/* $Id: SymbolDeclaration.hpp 4323 2009-01-27 13:48:12Z potyra $
 *
 * SymbolDeclaration: Base class for anything that declares a symbol.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __SYMBOL_DECLARATION_HPP_INCLUDED
#define __SYMBOL_DECLARATION_HPP_INCLUDED

#include "frontend/ast/AstNode.hpp"
#include <string>

namespace ast {

/* forward declaration */
class DeclarativeRegion;

//! Generic declaration of a symbol.
/** This abstract class represents a generic declaration of a symbol, 
 *  e.g. the declaration of a signal, variable, function or type.
 */
class SymbolDeclaration : public AstNode {
public:
	/** c'tor 
	 *  @param declName name of the declared symbol.
	 *  @param loc Location of the symbol declaration.
	 */
	SymbolDeclaration(
		std::string *declName,
		Location loc
		) : 	AstNode(loc),
			name(declName),
			region(NULL) {}

	//! return the intermediate code name of a symbol
	/** @return name to be used in the intermediate code.
	 */
	virtual std::string getICName(void) const;
	
	/** The name of the declared symbol */
	std::string *name;
	/** declarative region created by the symbol, if any */
	DeclarativeRegion *region;
	/** path name of the symbol */
	std::string pathName;

protected:
	/** Destructor */
	virtual ~SymbolDeclaration() {
		if (this->name != NULL) {
			delete this->name;
		}
	}
};


}; /* namespace ast */

#endif /* __SYMBOL_DECLARATION_HPP_INCLUDED */
