#############################################################
##                                                         ##
## Copyright (c) 2003-2011 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################

from esys.lsm.vis.core.Exception import raiseNotImplemented
from esys.lsm.vis                import core
from Modifier                    import Modifier
import string

class RgbColor(core.RgbColor, Modifier):
    """
    Extends L{core.RgbColor} by implementing the L{applyTo} method.
    """
    def applyTo(self, actor):
        actor.GetProperty().SetColor(self.getRgb())

class Colors:
    def __init__(self):
        raiseNotImplemented(
          "This class is not designed for instantiation."
        )

_nameRgbColorDict = dict()

for attribute in dir(core.Colors):
    attr = getattr(core.Colors, attribute)
    if (isinstance(attr, core.RgbColor)):
        setattr(Colors, attribute, RgbColor(attr[0], attr[1], attr[2]))
        _nameRgbColorDict[string.upper(attr.getName())] = getattr(Colors, attribute)

def findColor(colorName):
    """
    Performs a case-insensitive search for a color with name colorName.
    Returns None if no color matching colorName is found.
    """
    if (_nameRgbColorDict.has_key(string.upper(colorName))):
        return _nameRgbColorDict[string.upper(colorName)]
    return None
