#ifndef __EXEC_H__
#define __EXEC_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "hook.h"
#include "rstring.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

/**
 * This structure holds information about _all_ functions that can be
 * invoked from elmo by user (directly after pressing ':', or indirectly
 * when the function is mapped to a key).  Only these functions can be used
 * during elmo execution.
 */
typedef struct exec {
        char        *name;       /* function name */
        void       (*fun)(void); /* function pointer */
        hook_t      *hook;       /* list of functions executed _after_ this one */
        char        *desc;       /* short description */
} exec_t;

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void       exec_init (void);
extern void       exec_post_setup (void);
extern exec_t    *exec_lookup (const char *name);
extern exec_t    *exec_lookup_fun (void (*fun)(void));
extern void       exec_run_name (char *name);
extern void       exec_run (exec_t *exec);
extern void       exec_free_resources (void);
extern rstring_t *exec_get_functions (const char *prefix);

extern void       exec_new_macro (const char *name);
extern void       exec_macro_comment (char *str);
extern void       exec_macro_add_hook (const char *fun);
extern void       exec_macro_add_prog (char *prog);
extern void       exec_macro_commit (void);
extern void       exec_register_timeout_hook (int interval, const char *fun);
extern void       exec_update_last_user_action (void);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER exec.h
 *
 ****************************************************************************/
#endif
