#!/usr/bin/env perl
#
#  elmo - ELectronic Mail Operator
#
#  Copyright (C) 2003, 2004 rzyjontko
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; version 2.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
#
#  ------------------------------------------------------------

use strict;
use warnings;

my ($desc_file, $inc_file, %module, %vars, %colors);

$desc_file = $ARGV[0];
$inc_file  = $ARGV[1];


sub generate_color {
    my ($var, $fg, $bg) = @_;

    print INC "        $var", "_color = get_color (ask, ",
              "\"$var", "_fg\", \"$var", "_bg\", \"$fg\", \"$bg\");\n";
    print CONF ", \"$var", "_fg\", \"$var", "_bg\"";
}


sub generate_colors {
    my $key;
    
    foreach $key (keys %colors){
	generate_color ($key, $colors{$key}{"fg"}, $colors{$key}{"bg"})
    }
    print INC "\n";
}


sub generate_var {
    my ($var, $default) = @_;

    print CONF ", \"$var\"";
    
    if ($default =~ /^\-?[0-9]+$/){
	print INC "        $var = ask_get_field_int_default (ask, ",
	          "\"$var\", $default);\n";
    }
    else {
	print INC "        $var = ask_get_field (ask, \"$var\");\n";
	print INC "        if ($var == NULL){\n";
	print INC "                $var = $default;\n";
	print INC "        }\n";
    }
}


sub generate_vars {
    my $key;

    foreach $key (keys %vars){
	generate_var ($key, $vars{$key});
    }

    print INC "\n";
}


sub generate_module {
    my $fname = $module{"file"} . ".inc";
    my $cnt   = keys (%vars) + 2 * keys (%colors) + $module{"label"};
    
    open (IN, "$inc_file") or die "$inc_file: $!";
    open (INC, ">$fname") or die "$fname: $!";

    while (<IN>){
	if (/\@VARS\@/){
	    print CONF "confhold_register (\"win_", $module{"name"}, "\", $cnt";
	    generate_colors ();
	    generate_vars ();
	    if ($module{"label"}){
		print CONF ", \"label\"";
	    }
	    print CONF ");\n";
	}
	else {
	    s/@([a-z_]+)@/$module{$1}/g;
	    print INC;
	}
    }

    close (INC);
    close (IN);
}





open (DESC, $desc_file) or die "$desc_file: $!";
open (CONF, ">elmo.inc") or die "elmo.inc: $!";
while (<DESC>){

    if (/[ \t]*([a-z_]+)[ \t]*\{/){
	$module{"file"} = $1;
    }

    if (/[ \t]*\.?([a-z_]+)_color:[ \t]*\(([a-z]+),[ \t]+([a-z]+)\)/){
	$colors{$1} = {"fg" => $2, "bg" => $3};
    }
    elsif (/[ \t]*(\.)?label:[ \t]*([10])([ \t]*\"[^\"]+\")?[ \t]*([a-z_]+)?/){
	$module{"label_def"} = $2;
	if ($4){
	    $module{"label_name"}     = $4;
	    $module{"fun"}            = "interface_init_2";
	}
	else {
	    $module{"label_name"}     = "label";
	    $module{"fun"}            = "interface_init"
	}
	if ($3){
	    $module{"label_txt"}      = $3;
	    $module{"label_have_txt"} = 1;
	}
	else {
	    $module{"label_txt"}      = "no_label";
	    $module{"label_have_txt"} = 0;
	}

	if ($1){
	    $module{"label"} = 1;
	}
	else {
	    $module{"label"} = 0;
	}
    }
    elsif (/[ \t]*\.([a-z_]+):[ \t]*(.*)[ \t]*$/){
	$vars{$1}   = $2;
	$module{$1} = $2;
    }
    elsif (/[ \t]*([a-z_]+):[ \t]*(.*)[ \t]*$/){
	$module{$1} = $2;
    }
    
    if (/[ \t]*\}/){
	generate_module ();
	%module = ();
	%vars   = ();
	%colors = ();
    }
}
close (CONF);
close (DESC);
