/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.hpp"
#include <gtkmm.h>
#include "eiciel_container.hpp"
#include <gettext.h>
#include <gnome.h>

int main(int argc, char* argv[])
{
#ifdef ENABLE_NLS
    setlocale(LC_ALL, "");
    bindtextdomain("eiciel", DATADIR "/locale");
    // textdomain("eiciel");

    // Volem les traduccions en UTF-8 (independentment del
    // format usat per a traduir)
    bind_textdomain_codeset ("eiciel", "UTF-8");
#endif

    GnomeProgram *my_app;
    my_app = gnome_program_init(PACKAGE, VERSION,
            LIBGNOMEUI_MODULE, argc, argv, 
            GNOME_PARAM_HUMAN_READABLE_NAME, "Eiciel",
            GNOME_PARAM_APP_DATADIR, DATADIR,
            NULL);
    Gtk::Main kit(argc, argv);

    EicielContainer w;

    if (argc > 1)
    {
        w.obrirFitxer(argv[1]);
    }

    kit.run(w);

    return 0;
}

