/*
 * This testing program prints the ioclt numbers known by e2fsprogs
 *
 * Copyright (C) 2011 by Theodore Ts'o.
 *
 * %Begin-Header%
 * This file may be redistributed under the terms of the GNU Library
 * General Public License, version 2.
 * %End-Header%
 */

#include "config.h"
#include <stdio.h>
#include <string.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#if HAVE_ERRNO_H
#include <errno.h>
#endif

#include "ext2_fs.h"
#include "ext2fs.h"

#define PRINT_IOCTL(x)	printf("%-24s 0x%08lx\n", #x, x)

int main(int argc, char **argv)
{
	PRINT_IOCTL(EXT2_IOC_GETFLAGS);
	PRINT_IOCTL(EXT2_IOC_SETFLAGS);
	PRINT_IOCTL(EXT2_IOC_GETVERSION);
	PRINT_IOCTL(EXT2_IOC_SETVERSION);
	PRINT_IOCTL(EXT2_IOC_GETVERSION_NEW);
	PRINT_IOCTL(EXT2_IOC_SETVERSION_NEW);
	PRINT_IOCTL(EXT2_IOC_GROUP_EXTEND);
	PRINT_IOCTL(EXT2_IOC_GROUP_ADD);
	PRINT_IOCTL(EXT4_IOC_GROUP_ADD);
	PRINT_IOCTL(EXT4_IOC_RESIZE_FS);

	return 0;
}
