// This code conforms with the UFC specification version 2.0.0
// and was automatically generated by FFC version 0.9.10.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __FORMS_H
#define __FORMS_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class forms_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  forms_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    values[0] = 0.000000000000000;
    values[1] = 0.000000000000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.169533172561123, 0.084179378712684, -0.116642368703960, 0.000000000000000, -0.146820034222104, 0.072901480439975, -0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.321678327423669, -0.134687005940295, 0.097201973919967, 0.260579710864614, -0.129879261042630, 0.097687983789567, -0.063134534034513};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.078246079643595, -0.168358757425368, 0.349927106111882, 0.000000000000000, 0.067763092717894, -0.145802960879951, 0.303045763365662};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.165186168136480, 0.235702260395516, -0.272165526975909, -0.120267558860592, 0.146820034222104, -0.224536559755125, 0.176776695296637};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.039123039821798, -0.084179378712684, -0.349927106111882, 0.000000000000000, -0.033881546358947, -0.072901480439976, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.060858061945019, 0.000000000000000, 0.213844342623929, 0.060133779430296, 0.039528470752104, 0.112268279877563, -0.138895974875929};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.169533172561123, 0.084179378712684, 0.116642368703961, 0.000000000000000, 0.146820034222104, 0.072901480439975, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.491211499984792, 0.218866384652979, 0.213844342623928, -0.260579710864614, 0.016940773179474, -0.024786503349592, 0.037880720420708};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.078246079643596, -0.168358757425368, -0.349927106111882, 0.000000000000000, -0.067763092717894, -0.145802960879951, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.243432247780073, -0.404061017820885, -0.622092633087791, 0.120267558860591, 0.079056941504209, 0.078733598875174, -0.126269068069027};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.039123039821798, -0.084179378712684, 0.349927106111882, 0.000000000000000, 0.033881546358947, -0.072901480439975, 0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.099981101766815, -0.084179378712684, 0.563771448735811, -0.060133779430296, 0.073410017111052, -0.185169760317538, 0.164149788489735};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.382536389368687, 0.303045763365663, 0.311046316543896, 0.000000000000000, -0.090350790290525, -0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.169533172561123, 0.084179378712684, 0.116642368703961, 0.160356745147455, 0.067763092717894, 0.032076651393590, -0.075761440841416};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.765072778737375, 0.000000000000000, -0.155523158271948, 0.000000000000000, 0.180701580581050, 0.000000000000000, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.382536389368687, 0.067343502970148, -0.077761579135974, -0.320713490294909, 0.090350790290526, -0.064153302787179, 0.050507627227611};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.382536389368687, -0.303045763365664, 0.311046316543896, 0.000000000000000, -0.090350790290525, 0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.213003216807565, -0.218866384652979, 0.194403947839935, 0.160356745147455, -0.158113883008420, 0.177879612273541, -0.126269068069027};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {3.999999999999862, 0.000000000000000, 0.000000000000000, -0.368855556781647, -0.476190476190461, -1.649572197684589, 0.000000000000000, -0.319438282499960, -0.412393049421147, 0.571428571428550};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.614759261302740, 0.476190476190460, -0.549857399228195, 0.566946709513820, 0.159719141249981, -0.453632354363261, 0.357142857142845};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 3.999999999999863, 0.000000000000000, -0.677630927178916, 1.807956714911334, 0.000000000000000, 0.000000000000000, -0.586845597326945, -1.262690680690219, 0.000000000000000};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.054092553389421, 1.166423687039569, -0.336717514850724, 1.041547612244083, 0.684653196881436, -0.580837713117500, 0.218704441319919};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 3.999999999999863, 0.130410132739321, -0.841793787126813, 0.933138949631658, 0.000000000000000, 0.112938487863153, -0.729014804399731, -2.020305089104349};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.347760353971517, 0.336717514850724, 1.360827634879500, -0.200445931434309, 0.621161683247337, 0.597792139607780, -0.883883476483157};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.952380952380919, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.824786098842294, 0.000000000000000};
      
      static const double coefficients1[10] = \
      {3.999999999999863, 0.000000000000000, 0.000000000000000, -1.598374079387130, 0.476190476190459, -0.549857399228197, 0.000000000000000, -0.638876564999920, 0.412393049421148, -0.142857142857138};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.355261854357833, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.173691194653889, 0.000000000000000, 0.000000000000000};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 3.999999999999860, 0.000000000000000, 0.677630927178917, -0.524890659167804, 0.000000000000000, -2.083095224488167, 0.586845597326944, -0.101015254455218, 0.000000000000000};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.683587574253624, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.458029608799459, 0.000000000000000};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 3.999999999999861, 0.825930840682367, 0.841793787126812, -1.788516320127341, 0.000000000000000, -1.129384878631527, 0.729014804399730, -0.252538136138043};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.000000000000000, 0.000000000000000};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.169533172561123, 0.084179378712684, -0.116642368703960, 0.000000000000000, -0.146820034222104, 0.072901480439975, -0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.321678327423669, -0.134687005940295, 0.097201973919967, 0.260579710864614, -0.129879261042630, 0.097687983789567, -0.063134534034513};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.078246079643595, -0.168358757425368, 0.349927106111882, 0.000000000000000, 0.067763092717894, -0.145802960879951, 0.303045763365662};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.165186168136480, 0.235702260395516, -0.272165526975909, -0.120267558860592, 0.146820034222104, -0.224536559755125, 0.176776695296637};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.039123039821798, -0.084179378712684, -0.349927106111882, 0.000000000000000, -0.033881546358947, -0.072901480439976, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.060858061945019, 0.000000000000000, 0.213844342623929, 0.060133779430296, 0.039528470752104, 0.112268279877563, -0.138895974875929};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.169533172561123, 0.084179378712684, 0.116642368703961, 0.000000000000000, 0.146820034222104, 0.072901480439975, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.491211499984792, 0.218866384652979, 0.213844342623928, -0.260579710864614, 0.016940773179474, -0.024786503349592, 0.037880720420708};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.078246079643596, -0.168358757425368, -0.349927106111882, 0.000000000000000, -0.067763092717894, -0.145802960879951, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.243432247780073, -0.404061017820885, -0.622092633087791, 0.120267558860591, 0.079056941504209, 0.078733598875174, -0.126269068069027};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.039123039821798, -0.084179378712684, 0.349927106111882, 0.000000000000000, 0.033881546358947, -0.072901480439975, 0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.099981101766815, -0.084179378712684, 0.563771448735811, -0.060133779430296, 0.073410017111052, -0.185169760317538, 0.164149788489735};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.382536389368687, 0.303045763365663, 0.311046316543896, 0.000000000000000, -0.090350790290525, -0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.169533172561123, 0.084179378712684, 0.116642368703961, 0.160356745147455, 0.067763092717894, 0.032076651393590, -0.075761440841416};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.765072778737375, 0.000000000000000, -0.155523158271948, 0.000000000000000, 0.180701580581050, 0.000000000000000, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.382536389368687, 0.067343502970148, -0.077761579135974, -0.320713490294909, 0.090350790290526, -0.064153302787179, 0.050507627227611};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.382536389368687, -0.303045763365664, 0.311046316543896, 0.000000000000000, -0.090350790290525, 0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.213003216807565, -0.218866384652979, 0.194403947839935, 0.160356745147455, -0.158113883008420, 0.177879612273541, -0.126269068069027};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {3.999999999999862, 0.000000000000000, 0.000000000000000, -0.368855556781647, -0.476190476190461, -1.649572197684589, 0.000000000000000, -0.319438282499960, -0.412393049421147, 0.571428571428550};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.614759261302740, 0.476190476190460, -0.549857399228195, 0.566946709513820, 0.159719141249981, -0.453632354363261, 0.357142857142845};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 3.999999999999863, 0.000000000000000, -0.677630927178916, 1.807956714911334, 0.000000000000000, 0.000000000000000, -0.586845597326945, -1.262690680690219, 0.000000000000000};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.054092553389421, 1.166423687039569, -0.336717514850724, 1.041547612244083, 0.684653196881436, -0.580837713117500, 0.218704441319919};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 3.999999999999863, 0.130410132739321, -0.841793787126813, 0.933138949631658, 0.000000000000000, 0.112938487863153, -0.729014804399731, -2.020305089104349};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.347760353971517, 0.336717514850724, 1.360827634879500, -0.200445931434309, 0.621161683247337, 0.597792139607780, -0.883883476483157};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.952380952380919, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.824786098842294, 0.000000000000000};
      
      static const double coefficients1[10] = \
      {3.999999999999863, 0.000000000000000, 0.000000000000000, -1.598374079387130, 0.476190476190459, -0.549857399228197, 0.000000000000000, -0.638876564999920, 0.412393049421148, -0.142857142857138};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.355261854357833, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.173691194653889, 0.000000000000000, 0.000000000000000};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 3.999999999999860, 0.000000000000000, 0.677630927178917, -0.524890659167804, 0.000000000000000, -2.083095224488167, 0.586845597326944, -0.101015254455218, 0.000000000000000};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.000000000000000;
      double tmp6 = 0.000000000000000;
      double tmp7 = 0.000000000000000;
      double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
      double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.683587574253624, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.458029608799459, 0.000000000000000};
      
      static const double coefficients1[10] = \
      {0.000000000000000, 0.000000000000000, 3.999999999999861, 0.825930840682367, 0.841793787126812, -1.788516320127341, 0.000000000000000, -1.129384878631527, 0.729014804399730, -0.252538136138043};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.898979485566357, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.999999999999999, 0.000000000000000, 7.071067811865480, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.291502622129182, 0.000000000000000, -2.993325909419149, 13.662601021279462, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998820, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.464101615137755, 0.000000000000000, 7.838367176906175, 0.000000000000000, 0.000000000000000, 8.400000000000002, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[10][10] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.449489742783178, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.581988897471611, 4.743416490252569, -0.912870929175276, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.999999999999999, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {-2.309401076758505, 0.000000000000000, 8.164965809277263, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.645751311064592, 5.184592558726287, -1.496662954709574, 6.831300510639732, -1.058300524425836, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {2.236067977499790, 2.190890230020665, 2.529822128134708, 8.082903768654759, 6.260990336999411, -1.807392228230127, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.732050807568875, -5.091168824543142, 3.919183588453088, 0.000000000000000, 9.699484522385712, 4.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.000000000000002, 0.000000000000000, -2.828427124746187, 0.000000000000000, 0.000000000000000, 12.124355652982144, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[2*num_derivatives];
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    double result;
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];switch (i)
    {
    case 0:
      {
        y[0] = 0.750000000000000*x[1][0] + 0.250000000000000*x[2][0];
      y[1] = 0.750000000000000*x[1][1] + 0.250000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 1:
      {
        y[0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[2][0];
      y[1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 2:
      {
        y[0] = 0.250000000000000*x[1][0] + 0.750000000000000*x[2][0];
      y[1] = 0.250000000000000*x[1][1] + 0.750000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 3:
      {
        y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[2][0];
      y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 4:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[2][0];
      y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 5:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[2][0];
      y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 6:
      {
        y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[1][0];
      y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[1][1];
      f.evaluate(vals, y, c);
      result = (J_00*vals[0] + J_10*vals[1]);
      return result;
        break;
      }
    case 7:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[1][0];
      y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[1][1];
      f.evaluate(vals, y, c);
      result = (J_00*vals[0] + J_10*vals[1]);
      return result;
        break;
      }
    case 8:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[1][0];
      y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[1][1];
      f.evaluate(vals, y, c);
      result = (J_00*vals[0] + J_10*vals[1]);
      return result;
        break;
      }
    case 9:
      {
        result = 0.0;
      double X_9[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_9[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_9[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
      double copy_9[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_9[r][0] - X_9[r][1];
        const double w1 = X_9[r][0];
        const double w2 = X_9[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_9[0] = J_00*vals[0] + J_10*vals[1];
        copy_9[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_9[D_9[r][s]]*W_9[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 10:
      {
        result = 0.0;
      double X_10[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_10[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_10[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
      double copy_10[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_10[r][0] - X_10[r][1];
        const double w1 = X_10[r][0];
        const double w2 = X_10[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_10[0] = J_00*vals[0] + J_10*vals[1];
        copy_10[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_10[D_10[r][s]]*W_10[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 11:
      {
        result = 0.0;
      double X_11[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_11[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_11[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
      double copy_11[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_11[r][0] - X_11[r][1];
        const double w1 = X_11[r][0];
        const double w2 = X_11[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_11[0] = J_00*vals[0] + J_10*vals[1];
        copy_11[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_11[D_11[r][s]]*W_11[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 12:
      {
        result = 0.0;
      double X_12[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_12[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_12[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
      double copy_12[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_12[r][0] - X_12[r][1];
        const double w1 = X_12[r][0];
        const double w2 = X_12[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_12[0] = J_00*vals[0] + J_10*vals[1];
        copy_12[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_12[D_12[r][s]]*W_12[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 13:
      {
        result = 0.0;
      double X_13[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_13[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_13[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
      double copy_13[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_13[r][0] - X_13[r][1];
        const double w1 = X_13[r][0];
        const double w2 = X_13[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_13[0] = J_00*vals[0] + J_10*vals[1];
        copy_13[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_13[D_13[r][s]]*W_13[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 14:
      {
        result = 0.0;
      double X_14[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_14[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_14[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
      double copy_14[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_14[r][0] - X_14[r][1];
        const double w1 = X_14[r][0];
        const double w2 = X_14[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_14[0] = J_00*vals[0] + J_10*vals[1];
        copy_14[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_14[D_14[r][s]]*W_14[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    double result;
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];y[0] = 0.750000000000000*x[1][0] + 0.250000000000000*x[2][0];
    y[1] = 0.750000000000000*x[1][1] + 0.250000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
    values[0] = result;
    y[0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[2][0];
    y[1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
    values[1] = result;
    y[0] = 0.250000000000000*x[1][0] + 0.750000000000000*x[2][0];
    y[1] = 0.250000000000000*x[1][1] + 0.750000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
    values[2] = result;
    y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[2][0];
    y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (J_01*vals[0] + J_11*vals[1]);
    values[3] = result;
    y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[2][0];
    y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (J_01*vals[0] + J_11*vals[1]);
    values[4] = result;
    y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[2][0];
    y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (J_01*vals[0] + J_11*vals[1]);
    values[5] = result;
    y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[1][0];
    y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[1][1];
    f.evaluate(vals, y, c);
    result = (J_00*vals[0] + J_10*vals[1]);
    values[6] = result;
    y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[1][0];
    y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[1][1];
    f.evaluate(vals, y, c);
    result = (J_00*vals[0] + J_10*vals[1]);
    values[7] = result;
    y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[1][0];
    y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[1][1];
    f.evaluate(vals, y, c);
    result = (J_00*vals[0] + J_10*vals[1]);
    values[8] = result;
    result = 0.0;
    double X_9[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_9[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_9[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
    double copy_9[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_9[r][0] - X_9[r][1];
      const double w1 = X_9[r][0];
      const double w2 = X_9[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_9[0] = J_00*vals[0] + J_10*vals[1];
      copy_9[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_9[D_9[r][s]]*W_9[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[9] = result;
    result = 0.0;
    double X_10[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_10[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_10[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
    double copy_10[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_10[r][0] - X_10[r][1];
      const double w1 = X_10[r][0];
      const double w2 = X_10[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_10[0] = J_00*vals[0] + J_10*vals[1];
      copy_10[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_10[D_10[r][s]]*W_10[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[10] = result;
    result = 0.0;
    double X_11[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_11[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_11[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
    double copy_11[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_11[r][0] - X_11[r][1];
      const double w1 = X_11[r][0];
      const double w2 = X_11[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_11[0] = J_00*vals[0] + J_10*vals[1];
      copy_11[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_11[D_11[r][s]]*W_11[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[11] = result;
    result = 0.0;
    double X_12[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_12[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_12[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
    double copy_12[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_12[r][0] - X_12[r][1];
      const double w1 = X_12[r][0];
      const double w2 = X_12[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_12[0] = J_00*vals[0] + J_10*vals[1];
      copy_12[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_12[D_12[r][s]]*W_12[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[12] = result;
    result = 0.0;
    double X_13[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_13[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_13[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
    double copy_13[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_13[r][0] - X_13[r][1];
      const double w1 = X_13[r][0];
      const double w2 = X_13[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_13[0] = J_00*vals[0] + J_10*vals[1];
      copy_13[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_13[D_13[r][s]]*W_13[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[13] = result;
    result = 0.0;
    double X_14[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_14[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_14[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
    double copy_14[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_14[r][0] - X_14[r][1];
      const double w1 = X_14[r][0];
      const double w2 = X_14[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_14[0] = J_00*vals[0] + J_10*vals[1];
      copy_14[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_14[D_14[r][s]]*W_14[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[14] = result;
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    // Evaluate function and change variables
    vertex_values[0] = dof_values[3]*K_10*3.0 + dof_values[4]*(K_10*(-3.0)) + dof_values[5]*K_10 + dof_values[6]*K_00*3.0 + dof_values[7]*(K_00*(-3.0)) + dof_values[8]*K_00 + dof_values[11]*(K_10*(1.75415237891e-14));
    vertex_values[2] = dof_values[0]*K_10*3.0 + dof_values[1]*(K_10*(-3.0)) + dof_values[2]*K_10 + dof_values[6]*(K_00 + K_10) + dof_values[7]*(K_00*(-3.0) + K_10*(-3.0)) + dof_values[8]*(K_00*3.0 + K_10*3.0) + dof_values[9]*(K_10*(-1.53210777398e-14)) + dof_values[10]*(K_10*(-1.36002320517e-14)) + dof_values[11]*(K_10*(4.32986979604e-14)) + dof_values[12]*(K_10*(1.81521464526e-14)) + dof_values[14]*(K_10*(1.98729921408e-14));
    vertex_values[4] = dof_values[0]*(K_00*(-1.0)) + dof_values[1]*K_00*3.0 + dof_values[2]*(K_00*(-3.0)) + dof_values[3]*(K_00 + K_10) + dof_values[4]*(K_00*(-3.0) + K_10*(-3.0)) + dof_values[5]*(K_00*3.0 + K_10*3.0) + dof_values[9]*(K_00*(-1.15463194561e-14)) + dof_values[10]*(K_00*(-1.49876115949e-14)) + dof_values[11]*(K_00*(2.84217094304e-14)) + dof_values[12]*(K_00*(1.10758165981e-14)) + dof_values[14]*(K_00*(1.53617133794e-14));
    vertex_values[1] = dof_values[3]*K_11*3.0 + dof_values[4]*(K_11*(-3.0)) + dof_values[5]*K_11 + dof_values[6]*K_01*3.0 + dof_values[7]*(K_01*(-3.0)) + dof_values[8]*K_01 + dof_values[11]*(K_11*(1.75415237891e-14));
    vertex_values[3] = dof_values[0]*K_11*3.0 + dof_values[1]*(K_11*(-3.0)) + dof_values[2]*K_11 + dof_values[6]*(K_01 + K_11) + dof_values[7]*(K_01*(-3.0) + K_11*(-3.0)) + dof_values[8]*(K_01*3.0 + K_11*3.0) + dof_values[9]*(K_11*(-1.53210777398e-14)) + dof_values[10]*(K_11*(-1.36002320517e-14)) + dof_values[11]*(K_11*(4.32986979604e-14)) + dof_values[12]*(K_11*(1.81521464526e-14)) + dof_values[14]*(K_11*(1.98729921408e-14));
    vertex_values[5] = dof_values[0]*(K_01*(-1.0)) + dof_values[1]*K_01*3.0 + dof_values[2]*(K_01*(-3.0)) + dof_values[3]*(K_01 + K_11) + dof_values[4]*(K_01*(-3.0) + K_11*(-3.0)) + dof_values[5]*(K_01*3.0 + K_11*3.0) + dof_values[9]*(K_01*(-1.15463194561e-14)) + dof_values[10]*(K_01*(-1.49876115949e-14)) + dof_values[11]*(K_01*(2.84217094304e-14)) + dof_values[12]*(K_01*(1.10758165981e-14)) + dof_values[14]*(K_01*(1.53617133794e-14));
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new forms_finite_element_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class forms_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  forms_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~forms_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 3.000000000000000*m.num_entities[1] + 6.000000000000000*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + 3*c.entity_indices[1][0];
    dofs[1] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[2] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[3] = offset + 3*c.entity_indices[1][1];
    dofs[4] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][2];
    dofs[7] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[9] = offset + 6*c.entity_indices[2][0];
    dofs[10] = offset + 6*c.entity_indices[2][0] + 1;
    dofs[11] = offset + 6*c.entity_indices[2][0] + 2;
    dofs[12] = offset + 6*c.entity_indices[2][0] + 3;
    dofs[13] = offset + 6*c.entity_indices[2][0] + 4;
    dofs[14] = offset + 6*c.entity_indices[2][0] + 5;
    offset += 6*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 3;
      dofs[1] = 4;
      dofs[2] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 6;
      dofs[1] = 7;
      dofs[2] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 2;
          break;
        }
      case 1:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
      dofs[1] = 10;
      dofs[2] = 11;
      dofs[3] = 12;
      dofs[4] = 13;
      dofs[5] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    throw std::runtime_error("tabulate_coordinates is not defined for this element");
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new forms_dofmap_0();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class forms_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  forms_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius, assuming triangle is embedded in 2D.
    
    
    // Array of quadrature weights.
    static const double W6[6] = {0.054975871827661, 0.054975871827661, 0.054975871827661, 0.111690794839005, 0.111690794839005, 0.111690794839005};
    // Quadrature points on the UFC reference element: (0.816847572980459, 0.091576213509771), (0.091576213509771, 0.816847572980459), (0.091576213509771, 0.091576213509771), (0.108103018168070, 0.445948490915965), (0.445948490915965, 0.108103018168070), (0.445948490915965, 0.445948490915965)
    
    // Value of basis functions at quadrature points.
    static const double FE0_C0_D01[6][15] = \
    {{-2.842784779491817, 2.601331694081312, -0.632753871377702, 1.859826441657717, -0.635415018413117, 1.615712209211801, 2.329426877301644, -3.323029803277361, -5.804965528171156, 16.756624755930602, 28.250337550111222, -10.312595005821173, -5.560452050450599, 17.117522665955452, -9.829583378340640},
    {-1.790747689754887, 5.757442963292069, -10.101087679010000, 4.752928438434249, -11.681804460650794, 7.138906930330638, -0.021689692393990, 0.104074179473839, -0.265803924839870, -16.831893360509639, 0.917612187043470, -25.933482529750158, 16.756624755930815, 3.451159984421552, 29.621807486792605},
    {-0.730727158911741, 0.369744598943470, -1.150788975139931, 1.381597472408787, -1.671485225937567, 0.499918661642877, -11.562274986092968, 6.687289431435792, -1.923582899489700, 14.953319808833061, -30.970567403202004, -19.478002335487812, 3.681878498774116, 6.764042712690830, 6.508703134970290},
    {0.565452740291993, -0.671420571424330, 2.089018679385738, -1.604110042606186, 2.748735176052719, -1.050361377071543, 1.906408102993407, -0.306199418639674, 0.748063316684320, -1.033001415067149, 15.171423306557827, 29.929887517939214, -5.875532974362149, -4.863177623764873, -10.386573023141596},
    {0.793731867204492, 0.013416809313156, 0.034506537173266, -0.976342443596823, 0.351804343471505, 0.148104039219064, -2.565518912561606, -1.543441746175004, -2.011770247026967, 19.692601753220764, 9.240557614759402, -13.077289185765682, -1.033001415067174, -7.828610469664104, -1.826105763923251},
    {-0.957138495883970, -2.146088461113858, -0.004270374071459, 2.749104191871733, -1.437842930861672, -1.787695321916306, 3.349063469336983, -2.095846692972839, 1.095055224673914, -15.431245965290280, 2.321214307661231, 18.036697707450550, 10.136888762292616, 18.622653785227424, 17.919656959877042}};
    
    static const double FE0_C1_D10[6][15] = \
    {{10.101087679010019, -5.757442963292116, 1.790747689754908, -0.021689692394002, 0.104074179473859, -0.265803924839903, 4.752928438434257, -11.681804460650804, 7.138906930330664, 16.756624755930694, 27.378817781785138, -11.822111524362809, -16.831893360509522, -22.000248585841828, 13.761416729677020},
    {0.632753871377706, -2.601331694081320, 2.842784779491822, 2.329426877301646, -3.323029803277367, -5.804965528171155, 1.859826441657721, -0.635415018413120, 1.615712209211808, -5.560452050450602, 0.046092418717468, 19.739001167743702, 16.756624755930645, 5.194199521073934, 29.621807486792378},
    {1.150788975139931, -0.369744598943467, 0.730727158911735, -11.562274986092957, 6.687289431435788, -1.923582899489695, 1.381597472408786, -1.671485225937569, 0.499918661642878, 3.681878498774109, 9.018723616921099, 2.603481253988086, 14.953319808833033, -32.353728539106051, -17.082296973047285},
    {-0.034506537173261, -0.013416809313163, -0.793731867204488, -2.565518912561603, -1.543441746175007, -2.011770247026963, -0.976342443596818, 0.351804343471497, 0.148104039219070, -1.033001415067168, -5.495759216386759, -5.866722661100311, 19.692601753220767, -6.704985840128922, 14.541202232398236},
    {-2.089018679385743, 0.671420571424338, -0.565452740291995, 1.906408102993406, -0.306199418639673, 0.748063316684324, -1.604110042606187, 2.748735176052722, -1.050361377071547, -5.875532974362127, -11.426624908185174, 0.981651146274360, -1.033001415067169, 33.505754576225037, -1.826105763923247},
    {0.004270374071451, 2.146088461113870, 0.957138495883959, 3.349063469336984, -2.095846692972848, 1.095055224673921, 2.749104191871726, -1.437842930861662, -1.787695321916318, 10.136888762292612, 24.830205046969855, 7.167862783950818, -15.431245965290286, 16.780845568863356, -7.008118295662763}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 225; r++)
    {
      A[r] = 0.000000000000000;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 22.
    double G[2];
    G[0] = det*(K_00*K_00*K_11*K_11 + K_01*K_10*(K_01*K_10-2.000000000000000*K_00*K_11));
    G[1] = det*(K_01*K_10*(2.000000000000000*K_00*K_11 - K_01*K_10) - K_00*K_00*K_11*K_11);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 16212
    for (unsigned int ip = 0; ip < 6; ip++)
    {
      
      // Number of operations to compute ip constants: 2
      double I[2];
      // Number of operations: 1
      I[0] = G[0]*W6[ip];
      
      // Number of operations: 1
      I[1] = G[1]*W6[ip];
      
      
      // Number of operations for primary indices: 2700
      for (unsigned int j = 0; j < 15; j++)
      {
        for (unsigned int k = 0; k < 15; k++)
        {
          // Number of operations to compute entry: 12
          A[j*15 + k] += (FE0_C0_D01[ip][j]*FE0_C0_D01[ip][k]*I[0] + FE0_C0_D01[ip][j]*FE0_C1_D10[ip][k]*I[1] + FE0_C0_D01[ip][k]*FE0_C1_D10[ip][j]*I[1] + FE0_C1_D10[ip][j]*FE0_C1_D10[ip][k]*I[0]);
        }// end loop over 'k'
      }// end loop over 'j'
    }// end loop over 'ip'
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0).");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class forms_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  forms_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 777
    // Total number of operations (multiply-add pairs):                  796
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11);
    
    // Compute element tensor
    A[0] = 0.021626984126984*G0_0_0 - 0.011160714285714*G0_0_1 - 0.011160714285714*G0_1_0 + 0.057341269841270*G0_1_1;
    A[1] = -0.029861111111111*G0_0_0 + 0.005952380952381*G0_0_1 + 0.009920634920635*G0_1_0 - 0.048710317460318*G0_1_1;
    A[2] = 0.017658730158730*G0_0_0 - 0.004712301587302*G0_0_1 - 0.004712301587302*G0_1_0 + 0.017658730158730*G0_1_1;
    A[3] = -0.015426587301587*G0_0_0 - 0.024479166666667*G0_0_1 + 0.009052579365079*G0_1_0 + 0.018601190476191*G0_1_1;
    A[4] = 0.017460317460317*G0_0_0 + 0.021676587301587*G0_0_1 - 0.005704365079365*G0_1_0 - 0.011904761904762*G0_1_1;
    A[5] = -0.023859126984127*G0_0_0 - 0.032663690476190*G0_0_1 + 0.006820436507937*G0_1_0 + 0.011160714285714*G0_1_1;
    A[6] = -0.013144841269841*G0_0_0 - 0.008804563492064*G0_0_1 + 0.030679563492064*G0_1_0 + 0.023859126984127*G0_1_1;
    A[7] = 0.027777777777778*G0_0_0 + 0.014136904761905*G0_0_1 - 0.072767857142858*G0_1_0 - 0.061111111111112*G0_1_1;
    A[8] = -0.020585317460318*G0_0_0 - 0.007068452380952*G0_0_1 + 0.058209325396826*G0_1_0 + 0.051140873015873*G0_1_1;
    A[9] = 0.043492679001550*G0_0_0 - 0.023149329145988*G0_0_1 - 0.062433039211904*G0_1_0 + 0.035074741130284*G0_1_1;
    A[10] = 0.065295566158350*G0_0_0 - 0.051549131177644*G0_0_1 - 0.127154523571520*G0_1_0 + 0.065295566158349*G0_1_1;
    A[11] = -0.016865079365081*G0_0_0 - 0.007440476190476*G0_0_1 + 0.071924603174600*G0_1_0 - 0.010912698412699*G0_1_1;
    A[12] = 0.035074741130284*G0_0_0 + 0.128373552536838*G0_0_1 - 0.011925411984297*G0_1_0 - 0.124866078423811*G0_1_1;
    A[13] = -0.100520805796406*G0_0_0 - 0.063147685692613*G0_0_1 + 0.070880055369260*G0_1_0 - 0.085056066443111*G0_1_1;
    A[14] = 0.062003968253967*G0_0_0 + 0.095982142857138*G0_0_1 - 0.021081349206349*G0_1_0 + 0.053075396825397*G0_1_1;
    A[15] = -0.029861111111111*G0_0_0 + 0.009920634920635*G0_0_1 + 0.005952380952381*G0_1_0 - 0.048710317460318*G0_1_1;
    A[16] = 0.068650793650794*G0_0_0 - 0.012896825396825*G0_0_1 - 0.012896825396825*G0_1_0 + 0.068650793650794*G0_1_1;
    A[17] = -0.048710317460317*G0_0_0 + 0.005952380952381*G0_0_1 + 0.009920634920635*G0_1_0 - 0.029861111111111*G0_1_1;
    A[18] = 0.017460317460317*G0_0_0 + 0.023164682539682*G0_0_1 - 0.004216269841270*G0_1_0 - 0.010416666666667*G0_1_1;
    A[19] = -0.043849206349206*G0_0_0 - 0.053273809523810*G0_0_1 + 0.009424603174603*G0_1_0 + 0.017857142857143*G0_1_1;
    A[20] = 0.061111111111111*G0_0_0 + 0.075248015873016*G0_0_1 - 0.011656746031746*G0_1_0 - 0.025297619047619*G0_1_1;
    A[21] = 0.010416666666667*G0_0_0 + 0.004216269841270*G0_0_1 - 0.023164682539683*G0_1_0 - 0.017460317460318*G0_1_1;
    A[22] = -0.017857142857143*G0_0_0 - 0.009424603174603*G0_0_1 + 0.053273809523810*G0_1_0 + 0.043849206349207*G0_1_1;
    A[23] = 0.025297619047619*G0_0_0 + 0.011656746031746*G0_0_1 - 0.075248015873017*G0_1_0 - 0.061111111111112*G0_1_1;
    A[24] = -0.078567420131834*G0_0_0 - 0.009820927516480*G0_0_1 + 0.136089995585501*G0_1_0 + 0.070149482260569*G0_1_1;
    A[25] = -0.053267435550233*G0_0_0 - 0.008591521862941*G0_0_1 + 0.183858567866929*G0_1_0 + 0.084196914256820*G0_1_1;
    A[26] = -0.004960317460314*G0_0_0 + 0.019841269841269*G0_0_1 - 0.162698412698407*G0_1_0 - 0.102182539682537*G0_1_1;
    A[27] = -0.070149482260569*G0_0_0 - 0.136089995585501*G0_0_1 + 0.009820927516480*G0_1_0 + 0.078567420131834*G0_1_1;
    A[28] = 0.046394218059879*G0_0_0 + 0.048971674618760*G0_0_1 - 0.012887282794410*G0_1_0 + 0.030929478706585*G0_1_1;
    A[29] = -0.124007936507934*G0_0_0 - 0.240575396825388*G0_0_1 + 0.017361111111111*G0_1_0 + 0.043650793650793*G0_1_1;
    A[30] = 0.017658730158730*G0_0_0 - 0.004712301587302*G0_0_1 - 0.004712301587302*G0_1_0 + 0.017658730158730*G0_1_1;
    A[31] = -0.048710317460317*G0_0_0 + 0.009920634920635*G0_0_1 + 0.005952380952381*G0_1_0 - 0.029861111111111*G0_1_1;
    A[32] = 0.057341269841270*G0_0_0 - 0.011160714285714*G0_0_1 - 0.011160714285714*G0_1_0 + 0.021626984126984*G0_1_1;
    A[33] = -0.023859126984127*G0_0_0 - 0.030679563492064*G0_0_1 + 0.008804563492064*G0_1_0 + 0.013144841269841*G0_1_1;
    A[34] = 0.061111111111111*G0_0_0 + 0.072767857142858*G0_0_1 - 0.014136904761905*G0_1_0 - 0.027777777777778*G0_1_1;
    A[35] = -0.051140873015873*G0_0_0 - 0.058209325396826*G0_0_1 + 0.007068452380952*G0_1_0 + 0.020585317460318*G0_1_1;
    A[36] = -0.018601190476191*G0_0_0 - 0.009052579365079*G0_0_1 + 0.024479166666667*G0_1_0 + 0.015426587301587*G0_1_1;
    A[37] = 0.011904761904762*G0_0_0 + 0.005704365079365*G0_0_1 - 0.021676587301587*G0_1_0 - 0.017460317460318*G0_1_1;
    A[38] = -0.011160714285714*G0_0_0 - 0.006820436507937*G0_0_1 + 0.032663690476191*G0_1_0 + 0.023859126984127*G0_1_1;
    A[39] = 0.124866078423811*G0_0_0 + 0.011925411984297*G0_0_1 - 0.128373552536838*G0_1_0 - 0.035074741130285*G0_1_1;
    A[40] = -0.003436608745177*G0_0_0 - 0.017183043725881*G0_0_1 - 0.051549131177643*G0_1_0 - 0.003436608745176*G0_1_1;
    A[41] = 0.100198412698408*G0_0_0 - 0.071924603174601*G0_0_1 + 0.102678571428568*G0_1_0 + 0.118055555555554*G0_1_1;
    A[42] = -0.035074741130285*G0_0_0 + 0.062433039211904*G0_0_1 + 0.023149329145988*G0_1_0 - 0.043492679001550*G0_1_1;
    A[43] = -0.023197109029939*G0_0_0 + 0.001288728279441*G0_0_1 + 0.032218206986027*G0_1_0 - 0.018042195912174*G0_1_1;
    A[44] = -0.062003968253968*G0_0_0 + 0.146081349206343*G0_0_1 + 0.040922619047619*G0_1_0 - 0.064980158730158*G0_1_1;
    A[45] = -0.015426587301587*G0_0_0 + 0.009052579365079*G0_0_1 - 0.024479166666667*G0_1_0 + 0.018601190476191*G0_1_1;
    A[46] = 0.017460317460317*G0_0_0 - 0.004216269841270*G0_0_1 + 0.023164682539682*G0_1_0 - 0.010416666666667*G0_1_1;
    A[47] = -0.023859126984127*G0_0_0 + 0.008804563492064*G0_0_1 - 0.030679563492064*G0_1_0 + 0.013144841269841*G0_1_1;
    A[48] = 0.021626984126984*G0_0_0 + 0.032787698412699*G0_0_1 + 0.032787698412699*G0_1_0 + 0.101289682539683*G0_1_1;
    A[49] = -0.029861111111111*G0_0_0 - 0.035813492063492*G0_0_1 - 0.039781746031746*G0_1_0 - 0.094444444444445*G0_1_1;
    A[50] = 0.017658730158730*G0_0_0 + 0.022371031746032*G0_0_1 + 0.022371031746032*G0_1_0 + 0.044742063492063*G0_1_1;
    A[51] = 0.020585317460318*G0_0_0 + 0.013516865079365*G0_0_1 + 0.078794642857143*G0_1_0 + 0.020585317460318*G0_1_1;
    A[52] = -0.027777777777778*G0_0_0 - 0.013640873015873*G0_0_1 - 0.100545634920636*G0_1_0 - 0.025297619047619*G0_1_1;
    A[53] = 0.013144841269841*G0_0_0 + 0.004340277777778*G0_0_1 + 0.043824404761905*G0_1_0 + 0.011160714285714*G0_1_1;
    A[54] = -0.078567420131834*G0_0_0 + 0.026656803259016*G0_0_1 - 0.152925871328036*G0_1_0 + 0.042089689356341*G0_1_1;
    A[55] = -0.035225239638056*G0_0_0 + 0.079471577232202*G0_0_1 + 0.021049228564203*G0_1_0 + 0.115985545149699*G0_1_1;
    A[56] = -0.045138888888887*G0_0_0 + 0.043402777777777*G0_0_1 + 0.005704365079364*G0_1_0 + 0.052083333333332*G0_1_1;
    A[57] = 0.035074741130285*G0_0_0 - 0.093298811406554*G0_0_1 + 0.047000153114581*G0_1_0 - 0.206239477846067*G0_1_1;
    A[58] = 0.100520805796406*G0_0_0 + 0.037373120103792*G0_0_1 + 0.171400861165666*G0_1_0 + 0.193309241916163*G0_1_1;
    A[59] = 0.062003968253967*G0_0_0 - 0.033978174603172*G0_0_1 + 0.083085317460317*G0_1_0 + 0.040178571428573*G0_1_1;
    A[60] = 0.017460317460317*G0_0_0 - 0.005704365079365*G0_0_1 + 0.021676587301587*G0_1_0 - 0.011904761904762*G0_1_1;
    A[61] = -0.043849206349206*G0_0_0 + 0.009424603174603*G0_0_1 - 0.053273809523810*G0_1_0 + 0.017857142857143*G0_1_1;
    A[62] = 0.061111111111111*G0_0_0 - 0.014136904761905*G0_0_1 + 0.072767857142858*G0_1_0 - 0.027777777777778*G0_1_1;
    A[63] = -0.029861111111111*G0_0_0 - 0.039781746031746*G0_0_1 - 0.035813492063492*G0_1_0 - 0.094444444444445*G0_1_1;
    A[64] = 0.068650793650794*G0_0_0 + 0.081547619047620*G0_0_1 + 0.081547619047620*G0_1_0 + 0.163095238095239*G0_1_1;
    A[65] = -0.048710317460318*G0_0_0 - 0.054662698412699*G0_0_1 - 0.058630952380953*G0_1_0 - 0.094444444444445*G0_1_1;
    A[66] = -0.025297619047619*G0_0_0 - 0.013640873015873*G0_0_1 - 0.100545634920636*G0_1_0 - 0.027777777777778*G0_1_1;
    A[67] = 0.017857142857143*G0_0_0 + 0.008432539682540*G0_0_1 + 0.071130952380952*G0_1_0 + 0.017857142857143*G0_1_1;
    A[68] = -0.010416666666667*G0_0_0 - 0.006200396825397*G0_0_1 - 0.033581349206349*G0_1_0 - 0.011904761904762*G0_1_1;
    A[69] = 0.148716902392404*G0_0_0 + 0.002805979290423*G0_0_1 + 0.294627825494385*G0_1_0;
    A[70] = -0.006873217490354*G0_0_0 - 0.047253370246174*G0_0_1 - 0.177844502562874*G0_1_0 - 0.103098262355288*G0_1_1;
    A[71] = 0.128968253968249*G0_0_0 - 0.091765873015871*G0_0_1 - 0.016369047619046*G0_1_0 - 0.178571428571424*G0_1_1;
    A[72] = -0.070149482260569*G0_0_0 + 0.065940513324932*G0_0_1 - 0.079970409777049*G0_1_0 + 0.134687005940287*G0_1_1;
    A[73] = -0.046394218059879*G0_0_0 + 0.002577456558881*G0_0_1 - 0.059281500854289*G0_1_0 - 0.041239304942114*G0_1_1;
    A[74] = -0.124007936507935*G0_0_0 + 0.116567460317454*G0_0_1 - 0.141369047619046*G0_1_0 + 0.142857142857138*G0_1_1;
    A[75] = -0.023859126984127*G0_0_0 + 0.006820436507937*G0_0_1 - 0.032663690476190*G0_1_0 + 0.011160714285714*G0_1_1;
    A[76] = 0.061111111111111*G0_0_0 - 0.011656746031746*G0_0_1 + 0.075248015873016*G0_1_0 - 0.025297619047619*G0_1_1;
    A[77] = -0.051140873015873*G0_0_0 + 0.007068452380952*G0_0_1 - 0.058209325396826*G0_1_0 + 0.020585317460318*G0_1_1;
    A[78] = 0.017658730158730*G0_0_0 + 0.022371031746032*G0_0_1 + 0.022371031746032*G0_1_0 + 0.044742063492063*G0_1_1;
    A[79] = -0.048710317460318*G0_0_0 - 0.058630952380953*G0_0_1 - 0.054662698412699*G0_1_0 - 0.094444444444445*G0_1_1;
    A[80] = 0.057341269841270*G0_0_0 + 0.068501984126984*G0_0_1 + 0.068501984126984*G0_1_0 + 0.101289682539683*G0_1_1;
    A[81] = 0.011160714285714*G0_0_0 + 0.004340277777778*G0_0_1 + 0.043824404761905*G0_1_0 + 0.013144841269841*G0_1_1;
    A[82] = -0.011904761904762*G0_0_0 - 0.006200396825397*G0_0_1 - 0.033581349206349*G0_1_0 - 0.010416666666666*G0_1_1;
    A[83] = 0.018601190476191*G0_0_0 + 0.009548611111111*G0_0_1 + 0.043080357142857*G0_1_0 + 0.018601190476190*G0_1_1;
    A[84] = -0.089791337293526*G0_0_0 - 0.015432886097325*G0_0_1 - 0.195015560684376*G0_1_0 - 0.042089689356341*G0_1_1;
    A[85] = -0.026633717775116*G0_0_0 - 0.010739402328676*G0_0_1 - 0.007302793583500*G0_1_0 - 0.012887282794412*G0_1_1;
    A[86] = -0.038194444444441*G0_0_0 + 0.035962301587300*G0_0_1 + 0.105406746031745*G0_1_0 + 0.126488095238092*G0_1_1;
    A[87] = -0.035074741130284*G0_0_0 - 0.097507780342188*G0_0_1 - 0.058224070276272*G0_1_0 - 0.164149788489725*G0_1_1;
    A[88] = 0.023197109029939*G0_0_0 + 0.024485837309380*G0_0_1 + 0.055415316015966*G0_1_0 + 0.074746240207582*G0_1_1;
    A[89] = -0.062003968253966*G0_0_0 - 0.208085317460310*G0_0_1 - 0.102926587301585*G0_1_0 - 0.313988095238087*G0_1_1;
    A[90] = -0.013144841269841*G0_0_0 + 0.030679563492064*G0_0_1 - 0.008804563492064*G0_1_0 + 0.023859126984127*G0_1_1;
    A[91] = 0.010416666666667*G0_0_0 - 0.023164682539683*G0_0_1 + 0.004216269841270*G0_1_0 - 0.017460317460318*G0_1_1;
    A[92] = -0.018601190476191*G0_0_0 + 0.024479166666667*G0_0_1 - 0.009052579365079*G0_1_0 + 0.015426587301587*G0_1_1;
    A[93] = 0.020585317460318*G0_0_0 + 0.078794642857143*G0_0_1 + 0.013516865079365*G0_1_0 + 0.020585317460318*G0_1_1;
    A[94] = -0.025297619047619*G0_0_0 - 0.100545634920636*G0_0_1 - 0.013640873015873*G0_1_0 - 0.027777777777778*G0_1_1;
    A[95] = 0.011160714285714*G0_0_0 + 0.043824404761905*G0_0_1 + 0.004340277777778*G0_1_0 + 0.013144841269841*G0_1_1;
    A[96] = 0.101289682539683*G0_0_0 + 0.032787698412699*G0_0_1 + 0.032787698412699*G0_1_0 + 0.021626984126984*G0_1_1;
    A[97] = -0.094444444444445*G0_0_0 - 0.039781746031746*G0_0_1 - 0.035813492063492*G0_1_0 - 0.029861111111111*G0_1_1;
    A[98] = 0.044742063492063*G0_0_0 + 0.022371031746032*G0_0_1 + 0.022371031746032*G0_1_0 + 0.017658730158730*G0_1_1;
    A[99] = -0.206239477846068*G0_0_0 + 0.047000153114581*G0_0_1 - 0.093298811406554*G0_1_0 + 0.035074741130284*G0_1_1;
    A[100] = 0.131450284502993*G0_0_0 + 0.157654426184961*G0_0_1 - 0.010739402328674*G0_1_0 + 0.103957414541582*G0_1_1;
    A[101] = 0.147321428571422*G0_0_0 + 0.106894841269839*G0_0_1 + 0.049355158730157*G0_1_0 + 0.056051587301586*G0_1_1;
    A[102] = 0.042089689356341*G0_0_0 - 0.152925871328036*G0_0_1 + 0.026656803259016*G0_1_0 - 0.078567420131834*G0_1_1;
    A[103] = 0.103098262355287*G0_0_0 + 0.015464739353292*G0_0_1 + 0.077323696766466*G0_1_0 - 0.056704044295407*G0_1_1;
    A[104] = 0.074404761904761*G0_0_0 + 0.015376984126983*G0_0_1 + 0.047123015873015*G0_1_0 - 0.007936507936507*G0_1_1;
    A[105] = 0.027777777777778*G0_0_0 - 0.072767857142858*G0_0_1 + 0.014136904761905*G0_1_0 - 0.061111111111112*G0_1_1;
    A[106] = -0.017857142857143*G0_0_0 + 0.053273809523810*G0_0_1 - 0.009424603174603*G0_1_0 + 0.043849206349207*G0_1_1;
    A[107] = 0.011904761904762*G0_0_0 - 0.021676587301587*G0_0_1 + 0.005704365079365*G0_1_0 - 0.017460317460318*G0_1_1;
    A[108] = -0.027777777777778*G0_0_0 - 0.100545634920636*G0_0_1 - 0.013640873015873*G0_1_0 - 0.025297619047619*G0_1_1;
    A[109] = 0.017857142857143*G0_0_0 + 0.071130952380952*G0_0_1 + 0.008432539682540*G0_1_0 + 0.017857142857143*G0_1_1;
    A[110] = -0.011904761904762*G0_0_0 - 0.033581349206349*G0_0_1 - 0.006200396825397*G0_1_0 - 0.010416666666666*G0_1_1;
    A[111] = -0.094444444444445*G0_0_0 - 0.035813492063492*G0_0_1 - 0.039781746031746*G0_1_0 - 0.029861111111111*G0_1_1;
    A[112] = 0.163095238095239*G0_0_0 + 0.081547619047620*G0_0_1 + 0.081547619047620*G0_1_0 + 0.068650793650794*G0_1_1;
    A[113] = -0.094444444444445*G0_0_0 - 0.058630952380953*G0_0_1 - 0.054662698412699*G0_1_0 - 0.048710317460318*G0_1_1;
    A[114] = 0.134687005940288*G0_0_0 - 0.079970409777048*G0_0_1 + 0.065940513324932*G0_1_0 - 0.070149482260569*G0_1_1;
    A[115] = 0.103098262355288*G0_0_0 - 0.152069936974049*G0_0_1 + 0.102239110168991*G0_1_0 - 0.130591132316698*G0_1_1;
    A[116] = -0.107142857142853*G0_0_0 + 0.019345238095238*G0_0_1 - 0.056051587301585*G0_1_0 + 0.021825396825397*G0_1_1;
    A[117] = 0.294627825494384*G0_0_1 + 0.002805979290423*G0_1_0 + 0.148716902392403*G0_1_1;
    A[118] = -0.206196524710575*G0_0_0 - 0.103098262355287*G0_0_1 - 0.103098262355288*G0_1_0 + 0.108253175473050*G0_1_1;
    A[119] = -0.145833333333332*G0_0_1 + 0.004960317460317*G0_1_0 - 0.070436507936508*G0_1_1;
    A[120] = -0.020585317460318*G0_0_0 + 0.058209325396826*G0_0_1 - 0.007068452380952*G0_1_0 + 0.051140873015873*G0_1_1;
    A[121] = 0.025297619047619*G0_0_0 - 0.075248015873017*G0_0_1 + 0.011656746031746*G0_1_0 - 0.061111111111112*G0_1_1;
    A[122] = -0.011160714285714*G0_0_0 + 0.032663690476191*G0_0_1 - 0.006820436507937*G0_1_0 + 0.023859126984127*G0_1_1;
    A[123] = 0.013144841269841*G0_0_0 + 0.043824404761905*G0_0_1 + 0.004340277777778*G0_1_0 + 0.011160714285714*G0_1_1;
    A[124] = -0.010416666666667*G0_0_0 - 0.033581349206349*G0_0_1 - 0.006200396825397*G0_1_0 - 0.011904761904762*G0_1_1;
    A[125] = 0.018601190476191*G0_0_0 + 0.043080357142857*G0_0_1 + 0.009548611111111*G0_1_0 + 0.018601190476190*G0_1_1;
    A[126] = 0.044742063492063*G0_0_0 + 0.022371031746032*G0_0_1 + 0.022371031746032*G0_1_0 + 0.017658730158730*G0_1_1;
    A[127] = -0.094444444444445*G0_0_0 - 0.054662698412699*G0_0_1 - 0.058630952380953*G0_1_0 - 0.048710317460318*G0_1_1;
    A[128] = 0.101289682539683*G0_0_0 + 0.068501984126985*G0_0_1 + 0.068501984126985*G0_1_0 + 0.057341269841270*G0_1_1;
    A[129] = -0.164149788489726*G0_0_0 - 0.058224070276273*G0_0_1 - 0.097507780342189*G0_1_0 - 0.035074741130285*G0_1_1;
    A[130] = -0.234548546858280*G0_0_0 - 0.061429381320027*G0_0_1 - 0.167964252420488*G0_1_0 - 0.042098457128410*G0_1_1;
    A[131] = 0.221726190476183*G0_0_0 + 0.099454365079363*G0_0_1 + 0.125248015873011*G0_1_0 + 0.051091269841269*G0_1_1;
    A[132] = -0.042089689356341*G0_0_0 - 0.195015560684376*G0_0_1 - 0.015432886097325*G0_1_0 - 0.089791337293526*G0_1_1;
    A[133] = 0.103098262355287*G0_0_0 + 0.087633523001995*G0_0_1 + 0.025774565588821*G0_1_0 - 0.046394218059878*G0_1_1;
    A[134] = -0.074404761904760*G0_0_0 - 0.059027777777778*G0_0_1 - 0.027281746031745*G0_1_0 - 0.003968253968254*G0_1_1;
    A[135] = 0.043492679001549*G0_0_0 - 0.062433039211904*G0_0_1 - 0.023149329145988*G0_1_0 + 0.035074741130284*G0_1_1;
    A[136] = -0.078567420131834*G0_0_0 + 0.136089995585501*G0_0_1 - 0.009820927516480*G0_1_0 + 0.070149482260569*G0_1_1;
    A[137] = 0.124866078423811*G0_0_0 - 0.128373552536838*G0_0_1 + 0.011925411984297*G0_1_0 - 0.035074741130285*G0_1_1;
    A[138] = -0.078567420131834*G0_0_0 - 0.152925871328036*G0_0_1 + 0.026656803259016*G0_1_0 + 0.042089689356341*G0_1_1;
    A[139] = 0.148716902392404*G0_0_0 + 0.294627825494385*G0_0_1 + 0.002805979290423*G0_1_0;
    A[140] = -0.089791337293526*G0_0_0 - 0.195015560684376*G0_0_1 - 0.015432886097325*G0_1_0 - 0.042089689356341*G0_1_1;
    A[141] = -0.206239477846068*G0_0_0 - 0.093298811406554*G0_0_1 + 0.047000153114581*G0_1_0 + 0.035074741130284*G0_1_1;
    A[142] = 0.134687005940288*G0_0_0 + 0.065940513324932*G0_0_1 - 0.079970409777048*G0_1_0 - 0.070149482260569*G0_1_1;
    A[143] = -0.164149788489726*G0_0_0 - 0.097507780342189*G0_0_1 - 0.058224070276273*G0_1_0 - 0.035074741130285*G0_1_1;
    A[144] = 4.920634920634567*G0_0_0 + 0.198412698412688*G0_0_1 + 0.198412698412688*G0_1_0 + 0.396825396825375*G0_1_1;
    A[145] = 0.024300493479966*G0_0_0 - 0.060751233699967*G0_0_1 + 0.230854688059913*G0_1_0 + 0.607512336999764*G0_1_1;
    A[146] = -0.519106168728166*G0_0_0 - 0.806719045996497*G0_0_1 - 0.301642773720431*G0_1_0 - 0.350747411302832*G0_1_1;
    A[147] = -0.198412698412689*G0_0_0 + 4.305555555555237*G0_0_1 + 0.019841269841269*G0_1_0 - 0.198412698412687*G0_1_1;
    A[148] = -0.218704441319894*G0_0_0 - 0.036450740219987*G0_0_1 + 0.255155181539901*G0_1_0 - 0.218704441319913*G0_1_1;
    A[149] = -0.350747411302835*G0_0_0 + 0.540151013406350*G0_0_1 + 0.035074741130283*G0_1_0 + 0.322687618398611*G0_1_1;
    A[150] = 0.065295566158350*G0_0_0 - 0.127154523571520*G0_0_1 - 0.051549131177644*G0_1_0 + 0.065295566158349*G0_1_1;
    A[151] = -0.053267435550233*G0_0_0 + 0.183858567866929*G0_0_1 - 0.008591521862941*G0_1_0 + 0.084196914256820*G0_1_1;
    A[152] = -0.003436608745177*G0_0_0 - 0.051549131177643*G0_0_1 - 0.017183043725881*G0_1_0 - 0.003436608745176*G0_1_1;
    A[153] = -0.035225239638056*G0_0_0 + 0.021049228564203*G0_0_1 + 0.079471577232201*G0_1_0 + 0.115985545149699*G0_1_1;
    A[154] = -0.006873217490354*G0_0_0 - 0.177844502562874*G0_0_1 - 0.047253370246174*G0_1_0 - 0.103098262355288*G0_1_1;
    A[155] = -0.026633717775116*G0_0_0 - 0.007302793583500*G0_0_1 - 0.010739402328676*G0_1_0 - 0.012887282794412*G0_1_1;
    A[156] = 0.131450284502994*G0_0_0 - 0.010739402328674*G0_0_1 + 0.157654426184961*G0_1_0 + 0.103957414541582*G0_1_1;
    A[157] = 0.103098262355288*G0_0_0 + 0.102239110168991*G0_0_1 - 0.152069936974049*G0_1_0 - 0.130591132316698*G0_1_1;
    A[158] = -0.234548546858281*G0_0_0 - 0.167964252420488*G0_0_1 - 0.061429381320027*G0_1_0 - 0.042098457128410*G0_1_1;
    A[159] = 0.024300493479966*G0_0_0 + 0.230854688059913*G0_0_1 - 0.060751233699967*G0_1_0 + 0.607512336999764*G0_1_1;
    A[160] = 5.416666666666341*G0_0_0 + 0.431547619047606*G0_0_1 + 0.431547619047606*G0_1_0 + 1.130952380952322*G0_1_1;
    A[161] = -0.189013480984697*G0_0_0 - 0.068732174903520*G0_0_1 - 0.274928699614087*G0_1_0 - 0.189013480984689*G0_1_1;
    A[162] = 0.170103454359941*G0_0_0 + 0.449559129379811*G0_0_1 + 0.157953207619939*G0_1_0 - 0.413108389159829*G0_1_1;
    A[163] = -0.401785714285695*G0_0_0 + 3.593749999999750*G0_0_1 + 0.558035714285685*G0_1_0 - 0.401785714285686*G0_1_1;
    A[164] = 0.300703265202925*G0_0_0 + 0.176126198190277*G0_0_1 + 0.279224460545564*G0_1_0 + 0.300703265202922*G0_1_1;
    A[165] = -0.016865079365081*G0_0_0 + 0.071924603174600*G0_0_1 - 0.007440476190476*G0_1_0 - 0.010912698412699*G0_1_1;
    A[166] = -0.004960317460314*G0_0_0 - 0.162698412698407*G0_0_1 + 0.019841269841269*G0_1_0 - 0.102182539682537*G0_1_1;
    A[167] = 0.100198412698408*G0_0_0 + 0.102678571428568*G0_0_1 - 0.071924603174601*G0_1_0 + 0.118055555555554*G0_1_1;
    A[168] = -0.045138888888887*G0_0_0 + 0.005704365079364*G0_0_1 + 0.043402777777777*G0_1_0 + 0.052083333333332*G0_1_1;
    A[169] = 0.128968253968249*G0_0_0 - 0.016369047619046*G0_0_1 - 0.091765873015871*G0_1_0 - 0.178571428571424*G0_1_1;
    A[170] = -0.038194444444441*G0_0_0 + 0.105406746031745*G0_0_1 + 0.035962301587300*G0_1_0 + 0.126488095238092*G0_1_1;
    A[171] = 0.147321428571422*G0_0_0 + 0.049355158730157*G0_0_1 + 0.106894841269839*G0_1_0 + 0.056051587301586*G0_1_1;
    A[172] = -0.107142857142853*G0_0_0 - 0.056051587301585*G0_0_1 + 0.019345238095238*G0_1_0 + 0.021825396825397*G0_1_1;
    A[173] = 0.221726190476183*G0_0_0 + 0.125248015873011*G0_0_1 + 0.099454365079363*G0_1_0 + 0.051091269841269*G0_1_1;
    A[174] = -0.519106168728166*G0_0_0 - 0.301642773720431*G0_0_1 - 0.806719045996497*G0_1_0 - 0.350747411302832*G0_1_1;
    A[175] = -0.189013480984697*G0_0_0 - 0.274928699614087*G0_0_1 - 0.068732174903520*G0_1_0 - 0.189013480984689*G0_1_1;
    A[176] = 5.555555555555189*G0_0_0 + 0.590277777777738*G0_0_1 + 0.590277777777738*G0_1_0 + 0.912698412698367*G0_1_1;
    A[177] = -0.350747411302834*G0_0_0 - 0.301642773720424*G0_0_1 + 0.203433498555643*G0_1_0 - 0.014029896452095*G0_1_1;
    A[178] = 0.077323696766471*G0_0_0 + 0.167534676327338*G0_0_1 + 0.064436413972052*G0_1_0 + 0.077323696766467*G0_1_1;
    A[179] = -0.620039682539653*G0_0_0 + 3.395337301587060*G0_0_1 + 0.359623015872998*G0_1_0 - 0.620039682539661*G0_1_1;
    A[180] = 0.035074741130284*G0_0_0 - 0.011925411984297*G0_0_1 + 0.128373552536838*G0_1_0 - 0.124866078423811*G0_1_1;
    A[181] = -0.070149482260569*G0_0_0 + 0.009820927516480*G0_0_1 - 0.136089995585501*G0_1_0 + 0.078567420131834*G0_1_1;
    A[182] = -0.035074741130285*G0_0_0 + 0.023149329145988*G0_0_1 + 0.062433039211904*G0_1_0 - 0.043492679001550*G0_1_1;
    A[183] = 0.035074741130285*G0_0_0 + 0.047000153114581*G0_0_1 - 0.093298811406554*G0_1_0 - 0.206239477846067*G0_1_1;
    A[184] = -0.070149482260569*G0_0_0 - 0.079970409777049*G0_0_1 + 0.065940513324932*G0_1_0 + 0.134687005940287*G0_1_1;
    A[185] = -0.035074741130284*G0_0_0 - 0.058224070276272*G0_0_1 - 0.097507780342188*G0_1_0 - 0.164149788489725*G0_1_1;
    A[186] = 0.042089689356341*G0_0_0 + 0.026656803259016*G0_0_1 - 0.152925871328036*G0_1_0 - 0.078567420131834*G0_1_1;
    A[187] = 0.002805979290423*G0_0_1 + 0.294627825494384*G0_1_0 + 0.148716902392403*G0_1_1;
    A[188] = -0.042089689356341*G0_0_0 - 0.015432886097325*G0_0_1 - 0.195015560684376*G0_1_0 - 0.089791337293526*G0_1_1;
    A[189] = -0.198412698412689*G0_0_0 + 0.019841269841269*G0_0_1 + 4.305555555555236*G0_1_0 - 0.198412698412687*G0_1_1;
    A[190] = 0.170103454359941*G0_0_0 + 0.157953207619939*G0_0_1 + 0.449559129379811*G0_1_0 - 0.413108389159829*G0_1_1;
    A[191] = -0.350747411302834*G0_0_0 + 0.203433498555643*G0_0_1 - 0.301642773720425*G0_1_0 - 0.014029896452095*G0_1_1;
    A[192] = 0.396825396825376*G0_0_0 + 0.198412698412687*G0_0_1 + 0.198412698412687*G0_1_0 + 4.920634920634568*G0_1_1;
    A[193] = -0.145802960879936*G0_0_1 - 0.729014804399696*G0_1_0 - 0.437408882639822*G0_1_1;
    A[194] = 0.701494822605665*G0_0_0 + 0.350747411302831*G0_0_1 + 0.350747411302829*G0_1_0 + 0.280597929042238*G0_1_1;
    A[195] = -0.100520805796406*G0_0_0 + 0.070880055369260*G0_0_1 - 0.063147685692613*G0_1_0 - 0.085056066443111*G0_1_1;
    A[196] = 0.046394218059879*G0_0_0 - 0.012887282794410*G0_0_1 + 0.048971674618760*G0_1_0 + 0.030929478706585*G0_1_1;
    A[197] = -0.023197109029939*G0_0_0 + 0.032218206986027*G0_0_1 + 0.001288728279441*G0_1_0 - 0.018042195912174*G0_1_1;
    A[198] = 0.100520805796406*G0_0_0 + 0.171400861165666*G0_0_1 + 0.037373120103792*G0_1_0 + 0.193309241916163*G0_1_1;
    A[199] = -0.046394218059879*G0_0_0 - 0.059281500854289*G0_0_1 + 0.002577456558881*G0_1_0 - 0.041239304942114*G0_1_1;
    A[200] = 0.023197109029939*G0_0_0 + 0.055415316015966*G0_0_1 + 0.024485837309380*G0_1_0 + 0.074746240207582*G0_1_1;
    A[201] = 0.103098262355287*G0_0_0 + 0.077323696766466*G0_0_1 + 0.015464739353292*G0_1_0 - 0.056704044295407*G0_1_1;
    A[202] = -0.206196524710575*G0_0_0 - 0.103098262355288*G0_0_1 - 0.103098262355287*G0_1_0 + 0.108253175473050*G0_1_1;
    A[203] = 0.103098262355287*G0_0_0 + 0.025774565588821*G0_0_1 + 0.087633523001995*G0_1_0 - 0.046394218059878*G0_1_1;
    A[204] = -0.218704441319894*G0_0_0 + 0.255155181539901*G0_0_1 - 0.036450740219987*G0_1_0 - 0.218704441319913*G0_1_1;
    A[205] = -0.401785714285695*G0_0_0 + 0.558035714285685*G0_0_1 + 3.593749999999750*G0_1_0 - 0.401785714285686*G0_1_1;
    A[206] = 0.077323696766471*G0_0_0 + 0.064436413972052*G0_0_1 + 0.167534676327338*G0_1_0 + 0.077323696766466*G0_1_1;
    A[207] = -0.729014804399697*G0_0_1 - 0.145802960879936*G0_1_0 - 0.437408882639822*G0_1_1;
    A[208] = 0.803571428571388*G0_0_0 + 0.401785714285693*G0_0_1 + 0.401785714285692*G0_1_0 + 5.357142857142497*G0_1_1;
    A[209] = -0.051549131177631*G0_0_1 - 0.257745655888199*G0_1_0 - 0.154647393532917*G0_1_1;
    A[210] = 0.062003968253967*G0_0_0 - 0.021081349206349*G0_0_1 + 0.095982142857138*G0_1_0 + 0.053075396825397*G0_1_1;
    A[211] = -0.124007936507934*G0_0_0 + 0.017361111111111*G0_0_1 - 0.240575396825388*G0_1_0 + 0.043650793650793*G0_1_1;
    A[212] = -0.062003968253968*G0_0_0 + 0.040922619047619*G0_0_1 + 0.146081349206343*G0_1_0 - 0.064980158730158*G0_1_1;
    A[213] = 0.062003968253967*G0_0_0 + 0.083085317460317*G0_0_1 - 0.033978174603172*G0_1_0 + 0.040178571428573*G0_1_1;
    A[214] = -0.124007936507935*G0_0_0 - 0.141369047619046*G0_0_1 + 0.116567460317454*G0_1_0 + 0.142857142857138*G0_1_1;
    A[215] = -0.062003968253966*G0_0_0 - 0.102926587301585*G0_0_1 - 0.208085317460310*G0_1_0 - 0.313988095238087*G0_1_1;
    A[216] = 0.074404761904761*G0_0_0 + 0.047123015873015*G0_0_1 + 0.015376984126983*G0_1_0 - 0.007936507936507*G0_1_1;
    A[217] = 0.004960317460317*G0_0_1 - 0.145833333333332*G0_1_0 - 0.070436507936508*G0_1_1;
    A[218] = -0.074404761904760*G0_0_0 - 0.027281746031745*G0_0_1 - 0.059027777777778*G0_1_0 - 0.003968253968254*G0_1_1;
    A[219] = -0.350747411302835*G0_0_0 + 0.035074741130283*G0_0_1 + 0.540151013406349*G0_1_0 + 0.322687618398611*G0_1_1;
    A[220] = 0.300703265202925*G0_0_0 + 0.279224460545564*G0_0_1 + 0.176126198190277*G0_1_0 + 0.300703265202921*G0_1_1;
    A[221] = -0.620039682539653*G0_0_0 + 0.359623015872998*G0_0_1 + 3.395337301587060*G0_1_0 - 0.620039682539661*G0_1_1;
    A[222] = 0.701494822605665*G0_0_0 + 0.350747411302829*G0_0_1 + 0.350747411302831*G0_1_0 + 0.280597929042238*G0_1_1;
    A[223] = -0.257745655888199*G0_0_1 - 0.051549131177631*G0_1_0 - 0.154647393532917*G0_1_1;
    A[224] = 1.240079365079299*G0_0_0 + 0.620039682539646*G0_0_1 + 0.620039682539646*G0_1_0 + 5.615079365079026*G0_1_1;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class forms_form_0: public ufc::form
{
public:

  /// Constructor
  forms_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Sum(Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})))), Sum(Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 1), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2}))))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_finite_element_0();
        break;
      }
    case 1:
      {
        return new forms_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_dofmap_0();
        break;
      }
    case 1:
      {
        return new forms_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class forms_form_1: public ufc::form
{
public:

  /// Constructor
  forms_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(Indexed(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 0), MultiIndex((Index(0),), {Index(0): 2})), Indexed(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 1), MultiIndex((Index(0),), {Index(0): 2}))), MultiIndex((Index(0),), {Index(0): 2})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_finite_element_0();
        break;
      }
    case 1:
      {
        return new forms_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_dofmap_0();
        break;
      }
    case 1:
      {
        return new forms_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>

namespace Forms
{

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::error("No coefficients.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::error("No coefficients.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

class Form_1_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_1()
  {
  }

};

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::error("No coefficients.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::error("No coefficients.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;
  typedef Form_1_FunctionSpace_1 TrialSpace;

  // Coefficients
};

// Class typedefs
typedef Form_0::TestSpace FunctionSpace;

}

#endif
