<?xml version='1.0'?><!-- -*-SGML-*- -->
<!--
This file  is part of  DocBookWiki.  DocBookWiki is a  web application
that  displays  and  edits  DocBook  documents.  

Copyright (C) 2004, 2005 Dashamir Hoxha, dashohoxha@users.sf.net

DocBookWiki is free software; you can redistribute it and/or modify it
under the terms of the GNU  General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

DocBookWiki is  distributed in  the hope that  it will be  useful, but
WITHOUT   ANY  WARRANTY;   without  even   the  implied   warranty  of
MERCHANTABILITY  or FITNESS  FOR A  PARTICULAR PURPOSE.   See  the GNU
General Public License for more details.

You  should have received  a copy  of the  GNU General  Public License
along with DocBookWiki; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0'>

<!-- mediaobject -->
<xsl:template match="mediaobject">
  <xsl:variable name="node_path" select="'{{node_path}}'" />

  <xsl:variable name="align">
    <xsl:choose>
      <xsl:when test="./imageobject/imagedata/@align">
        <xsl:value-of select="./imageobject/imagedata/@align" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'center'" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <div align="{$align}">
  <table class="imageobject">
    <tr>
      <td class="imagedata">
        <img src="{$book_path}{$node_path}{./imageobject/imagedata/@fileref}"
             width="{./imageobject/imagedata/@width}"
             alt="{./textobject/phrase}" />
      </td>
    </tr>
    <xsl:if test="./caption">
    <tr>
      <td class="caption"><xsl:value-of select="./caption/para"/></td>
    </tr>
    </xsl:if>
  </table>
  </div>
</xsl:template>


</xsl:transform>
