# If dhcdbd is to be run by the dbus-daemon's service activation service,
# then currently it MUST be installed setuid; else, it must have an
# initscript and be run as root during boot.

Summary:   DHCP D-BUS daemon (dhcdbd) controls dhclient sessions with D-BUS
Name:      dhcdbd
Version:   3.0
Release:   1%{?dist}
License:   GPLv2+
Group:     System Environment/Daemons
URL:       http://dcantrel.fedorapeople.org/%{name}/

Source:    http://dcantrel.fedorapeople.org/%{name}/%{name}-%{version}.tar.bz2

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: dbus-devel >= 0.90, pkgconfig

Requires: dhclient >= 3.0.4, dbus >= 0.6
Requires(post): chkconfig
Requires(preun): chkconfig
Requires(preun): initscripts
Requires(postun): initscripts

%description
dhcdbd provides a D-BUS interface to the ISC dhclient software.  The
daemon provides access to DHCP configuration operations and stores those
options persistently.  Other D-BUS applications can receive notifications
of changes in the client's DHCP configuration.

%prep
%setup -q

%build
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
%{__make} install DESTDIR=%{buildroot}
%{__mkdir} -p %{buildroot}%{_initrddir}
%{__install} -p -c -m 0755 dhcdbd.init %{buildroot}%{_initrddir}/dhcdbd

%clean
%{__rm} -rf %{buildroot}

%post
# This adds the proper /etc/rc*.d links for the script
/sbin/chkconfig --add dhcdbd

%preun
if [ $1 = 0 ]; then
    /sbin/service dhcdbd stop >/dev/null 2>&1 || :
    /sbin/chkconfig --del dhcdbd
fi

%postun
if [ $1 = 1 ]; then
    /sbin/service dhcdbd condrestart >/dev/null 2>&1 || :
fi

%files
%defattr(-, root, root, -)
%doc README COPYING ChangeLog TODO
%config(noreplace) %{_sysconfdir}/dbus-1/system.d/dhcdbd.conf
%{_datadir}/dbus-1/services/dhcdbd.service
%attr(755,root,root) /sbin/dhcdbd
%attr(755,root,root) %{_initrddir}/dhcdbd

%changelog
* Thu Aug 16 2007 David Cantrell <dcantrell@redhat.com> - 3.0-1
- Removed the extended option info switch for dhclient (-x) as dhclient is
  no longer providing this capability.

* Wed Aug 15 2007 David Cantrell <dcantrell@redhat.com> - 2.10-1
- Do not source /lib/lsb/init-functions (#252256)
- Use existing init script functions, not LSB-specific ones (#252256)
- Do not use the log_success_msg() or log_failure_msg() functions for LSB
  scripts even though they do exist and just pass through to our existing
  functions (#252256)

* Mon Aug 13 2007 David Cantrell <dcantrell@redhat.com> - 2.9-1
- Update init script to meet LSB requirements (#246906)
- Relicense software under GPL version 2 or any later version

* Wed Aug 08 2007 David Cantrell <dcantrell@redhat.com> - 2.8-3
- Update License tag to GPLv2
- Change dbus_watch_get_fd() calls to dbus_watch_get_unix_fd() calls
- Pass a mode to the open(2) call

* Mon Jun 11 2007 David Cantrell <dcantrell@redhat.com> - 2.8-2
- Merge review (#225690)

* Tue Jun 05 2007 David Cantrell <dcantrell@redhat.com> - 2.8-1
- Use dbus to avoid waking up so often (#218406)

* Thu May 05 2007 David Cantrell <dcantrell@redhat.com> - 2.7-4
- Make sure lockfile is removed when service is stopped (#238713)

* Thu Apr 26 2007 David Cantrell <dcantrell@redhat.com> - 2.7-3
- More init script fixes (#237977)

* Thu Apr 26 2007 David Cantrell <dcantrell@redhat.com> - 2.7-2
- Init script fixes (#237977)

* Mon Apr 09 2007 David Cantrell <dcantrell@redhat.com> - 2.7-1
- Spec file scriptlet cleanups

* Mon Mar 05 2007 David Cantrell <dcantrell@redhat.com> - 2.6-1
- Spec file cleanups to conform to Fedora packaging guidelines
- Run 'chkconfig --del dhcdbd' on package removal (#222514)

* Thu Feb 08 2007 David Cantrell <dcantrell@redhat.com> - 2.5-1
- Remove period from end of summary line (package review)
- Use preferred BuildRoot (package review)

* Fri Feb 02 2007 David Cantrell <dcantrell@redhat.com> - 2.4-1
- Enable dhcdbd service by default in runlevels 2, 3, 4, and 5

* Mon Nov 06 2006 David Cantrell <dcantrell@redhat.com> - 2.3-1
- Require dhcp-3.0.4 or higher
- Removed the tests subdirectory since they are old and not useful

* Wed Nov 01 2006 David Cantrell <dcantrell@redhat.com> - 2.2-1
- Set chkconfig start order to 97 so dhcdbd starts before NetworkManager

* Fri Sep 29 2006 David Cantrell <dcantrell@redhat.com> - 2.1-1
- Line continuation slashes for the description in dhcdbd.init (#204711)

* Tue Sep 26 2006 David Cantrell <dcantrell@redhat.com> - 2.0-1
- Rebuild for FC6
- BuildRequires pkgconfig

* Tue Sep 26 2006 David Cantrell <dcantrell@redhat.com> - 1.99.4-1
- Reworked source tree to make builds a little cleaner
- Added more documentation
- Removed named user policy in dhcdbd.conf (#205254)

* Wed Aug 16 2006 Bill Nottingham <notting@redhat.com>
- silence %%postun condrestart, %%preun stop

* Mon Aug 14 2006 David Cantrell <dcantrell@redhat.com> - 1.16-1
- Rolled in dbus-deprecated patch changes to upstream source
- Corrected init script problems (#202219)
- Install the init script from the source archive, not SOURCES

* Wed Jul 19 2006 Matthias Clasen <mclasen@redhat.com> - 1.15-1.FC6.3
- Rebuild against new dbus

* Tue Jul 18 2006 John (J5) Palmieri <johnp@redhat.com> - 1.15-1.FC6.2
- add dbus-deprecated patch

* Wed Jul 12 2006 Jesse Keating <jkeating@redhat.com> - 1.15-1.FC6.1
- rebuild

* Mon May 30 2006 Jason Vas Dias <jvdias@redhat.com> - 1.15-1.FC6
- fix bug 193562: remove 'servicedir' entry from dhcdbd.conf

* Thu Apr 20 2006 Jason Vas Dias <jvdias@redhat.com> - 1.14-1.FC5
- fix bug 189529: prevent potential memory corruption on hex string
  options with single-byte non-ascii values
- modify dhcp option types to be in line with latest ISC dhcp

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 1.12-1.FC5.2
- bump again for double-long bug on ppc(64)

* Tue Feb 07 2006 Jesse Keating <jkeating@redhat.com> - 1.12-1.FC5.1
- rebuilt for new gcc4.1 snapshot and glibc changes

* Tue Jan 17 2006 Jason Vas Dias <jvdias@redhat.com> 1.12-1
- Cleanup un-exercised code in dbus_service.c, lines 381 & 391
  (pointed out by David Binderman<dcb314@hotmail.com>)

* Thu Dec 01 2005 Jason Vas Dias <jvdias@redhat.com> 1.11-1
- Rebuild for new dbus-0.6 dependency; remove use of
  DBUS_NAME_FLAG_PROHIBIT_REPLACEMENT

* Wed Nov 16 2005 Jason Vas Dias <jvdias@redhat.com> 1.10-1
- Rebuild for FC-5 (version must compare > FC-4)
- Change dhclient.leases directory to /var/lib/dhclient/ for bug 169164
- fix Makefile to workaround bug 173431
- apply patch contributed by Robert Love<rml@novell.com> :
  o use daemon(3) to daemonize
  o direct stdout/stderr to /dev/null, not console
  o use dhclient -q option

* Thu Oct 06 2005 Jason Vas Dias <jvdias@redhat.com> 1.9-1
- fix bug 169937: do 'chkconfig --add dhcdbd' in %%post
- Add CHANGES changelog file to %%doc generated from this changelog
- Rebuild with new dbus / gcc / glibc

* Fri Aug 12 2005 Jason Vas Dias <jvdias@redhat.com> 1.8-1
- Allow named user permission to send in /etc/dbus-1/system.d/dhcdbd.conf
- Fix bug 163711 addendum: handle non-existence of /etc/sysconfig/network

* Wed Jul 27 2005 Jason Vas Dias <jvdias@redhat.com> 1.7-1
- fix bug 163711 / 162857: dhcdbd.init startup order
- improve security with system.d/dhcdbd.conf: allow only
  root user to send to dhcdbd
 
* Mon Jun 06 2005 Jason Vas Dias <jvdias@redhat.com> 1.6-1
- Add GPL licensing
- Make all paths into -D options
- Handle interface specific dhclient-${if}.conf files properly
- Add "up" dhclient flag DHCLIENT_NO_LEASES to remove
  lease database on startup
- Add /var/run/dhcdbd.pid file support
- fix initscript stop & add condrestart
- invoke condrestart on upgrade
- cleanup after dead prospective subscribers properly

* Sun May 15 2005 Jason Vas Dias <jvdias@redhat.com> 1.5-1
- add subscriptions for option signals from ANY interface
- fix handling of .old. options from previous lease

* Tue May 03 2005 Jason Vas Dias <jvdias@redhat.com> 1.4-1
- continue to ship dhcdbd.conf and dhcdbd.service even if
  DHCDBD_SETUID=0
- allow --no_daemon to appear before --system or --session

* Tue May 03 2005 Jason Vas Dias <jvdias@redhat.com> 1.3-1
- added timeout "up" argument

* Mon May 02 2005 Jason Vas Dias <jvdias@redhat.com> 1.2-1
- removed setuid requirement.

* Fri Apr 30 2005 Jason Vas Dias <jvdias@redhat.com> 1.1-1
- added subscription facility.

* Mon Apr 25 2005 Jason Vas Dias <jvdias@redhat.com> - 
- Initial build.
