# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import modules, os.path, tools

from tools import consts, log, prefs

MOD_INFO = ('Command Line Support', 'Command Line Support', '', [], True, False)
MOD_NAME = MOD_INFO[modules.MODINFO_NAME]


class CommandLine(modules.ThreadedModule):

    def __init__(self):
        """ Constructor """
        modules.ThreadedModule.__init__(self, (consts.MSG_EVT_NEW_TRACKLIST, consts.MSG_EVT_APP_STARTED))


    def onAppStarted(self):
        """ Try to fill the playlist by using the files given on the command line or by restoring the last playlist """
        (options, args)    = prefs.getCmdLine()
        self.savedPlaylist = os.path.join(consts.dirCfg, 'saved-playlist.txt')

        if len(args) != 0:
            files = []
            for file in args:
                if file.startswith('file://'): files.append(file)
                else:                          files.append('file://' + file)
            log.logger.info('[%s] Filling playlist with files given on command line' % MOD_NAME)
            modules.postMsg(consts.MSG_CMD_TRACKLIST_SET, {'files': files, 'playNow': True})
        else:
            try:
                modules.postMsg(consts.MSG_CMD_TRACKLIST_SET_EXT, {'files': tools.pickleLoad(self.savedPlaylist), 'playNow': False})
                log.logger.info('[%s] Restored playlist' % MOD_NAME)
            except:
                log.logger.error('[%s] Unable to restore playlist from %s' % (MOD_NAME, self.savedPlaylist))


    # --== Message handler ==--


    def handleMsg(self, msg, params):
        """ Handle messages sent to this modules """
        if msg == consts.MSG_EVT_NEW_TRACKLIST:
            tools.pickleSave(self.savedPlaylist, [track.getFields() for track in params['tracks']])
        elif msg == consts.MSG_EVT_APP_STARTED:
            self.onAppStarted()
