# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import media

from tools       import consts
from mutagen.asf import ASF


def readInfo(file):
    """ Read information from an asf file """
    asfFile = ASF(file)

    info = [consts.UNKNOWN_TRACKNUMBER, consts.UNKNOWN_TITLE, consts.UNKNOWN_ARTIST, consts.UNKNOWN_ALBUM, int(round(asfFile.info.length)), file, consts.UNKNOWN_ALBUM_ARTIST]

    try:    info[media.NFO_NUM] = int(asfFile['WM/TrackNumber'][0])
    except: pass

    try:    info[media.NFO_TIT] = unicode(str(asfFile['Title'][0]), errors='replace')
    except: pass

    try:    info[media.NFO_ALB] = unicode(str(asfFile['WM/AlbumTitle'][0]), errors='replace')
    except: pass

    try:    info[media.NFO_ART] = unicode(str(asfFile['Author'][0]), errors='replace')
    except: pass

    try:    info[media.NFO_AAR] = unicode(str(asfFile['WM/AlbumArtist'][0]), errors='replace')
    except: pass

    return info
