# This script sets architecture specification strings. It is not dbs-specific,
# but including it is a good thing. See dbs(7) and dpkg-architecture(1) for
# more info.
#
# Usage in debian/rules:
# ----------------------
# ifeq (,$(DEB_BUILD_GNU_TYPE))
#	include /usr/share/dbs/dpkg-arch.mk
# endif
#

$(warning WARNING:  dbs is deprecated - please use source format 3.0 (quilt) instead)

DEB_BUILD_ARCH		:= $(shell dpkg-architecture -qDEB_BUILD_ARCH)
DEB_BUILD_ARCH_CPU	:= $(shell dpkg-architecture -qDEB_BUILD_ARCH_CPU 2>/dev/null)
DEB_BUILD_ARCH_OS	:= $(shell dpkg-architecture -qDEB_BUILD_ARCH_OS 2>/dev/null)
DEB_BUILD_GNU_CPU	:= $(shell dpkg-architecture -qDEB_BUILD_GNU_CPU)
DEB_BUILD_GNU_SYSTEM	:= $(shell dpkg-architecture -qDEB_BUILD_GNU_SYSTEM)
DEB_BUILD_GNU_TYPE	:= $(shell dpkg-architecture -qDEB_BUILD_GNU_TYPE)
DEB_HOST_ARCH_CPU	:= $(shell dpkg-architecture -qDEB_HOST_ARCH_CPU 2>/dev/null)
DEB_HOST_ARCH_OS	:= $(shell dpkg-architecture -qDEB_HOST_ARCH_OS 2>/dev/null)
DEB_HOST_GNU_CPU	:= $(shell dpkg-architecture -qDEB_HOST_GNU_CPU)
DEB_HOST_GNU_SYSTEM	:= $(shell dpkg-architecture -qDEB_HOST_GNU_SYSTEM)
DEB_HOST_GNU_TYPE	:= $(shell dpkg-architecture -qDEB_HOST_GNU_TYPE)

# Take account of old dpkg-architecture output.
ifeq ($(DEB_BUILD_ARCH_CPU),)
  DEB_BUILD_ARCH_CPU := $(DEB_BUILD_GNU_CPU)
  ifeq ($(DEB_BUILD_ARCH_CPU),x86_64)
    DEB_BUILD_ARCH_CPU := amd64
  endif
endif
ifeq ($(DEB_BUILD_ARCH_OS),)
  DEB_BUILD_ARCH_OS := $(subst -gnu,,$(DEB_BUILD_GNU_SYSTEM))
  ifeq ($(DEB_BUILD_ARCH_OS),gnu)
    DEB_BUILD_ARCH_OS := hurd
  endif
endif
ifeq ($(DEB_HOST_ARCH_CPU),)
  DEB_HOST_ARCH_CPU := $(DEB_HOST_GNU_CPU)
  ifeq ($(DEB_HOST_ARCH_CPU),x86_64)
    DEB_HOST_ARCH_CPU := amd64
  endif
endif
ifeq ($(DEB_HOST_ARCH_OS),)
  DEB_HOST_ARCH_OS := $(subst -gnu,,$(DEB_HOST_GNU_SYSTEM))
  ifeq ($(DEB_HOST_ARCH_OS),gnu)
    DEB_HOST_ARCH_OS := hurd
  endif
endif
