' Copyright (C) 2004 - 2007 db4objects Inc. http:'www.db4o.com 
Imports System
Imports System.IO

Imports System.Runtime.Remoting
Imports System.Runtime.Remoting.Channels
Imports System.Runtime.Remoting.Channels.Http
Imports System.Runtime.Remoting.Channels.Tcp

' Client test class. Creates a test object and passes it over the network 
' to be stored to the database.

Imports RemotingClasses

Namespace RemotingExample

    Class Program

        ' Remote test proxy
        Private testServer As RemotingClasses.RemotingClasses.TestValueServer

        Public Sub New()

            Dim url As String

            ' Setup a client channel to our services.
            Dim channel As HttpChannel = New HttpChannel(0)
            url = "http://LocalHost:65101/"

            ' Register the channel
            ChannelServices.RegisterChannel(channel, False)

            ' Set an access to the remote proxy
            testServer = CType(RemotingServices.Connect(GetType(RemotingClasses.RemotingClasses.TestValueServer), url + "TestValueEndpoint"), RemotingClasses.RemotingClasses.TestValueServer)
        End Sub
        ' end New

        Private Sub RunTest()
            ' Remote persistent class 
            Dim testValue As RemotingClasses.RemotingClasses.TestValue
            testValue = New RemotingClasses.RemotingClasses.TestValue()
            ' Modify local TestValue object
            testValue.ChangeData("Test value")
            ' Pass testValue to the server through testServer
            testServer.TestValue = testValue
            ' Call method on the server to store the testValue object
            testServer.StoreData()
            ' Test what is stored to the database
            Dim result As String = testServer.RetrieveData()
            System.Console.WriteLine(result)
        End Sub
        ' end RunTest

        Shared Sub Main(ByVal args As String())
            Dim p As Program = New Program()
            p.RunTest()
        End Sub
        ' end Main
    End Class
End Namespace
