/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using System.Collections;
using Sharpen.Lang;
using Sharpen.Util;

namespace Db4objects.Db4o {

	[Obsolete("since 7.0")]
    internal class P2HashMapKeySet : ICollection {

        protected P2HashMap i_map;
      
        internal P2HashMapKeySet(P2HashMap p2hashmap) : base() {
            i_map = p2hashmap;
        }

        public int Count{
            get{
                lock (i_map.StreamLock()) {
                    i_map.CheckActive();
                    return i_map.i_size;
                }
            }
        }

        public void CopyTo(Array arr, int pos){
            lock (i_map.StreamLock()) {
                i_map.CheckActive();
                P2HashMapKeyIterator i = new P2HashMapKeyIterator(i_map);
                while (i.HasNext()) {
                    arr.SetValue(i.Next(), pos++);
                }
            }
        }

        public IEnumerator GetEnumerator(){
            i_map.CheckActive();
            return new P2HashMapKeyIterator(i_map);
        }

        public bool IsSynchronized{
            get{
                return true;
            }
        }

        public Object SyncRoot{
            get{
                i_map.CheckActive();
                return i_map.StreamLock();
            }
        }
    }
}