/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using Db4objects.Db4o.Foundation;
using Db4objects.Db4o.Internal;
using Db4objects.Db4o.Internal.Convert;
using Db4objects.Db4o.Internal.Convert.Conversions;

namespace Db4objects.Db4o.Internal.Convert
{
	/// <exclude></exclude>
	public class Converter
	{
		public const int Version = ClassAspects_7_4.Version;

		private static Converter _converter;

		private Hashtable4 _conversions;

		private Converter()
		{
			_conversions = new Hashtable4();
			// TODO: There probably will be Java and .NET conversions
			//       Create Platform4.registerConversions() method ann
			//       call from here when needed.
			CommonConversions.Register(this);
		}

		public static bool Convert(ConversionStage stage)
		{
			if (!NeedsConversion(stage.SystemData()))
			{
				return false;
			}
			if (_converter == null)
			{
				_converter = new Converter();
			}
			return _converter.RunConversions(stage);
		}

		private static bool NeedsConversion(SystemData systemData)
		{
			return systemData.ConverterVersion() < Version;
		}

		public virtual void Register(int idx, Conversion conversion)
		{
			if (_conversions.Get(idx) != null)
			{
				throw new InvalidOperationException();
			}
			_conversions.Put(idx, conversion);
		}

		public virtual bool RunConversions(ConversionStage stage)
		{
			SystemData systemData = stage.SystemData();
			if (!NeedsConversion(systemData))
			{
				return false;
			}
			for (int i = systemData.ConverterVersion(); i <= Version; i++)
			{
				Conversion conversion = (Conversion)_conversions.Get(i);
				if (conversion != null)
				{
					stage.Accept(conversion);
				}
			}
			return true;
		}
	}
}
