/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using Db4oUnit;
using Db4oUnit.Extensions;
using Db4objects.Db4o;
using Db4objects.Db4o.Tests.Common.Config;

namespace Db4objects.Db4o.Tests.Common.Config
{
	public class ConfigurationReuseTestCase : AbstractDb4oTestCase
	{
		private static readonly string FileName = "my.db4o";

		public virtual void TestOpenSolo()
		{
			Assert.Expect(typeof(ArgumentException), new _ICodeBlock_15(this));
		}

		private sealed class _ICodeBlock_15 : ICodeBlock
		{
			public _ICodeBlock_15(ConfigurationReuseTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			/// <exception cref="System.Exception"></exception>
			public void Run()
			{
				Db4oFactory.OpenFile(this._enclosing.Db().Configure(), ConfigurationReuseTestCase
					.FileName);
			}

			private readonly ConfigurationReuseTestCase _enclosing;
		}

		public virtual void TestOpenServer()
		{
			Assert.Expect(typeof(ArgumentException), new _ICodeBlock_23(this));
		}

		private sealed class _ICodeBlock_23 : ICodeBlock
		{
			public _ICodeBlock_23(ConfigurationReuseTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			/// <exception cref="System.Exception"></exception>
			public void Run()
			{
				Db4oFactory.OpenServer(this._enclosing.Db().Configure(), ConfigurationReuseTestCase
					.FileName, 0);
			}

			private readonly ConfigurationReuseTestCase _enclosing;
		}

		public virtual void TestOpenClient()
		{
			Assert.Expect(typeof(ArgumentException), new _ICodeBlock_31(this));
		}

		private sealed class _ICodeBlock_31 : ICodeBlock
		{
			public _ICodeBlock_31(ConfigurationReuseTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			/// <exception cref="System.Exception"></exception>
			public void Run()
			{
				Db4oFactory.OpenClient(this._enclosing.Db().Configure(), "localhost", 0, string.Empty
					, string.Empty);
			}

			private readonly ConfigurationReuseTestCase _enclosing;
		}
	}
}
