/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_tree_builder_hpp_
#define dammit_tree_builder_hpp_ 1

#include "project_node.hpp"
#include "node.hpp"

#include <dammit/build_project.hpp>
#include <dammit/project.hpp>

#include <memory>

namespace dammit {

class tree_builder
{
public:
	void add_project(build_project &);
	void recursive_add_project(project &root);

	intrusive_ptr<node> operator()(project &);
	intrusive_ptr<node> operator()(void);

private:
	struct project_info
	{
		intrusive_ptr<project_node> node;

		bool toplevel;

		typedef std::list<project::name> library_list;
		typedef library_list::iterator library_iterator;
		
		library_list libraries;
		//std::list<project::name> tools;
	};

	typedef std::list<project_info> project_list;
	typedef project_list::iterator project_iterator;

	project_list projects;
};

}

#endif
