/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "print_visitor.hpp"

#include "parallel_node.hpp"
#include "project_node.hpp"
#include "configuration_node.hpp"
#include "input_node.hpp"
#include "temporary_node.hpp"
#include "output_node.hpp"
#include "tool_node.hpp"
#include "environment_node.hpp"
#include "action_node.hpp"

#include <iostream>
#include <iomanip>

namespace dammit {

intrusive_ptr<node> print_visitor::visit(parallel_node &n)
{
	out << std::setw(depth*2+11) << "- parallel" << std::endl;
	++depth;
	for(parallel_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end(); ++i)
		*i = (**i).apply(*this);
	--depth;
	return &n;
}

intrusive_ptr<node> print_visitor::visit(project_node &n)
{
	out << std::setw(depth*2+12) << "- project: " << n.project_name << " (" << n.project_type << ")" << std::endl;
	++depth;
	for(project_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end(); ++i)
		*i = (**i).apply(*this);
	--depth;
	return &n;
}

intrusive_ptr<node> print_visitor::visit(configuration_node &n)
{
	out << std::setw(depth*2+18) << "- configuration: " << n.platform << std::endl;
	++depth;
	for(configuration_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end(); ++i)
		*i = (**i).apply(*this);
	--depth;
	return &n;
}

intrusive_ptr<node> print_visitor::visit(input_node &n)
{
	out << std::setw(depth*2+10) << "- input: " << n.filename << std::endl;
	return &n;
}

intrusive_ptr<node> print_visitor::visit(temporary_node &n)
{
	out << std::setw(depth*2+14) << "- temporary: " << n.filename << std::endl;
	++depth;
	n.action = n.action->apply(*this);
	--depth;
	return &n;
}

intrusive_ptr<node> print_visitor::visit(output_node &n)
{
	out << std::setw(depth*2+11) << "- output: " << n.filename << std::endl;
	++depth;
	for(output_node::input_iterator i = n.inputs.begin();
			i != n.inputs.end(); ++i)
		*i = (**i).apply(*this);
	if(n.action)
		n.action->apply(*this);
	--depth;
	return &n;
}

intrusive_ptr<node> print_visitor::visit(tool_node &n)
{
	out << "tool: " << std::endl;
	return &n;
}

intrusive_ptr<node> print_visitor::visit(environment_node &n)
{
	out << "environment: " << std::endl;
	return &n;
}

intrusive_ptr<node> print_visitor::visit(action_node &n)
{
	out << std::setw(depth*2+11) << "- action: " << n.cmd << std::endl;
	++depth;
	for(action_node::input_iterator i = n.inputs.begin();
			i != n.inputs.end(); ++i)
		*i = (**i).apply(*this);
	--depth;
	return &n;
}

}
