/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "input_node.hpp"

#include "visitor.hpp"
#include "const_visitor.hpp"

namespace dammit {

input_node::input_node(path const &directory, path const &filename) :
	directory(directory), filename(filename)
{
	return;
}

intrusive_ptr<node> input_node::apply(visitor &v)
{
	return v.visit(*this);
}

void input_node::apply(const_visitor &v) const
{
	v.visit(*this);
}

}
