/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_const_visitor_hpp_
#define dammit_const_visitor_hpp_ 1

namespace dammit {

class parallel_node;
class project_node;
class configuration_node;
class input_node;
class temporary_node;
class output_node;
class tool_node;
class environment_node;
class action_node;

class const_visitor
{
public:
	virtual ~const_visitor(void) throw() { }

	virtual void visit(parallel_node const &) = 0;

	virtual void visit(project_node const &) = 0;
	virtual void visit(configuration_node const &) = 0;

	virtual void visit(input_node const &) = 0;
	virtual void visit(temporary_node const &) = 0;
	virtual void visit(output_node const &) = 0;

	virtual void visit(tool_node const &) = 0;
	virtual void visit(environment_node const &) = 0;

	virtual void visit(action_node const &) = 0;
};

}

#endif
