HTTP(1)                      DACS Commands Manual                      HTTP(1)



NNAAMMEE
       http - perform an HTTP/HTTPS request

SSYYNNOOPPSSIISS
       hhttttpp [--ggeett | --ppoosstt | --ddeelleettee | --hheeaadd | --ooppttiioonnss | --ssooppttiioonnss | --ppuutt]
            [--llll _l_o_g___l_e_v_e_l]
            [--pprroommpptt] [--vv] [----vveerrssiioonn] [[--cctt _s_t_r_i_n_g] |
            [----ccoonntteenntt--ttyyppee _s_t_r_i_n_g]]
            [{--hheeaaddeerr _n_a_m_e _v_a_l_u_e}...] [--hheeaaddeerrss _f_i_l_e_n_a_m_e] [--bbooddyy _f_i_l_e_n_a_m_e]
            [--iihh]
            [--uusseerr--aaggeenntt _s_t_r_i_n_g] [{--pp _n_a_m_e _v_a_l_u_e}...] [--pprroottoo _v_e_r_s_i_o_n_-_n_u_m]
            [--pprrooxxyy _p_r_o_x_y_h_o_s_t:_p_r_o_x_y_p_o_r_t]
            [--pprrooxxyymmaattcchh _h_o_s_t_n_a_m_e[:_p_o_r_t] _p_r_o_x_y_h_o_s_t:_p_r_o_x_y_p_o_r_t]
            [--ff _n_a_m_e _f_i_l_e_n_a_m_e] [{--ccooookkiieess _f_i_l_e_n_a_m_e}...] [--aahh]
            [--ssssll _c_o_m_m_a_n_d_-_l_i_n_e] [--ssssll--ffllaaggss _f_l_a_g_s] _u_r_i

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite. It is a stand-alone program
       that neither accepts the usual DDAACCSS command line options
       (ddaaccssooppttiioonnss[1]) nor accesses any DDAACCSS configuration files.

       This general-purpose utility sends an HTTP/HTTPS request for _u_r_i to a
       web server and prints the reply to its standard output.

       hhttttpp will automatically follow redirects according to RRFFCC 22661166[2] and
       up to a compile-time maximum, unless the --pprroommpptt flag is given. A
       non-standard extension is that a redirect to a non-absolute URI is
       interpreted in a manner compatible with most browsers.

           NNoottee
           DDAACCSS can issue its own HTTP requests, such as from
           ddaaccss__aauutthheennttiiccaattee to an external authentication module. This HTTP
           functionality is provided by the same support code that the hhttttpp
           command uses, and therefore much of the following information
           applies to these internally generated requests also (e.g.,
           HHTTTTPP__PPRROOGG[3], SSSSLL__PPRROOGG[4], SSSSLL__PPRROOGG__AARRGGSS[5], SSSSLL__PPRROOGG__CCAA__CCRRTT[6],
           SSSSLL__PPRROOGG__CCLLIIEENNTT__CCRRTT[7], VVFFSS[8]).

OOPPTTIIOONNSS
       The HTTP GET method is used by default, but some flags implicitly
       select a different method (e.g., --ff and --pp). One of the following flags
       can be used to explicitly specify the HTTP method, provided it is
       compatible with the other options:

       --ggeett
           Use the GET method (the default).

       --ppoosstt
           Use the POST method.

       --hheeaadd
           Use the HEAD method.

       --ppuutt
           Use the PUT method.

       --ddeelleettee
           Use the DELETE method.

       --ooppttiioonnss
           Use the OPTIONS method.

       --ssooppttiioonnss
           Use the OPTIONS method but ignore anything that follows the
           authority component of _u_r_i and instead use the special case "*"
           request URI that means that the request applies to the server
           itself rather than to a particular resource.

       These command line flags are also recognized:

       --aahh
           If cookies (credentials) are to be sent (see --ccooookkiieess), use an
           Authorization header rather than a Cookie header.

       --bbooddyy _f_i_l_e_n_a_m_e
           Read the message body from _f_i_l_e_n_a_m_e. It is assumed that the body
           has already been appropriately formatted for the request's content
           type.

       --ccooookkiieess _f_i_l_e_n_a_m_e
           Obtain cookies from _f_i_l_e_n_a_m_e, one per line, to send with the
           request using the Cookie header. Multiple cookies are separated
           using a semi-colon, which follows the NNeettssccaappee ssppeecc[9].
           Alternatively, multiple cookies can be combined on a single line,
           separated by either a semi-colon or a comma (following RRFFCC 22110099[10]
           or RRFFCC 22996655[11]). This argument may be repeated.

       --cctt _s_t_r_i_n_g
       ----ccoonntteenntt--ttyyppee _s_t_r_i_n_g
           Set the Content-Type request-header to _s_t_r_i_n_g. If the request has
           an entity-body, the default Content-Type is
           application/x-www-form-urlencoded; if the request does not have an
           entity-body, by default the Content-Type request-header is not set.

       --ff _n_a_m_e _f_i_l_e_n_a_m_e
           Passes and encodes the contents of _f_i_l_e_n_a_m_e as the value for name.
           By default, the POST method will be used, although PUT and OPTIONS
           can be selected. If _f_i_l_e_n_a_m_e is "--", the standard input is read;
           this form can only be used once on the command line. This argument
           may be repeated.

       --hheeaaddeerr _n_a_m_e _v_a_l_u_e
           This flag, which may be repeated, causes the HTTP header _n_a_m_e:
           _v_a_l_u_e to be sent with the request. Neither _n_a_m_e nor _v_a_l_u_e are
           checked in any way.

               NNoottee
               This will not override headers required or implied by other
               command line flags; for example, the following flags are not
               equivalent:



                   --hheeaaddeerr User-Agent foo
                   --uusseerr--aaggeenntt foo

               The former case will send the User-Agent header twice.

       --hheeaaddeerrss _f_i_l_e_n_a_m_e
           Read additional message headers from _f_i_l_e_n_a_m_e, one per line, and
           send them with the request (refer to the --hheeaaddeerr flag). This flag
           may be repeated.

       --iihh
           Include the HTTP response headers in the output. They are
           terminated by a blank line. The status line is labelled
           "Status-Line".

       --llll _l_o_g___l_e_v_e_l
           Set the debugging output level to _l_o_g___l_e_v_e_l (see ddaaccss((11))[12]). The
           default level is warn, and the --vv flag bumps the level to debug or
           trace.

       --pp _n_a_m_e _v_a_l_u_e
           Passes and encodes name=value as part of the entity-body. By
           default, the POST method will be used, although PUT and OPTIONS can
           be selected. This argument may be repeated.

       --pprroommpptt
           Prompt the user for permission to proceed after certain events,
           such as receiving a redirect; the response is affirmative only if
           it is "yes" or "y". If this option is not specified, the
           affirmative action will automatically be taken.

       --pprroottoo _v_e_r_s_i_o_n_-_n_u_m
           Function in compliance with _v_e_r_s_i_o_n_-_n_u_m of the HTTP protocol (e.g.,
           1.0).

       --pprrooxxyy _p_r_o_x_y_h_o_s_t:_p_r_o_x_y_p_o_r_t
           Forward all HTTP requests (except for those that match a
           --pprrooxxyymmaattcchh flag) to the proxy server at _p_r_o_x_y_p_o_r_t (a numeric port
           number or recognized service name) on _p_r_o_x_y_h_o_s_t (a domain name or
           IP address). Proxying is not fully supported by hhttttpp, but it will
           connect to the specified proxy server instead of the server implied
           by _u_r_i.

       --pprrooxxyymmaattcchh _h_o_s_t_n_a_m_e[:_p_o_r_t] _p_r_o_x_y_h_o_s_t:_p_r_o_x_y_p_o_r_t
           If _h_o_s_t_n_a_m_e matches the host specified in _u_r_i, proxy the HTTP
           request through _p_r_o_x_y_h_o_s_t (a domain name or IP address) at
           _p_r_o_x_y_p_o_r_t (a numeric port number or recognized service name). If
           _p_o_r_t is not given, it is assumed to be 80 (for the http scheme) or
           443 (for the https scheme). Matching is done by resolving _h_o_s_t_n_a_m_e
           to an IP address (if necessary) and comparing it to the effective
           IP address that is specified by _u_r_i. This flag is given priority
           over the --pprrooxxyy flag, so it can be used to override a default proxy
           server.

               NNoottee
               This option is not implemented. The SSL flags apply to _a_l_l
               connections; this is probably a bug.

       --ssssll _c_o_m_m_a_n_d_-_l_i_n_e
           This flag indicates that HTTPS (i.e, HTTP over an SSL connection)
           is to be used, regardless of the scheme specified by _u_r_i. Because
           hhttttpp does not directly include SSL functionality, it uses pipes to
           communicate with an external program that provides the SSL
           connection. The ssssllcclliieenntt((11))[13] command is strongly recommended
           for this purpose (version 3.26 of ssttuunnnneell((11)) and ssttuunnnneell33, which
           comes with some releases of ssttuunnnneell--44..xx, might also work).

           The _c_o_m_m_a_n_d_-_l_i_n_e is a complete shell command line that will be used
           to run the program as a filter. For example, this argument might
           look like either of:

               -ssl "/usr/local/dacs/bin/sslclient example.com:443"

               -ssl "/usr/local/bin/stunnel -c -r example.com:443"

           If the --ssssll argument is absent but the _u_r_i argument uses the https
           scheme, hhttttpp will still try to use SSL. It will attempt to use
           ssssllcclliieenntt((11))[13] and assume it is in its default location. If the
           --ssssll argument is present but specifies only one string, that string
           is assumed to be the path to ssssllcclliieenntt((11))[13]. The first example
           below will run ssssllcclliieenntt((11))[13] from /tmp/sslclient to connect to
           port 443 at example.com; the second example has the same effect but
           will run ssssllcclliieenntt((11))[13] from its default location:

               % http -ssl "/tmp/sslclient" https://example.com
               % http https://example.com


       --ssssll--ffllaaggss _f_l_a_g_s
           If SSL operation is enabled but the --ssssll flag is absent or did not
           simply specify a pathname, append _f_l_a_g_s to the list of arguments to
           be passed to the external SSL provider; when the --ssssll flag
           specifies more than one argument, this flag is ignored. The _f_l_a_g_s
           string is a space-separated list of arguments. This flag may be
           repeated.

           For example, in this example hhttttpp will invoke ssssllcclliieenntt with the
           two arguments _-_s_m and _b_o_b_o_._e_x_a_m_p_l_e_._c_o_m:

               % http -ssl-flags "-sm bobo.example.com" https://example.com

           If a wildcard server certificate is used, it may be necessary to
           explicitly match all hosts within a specific domain:

               % http -ssl-flags "-sm .*\.example\.com" https://example.com


               IImmppoorrttaanntt
               When called by hhttttpp, error messages produced by ssssllcclliieenntt may
               be lost. If you encounter problems with SSL operation, work
               with ssssllcclliieenntt((11))[13] to ensure that an SSL connection can be
               established, or to determine and resolve the problem. If you
               discover that ssssllcclliieenntt requires command line flags for proper
               operation, you will need to make sure that hhttttpp passes those
               flags to it.

       --uusseerr--aaggeenntt _s_t_r_i_n_g
           Set the User-Agent request-header to _s_t_r_i_n_g. If not provided, this
           string will have the prefix "DACS-http/", followed by a DDAACCSS
           release identifier (example: "DACS-http/1.4.1").

       --vv
           Increase the level of debugging output. This will cause response
           headers to be displayed, for example. The flag may be repeated.

       ----vveerrssiioonn
           Print version information to stderr, then exit immediately.

       The _u_r_i argument is the URL to invoke. It may include a query string
       suffix (even if HTTP POST is selected).

       Whether selected implicitly or explicitly, the command line must
       specify exactly one of the HTTP methods.

       Request headers specified using the --hheeaaddeerr or --hheeaaddeerrss flags are sent
       in the order in which the flags appear on the command line. If they are
       read from a file, there ordering is maintained.

EEXXAAMMPPLLEESS
       The following will retrieve RRFFCC 22661166[2] and save it in rfc2616.txt:

           % http "http://www.rfc-editor.org/rfc/rfc2616.txt" > rfc2616.txt

       This will do a GET on the given URL, passing the query string _f_o_o_=_b_a_z,
       and writing the result to stdout:

           % http "https://example.com/cgi-bin/dacs/dacs_prenv?foo=baz"

       This will do a POST on the given URL, passing two arguments:

           % http -p foo baz -p bar zork https://example.com/cgi-bin/dacs/dacs_prenv

       This will make an HTTP GET method request over SSL to the given URL:

           % http -ssl "/usr/local/dacs/bin/sslclient example.com:443" \
               https://example.com/cgi-bin/dacs/dacs_prenv

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       Use of an SSL provider other than ssssllcclliieenntt((11))[13] is officially
       deprecated. Recent development makes it doubtful that any other program
       will function properly with hhttttpp.

       It is only a partial implementation of RRFFCC 22661166[2] (HTTP 1.0). It only
       talks HTTP (no other URI schemes are supported). Received cookies are
       discarded, there is no support for RRFFCC 22661177[14] authentication, and no
       client-side caching is performed.  hhttttpp should not require an external
       program to provide SSL functionality. The program is a bit confused
       about when it should be able to send a message body.

SSEEEE AALLSSOO
       ssssllcclliieenntt((11))[13], llyynnxx((11))[15], ccuurrll((11))[16], WWggeett((11))[17], RRFFCC 11773388[18],
       RRFFCC 22339966[19], RRFFCC 22661166[2], RRFFCC 33998866[20]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[21])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[22] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

        3. HTTP_PROG
           http://dacs.dss.ca/man/dacs.conf.5.html#HTTP_PROG

        4. SSL_PROG
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG

        5. SSL_PROG_ARGS
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG_ARGS

        6. SSL_PROG_CA_CRT
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG_CA_CRT

        7. SSL_PROG_CLIENT_CRT
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG_CLIENT_CRT

        8. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        9. Netscape spec
           http://web.archive.org/web/20070805052634/http://wp.netscape.com/newsref/std/cookie_spec.html

       10. RFC 2109
           http://www.rfc-editor.org/rfc/rfc2109.txt

       11. RFC 2965
           http://www.rfc-editor.org/rfc/rfc2965.txt

       12. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       13. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

       14. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

       15. lynx(1)
           http://lynx.isc.org

       16. curl(1)
           http://directory.fsf.org/All_Packages_in_Directory/cURL.html

       17. Wget(1)
           http://www.gnu.org/software/wget/wget.html

       18. RFC 1738
           http://www.rfc-editor.org/rfc/rfc1738.txt

       19. RFC 2396
           http://www.rfc-editor.org/rfc/rfc2396.txt

       20. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

       21. www.dss.ca
           http://www.dss.ca

       22. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                           HTTP(1)
