DACSTOKEN(1)                 DACS Commands Manual                 DACSTOKEN(1)



NNAAMMEE
       dacstoken - administer hash-based one-time passwords

SSYYNNOOPPSSIISS
       ddaaccssttookkeenn [ddaaccssooppttiioonnss[1]] [--aallll] [--bbaassee _n_u_m] [--ccoouunntteerr _n_u_m]
                 [--ddiiggiittss _n_u_m]
                 [--ddiissaabbllee | --eennaabbllee] [--hhoottpp--wwiinnddooww _n_u_m] [--iinnkkeeyyss _i_t_e_m___t_y_p_e]
                 [[--kkeeyy _k_e_y_v_a_l] | [--kkeeyy--ffiillee _f_i_l_e_n_a_m_e] | [--kkeeyy--pprroommpptt]]
                 [--mmooddee _o_t_p_-_m_o_d_e] [--oouuttkkeeyyss _i_t_e_m___t_y_p_e]
                 [[--ppiinn _p_i_n_v_a_l] | [--ppiinn--ffiillee _f_i_l_e_n_a_m_e] | [--ppiinn--pprroommpptt]]
                 [--ppiinn--ccoonnssttrraaiinnttss _s_t_r]
                 [--rrnndd] [--sseeeedd _s_t_r] [--sseerriiaall _s_t_r] [--ttoottpp--ddeellttaa _n_u_m]
                 [--ttoottpp--ddrriifftt _n_w_i_n_d_o_w_s] [--ttoottpp--hhaasshh _a_l_g]
                 [--ttoottpp--ttiimmeesstteepp _s_e_c_s] [--vvffss _v_f_s___u_r_i] [_o_p_-_s_p_e_c] [_u_s_e_r_n_a_m_e]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssttookkeenn utility administers DDAACCSS accounts associated with
       one-time password (OTP) generating devices (_t_o_k_e_n_s) or software-based
       clients. Using command line options, it also computes OTP values; token
       account parameters can be overridden, but accounts are not even
       required.

       Strong, two-factor authentication can be provided when
       ddaaccss__aauutthheennttiiccaattee[2] is configured to use the
       llooccaall__ttookkeenn__aauutthheennttiiccaattee[3] authentication module or when ddaaccssttookkeenn is
       used as a standalone program to validate passwords. Both the HMAC-based
       one-time password mode (HOTP), based on an event counter and specified
       by RRFFCC 44222266[4], and the time-based one-time password mode (TOTP), as
       specified by the llaatteesstt IIEETTFF IInntteerrnneett--DDrraafftt[5] proposal, are supported.
       AAddddiittiioonnaall ooppeerraattiioonnaall mmooddeess[6] called OCRA (_O_A_T_H _C_h_a_l_l_e_n_g_e_-_R_e_s_p_o_n_s_e
       _A_l_g_o_r_i_t_h_m_s), described in an IETF Internet-Draft, are not yet fully
       supported.

           NNoottee
           This version of ddaaccssttookkeenn incorporates many changes that are not
           backward compatible with release 1.4.24a and earlier. Some command
           line flags function differently, and the format of the account file
           has changed. If you have used this command in earlier releases,
           please make a backup copy of your token account file and review
           this manual page carefully before proceeding (note the --ccoonnvveerrtt
           flag[7] in particular).

           IImmppoorrttaanntt
           No vendor-supplied software is required by ddaaccssttookkeenn to supply its
           functionality. The devices currently supported do not need any
           registration or configuration interaction with vendors and
           ddaaccssttookkeenn _d_o_e_s _n_o_t _i_n_t_e_r_a_c_t _w_i_t_h _v_e_n_d_o_r_s_' _s_e_r_v_e_r_s _o_r _u_s_e _a_n_y
           _p_r_o_p_r_i_e_t_a_r_y _s_o_f_t_w_a_r_e. Vendor-supplied software may be required to
           perform initialization or configuration for other token devices,
           however, and ddaaccssttookkeenn does not provide such support for them.

       Each token device generally corresponds to exactly one account that is
       managed by ddaaccssttookkeenn, although some vendors produce tokens that can
       support multiple accounts.

       To summarize, this utility:

       +o   creates and administers DDAACCSS accounts associated with counter-based
           and time-based one-time passwords

       +o   provides validation and testing functionality

       +o   provides a command line authentication capability


           SSeeccuurriittyy
           Only the DDAACCSS administrator should be able to successfully run this
           program from the command line. Because DDAACCSS keys and configuration
           files, including the file used to store accounts, must be
           restricted to the administrator, this will normally be the case,
           but a careful administrator will set file permissions to deny
           access to all other users.

           NNoottee
           The ddaaccss__ttookkeenn((88))[8] web service provides users with limited
           self-service functionality to set or reset their account PIN and
           synchronize their token. It also has a demonstration mode to
           simplify testing and evaluation.

   PPIINNss ((AAccccoouunntt PPaasssswwoorrddss))
       A ddaaccssttookkeenn account can optionally have a PIN (i.e., a password)
       associated with it. To authenticate against such an account, a user
       must provide the one-time password produced by the token _a_n_d the PIN.
       The TTOOKKEENN__RREEQQUUIIRREESS__PPIINN[9] configuration directive determines whether a
       PIN must be provided when creating or importing an account; it does not
       apply in conjunction with the --ddeellppiinn flag, since only an administrator
       should be able to perform that function.

       A hash of the PIN is stored in the account record rather than the PIN
       itself. The same method used by ddaaccssppaasssswwdd((11))[10] and
       ddaaccss__ppaasssswwdd((88))[11] is applied, and depends on the PPAASSSSWWOORRDD__DDIIGGEESSTT[12]
       and PPAASSSSWWOORRDD__SSAALLTT__PPRREEFFIIXX[13] directives in effect. If
       PPAASSSSWWOORRDD__DDIIGGEESSTT[12] is configured, that algorithm is used, otherwise a
       compile-time default (SHA1) is used. If a user forgets the PIN, the old
       one cannot be recovered so it must either be deleted or a new one must
       be set.

       Some token devices have a PIN capability built into them. The user must
       enter a PIN into the device before the device will emit a one-time
       password. This "device PIN" is completely distinct from the account PIN
       that is managed by ddaaccssttookkeenn, and this manual is only concerned with
       the ddaaccssttookkeenn PIN. The device PIN should always be used when possible;
       the ddaaccssttookkeenn PIN is strongly recommended and is required for
       two-factor authentication (unless an additional authentication factor
       is applied in some other way).

       Since only the administrator is allowed to run this command, no
       restrictions are imposed on the length or quality of the PINs that the
       administrator supplies; a warning message will be emitted, however, if
       the password is considered to be weak as determined by the
       PPAASSSSWWOORRDD__CCOONNSSTTRRAAIINNTTSS[14] directive.

   OOnnee--TTiimmee PPaasssswwoorrddss
       Both kinds of one-time password device compute a password value by
       employing a secure keyed hash algorithm (RRFFCC 22110044[15], FFIIPPSS 119988[16]).
       In the counter-based method, the device and server share a secret key
       and a counter value which are hashed to yield a numerical value
       displayed in a certain radix with a certain number of digits.
       Successful authentication requires the device and server to compute
       matching passwords. Each time the device produces a password, it
       increments its counter. When the server receives a matching password,
       it increments its counter. Because it is possible for the two counters
       to become unsynchronized, the server's matching algorithm will
       typically allow a client's password to fall within a "window" of
       counter values. The time-based method is similar, the main difference
       being that the current Unix time (as returned by ttiimmee((33))[17], for
       instance) is used to establish a "time-step window" that serves as a
       counter value in the computation of the secure hash. Because the
       real-time clocks on the device and server may not be sufficiently
       synchronized, the server's matching algorithm must also allow a
       client's password to fall within some number of time-step windows for
       these devices.

           SSeeccuurriittyy
           A token may be assigned a permanent secret key (sometimes called an
           OTP seed) by its manufacturer or the key may be programmable. This
           secret key is used by the token's password generation procedure and
           it is critical that it be kept private. If the token is not
           programmable, the key is obtained from the vendor (for a HOTP
           token, typically by providing the device's serial number and any
           three consecutive passwords). A record of each mapping from serial
           number to secret key should be kept in a secure location.

           If the secret key is programmable, as it is likely to be with a
           software client, it is required to be at least 112288 bits in length;
           a minimum of 116600 bbiittss is recommended. The key is represented by a
           16 (or more) character long hexadecimal string. The key should be
           obtained from a cryptographic-quality source of random bits. Some
           clients may be capable of generating a suitable key, but you may
           use ddaaccsseexxpprr((11))[18]:

               % dacsexpr -e "random(string, 20)"
               "bb2504780e8075a49bd88891b228fc7216ac18d9"

           TTiipp
           Tokens can be used for authentication purposes other than computer
           sign on. For example, by providing an account number, PIN, and
           token value, customers can quickly be authenticated over the phone,
           reducing or eliminating the need for expensive and time-consuming
           security questions.

       One-time password devices and applications have the following
       operational parameters. These parameters determine the password
       sequence that is generated. Some operational parameters may be fixed
       (by the relevant standard or due to the implementation), while others
       may be partially or completely configurable by the user. Please refer
       to the references and manufacturers' documentation for details.

       base
           The radix in which passwords are displayed.

       counter
           For HOTP mode only, the current counter value.

       digits
           The number of digits in each one-time password.

       key
           The secret key (OTP seed).

       serial number
           A unique identifier or name for the device.

       time step size
           For TOTP mode only, the width of each time interval, in seconds.
           The same password will be generated within a given interval; i.e.,
           this is the "lifetime" or validity period of each TOTP password.

       In addition to these parameters, ddaaccssttookkeenn employs several per-account
       (i.e., per-device) parameters:

       accept-window
           When validating a HOTP password, the maximum number of passwords to
           consider after the expected password.

       drift
           For TOTP mode only, the number of seconds by which to adjust the
           server's clock forward or backward to better synchronize it with
           the device. This is used to compensate for tokens or client
           software whose clocks are not well synchronized with the server's.

       drift-window
           For TOTP mode only, but analogous to the accept-window, the maximum
           number of intervals (each of the time step size) to search forward
           and backward when validating against a given password.

       sync-otps
           For HOTP mode only, the number of consecutive one-time passwords
           required to synchronize the account with the device.

       username
           The name of the DDAACCSS account bound to the device.

       Authentication based on one-time password devices has the following
       advantages:

       +o   Each time a user authenticates, a different password will be
           generated (with high probability); users cannot therefore jot down
           "the password" because the password is always changing; users
           cannot forget their password;

       +o   Once used, a HOTP mode password is immediately "consumed" and is
           unlikely to be used again for a long time; with suitable
           configuration parameters, a TOTP mode password automatically
           "expires" within a relatively short time interval and is unlikely
           to be used again for a long time;

       +o   If no correction for clock drift is required, a TOTP mode account
           can have read-only operation;

       +o   Because the password is unlikely to be an easily-guessed number or
           string, it should be stronger than most user-selected passwords;

       +o   A HOTP token can be the basis of a mutual ("bidirectional")
           authentication method; the server shows the user his token's next
           password to confirm its identity (with both parties advancing their
           counters), then the client shows the server the next password to
           confirm his identity;

       +o   Should a key sniffer be installed on the user's computer, a sniffed
           password does not do an attacker any good unless a
           mmaann--iinn--tthhee--mmiiddddllee aattttaacckk[19] is possible; given _N consecutive
           passwords it is still very difficult to compute password _N _+ _1
           without knowing the secret key;

       +o   It is more difficult for users to share an account (although users
           might sometimes view this as an inconvenience);

       +o   If a ddaaccssttookkeenn PIN is assigned to an account and an attacker
           obtains the account's token, it is still difficult for the attacker
           to authenticate without knowing the PIN;

       +o   A quick and immediately effective way to disable an account is by
           simply seizing a hardware token (e.g., if an employee is fired),
           although an account can be disabled by this program or using the
           rreevvooccaattiioonn lliisstt[20];

       +o   In the case of a software client that runs on a mobile device, such
           as a phone or PDA, users are already carrying the device with them;
           free clients are available, so there may be no additional cost
           (note that mobile devices may not offer the same tamper-resistance,
           durability, key secrecy, clock accuracy, etc. of a hardware token).


       One-time password devices have the following potential disadvantages:

       +o   There is a one-time expense for a hardware token (depending on the
           purchase volume, you can expect to pay $10-$100 USD each), and
           there is the possibility of having to replace a lost or broken
           token, or a token's battery (some units have a non-replaceable
           battery, making them disposable after a few years);

       +o   Initial configuration is somewhat more difficult than with other
           authentication methods, and users unfamiliar with the devices will
           have to be instructed on their use;

       +o   Although they are typically quite small (e.g., 5cm x 2cm x 1cm) and
           can be attached to a keychain or lanyard, or kept in a wallet,
           users may wince at having to carry a token around with them;

       +o   Users can forget to have their token with them or lose the token;

       +o   A mobile device (with a software client) is probably a likely
           target for theft, more so than a hardware token (hence the extra
           importance of a PIN for this device);

       +o   Unlike a hardware token where the key is burned into inaccessible,
           tamper-proof memory, the key configured into a software client is
           likely to be readable by its owner, making sharing of the account
           possible;

       +o   Entering a 40 character or longer seed value into a mobile device
           can be frustrating and prone to error;

       +o   Once a TOTP device generates a password, a new password cannot be
           generated until the next time-step window, requiring the user to
           wait 30 (or possibly 60) seconds (e.g., if an entry error is made);

       +o   Some devices are difficult to read in low-light conditions;
           presbyopic users and those with impaired vision may have difficulty
           reading the display.


   AAccccoouunnttss
       The accounts managed by ddaaccssttookkeenn are completely separate from the
       accounts used by llooccaall__ppaasssswwdd__aauutthheennttiiccaattee[21] or any other DDAACCSS
       authentication module.

       Accounts for HOTP and TOTP devices may either be combined or kept
       separate. If the virtual filestore item type auth_hotp_token is
       defined, it is only used for accounts associated with HOTP tokens.
       Similarly, if the virtual filestore item type auth_totp_token is
       defined, it is only used for accounts associated with TOTP tokens. If
       either item type is not defined, accounts are accessed through DDAACCSS''ss
       virtual filestore using item type auth_token. It is assumed that file
       permissions on the account databases are such that all access is
       limited to the administrator and llooccaall__ttookkeenn__aauutthheennttiiccaattee.

       If accounts for the two device types are _c_o_m_b_i_n_e_d, because each
       username for an authentication method must be unique, if an individual
       has both types of token they must be assigned different usernames. So,
       for example, if Auggie has one HOTP token and one TOTP token, the
       former might correspond to the username auggie-hotp and the latter to
       auggie-totp; the sign-on form might include a device-mode input which
       would allow Auggie to simply type "auggie" in the username field and
       JavaScript to automatically append the appropriate suffix based on the
       select device mode. An obvious disadvantage of this configuration is
       that it results in two different DDAACCSS identities for the same
       individual; this would have to be remembered if an access control rule
       needed to identify Auggie explicitly. If both tokens should map to the
       same DDAACCSS identity, the Auth clause could strip the suffix off after
       successful authentication, but the administrator would then need to
       beware of the case of two different Auggies, each using a different
       device type.

       Configuring both the auth_hotp_token and auth_totp_token item types (or
       just one of them and auth_token) keeps the accounts separate and allows
       the same username to be used for both types of devices. Auggie could
       therefore have an account record with the same username for both device
       types. This approach requires the device mode to be specified when an
       operation is requested so that the correct item type can be used; this
       means that users must know which type of device they are using (perhaps
       by afixing a label to it). Refer to important details regarding DDAACCSS
       identities[22].

       The --vvffss is used to configure or reconfigure the auth_token item type.

       Only keys that meet the minimum key length requirement (1166 bytes) may
       be stored with account information (e.g., with --sseett or --iimmppoorrtt). In
       other contexts, the requirement is not enforced.

       The secret key is encrypted by ddaaccssttookkeenn when it is written to the
       account file. The virtual filestore item type auth_token_keys
       identifies the encryption keys for ddaaccssttookkeenn to use; the --iinnkkeeyyss and
       --oouuttkkeeyyss flags specify alternatives (see ddaaccsskkeeyy((11))[23]). If the
       encryption keys are lost, the secret keys are practically
       unrecoverable.

           IImmppoorrttaanntt
           If an attacker discovers a secret key, generating usable passwords
           without possessing the token will not be difficult. For at least
           some hardware tokens, the key is burned in to the device and cannot
           be changed; in this case, if the key is leaked the device should be
           destroyed. If a token is lost, the corresponding account should be
           disabled. In the event an attacker finds a lost token or discovers
           a secret key, having a strong PIN associated with the account will
           make it difficult for the attacker to gain access.

           IImmppoorrttaanntt
           +o   This authentication method has been tested against the
               following OTP products:

               +o   AAuutthheenneexx AA--KKeeyy((RR)) 33660000[24] one-time password (HOTP)
                   hardware token;

               +o   FFeeiittiiaann TTeecchhnnoollooggiieess[25] OTP C100 and OTP C200 one-time
                   password hardware tokens, provided by HHyyppeerrSSeeccuu IInnffoorrmmaattiioonn
                   SSyysstteemmss[26]; and

               +o   OOAATTHH TTookkeenn[27] software application by Archie Cobbs, which
                   implements both HOTP and TOTP on the iiPPoodd TToouucchh,, iiPPhhoonnee,,
                   aanndd iiPPaadd[28].

               +o   Feitian Technologies iiOOAATTHH LLiittee[29] HOTP software
                   application for the iPod Touch, iPhone, and iPad.
                   Other manufacturers interested in having their products
                   supported by DDAACCSS are welcome to contact Dss.

               +o    PPhhoottoo[30]: Feitian OTP C200, iPod Touch with the OATH
                   Token app, Authenex A-Key(R) 3600 (clockwise from top left)

               +o   Although this implementation should work with similar,
                   conformant products, only these products are officially
                   supported by DDAACCSS.

               +o   Hardware tokens can be purchased directly from the vendors.

               +o   Any problems with using tokens to authenticate through DDAACCSS
                   are not the responsibility of the token vendor.

   IImmppoorrttiinngg aanndd EExxppoorrttiinngg OOTTPP AAccccoouunnttss
       Descriptions of accounts and their tokens can be loaded or dumped
       (refer to the --iimmppoorrtt and --eexxppoorrtt flags). This simplifies bulk
       provisioning, backup, and portability. The account information is
       written in a simple, application-specific (almost) XML format.

       The format understood by ddaaccssttookkeenn consists of a root element
       ("otp_tokens"), followed by zero or more "otp_token" elements, one per
       line, each with required and optional attributes (described below). The
       XML declaration must be omitted. Leading whitespace and blank lines are
       ignored, as are single line XML comments. Additionally, lines having a
       "#" as the first non-whitespace character are ignored. Optional
       attributes that are not present are assigned default values. The
       default digest algorithm is SHA1. Short attribute names are used to
       save space. Unrecognized attributes, and attributes irrelevant to the
       device mode, are ignored. Single or double quote characters (or both)
       within XML attribute values must be replaced by the corresponding
       entity reference ("&apos;" and "&quot;", respectively), as must the "<"
       (less than) and "&" (ampersand) characters. A ">" (greater than)
       character may optionally be replaced by a "&gt;" sequence, but no other
       entity references are recognized.

       Recognized attributes are:

       +o   b:
             _b_a_s_e
             -- radix for OTP value
             [Optional:
             1100 (default),
             1166, or 3322]

       +o   c:
             _c_o_u_n_t_e_r
             -- current counter value for HOTP, in hex if preceded
             by "0x" (or "0X"), decimal otherwise
             [Optional:
             default is 00]

       +o   d:
             _O_T_P _d_e_v_i_c_e _m_o_d_e
             -- "c" (for HOTP)
             or "t" (for TOTP)
             [Required]

       +o   dn:
             _d_i_g_e_s_t_-_n_a_m_e
             -- one of the Secure Hash Algorithms
             [Optional:
             SHA1 (default),
             SHA224, SHA256,
             SHA384, SHA512]

       +o   dr:
             _c_l_o_c_k_-_d_r_i_f_t
             -- clock adjustment, in seconds, for TOTP
             [Optional]

       +o   ek:
             _e_n_c_r_y_p_t_e_d_-_k_e_y
             -- encrypted secret key, base-64 encoded
             [Required:
             OTP account records only]

       +o   en:
             _e_n_a_b_l_e_d_-_s_t_a_t_u_s
             -- 11 for enabled,
             00 for disabled
             [Required]

       +o   k:
             _p_l_a_i_n_t_e_x_t_-_k_e_y
             -- unencrypted secret key
             [Required]

       +o   lu:
             _l_a_s_t_-_u_p_d_a_t_e
             -- Unix time of last record update
             [Optional: default is current time]

       +o   nd:
             _n_d_i_g_i_t_s
             -- number of digits for OTP value
             [Optional:
             default is 66 for HOTP,
             88 for TOTP]

       +o   p:
             _p_l_a_i_n_t_e_x_t_-_P_I_N
             -- plaintext PIN value for the account
             [Required:
             unless ph is present,
             for import only]

       +o   ph:
             _h_a_s_h_e_d_-_P_I_N
             -- hashed PIN value for the account
             [Optional:
             generated by ddaaccssttookkeenn
             for export and OTP account files only]

       +o   s:
             _s_e_r_i_a_l_-_n_u_m_b_e_r
             -- unique identifier string for the device
             [Required]

       +o   ts:
             _t_i_m_e_-_s_t_e_p
             -- time-step value, in seconds, for TOTP
             [Optional:
             default is 3300]

       +o   u:
             _u_s_e_r_n_a_m_e
             -- a valid DDAACCSS username associated with this account
             [Required]


       The following example describes two accounts that might be created
       using the --iimmppoorrtt flag:

           <otp_tokens>
           <!-- Staff OTP tokens for DACS authentication -->
           <otp_token u="ietf" d="t" en="1" s="totp-ietf &quot;draft&quot;" k="3132333435363738393031323334353637383930" dn="SHA1" ts="30"/>
           <otp_token u="ipod-c" d="c" en="1" s="ipodc-9C841SD4203" k="19c0a3519a89b4a8034c5b9306db" dn="SHA1" c="0" nd="6" b="10"/>
           </otp_tokens>


           SSeeccuurriittyy
           Because imported records include the unencrypted secret keys for
           the OTP devices, the exported file should be kept encrypted (e.g.,
           using ooppeennssssll) or at least have appropriate file permissions.

           NNoottee
           A standard format for OTP device provisioning is being developed.
           This format may be understood by a future version of ddaaccssttookkeenn, or
           a conversion utility may be written. The standard format is likely
           to be considerably more complex than the DDAACCSS format.

OOPPTTIIOONNSS
       In addition to the standard _d_a_c_s_o_p_t_i_o_n_s[1], a lengthy list of command
       line flags are recognized. When a _u_s_e_r_n_a_m_e is given, default values
       associated with that account are used, otherwise recommended or
       implementation-specific defaults are used. These default values can
       usually be overridden on the command line. Some flags are only allowed
       with a particular token mode (e.g., --ccoouunntteerr, --ttoottpp--sshhooww) and their
       appearance implies that mode, making the --mmooddee flag unnecessary; other
       flags are mode independent (e.g., --ddeelleettee, --eennaabbllee). It is an error to
       use a mutually incompatible flag combination. Flags that are
       meaningless with the selected operation are ignored, although they
       still imply a mode. Hexadecimal values are case insensitive. If a
       counter value is required but unspecified (e.g., when creating an
       account), an initial counter value of zero is used.

       The _o_p_-_s_p_e_c specifies the operation to be performed, together with zero
       or more _m_o_d_i_f_i_e_r flags. If _o_p_-_s_p_e_c is missing, the --lliisstt operation is
       performed. An _o_p_-_s_p_e_c is one of the following:


       --aauutthh _o_t_p_-_v_a_l_u_e
           This flag is like --vvaalliiddaattee[31], except:

           +o   a _u_s_e_r_n_a_m_e is required, from which all parameters are obtained
               (such as the key);

           +o   if the account has a PIN, it must be provided;

           +o   if the account is for a HOTP token, the counter will be updated
               if authentication is successful.
               An exit status of zero indicates successful authentication,
               while any other value means authentication failed.

           --ccoonnvveerrtt _f_i_l_e_n_a_m_e
               Load an older format (prior to release 1.4.25) token account
               file from _f_i_l_e_n_a_m_e ("-" means to read from stdin), convert it
               to the newer format, and write it to stdout (as by --eexxppoorrtt).
               This flag is deprecated and this capability will be removed in
               a future release of DDAACCSS.

           --ccrreeaattee
               Create an account for _u_s_e_r_n_a_m_e, which must not already exist.
               In other respects it works like --sseett[32]. When creating a new
               account, --sseerriiaall is required and --kkeeyy is implied. If no --eennaabbllee
               flag is provided when creating an account, --ddiissaabbllee is implied.
               If no --ccoouunntteerr flag is provided, a default of zero is used. If
               one of the PIN flags is present, the given PIN will be assigned
               to the account, otherwise the account will not have a PIN (or
               the existing PIN will not be changed).

           --ccuurrrreenntt
               Display the current moving factor (i.e., the counter value for
               HOTP or the interval value for TOTP) and expected OTP for
               _u_s_e_r_n_a_m_e. For HOTP, the counter is advanced. All parameters are
               taken from the account.

           --ddeelleettee
               Delete the account for _u_s_e_r_n_a_m_e. The device's secret key and
               other operational parameters will be lost.

           --ddeellppiinn
               Delete the PIN, if present, on the account for _u_s_e_r_n_a_m_e,
               leaving the account without a PIN.

           --eexxppoorrtt
               Write information about all accounts, or only one account if
               _u_s_e_r_n_a_m_e is given, to stdout. If a mode is selected, however,
               only accounts having that mode will be written. This
               information may be reloaded using --iimmppoorrtt or --iimmppoorrtt--rreeppllaaccee.
               The output should be stored in an encrypted form, or at the
               very least have its file permissions set appropriately. For
               example:

                   % dacstoken -uj EXAMPLE -export | openssl enc -aes-256-cbc > dacstoken-exported.enc

               Later, you might do something like:

                   % openssl enc -d -aes-256-cbc < dacstoken-exported.enc | dacstoken -uj EXAMPLE -import -


           --hh
           --hheellpp
               Display a help message and exit.

           --hhoottpp--sshhooww _n_u_m
               Display _n_u_m consecutive HOTP passwords from a given counter
               value and key. The --ccoouunntteerr flag can be used to specify an
               initial counter value. The key can be specified using --kkeeyy,
               --kkeeyy--ffiillee, or --kkeeyy--pprroommpptt. If a _u_s_e_r_n_a_m_e is provided, the
               initial counter value and key are obtained from the user's HOTP
               account, unless either value is overridden on the command line;
               the account's stored counter value is not modified. This is
               mainly intended for debugging purposes.

           --iimmppoorrtt _f_i_l_e_n_a_m_e
           --iimmppoorrtt--rreeppllaaccee _f_i_l_e_n_a_m_e
               Load account and token information from _f_i_l_e_n_a_m_e; if _f_i_l_e_n_a_m_e
               is "-", stdin is read. If a mode is selected, only accounts
               having that mode will be read. With --iimmppoorrtt it is an error if
               an imported account already exists, and processing stops;
               --iimmppoorrtt--rreeppllaaccee will replace an existing account with imported
               data.

           --ll
           --lliisstt
           --lloonngg
               If _u_s_e_r_n_a_m_e is provided, display information about the
               corresponding account; if the --sseerriiaall flag is given, display
               information about the account with the specified serial number;
               otherwise list all accounts. If the --mmooddee flag is given in any
               of these cases, however, list only those accounts that have the
               operational mode specified. If this flag is repeated, or with
               the --lloonngg flag, more detail is displayed: device type, account
               status, device serial number, counter value (for HOTP), clock
               drift value (for TOTP), whether or not the account has a PIN
               (indicated by a "+" or "-" symbol), and the time and date of
               the account's last modification.

           --rreennaammee _n_e_w_-_u_s_e_r_n_a_m_e
               Rename the existing account for _u_s_e_r_n_a_m_e to be _n_e_w_-_u_s_e_r_n_a_m_e,
               and modify the new account using command line arguments (as
               with --sseett[32]). As this requires two steps that are not done
               atomically, if an error occurs it is possible for the new
               account to be created and the old account to still exist.

           --sseett
               The --sseett flag is used to modify the existing account for
               _u_s_e_r_n_a_m_e based on one or more modifier arguments (--bbaassee,
               --ccoouunntteerr, --ddiiggiittss, --ddiissaabbllee or --eennaabbllee, --kkeeyy (or --kkeeyy--ffiillee or
               --kkeeyy--pprroommpptt), --ppiinn (or --ppiinn--ffiillee or --ppiinn--pprroommpptt), or --sseerriiaall).
               The mode can also be changed by specifying --mmooddee, but
               mode-specific parameters associated with the account will be
               lost (e.g., the current counter value will be deleted if a HOTP
               account is changed to a TOTP account) and general parameters
               (such as the serial number) will be retained unless overridden
               on the command line.

           --ssyynncc _p_a_s_s_w_o_r_d_-_l_i_s_t
               In HOTP mode, this attempts to synchronize the server with the
               token for _u_s_e_r_n_a_m_e. The _p_a_s_s_w_o_r_d_-_l_i_s_t is a comma-separated list
               of three successive passwords produced by the user's token
               (this "auto-synchronize" function is also available through
               llooccaall__ttookkeenn__aauutthheennttiiccaattee[3]). The given sequence must match the
               computed sequence _e_x_a_c_t_l_y, given the operational parameters in
               effect; e.g., leading zeroes are significant, as is the display
               radix and number of OTP digits in effect. If synchronization is
               successful, the user should be able to authenticate using the
               next password produced by the device. An exhaustive search
               algorithm using increasing counter values is employed, with a
               compile-time limit on the maximum number of computations. The
               search begins at the server's currently stored counter value,
               unless one is provided using --ccoouunntteerr. If unsuccessful, this
               operation could take a long time before it terminates; the user
               must contact an administrator for assistance.

               In TOTP mode, attempt to determine how closely synchronized the
               system clock is with the token's clock and display the result.
               This information can be used to update the user's token record
               to compensate for poorly synchronized clocks, or to adjust
               validation parameters. The token's key and the name of the
               digest algorithm are obtained for the token record belonging to
               _u_s_e_r_n_a_m_e, if it is given; otherwise the key is prompted for and
               the digest algorithm to use is either obtained from the command
               line or the default. Only the first password in _p_a_s_s_w_o_r_d_-_l_i_s_t
               is used. The --ttoottpp--ttiimmeesstteepp, --ddiiggiittss, and --ttoottpp--bbaassee options
               are effective during this operation.

           --tteesstt
               Perform some self-tests, then exit. A non-zero exit status
               means an error occurred.

           --ttoottpp--sshhooww _n_u_m
               Display a sequence of TOTP passwords using the parameters
               currently in effect: interval size (--ttoottpp--ttiimmeesstteepp), number of
               digits (--ddiiggiittss), and base (--bbaassee). The account's stored
               parameters are not modified. This is mainly intended for
               debugging purposes.

               If a _u_s_e_r_n_a_m_e is provided (it must be associated with a TOTP
               device), the key and other stored parameters from the account
               are used unless overridden by command line flags. The sequence
               of passwords for _n_u_m intervals before and after the current
               time, together with the password for the current time are
               printed.

               If no _u_s_e_r_n_a_m_e is given, the program prompts for the key (which
               is echoed) and uses command line flags or default values for
               parameters. It then emits the TOTP password for the current
               time each time Return/Enter is pressed. Typing EOF causes
               immediate termination.

           --vvaalliiddaattee _o_t_p_-_v_a_l_u_e
               If _o_t_p_-_v_a_l_u_e is the next expected one-time password, return an
               exit status of zero to indicate success; any other value
               indicates failure. If _u_s_e_r_n_a_m_e is given, parameters for
               validation, including the key, are obtained from that account
               unless overridden on the command line. The server's state is
               not changed; e.g., a HOTP counter is not advanced. If no
               _u_s_e_r_n_a_m_e is given, the --mmooddee flag must be used and the
               parameters required for that mode must be given, including a
               key. For HOTP mode, a counter value must be provided. For TOTP
               mode, command line parameters are effective during this
               validation.  ddaaccssttookkeenn will test whether _o_t_p_-_v_a_l_u_e validates
               against the parameters in effect.

           The following _m_o_d_i_f_i_e_r flags are understood:


           --aallll
               With --sseett and no _u_s_e_r_n_a_m_e, apply the changes to _a_l_l accounts.
               This can be used to enable or disable all accounts, for
               example. The --iinnkkeeyyss and --oouuttkkeeyyss flags are honoured. If an
               error occurs processing stops immediately, in which case only
               some accounts may have been modified.

           --bbaassee _n_u_m
               Use _n_u_m as the base (radix) when displaying an OTP. The value
               of _n_u_m is restricted to 1100 (the default), 1166, or 3322.

           --ccoouunntteerr _n_u_m
               This is the 8-byte HOTP counter value to set, expressed as a
               hex value if preceded by by "0x" (or "0X"), decimal otherwise.
               Leading zeroes may be elided. This implies HOTP mode. For token
               devices, it should not be possible to reset a counter (modulo
               counter overflow) because that will result in the password
               sequence being repeated, assuming that the key is not changed;
               software implementations might not have this restriction,
               however, so beware of the security implications.

           --ddiiggiittss _n_u_m
               Use _n_u_m digits when displaying an OTP. The value of _n_u_m is
               restricted to 66, 77, 88 (the default), or 99 with base 1100. It is
               restricted to 66 with base 3322 and is ignored with base 1166 (hex
               output).

           --ddiissaabbllee
               Disable the account for _u_s_e_r_n_a_m_e. The llooccaall__ttookkeenn__aauutthheennttiiccaattee
               module, and --aauutthh and --vvaalliiddaattee flags, will not allow the user
               to authenticate until the account has been enabled, although
               other operations may still be performed on the account. If
               --eennaabbllee is subsequently used, the account will become usable
               for authentication and is restored to its state at the time it
               was disabled. It is not an error to disable an already disabled
               account.

           --eennaabbllee
               Enable the account for _u_s_e_r_n_a_m_e. The llooccaall__ttookkeenn__aauutthheennttiiccaattee
               module will allow the user to authenticate. It is not an error
               to enable an already enabled account.

           --hhoottpp--wwiinnddooww _n_u_m
               If the expected HOTP password does not match the given
               password, try to match up to _n_u_m passwords after the expected
               password in the sequence. A value of zero for _n_u_m disables this
               search.

           --iinnkkeeyyss _i_t_e_m___t_y_p_e
               For decrypting secret keys, use the store identified by
               _i_t_e_m___t_y_p_e, presumably configured in dacs.conf.

           --kkeeyy _k_e_y_v_a_l
               Use _k_e_y_v_a_l as the secret key, expressed as a hex digit string.

                   SSeeccuurriittyy
                   Supplying a key on the command line is not secure because
                   it may be visible to other processes.

           --kkeeyy--ffiillee _f_i_l_e_n_a_m_e
               Read the secret key, expressed as a hex digit string, from
               _f_i_l_e_n_a_m_e. If _f_i_l_e_n_a_m_e is "-", the key is read from stdin.

           --kkeeyy--pprroommpptt
               Prompt for the secret key, expressed as a hex digit string. The
               input is not echoed.

           --mmooddee _o_t_p_-_m_o_d_e
               This specifies (case insensitively) the type of token (the OTP
               device mode) for use with --sseett, --ccrreeaattee, and validation and
               synchronization operations. The _o_t_p_-_m_o_d_e may be either counter
               or hotp for counter mode, or time or totp for time-based mode.
               This flag is required when creating a new account.

           --oouuttkkeeyyss _i_t_e_m___t_y_p_e
               For encrypting secret keys, use the store identified by
               _i_t_e_m___t_y_p_e, presumably defined in dacs.conf.

           --ppiinn _p_i_n_v_a_l
               Use _p_i_n_v_a_l as the secret PIN for the account.

                   SSeeccuurriittyy
                   Supplying a PIN on the command line is not secure because
                   it may be visible to other processes.

           --ppiinn--ccoonnssttrraaiinnttss _s_t_r
               Instead of using PPAASSSSWWOORRDD__CCOONNSSTTRRAAIINNTTSS[14], use _s_t_r (having the
               same syntax and semantics) to describe the requirements for a
               PIN.

                   NNoottee
                   Requirements for a PIN apply to PINs obtained via a command
                   line flag and to those obtained through importing (using
                   the "p" attribute). Requirements are not "retroactive",
                   however, so changing the requirements does not affect the
                   PINs of existing accounts or importing accounts that were
                   previously exported (having a "ph" attribute).

           --ppiinn--ffiillee _f_i_l_e_n_a_m_e
               Read the secret PIN from _f_i_l_e_n_a_m_e. If _f_i_l_e_n_a_m_e is "-", the PIN
               is read from stdin.

           --ppiinn--pprroommpptt
               Prompt for the secret PIN. The input is not echoed.

           --rrnndd
               Reserved for future use.

           --sseeeedd _s_t_r
               Reserved for future use.

           --sseerriiaall _s_t_r
               The serial number, _s_t_r, is a (purportedly) unique identifier
               assigned to the token. This option is used with the --sseett,
               --ccrreeaattee, and --lliisstt flags. A serial number identifies a specific
               OTP device and need not be kept secret. The uniqueness property
               is enforced within an item type storage unit; that is, serial
               numbers of all HOTP devices must be unique, serial numbers of
               all TOTP devices must be unique, and if accounts for the two
               device types are combined, all device serial numbers must be
               unique. Any printable string is accepted. If a software client
               is generating passwords, you may use the device's serial
               number, or choose any suitably descriptive string not already
               assigned to a device.

                   NNoottee
                   A jurisdiction that allows (or may eventually allow) both
                   hardware tokens and software-generating client applications
                   should consider adopting a formalized naming scheme for its
                   tokens. For example, the administrator might append "-hw"
                   to the vendor's serial number to form the ddaaccssttookkeenn serial
                   number. For software tokens, the administrator might create
                   a ddaaccssttookkeenn serial number by appending "-sw" to the
                   vendor's serial number for the device.

           --ttoottpp--ddeellttaa _n_u_m
               Adjust the base time by _n_u_m intervals (each of the step size
               number of seconds) when computing a TOTP. The _n_u_m may be
               negative, zero, or positive. This is used to correct for
               inadequately synchronized clocks.

           --ttoottpp--ddrriifftt _n_w_i_n_d_o_w_s
               For TOTP, use a window size of _n_w_i_n_d_o_w_s (in terms of the
               interval size) for validation. If _n_w_i_n_d_o_w_s is 00, the computed
               TOTP value must match the given one exactly. If _n_w_i_n_d_o_w_s is 11,
               for example, ddaaccssttookkeenn will try to match the given TOTP value
               in the previous, current, and next intervals. This allows the
               clocks in the system running ddaaccssttookkeenn (or
               llooccaall__ttookkeenn__aauutthheennttiiccaattee) and token producing device to be less
               well synchronized.

                   SSeeccuurriittyy
                   Although it compensates for poorly synchronized clocks,
                   increasing the value of _n_w_i_n_d_o_w_s weakens the system by
                   extending the lifetime of a one-time password.

           --ttoottpp--hhaasshh _a_l_g
               Use _a_l_g as the digest algorithm with TOTP. The value of _a_l_g is
               restricted to (case insensitively) SHA1 (the default), SHA256,
               or SHA512.

           --ttoottpp--ttiimmeesstteepp _s_e_c_s
               Use _s_e_c_s as the interval size when computing a TOTP. It must be
               greater than zero. The default is 3300 seconds.

                   SSeeccuurriittyy
                   Although it compensates for poorly synchronized clocks,
                   increasing the value of _s_e_c_s weakens the system by
                   extending the lifetime of a one-time password.

           --vvffss _v_f_s___u_r_i
               Use _v_f_s___u_r_i to override the VVFFSS[33] configuration directive in
               effect. This can be used to configure or reconfigure
               auth_token, auth_hotp_token, or auth_totp_token to specify the
               storage method for the accounts being acted upon.

           Apart from error messages, which are printed to the standard error,
           all output goes to the standard output.

           Ordinarily, a _d_a_c_s_o_p_t_i_o_n will be specified to select the
           jurisdiction on behalf of which accounts are being managed.

EEXXAAMMPPLLEESS
       These examples assume that the jurisdiction name to use is EXAMPLE and
       its federation domain is example.com.

       To use this authentication method, a DDAACCSS administrator might perform
       the following steps for each OTP device assigned to a user:

        1. Obtain a supported token, review how it is used for authentication,
           and select values for the various parameters. Obtain the secret key
           for the device from the vendor; for a programmable device, select a
           suitable random key and program it into the device. The current
           counter values might also be obtained from the vendor, although it
           is likely to initialized to zero; for a programmable device, set
           the counter value to zero. Decide whether a PIN will be required
           (see TTOOKKEENN__RREEQQUUIIRREESS__PPIINN[9]). If a software client is being used,
           install the software on the user's device (or have the user do so),
           and configure the software.

        2. Decide where the account information will be stored and, if
           necessary, add a suitable VVFFSS[33] directive to dacs.conf. The
           default (found in site.conf) maintains the account information in a
           file named auth_tokens within each jurisdiction's default private
           area:

               VFS "[auth_token]dacs-kwv-fs:${Conf::FEDERATIONS_ROOT}/\
               ${Conf::FEDERATION_DOMAIN}/${Conf::JURISDICTION_NAME}/auth_tokens"


        3. Generate keys to encrypt the account information (see TTookkeennss aanndd
           sseeccrreett kkeeyyss[34]) and decide where they will be stored; for example
           (your user ID, group ID, path, jurisdiction name, and federation
           domain may vary):

               % cd /usr/local/dacs/federations_root/example.com/EXAMPLE
               % dacskey -uj EXAMPLE -q auth_token_keys
               % chgrp www auth_token_keys
               % chmod 0640 auth_token_keys

           If necessary, add a suitable VVFFSS[33] directive to dacs.conf; the
           default, which is used above, maintains the account information in
           a file named auth_token_keys within each jurisdiction's default
           private area:

               VFS "[auth_token_keys]dacs-fs:${Conf::FEDERATIONS_ROOT}/\
               ${Conf::FEDERATION_DOMAIN}/${Conf::JURISDICTION_NAME}/auth_token_keys"


        4. If you need users to sign on through ddaaccss__aauutthheennttiiccaattee((88))[2], you
           must configure a suitable Auth clause in dacs.conf, for example:

               <Auth id="token">
                 URL "token"
                 STYLE "pass"
                 CONTROL "sufficient"
               </Auth>


        5. There are several ways that an administrator might proceed,
           depending on how much of the effort can be done by users (e.g.,
           whether they can be trusted, their technical ability), how many
           users there are (a few, or thousands), and the level of security
           required.

            1. prepare a file containing an XXMMLL rreeccoorrdd[35] for each account to
               be created; if PINs are to be used, assign a random PIN to each
               account;

            2. use the --iimmppoorrtt[36] flag to create the accounts;

            3. give the token device, username, and (if necessary) initial PIN
               to the user (perhaps verifying identity), providing any
               necessary demonstration and instructions;

            4. have the user set or reset the PIN for the account, and ask the
               user to sign on using the token to confirm correct operation.


       To create a disabled account for user bobo for a HOTP device:

           % dacstoken -uj EXAMPLE -mode hotp -serial 37000752 -key-file bobo.key -create bobo

       The secret key for the account (which must not already exist) is read
       from the file bobo.key. New accounts are disabled by default; use
       --eennaabbllee to create an enabled account.

       Once an account has been created, it can be synchronized with the
       token. To synchronize the HOTP token for user bobo:

           % dacstoken -uj EXAMPLE -sync 433268,894121,615120 bobo

       In this example, the particular token produced the three consecutive
       passwords 433268, 894121, and 615120. Note that the password sequence
       string that follows the --ssyynncc flag is a single argument that cannot
       have any embedded spaces. If the key for this token is
       19c0a3519a89b4a8034c5b9306db, the next password generated by this token
       should be 544323 (with counter value 1133). This can be verified using
       --hhoottpp--sshhooww:

           % dacstoken -hotp-show 5 -counter 10 -key 19c0a3519a89b4a8034c5b9306db
           000000000000000a: 433268
           000000000000000b: 894121
           000000000000000c: 615120
           000000000000000d: 544323
           000000000000000e: 002442

       To enable the account for user bobo:

           % dacstoken -uj EXAMPLE -enable -set bobo

       To both set the PIN and enable the account for user bobo:

           % dacstoken -uj EXAMPLE -enable -pin "CzAy" -set bobo

       To list all accounts in detail:

           % dacstoken -uj EXAMPLE -long

       The --lliisstt flag is redundant because it is the default operation. The
       --mmooddee, --ccoouunntteerr, etc. modifiers have no effect when listing.

       To list only the account for bobo:


           % dacstoken -uj EXAMPLE -list bobo

       The exit status will be non-zero if this user does not have an account.

       To display the account for the device with serial number 37000752:

           % dacstoken -uj EXAMPLE -serial 37000752

       The serial number, which should uniquely identify a token, is often
       printed on the token or can be displayed by the token.

       To set the counter value for the existing account of bobo:

           % dacstoken -uj EXAMPLE -counter 9 -set bobo

       This operation might be used for testing or with a software token. The
       --ssyynncc operation is more appropriate for a hardware token.

       To change the PIN for username bobo:

           % dacstoken -uj EXAMPLE -pin-prompt -set bobo

       The program will prompt for the new PIN.

       To use an alternate account file, /secure/auth_tokens:

           % dacstoken -uj EXAMPLE -vfs "dacs-kwv-fs:/secure/auth_tokens" -list

       To use new keys (making the same assumptions as earlier), add a
       suitable VFS directive to dacs.conf; the default defines the item type
       auth_token_keys_prev as follows:

           VFS "[auth_token_keys_prev]dacs-fs:${Conf::FEDERATIONS_ROOT}/\
           ${Conf::FEDERATION_DOMAIN}/${Conf::JURISDICTION_NAME}/auth_token_keys.prev"



           % cd /usr/local/dacs/federations_root/example.com/EXAMPLE
           % mv auth_token_keys auth_token_keys.prev
           % dacskey -uj EXAMPLE -q auth_token_keys
           % chgrp www auth_token_keys
           % chmod 0640 auth_token_keys
           % dacstoken -uj EXAMPLE -inkeys auth_token_keys.prev -set


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0, or 1 if an error occurred.

BBUUGGSS
       HOTP should probably be called COTP, but HOTP came before TOTP.  WOTP?

       Listings may only be sorted by username.

       The drift adjustment for TOTP accounts is tied to the real time clocks
       of a particular client/server pair. If either clock is effectively
       changed "too much" (e.g., by resetting a very fast server clock or
       replacing an old token that had a relatively slower clock), then a user
       will observe the token to suddenly stop working. Resynchronization is
       required in these cases. Sharing an account file amongst two or more
       servers should be avoided in general (because locks are unlikely to be
       visible across hosts), but also if their clocks are not always well
       synchronized. It is recommended that the Network Time Protocol (RRFFCC
       11330055[37]) or equivalent be used on any host that runs DDAACCSS commands or
       web services.

       The implementation of time-based tokens is based on the latest
       available Internet-Draft, which is considered by the IETF to be a "work
       in progress". Hence the algorithm, its implementation (including DDAACCSS
       accounts based on this operational mode), and documentation are all
       subject to change.

       TOTP password matching windows are symmetrical.

       This functionality should probably be available through
       ddaaccss__aaddmmiinn((88))[38] and ddaaccssaauutthh((11))[39], but it's not.

       Mutual authentication using tokens should be implemented.

       Although release 1.4.25 introduced many improvements, some cause
       incompatibilities with earlier versions of ddaaccssttookkeenn.

SSEEEE AALLSSOO
       RRFFCC 44222266[4], ddrraafftt--mmrraaiihhii--ttoottpp--ttiimmeebbaasseedd--0055..ttxxtt[5],
       ddaaccss__aauutthheennttiiccaattee((88))[2], ddaaccss__ttookkeenn((88))[8], ddaaccssggrriidd((11))[40],
       ddaaccssppaasssswwdd((11))[10], ooppiiee((44))[41], MMoobbiillee OOnnee TTiimmee PPaasssswwoorrddss[42],
       mmoodd__aauutthhnn__oottpp[43]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[44])

AACCKKNNOOWWLLEEDDGGEEMMEENNTTSS
       Our sincere thanks to AAuutthheenneexx,, IInncc..[24] and HHyyppeerrSSeeccuu IInnffoorrmmaattiioonn
       SSyysstteemmss,, IInncc..[26] for generously providing samples of their products
       and technical support.

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[45] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        3. local_token_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#token

        4. RFC 4226
           http://www.rfc-editor.org/rfc/rfc4226.txt

        5. latest IETF Internet-Draft
           http://www.ietf.org/id/draft-mraihi-totp-timebased-05.txt

        6. Additional operational modes
           http://www.ietf.org/id/draft-mraihi-mutual-oath-hotp-variants-11.txt

        7. --ccoonnvveerrtt flag
           http://dacs.dss.ca/man/#convert_flag

        8. dacs_token(8)
           http://dacs.dss.ca/man/dacs_token.8.html

        9. TOKEN_REQUIRES_PIN
           http://dacs.dss.ca/man/dacs.conf.5.html#TOKEN_REQUIRES_PIN

       10. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

       11. dacs_passwd(8)
           http://dacs.dss.ca/man/dacs_passwd.8.html

       12. PASSWORD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_DIGEST

       13. PASSWORD_SALT_PREFIX
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_SALT_PREFIX

       14. PASSWORD_CONSTRAINTS
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_CONSTRAINTS

       15. RFC 2104
           http://www.rfc-editor.org/rfc/rfc2104.txt

       16. FIPS 198
           http://csrc.nist.gov/publications/fips/fips198/fips-198a.pdf

       17. time(3)
           http://www.freebsd.org/cgi/man.cgi?query=time&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       18. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

       19. man-in-the-middle attack
           http://en.wikipedia.org/wiki/Man-in-the-middle_attack

       20. revocation list
           http://dacs.dss.ca/man/dacs.acls.5.html#revocation_list

       21. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#passwd

       22. DDAACCSS identities
           http://dacs.dss.ca/man/dacs.1.html#gloss_identity

       23. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

       24. Authenex A-Key(R) 3600
           http://www.authenex.com

       25. Feitian Technologies
           http://www.ftSafe.com

       26. HyperSecu Information Systems
           http://www.hypersecu.com

       27. OATH Token
           http://oathtoken.googlecode.com

       28. iPod Touch, iPhone, and iPad
           http://itunes.apple.com/us/app/oath-token/id364017137?mt=8

       29. iOATH Lite
           http://itunes.apple.com/ca/app/ioath-lite/id327109243?mt=8

       30. Photo
           http://dacs.dss.ca/otp-tokens2.jpg

       31. --vvaalliiddaattee
           http://dacs.dss.ca/man/#validate_flag

       32. --sseett
           http://dacs.dss.ca/man/#set_flag

       33. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       34. Tokens and secret keys
           http://dacs.dss.ca/man/#security1

       35. XML record
           http://dacs.dss.ca/man/#user_provisioning

       36. -import
           http://dacs.dss.ca/man/import_flag

       37. RFC 1305
           http://www.rfc-editor.org/rfc/rfc1305.txt

       38. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       39. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       40. dacsgrid(1)
           http://dacs.dss.ca/man/dacsgrid.1.html

       41. opie(4)
           http://www.freebsd.org/cgi/man.cgi?query=opie&apropos=0&sektion=4&manpath=FreeBSD+7.2-RELEASE&format=html

       42. Mobile One Time Passwords
           http://motp.sourceforge.net

       43. mod_authn_otp
           http://code.google.com/p/mod-authn-otp

       44. www.dss.ca
           http://www.dss.ca

       45. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                      DACSTOKEN(1)
