DACS_LIST_JURISDICTI(8)    DACS Web Services Manual    DACS_LIST_JURISDICTI(8)



NNAAMMEE
       dacs_list_jurisdictions - display information about DDAACCSS jurisdictions

SSYYNNOOPPSSIISS
       ddaaccss__lliisstt__jjuurriissddiiccttiioonnss [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This web service is part of the DDAACCSS suite.

       The ddaaccss__lliisstt__jjuurriissddiiccttiioonnss web service displays information, relative
       to the jurisdiction that receives the request, about its federation and
       other jurisdictions in that federation. Included are the federation's
       public encryption key and its unique instance identifier.

       The _F_O_R_M_A_T argument (see ddaaccss..sseerrvviicceess((88))[2]) determines the type of
       output, with the default being HTML, using the style sheet
       ddaaccss__lliisstt__jjuurriissddiiccttiioonnss..ccssss[3]. The various flavours of XML, a PHP
       format (see below), JSON, and plain text (TEXT) are supported.

       One application of ddaaccss__lliisstt__jjuurriissddiiccttiioonnss is to assist middleware to
       generate a menu of jurisdictions for user authentication. If _F_O_R_M_A_T is
       PHP, a list of each jurisdiction that provides an authentication
       service is emitted (as text/plain, one jurisdiction per line. Each line
       has the format:

           jurisdiction[]=_j_n_a_m_e&host[]=_u_r_l&_j_n_a_m_e

       The string _j_n_a_m_e is the DDAACCSS jurisdiction name and _u_r_l is the complete
       URL prefix for DDAACCSS web services at the jurisdiction. For example,
       invoking this URL:

           https://example.com/infocards/cgi-bin/dacs/dacs_list_jurisdictions?FORMAT=PHP

       might return the following response:

           jurisdiction[]=INFOCARDS&host[]=https://example.com/infocards/cgi-bin/dacs&INFOCARDS
           jurisdiction[]=DEMO&host[]=https://example.com/demo/cgi-bin/dacs&DEMO
           jurisdiction[]=TEST&host[]=https://test.example.com/cgi-bin/dacs&TEST

       The hhttmmll//eexxaammpplleess//llooggiinn..pphhpp[4] template demonstrates this feature. If
       XML output is selected, a document conforming to
       ddaaccss__lliisstt__jjuurriissddiiccttiioonnss..ddttdd[5] is returned.

       When returned as an XML attribute, a public encryption key is a base-64
       encoding of the PEM formatted key.

           NNoottee
           This program is also available as a DDAACCSS utility, ddaaccsslliisstt((11))[6].
           Because ddaaccss__aaddmmiinn((88))[7] provides the same functionality and more,
           ddaaccss__lliisstt__jjuurriissddiiccttiioonnss may be removed in a future release.

   WWeebb SSeerrvviiccee AArrgguummeennttss
       In addition to the ssttaannddaarrdd CCGGII aarrgguummeennttss[8], ddaaccss__lliisstt__jjuurriissddiiccttiioonnss
       understands the following CGI arguments:

       _J_U_R_I_S_D_I_C_T_I_O_N
           Limit the output to the specified jurisdiction name. As a special
           case, if the argument does not specify a jurisdiction name, only
           federation-scoped information will be returned.

       _P_U_B___K_E_Y___O_N_L_Y
           If this argument is "yes" (case insensitive) only the federation's
           or a jurisdiction's public key (if known) will be returned. If
           _J_U_R_I_S_D_I_C_T_I_O_N is given and is not the empty string, that
           jurisdiction name is selected; if _J_U_R_I_S_D_I_C_T_I_O_N is given and is the
           empty string, the federation is selected; and if the argument is
           absent, the current jurisdiction is selected. This argument
           currently requires _F_O_R_M_A_T to be TEXT. A PEM [RRFFCC 11442211[9], RRFFCC
           11442222[10], RRFFCC 11442233[11], RRFFCC 11442244[12]] formatted key is returned.

           NNoottee
           In the current implementation, a jurisdiction's public key can only
           be provided by one of the jurisdictions configured on the same
           host.

FFIILLEESS
       ddaaccss__lliisstt__jjuurriissddiiccttiioonnss..ccssss[3]

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccss((11))[13], ddaaccsskkeeyy((11))[14], ddaaccsslliisstt((11))[6], ddaaccss..ggrroouuppss((55))[15]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[16])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[17] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs.services(8)
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

        3. dacs_list_jurisdictions.css
           http://dacs.dss.ca/man//css/dacs_list_jurisdictions.css

        4. html/examples/login.php
           http://dacs.dss.ca/man/../examples/login.php

        5. dacs_list_jurisdictions.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_list_jurisdictions.dtd

        6. dacslist(1)
           http://dacs.dss.ca/man/dacslist.1.html

        7. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

        8. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        9. RFC 1421
           http://www.rfc-editor.org/rfc/rfc1421.txt

       10. RFC 1422
           http://www.rfc-editor.org/rfc/rfc1422.txt

       11. RFC 1423
           http://www.rfc-editor.org/rfc/rfc1423.txt

       12. RFC 1424
           http://www.rfc-editor.org/rfc/rfc1424.txt

       13. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       14. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

       15. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       16. www.dss.ca
           http://www.dss.ca

       17. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012           DACS_LIST_JURISDICTI(8)
