DACS_AUTHENTICATE(8)       DACS Web Services Manual       DACS_AUTHENTICATE(8)



NNAAMMEE
       dacs_authenticate - DDAACCSS authentication service

SSYYNNOOPPSSIISS
       ddaaccss__aauutthheennttiiccaattee [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This web service is part of the DDAACCSS suite.

       The ddaaccss__aauutthheennttiiccaattee web service is an authentication "driver" for
       DDAACCSS. When it receives a request to authenticate a user, it usually
       invokes one or more authentication modules, depending on its
       configuration. Successful authentication assigns a DDAACCSS user identity
       to the user and roles modules may be invoked to determine the roles
       with which the identity is associated; DDAACCSS credentials are generated
       and returned to the user. The caller of ddaaccss__aauutthheennttiiccaattee can be
       redirected to a configured URL, called the post-authentication handler
       (or just the handler), depending on whether authentication fails or
       succeeds.

       General DDAACCSS configuration directives are discussed in ddaaccss..ccoonnff((55))[2].
       Configuration directives specific to authentication are described here.

       DDAACCSS expressions are described in ddaaccss..eexxpprrss((55))[3].

       ddaaccss__aauutthheennttiiccaattee might be called from an HTML form (see the
       distribution's hhttmmll//eexxaammpplleess[4] directory for examples of simple login
       pages), directly through a link on a web page, indirectly by DDAACCSS HHTTTTPP
       AAuutthheennttiiccaattiioonn[5], or from middleware.

       Command line authentication functionality is provided by
       ddaaccssaauutthh((11))[6]. Other authentication mechanisms are provided by
       ddaaccss__aauutthh__aaggeenntt((88))[7], ddaaccss__aauutthh__ttrraannssffeerr((88))[8], and ddaaccssccooookkiiee((11))[9].

   AAuutthheennttiiccaattiioonn
       Authentication is the procedure by which a claimed identity is
       confirmed. Following successful authentication, DDAACCSS credentials may be
       created that represent the identity. For maximum convenience and
       interoperability in a web environment, DDAACCSS credentials are usually
       encapsulated within an HTTP cookie and transmitted over a TCP/IP
       connection secured by SSL. Any secure method of transporting
       credentials can be used instead, however, such as the value of an HTTP
       extension-header entity-header field in a request message sent over a
       VPN.

       While ddaaccss__aauutthheennttiiccaattee provides powerful and flexible ways to combine
       and compose a variety of authentication methods, most DDAACCSS
       jurisdictions will configure only one method, or perhaps just a few
       methods, in simple ways.

       To help integrate DDAACCSS seamlessly within a web site, ddaaccss__aauutthheennttiiccaattee
       allows handlers to be configured. Handlers allow various exceptions to
       be caught and processed so that an appropriate flow of control can
       occur. For example, if authentication succeeds the user can be
       redirected to a specific page, including the one originally requested
       before the exception occurred.

       Authentication succeeds (and the user is authenticated) if and only if:

       +o   at least one AAuutthh ccllaauussee[10] has been configured,

       +o   the semantics of all CCOONNTTRROOLL[11] directives satisfy the
           requirements for success,

       +o   the DDAACCSS uusseerrnnaammee[12] arrived at is syntactically valid, and

       +o   the identity's access has not been revoked or denied (see
           ddaaccss..aaccllss((55))[13]).


       An incorrect password, for instance, is not considered to be an error;
       it will cause its Auth clause to fail but depending on the control
       directives that have been configured, the user may still be
       successfully authenticated by some other Auth clause. True errors are
       fatal and cause ddaaccss__aauutthheennttiiccaattee to terminate without issuing
       credentials and possibly without invoking a handler.

       If a DDAACCSS identity reauthenticates, the user agent is expected to
       replace the old credentials with new ones; if re-authentication fails
       (e.g., the password is incorrect), the old credentials should continue
       to exist. If a user establishes multiple concurrent identities, the
       user agent is expected to send all credentials with each service
       request in accordance with the relevant standards. This is standard
       behaviour for most common web browsers.

       As an efficiency measure, the authentication architecture allows an
       authentication module to return roles.

       NNaammeess
           Please refer to ddaaccss((11))[14] for details about naming.

       CCrreeddeennttiiaallss aanndd CCooookkiieess
           DDAACCSS credentials are cryptographically protected XML documents
           (ccrreeddeennttiiaallss..ddttdd[15]), making it extremely difficult for an
           attacker to generate valid credentials, modify captured credentials
           to impersonate another user, or obtain greater access rights
           without being detected. User agents and other software outside of
           DDAACCSS do not need to decrypt the credentials and do not possess the
           required key.

           New credentials are created and returned to the user after
           successful authentication. Although the lifetime of a set of
           credentials is independently configurable, they are intended to be
           fairly transitory. If a user reauthenticates, new credentials
           different than previous credentials might well be returned (e.g.,
           with different roles).

           DDAACCSS does not verify that a user's browser is configured to accept
           cookies - this is the responsibility of the DDAACCSS administrator (by
           supplying client-side code to test that cookies have been enabled,
           for instance). Failure to accept cookies may cause some features to
           be unavailable or work incorrectly. Also note that despite what
           DDAACCSS (or any other program) tells a browser about the lifetime of
           an HTTP cookie, browsers may be configured to impose a shorter
           lifetime and can delete a cookie at any time. (Aside: Firefox
           2.0.0.3 appears to show cookies that have been deleted.)

               SSeeccuurriittyy
               +o   For DDAACCSS to operate securely, communication between a user
                   (or middleware) and ddaaccss__aauutthheennttiiccaattee, which may include
                   information such as passwords, _m_u_s_t _o_n_l_y _b_e _t_r_a_n_s_m_i_t_t_e_d
                   _o_v_e_r _a _s_e_c_u_r_e _c_o_n_n_e_c_t_i_o_n _(_S_S_L_).

               +o   Communication between ddaaccss__aauutthheennttiiccaattee (and ddaaccssaauutthh) and
                   an external (not built-in) authentication module may
                   include information such as passwords and therefore _s_h_o_u_l_d
                   _o_n_l_y _b_e _t_r_a_n_s_m_i_t_t_e_d _o_v_e_r _a _s_e_c_u_r_e _c_o_n_n_e_c_t_i_o_n _(_S_S_L_) or in a
                   way that is not subject to eavesdropping or attack.

               +o   For DDAACCSS to operate securely, regardless of how they are
                   obtained, DDAACCSS credentials _m_u_s_t _o_n_l_y _b_e _t_r_a_n_s_m_i_t_t_e_d _o_v_e_r _a
                   _s_e_c_u_r_e _c_o_n_n_e_c_t_i_o_n _(_S_S_L_) _s_o _t_h_a_t _t_h_e_y _c_a_n_n_o_t _e_a_s_i_l_y _b_e
                   _c_a_p_t_u_r_e_d _a_n_d _r_e_u_s_e_d _b_y _a_n _a_t_t_a_c_k_e_r.

               +o   It is unwise to configure both SSL and non-SSL
                   communication. Besides providing an avenue for attack, it
                   may cause DDAACCSS to behave strangely (e.g., infinite loops
                   may occur because cookies obtained over an SSL connection
                   are not subsequently forwarded over a non-SSL connection).

               +o   The apparent IP address of an authenticated user, as
                   provided by the web server, is stored in credentials.  DDAACCSS
                   can be configured to consider credentials to be valid only
                   for requests that come from that address (refer to the
                   VVEERRIIFFYY__IIPP[16] configuration directive), making it more
                   difficult for an attacker to replay captured credentials.

                   In some environments this constraint is a good idea, but in
                   general it is of dubious value so enable it with care.
                   Where a user is behind a firewall or router that has
                   multiple IP addresses, successive service requests might
                   legitimately not appear to be coming from the same address
                   and some requests would be denied if this constraint were
                   enabled. In situations where credentials are being
                   forwarded between web services they might be rejected. In
                   the case of dial-up Internet access, a user might be issued
                   credentials, lose the connection, and be assigned a
                   different IP address upon reconnecting; the user would be
                   forced to reauthenticate. Also, more than one user may be
                   associated with a particular IP address, as when a Network
                   Address Translation (NAT) facility such as nnaattdd((88))[17] is
                   used, so the check does not guarantee uniqueness.

               +o   Information associated with a user's browser can be
                   included in credentials created for that user to make it
                   difficult to reuse captured credentials with a different
                   browser. Please refer to VVEERRIIFFYY__UUAA[18] for details.

               +o   Credentials have a limit on their lifetime that is
                   independent of the lifetime of the HTTP cookie that
                   contains them; that is, credentials can expire without
                   their cookie having expired, and vice versa. Expired
                   credentials are recognized and will not be used by DDAACCSS.
                   Refer to the AAUUTTHH__CCRREEDDEENNTTIIAALLSS__DDEEFFAAUULLTT__LLIIFFEETTIIMMEE__SSEECCSS[19]
                   configuration directive for details.

               +o   Passwords do not appear in any credentials and are not
                   stored once the user has been authenticated.

               +o   It is forbidden to submit multiple credentials for the same
                   identity to DDAACCSS and such a request will trigger an error.

           All DDAACCSS jurisdictions within the same federation share an
           algorithm and key to encrypt and decrypt credentials. A
           cryptographically secure, symmetric encryption function, Rijndael
           (the AAddvvaanncceedd EEnnccrryyppttiioonn SSttaannddaarrdd[20] (AES) algorithm and FFeeddeerraall
           IInnffoorrmmaattiioonn PPrroocceessssiinngg SSttaannddaarrdd[21]), is used. The same 128 bit key
           is used by all DDAACCSS jurisdictions.  AES also supports 192 and 256
           bit key lengths and either can be configured at build-time.

           A cryptographically secure message authentication code (MAC) is
           employed to detect modification of credentials. A key different
           from the encryption key is used. The Keyed-Hash Message
           Authentication Code (HMAC, FFIIPPSS 119988[22], RRFFCC 22110044[23], RRFFCC
           44663355[24], RRFFCC 44886688[25]), is employed using the 160-bit NNIISSTT[26]
           secure hash standard, SHA-1 (FFIIPPSS 118800--11[27], RRFFCC 44663344[28]). In
           addition to SHA-1, SHA-224, SHA-256, SHA-384, and SHA-512 (FFIIPPSS
           118800--33[29]) can be used, although they must be configured at
           build-time.

           The AES key length and HMAC digest algorithm used by a federation
           can be changed at any time, perhaps forcing some users to
           reauthenticate, but the same key length and digest algorithm must
           be used throughout a federation.

               SSeeccuurriittyy
               DDAACCSS can be configured to use the less secure but widely-used
               and somewhat more efficient MMDD55 aallggoorriitthhmm[30] instead, although
               it is deprecated and it will eventually be removed.

           The NNeettssccaappee HHTTTTPP CCooookkiieess SSppeecciiffiiccaattiioonn[31] defines the syntax and
           semantics of the HTTP response header that a web server sends to a
           client; this syntax is used by default, but the _C_O_O_K_I_E___S_Y_N_T_A_X[32]
           argument can be used to request a different syntax. The Netscape
           format is as follows:

               Set-Cookie: NAME=VALUE; expires=DATE; path=PATH; domain=DOMAIN_NAME; secure

           DDAACCSS formulates these response headers as follows.

           The NAME attribute of an authentication cookie returned to the user
           (e.g., by ddaaccss__aauutthheennttiiccaattee) has the following format:

               DACS:_f_e_d_e_r_a_t_i_o_n_-_n_a_m_e::[_j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e]:[_u_s_e_r_n_a_m_e]

           where _f_e_d_e_r_a_t_i_o_n_-_n_a_m_e is the official name assigned to the
           federation for which the cookie is valid, _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e is the
           name of the authenticating jurisdiction, and _u_s_e_r_n_a_m_e is the
           authenticated name of the user. If the _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e is
           omitted, the _u_s_e_r_n_a_m_e must also be omitted. Semicolons, commas, and
           whitespace within the name must be URL-style encoded. Colons are
           not allowed in any of the name components. Here is an example of a
           cookie name:

               DACS:EXAMPLE::METALOGIC:rick@example.com

           The VALUE attribute of a cookie is a printable text encoding of
           credentials.

               SSeeccuurriittyy
               +o   Although DDAACCSS performs validity tests on cookie names,
                   middleware should not rely on cookie names for any purpose.
                   An apparently valid DDAACCSS cookie can easily be crafted with
                   any value. Also, an apparently legitimate cookie might
                   convey expired or otherwise invalid credentials. Middleware
                   should use ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[33] to validate an
                   authentication cookie and not trust cookie names.

               +o   No expires attribute is set; this will cause the cookie to
                   be automatically deleted by a conforming browser when the
                   user's browser session ends and not made persistent (i.e.,
                   not stored on disk for use in a subsequent browser
                   session), closing a potential security hole.

               +o   By default, the value of the path attribute is "/", meaning
                   the cookie will be sent with every request to the domain
                   that created the cookie, whether it is for a DDAACCSS-wrapped
                   service request or not. The CCOOOOKKIIEE__PPAATTHH[34] configuration
                   directive can specify an alternative value. Using a more
                   restricted path can potentially improve security. All of
                   the jurisdiction's DDAACCSS-wrapped services must appear under
                   that path, of course, or the cookie will not be sent;
                   ideally, no non-DDAACCSS wrapped service would appear under
                   that path.

           The value of the domain attribute associated with the cookie is
           dependent on the uniform domain name scheme chosen for the
           jurisdictions. The value will be configured to be the most specific
           tail string that tail matches all participating domain names. For
           example, if the uniform domain name scheme has hostnames of the
           form xxx.example.com, yyy.example.com, and zzz.example.com, then
           the value of the attribute will be example.com. This will ensure
           that the user agent sends the cookie with any service request
           directed to a hostname ending in example.com.

               TTiipp
               The HTTP cookie specifications appear to say that a cookie
               having a domain attribute of example.com should _n_o_t be sent to
               a host of the same name, yet both Mozilla and IE (and perhaps
               other browsers) do just that. Without this behaviour, it would
               not be possible to use a single domain name with multiple DDAACCSS
               jurisdictions below it; that is, given domain=example.com, it
               is expected that jurisdictions can be identified by URI path
               prefixes such as example.com/metalogic, example.com/test, and
               so on.

           When operating securely (see the SSEECCUURREE__MMOODDEE[35] directive in
           ddaaccss..ccoonnff((55))[2]) or when an authentication request is sent over
           SSL, the secure attribute will be present so that the cookie will
           only be transmitted if the communications channel with the host is
           a secure one. At present, browsers define this to mean that secure
           cookies will only be sent to HTTPS (HTTP over SSL) servers.

   WWeebb SSeerrvviiccee AArrgguummeennttss
       In addition to the ssttaannddaarrdd CCGGII aarrgguummeennttss[36], ddaaccss__aauutthheennttiiccaattee
       understands the following CGI arguments. Some arguments are optional,
       while others are required depending on the authentication
       configuration. An invalid argument value will usually cause
       authentication to fail immediately. Unrecognized arguments are ignored.

       _A_U_T_H___I_D
           This optional argument is used with the user_sufficient keyword
           (refer to the CCOONNTTRROOLL[11] directive).

       _A_U_T_H___P_R_O_M_P_T___V_A_R___P_R_E_F_I_X
           Reserved for use by llooccaall__ppaamm__aauutthheennttiiccaattee[37].

       _A_U_T_H___T_R_A_N_S_I_D
           Reserved for use by llooccaall__ppaamm__aauutthheennttiiccaattee[37].

       _A_U_T_H_O_R_I_Z_A_T_I_O_N
           Used internally with HHTTTTPP AAuutthheennttiiccaattiioonn[5].

       _A_U_X_I_L_I_A_R_Y
           This argument can be used to pass additional authentication
           material to authentication modules.

       _C_O_O_K_I_E___S_Y_N_T_A_X
           By default, the _d_e _f_a_c_t_o standard NNeettssccaappee HHTTTTPP CCooookkiieess
           SSppeecciiffiiccaattiioonn[31] syntax is followed when cookies are created
           (COOKIE_SYNTAX=COOKIE_NETSCAPE). The value COOKIE_EXT_NETSCAPE
           selects an "extended" Netscape spec syntax (it's not the Netscape
           syntax but it's not fully RFC 2109 compliant either); instead of
           using the expires attribute it will use the Max-Age attribute as
           defined in RRFFCC 22110099[38] and RRFFCC 22996655[39]. Attribute values are not
           quoted and there is no support for the Comment field. Parameter
           values COOKIE_RFC2109 and COOKIE_RFC2965 are recognized but not
           implemented.

               NNoottee
               RRFFCC 22110099[38] and RRFFCC 22996655[39] forbid the following characters
               from appearing in the value of an HTTP cookie's NAME attribute:

                   ( ) <  > @ , ; : \ "  /  [  ]  ? = {  }

               Additionally, the space, tab, and all US-ASCII control
               characters (octets 0 - 31) and DEL (127) are disallowed. As
               DDAACCSS currently follows only the Netscape spec syntax in this
               respect, it produces cookies that are invalid with respect to
               RFC 2109 and RFC 2965. While this limitation does not appear to
               cause problems for web browsers, it may be noteworthy for users
               of some cookie handling APIs.

       _D_A_C_S___A_U_T_H___S_U_C_C_E_S_S___H_A_N_D_L_E_R
           This argument provides a way for the caller to specify where the
           user agent should be redirected after successful authentication,
           regardless of whether authentication handlers are configured or
           enabled. If its value is DACS_ERROR_URL and an argument by that
           name is present, the user agent will be redirected to the value of
           that argument; otherwise, the user agent will be redirected to the
           value of _D_A_C_S___A_U_T_H___S_U_C_C_E_S_S___H_A_N_D_L_E_R. The _D_A_C_S___E_R_R_O_R___U_R_L is passed to
           this web service by ddaaccss__aaccss((88))[40] as part of an authentication
           workflow initiated by a request that is denied because no
           credentials were supplied; _D_A_C_S___E_R_R_O_R___U_R_L should not be generated
           by any non-DDAACCSS software.

       _D_A_C_S___B_R_O_W_S_E_R
           If an argument named _D_A_C_S___B_R_O_W_S_E_R is present and has the value 1,
           it signifies that the request is coming from a browser rather than
           middleware. If the request comes from a browser, DDAACCSS will return a
           cookie using the Set-Cookie HTTP response header, otherwise it will
           not.

       _D_A_C_S___D_E_B_U_G
           If this argument is present, the web service will produce more
           detailed log information.

       _E_N_A_B_L_E___A_U_T_H___H_A_N_D_L_E_R_S
           The jurisdiction's authentication handler directives are honoured
           if and only if this argument is present and has the value 1.

       _O_P_E_R_A_T_I_O_N
           This is used with the identity selection mechanism described by
           ddaaccss__sseelleecctt__ccrreeddeennttiiaallss((88))[41]. If the value of this parameter is
           SELECT and authentication is successful, any currently selected
           credentials are deselected and the new credentials are selected.

       _P_A_S_S_W_O_R_D
           This argument is the password that corresponds to _U_S_E_R_N_A_M_E.

       _U_S_E_R_N_A_M_E
           This argument, which is (almost) always required, is the name
           provided by the user and is usually the name being authenticated.
           It will not necessarily be the same as the final DDAACCSS username. For
           example, if the value of _U_S_E_R_N_A_M_E is not a syntactically valid DDAACCSS
           username, the authentication procedure must transform it into
           something acceptable (using the ssttrrttrr(())[42] function, for instance;
           see ddaaccss..eexxpprrss((55))[3]).

       _W_W_W___A_U_T_H_E_N_T_I_C_A_T_E
           Reserved for internal use by HHTTTTPP AAuutthheennttiiccaattiioonn[5].

   AAuutthh CCllaauussee DDiirreeccttiivveess
       Each Auth clause in a DDAACCSS configuration file contains directives that
       describe a procedure for authenticating users. Some of these directives
       are common to all authentication modules, while others are understood
       only by a certain module; for example, LLDDAAPP__UUSSEERRNNAAMMEE__UURRLL[43] is only
       meaningful to the llooccaall__llddaapp__aauutthheennttiiccaattee[44] module. The
       general-purpose OOPPTTIIOONN[45] directive may sometimes be used to specify
       an argument to an authentication module.

           IImmppoorrttaanntt
           The order in which the Auth clauses appear is significant. See the
           CCOONNTTRROOLL[11] directive.

       Every Auth element must have an id attribute. Its value is merely a
       label (an alphabetic followed by zero or more alphanumerics, hyphens,
       and underscores) that allows the clause to be referenced. Each id
       attribute value must be unique (case-sensitively) within the
       Jurisdiction section that contains it.

       The following configuration directives are recognized by
       ddaaccss__aauutthheennttiiccaattee within any Auth clause (see ddaaccss..ccoonnff((55))[46] for
       general information about directives).

       AAuutthh CCllaauussee CCoommmmoonn DDiirreeccttiivveess IInnddeexx::

        1. CONTROL (Required1)

        2. CREDENTIALS_LIFETIME_SECS (Optional1)

        3. EXIT* (Optional1)

        4. EXPR (Optional1)

        5. FLAGS (Optional1)

        6. INIT* (Optional1)

        7. OPTION (Optional)

        8. OPTION* (Optional)

        9. PASSWORD_AUDIT (Optional)

       10. PREDICATE (Optional1)

       11. STYLE (Required1)

       12. URL (Optional1)

       13. URL* (Optional1)

       CONTROL (Required1)
           This directive specifies a PAM-like control keyword that determines
           what will happen if the authentication module succeeds or fails;
           see ppaamm((33))[47] and the XX//OOppeenn SSiinnggllee SSiiggnn--OOnn SSeerrvviiccee ((XXSSSSOO))
           pprreelliimmiinnaarryy ssppeecciiffiiccaattiioonn[48] (page 30), from which the description
           of these directives was adapted. Although this control mechanism
           allows for rather complicated authentication sequences to be
           described, in practice jurisdictions tend to construct fairly
           simple configurations. Most processing errors (other than errors
           encountered by a module) are considered fatal.

           The first Auth clause that appears after configuration merging (see
           ddaaccss..ccoonnff((55))[49]) is the "top" or first module in the stack, the
           next one is the second module in the stack, and so on.

           The value of this directive is a case-insensitive keyword that can
           be abbreviated up to the indicated minimum:

           +o   require[d]

           +o   requisite

           +o   opt[ional]

           +o   suff[icient]

           +o   user_suff[icient]
               For example, the keywords require and required are equivalent.

               The control flow of authentication module processing is as
               follows:

                1. If a requisite module fails, authentication fails and
                   ddaaccss__aauutthheennttiiccaattee stops processing the module stack,
                   returning the error reported by the requisite module;

                2. If all requisite and required modules in the stack succeed,
                   then authentication succeeds (any errors reported by
                   optional, sufficient, and user_sufficient modules are
                   ignored);

                3. If one or more required modules fail, then the error value
                   from the first required module that failed is returned;
                   unlike failure of a requisite module, processing continues;

                4. If none of the modules in the stack are designated as
                   required or requisite, then ddaaccss__aauutthheennttiiccaattee requires that
                   at least one optional, sufficient, or user_sufficient
                   module succeed. If all fail, then the error value from the
                   first module in the stack is returned;

                5. The first exception to the above is caused by the
                   sufficient keyword. If a module that is designated as
                   sufficient succeeds, then ddaaccss__aauutthheennttiiccaattee immediately
                   returns success (all subsequent modules are ignored, even
                   required and requisite ones), given that all prior required
                   and requisite modules have also succeeded. If a prior
                   required module failed, then the error value from that
                   module is returned;

                6. The second exception to the above involves the
                   user_sufficient keyword, which enables at most one
                   user_sufficient Auth clause and disables all other
                   user_sufficient _a_n_d sufficient Auth clauses. This control
                   simplifies configuring user-selectable authentication
                   methods. Note that this mechanism will necessarily reveal
                   additional information about a jurisdiction's
                   authentication configuration.

                   If the _A_U_T_H___I_D argument is _n_o_t given, then all Auth clauses
                   with the user_sufficient control are disabled - none of
                   their directives are evaluated - and any sufficient
                   controlled clauses are processed normally. If the _A_U_T_H___I_D
                   is present, then only an Auth clause with a user_sufficient
                   control _a_n_d an exactly matching id attribute is used. There
                   can be at most one such Auth clause; all other Auth clauses
                   having a user_sufficient _o_r sufficient control is disabled.
                   In all other respects, an enabled user_sufficient Auth
                   clause is processed as for the sufficient control;

                7. If an error occurs while processing a directive, then
                   ddaaccss__aauutthheennttiiccaattee fails immediately.

               CREDENTIALS_LIFETIME_SECS (Optional1)
                   The lifetime, in seconds, of credentials returned after
                   successful authentication. This overrides the general
                   directive of the same name, and may in turn be overridden
                   by setting the variable _$_{_A_u_t_h_:_:_C_R_E_D_E_N_T_I_A_L_S___L_I_F_E_T_I_M_E___S_E_C_S_}.
                   Authentication will fail if this value is invalid.

               EXIT* (Optional1)
                   If authentication is successful, this expression is
                   evaluated immediately after the module's authentication
                   processing is executed (but refer to the FLAGS directive).

               EXPR (Optional1)
                   This directive, which is required when STYLE is expr, gives
                   an expression that is evaluated to decide whether to grant
                   credentials and the DDAACCSS identity to use. See
                   AAuutthheennttiiccaattiinngg UUssiinngg aann EExxpprreessssiioonn[50].

               FLAGS (Optional1)
                   This directive gives control flags that are interpreted by
                   ddaaccss__aauutthheennttiiccaattee. Each directive consists of a
                   whitespace-separated list of values.

                   The only value currently recognized is the keyword ident.

                       IImmppoorrttaanntt
                       If there is more than one Auth clause, the ident flag
                       should ordinarily be specified in at least one of them
                       to indicate that the username returned by the module,
                       if authentication is successful, is to become the
                       "current" username. Those Auth clauses without the
                       ident flag will not change the current username. After
                       the last Auth clause is processed, the current username
                       is used in the resulting credentials.

                       The _$_{_A_u_t_h_:_:_C_U_R_R_E_N_T___U_S_E_R_N_A_M_E_} variable (see below) is
                       updated only if there is exactly one Auth clause or if
                       the ident flag is given. This update occurs immediately
                       prior to execution of any EXIT* directive.

                       If ident is not specified in any successfully processed
                       Auth clause (i.e., one where authentication succeeds),
                       the username returned by the last successfully
                       processed clause is used. If the ident flag is
                       specified in one or more successfully processed
                       clauses, the username returned by the last such module
                       will be used.

               INIT* (Optional1)
                   The given expression is evaluated immediately prior to the
                   URL* and EXPR expressions, all of which are evaluated
                   before a module's authentication processing is invoked.

               OPTION (Optional)
                   The directive value is a _n_a_m_e=_v_a_l_u_e pair that may be
                   interpreted by ddaaccss__aauutthheennttiiccaattee or the authentication
                   module specified by the Auth clause. It causes a variable
                   called _n_a_m_e to be put into the Options namespace, which
                   only exists within the context of the Auth clause
                   containing this OPTION. The variables in this namespace are
                   passed as arguments to the authentication module.
                   Whitespace may not precede or follow the '=' and any quotes
                   around the value are considered to be part of the value. A
                   given _n_a_m_e may not be specified more than once within a
                   particular Auth clause. The Options namespace is
                   initialized with _U_S_E_R_N_A_M_E, _P_A_S_S_W_O_R_D, _A_U_X_I_L_I_A_R_Y,
                   _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N, and _D_A_C_S___V_E_R_S_I_O_N variables. If these
                   variables are specified by an OPTION, the argument
                   ordinarily used will be overridden.

                   For example, this directive causes SAMBA_PORT=139 to be
                   passed as a POST method parameter:

                       OPTION "SAMBA_PORT=139"


               OPTION* (Optional)
                   The given expression is evaluated before the module is
                   called, and after all OPTION directives and all OPTION*
                   directives that appear earlier. The value of the expression
                   must be a _n_a_m_e=_v_a_l_u_e pair, as with the OPTION directive,
                   and overrides any _n_a_m_e in the Options namespace.

               PASSWORD_AUDIT (Optional)
                   This directive is used to audit password-type arguments
                   passed to authentication modules by ddaaccss__aauutthheennttiiccaattee,
                   regardless of the authentication method, against the
                   criteria selected by the specified constraint string, which
                   is in the format used by PPAASSSSWWOORRDD__CCOONNSSTTRRAAIINNTTSS[51]. If any
                   password does not meet the requirements, a log message will
                   be emitted (which does not include the password itself).
                   The message will be tagged as audit and sensitive; please
                   refer to the LLOOGG__FFIILLTTEERR[52] directive. This feature can be
                   used to notify the administrator about weak passwords.

                   The directive value can be a variable name, which is
                   matched exactly against the _P_A_S_S_W_O_R_D or _A_U_X_I_L_I_A_R_Y
                   arguments, or a keyword in one of the OPTION directives
                   within the same clause. In this form, the
                   PASSWORD_CONSTRAINTS directive must be configured and its
                   value is used as the constraint. In the second form, the
                   directive value is a variable name as in the first form,
                   followed by spaces or tabs, followed by the constraint
                   string to use in the syntax of PASSWORD_CONSTRAINTS.
                   Consider the following directives:

                       PASSWORD_CONSTRAINTS "8L,1C,1P"

                       <Auth id="auth1">
                         URL "https://foo.example.com/cgi-bin/dacs/local_woof_authenticate"
                         STYLE "pass"
                         CONTROL "sufficient"
                         PASSWORD_AUDIT "PASSWORD 10L"
                         PASSWORD_AUDIT "AUXILIARY"
                       </Auth>

                   Here, the _P_A_S_S_W_O_R_D argument must be at least ten characters
                   long but _A_U_X_I_L_I_A_R_Y must only be eight characters long and
                   include an upper case character and punctuation.

                       NNoottee
                       Not all authentication modules require a _P_A_S_S_W_O_R_D
                       argument, such as llooccaall__ccaass__aauutthheennttiiccaattee[53] in its
                       interactive mode. This directive is ignored if the
                       argument is not passed to the module.

               PREDICATE (Optional1)
                   If provided, this expression is evaluated before any other
                   authentication module processing is done. If there is an
                   evaluation error or it returns FFaallssee (zero or the empty
                   string), processing continues just as if the module were
                   run and indicated that authentication failed. Otherwise,
                   processing of the clause continues normally.

                   This directive provides a way to effectively enable or
                   disable a module based on run time context. This can be
                   used to configure layered authentication or risk-based
                   authentication because a predicate can examine various
                   aspects of an authentication request, such as the _U_S_E_R_N_A_M_E,
                   current date and time, IP address from where the request
                   originates, and so on.

               STYLE (Required1)
                   Each authentication module implements one or more
                   authentication styles. The value of the STYLE directive is
                   a comma-separated list of case-insensitive style names and
                   style options; the order is insignificant. No whitespace is
                   allowed. Keywords can be abbreviated up to the indicated
                   minimum.

                   cas
                       This style selects username/password authentication
                       using the CCeennttrraall AAuutthheennttiiccaattiioonn SSeerrvviiccee ((CCAASS))[54]
                       protocol through the llooccaall__ccaass__aauutthheennttiiccaattee[53]
                       authentication module.

                   cert[ificate]
                       An X.509 client certificate, obtained from the SSL
                       layer, will be provided for authentication. The request
                       must be sent using SSL and the client certificate must
                       be provided by AAppaacchhee through the SSSSLL__CCLLIIEENNTT__CCEERRTT
                       environment variable.

                   digest
                       This selects the RRFFCC 22661177[55] Digest Access
                       Authentication scheme as implemented by DDAACCSS in
                       conjunction with the llooccaall__aappaacchhee__aauutthheennttiiccaattee[56]
                       authentication module. See HHTTTTPP AAuutthheennttiiccaattiioonn[5].

                   expr
                       No authentication module will be used; eexxpprreessssiioonn
                       eevvaalluuaattiioonn[50] will be used instead.

                   infocard
                       A self-issued or managed IInnffoorrmmaattiioonn CCaarrdd[57]
                       (InfoCard) must be provided for authentication. To be
                       recognized, the InfoCard must have been previously
                       registered at this jurisdiction using
                       ddaaccssiinnffooccaarrdd((11))[58], ddaaccss__iinnffooccaarrdd((88))[59], or
                       ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[60]. This style is implemented
                       by the llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee[61] authentication
                       module.

                   managed_infocard
                       A managed IInnffoorrmmaattiioonn CCaarrdd[57] (InfoCard) must be
                       provided for authentication. To be recognized, the
                       InfoCard must have been previously registered at this
                       jurisdiction using ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[60]. This
                       style is implemented by the
                       llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee[61] authentication module.

                   nat[ive]
                       The user is expected to have already authenticated
                       through the web server's native authentication
                       mechanism (e.g., HTTP Basic or Digest authentication);
                       DDAACCSS will import this identity without any additional
                       requirements. The AAUUTTHH__TTYYPPEE environment variable but be
                       available and have the value Basic or Digest (case
                       insensitive), and the RREEMMOOTTEE__UUSSEERR environment variable
                       must be set.

                   pass[word]
                   passwd
                       The username must be provided through a _U_S_E_R_N_A_M_E
                       argument and the password must accompany the
                       authentication request through a _P_A_S_S_W_O_R_D argument.

                   prompt[ed]
                       A dialog-based interaction will be conducted, such as
                       one based on Pluggable Authentication Modules (PAM).
                       See llooccaall__ppaamm__aauutthheennttiiccaattee.

                   selfissued_infocard
                       A self-issued IInnffoorrmmaattiioonn CCaarrdd[57] (InfoCard) must be
                       provided for authentication. To be recognized, the
                       InfoCard must have been previously registered at this
                       jurisdiction using ddaaccssiinnffooccaarrdd((11))[58] or
                       ddaaccss__iinnffooccaarrdd((88))[59]. This style is implemented by the
                       llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee[61] authentication module.

                   simple
                       This style of authentication merely requires a
                       recognized username, provided through a _U_S_E_R_N_A_M_E
                       argument and therefore offers little security. Still,
                       it can be used in appropriate situations to
                       authenticate a user that can provide a valid account
                       name, which might be a membership number or randomly
                       generated (and perhaps hard to guess) username. If a
                       _P_A_S_S_W_O_R_D argument is provided, it is logged as
                       sensitive data, much as an anonymous FTP password might
                       be logged. This style is implemented by the
                       llooccaall__ssiimmppllee__aauutthheennttiiccaattee[62] authentication module.

                   set_roles
                       If the authentication module returns roles, this option
                       says that they should override any other roles
                       currently in effect and no roles module should be
                       executed. This option may appear at most once among all
                       Auth clauses and only if aadddd__rroolleess[63] is not used.

                   add_roles
                       If the authentication module returns roles, this option
                       says that they should be appended to any other roles
                       currently in effect. Any configured roles modules will
                       still be executed. This option may be repeated in other
                       Auth clauses but may not appear if the sseett__rroolleess[64]
                       option also appears.

               URL (Optional1)
               URL* (Optional1)
                   Exactly one of these two directives must be specified,
                   except when STYLE is expr, where neither directive is used.
                   These directives specify the URL to be used to invoke the
                   authentication module; use of an absolute URL is
                   recommended.

                   The difference between the two directives is that the value
                   of URL* is an expression that is evaluated immediately
                   before the module is invoked to determine the URL to be
                   used.

                   In the current implementation, the standard set of modules
                   must run within the context of a DDAACCSS jurisdiction. This is
                   not an architectural limitation, however.

                       TTiipp
                       Some authentication modules are available as built-in
                       components of ddaaccss__aauutthheennttiiccaattee and ddaaccssaauutthh. These
                       modules are identified by specific relative URLs; a
                       module's description will provide its built-in name
                       when this capability is available. The built-in
                       capability will automatically be provided if the module
                       has been enabled at build-time.

                       Although it will be more efficient (and possibly more
                       secure) to use a built-in module, they are executed on
                       the same host as ddaaccss__aauutthheennttiiccaattee thereby giving up
                       some flexibility because access control rules are not
                       applied to them (other than the one for
                       ddaaccss__aauutthheennttiiccaattee), and ddaaccss__aauutthheennttiiccaattee may need to
                       be executed setuid root or setgid www so that it can
                       access password files. The same applies for ddaaccssaauutthh.

               Here is an example of a configuration that will authenticate
               using Unix user names and passwords:

                   <Auth id="passwd">
                     URL "https://foo.example.com:8443/cgi-bin/dacs/local_unix_authenticate"
                     STYLE "pass"
                     CONTROL "sufficient"
                   </Auth>

               In the following example, ddaaccss__aauutthheennttiiccaattee will first try to
               authenticate using a Unix login name and password; if that
               fails, it will then try a DDAACCSS account name and password.

                   <Auth id="passwd">
                     URL "https://foo.example.com:8443/cgi-bin/dacs/local_unix_authenticate"
                     STYLE "pass"
                     CONTROL "sufficient"
                   </Auth>

                   <Auth id="passwd2">
                     URL "https://foo2.example.com/cgi-bin/dacs/local_passwd_authenticate"
                     STYLE "pass"
                     CONTROL "sufficient"
                   </Auth>

               The preceding example can be changed to try authenticating
               using a DDAACCSS account name and password if and only if the
               _A_U_X_I_L_I_A_R_Y argument has the value "guest" (which might have been
               provided when the user selected a button on a login form):

                   <Auth id="passwd">
                     URL "https://foo.example.com:8443/cgi-bin/dacs/local_unix_authenticate"
                     STYLE "pass"
                     CONTROL "sufficient"
                     PREDICATE '${Args::AUXILIARY} ne "guest"'
                   </Auth>

                   <Auth id="passwd2">
                     URL "https://foo2.example.com/cgi-bin/dacs/local_passwd_authenticate"
                     STYLE "pass"
                     CONTROL "sufficient"
                     PREDICATE '${Args::AUXILIARY} eq "guest"'
                   </Auth>

               In this example, a jurisdiction offers users a choice from
               among three authentication methods: a Google(TM) account, a
               Windows NTLM account, or a DDAACCSS password-based account. The
               jurisdiction's login form would be written to provide the
               appropriate _A_U_T_H___I_D argument for the corresponding method;

                   # For AUTH_ID=google
                   <Auth id="google">
                     URL "local_http_authenticate"
                     STYLE "password"
                     CONTROL "user_sufficient"
                     OPTION 'AUTH_URL="https://www.google.com/accounts/ClientLogin"'
                     OPTION 'AUTH_METHOD=POST'
                     OPTION 'USERNAME_PARAMETER="Email"'
                     OPTION 'PASSWORD_PARAMETER="Passwd"'
                     OPTION 'service=xapi'
                     OPTION "source=DSS-DACS-1.4"
                   </Auth>

                   # For AUTH_ID=ntlm
                   <Auth id="ntlm">
                     URL "local__ntlm_authenticate"
                     STYLE "password"
                     CONTROL "user_sufficient"
                     OPTION 'SAMBA_SERVER="samba.example.com"'
                     OPTION 'SAMBA_PORT="139"'
                     EXIT* '${Auth::CURRENT_USERNAME}=strtr(${Auth::CURRENT_USERNAME}, "a-z", "A-Z")'
                   </Auth>

                   # For AUTH_ID=passwd
                   <Auth id="passwd">
                     URL "local_passwd_authenticate"
                     STYLE "password"
                     CONTROL "user_sufficient"
                   </Auth>


   IInniittiiaalliizzaattiioonn aanndd tthhee AAuutthh NNaammeessppaaccee
       ddaaccss__aauutthheennttiiccaattee uses a variable namespace called Auth to make
       authentication-related context available to its configuration
       directives (see ddaaccss..eexxpprrss((55))[65]). Aspects of ddaaccss__aauutthheennttiiccaattee's
       behaviour can be controlled by modifying these variables. This
       namespace disappears when ddaaccss__aauutthheennttiiccaattee terminates. The next
       section describes how these variables are used.

       Additionally, all environment variables are accessible through the Env
       namespace (e.g., _$_{_E_n_v_:_:_R_E_M_O_T_E___A_D_D_R_}) during authentication processing.

   AAuutthheennttiiccaattiioonn CCllaauussee CCoonnttrrooll FFllooww
       Auth clauses are processed in the order in which they appear in the
       configuration file, subject to the semantics of the CONTROL directives.

       ddaaccss__aauutthheennttiiccaattee is typically configured so that the last thing it
       does is to redirect its caller to an appropriate web page. If
       authentication is successful, any AAUUTTHH__SSUUCCCCEESSSS[66] expression is
       evaluated and the AAUUTTHH__SSUUCCCCEESSSS__HHAANNDDLLEERR[67] directive is consulted; if
       authentication fails, the AAUUTTHH__EERRRROORR__HHAANNDDLLEERR[68] and
       AAUUTTHH__FFAAIILL__DDEELLAAYY__SSEECCSS[69] directives are used. This behaviour is
       partially under the control of the caller through the
       _D_A_C_S___A_U_T_H___S_U_C_C_E_S_S___H_A_N_D_L_E_R[70] and _E_N_A_B_L_E___A_U_T_H___H_A_N_D_L_E_R_S[71] arguments,
       however.

           TTiipp
           To redirect the newly authenticated user to a web page based on the
           user's identity, jurisdiction, roles, or other contextual state,
           configure AUTH_SUCCESS_HANDLER to specify the URL of a DDAACCSS-wrapped
           CGI program. After examining environment variables automatically
           passed to it by DDAACCSS or its query arguments, this program can emit
           an appropriate redirect. To test this, configure:

               AUTH_SUCCESS_HANDLER "url /cgi-bin/dacs/dacs_prenv"

           (making sure that ddaaccss__pprreennvv((88))[72] has been installed) and examine
           the information that is available.

       An Auth clause is processed in a sequence of steps, and with various
       hooks to provide fine-grained control. Only advanced DDAACCSS
       administrators usually need to be concerned with this level of detail.

       Before the first clause is examined, the variable
       _$_{_A_u_t_h_:_:_C_U_R_R_E_N_T___U_S_E_R_N_A_M_E_} is set to the empty string; this variable is
       automatically updated by ddaaccss__aauutthheennttiiccaattee. The contents of the Args,
       DACS, Conf, and Env nnaammeessppaacceess[65] are made available to all
       expressions evaluated during authentication module processing.
       Processing of each Auth clause is performed in the following sequence:

        1. If the clause has a PREDICATE directive, it is evaluated in the
           current context. If the value is not TTrruuee (including cases where
           the expression was invalid), processing of the clause terminates
           immediately with the same result as if its authentication had been
           unsuccessful.

        2. If a variable named _$_{_A_u_t_h_:_:_A_B_O_R_T_} has the value yes (case
           insensitive), authentication terminates. If the variable
           _$_{_A_u_t_h_:_:_M_O_D_U_L_E___S_K_I_P_} has the value yes (case insensitive),
           processing of the clause terminates immediately with the same
           result as if its authentication had been unsuccessful.

        3. If the clause has an INIT* directive, it is evaluated; if an error
           occurs, authentication terminates.

        4. If the clause has a URL directive, it names the authentication
           module to be invoked (or is the name of a built-in module).

           If the URL* directive is used instead, it is evaluated to obtain
           the URL to be invoked; if an error occurs, authentication
           terminates.

        5. If a variable named _$_{_A_u_t_h_:_:_A_B_O_R_T_} has the value yes (case
           insensitive), authentication terminates. If the variable
           _$_{_A_u_t_h_:_:_M_O_D_U_L_E___S_K_I_P_} has the value yes (case insensitive),
           processing of the clause terminates immediately with the same
           result as if its authentication had been unsuccessful.

        6. If the clause's STYLE is expr, the EXPR directive is evaluated and
           is expected to either return FFaallssee or a valid DDAACCSS username. If the
           expression's value is FFaallssee, processing of the clause terminates
           immediately with the same result as if its authentication had been
           unsuccessful; if its value is an invalid username, authentication
           terminates, otherwise the module is deemed to have been successful.
           If an error occurs, authentication terminates.

           If the clause's STYLE is not expr, the authentication module is
           invoked.

        7. If an error occurs while executing the authentication module,
           authentication terminates. If the authentication module does not
           authenticate the user, the CONTROL directive determines whether
           authentication fails or continues.

           The username passed to the module, or returned by the module,
           becomes the tentative DDAACCSS username and the variable
           _$_{_A_u_t_h_:_:_C_U_R_R_E_N_T___U_S_E_R_N_A_M_E_} is set to it. If the variable
           _$_{_A_u_t_h_:_:_R_O_L_E_S_} is set to a valid role descriptor, it becomes the
           current tentative roles for the user.

        8. The expression given by the EXIT* directive, if any, is evaluated.
           If an error occurs, authentication terminates. The expression may
           update _$_{_A_u_t_h_:_:_C_U_R_R_E_N_T___U_S_E_R_N_A_M_E_}. For instance, the directive:

               EXIT* '${Auth::CURRENT_USERNAME}="bobo"'

           completely ignores the username returned by the module and simply
           assigns one, while this directive:

               EXIT* '${Auth::CURRENT_USERNAME} = \
                      strtr(${Auth::CURRENT_USERNAME}, "A-Z", "a-z")'

           converts all upper case characters in the username returned by the
           module to their lower case equivalents.

        9. If a variable named _$_{_A_u_t_h_:_:_A_B_O_R_T_} has the value yes (case
           insensitive), authentication terminates despite success of the
           module. If the variable _$_{_A_u_t_h_:_:_M_O_D_U_L_E___S_K_I_P_} has the value yes
           (case insensitive), processing of the clause terminates immediately
           with the same result as if its authentication had been
           unsuccessful.

       The value of _$_{_A_u_t_h_:_:_C_U_R_R_E_N_T___U_S_E_R_N_A_M_E_} when the last module has been
       processed is the username that will be assigned to a successfully
       authenticated user. If set, the value of
       _$_{_A_u_t_h_:_:_C_R_E_D_E_N_T_I_A_L_S___L_I_F_E_T_I_M_E___S_E_C_S_} will be used as the lifetime of the
       generated credentials; if not set, the value returned by the last
       successful authentication module is used (typically that of the
       module's CREDENTIALS_LIFETIME_SECS directive), if available, or the
       jurisdiction's CREDENTIALS_LIFETIME_SECS directive's value.

   AAuutthheennttiiccaattiinngg UUssiinngg aann EExxpprreessssiioonn
       Rather than using an authentication module, the expr style of
       authentication involves evaluating an expression. The value of the
       expression is the DDAACCSS username to associate with the user. If no value
       is returned, an invalid value is returned, or an error occurs, the Auth
       clause fails.

       Here is a simple example that is unlikely to be used in practice. If
       the _P_A_S_S_W_O_R_D argument is "xyzzy", then authentication will succeed and
       the user will be assigned the DDAACCSS username bobo.

           <Auth id="expr1">
             STYLE "expr"
             CONTROL "sufficient"
             EXPR '${Args::PASSWORD} eq "xyzzy" ? "bobo" : ""'
           </Auth>

       This example illustrates how an expression can be used to read a
       password (its hex-encoded SHA-256 hash, actually) from a file and
       compare it with the one provided in the service request. Each user has
       his own password file that consists of a single line of text containing
       the hash. If a username is given that does not have a corresponding
       password file, or if the hash of the provided password does not match
       the stored one, the Auth clause will fail, otherwise the given username
       is returned as the authenticated name.

           <Auth id="expr5">
           STYLE "expr"
           EXPR '${pwd} = get("/usr/local/dacs/pwd/pwd." . ${Args::USERNAME}); \
             digest(${Args::PASSWORD}, 0, sha256) eq decode(hex, ${pwd}) \
                 ? ${Args::USERNAME} : ""'
           CONTROL "sufficient"
           </Auth>

       The expression can also assign a valid role string to _$_{_A_u_t_h_:_:_R_O_L_E_S_} to
       establish roles for the user (in conjunction with the aadddd__rroolleess[63] or
       sseett__rroolleess[64] style option):

           <Auth id="expr2">
             STYLE "expr,add_roles"
             CONTROL "sufficient"
             EXPR '${Auth::ROLES}="foo,bar"; ${Args::PASSWORD} eq \
               "xyzzy" ? "bobo" : ""'
           </Auth>

       This style of authentication can be a useful alternative to the cert
       style with the llooccaall__cceerrtt__aauutthheennttiiccaattee module. If the client has
       provided an X.509 certificate that has been adequately verified by the
       web server, then in many cases all that remains to be done is to assign
       a syntactically valid DACS username to the client.  EEnnvviirroonnmmeenntt
       vvaarriiaabblleess[73] created by mmoodd__ssssll[74] can be referenced as
       _$_{_A_u_t_h_:_:_s_s_l___v_a_r_i_a_b_l_e___n_a_m_e_}. Something such as the following might be
       suitable:

           <Auth id="expr3">
             STYLE "expr"
             CONTROL "sufficient"
             EXPR '${Auth::SSL_CLIENT_VERIFY} eq "SUCCESS" and
               ${Auth::SSL_CLIENT_S_DN_Email:ei} \
                   ? ${Auth::SSL_CLIENT_S_DN_Email:i} : ""'
           </Auth>

       Another application of this style of authentication is where it is the
       location of the user that is important rather than the user's identity
       _p_e_r _s_e. For example, if a system administrator needs to restrict access
       to a web server to the hosts in a lab or desktops in a group of offices
       (that presumably share a subnet) but does not require individual users
       to authenticate, a configuration like the following might be adequate:

           <Auth id="expr4">
             STYLE "expr"
             CONTROL "sufficient"
             EXPR '${Auth::CURRENT_USERNAME} = "user-${Env::REMOTE_ADDR}"'
           </Auth>

       A user would not provide a username or a password; by simply clicking
       on a link that invokes ddaaccss__aauutthheennttiiccaattee, a user from the computer with
       IP address 10.0.0.213 (for example) would be assigned the identity
       user-10.0.0.213. Access control rules could be expressed in terms of
       those identities or the corresponding IP addresses.

   MMiiddddlleewwaarree SSuuppppoorrtt
       As with most DDAACCSS web services, the _F_O_R_M_A_T argument can be used to
       request a particular type of output (see ddaaccss..sseerrvviicceess((88))[75]) from
       ddaaccss__aauutthheennttiiccaattee. If any XML type is specified, the reply from
       ddaaccss__aauutthheennttiiccaattee will conform to the DTD ddaaccss__aauutthh__rreeppllyy..ddttdd[76]. The
       reply indicates whether the user has been successfully authenticated or
       not. If authentication was successful, a description of the new
       credentials is returned as a dacs_current_credentials element, (as
       described by ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss..ddttdd[77]). If authentication was
       unsuccessful because of a transient error condition, a reason may
       optionally be provided.

           SSeeccuurriittyy
           This reason is solely used to inform the user; it should not reveal
           any details that might compromise security.

       Authentication modules return an aauutthh__rreeppllyy..ddttdd[78] document to
       ddaaccss__aauutthheennttiiccaattee.

   AAuutthheennttiiccaattiioonn MMoodduulleess
           IImmppoorrttaanntt
           DDAACCSS provides a set of authentication modules. At the time DDAACCSS is
           compiled, some standard modules are enabled by default while others
           needed must be specifically enabled (see ddaaccss..iinnssttaallll((77))[79]). You
           should not enable authentication modules that you do not plan to
           use.

           SSeeccuurriittyy
           +o   As a security measure, these modules should be executable only
               by ddaaccss__aauutthheennttiiccaattee, which is the default.

           +o   By default, access control rules are configured to restrict
               access to all authentication and roles modules. This prevents
               an attacker from calling an authentication module directly in
               an attempt to guess account names, passwords, and so on.

           +o   Modules may need to be installed setuid or setgid as
               appropriate so that it is possible for them to read the
               password files that they require or obtain encryption keys.

           +o   Modules may need to be installed setuid or setgid, and never
               run as the UID of a less-privileged user, so that it is
               impossible to circumvent the module's functionality (e.g., by
               attaching to the running module with a debugger).

       Each authentication module is called with the following arguments.
       Authentication modules are always invoked using the POST method.

       _A_U_X_I_L_I_A_R_Y
           The value of the _A_U_X_I_L_I_A_R_Y argument to ddaaccss__aauutthheennttiiccaattee if one was
           given, otherwise the empty string.

       _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N
           The value of the _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N argument to ddaaccss__aauutthheennttiiccaattee.

       _D_A_C_S___V_E_R_S_I_O_N
           The DACS_VERSION_NUMBER for this version of ddaaccss__aauutthheennttiiccaattee.

       _P_A_S_S_W_O_R_D
           The value of the _P_A_S_S_W_O_R_D argument to ddaaccss__aauutthheennttiiccaattee if one was
           given, otherwise the empty string.

       _U_S_E_R_N_A_M_E
           The value of the _U_S_E_R_N_A_M_E argument to ddaaccss__aauutthheennttiiccaattee.

       Directives
           Each directive in the Auth section being processed and its value is
           passed.

       SSL environment variables
           Each SSL environment variable passed to ddaaccss__aauutthheennttiiccaattee is
           passed.

       Transaction state data
           With respect to the prompted style of authentication, transaction
           state variables are passed.
       Ordinarily, a particular argument may not appear more than once.

       AAuutthheennttiiccaattiioonn MMoodduullee IInnddeexx::

        1. local_apache_authenticate: Password-protected accounts maintained
           by AAppaacchhee utilities

        2. local_cas_authenticate: Central Authentication Service (CAS)

        3. local_cert_authenticate: SSL-based X.509 client certificates

        4. local_grid_authenticate: Grid-based one-time passwords

        5. local_http_authenticate: Generic authentication via HTTP

        6. local_infocard_authenticate: Information Card-based accounts and
           identities

        7. local_ldap_authenticate: Lightweight Directory Access Protocol
           (LDAP) / Microsoft Active Directory

        8. local_native_authenticate: Importing an identity established by
           AAppaacchhee

        9. local_ntlm_authenticate: Microsoft Windows NT LAN Manager usernames
           and passwords

       10. local_pam_authenticate: Pluggable Authentication Modules (PAM)

       11. local_passwd_authenticate: Password-protected DDAACCSS accounts

       12. local_simple_authenticate: Account name without a password

       13. local_token_authenticate: One-time passwords, two-factor
           authentication

       14. local_unix_authenticate: Unix usernames and passwords

       llooccaall__aappaacchhee__aauutthheennttiiccaattee
           The llooccaall__aappaacchhee__aauutthheennttiiccaattee module is used to authenticate
           against password files used by the AAppaacchhee mmoodd__aauutthh[80],
           mmoodd__aauutthh__ddiiggeesstt[81], or mmoodd__aauutthh__ddbbmm[82] modules. These password
           files are managed by AAppaacchhee''ss hhttppaasssswwdd((11))[83], hhttddiiggeesstt((11))[84], and
           hhttddbbmm((11))[85] utilities, respectively. An administrator can
           configure DDAACCSS to use an existing htpasswd file, for instance, and
           so avoid dealing with creating and managing a duplicate set of
           usernames and passwords.

           If Basic authentication is used, the STYLE should be password. If
           Digest authentication is used, because no password is passed to
           DDAACCSS, the STYLE for this module should be configured as digest.

           The following configuration options are recognized by this module.
           They should be provided using the OPTION directive.

           AUTH_MODULE
               This must be "mod_auth" (or "htpasswd"), "mod_auth_digest" (or
               "htdigest"), or "mod_auth_dbm" (or "htdbm"), depending on which
               module's authentication method is to be used. This value is
               case-insensitive.

           AUTH_FILE
               This is the absolute pathname of the flat-file or database file
               to use.

                   NNoottee
                   This pathname is resolved on the host that runs this
                   module. This should eventually be extended to accept a DDAACCSS
                   virtual filestore URI.

           DBM_TYPE
               Required only in conjunction with mod_auth_dbm compatibility,
               this argument identifies the database format of AUTH_FILE. The
               names "sdbm" (not yet implemented), "gdbm", "ndbm", and "db"
               are recognized, although not all types may be available on a
               particular platform.

               NNootteess
               +o   This module does not rely on any AAppaacchhee module (other than
                   mmoodd__aauutthh__ddaaccss).

               +o   This module does not require any AAppaacchhee configuration with
                   respect to authentication; only DDAACCSS needs to be
                   configured.

               +o   It is not necessary to use DDAACCSS''ss HHTTTTPP AAuutthheennttiiccaattiioonn[5]
                   feature in order to use this module. For example, using
                   Basic authentication, the _U_S_E_R_N_A_M_E and _P_A_S_S_W_O_R_D arguments
                   can be submitted from a site's login page and verified by
                   this module against an hhttppaasssswwdd file.

               +o   hhttppaasssswwdd allows plaintext passwords to be stored in a
                   password file, although hhttttppdd apparently restricts the use
                   of these passwords. This module imposes no such
                   restrictions. Under normal circumstances passwords should
                   not be stored in plaintext form.

               +o   The major difference between this module and
                   llooccaall__nnaattiivvee__aauutthheennttiiccaattee[86] is that the latter "imports"
                   an identity already established by an AAppaacchhee authentication
                   module, whereas this module authenticates using information
                   that can also be used by AAppaacchhee and which is administered
                   using AAppaacchhee utiltities.

               +o   DDAACCSS will access AAppaacchhee password files in read-only mode
                   only; DDAACCSS never modifies those files.

               +o   Some platforms may not support all possible DBM-type
                   databases and some types of database may not have been
                   configured at build-time.

           Here is an example configuration that uses an hhttppaasssswwdd-managed file
           for authentication:

               HTTP_AUTH_ENABLE "yes"
               HTTP_AUTH "Basic \"DACS Basic Auth Area\" /restricted/*"

               <Auth id="apache-htpasswd">
               URL "https://example.com/cgi-bin/dacs/local_apache_authenticate"
               STYLE "pass"
               CONTROL "sufficient"
               OPTION "AUTH_FILE=/usr/local/apache2/conf/passwords"
               OPTION "AUTH_MODULE=mod_auth"
               </Auth>

           If the passwords were kept in a Berkeley DB database instead, the
           configuration might look like:

               HTTP_AUTH_ENABLE "yes"
               HTTP_AUTH "Basic \"DACS Basic Auth Area\" /restricted/*"

               <Auth id="apache-htpasswd">
               URL "https://example.com/cgi-bin/dacs/local_apache_authenticate"
               STYLE "pass"
               CONTROL "sufficient"
               OPTION "AUTH_FILE=/usr/local/apache2/conf/passwords.db"
               OPTION "AUTH_MODULE=mod_auth_dbm"
               OPTION "DBM_TYPE=db"
               </Auth>

           This example configuration is similar; the difference is that the
           username and password obtained through HTTP Basic authentication
           are verified against a Unix account:

               HTTP_AUTH_ENABLE "yes"
               HTTP_AUTH "Basic \"DACS Basic Auth Area\" /private/*"

               <Auth id="basic">
               URL "https://example.com/cgi-bin/dacs/local_unix_authenticate"
               STYLE "pass"
               CONTROL "sufficient"
               </Auth>

           This example configures HTTP Digest authentication and references
           an hhttddiiggeesstt-managed file:

               HTTP_AUTH_ENABLE "yes"
               HTTP_AUTH "Digest \"DACS Digest Auth Area\" /digest/*"

               <Auth id="apache-htdigest">
               URL "apache"
               STYLE "digest"
               CONTROL "sufficient"
               OPTION "AUTH_FILE=/usr/local/apache2/conf/passwords.digest"
               OPTION "AUTH_MODULE=mod_auth_digest"
               </Auth>


               TTiipp
               A built-in version of this module can be selected by using the
               URL local_apache_authenticate or just apache.

       llooccaall__ccaass__aauutthheennttiiccaattee
           This module coordinates with a specified CCeennttrraall AAuutthheennttiiccaattiioonn
           SSeerrvviiccee ((CCAASS))[54] server to authenticate a user that is purportedly
           known to that server. The module implements the client side of the
           CCAASS 22..00 PPrroottooccooll[87] and can be used in two different modes:
           interactive and non-interactive.

           Interactive mode is employed if neither a _U_S_E_R_N_A_M_E nor a _P_A_S_S_W_O_R_D
           argument is given to ddaaccss__aauutthheennttiiccaattee. When ddaaccss__aauutthheennttiiccaattee is
           called, whether directly or as the result of redirection after
           access was denied to an unauthenticated user, it redirects the user
           to a CAS login page. After successful CAS authentication (which may
           return a ticket granting cookie to the user's browser), CAS
           redirects the user to ddaaccss__aauutthheennttiiccaattee, passing it the CAS session
           ticket as an argument called _t_i_c_k_e_t. After successfully validating
           the session ticket at the CAS server, DDAACCSS authentication succeeds.

               SSeeccuurriittyy
               When interactive mode is used, DDAACCSS does not see the username
               and password, only CAS does. The username is obtained by the
               module as part of the session ticket validation protocol. This
               mode of operation is similar to, but simpler than, the
               OOppeennIIDD[88] Authentication protocol.

           A variant of this flow of control can occur if the user has
           authenticated against the CAS server outside of DDAACCSS and therefore
           holds a ticket granting cookie. This cookie will automatically be
           sent by the user's browser when it is redirected to the CAS server;
           as a result, the CAS server may not prompt the user to
           authenticate.

           In non-interactive mode, both a _U_S_E_R_N_A_M_E _a_n_d a _P_A_S_S_W_O_R_D argument
           are passed to ddaaccss__aauutthheennttiiccaattee. This module will use these
           arguments to authenticate the user against the CAS server. In this
           mode, no ticket granting cookie will be returned to the user. This
           mode can be used with the DDAACCSS HHTTTTPP aauutthheennttiiccaattiioonn[5] feature.

           The STYLE should be configured as cas for this module.

           The following module-specific OPTION directive value is understood:

           CAS_SERVER_URI (Required1)
               This is the URI of the CAS server to authenticate against. For
               example, dacs.conf might contain authentication configuration
               similar to the following:

                   <Auth id="CAS">
                   URL "cas"
                   STYLE "cas"
                   CONTROL "sufficient"
                   OPTION "CAS_SERVER_URI=https://cas.example.com/castest"
                   </Auth>


           The module recognizes the following arguments (which are
           automatically passed to it as necessary by ddaaccss__aauutthheennttiiccaattee):

           CAS_TICKET (Required1-C)
               This is the session ticket returned by CAS via a callback to
               ddaaccss__aauutthheennttiiccaattee (i.e., the _t_i_c_k_e_t argument).

           CAS_REDIRECT_ARGS (Optional1)
               These are additional arguments to ddaaccss__aauutthheennttiiccaattee that must
               be provided when CAS performs its callback to ddaaccss__aauutthheennttiiccaattee
               to preserve user preferences. The _D_A_C_S___B_R_O_W_S_E_R, _F_O_R_M_A_T,
               _D_A_C_S___E_R_R_O_R___U_R_L, and _E_N_A_B_L_E___A_U_T_H___H_A_N_D_L_E_R_S arguments may be
               forwarded in this way.

           CAS_SERVER_URI (Required1-C)
               This argument has the value specified in the Auth clause's
               OPTION directive. Note that HTTP redirects are not handled in
               this context, so invoking GET on CAS_SERVER_URI must return a
               valid document.

               NNoottee
               The llooccaall__ccaass__aauutthheennttiiccaattee module extends the response of the
               vvaalliiddaattee service of the CAS protocol to allow a role descriptor
               string (_r_o_l_e___s_t_r_i_n_g) to be returned. If authentication
               succeeds, the standard service returns the following text:
                yes\n_u_s_e_r_n_a_m_e\n

               An invalid role string is discarded. If these roles should be
               used, it will be necessary to use either the sseett__rroolleess[64] or
               aadddd__rroolleess[63] style option with the SSTTYYLLEE[89] directive.

               TTiipp
               The authentication procedure described by the CAS protocol is
               notable because the authentication material provided by the
               user in interactive mode _d_o_e_s _n_o_t _f_l_o_w _t_h_r_o_u_g_h DDAACCSS; in
               particular, DDAACCSS does not see a user's password when this
               module is used. This may be an important consideration in some
               environments.

               Because the protocol implemented by this module is general
               purpose and relatively simple, writing middleware that
               implements a subset of the server-side CAS protocol to
               interface with this module may be a sensible solution for DDAACCSS
               administrators who require a CAS-like control flow but do not
               want to use actual CAS server-side software. The user would be
               redirected to the middleware component by
               llooccaall__ccaass__aauutthheennttiiccaattee to perform the /login service; then it
               would prompt and authenticate the user, and redirect the user
               to a URL provided to it by llooccaall__ccaass__aauutthheennttiiccaattee; then
               llooccaall__ccaass__aauutthheennttiiccaattee would call the middleware component
               directly, this time to perform the /validate service. The usual
               flow of control within DDAACCSS would follow.

               A simple script for testing and working with
               llooccaall__ccaass__aauutthheennttiiccaattee is available in src/cas_middleware_test.

               TTiipp
               A built-in version of this module can be selected by using the
               URL local_cas_authenticate or just cas.

       llooccaall__cceerrtt__aauutthheennttiiccaattee
           The llooccaall__cceerrtt__aauutthheennttiiccaattee module authenticates a user that
           supplies an acceptable X.509 client certificate via SSL.  AAppaacchhee
           must be appropriately configured to request and verify client
           certificates, check for revocation, and so on (see
           SSSSLLVVeerriiffyyCClliieenntt[90] and related directives). As part of the SSL
           protocol, AAppaacchhee's mmoodd__ssssll[74] module verifies that the client
           possesses the private key that corresponds to the client
           certificate.  AAppaacchhee will usually be configured to verify the
           correctness and suitability of the client certificate.  AAppaacchhee
           directives such as SSSSLLRReeqquuiirree[91] might be used, for example.

           The STYLE should be configured as certificate for this module.

           The verification of the client certificate done by AAppaacchhee may be
           sufficient, in which case the only remaining configuration task for
           the Auth clause is to assign a username and possibly extract role
           information from the certificate; it may impose additional tests on
           the certificate, however, by inspecting its fields. If verification
           beyond the ability of mmoodd__ssssll[74] is required, or if it needs to be
           performed on a system other than where the web server is running,
           llooccaall__cceerrtt__aauutthheennttiiccaattee can execute an external program to decide
           whether the client certificate is suitable for authentication. This
           program is currently limited to OOppeennSSSSLL[92] but this may be
           generalized in future versions.

           To ensure that llooccaall__cceerrtt__aauutthheennttiiccaattee is able to obtain
           information contained within the client certificate, AAppaacchhee must be
           configured so that SSttddEEnnvvVVaarrss and EExxppoorrttCCeerrttDDaattaa are enabled in an
           appropriate SSSSLLOOppttiioonnss[93] directive, such as the following:

               SSLOptions +StdEnvVars +ExportCertData

           The following configuration directives are specific to this module:

           CERT_CA_PATH (Required1)
               This is the absolute pathname of a directory that contains
               trusted certificates. Refer to the --CCAAppaatthh argument to
               OOppeennSSSSLL's verify command.

           CERT_DUMP_CLIENT (Optional1)
               If configured, this gives the absolute pathname of a file to
               which the client certificate is to be written in PEM format.
               The file is created or truncated, as necessary. This is useful
               for debugging purposes.

           CERT_NAME_ATTR (Optional1)
               If this directive is configured, it gives the name of an SSSSLL
               eennvviirroonnmmeenntt vvaarriiaabbllee[73]. The value of that variable is used as
               a key for the certnamemap item type (which must also be
               configured); the key's value becomes the username returned by
               the module (if the environment variable is not found or the
               lookup is unsuccessful, the module will fail to authenticate
               the user). If the module is not fully configured for this
               lookup, the value of the _U_S_E_R_N_A_M_E is returned by the module.

               To illustrate this, consider the following configuration:

                   VFS "[certmap]dacs-kwv-fs:/usr/local/dacs/federations/certnamemap"

                   <Auth id="cert">
                     URL "https://example.com/cgi-bin/dacs/local_cert_authenticate"
                     STYLE "cert"
                     CONTROL "sufficient"
                     CERT_CA_PATH "/usr/local/apache2/conf/ssl.crt"
                     CERT_NAME_ATTR "SSL_CLIENT_S_DN_CN"
                   </Auth>

               with the file /usr/local/dacs/federations/certnamemap
               containing the two lines:

                   Clark Kent:superman
                   Bruce Wayne:batman

               Given the configuration above, if the value of the
               SSSSLL__CCLLIIEENNTT__SS__DDNN__CCNN environment variable is "Clark Kent", the
               username returned by the module will be "superman".

               As with any module, an expression can be used within an Auth
               clause to modify or override the value returned by a module.

           CERT_OPENSSL_PATH (Optional1)
               This is the absolute pathname of the ooppeennssssll program. If not
               provided, a build-time value is used (_O_P_E_N_S_S_L___P_A_T_H).

               SSeeccuurriittyy
               The lifetime of credentials obtained through the local
               authentication service may be independent of the validity
               period of the certificate presented for authentication. It is
               therefore possible for the certificate to expire before the
               DDAACCSS credentials. The local authentication service might take
               this into consideration before granting access and when
               computing a lifetime for the resulting DDAACCSS credentials.

       llooccaall__ggrriidd__aauutthheennttiiccaattee
           This module works in concert with the ddaaccssggrriidd((11))[94] utility to
           provide users with one-time passwords. It is also an approximation
           of the "something you have" factor of two-factor authentication.

           The STYLE should be configured as password for this module.

           Please refer to ddaaccssggrriidd((11))[94] for a complete description.

           In addition to the usual _U_S_E_R_N_A_M_E argument, the module requires the
           _P_A_S_S_W_O_R_D argument to be the user's response to the challenge and
           the _A_U_X_I_L_I_A_R_Y argument to be the encoded challenge. The latter two
           arguments must be produced by ddaaccssggrriidd((11))[94].

           The following OPTION directive values are understood:

           AUTH_GRID_CHALLENGE_SECS (Optional1)
               The number of seconds between when a challenge is created and
               when it expires, overriding the default value. This value
               should be relatively small, at most on the order of a few tens
               of seconds. If this module runs on a host other than the one
               running ddaaccss__aauutthheennttiiccaattee, the two system clocks must be
               suitably synchronized.

           AUTH_GRID_LIFETIME_SECS (Optional1)
               The length of time, in seconds, for which a grid is valid.
               After this period, all authentication against a grid will fail.

               TTiipp
               A built-in version of this module can be selected by using the
               URL local_grid_authenticate or just grid.

       llooccaall__hhttttpp__aauutthheennttiiccaattee
           This module authenticates by invoking a given (non-interactive) web
           service with specified arguments. If the web service reports
           success by returning HTTP status code 220000 (see RRFFCC 22661166[95],
           Section 10), then the module succeeds, otherwise it fails. Any
           output, including cookies, returned by the web service is
           discarded. No session is established with the web service and no
           additional requests are made to it; the web service is used solely
           to determine whether a username/password is correct.

           This module can be used to authenticate against any existing web
           service that follows the expected protocol, or can provide a way to
           add a new, custom authentication method to DDAACCSS.

           The STYLE should be configured as password for this module.

           The following OPTION directive values are understood:

           AUTH_URL (Required1)
               The URL to invoke, which may use either the http or https
               scheme.

           AUTH_METHOD (Optional1)
               The HTTP method to use to invoke AUTH_URL. The default is POST.
               Keep in mind that if query arguments are present (or if the GET
               method is used) they may appear in log files.

           USERNAME_PARAMETER (Required1)
               The name of the argument by which _U_S_E_R_N_A_M_E is passed. The
               default is _U_S_E_R_N_A_M_E.

           PASSWORD_PARAMETER (Required1)
               The name of the argument by which _P_A_S_S_W_O_R_D is passed. The
               default is _P_A_S_S_W_O_R_D.

           Any other OPTION directive values are simply passed to the web
           service. Duplicate argument names will be passed.

           For GGooooggllee[96](TM) aaccccoouunntt aauutthheennttiiccaattiioonn[97], for instance, the
           following configuration might be used:

               <Auth id="google">
               URL "local_http_authenticate"
               STYLE "password"
               CONTROL "required"
               OPTION 'AUTH_URL="https://www.google.com/accounts/ClientLogin"'
               OPTION 'USERNAME_PARAMETER=Email'
               OPTION 'PASSWORD_PARAMETER=Passwd'
               OPTION 'service=xapi'
               OPTION "source=DSS-DACS-1.4"
               </Auth>

           This web service returns an HTTP status code of 220000 if the correct
           username and password are given (i.e., login succeeded), and 440033 if
           login fails. If CClliieennttLLooggiinn fails and requests a CAPTCHA challenge
           the request will not be passed back to the user.

               NNoottee
               One of the reasons for inclusion of this module is to support
               reuse of accounts widely used by the public. Google(TM)
               provides exactly the right interface needed by systems such as
               DDAACCSS. Accounts provided by eeBBaayy[98](TM)and YYaahhoooo!![99](R), for
               instance, do not appear to be directly usable in this way. In
               some cases, ddaaccss__aauutthh__ttrraannssffeerr((88))[8] may be a better approach
               than this module.

               TTiipp
               A built-in version of this module can be selected by using the
               URL local_http_authenticate or just http.

       llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee
           The llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee module performs DDAACCSS authentication
           using an IInnffoorrmmaattiioonn CCaarrdd[57] (InfoCard) previously registered at
           the jurisdiction. Self-issued InfoCards are registered using
           ddaaccss__iinnffooccaarrdd((88))[59] or ddaaccssiinnffooccaarrdd((11))[58]. Managed InfoCards are
           also supported, provided they have been registered using
           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[60] and include a dacs_identity claim in
           the DDAACCSS namespace.  DDAACCSS aims to conform to IIddeennttiittyy SSeelleeccttoorr
           IInntteerrooppeerraabbiilliittyy PPrrooffiillee ((IISSIIPP)) 11..55[100].

           A DDAACCSS rroollee ddeessccrriippttoorr ssttrriinngg[101] can be associated with a managed
           InfoCard through the dacs_roles claim name in the DDAACCSS namespace
           (see ddaaccss__iinnffooccaarrdd((88))[102]. These roles can be associated with new
           credentials via the aadddd__rroolleess[63] and sseett__rroolleess[64] options.

               SSeeccuurriittyy
               At present, to be valid for authentication, the dacs_identity
               claim value must specify a user at the current jurisdiction;
               that is, it cannot specify an identity at a jurisdiction other
               than the one where authentication is being performed.

           The authentication style infocard causes the module to accept
           either type of InfoCard - the type of InfoCard actually used will
           be available in the resulting credentials. The styles
           managed_infocard and selfissued_infocard tell the module to limit
           authentication to managed InfoCards or self-issued InfoCards,
           respectively. When invoked as a web service,
           llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee understands an optional argument, _T_Y_P_E,
           that may have the value "selfissued" or "managed" to restrict
           authentication to the corresponding InfoCard type; the default
           behaviour accepts either type of InfoCard.

               TTiipp
               The eexxpprreessssiioonn--bbaasseedd aauutthheennttiiccaattiioonn ssttyyllee[103], which does not
               employ this module, provides an alternative way to support
               InfoCard-based authentication. It is somewhat more complicated
               to use, however, and may require a small amount of programming.

           For additional information about InfoCards, please refer to:

           +o   ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[104], ddaaccss..ccoonnff((55))[105] (the INFOCARD_
               prefixed directives), ddaaccss__mmeexx((88))[106], and ddaaccss__ssttss((88))[107].

           +o   UUssiinngg IInnffooCCaarrddss WWiitthh DDAACCSS[108], Distributed Systems Software
               (July, 2009).

           +o   _I_d_e_n_t_i_t_y _S_e_l_e_c_t_o_r _I_n_t_e_r_o_p_e_r_a_b_i_l_i_t_y _P_r_o_f_i_l_e _s_p_e_c_i_f_i_c_a_t_i_o_n _a_n_d
               _c_o_m_p_a_n_i_o_n _g_u_i_d_e_s[109] (August, 2008).

           +o   _I_n_t_r_o_d_u_c_i_n_g _W_i_n_d_o_w_s _C_a_r_d_S_p_a_c_e[110] (April, 2006).


           TTiipp
           A built-in version of this module can be selected by using the URL
           local_infocard_authenticate or just infocard.

       llooccaall__llddaapp__aauutthheennttiiccaattee
           The llooccaall__llddaapp__aauutthheennttiiccaattee module performs DDAACCSS authentication
           using the Lightweight Directory Access Protocol, also known as
           LDAP, (see RRFFCC 22225511[111], RRFFCC 22225522[112], RRFFCC 22225533[113], RRFFCC
           33337777[114], and many others). This form of authentication can be
           used with Microsoft's AAccttiivvee DDiirreeccttoorryy ((AADDSS))[115].  OOppeennLLDDAAPP[116]
           is used to supply LDAP client support.

           The STYLE should be configured as password for this module.

           In general, authentication using LDAP is challenging because an
           LDAP name (a distinguished name, or DN) is typically long and often
           has a site-specific structure. For this reason, this module often
           requires more local expertise for configuring and testing than
           other DDAACCSS authentication modules. At least a basic familiarity
           with LDAP will be required to configure this module.

           The module implements two different approaches to authentication:

            1. In the direct method, which is the simpler and more efficient
               approach, the _U_S_E_R_N_A_M_E argument is directly mapped to the
               corresponding DN. The module binds to that DN using the given
               _P_A_S_S_W_O_R_D. If the bind operation succeeds, the user has been
               authenticated.

            2. When the simpler method is not possible, the indirect method
               can be used to bind to the directory as an LDAP administrator
               (or an identity with the ability to search the appropriate
               portion of the directory tree) and perform an LDAP search
               operation for a directory entry having an attribute that
               matches the _U_S_E_R_N_A_M_E argument. If the search returns exactly
               one entry, it binds to that entry's DN using the _P_A_S_S_W_O_R_D
               argument; if the bind operation succeeds, the user has been
               authenticated.

       Regardless of the approach, after successful authentication it may be
       necessary to map the _U_S_E_R_N_A_M_E or the DN into a valid DDAACCSS username.

       The following configuration directives are specific to this module:

       LDAP_ADMIN_PASSWORD (Optional1)
           This is the password for the LDAP administrator account that
           corresponds to LDAP_ADMIN_URL.

       LDAP_ADMIN_URL (Required1-C)
           If the indirect method is used, this directive is required. This
           value is a URI like LDAP_USERNAME_URL except that it identifies the
           LDAP directory's administrator. Example:

               LDAP_ADMIN_URL
                 "ldap://example.com/cn=Administrator, cn=Users, dc=example, dc=com"


       LDAP_BIND_METHOD (Required1-C)
           This directive tells the module to use the direct method, indirect
           method, or both methods (case insensitive). When both are used, the
           indirect method is attempted only if the direct method fails.

       LDAP_ROLES_SELECTOR* (Optional)
           Since LDAP directory operations are usually relatively expensive,
           this module can return role information for the authenticated user,
           avoiding a second LDAP operation during Roles clause processing.
           Roles are typically extracted from information in the user's
           directory entry. Each occurrence of this directive specifies an
           expression that is evaluated by iterating through each attribute of
           the entry and making the attribute name (_$_{_L_D_A_P_:_:_a_t_t_r_n_a_m_e_}) and its
           value (_$_{_L_D_A_P_:_:_a_t_t_r_v_a_l_u_e_}) available. All of the entry's attribute
           names and values are made available within the LDAP namespace. If
           the result of the expression is a valid role string (which excludes
           the empty string, ""), it is added to the list of roles.

           An example:

               LDAP_ROLES_SELECTOR* '"${LDAP::attrname}" eq "memberOf" \
                   ? strtr(ldap(rdn_attrvalue, \
                       ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") \
                   : ""'

           For each instance of the entry's memberOf attribute, this
           expression selects the least significant (left-most) component of
           the attribute value (a DN) using llddaapp(())[117] and converts spaces to
           underscores. If the user's entry contains:

               memberOf: CN=Domain Guests,CN=Users,DC=example,DC=com
               memberOf: CN=Guests,CN=Builtin,DC=example,DC=com

           the resulting roles would be Domain_Guests and Guests.

               NNoottee
               These roles are discarded unless the SSTTYYLLEE[89] directive for
               this module allows the roles to be incorporated into the user's
               credentials.

       LDAP_SEARCH_FILTER (Required1-C)
           If the indirect method is used, either this directive or
           LDAP_SEARCH_FILTER* (but not both) must be configured. This search
           filter is used to select the unique directory entry that
           corresponds to this user.

       LDAP_SEARCH_FILTER* (Required1-C)
           If the indirect method is used, either this directive or
           LDAP_SEARCH_FILTER (but not both) must be configured. This search
           filter is used to select the unique directory entry that
           corresponds to this user. This directive is exactly like
           LDAP_SEARCH_FILTER except that it is evaluated just before it is
           used, allowing various elements of the execution context to appear
           in the string. Example:

               LDAP_SEARCH_FILTER* '"(sAMAccountName=${Args::USERNAME})"'


       LDAP_SEARCH_ROOT_DN (Required1-C)
           This is the root DN at which the indirect method should begin
           searching for user entries.

       LDAP_TIMEOUT_SECS (Optional1)
           This is a maximum time limit, in seconds, for any individual LDAP
           read or search operation performed by the module. If not specified,
           there will not be an application-specified time limit.

       LDAP_USERNAME_EXPR* (Optional1)
           If authentication succeeds, this directive is evaluated to yield
           the DDAACCSS username returned to ddaaccss__aauutthheennttiiccaattee. All of the entry's
           attribute names and values are made available within the LDAP
           namespace. If unspecified, the value of the _U_S_E_R_N_A_M_E parameter is
           returned. Example:

               LDAP_USERNAME_EXPR* '"${LDAP::sAMAccountName}"'


       LDAP_USERNAME_URL (Optional1)
           If the direct method is used, either this directive or
           LLDDAAPP__UUSSEERRNNAAMMEE__UURRLL**[118] (but not both) must be configured. This
           directive identifies both the LDAP server to use and the user being
           authenticated. The value of this directive is a URI (see RRFFCC
           22339966[119] and RRFFCC 33998866[120]) that gives the name of the LDAP server
           to contact to authenticate the user (as the scheme and authority
           part of the URI) and the DN for the user (as the path part of the
           URI). The scheme must be either ldap or ldaps (case insensitive).
           If no port number is specified, 338899 is used with the former scheme
           and 663366 with the latter.

               LDAP_USERNAME_URL
                 '"ldap://example.com/cn=Auggie%20Doggie, cn=Users, dc=example, dc=com"'


               SSeeccuurriittyy
               The ldaps scheme is not implemented. Communication between this
               module and the LDAP server should use a secure channel or at
               least not be snoopable.

       LDAP_USERNAME_URL* (Optional1)
           If the direct method is used, either this directive or
           LDAP_USERNAME_URL (but not both) must be configured. This directive
           is exactly like LDAP_USERNAME_URL except that it is evaluated just
           before it is used, allowing various elements of the execution
           context to appear in the string. Example:

               LDAP_USERNAME_URL*
                 '"ldap://example.com/cn=${Args::USERNAME}, cn=Users, dc=example, dc=com"'


           TTiipp
           Before using LDAP authentication with DDAACCSS, you should first make
           sure that your LDAP server is functioning as you expect and that
           the host that will run the llooccaall__llddaapp__aauutthheennttiiccaattee module can
           communicate with the LDAP server.

           One way to do this is to use the llddaappsseeaarrcchh((11))[121] command (found
           in the clients/tools directory of the OpenLDAP distribution) to
           bind to the directory and perform some searches. You should run
           this command on the same machine that will be running DDAACCSS's LDAP
           authentication module (llooccaall__llddaapp__aauutthheennttiiccaattee). Some of the
           information that you obtain from this exercise may be helpful when
           you configure DDAACCSS to use this form of authentication.

           Here are some examples to try - you must adapt the names for your
           environment:

               % ./ldapsearch -h win2k.example.com -x -b "dc=example,dc=com" \
                    -D "CN=Administrator,CN=Users,DC=example,DC=com" -W -LLL
               % ./ldapsearch -h win2k.example.com -x -b "dc=example,dc=com" \
                    -D "CN=Auggie Doggie,CN=Users,DC=example,DC=com" -W -LLL
               % ./ldapsearch -h win2k.example.com -x -b "dc=example,dc=com" \
                    -D "CN=Administrator,CN=Users,DC=example,DC=com" -W -LLL \
                    "(cn=Administrator)" memberOf
               % ./ldapsearch -h win2k.example.com -x -b "dc=example,dc=com" \
                    -D "CN=Administrator,CN=Users,DC=example,DC=com" -W -LLL \
                    "(sAMAccountName=auggie)"

           In these examples, the LDAP server runs on a host named
           win2k.example.com (so change win2k.example.com, example, and com),
           and it expects a user named "Auggie Doggie" to exist and have the
           account name "auggie" (again, change to names that exist in your
           LDAP directory). You should be prompted for the LDAP password (in
           Windows, that will be the login password) for either Administrator
           or a user named "Auggie Doggie", depending on the argument that
           follows the --DD flag.

       The following configuration illustrates authentication using this
       module:

           <Auth id="ldap">
             URL "https://example.com/cgi-bin/dacs/local_ldap_authenticate"
             STYLE "password,add_roles"
             CONTROL "required"
             LDAP_BIND_METHOD "direct"
             LDAP_USERNAME_URL* '"ldap://windows.example.com/cn=" \
                . encode(url, ${Args::USERNAME}) . ",cn=Users,dc=example,dc=com"'
             LDAP_USERNAME_EXPR* '"${LDAP::sAMAccountName}"'
             LDAP_ROLES_SELECTOR* '"${LDAP::attrname}" eq "memberOf" \
               ? strtr(ldap(rdn_attrvalue, \
                   ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") \
               : 0'
           </Auth>

       Here, the LDAP authentication module will construct a DN by plugging
       the user-provided _U_S_E_R_N_A_M_E argument into the template and binding to
       that DN with the _P_A_S_S_W_O_R_D argument. If successful, the DDAACCSS username
       will be the value of the user's entry's sAMAccountName attribute, and
       roles will extracted from the entry's memberOf attribute values, as
       described above.

           NNoottee
           In Windows, the SAM-Account-Name Active Directory attribute value
           (sAMAccountName) need not be the same as the entry's Common Name;
           for instance, the former might be "doggie" and the latter
           "CN=Auggie Doggie". The sAMAccountName must not exceed 20
           characters in length and must be unique within the domain. It is
           composed of printable characters other than the following:

               \   /   [   ]   :   ;   |   =   ,   +   *   ?   <   >   @   "

           The userPrincipalName attribute value is a user account name (or
           "user login name") that is unique within its domain and a domain
           name identifying the domain in which the user account is located.
           The format is the same as a domain-name based email address; e.g.,
           doggie@example.com.

       llooccaall__nnaattiivvee__aauutthheennttiiccaattee
           The llooccaall__nnaattiivvee__aauutthheennttiiccaattee module transfers a user's current,
           context-dependent web server identity to a DDAACCSS identity. The web
           server will most likely have used RRFFCC 22661177[55] Basic or Digest
           authentication. The user, having already been authenticated by the
           web server at a particular jurisdiction, will automatically be
           given DDAACCSS credentials associated with that jurisdiction and
           typically having the same username.

           The STYLE should be configured as native for this module.

           This method of authentication also depends on a CGI helper program
           (aauuttoollooggiinn((88))[122]) and appropriate configuration of AAppaacchhee
           authentication. The general idea is that the helper program must be
           executable only by users that have been properly authenticated by
           the web server (by any AAppaacchhee method and using any AAppaacchhee
           authentication module). The helper program then invokes
           ddaaccss__aauutthheennttiiccaattee with appropriate arguments; if this module has
           been enabled and accepts its arguments, the user will be given DDAACCSS
           credentials.

           There are no directives or options specific to this module.

       llooccaall__nnttllmm__aauutthheennttiiccaattee
           The llooccaall__nnttllmm__aauutthheennttiiccaattee module authenticates users through
           Windows NT LAN Manager using the NTLM protocol [11[123], 22[124]].
           This module, which makes use of SSaammbbaa[125] libraries, provides
           Windows NNTTLLMM aauutthheennttiiccaattiioonn[126] based on a username and password.
           The module does not need to be (and will not usually be) executed
           on the host running Windows.

           The STYLE should be configured as password for this module.

           The following OPTION directive values are understood:

           SAMBA_SERVER (Required1)
               The domain name or numeric IP address of the Windows system
               providing NTLM authentication.

           SAMBA_PORT (Optional1)
               The port number to use on SAMBA_SERVER. The default is 0, which
               tells Samba to use a sequence of default ports until one works.

           SAMBA_DOMAIN (Optional1)
               The domain name to use on SAMBA_SERVER. The default is "".

           The module-specific option SAMBA_SERVER must be given to provide
           the domain name of the host providing the NTLM authentication. The
           module-specific options SAMBA_DOMAIN and SAMBA_PORT, which are
           optional, can be used to override the default port(s) used by Samba
           to contact SAMBA_SERVER.

           The following illustrates how this module might be configured:

               <Auth id="ntlm">
                 URL "https://example.com/cgi-bin/dacs/local_ntlm_authenticate"
                 STYLE "pass"
                 CONTROL "sufficient"
                 OPTION 'SAMBA_SERVER="10.0.0.123"'
                 OPTION 'SAMBA_PORT="139"'
               </Auth>

           Here, ddaaccss__aauutthheennttiiccaattee will invoke the NTLM authentication module
           at the given URL. That module will try to authenticate the username
           and password given to it by asking the NTLM service at port 139 on
           the Windows system at 10.0.0.213.

           There are no directives specific to this module.

               SSeeccuurriittyy
               Communication between this module and the NTLM service should
               use a secure channel or at least not be snoopable.

               TTiipp
               +o   A built-in version of this module can be selected by using
                   the URL local_ntlm_authenticate or just ntlm.

               +o   Before attempting to use this module, it may save a lot of
                   time and aggravation if you first check that it is possible
                   to authenticate against NTLM, _f_r_o_m _t_h_e _m_a_c_h_i_n_e _o_n _w_h_i_c_h _y_o_u
                   _i_n_t_e_n_d _t_o _r_u_n _t_h_i_s _m_o_d_u_l_e, using a username/password
                   combination that you know is correct. If you are not able
                   to successfully authenticate in this way, obviously you
                   will not have any luck with the DDAACCSS module.

                   To test whether it is possible to authenticate using a
                   particular username and password, you may be able to use
                   ssmmbbcclliieenntt((11))[127]. For example, if C:\Shared is a network
                   shared folder or HPLaserJ-PS is a shared printer on the
                   Windows machine on which you want to perform
                   authentication, to authenticate as the Administrator try
                   something like:

                       % smbclient //mywinhost/shared -U Administrator

                   or to authenticate as the user bob, try:

                       % smbclient //mywinhost/HPLaserJ-PS -U bob

                   Replace _m_y_w_i_n_h_o_s_t with the name of your Windows machine.
                   You should be prompted for the account's password. If
                   ssmmbbcclliieenntt successfully connects and establishes a session
                   using the username and password you provide, then this
                   module should also be able to authenticate that user,
                   otherwise you should see an error message.

                   After you have configured DDAACCSS, you can test
                   llooccaall__nnttllmm__aauutthheennttiiccaattee from the command line. You will
                   need to set the environment variable QQUUEERRYY__SSTTRRIINNGG and
                   specify the --uu, --uujj, or --uuss command line flag (see
                   ddaaccss((11))[128]).

                   For example, using your preferred shell's syntax, from the
                   distribution's src directory, try something like:

                       % QUERY_STRING="USERNAME=bob&PASSWORD=test&DACS_JURISDICTION=Test\
                       &SAMBA_SERVER=windows.example.com"
                       % export QUERY_STRING
                       % ./local_ntlm_auth -uj Test

                   Change "bob" to the username you want to authenticate,
                   "test" to the password for that username, "Test" to the
                   name of the DDAACCSS jurisdiction that will perform the
                   authentication, and "windows.example.com" to the domain
                   name of the Windows machine where the user's account is.
                   You may also need to specify _S_A_M_B_A___P_O_R_T. The output, an XML
                   document, will indicate success ("ok", exit status 0) or
                   failure ("failed", exit status 1). Repeat this with an
                   invalid password to make sure that it fails.

       llooccaall__ppaamm__aauutthheennttiiccaattee
           This module makes a local or remote Pluggable Authentication
           Modules (PAM) infrastructure available for authentication. PAM
           authenticates a user that is known to the PAM-capable operating
           system (i.e., a user with an existing account) through one or more
           PAM authentication service modules that have been configured by the
           system administrator. Other PAM operations, such as password
           management, are currently unsupported by DDAACCSS. Please refer to
           XX//OOppeenn SSiinnggllee SSiiggnn--OOnn SSeerrvviiccee ((XXSSSSOO)) ---- PPlluuggggaabbllee
           AAuutthheennttiiccaattiioonn[48] for additional information about PAM.

               NNoottee
               By default, the ppaammdd server uses "dacs" as the name of the PAM
               policy (see ppaamm__ssttaarrtt((33))[129]). Some systems may revert to a
               default policy (such as "other") if no "dacs" policy is
               defined. A policy name can be specified as a ppaammdd argument.

           There is a huge selection of open source and vendor-supplied PAM
           authentication modules for a wide variety of platforms, including
           some that provide functionality similar to that of DDAACCSS
           authentication modules [GGNNUU//LLiinnuuxx[130], FFrreeeeBBSSDD[131],
           SSoollaarriiss[132]]. For example, ppaamm__uunniixx((88))[133] performs essentially
           the same authentication function as llooccaall__uunniixx__aauutthheennttiiccaattee[134],
           except that the latter is not interactive (it does not prompt).

           The STYLE should be configured as prompted for this module.

               NNoottee
               While this authentication module has been tested with only a
               few PAM authentication service modules, in theory it should
               work with any conformant PAM authentication module. If this
               module is used, the current implementation does not allow any
               other authentication modules to be configured for the
               jurisdiction; this can be partially ameliorated by configuring
               PAM to try multiple PAM modules.

               IImmppoorrttaanntt
               The llooccaall__ppaamm__aauutthheennttiiccaattee module depends on functionality
               provided by ppaammdd((88))[135] running on a PAM-capable system, which
               does not need to be the same host where llooccaall__ppaamm__aauutthheennttiiccaattee
               is run. The llooccaall__ppaamm__aauutthheennttiiccaattee module establishes
               connections with ppaammdd, which interacts with the ppaamm((33))[47]
               library. Unlike the other DDAACCSS authentication styles,
               authentication using the prompted style may involve more than
               one request to ddaaccss__aauutthheennttiiccaattee, each of which supplies
               additional authentication material.

               The prompted authentication style implements a _s_e_s_s_i_o_n between
               the user and the PAM library that consists of a sequence of
               operations that comprise a PAM _t_r_a_n_s_a_c_t_i_o_n. For each operation,
               ddaaccss__aauutthheennttiiccaattee (via llooccaall__ppaamm__aauutthheennttiiccaattee and ppaammdd)
               supplies the PAM library with authentication material (either
               initial data or data requested by the PAM library from the
               previous operation), determines if authentication has succeeded
               or failed, or whether the user must be prompted for additional
               data. If the PAM library requires additional data, the user is
               prompted for it, and the response is submitted to
               ddaaccss__aauutthheennttiiccaattee in the transaction's next operation.

           If PAM requires information from the user, llooccaall__ppaamm__aauutthheennttiiccaattee
           can be configured to prompt for it using one of three methods. The
           first method is used if the Auth clause has an OPTION directive
           that configures PAM_HANDLER_URL; the user will be redirected to
           this URL. The other possibilities are selected by the _F_O_R_M_A_T
           argument (see ddaaccss..sseerrvviicceess((88))[75]). If any XML type is specified,
           the reply from ddaaccss__aauutthheennttiiccaattee will conform to the DTD
           ddaaccss__aauutthh__rreeppllyy..ddttdd[76]. If HTML is specified and PAM
           authentication requires additional information from the user,
           ddaaccss__aauutthheennttiiccaattee will return a rudimentary HTML form that must be
           completed and submitted by the user. For example, if ppaamm__uunniixx is
           configured, ddaaccss__aauutthheennttiiccaattee may emit a web page that prompts for
           a username (if none was provided with the initial invocation of
           ddaaccss__aauutthheennttiiccaattee), and after that form has been submitted by the
           user emit a web page that prompts for a password.

           If PAM_HANDLER_URL is configured, the handler to which the
           administrator redirects users has complete control over user
           prompting. In most implementations, the handler will emit a web
           page that includes a form element, with appropriate inputs and
           hidden variables, which is submitted to the web service named in
           the _s_e_r_v_i_c_e argument (see below). The handler is required to obtain
           values for a set of requested variables and submit them to a given
           URL (ddaaccss__aauutthheennttiiccaattee). Each variable has a type, an optional
           descriptive text label, and a name. The value of PAM_HANDLER_URL
           may either be an absolute URL or a web service name, beginning with
           a '/', that is interpreted relative to the current jurisdiction
           (i.e., the ddaaccss__uurrll[136] is prepended). Query arguments may be
           included, provided none of the argument names used by
           ddaaccss__aauutthheennttiiccaattee, described below, are duplicated.

           The ppaammdd server requires the handler to respond within 6600 seconds
           (configured at compile time). The llooccaall__ppaamm__aauutthheennttiiccaattee module
           requires ppaammdd to respond to the initial request with the first
           prompt within 2200 seconds (configured at compile time). Should the
           handler encounter a serious error, it can simply terminate; this
           will cause ppaammdd to eventually time out, which will abort the PAM
           transaction.

               SSeeccuurriittyy
               The handler does not have to be DDAACCSS-wrapped, but ideally it
               should be. If it is, don't forget to add an access control rule
               to grant access to any user that might authenticate through
               llooccaall__ppaamm__aauutthheennttiiccaattee.

           This "prompter" service might be configured as follows:

               OPTION "PAM_HANDLER_URL=/dacs_pam_handler"

           This will be expanded into a URL that looks something like
           https://example.com/cgi-bin/dacs/dacs_pam_handler. When a user is
           redirected to this handler, ddaaccss__aauutthheennttiiccaattee adds the following
           query arguments:

           +o    _s_e_r_v_i_c_e: This is the URL of the ddaaccss__aauutthheennttiiccaattee service to
               which the handler must submit the requested values. This URL
               will not include any query arguments. Because private
               information, such as a password, may be present, it will
               typically use the https scheme. The handler should use the POST
               method to invoke _s_e_r_v_i_c_e.

           +o    _C_S_S___P_A_T_H: This is the path configured for HTML stylesheets.

           +o    _A_U_T_H___T_R_A_N_S_I_D: This is the unique transaction identifier for
               this PAM interaction. As part of a single authentication
               transaction, the handler may be called several times with the
               same _A_U_T_H___T_R_A_N_S_I_D. The handler is not required to retain state
               between these calls, but it may do so. The handler must pass
               this argument when calling _s_e_r_v_i_c_e. Although the lifetime of
               this identifier is relatively brief, it should be kept private
               by the handler.

           +o    _a_u_t_h___p_r_o_m_p_t___v_a_r___p_r_e_f_i_x: Each requested value will be
               identified by an argument to _s_e_r_v_i_c_e having this prefix, with a
               positive integer (_i_n_t, which is assigned consecutive integers
               starting with 11) appended. For instance, if
               _a_u_t_h___p_r_o_m_p_t___v_a_r___p_r_e_f_i_x is "AUTH_PROMPT_VAR", then the handler
               must submit the requested values as _A_U_T_H___P_R_O_M_P_T___V_A_R_1,
               _A_U_T_H___P_R_O_M_P_T___V_A_R_2, and so on. The first absent _i_n_t value signals
               the end of the variable argument list.

           +o    _T_Y_P_E_i_n_t: This is the type ("text", "password", or "error") of
               the variable numbered _i_n_t. The password type indicates the
               value should not be displayed during user input.

           +o    _L_A_B_E_L_i_n_t: This argument, which is optional, indicates a label
               that might be displayed beside the user prompt (e.g.,
               "Username?") for variable _i_n_t.

           +o    _N_A_M_E_i_n_t: If this argument is not present for a given _i_n_t, then
               no value is required for this variable - presumably _L_A_B_E_L_i_n_t is
               informational. If _N_A_M_E_i_n_t is present, it gives the name of the
               variable to use when the handler submits the value. For
               example, suppose the handler is called with arguments _T_Y_P_E_2 as
               "text", _L_A_B_E_L_2 as "Login:", and _N_A_M_E_2 as "AUTH_PROMPT_VAR2".
               This asks the handler to prompt for text input labeled
               "Login:". If the user submits the value "Auggie", then included
               with the arguments to _s_e_r_v_i_c_e there should be a variable named
               _A_U_T_H___P_R_O_M_P_T___V_A_R_2 with the value "Auggie".

       Any other arguments to the handler should be forwarded to _s_e_r_v_i_c_e
       verbatim. Such arguments include _D_A_C_S___V_E_R_S_I_O_N, _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N,
       _D_A_C_S___B_R_O_W_S_E_R, and _E_N_A_B_L_E___A_U_T_H___H_A_N_D_L_E_R_S.

           NNoottee
           For testing purposes, it may be helpful to set PAM_HANDLER_URL to
           ddaaccss__pprreennvv, which will display the arguments passed to the handler
           and other context. The DDAACCSS distribution includes an example
           handler, html/handlers/dacs_pam_handler.

       If an HTML form is emitted, its appearance can be customized somewhat
       through the default stylesheet llooccaall__ppaamm__aauutthheennttiiccaattee..ccssss[137]. The
       content of the generated web page can be customized through the
       local_pam_authenticate VFS item type. The following items relative to
       that item type are emitted if they exist:

       +o   header: Initial HTML to emit instead of the default.

       +o   prologue: HTML to emit immediately after the header.

       +o   instructions: HTML to emit immediately after the prologue and
           before the form.

       +o   form: Additional HTML to emit within the form.

       +o   epilogue: HTML to emit immediately after the form.

       +o   trailer: Final HTML to emit instead of the default.

       For example, consider the configuration directive:

           VFS "[local_pam_authenticate]dacs-fs:${Conf::DACS_HOME}/pam_auth"

       Here, pam_auth is the directory ${Conf::DACS_HOME}/pam_auth. If files
       named header and trailer exist in that directory, they are expected to
       contain the initial and final HTML content, respectively. These files
       consist of text and HTML markup but are not complete HTML documents.

       Customization of the HTML form is possible using configuration
       variables:

       +o    _p_r_o_m_p_t___s_u_b_m_i_t___l_a_b_e_l: the text label to put in the form's submit
           button.

       For example, the submit button's text can be specified using the
       directive:

           EVAL ${Conf::prompt_submit_label} = " Continue "


           TTiipp
           A built-in version of this module can be selected by using the URL
           local_pam_authenticate or just pam.

       llooccaall__ppaasssswwdd__aauutthheennttiiccaattee
           The llooccaall__ppaasssswwdd__aauutthheennttiiccaattee module provides support for DDAACCSS
           identities, strictly private to DDAACCSS, through password-protected
           accounts (similar to what AAppaacchhee's mmoodd__aauutthh[80] and
           mmoodd__aauutthh__ddbbmm[82] modules do, along with the hhttppaasssswwdd((11))[83]
           utility). A secure hash of a password is stored rather than the
           plaintext password itself. Several hashing methods are available
           (see PPAASSSSWWOORRDD__DDIIGGEESSTT[138]).

           The llooccaall__ppaasssswwdd__aauutthheennttiiccaattee module performs authentication by
           consulting the _U_S_E_R_N_A_M_E and _P_A_S_S_W_O_R_D parameters and comparing them
           to the information previously stored by the administrator.

               SSeeccuurriittyy
               This module always requires the _P_A_S_S_W_O_R_D argument and will not
               accept the empty string as a password value (even if that
               actually is the password). Use llooccaall__ssiimmppllee__aauutthheennttiiccaattee[62]
               for password-less accounts.

           The STYLE should be configured as password for this module.

           The ddaaccssppaasssswwdd((11))[139] utility is used to manage these accounts.
           The item type is "passwds".

           The following example configuration, which reflects typical usage,
           maintains user and password information in a plain text file named
           /usr/local/dacs/federations/passwd.

               VFS "[passwds]dacs-kwv-fs:/usr/local/dacs/federations/passwd"

           There are no directives or options specific to this module.

               NNoottee
               The name "local_passwd_authenticate" may be a little confusing
               because there are other modules that implement some form of
               password-based authentication. This module might more
               appropriately be called "local_dacspasswd_authenticate".

               TTiipp
               A built-in version of this module can be selected by using the
               URL local_passwd_authenticate or just passwd.

       llooccaall__ssiimmppllee__aauutthheennttiiccaattee
           The llooccaall__ssiimmppllee__aauutthheennttiiccaattee module supports DDAACCSS identities,
           strictly private to DDAACCSS, through accounts that are _n_o_t
           password-protected. The llooccaall__ssiimmppllee__aauutthheennttiiccaattee module performs
           authentication by looking up an account named by the _U_S_E_R_N_A_M_E
           argument. In typical use, the username will be an email address,
           account or membership number, or random character string.

               SSeeccuurriittyy
               This form of authentication is _i_n_h_e_r_e_n_t_l_y _i_n_s_e_c_u_r_e because no
               password is provided. It is only appropriate when the
               consequences of a valid account name being guessed or
               misappropriated are of little concern. Administrators should
               not assume that using difficult-to-guess account names with
               this module offers much security. Keep in mind that depending
               on the larger context of how these identities are used, these
               usernames may be publicly visible.

           The STYLE should be configured as simple for this module.

           The ddaaccssppaasssswwdd((11))[139] utility is used to manage these accounts.
           The item type is "simple".

           The following example configuration, which reflects typical usage,
           maintains user account information in a plain text file named
           /usr/local/dacs/federations/simple_accounts.

               VFS "[simple]dacs-kwv-fs:/usr/local/dacs/federations/simple_accounts"


               NNoottee
               Although it is possible to combine password-protected accounts
               and password-less accounts in the same VFS object (i.e., with
               the item types passwds and simple pointing to the same file or
               database), putting them in separate objects is recommended.

           There are no directives or options specific to this module.

               TTiipp
               A built-in version of this module can be selected by using the
               URL local_simple_authenticate or just simple.

       llooccaall__ttookkeenn__aauutthheennttiiccaattee
           This module works in concert with the ddaaccssttookkeenn((11))[140] utility to
           support one-time passwords. Two-factor authentication, a strong
           authentication method, is supported by combining hardware
           token-based one-time passwords ("something you have") with a PIN (a
           password, "something you know"). Software-based clients may also be
           used. The implementation follows RRFFCC 44222266[141], which has been
           adopted by OOAATTHH[142], and other standards. Please refer to
           ddaaccssttookkeenn((11))[140] for complete details.

           The STYLE should be configured as password for this module.

           In addition to the usual _U_S_E_R_N_A_M_E argument, the module requires the
           _P_A_S_S_W_O_R_D argument to be the next one-time password (e.g., the value
           produced by the user's hardware token). If the user's DDAACCSS account
           has a PIN associated with it, the PIN must be passed as the
           _A_U_X_I_L_I_A_R_Y argument. The PIN referred to here is the one managed by
           ddaaccssttookkeenn, not a PIN that may be entered into the token device to
           unlock it.

           One-time password generation depends on a secret that is shared
           between the client and DDAACCSS, and a non-repeating value that may be
           based on synchronized counters or clocks. The client's token can
           become unsynchronized with the server's state. This can happen for
           many reasons, such as if a password is generated by the device but
           not used, if a password or PIN is typed incorrectly, or because of
           a configuration error. The method can tolerate a configurable
           deviation of the client's token from the server's state; that is,
           provided the client's password falls within a window of _N from the
           one expected by DDAACCSS, DDAACCSS will accept the client's token. For
           counter-based tokens, only the "forward" side of the window is
           examined, so DDAACCSS can "catch up" to the client.

           If the user's password does not fall within the window, it is
           deemed to have become unsynchronized with llooccaall__ttookkeenn__aauutthheennttiiccaattee
           and authentication will fail. The user can attempt to resynchronize
           by entering a sequence of passwords as _P_A_S_S_W_O_R_D, using a comma to
           separate them. Three consecutive, valid passwords are required
           (this number can be configured at build time). If the account has a
           PIN, it must be provided to enable synchronization. If
           synchronization succeeds, the user's account information is
           corrected and the module also reports successful authentication. If
           synchronization fails, the module also fails and a DDAACCSS
           administrator must be contacted to resynchronize the token.

               NNoottee
               The token value must be entered exactly as it is displayed on
               the token. Leading zeroes must be typed, for example, and no
               spaces or punctuation are allowed. Whenever authentication
               fails, the user must obtain a new password from the token.

           The following OPTION directive value is understood:

           ACCEPT_WINDOW (Optional1)
               The (non-negative) size of the acceptance window for one-time
               passwords, overriding the default. If the size is zero, DDAACCSS
               will only consider a match with the expected password and will
               not try to match the user's password against "nearby"
               passwords. With some modes of operation, only forward matches
               are allowed.

               TTiipp
               A built-in version of this module can be selected by using the
               URL local_token_authenticate or just token.

       llooccaall__uunniixx__aauutthheennttiiccaattee
           The llooccaall__uunniixx__aauutthheennttiiccaattee module implements native Unix
           username/password authentication, allowing a user having a
           pre-existing Unix account to be authenticated by DDAACCSS using the
           username and password for that account. The ggeettppwwnnaamm((33))[143]
           library function is passed the _U_S_E_R_N_A_M_E and _P_A_S_S_W_O_R_D parameters
           given to ddaaccss__aauutthheennttiiccaattee. It can be configured for systems with
           or without shadow passwords. On some Unix systems, when the
           yypp((88))[144] password database is enabled, the ggeettppwwnnaamm((33))[143]
           function will use the YP map "passwd.byname" if the requested
           password entry is not found in the local database.

           The STYLE should be configured as password for this module.

               TTiipp
               A built-in version of this module can be selected by using the
               URL local_unix_authenticate or just unix. If the module is
               used, ddaaccss__aauutthheennttiiccaattee must be setuid root since it must be
               able to read the shadow password file.

   RRoolleess
       Each user authenticated by DDAACCSS may be associated with one or more
       roles. The ssyynnttaaxx ooff rroolleess aanndd rroollee ddeessccrriippttoorrss[14] is described
       elsewhere. Role-based group membership is discussed in
       ddaaccss..ggrroouuppss((55))[145]. Configuration of a Roles clause is optional and if
       none are specified, an empty role descriptor string will be used. If
       more than one Roles clause is configured, their role strings are
       concatenated (duplicates are not removed). If a roles service fails, it
       is treated as if it returned no roles and processing continues
       normally.

       Like authentication, a modular mechanism is used to find the roles with
       which a user is associated. A roles module, analogous to an
       authentication module, can be called by ddaaccss__aauutthheennttiiccaattee to return
       roles. A roles service returns a roles_reply element (see
       rroolleess__rreeppllyy..ddttdd[146]).

       Each Roles element must have an id attribute. Its value is merely a
       label (an alphabetic followed by zero or more alphanumerics, hyphens,
       and underscores) that allows the clause to be referenced. The id
       attribute values must be unique (case-sensitively) within the clause's
       Jurisdiction section.

           NNoottee
           A maximum limit is imposed on the length of a role descriptor
           string. Please refer to the RROOLLEE__SSTTRRIINNGG__MMAAXX__LLEENNGGTTHH[147] directive.

   RRoolleess CCllaauussee DDiirreeccttiivveess
       The roles directives are largely analogous to the authentication
       directives.

       When evaluation of the Roles clauses begins, several variables are
       available in the Auth namespace to reflect the outcome of
       authentication. These variables may be useful when determining the
       user's roles: _D_A_C_S___U_S_E_R_N_A_M_E, _D_A_C_S___I_D_E_N_T_I_T_Y, _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N, and
       _D_A_C_S___V_E_R_S_I_O_N.

       RRoolleess CCllaauussee DDiirreeccttiivveess IInnddeexx::

        1. EXIT* (Optional1)

        2. EXPR (Optional1)

        3. INIT* (Optional1)

        4. OPTION (Optional)

        5. OPTION* (Optional)

        6. PREDICATE (Optional1)

        7. URL (Optional1)

        8. URL* (Optional1)

       URL (Optional1)
       URL* (Optional1)
           Exactly one of these two directives must be specified, unless EXPR
           is specified, in which case neither URL nor URL* may be specified.
           These directives specify the URL to be used to invoke the roles
           module (or is the name of a built-in module). The difference
           between the two directives is that the value of URL* is an
           expression that is evaluated to determine the URL to be used; this
           evaluation occurs immediately before the module is invoked.

       INIT* (Optional1)
           An expression can be specified that is to be evaluated immediately
           prior to the URL* and EXPR expressions, all of which are evaluated
           before a module is invoked.

       EXIT* (Optional1)
           If authentication is successful, this expression is evaluated
           immediately after the module is executed or EXPR evaluated.

       EXPR (Optional1)
           This directive gives an expression that is evaluated to obtain
           roles instead of invoking a roles module. Please refer to Advanced
           Techniques.

       OPTION (Optional)
           Similar to the Auth clause's OOPPTTIIOONN[45] directive, this is used to
           pass an argument to the roles module. A given _n_a_m_e may not be
           specified more than once within a particular Roles clause. The
           Options namespace is initialized with _D_A_C_S___U_S_E_R_N_A_M_E,
           _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N, and _D_A_C_S___V_E_R_S_I_O_N variables. If these are
           specified by an OPTION, the argument ordinarily used will be
           overridden.

           For example:

               OPTION "PASSWORD=bobo"

           causes PASSWORD=bobo to be passed as a POST method parameter.

       OPTION* (Optional)
           The given expression is evaluated before the module is called, and
           after all OPTION directives and all OPTION* directives that appear
           earlier. The value of the expression must be a _n_a_m_e=_v_a_l_u_e pair, as
           with the OPTION directive, and overrides any _n_a_m_e in the Options
           namespace.

       PREDICATE (Optional1)
           If provided, this expression is evaluated before any other roles
           module processing is done. If there is an evaluation error or it
           returns FFaallssee (zero or the empty string), processing of the clause
           terminates and the next Roles clause, if any, is processed.
           Otherwise, processing of the clause continues normally.

   RRoolleess CCllaauussee CCoonnttrrooll FFllooww
       If authentication succeeds, Roles clauses are processed in which they
       appear, but only if sseett__rroolleess[64] has not been specified for some
       authentication module's STYLE.

       A Roles clause is processed in a sequence of steps, and with various
       hooks to provide fine-grained control. Before the first clause is
       examined, the variables _$_{_A_u_t_h_:_:_C_U_R_R_E_N_T___R_O_L_E_S_} and _$_{_A_u_t_h_:_:_L_A_S_T___R_O_L_E_S_}
       are initialized to the role string, if any, obtained during
       authentication module processing. Processing of each Roles clause
       proceeds as follows:

        1. If the clause has a PREDICATE directive, it is evaluated in the
           current context. If the value is not TTrruuee the clause is not
           evaluated further. No variables are updated. If the expression was
           invalid, processing of roles is terminated.

        2. If the clause has an INIT* directive, it is evaluated; if an error
           occurs, processing of roles is terminated.

        3. If the clause has a URL* directive, it is evaluated to obtain the
           URL of the DDAACCSS roles service to be invoked; if an error occurs,
           processing of roles is terminated. If the clause has an EXPR*
           directive, it is evaluated to obtain the role string; if an error
           occurs during evaluation it is treated as if the expression
           returned the empty string.

        4. If a roles service has been specified, it is invoked. If an error
           occurs, roles processing _c_o_n_t_i_n_u_e_s _a_s _i_f _t_h_e _m_o_d_u_l_e _r_e_t_u_r_n_e_d _t_h_e
           _e_m_p_t_y _s_t_r_i_n_g _f_o_r _t_h_e _r_o_l_e _s_t_r_i_n_g.

        5. The variable _$_{_A_u_t_h_:_:_L_A_S_T___R_O_L_E_S_} is set to the roles string
           returned by the module or expression.

        6. If the clause has an EXIT* directive, it is evaluated; if an error
           occurs, processing of roles is terminated. The value of
           _$_{_A_u_t_h_:_:_L_A_S_T___R_O_L_E_S_} becomes the role string returned by the clause.

        7. The role string returned by the clause is appended to the variable
           _$_{_A_u_t_h_:_:_C_U_R_R_E_N_T___R_O_L_E_S_}.

       The value of _$_{_A_u_t_h_:_:_C_U_R_R_E_N_T___R_O_L_E_S_} when the last module has been
       processed is the roles string that will be used in the generated
       credentials.

           TTiipp
           Some roles modules are available as built-in components of
           ddaaccss__aauutthheennttiiccaattee. These modules are identified by specific
           relative URLs; a module's description will provide its built-in
           name when this capability is available. The built-in capability
           will automatically be provided if the module has been enabled at
           build-time. The same applies for ddaaccssaauutthh.

           Although it will be more efficient (and possibly more secure) to
           use a built-in module, they are executed on the same host as
           ddaaccss__aauutthheennttiiccaattee (thereby giving up some flexibility), access
           control rules are not applied to them (other than the one for
           ddaaccss__aauutthheennttiiccaattee), and ddaaccss__aauutthheennttiiccaattee may need to be executed
           setuid (probably as root) or setgid (as www, for example) so that
           it can access password files.

   RRoolleess MMoodduulleess
       If and only if authentication succeeds, DDAACCSS can request the user's
       role descriptor from the jurisdiction. Roles modules are always invoked
       using the POST method and are passed the following arguments:

       _D_A_C_S___U_S_E_R_N_A_M_E
           The _u_s_e_r_n_a_m_e component of the user's DDAACCSS identity.

       _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N
           The name of the jurisdiction that authenticated _D_A_C_S___U_S_E_R_N_A_M_E.

       _D_A_C_S___V_E_R_S_I_O_N
           The DACS_VERSION_NUMBER for this version of ddaaccss__aauutthheennttiiccaattee.

       OPTION directives
           For each OOPPTTIIOONN ddiirreeccttiivvee[148] or OOPPTTIIOONN** ddiirreeccttiivvee[149] in the
           Roles section being processed, the variable name and its value are
           passed.
       Any of the standard web service arguments will also be accepted;
       anything else will be ignored.

       Roles modules return an rroolleess__rreeppllyy..ddttdd[146] document to
       ddaaccss__aauutthheennttiiccaattee.

           NNoottee
           Although there is a roles module for obtaining LDAP or ADS roles,
           you may also get them by authenticating through
           llooccaall__llddaapp__aauutthheennttiiccaattee[44] or by using a Roles clause with an
           appropriate EXPR directive.

       RRoolleess MMoodduullee IInnddeexx::

        1. local_roles: Private DDAACCSS roles

        2. local_ldap_roles: Roles imported from an LDAP/ADS directory

        3. local_unix_roles: Roles imported from Unix group membership

       llooccaall__rroolleess
           This roles service consults a private list to obtain a
           username-to-roles mapping using DDAACCSS virtual storage (the item type
           is "roles"). The following example configuration, which reflects
           typical usage, maintains mappings in a plain text file named
           /usr/local/dacs/federations/roles.

               VFS "[roles]dacs-kwv-fs:/usr/local/dacs/federations/roles"

           The file /usr/local/dacs/federations/roles might look something
           like this:

               admin:dacs,admin
               rick:metalogic,guests
               bobo:staff,users
               auggie:staff,users

           Here, user auggie is associated with the roles staff and users.

               TTiipp
               A built-in version of this module can be selected by using the
               URL local_roles or just roles.

       llooccaall__llddaapp__rroolleess
           This roles service returns roles derived from the attributes of a
           user's LDAP/ADS directory entry. This module is based on
           llooccaall__llddaapp__aauutthheennttiiccaattee[44]; please consult the description and
           examples presented with that authentication module for additional
           information.

               NNoottee
               The user need not have been authenticated by LDAP/ADS for this
               module to be used. For example, the user can be authenticated
               on a Unix system but his roles can come from LDAP/ADS.

           The following configuration directives are recognized by this
           module. They function identically to the directives of the same
           name used by llooccaall__llddaapp__aauutthheennttiiccaattee[44], so for the most part
           their descriptions will not be repeated here.

               NNoottee
               These module directives must be passed using either the
               OOPPTTIIOONN[148] or OOPPTTIIOONN**[149] directive. Ensure that the option
               value is properly quoted.

           LDAP_BIND_METHOD (Required1-C)
               This tells the module how to find the user's entry.

           LDAP_USERNAME_URL (Optional1)
           LDAP_USERNAME_URL* (Optional1)
               With the direct method, one of these options is used to name
               the user's entry as a URI.

           LDAP_ADMIN_URL (Required1-C)
               If the indirect method is used, this option is required. This
               value is a URI like LDAP_USERNAME_URL except that it identifies
               the LDAP directory's administrator.

           LDAP_ADMIN_PASSWORD (Optional1)
               This is the password for the LDAP administrator account that
               corresponds to LDAP_ADMIN_URL.

           LDAP_SEARCH_ROOT_DN (Required1-C)
               This is the root DN at which the indirect method should begin
               searching for user entries.

           LDAP_SEARCH_FILTER (Required1-C)
           LDAP_SEARCH_FILTER* (Required1-C)
               If the indirect method is used, either this option or
               LDAP_SEARCH_FILTER* (but not both) must be configured. This
               search filter is used to select the unique directory entry that
               corresponds to this user. The LDAP_SEARCH_FILTER* option is
               exactly like LDAP_SEARCH_FILTER except that it is evaluated
               just before it is used, allowing various elements of the
               execution context to appear in the string. The DDAACCSS username
               obtained from the preceding authentication phase can be
               referenced as _$_{_A_r_g_s_:_:_D_A_C_S___U_S_E_R_N_A_M_E_}.

           LDAP_USERNAME_EXPR* (Optional1)
               This option is evaluated to yield a username that can be
               referenced by the LDAP_ROLES_SELECTOR* option as
               _$_{_L_D_A_P_:_:_U_S_E_R_N_A_M_E_}.

           LDAP_ROLES_SELECTOR* (Optional)
               Each occurrence of this directive specifies an expression that
               is evaluated by iterating through each attribute of the entry
               and making the attribute name (_$_{_L_D_A_P_:_:_a_t_t_r_n_a_m_e_}) and its value
               (_$_{_L_D_A_P_:_:_a_t_t_r_v_a_l_u_e_}) available. All of the entry's attribute
               names and values are made available within the LDAP namespace.
               If the result of the expression is a valid role string (which
               excludes the empty string, ""), it is added to the list of
               roles.

           LDAP_TIMEOUT_SECS (Optional1)
               This is a maximum time limit, in seconds, for any individual
               LDAP read or search operation performed by the module. If not
               specified, there will not be an application-specified time
               limit.

           Here is an example that binds to the directory on x.example.com as
           the administrator, searches for the entry for the account of the
           authenticated user, and assigns the user a role from the attribute
           value of each memberOf attribute in the entry:

               <Roles id="ldap_roles">
               URL "http://example.com/cgi-bin/dacs/local_ldap_roles"
               OPTION "LDAP_BIND_METHOD=indirect"
               OPTION \
               'LDAP_ADMIN_URL="ldap://x.example.com/CN=Administrator,CN=Users,DC=example,DC=com"'
               OPTION 'LDAP_ADMIN_PASSWORD="secretpassword"'

               OPTION 'LDAP_SEARCH_ROOT_DN="cn=Users,dc=example,dc=com"'
               OPTION 'LDAP_SEARCH_FILTER*=\'"(sAMAccountName=${Args::DACS_USERNAME})"\''

               OPTION 'LDAP_ROLES_SELECTOR*=\'"${LDAP::attrname}" eq "memberOf" \
                   ? strtr(ldap(rdn_attrvalue, \
                       ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") \
                   : ""\''
               </Roles>

           For example, the resulting role string might look like:

               DnsAdmins,Print_Operators,Domain_Admins,Administrators


       llooccaall__uunniixx__rroolleess
           This roles service returns the Unix group membership associated
           with an authenticated username; that it, the resulting list of
           roles is the same as would be obtained if the user ran the Unix
           ggrroouuppss((11))[150].

               NNoottee
               The user need not have been authenticated as this username on
               the Unix system where this service is run.

               TTiipp
               A built-in version of this module can be selected by using the
               URL local_unix_roles or just unix.

   RReellaatteedd SSeerrvviicceess
       The ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[33] web service displays elements of
       each set of credentials sent with the request. The ddaaccss__ssiiggnnoouutt((88))[151]
       service is typically called from a browser to cause one or more cookies
       (each representing a DDAACCSS identity) to be deleted. Cookies are
       automatically deleted when a browser terminates, but it is sometimes
       useful to explicitly logoff.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

NNOOTTEESS
       A separate but similar mechanism called "affiliated DDAACCSS federations"
       supports cross-federation single sign-on; see ddaaccss__aauutthh__ttrraannssffeerr((88))[8].

       ddaaccss__aauutthheennttiiccaattee could be modified to temporarily disable an account
       after some number of unsuccessful login attempts over a certain time
       period. The flip side of such a feature is that it could be used in a
       denial of service attack. Rather than disabling an account, a
       designated administrator might receive an email notification or a
       console message might be logged.

       It might be worthwhile to include a rule-based mechanism, called after
       the user has been identified but before credentials are returned, to
       decide whether authentication should be permitted. This might be used,
       for example, to restrict a particular user to login from a specified IP
       address or range of addresses, or limit the time of day at which login
       is allowed.

BBUUGGSS
       It would be nice to provide assistance to programs that generate login
       pages. Composing modules should be easier, to make multi-factor
       authentication more accessible.

SSEEEE AALLSSOO
       ddaaccssaauutthh((11))[6], ddaaccssccrreedd((11))[152], ddaaccssccooookkiiee((11))[9], ddaaccss..eexxpprrss((55))[3],
       ddaaccss__aauuttoollooggiinn__ssssll((88))[153], aauuttoollooggiinn((88))[122], ddaaccss__aauutthh__aaggeenntt((88))[7],
       ddaaccss__aauutthh__ttrraannssffeerr((88))[8], ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[33],
       ddaaccss__sseelleecctt__ccrreeddeennttiiaallss((88))[41], ddaaccss__ssiiggnnoouutt((88))[151], ppaammdd((88))[135]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[154])

CCOOPPYYIINNGG
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       LLIICCEENNSSEE[155] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        3. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

        4. html/examples
           http://dacs.dss.ca/man//examples

        5. HTTP Authentication
           http://dacs.dss.ca/man/dacs_acs.8.html#http_authentication

        6. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

        7. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

        8. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

        9. dacscookie(1)
           http://dacs.dss.ca/man/dacscookie.1.html

       10. Auth clause
           http://dacs.dss.ca/man/#auth_clause

       11. CONTROL
           http://dacs.dss.ca/man/#CONTROL

       12. username
           http://dacs.dss.ca/man/dacs.1.html#dacs_identity

       13. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html#revocation_list

       14. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#naming

       15. credentials.dtd
           http://dacs.dss.ca/man/../dtd-xsd/credentials.dtd

       16. VERIFY_IP
           http://dacs.dss.ca/man/dacs.conf.5.html#VERIFY_IP

       17. natd(8)
           http://www.freebsd.org/cgi/man.cgi?query=natd&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

       18. VERIFY_UA
           http://dacs.dss.ca/man/dacs.conf.5.html#VERIFY_UA

       19. AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS

       20. Advanced Encryption Standard
           http://csrc.nist.gov/encryption/aes/aes_home.htm

       21. Federal Information Processing Standard
           http://www.nist.gov/public_affairs/releases/g01-111.htm

       22. FIPS 198
           http://csrc.nist.gov/publications/fips/fips198-1/FIPS-198-1_final.pdf

       23. RFC 2104
           http://www.rfc-editor.org/rfc/rfc2104.txt

       24. RFC 4635
           http://www.rfc-editor.org/rfc/rfc4635.txt

       25. RFC 4868
           http://www.rfc-editor.org/rfc/rfc4868.txt

       26. NIST
           http://www.nist.gov/

       27. FIPS 180-1
           http://www.itl.nist.gov/fipspubs/fip180-1.htm

       28. RFC 4634
           http://www.rfc-editor.org/rfc/rfc4634.txt

       29. FIPS 180-3
           http://csrc.nist.gov/publications/fips/fips180-3/fips180-3_final.pdf

       30. MD5 algorithm
           http://www.rfc-editor.org/rfc/rfc1321.txt

       31. Netscape HTTP Cookies Specification
           http://web.archive.org/web/20070805052634/http://wp.netscape.com/newsref/std/cookie_spec.html

       32. _C_O_O_K_I_E___S_Y_N_T_A_X
           http://dacs.dss.ca/man/#COOKIE_SYNTAX

       33. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       34. COOKIE_PATH
           http://dacs.dss.ca/man/dacs.conf.5.html#COOKIE_PATH

       35. SECURE_MODE
           http://dacs.dss.ca/man/dacs.conf.5.html#SECURE_MODE

       36. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       37. local_pam_authenticate
           http://dacs.dss.ca/man/#local_pam_authenticate

       38. RFC 2109
           http://www.rfc-editor.org/rfc/rfc2109.txt

       39. RFC 2965
           http://www.rfc-editor.org/rfc/rfc2965.txt

       40. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       41. dacs_select_credentials(8)
           http://dacs.dss.ca/man/dacs_select_credentials.8.html

       42. ssttrrttrr(())
           http://dacs.dss.ca/man/dacs.exprs.5.html#strtr

       43. LDAP_USERNAME_URL
           http://dacs.dss.ca/man/#LDAP_USERNAME_URL

       44. local_ldap_authenticate
           http://dacs.dss.ca/man/#local_ldap_authenticate

       45. OPTION
           http://dacs.dss.ca/man/#OPTION

       46. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#auth_clause

       47. pam(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam&apropos=0&sektion=0&manpath=FreeBSD+7.2-RELEASE&format=html

       48. X/Open Single Sign-On Service (XSSO) preliminary specification
           http://www.opengroup.org/pubs/catalog/p702.htm

       49. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#merging

       50. Authenticating Using an Expression
           http://dacs.dss.ca/man/#expr

       51. PASSWORD_CONSTRAINTS
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_CONSTRAINTS

       52. LOG_FILTER
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_FILTER

       53. local_cas_authenticate
           http://dacs.dss.ca/man/#local_cas_authenticate

       54. Central Authentication Service (CAS)
           http://www.ja-sig.org/products/cas/index.html

       55. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

       56. local_apache_authenticate
           http://dacs.dss.ca/man/#local_apache_authenticate

       57. Information Card
           http://en.wikipedia.org/wiki/Information_Card

       58. dacsinfocard(1)
           http://dacs.dss.ca/man/dacsinfocard.1.html

       59. dacs_infocard(8)
           http://dacs.dss.ca/man/dacs_infocard.8.html

       60. dacs_managed_infocard(8)
           http://dacs.dss.ca/man/dacs_managed_infocard.8.html

       61. local_infocard_authenticate
           http://dacs.dss.ca/man/#local_infocard_authenticate

       62. local_simple_authenticate
           http://dacs.dss.ca/man/#local_simple_authenticate

       63. add_roles
           http://dacs.dss.ca/man/#add_roles

       64. set_roles
           http://dacs.dss.ca/man/#set_roles

       65. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html#variables

       66. AUTH_SUCCESS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_SUCCESS

       67. AUTH_SUCCESS_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_SUCCESS_HANDLER

       68. AUTH_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_ERROR_HANDLER

       69. AUTH_FAIL_DELAY_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_FAIL_DELAY_SECS

       70. _D_A_C_S___A_U_T_H___S_U_C_C_E_S_S___H_A_N_D_L_E_R
           http://dacs.dss.ca/man/#DACS_AUTH_SUCCESS_HANDLER

       71. _E_N_A_B_L_E___A_U_T_H___H_A_N_D_L_E_R_S
           http://dacs.dss.ca/man/#ENABLE_AUTH_HANDLERS

       72. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

       73. Environment variables
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#envvars

       74. mod_ssl
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html

       75. dacs.services(8)
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

       76. dacs_auth_reply.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_auth_reply.dtd

       77. dacs_current_credentials.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_current_credentials.dtd

       78. auth_reply.dtd
           http://dacs.dss.ca/man/../dtd-xsd/auth_reply.dtd

       79. dacs.install(7)
           http://dacs.dss.ca/man//man/dacs.install.7.html

       80. mmoodd__aauutthh
           http://httpd.apache.org/docs-2.2/mod/mod_auth.html

       81. mmoodd__aauutthh__ddiiggeesstt
           http://httpd.apache.org/docs-2.2/mod/mod_auth_digest.html

       82. mmoodd__aauutthh__ddbbmm
           http://httpd.apache.org/docs-2.2/mod/mod_auth_dbm.html

       83. htpasswd(1)
           http://httpd.apache.org/docs/2.2/programs/htpasswd.html

       84. htdigest(1)
           http://httpd.apache.org/docs/2.2/programs/htdigest.html

       85. htdbm(1)
           http://httpd.apache.org/docs/2.2/programs/htdbm.html

       86. local_native_authenticate
           http://dacs.dss.ca/man/#local_native_authenticate

       87. CAS 2.0 Protocol
           http://www.ja-sig.org/products/cas/overview/protocol/index.html

       88. OpenID
           http://openid.net/

       89. STYLE
           http://dacs.dss.ca/man/#STYLE

       90. SSLVerifyClient
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslverifyclient

       91. SSLRequire
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslrequire

       92. OpenSSL
           http://www.openssl.org

       93. SSLOptions
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#ssloptions

       94. dacsgrid(1)
           http://dacs.dss.ca/man/dacsgrid.1.html

       95. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

       96. Google
           http://www.google.com

       97. account authentication
           http://code.google.com/apis/accounts/AuthForInstalledApps.html

       98. eBay
           http://developer.ebay.com/developercenter/rest/

       99. Yahoo!
           http://developer.yahoo.com/auth/

       00. Identity Selector Interoperability Profile (ISIP) 1.5
           http://download.microsoft.com/download/1/1/a/11ac6505-e4c0-4e05-987c-6f1d31855cd2/Identity_Selector_Interoperability_Profile_V1.5.pdf

       01. role descriptor string
           http://dacs.dss.ca/man/dacs.1.html#roles

       02. dacs_infocard(8)
           http://dacs.dss.ca/man/dacs_infocard.8.html#about_claims

       03. expression-based authentication style
           http://dacs.dss.ca/man//man/dacs_authenticate.8.html#expr

       04. dacs_managed_infocard(8)
           http://dacs.dss.ca/man//man/dacs_managed_infocard.8.html

       05. dacs.conf(5)
           http://dacs.dss.ca/man//man/dacs.conf.5.html#INFOCARD_prefixed

       06. dacs_mex(8)
           http://dacs.dss.ca/man//man/dacs_mex.8.html

       07. dacs_sts(8)
           http://dacs.dss.ca/man//man/dacs_sts.8.html

       08. Using InfoCards With DACS
           http://dacs.dss.ca/man/using-infocards-with-dacs.html

       09. _I_d_e_n_t_i_t_y _S_e_l_e_c_t_o_r _I_n_t_e_r_o_p_e_r_a_b_i_l_i_t_y _P_r_o_f_i_l_e _s_p_e_c_i_f_i_c_a_t_i_o_n _a_n_d
           _c_o_m_p_a_n_i_o_n _g_u_i_d_e_s
           http://www.microsoft.com/downloads/details.aspx?FamilyID=b94817fc-3991-4dd0-8e85-b73e626f6764&DisplayLang=en

       10. _I_n_t_r_o_d_u_c_i_n_g _W_i_n_d_o_w_s _C_a_r_d_S_p_a_c_e
           http://msdn.microsoft.com/en-us/library/aa480189.aspx

       11. RFC 2251
           http://www.faqs.org/rfcs/rfc2251.html

       12. RFC 2252
           http://www.faqs.org/rfcs/rfc2252.html

       13. RFC 2253
           http://www.faqs.org/rfcs/rfc2253.html

       14. RFC 3377
           http://www.faqs.org/rfcs/rfc3377.html

       15. Active Directory (ADS)
           http://www.microsoft.com/windows2000/technologies/directory/ad/default.asp

       16. OpenLDAP
           http://www.openldap.org

       17. ldap()
           http://dacs.dss.ca/man/dacs.exprs.5.html#ldap

       18. LDAP_USERNAME_URL*
           http://dacs.dss.ca/man/#LDAP_USERNAME_URL*

       19. RFC 2396
           http://www.faqs.org/rfcs/rfc2396.html

       20. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

       21. ldapsearch(1)
           http://www.openldap.org/software/man.cgi?query=ldapsearch&apropos=0&sektion=0&manpath=OpenLDAP+2.4-Release&format=html

       22. autologin(8)
           http://dacs.dss.ca/man/autologin.8.html

       23. 1
           http://curl.haxx.se/rfc/ntlm.html

       24. 2
           http://msdn.microsoft.com/en-us/library/cc236621%28PROT.10%29.aspx

       25. Samba
           http://www.samba.org

       26. NTLM authentication
           http://davenport.sourceforge.net/ntlm.html

       27. smbclient(1)
           http://us2.samba.org/samba/docs/man/manpages-3/smbclient.1.html

       28. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       29. pam_start(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam_start&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       30. GNU/Linux
           http://www.kernel.org/pub/linux/libs/pam/modules.html

       31. FreeBSD
           http://www.freebsd.org/doc/en_US.ISO8859-1/articles/pam/pam-freebsd-modules.html

       32. Solaris
           http://www.sun.com/software/solaris/pam/

       33. pam_unix(8)
           http://www.freebsd.org/cgi/man.cgi?query=pam_unix&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

       34. local_unix_authenticate
           http://dacs.dss.ca/man/#local_unix_authenticate

       35. pamd(8)
           http://dacs.dss.ca/man/pamd.8.html

       36. dacs_url
           http://dacs.dss.ca/man/dacs.groups.5.html#group_syntax

       37. local_pam_authenticate.css
           http://dacs.dss.ca/man//css/local_pam_authenticate.css

       38. PASSWORD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_DIGEST

       39. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

       40. dacstoken(1)
           http://dacs.dss.ca/man/dacstoken.1.html

       41. RFC 4226
           http://www.rfc-editor.org/rfc/rfc4226.txt

       42. OATH
           http://www.openauthentication.org

       43. getpwnam(3)
           http://www.freebsd.org/cgi/man.cgi?query=getpwnam&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       44. yp(8)
           http://www.freebsd.org/cgi/man.cgi?query=yp&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

       45. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       46. roles_reply.dtd
           http://dacs.dss.ca/man/../dtd-xsd/roles_reply.dtd

       47. ROLE_STRING_MAX_LENGTH
           http://dacs.dss.ca/man/dacs.conf.5.html#ROLE_STRING_MAX_LENGTH

       48. OPTION directive
           http://dacs.dss.ca/man/#r_OPTION

       49. OPTION* directive
           http://dacs.dss.ca/man/#r_OPTION*

       50. groups(1)
           http://www.freebsd.org/cgi/man.cgi?query=groups&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       51. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       52. dacscred(1)
           http://dacs.dss.ca/man/dacscred.1.html

       53. dacs_autologin_ssl(8)
           http://dacs.dss.ca/man/dacs_autologin_ssl.8.html

       54. www.dss.ca
           http://www.dss.ca

       55. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012              DACS_AUTHENTICATE(8)
