DACS_ACS(8)                DACS Web Services Manual                DACS_ACS(8)



NNAAMMEE
       dacs_acs - DDAACCSS access control service

SSYYNNOOPPSSIISS
       ddaaccss__aaccss [ddaaccssooppttiioonnss[1]] [--pprrooxxyy--ssttaattiicc] [--pprrooxxyy--eexxeecc]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The DDAACCSS access control service, ddaaccss__aaccss (or simply AACCSS) is
       responsible for making access control decisions on web service
       requests. It is run by a web server. In the current implementation,
       ddaaccss__aaccss is executed by the web server as an external program.  AACCSS
       provides role-based access control using the DDAACCSS rule-processing
       engine, which consults access control rules (also referred to as ACLs)
       provided with DDAACCSS or written by a DDAACCSS administrator. Because access
       control is performed on URIs, AACCSS can control access to arbitrary
       resources, such as web pages, files, or programs.

       A generic interface to DDAACCSS''ss rule processing engine is given by
       ddaaccsscchheecckk((11))[2].

       A web server runs ddaaccss__aaccss to determine whether a particular service
       request is authorized. Although in theory any web server that provides
       appropriate hooks could call ddaaccss__aaccss, at present only AAppaacchhee 2.x and
       2.2.x web servers are supported. A DDAACCSS-aware AAppaacchhee module called
       mmoodd__aauutthh__ddaaccss[3] is configured using custom AAppaacchhee directives and runs
       ddaaccss__aaccss. A web server having mmoodd__aauutthh__ddaaccss[3] functionality is said to
       be DDAACCSS-enhanced and web services that are under the control of
       mmoodd__aauutthh__ddaaccss[3] are said to be DDAACCSS-wrapped.

       When AAppaacchhee receives a DDAACCSS-wrapped service request, the mmoodd__aauutthh__ddaaccss
       module is run, which in turn runs ddaaccss__aaccss to determine whether the
       request should be granted. The module provides ddaaccss__aaccss with the name
       of the requested service ("What is being accessed?"), parameters that
       were passed in the request ("How is it being accessed?"), the identity
       of the client ("Who is making the request?"), and other context
       associated with the request. With this information at hand, ddaaccss__aaccss
       consults a set of access control rules (the ruleset) (see
       ddaaccss..aaccllss((55))[4]). Additional contextual information, such as DDAACCSS
       configuration directives and build-time options, and the run-time
       environment, is also available. The information returned by ddaaccss__aaccss to
       the module either causes AAppaacchhee to grant permission, possibly with a
       constraint that specifies additional, service-specific information, or
       denies permission, possibly with a reason for denial.  ddaaccss__aaccss may
       also instruct the web server to redirect the client.

       All DDAACCSS services must be under the control of ddaaccss__aaccss, even those
       that do not require the client to be authenticated. Also, a web server
       must be configured such that only DDAACCSS-controlled services and no other
       services can be invoked through URLs associated with its DDAACCSS
       jurisdiction.

       It is not a requirement that all of a web server's resources be under
       the control of DDAACCSS. That is, it is not necessary to DDAACCSS-wrap
       everything, but it is certainly possible.

       Please refer to the documentation for mmoodd__aauutthh__ddaaccss[3] for information
       on configuring the DDAACCSS AAppaacchhee module.

           SSeeccuurriittyy
           A ddaaccss__aaccss process, which is created by hhttttppdd, should ordinarily
           run as the same user id as hhttttppdd. File and directory ownership and
           modes must be set so that it can read its configuration files,
           access control rules, and so on. The DDAACCSS expression language
           includes functions that can execute an arbitrary program and
           perform file system operations, so care must be taken to ensure
           that files used by DDAACCSS cannot be edited or replaced by
           non-privileged users. In some circumstances, it may be necessary
           for ddaaccss__aaccss to run as root, in which case a DDAACCSS administrator
           must be extra careful in this regard.

           TTiipp
           One way to understand what ddaaccss__aaccss is doing, or to debug it, is to
           enable the most detailed level of llooggggiinngg[5]. This will emit a
           copious quantity of output to the DDAACCSS log file, so be sure to
           reduce the logging level and delete the log file when you are
           finished.

           Setting the LLOOGG__LLEEVVEELL[6] directive to "debug" or "trace" will
           produce detailed output (although it can be moderated using the
           LLOOGG__FFIILLTTEERR[7] directive).  LOG_LEVEL has the disadvantage that it
           cannot take effect until after configuration processing.

           To enable logging output at the earliest possible time, you can add
           the desired _d_a_c_s_o_p_t_i_o_n_s[1] flags to Apache's AAddddDDAACCSSAAuutthh[8]
           directive; for example, by using a directive like the following in
           httpd.conf:

               AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-t -v"

           Note that hhttttppdd must be restarted before changes to this directive
           take effect.

           An alternative method of enabling detailed logging, equivalent to
           using the --tt and --vv flags if neither has been specified, is to
           create a file in the DDAACCSS__HHOOMMEE[9] directory with the name
           debug__p_r_o_g_n_a_m_e. For example, to enable detailed logging for
           ddaaccss__aaccss, the following command might be used:

               % touch /usr/local/dacs/debug_dacs_acs

           This method takes effect immediately and applies to any DDAACCSS web
           service or command that accepts _d_a_c_s_o_p_t_i_o_n_s[1] at the time they
           begin execution. It overrides the current value of LOG_LEVEL, is
           more selective because it applies only to _p_r_o_g_n_a_m_e (unlike
           LOG_LEVEL), is easily turned on by creating the file and turned off
           by removing the file, and neither requires changes to httpd.conf
           nor an hhttttpp restart.

   MMoodduullee--ttoo--AACCSS PPrroottooccooll
       DDAACCSS's mmoodd__aauutthh__ddaaccss[3] module for AAppaacchhee invokes the ddaaccss__aaccss program
       to do the hard part of deciding whether a request should be granted or
       denied. The module is responsible for configuring itself using new
       AAppaacchhee directives, gathering information required to make the access
       control decision, passing that information to ddaaccss__aaccss, and receiving
       the access control decision from ddaaccss__aaccss, together with either
       environment information (if access is granted to an executable request)
       or error handling directives (if access is denied).

       To prevent potentially sensitive information from becoming visible,
       mmoodd__aauutthh__ddaaccss[3] passes information to ddaaccss__aaccss over an interprocess
       communication channel (ppiippee((22))[10]).  ddaaccss__aaccss reads its standard
       input, makes the access control decision, and writes either environment
       information or an optional error handling directive to its standard
       output. The exit status of ddaaccss__aaccss communicates its decision: zero
       means the request should be granted, anything else means the request
       should be denied.

       The information passed _t_o ddaaccss__aaccss _f_r_o_m AAppaacchhee is in the format:

           _v_a_r_i_a_b_l_e_-_n_a_m_e="_v_a_r_i_a_b_l_e_-_v_a_l_u_e"

       each of which is terminated by a newline character. These variables are
       listed below. For details about how to reference these values, see
       VVaarriiaabblleess AAvvaaiillaabbllee TToo RRuulleess[11].

       _S_E_R_V_I_C_E___A_R_G_S
           The query arguments (if any and whether GET or POST method is being
           used) followed by POST arguments (if any and to the maximum length
           configured), base-64 encoded.

       _S_E_R_V_I_C_E___A_R_G_S___T_R_U_N_C_A_T_E_D
           For POST method requests, if the POST data stream (i.e., the
           request's entity-body) was not completely captured, such as if the
           maximum length was reached, this variable will be present and
           assigned the value 1.

       _S_E_R_V_I_C_E___A_U_T_H_O_R_I_Z_A_T_I_O_N
           The value of the Authorization HTTP header field, if present.

       _S_E_R_V_I_C_E___C_O_N_T_E_N_T___E_N_C_O_D_I_N_G
           The value of the Content-Encoding HTTP header field, if present.

       _S_E_R_V_I_C_E___C_O_N_T_E_N_T___L_E_N_G_T_H
           The value of the Content-Length HTTP header field, if present.

       _S_E_R_V_I_C_E___C_O_N_T_E_N_T___T_Y_P_E
           The value of the Content-Type HTTP header field, if present.

       _S_E_R_V_I_C_E___C_O_O_K_I_E
           The value of the Cookie HTTP header field, if present.

       _S_E_R_V_I_C_E___F_I_L_E_N_A_M_E
           The name of the file, as determined by AAppaacchhee, corresponding to
           this response.

       _S_E_R_V_I_C_E___H_O_S_T_N_A_M_E
           The name of the host as set by the full URI or Host HTTP header
           field, as determined by AAppaacchhee.

       _S_E_R_V_I_C_E___H_T_T_P_S
           If the request came over SSL (HTTPS), this variable will be present
           and set to "on".

       _S_E_R_V_I_C_E___M_E_T_H_O_D
           The request method, as set by AAppaacchhee (e.g., "GET").

       _S_E_R_V_I_C_E___P_A_T_H___I_N_F_O
           The PPAATTHH__IINNFFOO part of the URI, as set by AAppaacchhee.

       _S_E_R_V_I_C_E___P_O_S_T_D_A_T_A
           When available, the POST data stream (the HTTP message body) (or
           part of it: see the description of the SetDACSAuthPostBuffer
           directive to mmoodd__aauutthh__ddaaccss[12]). It is MIME base-64 encoded.

       _S_E_R_V_I_C_E___P_R_O_X_Y___A_U_T_H
           The value of the DACS-Proxy-Authorization HTTP header field, if
           present. (Not currently used).

       _S_E_R_V_I_C_E___P_R_O_X_Y_R_E_Q
           If the current request involves proxy processing on this server,
           this identifies the type of processing as "proxy" (for "forward
           proxying"), "proxy_reverse" (for "reverse proxying"), or
           "proxy_response".

       _S_E_R_V_I_C_E___Q_U_E_R_Y
           The value of the query string component of the URI.

       _S_E_R_V_I_C_E___R_E_M_O_T_E___A_D_D_R
           The client's IP address.

       _S_E_R_V_I_C_E___R_E_M_O_T_E___H_O_S_T
           The client's DNS name, if known by AAppaacchhee.

       _S_E_R_V_I_C_E___S_E_R_V_E_R___P_O_R_T
           The TCP/IP port on which the request was received by AAppaacchhee.

       _S_E_R_V_I_C_E___U_R_I
           The path portion of the URI, as determined by AAppaacchhee.

       _S_E_R_V_I_C_E___U_S_E_R___A_G_E_N_T
           The value of the User-Agent HTTP header field, if present.

       If access is granted, ddaaccss__aaccss may provide a set of control directives
       for mmoodd__aauutthh__ddaaccss[3] to interpret, followed by a set of environment
       variables for mmoodd__aauutthh__ddaaccss[3] to introduce into the environment of an
       executable request. Each control directive starts with a "=" character
       and is terminated by a newline. Environment variables are specified in
       the format:

           _v_a_r_i_a_b_l_e_-_n_a_m_e=_v_a_r_i_a_b_l_e_-_v_a_l_u_e

       each of which is terminated by a newline character.

       If access is denied, ddaaccss__aaccss may instead provide an error handling
       directive, newline terminated, in the form expected as the third
       argument to AAppaacchhee's aapp__ccuussttoomm__rreessppoonnssee(()) function.

   CCrreeddeennttiiaallss
       DDAACCSS credentials can be passed to ddaaccss__aaccss in several ways, but they
       have the following representation:

           DACS:_f_e_d_e_r_a_t_i_o_n_-_n_a_m_e::[_j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e]:[_u_s_e_r_n_a_m_e]=_v_a_l_u_e[; ...]

       If the _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e is omitted, the _u_s_e_r_n_a_m_e must also be omitted.
       The string is URL encoded. If there are multiple credentials, they are
       separated by any combination of spaces and ";" characters.

       Credentials are passed from mmoodd__aauutthh__ddaaccss[3] to ddaaccss__aaccss using the
       _S_E_R_V_I_C_E___C_O_O_K_I_E variable (transmitted over a ppiippee((22))[10])

       Because a process's environment is public on some systems, DDAACCSS takes
       care not to pass credentials using environment variables. Passing
       credentials through the HHTTTTPP__CCOOOOKKIIEE environment variable is forbidden
       unless enabled by the AALLLLOOWW__HHTTTTPP__CCOOOOKKIIEE[13] directive. When
       specifically enabled by a rule's attribute, they can be passed using
       the DDAACCSS__CCOOOOKKIIEE environment variable (see the pass_credentials
       attribute described in ddaaccss..aaccllss((55))[4]).

       If an HTTP Authorization header is used with the "DACS" authentication
       scheme, the "basic-credentials" component of the header may contain
       DDAACCSS credentials. Please refer to RRFFCC 22661177[14]. These credentials have
       the format given above but are also base-64 encoded.

           SSeeccuurriittyy
           It is forbidden to submit multiple credentials for the same
           identity to DDAACCSS and such a request will trigger an error.

           it is also forbidden to submit multiple DDAACCSS authentication cookies
           with the same cookie name.

       Please refer to ddaaccss__aauutthheennttiiccaattee((88))[15] for additional information.

   RRlliinnkkss
       An Rlink (rule link) is an alternate mechanism for providing DDAACCSS
       authentication and authorization. Instead of matching the name of a
       requested resource against rules, as is normally done by DDAACCSS, the
       request indirectly specifies authorization constraints that must be
       applied to the request. Optionally, a DDAACCSS identity and other
       information can accompany the request. An Rname, which is essentially
       the name of an access control rule, is used to point at the
       authorization constraints.

       An Rlink is a URL that includes an Rname. During authorization
       processing, the Rname is resolved to an access control rule that is
       processed the same as any other access control rule and the requested
       resource must be DDAACCSS-wrapped. In other words, a request that is
       recognized as an Rlink essentially says "use the rule identified by
       this request's Rname to decide whether or not to grant access and do
       not consider any other rule". Subsequent access control processing is
       identical to the normal case.

       In typical usage, an Rlink is created (probably, but not necessarily by
       ddaaccssrrlliinnkk((11))[16]) and the resulting URL is distributed (e.g., by email)
       to those parties intended to be able to access the resource. Similar
       mechanisms are widely used by web-based applications.

       When an Rlink is used as a kind of "secret URL" that grants access to
       anyone who uses it, an Rname is a randomly generated identifier that is
       unique, with very high probability, relative to its namespace at a
       jurisdiction. By default, an Rname consists of eight symbols from the
       set of upper- and lower-case alphabetics and digits, yielding a
       namespace in excess of 10^14 identifiers. This makes guessing a valid
       Rname highly unlikely. The characteristics of new Rnames can be changed
       at will; the alphabet from which they are generated should be
       considered carefully, however, to avoid problems that might arise when
       they are embedded within a URL or used as a filename.  RRLLIINNKK[17]
       directives can map Rnames to the same or different namespaces,
       depending on the filestore selected by a directive.

           NNoottee
           An Rlink does not have to be used as a secret URL though, and its
           creator can choose any Rname that will work with the mechanism
           described here.

           If a rule contains the optional name attribute, the attribute value
           must exactly match the Rname.

           The base name of a file containing an Rlink will be its Rname. This
           naming scheme is different from tthhee oonnee uusseedd ffoorr nnoorrmmaall rruulleess[18].

       This feature allows multiple versions of an Rlink to be created, each
       bound to a different identity. By attaching an identity to an Rlink,
       its creator can confer different rights to different users, or simply
       track who has used the Rlink. These identities may or may not
       correspond to "real" identities that are associated with DDAACCSS
       authentication (i.e., there may or may not be an account associated
       with them); DDAACCSS administrators should keep this mind to avoid any
       confusion.

       An Rname may be followed by a suffix that directly or indirectly
       associates a DDAACCSS identity with the Rlink. For want of a better name,
       this composite identifier is called an RnameIdent and has the following
       syntax:


             _R_n_a_m_e_I_d_e_n_t  -> _R_n_a_m_e ':' _i_d_e_n_t | _R_n_a_m_e ';' _i_p_t_r

       In the _d_i_r_e_c_t mode of identity attachment, the Rname is followed by a
       separator (a colon, which cannot appear in an Rname) and _i_d_e_n_t, a
       cryptographically protected and base-64 encoded ccoonncciissee uusseerr
       iiddeennttiittyy[19] that is created by ddaaccssrrlliinnkk((11))[16]. These encrypted
       identities are _n_o_t the same as encrypted credentials. Note that
       different encrypted identifiers may represent exactly the same
       identity. If DDAACCSS recognizes the Rname, when it performs authorization
       checking it will do so assuming the specified identity, _i_g_n_o_r_i_n_g _a_n_y
       _o_t_h_e_r _c_r_e_d_e_n_t_i_a_l_s _t_h_a_t _m_i_g_h_t _h_a_v_e _a_c_c_o_m_p_a_n_i_e_d _t_h_e _r_e_q_u_e_s_t.

       In the _i_n_d_i_r_e_c_t mode, the Rname is followed by a different separator (a
       semi-colon, which cannot appear in an Rname) and an arbitrary string,
       called an _i_p_t_r (identity pointer) that is safe to embed in a URI. The
       same character set from which an Rname can be generated is safe for an
       _i_p_t_r: any number of alphanumerics, hyphens, and underscores. The rule
       that is specified by the Rname is expected to map the string to an
       identity, probably by using the iiddeennttiittyy eelleemmeenntt[20], and the identity
       is used in the same way as in the direct mode. Like an Rname, in
       typical usage an _i_p_t_r must be difficult to guess and be kept secret,
       otherwise a valid Rlink might easily be constructed that is associated
       with a chosen identity. The indirect mode has the advantages of keeping
       the URL relatively short, is immune to changes of the encryption key,
       and allows identities to be modified after an Rlink is shared.

       An identity obtained using either attachment mode is tested for
       revocation.

       The Rname, specified identity, and identity pointer are accessible in
       the _D_A_C_S namespace[11], when they are available, as _$_{_D_A_C_S_:_:_R_N_A_M_E_},
       _$_{_D_A_C_S_:_:_R_I_D_E_N_T_}, and _$_{_D_A_C_S_:_:_R_I_P_T_R_}, respectively.

       Rlinks can easily be created manually or by a custom program, but the
       ddaaccssrrlliinnkk((11))[16] utility provides a simple interface to create and
       administer them. Rules created by ddaaccssrrlliinnkk can be manually edited and
       deleted just like any other rule. Their is no _a _p_r_i_o_r_i limit on the
       lifetime of an Rlink; it continues to exist as far as DDAACCSS is concerned
       if the Rname is recognized by an RLINK directive and the named rule
       exists and is valid. Deleting the rule corresponding to an Rname
       effectively invalidates that Rlink.

       An Rname can be presented as an ordinary web service argument, as a
       component of the request URI, or via the special DDAACCSS__AACCSS aarrgguummeenntt[21]:

           https://example.com/~alice/photos/myphoto.gif?RNAME=jigrFUwF
           https://example.com/cgi-bin/manage.cgi/jigrFUwF
           https://example.com/private/data?DACS_ACS=-rname+jigrFUwF

       Each of these approaches has advantages and disadvantages; the best
       choice depends on web site and application details. For example,
       embedding an Rname as a component of a URI is particularly well suited
       to CGI programs and web services (e.g.,
       https://example.com/cgi-bin/manage/jigrFUwF, where manage is the name
       of the program). Using the _D_A_C_S___A_C_S argument allows the Rname to be
       used during access control testing but completely hidden from the
       requested resource.

       RRLLIINNKK[17] directives are used to examine an incoming request, decide
       whether an Rname is present, extract the Rname, and specify where the
       rule can be found. If an Rname is present, normal access control
       processing is disabled and no search of the usual DDAACCSS rulesets for an
       applicable rule occurs. If no RLINK directive finds an Rname, normal
       access control processing occurs.

       The main advantage of Rlinks is that they make controlled file sharing
       and web service access simple. An Rlink is created and disseminated,
       and all recipients can access the named resource (subject to the
       Rlink's rule) using any web browser. Any number of different rules can
       be created for the same resource, with each one having a different
       Rname. An Rlink's rule can be changed or deleted by its owner at any
       time, even after it has been distributed.

       Rlinks also offer an alternative way to make exceptions to the rule
       normally applicable. Rather than revising the "normal" rule for a
       resource or set of resources to take account for the exceptions, one or
       more Rlinks can be created to handle the special cases and the normal
       rules need not be touched.

       Another application of Rlinks is as a short representation of an
       arbitrary URL. Someone accessing an Rlink that has been configured in
       this way is redirected to a specified URL; see the rreeddiirreecctt(())[22]
       function. The URL can be changed at will simply by editing the Rlink's
       rule. The Rlink need not be kept secret when it is used for this
       purpose.

       The main disadvantage of Rlinks is that security may rely on keeping
       Rnames secret, and because an Rlink may be visible in a URL, this can
       be difficult to keep up. Anyone who can capture an Rname and use it
       properly with a resource to which it applies can potentially gain
       access to that resource. An Rname might be found in a log file, or in a
       browser's history or bookmark list. Although this method is convenient
       for users, the requirement for secrecy means that it might not be
       appropriate in some situations. At the expense of some convenience,
       however, a password can be bound to an Rlink when it is created; for
       the Rlink to be valid when it is invoked, the same password must be
       presented as an argument. Furthermore, because the access control rule
       associated with an Rname is the same as any other rule, it may express
       any conditions it likes, so it can still require authentication to have
       been performed, restrict the user's IP address, and so on. Also, an
       Rlink cannot be used to gain access to a resource that is not described
       by its rule's services element.

   HHTTTTPP AAuutthheennttiiccaattiioonn
       ddaaccss__aaccss can be configured to trigger HTTP authentication (see RRFFCC
       22661177[14]) by returning a WWW-Authenticate response header in certain
       circumstances. This will usually cause a browser or other web user
       agent to use its built-in mechanism for prompting the user for a
       username and password that corresponds to a particular access realm (a
       label that identifies a URL path prefix belonging to the server).

       If ddaaccss__aaccss denies access because the user is not authenticated (code
       990022, ACS_DENIAL_REASON_NO_AUTH), it checks to see if HTTP
       authentication has been enabled for the request. If not, processing of
       the denied request proceeds normally, otherwise DDAACCSS will try to use
       the RRFFCC 22661177[14] protocol to have ddaaccss__aauutthheennttiiccaattee authenticate the
       user.

           TTiipp
           This feature is configured through the HHTTTTPP__AAUUTTHH__EENNAABBLLEE[23] and
           HHTTTTPP__AAUUTTHH[24] directives, some configuration variables, and AAuutthh
           ccllaauussee ddiirreeccttiivveess[25]. Please refer to them for details.

           When HTTP authentication is triggered in this way, _n_o _e_x_t_r_a AAppaacchhee
           _c_o_n_f_i_g_u_r_a_t_i_o_n _n_e_e_d_s _t_o _b_e _d_o_n_e _o_r _s_h_o_u_l_d _b_e _d_o_n_e. All that is
           required of AAppaacchhee is that the resource that should trigger
           authentication be DDAACCSS-wrapped.

           _A_n_y password style authentication module, or the CAS authentication
           module, can be configured in conjunction with DDAACCSS''ss HTTP Basic
           authentication. That is, DDAACCSS can be configured to cause a browser
           to pop-up a username/password prompt and then use the values
           supplied by the user as if they were the _U_S_E_R_N_A_M_E and _P_A_S_S_W_O_R_D
           arguments to ddaaccss__aauutthheennttiiccaattee. The authentication module on the
           backend of the authentication procedure can use any type of AAppaacchhee
           password file or DDAACCSS password file, NTLM, CAS, etc.

           Besides authenticating against an AAppaacchhee password file created by
           hhttppaasssswwdd, hhttddiiggeesstt, or hhttddbbmm, this means that an ordinary browser
           can be used to capture a username and password for any DDAACCSS
           authentication module that requires it. Please refer to the
           description of the llooccaall__aappaacchhee__aauutthheennttiiccaattee[26] module for
           details.

       If the feature is enabled and applies to a request:

        1. any AACCSS__EERRRROORR__HHAANNDDLLEERR[27], AAUUTTHH__SSUUCCCCEESSSS__HHAANNDDLLEERR[28], and
           AAUUTTHH__EERRRROORR__HHAANNDDLLEERR[29] directives that would ordinarily apply are
           overridden.

        2. the HHTTTTPP__AAUUTTHH[24] directive that applies to the request specifies
           the authentication scheme, realm, and any additional authentication
           parameters.

        3. a WWW-Authenticate response header is returned to the browser. For
           example, for Basic authentication this header might look like:

               WWW-Authenticate: Basic realm="My Realm"


        4. an HTTP status value of 440011 (RRFFCC 22661166[30]) is returned. If the
           variable _$_{_C_o_n_f_:_:_h_t_t_p___a_u_t_h___m_e_s_s_a_g_e_} is defined, its value is used
           as the message body; if it is "", then no message body will be
           sent; if not provided, the string "902 Authentication by DACS is
           required" is used.

        5. if the variable _$_{_C_o_n_f_:_:_h_t_t_p___a_u_t_h___j_u_r_i_s_d_i_c_t_i_o_n_} is configured, it
           is expected to be the name of the jurisdiction (within the current
           federation) at which ddaaccss__aauutthheennttiiccaattee is to be invoked to
           authenticate the user; if the variable is undefined, the name of
           the current jurisdiction is used.


       The values of some of these variables are neither examined by DDAACCSS nor
       meaningful to it. For example, all that DDAACCSS requires of the realm
       string is that it be syntactically valid.

       When enabled, the following flow of control occurs:

        1. The user hits a DDAACCSS-wrapped URL when not authenticated; if
           ddaaccss__aaccss is configured to perform HTTP authentication for the
           request, it returns a 440011 ("Unauthorized") status code and a
           WWW-Authenticate header;

        2. The browser prompts for a username and password; the user enters
           the information and the browser re-submits the request, which this
           time includes an Authorization header;

        3. ddaaccss__aaccss again denies the request because the user is not
           authenticated, but sees an Authorization header and redirects the
           user to ddaaccss__aauutthheennttiiccaattee (at _$_{_C_o_n_f_:_:_h_t_t_p___a_u_t_h___j_u_r_i_s_d_i_c_t_i_o_n_} or
           the current jurisdiction) with arguments necessary for the selected
           authentication scheme; ddaaccss__aauutthheennttiiccaattee maps the given username
           (and password, if available) to the _U_S_E_R_N_A_M_E argument (and possibly
           the _P_A_S_S_W_O_R_D argument) and invokes authentication modules as
           necessary;

        4. If authentication succeeds, credentials are issued and the user is
           redirected to the original request (via the GET method);

        5. If authentication fails, the procedure is repeated from the
           beginning.


           NNoottee
           If a user authenticates using Basic authentication, signs out of
           DDAACCSS, and in the same browser session hits the link to trigger
           authentication, credentials may be automatically re-issued without
           prompting. This is because the browser will continue to send the
           Authorization request header, which ddaaccss__aauutthheennttiiccaattee may continue
           to honour.

           With Digest authentication, various aspects of the authentication
           protocol are subject to time limits as a security measure. The
           configuration variable _$_{_C_o_n_f_:_:_h_t_t_p___a_u_t_h___t_i_m_e_o_u_t___s_e_c_s_} can be set
           to the number of seconds for which a nonce is valid, thereby
           overriding the default; only advanced administrators familiar with
           RRFFCC 22661177[14] should change the default.

       The following is an example of configuration that might appear in the
       appropriate section (or sections) in DDAACCSS configuration files:

           HTTP_AUTH_ENABLE "yes"
           HTTP_AUTH "Basic \"Doggies\" /basic/*"

           EVAL ${Conf::http_auth_message} = \
             "902 https://example.com/cgi-bin/dacs/dacs_authenticate"

       Given this example configuration, whenever authentication is denied for
       a resource having a URL path that begins with "/basic/" because the
       user is not authenticated, the following response-headers will be
       returned:

           WWW-Authenticate: Basic realm="Doggies"
           Status: 401

       and the message body will contain the single line:

           902 https://example.com/cgi-bin/dacs/dacs_authenticate

       Instead of enabling the feature for _a_l_l requests, the following example
       enables it only for those user agents that supply a User-Agent
       request-header that matches the regular expression "DACS-http/.*"
       (which happens to match the default User-Agent string sent by the DDAACCSS
       hhttttpp((11))[31] utility).

           HTTP_AUTH_ENABLE = regmatch("${DACS::USER_AGENT}", "DACS-http/.*") ? "yes" : "no"

       A similar expression would enable the feature only for IInntteerrnneett
       EExxpplloorreerr, MMoozziillllaa, ccuurrll, hhttttpp((11))[31], etc., or some combination of
       browsers. Simply obtain the User-Agent string(s) sent by the browser(s)
       and write the appropriate regular expression to match it/them.

       Although RRFFCC 22661177[14] allows multiple WWW-Authenticate response-headers
       to be returned, this mechanism can only send one.

       When provided by a user agent, ddaaccss__aaccss makes the value of the
       Authorization request-header available to access control rules through
       the _$_{_D_A_C_S_:_:_A_U_T_H_O_R_I_Z_A_T_I_O_N_} variable.  DDAACCSS credentials can also be
       ppaasssseedd uussiinngg tthhiiss rreeqquueesstt--hheeaaddeerr[32].

   AAuutthhoorriizzaattiioonn CCaacchhiinngg
       After a rule grants access, ddaaccss__aaccss can be configured to save some
       context about its access control decision so that if the user makes a
       subsequent request for a resource managed by the same rule in a similar
       context, authorization can be granted quickly and without having to
       search for the applicable rule or re-evaluate it. Basically, the
       administrator tells DDAACCSS that if the rule grants access to a particular
       user, then it is safe for DDAACCSS to assume that future requests for the
       same resource by the same user should be granted without doing a
       complete authorization check.

       This mechanism offers improved performance in cases where:

       +o   users tend to make many requests for the same resource, or for a
           set of resources that are managed by the same rule (such as CSS
           files or images);

       +o   rule evaluation is relatively slow or expensive;

       +o   there are a large number of rules and/or rule retrieval is
           relatively slow;

       +o   re-evaluation of the rule is unnecessary (e.g., the rule does not
           update any state information)

       +o   it is acceptable for changes to the ruleset to not immediately
           affect cachable decisions


           SSeeccuurriittyy
           Pending further testing, this feature should be considered
           experimental. Use it in production situations only after you have
           satisfied yourself that it is working properly with your access
           control rules.

       Authorization caching is implemented using a special HTTP cookie,
       called an access token (not related to the tokens used in
       authentication), and a simple database maintained by ddaaccss__aaccss. A cookie
       is returned to the user when caching is possible and the user does not
       already possess a valid cookie. An access token points to server-side
       data that describes the cached authorization, including the context in
       which it is valid. Immediately after revocation testing, ddaaccss__aaccss
       checks if authorization caching applies to the current request; if it
       does, no access control rules are examined and access is immediately
       granted. If caching does not apply, process continues as usual. If any
       invalid access tokens were sent with the request, ddaaccss__aaccss will ask for
       them to be deleted (i.e., it unsets the cookies). These cookies have
       the following format:

           DACS:_f_e_d_e_r_a_t_i_o_n_-_n_a_m_e::_j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e::TOKEN-_u_n_i_q_u_e

       Here, _u_n_i_q_u_e is the "dacs64" encoding (see ddaaccss..eexxpprrss((55))[33]) of a
       cryptographically strong pseudo-random 16 byte value. Since access
       control is purely a jurisdictional responsibility in DDAACCSS, a cookie is
       meaningful only to the jurisdiction that issues it.

       These cookies are non-persistent (they are supposed to disappear when a
       browser session ends). The value of CCOOOOKKIIEE__PPAATTHH[34], or "/", determines
       the cookie's path attribute. The CCOOOOKKIIEE__NNOO__DDOOMMAAIINN[35] and
       CCOOOOKKIIEE__HHTTTTPP__OONNLLYY[36] directives are also honoured.

       Here is a simple example of how DDAACCSS might be configured to enable
       authorization caching for a particular resource. The jurisdiction's
       dacs.conf would include directives similar to the following:

           ACS_ACCESS_TOKEN_ENABLE        "yes"
           ACS_ACCESS_TOKEN_LIFETIME_SECS "43200"
           VFS                            "[tokens]dacs-kwv-fs:/usr/local/dacs/conf/tokens"

       A rule for the resource might look like this:

           <acl_rule status="enabled">
              <services>
                <service url_pattern="/cgi-bin/database.cgi"/>
                <service url_pattern="/cgi-bin/someprog.cgi"/>
              </services>

              <rule order="allow,deny">
                <allow permit_caching="yes">
                  user("auth")
                </allow>
              </rule>
           </acl_rule>

       Given this configuration, the first time an authenticated user
       requests, say, https://example.com/cgi-bin/database.cgi, he will be
       issued an access token. This token will be valid for up to 12 hours,
       and its associated data will be stored as an entry in the file
       /usr/local/dacs/conf/tokens.

           NNoottee
           In the current implementation, each access token is contained
           within its own cookie, rather than a jurisdiction collecting all of
           the user's tokens within a single cookie. A user might therefore
           simultaneously hold many access tokens from each jurisdiction. This
           should not be significant for middleware agents, but web browsers
           typically impose various kinds of limits on cookie "real estate".
           Administrators should take this into account when using this
           feature.

       Before it can be used, DDAACCSS must be built with the feature enabled (see
       ----eennaabbllee--aacccceessss--ttookkeennss in ddaaccss..iinnssttaallll((77))[37]). The virtual filestore
       item type "tokens" must be configured to identify an indexed virtual
       storage method and location for storing cache entries. Also, the
       authorization caching mechanism must be configured (see
       AACCSS__AACCCCEESSSS__TTOOKKEENN__EENNAABBLLEE[38], AACCSS__AACCCCEESSSS__TTOOKKEENN__LLIIFFEETTIIMMEE__LLIIMMIITT[39], and
       AACCSS__AACCCCEESSSS__TTOOKKEENN__LLIIFFEETTIIMMEE__SSEECCSS[40]).

       Enabling the feature in a particular context also requires setting a
       rule's permit_caching attribute to "yes" (see ddaaccss..aaccllss((55))[41]).
       Whenever access is granted because of the rule, authorization caching
       of the rule is possible.

           NNoottee
           Only the url_pattern of the rule's matching Service element (or the
           path derived from a url_expr attribute) is associated with the
           access token. This implies that when a rule has more than one
           service element, as in the example rule above, a single access
           token would be associated with only one of the two resources.
           Requests for different services could result in multiple access
           tokens being returned to a user, one for each service. A wildcard
           pattern is required if an access token is intended to grant access
           to more than one resource (this restriction may be lifted in future
           releases).

           Note that although a service request's arguments may be significant
           when initially granting access, they are not significant with
           respect to authorization caching applied to subsequent requests
           that use the access token. Once an access token is issued, the
           resource or resources named by it may therefore be invoked with
           different arguments without negating authorization caching.

           If any constraint, permit_chaining pass_credentials, or
           pass_http_cookie attributes are associated with the cachable rule,
           their values are also remembered and set if the access token
           subsequently causes access to be granted.

       Authorization caching is possible irrespective of whether a user has
       been authenticated. Caching is not allowed, however, in cases where the
       granting rule uses ttaaiill mmaattcchhiinngg[42] _a_n_d a rule exists for a
       subordinate URL (i.e., where there is a "more specific" rule for some
       other resource that should not be overridden by caching the "more
       general" rule). These cases are simply ignored; they are not considered
       to be errors. It is therefore not possible to cache the outcome of a
       rule with a url_pattern of "/*", for example, unless it is the only
       rule in the ruleset.

           NNoottee
           A positive result will be cached regardless of whether the
           requested resource actually exists or is subsequently processed
           without error by the web server. It is therefore possible for an
           access token to be issued for a resource that does not exist at the
           time of issue but which is created at some later time.

       The store of tokens may be deleted or modified at any time. Any access
       token that points to an invalid or missing entry in the store becomes
       invalid.

       Over time, the server-side access token database tends to accumulate
       entries for access tokens that no longer exist or have expired. These
       should be garbage collected. (This is currently not automated, so the
       database needs to be truncated. There should also be way to list the
       entries and manually delete entries.) The ddaaccssaaccll((11))[43] command and
       ddaaccss__aaddmmiinn((88))[44] service can perform administrative functions on the
       entry database.

           SSeeccuurriittyy
           Access tokens are created and used in such a way that it is
           practically impossible for an attacker to manufacture a valid
           access token or to convert an access token valid for one resource
           into one valid for a different resource.

           If a user is authenticated at the time an access token is
           generated, the token is "tied" to those credentials (all of them)
           and becomes invalid if any of the credentials become invalid or are
           not sent with the access token. If a user signs out or
           reauthenticates after being issued an access token, therefore, the
           access token will become invalid. Additional credentials, beyond
           what were present at the time an access token was generated, have
           no effect in this regard.

           As with cookies bearing DDAACCSS credentials, cookies containing access
           tokens must be kept private. For an authenticated user, an attacker
           would need to acquire an access token _a_n_d _a_l_l _c_r_e_d_e_n_t_i_a_l_s to make
           use of the token. For an unauthenticated user, only the access
           token is needed; presumably (but not necessarily) in this case a
           lower level of security is being applied to the resource in any
           case.

           It is the administrator's responsibility to ensure that
           authorization caching does not break the intended semantics of a
           rule - DDAACCSS does not do any consistency or sanity checks. For
           instance, if a rule is written to grant access only between 12:00
           and 12:59 but an access token produced by the rule could continue
           to be valid beyond that time interval, authorization caching could
           violate the intent of the rule. Also, a rule that ordinarily
           produces side effects would not do so for any requests granted
           through authorization caching.

           As long as an authorization decision remains valid, changes to the
           ruleset will not cause a cached decision to be reversed. That is, a
           change to the ruleset that would ordinarily cause a request to be
           denied will have no effect on a cached decision. The rreevvooccaattiioonn
           lliisstt[45] is, however, processed as usual, so it is possible for a
           cached decision to be denied due to revocation. An error
           encountered during processing would also cause access to be denied,
           regardless of authorization caching.

   XXMMLL OOuuttppuutt
       When XML output has been enabled, ddaaccss__aaccss will emit a document
       (conforming to ddaaccss__aaccss..ddttdd[46]) when access is denied, a processing
       error occurs, or when an access testing mode has been requested using
       the _D_A_C_S___A_C_S argument.

       ddaaccss__aaccss associates an error code with each event or reason for which
       access might be denied (see the description of the ACS_ERROR_HANDLER
       directive in ddaaccss..ccoonnff((55))[47]). The error code is itself sufficient for
       a client to know why access was denied. When access is denied, an
       appropriately named XML element is emitted. The element will include an
       explanatory text message, and optionally, the URI of a handler that the
       client might call to continue the workflow. This URI is obtained from
       the applicable ACS_ERROR_HANDLER directive, if any.

       The event905 element corresponds to the ACK_NEEDED (equivalent to error
       code 990055) DDAACCSS error event. It is emitted if the client must
       acknowledge one or more notices before the request will be granted. Its
       handler attributes, which are optional, are obtained from the
       ACS_ERROR_HANDLER directive that applies to this error and the
       NOTICES_ACK_HANDLER directive. If the ack_handler attribute is absent,
       then the presentation_handler is expected to perform both presentation
       and acknowledgement handling functions. The notice_uris attribute is a
       comma-separated list of URIs of notices that must be acknowledged by
       the user. The resource_uris attribute is a comma-separated list of URIs
       of resources associated with this request; this will usually be only a
       single URI. The time and hmac attributes are used to enforce a secure
       workflow mode. Please refer to ddaaccss__nnoottiicceess((88))[48] and ddaaccss..ccoonnff((55))[47]
       for additional detail.

       A common_status element indicates that ddaaccss__aaccss could not process the
       request. This might happen, for example, if ddaaccss__aaccss were not properly
       configured.

   VVaarriiaabblleess AAvvaaiillaabbllee TToo RRuulleess
       ddaaccss__aaccss predefines several variables that may be accessed by rules.
       Additionally, variables obtained from the request's credentials are
       exported into the environment of an invoked CGI program. In this way,
       services can know who is making the request, to retrieve user
       preferences, for example.

       In addition, parameters passed to a CGI program, whether through a
       query string or a message body (e.g., POST method data), may be
       accessed as variables. For example, for the service request:

            .../cgi-bin/foo?A=hello&B=world

       the variables _$_{_A_r_g_s_:_:_A_} with the value hello and _$_{_A_r_g_s_:_:_B_} with the
       value world will be defined at the time ACL rulesets are evaluated.
       Also, variables obtained from the authenticated credentials may be
       referenced (e.g., _$_{_D_A_C_S_:_:_J_U_R_I_S_D_I_C_T_I_O_N_}).

           NNoottee
           Because at present a variable cannot be multi-valued, if a variable
           is set more than once its value at the time of evaluation is not
           predictable. For example, given this query string you cannot depend
           on which value is assigned to _$_{_A_r_g_s_:_:_A_R_G_}:

                .../cgi-bin/foo?ARG=hello&ARG=world

           This also creates problems if you need to examine arguments
           produced by an HTML SELECT element within a form when the MULTIPLE
           attribute is used because each OPTION selected by the user will be
           associated with the same argument name. Syntactical and functional
           improvements are planned in this regard.

           Any "null" arguments in the query string (e.g., "&&") are ignored.
           A query string with a component that has a value but not a name
           (e.g., "&=foo") is considered to be invalid.

       From these sources, the execution environment, and from the DDAACCSS
       configuration, ddaaccss__aaccss automatically creates four "classes" of
       variables: CGI parameter variables, configuration variables,
       environment variables, and request-specific variables created by DDAACCSS.
       These classes are called namespaces; please refer to ddaaccss..eexxpprrss((55))[49]
       for details. For example, the value of a CGI parameter is accessed by
       _$_{_A_r_g_s_:_:_v_a_r_n_a_m_e_}, the value of a DDAACCSS context variable is accessed by
       _$_{_D_A_C_S_:_:_v_a_r_n_a_m_e_} (e.g., _$_{_D_A_C_S_:_:_J_U_R_I_S_D_I_C_T_I_O_N_}), and the value of
       configuration variable is obtained using _$_{_C_o_n_f_:_:_v_a_r_n_a_m_e_} (e.g.,
       _$_{_C_o_n_f_:_:_F_E_D_E_R_A_T_I_O_N___D_O_M_A_I_N_}).

       For ddaaccss__aaccss, the _E_n_v namespace is comprised of all CGI variables
       exported by AAppaacchhee, which includes HTTP request variables such as
       _$_{_E_n_v_:_:_H_T_T_P___U_S_E_R___A_G_E_N_T_}. The values of recognized headers that might
       compromise security are edited or deleted. Note that AAppaacchhee will export
       unrecognized HTTP request headers by prefixing the header name with
       HTTP_ and mapping the header name to upper case; this example results
       in _$_{_E_n_v_:_:_A_U_G_G_I_E_} having the value "Doggie":

           % http -header Auggie Doggie https://example.com/cgi-bin/dacs/someprog

       For other programs, the _E_n_v namespace is populated from the program's
       normal environment.

       These namespaces are reserved from other uses and their contents are,
       for the most part, read-only.

       The only MIME content types currently supported with respect to
       capturing CGI parameters are application/x-www-form-urlencoded, which
       is the default used by browsers when submitting a form, and
       multipart/form-data. At present, only 7bit data encoding is supported.
       The methods by which values from forms can be returned to a server are
       described in RRFFCC 11886677[50], RRFFCC 22338888[51], and HHTTMMLL 44[52].

       The following variables are exported to the "_D_A_C_S" namespace (e.g.,
       _$_{_D_A_C_S_:_:_Q_U_E_R_Y_}). Upper and lower case are distinct in variable names.
       These values are either obtained from AAppaacchhee or are elements of the
       client's credentials.

       _A_C_S
           If ddaaccss__aaccss is requested to test access, this variable will be
           defined and have the value of the _D_A_C_S___A_C_S argument.

       _A_R_G_S
           A string representing all of the parameters to a CGI program,
           excluding multipart/form-data, encoded as a query string. If the
           number or total size of the parameters exceeded the
           implementation-dependent limit, the variable _A_R_G_S___T_R_U_N_C_A_T_E_D will be
           defined and have a non-zero value.

       _A_R_G_S___T_R_U_N_C_A_T_E_D
           If this variable is defined and its value is non-zero, the argument
           list has been truncated. This means that not all arguments to the
           CGI program are accessible to ddaaccss__aaccss and the value of one
           argument may have been truncated. See AACCSS__PPOOSSTT__EEXXCCEEPPTTIIOONN__MMOODDEE[53].

       _A_R_G___C_O_U_N_T
           The number of arguments available in the _A_r_g_s namespace. If there
           are four arguments in a request's query string and two arguments
           within its application/x-www-form-urlencoded message body, for
           instance, then the value of _$_{_D_A_C_S_:_:_A_R_G___C_O_U_N_T_} will be six. These
           arguments will be available collectively as the value of
           _$_{_D_A_C_S_:_:_A_R_G_S_} and individually in the _A_r_g_s namespace.

       _A_U_T_H_O_R_I_Z_A_T_I_O_N
           The value of the Authorization HTTP header field, if available.

       _C_O_N_T_E_N_T___E_N_C_O_D_I_N_G
           The value of the Content-Encoding HTTP header field, if available.

       _C_O_N_T_E_N_T___L_E_N_G_T_H
           The value of the Content-Length HTTP header field, if available.

       _C_O_N_T_E_N_T___T_Y_P_E
           The value of the Content-Type HTTP header field, if available.

       _C_U_R_R_E_N_T___U_R_I
           The full URI for the requested resource, including any query
           component.

       _C_U_R_R_E_N_T___U_R_I___N_O___Q_U_E_R_Y
           The full URI for the requested resource, excluding any query
           component.

       _F_E_D_E_R_A_T_I_O_N
           The official name of the federation to which _J_U_R_I_S_D_I_C_T_I_O_N belongs.
           If the user was not authenticated, this variable will be undefined.

       _F_I_L_E_N_A_M_E
           The full path of the file corresponding to the URL being invoked,
           equivalent to AAppaacchhee's SSCCRRIIPPTT__FFIILLEENNAAMMEE environment variable or its
           _R_E_Q_U_E_S_T___F_I_L_E_N_A_M_E variable.

       _I_D_E_N_T_I_T_Y
           The DDAACCSS identity (the username component plus federation and
           jurisdiction components) if the user was authenticated, otherwise
           undefined.

       _I_N_T_E_R_A_C_T_I_V_E
           If the standard input is a valid terminal type device, this
           variable is set to 1, otherwise it is undefined.

       _I_P
           The IP address, in standard numeric dot notation, associated with
           _U_S_E_R_N_A_M_E. If the user was not authenticated, this variable will be
           undefined.

       _J_U_R_I_S_D_I_C_T_I_O_N
           The official, abbreviated name of the jurisdiction that
           authenticated _U_S_E_R_N_A_M_E. If the user was not authenticated, this
           variable will be undefined.

       _M_E_T_H_O_D
           The method used to invoke the URL, equivalent to AAppaacchhee's
           RREEQQUUEESSTT__MMEETTHHOODD environment variable.

       _P_A_T_H___I_N_F_O
           The PPAATTHH__IINNFFOO part of the URI, as set by AAppaacchhee.

       _P_O_S_T_D_A_T_A
           A MIME base-64 encoded string representing the data stream (message
           body) sent to a CGI program. If the number or total size of the
           parameters exceeded the configured limit, the variable
           _A_R_G_S___T_R_U_N_C_A_T_E_D will be defined and have a non-zero value. See the
           description of the SetDACSAuthPostBuffer directive to
           mmoodd__aauutthh__ddaaccss[12]).

       _P_R_O_X_Y_R_E_Q
           If set, the type of proxy processing performed for this request by
           Apache (from _S_E_R_V_I_C_E___P_R_O_X_Y_R_E_Q).

       _Q_U_E_R_Y
           The query string, if any, that was appended to the URL.

       _R_E_M_O_T_E___A_D_D_R
           The RREEMMOOTTEE__AADDDDRR, as set by AAppaacchhee.

       _R_E_M_O_T_E___H_O_S_T
           The RREEMMOOTTEE__HHOOSSTT, as set by AAppaacchhee.

       _R_I_D_E_N_T
           The Rlink identity, if any, associated with the rule currently
           being evaluated. See RRlliinnkkss[54].

       _R_I_P_T_R
           The Rlink identity pointer, if any, associated with the rule
           currently being evaluated. See RRlliinnkkss[54].

       _R_N_A_M_E
           The Rname, if any, associated with the rule currently being
           evaluated. This is also available as _$_{_A_r_g_s_:_:_R_N_A_M_E_}. See
           RRlliinnkkss[54].

       _R_O_L_E_S
           The role string associated with _U_S_E_R_N_A_M_E. If the user was not
           authenticated, this variable will be undefined.

       _U_R_I and _U_R_L
           The URL being invoked.

       _U_S_E_R_N_A_M_E
           The username (without any federation or jurisdiction component). If
           the user was not authenticated, this variable will be undefined.

       _U_S_E_R___A_G_E_N_T
           When provided by the user agent, this is equivalent to the HTTP
           User-Agent request-header field and HHTTTTPP__UUSSEERR__AAGGEENNTT environment
           variable provided by AAppaacchhee. When an actual value is unavailable,
           this variable is set to "unknown".

   EExxppoorrtteedd EEnnvviirroonnmmeenntt VVaarriiaabblleess
       The normal execution environment of a CGI program or internally
       processed script (e.g., mmoodd__pphhpp) invoked through DDAACCSS is augmented with
       environment variables instantiated from validated credentials, access
       control rules, configuration information, and so on. Through these
       variables, services have access to the identity of the user making the
       request to retrieve user preferences, for example, or make run-time
       decisions.

           NNoottee
           Environment variables with the prefix "DACS_" are reserved for use
           by DDAACCSS and should not be used for other purposes by an
           application. Upper and lower case are distinct in variable names.

           TTiipp
           If PPHHPP[55] is installed, a nice way to see the DDAACCSS environment
           variables that are passed to a CGI program is to run a DDAACCSS-wrapped
           script like this:

               <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
               <html><head>
               <meta http-equiv="Content-type" content="text/html;charset=ISO-8859-1">
               <title></title></head>
               <body>
               <p>
               <?php
               phpinfo();
               ?>
               </p>
               </body></html>

           Alternatively, you can use ddaaccss__pprreennvv((88))[56].

       Currently defined environment variables are listed here. More detailed
       descriptions of these variables appear in other DDAACCSS documents.

       DDAACCSS__AACCSS__JJUURRIISSDDIICCTTIIOONN
           This is the official DDAACCSS internal, abbreviated name for the
           jurisdiction that has granted access.

       DDAACCSS__AAPPPPRROOVVAALL
           A digitally signed message that confirms that DDAACCSS authorized the
           request. See ddaaccss__aaccss((88))[57].

       DDAACCSS__CCOONNCCIISSEE__IIDDEENNTTIITTYY
           This is the full DDAACCSS identity to which access was granted
           expressed in the concise syntax used by ddaaccsscchheecckk((11))[2]. When
           available, the user's roles and IP address are included.

       DDAACCSS__CCOONNFF
           This is the full pathname of the DDAACCSS configuration file.

       DDAACCSS__CCOONNSSTTRRAAIINNTT
           A constraint string associated with a sub-component of the matching
           access control rule permitting the service request.

       DDAACCSS__DDEEFFAAUULLTT__CCOONNSSTTRRAAIINNTT
           A constraint string associated with the matching access control
           rule.

       DDAACCSS__FFEEDDEERRAATTIIOONN
           This is the federation name component of DDAACCSS__IIDDEENNTTIITTYY.

       DDAACCSS__IIDDEENNTTIITTYY
           This is the full DDAACCSS identity to which access was granted.
           AAppaacchhee's RREEMMOOTTEE__UUSSEERR environment variable is also set to this
           value, so it is available for logging purposes and export to CGI
           programs.

       DDAACCSS__JJUURRIISSDDIICCTTIIOONN
           This is the jurisdiction component of DDAACCSS__IIDDEENNTTIITTYY.

       DDAACCSS__MMOODD__AAUUTTHH__DDAACCSS
           This is a version identification string for mmoodd__aauutthh__ddaaccss[3].

       DDAACCSS__RROOLLEESS
           This is the role string associated with DDAACCSS__UUSSEERRNNAAMMEE within
           DDAACCSS__JJUURRIISSDDIICCTTIIOONN.

       DDAACCSS__SSIITTEE__CCOONNFF
           This is the full pathname of the DDAACCSS site configuration file.

       DDAACCSS__UUSSEERRNNAAMMEE
           This is the username component of the identity to which access was
           granted.

       DDAACCSS__VVEERRSSIIOONN
           The major version number of DDAACCSS.

       AAbboouutt SSeerrvvlleettss
               NNoottee
               The details of how environment variables are passed from AAppaacchhee
               to servlets are beyond the scope of DDAACCSS. But for what it's
               worth, the following illustrates how to export and access them
               from servlets that are under the control of DDAACCSS in conjunction
               with mmoodd__jjkk[58] and TToommccaatt[59]. This used to work at one time
               but may no longer be correct.

           The following directives (which appear in, or are included in, the
           AAppaacchhee configuration file) are used (this list may be expanded):

               <IfModule mod_jk.c>
                 JkEnvVar DACS_FEDERATION         NONE
                 JkEnvVar DACS_JURISDICTION       NONE
                 JkEnvVar DACS_ACS_JURISDICTION   NONE
                 JkEnvVar DACS_ROLES              NONE
                 JkEnvVar DACS_USERNAME           NONE
                 JkEnvVar DACS_CONSTRAINT         NONE
                 JkEnvVar DACS_DEFAULT_CONSTRAINT NONE
                 JkEnvVar DACS_COOKIE             NONE
                 JkEnvVar DACS_MOD_AUTH_DACS      NONE
               </IfModule mod_jk.c>

           From a servlet, the values of these variables can be obtained
           through the ggeettAAttttrriibbuuttee(()) method, invoked on an _H_t_t_p_S_e_r_v_l_e_t_R_e_q_u_e_s_t
           object. For example:

               Object username = req.getAttribute("DACS_USERNAME");
               out.println("roles = " + req.getAttribute("DACS_ROLES"));


OOPPTTIIOONNSS
       Besides the standard command line arguments (see ddaaccss((11))[60]), ddaaccss__aaccss
       recognizes the following arguments:

       --pprrooxxyy--ssttaattiicc
           Reserved for future use.

       --pprrooxxyy--eexxeecc
           Reserved for future use.

   TThhee DDAACCSS__AACCSS AArrgguummeenntt
       Various aspects of the behaviour of ddaaccss__aaccss can be controlled by an
       optional argument named _D_A_C_S___A_C_S. This argument, which may be passed to
       _a_n_y web service, is interpreted by ddaaccss__aaccss rather than the web service
       that is being invoked. The value of this argument is parsed as a list
       of space-separated command line flags.

           TTiipp
           The space character(s) must be properly escaped; e.g., as %20 or +.

       One use of this feature is when an application or middleware would like
       to know whether DDAACCSS will grant or deny a service request without
       having to actually execute the service request. When building a menu,
       for instance, an application might want to exclude items involving
       service requests that would be denied to the user.  ddaaccss__aaccss provides
       this capability.

       To check whether access would be granted or denied, the application
       invokes the DDAACCSS-wrapped service or resource exactly as it would
       normally except that it provides the _D_A_C_S___A_C_S argument. In some
       situations, if access would be denied ddaaccss__aaccss will return an
       indication of what must be done; e.g., the user must authenticate or a
       notice must be acknowledged. Note that there can be multiple reasons
       for denying access, in which case an application may have to repeatedly
       request a check and address the reason for denial before access may be
       granted.

       The _D_A_C_S___A_C_S argument can be a query argument or can appear in a
       message body with the content type application/x-www-form-urlencoded
       (as in the case of an HTML form submitted using the POST method, for
       example). The _D_A_C_S___A_C_S argument may not be specified more than once. It
       is not always possible to escape this argument (see --iinnvviissiibbllee[61]).

       The following flags are recognized:

       --cchheecckk__oonnllyy
           The presence of this flag tells ddaaccss__aaccss not to actually execute
           the web service or return the resource, but to merely return the
           access control decision. This flag and the --cchheecckk__ffaaiill flag are
           mutually exclusive.

           If the access check was performed, HTTP status code 220000 (OK) will
           be returned; any other result indicates that the check could not be
           executed (e.g., due to an AAppaacchhee configuration problem or a DDAACCSS
           error). If the check is performed, a DACS-Status-Line HTTP
           extension header is included in the response by default (see
           below).

           The default response consists of a single line of text that gives
           the result. This line consists of a three digit result code,
           followed by a space, an explanatory message, and a newline
           character; for example,

               797 Access denied
               798 Access granted
               799 Access error

           Inspecting the result code is sufficient to obtain the outcome of
           the check. Any AAppaacchhee ErrorDocument directive for "error-code" 200
           is overridden. The --ffoorrmmaatt flag (see below) can be used to select a
           different output format.

               NNoottee
               The service or resource in question does not have to exist for
               ddaaccss__aaccss to grant access; for instance, this can happen if a
               wildcard rule pattern is used. Also, keep in mind that access
               control rules can be written to be highly context specific;
               there is no guarantee that the same decision made at one point
               in time will also be made an instant later (access control
               rules can depend on the current date or time, for instance).

               Rules can be written such that their evaluation results in
               persistent changes; for example, a database might be updated.
               These kinds of changes will occur both in normal operation and
               when only checking access.  ddaaccss__aaccss defines the variable
               _$_{_D_A_C_S_:_:_A_C_S_} only during the testing mode of operation so that,
               if necessary, rules can be written to differentiate between
               testing mode and normal operation.

       --cchheecckk__ffaaiill
           This flag is like the --cchheecckk__oonnllyy flag, except if access is granted
           the request is allowed to proceed. If access is not granted and
           HTTP status code 220000 is returned, a DACS-Status-Line HTTP extension
           header is included in the response by default (see below). The
           --cchheecckk__ffaaiill flag is useful in situations where a --cchheecckk__oonnllyy test
           that indicates that access would be granted is always immediately
           followed by the actual request. This flag and the --cchheecckk__oonnllyy flag
           are mutually exclusive.

       --ffoorrmmaatt _f_m_t
           By default, the --cchheecckk__oonnllyy flag (and in the case where access is
           denied, also the --cchheecckk__ffaaiill flag) results in a single line of text
           being output (equivalent to "--ffoorrmmaatt tteexxtt"). If more detail is
           required, an XML description can be produced by specifying any of
           the XML output formats. Refer to XXMMLL OOuuttppuutt[62], the _F_O_R_M_A_T CGI
           argument[63], and the --ffoorrmmaatt[64] command line argument.

       --rrnnaammee _r_n_a_m_e
           The string _r_n_a_m_e, which is assumed to be the name of an Rlink, is
           made available available as _$_{_A_r_g_s_:_:_R_N_A_M_E_} during evaluation of
           AACCSS__PPRREE__AAUUTTHH[65] directive expressions.

       --ssttaattuuss__lliinnee
       --nnoo--ssttaattuuss__lliinnee
           The --ssttaattuuss__lliinnee flag enables the DDAACCSS--SSttaattuuss--LLiinnee[66] header,
           overriding the setting of the SSTTAATTUUSS__LLIINNEE[67] configuration
           directive. The --nnoo__ssttaattuuss__lliinnee flag _a_l_w_a_y_s suppresses this header,
           regardless of the SSTTAATTUUSS__LLIINNEE[67] directive and the --cchheecckk__oonnllyy and
           --cchheecckk__ffaaiill flags.

       --vviissiibbllee
       --iinnvviissiibbllee
           If the _D_A_C_S___A_C_S argument is passed as a query argument, the default
           behaviour is to delete it so that it cannot be seen after access
           control processing grants access. This deletion is explicitly
           enabled by the --iinnvviissiibbllee flag and disabled by the --vviissiibbllee flag.
           If _D_A_C_S___A_C_S is not deleted, it will be passed to an invoked program
           and might affect subsequent processing.

               IImmppoorrttaanntt
               Deletion of the _D_A_C_S___A_C_S argument is currently possible only if
               it is passed as a query argument.
           For example, consider the hypothetical URL:

               https://example.com/cgi-bin/myprog?DACS_ACS=-check_fail+-visible&foo=baz

           If the CGI program mmyypprroogg is executed, it will not only see the
           _f_o_o_=_b_a_z argument, but also the _D_A_C_S___A_C_S_=_-_c_h_e_c_k___f_a_i_l_+_-_v_i_s_i_b_l_e
           argument, and this could trigger an error or incorrect behaviour
           when mmyypprroogg processes it.

           All DDAACCSS web services ignore a _D_A_C_S___A_C_S argument, however, so its
           presence will not affect them.

       The flag list is processed from left to right. Any flag may be
       repeated, with the value of a later occurrence overriding an earlier
       one. If some part of the _D_A_C_S___A_C_S argument is invalid, the initial,
       valid part will still be effective; e.g., if the initial part is
       --ffoorrmmaatt XML, the output format will be XML.

       ddaaccss__aaccss removes the _D_A_C_S___A_C_S argument from the rule-processing
       environment so as not to disturb access control processing.  DDAACCSS
       credentials may accompany the service request just as they would a real
       request and are incorporated into the check.

       Assuming the target resource is DDAACCSS-wrapped, instead of returning the
       resource, accessing the following URL would return an indication of
       whether an actual request to access the resource would be granted or
       denied:

           % http -v -v \
            'https://dacs.dss.ca/infocard-demo/cgi-bin/dacs/dacs_version?DACS_ACS=-check_only%20-format+xml'

       TThhee DDAACCSS--SSttaattuuss--LLiinnee hheeaaddeerr
           When the DDAACCSS__AACCSS==--cchheecckk__oonnllyy argument is present, the response
           from DDAACCSS includes an extension header named DACS-Status-Line. The
           format of this extension header follows that of the HTTP
           Status-Line (RRFFCC 22661166[30], section 6.1):

               DACS-Status-Line = "DACS-Status-Line" ":" _D_A_C_S_-_V_e_r_s_i_o_n SP _A_C_S_-_S_t_a_t_u_s_-_C_o_d_e
                 SP _R_e_a_s_o_n_-_P_h_r_a_s_e CRLF

           Where:

               _D_A_C_S_-_V_e_r_s_i_o_n = "DACS-" _V_e_r_s_i_o_n

           and _V_e_r_s_i_o_n is the DDAACCSS__VVEERRSSIIOONN__RREELLEEAASSEE string (e.g., 1.4.8b), and
           where:

               _A_C_S_-_S_t_a_t_u_s_-_C_o_d_e = "797" | "798" | "799"

           The status code 779977 means that DDAACCSS denies access, 779988 means that
           it grants access, and 779999 means that an error occurred during
           processing.

           Here are some examples:

               DACS-Status-Line: DACS-1.4.8b 797 Access denied
               DACS-Status-Line: DACS-1.4.8b 798 Access granted
               DACS-Status-Line: DACS-1.4.8b 799 Access error

           The reason phrases in the examples are only recommendations; they
           may be replaced by local equivalents without affecting the
           protocol.

               NNoottee
               The reason phrase may include additional information, such as
               an audit identifier, that can be used to track the request in
               the DDAACCSS logs:

                   DACS-Status-Line: DACS-1.4.10 798 Access granted, unauth user (j10OXL2Z)

           This header is also returned when --cchheecckk__ffaaiill is requested, but
           only if access is not granted.

       TThhee DDAACCSS__AAPPPPRROOVVAALL eennvviirroonnmmeenntt vvaarriiaabbllee
           If enabled by the AACCSS__EEMMIITT__AAPPPPRROOVVAALL[68] directive, the
           DDAACCSS__AAPPPPRROOVVAALL environment variable will be passed to a DDAACCSS-wrapped
           program. If the program cares to verify that its execution has been
           authorized, it may validate the approval's signature (to ensure
           that the approval has not been forged) and validate the stamp (to
           ensure that the approval is not being replayed). Note that if a
           man-in-the-middle attack is of concern, end-to-end encryption
           should be used.

           With proper configuration, this feature can be used by a web-based
           program that is not DDAACCSS-wrapped but for which authorization has
           been obtained indirectly. For example, when ddaaccss__uupprrooxxyy((88))[69],
           invokes a program, ddaaccss__uupprrooxxyy will forward the value of
           DDAACCSS__AAPPPPRROOVVAALL (when available) to the invoked program, which can
           obtain the value in its HHTTTTPP__DDAACCSS__UUPPRROOXXYY__AAPPPPRROOVVAALL environment
           variable. If it is able to validate the value (or can trust it),
           the invoked program knows that its execution was authorized by
           DDAACCSS, even though DDAACCSS may not be configured or even installed on
           the host where the invoked program runs.

           A jurisdiction's cryptographic keys, identified by the virtual
           filestore item type jurisdiction_keys, must be configured so that
           the approval can be digitally signed.

           The value of DDAACCSS__AAPPPPRROOVVAALL has the following format:

               a="_d_a_c_s_6_4_-_a_p_p_r_o_v_a_l_-_m_e_s_s_a_g_e", s="_d_a_c_s_6_4_-_s_i_g_n_a_t_u_r_e"

           The _d_a_c_s_6_4_-_a_p_p_r_o_v_a_l_-_m_e_s_s_a_g_e is a ddaaccss6644[33] encoded string,
           described below. The _d_a_c_s_6_4_-_s_i_g_n_a_t_u_r_e is the dacs64 encoded RSA
           signature of the approval message, which is the unencoded
           _d_a_c_s_6_4_-_a_p_p_r_o_v_a_l_-_m_e_s_s_a_g_e.

           An approval message has the following format:

               j="_j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e"<newline>
               h="_d_i_g_e_s_t_-_n_a_m_e"<newline>
               s="_s_t_a_m_p"<newline>
               u="_u_r_i"<newline>
               m="_m_e_t_h_o_d"<newline>
               i="_i_d_e_n_t"

           Here, _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e is the name of the jurisdiction (including
           its federation name) that generated the approval. The name of the
           message digest (secure hash) algorithm used to sign the approval is
           _d_i_g_e_s_t_-_n_a_m_e. The unique stamp is _s_t_a_m_p (as generated by
           uussttaammpp(())[70]) and the URI, including any query component, is _u_r_i.
           The HTTP method is _m_e_t_h_o_d. The DDAACCSS identity of the user for which
           access was granted is _i_d_e_n_t (or "unauth", if none). The _s_t_a_m_p and
           _m_e_t_h_o_d are mapped to lowercase. Here is an example of an approval
           message:

               j="DSS::DSS-dacs"
               h="SHA1"
               s="1185565675:130",
               u="http://example.com/cgi-bin/dacs/dacs_current_credentials?FORMAT=HTML"
               m="get"
               i="unauth"

           The RSA signature is computed using the jurisdiction's private key
           and SHA-1 (by default) over the approval message. A different
           message digest algorithm can be used by setting the configuration
           variable _$_{_C_o_n_f_:_:_d_a_c_s___a_p_p_r_o_v_a_l___d_i_g_e_s_t___n_a_m_e_} (see ddiiggeesstt(())[71] for
           information about message digest algorithms):

               EVAL ${Conf::dacs_approval_digest_name} = "SHA256"


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccssaaccll((11))[43], ddaaccsscchheecckk((11))[2], ddaaccss..aaccllss((55))[4], ddaaccss..ccoonnff((55))[47],
       ddaaccss__aaddmmiinn((88))[44]

BBUUGGSS
       While the _D_A_C_S___A_C_S mechanism can be useful, it is still a kludge,

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[72])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[73] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

        3. mod_auth_dacs
           http://dacs.dss.ca/man/mod_auth_dacs.html

        4. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        5. logging
           http://dacs.dss.ca/man/dacs.1.html#logging

        6. LOG_LEVEL
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_LEVEL

        7. LOG_FILTER
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_FILTER

        8. AddDACSAuth
           http://dacs.dss.ca/man/mod_auth_dacs.html#AddDACSAuth

        9. DACS_HOME
           http://dacs.dss.ca/man/dacs.conf.5.html#var_dacs_home

       10. pipe(2)
           http://www.freebsd.org/cgi/man.cgi?query=pipe&apropos=0&sektion=2&manpath=FreeBSD+7.2-RELEASE&format=html

       11. Variables Available To Rules
           http://dacs.dss.ca/man/#vars_in_rules

       12. mod_auth_dacs
           http://dacs.dss.ca/man/mod_auth_dacs.html#SetDACSAuthPostBuffer

       13. ALLOW_HTTP_COOKIE
           http://dacs.dss.ca/man/dacs.conf.5.html#ALLOW_HTTP_COOKIE

       14. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

       15. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#credentials

       16. dacsrlink(1)
           http://dacs.dss.ca/man/dacsrlink.1.html

       17. RLINK
           http://dacs.dss.ca/man/dacs.conf.5.html#RLINK

       18. the one used for normal rules
           http://dacs.dss.ca/man/dacs.acls.5.html#acl_files

       19. concise user identity
           http://dacs.dss.ca/man/dacs.1.html#concise_user_syntax

       20. identity element
           http://dacs.dss.ca/man/dacs.acls.5.html#elements

       21. DACS_ACS argument
           http://dacs.dss.ca/man/#dacs_acs_argument

       22. redirect()
           http://dacs.dss.ca/man/dacs.exprs.5.html#redirect

       23. HTTP_AUTH_ENABLE
           http://dacs.dss.ca/man/dacs.conf.5.html#HTTP_AUTH_ENABLE

       24. HTTP_AUTH
           http://dacs.dss.ca/man/dacs.conf.5.html#HTTP_AUTH

       25. Auth clause directives
           http://dacs.dss.ca/man/dacs_authenticate.8.html#auth_clause

       26. local_apache_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_apache_authenticate

       27. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ERROR_HANDLER

       28. AUTH_SUCCESS_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_SUCCESS_HANDLER

       29. AUTH_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_ERROR_HANDLER

       30. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

       31. http(1)
           http://dacs.dss.ca/man/http.1.html

       32. passed using this request-header
           http://dacs.dss.ca/man/#http_authentication

       33. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html#encode

       34. COOKIE_PATH
           http://dacs.dss.ca/man/dacs.conf.5.html#COOKIE_PATH

       35. COOKIE_NO_DOMAIN
           http://dacs.dss.ca/man/dacs.conf.5.html#COOKIE_NO_DOMAIN

       36. COOKIE_HTTP_ONLY
           http://dacs.dss.ca/man/dacs.conf.5.html#COOKIE_HTTP_ONLY

       37. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html#configure_options

       38. ACS_ACCESS_TOKEN_ENABLE
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ACCESS_TOKEN_ENABLE

       39. ACS_ACCESS_TOKEN_LIFETIME_LIMIT
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ACCESS_TOKEN_LIFETIME_LIMIT

       40. ACS_ACCESS_TOKEN_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ACCESS_TOKEN_LIFETIME_SECS

       41. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html#acl_syntax

       42. tail matching
           http://dacs.dss.ca/man/dacs.acls.5.html#tail_matching

       43. dacsacl(1)
           http://dacs.dss.ca/man/dacsacl.1.html

       44. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       45. revocation list
           http://dacs.dss.ca/man/dacs.acls.5.html#revocation_list

       46. dacs_acs.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_acs.dtd

       47. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       48. dacs_notices(8)
           http://dacs.dss.ca/man/dacs_notices.8.html

       49. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html#variables

       50. RFC 1867
           http://www.rfc-editor.org/rfc/rfc1867.txt

       51. RFC 2388
           http://www.rfc-editor.org/rfc/rfc2388.txt

       52. HTML 4
           http://www.w3.org/TR/html4

       53. ACS_POST_EXCEPTION_MODE
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_POST_EXCEPTION_MODE

       54. Rlinks
           http://dacs.dss.ca/man/#rlinks

       55. PHP
           http://www.php.net

       56. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

       57. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_approval

       58. mod_jk
           http://tomcat.apache.org/connectors-doc/generic_howto/quick.html

       59. Tomcat
           http://jakarta.apache.org

       60. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       61. --iinnvviissiibbllee
           http://dacs.dss.ca/man/#invisible_flag

       62. XML Output
           http://dacs.dss.ca/man/#XML-output

       63. _F_O_R_M_A_T CGI argument
           http://dacs.dss.ca/man/dacs.1.html#FORMAT

       64. --ffoorrmmaatt
           http://dacs.dss.ca/man/dacs.1.html#format-arg

       65. ACS_PRE_AUTH
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_PRE_AUTH

       66. DACS-Status-Line
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_status_line

       67. STATUS_LINE
           http://dacs.dss.ca/man/dacs.conf.5.html#STATUS_LINE

       68. ACS_EMIT_APPROVAL
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_EMIT_APPROVAL

       69. dacs_uproxy(8)
           http://dacs.dss.ca/man/dacs_uproxy.8.html

       70. ustamp()
           http://dacs.dss.ca/man/dacs.exprs.5.html#ustamp

       71. digest()
           http://dacs.dss.ca/man/dacs.exprs.5.html#digest

       72. www.dss.ca
           http://www.dss.ca

       73. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                       DACS_ACS(8)
