DACS.INSTALL(7)         DACS Miscellaneous Information         DACS.INSTALL(7)



NNAAMMEE
       dacs.install - DDAACCSS installation guide

DDEESSCCRRIIPPTTIIOONN
       This document describes how to configure and install this release of
       DDAACCSS. Please read it carefully.

           IImmppoorrttaanntt
           +o   Installation requires the GNU mmaakkee command (ggmmaakkee[1]) and
               GGCCCC[2].

           +o   The examples here and in other DDAACCSS documentation assume that
               DDAACCSS is installed in its default location, /usr/local/dacs. If
               you specify a different location at build time, please keep
               this in mind as you read the documentation. This also applies
               to third-party packages, which you may install where
               convenient, provided you are careful not to mix different
               versions of the same package; in this document's examples we
               install them under /usr/local and unpack their source code
               under /local/src.

           +o   In some command line examples, long lines have been split to
               improve readability.

           +o   Whenever you upgrade to a more recent version of DDAACCSS, please
               do not forget to install the mmoodd__aauutthh__ddaaccss module that comes
               with your new version of DDAACCSS.

           +o   Please pay careful attention to the descriptions of the
               third-party packages below. Our philosophy is that DDAACCSS should
               be used with the most recent versions of third-party packages
               available at the time DDAACCSS is released. This helps to ensure
               that a DDAACCSS deployment has the latest security features and bug
               fixes.

               You should build third-party packages in the order in which
               they are discussed below because packages that are discussed
               earlier may require some that appear later.

               For a few third-party packages, it is important that you use
               the _e_x_a_c_t _v_e_r_s_i_o_n that is mentioned. Do not use anything newer
               or older.

               For some third-party packages, a particular release is
               _r_e_c_o_m_m_e_n_d_e_d. It is less critical that you use the recommended
               release, but older releases may have important bugs, including
               security problems. A release newer than the one(s) specified
               will not have been tested with DDAACCSS - and a release older than
               the one(s) specified may not have been tested with DDAACCSS - so if
               you choose to use such a release you are on your own.

               You may save yourself time and headaches if you just use the
               recommended releases.

               Sometimes the recommended version of a third-party package will
               be fine on some platforms but will not build or is buggy on
               another platform. Whenever possible, the DDAACCSS installation
               instructions suggest an alternative version, and you may
               proceed with that version, or a recent version of your choice -
               but keep the preceding comments regarding older releases in
               mind and ensure that a "ggmmaakkee tteesstt" of DDAACCSS completes
               successfully.


   TTrryyiinngg DDAACCSS
       If at this time you only want to try DDAACCSS rather than doing a full
       install, review the information below regarding third-party packages
       and then proceed to follow the instructions you will find in
       ddaaccss..qquuiicckk((77))[3], which is a step-by-step tutorial for installing and
       configuring DDAACCSS.

   UUppggrraaddiinngg DDAACCSS
       If DDAACCSS 1.4 is already installed on your system and you are not
       changing any third-party packages or installation options, for a "quick
       and dirty" upgrade you can often install a new release on top of a
       previous release. While this will leave your existing DDAACCSS
       configuration files alone, it will also leave files that are no longer
       needed by the new DDAACCSS. Be sure to check the new distribution's release
       notes and the rest of this manual page for any notable differences and
       incompatibilities - you may need to make some adjustments to your
       pre-existing installation.

       It is possible for minor, incompatible changes introduced by a new
       release to cause temporary, user-visible problems. For example, changes
       to the format of credentials might invalidate sessions (i.e., DDAACCSS HTTP
       cookies) issued by the earlier release, requiring users to
       reauthenticate.

        1. Make a backup copy of the previous install, just in case.  _I_t _i_s
           _e_s_p_e_c_i_a_l_l_y _i_m_p_o_r_t_a_n_t _t_o _m_a_k_e _c_o_p_i_e_s _o_f _a_l_l _d_a_t_a _f_i_l_e_s _(_s_u_c_h _a_s DDAACCSS
           _p_a_s_s_w_o_r_d _f_i_l_e_s_, _o_t_h_e_r _k_i_n_d_s _o_f _a_c_c_o_u_n_t _f_i_l_e_s_, _e_n_c_r_y_p_t_i_o_n _k_e_y_s_) _a_n_d
           _a_n_y _c_u_s_t_o_m _c_o_n_f_i_g_u_r_a_t_i_o_n _(_s_u_c_h _a_s _a_c_c_e_s_s _c_o_n_t_r_o_l _r_u_l_e_s_).

        2. Obtain and unpack the new distribution and cchhddiirr to it;

        3. Review ddaaccss..rreeaaddmmee((77))[4] and the instructions in this document;

        4. Copy src/config.nice from your installed version to the new src
           directory, make any updates and corrections that are necessary, and
           configure DDAACCSS:

               % cd src; sh ./config.nice


        5. Build DDAACCSS:

               % gmake


        6. We recommend that you remove some of the files from the previous
           release in case they are no longer required or have been renamed.
           Unless you have put non-standard files in them or made non-standard
           customizations, it is safe to simply delete these directories and
           their contents:

               % rm -f -r /usr/local/dacs/{acls,bin,include,lib,man,www}


        7. Stop hhttttppdd:

               % apachectl stop


        8. Install DDAACCSS:

               % gmake install


        9. Make and install the latest mmoodd__aauutthh__ddaaccss module:

               % cd ../apache; gmake tag install


       10. Restart hhttttppdd:

               % apachectl start

           or

               % apachectl startssl


       11. Check that DDAACCSS appears to be working correctly. You may find it
           handy to construct a set of links or bookmarks that you can use
           after installing or configuring DDAACCSS to invoke various DDAACCSS web
           services with appropriate arguments; for instance, try
           ddaaccss__aauutthheennttiiccaattee((88))[5] ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[6],
           ddaaccss__pprreennvv((88))[7], ddaaccss__lliisstt__jjuurriissddiiccttiioonnss((88))[8], ddaaccss__ccoonnff((88))[9],
           ddaaccss__ssiiggnnoouutt((88))[10], and ddaaccss__vveerrssiioonn((88))[11]. Review the DDAACCSS log
           file for any error messages or warnings.

   DDAACCSS oonn WWiinnddoowwss
       DDAACCSS is not currently supported on Microsoft Windows platforms.
       CCyyggwwiinn[12], which provides a GNU/Linux-like environment for Windows, is
       not an officially-supported platform, but DDAACCSS releases usually build
       on it.

       To run DDAACCSS utilities and commands on Windows (such as ddaaccsscchheecckk), it
       appears to be sufficient to install the binaries along with the Cygwin
       run-time libraries that they require, such as /bin/cygwin1.dll and
       /bin/cygcrypt-0.dll.

   IInnssttaalllliinngg DDAACCSS
       The following describes how to install DDAACCSS.

           IImmppoorrttaanntt
           +o   If another release of DDAACCSS is present, rename your previous
               release, install the new release, and then copy any
               site-specific configuration files from the previous release to
               the new release.

           +o   Be careful not to mix DDAACCSS binaries and support files from
               different releases; this can lead to strange behaviour that is
               often hard to resolve.

           +o   If you are installing or upgrading a third-party package, make
               sure that you are building against the include files and
               libraries from the correct version (i.e., that the DDAACCSS build
               is not finding an old version, or using include files from one
               version and library files from a different version). This can
               also cause strange problems.

        1. Unpack the DDAACCSS distribution and move to its root directory.

        2. Familiarize yourself with the system by:

           +o   reading this document;

           +o   running:

                   % src/configure --help


           +o   browsing through the documentation (easily done by loading
               mmaann//iinnddeexx..hhttmmll[13] into your browser);

           +o   deciding where you want the various components to be installed;
               and

           +o   considering which optional features you may want (you can
               easily make changes at any time, so do not be too concerned
               about this).

            3. A few third-party packages are _r_e_q_u_i_r_e_d by DDAACCSS and must be
               built before DDAACCSS can be configured and built. Please note
               carefully if any special exceptions apply to your particular
               platform and third-party package needs. Although you may have
               better luck, sometimes we experienced problems building the
               recommended packages (or combinations of packages) on certain
               platforms; whenever possible, we try to provide a workable
               alternative. Late-breaking updates are sometimes available in
               the release's PPoosstt--RReelleeaassee NNootteess[14].

                   IImmppoorrttaanntt
                   It is not necessary to actually _i_n_s_t_a_l_l these packages, you
                   only have to _b_u_i_l_d them so that the DDAACCSS build can use
                   their libraries, include files, and so on, directly from
                   where you build the packages. You may chose to do this if
                   you do not want to upgrade an existing version of the
                   package, or if you are unable to do so.

                   Build these packages _i_n _t_h_e _o_r_d_e_r _i_n _w_h_i_c_h _t_h_e_y _a_r_e _l_i_s_t_e_d
                   _b_e_l_o_w. If you install a package, you may need to be root or
                   use ssuuddoo((88))[15].

                   These packages are not distributed with DDAACCSS and have
                   licensing terms completely separate from those of DDAACCSS that
                   are your responsibility.

                1. Install the Expat XML parser

                   This release of DDAACCSS has been tested with EExxppaatt[16] 2.0.1
                   and we recommend that you use that release.

                   For use with DDAACCSS, EExxppaatt can either be built with
                   --pprreeffiixx==//uussrr//llooccaall or something like
                   --pprreeffiixx==//uussrr//llooccaall//eexxppaatt--22..00..11, whichever you prefer. In
                   the former case, you can omit the ----wwiitthh--eexxppaatt when
                   configuring DDAACCSS or use ----wwiitthh--eexxppaatt==//uussrr//llooccaall, and in the
                   latter case you must use
                   ----wwiitthh--eexxppaatt==//uussrr//llooccaall//eexxppaatt--22..00..11. For the record, here
                   is an example of how we build EExxppaatt after unpacking it:

                       % cd expat-2.0.1
                       % ./configure --prefix=/usr/local/expat-2.0.1
                       % make
                       (All should go well.)
                       % make install
                       (All should go well here, too.)


                       NNoottee
                       On Win2K/Cygwin, only a static library is needed. From
                       the root of the eexxppaatt distribution directory:

                           % cd lib; ar rv libexpat.a *.o; ranlib libexpat.a

                       If the build fails, reconfigure using
                       ----eennaabbllee--sshhaarreedd==nnoo and ----eennaabbllee--ssttaattiicc==yyeess and try to
                       build it again.

                2. Install OOppeennSSSSLL

                   DDAACCSS uses cryptographic functionality provided by
                   OOppeennSSSSLL[17]. This release of DDAACCSS has been tested with
                   openssl-1.0.0f and we recommend that you use that release
                   with DDAACCSS.  AAppaacchhee should be built using the version of
                   OOppeennSSSSLL recommended by the particular AAppaacchhee release -
                   using a more recent version of OOppeennSSSSLL may introduce build
                   problems or run-time bugs in AAppaacchhee.  _I_t _i_s _n_o_t _n_e_c_e_s_s_a_r_y
                   _f_o_r AAppaacchhee _a_n_d DDAACCSS _t_o _u_s_e _t_h_e _s_a_m_e _r_e_l_e_a_s_e _o_f OOppeennSSSSLL.

                       NNootteess
                       +o   Releases of AAppaacchhee prior to 2.0.55 do not work (as
                           shipped) with OOppeennSSSSLL 0.9.8 or newer.

                       +o   DDAACCSS will work with openssl-1.0.0 but not with
                           openssl-0.9.8[mno] ("ggmmaakkee tteesstt" fails);
                           openssl-0.9.8l is the last of the pre-openssl-1.0.0
                           releases known to work correctly with DDAACCSS.

                       +o   If you need InfoCard support and you have upgraded
                           to openssl-1.0.0 or newer, it may be necessary to
                           rebuild xxmmllsseecc11[18] against the new library (if you
                           need to rebuild, "ggmmaakkee tteesstt" will fail).

                       +o   When building openssl-0.9.8j on FreeBSD 7.0,
                           problems were encountered that caused "mmaakkee
                           iinnssttaallll" to fail; corrections to Makefiles under
                           the fips subdirectory solved the problem.

                       +o   On OpenSolaris, more serious problems building
                           openssl-0.9.8j and openssl-0.9.8k were found and
                           neither could be successfully completed; with the
                           same options and environment, openssl-0.9.8i and
                           openssl-0.9.8l built without incident, however, and
                           the latter was used for testing on that platform.
                           There were also problems forcing the runtime linker
                           to use OOppeennSSSSLL libraries other than the default
                           system versions, despite the guidance of the
                           relevant manual pages; it was necessary to set
                           LLDD__LLIIBBRRAARRYY__PPAATTHH appropriately (use ddaaccssvveerrssiioonn --vv
                           to verify that the expected libraries are being
                           used at runtime).

                       +o   If you are enabling DDAACCSS support for Java, add the
                           --ffPPIICC flag to ccoonnffiigg when you are building OOppeennSSSSLL.

                       +o   In some configurations you may want or require
                           shared OOppeennSSSSLL libraries; if so, add the sshhaarreedd
                           command line flag to ccoonnffiigg when building OOppeennSSSSLL.

                       +o   Solaris 8 (and perhaps other platforms) may require
                           aa ppaattcchh[19] before OOppeennSSSSLL will work properly.
                           Please consult the latest OOppeennSSSSLL documentation.

                       +o   For Solaris 10 x86, review OOppeennSSSSLL''ss PROBLEMS file
                           to see if you must apply a patch before OOppeennSSSSLL
                           will compile correctly with GGCCCC.

                       +o   For the record, here is an example of how we build
                           OOppeennSSSSLL:

                               % ./config --prefix=/usr/local/openssl-1.0.0f --openssldir=/usr/local/openssl-1.0.0f -fPIC shared


                       +o   On Mac OS X, however, it was necessary to
                           explicitly request a 64-bit build of OOppeennSSSSLL:

                               % ./Configure darwin64-x86_64-cc --prefix=/usr/local/openssl-1.0.0f --openssldir=/usr/local/openssl-1.0.0f -fPIC shared


                    3. Install Apache 2.2.21 or 2.0.64

                       You will need an SSL-capable AAppaacchhee[20] server (build
                       AAppaacchhee with ----eennaabbllee--ssssll) that uses a recent version of
                       OOppeennSSSSLL (build AAppaacchhee using ----wwiitthh--ssssll==_p_a_t_h, see
                       aabboovvee[21]).

                           TTiipp
                           You can install a subset of DDAACCSS that does not
                           require AAppaacchhee and does not require _a_n_y DDAACCSS
                           configuration. These stand-alone, general-purpose
                           utility commands, such as hhttttpp and ssssllcclliieenntt, might
                           be of interest to you even if you are not
                           interested in any other parts of DDAACCSS. Look for
                           BASIC_PROGS in Makefile.in to see which commands
                           will be installed.

                           To build this subset, use ----wwiitthh--aappaacchhee==oommiitt when
                           running ccoonnffiigguurree. Please continue to review the
                           information about third-party packages in this
                           document, but you can ignore anything that follows
                           that is related to AAppaacchhee and mmoodd__aauutthh__ddaaccss.
                       If you want to use mmoodd__aauutthh__ddaaccss as a dynamic module,
                       which is the recommended configuration, make sure that
                       mmoodd__ssoo is built-in to your hhttttppdd ("httpd -l" displays a
                       list).

                           IImmppoorrttaanntt
                           +o   This release of DDAACCSS has been tested with both
                               AAppaacchhee 2.0.64 and AAppaacchhee 2.2.21. We strongly
                               recommend that you use either of those
                               versions. If necessary, DDAACCSS will probably also
                               work with 2.0.51 and newer, or 2.2.2 and newer,
                               but not with releases older than that.

                           +o   When building AAppaacchhee 2.2, we first build and
                               install APR (srclib/apr) and APR-UTIL
                               (srclib/apr-util), and then build hhttttppdd using
                               the ----wwiitthh--aapprr and ----wwiitthh--aapprr--uuttiill flags. This
                               may be helpful to know if you run into
                               problems. Also, if you encounter problems
                               building ddaaccssvveerrssiioonn, it may be necessary for
                               you to go back and build APR with the
                               ----ddiissaabbllee--llffss flag to disable large file
                               support on your platform. When you build DDAACCSS
                               in an upcoming step, you will probably need to
                               use the ----wwiitthh--aappaacchhee and ----wwiitthh--aappaacchhee--aapprr
                               flags (see TThhiirrdd--ppaarrttyy ssuuppppoorrtt ooppttiioonnss[22]). If
                               you are going to use the ----wwiitthh--bbeerrkkeelleeyy--ddbb
                               flag when building APR-UTIL, you may want to
                               temporarily skip ahead to bbuuiilldd BBeerrkkeelleeyy DDBB[23]
                               before returning here to continue your AAppaacchhee
                               build.

                           +o   For the record, here is an example of how we
                               built AAppaacchhee 2.2 after unpacking it:

                                   % cd httpd-2.2.21
                                   % cd srclib/apr
                                   % ./configure --prefix=/usr/local/apache2-2.2.21/apr-httpd --disable-lfs CFLAGS=-fPIC
                                   % make install
                                   % cd ../apr-util
                                   # See notes below for adding LDFLAGS
                                   % ./configure --prefix=/usr/local/apache2-2.2.21/apr-util-httpd
                                          --with-apr=/usr/local/apache2-2.2.21/apr-httpd
                                          --with-expat=/usr/local/expat-2.0.1
                                          --with-berkeley-db=/usr/local/BerkeleyDB.5.3
                                          --with-dbm=db50
                                   % make install
                                   % cd ../..
                                   # See notes below for adding LDFLAGS
                                   % ./configure --prefix=/usr/local/apache2-2.2.21 --enable-ssl
                                          --with-ssl=/usr/local/openssl-1.0.0f
                                          --with-apr=/usr/local/apache2-2.2.21/apr-httpd
                                          --with-apr-util=/usr/local/apache2-2.2.21/apr-util-httpd
                                          LDFLAGS="-rpath /usr/local/BerkeleyDB.5.3/lib -rpath /usr/local/openssl-1.0.0f/lib"
                                   % make install

                               This builds a very basic server; you can enable
                               other options if you want.

                               Because we deal with multiple versions of
                               third-party packages, each release is installed
                               separately, hence the version numbers in the
                               pathnames.

                               Your mileage may vary, but when doing the top
                               level AAppaacchhee configuration above on FreeBSD it
                               was necessary to add "-rpath
                               /usr/local/BerkeleyDB.5.3/lib -rpath
                               /usr/local/openssl-1.0.0f/lib" to _L_D_F_L_A_G_S so
                               that Apache commands could find the shared
                               library at run time. On Linux, it was necessary
                               to add "-Wl,-rpath
                               /usr/local/BerkeleyDB.5.3/lib -Wl,-rpath
                               /usr/local/openssl-1.0.0f/lib" to _L_D_F_L_A_G_S when
                               building apr-util and at the top level.
                               Alternatively, on either platform the llddccoonnffiigg
                               command or LLDD__LLIIBBRRAARRYY__PPAATTHH might be used. It
                               does not appear necessary to specify additional
                               linker flags on Mac OS X.

                           +o   One difference between the AAppaacchhee 2.0 and 2.2
                               releases to be aware of is that the default
                               AAppaacchhee configuration with 2.2 may deny all
                               access by default; some DDAACCSS files should be
                               publicly accessible, however, so you may need
                               to explicitly allow this. For example, in
                               httpd.conf:

                                   <Directory /usr/local/dacs/www>
                                     Satisfy Any
                                     Allow from all
                                     Options Indexes FollowSymLinks
                                   </Directory>


                           +o   AAppaacchhee 1.3 is _n_o_t supported; please consult the
                               FFAAQQ[24].  DDAACCSS has not been tested with AAppaacchhee
                               2.3 or 2.4.

                           +o   We do not support using mmoodd__aauutthh__ddaaccss with a
                               non-source install of AAppaacchhee; we have received
                               feedback that it can be done manually without
                               much effort, however. In this case, we believe
                               that the install may go more smoothly if you
                               use the configure flag ----ddiissaabbllee--sshhaarreedd.

                           TTiipp
                           Check that AAppaacchhee is working properly and that it
                           is actually using the version of OOppeennSSSSLL that you
                           are expecting. It is important to confirm that your
                           server is working correctly with your web resources
                           _b_e_f_o_r_e DDAACCSS gets involved - doing so can save you
                           time and frustration.

                           You can see your hhttttppdd''ss Server response-header by
                           connecting to your server (e.g., using tteellnneett) and
                           engaging in an interaction with it similar to the
                           following (note the last line of output):

                               % telnet localhost 80
                               Trying 127.0.0.1...
                               Connected to localhost
                               Escape character is '^]'.
                               GET / HTTP/1.0

                               HTTP/1.1 200 OK
                               Date: Tue, 30 Aug 2011 21:27:17 GMT
                               Server: Apache/2.2.21 (Unix) mod_auth_dacs/1.4.26(Release date 32-Sep-2011 00:00:01) mod_ssl/2.2.21 OpenSSL/1.0.0d

                4. A few third-party packages are _o_p_t_i_o_n_a_l and whether you
                   need them depends on which optional features of DDAACCSS you
                   require. These packages must be built before DDAACCSS can be
                   configured and built. If you decide you want to add or
                   remove optional capabilities after building DDAACCSS, it is
                   easy to do so later.

                       TTiipp
                       If you are new to DDAACCSS, it may be a good idea to first
                       build it without any optional packages. After you have
                       gotten the basic system working to your satisfaction,
                       rebuild DDAACCSS with the optional components you need. Or,
                       if you are not sure at this time which optional
                       packages you need, return to this step later.

                    1. Berkeley DB, gdbm, ndbm DB (dbm-type databases)

                       If you want to be able to store DDAACCSS configuration
                       information in a database or need to access files
                       managed by AAppaacchhee''ss mmoodd__aauutthh__ddbbmm, you may use BBeerrkkeelleeyy
                       DDBB[25] from OOrraaccllee CCoorrppoorraattiioonn[26] (Sleepy Cat Software
                       was acquired by Oracle in February, 2006). A suitable
                       version may already be installed on your system.
                       Version db-5.3.15 is being used for testing, but
                       somewhat older or newer versions should be fine. See
                       the DDAACCSS configure arguments: ----eennaabbllee--bbddbb[27],
                       ----ddiissaabbllee--bbddbb[28], and ----wwiitthh--bbddbb[29].

                       The default is to use Berkeley DB if it is available,
                       but if you do not want to use Berkeley DB you can
                       disable it (----ddiissaabbllee--bbddbb[28]) and get similar
                       functionality from the NDBM library, or from GNU GDBM
                       (version 1.8.3 or 1.9.1) in its NDBM compatibility
                       mode. These libraries may already be installed on your
                       system. Get GDBM from ffttpp::////ffttpp..ggnnuu..oorrgg//ggnnuu//ggddbbmm[30].
                       See the ----eennaabbllee--nnddbbmm[31] and ----eennaabbllee--ggddbbmm[32]
                       configure flags.

                           NNootteess
                           +o   It may be necessary to create (or update) links
                               to the Berkeley DB installation directory to
                               avoid problems when building other packages.
                               For example, if you install it in
                               /usr/local/bdb-5.3.15:

                                   % ln -s /usr/local/bdb-5.3.15 /usr/local/BerkeleyDB.5.3
                                   % ln -s /usr/local/bdb-5.3.15 /usr/local/db53


                           +o   For the record, here is an example of how we
                               build Berkeley DB after unpacking it:

                                   % cd build_unix
                                   % ../dist/configure --prefix=/usr/local/bdb-5.2.36
                                   % make
                                   (All should go well.)
                                   % make install
                                   (All should go well here, too.)


                           +o   You cannot use both ----eennaabbllee--nnddbbmm _a_n_d
                               ----eennaabbllee--ggddbbmm, but you can use either one along
                               with ----eennaabbllee--bbddbb.

                           +o   GNU GDBM 1.9.1 may not interoperate correctly
                               with databases created by earlier versions of
                               GNU GDBM; consult its source code and
                               documentation for details.

                           +o   A deficiency in configuration processing is
                               that the locations of the GNU GDBM and NDBM
                               libraries cannot be specified; the standard
                               configuration search path is used. A future
                               version should provide ----wwiitthh--ggddbbmm and
                               ----wwiitthh--nnddbbmm flags.

                           +o   The NDBM-workalike, ssddbbmm[33], is not currently
                               supported. It may be added to a future release,
                               however, particularly if it is requested.

                    2. SQLite

                       The SSQQLLiittee[34] database, which can be used together
                       with the ddbbmm--ttyyppee ddaattaabbaasseess[23], is another option for
                       storing DDAACCSS configuration information. Version 3.7.9
                       is being used for testing. See the DDAACCSS configure
                       arguments: ----eennaabbllee--ssqqlliittee[35], ----ddiissaabbllee--ssqqlliittee[36],
                       and ----wwiitthh--ssqqlliittee[37].

                    3. Microsoft NTLM

                       If you want to be able to authenticate against NTLM
                       (see llooccaall__nnttllmm__aauutthheennttiiccaattee[38]), you must obtain
                       SSaammbbaa[39]. This release of DDAACCSS has been tested with
                       samba-3.6.1, and we strongly recommend that you use
                       that version. It is not known whether this release of
                       DDAACCSS will work with any other version of SSaammbbaa - we do
                       not officially support them.

                       DDAACCSS NTLM authentication has been tested against
                       Windows 2000 Server SP4.

                           NNoottee
                           DDAACCSS requires the SSaammbbaa source distribution to be
                           _b_u_i_l_t but it does not matter if SSaammbbaa is _i_n_s_t_a_l_l_e_d.
                           The DDAACCSS build procedure looks for include files
                           and libraries relative to the SSaammbbaa distribution's
                           root directory.
                       To build SSaammbbaa for DDAACCSS, from your SSaammbbaa distribution's
                       ./source3 directory do:

                           % ./configure --enable-static=yes --with-ads=no --with-ldap=no --disable-swat --disable-cups --disable-pie
                           % make

                       Then, when configuring DDAACCSS, specify the directory
                       where SSaammbbaa was unpacked, for example:

                           --with-samba=/local/src/samba-3.6.1

                       See the DDAACCSS configure arguments:
                       ----eennaabbllee--nnttllmm--aauutthh[40] and ----wwiitthh--ssaammbbaa[41].

                    4. libxml2 and xmlsec1

                       If you need InfoCard support (see
                       llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee[42]), lliibbxxmmll22[43] and
                       xxmmllsseecc11[18] are required. Build libxml2 and OOppeennSSSSLL
                       first, because xxmmllsseecc11[18] depends on both of them.
                       This release of DDAACCSS has been tested with libxml2-2.7.8
                       and xmlsec1-1.2.18, and we strongly recommend that you
                       use those versions. It is not known whether this
                       release of DDAACCSS will work with any other versions - we
                       do not officially support them.

                           NNootteess
                           +o   For the record, here is an example of how we
                               build xmlsec1:

                                   % ./configure --prefix=/usr/local/xmlsec1-1.2.18
                                       --with-libxml=/usr/local/libxml2-2.7.8
                                       --with-openssl=/usr/local/openssl-1.0.0f --with-gnu-ld
                                       --enable-static-linking  --disable-crypto-dl --disable-apps-crypto-dl

                               Except on Mac OS X:

                                   % ./configure --prefix=/usr/local/xmlsec1-1.2.18 \
                                         --with-libxml=/usr/local/libxml2-2.7.8 --with-gnu-ld --enable-static=yes \
                                         --enable-shared=yes --with-nss=/Applications/Firefox.app/Contents/MacOS \
                                         --with-nspr=/Applications/Firefox.app/Contents/MacOS \
                                         --with-openssl=/usr/local/openssl-1.0.0f


                           +o   Due to an apparent error in its build
                               procedure, we sometimes encountered the
                               following error message:

                                   *** Warning: Linking the shared library libxmlsec1-openssl.la against the
                                   *** static library /local/openssl-1.0.0f/lib/libcrypto.a is not portable!

                               After ensuring that libcrypto.so (or
                               libcrypto.dylib) had been installed when
                               building OOppeennSSSSLL, to correct the xmlsec1 build
                               problem we did "mmaakkee cclleeaann", re-ran ccoonnffiigguurree
                               as above, and edited src/openssl/Makefile under
                               the root of the xmlsec1 distribution directory
                               to change all occurrences of "libcrypto.a" to
                               "libcrypto.so". It was sometimes also necessary
                               to delete the -ldl flag on those same lines,
                               and in other Makefile files in the distribution
                               (and making sure the flag was not specified by
                               xmlsec1-config). After those changes, we ran
                               mmaakkee again. Additionally, it was sometimes
                               necessary to specify
                               CFLAGS="-I/usr/local/include -L/usr/local/lib".

                           +o   Another problem related to this library on a
                               CentOS platform resulted in an error message
                               similar to this:

                                   Cannot restore segment prot after reloc: Permission denied

                               The solution was to issue the command (adjust
                               the path as necessary):

                                   % chcon -t texrel_shlib_t /usr/local/xmlsec1-1.2.18/lib/libxmlsec1-openssl.so


                           +o   When including InfoCard support on Mac OS X, it
                               was necessary to tell the dynamic linker where
                               to find the xmlsec1 library (despite using the
                               --rrppaatthh flag during the build). To work around
                               this, do something like the following (or
                               equivalent):

                                   % setenv DYLD_LIBRARY_PATH /usr/local/xmlsec1-1.2.18/lib

                               Ensure that "ggmmaakkee tteesstt" does not fail.

                           +o   Due to an apparent bug in configure.in, on
                               FreeBSD ccoonnffiigguurree may incorrectly use the --llddll
                               flag in generated Makefiles. Either edit all
                               Makefiles to remove all occurrences of the --llddll
                               flag, or edit configure.in, add a
                               "*-*-freebsd*" case like the others in the
                               "OpenSSL" section, run aauuttooccoonnff to regenerate
                               ccoonnffiigguurree, and then "mmaakkee cclleeaann" and re-run
                               ccoonnffiigguurree.

                           +o   Your experience may differ, but we found
                               xmlsec1 to not cooperate when we wanted to work
                               with multiple installations of libxml2 -
                               apparently if a libxml2 directory or link has
                               been installed, its build procedure seems to
                               use that version, regardless of what is
                               specified on the command line, requiring manual
                               editing of its Makefiles. Check that the
                               correct instance of xxmmll22--ccoonnffiigg is being used.
                           The DDAACCSS build procedure uses xxmmllsseecc11--ccoonnffiigg, a
                           program that comes with xmlsec1. If InfoCard
                           support is enabled, the build procedure will look
                           in some standard places for this command. You can
                           specify its location with the
                           ----wwiitthh--xxmmllsseecc11--ccoonnffiigg[44] flag.

                           See the DDAACCSS configure arguments:
                           ----eennaabbllee--iinnffooccaarrdd--aauutthh[45] and
                           ----wwiitthh--xxmmllsseecc11--ccoonnffiigg[44]

                        5. LDAP or Microsoft Active Directory

                           If you want to be able to authenticate through LDAP
                           (see llooccaall__llddaapp__aauutthheennttiiccaattee[46]), including
                           Microsoft's ADS, you must obtain OOppeennLLDDAAPP[47]. This
                           release of DDAACCSS has been tested only with
                           openldap-2.4.28 and we strongly recommend that you
                           use that version.

                           It is not known whether this release of DDAACCSS will
                           work with any other version of OOppeennLLDDAAPP - we do not
                           support them.  DDAACCSS may work properly with OOppeennLLDDAAPP
                           versions at least as old as 2.2.24, if you really
                           must use one of them.

                           DDAACCSS has been tested against Windows 2000 Server
                           SP4.

                           It is not necessary for you to _i_n_s_t_a_l_l OOppeennLLDDAAPP,
                           you only need to _b_u_i_l_d it - so you do not need to
                           be concerned about hassles associated with
                           upgrading or any other versions that might already
                           be installed on your system. The DDAACCSS build
                           procedure looks for include files and libraries to
                           the root of the OOppeennLLDDAAPP distribution directory.

                           To build OOppeennLLDDAAPP for DDAACCSS, from the root of your
                           OOppeennLLDDAAPP distribution do:

                               % ./configure --disable-slapd --enable-static
                               % make

                           If so instructed, do a "mmaakkee ddeeppeenndd" before the
                           mmaakkee.

                           See the DDAACCSS configure arguments:
                           ----eennaabbllee--llddaapp--aauutthh[48] and ----wwiitthh--llddaapp[49]

                        6. Readline

                           The history and editing functionality provided by
                           the GGNNUU RReeaaddlliinnee LLiibbrraarryy[50] can be nice to have
                           when using ddaaccsseexxpprr((11))[51] interactively. We have
                           successfully used versions 6.0, 6.1, and 6.2. Note
                           that you may need to compile Readline with the
                           --ffPPIICC flag ("mmaakkee CCFFLLAAGGSS==--ffPPIICC").

                           It is not necessary for you to _i_n_s_t_a_l_l readline,
                           you only need to _b_u_i_l_d it - so you do not need to
                           be concerned about hassles associated with
                           upgrading or any other versions that might already
                           be installed on your system.

                               NNootteess
                               +o   When building on Mac OS X, it was necessary
                                   to fix a bug by editing shlib/Makefile and
                                   making this change:

                                       #SHOBJ_LDFLAGS = -dynamic
                                       SHOBJ_LDFLAGS = -dynamiclib

                               See the DDAACCSS configure arguments:
                               ----wwiitthh--rreeaaddlliinnee[52]

                        5. Configure and build DDAACCSS libraries, services,
                           commands, and utilities

                           See BBuuiilldd OOppttiioonnss[53] for build alternatives and
                           options to ccoonnffiigguurree.

                               % cd src
                               % ./configure
                               % gmake

                           To confirm that DDAACCSS has been built with the
                           third-party packages that you intended, from the
                           run:

                               % ./version -v

                           You should ensure that the ssssllcclliieenntt utility is
                           working correctly. From the src directory, you can
                           test it using the following command:

                               % perl -e 'printf "GET / HTTP/1.0\n\n";' | ./sslclient dacs.dss.ca:443

                           which should print the contents of
                           hhttttppss::////ddaaccss..ddssss..ccaa to the standard output. You
                           should repeat this test substituting the name of
                           your server and port.

                               TTiipp
                               After building DDAACCSS, it is strongly recommended
                               that you run the self-tests (expression
                               evaluation, crypto code, string handling, and
                               so on) from the src directory:

                                   % gmake test

                               If any error occurs during testing, testing
                               will stop immediately and a message will be
                               displayed. In this event, first check that you
                               are using the recommended software packages and
                               that your build flags are correct. Most often,
                               problems are the result of mixing header files
                               or library files from different versions of a
                               third-party package (e.g., OOppeennSSSSLL) or
                               incorrect file permissions. If you cannot find
                               anything wrong with your configuration, please
                               submit a bug report that includes the self test
                               output and describes your platform (you can
                               include the output of "./version -v").

                        6. If all looks good, install DDAACCSS

                               % gmake install


                               NNootteess
                               +o   If ggmmaakkee complains about not being able to
                                   find xxssllttpprroocc, docbook.xsl, or something
                                   that might be related to installing the
                                   documentation, try:

                                       % (cd ../man; gmake touch)
                                       % gmake install


                               +o   This will install the rules for the
                                   standard DDAACCSS web services and run
                                   ddaaccssaaccll((11))[54] to create and install an
                                   index for them.

                               +o   You can specify DDEESSTTDDIIRR[55] to ggmmaakkee when
                                   installing or uninstalling:

                                       % gmake DESTDIR=/tmp/mydacs install

                               The installation process may prompt you for the
                               owner name and group name to use for files and
                               directories; it will guess at reasonable
                               defaults for your platform. The appropriate
                               responses will depend on local conventions, but
                               to start with you might set the owner to your
                               login name or root, and the group name to the
                               same name that is used by AAppaacchhee (specified by
                               the GGrroouupp[56] directive in httpd.conf).

                                   TTiipp
                                   While running "ggmmaakkee iinnssttaallll", important
                                   instructions regarding manual installation
                                   steps may be displayed. A copy is written
                                   to .build_notes, truncating any previous
                                   contents.

                            7. As part of the installation procedure, the DDAACCSS
                               manual pages are copied into the DDAACCSS man
                               directory (default: /usr/local/dacs/man). If
                               you adjust your MMAANNPPAATTHH environment variable to
                               include that directory, try:

                                   % man dacs

                               While it is occasionally handy to view the
                               manual pages using the mmaann command, the HTML
                               documentation is far superior.

                            8. Build a DDAACCSS-enabled hhttttppdd

                               Please consult apache/README in the DDAACCSS
                               distribution for details and, from the apache
                               directory, do:

                                   % gmake help


                                   SSeeccuurriittyy
                                   You can build the module with a full
                                   version tag ("ggmmaakkee ttaagg"), with a simple
                                   tag ("ggmmaakkee ssmmaallllttaagg"), or without a tag
                                   ("ggmmaakkee nnoottaagg" or "ggmmaakkee mmoodduullee"). We
                                   recommend that you compile mmoodd__aauutthh__ddaaccss
                                   with a tag so that AAppaacchhee''ss
                                   SERVER_SIGNATURE includes a DDAACCSS version
                                   identifier stamp; this makes it easy to
                                   tell which version of DDAACCSS the server is
                                   running and helps to detect mismatches. For
                                   servers that are subject to attack,
                                   however, identifying exactly which modules
                                   are in your AAppaacchhee server is considered a
                                   security weakness - you may reasonably
                                   choose not to include the stamp.
                               If you want mmoodd__aauutthh__ddaaccss to be a dynamic
                               module, which is recommended, do:

                                   % cd apache
                                   % gmake tag
                                   % gmake install

                               Check that your httpd.conf has the appropriate
                               LoadModule directive.

                               If you want mmoodd__aauutthh__ddaaccss to be a static
                               module:

                                1. Copy apache/mod_auth_dacs.c to AAppaacchhee''ss
                                   modules/aaa directory

                                2. Re-run AAppaacchhee's configure, adding
                                   mmoodd__aauutthh__ddaaccss (----wwiitthh--mmoodduullee==aaaaaa::aauutthh__ddaaccss)

                                3. Reinstall AAppaacchhee:

                                       % make install


                                4. Verify that mmoodd__aauutthh__ddaaccss appears in the
                                   list of AAppaacchhee modules:

                                       % httpd -l


                                       TTiipp
                                       Make sure that mmoodd__ssssll is either
                                       statically compiled with hhttttppdd or
                                       dynamically loaded _b_e_f_o_r_e mmoodd__aauutthh__ddaaccss
                                       (using the LoadModule directive in
                                       httpd.conf). If neither is the case,
                                       you'll probably see a message like the
                                       following when you try to start AAppaacchhee:

                                           mod_auth_dacs.so: undefined symbol: ssl_hook_Fixup
                                   After you've installed mmoodd__aauutthh__ddaaccss,
                                   restart hhttttppdd.

                                   If you built the module with a tag, verify
                                   that the DDAACCSS version identifier appears in
                                   SERVER_SIGNATURE. You can do this by
                                   hitting AAppaacchhee''ss pprriinntteennvv CGI program from
                                   your browser or using a command like:

                                       % http "http://_m_y_s_e_r_v_e_r:_m_y_s_e_r_v_e_r_p_o_r_t/cgi-bin/printenv"

                                   (first making sure that AAppaacchhee''ss pprriinntteennvv
                                   CGI is executable) and examining the
                                   SERVER_SIGNATURE environment variable, or
                                   by running:

                                       % telnet _m_y_s_e_r_v_e_r _m_y_s_e_r_v_e_r_p_o_r_t

                                   and typing:

                                       OPTIONS * HTTP/1.0

                                   followed by a blank line and examining the
                                   Server response header.

                                       NNoottee
                                       +o   The URLs that follow will use http
                                           and omit _m_y_s_e_r_v_e_r_p_o_r_t. Substitute
                                           https and/or include _m_y_s_e_r_v_e_r_p_o_r_t
                                           as necessary for your
                                           configuration.

                                       +o   If you install a new version of
                                           DDAACCSS, please make sure that you use
                                           the mmoodd__aauutthh__ddaaccss module that comes
                                           with it. Follow the instructions
                                           above.

                                9. An assortment of DDAACCSS files, including HTML
                                   documentation and CSS files, are copied
                                   into the DDAACCSS www directory (default:
                                   /usr/local/dacs/www).

                                   While you can view the documentation simply
                                   by pointing your web browser at the DDAACCSS
                                   www directory, it is recommended that you
                                   make it available through AAppaacchhee using its
                                   AAlliiaass[57] directive because the default
                                   site configuration (site.conf-std) expects
                                   handlers and DTDs to be available using
                                   certain URLs.

                                   Add lines like the following to your
                                   httpd.conf:

                                       Alias /dacs      "/usr/local/dacs/www/"
                                       Alias /css       "/usr/local/dacs/www/css/"
                                       Alias /dtd-xsd   "/usr/local/dacs/www/dtd-xsd/"
                                       Alias /examples  "/usr/local/dacs/www/examples/"
                                       Alias /handlers  "/usr/local/dacs/www/handlers/"
                                       Alias /infocards "/usr/local/dacs/www/infocards/"
                                       Alias /man       "/usr/local/dacs/www/man/"
                                       Alias /misc      "/usr/local/dacs/www/misc/"
                                       Alias /mod       "/usr/local/dacs/www/mod/"

                                   To see the DDAACCSS DTD files from your
                                   browser, you can also add:

                                       AddType text/plain      .dtd

                                   These .dtd files are only used to document
                                   XML structures and messages used by DDAACCSS
                                   and are cited in the documentation.

                                   You should also uncomment these two
                                   directives in your site.conf file:

                                       XSD_BASE_URL "/dacs/dtd-xsd"
                                       DTD_BASE_URL "/dacs/dtd-xsd"


                                       TTiipp
                                       After restarting hhttttppdd, you can view
                                       the documentation using a URL that
                                       looks like http://_m_y_s_e_r_v_e_r/dacs/man or
                                       simply http://_m_y_s_e_r_v_e_r/man.

                               10. Access to all DDAACCSS web services (everything
                                   installed in the .../cgi-bin/dacs
                                   directory) _m_u_s_t be controlled by DDAACCSS; that
                                   is, they must be "DDAACCSS-wrapped". Assuming
                                   you are following the defaults for
                                   installing DDAACCSS, these are the only files
                                   that are required to be DDAACCSS-wrapped.

                                   DDAACCSS-wrapping a resource or set of related
                                   resources involves:

                                   +o   Configuring AAppaacchhee so that it uses DDAACCSS
                                       to manage access to the contents of a
                                       directory or portion of URL space and

                                   +o   Configuring one or more DDAACCSS access
                                       control rules for the jurisdiction
                                       responsible for the resources (this is
                                       done for the DDAACCSS web services by the
                                       default ACLs).
                                       Configuring AAppaacchhee involves, at
                                       minimum, adding directives like the
                                       following to the appropriate
                                       VirtualHost section of httpd.conf:

                                           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-t -v"
                                           SetDACSAuthMethod dacs-acs external
                                           SetDACSAuthConf dacs-acs "/usr/local/dacs/dacs.conf"
                                           <Location /cgi-bin/dacs>
                                              AuthType DACS
                                              AuthDACS dacs-acs
                                              Require valid-user
                                              Options ExecCGI
                                           </Location>


                                           TTiipp
                                           Remember to restart AAppaacchhee after
                                           making changes to httpd.conf.
                                       Some administrators may choose to make
                                       _a_l_l content or _a_l_l CGIs DDAACCSS-wrapped.
                                       That is probably a more secure
                                       approach, although of course it can be
                                       somewhat less efficient than segmenting
                                       the server's URL space into "secure"
                                       and "insecure" areas. Content that is
                                       not DDAACCSS-wrapped is totally oblivious
                                       to DDAACCSS and incurs no overhead due to
                                       DDAACCSS. Also, this approach may
                                       necessitate making "holes" in the URL
                                       space for non-access controlled
                                       resources, which must be done with
                                       care.

                                           TTiipp
                                           If you decide to DDAACCSS-wrap
                                           everything, you will likely want to
                                           add rules to grant access to
                                           various public resources, such as
                                           CSS files, robots.txt, favicon.ico,
                                           and various public DDAACCSS resources,
                                           such as its man, dtd-xsd, etc.
                                           directories (see the instructions
                                           for the Alias directive above). The
                                           default ACL acl-stddocs.0 does this
                                           for some resources, but you may
                                           need to extend the list to grant
                                           access to additional public
                                           resources.

   IInniittiiaall CCoonnffiigguurraattiioonn
           TTiipp
           At this point, reviewing ddaaccss..qquuiicckk((77))[3] is strongly recommended.
           It provides a detailed example of what needs to be done to make
           your DDAACCSS operational and how to do some basic testing.

           TTiipp
           The interactive ddaaccssiinniitt utility can perform the steps described
           below quickly. You will find ddaaccssiinniitt in the distribution's src
           directory. It can be run anytime after DDAACCSS has been built and
           installed. It produces a directory structure for the federation,
           copies the distribution's site configuration file, creates a
           minimal dacs.conf for the federation and one jurisdiction, makes
           federation and jurisdiction encryption keys, and generates metadata
           for the jurisdiction. The resulting configuration can be used
           immediately by DDAACCSS commands and by DDAACCSS web services after AAppaacchhee
           has been configured for DDAACCSS.

           Passing the --dd flag to ddaaccssiinniitt causes it to append a string to
           certain paths and filenames so that, for debugging or test
           purposes, it is unlikely to overwrite any "real" configuration
           files. Passing it the --nn flag causes it to display what it would do
           without performing any of the actions.

       Having installed DDAACCSS, the next major step is to do some initial
       configuration of your federation and jurisdiction(s). At each
       jurisdiction in your federation you will need to do the following:

        1. Install the default site configuration file. The distribution comes
           with a default site configuration file found in the distribution's
           conf/site.conf-std file. The installation procedure copies this
           file into the DDAACCSS federations directory. After making a backup
           copy of any federations/site.conf file that is already there, copy
           federations/site.conf-std to federations/site.conf, applying any
           customizations you require (customizations are usually done in
           dacs.conf though, so that you can simply copy on top of the
           previous site.conf). Note that conf/site.conf-std may well change
           in a new release and you should use the latest version.

        2. As part of the installation procedure, a default set of access
           control rules is copied into the DDAACCSS acls directory (default:
           /usr/local/dacs/acls). The default site.conf file (site.conf-std)
           configures DDAACCSS to look in that directory for the default rules.
           These rules control access to DDAACCSS web services and are sufficient
           for proper operation.

               TTiipp
               If your installed DDAACCSS web services have a filename suffix
               (e.g., .cgi, you should probably build DDAACCSS with an appropriate
               ----wwiitthh--ccggii--ssuuffffiixx flag or customize the rules manually. If it
               is necessary to change the default rules, consider overriding
               them at the jurisdiction level instead of editing a default ACL
               file - this will make it easier for you to upgrade because you
               will not have to carry these changes forward to future releases
               of DDAACCSS.

               SSeeccuurriittyy
               Access to some administrative and experimental DDAACCSS web
               services is completely disabled or restricted by default;
               _c_h_a_n_g_e _t_h_e_s_e _w_i_t_h _c_a_r_e _a_n_d _a_t _y_o_u_r _o_w_n _r_i_s_k_, _p_a_r_t_i_c_u_l_a_r_l_y _i_f
               _y_o_u_r _w_e_b _s_e_r_v_e_r _i_s _r_e_a_c_h_a_b_l_e _f_r_o_m _t_h_e _I_n_t_e_r_n_e_t.

        3. Configure your dacs.conf file at each jurisdiction. At the very
           least, you must provide FFEEDDEERRAATTIIOONN__DDOOMMAAIINN[58], FFEEDDEERRAATTIIOONN__NNAAMMEE[59],
           and JJUURRIISSDDIICCTTIIOONN__NNAAMMEE[60] directives; all other required directives
           will come from the site.conf file installed in an earlier step if
           you do not specify them.

        4. Use ddaaccsskkeeyy((11))[61] to make encryption keys for the federation (if
           you are creating a new federation) or obtain a copy of the
           federation's encryption keys for each new jurisdiction (if you are
           joining an existing federation). Each jurisdiction in a federation
           must have a copy of the same federation keys.

        5. Use ddaaccsskkeeyy((11))[61] to make encryption keys for each new
           jurisdiction (each jurisdiction will have different keys).

        6. Create a group definition that describes your jurisdictions - see
           ddaaccss..ggrroouuppss((55))[62] - and install an identical copy at each
           jurisdiction.

        7. Check ownership and permissions on DDAACCSS executables and data files.

               SSeeccuurriittyy
               All access to DDAACCSS configuration files (dacs.conf, site.conf)
               and keys must be limited to the DDAACCSS administrator and the DDAACCSS
               CGI programs called by AAppaacchhee. The installation process tries
               to set this reasonably, but you should re-check now and after
               making changes because it is vital to maintain a secure system
               (e.g., ls -lR /usr/local/dacs).


   IInniittiiaall TTeessttiinngg
       Having configured AAppaacchhee and DDAACCSS, you should try some basic DDAACCSS web
       services to make sure that they are working properly before you go on
       to make customizations.

       For example, invoke ddaaccss__vveerrssiioonn((88))[11] from your browser to check that
       it is properly DDAACCSS-wrapped (adjust the URL for your environment):

           % http "http://_m_y_s_e_r_v_e_r/cgi-bin/dacs/dacs_version"

       Review the DDAACCSS log files (default: /usr/local/dacs/logs/*) to see what
       happened. You can also try ddaaccssvveerrssiioonn((11))[63] from the command line.

       You should verify that ddaaccss__lliisstt__jjuurriissddiiccttiioonnss((88))[8] works properly.

       The next step is to configure an authentication method - see
       ddaaccss__aauutthheennttiiccaattee((88))[5] and try to authenticate. Once that appears to
       be working, you can try ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[6],
       ddaaccss__pprreennvv((88))[7], ddaaccss__ccoonnff((88))[9], and ddaaccss__ssiiggnnoouutt((88))[10].

   BBuuiilldd OOppttiioonnss
       Running ccoonnffiigguurree generates config.nice (over-writing any previous
       contents), which can be executed at some later time if you want to
       re-run ccoonnffiigguurree with the same arguments.

           TTiipp
           After you are happy with your configuration, consider squirrelling
           away a copy of config.nice in case you want to reconfigure DDAACCSS or
           for use with later releases of DDAACCSS.

       It is possible to "bundle" several of the DDAACCSS utility programs
       together into a single binary called ddaaccss. This is similar to what
       OOppeennSSSSLL does with its ooppeennssssll command. Instead of running:

           % dacsacl ...

       you would run:

           % dacs dacsacl ...

       Running ddaaccss without arguments displays the list of built-in utilities.
       Some utilities have multiple names that are equivalent; these appear in
       a comma-separated list. To build this combined command, add the flag
       bundle=yes to command lines when building and installing:

           % gmake bundle=yes
           % gmake bundle=yes install

       The commands that are bundled into the ddaaccss command won't be built as
       separate programs. To build and install both bundled and unbundled
       commands:

           % gmake bundle=both
           % gmake bundle=both install

       Command: gmake or "ggmmaakkee bbuuiilldd"
           This will build libraries, services, and utilities in the source
           directory. By default, the build process will create shared
           libraries and binaries if they are supported on your platform.

               TTiipp
               If you encounter problems while building DDAACCSS with shared
               libraries, use ----ddiissaabblleedd--sshhaarreedd and ----eennaabbllee--ssttaattiicc with
               ccoonnffiigguurree and try building it again.

       Command: "ggmmaakkee iinnssttaallll"
           This will install all DDAACCSS components. We recommend that everything
           other than CGI binaries be put under /usr/local/dacs, which is the
           default. The CGI binaries are by default installed in
           .../_y_o_u_r_-_a_p_a_c_h_e_-_d_i_r/cgi-bin/dacs. By default, DDAACCSS utilities will
           be installed in /usr/local/dacs/bin, which you may want to put on
           your PPAATTHH for convenience.

       Command: "ggmmaakkee cclleeaann"
           Removes binaries, object files, and other junk in the build
           directory

       Command: "ggmmaakkee ddiissttcclleeaann"
           Does a "ggmmaakkee cclleeaann" and cleans up so that ccoonnffiigguurree can be
           re-done.

       Command: "ggmmaakkee eexxttrraacclleeaann"
           Does a "ggmmaakkee ddiissttcclleeaann" and removes configure. After this, do:

               % autoconf -I../include

           and then run ccoonnffiigguurree.

       Command: "ggmmaakkee uunniinnssttaallll"
           Removes installed binaries, include files, and libraries

       Other useful build commands (these should be self-explanatory):

           % gmake build-services
           % gmake build-progs
           % gmake build-static
           % gmake build-shared
           % gmake build-static-services
           % gmake build-shared-services
           % gmake build-static-progs
           % gmake build-shared-progs
           % gmake build-shared-lib
           % gmake install-libs
           % gmake install-shared-lib
           % gmake install-static-lib
           % gmake install-progs
           % gmake install-services

       CCoonnffiigguurree OOppttiioonnss
           To verify that this documentation is up-to-date, please run:

               % configure --help

           This will also tell you which features are enabled (or disabled) by
           default.  Standard build and install options.PP

           ----pprreeffiixx==_P_R_E_F_I_X
               The root for the installation hierarchy [/usr/local/dacs],
               which is referred to as the symbol and variable DDAACCSS__HHOOMMEE[64]

           ----eexxeecc--pprreeffiixx==_E_P_R_E_F_I_X
               The root for the architecture-dependent hierarchy [_P_R_E_F_I_X]

           ----bbiinnddiirr==_D_I_R
               Where DDAACCSS utilities are installed [_E_P_R_E_F_I_X/bin]

           ----lliibbddiirr==_D_I_R
               Where DDAACCSS libraries are installed [_E_P_R_E_F_I_X/lib]

           ----iinncclluuddeeddiirr==_D_I_R
               Where DDAACCSS include files are installed [_E_P_R_E_F_I_X/include]

           ----mmaannddiirr==_D_I_R
               Where DDAACCSS manual pages are installed [_E_P_R_E_F_I_X/man]

           ----eennaabbllee--sshhaarreedd
               Generate shared libraries

           ----eennaabbllee--ssttaattiicc
               Generate static libraries

           ----ddiissaabbllee--pprreeffiixx--cchheecckk
               Disable prefix path check. The prefix path check does some
               sanity tests on _P_R_E_F_I_X.
           Feature selection options.PP

           ----eennaabbllee--aacccceessss--ttookkeennss
               Compile with the authorization caching feature

           ----eennaabbllee--aallll--aauutthh
               Enable all authentication methods; you can use this flag and
               then individually disable methods (e.g., ----eennaabbllee--aallll--aauutthh
               ----ddiissaabbllee--aappaacchhee--aauutthh would enable all methods except AAppaacchhee
               password authentication

           ----eennaabbllee--aappaacchhee--aauutthh
               Enable AAppaacchhee password authentication directly through DDAACCSS

           ----eennaabbllee--bbddbb
               Enable Berkeley DB support (default is yes). If you don't want
               it, use ----ddiissaabbllee--bbddbb

           ----eennaabbllee--ccaass--aauutthh
               Enable CAS authentication

           ----eennaabbllee--cceerrtt--aauutthh
               Enable X.509 client certificate authentication

           ----eennaabbllee--ddaaccss--ccoonnff
               Specify default DDAACCSS config file

           ----eennaabbllee--ddaaccss--lloogg
               Specify initial DDAACCSS log file

           ----eennaabbllee--ddeebbuugg
               Compile with debugging

           ----eennaabbllee--ddeevveellooppeerr
               Compile with development flags

           ----eennaabbllee--ffttss
               Use included ffttss((33))[65] library

           ----eennaabbllee--ggddbbmm
               Enable ndbm support using gdbm's compatibility API
               (ggddbbmm((33))[66])

           ----eennaabbllee--ggrriidd--aauutthh
               Enable one-time password grid authentication

           ----eennaabbllee--iinnffooccaarrdd--aauutthh
               Enable InfoCard authentication and support

           ----eennaabbllee--jjaavvaa
               Enable Java support

           ----eennaabbllee--llddaapp--aauutthh
               Enable LDAP authentication and roles

           ----eennaabbllee--llooccaall--rroolleess
               Enable private DDAACCSS roles module (enabled by default)

           ----eennaabbllee--nnaattiivvee--aauutthh
               Enable authentication via AAppaacchhee modules

           ----eennaabbllee--nnddbbmm
               Enable native Unix ndbm API support

           ----eennaabbllee--nnttllmm--aauutthh
               Enable NTLM authentication

           ----eennaabbllee--ppaamm--aauutthh
               Enable PAM authentication

                   IImmppoorrttaanntt
                   The PAM module should be considered experimental. Test it
                   carefully before production use.

           ----eennaabbllee--ppaasssswwdd--aauutthh
               Enable DACS password-protected account authentication

           ----eennaabbllee--ssiimmppllee--aauutthh
               Enable simple DACS account authentication

           ----eennaabbllee--ssqqlliittee
               Enable SQLite support (default is no). If you don't want it,
               use ----ddiissaabbllee--ssqqlliittee

           ----eennaabbllee--ttookkeenn--aauutthh
               Enable one-time password token authentication

           ----eennaabbllee--uunniixx--rroolleess
               Enable Unix groups roles module (enabled by default on Unix
               platforms)

           ----eennaabbllee--uusseerr--iinnffoo
               Compile with the user information reporting feature
           Third-party support options.PP

           ----wwiitthh--aappaacchhee==_D_I_R
               Root AAppaacchhee install directory; if _D_I_R is "omit", however, a
               basic subset of DDAACCSS will be installed (aallssoo sseeee aabboovvee[67])
               (example: if AAppaacchhee files have been installed in
               /usr/local/apache2.2/include, /usr/local/apache2.2/conf, etc.,
               use ----wwiitthh--aappaacchhee=/usr/local/apache2.2)

           ----wwiitthh--aappaacchhee--aapprr==_D_I_R
               Root AAppaacchhee APR install directory; required only when AAppaacchhee
               2.2 is used (example:
               ----wwiitthh--aappaacchhee--aapprr=/usr/local/apache2.2/apr-httpd)

           ----wwiitthh--aappaacchhee--aapprr--ccoonnffiigg==_P_A_T_H
               AAppaacchhee APR configuration program; required only when AAppaacchhee 2.2
               is used and the program is not on the search path (example:
               ----wwiitthh--aappaacchhee--aapprr--ccoonnffiigg=/usr/local/apache2.2/apr-httpd/bin/apr-1-config)

           ----wwiitthh--aappaacchhee--aapprr--ccpppp--ddeeffss==_F_L_A_G_S
               Preprocessor flags required when compiling files that include
               AAppaacchhee APR code; may be required with some "non-standard" cases
               when AAppaacchhee 2.2 is used and "aapprr--11--ccoonnffiigg ----ccppppffllaaggss" is
               unavailable or does not report the correct flags (example:
               ----wwiitthh--aappaacchhee--aapprr--ccpppp--ddeeffss=-D_LARGEFILE64_SOURCE)

                   NNoottee
                   It has been reported that on some GNU/Linux platforms, such
                   as Ubuntu, it is necessary to define these symbols when
                   building DDAACCSS code that includes APR header files (such as
                   ddaaccssvveerrssiioonn):

                       #define LINUX 2
                       #define _REENTRANT
                       #define _GNU_SOURCE
                       #define _LARGEFILE64_SOURCE

           ----wwiitthh--aappaacchhee--aapprr--iinncclluuddeess==_D_I_R
               AAppaacchhee APR include files directory; required with some
               "non-standard" cases when AAppaacchhee 2.2 is used and aapprr--11--ccoonnffiigg
               is unavailable or does not report the correct directory
               (example: ----wwiitthh--aappaacchhee--aapprr--iinncclluuddeess=/usr/bin/include/apr-1.0)

           ----wwiitthh--aappxxss==_P_A_T_H
               By default, the build procedure expects the AAppaacchhee aappxxss utility
               to be bin/apxs, relative to AAppaacchhee''ss installation directory. On
               systems where this is incorrect, you must specifically
               configure the path for aappxxss. (example:
               ----wwiitthh--aappxxss=/usr/sbin/apxs2)

           ----wwiitthh--bbddbb==_D_I_R
               Location of the root of the installed Berkeley DB libraries,
               include files, etc.; for example
               ----wwiitthh--bbddbb=/usr/local/BerkeleyDB.5.3. This implies
               ----eennaabbllee--bbddbb.

           ----wwiitthh--ccggii--bbiinn==_D_I_R
               Location of AAppaacchhee CGI files for DDAACCSS web services. This will
               resolve to _D_I_R/cgi-bin/dacs if it exists, or _D_I_R/dacs if that
               exists, or _D_I_R if its last component is "dacs".

           ----wwiitthh--ccggii--ssuuffffiixx==_S_U_F_F_I_X
               When installing CGI executables, add _S_U_F_F_I_X as the file
               extension. A typical value for _S_U_F_F_I_X is ".cgi". The default
               access control rules for DDAACCSS web services (via the VFS item
               type dacs_acls) respect this suffix. On Windows platforms,
               where ".exe" is the standard extension for programs, _S_U_F_F_I_X is
               set to that by default. Using a _S_U_F_F_I_X of "no" sets the
               extension to the null string.

           ----wwiitthh--ddaaccss--ccoonnff==_P_A_T_H
               Specify default DDAACCSS config file (default:
               _P_R_E_F_I_X/federations/dacs.conf)

           ----wwiitthh--ddaaccss--lloogg==_P_A_T_H
               Specify initial DDAACCSS log file (default: _P_R_E_F_I_X/logs/error_log)

           ----wwiitthh--eexxppaatt==_D_I_R
               Root directory of installed EExxppaatt libraries and include files.
               If Expat files have been installed in /usr/local/expat/include,
               /usr/local/expat/lib, etc., use ----wwiitthh--eexxppaatt=/usr/local/expat.

           ----wwiitthh--ffeeddeerraattiioonnss--rroooott==_D_I_R
               Location of DDAACCSS federations root directory (default:
               _P_R_E_F_I_X/federations)

           ----wwiitthh--hhttddooccss==_D_I_R
               Location of AAppaacchhee DDAACCSS files if not the htdocs subdirectory of
               the AAppaacchhee install directory.

           ----wwiitthh--iiccoonnvv==_D_I_R
               Path to parent of iconv installation. This flag may be required
               if you are enabling SSaammbbaa support.

           ----wwiitthh--jjddkk--bbiinn
               If Java support is enabled, this identifies the directory
               containing the jjaavvaa, jjaavvaacc, jjaavvaahh, and jjaarr commands. If this
               flag is absent, ccoonnffiigguurree will look for those programs using
               the current PPAATTHH variable. (Example:
               ----wwiitthh--jjddkk--bbiinn==//uussrr//llooccaall//jjaavvaa//bbiinn)

           ----wwiitthh--jjddkk--iinncclluuddeess
               If Java support is enabled, this is a list of one or more GGCCCC
               include flags for JDK include directories (Example:
               ----wwiitthh--jjddkk--iinncclluuddeess==--II//uussrr//llooccaall//jjddkk//iinncclluuddee
               --II//uussrr//llooccaall//jjddkk//iinncclluuddee//ffrreeeebbssdd)

           ----wwiitthh--llddaapp==_D_I_R
               Location of OOppeennLLDDAAPP _s_o_u_r_c_e files. This is the root directory
               for the OpenLDAP source distribution (Example:
               /local/src/openldap-2.2.28). This implies ----eennaabbllee--llddaapp--aauutthh.

           ----wwiitthh--mmaaiilleerr--pprroogg==_P_A_T_H
               Location of a mailer program to use instead of sseennddmmaaiill. This
               is only needed if email support is required. If
               ----wwiitthh--mmaaiilleerr--aarrggss is also specified, it will be used as the
               command line arguments. See ddaaccsseemmaaiill((11))[68] for a description
               of how the mailer is expected to behave.

           ----wwiitthh--mmaaiilleerr--aarrggss==_S_T_R_I_N_G
               Command line arguments to use with the selected mailer program.
               This is only required if email support is required. See
               ddaaccsseemmaaiill((11))[68] for a description of how the mailer is
               expected to behave.

           ----wwiitthh--rreeaaddlliinnee==_L_I_B
               Use GGNNUU RReeaaddlliinnee[50] when available. If _L_I_B is given, it is the
               link flag to use or the pathname for the library (other flags
               may also be specified). (Example:
               ----wwiitthh--rreeaaddlliinnee==--WWll,,--rrppaatthh,,//llooccaall//ssrrcc//rreeaaddlliinnee--66..22//lliibb
               --LL//llooccaall//ssrrcc//rreeaaddlliinnee--66..22//lliibb
               --II//llooccaall//ssrrcc//rreeaaddlliinnee--66..22//iinncclluuddee)

           ----wwiitthh--ssaammbbaa==_D_I_R
               Location of Samba _s_o_u_r_c_e files. This is the root directory for
               the Samba source distribution (Example:
               /local/src/samba-3.6.1). This implies ----eennaabbllee--nnttllmm--aauutthh.

           ----wwiitthh--sseennddmmaaiill==_P_A_T_H
               Location of sseennddmmaaiill((88))[69]. This is only needed if email
               support is required and the location of the sseennddmmaaiill command
               found at configuration time must be overridden. If
               ----wwiitthh--mmaaiilleerr--aarrggss is also specified, it will be used instead
               of the default sseennddmmaaiill command line arguments. See
               ddaaccsseemmaaiill((11))[68] for additional details.

           ----wwiitthh--ssqqlliittee==_D_I_R
               Location of the root of the installed SQLite libraries, include
               files, etc.; for example ----wwiitthh--ssqqlliittee=/usr/local/sqlite-3.7.9.
               This implies ----eennaabbllee--ssqqlliittee.

           ----wwiitthh--ssssll==_D_I_R
               Location of the root of the installed OOppeennSSSSLL libraries and
               include files. If OOppeennSSSSLL files have been installed in
               /usr/local/openssl/include, /usr/local/openssl/lib, etc., use
               ----wwiitthh--eexxppaatt=/usr/local/openssl.

           ----wwiitthh--xxmmllsseecc11--ccoonnffiigg==_P_A_T_H
               If the build procedure cannot find xxmmllsseecc11--ccoonnffiigg, or if it
               finds the wrong one, you can specify its location as _P_A_T_H. This
               may only be required if InfoCard authentication has been
               enabled.

           To specify additional flags for compiling or linking DDAACCSS, set
           _C_F_L_A_G_S or _L_D_F_L_A_G_S, respectively.

           To specify additional flags for compiling or linking mmoodd__aauutthh__ddaaccss,
           set _A_P_A_C_H_E___C_F_L_A_G_S or _A_P_A_C_H_E___L_D_F_L_A_G_S, respectively. For example,
           this command will cause mmoodd__aauutthh__ddaaccss to be built with the --mm6644
           flag and DDAACCSS to be built with both the --mm6644 flag and the --OO33 flag:

               % ./configure "APACHE_CFLAGS=-m64" "CFLAGS=-O3 -m64" ...


SSEEEE AALLSSOO
       ddaaccss((11))[70], ddaaccss..rreeaaddmmee((77))[4], ddaaccss..qquuiicckk((77))[3]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[71])

CCOOPPYYIINNGG
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       LLIICCEENNSSEE[72] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. gmake
           http://directory.fsf.org/project/make

        2. GCC
           http://gcc.gnu.org

        3. dacs.quick(7)
           http://dacs.dss.ca/man/dacs.quick.7.html

        4. dacs.readme(7)
           http://dacs.dss.ca/man/dacs.readme.7.html

        5. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        6. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

        7. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

        8. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

        9. dacs_conf(8)
           http://dacs.dss.ca/man/dacs_conf.8.html

       10. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       11. dacs_version(8)
           http://dacs.dss.ca/man/dacs_version.8.html

       12. Cygwin
           http://cygwin.com

       13. man/index.html
           http://dacs.dss.ca/man/index.html

       14. Post-Release Notes
           http://dacs.dss.ca/download.html

       15. sudo(8)
           http://www.freebsd.org/cgi/man.cgi?query=sudo&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

       16. Expat
           http://expat.sourceforge.net

       17. OpenSSL
           http://www.openssl.org

       18. xmlsec1
           http://www.aleksey.com/xmlsec

       19. a patch
           http://www.openssl.org/support/faq.html#USER1

       20. Apache
           http://httpd.apache.org

       21. above
           http://dacs.dss.ca/man/#install_openssl

       22. Third-party support options
           http://dacs.dss.ca/man/#third-party-support-options

       23. build Berkeley DB
           http://dacs.dss.ca/man/#dbm-databases

       24. FAQ
           http://dacs.dss.ca/man//faq.html

       25. Berkeley DB
           http://www.oracle.com/technology/software/products/berkeley-db/index.html

       26. Oracle Corporation
           http://www.oracle.com

       27. --enable-bdb
           http://dacs.dss.ca/man/#build_flag_--enable-bdb

       28. --disable-bdb
           http://dacs.dss.ca/man/#build_flag_--disable-bdb

       29. --with-bdb
           http://dacs.dss.ca/man/#build_flag_--with-bdb

       30. ftp://ftp.gnu.org/gnu/gdbm
           ftp://ftp.gnu.org/gnu/gdbm/

       31. --enable-ndbm
           http://dacs.dss.ca/man/#build_flag_--enable-ndbm

       32. --enable-gdbm
           http://dacs.dss.ca/man/#build_flag_--enable-gdbm

       33. sdbm
           http://search.cpan.org/src/NWCLARK/perl-5.8.8/ext/SDBM_File/sdbm/README

       34. SQLite
           http://www.sqlite.org

       35. --enable-sqlite
           http://dacs.dss.ca/man/#build_flag_--enable-sqlite

       36. --disable-sqlite
           http://dacs.dss.ca/man/#build_flag_--disable-sqlite

       37. --with-sqlite
           http://dacs.dss.ca/man/#build_flag_--with-sqlite

       38. local_ntlm_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_ntlm_authenticate

       39. Samba
           http://www.samba.org

       40. --enable-ntlm-auth
           http://dacs.dss.ca/man/#build_flag_--enable-ntlm-auth

       41. --with-samba
           http://dacs.dss.ca/man/#build_flag_--with-samba

       42. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

       43. libxml2
           http://xmlsoft.org

       44. --with-xmlsec1-config
           http://dacs.dss.ca/man/#build_flag_--with-xmlsec1-config

       45. --enable-infocard-auth
           http://dacs.dss.ca/man/#build_flag_--enable-infocard-auth

       46. local_ldap_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_ldap_authenticate

       47. OpenLDAP
           http://www.openldap.org

       48. --enable-ldap-auth
           http://dacs.dss.ca/man/#build_flag_--enable-ldap-auth

       49. --with-ldap
           http://dacs.dss.ca/man/#build_flag_--with-ldap

       50. GNU Readline Library
           http://cnswww.cns.cwru.edu/php/chet/readline/rltop.html

       51. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

       52. --with-readline
           http://dacs.dss.ca/man/#build_flag_--with-readline

       53. Build Options
           http://dacs.dss.ca/man/#build_options

       54. dacsacl(1)
           http://dacs.dss.ca/man/dacsacl.1.html

       55. DESTDIR
           http://www.gnu.org/prep/standards/standards.html#DESTDIR

       56. Group
           http://httpd.apache.org/docs/2.2/mod/mpm_common.html#group

       57. Alias
           http://httpd.apache.org/docs/2.2/mod/mod_alias.html#alias

       58. FEDERATION_DOMAIN
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_DOMAIN

       59. FEDERATION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_NAME

       60. JURISDICTION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#JURISDICTION_NAME

       61. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

       62. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html#dacs_metadata

       63. dacsversion(1)
           http://dacs.dss.ca/man/dacsversion.1.html

       64. DACS_HOME
           http://dacs.dss.ca/man/dacs.conf.5.html#var_dacs_home

       65. fts(3)
           http://www.freebsd.org/cgi/man.cgi?query=fts&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       66. gdbm(3)
           http://directory.fsf.org/gdbm.html

       67. also see above
           http://dacs.dss.ca/man/#building_subset

       68. dacsemail(1)
           http://dacs.dss.ca/man/dacsemail.1.html

       69. sendmail(8)
           http://www.freebsd.org/cgi/man.cgi?query=sendmail&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

       70. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       71. www.dss.ca
           http://www.dss.ca

       72. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                   DACS.INSTALL(7)
