#
#   Copyright 2010,2011 by Mark Weyer
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#


Schemen = {

  name = "Silhouettes"
  author = "Mark Weyer"
  description = "Almost each level has its very own graphics.\nAt least this level has exactly the same rules as the previous one."
  pics = Fuehler, Herz, Zellen, Drachen, Qualle
  greypic = Grau
  startpic = Gras
  startdist = "**********"
  numexplode[1] = 6
  numexplode[2] = 4
  bgpic = mscHinter.xpm
  toppic = mscHetz.xpm
  topoverlap = 0
  explosionpic=ithDreckExpl.xpm
  
  emptypic = Leer

  <<
    leer = { pos = loc_y*10+loc_x; *; };

    sorte = {
      if !falling -> {
        leer;
        1;
        switch {
          0?0?0?0? -> A;
          0?1?0?0? -> B;
          0?1?0?1? -> C;
          0?0?0?1? -> D;
          0?0?1?0? -> E;
          0?1?1?0? -> F;
          0?1?1?1? -> G;
          0?0?1?1? -> H;
          1?0?1?0? -> I;
          1?1?1?0? -> J;
          1?1?1?1? -> K;
          1?0?1?1? -> L;
          1?0?0?0? -> M;
          1?1?0?0? -> N;
          1?1?0?1? -> O;
          1?0?0?1? -> P;
        };
        pos += 16 * ((time + 2*kind) % 10);
        *;
      };
      2;
    };
  >>

  Leer = {
    pics = mscLeer.xpm
    << Leer = leer; >>
  }

  Fuehler = {
    pics = mscLeer.xpm, mscVerbind.xpm, msc1A.xpm, msc1B.xpm, msc1C.xpm
    <<
      EinFuehler = {
        {
          if 1:10 => {A,B,C,B,A} else => A,
          if 1:10 => {D,E,F,E,D} else => D,
          if 1:10 => {G,H,I,H,G} else => G,
          if 1:10 => {D,E,F,E,D} else => D
        };
        *;
      };

      Fuehler = {
        sorte;
        EinFuehler;
        3;
        EinFuehler;
        4;
        EinFuehler;
      };
    >>
  }

  Herz = {
    pics = mscLeer.xpm, mscVerbind.xpm, msc2.xpm
    <<
      Herz = {
        sorte;
        A,B,C,D,E,F,G,H,I;
        *;
      };
    >>
  }

  Zellen = {
    pics = mscLeer.xpm, mscVerbind.xpm, msc3.xpm
    <<
      Zellen = {
        sorte;
        {if 1:2 => {A,A} else => A},
        {if 1:2 => {A,A,A} else => A},
        {if 1:2 => {A,A,A,A,A} else => A},
        B,C,D,D,
        {if 1:2 => {D,D} else => D},
        {if 1:2 => {D,D,D} else => D},
        E,F,
        {if 1:2 => {F,F} else => F},
        G,H,
        {if 1:2 => {H,H} else => H},
        {if 1:2 => {I,I} else => I},
        {if 1:2 => {J,J} else => J},
        K,L,M,N,O,
        A,A,A;
        *;
      };
    >>
  }

  Drachen = {
    pics = mscLeer.xpm, mscVerbind.xpm, msc4.xpm
    <<
      Drachen = {
        sorte;
        {E,F,G,H,
        if 1:2 => {I,J,K,L,M,N,O,P,A,B,C,D}
        else => {Q,R,S,T,U}};
        *;
      };
    >>
  }

  Qualle = {
    pics = mscLeer.xpm, mscVerbind.xpm, msc5.xpm
    <<
      var duempel;

      Qualle = {
        sorte;

        if 1:30 => { Y,Z,a,b,c,d,e,f,g,h,i,j,k,l,m }
        else -> {
          pos = duempel%24;
          duempel += 1;
        };
        *;
      };
    >>
  }

  Gras = {
    pics = mscLeer.xpm, mscGrasGrau.xpm
    <<
      flacker = {
        {if 1:2 => {A,A} else => A},
        {if 1:2 => {A,A,A} else => A},
        {if 1:2 => {A,A,A,A,A} else => A},
        {if 1:2 => {A,A,A,A,A,A,A,A,A} else => A},
        {if 1:2 => {A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A} else => A},
        {if 1:2
        => {A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A}
        else => A},
        {if 1:2
        => {A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,
            A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A}
        else => A},
        B,B,A,A,B,B,A,A,
        B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,
        {if 1:2 => {B,B,B,B,B,B} else => B},
        A,A,B,B,A,A,B,B,
        A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,
        A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A,A
      };

      Gras = {
        leer;
        1;
        g*;
        if kind@(0,-1)!=Gras -> {e; *@(0,-1);};
        if kind@(1,0)!=Gras -> {h; *@(1,0);};
        flacker; *;
        flacker; pos+=2; *;
        flacker; pos+=4; *;
        flacker; pos+=6; *;
        flacker; pos+=8; *;
        flacker; pos+=10; *;
        flacker; pos+=12; *;
        flacker; pos+=14; *;
        flacker; pos+=16; *;
        flacker; pos+=18; *;
        flacker; pos+=20; *;
        flacker; pos+=22; *;
        flacker; pos+=24; *;
        flacker; pos+=26; *;
        flacker; pos+=28; *;
      };
    >>
  }

  Grau = {
    pics = mscLeer.xpm, mscGrasGrau.xpm
    <<
      Grau = { leer; 1f*; };
    >>
  }

}

