#!/bin/bash

test_info()
{
    cat <<EOF
Verify 'ctdb getmonmode' works correctly.

This test doesn't actually verify that enabling and disabling
monitoring mode actually does that.  It trusts ctdb that the
monitoring mode is modified as requested.  21_ctdb_disablemonitor.sh
does some more useful checking.

Prerequisites:

* An active CTDB cluster with at least 2 active nodes.

Steps:

1. Verify that the status on all of the ctdb nodes is 'OK'.
2. Use 'ctdb getmodmode -n <node>' to get the current monitoring mode.
3. Verify that it looks sane.
4. Verify that the command prints the output in colon-separated format
   when run with the '-Y' option.
5. Disable monitoring on the node using 'ctdb disablemonitor'.
6. Verify that it shows monitoring as 'disabled'.

Expected results:

* 'ctdb getmonmode' works as expected.
EOF
}

. ctdb_test_functions.bash

ctdb_test_init "$@"

set -e

cluster_is_healthy

# Reset configuration
ctdb_restart_when_done

test_node=1

try_command_on_node -v 0 $CTDB getmonmode -n $test_node

sanity_check_output \
    1 \
    '^Monitoring mode:(ACTIVE \(0\)|DISABLED \(1\))$' \
    "$out"

try_command_on_node -v 0 $CTDB -Y getmonmode -n $test_node

sanity_check_output 2 '^(:mode:|:0:|:1:)$' "$out"

try_command_on_node -v 0 $CTDB disablemonitor -n $test_node

wait_until_node_has_status $test_node monoff
