//
//  MyDocument.h
//  CsoundX
//
//  Created by matt on 12/25/05.
//  Copyright 2005 Matt Ingalls
/*
 * L I C E N S E
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#import <Cocoa/Cocoa.h>

#include "csound.h"

#include "ComplexPlayThru.h"

// Prototypes for our static CSound Callback Functions.
void CS_StandardOutput(CSOUND *,  int attr, const char *format, va_list valist);
int CS_Yield(CSOUND *csound);
int CS_Playopen(CSOUND *, const csRtAudioParams *parm);
void CS_Rtplay(CSOUND *, const MYFLT *outBuf, int nbytes);
int CS_Recopen(CSOUND *, const csRtAudioParams *parm);
int CS_Rtrecord(CSOUND *,  MYFLT *inBuf, int nbytes);
void CS_Rtclose(CSOUND *);
void CS_GetValue(CSOUND *cs, const char *channelName, float *value);

@interface MyDocument : NSDocument
{
        IBOutlet NSWindow *window;
    IBOutlet NSTextView *textview;
        IBOutlet NSProgressIndicator *spinner;
        IBOutlet NSPopUpButton *rendertype;

        CSOUND *csound;

        char *mTextBuffer;
        long mTextWriteIndex;
        long mTextReadIndex;

@public
        BOOL mQuitRequested;
        BOOL mIsRealtime;
        int mIsDone;
        float mValues[128];

        csRtAudioParams mRTParams;

        MyDocument *mNextPlaying;
}

- (IBAction)render:(id)sender;
- (IBAction)stop:(id)sender;
- (IBAction)rendertype:(id)sender;

- (IBAction)invalue:(id)sender;

- (void)displayText:(NSString *)text;
- (void)writeText:(char *)str;
- (void)updateText;
- (void)run:(id)anObject;

- (void)addToPlaylist;
- (void)removeFromPlaylist;
- (int)processAudio:(AudioBufferList *)ioData;

- (float)value:(int)channel;
@end
