#!/usr/bin/env python
#
#   ConVirt   -  Copyright (c) 2008 Convirture Corp.
#   ======
#
# ConVirt is a Virtualization management tool with a graphical user
# interface that allows for performing the standard set of VM operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify various aspects of VM lifecycle management.
#
#
# This software is subject to the GNU General Public License, Version 2 (GPLv2)
# and for details, please consult it at:
#
#    http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
# 
#
# author : Jd <jd_jedi@users.sourceforge.net>
#

class VMInfoHelper:
    def __init__(self):
        self.model = None
        pass

    def append_info_node(self, iter, vm,  name, param):
        """ get the value of param from vm and append Name/Value in the
        tree at 'iter' position."""

        if not vm: return
        value = vm[param]

        if value:
            if type(value) == int:
                value = str(value)
            self.model.append(iter, [name,value,"",False])
        else:
            config = vm.get_config()
            if config:
                value = config[param]
                if value:
                    if type(value) == int:
                        value = str(value)
                    self.model.append(iter, [name,value,"",False])
                    return

            self.model.append(iter, [name,"N/A", "", False])

    def get_categories(self):
        return [("GEN", "General"), ("BOOT", "Boot"), ("RESOURCE", "Resource")]

    def get_category_keys(self):
        return { "GEN" : [("name", "Name"), ("filename", "Filename") ],
                 "BOOT" : [("on_crash", "On Crash"),
                           ("on_reboot", "On Reboot")],
                 "RESOURCE" : [ ("memory", "Memory"),
                                ("vcpus", "CPU"),
                                ("vif", "Network"),
                                ("disk", "Disks") ]
                 }


    def display_vm_info(self, treeview, vm):
        model = treeview.get_model()
        model.clear()
        self.model = model

        cat_keys = self.get_category_keys()
        for (cat,cat_label) in self.get_categories():
            iter = model.append(None,[cat_label,"", "",True])
            for k, k_label in cat_keys[cat]:
                self.append_info_node(iter, vm, k_label,k)


