# Copyright (c) 2011 The WebRTC project authors. All Rights Reserved.
#
# Use of this source code is governed by a BSD-style license
# that can be found in the LICENSE file in the root of the source
# tree. An additional intellectual property rights grant can be found
# in the file PATENTS.  All contributing project authors may
# be found in the AUTHORS file in the root of the source tree.

LOCAL_PATH := $(call my-dir)

include $(CLEAR_VARS)

LOCAL_ARM_MODE := arm
LOCAL_MODULE := libwebrtc_voe_core
LOCAL_MODULE_TAGS := optional
LOCAL_CPP_EXTENSION := .cc
LOCAL_GENERATED_SOURCES :=
LOCAL_SRC_FILES := audio_frame_operations.cc \
    channel.cc \
    channel_manager.cc \
    channel_manager_base.cc \
    dtmf_inband.cc \
    dtmf_inband_queue.cc \
    level_indicator.cc \
    monitor_module.cc \
    output_mixer.cc \
    ref_count.cc \
    shared_data.cc \
    statistics.cc \
    transmit_mixer.cc \
    utility.cc \
    voe_audio_processing_impl.cc \
    voe_base_impl.cc \
    voe_call_report_impl.cc \
    voe_codec_impl.cc \
    voe_dtmf_impl.cc \
    voe_encryption_impl.cc \
    voe_external_media_impl.cc \
    voe_file_impl.cc \
    voe_hardware_impl.cc \
    voe_neteq_stats_impl.cc \
    voe_network_impl.cc \
    voe_rtp_rtcp_impl.cc \
    voe_video_sync_impl.cc \
    voe_volume_control_impl.cc \
    voice_engine_impl.cc

# Flags passed to both C and C++ files.
MY_CFLAGS :=  
MY_CFLAGS_C :=
MY_DEFS := '-DNO_TCMALLOC' \
    '-DNO_HEAPCHECKER' \
    '-DWEBRTC_TARGET_PC' \
    '-DWEBRTC_LINUX' \
    '-DWEBRTC_THREAD_RR' \
    '-DWEBRTC_ANDROID' \
    '-DANDROID' 
LOCAL_CFLAGS := $(MY_CFLAGS_C) $(MY_CFLAGS) $(MY_DEFS)

# Include paths placed before CFLAGS/CPPFLAGS
LOCAL_C_INCLUDES := $(LOCAL_PATH)/../../.. \
    $(LOCAL_PATH)/../interface \
    $(LOCAL_PATH)/../../../common_audio/resampler/main/interface \
    $(LOCAL_PATH)/../../../common_audio/signal_processing_library/main/interface \
    $(LOCAL_PATH)/../../../modules/audio_coding/main/interface \
    $(LOCAL_PATH)/../../../modules/interface \
    $(LOCAL_PATH)/../../../modules/audio_conference_mixer/interface \
    $(LOCAL_PATH)/../../../modules/audio_device/main/interface \
    $(LOCAL_PATH)/../../../modules/audio_processing/main/interface \
    $(LOCAL_PATH)/../../../modules/media_file/interface \
    $(LOCAL_PATH)/../../../modules/rtp_rtcp/interface \
    $(LOCAL_PATH)/../../../modules/udp_transport/interface \
    $(LOCAL_PATH)/../../../modules/utility/interface \
    $(LOCAL_PATH)/../../../system_wrappers/interface 

# Flags passed to only C++ (and not C) files.
LOCAL_CPPFLAGS := 

LOCAL_LDFLAGS :=

LOCAL_STATIC_LIBRARIES := 

LOCAL_SHARED_LIBRARIES := libcutils \
    libdl \
    libstlport 
LOCAL_ADDITIONAL_DEPENDENCIES :=

ifeq ($(TARGET_OS)-$(TARGET_SIMULATOR),linux-true)
LOCAL_LDLIBS += -ldl -lpthread
endif

ifneq ($(TARGET_SIMULATOR),true)
LOCAL_SHARED_LIBRARIES += libdl
endif

include external/stlport/libstlport.mk
include $(BUILD_STATIC_LIBRARY)
#include $(BUILD_SHARED_LIBRARY)