# Copyright (c) 2011 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'protoc_out_dir': '<(SHARED_INTERMEDIATE_DIR)/protoc_out',
  },
  'target_defaults': {
    'include_dirs': [
      '../..',  # add it first, so src/base headers are used instead of the ones
                # brought with the library as cc files would be taken from the
                # main chrome tree as well.
      'cpp/src',
      '<(protoc_out_dir)',
    ],
    'defines': [
      'USE_HASH_MAP=1',
      'USE_GOOGLE_BASE=1',
    ],
  },
  'targets': [{
    'target_name': 'libphonenumber',
    'type': 'static_library',
    'dependencies': [
      '../icu/icu.gyp:icui18n',
      '../icu/icu.gyp:icuuc',
      '../protobuf/protobuf.gyp:protobuf_lite',
      '../../base/base.gyp:base',
      '../../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
      'phonenumber_proto',
    ],
    'sources': [
      # 'chrome/regexp_adapter_icuregexp.cc',
      'cpp/src/default_logger.cc',
      'cpp/src/lite_metadata.cc',
      'cpp/src/logger.cc',
      'cpp/src/phonenumber.cc',
      'cpp/src/phonenumberutil.cc',
      'cpp/src/regexp_adapter_icu.cc',
      'cpp/src/regexp_cache.cc',
      'cpp/src/stringutil.cc',
      'cpp/src/utf/rune.c',
      'cpp/src/utf/unicodetext.cc',
      'cpp/src/utf/unilib.cc',
      # Generated by phonenumber_proto.
      '<(protoc_out_dir)/phonemetadata.pb.cc',
      '<(protoc_out_dir)/phonenumber.pb.cc',
    ],
    'conditions': [
      ['OS=="win"', {
        'action': [
          '/wo4309',
        ],
      }],
    ],
  },
  {
    # Protobuf compiler / generate rule for the phones
    'target_name': 'phonenumber_proto',
    'type': 'none',
    'sources': [
      'resources/phonemetadata.proto',
      'resources/phonenumber.proto',
    ],
    'rules': [{
      'rule_name': 'genproto',
      'extension': 'proto',
      'inputs': [
        '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
      ],
      'variables': {
        # The protoc compiler requires a proto_path argument with the
        # directory containing the .proto file.
        # There's no generator variable that corresponds to this, so fake it.
        'rule_input_relpath': 'resources',
      },
      'outputs': [
        '<(protoc_out_dir)/<(RULE_INPUT_ROOT).pb.h',
        '<(protoc_out_dir)/<(RULE_INPUT_ROOT).pb.cc',
      ],
      'action': [
        '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
        '--proto_path=<(rule_input_relpath)',
        '<(rule_input_relpath)/<(RULE_INPUT_ROOT)<(RULE_INPUT_EXT)',
        '--cpp_out=<(protoc_out_dir)',
      ],
      'message': 'Generating C++ code from <(RULE_INPUT_PATH)',
    }],
    'dependencies': [
      '../protobuf/protobuf.gyp:protobuf_lite',
      '../protobuf/protobuf.gyp:protoc#host',
    ],
    'direct_dependent_settings': {
      'include_dirs': [
        '<(protoc_out_dir)',
      ]
    },
    'export_dependent_settings': [
      '../../third_party/protobuf/protobuf.gyp:protobuf_lite',
    ],
  },
  {
    'target_name': 'libphonenumber_unittests',
    'type': 'executable',
    'sources': [
      '../../base/test/run_all_unittests.cc',
      'cpp/src/phonenumberutil_test.cc',
      'cpp/src/regexp_adapter_test.cc',
      'cpp/src/stringutil_test.cc',
      'cpp/src/test_metadata.cc',
    ],
    'dependencies': [
      '../icu/icu.gyp:icui18n',
      '../icu/icu.gyp:icuuc',
      '../protobuf/protobuf.gyp:protobuf_lite',
      '../../base/base.gyp:base',
      '../../base/base.gyp:test_support_base',
      '../../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
      '../../testing/gmock.gyp:gmock',
      '../../testing/gtest.gyp:gtest',
      'libphonenumber',
    ],
    'conditions': [
      ['OS=="win"', {
        'action': [
          '/wo4309',
        ],
      }],
    ],
  }]
}
