// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PPAPI_PROXY_PPAPI_PARAM_TRAITS_H_
#define PPAPI_PROXY_PPAPI_PARAM_TRAITS_H_

#include <string>
#include <vector>

#include "ipc/ipc_message_utils.h"
#include "ipc/ipc_platform_file.h"
#include "ppapi/c/pp_completion_callback.h"
#include "ppapi/c/pp_rect.h"
#include "ppapi/c/pp_var.h"

struct PP_FileInfo;
struct PP_ObjectProperty;
struct PP_Flash_Menu;
struct PP_Flash_NetAddress;

namespace pp {
namespace proxy {

class HostResource;
struct PPBFileRef_CreateInfo;
struct PPBFlash_DrawGlyphs_Params;
struct PPBURLLoader_UpdateProgress_Params;
struct SerializedDirEntry;
struct SerializedFontDescription;
class SerializedFlashMenu;
class SerializedVar;

}  // namespace proxy
}  // namespace pp

namespace IPC {

template<>
struct ParamTraits<PP_Bool> {
  typedef PP_Bool param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits<PP_FileInfo> {
  typedef PP_FileInfo param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template <>
struct ParamTraits<PP_Flash_NetAddress> {
  typedef PP_Flash_NetAddress param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* p);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits<PP_ObjectProperty> {
  typedef PP_ObjectProperty param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits<pp::proxy::PPBFlash_DrawGlyphs_Params> {
  typedef pp::proxy::PPBFlash_DrawGlyphs_Params param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits<pp::proxy::PPBFileRef_CreateInfo> {
  typedef pp::proxy::PPBFileRef_CreateInfo param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits<pp::proxy::PPBURLLoader_UpdateProgress_Params> {
  typedef pp::proxy::PPBURLLoader_UpdateProgress_Params param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits<pp::proxy::SerializedDirEntry> {
  typedef pp::proxy::SerializedDirEntry param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits<pp::proxy::SerializedFontDescription> {
  typedef pp::proxy::SerializedFontDescription param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits<pp::proxy::HostResource> {
  typedef pp::proxy::HostResource param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits<pp::proxy::SerializedVar> {
  typedef pp::proxy::SerializedVar param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits< std::vector<pp::proxy::SerializedVar> > {
  typedef std::vector<pp::proxy::SerializedVar> param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits< std::vector<pp::proxy::PPBFileRef_CreateInfo> > {
  typedef std::vector<pp::proxy::PPBFileRef_CreateInfo> param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

template<>
struct ParamTraits<pp::proxy::SerializedFlashMenu> {
  typedef pp::proxy::SerializedFlashMenu param_type;
  static void Write(Message* m, const param_type& p);
  static bool Read(const Message* m, void** iter, param_type* r);
  static void Log(const param_type& p, std::string* l);
};

}  // namespace IPC

#endif  // PPAPI_PROXY_PPAPI_PARAM_TRAITS_H_
