// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_VIDEO_PICTURE_H_
#define MEDIA_VIDEO_PICTURE_H_

#include "base/basictypes.h"
#include "ui/gfx/gl/gl_context.h"
#include "ui/gfx/size.h"

namespace media {

// A picture buffer that is composed of a GLES2 texture.
// This is the media-namespace equivalent of PP_PictureBuffer_Dev.
class PictureBuffer {
 public:
  PictureBuffer(int32 id, gfx::Size size, uint32 texture_id);

  // Returns the client-specified id of the buffer.
  int32 id() const {
    return id_;
  }

  // Returns the size of the buffer.
  gfx::Size size() const {
    return size_;
  }

  // Returns the id of the texture.
  // NOTE: The texture id in the renderer process corresponds to a different
  // texture id in the GPU process.
  uint32 texture_id() const {
    return texture_id_;
  }

 private:
  int32 id_;
  gfx::Size size_;
  uint32 texture_id_;
};

// A decoded picture frame.
// This is the media-namespace equivalent of PP_Picture_Dev.
class Picture {
 public:
  Picture(int32 picture_buffer_id, int32 bitstream_buffer_id);

  // Returns the id of the picture buffer where this picture is contained.
  int32 picture_buffer_id() const {
    return picture_buffer_id_;
  }

  // Returns the id of the bitstream buffer from which this frame was decoded.
  int32 bitstream_buffer_id() const {
    return bitstream_buffer_id_;
  }

  void set_bitstream_buffer_id(int32 bitstream_buffer_id) {
    bitstream_buffer_id_ = bitstream_buffer_id;
  }

 private:
  int32 picture_buffer_id_;
  int32 bitstream_buffer_id_;
};

}  // namespace media

#endif  // MEDIA_VIDEO_PICTURE_H_
