#!/usr/bin/python
# -*- encoding: utf-8; py-indent-offset: 4 -*-
# +------------------------------------------------------------------+
# |             ____ _               _        __  __ _  __           |
# |            / ___| |__   ___  ___| | __   |  \/  | |/ /           |
# |           | |   | '_ \ / _ \/ __| |/ /   | |\/| | ' /            |
# |           | |___| | | |  __/ (__|   <    | |  | | . \            |
# |            \____|_| |_|\___|\___|_|\_\___|_|  |_|_|\_\           |
# |                                                                  |
# | Copyright Mathias Kettner 2010             mk@mathias-kettner.de |
# +------------------------------------------------------------------+
#
# This file is part of Check_MK.
# The official homepage is at http://mathias-kettner.de/check_mk.
#
# check_mk is free software;  you can redistribute it and/or modify it
# under the  terms of the  GNU General Public License  as published by
# the Free Software Foundation in version 2.  check_mk is  distributed
# in the hope that it will be useful, but WITHOUT ANY WARRANTY;  with-
# out even the implied warranty of  MERCHANTABILITY  or  FITNESS FOR A
# PARTICULAR PURPOSE. See the  GNU General Public License for more de-
# ails.  You should have  received  a copy of the  GNU  General Public
# License along with GNU Make; see the file  COPYING.  If  not,  write
# to the Free Software Foundation, Inc., 51 Franklin St,  Fifth Floor,
# Boston, MA 02110-1301 USA.

multisite_builtin_views = {
 'allhosts': {'browser_reload': 30,
              'column_headers': 'pergroup',
              'datasource': 'hosts',
              'description': 'Overall state of allhosts, with counts of services in the various states.',
              'group_painters': [('sitealias', None)],
              'hard_filters': ['summary_host'],
              'hard_filtervars': [('site', ''),
                                  ('is_summary_host', '0'),
                                  ('host', ''),
                                  ('opthostgroup', '')],
              'hidden': False,
              'hide_filters': [],
              'layout': 'table',
              'mustsearch': False,
              'name': 'allhosts',
              'num_columns': 3,
              'owner': '',
              'painters': [('host_state', None),
                           ('host', 'host'),
                           ('host_icons', None),
                           ('num_services_ok', 'host_ok'),
                           ('num_services_warn', 'host_warn'),
                           ('num_services_unknown', 'host_unknown'),
                           ('num_services_crit', 'host_crit'),
                           ('num_services_pending', 'host_pending')],
              'play_sounds': False,
              'public': True,
              'show_filters': ['siteopt', 'hostregex', 'opthostgroup'],
              'sorters': [('site', False), ('site_host', False)],
              'title': 'All hosts',
              'topic': "Hosts"},
 'allhosts_mini': {'browser_reload': 30,
                   'column_headers': 'pergroup',
                   'datasource': 'hosts',
                   'description': '',
                   'group_painters': [('sitealias', None)],
                   'hard_filters': ['summary_host',],
                   'hard_filtervars': [('site', ''),
                                       ('host', ''),
                                       ('is_summary_host', '0'),
                                       ('opthostgroup', '')],
                   'hidden': False,
                   'hide_filters': [],
                   'layout': 'table',
                   'mustsearch': False,
                   'name': 'allhosts_mini',
                   'num_columns': 6,
                   'owner': '',
                   'painters': [('host_state', None),
                                ('host', 'host'),
                                ('num_problems', 'problemsofhost')],
                   'play_sounds': False,
                   'public': True,
                   'show_filters': ['siteopt', 'hostregex', 'opthostgroup'],
                   'sorters': [('site', False), ('site_host', False)],
                   'title': 'All hosts (Mini)',
              'topic': "Hosts"},
 'allservices': {'browser_reload': 90,
                 'column_headers': 'perpage',
                 'datasource': 'services',
                 'description': 'All services grouped\r\nby hosts.',
                 'group_painters': [('sitealias', 'sitehosts'),
                                    ('host_with_state', 'host')],
                 'hard_filters': ['summary_host'],
                 'hard_filtervars': [('is_service_in_notification_period',
                                      '-1'),
                                     ('optservicegroup', ''),
                                     ('is_service_notifications_enabled',
                                      '-1'),
                                     ('is_host_in_notification_period',
                                      '-1'),
                                     ('is_in_downtime', '-1'),
                                     ('is_service_scheduled_downtime_depth',
                                      '-1'),
                                     ('is_service_acknowledged', '-1'),
                                     ('host', ''),
                                     ('is_service_active_checks_enabled',
                                      '-1'),
                                     ('is_summary_host', '0'),
                                     ('service', ''),
                                     ('check_command', ''),
                                     ('st0', 'on'),
                                     ('st1', 'on'),
                                     ('st2', 'on'),
                                     ('st3', 'on'),
                                     ('stp', 'on'),
                                     ('opthostgroup', ''),
                                     ('service_output', ''),
                                     ('is_service_is_flapping', '-1')],
                 'hidden': False,
                 'hide_filters': [],
                 'layout': 'table',
                 'mustsearch': False,
                 'name': 'allservices',
                 'num_columns': 1,
                 'owner': '',
                 'painters': [('service_state', None),
                              ('service_description', 'service'),
                              ('svc_plugin_output', None),
                              ('service_icons', None),
                              ('svc_state_age', None),
                              ('svc_check_age', None),
                              ('perfometer', None)],
                 'play_sounds': True,
                 'public': True,
                 'show_filters': ['service_in_notification_period',
                                  'optservicegroup',
                                  'service_notifications_enabled',
                                  'host_in_notification_period',
                                  'in_downtime',
                                  'service_scheduled_downtime_depth',
                                  'service_acknowledged',
                                  'hostregex',
                                  'service_active_checks_enabled',
                                  'summary_host',
                                  'serviceregex',
                                  'check_command',
                                  'svcstate',
                                  'opthostgroup',
                                  'output',
                                  'service_is_flapping'],
                 'sorters': [('site', False),
                             ('site_host', False),
                             ('svcdescr', False)],
                 'title': 'All services',
              'topic': 'Services'},
 'comments': {'column_headers': 'perpage',
              'datasource': 'comments',
              'description': 'All host- and service comments',
              'group_painters': [('comment_what', None)],
              'hard_filters': [],
              'hard_filtervars': [('host', ''), ('service', '')],
              'hidden': False,
              'hide_filters': [],
              'layout': 'table',
              'mustsearch': False,
              'name': 'comments',
              'num_columns': 1,
              'owner': '',
              'painters': [('comment_author', None),
                           ('comment_time', None),
                           ('comment_expires', None),
                           ('comment_entry_type', None),
                           ('comment_comment', None),
                           ('host', None),
                           ('service_description', 'service'),
                           ('comment_id', None)],
              'public': True,
              'show_filters': ['hostregex', 'serviceregex'],
              'sorters': [('comment_type', False), ('comment_author', False)],
              'title': 'Comments'},
 'comments_of_host': {'column_headers': 'perpage',
                      'datasource': 'comments',
                      'description': 'Linkable view showing\r\nall comments of a specific host',
                      'group_painters': [],
                      'hard_filters': ['service'],
                      'hard_filtervars': [('service', '')],
                      'hidden': True,
                      'hide_filters': ['site', 'host'],
                      'layout': 'table',
                      'mustsearch': False,
                      'name': 'comments_of_host',
                      'num_columns': 1,
                      'owner': '',
                      'painters': [('comment_author', None),
                                   ('comment_comment', None),
                                   ('comment_time', None),
                                   ('comment_entry_type', None)],
                      'public': True,
                      'show_filters': [],
                      'sorters': [],
                      'linktitle': 'Host comments',
                      'title': 'Comments of host'},

 'comments_of_service': {'column_headers': 'perpage',
                         'datasource': 'comments',
                         'description': 'Linkable view showing\r\nall comments of a specific service',
                         'group_painters': [],
                         'hard_filters': [],
                         'hard_filtervars': [],
                         'hidden': True,
                         'hide_filters': ['site', 'host', 'service'],
                         'layout': 'table',
                         'mustsearch': False,
                         'name': 'comments_of_service',
                         'num_columns': 1,
                         'owner': '',
                         'painters': [('comment_author', None),
                                      ('comment_comment', None),
                                      ('comment_time', None),
                                      ('comment_entry_type', None)],
                         'public': True,
                         'show_filters': [],
                         'sorters': [],
                         'linktitle': 'Comments',
                         'title': 'Comments of service'},
 'downtimes': {'column_headers': 'pergroup',
               'datasource': 'downtimes',
               'description': 'All host- und service-downtimes',
               'group_painters': [('downtime_what', None)],
               'hard_filters': [],
               'hard_filtervars': [('is_service_scheduled_downtime_depth',
                                    '-1'),
                                   ('host', ''),
                                   ('service', '')],
               'hidden': False,
               'hide_filters': [],
               'layout': 'table',
               'mustsearch': False,
               'name': 'downtimes',
               'num_columns': 1,
               'owner': '',
               'painters': [('host', 'host'),
                            ('service_description', 'service'),
                            ('downtime_author', None),
                            ('downtime_entry_time', None),
                            ('downtime_start_time', None),
                            ('downtime_end_time', None),
                            ('downtime_fixed', None),
                            ('downtime_duration', None),
                            ('downtime_comment', None)],

               'public': True,
               'show_filters': ['service_scheduled_downtime_depth',
                                'hostregex',
                                'serviceregex'],
               'sorters': [('downtime_what', False),
                           ('downtime_start_time', False)],
               'title': 'Downtimes'},
 'downtimes_of_host': {'column_headers': 'perpage',
                       'datasource': 'downtimes',
                       'description': '',
                       'group_painters': [],
                       'hard_filters': [],
                       'hard_filtervars': [],
                       'hidden': True,
                       'hide_filters': ['site', 'host'],
                       'layout': 'table',
                       'mustsearch': False,
                       'name': 'downtimes_of_host',
                       'num_columns': 1,
                       'owner': '',
                       'painters': [('downtime_author', None),
                            ('downtime_entry_time', None),
                            ('downtime_start_time', None),
                            ('downtime_end_time', None),
                            ('downtime_fixed', None),
                            ('downtime_duration', None),
                            ('downtime_comment', None)],
                       'public': True,
                       'show_filters': [],
                       'sorters': [],
                       'linktitle': 'Host downtimes',
                       'title': 'Downtimes of host'},
 'downtimes_of_service': {'column_headers': 'pergroup',
                          'datasource': 'downtimes',
                          'description': '',
                          'group_painters': [],
                          'hard_filters': [],
                          'hard_filtervars': [],
                          'hidden': True,
                          'hide_filters': ['site', 'service', 'host'],
                          'layout': 'table',
                          'mustsearch': False,
                          'name': 'downtimes_of_service',
                          'num_columns': 1,
                          'owner': '',
                          'painters': [('downtime_author', None),
                                    ('downtime_entry_time', None),
                                    ('downtime_start_time', None),
                                    ('downtime_end_time', None),
                                    ('downtime_fixed', None),
                                    ('downtime_duration', None),
                                    ('downtime_comment', None)],
                          'public': True,
                          'show_filters': [],
                          'sorters': [],
                          'linktitle': 'Downtimes',
                          'title': 'Downtimes of service'},
 'host': {'browser_reload': 30,
          'column_headers': 'perpage',
          'datasource': 'services',
          'description': 'All services of a given host. The host and site must be set via HTML variables.',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': [],
          'hard_filtervars': [('st0', 'on'),
                              ('st1', 'on'),
                              ('st2', 'on'),
                              ('st3', 'on'),
                              ('stp', 'on')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('service_icons', None),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate', 'serviceregex'],
          'sorters': [('svcdescr', False)],
          'linktitle': 'Services',
          'title': 'Services of Host'},
'hosts': {'browser_reload': 30,
           'column_headers': 'off',
           'datasource': 'services',
           'description': 'All services of of hosts which match a name',
           'group_painters': [('sitealias', 'sitehosts'), ('host', 'host')],
           'hard_filters': [],
           'hard_filtervars': [('host', ''),
                               ('st0', 'on'),
                               ('st1', 'on'),
                               ('st2', 'on'),
                               ('st3', 'on'),
                               ('stp', 'on')],
           'hidden': True,
           'hide_filters': [],
           'layout': 'boxed',
           'linktitle': 'Services of Hosts',
           'mustsearch': False,
           'name': 'hosts',
           'num_columns': 1,
           'owner': '',
           'painters': [('service_state', None),
                        ('service_description', 'service'),
                        ('svc_plugin_output', None),
                        ('svc_state_age', None),
                        ('svc_check_age', None),
                        ('service_icons', None),
                        ('perfometer', None)],
           'play_sounds': False,
           'public': True,
           'show_filters': ['hostregex', 'svcstate'],
           'sorters': [('site', False),
                       ('site_host', False),
                       ('svcdescr', False)],
           'title': 'Services of Hosts',
           'topic': 'Other'},
'host_ok': {'browser_reload': 30,
          'column_headers': 'perpage',
          'datasource': 'services',
          'description': 'All services of a given host that are in state OK',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', 'on'),
                              ('st1', ''),
                              ('st2', ''),
                              ('st3', ''),
                              ('stp', '')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'hidebutton' : True,
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host_lk',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : 'Services: OK',
          'title': 'OK Services of host'},
'host_warn': {'browser_reload': 30,
          'column_headers': 'perpage',
          'datasource': 'services',
          'description': 'All services of a given host that are in state WARN',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', ''),
                              ('st1', 'on'),
                              ('st2', ''),
                              ('st3', ''),
                              ('stp', '')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'hidebutton' : True,
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host_warn',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : 'Services: WARN',
          'title': 'WARN Services of host'},
'host_crit': {'browser_reload': 30,
          'column_headers': 'perpage',
          'datasource': 'services',
          'description': 'All services of a given host that are in state CRIT',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', ''),
                              ('st1', ''),
                              ('st2', 'on'),
                              ('st3', ''),
                              ('stp', '')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'hidebutton' : True,
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host_crit',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : 'Services: CRIT',
          'title': 'CRIT Services of host'},
'host_unknown': {'browser_reload': 30,
          'column_headers': 'perpage',
          'datasource': 'services',
          'description': 'All services of a given host that are in state UNKNOWN',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', ''),
                              ('st1', ''),
                              ('st2', ''),
                              ('st3', 'on'),
                              ('stp', '')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'hidebutton' : True,
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host_unknown',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : 'Services: UNKNOWN',
          'title': 'UNKNOWN Services of host'},
'host_pending': {'browser_reload': 30,
          'column_headers': 'perpage',
          'datasource': 'services',
          'description': 'All services of a given host that are PENDING',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', ''),
                              ('st1', ''),
                              ('st2', ''),
                              ('st3', ''),
                              ('stp', 'on')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'hidebutton' : True,
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'host_pending',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : 'Services: PENDING',
          'title': 'PENDING Services of host'},
'problemsofhost': {'browser_reload': 30,
          'column_headers': 'perpage',
          'datasource': 'services',
          'description': 'All problem services of a given host. The host and site must be set via HTML variables.',
          'group_painters': [('host_with_state', 'hoststatus')],
          'hard_filters': ['svcstate'],
          'hard_filtervars': [('st0', ''),
                              ('st1', 'on'),
                              ('st2', 'on'),
                              ('st3', 'on'),
                              ('stp', '')],
          'hidden': True,
          'hide_filters': ['site', 'host'],
          'layout': 'boxed',
          'mustsearch': False,
          'name': 'problemsofhost',
          'num_columns': 2,
          'owner': '',
          'painters': [('service_state', None),
                       ('service_description', 'service'),
                       ('svc_plugin_output', None),
                       ('svc_state_age', None),
                       ('svc_check_age', None),
                       ('service_icons', None),
                       ('perfometer', None)],
          'play_sounds': False,
          'public': True,
          'show_filters': ['svcstate'],
          'sorters': [('svcdescr', False)],
          'linktitle' : 'Host Problems',
          'title': 'Problems of host'},
 'hostgroup': {'browser_reload': 30,
               'column_headers': 'off',
               'datasource': 'hosts',
               'description': '',
               'group_painters': [('site_icon', None),
                                  ('sitealias', 'sitehosts')],
               'hard_filters': [],
               'hard_filtervars': [],
               'hidden': True,
               'hide_filters': ['hostgroup'],
               'layout': 'boxed',
               'linktitle': 'Hostgroup Overview',
               'mustsearch': False,
               'name': 'hostgroup',
               'num_columns': 2,
               'owner': 'admin',
               'painters': [('host_state', None),
                            ('host', 'host'),
                            ('host_icons', None),
                            ('alias', None),
                            ('num_services_ok', 'host_ok'),
                            ('num_services_warn', 'host_warn'),
                            ('num_services_unknown', 'host_unknown'),
                            ('num_services_crit', 'host_crit'),
                            ('num_services_pending', 'host_pending')],
               'play_sounds': False,
               'public': True,
               'show_filters': [],
               'sorters': [('site', False), ('site_host', False)],
               'title': 'Hostgroup',
               'topic': 'hidden'},
 'hostgroupservices': {'browser_reload': 90,
                       'column_headers': 'off',
                       'datasource': 'services',
                       'description': 'All services of a certain hostgroup',
                       'group_painters': [('sitealias', 'sitehosts'),
                                          ('host_with_state', 'host')],
                       'hard_filters': [],
                       'hard_filtervars': [('is_service_in_notification_period',
                                            '-1'),
                                           ('optservicegroup', ''),
                                           ('neg_optservicegroup', ''),
                                           ('is_service_notifications_enabled',
                                            '-1'),
                                           ('is_host_in_notification_period',
                                            '-1'),
                                           ('is_service_scheduled_downtime_depth',
                                            '-1'),
                                           ('is_service_acknowledged', '-1'),
                                           ('host', ''),
                                           ('is_service_active_checks_enabled',
                                            '-1'),
                                           ('service', ''),
                                           ('check_command', ''),
                                           ('st0', 'on'),
                                           ('st1', 'on'),
                                           ('st2', 'on'),
                                           ('st3', 'on'),
                                           ('stp', 'on'),
                                           ('is_in_downtime', '-1'),
                                           ('service_output', ''),
                                           ('is_service_is_flapping', '-1')],
                       'hidden': True,
                       'hide_filters': ['hostgroup'],
                       'layout': 'table',
                       'linktitle': 'Services',
                       'mustsearch': False,
                       'name': 'hostgroupservices',
                       'num_columns': 2,
                       'owner': 'admin',
                       'painters': [('service_state', None),
                                    ('service_description', 'service'),
                                    ('svc_plugin_output', None),
                                    ('service_icons', None),
                                    ('svc_state_age', None),
                                    ('svc_check_age', None)],
                       'play_sounds': True,
                       'public': True,
                       'show_filters': ['service_in_notification_period',
                                        'optservicegroup',
                                        'service_notifications_enabled',
                                        'host_in_notification_period',
                                        'service_scheduled_downtime_depth',
                                        'service_acknowledged',
                                        'hostregex',
                                        'service_active_checks_enabled',
                                        'serviceregex',
                                        'check_command',
                                        'svcstate',
                                        'in_downtime',
                                        'output',
                                        'service_is_flapping'],
                       'sorters': [('site', False),
                                   ('site_host', False),
                                   ('svcdescr', False)],
                       'title': 'Services of Hostgroup',
                       'topic': 'hidden'},
 'hostgroupgrid': {'browser_reload': 30,
               'column_headers': 'pergroup',
                   'datasource': 'hostsbygroup',
                   'description': 'Hosts grouped by hostgroups, with a brief list of all services',
                   'group_painters': [('sitealias', 'sitehosts'),
                                      ('hg_alias', 'hostgroup')],
                   'hard_filters': [],
                   'hard_filtervars': [('is_host_scheduled_downtime_depth',
                                        '-1'),
                                       ('is_host_in_notification_period',
                                        '-1'),
                                       ('site', ''),
                                       ('is_summary_host', '-1'),],
                   'hidden': False,
                   'hide_filters': [],
                   'layout': 'boxed',
                   'mustsearch': False,
                   'name': 'hostgroupgrid',
                   'num_columns': 2,
                   'owner': '',
                   'painters': [('host', 'host'),
                                ('host_services', None),
                                ('host_icons', None)],
                   'public': True,
                   'show_filters': ['host_scheduled_downtime_depth',
                                    'host_in_notification_period',
                                    'siteopt',
                                    'summary_host',
                                    ],
                   'sorters': [('site', False),
                               ('hostgroup', False),
                               ('site_host', False)],
                   'title': 'Hostgroups (Grid)',
                   'topic': "Hostgroups"},
 'hostgroups': {'browser_reload': 30,
               'column_headers': 'pergroup',
                'datasource': 'hostgroups',
                'description': 'A short overview over all host groups, without an explicity listing of the actual hosts',
                'group_painters': [('sitealias', 'sitehosts')],
                'hard_filters': [],
                'hard_filtervars': [],
                'hidden': False,
                'hide_filters': [],
                'layout': 'boxed',
                'mustsearch': False,
                'name': 'hostgroups',
                'num_columns': 3,
                'owner': '',
                'painters': [('hg_name', 'hostgroup'),
                             ('hg_alias', None),
                             ('hg_num_hosts_up', None),
                             ('hg_num_hosts_down', None),
                             ('hg_num_hosts_unreach', None),
                             ('hg_num_hosts_pending', None),
                             ('hg_num_services_ok', None),
                             ('hg_num_services_warn', None),
                             ('hg_num_services_crit', None),
                             ('hg_num_services_unknown', None),
                             ('hg_num_services_pending', None)],
                'public': True,
                'show_filters': [],
                'sorters': [],
                'title': 'Hostgroups (Summary)',
                'topic': 'Hostgroups' },
 'hostproblems': {'browser_reload': 30,
               'column_headers': 'pergroup',
                  'datasource': 'hosts',
                  'description': 'A complete list of all host problems with a search form for selecting handled and unhandled',
                  'group_painters': [('host_state', None)],
                  'hard_filters': ['host_scheduled_downtime_depth', 'summary_host'],
                  'hard_filtervars': [('is_host_scheduled_downtime_depth',
                                       '0'),
                                      ('is_host_in_notification_period',
                                       '-1'),
                                      ('hst0', ''),
                                      ('hst1', 'on'),
                                      ('hst2', 'on'),
                                      ('hstp', ''),
                                      ('host', ''),
                                      ('is_summary_host', '0'),
                                      ('opthostgroup', '')],
                  'hidden': False,
                  'hide_filters': [],
                  'layout': 'boxed',
                  'mustsearch': False,
                  'name': 'hostproblems',
                  'num_columns': 3,
                  'owner': '',
                  'painters': [('host', 'host'),
                               ('host_icons', None),
                               ('host_state', None),
                               ('host_plugin_output', None),
                               ('num_services_ok', 'host_ok'),
                               ('num_services_warn', 'host_warn'),
                               ('num_services_crit', 'host_crit'),
                               ('num_services_unknown', 'host_unknown'),
                               ('num_services_pending', 'host_pending')],
                  'public': True,
                  'show_filters': ['host_in_notification_period',
                                   'hoststate',
                                   'hostregex',
                                   'opthostgroup'],
                  'sorters': [],
                  'title': 'Host problems',
                  'topic': 'Problems'},
 'hostsbygroup': {'browser_reload': 30,
               'column_headers': 'pergroup',
                  'datasource': 'hostsbygroup',
                  'description': 'A complete listing of\r\nall host groups and each of their hosts',
                  'group_painters': [('sitealias', 'sitehosts'),
                                     ('hg_alias', 'hostgroup')],
                  'hard_filters': [],
                  'hard_filtervars': [('is_host_scheduled_downtime_depth',
                                       '-1'),
                                      ('is_host_in_notification_period',
                                       '-1'),
                                      ('site', ''),
                                      ('is_summary_host', '-1')],
                  'hidden': False,
                  'hide_filters': [],
                  'layout': 'boxed',
                  'mustsearch': False,
                  'name': 'hostsbygroup',
                  'num_columns': 2,
                  'owner': '',
                  'painters': [('host_state', None),
                               ('host', 'host'),
                               ('host_icons', None),
                               ('alias', 'hoststatus'),
                               ('num_services_ok', 'host_ok'),
                               ('num_services_warn', 'host_warn'),
                               ('num_services_unknown', 'host_unknown'),
                               ('num_services_crit', 'host_crit'),
                               ('num_services_pending', 'host_pending')],
                  'public': True,
                  'show_filters': ['host_scheduled_downtime_depth',
                                   'host_in_notification_period',
                                   'siteopt',
                                   'summary_host'],
                  'sorters': [('site', False),
                              ('hostgroup', False),
                              ('site_host', False)],
                  'title': 'Hostgroups',
                  'topic': 'Hostgroups'},
 'hoststatus': {'browser_reload': 30,
               'column_headers': 'off',
                'datasource': 'hosts',
                'description': '',
                'group_painters': [],
                'hard_filters': [],
                'hard_filtervars': [],
                'hidden': True,
                'hide_filters': ['site', 'host'],
                'layout': 'dataset',
                'mustsearch': False,
                'name': 'hoststatus',
                'owner': '',
                'painters': [('sitealias', None),
                             ('host', 'host'),
                             ('alias', None),
                             ('host_address', None),
                             ('host_group_memberlist', None),
                             ('host_parents', None),
                             ('host_childs', None),
                             ('host_icons', None),
                             ('host_state', None),
                             ('host_plugin_output', None),
                             ('host_perf_data', None),
                             ('host_attempt', None),
                             ('host_check_type', None),
                             ('host_state_age', None),
                             ('host_check_age', None),
                             ('host_next_check', None),
                             ('host_next_notification', None),
                             ('host_last_notification', None),
                             ('host_check_latency', None),
                             ('host_check_duration', None),
                             ('host_in_downtime', None),
                             ('host_in_notifper', None),
                             ('host_notifper', None),
                             ('num_services', None),
                             ('num_services_ok', 'host_ok'),
                             ('num_services_warn', 'host_warn'),
                             ('num_services_crit', 'host_crit'),
                             ('num_services_unknown', 'host_unknown'),
                             ('num_services_pending', 'host_pending'),
                             ('host_custom_notes', None),
                             ('host_pnpgraph', None),
                             ],
                'public': True,
                'show_filters': [],
                'sorters': [],
                'linktitle': 'Host status',
                'title': 'Status of Host'},
'pendingsvc': {'browser_reload': 30,
                'column_headers': 'off',
                'datasource': 'services',
                'description': '',
                'group_painters': [('host', 'host')],
                'hard_filters': ['summary_host', 'svcstate'],
                'hard_filtervars': [('is_summary_host', '0'),
                                    ('st0', ''),
                                    ('st1', ''),
                                    ('st2', ''),
                                    ('st3', ''),
                                    ('stp', 'on')],
                'hidden': False,
                'hide_filters': [],
                'layout': 'boxed',
                'linktitle': 'Pending Services',
                'mustsearch': False,
                'name': 'pendingsvc',
                'num_columns': 5,
                'owner': '',
                'painters': [('service_description', 'service')],
                'play_sounds': False,
                'public': True,
                'show_filters': [],
                'sorters': [],
                'title': 'Pending Services',
                'topic': 'Problems'},
 'searchhost': {'browser_reload': 60,
                'column_headers': 'pergroup',
                'datasource': 'hosts',
                'description': 'A form for search hosts after a couple of criteria.',
                'group_painters': [('sitealias', None)],
                'hard_filters': [],
                'hard_filtervars': [('is_host_scheduled_downtime_depth',
                                     '-1'),
                                    ('is_host_in_notification_period', '-1'),
                                    ('hst0', 'on'),
                                    ('hst1', 'on'),
                                    ('hst2', 'on'),
                                    ('hstp', 'on'),
                                    ('site', ''),
                                    ('host', ''),
                                    ('is_summary_host', '-1'),
                                    ('opthostgroup', ''),
                                    ('host_check_command', ''),
                                    ],
                'hidden': False,
                'hide_filters': [],
                'layout': 'table',
                'mustsearch': True,
                'name': 'searchhost',
                'num_columns': 3,
                'owner': '',
                'painters': [('host_state', None),
                             ('host', 'host'),
                             ('host_icons', None),
                             ('num_services_ok', 'host_ok'),
                             ('num_services_warn', 'host_warn'),
                             ('num_services_crit', 'host_crit'),
                             ('num_services_unknown', 'host_unknown'),
                             ('num_services_pending', 'host_pending')],
                'play_sounds': True,
                'public': True,
                'show_filters': ['host_scheduled_downtime_depth',
                                 'host_in_notification_period',
                                 'hoststate',
                                 'siteopt',
                                 'hostregex',
                                 'summary_host',
                                 'opthostgroup',
                                 'host_check_command',
                                 ],
                'sorters': [],
                'title': 'Host search',
                'topic': 'Hosts'},
 'searchsvc': {'browser_reload': 60,
               'column_headers': 'pergroup',
               'datasource': 'services',
               'description': 'Almost all available filters, used for searching services and maybe doing actions',
               'group_painters': [('sitealias', 'sitehosts'),
                                  ('host', 'host')],
               'hard_filters': [],
               'hard_filtervars': [('is_service_in_notification_period',
                                    '-1'),
                                   ('optservicegroup', ''),
                                   ('is_service_notifications_enabled',
                                    '-1'),
                                   ('is_host_in_notification_period', '-1'),
                                   ('is_in_downtime', '-1'),
                                   ('is_service_scheduled_downtime_depth',
                                    '-1'),
                                   ('is_service_acknowledged', '-1'),
                                   ('host', ''),
                                   ('is_service_active_checks_enabled',
                                    '-1'),
                                   ('is_summary_host', '-1'),
                                   ('service', ''),
                                   ('check_command', ''),
                                   ('st0', 'on'),
                                   ('st1', 'on'),
                                   ('st2', 'on'),
                                   ('st3', 'on'),
                                   ('stp', 'on'),
                                   ('opthostgroup', ''),
                                   ('service_output', ''),
                                   ('is_service_is_flapping', '-1')],
               'hidden': False,
               'hide_filters': [],
               'layout': 'table',
               'mustsearch': True,
               'name': 'searchsvc',
               'num_columns': 1,
               'owner': '',
               'painters': [('service_state', None),
                            ('service_description', 'service'),
                            ('svc_plugin_output', None),
                            ('service_icons', None),
                            ('svc_state_age', None),
                            ('svc_check_age', None),
                            ('perfometer', None)],
               'play_sounds': False,
               'public': True,
               'show_filters': ['service_in_notification_period',
                                'optservicegroup',
                                'service_notifications_enabled',
                                'host_in_notification_period',
                                'in_downtime',
                                'service_scheduled_downtime_depth',
                                'service_acknowledged',
                                'hostregex',
                                'service_active_checks_enabled',
                                'summary_host',
                                'serviceregex',
                                'check_command',
                                'svcstate',
                                'opthostgroup',
                                'output',
                                'service_is_flapping',
                                'svc_last_state_change',
                                'svc_last_check'],
               'sorters': [('site', False),
                           ('site_host', False),
                           ('svcdescr', False)],
               'title': 'Service search',
               'topic': 'Services'},
 'service': {'browser_reload': 30,
               'column_headers': 'pergroup',
             'datasource': 'services',
             'description': 'Status of a single service, to be used for linking',
             'group_painters': [],
             'hard_filters': [],
             'hard_filtervars': [],
             'hidden': True,
             'hide_filters': ['site', 'service', 'host'],
             'layout': 'dataset',
             'mustsearch': False,
             'name': 'service',
             'num_columns': 1,
             'owner': '',
             'painters': [('sitealias', None),
                          ('host', 'hoststatus'),
                          ('service_description', 'servicedesc'),
                          ('svc_group_memberlist', None),
                          ('service_icons', None),
                          ('service_state', None),
                          ('svc_plugin_output', None),
                          ('svc_long_plugin_output', None),
                          ('svc_perf_data', None),
                          ('svc_check_command', None),
                          ('svc_attempt', None),
                          ('svc_check_type', None),
                          ('svc_state_age', None),
                          ('svc_check_age', None),
                          ('svc_next_check', None),
                          ('svc_next_notification', None),
                          ('svc_last_notification', None),
                          ('svc_check_latency', None),
                          ('svc_check_duration', None),
                          ('svc_in_downtime', None),
                          ('svc_in_notifper', None),
                          ('svc_notifper', None),
			  ('check_manpage', None),
                          ('svc_custom_notes', None),
                          ('svc_pnpgraph', None),
                          ],
             'public': True,
             'show_filters': [],
             'sorters': [],
             'linktitle': 'Details',
             'title': 'Service'},
 'servicedesc': {'browser_reload': 30,
               'column_headers': 'off',
                 'datasource': 'services',
                 'description': 'All Services with\r\na certain description\r\n',
                 'group_painters': [('service_description', 'servicedesc')],
                 'hard_filters': [],
                 'hard_filtervars': [('host', ''),
                                     ('st0', 'on'),
                                     ('st1', 'on'),
                                     ('st2', 'on'),
                                     ('st3', 'on'),
                                     ('stp', 'on'),
                                     ('opthostgroup', '')],
                 'hidden': True,
                 'hide_filters': ['service'],
                 'layout': 'table',
                 'mustsearch': False,
                 'name': 'servicedesc',
                 'num_columns': 2,
                 'owner': '',
                 'painters': [('service_state', None),
                              ('host', 'host'),
                              ('svc_plugin_output', None),
                              ('perfometer', None)],
                 'public': True,
                 'show_filters': ['hostregex', 'svcstate', 'opthostgroup'],
                 'sorters': [('site', False),
                             ('site_host', False)],
                 'linktitle': 'Same serv. on all hosts',
                 'title': 'All Services with this description:'},
'servicedescpnp': {'browser_reload': 90,
                    'column_headers': 'off',
                    'datasource': 'services',
                    'description': 'PNP graphs for all Services with\r\na certain description\r\n',
                    'group_painters': [('host', 'hostpnp')],
                    'hard_filters': [],
                    'hard_filtervars': [('host', ''),
                                        ('st0', 'on'),
                                        ('st1', 'on'),
                                        ('st2', 'on'),
                                        ('st3', 'on'),
                                        ('stp', 'on'),
                                        ('opthostgroup', ''),
                                        ('neg_opthostgroup', '')],
                    'hidden': True,
                    'hide_filters': ['service'],
                    'layout': 'boxed',
                    'linktitle': 'Same serv. PNP Graph',
                    'mustsearch': False,
                    'name': 'servicedescpnp',
                    'num_columns': 2,
                    'owner': 'admin',
                    'painters': [('svc_pnpgraph', None)],
                    'play_sounds': False,
                    'public': True,
                    'show_filters': ['hostregex', 'svcstate', 'opthostgroup'],
                    'sorters': [('svcstate', False),
                                ('site', False),
                                ('site_host', False)],
                    'title': 'PNP Graphs of services with description:',
                    'topic': 'Other'},
 'servicegroup': {'browser_reload': 30,
                  'column_headers': 'pergroup',
                  'datasource': 'services',
                  'description': '',
                  'group_painters': [('sitealias', 'sitehosts'),
                                     ('host', 'host')],
                  'hard_filters': [],
                  'hard_filtervars': [],
                  'hidden': True,
                  'hide_filters': ['servicegroup'],
                  'layout': 'table',
                  'linktitle': 'Servicegroup',
                  'mustsearch': False,
                  'name': 'servicegroup',
                  'num_columns': 1,
                  'owner': '',
                  'painters': [('service_state', None),
                               ('svc_state_age', None),
                               ('service_description', 'service'),
                               ('svc_plugin_output', None),
                               ('perfometer', None)],
                  'play_sounds': False,
                  'public': True,
                  'show_filters': [],
                  'sorters': [],
                  'title': 'Servicegroup',
                  'topic': 'Other'},
 'sitehosts': {'browser_reload': 30,
               'column_headers': 'off',
               'datasource': 'hosts',
               'description': 'Link view showing all\r\nhosts of one site',
               'group_painters': [('site_icon', None), ('sitealias', 'sitesvcs')],
               'hard_filters': ['summary_host'],
               'hard_filtervars': [
                                    ('is_summary_host', '0'),],
               'hidden': True,
               'hide_filters': ['site'],
               'layout': 'boxed',
               'mustsearch': False,
               'name': 'sitehosts',
               'num_columns': 2,
               'owner': '',
               'painters': [('host_state', None),
                            ('host', 'host'),
                            ('host_icons', None),
                            ('alias', 'hoststatus'),
                            ('num_services_ok', 'host_ok'),
                            ('num_services_warn', 'host_warn'),
                            ('num_services_unknown', 'host_unknown'),
                            ('num_services_crit', 'host_crit'),
                            ('num_services_pending', 'host_pending')],
               'public': True,
               'show_filters': [],
               'sorters': [('site', False), ('site_host', False)],
               'linktitle': 'Complete site',
               'title': 'All hosts of site'},
 'svcbygroups': {'browser_reload': 30,
               'column_headers': 'pergroup',
                 'datasource': 'servicesbygroup',
                 'description': 'Service grouped by service groups. Services not member of a group are not displayed. Services being in more groups, are displayed once for each group',
                 'group_painters': [('sg_alias', 'servicegroup')],
                 'hard_filters': [],
                 'hard_filtervars': [],
                 'hidden': False,
                 'hide_filters': [],
                 'layout': 'table',
                 'mustsearch': False,
                 'name': 'svcbygroups',
                 'num_columns': 1,
                 'owner': '',
                 'painters': [('host', 'host'),
                              ('service_state', None),
                              ('service_description', 'service'),
                              ('svc_plugin_output', None),
                              ('svc_state_age', None),
                              ('svc_check_age', None),
                              ('service_icons', None)],
                 'public': True,
                 'show_filters': [],
                 'sorters': [('servicegroup', False),
                             ('site_host', False),
                             ('svcdescr', False)],
                 'title': 'Services by group',
                 'topic': 'Servicegroups'},
 'svcbyhgroups': {'browser_reload': 30,
               'column_headers': 'pergroup',
                  'datasource': 'servicesbyhostgroup',
                  'description': 'Service grouped by host groups. Services not member of a host group are not displayed. Services being in more groups, are displayed once for each group',
                  'group_painters': [('hg_alias', 'hostgroup')],
                  'hard_filters': [],
                  'hard_filtervars': [],
                  'hidden': False,
                  'hide_filters': [],
                  'layout': 'boxed',
                  'mustsearch': False,
                  'name': 'svcbyhgroups',
                  'num_columns': 2,
                  'owner': '',
                  'painters': [('host', 'host'),
                               ('service_state', None),
                               ('svc_state_age', None),
                               ('service_description', None),
                               ('service_icons', None),
                               ('svc_plugin_output', None)],
                  'public': True,
                  'show_filters': [],
                  'sorters': [('hostgroup', False),
                              ('site_host', False),
                              ('svcdescr', False)],
                  'title': 'Serv. by host groups',
                  'topic': 'Services'},
 'svcgroups': {'browser_reload': 30,
               'column_headers': 'pergroup',
               'datasource': 'servicegroups',
               'description': 'A short overview over all servicegroups, without explicity listing of the actual hosts and services',
               'group_painters': [('sitealias', 'sitehosts')],
               'hard_filters': [],
               'hard_filtervars': [],
               'hidden': False,
               'hide_filters': [],
               'layout': 'boxed',
               'mustsearch': False,
               'name': 'svcgroups',
               'num_columns': 3,
               'owner': '',
               'painters': [('sg_name', 'servicegroup'),
                            ('sg_alias', None),
                            ('sg_num_services_ok', None),
                            ('sg_num_services_warn', None),
                            ('sg_num_services_crit', None),
                            ('sg_num_services_unknown', None),
                            ('sg_num_services_pending', None)],
               'public': True,
               'show_filters': [],
               'sorters': [],
               'title': 'Servicegroups (Summary)',
                  'topic': 'Servicegroups'},
 'svcgroups_grid': {'browser_reload': 30,
               'column_headers': 'pergroup',
                    'datasource': 'servicegroups',
                    'description': 'A short overview over all servicegroups, without explicity listing of the actual hosts and services',
                    'group_painters': [('sitealias', 'sitehosts')],
                    'hard_filters': [],
                    'hard_filtervars': [],
                    'hidden': False,
                    'hide_filters': [],
                    'layout': 'boxed',
                    'mustsearch': False,
                    'name': 'svcgroups_grid',
                    'num_columns': 3,
                    'owner': '',
                    'painters': [('sg_name', 'servicegroup'),
                                 ('sg_alias', None),
                                 ('sg_services', None)],
                    'public': True,
                    'show_filters': [],
                    'sorters': [],
                    'title': 'Servicegroups (Grid)',
                  'topic': 'Servicegroups'},
 'svcproblems': {'browser_reload': 30,
               'browser_reload': 30,
                 'column_headers': 'pergroup',
                 'datasource': 'services',
                 'description': 'All problems of services not currently in a downtime.',
                 'group_painters': [('service_state', None)],
                 'hard_filters': ['summary_host', 'in_downtime'],
                 'hard_filtervars': [('is_service_in_notification_period', '-1'),
                                     ('is_in_downtime', '0'),
                                     ('is_service_acknowledged', '-1'),
                                     ('st0', ''),
                                     ('st1', 'on'),
                                     ('st2', 'on'),
                                     ('st3', 'on'),
                                     ('stp', ''),
                                     ('hst0', 'on'),
                                     ('hst1', ''),
                                     ('hst2', ''),
                                     ('hstp', 'on'),
                                     ('is_summary_host', '0')],
                 'hidden': False,
                 'hide_filters': [],
                 'layout': 'table',
                 'mustsearch': False,
                 'name': 'svcproblems',
                 'num_columns': 1,
                 'owner': '',
                 'painters': [('host', 'host'),
                              ('service_description', 'service'),
                              ('svc_plugin_output', None),
                              ('svc_state_age', None),
                              ('svc_check_age', None),
                              ('service_icons', None),
                              ('perfometer', None)],
                 'play_sounds': True,
                 'public': True,
                 'show_filters': ['service_in_notification_period',
                                  'service_acknowledged',
                                  'svcstate',
                                  'hoststate'],
                 'sorters': [('svcstate', True),
                             ('stateage', False),
                             ('svcdescr', False)],
                 'title': 'Service problems',
                  'topic': 'Problems'},
 'hosttiles': {'browser_reload': 30,
               'column_headers': 'off',
               'datasource': 'hostsbygroup',
               'description': '',
               'group_painters': [('hg_name', 'hostgroup'),
                                  ('hg_alias', None)],
               'hard_filters': ['summary_host'],
               'hard_filtervars': [('is_summary_host', '0')],
               'hidden': False,
               'hide_filters': [],
               'layout': 'tiled',
               'mustsearch': False,
               'name': 'hosttiles',
               'num_columns': 1,
               'owner': '',
               'painters': [('host', 'hoststatus'),
                            ('host_address', None),
                            ('host_icons', None),
                            ('num_services', 'host'),
                            ('num_problems', 'problemsofhost'),
                            ('host_state', None)],
               'play_sounds': False,
               'public': True,
               'show_filters': [],
               'sorters': [],
               'title': 'All hosts (tiled)',
               'topic': 'Hosts'},
 'searchpnp': {'browser_reload': 90,
               'column_headers': 'off',
               'datasource': 'services',
               'description': 'Search for services and display PNP graphs',
               'group_painters': [('sitealias', 'sitehosts'),
                                  ('host', 'host'),
                                  ('service_description', 'service'),
                                  ('svc_plugin_output', None)],
               'hard_filters': ['service_process_performance_data',
                                'has_performance_data',
                                'summary_host'],
               'hard_filtervars': [('is_service_in_notification_period',
                                    '-1'),
                                   ('is_service_process_performance_data',
                                    '1'),
                                   ('optservicegroup', ''),
                                   ('is_service_notifications_enabled',
                                    '-1'),
                                   ('is_host_in_notification_period', '-1'),
                                   ('is_has_performance_data', '1'),
                                   ('is_service_scheduled_downtime_depth',
                                    '-1'),
                                   ('is_service_acknowledged', '-1'),
                                   ('host', ''),
                                   ('is_service_active_checks_enabled',
                                    '-1'),
                                   ('is_summary_host', '0'),
                                   ('service', ''),
                                   ('check_command', ''),
                                   ('st0', 'on'),
                                   ('st1', 'on'),
                                   ('st2', 'on'),
                                   ('st3', 'on'),
                                   ('stp', ''),
                                   ('opthostgroup', ''),
                                   ('is_in_downtime', '-1'),
                                   ('service_output', ''),
                                   ('is_service_is_flapping', '-1')],
               'hidden': False,
               'hide_filters': [],
               'layout': 'boxed',
               'mustsearch': True,
               'name': 'searchpnp',
               'num_columns': 2,
               'owner': '',
               'painters': [('svc_pnpgraph', None)],
               'play_sounds': False,
               'public': False,
               'show_filters': ['service_in_notification_period',
                                'optservicegroup',
                                'service_notifications_enabled',
                                'host_in_notification_period',
                                'service_scheduled_downtime_depth',
                                'service_acknowledged',
                                'hostregex',
                                'service_active_checks_enabled',
                                'serviceregex',
                                'check_command',
                                'svcstate',
                                'opthostgroup',
                                'in_downtime',
                                'output',
                                'service_is_flapping'],
               'sorters': [('site', False),
                           ('site_host', False),
                           ('svcdescr', False)],
               'title': 'Search PNP graphs',
               'topic': 'Addons'},
 'hostpnp': {'browser_reload': 90,
             'column_headers': 'off',
             'datasource': 'services',
             'description': 'All PNP performance graphs for a certain host.',
             'group_painters': [('sitealias', 'sitehosts'),
                                ('host', 'host'),
                                ('service_description', 'service'),
                                ('svc_plugin_output', None)],
             'hard_filters': ['service_process_performance_data',
                              'has_performance_data',
                              'svcstate'],
             'hard_filtervars': [('is_service_process_performance_data',
                                  '1'),
                                 ('is_has_performance_data', '1'),
                                 ('service', ''),
                                 ('check_command', ''),
                                 ('st0', 'on'),
                                 ('st1', 'on'),
                                 ('st2', 'on'),
                                 ('st3', 'on'),
                                 ('stp', '')],
             'hidden': True,
             'hide_filters': ['site', 'host'],
             'layout': 'boxed',
             'mustsearch': False,
             'name': 'hostpnp',
             'num_columns': 2,
             'owner': '',
             'painters': [('svc_pnpgraph', None)],
             'play_sounds': False,
             'public': False,
             'show_filters': ['serviceregex', 'check_command'],
             'sorters': [('site', False),
                         ('site_host', False),
                         ('svcdescr', False)],
             'linktitle': 'PNP graphs',
             'title': 'PNP graphs for host',
               'topic': 'PNP4Nagios'},
'recentsvc': {'browser_reload': 30,
               'column_headers': 'pergroup',
               'datasource': 'services',
               'description': 'Service whose state changed in the last\r\n60 minutes',
               'group_painters': [],
               'hard_filters': ['summary_host'],
               'hard_filtervars': [('svc_last_state_change', 'since'),
                                   ('svc_last_state_change_sec', '0'),
                                   ('svc_last_state_change_min', '60'),
                                   ('svc_last_state_change_hours', '0'),
                                   ('svc_last_state_change_days', '0'),
                                   ('is_summary_host', '0'),
                                   ('st0', 'on'),
                                   ('st1', 'on'),
                                   ('st2', 'on'),
                                   ('st3', 'on'),
                                   ('stp', '')],
               'hidden': False,
               'hide_filters': [],
               'layout': 'table',
               'linktitle': 'Change ago:',
               'mustsearch': False,
               'name': 'svcrecent',
               'num_columns': 1,
               'owner': '',
               'painters': [('host', 'host'),
                            ('service_state', None),
                            ('service_description', 'service'),
                            ('svc_plugin_output', None),
                            ('service_icons', None),
                            ('svc_state_age', None),
                            ('svc_check_age', None)],
               'play_sounds': False,
               'public': True,
               'show_filters': ['svc_last_state_change', 'svcstate'],
               'sorters': [('stateage', True)],
               'title': 'Recently changed services',
               'topic': 'Services'},
 'uncheckedsvc': {'browser_reload': 30,
                  'column_headers': 'pergroup',
                  'datasource': 'services',
                  'description': 'Services that have not been checked within the last 24 hours (pending services excluded).',
                  'group_painters': [('host', 'host')],
                  'hard_filters': ['summary_host'],
                  'hard_filtervars': [('svc_last_check', 'before'),
                                      ('svc_last_check_sec', '0'),
                                      ('svc_last_check_min', '0'),
                                      ('svc_last_check_hours', '0'),
                                      ('svc_last_check_days', '1'),
                                      ('is_summary_host', '0'),
                                      ('st0', 'on'),
                                      ('st1', 'on'),
                                      ('st2', 'on'),
                                      ('st3', 'on'),
                                      ('stp', '')],
                  'hidden': False,
                  'hide_filters': [],
                  'layout': 'table',
                  'linktitle': 'Unchecked services',
                  'mustsearch': False,
                  'name': 'uncheckedsvc',
                  'num_columns': 1,
                  'owner': '',
                  'painters': [('service_state', None),
                               ('service_description', 'service'),
                               ('svc_plugin_output', None),
                               ('service_icons', None),
                               ('svc_state_age', None),
                               ('svc_check_age', None)],
                  'play_sounds': False,
                  'public': True,
                  'show_filters': ['svc_last_check', 'svcstate'],
                  'sorters': [('site_host', False), ('svcdescr', False)],
                  'title': 'Unchecked services',
                  'topic': 'Problems'},
'events': {'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'log_events',
            'description': 'All historic events of hosts or services (alerts, downtimes, etc.)',
            'group_painters': [('log_date', None)],
            'hard_filters': [],
            'hard_filtervars': [('host', ''),
                                ('service', ''),
                                ('logtime', 'since'),
                                ('logtime_sec', '0'),
                                ('logtime_min', '0'),
                                ('logtime_hours', '0'),
                                ('logtime_days', '7'),
                                ('log_plugin_output', '')],
            'hidden': False,
            'hide_filters': [],
            'layout': 'table',
            'linktitle': 'Events',
            'mustsearch': False,
            'name': 'events',
            'num_columns': 1,
            'owner': 'admin',
            'painters': [('log_icon', None),
                         ('log_time', None),
                         ('log_type', None),
                         ('host', 'hostsvcevents'),
                         ('service_description', 'svcevents'),
                         ('log_state_type', None),
                         ('log_plugin_output', None)],
            'play_sounds': False,
            'public': True,
            'show_filters': ['hostregex',
                             'serviceregex',
                             'logtime',
                             'log_plugin_output'],
            'sorters': [],
            'title': 'Host- and Service events',
            'topic': 'Other'},
'hostevents': {'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'log_host_events',
            'description': 'All historic events concerning the state of a certain host (without services)',
            'group_painters': [('log_date', None)],
            'hard_filters': [],
            'hard_filtervars': [('logtime', 'since'),
                                ('logtime_sec', '0'),
                                ('logtime_min', '0'),
                                ('logtime_hours', '0'),
                                ('logtime_days', '31')],
            'hidden': True,
            'hide_filters': ['site', 'host'],
            'layout': 'table',
            'linktitle': 'Host history',
            'mustsearch': False,
            'name': 'events',
            'num_columns': 1,
            'owner': '',
            'painters': [('log_icon', None),
                         ('log_time', None),
                         ('log_type', None),
                         ('service_description', 'svcevents'),
                         ('log_state_type', None),
                         ('log_plugin_output', None),
                             ],
            'play_sounds': False,
            'public': True,
            'show_filters': ['logtime'],
            'sorters': [],
            'title': 'Events of host'},
'svcevents': {'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'log_events',
            'description': 'All historic events concerning the state of a certain service',
            'group_painters': [('log_date', None)],
            'hard_filters': [],
            'hard_filtervars': [('logtime', 'since'),
                                ('logtime_sec', '0'),
                                ('logtime_min', '0'),
                                ('logtime_hours', '0'),
                                ('logtime_days', '31')],
            'hidden': True,
            'hide_filters': ['site', 'host', 'service'],
            'layout': 'table',
            'linktitle': 'History',
            'mustsearch': False,
            'name': 'events',
            'num_columns': 1,
            'owner': '',
            'painters': [('log_icon', None),
                         ('log_time', None),
                         ('log_type', None),
                         ('log_state_type', None),
                         ('log_plugin_output', None),
                             ],
            'play_sounds': False,
            'public': True,
            'show_filters': ['logtime'],
            'sorters': [],
            'title': 'Events of service'},
'hostsvcevents': {'browser_reload': 0,
            'column_headers': 'pergroup',
            'datasource': 'log_events',
            'description': 'All historic events concerning the state of a certain host (including services)',
            'group_painters': [('log_date', None)],
            'hard_filters': [],
            'hard_filtervars': [('logtime', 'since'),
                                ('logtime_sec', '0'),
                                ('logtime_min', '0'),
                                ('logtime_hours', '0'),
                                ('logtime_days', '31')],
            'hidden': True,
            'hide_filters': ['site', 'host'],
            'layout': 'table',
            'linktitle': 'Host & service history',
            'mustsearch': False,
            'name': 'events',
            'num_columns': 1,
            'owner': '',
            'painters': [('log_icon', None),
                         ('log_time', None),
                         ('log_type', None),
                         ('host', 'hostsvcevents'),
                         ('service_description', 'svcevents'),
                         ('log_state_type', None),
                         ('log_plugin_output', None),
                             ],
            'play_sounds': False,
            'public': True,
            'show_filters': ['logtime'],
            'sorters': [],
            'title': 'Events of host & services'},
  'logfile': {'browser_reload': 0,
             'column_headers': 'off',
             'datasource': 'log',
             'description': '',
             'group_painters': [('log_date', None)],
             'hard_filters': [],
             'hard_filtervars': [('optservicegroup', ''),
                                 ('neg_optservicegroup', ''),
                                 ('site', ''),
                                 ('logclass0', 'on'),
                                 ('logclass1', 'on'),
                                 ('logclass2', 'on'),
                                 ('logclass3', 'on'),
                                 ('logclass4', ''),
                                 ('logclass5', 'on'),
                                 ('logclass6', ''),
                                 ('host', ''),
                                 ('service', ''),
                                 ('opthostgroup', ''),
                                 ('neg_opthostgroup', ''),
                                 ('logtime', 'since'),
                                 ('logtime_sec', '0'),
                                 ('logtime_min', '0'),
                                 ('logtime_hours', '0'),
                                 ('logtime_days', '7')],
             'hidden': False,
             'hide_filters': [],
             'layout': 'table',
             'linktitle': 'Search Global Logfile',
             'mustsearch': True,
             'name': 'logfile',
             'num_columns': 1,
             'owner': '',
             'painters': [('log_icon', None),
                          ('log_time', None),
                          ('log_type', None),
                          ('host', 'hostsvcevents'),
                          ('service_description', 'svcevents'),
                          ('log_state_type', None),
                          ('log_plugin_output', None)],
             'play_sounds': False,
             'public': True,
             'show_filters': ['optservicegroup',
                              'siteopt',
                              'log_class',
                              'hostregex',
                              'serviceregex',
                              'opthostgroup',
                              'logtime'],
             'sorters': [],
             'title': 'Search Global Logfile',
             'topic': 'Other'},

 'sitesvcs': {'browser_reload': 60,
              'column_headers': 'pergroup',
              'datasource': 'services',
              'description': 'All services of a given site.',
              'group_painters': [('host_with_state', 'hoststatus')],
              'hard_filters': [],
              'hard_filtervars': [('optservicegroup', ''),
                                  ('neg_optservicegroup', ''),
                                  ('host', ''),
                                  ('service', ''),
                                  ('st0', 'on'),
                                  ('st1', 'on'),
                                  ('st2', 'on'),
                                  ('st3', 'on'),
                                  ('stp', 'on'),
                                  ('opthostgroup', ''),
                                  ('neg_opthostgroup', ''),
                                  ('host_check_command', ''),
                                  ('service_output', '')],
              'hidden': True,
              'hide_filters': ['site'],
              'layout': 'boxed',
              'linktitle': 'Services of Site',
              'mustsearch': False,
              'name': 'sitesvcs',
              'num_columns': 2,
              'owner': 'maintenance',
              'painters': [('service_state', None),
                           ('service_description', 'service'),
                           ('svc_plugin_output', None),
                           ('svc_state_age', None),
                           ('svc_check_age', None),
                           ('service_icons', None),
                           ('perfometer', None)],
              'play_sounds': False,
              'public': True,
              'show_filters': ['optservicegroup',
                               'hostregex',
                               'serviceregex',
                               'svcstate',
                               'opthostgroup',
                               'host_check_command',
                               'output'],
              'sorters': [('site_host', False), ('svcdescr', False)],
              'title': 'Services of Site',
              'topic': 'Services'},

'alertstats': {'browser_reload': 0,
                'column_headers': 'pergroup',
                'datasource': 'alert_stats',
                'description': '',
                'group_painters': [],
                'hard_filters': [],
                'hard_filtervars': [('optservicegroup', ''),
                                    ('neg_optservicegroup', ''),
                                    ('site', ''),
                                    ('host', ''),
                                    ('is_summary_host', '-1'),
                                    ('service', ''),
                                    ('check_command', ''),
                                    ('log_plugin_output', ''),
                                    ('opthostgroup', ''),
                                    ('neg_opthostgroup', ''),
                                    ('host_check_command', ''),
                                    ('logtime', 'since'),
                                    ('logtime_sec', '0'),
                                    ('logtime_min', '0'),
                                    ('logtime_hours', '0'),
                                    ('logtime_days', '30')],
                'hidden': False,
                'hide_filters': [],
                'hidebutton': False,
                'layout': 'boxed',
                'linktitle': 'Alerts',
                'mustsearch': False,
                'name': 'alertstats',
                'num_columns': 1,
                'owner': 'omdadmin',
                'painters': [('host', 'hostsvcevents'),
                             ('service_description', 'svcevents'),
                             ('alert_stats_crit', None),
                             ('alert_stats_unknown', None),
                             ('alert_stats_warn', None),
                             ('alert_stats_problem', None)],
                'play_sounds': False,
                'public': False,
                'show_filters': ['optservicegroup',
                                 'siteopt',
                                 'hostregex',
                                 'summary_host',
                                 'serviceregex',
                                 'check_command',
                                 'log_plugin_output',
                                 'opthostgroup',
                                 'host_check_command',
                                 'logtime'],
                'sorters': [('alerts_crit', True),
                            ('alerts_unknown', True),
                            ('alerts_warn', True),
                            ('site_host', False),
                            ('svcdescr', False)],
                'title': 'Alert Statistics',
                'topic': 'Problems'},

# Special views for NagStaMon
'nagstamon_hosts': {'browser_reload': 30,
                     'column_headers': 'pergroup',
                     'datasource': 'hosts',
                     'description': 'The view is intended for NagStaMon as web service.',
                     'group_painters': [('host_state', None)],
                     'hard_filters': ['summary_host'],
                     'hard_filtervars': [('is_host_scheduled_downtime_depth',
                                          '-1'),
                                         ('is_host_active_checks_enabled',
                                          '-1'),
                                         ('hst0', 'on'),
                                         ('hst1', 'on'),
                                         ('hst2', 'on'),
                                         ('hstp', 'on'),
                                         ('is_host_acknowledged', '-1'),
                                         ('is_host_notifications_enabled',
                                          '-1'),
                                         ('is_summary_host', '0')],
                     'hidden': True,
                     'hide_filters': [],
                     'hidebutton': True,
                     'layout': 'table',
                     'linktitle': 'Host problems for NagStaMon',
                     'mustsearch': False,
                     'name': 'nagstamon_hosts',
                     'num_columns': 1,
                     'owner': 'omdadmin',
                     'painters': [('host', 'hoststatus', ''),
                                  ('host_icons', None, ''),
                                  ('host_check_age', None, ''),
                                  ('host_state_age', None, ''),
                                  ('host_attempt', None, ''),
                                  ('host_state', None, ''),
                                  ('host_plugin_output', None, ''),
                                  ('host_in_downtime', None, ''),
                                  ('host_acknowledged', None, ''),
                                  ('host_address', None, ''),
                                  ('sitename_plain', None, '')],
                     'play_sounds': False,
                     'public': True,
                     'show_filters': ['host_scheduled_downtime_depth',
                                      'host_active_checks_enabled',
                                      'hoststate',
                                      'host_acknowledged',
                                      'host_notifications_enabled'],
                     'sorters': [],
                     'title': 'Host problems for NagStaMon',
                     'topic': 'NagStaMon'},
 'nagstamon_svc': {'browser_reload': 30,
                   'column_headers': 'pergroup',
                   'datasource': 'services',
                   'description': 'This view is intended for usage as web service for NagStaMon.',
                   'group_painters': [('service_state', None)],
                   'hard_filters': ['summary_host'],
                   'hard_filtervars': [('is_service_in_notification_period',
                                        '-1'),
                                       ('is_service_notifications_enabled',
                                        '-1'),
                                       ('hst0', 'on'),
                                       ('hst1', 'on'),
                                       ('hst2', 'on'),
                                       ('hstp', 'on'),
                                       ('is_service_acknowledged', '-1'),
                                       ('is_service_active_checks_enabled',
                                        '-1'),
                                       ('is_host_notifications_enabled',
                                        '-1'),
                                       ('is_summary_host', '0'),
                                       ('st0', ''),
                                       ('st1', 'on'),
                                       ('st2', 'on'),
                                       ('st3', 'on'),
                                       ('stp', ''),
                                       ('is_in_downtime', '-1')],
                   'hidden': True,
                   'hide_filters': [],
                   'hidebutton': True,
                   'layout': 'table',
                   'linktitle': 'Service problems for NagStaMon',
                   'mustsearch': False,
                   'name': 'nagstamon_svc',
                   'num_columns': 1,
                   'owner': 'omdadmin',
                   'painters': [('host', 'hoststatus', ''),
                                ('service_description', 'service', ''),
                                ('service_icons', None, ''),
                                ('service_state', None, ''),
                                ('svc_check_age', None, ''),
                                ('svc_state_age', None, ''),
                                ('svc_attempt', None, ''),
                                ('svc_plugin_output', None, ''),
                                ('svc_flapping', None, ''),
                                ('svc_notifications_enabled', None, ''),
                                ('svc_is_active', None, ''),
                                ('sitename_plain', None, ''),
                                ('host_address', None, ''),
                                ('svc_check_command', None, '')],
                   'play_sounds': True,
                   'public': True,
                   'show_filters': ['service_in_notification_period',
                                    'service_notifications_enabled',
                                    'hoststate',
                                    'service_acknowledged',
                                    'service_active_checks_enabled',
                                    'host_notifications_enabled',
                                    'svcstate',
                                    'in_downtime'],
                   'sorters': [('svcstate', True),
                               ('stateage', False),
                               ('svcdescr', False)],
                   'title': 'Service problems for NagStaMon',
                   'topic': 'NagStaMon'},
}
