import gtk
import gtk.glade
import os
import gobject

from lib.common import *

GLADE_FILE = os.path.join(GLADE_BASE_PATH, "accounts_properties_dialog.glade")
#GLADE_FILE = "../glade/accounts_properties_dialog.glade"


(
 ICON_COL,
 NAME_COL,
 ID_COL
) = range(3)

(
 TYPE_GMAIL,
 TYPE_POP3,
 TYPE_IMAP
) = range(3)

class AccountPropertiesDialog:
	def __init__(self):
		self.widgets = gtk.glade.XML(GLADE_FILE, domain = "cgmail")

		dict = {
			"on_imap_other_rb_toggled": self.on_imap_other_toggled,
			"on_use_custom_port_cb_toggled" : self.on_use_custom_port_toggled,
			"on_ssl_connection_toggled" : self.on_ssl_connection_toggled
		}

		self.widgets.signal_autoconnect(dict)
		self.dialog = self.widgets.get_widget("dialog")

		self.gmail_icon = gtk.gdk.pixbuf_new_from_file(GMAIL_ICON)
		self.pop3_icon = gtk.gdk.pixbuf_new_from_file(POP3_ICON)
		self.imap_icon = gtk.gdk.pixbuf_new_from_file(IMAP_ICON)
		#self.gmail_icon = gtk.gdk.pixbuf_new_from_file("../data/gmail.png")
		#self.pop3_icon = gtk.gdk.pixbuf_new_from_file("../data/nomail.png")

		self.notebook = self.widgets.get_widget("notebook")
		
		self.typebox_liststore = gtk.ListStore( gtk.gdk.Pixbuf,
				gobject.TYPE_STRING, gobject.TYPE_INT)
		self.typebox_liststore.append([self.gmail_icon, _("gmail"),
									TYPE_GMAIL])
		self.typebox_liststore.append([self.pop3_icon, _("pop3"),
									TYPE_POP3])
		self.typebox_liststore.append([self.imap_icon, _("imap"),
									TYPE_IMAP])



		self.typebox = self.widgets.get_widget("type_box")
		self.typebox.set_model(self.typebox_liststore)

		self.type_pixcell = gtk.CellRendererPixbuf()
		self.type_textcell = gtk.CellRendererText()
		self.typebox.pack_start(self.type_pixcell, True)
		self.typebox.pack_end(self.type_textcell, True)
		self.type_pixcell.set_property( 'xalign', 0.0 )

		self.typebox.add_attribute(self.type_pixcell, 'pixbuf', 0)
		self.typebox.add_attribute(self.type_textcell, 'text', 1)

		self.typebox.set_active(TYPE_GMAIL)
		self.typebox.connect("changed", self.on_typebox_changed)

		self.conn_settings_frame = self.widgets.get_widget("conn_settings_frame")
		self.conn_type_frame = self.widgets.get_widget("conn_type_frame")
		self.imap_mbox_frame = self.widgets.get_widget("imap_mbox_frame")

		self.conn_settings_frame.hide()
		self.conn_type_frame.hide()
		self.imap_mbox_frame.hide()
		self.dialog.resize(400, 300)

		self.account_enabled_cb = self.widgets.get_widget("account_enabled_cb")
			
		self.user_entry = self.widgets.get_widget("user_entry")
		self.passw_entry = self.widgets.get_widget("password_entry")
		self.server_entry = self.widgets.get_widget("server_entry")
		self.use_custom_port_cb = self.widgets.get_widget("use_custom_port_cb")
		self.port_spin = self.widgets.get_widget("port_spin")
		self.standard_connection = self.widgets.get_widget("standard_connection")
		self.ssl_connection = self.widgets.get_widget("ssl_connection")
		self.imap_default_rb = self.widgets.get_widget("imap_default_rb")
		self.imap_other_rb = self.widgets.get_widget("imap_other_rb")
		self.imap_mbox_entry = self.widgets.get_widget("imap_mbox_entry")

		self.imap_mbox_entry.set_sensitive(False)
		
	
	def fill(self, amanager, id = None):

		self.amanager = amanager
		self.account_id = id
		
		if self.account_id is not None:
			info = {}
			try:
				dic = self.amanager.get_accounts_dicts()
			except:
				print "accpropdialog.py: Error retriving configuration"
				self.dialog.destroy()
				return
			for account in dic:
				if account["id"] == self.account_id:
					info = account
					break
			if info["type"] == "gmail":
				self.typebox.set_active(TYPE_GMAIL)
			elif info["type"] == "pop3":
				self.typebox.set_active(TYPE_POP3)
			elif info["type"] == "imap":
				self.typebox.set_active(TYPE_IMAP)

			enabled = info["enabled"]
			if enabled == "1":
				self.account_enabled_cb.set_active(True)
			else:
				self.account_enabled_cb.set_active(False)
	
			self.user_entry.set_text(info["username"])
			self.passw_entry.set_text(info["password"])
			if info["type"] != "gmail":
				self.server_entry.set_text(info["server"])
				self.port_spin.set_value(int(info["port"]))
				
				if info["ssl"] == "0":
					self.standard_connection.set_active(True)
				else:
					self.ssl_connection.set_active(True)
				if info["type"] == "imap":
					if info["use_default_mbox"] == "1":
						self.imap_default_rb.set_active(True)
						self.imap_mbox_entry.set_sensitive(False)
					else:
						self.imap_other_rb.set_active(True)
						self.imap_mbox_entry.set_sensitive(True)
						self.imap_mbox.set_text(info["mbox"])
			
			if self.port_is_standard():
				self.use_custom_port_cb.set_active(False)
			else:
				self.use_custom_port_cb.set_active(True)


	
	def port_is_standard(self):
		type = None
		try:
			model = self.typebox.get_model()
			iter = self.typebox.get_active_iter()
			type = model.get_value(iter, 1)
		except:
			pass
		
		port = str(self.port_spin.get_value_as_int())
		ssl = "0"
		if self.ssl_connection.get_active():
			ssl = "1"


		if port == "110" and type == "pop3" and  ssl == "0": return True
		if port == "995" and type == "pop3" and  ssl == "1": return True
		if port == "143" and type == "imap" and ssl == "0": return True
		if port == "993" and type == "imap" and ssl == "1": return True
		return False
	
	def enable_disable_widg(self, type):
		if type == "pop3":
			self.conn_settings_frame.show()
			self.conn_type_frame.show()
			self.imap_mbox_frame.hide()
			self.port_spin.set_value(110) # pop3 default port
			self.dialog.resize(400, 500)
		elif type == "gmail":
			self.conn_settings_frame.hide()
			self.conn_type_frame.hide()
			self.imap_mbox_frame.hide()
			self.dialog.resize(400, 300)
		elif type == "imap":
			self.conn_settings_frame.show()
			self.conn_type_frame.show()
			self.port_spin.set_value(143) # imap default port
			self.imap_mbox_frame.show()
			self.dialog.resize(400, 600)


	def run(self):
		result = self.dialog.run()
		
		# retrieve data from dialog
		uname = self.user_entry.get_text().strip()
		passw = self.passw_entry.get_text().strip()
		server = self.server_entry.get_text().strip()
		port = str(self.port_spin.get_value_as_int())
		ssl = "0"
		if self.ssl_connection.get_active():
			ssl = "1"
		
		account_enabled = "0"
		if self.account_enabled_cb.get_active():
			account_enabled = "1"

		imap_default = "1"
		imap_mbox = ""
		if self.imap_other_rb.get_active():
			imap_default = "0"
			imap_mbox = self.imap_mbox_entry.get_text()
		
		type = None
		try:
			model = self.typebox.get_model()
			iter = self.typebox.get_active_iter()
			type = model.get_value(iter, 1)
		except:
			pass

		if not self.use_custom_port_cb.get_active():
			if ssl == "1":
				if type == "pop3":
					port = "995"
				elif type == "imap":
					port = "993"
			else:
				if type == "pop3":
					port = "110"
				elif type == "imap":
					port = "143"


		
		dic = {}
		if result == gtk.RESPONSE_OK or \
			result == gtk.RESPONSE_APPLY:

			canstore = True

			if type == "gmail":
				if uname != "" and passw != "":
					dic = {
						"type" : "gmail",
						"username" : uname,
						"enabled" : account_enabled,
						"password" : passw
					}
				else:
					canstore = False
			elif type == "pop3" or type == "imap":
				if uname != "" and passw != "" \
						and server != "":
					dic = {
						"type" : type,
						"username" : uname,
						"password" : passw,
						"enabled" : account_enabled,
						"server": server,
						"ssl": ssl,
						"port" : port
					}
					if type == "imap":
						dic["use_default_mbox"] = imap_default
						dic["mbox"] = imap_mbox
				else:
					canstore = False
			else:
				canstore = False
				#print uname, passw, server, port, type, ssl

			# check for required entries
		
			if self.account_id is None and canstore:
				# this is a new account
				#print "adding account: ", dic
				self.account_id = self.amanager.add_account(dic)

				# must update checker

			elif canstore:
				# update an old account
				#self.amanager.remove_account(self.account_id)
				#self.account_id = self.amanager.add_account(dic)
				self.amanager.update_account(self.account_id, dic)
				#print "updating account: ", dic

				# must update checker

		if result == gtk.RESPONSE_OK or result == gtk.RESPONSE_CANCEL:
			self.dialog.destroy()

		elif result == gtk.RESPONSE_APPLY:
			self.run()
		
		# no response. Close button clicked on the dialog window
		self.dialog.destroy()
	
	def on_use_custom_port_toggled(self,w):
		if w.get_active():
			self.port_spin.set_sensitive(True)
		else:
			self.port_spin.set_sensitive(False)	

	def on_ssl_connection_toggled(self, w):

		model = self.typebox.get_model()
		iter = self.typebox.get_active_iter()
		type = model.get_value(iter, 1)

		if w.get_active():
			if type == "pop3":
				self.port_spin.set_value(995)
			elif type == "imap":
				self.port_spin.set_value(993)
		else:
			if type == "pop3":
				self.port_spin.set_value(110)
			elif type == "imap":
				self.port_spin.set_value(143)
	
	def on_imap_other_toggled(self, w):
		if w.get_active():
			self.imap_mbox_entry.set_sensitive(True)
		else:
			self.imap_mbox_entry.set_sensitive(False)

	def on_typebox_changed(self, arg):
		type = None
		try:
			model = self.typebox.get_model()
			iter = self.typebox.get_active_iter()
			type = model.get_value(iter, 1)
			self.enable_disable_widg(type)
		except:
			print "notype error"
			pass

		if self.port_is_standard():
			self.use_custom_port_cb.set_active(False)
		else:
			self.use_custom_port_cb.set_active(True)
	

if __name__ == "__main__":
	from accountmanager import AccountManager
	a = AccountManager().get_manager()
	AccountPropertiesDialog(a).run()
	gtk.main()

