// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "ComponentArea.pypp.hpp"

namespace bp = boost::python;

void register_ComponentArea_class(){

    { //::CEGUI::ComponentArea
        typedef bp::class_< CEGUI::ComponentArea > ComponentArea_exposer_t;
        ComponentArea_exposer_t ComponentArea_exposer = ComponentArea_exposer_t( "ComponentArea", "*!\n\
            \n\
                Class that represents a target area for a widget or imagery component.\n\
        \n\
                This is essentially a Rect built out of Dimension objects.  Of note is that\n\
                what would normally be the 'right' and 'bottom' edges may alternatively\n\
                represent width and height depending upon what the assigned Dimension(s)\n\
                represent.\n\
            *\n" );
        bp::scope ComponentArea_scope( ComponentArea_exposer );
        { //::CEGUI::ComponentArea::getAreaPropertySource
        
            typedef ::CEGUI::String const & ( ::CEGUI::ComponentArea::*getAreaPropertySource_function_type )(  ) const;
            
            ComponentArea_exposer.def( 
                "getAreaPropertySource"
                , getAreaPropertySource_function_type( &::CEGUI::ComponentArea::getAreaPropertySource )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                    \n\
                        Return the name of the property that will be used to determine the pixel area for this\
                        ComponentArea.\n\
            \n\
                    @return\n\
                        String object holding the name of a Propery.\n\
                    *\n" );
        
        }
        { //::CEGUI::ComponentArea::getPixelRect
        
            typedef ::CEGUI::Rect ( ::CEGUI::ComponentArea::*getPixelRect_function_type )( ::CEGUI::Window const & ) const;
            
            ComponentArea_exposer.def( 
                "getPixelRect"
                , getPixelRect_function_type( &::CEGUI::ComponentArea::getPixelRect )
                , ( bp::arg("wnd") )
                , "*!\n\
                    \n\
                        Return a Rect describing the absolute pixel area represented by this ComponentArea.\n\
            \n\
                    @param wnd\n\
                        Window object to be used when calculating final pixel area.\n\
            \n\
                    @return\n\
                        Rect object describing the pixels area represented by this ComponentArea when using\
                        wnd\n\
                        as a reference for calculating the final pixel dimensions.\n\
                    *\n" );
        
        }
        { //::CEGUI::ComponentArea::getPixelRect
        
            typedef ::CEGUI::Rect ( ::CEGUI::ComponentArea::*getPixelRect_function_type )( ::CEGUI::Window const &,::CEGUI::Rect const & ) const;
            
            ComponentArea_exposer.def( 
                "getPixelRect"
                , getPixelRect_function_type( &::CEGUI::ComponentArea::getPixelRect )
                , ( bp::arg("wnd"), bp::arg("container") )
                , "*!\n\
                    \n\
                        Return a Rect describing the absolute pixel area represented by this ComponentArea.\n\
            \n\
                    @param wnd\n\
                        Window object to be used when calculating final pixel area.\n\
            \n\
                    @param container\n\
                        Rect object to be used as a base or container when converting relative dimensions.\n\
            \n\
                    @return\n\
                        Rect object describing the pixels area represented by this ComponentArea when using\
                        wnd\n\
                        and  container as a reference for calculating the final pixel dimensions.\n\
                    *\n" );
        
        }
        { //::CEGUI::ComponentArea::isAreaFetchedFromProperty
        
            typedef bool ( ::CEGUI::ComponentArea::*isAreaFetchedFromProperty_function_type )(  ) const;
            
            ComponentArea_exposer.def( 
                "isAreaFetchedFromProperty"
                , isAreaFetchedFromProperty_function_type( &::CEGUI::ComponentArea::isAreaFetchedFromProperty )
                , "*!\n\
                    \n\
                        Return whether this ComponentArea fetches it's area via a property on the target\
                        window.\n\
            \n\
                    @return\n\
                        - true if the area comes via a Propery.\n\
                        - false if the area is defined explicitly via the Dimension fields.\n\
                    *\n" );
        
        }
        { //::CEGUI::ComponentArea::setAreaPropertySource
        
            typedef void ( ::CEGUI::ComponentArea::*setAreaPropertySource_function_type )( ::CEGUI::String const & ) ;
            
            ComponentArea_exposer.def( 
                "setAreaPropertySource"
                , setAreaPropertySource_function_type( &::CEGUI::ComponentArea::setAreaPropertySource )
                , ( bp::arg("property") )
                , "*!\n\
                    \n\
                        Set the name of the property that will be used to determine the pixel area for this\
                        ComponentArea.\n\
            \n\
                    @param property\n\
                        String object holding the name of a Propery.  The property should access a URect type\
                        property.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::ComponentArea::writeXMLToStream
        
            typedef void ( ::CEGUI::ComponentArea::*writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            ComponentArea_exposer.def( 
                "writeXMLToStream"
                , writeXMLToStream_function_type( &::CEGUI::ComponentArea::writeXMLToStream )
                , ( bp::arg("xml_stream") )
                , "*!\n\
                    \n\
                        Writes an xml representation of this ComponentArea to  out_stream.\n\
            \n\
                    @param xml_stream\n\
                        Stream where xml data should be output.\n\
            \n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        ComponentArea_exposer.def_readwrite( "d_bottom_or_height", &CEGUI::ComponentArea::d_bottom_or_height );
        ComponentArea_exposer.def_readwrite( "d_left", &CEGUI::ComponentArea::d_left );
        ComponentArea_exposer.def_readwrite( "d_right_or_width", &CEGUI::ComponentArea::d_right_or_width );
        ComponentArea_exposer.def_readwrite( "d_top", &CEGUI::ComponentArea::d_top );
    }

}
