#ifndef H_CDW_NCURSES
#define H_CDW_NCURSES

#include <stddef.h>

#include "config.h"

/* Some systems put ncurses headers in /usr/include, and somehow Autotools
   can't see them there; see Sourceforge for a feature request in cdw:
   http://sourceforge.net/tracker/?func=detail&aid=3249439&group_id=47851&atid=451094

   See also bug in Arch Linux bug tracker on location of ncurses includes:
   https://bugs.archlinux.org/task/5263?opened=2039&status[0]=

   Anyway, AC_CHECK_HEADERS in configure.ac + this preprocessor code should
   give good results. It works on my Debian box, to be tested on Arch. */
#if (HAVE_NCURSESW_FORM_H && HAVE_NCURSESW_MENU_H && HAVE_NCURSESW_NCURSES_H && HAVE_NCURSESW_PANEL_H)
  #include <ncursesw/ncurses.h>
  #include <ncursesw/form.h>
  #include <ncursesw/menu.h>
  #include <ncursesw/panel.h>
#elif (HAVE_FORM_H && HAVE_MENU_H && HAVE_NCURSES_H && HAVE_PANEL_H)
  #include <ncurses.h>
  #include <form.h>
  #include <menu.h>
  #include <panel.h>
#endif

#include "main.h"
#include "cdw_colors.h"


/* type of data that can be put in input field, and if it should be invisible */
enum {
	CDW_NCURSES_INPUT_NONE = 0,
	CDW_NCURSES_INPUT_HIDDEN = 1,
	CDW_NCURSES_INPUT_INTEGER = 2,
	CDW_NCURSES_INPUT_NUMERIC = 4
};



cdw_rv_t cdw_ncurses_init(void);
void cdw_ncurses_clean(void);


cdw_rv_t cdw_ncurses_get_field_buffer(FIELD *field, char **buffer, size_t limit);
const char *cdw_ncurses_error_string(int ret_val);

bool   cdw_ncurses_get_field_bit(FIELD *field);
char  *cdw_ncurses_get_field_string(FIELD *field);
FORM  *cdw_ncurses_new_form(WINDOW *window, WINDOW *subwindow, FIELD **field);
FIELD *cdw_ncurses_new_input_field(int n_lines, int n_cols, int begin_y, int begin_x, const char *initial_value, size_t len_max, int input_type, cdw_colors_t colors);
FIELD *cdw_ncurses_new_label_field(int n_lines, int n_cols, int begin_y, int begin_x, const char *initial_value);
FIELD *cdw_ncurses_new_checkbox_field(int begin_y, int begin_x, const char *initial_value);
cdw_rv_t cdw_ncurses_nice_box(WINDOW *window, const char *top_string, const char *bottom_string);
void cdw_ncurses_delete_menu_and_items(MENU **menu);
const char *cdw_ncurses_key_label(int c);

WINDOW *cdw_ncurses_window_new(WINDOW *window, int n_lines, int n_cols, int begin_y, int begin_x, chtype cdw_colors, const char *top_string, const char *bottom_string);
void    cdw_ncurses_window_delete(WINDOW **window);

void cdw_ncurses_window_add_help_marker(WINDOW *window);

#endif /* H_CDW_NCURSES */


