#This is the main tcl library for anything to do with burning

proc toast {} {
	global cfg cue
	set cue 0

	if {$cfg(ds) == "none"} {
		set source ""
	}

	if {$cfg(ds) == "premade"} {
		set source [.ds.tname get]
		if {[string match -nocase "*cue" $source]} { set cue 1 } else { set cue 0 }
		if {![file isfile $source]} {
		alert "Premade data track must be a regular file."
		return
		}
	}

	if {$cfg(ds) == "mkisofs"} {
		set source -
		set mk [make_mkisofs_cmd]
		if {$mk == ""} {
			return
		}
	}

	if { $cue } { set cd [base_cdrdao] } else { set cd [base_cdrec] }
	#set cd [base_cdrec]

	set nuke ""
	set convlist ""

	if {$source != ""} {
		if {!$cue} {lappend cd $cfg(cd_mode)}
		if $cfg(multi) {lappend cd "-multi"}
		if $cfg(dpad) {lappend cd "-pad"}
		lappend cd $source
	}
	set tmp [.audio.f.lb get 0 end]
	if {$tmp == ""} {
		if {$cfg(ds) == "none"} {
			alert "No audio tracks were specified for an audio-only disk. This makes no sense."
			return
		}
	} else {
		lappend cd -audio
		if {$cfg(cdi)} {lappend cd "-cdi"}
		if {!$cue} {if {$cfg(multi)} {lappend cd "-multi"}}

		if $cfg(apad) {lappend cd "-pad"} else {
			if $cfg(dpad) {lappend cd "-nopad"}
		}
		set warned 0
		foreach i $tmp {
			## Have to validate audio track type
			switch [file extension $i] {
				.mp2 -
				.mpg -
				.mp3 {
					if {$warned == 0} {
						# Give use opportunity to opt out. Also collect info for conversion.
						set tempdir [get_mp3_burn_info]
						if {$tempdir==""} {
						 alert "An understandable choice."
						 return
						}
						set warned 1
					}
					# Queue for conversion burning, and nuking.
					# Yes, there are race conditions. No, I don't care too much. If
					# you have a fix for the race conditions which is not too complicated,
					# tell me and I'll probably add your fix. Thanks.
					set tail [file tail $i]
					set tempfile [file join $tempdir "###${tail}.wav"]
					if [file exists $tempfile] {
						alert "$tempfile already exists. I will cancel the burn and let you decide what to do."
						return
					}
					lappend convlist $i
					lappend nuke $tempfile
					lappend cd $tempfile
					}

					.wav -
					.raw -
					.pcm {
					# queue for burning
					lappend cd $i
				}

				default {
					# Note the offending file for the user.
					alert "I don't recognize the file extention on '$i'. For safety reasons, I won't burn that file as an audio track.\n\nI'd suggest removing it and others like it from the audio track list."
					return
				}
			}
		}
	}

	if {$cfg(ds) == "mkisofs"} { set cd [concat $mk $cd] }

	set shellCommand $cd
	regsub -all {///PIPE///} $shellCommand "|" shellCommand

	if {[sure "About to run command:\n\n$shellCommand\n\nAre you sure?"]} {
		set err 0
		set err [catch {
			# Run necessary conversions
			if [llength $convlist] {

				toplevel .conv
				wm title .conv "Converting MP3s"
				text .conv.t -width 80 -height [llength $convlist]
				pack .conv.t

				foreach orig $convlist tempfile $nuke {
					.conv.t insert end "$orig --> $tempfile ..."
					update
					exec mpg123 -s $orig | sox -t raw -w -s -c 2 -r 44100 - -t wav $tempfile >&/dev/null
					.conv.t insert end " Done.\n"
				}

				destroy .conv
			}
		}]

		set cmd_list [list $cd]

		if $err {
			alert "Some error occured during the MPEG conversion process. You probably ran out of space or don't have the mpg123 and sox tools installed."
		} else {
			# Remove temp files when done...
			foreach tempfile $nuke {
				lappend cmd_list [list rm $tempfile]
			}

			dispatch $cmd_list {CD Burn Progress}
		}

	}

}

proc fix_cdrw {} {
	global cfg

	catch {destroy .top}
	toplevel .top
	wm title .top "Fixate Multisession CD"

	frame .top.type -border 0 -relief flat
	frame .top.b -border 0 -relief flat
	label .top.type.l -text {Are you sure you want to fixate your disk?}
	button .top.b.ok -text {Do it} -command {
	set cmd [list cdrecord -v -fix]
	if {$cfg(dummy)} { lappend cmd "-dummy" }
	if {$cfg(eject)} { lappend cmd "-eject" }
	lappend cmd "speed=$cfg(speed)"
	set dev [.c.dev.e get]
	lappend cmd "dev=$cfg(dev)"
	dispatch [list $cmd] "Fixating disk: ${dev}"
	destroy .top
	}
	button .top.b.dis -text {Let's not.} -command {
		destroy .top
	}

	pack .top.type -side top
	pack .top.b -side top -fill x
	pack .top.type.l -side left
	pack .top.b.ok -side left -expand 1
	pack .top.b.dis -side left -expand 1
}

proc blank_cdrw {} {
	global blank

	catch {destroy .top}
	toplevel .top
	wm title .top "Blank CDRW Media"

	frame .top.type -border 0 -relief flat
	frame .top.b -border 0 -relief flat
	label .top.type.l -text {Blank Type}
	frame .top.type.r
	radiobutton .top.type.all -text {Entire Disk} -variable {blank} -value {all}
	radiobutton .top.type.session -text {Session} -variable {blank} -value {session}
	radiobutton .top.type.track -text {Track} -variable {blank} -value {track}
	radiobutton .top.type.fast -text {Fast} -variable {blank} -value {fast}
	radiobutton .top.type.r.unreserve -text {Unreserve} -variable {blank} -value {unreserve}
	radiobutton .top.type.r.trtail -text {Track Tail} -variable {blank} -value {trtail}
	radiobutton .top.type.r.unclose -text {Unclose} -variable {blank} -value {unclose}
	button .top.b.ok -text {Do it} -command {
		set cmd [base_cdrec]
		lappend cmd "blank=${blank}"
		dispatch [list $cmd] "Blanking CDRW: ${blank}"
		destroy .top
	}
	button .top.b.dis -text {Let's not.} -command {
		destroy .top
	}

	pack .top.type -side top
	pack .top.b -side top -fill x
	pack .top.type.l -side left
	pack .top.type.r -side right -fill y
	pack .top.type.all -side top -anchor w
	pack .top.type.session -side top -anchor w
	pack .top.type.track -side top -anchor w
	pack .top.type.fast -side top -anchor w
	pack .top.type.r.unreserve -side top -anchor w
	pack .top.type.r.trtail -side top -anchor w
	pack .top.type.r.unclose -side top -anchor w
	pack .top.b.ok -side left -expand 1
	pack .top.b.dis -side left -expand 1

	set blank session

}

proc base_cdrec {} {
	global cfg
	set cd [list cdrecord -v]
	if {$cfg(dummy)} {lappend cd -dummy}
	if {$cfg(eject)} {lappend cd -eject}

	set dev [.c.dev.e get]
	if {![check_device $dev]} {
		alert "You don't have write permission to the device you selected. You should probably be running this as root. If that is not an option, get the system administrator to give you write privileges for the cd-writer."
		return -code return
	}
	lappend cd "dev=$dev" "speed=$cfg(speed)"
	if {$cfg(dao)} {lappend cd -dao}
	if {$cfg(burnfree)} {lappend cd "-driveropts=burnfree"} else {lappend cd "-driveropts=noburnfree"}
	if {!$cfg(fix)} {lappend cd "-nofix"}
	if {$cfg(ob)} {lappend cd "-overburn"}
	return $cd
}

proc base_cdrdao {} {
	global cfg
	set cd [list cdrdao]
	if {$cfg(dummy)} {lappend cd "simulate"} else { lappend cd "write" }
	if {$cfg(eject)} {lappend cd "--eject"}
	if {$cfg(multi)} {lappend cd "--multi"}
	if {$cfg(mmc) != ""} {
		lappend cd "--driver"
		lappend cd $cfg(mmc)
	}
	#lappend cd "--driver" "generic-mmc"

	set dev [.c.dev.e get]
	if {![check_device $dev]} {
		alert "You don't have write permission to the device you selected. You should probably be running this as root. If that is not an option, get the system administrator to give you write privileges for the cd-writer."
		return -code return
	}
	lappend cd "--device" $dev "--speed" $cfg(speed)
	if {$cfg(ob)} {lappend cd "--overburn"}
	return $cd
}

proc make_mkisofs_cmd {} {
	global cfg custom boot

	set vol [.m.volid.e get]
	set root [.m.root.e get]

	# Presumably this is not necessary if there is a custom layout.

	if {![file isdirectory $root]} {
	alert "For on-the-fly ISO image creation, the root of tree must be a directory."
	return
	}

	set mk mkisofs
	if {$cfg(all)} {lappend mk -all-files}
	if {$cfg(joliet)} {lappend mk -joliet}
	switch -exact $cfg(rock) {
		none {}
		rat {lappend mk -r}
		lit {lappend mk -R}
	}
	if {$cfg(follow)} {lappend mk -follow-links}
	if {$cfg(trans)} {lappend mk -translation-table}
	if {$boot} {
			if {($cfg(bootimg) == "") || ($cfg(bootcat) == "")} {
				alert "You selected 'Bootable CD' but either the boot image or boot catalog entries are blank. This will not work."
				return
			}
			if {![file exists [file join $root $cfg(bootimg)]]} {
				alert "[file join $root $cfg(bootimg)] is not there. You can't make a bootable CD without a bootimage."
				return
			}
			if {[file exists [file join $root $cfg(bootcat)]]} {
				if {![sure "[file join $root $cfg(bootcat)] will be overwritten if you continue. Is this ok?"]} {return}
			}
			lappend mk -b $cfg(bootimg) -c $cfg(bootcat)
	}
	if {$vol != ""} {lappend mk -volid $vol}

	## Here we need to (maybe) process the custom layout entries.
	lappend mk $root

	if {$custom(use)} {
		foreach dir $custom(from) graftpoint $custom(to) {
			if {$dir == ""} continue
			set isdir [file isdirectory $dir]
			if {$isdir} {set dir "$dir/"}
			lappend mk "$graftpoint/=$dir"
		}
	}

	## Last gasp.
	# use an illegal filename as symbol for the pipe so it can be recognized later
	lappend mk "///PIPE///"
	return $mk
}


proc open_bootfile {} {
	set types {
		{{Disk Images}      {.img}        }
		{{All Files}        *             }
	}
	set boot_img [tk_getOpenFile -filetypes $types -initialdir ~/ -title {Choose Image}]
	.boot.img.e delete 0 250
	.boot.img.e insert 0 $boot_img
}


proc open_catfile {} {
	set types {
		{{All Files}        *             }
	}
	set boot_cat [tk_getOpenFile -filetypes $types -initialdir ~/ -title {Choose File}]
	.boot.cat.e delete 0 250
	.boot.cat.e insert 0 $boot_cat
}


proc check_device dev {

	if {[file writable $dev]} {
		 return 1
	}

	# Now gotta test for numeric device specification

	set len [string length $dev]
	set field {0123456789,}

	for {set i 0} {$i < $len} {incr i} {
		set try [string index $dev $i]
		if {![string match *$try* $field]} {return 0}
	}

	return 1
}

proc detect_cdrom_device {} {
	# Try some likely prospects:

	set prospects [list "/dev/cdrom" "/dev/cdroms/cdrom0"]
	foreach try $prospects {
		if {[file exists $try] && ! [file isdirectory $try]} {
			return $try
		}
	}

	# Give up and hope for user input.
	return "/dev/"
}

proc read_iso {} {
	catch {destroy .top}
	toplevel .top
	wm title .top "Read ISO image"

	frame .top.dev -border 0 -relief flat
	frame .top.file -border 0 -relief flat
	frame .top.b -border 0 -relief flat
	label .top.dev.l -text {device to read:}
	label .top.file.l -text {file to write:}
	entry .top.dev.e -width 20 -font 7x14
	entry .top.file.e -width 20 -font 7x14
	button .top.b.ok -text {Do it} -command {
		if {![file readable [.top.dev.e get]]} {
			alert "You do not have read permissions on '[.top.dev.e get]'. You should probably be running this as root."
			return
		}
		set cmd_echo [list echo "This takes a good while."]
		set cmd_dd [list dd if=[.top.dev.e get] of=[.top.file.e get] bs=1024k]
		set cmd_eject [list eject [.top.dev.e get]]
		dispatch [list $cmd_echo $cmd_dd $cmd_eject] "Reading ISO Image"
		destroy .top
	}
	button .top.b.dis -text {Forget it} -command { destroy .top }

	pack .top.dev -side top
	pack .top.file -side top
	pack .top.b -side top -fill x
	pack .top.dev.l -side left
	pack .top.file.l -side left
	pack .top.dev.e -side left
	pack .top.file.e -side left
	pack .top.b.ok -side left -expand 1
	pack .top.b.dis -side left -expand 1

	.top.dev.e insert 0 [detect_cdrom_device]
	.top.file.e insert 0 "image.iso"

}

proc read_cuebin {} {
	global hdir
	catch {destroy .top}
	toplevel .top
	set tmpfile $::env(HOME)
        append tmpfile {/temp.toc}
	wm title .top "Read CUE/BIN image"
	frame .top.dev -border 0 -relief flat
	frame .top.file -border 0 -relief flat
	frame .top.b -border 0 -relief flat
	label .top.dev.l -text {device to read:}
	label .top.file.l -text {file to write:}
	entry .top.dev.e -width 25 -font 7x14
	entry .top.file.e -width 27 -font 7x14
	button .top.b.ok -text {Do it} -command {
		if {![file readable [.top.dev.e get]]} {
			alert "You do not have read permissions on '[.top.dev.e get]'. You should probably be running this as root."
			return
		}
		set sTocFile [.top.file.e get]
		set cmd_echo [list echo "This will take some time."]
		set cmd_cdrdao [list cdrdao read-cd --device [.top.dev.e get] --datafile [.top.file.e get].bin [.top.file.e get].toc]
		set cmd_toctocue [list $hdir/toc2cue $sTocFile]
		set cmd_eject [list eject [.top.dev.e get]]
		dispatch [list $cmd_echo $cmd_cdrdao $cmd_toctocue $cmd_eject] "Reading CUE/BIN Image"
		destroy .top
	}
	button .top.b.dis -text {Forget it} -command { destroy .top }

	pack .top.dev -side top
	pack .top.file -side top
	pack .top.b -side top -fill x
	pack .top.dev.l -side left
	pack .top.file.l -side left
	pack .top.dev.e -side left
	pack .top.file.e -side left
	pack .top.b.ok -side left -expand 1
	pack .top.b.dis -side left -expand 1

	.top.dev.e insert 0 [detect_cdrom_device]
	.top.file.e insert 0 "image"

}


