
/* Automatically generated by m214003 at 2010-06-21, do not edit */

/* CDILIB_VERSION="1.4.5" */

#if  defined  (HAVE_CONFIG_H)
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <float.h>
#include <math.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#if  defined  (HAVE_LIBGRIB_API)
#  include <grib_api.h>
#endif

#if defined (HAVE_MMAP)
#  include <sys/mman.h> /* mmap() is defined in this header */
#endif

#if  defined  (HAVE_LIBPTHREAD)
#  include <pthread.h>
#endif

#if  defined  (HAVE_LIBSZ)
#  include <szlib.h>
#endif

#if ! defined (HAVE_CONFIG_H)
#  define  HAVE_LIBGRIB      1
#  define  HAVE_LIBCGRIBEX   1
#  define  HAVE_LIBSERVICE   1
#  define  HAVE_LIBEXTRA     1
#  define  HAVE_LIBIEG       1
#endif

#ifndef _CDI_LIMITS_H
#define _CDI_LIMITS_H

#define  MIN_STREAMS    1024  /* minimum number of streams                    */
#define  MAX_STREAMS   65536  /* maximum number of streams                    */
#define  MIN_VLISTS     1024  /* minimum number of vlists                     */
#define  MAX_VLISTS    65536  /* maximum number of vlists                     */
#define  MIN_TAXES      1024  /* minimum number of taxes                      */
#define  MAX_TAXES     65536  /* maximum number of taxes                      */
#define  MAX_ZAXES      1024  /* maximum number of zaxes                      */
#define  MAX_GRIDS      8192  /* maximum number of grids                      */
#define  MAX_INSTS      1024  /* maximum number of instituts                  */
#define  MAX_MODELS     1024  /* maximum number of models                     */
#define  MAX_GRIDS_PS    128  /* maximum number of different grids per stream */
#define  MAX_ZAXES_PS    128  /* maximum number of different zaxes per stream */
#define  MAX_ATTRIBUTES  256  /* maximum number of attributes per variable    */

#endif  /* _CDI_LIMITS_H */
#ifndef _TAXIS_H
#define _TAXIS_H


typedef struct {
  /* Date format  YYYYMMDD */
  /* Time format    hhmmss */
  int     self;
  int     used;
  int     type;           /* time type             */
  int     vdate;          /* verification date     */
  int     vtime;          /* verification time     */
  int     rdate;          /* reference date        */
  int     rtime;          /* reference time        */
  int     calendar;
  int     unit;           /* time unit             */
  int     numavg;
  int     has_bounds;
  int     vdate_lb;       /* lower bounds of vdate */
  int     vtime_lb;       /* lower bounds of vtime */
  int     vdate_ub;       /* upper bounds of vdate */
  int     vtime_ub;       /* upper bounds of vtime */
}
taxis_t;

void    ptaxisInit(taxis_t *taxis);
void    ptaxisCopy(taxis_t *dest, taxis_t *source);
taxis_t  *taxisPtr(int timeID);
void    cdiDecodeTimeval(double timevalue, taxis_t *taxis, int *date, int *time);
double  cdiEncodeTimeval(int date, int time, taxis_t *taxis);
void    timeval2vtime(double timevalue, taxis_t *taxis, int *vdate, int *vtime);
double  vtime2timeval(int vdate, int vtime, taxis_t *taxis);


#endif  /* _TAXIS_H */
#ifndef _ERROR_H
#define _ERROR_H

#define  _FATAL     1     /* Error flag: exit on error  */
#define  _VERBOSE   2     /* Error flag: report errors  */
#define  _DEBUG     4     /* Error flag: debug          */

extern int _ExitOnError;  /* If set to 1, exit on error (default 1)       */
extern int _Verbose;      /* If set to 1, errors are reported (default 1) */
extern int _Debug;        /* If set to 1, debuggig (default 0)            */

void SysError(const char *caller, const char *fmt, ...);
void    Error(const char *caller, const char *fmt, ...);
void  Warning(const char *caller, const char *fmt, ...);
void  Message(const char *caller, const char *fmt, ...);

#endif  /* _ERROR_H */
#ifndef _DTYPES_H
#define _DTYPES_H

#include <stdio.h>
#include <limits.h>

/* INT32 */

#if ! defined (INT_MAX)
#  error INT_MAX undefined
#endif

#undef  INT32
#if  INT_MAX == 2147483647L
#  define  INT32  int
#elif LONG_MAX == 2147483647L
#  define  INT32  long
#endif

/* INT64 */

#if ! defined (LONG_MAX)
#  error LONG_MAX undefined
#endif

#undef  INT64
#if  LONG_MAX > 2147483647L
#  define  INT64  long
#else
#  define  INT64  long long
#endif

/* FLT32 */

#undef   FLT32
#define  FLT32  float

/* FLT64 */

#undef   FLT64
#define  FLT64  double

/* UINT32 and UINT64 */

#define  UINT32   unsigned INT32
#define  UINT64   unsigned INT64

#endif  /* _DTYPES_H */
#ifndef _FILE_H
#define _FILE_H

#include <stdio.h>
#include <sys/types.h>


#define  FILE_UNDEFID      -1

#define  FILE_TYPE_OPEN     1
#define  FILE_TYPE_FOPEN    2

/* buffer types for FILE_TYPE_OPEN */
#define  FILE_BUFTYPE_STD   1
#define  FILE_BUFTYPE_MMAP  2

const
char  *fileLibraryVersion(void);

void   fileDebug(int debug);

void  *filePtr(int fileID);

int    fileSetBufferType(int fileID, int type);
void   fileSetBufferSize(int fileID, long buffersize);

int    fileOpen(const char *filename, const char *mode);
int    fileClose(int fileID);

char  *fileInqName(int fileID);
int    fileInqMode(int fileID);

int    fileFlush(int fileID);
void   fileClearerr(int fileID);
int    fileEOF(int fileID);
int    filePtrEOF(void *fileptr);
void   fileRewind(int fileID);

off_t  fileGetPos(int fileID);
int    fileSetPos(int fileID, off_t offset, int whence);

int    fileGetc(int fileID);
int    filePtrGetc(void *fileptr);

size_t filePtrRead(void *fileptr, void *ptr, size_t size);
size_t fileRead(int fileID, void *ptr, size_t size);
size_t fileWrite(int fileID, const void *ptr, size_t size);

#endif  /* _FILE_H */
#ifndef _CGRIBEX_H
#define _CGRIBEX_H

#include <stdio.h>
#include <sys/types.h>

#define  GRIB_MISSVAL  -9.E33

/* Level Types */
#define  LTYPE_SURFACE               1
#define  LTYPE_99                   99
#define  LTYPE_ISOBARIC            100
#define  LTYPE_MEANSEA             102
#define  LTYPE_ALTITUDE            103
#define  LTYPE_HEIGHT              105
#define  LTYPE_SIGMA               107
#define  LTYPE_HYBRID              109
#define  LTYPE_HYBRID_LAYER        110
#define  LTYPE_LANDDEPTH           111
#define  LTYPE_LANDDEPTH_LAYER     112
#define  LTYPE_ISENTROPIC          113
#define  LTYPE_SEADEPTH            160
#define  LTYPE_99_MARGIN          1000

/*
 *  Data representation type (Grid Type) [Table 6]
 */
#define  GTYPE_LATLON                0  /*  latitude/longitude                       */
#define  GTYPE_LATLON_ROT           10  /*  rotated latitude/longitude               */
#define  GTYPE_LATLON_STR           20  /*  stretched latitude/longitude             */
#define  GTYPE_LATLON_ROTSTR        30  /*  rotated and stretched latitude/longitude */
#define  GTYPE_GAUSSIAN              4  /*  gaussian grid                            */
#define  GTYPE_GAUSSIAN_ROT         14  /*  rotated gaussian grid                    */
#define  GTYPE_GAUSSIAN_STR         24  /*  stretched gaussian grid                  */
#define  GTYPE_GAUSSIAN_ROTSTR      34  /*  rotated and stretched gaussian grid      */
#define  GTYPE_LCC                   3  /*  Lambert conformal                        */
#define  GTYPE_SPECTRAL             50  /*  spherical harmonics                      */
#define  GTYPE_GME                 192  /*  hexagonal GME grid                       */

/*
 *  Macros for the indicator section ( Section 0 )
 */
#define  ISEC0_GRIB_Len             (isec0[ 0])  /*  Number of octets in the GRIB message         */
#define  ISEC0_GRIB_Version         (isec0[ 1])  /*  GRIB edition number                          */


/*
 *  Macros for the product definition section ( Section 1 )
 */
#define  ISEC1_TABLE4_MINUTE    0
#define  ISEC1_TABLE4_HOUR      1
#define  ISEC1_TABLE4_DAY       2
#define  ISEC1_TABLE4_3HOURS   10
#define  ISEC1_TABLE4_6HOURS   11
#define  ISEC1_TABLE4_12HOURS  12
#define  ISEC1_TABLE4_QUARTER  13


#define  ISEC1_CodeTable            (isec1[ 0])  /*  Version number of code table                 */
#define  ISEC1_CenterID             (isec1[ 1])  /*  Identification of centre                     */
#define  ISEC1_ModelID              (isec1[ 2])  /*  Identification of model                      */
#define  ISEC1_GridDefinition       (isec1[ 3])  /*  Grid definition                              */
#define  ISEC1_Sec2Or3Flag          (isec1[ 4])  /*  Section 2 or 3 included                      */
#define  ISEC1_Parameter            (isec1[ 5])  /*  Parameter indicator                          */
#define  ISEC1_LevelType            (isec1[ 6])  /*  Type of level indicator                      */
#define  ISEC1_Level1               (isec1[ 7])  /*  Level 1                                      */
#define  ISEC1_Level2               (isec1[ 8])  /*  Level 2                                      */
#define  ISEC1_Year                 (isec1[ 9])  /*  Year of century (YY)                         */
#define  ISEC1_Month                (isec1[10])  /*  Month (MM)                                   */
#define  ISEC1_Day                  (isec1[11])  /*  Day (DD)                                     */
#define  ISEC1_Hour                 (isec1[12])  /*  Hour (HH)                                    */
#define  ISEC1_Minute               (isec1[13])  /*  Minute (MM)                                  */
#define  ISEC1_TimeUnit             (isec1[14])  /*  Time unit indicator                          */
#define  ISEC1_TimePeriod1          (isec1[15])  /*  P1 Time period                               */
#define  ISEC1_TimePeriod2          (isec1[16])  /*  P2 Time period                               */
#define  ISEC1_TimeRange            (isec1[17])  /*  Time range indicator                         */
#define  ISEC1_AvgNum               (isec1[18])  /*  Number of products included in an average    */
#define  ISEC1_AvgMiss              (isec1[19])  /*  Number of products missing from an average   */
#define  ISEC1_Century              (isec1[20])  /*  Century                                      */
#define  ISEC1_SubCenterID          (isec1[21])  /*  Subcenter identifier                         */
#define  ISEC1_DecScaleFactor       (isec1[22])  /*  Decimal scale factor                         */
#define  ISEC1_LocalFLag            (isec1[23])  /*  Flag field to indicate local use in isec1    */

#define  ISEC1_ECMWF_LocalExtension (isec1[36])
#define  ISEC1_ECMWF_Class          (isec1[37])


/*
 *  Macros for the grid definition section ( Section 2 )
 */
#define  ISEC2_GridType             (isec2[ 0])  /* Data representation type */

/* Triangular grids */

#define  ISEC2_GME_NI2              (isec2[ 1])  /*  Number of factor 2 in factorisation of Ni    */
#define  ISEC2_GME_NI3              (isec2[ 2])  /*  Number of factor 3 in factorisation of Ni    */
#define  ISEC2_GME_ND               (isec2[ 3])  /*  Nubmer of diamonds                           */
#define  ISEC2_GME_NI               (isec2[ 4])  /*  Number of tri. subdiv. of the icosahedron    */
#define  ISEC2_GME_AFlag            (isec2[ 5])  /*  Flag for orientation of diamonds (Table A)   */
#define  ISEC2_GME_LatPP            (isec2[ 6])  /*  Latitude of pole point                       */
#define  ISEC2_GME_LonPP            (isec2[ 7])  /*  Longitude of pole point                      */
#define  ISEC2_GME_LonMPL           (isec2[ 8])  /*  Longitude of the first diamond               */
#define  ISEC2_GME_BFlag            (isec2[ 9])  /*  Flag for storage sequence (Table B)          */

/* Spherical harmonic coeficients */

#define  ISEC2_PentaJ               (isec2[ 1])  /*  J pentagonal resolution parameter            */
#define  ISEC2_PentaK               (isec2[ 2])  /*  K pentagonal resolution parameter            */
#define  ISEC2_PentaM               (isec2[ 3])  /*  M pentagonal resolution parameter            */
#define  ISEC2_RepType              (isec2[ 4])  /*  Representation type                          */
#define  ISEC2_RepMode              (isec2[ 5])  /*  Representation mode                          */

/* Gaussian grids */

#define  ISEC2_NumLon               (isec2[ 1])  /*  Number of points along a parallel (Ni)       */
#define  ISEC2_NumLat               (isec2[ 2])  /*  Number of points along a meridian (Nj)       */
#define  ISEC2_FirstLat             (isec2[ 3])  /*  Latitude of the first grid point             */
#define  ISEC2_FirstLon             (isec2[ 4])  /*  Longitude of the first grid point            */
#define  ISEC2_ResFlag              (isec2[ 5])  /*  Resolution flag: 128 regular grid            */
#define  ISEC2_LastLat              (isec2[ 6])  /*  Latitude of the last grid point              */
#define  ISEC2_LastLon              (isec2[ 7])  /*  Longitude of the last grid point             */
#define  ISEC2_LonIncr              (isec2[ 8])  /*  i direction increment                        */
#define  ISEC2_LatIncr              (isec2[ 9])  /*  j direction increment                        */
#define  ISEC2_NumPar               (isec2[ 9])  /*  Number of parallels between a pole and the E.*/
#define  ISEC2_ScanFlag             (isec2[10])  /*  Scanning mode flags                          */
#define  ISEC2_NumVCP               (isec2[11])  /*  Number of vertical coordinate parameters     */

/* Lambert */
#define  ISEC2_Lambert_Lov          (isec2[ 6])  /*  Orientation of the grid                      */
#define  ISEC2_Lambert_dx           (isec2[ 8])  /*  X-direction grid length                      */
#define  ISEC2_Lambert_dy           (isec2[ 9])  /*  Y-direction grid length                      */
#define  ISEC2_Lambert_ProjFlag     (isec2[12])  /*  Projection centre flag                       */
#define  ISEC2_Lambert_LatS1        (isec2[13])  /*  First lat at which the secant cone cuts the sphere */
#define  ISEC2_Lambert_LatS2        (isec2[14])  /*  Second lat at which the secant cone cuts the sphere */
#define  ISEC2_Lambert_LatSP        (isec2[19])  /*  Latitude of the southern pole                */
#define  ISEC2_Lambert_LonSP        (isec2[20])  /*  Longitude of the southern pole               */


#define  ISEC2_Reduced              (isec2[16])  /* 0: regular, 1: reduced grid                   */

#define  ISEC2_RowLonPtr            (&isec2[22])
#define  ISEC2_RowLon(i)            (isec2[22+i]) /* Number of points along each parallel         */

/* */

#define  ISEC2_LatSP                (isec2[12])  /* Latitude of the southern pole of rotation     */
#define  ISEC2_LonSP                (isec2[13])  /* Longitude of the southern pole of rotation    */

#define  FSEC2_RotAngle             (fsec2[ 0])  /* Angle of rotation                             */
#define  FSEC2_StrFact              (fsec2[ 1])  /* Stretching factor                             */

/*
 *  Macros for the bit map section ( Section 3 )
 */
#define  ISEC3_PredefBitmap         (isec3[ 0])  /* Predefined bitmap                             */
#define  ISEC3_MissVal              (isec3[ 1])  /* Missing data value for integers               */
#define  FSEC3_MissVal              (fsec3[ 1])  /* Missing data value for floats                 */

/*
 *  Macros for the binary data section ( Section 4 )
 */
#define  ISEC4_NumValues            (isec4[ 0])  /* Number of data values for encode/decode       */
#define  ISEC4_NumBits              (isec4[ 1])  /* Number of bits used for each encoded value    */
#define  ISEC4_NumNonMissValues     (isec4[20])  /* Number of non-missing values                  */




void  gribSetDebug(int debug);
void  gribSetRound(int round);
void  gribSetRefDP(double refval);
void  gribSetRefSP(float  refval);
void  gribSetValueCheck(int vcheck);


void  gribExSP(int *isec0, int *isec1, int *isec2, float *fsec2, int *isec3,
               float *fsec3, int *isec4, float *fsec4, int klenp, int *kgrib,
               int kleng, int *kword, char *hoper, int *kret);

void  gribExDP(int *isec0, int *isec1, int *isec2, double *fsec2, int *isec3,
               double *fsec3, int *isec4, double *fsec4, int klenp, int *kgrib,
               int kleng, int *kword, char *hoper, int *kret);


const char *cgribexLibraryVersion(void);

void  gribDebug(int debug);


void  gribDateTime(int *isec1, int *date, int *time);
int   gribRefDate(int *isec1);
int   gribRefTime(int *isec1);
int   gribTimeIsFC(int *isec1);

void  gribPrintSec0(int *isec0);
void  gribPrintSec1(int *isec0, int *isec1);
void  gribPrintSec2DP(int *isec0, int *isec2, double *fsec2);
void  gribPrintSec2SP(int *isec0, int *isec2, float  *fsec2);
void  gribPrintSec3DP(int *isec0, int *isec3, double *fsec3);
void  gribPrintSec3SP(int *isec0, int *isec3, float  *fsec3);
void  gribPrintSec4DP(int *isec0, int *isec4, double *fsec4);
void  gribPrintSec4SP(int *isec0, int *isec4, float  *fsec4);
void  gribPrintSec4Wave(int *isec4);

void  gribPrintALL(int nrec, long offset, long recpos, long recsize, unsigned char *gribbuffer);
void  gribPrintPDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer);
void  gribPrintGDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer);
void  gribPrintBMS(int nrec, long recpos, long recsize, unsigned char *gribbuffer);
void  gribPrintBDS(int nrec, long recpos, long recsize, unsigned char *gribbuffer);

int grib1Sections(unsigned char *gribbuffer, long recsize, unsigned char **pdsp,
		  unsigned char **gdsp, unsigned char **bmsp, unsigned char **bdsp);
int grib2Sections(unsigned char *gribbuffer, long recsize, unsigned char **idsp,
		  unsigned char **lusp, unsigned char **gdsp, unsigned char **pdsp,
		  unsigned char **drsp, unsigned char **bmsp, unsigned char **bdsp);

int   gribGetZip(long recsize, unsigned char *gribbuffer, long *urecsize);

int   gribBzip(unsigned char *dbuf, long dbufsize, unsigned char *sbuf, long sbufsize);
int   gribZip(unsigned char *dbuf, long dbufsize, unsigned char *sbuf, long sbufsize);
int   gribUnzip(unsigned char *dbuf, long dbufsize, unsigned char *sbuf, long sbufsize);

int   gribOpen(const char *filename, const char *mode);
void  gribClose(int fileID);

int   gribRead(int fileID, unsigned char *buffer, size_t *buffersize);
int   gribWrite(int fileID, unsigned char *buffer, size_t buffersize);
off_t gribGetPos(int fileID);
int   gribGetSize(int fileID);
int   gribCheckSeek(int fileID, long *offset, int *version);
int   gribFileSeek(int fileID, long *offset);
int   gribReadSize(int fileID);
int   gribVersion(unsigned char *buffer, size_t buffersize);

int   gribGinfo(long recpos, long recsize, unsigned char *gribbuffer, int *intnum, float *fltnum);

double calculate_pfactor(const double* spectralField, long fieldTruncation, long subsetTruncation);

#endif  /* _CGRIBEX_H */ 

#ifndef _GRIBAPI_H
#define _GRIBAPI_H

#define  GRIBAPI_MISSVAL  -9.E33

/* Level Types */
#define  GRIBAPI_LTYPE_SURFACE               1
#define  GRIBAPI_LTYPE_ISOBARIC            100
#define  GRIBAPI_LTYPE_MEANSEA             101
#define  GRIBAPI_LTYPE_ALTITUDE            102
#define  GRIBAPI_LTYPE_HEIGHT              103
#define  GRIBAPI_LTYPE_SIGMA               104
#define  GRIBAPI_LTYPE_HYBRID              105
#define  GRIBAPI_LTYPE_LANDDEPTH           106
#define  GRIBAPI_LTYPE_ISENTROPIC          107
#define  GRIBAPI_LTYPE_SEADEPTH            160

/*
 *  Data representation type (Grid Type)
 */
#define  GRIBAPI_GTYPE_LATLON                0  /*  latitude/longitude                       */
#define  GRIBAPI_GTYPE_LATLON_ROT            1  /*  rotated latitude/longitude               */
#define  GRIBAPI_GTYPE_LATLON_STR            2  /*  stretched latitude/longitude             */
#define  GRIBAPI_GTYPE_LATLON_ROTSTR         3  /*  rotated and stretched latitude/longitude */
#define  GRIBAPI_GTYPE_GAUSSIAN             40  /*  gaussian grid                            */
#define  GRIBAPI_GTYPE_GAUSSIAN_ROT         41  /*  rotated gaussian grid                    */
#define  GRIBAPI_GTYPE_GAUSSIAN_STR         42  /*  stretched gaussian grid                  */
#define  GRIBAPI_GTYPE_GAUSSIAN_ROTSTR      43  /*  rotated and stretched gaussian grid      */
#define  GRIBAPI_GTYPE_LCC                  30  /*  Lambert conformal                        */
#define  GRIBAPI_GTYPE_SPECTRAL             50  /*  spherical harmonics                      */
#define  GRIBAPI_GTYPE_GME                 192  /*  hexagonal GME grid                       */

const char *gribapiLibraryVersion(void);
void gribapiDefHandles(int streamID);
void *gribHandleNew();
void gribHandleDelete(void *gh);

#endif  /* _GRIBAPI_H */
#ifndef _SERVICE_H
#define _SERVICE_H


typedef struct {
  int    checked;
  int    byteswap;
  int    header[8];
  int    hprec;      /* header precision */
  int    dprec;      /* data   precision */
  size_t datasize;
  size_t buffersize;
  void  *buffer;
}
srvrec_t;


const char *srvLibraryVersion(void);

void srvDebug(int debug);

int  srvCheckFiletype(int fileID, int *swap);

srvrec_t *srvNew(void);
void srvDelete(srvrec_t *srvp);

int  srvRead(int fileID, srvrec_t *srvp);
int  srvWrite(int fileID, srvrec_t *srvp);

int  srvInqHeader(srvrec_t *srvp, int *header);
int  srvInqDataSP(srvrec_t *srvp, float *data);
int  srvInqDataDP(srvrec_t *srvp, double *data);

int  srvDefHeader(srvrec_t *srvp, const int *header);
int  srvDefDataSP(srvrec_t *srvp, const float *data);
int  srvDefDataDP(srvrec_t *srvp, const double *data);


#endif  /* _SERVICE_H */
#ifndef _EXTRA_H
#define _EXTRA_H

#define  EXT_REAL   1
#define  EXT_COMP   2


typedef struct {
  int    checked;
  int    byteswap;
  int    header[4];
  int    prec;      /* single or double precison */
  int    number;    /* real or complex */
  size_t datasize;
  size_t buffersize;
  void  *buffer;
}
extrec_t;


const char *extLibraryVersion(void);

void extDebug(int debug);

int  extCheckFiletype(int fileID, int *swap);

void *extNew(void);
void extDelete(void *ext);

int  extRead(int fileID, void *ext);
int  extWrite(int fileID, void *ext);

int  extInqHeader(void *ext, int *header);
int  extInqDataSP(void *ext, float *data);
int  extInqDataDP(void *ext, double *data);

int  extDefHeader(void *ext, const int *header);
int  extDefDataSP(void *ext, const float *data);
int  extDefDataDP(void *ext, const double *data);

#endif  /* _EXTRA_H */
#ifndef _IEG_H
#define _IEG_H

/* Level Types */
#define  IEG_LTYPE_SURFACE               1
#define  IEG_LTYPE_99                   99
#define  IEG_LTYPE_ISOBARIC            100
#define  IEG_LTYPE_MEANSEA             102
#define  IEG_LTYPE_ALTITUDE            103
#define  IEG_LTYPE_HEIGHT              105
#define  IEG_LTYPE_SIGMA               107
#define  IEG_LTYPE_HYBRID              109
#define  IEG_LTYPE_HYBRID_LAYER        110
#define  IEG_LTYPE_LANDDEPTH           111
#define  IEG_LTYPE_LANDDEPTH_LAYER     112
#define  IEG_LTYPE_SEADEPTH            160
#define  IEG_LTYPE_99_MARGIN          1000

/*
 *  Data representation type (Grid Type) [Table 6]
 */
#define  IEG_GTYPE_LATLON             0  /*  latitude/longitude                       */
#define  IEG_GTYPE_LATLON_ROT        10  /*  rotated latitude/longitude               */

#define  IEG_P_CodeTable(x)   (x[ 5])  /*  Version number of code table                 */
#define  IEG_P_Parameter(x)   (x[ 6])  /*  Parameter indicator                          */
#define  IEG_P_LevelType(x)   (x[ 7])  /*  Type of level indicator                      */
#define  IEG_P_Level1(x)      (x[ 8])  /*  Level 1                                      */
#define  IEG_P_Level2(x)      (x[ 9])  /*  Level 2                                      */
#define  IEG_P_Year(x)        (x[10])  /*  Year of century (YY)                         */
#define  IEG_P_Month(x)       (x[11])  /*  Month (MM)                                   */
#define  IEG_P_Day(x)         (x[12])  /*  Day (DD)                                     */
#define  IEG_P_Hour(x)        (x[13])  /*  Hour (HH)                                    */
#define  IEG_P_Minute(x)      (x[14])  /*  Minute (MM)                                  */

/*
 *  Macros for the grid definition section ( Section 2 )
 */
#define  IEG_G_Size(x)        (x[ 0])
#define  IEG_G_NumVCP(x)      (x[3] == 10 ? (x[0]-42)/4 : (x[0]-32)/4)
#define  IEG_G_GridType(x)    (x[ 3])  /*  Data representation type */
#define  IEG_G_NumLon(x)      (x[ 4])  /*  Number of points along a parallel (Ni)       */
#define  IEG_G_NumLat(x)      (x[ 5])  /*  Number of points along a meridian (Nj)       */
#define  IEG_G_FirstLat(x)    (x[ 6])  /*  Latitude of the first grid point             */
#define  IEG_G_FirstLon(x)    (x[ 7])  /*  Longitude of the first grid point            */
#define  IEG_G_ResFlag(x)     (x[ 8])  /*  Resolution flag: 128 regular grid            */
#define  IEG_G_LastLat(x)     (x[ 9])  /*  Latitude of the last grid point              */
#define  IEG_G_LastLon(x)     (x[10])  /*  Longitude of the last grid point             */
#define  IEG_G_LonIncr(x)     (x[11])  /*  i direction increment                        */
#define  IEG_G_LatIncr(x)     (x[12])  /*  j direction increment                        */
#define  IEG_G_ScanFlag(x)    (x[13])
#define  IEG_G_LatSP(x)       (x[16])  /*  Latitude of the southern pole of rotation    */
#define  IEG_G_LonSP(x)       (x[17])  /*  Longitude of the southern pole of rotation   */


typedef struct {
  int    checked;
  int    byteswap;
  int    dprec;      /* data   precision */
  double refval;
  int    ipdb[37];
  int    igdb[22];
  double vct[100];
  size_t datasize;
  size_t buffersize;
  void  *buffer;
}
iegrec_t;


const char *iegLibraryVersion(void);

void iegDebug(int debug);
int  iegCheckFiletype(int fileID, int *swap);

iegrec_t *iegNew(void);
void iegDelete(iegrec_t *iegp);
void iegInit(iegrec_t *iegp);
void iegInitMem(iegrec_t *iegp);

int  iegRead(int fileID, iegrec_t *iegp);
int  iegWrite(int fileID, iegrec_t *iegp);

void iegCopyMeta(iegrec_t *diegp, iegrec_t *siegp);
int  iegInqHeader(iegrec_t *iegp, int *header);
int  iegInqDataSP(iegrec_t *iegp, float *data);
int  iegInqDataDP(iegrec_t *iegp, double *data);

int  iegDefHeader(iegrec_t *iegp, const int *header);
int  iegDefDataSP(iegrec_t *iegp, const float *data);
int  iegDefDataDP(iegrec_t *iegp, const double *data);


#endif  /* _IEG_H */
#ifndef  _CDI_H
#define  _CDI_H

#include <sys/types.h>

#if defined(__cplusplus)
extern "C" {
#endif

#define  CDI_UNDEFID             -1
#define  CDI_GLOBAL              -1   /* Global var ID for vlist  */

/* Byte order */

#define  CDI_BIGENDIAN            0   /* Byte order BIGENDIAN     */
#define  CDI_LITTLEENDIAN         1   /* Byte order LITTLEENDIAN  */

#define  CDI_REAL                 1   /* Real numbers             */
#define  CDI_COMP                 2   /* Complex numbers          */
#define  CDI_BOTH                 3   /* Both numbers             */

/* Error identifier */

#define	 CDI_NOERR        	  0   /* No Error                             */
#define  CDI_ESYSTEM            -10   /* Operating system error               */
#define  CDI_EINVAL             -20   /* Invalid argument                     */
#define  CDI_EUFTYPE            -21   /* Unsupported file type                */
#define  CDI_ELIBNAVAIL         -22   /* xxx library not available            */
#define  CDI_EUFSTRUCT          -23   /* Unsupported file structure           */
#define  CDI_EUNC4              -24   /* Unsupported netCDF4 structure        */
#define  CDI_ELIMIT             -99   /* Internal limits exceeded             */

/* File types */

#define  FILETYPE_GRB             1   /* File type GRIB                       */
#define  FILETYPE_GRB2            2   /* File type GRIB version 2             */
#define  FILETYPE_NC              3   /* File type netCDF                     */
#define  FILETYPE_NC2             4   /* File type netCDF version 2 (64-bit)  */
#define  FILETYPE_NC4             5   /* File type netCDF version 4 (classic) */
#define  FILETYPE_SRV             6   /* File type SERVICE                    */
#define  FILETYPE_EXT             7   /* File type EXTRA                      */
#define  FILETYPE_IEG             8   /* File type IEG                        */

/* Compress types */

#define  COMPRESS_NONE            0
#define  COMPRESS_SZIP            1
#define  COMPRESS_GZIP            2
#define  COMPRESS_BZIP2           3
#define  COMPRESS_ZIP             4
#define  COMPRESS_JPEG            5

/* external data types */

#define  DATATYPE_PACK            0
#define  DATATYPE_PACK1           1
#define  DATATYPE_PACK2           2
#define  DATATYPE_PACK3           3
#define  DATATYPE_PACK4           4
#define  DATATYPE_PACK5           5
#define  DATATYPE_PACK6           6
#define  DATATYPE_PACK7           7
#define  DATATYPE_PACK8           8
#define  DATATYPE_PACK9           9
#define  DATATYPE_PACK10         10
#define  DATATYPE_PACK11         11
#define  DATATYPE_PACK12         12
#define  DATATYPE_PACK13         13
#define  DATATYPE_PACK14         14
#define  DATATYPE_PACK15         15
#define  DATATYPE_PACK16         16
#define  DATATYPE_PACK17         17
#define  DATATYPE_PACK18         18
#define  DATATYPE_PACK19         19
#define  DATATYPE_PACK20         20
#define  DATATYPE_PACK21         21
#define  DATATYPE_PACK22         22
#define  DATATYPE_PACK23         23
#define  DATATYPE_PACK24         24
#define  DATATYPE_PACK25         25
#define  DATATYPE_PACK26         26
#define  DATATYPE_PACK27         27
#define  DATATYPE_PACK28         28
#define  DATATYPE_PACK29         29
#define  DATATYPE_PACK30         30
#define  DATATYPE_PACK31         31
#define  DATATYPE_PACK32         32
#define  DATATYPE_CPX32          64
#define  DATATYPE_CPX64         128
#define  DATATYPE_FLT32         132
#define  DATATYPE_FLT64         164
#define  DATATYPE_INT8          208
#define  DATATYPE_INT16         216
#define  DATATYPE_INT32         232
#define  DATATYPE_UINT8         308
#define  DATATYPE_UINT16        316
#define  DATATYPE_UINT32        332

/* internal data types */

#define  DATATYPE_INT           251
#define  DATATYPE_FLT           252
#define  DATATYPE_TXT           253
#define  DATATYPE_CPX           254


/* GRID types */

#define  GRID_GENERIC             1
#define  GRID_GAUSSIAN            2
#define  GRID_GAUSSIAN_REDUCED    3
#define  GRID_LONLAT              4
#define  GRID_SPECTRAL            5
#define  GRID_FOURIER             6
#define  GRID_GME                 7  /* Icosahedral-hexagonal GME Grid */
#define  GRID_TRAJECTORY          8
#define  GRID_CELL                9
#define  GRID_CURVILINEAR        10
#define  GRID_LCC                11  /* Lambert Conformal Conic (GRIB) */
#define  GRID_LCC2               12  /* Lambert Conformal Conic (PROJ) */
#define  GRID_LAEA               13  /* Lambert Azimuthal Equal Area   */
#define  GRID_SINUSOIDAL         14  /* Sinusoidal                     */

/* ZAXIS types */

#define  ZAXIS_SURFACE            0
#define  ZAXIS_GENERIC            1
#define  ZAXIS_HYBRID             2
#define  ZAXIS_HYBRID_HALF        3
#define  ZAXIS_PRESSURE           4
#define  ZAXIS_HEIGHT             5
#define  ZAXIS_DEPTH_BELOW_SEA    6
#define  ZAXIS_DEPTH_BELOW_LAND   7
#define  ZAXIS_ISENTROPIC         8
#define  ZAXIS_TRAJECTORY         9
#define  ZAXIS_ALTITUDE          10
#define  ZAXIS_SIGMA             11
#define  ZAXIS_MEANSEA           12

/* TAXIS types */

#define  TAXIS_ABSOLUTE           1
#define  TAXIS_RELATIVE           2

/* TIME types */

#define  TIME_CONSTANT            1
#define  TIME_VARIABLE            2

/* TUNIT types */

#define  TUNIT_SECOND             1
#define  TUNIT_MINUTE             2
#define  TUNIT_HOUR               3
#define  TUNIT_DAY                4
#define  TUNIT_MONTH              5
#define  TUNIT_YEAR               6
#define  TUNIT_QUARTER            7
#define  TUNIT_3HOURS             8
#define  TUNIT_6HOURS             9
#define  TUNIT_12HOURS           10

/* TSTEP types */

#define  TSTEP_INSTANT            1
#define  TSTEP_AVG                2
#define  TSTEP_ACCUM              3
#define  TSTEP_MAX                4
#define  TSTEP_MIN                5
#define  TSTEP_DIFF               6
#define  TSTEP_RANGE              7
#define  TSTEP_INSTANT2           8
#define  TSTEP_INSTANT3           9

/* CALENDAR types */

#define  CALENDAR_STANDARD        0  /* don't change this value (used also in cgribexlib)! */
#define  CALENDAR_PROLEPTIC       1
#define  CALENDAR_360DAYS         2
#define  CALENDAR_365DAYS         3
#define  CALENDAR_366DAYS         4
#define  CALENDAR_NONE            5


/* CDI control routines */

char   *cdiStringError(int cdiErrno);

void    cdiDebug(int debug);

char   *cdiLibraryVersion(void);
void    cdiPrintVersion(void);

void    cdiDefMissval(double missval);
double  cdiInqMissval(void);
void    cdiDefGlobal(const char *string, int val);

/* CDI converter routines */

/* parameter */

void    cdiParamToString(int param, char *paramstr, int maxlen);

void    cdiDecodeParam(int param, int *pnum, int *pcat, int *pdis);
int     cdiEncodeParam(int pnum, int pcat, int pdis);

/* date format:  YYYYMMDD */
/* time format:    hhmmss */

void    cdiDecodeDate(int date, int *year, int *month, int *day);
int     cdiEncodeDate(int year, int month, int day);

void    cdiDecodeTime(int time, int *hour, int *minute, int *second);
int     cdiEncodeTime(int hour, int minute, int second);


/* STREAM control routines */

/*      streamOpenRead: Open a dataset for reading */
int     streamOpenRead(const char *path);

/*      streamOpenWrite: Create a new dataset */
int     streamOpenWrite(const char *path, int filetype);

int     streamOpenAppend(const char *path);

/*      streamClose: Close an open dataset */
void    streamClose(int streamID);

/*      streamSync: Synchronize an Open Dataset to Disk */
void    streamSync(int streamID);

/*      streamDefVlist: Define the Vlist for a stream */
void    streamDefVlist(int streamID, int vlistID);

/*      streamInqVlist: Get the Vlist of a stream */
int     streamInqVlist(int streamID);

/*      streamInqFiletype: Get the filetype */
int     streamInqFiletype(int streamID);

/*      streamDefByteorder: Define the byteorder */
void    streamDefByteorder(int streamID, int byteorder);

/*      streamInqByteorder: Get the byteorder */
int     streamInqByteorder(int streamID);

/*      streamDefZtype: Define compression type */
void    streamDefZtype(int streamID, int ztype);

/*      streamDefZlevel: Define compression level */
void    streamDefZlevel(int streamID, int zlevel);

/*      streamInqZtype: Get compression type */
int     streamInqZtype(int streamID);

/*      streamInqZlevel: Get compression level */
int     streamInqZlevel(int streamID);

/*      streamDefTimestep: Define time step */
int     streamDefTimestep(int streamID, int tsID);

/*      streamInqTimestep: Get time step */
int     streamInqTimestep(int streamID, int tsID);

char   *streamFilename(int streamID);
char   *streamFilesuffix(int filetype);
int     streamNtsteps(int streamID);
off_t   streamNvals(int streamID);


/* STREAM var I/O routines */

/*      streamReadVar: Read a variable */
void    streamReadVar(int streamID, int varID, double *data_vec, int *nmiss);

/*      streamWriteVar: Write a variable */
void    streamWriteVar(int streamID, int varID, const double *data_vec, int nmiss);

/*      streamReadVarSlice: Read a horizontal slice of a variable */
void    streamReadVarSlice(int streamID, int varID, int levelID, double *data_vec, int *nmiss);

/*      streamWriteVarSlice: Write a horizontal slice of a variable */
void    streamWriteVarSlice(int streamID, int varID, int levelID, const double *data_vec, int nmiss);


/* STREAM record I/O routines */

void    streamInqRecord(int streamID, int *varID, int *levelID);
void    streamDefRecord(int streamID, int  varID, int  levelID);
void    streamReadRecord(int streamID, double *data_vec, int *nmiss);
void    streamWriteRecord(int streamID, const double *data_vec, int nmiss);
void    streamCopyRecord(int streamIDdest, int streamIDsrc);

void    streamInqGinfo(int streamID, int *intnum, float *fltnum);

/* VLIST routines */

/*      vlistCreate: Create a variable list */
int     vlistCreate(void);

/*      vlistDestroy: Destroy a variable list */
void    vlistDestroy(int vlistID);

/*      vlistDuplicate: Duplicate a variable list */
int     vlistDuplicate(int vlistID);

/*      vlistCopy: Copy a variable list */
void    vlistCopy(int vlistID2, int vlistID1);

/*      vlistCopyFlag: Copy some entries of a variable list */
void    vlistCopyFlag(int vlistID2, int vlistID1);

void    vlistClearFlag(int vlistID);

/*      vlistCat: Concatenate two variable lists */
void    vlistCat(int vlistID2, int vlistID1);

/*      vlistMerge: Merge two variable lists */
void    vlistMerge(int vlistID2, int vlistID1);

void    vlistPrint(int vlistID);

/*      vlistNumber: Number type in a variable list */
int     vlistNumber(int vlistID);

/*      vlistNvars: Number of variables in a variable list */
int     vlistNvars(int vlistID);

/*      vlistNgrids: Number of grids in a variable list */
int     vlistNgrids(int vlistID);

/*      vlistNzaxis: Number of zaxis in a variable list */
int     vlistNzaxis(int vlistID);

void    vlistDefNtsteps(int vlistID, int nts);
int     vlistNtsteps(int vlistID);
int     vlistGridsizeMax(int vlistID);
int     vlistGrid(int vlistID, int index);
int     vlistGridIndex(int vlistID, int gridID);
void    vlistChangeGridIndex(int vlistID, int index, int gridID);
void    vlistChangeGrid(int vlistID, int gridID1, int gridID2);
int     vlistZaxis(int vlistID, int index);
int     vlistZaxisIndex(int vlistID, int zaxisID);
void    vlistChangeZaxisIndex(int vlistID, int index, int zaxisID);
void    vlistChangeZaxis(int vlistID, int zaxisID1, int zaxisID2);
int     vlistNrecs(int vlistID);

/*      vlistDefTaxis: Define the time axis of a variable list */
void    vlistDefTaxis(int vlistID, int taxisID);

/*      vlistInqTaxis: Get the time axis of a variable list */
int     vlistInqTaxis(int vlistID);

void    vlistDefTable(int vlistID, int tableID);
int     vlistInqTable(int vlistID);
void    vlistDefInstitut(int vlistID, int instID);
int     vlistInqInstitut(int vlistID);
void    vlistDefModel(int vlistID, int modelID);
int     vlistInqModel(int vlistID);


/* VLIST VAR routines */

/*      vlistDefVar: Create a new Variable */
int     vlistDefVar(int vlistID, int gridID, int zaxisID, int timeID);

void    vlistChangeVarGrid(int vlistID, int varID, int gridID);
void    vlistChangeVarZaxis(int vlistID, int varID, int zaxisID);

void    vlistInqVar(int vlistID, int varID, int *gridID, int *zaxisID, int *timeID);
int     vlistInqVarGrid(int vlistID, int varID);
int     vlistInqVarZaxis(int vlistID, int varID);
int     vlistInqVarTime(int vlistID, int varID);

void    vlistDefVarZtype(int vlistID, int varID, int ztype);
int     vlistInqVarZtype(int vlistID, int varID);
void    vlistDefVarZlevel(int vlistID, int varID, int zlevel);
int     vlistInqVarZlevel(int vlistID, int varID);

/*      vlistDefVarParam: Define the parameter number of a Variable */
void    vlistDefVarParam(int vlistID, int varID, int param);

/*      vlistInqVarParam: Get the parameter number of a Variable */
int     vlistInqVarParam(int vlistID, int varID);

/*      vlistDefVarCode: Define the code number of a Variable */
void    vlistDefVarCode(int vlistID, int varID, int code);

/*      vlistInqVarCode: Get the code number of a Variable */
int     vlistInqVarCode(int vlistID, int varID);

/*      vlistDefVarDatatype: Define the data type of a Variable */
void    vlistDefVarDatatype(int vlistID, int varID, int datatype);

/*      vlistInqVarDatatype: Get the data type of a Variable */
int     vlistInqVarDatatype(int vlistID, int varID);

int     vlistInqVarNumber(int vlistID, int varID);

void    vlistDefVarInstitut(int vlistID, int varID, int instID);
int     vlistInqVarInstitut(int vlistID, int varID);
void    vlistDefVarModel(int vlistID, int varID, int modelID);
int     vlistInqVarModel(int vlistID, int varID);
void    vlistDefVarTable(int vlistID, int varID, int tableID);
int     vlistInqVarTable(int vlistID, int varID);

/*      vlistDefVarName: Define the name of a Variable */
void    vlistDefVarName(int vlistID, int varID, const char *name);

/*      vlistInqVarName: Get the name of a Variable */
void    vlistInqVarName(int vlistID, int varID, char *name);

/*      vlistDefVarStdname: Define the standard name of a Variable */
void    vlistDefVarStdname(int vlistID, int varID, const char *stdname);

/*      vlistInqVarStdname: Get the standard name of a Variable */
void    vlistInqVarStdname(int vlistID, int varID, char *stdname);

/*      vlistDefVarLongname: Define the long name of a Variable */
void    vlistDefVarLongname(int vlistID, int varID, const char *longname);

/*      vlistInqVarLongname: Get the long name of a Variable */
void    vlistInqVarLongname(int vlistID, int varID, char *longname);

/*      vlistDefVarUnits: Define the units of a Variable */
void    vlistDefVarUnits(int vlistID, int varID, const char *units);

/*      vlistInqVarUnits: Get the units of a Variable */
void    vlistInqVarUnits(int vlistID, int varID, char *units);

/*      vlistDefVarMissval: Define the missing value of a Variable */
void    vlistDefVarMissval(int vlistID, int varID, double missval);

/*      vlistInqVarMissval: Get the missing value of a Variable */
double  vlistInqVarMissval(int vlistID, int varID);

void    vlistDefVarScalefactor(int vlistID, int varID, double scalefactor);
double  vlistInqVarScalefactor(int vlistID, int varID);
void    vlistDefVarAddoffset(int vlistID, int varID, double addoffset);
double  vlistInqVarAddoffset(int vlistID, int varID);

void    vlistDefVarTsteptype(int vlistID, int varID, int tsteptype);
int     vlistInqVarTsteptype(int vlistID, int varID);
void    vlistDefVarTimave(int vlistID, int varID, int timave);
int     vlistInqVarTimave(int vlistID, int varID);
void    vlistDefVarTimaccu(int vlistID, int varID, int timaccu);
int     vlistInqVarTimaccu(int vlistID, int varID);

int     vlistInqVarSize(int vlistID, int varID);
int     vlistInqVarID(int vlistID, int code);

void    vlistDefIndex(int vlistID, int varID, int levID, int index);
int     vlistInqIndex(int vlistID, int varID, int levID);
void    vlistDefFlag(int vlistID, int varID, int levID, int flag);
int     vlistInqFlag(int vlistID, int varID, int levID);
int     vlistFindVar(int vlistID, int fvarID);
int     vlistFindLevel(int vlistID, int fvarID, int flevelID);
int     vlistMergedVar(int vlistID, int varID);
int     vlistMergedLevel(int vlistID, int varID, int levelID);


/* VLIST attributes */

/*      vlistInqNatts: Get number of variable attributes assigned to this variable */
int     vlistInqNatts(int vlistID, int varID, int *nattsp);
/*      vlistInqAtt: Get information about an attribute */
int     vlistInqAtt(int vlistID, int varID, int attrnum, char *name, int *typep, int *lenp);
int     vlistDelAtt(int vlistID, int varID, const char *name);

/*      vlistDefAttInt: Define an integer attribute */
int     vlistDefAttInt(int vlistID, int varID, const char *name, int len, const int *ip_vec);
/*      vlistDefAttInt: Define a floating point attribute */
int     vlistDefAttFlt(int vlistID, int varID, const char *name, int len, const double *dp_vec);
/*      vlistDefAttInt: Define a text attribute */
int     vlistDefAttTxt(int vlistID, int varID, const char *name, int len, const char *tp);

/*      vlistInqAttInt: Get the value(s) of an integer attribute */
int     vlistInqAttInt(int vlistID, int varID, const char *name, int mlen, int *ip_vec);
/*      vlistInqAttInt: Get the value(s) of a floating point attribute */
int     vlistInqAttFlt(int vlistID, int varID, const char *name, int mlen, double *dp_vec);
/*      vlistInqAttInt: Get the value(s) of a text attribute */
int     vlistInqAttTxt(int vlistID, int varID, const char *name, int mlen, char *tp);


/* GRID routines */

void    gridName(int gridtype, char *gridname);
char   *gridNamePtr(int gridtype);

void    gridCompress(int gridID);

void    gridDefMask(int gridID, const int *mask_vec);
int     gridInqMask(int gridID, int *mask_vec);

void    gridPrint(int gridID, int opt);
int     gridSize(void);

/*      gridCreate: Create a horizontal Grid */
int     gridCreate(int gridtype, int size);

/*      gridDestroy: Destroy a horizontal Grid */
void    gridDestroy(int gridID);

/*      gridDuplicate: Duplicate a Grid */
int     gridDuplicate(int gridID);

/*      gridInqType: Get the type of a Grid */
int     gridInqType(int gridID);

/*      gridInqSize: Get the size of a Grid */
int     gridInqSize(int gridID);

/*      gridDefXsize: Define the size of a X-axis */
void    gridDefXsize(int gridID, int xsize);

/*      gridInqXsize: Get the size of a X-axis */
int     gridInqXsize(int gridID);

/*      gridDefYsize: Define the size of a Y-axis */
void    gridDefYsize(int gridID, int ysize);

/*      gridInqYsize: Get the size of a Y-axis */
int     gridInqYsize(int gridID);

/*      gridDefXvals: Define the values of a X-axis */
void    gridDefXvals(int gridID, const double *xvals_vec);

/*      gridInqXvals: Get all values of a X-axis */
int     gridInqXvals(int gridID, double *xvals_vec);

/*      gridDefYvals: Define the values of a Y-axis */
void    gridDefYvals(int gridID, const double *yvals_vec);

/*      gridInqYvals: Get all values of a Y-axis */
int     gridInqYvals(int gridID, double *yvals_vec);

/*      gridDefXname: Define the name of a X-axis */
void    gridDefXname(int gridID, const char *xname);

/*      gridDefXlongname: Define the longname of a X-axis  */
void    gridDefXlongname(int gridID, const char *xlongname);

/*      gridDefXunits: Define the units of a X-axis */
void    gridDefXunits(int gridID, const char *xunits);

/*      gridDefYname: Define the name of a Y-axis */
void    gridDefYname(int gridID, const char *yname);

/*      gridDefYlongname: Define the longname of a Y-axis */
void    gridDefYlongname(int gridID, const char *ylongname);

/*      gridDefYunits: Define the units of a Y-axis */
void    gridDefYunits(int gridID, const char *yunits);

/*      gridInqXname: Get the name of a X-axis */
void    gridInqXname(int gridID, char *xname);

/*      gridInqXlongname: Get the longname of a X-axis */
void    gridInqXlongname(int gridID, char *xlongname);

/*      gridInqXstdname: Get the standard name of a X-axis */
void    gridInqXstdname(int gridID, char *xstdname);

/*      gridInqXunits: Get the units of a X-axis */
void    gridInqXunits(int gridID, char *xunits);

/*      gridInqYname: Get the name of a Y-axis */
void    gridInqYname(int gridID, char *yname);

/*      gridInqYlongname: Get the longname of a Y-axis */
void    gridInqYlongname(int gridID, char *ylongname);

/*      gridInqYstdname: Get the standard name of a Y-axis */
void    gridInqYstdname(int gridID, char *ystdname);

/*      gridInqYunits: Get the units of a Y-axis */
void    gridInqYunits(int gridID, char *yunits);

/*      gridDefPrec: Define the precision of a Grid */
void    gridDefPrec(int gridID, int prec);

/*      gridInqPrec: Get the precision of a Grid */
int     gridInqPrec(int gridID);

/*      gridInqXval: Get one value of a X-axis */
double  gridInqXval(int gridID, int index);

/*      gridInqYval: Get one value of a Y-axis */
double  gridInqYval(int gridID, int index);

double  gridInqXinc(int gridID);
double  gridInqYinc(int gridID);

int     gridIsCircular(int gridID);
int     gridIsRotated(int gridID);
double  gridInqXpole(int gridID);
void    gridDefXpole(int gridID, double xpole);
double  gridInqYpole(int gridID);
void    gridDefYpole(int gridID, double ypole);
double  gridInqAngle(int gridID);
void    gridDefAngle(int gridID, double angle);
void    gridDefTrunc(int gridID, int trunc);
int     gridInqTrunc(int gridID);
/* Hexagonal GME grid */
int     gridInqGMEnd(int gridID);
void    gridDefGMEnd(int gridID, int nd);
int     gridInqGMEni(int gridID);
void    gridDefGMEni(int gridID, int ni);
int     gridInqGMEni2(int gridID);
void    gridDefGMEni2(int gridID, int ni2);
int     gridInqGMEni3(int gridID);
void    gridDefGMEni3(int gridID, int ni3);

/* Lambert Conformal Conic grid (GRIB version) */
void gridDefLCC(int gridID, double originLon, double originLat, double lonParY, double lat1, double lat2, double xinc, double yinc, int projflag, int scanflag);
void gridInqLCC(int gridID, double *originLon, double *originLat, double *lonParY, double *lat1, double *lat2, double *xinc, double *yinc, int *projflag, int *scanflag);

/* Lambert Conformal Conic 2 grid (PROJ version) */
void gridDefLcc2(int gridID, double earth_radius, double lon_0, double lat_0, double lat_1, double lat_2);
void gridInqLcc2(int gridID, double *earth_radius, double *lon_0, double *lat_0, double *lat_1, double *lat_2);

/* Lambert Azimuthal Equal Area grid */
void gridDefLaea(int gridID, double earth_radius, double lon_0, double lat_0);
void gridInqLaea(int gridID, double *earth_radius, double *lon_0, double *lat_0);


void    gridDefArea(int gridID, const double *area_vec);
void    gridInqArea(int gridID, double *area_vec);
int     gridHasArea(int gridID);

/*      gridDefNvertex: Define the number of vertex of a Gridbox */
void    gridDefNvertex(int gridID, int nvertex);

/*      gridInqNvertex: Get the number of vertex of a Gridbox */
int     gridInqNvertex(int gridID);

/*      gridDefXbounds: Define the bounds of a X-axis */
void    gridDefXbounds(int gridID, const double *xbounds_vec);

/*      gridInqXbounds: Get the bounds of a X-axis */
int     gridInqXbounds(int gridID, double *xbounds_vec);

/*      gridDefYbounds: Define the bounds of a Y-axis */
void    gridDefYbounds(int gridID, const double *ybounds_vec);

/*      gridInqYbounds: Get the bounds of a Y-axis */
int     gridInqYbounds(int gridID, double *ybounds_vec);

void    gridDefRowlon(int gridID, int nrowlon, const int *rowlon_vec);
void    gridInqRowlon(int gridID, int *rowlon_vec);
void    gridChangeType(int gridID, int gridtype);

void    gridDefComplexPacking(int gridID, int lpack);
int     gridInqComplexPacking(int gridID);

/* ZAXIS routines */

void    zaxisName(int zaxistype, char *zaxisname);

/*      zaxisCreate: Create a vertical Z-axis */
int     zaxisCreate(int zaxistype, int size);

/*      zaxisDestroy: Destroy a vertical Z-axis */
void    zaxisDestroy(int zaxisID);

/*      zaxisInqType: Get the type of a Z-axis */
int     zaxisInqType(int zaxisID);

/*      zaxisInqSize: Get the size of a Z-axis */
int     zaxisInqSize(int zaxisID);

/*      zaxisDuplicate: Duplicate a Z-axis */
int     zaxisDuplicate(int zaxisID);

void    zaxisResize(int zaxisID, int size);

void    zaxisPrint(int zaxisID);
int     zaxisSize(void);

/*      zaxisDefLevels: Define the levels of a Z-axis */
void    zaxisDefLevels(int zaxisID, const double *levels_vec);

/*      zaxisInqLevels: Get all levels of a Z-axis */
void    zaxisInqLevels(int zaxisID, double *levels_vec);

/*      zaxisDefLevel: Define one level of a Z-axis */
void    zaxisDefLevel(int zaxisID, int levelID, double levels);

/*      zaxisInqLevel: Get one level of a Z-axis */
double  zaxisInqLevel(int zaxisID, int levelID);

/*      zaxisDefName: Define the name of a Z-axis */
void    zaxisDefName(int zaxisID, const char *name);

/*      zaxisDefLongname: Define the longname of a Z-axis */
void    zaxisDefLongname(int zaxisID, const char *longname);

/*      zaxisDefUnits: Define the units of a Z-axis */
void    zaxisDefUnits(int zaxisID, const char *units);

/*      zaxisInqName: Get the name of a Z-axis */
void    zaxisInqName(int zaxisID, char *name);

/*      zaxisInqLongname: Get the longname of a Z-axis */
void    zaxisInqLongname(int zaxisID, char *longname);

/*      zaxisInqUnits: Get the units of a Z-axis */
void    zaxisInqUnits(int zaxisID, char *units);

void    zaxisDefPrec(int zaxisID, int prec);
int     zaxisInqPrec(int zaxisID);

void    zaxisDefLtype(int zaxisID, int ltype);
int     zaxisInqLtype(int zaxisID);

const double *zaxisInqLevelsPtr(int zaxisID);
void    zaxisDefVct(int zaxisID, int size, const double *vct_vec);
int     zaxisInqVctSize(int zaxisID);
const double *zaxisInqVctPtr(int zaxisID);
int     zaxisInqLbounds(int zaxisID, double *lbounds_vec);
int     zaxisInqUbounds(int zaxisID, double *ubounds_vec);
int     zaxisInqWeights(int zaxisID, double *weights_vec);
double  zaxisInqLbound(int zaxisID, int index);
double  zaxisInqUbound(int zaxisID, int index);
void    zaxisDefLbounds(int zaxisID, const double *lbounds_vec);
void    zaxisDefUbounds(int zaxisID, const double *ubounds_vec);
void    zaxisDefWeights(int zaxisID, const double *weights_vec);
void    zaxisChangeType(int zaxisID, int zaxistype);

/* TAXIS routines */

/*      taxisCreate: Create a Time axis */
int     taxisCreate(int timetype);

/*      taxisDestroy: Destroy a Time axis */
void    taxisDestroy(int taxisID);

int     taxisDuplicate(int taxisID);

void    taxisCopyTimestep(int taxisIDdes, int taxisIDsrc);

void    taxisDefType(int taxisID, int type);

/*      taxisDefVdate: Define the verification date */
void    taxisDefVdate(int taxisID, int date);

/*      taxisDefVtime: Define the verification time */
void    taxisDefVtime(int taxisID, int time);

/*      taxisDefRdate: Define the reference date */
void    taxisDefRdate(int taxisID, int date);

/*      taxisDefRtime: Define the reference date */
void    taxisDefRtime(int taxisID, int time);

int     taxisHasBounds(int taxisID);

void    taxisDeleteBounds(int taxisID);

void    taxisDefVdateBounds(int taxisID, int vdate_lb, int vdate_ub);

void    taxisDefVtimeBounds(int taxisID, int vtime_lb, int vtime_ub);

void    taxisInqVdateBounds(int taxisID, int *vdate_lb, int *vdate_ub);

void    taxisInqVtimeBounds(int taxisID, int *vtime_lb, int *vtime_ub);

/*      taxisDefCalendar: Define the calendar */
void    taxisDefCalendar(int taxisID, int calendar);

void    taxisDefTunit(int taxisID, int tunit);

void    taxisDefNumavg(int taxisID, int numavg);

int     taxisInqType(int taxisID);

/*      taxisInqVdate: Get the verification date */
int     taxisInqVdate(int taxisID);

/*      taxisInqVtime: Get the verification time */
int     taxisInqVtime(int taxisID);

/*      taxisInqRdate: Get the reference date */
int     taxisInqRdate(int taxisID);

/*      taxisInqRtime: Get the reference time */
int     taxisInqRtime(int taxisID);

/*      taxisInqCalendar: Get the calendar */
int     taxisInqCalendar(int taxisID);

int     taxisInqTunit(int taxisID);

int     taxisInqNumavg(int taxisID);

char   *tunitNamePtr(int tunitID);


/* Institut routines */

int     institutDef(int center, int subcenter, const char *name, const char *longname);
int     institutInq(int center, int subcenter, const char *name, const char *longname);
int     institutInqNumber(void);
int     institutInqCenter(int instID);
int     institutInqSubcenter(int instID);
char   *institutInqNamePtr(int instID);
char   *institutInqLongnamePtr(int instID);

/* Model routines */

int     modelDef(int instID, int modelgribID, const char *name);
int     modelInq(int instID, int modelgribID, char *name);
int     modelInqInstitut(int modelID);
int     modelInqGribID(int modelID);
char   *modelInqNamePtr(int modelID);

/* Table routines */

void    tableWriteC(const char *filename, int tableID);
void    tableWrite(const char *filename, int tableID);
int     tableRead(const char *tablefile);
int     tableDef(int modelID, int tablenum, const char *tablename);

char   *tableInqNamePtr(int tableID);
void    tableDefEntry(int tableID, int code, const char *name, const char *longname, const char *units);

int     tableInq(int modelID, int tablenum, const char *tablename);
int     tableInqNumber(void);

int     tableInqNum(int tableID);
int     tableInqModel(int tableID);

void    tableInqPar(int tableID, int code, char *name, char *longname, char *units);

int     tableInqParCode(int tableID, char *name, int *code);
int     tableInqParName(int tableID, int code, char *name);
int     tableInqParLongname(int tableID, int code, char *longname);
int     tableInqParUnits(int tableID, int code, char *units);

char   *tableInqParNamePtr(int tableID, int parID);
char   *tableInqParLongnamePtr(int tableID, int parID);
char   *tableInqParUnitsPtr(int tableID, int parID);

/* History routines */

void    streamDefHistory(int streamID, int size, const char *history);
int     streamInqHistorySize(int streamID);
void    streamInqHistoryString(int streamID, char *history);

#if defined (__cplusplus)
}
#endif

#endif  /* _CDI_H */
#ifndef  _TIMEBASE_H
#define  _TIMEBASE_H

/* date format:  YYYYMMDD */
/* time format:  hhmmss   */

void decode_julday(int calendar, int julday, int *year, int *mon, int *day);
int  encode_julday(int calendar, int year, int month, int day);

int date_to_julday(int calendar, int date);
int julday_to_date(int calendar, int julday);

int time_to_sec(int time);
int sec_to_time(int secofday);

void   julday_add_seconds(int seconds, int *julday, int *secofday);
void   julday_add(int days, int secs, int *julday, int *secofday);
double julday_sub(int julday1, int secofday1, int julday2, int secofday2, int *days, int *secs);

void encode_juldaysec(int calendar, int year, int month, int day, int hour, int minute, int *julday, int *secofday);
void decode_juldaysec(int calendar, int julday, int secofday, int *year, int *month, int *day, int *hour, int *minute);

#endif  /* _TIMEBASE_H */
#ifndef _CALENDAR_H
#define _CALENDAR_H

void encode_caldaysec(int calendar, int year, int month, int day, int hour, int minute, int second,
		      int *julday, int *secofday);
void decode_caldaysec(int calendar, int julday, int secofday, 
		      int *year, int *month, int *day, int *hour, int *minute, int *second);

#endif  /* _CALENDAR_H */
#ifndef _BASETIME_H
#define _BASETIME_H


typedef struct {
  int   ncvarid;
  int   ncdimid;
  int   ncvarboundsid;
}
BaseTime;

void basetimeInit(BaseTime *basetime);

#endif  /* _BASETIME_H */
typedef struct
{
  long date;
  long time;
}
DateTime;
#ifndef _STREAM_INT_H
#define _STREAM_INT_H

#if defined (HAVE_CONFIG_H)
#  include "config.h"
#endif

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>

#ifndef strdupx
#ifndef strdup
char *strdup(const char *s);
#endif
#define strdupx  strdup
/*
#define strdupx(s)			          \
({					      	  \
   const char *__old = (s);			  \
   size_t __len = strlen(__old) + 1;		  \
   char *__new = (char *) malloc(__len);	  \
   (char *) memcpy(__new, __old, __len);	  \
})
*/
#endif

#ifndef M_PI
#define M_PI		3.14159265358979323846	/* pi */
#endif


#ifndef  _ERROR_H
#  include "error.h"
#endif
#ifndef _BASETIME_H
#  include "basetime.h"
#endif
#ifndef _TIMEBASE_H
#  include "timebase.h"
#endif
#ifndef  _TAXIS_H
#  include "taxis.h"
#endif
#ifndef  _CDI_LIMITS_H
#  include "cdi_limits.h"
#endif
#ifndef  _SERVICE_H
#  include "service.h"
#endif
#ifndef  _EXTRA_H
#  include "extra.h"
#endif
#ifndef  _IEG_H
#  include "ieg.h"
#endif


#if defined (__xlC__) /* performance problems on IBM */
#ifndef DBL_IS_NAN
#  define DBL_IS_NAN(x)     ((x) != (x))
#endif
#else
#ifndef DBL_IS_NAN
#if  defined  (HAVE_ISNAN)
#  define DBL_IS_NAN(x)     (isnan(x))
#elif  defined  (FP_NAN)
#  define DBL_IS_NAN(x)     (fpclassify(x) == FP_NAN)
#else
#  define DBL_IS_NAN(x)     ((x) != (x))
#endif
#endif
#endif

#ifndef DBL_IS_EQUAL
/*#define DBL_IS_EQUAL(x,y) (!(x < y || y < x)) */
#  define DBL_IS_EQUAL(x,y) (DBL_IS_NAN(x)||DBL_IS_NAN(y)?(DBL_IS_NAN(x)&&DBL_IS_NAN(y)?1:0):!(x < y || y < x))
#endif

#ifndef IS_EQUAL
#  define IS_NOT_EQUAL(x,y) (x < y || y < x)
#  define IS_EQUAL(x,y)     (!IS_NOT_EQUAL(x,y))
#endif


#ifndef INT
#  define  INT(x)  ((int)(x))
#endif

#ifndef NINT
#  define  NINT(x)  ((x) < 0 ? (int)((x)-.5) : (int)((x)+.5))
#endif

#define  FALSE  0
#define  TRUE   1

#define  TYPE_REC  0
#define  TYPE_VAR  1


typedef struct
{
  void     *buffer;
  size_t    buffersize;
  off_t     position;
  int       recsize;
  int       size;
  int       dataread;
  int       param;
  int       level;
  int       date;
  int       time;
  int       gridID;
  int       zaxisID;
  int       used;
  int       nrec;
  int       varID;
  int       levelID;
  int       recid;
  int       prec;
  int       sec0[2];
  int       sec1[1024];
  int       sec2[4096];
  int       sec3[2];
  int       sec4[512];
#if  defined  (HAVE_LIBSERVICE)
  srvrec_t   *srvp;
#endif
#if  defined  (HAVE_LIBEXTRA)
  extrec_t *extp;
#endif
#if  defined  (HAVE_LIBIEG)
  iegrec_t   *iegp;
#endif
}
Record;


typedef struct
{
  off_t     position;
  size_t    size;
  int       zip;
  int       param;
  int       ilevel;
  int       ilevel2;
  int       ltype;
  short     used;
  short     varID;
  short     levelID;
}
record_t;


typedef struct {
  record_t *records;
  int       recordSize;  /* number of allocated records           */
  int      *recIDs;      /* IDs of non constant records           */
  int       nrecs;       /* number of used records                */
                         /* tsID=0 nallrecs                       */
                         /* tsID>0 number of non constant records */
  int       nallrecs;    /* number of all records                 */
  int       curRecID;    /* current record ID                     */
  long      next;
  off_t     position;    /* timestep file position                */
  taxis_t   taxis;
}
TSTEPS;


typedef struct {
  int       ncvarid;
  int       nlevs;
  int      *level;       /* record IDs */
  int      *lindex;      /* level index */
  int       defmiss;     /* TRUE if missval is defined in file */

  int       isUsed;
  int       gridID;
  int       zaxisID;
  int       timeID;      /* ( TIME_VARIABLE or TIME_CONSTANT ) */
  int       nlevel;
}
SVARINFO;


typedef struct {
  int       ilev;
  int       mlev;
  int       ilevID;
  int       mlevID;
}
VCT;


typedef struct {
  int       self;
  int       accesstype;   /* TYPE_REC or TYPE_VAR */
  int       accessmode;
  int       filetype;
  int       byteorder;
  int       fileID;
  int       dimgroupID;
  int       filemode;
  off_t     numvals;
  char     *filename;
  Record   *record;
  int       nrecs;        /* number of records                  */
  int       nvars;        /* number of variables                */
  int       varlocked;    /* variables locked                   */
  SVARINFO *vars;
  int       varsAllocated;
  int       varinit;
  int       curTsID;      /* current timestep ID */
  int       rtsteps;      /* number of tsteps accessed       */
  long      ntsteps;      /* number of tsteps : only set if all records accessed */
  int       numTimestep;  /* number of tsteps : only set if all records accessed */
  TSTEPS   *tsteps;
  int       tstepsTableSize;
  int       tstepsNextID;
  BaseTime  basetime;
  int       ncmode;
  int       vlistID;
  int       xdimID[MAX_GRIDS_PS];
  int       ydimID[MAX_GRIDS_PS];
  int       zaxisID[MAX_ZAXES_PS];
  int       ncxvarID[MAX_GRIDS_PS];
  int       ncyvarID[MAX_GRIDS_PS];
  int       ncavarID[MAX_GRIDS_PS];
  int       historyID;
  int       globalatts;
  int       localatts;
  VCT       vct;
  int       unreduced;
  int       sortname;
  int       have_missval;
  int       ztype;
  int       zlevel;
  int       curfile;
  int       nfiles;
  char    **fnames;
  int       gribHandleNums;
  void    **gribHandle;
}
stream_t;


extern int CDI_Debug;      /* If set to 1, debuggig (default 0)            */
extern double cdiDefaultMissval;
extern int cdiDefaultInstID;
extern int cdiDefaultModelID;
extern int cdiDefaultTableID;
extern int cdiDefaultLeveltype;
extern int cdiNcMissingValue;
extern int cdiSplitLtype105;

extern char *cdiPartabPath;
extern int   cdiPartabIntern;

stream_t *stream_to_pointer(int idx);
stream_t *stream_new_entry(void);
void stream_delete_entry(stream_t *streamptr);
void stream_check_ptr(const char *func, stream_t *streamptr);

int     streamInqFileID(int streamID);

int     zaxisInqLevelID(int zaxisID, double level);
char   *gridNamePtr(int gridtype);
char   *zaxisNamePtr(int leveltype);

void    streamCheckID(const char *func, int streamID);

void    streamDefineTaxis(int streamID);

int     streamsNewEntry(int filetype);
void    streamsInitEntry(int streamID);
int     streamNewVar(int streamID, int gridID, int zaxisID);

int     tstepsNewEntry(int streamID);

char   *strfiletype(int filetype);

void    cdiGenVars(int streamID);

void    cdiCheckContents(int streamID);

void    cdiCreateRecords(int streamID, int tsID);

int     recordNewEntry(int streamID, int tsID);

void    cdiCreateTimesteps(int streamID);

void    recordInitEntry(record_t *record);

void    cdiCheckZaxis(int zaxisID);

void    cdiPrintDatatypes(void);

void    cdiDefAccesstype(int streamID, int type);
int     cdiInqAccesstype(int streamID);

void    streamDefDimgroupID(int streamID, int dimgroupID);
int     streamInqDimgroupID(int streamID);

int getByteswap(int byteorder);


#endif  /* _STREAM_INT_H */
#ifndef _STREAM_CGRIBEX_H
#define _STREAM_CGRIBEX_H

void cgribexScanTimestep1(int streamID);
int cgribexScanTimestep2(int streamID);
int cgribexScanTimestep(int streamID);

int cgribexDecode(unsigned char *gribbuffer, int gribsize, double *data, int gridsize,
		  int unreduced, int *nmiss, int *zip, double missval);

size_t cgribexEncode(int varID, int levelID, int vlistID, int gridID, int zaxisID,
		     int vdate, int vtime, int tsteptype, int numavg, 
		     long datasize, const double *data, int nmiss, unsigned char *gribbuffer, size_t gribbuffersize);

#endif  /* _STREAM_CGRIBEX_H */
#ifndef _STREAM_GRIBAPI_H
#define _STREAM_GRIBAPI_H

void gribapiScanTimestep1(int streamID);
int gribapiScanTimestep2(int streamID);
int gribapiScanTimestep(int streamID);

int gribapiDecode(unsigned char *gribbuffer, int gribsize, double *data, int gridsize,
		  int unreduced, int *nmiss, int *zip, double missval);

size_t gribapiEncode(int varID, int levelID, int vlistID, int gridID, int zaxisID,
		     int vdate, int vtime, int tsteptype, int numavg, 
		     long datasize, const double *data, int nmiss, unsigned char *gribbuffer, size_t gribbuffersize,
		     int ljpeg, void *gribHandle);

#endif  /* _STREAM_GRIBAPI_H */
#ifndef _STREAM_GRB_H
#define _STREAM_GRB_H

int   grbBitsPerValue(int datatype);

int   grbInqContents(int streamID);
int   grbInqTimestep(int streamID, int tsID);

int   grbInqRecord(int streamID, int *varID, int *levelID);
int   grbDefRecord(int streamID);
int   grbWriteRecord(int streamID, const double *data, int nmiss);
int   grbReadRecord(int streamID, double *data, int *nmiss);
int   grbCopyRecord(int streamIDdest, int streamIDsrc);

void  grbReadVarDP(int streamID, int varID, double *data, int *nmiss);
void  grbWriteVarDP(int streamID, int varID, const double *data, int nmiss);

void  grbReadVarSliceDP(int streamID, int varID, int levelID, double *data, int *nmiss);
int   grbWriteVarSliceDP(int streamID, int varID, int levelID, const double *data, int nmiss);

#endif  /* _STREAM_GRB_H */
#ifndef _STREAM_CDF_H
#define _STREAM_CDF_H

void   cdfDefVars(int streamID);
void   cdfDefTimestep(int streamID, int tsID);
int    cdfInqTimestep(int streamID, int tsID);
int    cdfInqContents(int streamID);
void   cdfDefHistory(int streamID, int size, char *history);
int    cdfInqHistorySize(int streamID);
void   cdfInqHistoryString(int streamID, char *history);

void   cdfEndDef(int streamID);
int    cdfDefRecord(int streamID);
int    cdfCopyRecord(int streamIDdest, int streamIDsrc);
int    cdfReadRecord(int streamID, double *data, int *nmiss);
void   cdfWriteRecord(int streamID, const double *data, int nmiss);

void   cdfReadVarDP(int streamID, int varID, double *data, int *nmiss);
void   cdfWriteVarDP(int streamID, int varID, const double *data, int nmiss);

int    cdfReadVarSliceDP(int streamID, int varID, int levelID, double *data, int *nmiss);
int    cdfWriteVarSliceDP(int streamID, int varID, int levelID, const double *data, int nmiss);

#endif
#ifndef _TABLEPAR_H
#define _TABLEPAR_H

typedef struct
{
  int   id;	     /* Parameter number (GRIB) */
  char *name;	     /* Parameter name */
  char *longname;    /* Parameter long name */
  char *units;	     /* Parameter units */
}
PAR;


void tableLink(int tableID, PAR *pars, int npars);
int tableDef(int modelID, int tablegribID, const char *tablename);

#endif
#ifndef _TABLE_H
#define _TABLE_H

static PAR echam4[] = {
  {   4, "precip",      "total precipitation",                      "m/s"      },
  {  34, "low_cld",     "low cloud",                                 NULL      },
  {  35, "mid_cld",     "mid cloud",                                 NULL      },
  {  36, "hih_cld",     "high cloud",                                NULL      },
  { 129, "geosp",       "surface geopotential (orography)",         "m^2/s^2"  },
  { 130, "t",           "temperature",                              "K"        },
  { 131, "u",           "u-velocity",                               "m/s"      },
  { 132, "v",           "v-velocity",                               "m/s"      },
  { 133, "sq",          "specific humidity",                        "kg/kg"    },
  { 134, "aps",         "Surface pressure",                         "Pa"       },
  { 135, "omega",       "vertical velocity",                        "Pa/s"     },
  { 138, "svo",         "vorticity",                                "1/s"      },
  { 139, "ts",          "surface temperature",                      "K"        },
  { 140, "ws",          "soil wetness",                             "m"        },
  { 141, "sn",          "snow depth",                               "m"        },
  { 142, "aprl",        "large scale precipitation",                "m/s"      },
  { 143, "aprc",        "convective  precipitation",                "m/s"      },
  { 144, "aprs",        "snow fall",                                "m/s"      },
  { 145, "vdis",        "boundary layer dissipation",               "W/m^2"    },
  { 146, "ahfs",        "surface sensible heat flux",               "W/m^2"    },
  { 147, "ahfl",        "surface latent heat flux",                 "W/m^2"    },
  { 148, "stream",      "streamfunction",                           "m^2/s"    },
  { 149, "velopot",     "velocity potential",                       "m^2/s"    },
  { 151, "slp",         "mean sea level pressure",                  "Pa"       },
  { 152, "lsp",         "log surface pressure",                      NULL      },
  { 153, "sx",          "liquid water content",                     "kg/kg"    },
  { 155, "sd",          "divergence",                               "1/s"      },
  { 156, "geopoth",     "geopotential height",                      "m"        },
  { 157, "rhumidity",   "relative humidity",                        "fraction" },
  { 158, "var158",      "tendency of surface pressure",             "Pa/s"     },
  { 159, "ustar3",      "ustar3",                                   "m^3/s^3"  },
  { 160, "runoff",      "surface runoff",                           "m/s"      },
  { 161, "alwc",        "liquid water content",                     "kg/kg"    },
  { 162, "aclc",        "cloud cover",                              "fraction" },
  { 163, "aclcv",       "total cloud cover",                        "fraction" },
  { 164, "aclcov",      "total cloud cover",                        "fraction" },
  { 165, "u10",         "10m u-velocity",                           "m/s"      },
  { 166, "v10",         "10m v-velocity",                           "m/s"      },
  { 167, "temp2",       "2m temperature",                           "K"        },
  { 168, "dew2",        "2m dew point temperature",                 "K"        },
  { 169, "tsurf",       "surface temperature",                      "K"        },
  { 170, "td",          "deep soil temperature",                    "K"        },
  { 171, "wind10",      "10m windspeed",                            "m/s"      },
  { 172, "slm",         "land sea mask",                            "fraction" },
  { 173, "az0",         "surface roughness length",                 "m"        },
  { 174, "alb",         "surface background albedo",                "fraction" },
  { 175, "albedo",      "surface albedo",                           "fraction" },
  { 176, "srads",       "net surface solar radiation",              "W/m^2"    },
  { 177, "trads",       "net surface thermal radiation",            "W/m^2"    },
  { 178, "srad0",       "net top solar radiation",                  "W/m^2"    },
  { 179, "trad0",       "top thermal radiation (OLR)",              "W/m^2"    },
  { 180, "ustr",        "surface u-stress",                         "Pa"       },
  { 181, "vstr",        "surface v-stress",                         "Pa"       },
  { 182, "evap",        "surface evaporation",                      "m/s"      },
  { 183, "tdcl",        "soil temperature",                         "K"        },
  { 185, "srafs",       "net surf. solar radiation   (clear sky)",  "W/m^2"    },
  { 186, "trafs",       "net surf. thermal radiation (clear sky)",  "W/m^2"    },
  { 187, "sraf0",       "net top solar radiation     (clear sky)",  "W/m^2"    },
  { 188, "traf0",       "net top thermal radiation   (clear sky)",  "W/m^2"    },
  { 189, "sclfs",       "surface solar cloud forcing",              "W/m^2"    },
  { 190, "tclfs",       "surface thermal cloud forcing",            "W/m^2"    },
  { 191, "sclf0",       "top solar cloud forcing",                  "W/m^2"    },
  { 192, "tclf0",       "top thermal cloud forcing",                "W/m^2"    },
  { 193, "wl",          "skin reservoir content",                   "m"        },
  { 194, "wlm1",        "skin reservoir content of plants",         "m"        },
  { 195, "ustrgw",      "u-gravity wave stress",                    "Pa"       },
  { 196, "vstrgw",      "v-gravity wave stress",                    "Pa"       },
  { 197, "vdisgw",      "gravity wave dissipation",                 "W/m^2"    },
  { 198, "vgrat",       "vegetation ratio",                         "fraction" },
  { 199, "varor",       "orographic variance",                      "m^2"      },
  { 200, "vlt",         "leaf area index",                           NULL      },
  { 201, "t2max",       "maximum 2m-temperature",                   "K"        },
  { 202, "t2min",       "minimum 2m-temperature",                   "K"        },
  { 203, "srad0u",      "top solar radiation upward",               "W/m^2"    },
  { 204, "sradsu",      "surface solar radiation upward",           "W/m^2"    },
  { 205, "tradsu",      "surface thermal radiation upward",         "W/m^2"    },
  { 206, "tsn",         "snow temperature",                         "K"        },
  { 207, "td3",         "soil temperature 3",                       "K"        },
  { 208, "td4",         "soil temperature 4",                       "K"        },
  { 209, "td5",         "soil temperature 5",                       "K"        },
  { 210, "seaice",      "sea ice cover",                            "fraction" },
  { 211, "siced",       "sea ice depth",                            "m"        },
  { 212, "forest",      "vegetation type",                          "fraction" },
  { 213, "teff",        "(effective) sea-ice skin temperature",     "K"        },
  { 214, "tsmax",       "maximum surface temperature",              "K"        },
  { 215, "tsmin",       "minimum surface temperature",              "K"        },
  { 216, "wimax",       "maximum 10m-wind speed",                   "m/s"      },
  { 217, "topmax",      "maximum height of convective cloud tops",  "Pa"       },
  { 218, "snmel",       "snow melt",                                "m/s"      },
  { 219, "runtoc",      "surface runoff into ocean",                 NULL      },
  { 220, "tslin",       "land: residual surface heat budget",       "W/m^2"    },
  { 221, "dsnac",       "snow depth change",                        "m/s"      },
  { 222, "alwcac",      "liquid water content",                     "kg/kg"    },
  { 223, "aclcac",      "cloud cover",                              "fraction" },
  { 224, "tke",         "turbulent kinetic energy",                  NULL      },
  { 225, "tkem1",       "turbulent kinetic energy (t-1)",            NULL      },
  { 226, "fao",         "FAO data set (soil data flags)",            NULL      },
  { 227, "rgcgn",       "heat capacity of soil",                     NULL      },
  { 228, "sodif",       "soil diffusivity",                          NULL      },
  { 229, "wsmx",        "field capacity of soil",                   "m"        },
  { 230, "qvi",         "vertically integrated specific humidity",  "kg/m^2"   },
  { 231, "alwcvi",      "vertically integrated liquid water cont.", "kg/m^2"   },
  { 232, "glac",        "glacier mask",                             "fraction" },
  { 233, "runlnd",      "surface runoff not running into ocean",     NULL      },
  { 259, "windspeed",   "windspeed (sqrt(u^2+v^2))",                 NULL      },
  { 260, "precip",      "total precipitation",                      "m/s"      },
  { 261, "net_top",     "total top radiation",                       NULL      },
  { 262, "net_bot",     "total surface radiation",                   NULL      },
  { 263, "net_heat",    "net surface heat flux",                     NULL      },
  { 264, "net_water",   "total surface water",                       NULL      },
  { 268, "sw_atm",       NULL,                                       NULL      },
  { 269, "lw_atm",       NULL,                                       NULL      },
  { 270, "net_atm",      NULL,                                       NULL      },
  { 271, "surf_runoff", "surface runoff",                            NULL      },
  { 275, "fresh_water",  NULL,                                       NULL      },
};

static PAR echam5[] = {
  {   4, "precip",     "total precipitation",                       "kg/m^2s" },
  {  79, "swnirac",    "net surface NIR flux acc.",                 "W/m^2"   },
  {  80, "swdifnirac", "fraction of diffuse NIR acc.",              "W/m^2"   },
  {  81, "swvisac",    "net surface visible flux acc.",             "W/m^2"   },
  {  82, "swdifvisac", "fraction of diffuse visible acc.",          "W/m^2"   },
  {  83, "ocu",        "ocean eastw. velocity (coupled mode)",      "m/s"     },
  {  84, "ocv",        "ocean northw. velocity (coupled mode)",     "m/s"     },
  {  85, "tradl",      "net LW radiation 200mb",                    "W/m^2"   },
  {  86, "sradl",      "net SW radiation 200mb",                    "W/m^2"   },
  {  87, "trafl",      "net LW radiation 200mb (clear sky)",        "W/m^2"   },
  {  88, "srafl",      "net SW radiation 200mb (clear sky)",        "W/m^2"   },
  {  89, "amlcorac",   "mixed layer flux correction",               "W/m^2"   },
  {  90, "amlheatac",  "mixed layer heat content",                  "J/m^2"   },
  {  91, "trfliac",    "net LW radiation over ice",                 "W/m^2"   },
  {  92, "trflwac",    "net LW radiation over water",               "W/m^2"   },
  {  93, "trfllac",    "net LW radiation over land",                "W/m^2"   },
  {  94, "sofliac",    "net SW radiation over ice",                 "W/m^2"   },
  {  95, "soflwac",    "net SW radiation over water",               "W/m^2"   },
  {  96, "sofllac",    "net SW radiation over land",                "W/m^2"   },
  {  97, "friac",      "ice cover (fraction of grid box)",           NULL     },
  { 102, "tsi",        "surface temperature of ice",                "K"       },
  { 103, "tsw",        "surface temperature of water",              "K"       },
  { 104, "ustri",      "zonal      wind stress over ice",           "Pa"      },
  { 105, "vstri",      "meridional wind stress over ice",           "Pa"      },
  { 106, "ustrw",      "zonal      wind stress over water",         "Pa"      },
  { 107, "vstrw",      "meridional wind stress over water",         "Pa"      },
  { 108, "ustrl",      "zonal      wind stress over land",          "Pa"      },
  { 109, "vstrl",      "meridional wind stress over land",          "Pa"      },
  { 110, "ahfliac",    "latent heat flux over ice",                 "W/m^2"   },
  { 111, "ahflwac",    "latent heat flux over water",               "W/m^2"   },
  { 112, "ahfllac",    "latent heat flux over land",                "W/m^2"   },
  { 113, "evapiac",    "evaporation over ice",                      "kg/m^2s" },
  { 114, "evapwac",    "evaporation over water",                    "kg/m^2s" },
  { 115, "evaplac",    "evaporation over land",                     "kg/m^2s" },
  { 116, "az0i",       "roughness length over ice",                 "m"       },
  { 117, "az0w",       "roughness length over water",               "m"       },
  { 118, "az0l",       "roughness length over land",                "m"       },
  { 119, "ahfsiac",    "sensible heat flux over ice",               "W/m^2"   },
  { 120, "ahfswac",    "sensible heat flux over water",             "W/m^2"   },
  { 121, "ahfslac",    "sensible heat flux over land",              "W/m^2"   },
  { 122, "alsoi",      "albedo of ice",                              NULL     },
  { 123, "alsow",      "albedo of water",                            NULL     },
  { 124, "alsol",      "albedo of land",                             NULL     },
  { 125, "ahfice",     "conductive heat flux through ice",          "W/m^2"   },
  { 126, "qres",       "residual heat flux for melting sea ice",    "W/m^2"   },
  { 127, "alake",      "lake fraction",                              NULL     },
  { 128, "rintop",     "low level inversion",                        NULL     },
  { 129, "geosp",      "surface geopotential (orography)",          "m^2/s^2" },
  { 130, "t",          "temperature",                               "K"       },
  { 131, "u",          "u-velocity",                                "m/s"     },
  { 132, "v",          "v-velocity",                                "m/s"     },
  { 133, "q",          "specific humidity",                         "kg/kg"   },
  { 134, "aps",        "surface pressure",                          "Pa"      },
  { 135, "omega",      "vertical velocity",                         "Pa/s"    },
  { 136, "acdnc",      "cloud droplet number concentration",        "1/m^3"   },
  { 137, "apmeb",      "(P-E) error",                               "kg/m^2s" },
  { 138, "svo",        "vorticity",                                 "1/s"     },
  { 139, "tslm1",      "surface temperature of land",               "K"       },
  { 140, "ws",         "soil wetness",                              "m"       },
  { 141, "sn",         "water equivalent snow depth",               "m"       },
  { 142, "aprl",       "large scale precipitation",                 "kg/m^2s" },
  { 143, "aprc",       "convective  precipitation",                 "kg/m^2s" },
  { 144, "aprs",       "snow fall",                                 "kg/m^2s" },
  { 145, "vdis",       "boundary layer dissipation",                "W/m^2"   },
  { 146, "ahfs",       "sensible heat flux",                        "W/m^2"   },
  { 147, "ahfl",       "latent heat flux",                          "W/m^2"   },
  { 148, "stream",     "streamfunction",                            "m^2/s"   },
  { 149, "velopot",    "velocity potential",                        "m^2/s"   },
  { 150, "xivi",       "vertically integrated cloud ice",           "kg/m^2"  },
  { 151, "slp",        "mean sea level pressure",                   "Pa"      },
  { 152, "lsp",        "log surface pressure",                       NULL     },
  { 153, "xl",         "cloud water",                               "kg/kg"   },
  { 154, "xi",         "cloud ice",                                 "kg/kg"   },
  { 155, "sd",         "divergence",                                "1/s"     },
  { 156, "geopoth",    "geopotential height",                       "m"       },
  { 157, "rhumidity",  "relative humidity",                          NULL     },
  { 159, "wind10w",    "10m windspeed over water",                  "m/s"     },
  { 160, "runoff",     "surface runoff and drainage",               "kg/m^2s" },
  { 161, "drain",      "drainage",                                  "kg/m^2s" },
  { 162, "aclc",       "cloud cover",                                NULL     },
  { 164, "aclcov",     "total cloud cover",                          NULL     },
  { 165, "u10",        "10m u-velocity",                            "m/s"     },
  { 166, "v10",        "10m v-velocity",                            "m/s"     },
  { 167, "temp2",      "2m temperature",                            "K"       },
  { 168, "dew2",       "2m dew point temperature",                  "K"       },
  { 169, "tsurf",      "surface temperature",                       "K"       },
  { 170, "xvar",       "variance of total water amount",            "kg/kg"   },
  { 171, "wind10",     "10m windspeed",                             "m/s"     },
  { 172, "slm",        "land sea mask (1. = land, 0. = sea/lakes)",  NULL     },
  { 173, "az0",        "roughness length",                          "m"       },
  { 174, "alb",        "surface background albedo",                  NULL     },
  { 175, "albedo",     "surface albedo",                             NULL     },
  { 176, "srads",      "net surface SW radiation",                  "W/m^2"   },
  { 177, "trads",      "net surface LW radiation",                  "W/m^2"   },
  { 178, "srad0",      "net top SW radiation",                      "W/m^2"   },
  { 179, "trad0",      "net top LW radiation (-OLR)",               "W/m^2"   },
  { 180, "ustr",       "u-stress",                                  "Pa"      },
  { 181, "vstr",       "v-stress",                                  "Pa"      },
  { 182, "evap",       "evaporation",                               "kg/m^2s" },
  { 183, "xskew",      "skewness of total water amount qv+qi+ql",    NULL     },
  { 184, "srad0d",     "top incoming SW radiation",                 "W/m^2"   },
  { 185, "srafs",      "net surface SW radiation (clear sky)",      "W/m^2"   },
  { 186, "trafs",      "net surface LW radiation (clear sky)",      "W/m^2"   },
  { 187, "sraf0",      "net top SW radiation   (clear sky)",        "W/m^2"   },
  { 188, "traf0",      "net top LW radiation   (clear sky)",        "W/m^2"   },
  { 189, "sclfs",      "net surface SW cloud forcing (176-185)",    "W/m^2"   },
  { 190, "tclfs",      "net surface LW cloud forcing (177-186)",    "W/m^2"   },
  { 191, "sclf0",      "net SW top cloud forcing (178-187)",        "W/m^2"   },
  { 192, "tclf0",      "net LW top cloud forcing (179-188)",        "W/m^2"   },
  { 193, "wl",         "skin reservoir content",                    "m"       },
  { 194, "slf",        "fractional land cover",                      NULL     },
  { 195, "ustrgw",     "u-gravity wave stress",                     "Pa"      },
  { 196, "vstrgw",     "v-gravity wave stress",                     "Pa"      },
  { 197, "vdisgw",     "gravity wave dissipation",                  "W/m^2"   },
  { 198, "vgrat",      "vegetation ratio",                           NULL     },
  { 199, "orostd",     "orographic standard deviation",             "m"       },
  { 200, "vlt",        "leaf area index",                            NULL     },
  { 201, "t2max",      "maximum 2m-temperature",                    "K"       },
  { 202, "t2min",      "minimum 2m-temperature",                    "K"       },
  { 203, "srad0u",     "top SW radiation upward",                   "W/m^2"   },
  { 204, "sradsu",     "surface SW radiation upward",               "W/m^2"   },
  { 205, "tradsu",     "surface LW radiation upward",               "W/m^2"   },
  { 206, "grndflux",   "surface ground heat flux",                   NULL     },
  { 207, "tsoil",      "deep soil temperatures (5 layers)",         "K"       },
  { 208, "ahfcon",     "conductive heat flux through ice",          "W/m^2"   },
  { 209, "ahfres",     "res. heat flux for melting ice",            "W/m^2"   },
  { 210, "seaice",     "ice cover (fraction of ice+water)",          NULL     },
  { 211, "siced",      "ice thickness",                             "m"       },
  { 212, "forest",     "forest fraction",                            NULL     },
  { 213, "gld",        "glacier thickness",                         "m"       },
  { 214, "sni",        "water equivalent of snow on ice",           "m"       },
  { 215, "rogl",       "glacier runoff",                            "kg/m^2s" },
  { 216, "wimax",      "maximum 10m-wind speed",                    "m/s"     },
  { 217, "topmax",     "maximum height of convective cloud tops",   "Pa"      },
  { 218, "snmel",      "snow melt",                                 "kg/m^2s" },
  { 219, "runtoc",     "surface runoff into ocean",                 "kg/m^2s" },
  { 220, "runlnd",     "surface runoff not running into ocean",     "kg/m^2s" },
  { 221, "apmegl",     "P-E over land ice",                         "kg/m^2s" },
  { 222, "snacl",      "snow accumulation over land",               "kg/m^2s" },
  { 223, "aclcac",     "cloud cover",                                NULL     },
  { 224, "tke",        "turbulent kinetic energy",                  "m^2/s^2" },
  { 225, "tkem1",      "turbulent kinetic energy (t-1)",            "m^2/s^2" },
  { 226, "fao",        "FAO data set (soil data flags) 0...5",       NULL     },
  { 227, "rgcgn",      "heat capacity of soil",                      NULL     },
  { 228, "sodif",      "soil diffusivity",                          "m^2/s"   },
  { 229, "wsmx",       "field capacity of soil",                    "m"       },
  { 230, "qvi",        "vertically integrated water vapor",         "kg/m^2"  },
  { 231, "xlvi",       "vertically integrated cloud water",         "kg/m^2"  },
  { 232, "glac",       "fraction of land covered by glaciers",       NULL     },
  { 233, "snc",        "snow depth at the canopy",                  "m"       },
  { 234, "rtype",      "type of convection",                        "0...3"   },
  { 235, "abso4",      "anthropogenic sulfur burden",               "kg/m^2"  },
  { 236, "ao3",        "ipcc ozone",                                "kg/m^2"  },
  { 237, "tropo",      "WMO defined tropopause height",             "Pa"      },
  { 259, "windspeed",  "windspeed (sqrt(u^2+v^2))",                 "m/s"     },
  { 260, "precip",     "total precipitation  (142+143)",            "kg/m^2s" },
  { 261, "net_top",    "total top radiation  (178+179)",            "W/m^2"   },
  { 262, "net_bot",    "total surface radiation (176+177)",         "W/m^2"   },
  { 272, "mastrfu",    "mass stream function",                      "kg/s"    },
};

static PAR mpiom1[] = {
  {   2, "THO",      "temperature",                     "C"        },
  {   5, "SAO",      "salinity",                        "psu"      },
  {   3, "UKO",      "zon. velocity",                   "m/s"      },
  {   4, "VKE",      "mer. velocity",                   "m/s"      },
  { 303, "UKOMFL",   "zon. velocity (divergence free)", "m/s"      },
  { 304, "VKEMFL",   "mer. velocity (divergence free)", "m/s"      },
  {   7, "WO",       "ver. velocity",                   "m/s"      },
  {   8, "RHO",      "insitu density",                  "kg/m**3"  },
  {   6, "PO",       "pressure",                        "Pa"       },
  {  67, "EMINPO",   "freshwaterflux by restoring",     "m/s"      },
  {  70, "FLUM",     "total heatflux",                  "W/m**2"   },
  {  79, "PEM",      "total freshwaterflux",            "m/s"      },
  {  13, "SICTHO",   "ice thickness",                   "m"        },
  {  15, "SICOMO",   "ice compactness",                 "frac."    },
  {  35, "SICUO",    "zon. ice velocity",               "m/s"      },
  {  36, "SICVE",    "mer. ice velocity",               "m/s"      },
  {  92, "TAFO",     "surface air temperature",         "C"        },
  { 164, "FCLOU",    "cloud cover",                      NULL      },
  {  52, "TXO",      "surface u-stress",                "Pa/1025." },
  {  53, "TYE",      "surface v-stress",                "Pa/1025." },
  { 260, "FPREC",    "prescr. precipitation",           "m/s"      },
  {  80, "FSWR",     "downward shortwave rad.",         "W/m**2"   },
  {  81, "FTDEW",    "dewpoint temperature",            "K"        },
  { 171, "FU10",     "10m windspeed",                   "m/s"      },
  { 141, "SICSNO",   "snow thickness",                  "m"        },
  { 176, "QSWO",     "heat flux shortwave",             "W/m**2"   },
  { 177, "QLWO",     "heat flux longwave",              "W/m**2"   },
  { 147, "QLAO",     "heat flux latent",                "W/m**2"   },
  { 146, "QSEO",     "heat flux sensible",              "W/m**2"   },
  {  65, "PRECO",    "net freshwater flux + runoff",    "m/s"      },
  {   1, "ZO",       "sealevel",                        "m"        },
  {  82, "Z1O",      "sealevel change",                 "m"        },
  {  69, "KCONDEP",  "depth of convection",             "level"    },
  {  27, "PSIUWE",   "hor. bar. streamfunction",        "Sv"       },
  {  83, "AMLD",     "mixed layer depth",               "m"        },
  { 172, "WETO",     "landseamask (pressure points)",    NULL      },
  { 507, "AMSUE",    "landseamask (vector points v)",    NULL      },
  { 508, "AMSUO",    "landseamask (vector points u)",    NULL      },
  {  84, "DEPTO",    "depth at pressure points",        "m"        },
  { 484, "DEUTO",    "depth at vector points (u)",      "m"        },
  { 584, "DEUTE",    "depth at vector points (v)",      "m"        },
  { 184, "DDUO",     "level thickness (vector u )",     "m"        },
  { 284, "DDUE",     "level thickness (vector v )",     "m"        },
  { 384, "DDPO",     "level thickness (pressure )",     "m"        },
  {  85, "DLXP",     "grid distance x",                 "m"        },
  {  86, "DLYP",     "grid distance y",                 "m"        },
  { 185, "DLXU",     "grid distance x  (vector u)",     "m"        },
  { 186, "DLYU",     "grid distance y  (vector u)",     "m"        },
  { 285, "DLXV",     "grid distance x  (vector v)",     "m"        },
  { 286, "DLYV",     "grid distance y  (vector v)",     "m"        },
  {  54, "GILA",     "latitude in radiants",            "rad"      },
  {  55, "GIPH",     "longitude in radiants",           "rad"      },
  { 354, "ALAT",     "latitude in degrees (pressure)",  "deg"      },
  { 355, "ALON",     "longitude in degrees (pressure)", "deg"      },
  { 154, "ALATU",    "latitude in degrees (vector u)",  "deg"      },
  { 155, "ALONU",    "longitude in degrees (vector u)", "deg"      },
  { 254, "ALATV",    "latitude in degrees (vector v)",  "deg"      },
  { 255, "ALONV",    "longitude in degrees (vector v)", "deg"      },
  { 110, "AVO",      "vertical impuls diffusion",       "m**2/s"   },
  { 111, "DVO",      "vertical T,S diffusion",          "m**2/s"   },
  { 142, "SICTRU",   "seaice transport x",              "m**2/s"   },
  { 143, "SICTRV",   "seaice transport y",              "m**2/s"   },
  { 612, "WTMIX",    "wind mixing",                     "m**2/s"   },
  { 183, "zmld",     "mixed layer depth (SJ)",          "m"        },
  { 207, "WGO",      "GM vertical velocity",            "m/s"      },
  { 305, "rivrun",   "RiverRunoff",                     "m/s"      },
  { 158, "TMCDO",    "mon. mean depth of convection",   "level"    },
  { 247, "DQSWO",    "heatflux sw over water",          "W/m**2"   },
  { 248, "DQLWO",    "heatflux lw over water",          "W/m**2"   },
  { 249, "DQSEO",    "heatflux se over water",          "W/m**2"   },
  { 250, "DQLAO",    "heatflux la over water",          "W/m**2"   },
  { 251, "DQTHO",    "heatflux net over water",         "W/m**2"   },
  { 252, "DQSWI",    "heatflux sw over seaice",         "W/m**2"   },
  { 253, "DQLWI",    "heatflux lw over seaice",         "W/m**2"   },
  { 254, "DQSEI",    "heatflux se over seaice",         "W/m**2"   },
  { 255, "DQLAI",    "heatflux la over seaice",         "W/m**2"   },
  { 256, "DQTHI",    "heatflux net over seaice",        "W/m**2"   },
  { 257, "DTICEO",   "Equi. temp over seaice",          "K"        },
  { 270, "AOFLNHWO", "oasis net heat flux water",       "W/m**2"   },
  { 271, "AOFLSHWO", "oasis downward short wave",       "W/m**2"   },
  { 272, "AOFLRHIO", "oasis residual heat flux ice",    "W/m**2"   },
  { 273, "AOFLCHIO", "oasis conduct. heat flux ice",    "W/m**2"   },
  { 274, "AOFLFRWO", "oasis fluid fresh water flux",    "m/s"      },
  { 275, "AOFLFRIO", "oasis solid fresh water flux",    "m/s"      },
  { 276, "AOFLTXWO", "oasis wind stress water x",       "Pa/102"   },
  { 277, "AOFLTYWO", "oasis wind stress water y",       "Pa/102"   },
  { 278, "AOFLTXIO", "oasis wind stress ice x",         "Pa/102"   },
  { 279, "AOFLTYIO", "oasis wind stress ice x",         "Pa/102"   },
  { 280, "AOFLWSVO", "oasis wind speed",                "m/s"      },
};

static PAR ecmwf[] = {
  {   1, "STRF",   "Stream function",                                            "m**2 s**-1"            },
  {   2, "VPOT",   "Velocity potential",                                         "m**2 s**-1"            },
  {   3, "PT",     "Potential temperature",                                      "K"                     },
  {   4, "EQPT",   "Equivalent potential temperature",                           "K"                     },
  {   5, "SEPT",   "Saturated equivalent potential temperature",                 "K"                     },
  {  11, "UDVW",   "U component of divergent wind",                              "m s**-1"               },
  {  12, "VDVW",   "V component of divergent wind",                              "m s**-1"               },
  {  13, "URTW",   "U component of rotational wind",                             "m s**-1"               },
  {  14, "VRTW",   "V component of rotational wind",                             "m s**-1"               },
  {  21, "UCTP",   "Unbalanced component of temperature",                        "K"                     },
  {  22, "UCLN",   "Unbalanced component of logarithm of surface pressure",       NULL                   },
  {  23, "UCDV",   "Unbalanced component of divergence",                         "s**-1"                 },
  {  26, "CL",     "Lake cover",                                                  NULL                   },
  {  27, "CVL",    "Low vegetation cover",                                        NULL                   },
  {  28, "CVH",    "High vegetation cover",                                       NULL                   },
  {  29, "TVL",    "Type of low vegetation",                                      NULL                   },
  {  30, "TVH",    "Type of high vegetation",                                     NULL                   },
  {  31, "CI",     "Sea-ice cover",                                               NULL                   },
  {  32, "ASN",    "Snow albedo",                                                 NULL                   },
  {  33, "RSN",    "Snow density kg",                                            "m**-3"                 },
  {  34, "SSTK",   "Sea surface temperature",                                    "K"                     },
  {  35, "ISTL1",  "Ice surface temperature layer 1",                            "K"                     },
  {  36, "ISTL2",  "Ice surface temperature layer 2",                            "K"                     },
  {  37, "ISTL3",  "Ice surface temperature layer 3",                            "K"                     },
  {  38, "ISTL4",  "Ice surface temperature layer 4",                            "K"                     },
  {  39, "SWVL1",  "Volumetric soil water layer 1",                              "m**3 m**-3"            },
  {  40, "SWVL2",  "Volumetric soil water layer 2",                              "m**3 m**-3"            },
  {  41, "SWVL3",  "Volumetric soil water layer 3",                              "m**3 m**-3"            },
  {  42, "SWVL4",  "Volumetric soil water layer 4",                              "m**3 m**-3"            },
  {  43, "SLT",    "Soil type",                                                   NULL                   },
  {  44, "ES",     "Snow evaporation m of water",                                 NULL                   },
  {  45, "SMLT",   "Snowmelt m of water",                                         NULL                   },
  {  46, "SDUR",   "Solar duration",                                             "s"                     },
  {  47, "DSRP",   "Direct solar radiation",                                     "w m**-2"               },
  {  48, "MAGSS",  "Magnitude of surface stress",                                "N m**-2 s"             },
  {  49, "WG10",   "Wind gust at 10 metres",                                     "m s**-1"               },
  {  50, "LSPF",   "Large-scale precipitation fraction",                         "s"                     },
  {  51, "MX2T24", "Maximum 2 metre temperature",                                "K"                     },
  {  52, "MN2T24", "Minimum 2 metre temperature",                                "K"                     },
  {  53, "MONT",   "Montgomery potential",                                       "m**2 s**-2"            },
  {  54, "PRES",   "Pressure",                                                   "Pa"                    },
  {  55, "MN2T24", "Mean 2 metre temperature past 24 hours",                     "K"                     },
  {  56, "MN2D24", "Mean 2 metre dewpoint temperature past 24 hours",            "K"                     },
  {  60, "PV",     "Potential vorticity",                                        "K m**2 kg**-1 s**-1"   },
  { 127, "AT",     "Atmospheric tide",                                            NULL                   },
  { 128, "BV",     "Budget values",                                               NULL                   },
  { 129, "Z",      "Geopotential",                                               "m**2 s**-2"            },
  { 130, "T",      "Temperature",                                                "K"                     },
  { 131, "U",      "U velocity",                                                 "m s**-1"               },
  { 132, "V",      "V velocity",                                                 "m s**-1"               },
  { 133, "Q",      "Specific humidity",                                          "kg kg**-1"             },
  { 134, "SP",     "Surface pressure",                                           "Pa"                    },
  { 135, "W",      "Vertical velocity",                                          "Pa s**-1"              },
  { 136, "TCW",    "Total column water",                                         "kg m**-2"              },
  { 137, "TCWV",   "Total column water vapour",                                  "kg m**-2"              },
  { 138, "VO",     "Vorticity (relative)",                                       "s**-1"                 },
  { 139, "STL1",   "Soil temperature level 1",                                   "K"                     },
  { 140, "SWL1",   "Soil wetness level 1 m of water",                             NULL                   },
  { 141, "SD",     "Snow depth         1 m of water equivalent",                  NULL                   },
  { 142, "LSP",    "Stratiform precipitation (Large scale precipitation)",       "m"                     },
  { 143, "CP",     "Convective precipitation",                                   "m"                     },
  { 144, "SF",     "Snowfall (convective + stratiform)",                         "m"                     },
  { 145, "BLD",    "Boundary layer dissipation",                                 "W m**-2 s"             },
  { 146, "SSHF",   "Surface sensible heat flux",                                 "W m**-2 s"             },
  { 147, "SLHF",   "Surface latent heat flux",                                   "W m**-2 s"             },
  { 148, "CHNK",   "Charnock",                                                    NULL                   },
  { 149, "SNR",    "Surface net radiation",                                      "W m**-2 s"             },
  { 150, "TNR",    "Top net radiation",                                           NULL                   },
  { 151, "MSL",    "Mean sea-level pressure",                                    "Pa"                    },
  { 152, "LNSP",   "Logarithm of surface pressure",                               NULL                   },
  { 153, "SWHR",   "Short-wave heating rate",                                    "K"                     },
  { 154, "LWHR",   "Long-wave heating rate",                                     "K"                     },
  { 155, "D",      "Divergence",                                                 "s**-1"                 },
  { 156, "GH",     "Height m Geopotential height",                                NULL                   },
  { 157, "R",      "Relative humidity",                                          "%"                     },
  { 158, "TSP",    "Tendency of surface pressure",                               "Pa s**-1"              },
  { 159, "BLH",    "Boundary layer height",                                      "m"                     },
  { 160, "SDOR",   "Standard deviation of orography",                             NULL                   },
  { 161, "ISOR",   "Anisotropy of sub-gridscale orography",                       NULL                   },
  { 162, "ANOR",   "Angle of sub-gridscale orography",                           "rad"                   },
  { 163, "SLOR",   "Slope of sub-gridscale orography",                            NULL                   },
  { 164, "TCC",    "Total cloud cover",                                           NULL                   },
  { 165, "U10M",   "10 metre U wind component",                                  "m s**-1"               },
  { 166, "V10M",   "10 metre V wind component",                                  "m s**-1"               },
  { 167, "T2M",    "2 metre temperature",                                        "K"                     },
  { 168, "D2M",    "2 metre dewpoint temperature",                               "K"                     },
  { 169, "SSRD",   "Surface solar radiation downwards",                          "W m**-2 s"             },
  { 170, "STL2",   "Soil temperature level 2",                                   "K"                     },
  { 171, "SWL2",   "Soil wetness level 2",                                       "m of water"            },
  { 172, "LSM",    "Land/sea mask",                                               NULL                   },
  { 173, "SR",     "Surface roughness",                                          "m"                     },
  { 174, "AL",     "Albedo",                                                      NULL                   },
  { 175, "STRD",   "Surface thermal radiation downwards",                        "W m**-2 s"             },
  { 176, "SSR",    "Surface solar radiation",                                    "W m**-2 s"             },
  { 177, "STR",    "Surface thermal radiation",                                  "W m**-2 s"             },
  { 178, "TSR",    "Top solar radiation",                                        "W m**-2 s"             },
  { 179, "TTR",    "Top thermal radiation",                                      "W m**-2 s"             },
  { 180, "EWSS",   "East/West surface stress",                                   "N m**-2 s"             },
  { 181, "NSSS",   "North/South surface stress",                                 "N m**-2 s"             },
  { 182, "E",      "Evaporation",                                                "m of water"            },
  { 183, "STL3",   "Soil temperature level 3",                                   "K"                     },
  { 184, "SWL3",   "Soil wetness level 3",                                       "m of water"            },
  { 185, "CCC",    "Convective cloud cover",                                      NULL                   },
  { 186, "LCC",    "Low cloud cover",                                             NULL                   },
  { 187, "MCC",    "Medium cloud cover",                                          NULL                   },
  { 188, "HCC",    "High cloud cover",                                            NULL                   },
  { 189, "SUND",   "Sunshine duration",                                          "s"                     },
  { 190, "EWOV",   "EW component of subgrid orographic variance",                "m**2"                  },
  { 191, "NSOV",   "NS component of subgrid orographic variance",                "m**2"                  },
  { 192, "NWOV",   "NWSE component of subgrid orographic variance",              "m**2"                  },
  { 193, "NEOV",   "NESW component of subgrid orographic variance",              "m**2"                  },
  { 194, "BTMP",   "Brightness temperature",                                     "K"                     },
  { 195, "LGWS",   "Lat. component of gravity wave stress",                      "N m**-2 s"             },
  { 196, "MGWS",   "Meridional component of gravity wave stress",                "N m**-2 s"             },
  { 197, "GWD",    "Gravity wave dissipation",                                   "W m**-2 s"             },
  { 198, "SRC",    "Skin reservoir content",                                     "m of water"            },
  { 199, "VEG",    "Vegetation fraction",                                         NULL                   },
  { 200, "VSO",    "Variance of sub-gridscale orography",                        "m**2"                  },
  { 201, "MX2T",   "Maximum 2 metre temperature since previous post-processing", "K"                     },
  { 202, "MN2T",   "Minimum 2 metre temperature since previous post-processing", "K"                     },
  { 203, "O3",     "Ozone mass mixing ratio",                                    "kg kg**-1"             },
  { 204, "PAW",    "Precipiation analysis weights",                               NULL                   },
  { 205, "RO",     "Runoff",                                                     "m"                     },
  { 206, "TCO3",   "Total column ozone",                                         "kg m**-2"              },
  { 207, "WS10",   "10 meter windspeed",                                         "m s**-1"               },
  { 208, "TSRC",   "Top net solar radiation, clear sky",                         "W m**-2"               },
  { 209, "TTRC",   "Top net thermal radiation, clear sky",                       "W m**-2"               },
  { 210, "SSRC",   "Surface net solar radiation, clear sky",                     "W m**-2"               },
  { 211, "STRC",   "Surface net thermal radiation, clear sky",                   "W m**-2"               },
  { 212, "SI",     "Solar insolation",                                           "W m**-2"               },
  { 214, "DHR",    "Diabatic heating by radiation",                              "K"                     },
  { 215, "DHVD",   "Diabatic heating by vertical diffusion",                     "K"                     },
  { 216, "DHCC",   "Diabatic heating by cumulus convection",                     "K"                     },
  { 217, "DHLC",   "Diabatic heating large-scale condensation",                  "K"                     },
  { 218, "VDZW",   "Vertical diffusion of zonal wind",                           "m s**-1"               },
  { 219, "VDMW",   "Vertical diffusion of meridional wind",                      "m s**-1"               },
  { 220, "EWGD",   "EW gravity wave drag tendency",                              "m s**-1"               },
  { 221, "NSGD",   "NS gravity wave drag tendency",                              "m s**-1"               },
  { 222, "CTZW",   "Convective tendency of zonal wind",                          "m s**-1"               },
  { 223, "CTMW",   "Convective tendency of meridional wind",                     "m s**-1"               },
  { 224, "VDH",    "Vertical diffusion of humidity",                             "kg kg**-1"             },
  { 225, "HTCC",   "Humidity tendency by cumulus convection",                    "kg kg**-1"             },
  { 226, "HTLC",   "Humidity tendency large-scale condensation",                 "kg kg**-1"             },
  { 227, "CRNH",   "Change from removing negative humidity",                     "kg kg**-1"             },
  { 228, "TP",     "Total precipitation",                                        "m"                     },
  { 229, "IEWS",   "Instantaneous X surface stress",                             "N m**-2"               },
  { 230, "INSS",   "Instantaneous Y surface stress",                             "N m**-2"               },
  { 231, "ISHF",   "Instantaneous surface heat flux",                            "W m**-2"               },
  { 232, "IE",     "Instantaneous moisture flux",                                "kg m**-2 s"            },
  { 233, "ASQ",    "Apparent surface humidity",                                  "kg kg**-1"             },
  { 234, "LSRH",   "Logarithm of surface roughness length for heat",              NULL                   },
  { 235, "SKT",    "Skin temperature",                                           "K"                     },
  { 236, "STL4",   "Soil temperature level 4",                                   "K"                     },
  { 237, "SWL4",   "Soil wetness level 4",                                       "m"                     },
  { 238, "TSN",    "Temperature of snow layer",                                  "K"                     },
  { 239, "CSF",    "Convective snowfall",                                        "m of water equivalent" },
  { 240, "LSF",    "Large-scale snowfall",                                       "m of water equivalent" },
  { 241, "ACF",    "Accumulated cloud fraction tendency",                         NULL                   },
  { 242, "ALW",    "Accumulated liquid water tendency",                           NULL                   },
  { 243, "FAL",    "Forecast albedo",                                             NULL                   },
  { 244, "FSR",    "Forecast surface roughness",                                 "m"                     },
  { 245, "FLSR",   "Forecast log of surface roughness for heat",                  NULL                   },
  { 246, "CLWC",   "Cloud liquid water content",                                 "kg kg**-1"             },
  { 247, "CIWC",   "Cloud ice water content",                                    "kg kg**-1"             },
  { 248, "CC",     "Cloud cover",                                                 NULL                   },
  { 249, "AIW",    "Accumulated ice water tendency",                              NULL                   },
  { 250, "ICE",    "Ice age",                                                     NULL                   },
  { 251, "ATTE",   "Adiabatic tendency of temperature",                          "K"                     },
  { 252, "ATHE",   "Adiabatic tendency of humidity",                             "kg kg**-1"             },
  { 253, "ATZE",   "Adiabatic tendency of zonal wind",                           "m s**-1"               },
  { 254, "ATMW",   "Adiabatic tendency of meridional wind",                      "m s**-1"               },
};

static PAR remo[] = {
  {  14, "FTKVM",     "turbulent transfer coefficient of momentum in the atmosphere",   NULL           },
  {  15, "FTKVH",     "turbulent transfer coefficient of heat in the atmosphere",       NULL           },
  {  38, "U10ER",     "10m u-velocity",                                                "m/s"           },
  {  39, "V10ER",     "10m v-velocity",                                                "m/s"           },
  {  40, "CAPE",      "convetive available potential energy",                           NULL           },
  {  41, "GHPBL",     "height of the planetary boudary layer",                         "gpm"           },
  {  42, "BETA",      "BETA",                                                           NULL           },
  {  43, "WMINLOK",   "WMINLOK",                                                        NULL           },
  {  44, "WMAXLOK",   "WMAXLOK",                                                        NULL           },
  {  45, "VBM10M",    "maximum of the expected gust velocity near the surface",        "m/s"           },
  {  46, "BFLHS",     "surface sensible heat flux",                                    "W/m**2"        },
  {  47, "BFLQDS",    "surface latent heat flux",                                      "W/m**2"        },
  {  48, "TMCM",      "turbulent transfer coefficient of momentum at the surface",      NULL           },
  {  49, "TRSOL",     "TRSOL",                                                          NULL           },
  {  50, "TMCH",      "turbulent transfer coefficient of heat at the surface",          NULL           },
  {  51, "EMTEF",     "EMTEF",                                                          NULL           },
  {  52, "TRSOF",     "TRSOF",                                                          NULL           },
  {  53, "DRAIN",     "drainage",                                                      "mm"            },
  {  54, "TSL",       "surface temperature (land)",                                    "K"             },
  {  55, "TSW",       "surface temperature (water)",                                   "K"             },
  {  56, "TSI",       "surface temperature (ice)",                                     "K"             },
  {  57, "USTRL",     "surface u-stress (land)",                                       "Pa"            },
  {  58, "USTRW",     "surface u-stress (water)",                                      "Pa"            },
  {  59, "USTRI",     "surface u-stress (ice)",                                        "Pa"            },
  {  60, "VSTRL",     "surface v-stress (land)",                                       "Pa"            },
  {  61, "VSTRW",     "surface v-stress (water)",                                      "Pa"            },
  {  62, "VSTRI",     "surface v-stress (ice)",                                        "Pa"            },
  {  63, "EVAPL",     "surface evaporation (land)",                                    "mm"            },
  {  64, "EVAPW",     "surface evaporation (water)",                                   "mm"            },
  {  65, "EVAPI",     "surface evaporation (ice)",                                     "mm"            },
  {  66, "AHFLL",     "surface latent heat flux (land)",                               "W/m**2"        },
  {  67, "AHFLW",     "surface latent heat flux (water)",                              "W/m**2"        },
  {  68, "AHFLI",     "surface latent heat flux (ice)",                                "W/m**2"        },
  {  69, "AHFSL",     "surface sensible heat flux (land)",                             "W/m**2"        },
  {  70, "AHFSW",     "surface sensible heat flux (water)",                            "W/m**2"        },
  {  71, "AHFSI",     "surface sensible heat flux (ice)",                              "W/m**2"        },
  {  72, "AZ0L",      "surface roughness length (land)",                               "m"             },
  {  73, "AZ0W",      "surface roughness length (water)",                              "m"             },
  {  74, "AZ0I",      "surface roughness length (ice)",                                "m"             },
  {  75, "ALSOL",     "surface albedo (land)",                                         "fract."        },
  {  76, "ALSOW",     "surface albedo (water)",                                        "fract."        },
  {  77, "ALSOI",     "surface albedo (ice)",                                          "fract."        },
  {  81, "TMCHL",     "turbulent transfer coefficient of heat at the surface (land)",   NULL           },
  {  82, "TMCHW",     "turbulent transfer coefficient of heat at the surface (water)",  NULL           },
  {  83, "TMCHI",     "turbulent transfer coefficient of heat at the surface (ice)",    NULL           },
  {  84, "QDBL",      "specific humidity surface (land)",                              "kg/kg"         },
  {  85, "QDBW",      "specific humidity surface (water)",                             "kg/kg"         },
  {  86, "QDBI",      "specific humidity surface (ice)",                               "kg/kg"         },
  {  87, "BFLHSL",    "surface sensible heat flux (land)",                             "W/m**2"        },
  {  88, "BFLHSW",    "surface sensible heat flux (water)",                            "W/m**2"        },
  {  89, "BFLHSI",    "surface sensible heat flux (ice)",                              "W/m**2"        },
  {  90, "BFLQDSL",   "surface latent heat flux (land)",                               "W/m**2"        },
  {  91, "BFLQDSW",   "surface latent heat flux (water)",                              "W/m**2"        },
  {  92, "BFLQDSI",   "surface latent heat flux (ice)",                                "W/m**2"        },
  {  93, "AHFICE",    "sea-ice: conductive heat",                                      "W/m"           },
  {  94, "QRES",      "residual heat flux for melting sea ice",                        "W/m**2"        },
  {  95, "SRFL",      "SRFL",                                                           NULL           },
  {  96, "QDBOXS",    "horizontal transport of water vapour",                          "kg/m**2"       },
  {  97, "QWBOXS",    "horizontal transport of cloud water",                           "kg/m**2"       },
  {  98, "EKBOXS",    "horizontal transport of kinetic energy",                        "(3600*J)/m**2" },
  {  99, "FHBOXS",    "horizontal transport of sensible heat",                         "(3600*J)/m**2" },
  { 100, "FIBOXS",    "horizontal transport of potential energy",                      "(3600*J)/m**2" },
  { 101, "TLAMBDA",   "heat conductivity of dry soil",                                 "W/(K*m)"       },
  { 103, "DLAMBDA",   "parameter for increasing the heat conductivity of the soil",     NULL           },
  { 104, "PORVOL",    "pore volume",                                                    NULL           },
  { 105, "FCAP",      "field capacity of soil",                                         NULL           },
  { 106, "WI3",       "fraction of frozen soil",                                        NULL           },
  { 107, "WI4",       "fraction of frozen soil",                                        NULL           },
  { 108, "WI5",       "fraction of frozen soil",                                        NULL           },
  { 109, "WI",        "fraction of frozen soil",                                        NULL           },
  { 110, "WICL",      "fraction of frozen soil",                                        NULL           },
  { 112, "QDB",       "specific humidity surface",                                     "kg/kg"         },
  { 129, "FIB",       "surface geopotential (orography)",                              "m"             },
  { 130, "T",         "temperature",                                                   "K"             },
  { 131, "U",         "u-velocity",                                                    "m/s"           },
  { 132, "V",         "v-velocity",                                                    "m/s"           },
  { 133, "QD",        "specific humidity",                                             "kg/kg"         },
  { 134, "PS",        "Surface pressure",                                              "Pa"            },
  { 135, "VERVEL",    "Vertical velocity",                                             "Pa/s"          },
  { 138, "SVO",       "vorticity",                                                     "1/s"           },
  { 139, "TS",        "surface temperature",                                           "K"             },
  { 140, "WS",        "soil wetness",                                                  "m"             },
  { 141, "SN",        "snow depth",                                                    "m"             },
  { 142, "APRL",      "large scale precipitation",                                     "mm"            },
  { 143, "APRC",      "convective  precipitation",                                     "mm"            },
  { 144, "APRS",      "snow fall",                                                     "mm"            },
  { 145, "VDIS",      "boundary layer dissipation",                                    "W/m**2"        },
  { 146, "AHFS",      "surface sensible heat flux",                                    "W/m**2"        },
  { 147, "AHFL",      "surface latent heat flux",                                      "W/m**2"        },
  { 148, "STREAM",    "streamfunction",                                                "m**2/s"        },
  { 149, "VELOPOT",   "velocity potential",                                            "m**2/s"        },
  { 151, "PSRED",     "mean sea level pressure",                                       "Pa"            },
  { 152, "LSP",       "log surface pressure",                                           NULL           },
  { 153, "QW",        "liquid water content",                                          "kg/kg"         },
  { 155, "SD",        "divergence",                                                    "1/s"           },
  { 156, "FI",        "geopotential height",                                           "gpm"           },
  { 159, "USTAR3",    "ustar**3",                                                      "m**3/s**3"     },
  { 160, "RUNOFF",    "surface runoff",                                                "mm"            },
  { 162, "ACLC",      "cloud cover",                                                   "fract."        },
  { 163, "ACLCV",     "total cloud cover",                                             "fract."        },
  { 164, "ACLCOV",    "total cloud cover",                                             "fract."        },
  { 165, "U10",       "10m u-velocity",                                                "m/s"           },
  { 166, "V10",       "10m v-velocity",                                                "m/s"           },
  { 167, "TEMP2",     "2m temperature",                                                "K"             },
  { 168, "DEW2",      "2m dew point temperature",                                      "K"             },
  { 169, "TSURF",     "surface temperature (land)",                                    "K"             },
  { 170, "TD",        "deep soil temperature",                                         "K"             },
  { 171, "WIND10",    "10m windspeed",                                                 "m/s"           },
  { 172, "BLA",       "land sea mask",                                                 "fract."        },
  { 173, "AZ0",       "surface roughness length",                                      "m"             },
  { 174, "ALB",       "surface background albedo",                                     "fract."        },
  { 175, "ALBEDO",    "surface albedo",                                                "fract."        },
  { 176, "SRADS",     "net surface solar radiation",                                   "W/m**2"        },
  { 177, "TRADS",     "net surface thermal radiation",                                 "W/m**2"        },
  { 178, "SRAD0",     "net top solar radiation",                                       "W/m**2"        },
  { 179, "TRAD0",     "top thermal radiation (OLR)",                                   "W/m**2"        },
  { 180, "USTR",      "surface u-stress",                                              "Pa"            },
  { 181, "VSTR",      "surface v-stress",                                              "Pa"            },
  { 182, "EVAP",      "surface evaporation",                                           "mm"            },
  { 183, "TDCL",      "soil temperature",                                              "K"             },
  { 185, "SRAFS",     "net surf. solar radiation   (clear sky)",                       "W/m**2"        },
  { 186, "TRAFS",     "net surf. thermal radiation (clear sky)",                       "W/m**2"        },
  { 187, "SRAF0",     "net top solar radiation     (clear sky)",                       "W/m**2"        },
  { 188, "TRAF0",     "net top thermal radiation   (clear sky)",                       "W/m**2"        },
  { 189, "SCLFS",     "surface solar cloud forcing",                                   "W/m**2"        },
  { 190, "TCLFS",     "surface thermal cloud forcing",                                 "W/m**2"        },
  { 191, "SCLF0",     "top solar cloud forcing",                                       "W/m**2"        },
  { 192, "TCLF0",     "top thermal cloud forcing",                                     "W/m**2"        },
  { 194, "WL",        "skin reservoir content",                                        "m"             },
  { 195, "USTRGW",    "u-gravity wave stress",                                         "Pa"            },
  { 196, "VSTRGW",    "v-gravity wave stress",                                         "Pa"            },
  { 197, "VDISGW",    "gravity wave dissipation",                                      "W/m**2"        },
  { 198, "VGRAT",     "vegetation ratio",                                               NULL           },
  { 199, "VAROR",     "orographic variance (for surface runoff)",                       NULL           },
  { 200, "VLT",       "leaf area index",                                                NULL           },
  { 201, "T2MAX",     "maximum 2m-temperature",                                        "K"             },
  { 202, "T2MIN",     "minimum 2m-temperature",                                        "K"             },
  { 203, "SRAD0U",    "top solar radiation upward",                                    "W/m**2"        },
  { 204, "SRADSU",    "surface solar radiation upward",                                "W/m**2"        },
  { 205, "TRADSU",    "surface thermal radiation upward",                              "W/m**2"        },
  { 206, "TSN",       "snow temperature",                                              "K"             },
  { 207, "TD3",       "soil temperature",                                              "K"             },
  { 208, "TD4",       "soil temperature",                                              "K"             },
  { 209, "TD5",       "soil temperature",                                              "K"             },
  { 210, "SEAICE",    "sea ice cover",                                                 "fract."        },
  { 211, "SICED",     "sea ice depth",                                                 "m"             },
  { 212, "FOREST",    "vegetation type",                                                NULL           },
  { 213, "TEFF",      "(effective) sea-ice skin temperature",                          "K"             },
  { 214, "TSMAX",     "maximum surface temperature",                                   "K"             },
  { 215, "TSMIN",     "minimum surface temperature",                                   "K"             },
  { 216, "WIMAX",     "maximum 10m-wind speed",                                        "m/s"           },
  { 217, "TOPMAX",    "maximum height of convective cloud tops",                       "Pa"            },
  { 218, "SNMEL",     "snow melt",                                                     "mm"            },
  { 220, "TSLIN",     "land: residual surface heat budget",                            "W/m**2"        },
  { 221, "DSNAC",     "snow depth change",                                             "mm"            },
  { 222, "EMTER",     "EMTER",                                                          NULL           },
  { 223, "ACLCAC",    "cloud cover",                                                   "fract."        },
  { 224, "TKE",       "turbulent kinetic energy",                                       NULL           },
  { 226, "FAO",       "FAO data set (soil data flags)",                                 NULL           },
  { 227, "RGCGN",     "heat capacity of soil",                                          NULL           },
  { 229, "WSMX",      "field capacity of soil",                                         NULL           },
  { 230, "QVI",       "vertically integrated specific humidity",                       "kg/m**2"       },
  { 231, "ALWCVI",    "vertically integrated liquid water cont.",                      "kg/m**2"       },
  { 232, "GLAC",      "glacier mask",                                                   NULL           },
  { 253, "PHI",       "latitude in real coordinates",                                  "degrees_north" },
  { 254, "RLA",       "longitude in real coordinates",                                 "degrees_east"  },
  { 259, "WINDSPEED", "windspeed (sqrt(u**2+v**2))",                                    NULL           },
  { 260, "PRECIP",    "total precipitation",                                            NULL           },
};

static PAR cosmo002[] = {
  {   1, "P",         "pressure",                                          "Pa"         },
  {   2, "PMSL",      "mean sea level pressure",                           "Pa"         },
  {   3, "DPSDT",     "surface pressure change",                           "Pa s-1"     },
  {   6, "FI",        "geopotential",                                      "m2 s-2"     },
  {   8, "HH",        "height",                                            "m"          },
  {  10, "TO3",       "vertical integrated ozone content",                 "Dobson"     },
  {  11, "T",         "temperature",                                       "K"          },
  {  15, "TMAX",      "2m maximum temperature",                            "K"          },
  {  16, "TMIN",      "2m minimum temperature",                            "K"          },
  {  17, "TD",        "2m dew point temperature",                          "K"          },
  {  31, "DD",        "undefined",                                         "undefined"  },
  {  32, "FF",        "undefined",                                         "undefined"  },
  {  33, "U",         "U-component of wind",                               "m s-1"      },
  {  34, "V",         "V-component of wind",                               "m s-1"      },
  {  39, "OMEGA",     "omega",                                             "Pa s-1"     },
  {  40, "W",         "vertical wind velocity",                            "m s-1"      },
  {  51, "QV",        "specific humidity",                                 "kg kg-1"    },
  {  52, "RELHUM",    "relative humidity",                                 "%"          },
  {  54, "TQV",       "precipitable water",                                "kg m-2"     },
  {  57, "AEVAP",     "surface evaporation",                               "kg m-2"     },
  {  58, "TQI",       "vertical integrated cloud ice",                     "kg m-2"     },
  {  59, "TOT_PR",    "total precipitation rate",                          "kg m-2 s-1" },
  {  61, "TOT_PREC",  "total precipitation amount",                        "kg m-2"     },
  {  65, "W_SNOW",    "surface snow amount",                               "m"          },
  {  66, "H_SNOW",    "thickness of snow",                                 "m"          },
  {  71, "CLCT",      "total cloud cover",                                 "1"          },
  {  72, "CLC_CON",   "convective cloud area fraction",                    "1"          },
  {  73, "CLCL",      "low cloud cover",                                   "1"          },
  {  74, "CLCM",      "medium cloud cover",                                "1"          },
  {  75, "CLCH",      "high cloud cover",                                  "1"          },
  {  76, "TQC",       "vertical integrated cloud water",                   "kg m-2"     },
  {  78, "SNOW_CON",  "convective snowfall",                               "kg m-2"     },
  {  79, "SNOW_GSP",  "large scale snowfall",                              "kg m-2"     },
  {  81, "FR_LAND",   "land-sea fraction",                                 "1"          },
  {  83, "Z0",        "surface roughness length",                          "m"          },
  {  84, "ALB_RAD",   "surface albedo",                                    "1"          },
  {  85, "TSOIL",     "soil surface temperature",                          "K"          },
  {  86, "WSOIL",     "water content of 1. soil layer",                    "m"          },
  {  87, "PLCOV",     "vegetation area fraction",                          "1"          },
  {  90, "RUNOFF",    "subsurface runoff",                                 "kg m-2"     },
  {  91, "FR_ICE",    "sea ice area fraction",                             "1"          },
  {  92, "H_ICE",     "sea ice thickness",                                 "m"          },
  { 111, "ASOB",      "averaged surface net downward shortwave radiation", "W m-2"      },
  { 112, "ATHB",      "averaged surface net downward longwave radiation",  "W m-2"      },
  { 113, "ASOB",      "averaged TOA net downward shortwave radiation",     "W m-2"      },
  { 114, "ATHB",      "averaged TOA outgoing longwave radiation",          "W m-2"      },
  { 115, "ASWDIR",    "direct downward sw radiation at the surface",       "W m-2"      },
  { 116, "ASWDIFD",   "diffuse downward sw radiation at the surface",      "W m-2"      },
  { 117, "ASWDIFU",   "diffuse upwnward sw radiation at the surface",      "W m-2"      },
  { 118, "ALWD",      "downward lw radiation at the surface",              "W m-2"      },
  { 119, "ALWU",      "upward lw radiation at the surface",                "W m-2"      },
  { 121, "ALHFL",     "averaged surface latent heat flux",                 "W m-2"      },
  { 122, "ASHFL",     "averaged surface sensible heat flux",               "W m-2"      },
  { 124, "AUMFL",     "averaged eastward stress",                          "Pa"         },
  { 125, "AVMFL",     "averaged northward stress",                         "Pa"         },
  { 128, "SUNSH",     "undefined",                                         "undefined"  },
  { 129, "SUNSH2",    "undefined",                                         "undefined"  },
  { 130, "SUN_SUM",   "undefined",                                         "undefined"  },
  { 131, "SUN_SUM2",  "undefined",                                         "undefined"  },
  { 133, "FCOR",      "undefined",                                         "undefined"  },
  { 134, "SKYVIEW",   "sky-view factor",                                   "1"          },
  { 137, "SWDIR_COR", "topo correction of direct solar radiarion",         "1"          },
};

static PAR cosmo201[] = {
  {   5, "APAB",      "&",                                                         "W m-2"      },
  {  13, "SOHR_RAD",  "&",                                                         "K s-1"      },
  {  14, "THHR_RAD",  "&",                                                         "K s-1"      },
  {  20, "DURSUN",    "duration of sunshine",                                      "s"          },
  {  29, "CLC",       "cloud area fraction",                                       "1"          },
  {  30, "CLC_SGS",   "grid scale cloud area fraction",                            "1"          },
  {  31, "QC",        "specific cloud liquid water content",                       "kg kg-1"    },
  {  33, "QI",        "specific cloud ice content",                                "kg kg-1"    },
  {  35, "QR",        "specific rain content",                                     "kg kg-1"    },
  {  36, "QS",        "specific snow content",                                     "kg kg-1"    },
  {  37, "TQR",       "total rain water content vertically integrated",            "kg m-2"     },
  {  38, "TQS",       "total snow content vertically integrated",                  "kg m-2"     },
  {  39, "QG",        "specific graupel content",                                  "kg kg-1"    },
  {  40, "TQG",       "total graupel content vertically integrated",               "kg m-2"     },
  {  41, "TWATER",    "cloud condensed water content",                             "kg m-2"     },
  {  42, "TDIV_HUM",  "atmosphere water divergence",                               "kg m-2"     },
  {  43, "QC_RAD",    "sub scale specific cloud liquid water content",             "kg kg-1"    },
  {  44, "QI_RAD",    "sub scale specific cloud ice content",                      "kg kg-1"    },
  {  61, "CLW_CON",   "convective cloud liquid water",                             "1"          },
  {  68, "HBAS_CON",  "height of convective cloud base",                           "m"          },
  {  69, "HTOP_CON",  "height of convective cloud top",                            "m"          },
  {  70, "HBAS_CONI", "height of convective cloud base",                           "m"          },
  {  71, "HTOP_CONI", "height of convective cloud top",                            "m"          },
  {  72, "BAS_CON",   "index of convective cloud base",                            "1"          },
  {  73, "TOP_CON",   "index of convective cloud top",                             "1"          },
  {  74, "DT_CON",    "convective tendency of temperature",                        "K s-1"      },
  {  75, "DQV_CON",   "convective tendency of specific humidity",                  "s-1"        },
  {  78, "DU_CON",    "convective tendency of u-wind component",                   "m s-2"      },
  {  79, "DV_CON",    "convective tendency of v-wind component",                   "m s-2"      },
  {  82, "HTOP_DC",   "height of dry convection top",                              "m"          },
  {  84, "HZEROCL",   "height of freezing level",                                  "m"          },
  {  85, "SNOWLMT",   "height of the snow fall limit in m above sea level",        "m"          },
  {  86, "HCBAS",     "height of cloud base",                                      "m"          },
  {  87, "HCTOP",     "height of cloud top",                                       "m"          },
  {  91, "C_T_LK",    "&",                                                         "1"          },
  {  92, "GAMSO_LK",  "&",                                                         "m-1"        },
  {  93, "DP_BS_LK",  "&",                                                         "m"          },
  {  94, "H_B1_LK",   "&",                                                         "m"          },
  {  95, "H_ML_LK",   "&",                                                         "m"          },
  {  96, "DEPTH_LK",  "lake depth",                                                "m"          },
  {  97, "FETCH_LK",  "wind fetch over lake",                                      "m"          },
  {  99, "QRS",       "precipitation water (water loading)",                       "1"          },
  { 100, "PRR_GSP",   "mass flux density of large scale rainfall",                 "kg m-2 s-1" },
  { 101, "PRS_GSP",   "mass flux density of large scale snowfall",                 "kg m-2 s-1" },
  { 102, "RAIN_GSP",  "large scale rainfall",                                      "kg m-2"     },
  { 111, "PRR_CON",   "mass flux density of convective rainfall",                  "kg m-2 s-1" },
  { 112, "PRS_CON",   "mass flux density of convective snowfall",                  "kg m-2 s-1" },
  { 113, "RAIN_CON",  "convective rainfall",                                       "kg m-2"     },
  { 129, "FRESHSNW",  "freshness of snow",                                         "undefined"  },
  { 131, "PRG_GSP",   "mass flux density of large scale graupel",                  "kg m-2 s-1" },
  { 132, "GRAU_GSP",  "large scale graupel",                                       "kg m-2"     },
  { 133, "RHO_SNOW",  "density of snow",                                           "kg m-3"     },
  { 139, "PP",        "deviation from reference pressure",                         "Pa"         },
  { 140, "RCLD",      "standard deviation of saturation deficit",                  "undefined"  },
  { 143, "CAPE_MU",   "cape of most unstable parcel",                              "J kg-1"     },
  { 144, "CIN_MU",    "convective inhibition of most unstable parcel",             "J kg-1"     },
  { 145, "CAPE_ML",   "cape of mean surface layer parcel",                         "J kg-1"     },
  { 146, "CIN_ML",    "convective inhibition of mean surface layer parcel",        "J kg-1"     },
  { 147, "TKE_CON",   "convective turbulent kinetic energy",                       "undefined"  },
  { 148, "TKETENS",   "tendency of turbulent kinetic energy",                      "undefined"  },
  { 152, "TKE",       "turbulent kinetic energy",                                  "m2 s-2"     },
  { 153, "TKVM",      "diffusion coefficient of momentum",                         "m2 s-1"     },
  { 154, "TKVH",      "diffusion coefficient of heat",                             "m2 s-1"     },
  { 170, "TCM",       "drag coefficient of momentum",                              "1"          },
  { 171, "TCH",       "drag coefficient of heat",                                  "1"          },
  { 187, "VMAX",      "maximum turbulent wind gust in 10m",                        "m s-1"      },
  { 190, "TSOIL",     "&",                                                         "K"          },
  { 191, "TSOIL",     "&",                                                         "K"          },
  { 192, "TSOIL",     "&",                                                         "K"          },
  { 193, "TSOIL",     "mixed layer temperature",                                   "K"          },
  { 194, "TSOIL",     "mean temperature of water column",                          "K"          },
  { 197, "TSOIL",     "soil temperature",                                          "K"          },
  { 198, "W_SO",      "soil water content",                                        "m"          },
  { 199, "W_SO_ICE",  "soil frozen water content",                                 "m"          },
  { 200, "W_I",       "canopy water amount",                                       "m"          },
  { 203, "TSOIL",     "snow surface temperature",                                  "K"          },
  { 215, "TSOIL",     "temperature of ice upper surface",                          "K"          },
  { 230, "dBZ",       "unattenuated radar reflectivity in Rayleigh approximation", "1"          },
  { 240, "MFLX_CON",  "convective mass flux density",                              "kg m-2 s-1" },
  { 241, "CAPE_CON",  "&",                                                         "J kg-1"     },
  { 243, "QCVG_CON",  "&",                                                         "s-1"        },
};

static PAR cosmo202[] = {
  {  46, "SSO_STDH",  "standard deviation of subgrid scale height",                "m"         },
  {  47, "SSO_GAMMA", "anisotropy of topography",                                  "-"         },
  {  48, "SSO_THETA", "angle between principal axis of orography and global east", "-"         },
  {  49, "SSO_SIGMA", "mean slope of subgrid scale orography",                     "-"         },
  {  55, "FR_LAKE",   "fraction of inland lake water",                             "1"         },
  {  57, "SOILTYP",   "soil type",                                                 "1"         },
  {  61, "LAI",       "leaf area index",                                           "1"         },
  {  62, "ROOTDP",    "root depth",                                                "m"         },
  {  64, "HMO3",      "air pressure at ozone maximum",                             "Pa"        },
  {  65, "VIO3",      "vertical integrated ozone amount",                          "Pa"        },
  {  67, "PLCOV_MX",  "vegetation area fraction maximum",                          "1"         },
  {  68, "PLCOV_MN",  "vegetation area fraction minimum",                          "1"         },
  {  69, "LAI_MX",    "leaf area index maximum",                                   "1"         },
  {  70, "LAI_MN",    "leaf area index minimum",                                   "1"         },
  {  75, "FOR_E",     "ground fraction covered by evergreen forest",               "-"         },
  {  76, "FOR_D",     "ground fraction covered by deciduous forest",               "-"         },
  { 104, "DQVDT",     "tendency of water vapor",                                   "s-1"       },
  { 105, "QVSFLX",    "surface flux of water vapour",                              "s-1m-2"    },
  { 113, "FC",        "coriolis parameter",                                        "s-1"       },
  { 114, "RLAT",      "latitude",                                                  "radian"    },
  { 115, "RLON",      "longitude",                                                 "radian"    },
  { 121, "ZTD",       "integrated total atmospheric refractivity",                 "undefined" },
  { 122, "ZWD",       "integrated wet atmospheric refractivity",                   "undefined" },
  { 123, "ZHD",       "integrated dry atmospheric refractivity",                   "undefined" },
  { 180, "O3",        "ozone mass mixing ratio",                                   "kg kg-1"   },
  { 200, "I131a",     "undefined",                                                 "undefined" },
  { 201, "I131a_DD",  "undefined",                                                 "undefined" },
  { 202, "I131a_WD",  "undefined",                                                 "undefined" },
  { 203, "Cs137",     "undefined",                                                 "undefined" },
  { 204, "Cs137_DD",  "undefined",                                                 "undefined" },
  { 205, "Cs137_WD",  "undefined",                                                 "undefined" },
  { 206, "Te132",     "undefined",                                                 "undefined" },
  { 207, "Te132_DD",  "undefined",                                                 "undefined" },
  { 208, "Te132_WD",  "undefined",                                                 "undefined" },
  { 209, "Zr95",      "undefined",                                                 "undefined" },
  { 210, "Zr95_DD",   "undefined",                                                 "undefined" },
  { 211, "Zr95_WD",   "undefined",                                                 "undefined" },
  { 212, "Kr85",      "undefined",                                                 "undefined" },
  { 213, "Kr85_DD",   "undefined",                                                 "undefined" },
  { 214, "Kr85_WD",   "undefined",                                                 "undefined" },
  { 215, "TRACER",    "undefined",                                                 "undefined" },
  { 216, "TRACER_DD", "undefined",                                                 "undefined" },
  { 217, "TRACER_WD", "undefined",                                                 "undefined" },
  { 218, "Xe133",     "undefined",                                                 "undefined" },
  { 219, "Xe133_DD",  "undefined",                                                 "undefined" },
  { 220, "Xe133_WD",  "undefined",                                                 "undefined" },
  { 221, "I131g",     "undefined",                                                 "undefined" },
  { 222, "I131g_DD",  "undefined",                                                 "undefined" },
  { 223, "I131g_WD",  "undefined",                                                 "undefined" },
  { 224, "I131o",     "undefined",                                                 "undefined" },
  { 225, "I131o_DD",  "undefined",                                                 "undefined" },
  { 226, "I131o_WD",  "undefined",                                                 "undefined" },
  { 227, "Ba140",     "undefined",                                                 "undefined" },
  { 228, "Ba140_DD",  "undefined",                                                 "undefined" },
  { 229, "Ba140_WD",  "undefined",                                                 "undefined" },
  { 230, "Sr90",      "undefined",                                                 "undefined" },
  { 231, "Sr90_DD",   "undefined",                                                 "undefined" },
  { 232, "Sr90_WD",   "undefined",                                                 "undefined" },
  { 233, "Ru103",     "undefined",                                                 "undefined" },
  { 234, "Ru103_DD",  "undefined",                                                 "undefined" },
  { 235, "Ru103_WD",  "undefined",                                                 "undefined" },
};

static PAR cosmo203[] = {
  { 135, "LCL_ML",   "undefined",                  "undefined" },
  { 136, "LFC_ML",   "undefined",                  "undefined" },
  { 137, "CAPE_3KM", "undefined",                  "undefined" },
  { 138, "SWISS00",  "swiss00 index",              "1"         },
  { 139, "SWISS12",  "swiss12 index",              "1"         },
  { 147, "SLI",      "surface lifted index",       "K"         },
  { 149, "SI",       "showalter index",            "K"         },
  { 155, "BRN",      "undefined",                  "undefined" },
  { 156, "HPBL",     "undefined",                  "undefined" },
  { 203, "CLDEPTH",  "normalized cloud depth",     "1"         },
  { 204, "CLCT_MOD", "modified_total_cloud_cover", "1"         },
};

static PAR cosmo205[] = {
  {   1, "SYNME5", "synthetic satellite images Meteosat5", "-" },
  {   2, "SYNME6", "synthetic satellite images Meteosat6", "-" },
  {   3, "SYNME7", "synthetic satellite images Meteosat7", "-" },
  {   4, "SYNMSG", "synthetic satellite images MSG",       "-" },
};

static PAR cosmo250[] = {
  {   1, "QNH",       "sea level air pressure",                                         "hPa"                                },
  {  11, "TSOIL",     "2m temperature",                                                 "K"                                  },
  {  12, "TSOIL",     "2m temperature",                                                 "K"                                  },
  {  13, "D_T_2M_K",  "kalman correction to 2m temperature",                            "K"                                  },
  {  14, "TSOIL",     "2m temperature",                                                 "K"                                  },
  {  15, "TSOIL",     "2m temperature",                                                 "K"                                  },
  {  16, "RH_ICE",    "relative humidity over ice",                                     "%"                                  },
  {  17, "TD",        "dew point temperature",                                          "K"                                  },
  {  18, "D_TD",      "dew point depression",                                           "K"                                  },
  {  19, "THETAE",    "equivalent potential temperature",                               "K"                                  },
  {  20, "TD_2M_K",   "2m dew point temperature",                                       "K"                                  },
  {  21, "D_TD_2M_K", "kalman correction to 2m dew point temperature",                  "K"                                  },
  {  22, "TD_2M_OLD", "2m dew point temperature",                                       "K"                                  },
  {  23, "TD_2M_BUZ", "2m dew point temperature",                                       "K"                                  },
  {  24, "HI",        "heat index",                                                     "Fahrenheit"                         },
  {  25, "DURSUN_M",  "maximum duration of sunshine",                                   "s"                                  },
  {  26, "DURSUN_R",  "relative duration of sunshine",                                  "%"                                  },
  {  52, "RH_2M_K",   "2m relative humidity",                                           "%"                                  },
  {  53, "D_RH_2M_K", "kalman correction to 2m relative humidity",                      "%"                                  },
  {  58, "CLI_RATIO", "cloud ice ratio (Qi/Qc+Qi)",                                     "%"                                  },
  {  61, "TOT_SNOW",  "total precipitation in snow",                                    "kg/m**2"                            },
  {  62, "TOT_RAIN",  "total precipitation in rain",                                    "kg/m**2"                            },
  {  63, "TOT_CON",   "total convective precipitation",                                 "kg/m**2"                            },
  {  64, "TOT_GSP",   "total large scale precipitation",                                "kg/m**2"                            },
  {  65, "SNOW_%",    "percentage of precipitation in snow",                            "%"                                  },
  {  66, "CONV_%",    "percentage of convective precipitation",                         "%"                                  },
  {  67, "VORTP_ABS", "absolute",                                                       "VORTP_ABS 67 -1 absolute vorticity" },
  {  68, "VORTP_REL", "relative",                                                       "VORTP_REL 68 -1 relative vorticity" },
  {  70, "PDIFF_CON", "pressure difference between cloud base and cloud top",           "Pa"                                 },
  {  71, "TTOP_CON",  "temperature at cloud top",                                       "K"                                  },
  {  80, "GEM",       "emissivity of the ground",                                       "%"                                  },
  {  82, "Z0LOC",     "local surface roughness length",                                 "m"                                  },
  { 110, "LUM",       "luminosity",                                                     "klux"                               },
  { 111, "GLOB",      "global shortwave radiation at surface",                          "W/m**2"                             },
  { 112, "LW_IN_TG",  "incoming longwave radiation at surface",                         "W/m**2"                             },
  { 113, "LW_IN_TS",  "incoming longwave radiation at surface",                         "W/m**2"                             },
  { 114, "LW_IN_T2M", "incoming longwave radiation at surface",                         "W/m**2"                             },
  { 115, "SWISS_WE",  "Swiss",                                                          "SWISS_WE 115 1 Swiss coordinates"   },
  { 116, "SWISS_SN",  "Swiss",                                                          "SWISS_SN 116 1 Swiss coordinates"   },
  { 150, "KOINDEX",   "KO index",                                                       "K"                                  },
  { 151, "TTINDEX",   "total-totals index",                                             "K"                                  },
  { 152, "DCI",       "deep convection index",                                          "K"                                  },
  { 153, "SWEAT",     "severe weather thread index",                                    "undefined"                          },
  { 154, "ADEDO2",    "adedokun 2 index",                                               "K"                                  },
  { 160, "C_TSTORM",  "thunderstorm index using AdaBoost classifier",                   "undefined"                          },
  { 161, "CN_TSTORM", "thunderstorm probabilty using AdaBoost classifier",              "%"                                  },
  { 200, "WSHEARL",   "wind shear between surface and 3 km asl",                        "1/s"                                },
  { 201, "WSHEARM",   "wind shear between surface and 6 km asl",                        "1/s"                                },
  { 202, "WSHEARU",   "wind shear between 3 km (or surface) and 6 km asl",              "1/s"                                },
  { 211, "VWIN",      "maximum OLD turbulent wind gust in 10m",                         "m s-1"                              },
  { 212, "VW10M_20",  "maximum 10m wind speed",                                         "m s-1"                              },
  { 213, "VW10M_25",  "duration of VWIN_10M above 25 knots",                            "s"                                  },
  { 214, "VW10M_30",  "duration of VWIN_10M above 30 knots",                            "s"                                  },
  { 215, "VW10M_35",  "duration of VWIN_10M above 35 knots",                            "s"                                  },
  { 216, "VW10M_40",  "duration of VWIN_10M above 40 knots",                            "s"                                  },
  { 217, "VW10M_45",  "duration of VWIN_10M above 45 knots",                            "s"                                  },
  { 218, "VW10M_50",  "duration of VWIN_10M above 50 knots",                            "s"                                  },
  { 219, "VOLD",      "maximum turbulent wind gust in 10m",                             "m s-1"                              },
  { 220, "VJPS",      "maximum turbulent wind gust in 10m",                             "m s-1"                              },
  { 221, "VBRA",      "maximum Brasseur turbulent wind gust in 10m",                    "m s-1"                              },
  { 222, "VB10M_20",  "duration of VBRA_10M above 20 knots",                            "s"                                  },
  { 223, "VB10M_25",  "duration of VBRA_10M above 25 knots",                            "s"                                  },
  { 224, "VB10M_30",  "duration of VBRA_10M above 30 knots",                            "s"                                  },
  { 225, "VB10M_35",  "duration of VBRA_10M above 35 knots",                            "s"                                  },
  { 226, "VB10M_40",  "duration of VBRA_10M above 40 knots",                            "s"                                  },
  { 227, "VB10M_45",  "duration of VBRA_10M above 45 knots",                            "s"                                  },
  { 228, "VB10M_50",  "duration of VBRA_10M above 50 knots",                            "s"                                  },
  { 231, "VCON",      "maximum convective wind gust in 10m",                            "m s-1"                              },
  { 232, "VC10M_20",  "duration of VCON_10M above 20 knots",                            "s"                                  },
  { 233, "VC10M_25",  "duration of VCON_10M above 25 knots",                            "s"                                  },
  { 234, "VC10M_30",  "duration of VCON_10M above 30 knots",                            "s"                                  },
  { 235, "VC10M_35",  "duration of VCON_10M above 35 knots",                            "s"                                  },
  { 236, "VC10M_40",  "duration of VCON_10M above 40 knots",                            "s"                                  },
  { 237, "VC10M_45",  "duration of VCON_10M above 45 knots",                            "s"                                  },
  { 238, "VC10M_50",  "duration of VCON_10M above 50 knots",                            "s"                                  },
  { 241, "FMAX",      "maximum wind speed at k=ke",                                     "m s-1"                              },
  { 242, "USTARMAX",  "maximal u*=SQRT(Drag_coef)*fmax_10m",                            "m s-1"                              },
  { 243, "GLOB_DIF",  "global diffuse shortwave radiation at the surface",              "W/m**2"                             },
  { 244, "GLOB_DIR",  "global direct (beam) shortwave radiation at the surface",        "W/m**2"                             },
  { 245, "GLOB_vE",   "global shortwave radiation on a vertical surface facing east",   "W/m**2"                             },
  { 246, "GLOB_vS",   "global shortwave radiation on a vertical surface facing south",  "W/m**2"                             },
  { 247, "GLOB_vW",   "global shortwave radiation on a vertical surface facing west",   "W/m**2"                             },
  { 248, "GLOB_vN",   "global shortwave radiation on a vertical surface facing north",  "W/m**2"                             },
  { 249, "LW_TG_vS",  "incoming longwave radiation on a vertical surface facing south", "W/m**2"                             },
  { 250, "ENTH",      "enthalpy",                                                       "kJ/kg"                              },
  { 251, "ENTH",      "enthalpy",                                                       "kJ/kg"                              },
  { 252, "MIXRAT",    "mixing ratio",                                                   "g/kg"                               },
  { 253, "MIXRAT",    "mixing ratio",                                                   "g/kg"                               },
  { 254, "TW",        "wet bulb temperature",                                           "degC"                               },
  { 255, "TW",        "wet bulb temperature",                                           "degC"                               },
};


void
tableDefault(void)
{
  int tableID, instID, modelID;


  /*
   *  define table : echam4
   */

  instID  = institutInq(98, 255, "MPIMET", NULL);
  if ( instID == -1 )
    instID  = institutDef(98, 255, "MPIMET", NULL);

  modelID = modelInq(instID, 0, "ECHAM4");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "ECHAM4");

  tableID = tableDef(modelID, 128, "echam4");

  tableLink(tableID, echam4, sizeof(echam4) / sizeof(PAR));

  /*
   *  define table : echam5
   */

  instID  = institutInq(0, 0, "MPIMET", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MPIMET", NULL);

  modelID = modelInq(instID, 0, "ECHAM5");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "ECHAM5");

  tableID = tableDef(modelID, 128, "echam5");

  tableLink(tableID, echam5, sizeof(echam5) / sizeof(PAR));

  /*
   *  define table : mpiom1
   */

  instID  = institutInq(0, 0, "MPIMET", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MPIMET", NULL);

  modelID = modelInq(instID, 0, "MPIOM1");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "MPIOM1");

  tableID = tableDef(modelID, 128, "mpiom1");

  tableLink(tableID, mpiom1, sizeof(mpiom1) / sizeof(PAR));

  /*
   *  define table : ecmwf
   */

  instID  = institutInq(0, 0, "ECMWF", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "ECMWF", NULL);

  modelID = modelInq(instID, 0, "");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "");

  tableID = tableDef(modelID, 128, "ecmwf");

  tableLink(tableID, ecmwf, sizeof(ecmwf) / sizeof(PAR));

  /*
   *  define table : remo
   */

  instID  = institutInq(0, 0, "MPIMET", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MPIMET", NULL);

  modelID = modelInq(instID, 0, "REMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "REMO");

  tableID = tableDef(modelID, 128, "remo");

  tableLink(tableID, remo, sizeof(remo) / sizeof(PAR));

  /*
   *  define table : cosmo002
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 002, "cosmo002");

  tableLink(tableID, cosmo002, sizeof(cosmo002) / sizeof(PAR));

  /*
   *  define table : cosmo201
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 201, "cosmo201");

  tableLink(tableID, cosmo201, sizeof(cosmo201) / sizeof(PAR));

  /*
   *  define table : cosmo202
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 202, "cosmo202");

  tableLink(tableID, cosmo202, sizeof(cosmo202) / sizeof(PAR));

  /*
   *  define table : cosmo203
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 203, "cosmo203");

  tableLink(tableID, cosmo203, sizeof(cosmo203) / sizeof(PAR));

  /*
   *  define table : cosmo205
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 205, "cosmo205");

  tableLink(tableID, cosmo205, sizeof(cosmo205) / sizeof(PAR));

  /*
   *  define table : cosmo250
   */

  instID  = institutInq(0, 0, "MCH", NULL);
  if ( instID == -1 )
    instID  = institutDef(0, 0, "MCH", NULL);

  modelID = modelInq(instID, 0, "COSMO");
  if ( modelID == -1 )
    modelID = modelDef(instID, 0, "COSMO");

  tableID = tableDef(modelID, 250, "cosmo250");

  tableLink(tableID, cosmo250, sizeof(cosmo250) / sizeof(PAR));
}

#endif  /* _TABLE_H */
#ifndef _GAUSSGRID_H
#define _GAUSSGRID_H

void   gaussaw(double *pa, double *pw, int nlat);

#endif  /* _GAUSSGRID_H */
#ifndef _GRID_H
#define _GRID_H


typedef struct {
  int     self;
  int     type;                   /* grid type                      */
  int     prec;                   /* grid precision                 */
  int    *mask;
  double *xvals;
  double *yvals;
  double *area;
  double *xbounds;
  double *ybounds;
  double  xfirst, yfirst;
  double  xlast, ylast;
  double  xinc, yinc;
  double  lcc_originLon;          /* Lambert Conformal Conic        */
  double  lcc_originLat;
  double  lcc_lonParY;
  double  lcc_lat1;
  double  lcc_lat2;
  double  lcc_xinc;
  double  lcc_yinc;
  int     lcc_projflag;
  int     lcc_scanflag;
  int     lcc_defined;
  double  lcc2_lon_0;             /* Lambert Conformal Conic 2      */
  double  lcc2_lat_0;
  double  lcc2_lat_1;
  double  lcc2_lat_2;
  double  lcc2_a;
  int     lcc2_defined;
  double  laea_lon_0;             /* Lambert Azimuthal Equal Area   */
  double  laea_lat_0;
  double  laea_a;
  int     laea_defined;
  double  xpole, ypole, angle;    /* rotated north pole             */
  int     isCyclic;               /* TRUE for global cyclic grids   */
  int     isRotated;              /* TRUE for rotated grids         */
  int     xdef;                   /* 0: undefined 1:xvals 2:x0+xinc */
  int     ydef;                   /* 0: undefined 1:yvals 2:y0+yinc */
  int     nd, ni, ni2, ni3;       /* parameter for GRID_GME         */
  int     trunc;                  /* parameter for GRID_SPECTEAL    */
  int     nvertex;
  int    *rowlon;
  int     nrowlon;
  int     size;
  int     xsize;
  int     ysize;
  int     locked;
  int     lcomplex;
  char    xname[256];
  char    yname[256];
  char    xlongname[256];
  char    ylongname[256];
  char    xstdname[256];
  char    ystdname[256];
  char    xunits[256];
  char    yunits[256];
}
grid_t;


const double *gridInqXvalsPtr(int gridID);
const double *gridInqYvalsPtr(int gridID);

double *gridInqXboundsPtr(int gridID);
double *gridInqYboundsPtr(int gridID);
const double *gridInqAreaPtr(int gridID);

int gridCompare(int gridID, grid_t grid);
int gridGenerate(grid_t grid);

#endif
#ifndef _VARSCAN_H
#define _VARSCAN_H

#ifndef _GRID_H
#  include "grid.h"
#endif


void varAddRecord(int recID, int param, int gridID, int zaxistype, int lbounds,
		  int level1, int level2, int prec,
		  int *pvarID, int *plevelID, int tsteptype, int numavg, int ltype,
		  const char *name, const char *longname, const char *units);

void varDefVCT(size_t vctsize, double *vctptr);

int  varDefGrid(int vlistID, grid_t grid, int mode);
int  varDefZaxis(int vlistID, int zaxistype, int nlevels, double *levels, int lbounds,
		 double *levels1, double *levels2, int vctsize, double *vct, char *name,
		 char *longname, char *units, int prec, int mode, int ltype);

void varDefMissval(int varID, double missval);
void varDefZtype(int varID, int ztype);
void varDefZlevel(int varID, int zlevel);
void varDefInst(int varID, int instID);
int  varInqInst(int varID);
void varDefModel(int varID, int modelID);
int  varInqModel(int varID);
void varDefTable(int varID, int tableID);
int  varInqTable(int varID);

int  zaxisCompare(int zaxisID, int zaxistype, int nlevels, int lbounds, double *levels, char *longname, char *units, int ltype);

#endif
#ifndef _BINARY_H
#define _BINARY_H

#include <stdio.h>

#ifndef _DTYPES_H
#include "dtypes.h"
#endif


UINT32 get_UINT32(unsigned char *x);
UINT32 get_SUINT32(unsigned char *x);
UINT64 get_UINT64(unsigned char *x);
UINT64 get_SUINT64(unsigned char *x);


size_t binReadF77Block(int fileID, int byteswap);
void   binWriteF77Block(int fileID, int byteswap, size_t blocksize);

int binReadInt32(int fileID, int byteswap, size_t size, INT32 *ptr);
int binReadInt64(int fileID, int byteswap, size_t size, INT64 *ptr);

int binWriteInt32(int fileID, int byteswap, size_t size, INT32 *ptr);
int binWriteInt64(int fileID, int byteswap, size_t size, INT64 *ptr);

int binReadFlt32(int fileID, int byteswap, size_t size, FLT32 *ptr);
int binReadFlt64(int fileID, int byteswap, size_t size, FLT64 *ptr);

int binWriteFlt32(int fileID, int byteswap, size_t size, FLT32 *ptr);
int binWriteFlt64(int fileID, int byteswap, size_t size, FLT64 *ptr);

#endif  /* _BINARY_H */

void swap4byte(void *ptr, size_t size);
void swap8byte(void *ptr, size_t size);
#ifndef _SERVICE_H
#define _SERVICE_H


typedef struct {
  int    checked;
  int    byteswap;
  int    header[8];
  int    hprec;      /* header precision */
  int    dprec;      /* data   precision */
  size_t datasize;
  size_t buffersize;
  void  *buffer;
}
srvrec_t;


const char *srvLibraryVersion(void);

void srvDebug(int debug);

int  srvCheckFiletype(int fileID, int *swap);

srvrec_t *srvNew(void);
void srvDelete(srvrec_t *srvp);

int  srvRead(int fileID, srvrec_t *srvp);
int  srvWrite(int fileID, srvrec_t *srvp);

int  srvInqHeader(srvrec_t *srvp, int *header);
int  srvInqDataSP(srvrec_t *srvp, float *data);
int  srvInqDataDP(srvrec_t *srvp, double *data);

int  srvDefHeader(srvrec_t *srvp, const int *header);
int  srvDefDataSP(srvrec_t *srvp, const float *data);
int  srvDefDataDP(srvrec_t *srvp, const double *data);


#endif  /* _SERVICE_H */
#ifndef _STREAM_SRV_H
#define _STREAM_SRV_H

#ifndef _SERVICE_H
#  include "service.h"
#endif

int    srvScanTimestep(int streamID);
int    srvInqContents(int streamID);
int    srvInqTimestep(int streamID, int tsID);

int    srvInqRecord(int streamID, int *varID, int *levelID);
int    srvDefRecord(int streamID);
int    srvCopyRecord(int streamIDdest, int streamIDsrc);
int    srvReadRecord(int streamID, double *data, int *nmiss);
int    srvWriteRecord(int streamID, const double *data);

void   srvReadVarDP (int streamID, int varID,       double *data, int *nmiss);
void   srvWriteVarDP(int streamID, int varID, const double *data);

void   srvReadVarSliceDP (int streamID, int varID, int levelID,       double *data, int *nmiss);
void   srvWriteVarSliceDP(int streamID, int varID, int levelID, const double *data);

#endif  /* _STREAM_SRV_H */
#ifndef _STREAM_EXT_H
#define _STREAM_EXT_H

#ifndef _EXTRA_H
#  include "extra.h"
#endif

int    extScanTimestep(int streamID);
int    extInqContents(int streamID);
int    extInqTimestep(int streamID, int tsID);

int    extInqRecord(int streamID, int *varID, int *levelID);
int    extDefRecord(int streamID);
int    extCopyRecord(int streamIDdest, int streamIDsrc);
int    extReadRecord(int streamID, double *data, int *nmiss);
int    extWriteRecord(int streamID, const double *data);

void   extReadVarDP (int streamID, int varID,       double *data, int *nmiss);
void   extWriteVarDP(int streamID, int varID, const double *data);

void   extReadVarSliceDP (int streamID, int varID, int levelID,       double *data, int *nmiss);
void   extWriteVarSliceDP(int streamID, int varID, int levelID, const double *data);

#endif  /* _STREAM_EXT_H */
#ifndef _STREAM_IEG_H
#define _STREAM_IEG_H

#ifndef _IEG_H
#  include "ieg.h"
#endif

int    iegScanTimestep(int streamID);
int    iegInqContents(int streamID);
int    iegInqTimestep(int streamID, int tsID);

int    iegInqRecord(int streamID, int *varID, int *levelID);
int    iegDefRecord(int streamID);
int    iegCopyRecord(int streamIDdest, int streamIDsrc);
int    iegReadRecord(int streamID, double *data, int *nmiss);
int    iegWriteRecord(int streamID, const double *data);

void   iegReadVarDP (int streamID, int varID,       double *data, int *nmiss);
void   iegWriteVarDP(int streamID, int varID, const double *data);

void   iegReadVarSliceDP (int streamID, int varID, int levelID,       double *data, int *nmiss);
void   iegWriteVarSliceDP(int streamID, int varID, int levelID, const double *data);

#endif  /* _STREAM_IEG_H */
#ifndef _CDF_INT_H
#define _CDF_INT_H

#if  defined  (HAVE_LIBNETCDF)

#include "netcdf.h"

void cdf_create (const char *path, int cmode, int *idp);
int  cdf_open   (const char *path, int omode, int *idp);
void cdf_close  (int ncid);

void cdf_redef (int ncid);
void cdf_enddef (int ncid);
void cdf_sync (int ncid);

void cdf_inq (int ncid, int *ndimsp, int *nvarsp, int *ngattsp, int *unlimdimidp);

void cdf_def_dim (int ncid, const char *name, size_t len, int *idp);
void cdf_inq_dimid (int ncid, const char *name, int *dimidp);
void cdf_inq_dim (int ncid, int dimid, char *name, size_t * lengthp);
void cdf_inq_dimname (int ncid, int dimid, char *name);
void cdf_inq_dimlen (int ncid, int dimid, size_t * lengthp);
void cdf_def_var (int ncid, const char *name, nc_type xtype, int ndims,
		 const int dimids[], int *varidp);
void cdf_inq_varid (int ncid, const char *name, int *varidp);
void cdf_inq_nvars (int ncid, int *nvarsp);
void cdf_inq_var (int ncid, int varid, char *name, nc_type *xtypep,
		 int *ndimsp, int dimids[], int *nattsp);
void cdf_inq_varname (int ncid, int varid, char *name);
void cdf_inq_vartype (int ncid, int varid, nc_type *xtypep);
void cdf_inq_varndims (int ncid, int varid, int *ndimsp);
void cdf_inq_vardimid (int ncid, int varid, int dimids[]);
void cdf_inq_varnatts (int ncid, int varid, int *nattsp);

void cdf_copy_att (int ncid_in, int varid_in, const char *name, int ncid_out, int varid_out);
void cdf_put_var_text   (int ncid, int varid, const char *tp);
void cdf_put_var_uchar  (int ncid, int varid, const unsigned char *up);
void cdf_put_var_schar  (int ncid, int varid, const signed char *cp);
void cdf_put_var_short  (int ncid, int varid, const short *sp);
void cdf_put_var_int    (int ncid, int varid, const int *ip);
void cdf_put_var_long   (int ncid, int varid, const long *lp);
void cdf_put_var_float  (int ncid, int varid, const float *fp);
void cdf_put_var_double (int ncid, int varid, const double *dp);

void cdf_get_var_text   (int ncid, int varid, char *tp);
void cdf_get_var_uchar  (int ncid, int varid, unsigned char *up);
void cdf_get_var_schar  (int ncid, int varid, signed char *cp);
void cdf_get_var_short  (int ncid, int varid, short *sp);
void cdf_get_var_int    (int ncid, int varid, int *ip);
void cdf_get_var_long   (int ncid, int varid, long *lp);
void cdf_get_var_float  (int ncid, int varid, float *fp);
void cdf_get_var_double (int ncid, int varid, double *dp);

void cdf_get_var1_double(int ncid, int varid, const size_t index[], double *dp);
void cdf_put_var1_double(int ncid, int varid, const size_t index[], const double *dp);

void cdf_get_vara_double(int ncid, int varid, const size_t start[],
                         const size_t count[], double *dp);
void cdf_put_vara_double(int ncid, int varid, const size_t start[],
                         const size_t count[], const double *dp);

void cdf_put_att_text (int ncid, int varid, const char *name, size_t len,
		      const char *tp);
void cdf_put_att_int (int ncid, int varid, const char *name, nc_type xtype,
		     size_t len, const int *ip);
void cdf_put_att_double (int ncid, int varid, const char *name, nc_type xtype,
			size_t len, const double *dp);

void cdf_get_att_text (int ncid, int varid, char *name, char *tp);
void cdf_get_att_int (int ncid, int varid, char *name, int *ip);
void cdf_get_att_double (int ncid, int varid, char *name, double *dp);

void cdf_inq_att (int ncid, int varid, const char *name, nc_type * xtypep,
		 size_t * lenp);
void cdf_inq_atttype (int ncid, int varid, const char *name, nc_type *xtypep);
void cdf_inq_attlen (int ncid, int varid, const char *name, size_t *lenp);
void cdf_inq_attname (int ncid, int varid, int attnum, char *name);
void cdf_inq_attid (int ncid, int varid, const char *name, int *attnump);

#endif

#endif  /* _CDF_INT_H */
#ifndef _CDF_H
#define _CDF_H

void cdfDebug(int debug);

const char *cdfLibraryVersion(void);
const char *hdfLibraryVersion(void);

int  cdfOpen(const char *filename, const char *mode);
int  cdfOpen64(const char *filename, const char *mode);
int  cdf4Open(const char *filename, const char *mode);
void cdfClose(int fileID);

#endif  /* _CDF_H */
#ifndef _VLIST_H
#define _VLIST_H

#ifndef _CDI_LIMITS_H
#  include "cdi_limits.h"
#endif


/*
 * CDI attribute
 */
typedef struct {
  size_t    xsz;	  /* amount of space at xvalue             */
  size_t    namesz;       /* size of name                          */
  char     *name;         /* attribute name                        */
  int       type;	  /* data type of xvalue (INT, FLT or TXT) */
  int       nctype;
  size_t    nelems;    	  /* number of elements                    */
  void     *xvalue;       /* the actual data                       */
} cdi_att_t;


typedef struct {
  size_t     nalloc;		/* number allocated >= nelems */
  size_t     nelems;		/* length of the array */
  cdi_att_t  value[MAX_ATTRIBUTES];
} cdi_atts_t;


typedef struct
{
  int      flag;
  int      index;
  int      mlevelID;
  int      flevelID;
}
levinfo_t;


typedef struct
{
  int         flag;
  int         nlevs;
  int         isUsed;
  int         mvarID;
  int         fvarID;
  int         param;
  int         gridID;
  int         zaxisID;
  int         timeID;    /* TIME_VARIABLE or TIME_CONSTANT */
  int         datatype;  /* DATATYPE_PACKX for GRIB data, else DATATYPE_FLT32 or DATATYPE_FLT64 */
  int         instID;
  int         modelID;
  int         tableID;
  int         tsteptype; /* Time step type: TSTEP_INSTANT, TSTEP_AVG ... */
  int         timave;
  int         timaccu;
  int         func;
  int         missvalused; /* TRUE if missval is defined */
  char       *name;
  char       *longname;
  char       *stdname;
  char       *units;
  double      missval;
  double      scalefactor;
  double      addoffset;
  levinfo_t  *levinfo;
  int         ztype;
  int         zlevel;
  cdi_atts_t  atts;
}
var_t;


typedef struct
{
  int         self;
  int         used;
  int         nlock;
  int         nvars;        /* number of variables                */
  int         ngrids;
  int         nzaxis;
  int         ntsteps;
  int         taxisID;
  int         tableID;
  int         instID;
  int         modelID;
  int         varsAllocated;
  int         gridIDs[MAX_GRIDS_PS];
  int         zaxisIDs[MAX_ZAXES_PS];
  var_t      *vars;
  cdi_atts_t  atts;
}
vlist_t;


vlist_t *vlist_to_pointer(int vlistID);
void     vlistCheckVarID(char *func, int vlistID, int varID);
int      vlistNlock(int vlistID);
void     vlistLock(int vlistID);
void     vlistUnlock(int vlistID);
char    *vlistInqVarNamePtr(int vlistID, int varID);
char    *vlistInqVarLongnamePtr(int vlistID, int varID);
char    *vlistInqVarStdnamePtr(int vlistID, int varID);
char    *vlistInqVarUnitsPtr(int vlistID, int varID);
void     vlistDestroyVarName(int vlistID, int varID);
void     vlistDestroyVarLongname(int vlistID, int varID);
void     vlistDestroyVarUnits(int vlistID, int varID);
void     vlistDefVarTime(int vlistID, int varID, int timeID);
int      vlistInqVarMissvalUsed(int vlistID, int varID);
int      vlistHasTime(int vlistID);

int      vlistDelAtts(int vlistID, int varID);
int      vlistCopyVarAtts(int vlistID1, int varID_1, int vlistID2, int varID_2);

#endif  /* _VLIST_H */
#if  defined  (HAVE_CONFIG_H)
#endif



#if ! defined (HAVE_CONFIG_H)
#if ! defined (HAVE_MALLOC_H)
#  if defined (SX)
#    define  HAVE_MALLOC_H
#  endif
#endif
#endif

#if  defined  (HAVE_MALLOC_H)
#    include <malloc.h>
#endif


#define  MALLOC_FUNC   0
#define  CALLOC_FUNC   1
#define  REALLOC_FUNC  2
#define  FREE_FUNC     3

#undef   UNDEFID
#define  UNDEFID  -1

#define  MAXNAME  32   /* Min = 8, for  "unknown" ! */

int dmemory_ExitOnError = 0;

typedef struct
{
  void     *ptr;
  int       item;
  size_t    size;
  size_t    nobj;
  int       mtype;
  int       line;
  char      file[MAXNAME];
  char      caller[MAXNAME];
}
MemTable;

static MemTable *memTable;
static int     memTableSize  = 0;
static long    memAccess     = 0;

static size_t  MemObjs       = 0;
static size_t  MaxMemObjs    = 0;
static size_t  MemUsed       = 0;
static size_t  MaxMemUsed    = 0;

static int     MEM_Debug     = 0;   /* If set to 1, debugging */

void memDebug(int debug)
{
  MEM_Debug = debug;
}

static
void memInternalProblem(const char *caller, const char *fmt, ...)
{
  va_list args;
	
  va_start(args, fmt);

  printf("\n");
   fprintf(stderr, "Internal problem (%s) : ", caller);
  vfprintf(stderr, fmt, args);
   fprintf(stderr, "\n");

  va_end(args);

  exit(EXIT_FAILURE);
}

static
void memError(const char *caller, const char *file, int line, size_t size)
{
  printf("\n");
  fprintf(stderr, "Error (%s) : Allocation of %lu bytes failed. [ line %d file %s ]\n",
	  caller, (unsigned long) size, line, file);

  if ( errno )
    perror("System error message ");
	
  exit(EXIT_FAILURE);
}

static
void memListPrintEntry(int mtype, int item, size_t size, void *ptr,
		       const char *caller, const char *file, int line)
{
  switch (mtype)
    {
    case MALLOC_FUNC:
      fprintf(stderr, "[%-7s ", "Malloc");
      break;
    case CALLOC_FUNC:
      fprintf(stderr, "[%-7s ", "Calloc");
      break;
    case REALLOC_FUNC:
      fprintf(stderr, "[%-7s ", "Realloc");
      break;
    case FREE_FUNC:
      fprintf(stderr, "[%-7s ", "Free");
      break;
    }

   fprintf(stderr, "memory item %3d ", item);
   fprintf(stderr, "(%6lu byte) ", (unsigned long) size);
   fprintf(stderr, "at %p", ptr);
   if ( file != NULL )
     {
       fprintf(stderr, " line %4d", line);
       fprintf(stderr, " file %s", file);
     }    
   if ( caller != NULL )
     fprintf(stderr, " (%s)", caller);     
   fprintf(stderr, "]\n");
}

static
void memListPrintTable(void)
{
  int memID, item, item1, item2 = 0;

  if ( MemObjs ) fprintf(stderr, "\nMemory table:\n");

  /* find maximum item */
  for ( memID = 0; memID < memTableSize; memID++ )
    if ( memTable[memID].item != UNDEFID )
      if ( memTable[memID].item > item2 ) item2 = memTable[memID].item;

  /* find minimum item */
  item1 = item2;
  for ( memID = 0; memID < memTableSize; memID++ )
    if ( memTable[memID].item != UNDEFID )
      if ( memTable[memID].item < item1 ) item1 = memTable[memID].item;

  for ( item = item1; item <= item2; item++ )
    for ( memID = 0; memID < memTableSize; memID++ )
      {
	if ( memTable[memID].item == item )
	  memListPrintEntry(memTable[memID].mtype, memTable[memID].item,
			    memTable[memID].size*memTable[memID].nobj,
			    memTable[memID].ptr, memTable[memID].caller,
			    memTable[memID].file, memTable[memID].line);
      }

  if ( MemObjs )
    {
      fprintf(stderr, "  Memory access             : %6u\n", (unsigned) memAccess);
      fprintf(stderr, "  Maximum objects           : %6u\n", (unsigned) memTableSize);
      fprintf(stderr, "  Objects used              : %6u\n", (unsigned) MaxMemObjs);
      fprintf(stderr, "  Objects in use            : %6u\n", (unsigned) MemObjs);
      fprintf(stderr, "  Memory allocated          : ");
      if (MemUsed > 1024*1024*1024)
	fprintf(stderr, " %5d GB\n",   (int) (MemUsed/(1024*1024*1024)));
      else if (MemUsed > 1024*1024)
	fprintf(stderr, " %5d MB\n",   (int) (MemUsed/(1024*1024)));
      else if (MemUsed > 1024)
	fprintf(stderr, " %5d KB\n",   (int) (MemUsed/(1024)));
      else
	fprintf(stderr, " %5d Byte\n", (int)  MemUsed);
    }

  if ( MaxMemUsed )
    {
      fprintf(stderr, "  Maximum memory allocated  : ");
      if (MaxMemUsed > 1024*1024*1024)
	fprintf(stderr, " %5d GB\n",   (int) (MaxMemUsed/(1024*1024*1024)));
      else if (MaxMemUsed > 1024*1024)
	fprintf(stderr, " %5d MB\n",   (int) (MaxMemUsed/(1024*1024)));
      else if (MaxMemUsed > 1024)
	fprintf(stderr, " %5d KB\n",   (int) (MaxMemUsed/(1024)));
      else
	fprintf(stderr, " %5d Byte\n", (int)  MaxMemUsed);
    }
}

static
void memGetDebugLevel(void)
{
  char *debugLevel;

  debugLevel = getenv("MEMORY_DEBUG");

  if ( debugLevel )
    {
      if ( isdigit((int) debugLevel[0]) )
	MEM_Debug = atoi(debugLevel);

      if ( MEM_Debug )
	atexit(memListPrintTable);
    }
}

static
void memInit(void)
{
  static int initDebugLevel = 0;

  if ( ! initDebugLevel )
    {
      memGetDebugLevel();
      initDebugLevel = 1;
    }  
}

static
int memListDeleteEntry(void *ptr, size_t *size)
{
  int memID = 0;
  int item = UNDEFID;

  for ( memID = 0; memID < memTableSize; memID++ )
    {
      if ( memTable[memID].item == UNDEFID ) continue;
      if ( memTable[memID].ptr == ptr ) break;
    }

  if ( memID != memTableSize )
    {
      MemObjs--;
      MemUsed -= memTable[memID].size * memTable[memID].nobj;
      *size = memTable[memID].size * memTable[memID].nobj;
       item = memTable[memID].item;
       memTable[memID].item   = UNDEFID;
    }

  return (item);
}

static
void memTableInitEntry(int memID)
{
  static char func[] = "memTableInitEntry";

  if ( memID < 0 || memID >= memTableSize )
    memInternalProblem(func, "memID %d undefined!", memID);

  memTable[memID].ptr    = NULL;
  memTable[memID].item   = UNDEFID;
  memTable[memID].size   = 0;
  memTable[memID].nobj   = 0;
  memTable[memID].mtype  = UNDEFID;
  memTable[memID].line   = UNDEFID;
}

static
int memListNewEntry(int mtype, void *ptr, size_t size, size_t nobj,
		    const char *caller, const char *file, int line)
{
  static char func[] = "memListNewEntry";
  static int item = 0;
  size_t memSize = 0;
  int memID = 0;
  size_t len;
  int i;

  /*
    Look for a free slot in memTable.
    (Create the table the first time through).
  */
  if ( memTableSize == 0 )
    {
      memTableSize = 8;
      memSize  = memTableSize*sizeof(MemTable);
      memTable = (MemTable *) malloc(memSize);
      if( memTable == NULL ) memError(func, __FILE__, __LINE__, memSize);

      for( i = 0; i < memTableSize; i++ )
	memTableInitEntry(i);
    }
  else
    {
      while( memID < memTableSize )
	{
	  if ( memTable[memID].item == UNDEFID ) break;
	  memID++;
	}
    }
  /*
    If the table overflows, double its size.
  */
  if ( memID == memTableSize )
    {
      memTableSize = 2*memTableSize;
      memSize  = memTableSize*sizeof(MemTable);
      memTable = (MemTable *) realloc(memTable, memSize);
      if( memTable == NULL ) memError(func, __FILE__, __LINE__, memSize);

      for( i = memID; i < memTableSize; i++ )
	memTableInitEntry(i);
    }

  memTable[memID].item  = item;
  memTable[memID].ptr   = ptr;
  memTable[memID].size  = size;
  memTable[memID].nobj  = nobj;
  memTable[memID].mtype = mtype;
  memTable[memID].line  = line;

  if ( file )
    {
      len = strlen(file);
      if ( len > MAXNAME-1 ) len = MAXNAME-1;
    
      (void) memcpy(memTable[memID].file, file, len);
      memTable[memID].file[len] = '\0';
    }
  else
    {
      (void) strcpy(memTable[memID].file, "unknown");
    }

  if ( caller )
    {
      len = strlen(caller);
      if ( len > MAXNAME-1 ) len = MAXNAME-1;

      (void) memcpy(memTable[memID].caller, caller, len);
      memTable[memID].caller[len] = '\0';
    }
  else
    {
      (void) strcpy(memTable[memID].caller, "unknown");
    }

  MaxMemObjs++;
  MemObjs++;
  MemUsed += size*nobj;
  if ( MemUsed > MaxMemUsed ) MaxMemUsed = MemUsed;

  return (item++);
}

static
int memListChangeEntry(void *ptrold, void *ptr, size_t size,
		       const char *caller, const char *file, int line)
{
  static char func[] = "memListChangeEntry";
  int item = UNDEFID;
  int memID = 0;
  size_t len;
  size_t sizeold;

  while( memID < memTableSize )
    {
      if ( memTable[memID].item != UNDEFID )
	if ( memTable[memID].ptr == ptrold ) break;
      memID++;
    }

  if ( memID == memTableSize )
    {
      if ( ptrold != NULL )
	memInternalProblem(func, "Item at %p not found.", ptrold);
    }
  else
    {
      item = memTable[memID].item;

      sizeold = memTable[memID].size*memTable[memID].nobj;
      
      memTable[memID].ptr   = ptr;
      memTable[memID].size  = size;
      memTable[memID].nobj  = 1;
      memTable[memID].mtype = REALLOC_FUNC;
      memTable[memID].line  = line;

      if ( file )
	{
	  len = strlen(file);
	  if ( len > MAXNAME-1 ) len = MAXNAME-1;

	  (void) memcpy(memTable[memID].file, file, len);
	  memTable[memID].file[len] = '\0';
	}
      else
	{
	  (void) strcpy(memTable[memID].file, "unknown");
	}

      if ( caller )
	{
	  len = strlen(caller);
	  if ( len > MAXNAME-1 ) len = MAXNAME-1;

	  (void) memcpy(memTable[memID].caller, caller, len);
	  memTable[memID].caller[len] = '\0';
	}
      else
	{
	  (void) strcpy(memTable[memID].caller, "unknown");
	}

      MemUsed -= sizeold;
      MemUsed += size;
      if ( MemUsed > MaxMemUsed ) MaxMemUsed = MemUsed;
    }

  return (item);
}


void *Calloc(const char *caller, const char *file, int line, size_t nobjs, size_t size)
{
  void *ptr = NULL;
  int item = UNDEFID;

  memInit();

  if ( nobjs*size > 0 )
    {
      ptr = calloc(nobjs, size);

      if ( MEM_Debug )
	{
	  memAccess++;

	  if ( ptr )
	    item = memListNewEntry(CALLOC_FUNC, ptr, size, nobjs, caller, file, line);

	  memListPrintEntry(CALLOC_FUNC, item, size*nobjs, ptr, caller, file, line);
	}

      if ( ptr == NULL && dmemory_ExitOnError )
	memError(caller, file, line, size*nobjs);
    }
  else
    fprintf(stderr, "Warning (%s) : Allocation of 0 bytes! [ line %d file %s ]\n", caller, line, file);

  return(ptr);
}


void *Malloc(const char *caller, const char *file, int line, size_t size)
{
  void *ptr = NULL;
  int item = UNDEFID;

  memInit();

  if ( size > 0 )
    {
      ptr = malloc(size);

      if ( MEM_Debug )
	{
	  memAccess++;

	  if ( ptr )
	    item = memListNewEntry(MALLOC_FUNC, ptr, size, 1, caller, file, line);

	  memListPrintEntry(MALLOC_FUNC, item, size, ptr, caller, file, line);
	}

      if ( ptr == NULL && dmemory_ExitOnError )
	memError(caller, file, line, size);
    }
  else
    fprintf(stderr, "Warning (%s) : Allocation of 0 bytes! [ line %d file %s ]\n", caller, line, file);

  return (ptr);
}


void *Realloc(const char *caller, const char *file, int line, void *ptrold, size_t size)
{
  void *ptr = NULL;
  int item = UNDEFID;

  memInit();

  if ( size > 0 )
    {
      ptr = realloc(ptrold, size);

      if ( MEM_Debug )
	{
	  memAccess++;

	  if ( ptr )
	    {
	      item = memListChangeEntry(ptrold, ptr, size, caller, file, line);

	      if ( item == UNDEFID )
		item = memListNewEntry(REALLOC_FUNC, ptr, size, 1, caller, file, line);
	    }

	  memListPrintEntry(REALLOC_FUNC, item, size, ptr, caller, file, line);
	}

      if ( ptr == NULL && dmemory_ExitOnError )
	memError(caller, file, line, size);
    }
  else
    fprintf(stderr, "Warning (%s) : Allocation of 0 bytes! [ line %d file %s ]\n", caller, line, file);

  return (ptr);
}


void Free(const char *caller, const char *file, int line, void *ptr)
{
  static char func[] = "Free";
  int item;
  size_t size;

  memInit();

  if ( MEM_Debug )
    {
      if ( (item = memListDeleteEntry(ptr, &size)) >= 0 )
	{
	  memListPrintEntry(FREE_FUNC, item, size, ptr, caller, file, line);
	}
      else
	{
	  if ( ptr )
	    fprintf(stderr, "%s info: memory entry at %p not found. [line %4d file %s (%s)]\n",
		    func, ptr, line, file, caller);
	}
    }

  free(ptr);
}


size_t memTotal(void)
{
  size_t memtotal = 0;
#if  defined  (HAVE_MALLINFO)
  struct mallinfo meminfo = mallinfo();
  if ( MEM_Debug )
    {
      fprintf(stderr, "arena      %8ld (non-mmapped space allocated from system)\n", (unsigned long) meminfo.arena);
      fprintf(stderr, "ordblks    %8ld (number of free chunks)\n", (unsigned long) meminfo.ordblks);
      fprintf(stderr, "smblks     %8ld (number of fastbin blocks)\n", (unsigned long) meminfo.smblks);
      fprintf(stderr, "hblks      %8ld (number of mmapped regions)\n", (unsigned long) meminfo.hblks);
      fprintf(stderr, "hblkhd     %8ld (space in mmapped regions)\n", (unsigned long) meminfo.hblkhd);
      fprintf(stderr, "usmblks    %8ld (maximum total allocated space)\n", (unsigned long) meminfo.usmblks);
      fprintf(stderr, "fsmblks    %8ld (maximum total allocated space)\n", (unsigned long) meminfo.fsmblks);
      fprintf(stderr, "uordblks   %8ld (total allocated space)\n", (unsigned long) meminfo.uordblks);
      fprintf(stderr, "fordblks   %8ld (total free space)\n", (unsigned long) meminfo.fordblks);
      fprintf(stderr, "Memory in use:   %8ld bytes\n", (unsigned long) meminfo.usmblks + meminfo.uordblks);
      fprintf(stderr, "Total heap size: %8ld bytes\n", (unsigned long) meminfo.arena);

      /* malloc_stats(); */
    }
  memtotal = meminfo.arena;
#endif

  return (memtotal);
}


void memExitOnError(void)
{
  dmemory_ExitOnError = 1;
}
#ifndef _DMEMORY_H
#define _DMEMORY_H


/*
 * if DEBUG_MEMORY is defined setenv MEMORY_DEBUG to debug memory
 */

#define  DEBUG_MEMORY

#define  WITH_CALLER_NAME

extern size_t  memTotal(void);
extern void    memDebug(int debug);
extern void    memExitOnError(void);

#if  defined  DEBUG_MEMORY

extern void   *Realloc(const char *caller, const char *file, int line, void *ptr, size_t size);
extern void   *Calloc (const char *caller, const char *file, int line, size_t nmemb, size_t size);
extern void   *Malloc (const char *caller, const char *file, int line, size_t size);
extern void    Free   (const char *caller, const char *file, int line, void *ptr);

#if  defined  calloc
#  undef  calloc
#endif

#if  defined  WITH_CALLER_NAME
#  define  realloc(p, s)  Realloc(func, __FILE__, __LINE__, p, (size_t)s)
#  define   calloc(n, s)   Calloc(func, __FILE__, __LINE__, n, (size_t)s)
#  define   malloc(s)      Malloc(func, __FILE__, __LINE__, (size_t)s)
#  define     free(p)        Free(func, __FILE__, __LINE__, p)
#else
#  define  realloc(p, s)  Realloc((void *) NULL, __FILE__, __LINE__, p, (size_t)s)
#  define   calloc(n, s)   Calloc((void *) NULL, __FILE__, __LINE__, n, (size_t)s)
#  define   malloc(s)      Malloc((void *) NULL, __FILE__, __LINE__, (size_t)s)
#  define     free(p)        Free((void *) NULL, __FILE__, __LINE__, p)
#endif

#endif /* DEBUG_MEMORY */

#endif /* _DMEMORY_H */
#if defined (HAVE_CONFIG_H)
#endif




extern int cdiDefaultCalendar;

static int DefaultTimeType = TAXIS_ABSOLUTE;
static int DefaultTimeUnit = TUNIT_HOUR;


char *Timeunits[] = {
  "undefined",
  "seconds",
  "minutes",
  "hours",
  "days",
  "months",
  "years",
  "quarter",
  "3hours",
  "6hours",
  "12hours",
};


char *tunitNamePtr(int unitID)
{
  char *name;
  int size = sizeof(Timeunits)/sizeof(char *);

  if ( unitID > 0 && unitID < size )
    name = Timeunits[unitID];
  else
    name = Timeunits[0];

  return (name);
}


void taxis_defaults(void)
{
  static char func[] = "taxis_defaults";
  char *timeunit;

  timeunit = getenv("TIMEUNIT");
  if ( timeunit )
    {
      if ( strcmp(timeunit, "minute") == 0 )
	DefaultTimeUnit = TUNIT_MINUTE;
      else if ( strcmp(timeunit, "hour") == 0 )
	DefaultTimeUnit = TUNIT_HOUR;
      else if ( strcmp(timeunit, "3hours") == 0 )
	DefaultTimeUnit = TUNIT_3HOURS;
      else if ( strcmp(timeunit, "6hours") == 0 )
	DefaultTimeUnit = TUNIT_6HOURS;
      else if ( strcmp(timeunit, "12hours") == 0 )
	DefaultTimeUnit = TUNIT_12HOURS;
      else if ( strcmp(timeunit, "day") == 0 )
	DefaultTimeUnit = TUNIT_DAY;
      else if ( strcmp(timeunit, "month") == 0 )
	DefaultTimeUnit = TUNIT_MONTH;
      else if ( strcmp(timeunit, "year") == 0 )
	DefaultTimeUnit = TUNIT_YEAR;
      else
	Warning(func, "Unsupported TIMEUNIT %s!", timeunit);
    }
}


static int  TAXIS_Debug = 0;   /* If set to 1, debugging */

static int _taxis_min = MIN_TAXES;
static int _taxis_max = MAX_TAXES;

static void taxis_initialize(void);

static int _taxis_init = FALSE;

#if  defined  (HAVE_LIBPTHREAD)

static pthread_once_t  _taxis_init_thread = PTHREAD_ONCE_INIT;
static pthread_mutex_t _taxis_mutex;

#  define TAXIS_LOCK()         pthread_mutex_lock(&_taxis_mutex)
#  define TAXIS_UNLOCK()       pthread_mutex_unlock(&_taxis_mutex)
#  define TAXIS_INIT()	      \
   if ( _taxis_init == FALSE ) pthread_once(&_taxis_init_thread, taxis_initialize)

#else

#  define TAXIS_LOCK()
#  define TAXIS_UNLOCK()
#  define TAXIS_INIT()	      \
   if ( _taxis_init == FALSE ) taxis_initialize()

#endif


typedef struct _taxisPtrToIdx {
  int      idx;
  int      next;
  taxis_t *ptr;
} taxisPtrToIdx;


static taxisPtrToIdx *_taxisList  = NULL;
static int            _taxisAvail = -1;

static
void taxis_list_new(void)
{
  static char func[] = "taxis_list_new";

  assert(_taxisList == NULL);

  _taxisList = (taxisPtrToIdx *) malloc(_taxis_min*sizeof(taxisPtrToIdx));
}

static
void taxis_list_delete(void)
{
  static char func[] = "taxis_list_delete";

  if ( _taxisList ) free(_taxisList);
}

static
void taxis_init_pointer(void)
{
  int  i;
  
  for ( i = 0; i < _taxis_min; ++i )
    {
      _taxisList[i].idx  = i;
      _taxisList[i].next = i + 1;
      _taxisList[i].ptr  = NULL;
    }

  _taxisList[_taxis_min-1].next = -1;

  _taxisAvail = 0;
}

static
void taxis_list_extend(void)
{
  static char func[] = "taxis_list_extend";
  int ntaxis;
  int i;

  assert(_taxisList != NULL);

  ntaxis = _taxis_min + MIN_TAXES;

  if ( ntaxis <= _taxis_max)
    {
      _taxisList = (taxisPtrToIdx *) realloc(_taxisList, ntaxis*sizeof(taxisPtrToIdx));
  
      for ( i = _taxis_min; i < ntaxis; ++i )
	{
	  _taxisList[i].idx  = i;
	  _taxisList[i].next = i + 1;
	  _taxisList[i].ptr  = NULL;
	}

      _taxisAvail = _taxis_min;
      _taxisList[_taxis_min-1].next = _taxis_min;
      _taxis_min = ntaxis;
      _taxisList[_taxis_min-1].next = -1;
    }
  else
    Warning(func, "Too many open taxes (limit is %d)!", _taxis_max);
}


taxis_t *taxis_to_pointer(int idx)
{
  static char func[] = "taxis_to_pointer";
  taxis_t *taxisptr = NULL;

  TAXIS_INIT();

  if ( idx >= 0 && idx < _taxis_min )
    {
      TAXIS_LOCK();

      taxisptr = _taxisList[idx].ptr;

      TAXIS_UNLOCK();
    }
  else
    Error(func, "taxis index %d undefined!", idx);

  return (taxisptr);
}


/* Create an index from a pointer */
static
int taxis_from_pointer(taxis_t *ptr)
{
  static char func[] = "taxis_from_pointer";
  int      idx = -1;

  if ( ptr )
    {
      TAXIS_LOCK();

      if ( _taxisAvail < 0 ) taxis_list_extend();

      if ( _taxisAvail >= 0 )
	{
	  taxisPtrToIdx *newptr;

	  newptr       = &_taxisList[_taxisAvail];
	  _taxisAvail  = newptr->next;
	  newptr->next = -1;
	  idx	       = newptr->idx;
	  newptr->ptr  = ptr;
      
	  if ( TAXIS_Debug )
	    Message(func, "Pointer %p has idx %d from taxis list", ptr, idx);
	}

      TAXIS_UNLOCK();
    }
  else
    Error(func, "Internal problem (pointer %p undefined)", ptr);

  return (idx);
}


void taxis_init_ptr(taxis_t *taxisptr)
{
  taxisptr->self       = -1;

  taxisptr->used       = FALSE;
  taxisptr->type       = DefaultTimeType;
  taxisptr->vdate      = 0;
  taxisptr->vtime      = 0;
  taxisptr->rdate      = CDI_UNDEFID;
  taxisptr->rtime      = 0;
  taxisptr->calendar   = cdiDefaultCalendar;
  taxisptr->unit       = DefaultTimeUnit;
  taxisptr->numavg     = 0;
  taxisptr->has_bounds = FALSE;
  taxisptr->vdate_lb   = 0;
  taxisptr->vtime_lb   = 0;
  taxisptr->vdate_ub   = 0;
  taxisptr->vtime_ub   = 0;
}


void taxis_init_entry(taxis_t *taxisptr)
{
  taxis_init_ptr(taxisptr);

  taxisptr->self       = taxis_from_pointer(taxisptr);
}

static
taxis_t *taxis_new_entry(void)
{
  static char func[] = "taxis_new_entry";
  taxis_t *taxisptr;

  taxisptr = (taxis_t *) malloc(sizeof(taxis_t));

  if ( taxisptr ) taxis_init_entry(taxisptr);

  return (taxisptr);
}

static
void taxis_delete_entry(taxis_t *taxisptr)
{
  static char func[] = "taxis_delete_entry";
  int idx;

  idx = taxisptr->self;

  TAXIS_LOCK();

  free(taxisptr);

  _taxisList[idx].next = _taxisAvail;
  _taxisList[idx].ptr  = 0;
  _taxisAvail          = idx;

  TAXIS_UNLOCK();

  if ( TAXIS_Debug )
    Message(func, "Removed idx %d from taxis list", idx);
}

static
void taxis_initialize(void)
{
  char *env;

#if  defined  (HAVE_LIBPTHREAD)
  /* initialize global API mutex lock */
  pthread_mutex_init(&_taxis_mutex, NULL);
#endif

  env = getenv("TAXIS_DEBUG");
  if ( env ) TAXIS_Debug = atoi(env);

  taxis_list_new();
  atexit(taxis_list_delete);

  TAXIS_LOCK();

  taxis_init_pointer();
  
  TAXIS_UNLOCK();

  _taxis_init = TRUE;

  taxis_defaults();
}

static
void taxis_copy(taxis_t *taxisptr2, taxis_t *taxisptr1)
{
  int taxisID2;

  taxisID2 = taxisptr2->self;
  memcpy(taxisptr2, taxisptr1, sizeof(taxis_t));
  taxisptr2->self = taxisID2;
}

static
void taxis_check_ptr(const char *func, taxis_t *taxisptr)
{
  if ( taxisptr == NULL )
    Error(func, "taxis undefined!");
}


/*
@Function  taxisCreate
@Title     Create a Time axis

@Prototype int taxisCreate(int taxistype)
@Parameter
    @Item  taxistype  The type of the Time axis, one of the set of predefined CDI time axis types.
                      The valid CDI time axis types are @func{TAXIS_ABSOLUTE} and @func{TAXIS_RELATIVE}.

@Description
The function @func{taxisCreate} creates a Time axis.

@Result
@func{taxisCreate} returns an identifier to the Time axis.

@Example
Here is an example using @func{taxisCreate} to create a relative T-axis
with a standard calendar.

@Source
   ...
int taxisID;
   ...
taxisID = taxisCreate(TAXIS_RELATIVE);
taxisDefCalendar(taxisID, CALENDAR_STANDARD);
taxisDefRdate(taxisID, 19870101);
taxisDefRtime(taxisID, 120000);
   ...
@EndSource
@EndFunction
*/
int taxisCreate(int taxistype)
{
  static char func[] = "taxisCreate";
  int taxisID;
  taxis_t *taxisptr;

  if ( CDI_Debug )
    Message(func, "taxistype: %d", taxistype);

  TAXIS_INIT();

  taxisptr = taxis_new_entry();
  if ( ! taxisptr ) Error(func, "No memory");

  taxisID = taxisptr->self;
  taxisptr->type = taxistype;

  if ( CDI_Debug )
    Message(func, "taxisID: %d", taxisID);

  return (taxisID);
}


/*
@Function  taxisDestroy
@Title     Destroy a Time axis

@Prototype void taxisDestroy(int taxisID)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @func{taxisCreate}

@EndFunction
*/
void taxisDestroy(int taxisID)
{
  static char func[] = "taxisDestroy";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxis_delete_entry(taxisptr);
}


int taxisDuplicate(int taxisID1)
{
  static char func[] = "taxisDuplicate";
  int taxisID2;
  taxis_t *taxisptr1;
  taxis_t *taxisptr2;

  taxisptr1 = taxis_to_pointer(taxisID1);

  taxisptr2 = taxis_new_entry();
  if ( ! taxisptr2 ) Error(func, "No memory");

  taxisID2 = taxisptr2->self;

  if ( CDI_Debug )
    Message(func, "taxisID2: %d", taxisID2);

  ptaxisCopy(taxisptr2, taxisptr1);

  // taxisptr2->has_bounds = FALSE;

  return (taxisID2);
}


void taxisDefType(int taxisID, int type)
{
  static char func[] = "taxisDefType";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->type = type;
}


/*
@Function  taxisDefVdate
@Title     Define the verification date

@Prototype void taxisDefVdate(int taxisID, int vdate)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}
    @Item  vdate    Verification date (YYYYMMDD)

@Description
The function @func{taxisDefVdate} defines the verification date of a Time axis.

@EndFunction
*/
void taxisDefVdate(int taxisID, int vdate)
{
  static char func[] = "taxisDefVdate";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->vdate = vdate;
}


/*
@Function  taxisDefVtime
@Title     Define the verification time

@Prototype void taxisDefVtime(int taxisID, int vtime)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}
    @Item  vtime    Verification time (hhmmss)

@Description
The function @func{taxisDefVtime} defines the verification time of a Time axis.

@EndFunction
*/
void taxisDefVtime(int taxisID, int vtime)
{
  static char func[] = "taxisDefVtime";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->vtime = vtime;
}


/*
@Function  taxisDefRdate
@Title     Define the reference date

@Prototype void taxisDefRdate(int taxisID, int rdate)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}
    @Item  rdate    Reference date (YYYYMMDD)

@Description
The function @func{taxisDefVdate} defines the reference date of a Time axis.

@EndFunction
*/
void taxisDefRdate(int taxisID, int rdate)
{
  static char func[] = "taxisDefRdate";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->rdate = rdate;
}


/*
@Function  taxisDefRtime
@Title     Define the reference time

@Prototype void taxisDefRtime(int taxisID, int rtime)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}
    @Item  rtime    Reference time (hhmmss)

@Description
The function @func{taxisDefVdate} defines the reference time of a Time axis.

@EndFunction
*/
void taxisDefRtime(int taxisID, int rtime)
{
  static char func[] = "taxisDefRtime";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->rtime = rtime;
}


/*
@Function  taxisDefCalendar
@Title     Define the calendar

@Prototype void taxisDefCalendar(int taxisID, int calendar)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}
    @Item  calendar The type of the calendar, one of the set of predefined CDI calendar types.
                    The valid CDI calendar types are @func{CALENDAR_STANDARD}, @func{CALENDAR_PROLEPTIC}, 
                    @func{CALENDAR_360DAYS}, @func{CALENDAR_365DAYS} and @func{CALENDAR_366DAYS}.

@Description
The function @func{taxisDefCalendar} defines the calendar of a Time axis.

@EndFunction
*/
void taxisDefCalendar(int taxisID, int calendar)
{
  static char func[] = "taxisDefCalendar";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->calendar = calendar;
}


void taxisDefTunit(int taxisID, int unit)
{
  static char func[] = "taxisDefTunit";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->unit = unit;
}

void taxisDefNumavg(int taxisID, int numavg)
{
  static char func[] = "taxisDefNumavg";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->numavg = numavg;
}


/*
The type of the time axis, one of the set of predefined CDI time types.
The valid CDI time types are TAXIS_ABSOLUTE and TAXIS_RELATIVE.
*/
int taxisInqType(int taxisID)
{
  static char func[] = "taxisInqType";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  return (taxisptr->type);
}


int taxisHasBounds(int taxisID)
{
  static char func[] = "taxisHasBounds";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  return (taxisptr->has_bounds);
}


void taxisDeleteBounds(int taxisID)
{
  static char func[] = "taxisDeleteBounds";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->has_bounds = FALSE;
}


void taxisCopyTimestep(int taxisID2, int taxisID1)
{
  static char func[] = "taxisCopyTimestep";
  taxis_t *taxisptr1;
  taxis_t *taxisptr2;

  taxisptr1 = taxis_to_pointer(taxisID1);
  taxisptr2 = taxis_to_pointer(taxisID2);

  taxis_check_ptr(func, taxisptr1);
  taxis_check_ptr(func, taxisptr2);

  taxisptr2->rdate = taxisptr1->rdate;
  taxisptr2->rtime = taxisptr1->rtime;

  taxisptr2->vdate = taxisptr1->vdate;
  taxisptr2->vtime = taxisptr1->vtime;

  if ( taxisptr2->has_bounds )
    {
      taxisptr2->vdate_lb = taxisptr1->vdate_lb;
      taxisptr2->vtime_lb = taxisptr1->vtime_lb;
      taxisptr2->vdate_ub = taxisptr1->vdate_ub;
      taxisptr2->vtime_ub = taxisptr1->vtime_ub;
    }
}


/*
@Function  taxisInqVdate
@Title     Get the verification date

@Prototype int taxisInqVdate(int taxisID)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}

@Description
The function @func{taxisInqVdate} returns the verification date of a Time axis.

@Result
@func{taxisInqVdate} returns the verification date.

@EndFunction
*/
int taxisInqVdate(int taxisID)
{
  static char func[] = "taxisInqVdate";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  return (taxisptr->vdate);
}


void taxisInqVdateBounds(int taxisID, int *vdate_lb, int *vdate_ub)
{
  static char func[] = "taxisInqVdateBounds";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  *vdate_lb = taxisptr->vdate_lb;
  *vdate_ub = taxisptr->vdate_ub;
}


void taxisDefVdateBounds(int taxisID, int vdate_lb, int vdate_ub)
{
  static char func[] = "taxisDefVdateBounds";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->vdate_lb = vdate_lb;
  taxisptr->vdate_ub = vdate_ub;
 
  taxisptr->has_bounds = TRUE;
}


/*
@Function  taxisInqVtime
@Title     Get the verification time

@Prototype int taxisInqVtime(int taxisID)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}

@Description
The function @func{taxisInqVtime} returns the verification time of a Time axis.

@Result
@func{taxisInqVtime} returns the verification time.

@EndFunction
*/
int taxisInqVtime(int taxisID)
{
  static char func[] = "taxisInqVtime";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  return (taxisptr->vtime);
}


void taxisInqVtimeBounds(int taxisID, int *vtime_lb, int *vtime_ub)
{
  static char func[] = "taxisInqVtimeBounds";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  *vtime_lb = taxisptr->vtime_lb;
  *vtime_ub = taxisptr->vtime_ub;
}


void taxisDefVtimeBounds(int taxisID, int vtime_lb, int vtime_ub)
{
  static char func[] = "taxisDefVtimeBounds";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  taxisptr->vtime_lb = vtime_lb;
  taxisptr->vtime_ub = vtime_ub;
 
  taxisptr->has_bounds = TRUE;
}


/*
@Function  taxisInqRdate
@Title     Get the reference date

@Prototype int taxisInqRdate(int taxisID)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}

@Description
The function @func{taxisInqRdate} returns the reference date of a Time axis.

@Result
@func{taxisInqVdate} returns the reference date.

@EndFunction
*/
int taxisInqRdate(int taxisID)
{
  static char func[] = "taxisInqRdate";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  if ( taxisptr->rdate == -1 )
    {
      taxisptr->rdate = taxisptr->vdate;
      taxisptr->rtime = taxisptr->vtime;
    }

  return (taxisptr->rdate);
}


/*
@Function  taxisInqRtime
@Title     Get the reference time

@Prototype int taxisInqRtime(int taxisID)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}

@Description
The function @func{taxisInqRtime} returns the reference time of a Time axis.

@Result
@func{taxisInqVtime} returns the reference time.

@EndFunction
*/
int taxisInqRtime(int taxisID)
{
  static char func[] = "taxisInqRtime";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  if ( taxisptr->rdate == -1 )
    {
      taxisptr->rdate = taxisptr->vdate;
      taxisptr->rtime = taxisptr->vtime;
    }

  return (taxisptr->rtime);
}


/*
@Function  taxisInqCalendar
@Title     Get the calendar

@Prototype int taxisInqCalendar(int taxisID)
@Parameter
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}

@Description
The function @func{taxisInqCalendar} returns the calendar of a Time axis.

@Result
@func{taxisInqCalendar} returns the type of the calendar,
one of the set of predefined CDI calendar types.
The valid CDI calendar types are @func{CALENDAR_STANDARD}, @func{CALENDAR_PROLEPRIC}, 
@func{CALENDAR_360DAYS}, @func{CALENDAR_365DAYS} and @func{CALENDAR_366DAYS}.

@EndFunction
*/
int taxisInqCalendar(int taxisID)
{
  static char func[] = "taxisInqCalendar";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  return (taxisptr->calendar);
}


int taxisInqTunit(int taxisID)
{
  static char func[] = "taxisInqTunit";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  return (taxisptr->unit);
}


int taxisInqNumavg(int taxisID)
{
  static char func[] = "taxisInqNumavg";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  return (taxisptr->numavg);
}


taxis_t *taxisPtr(int taxisID)
{
  static char func[] = "taxisPtr";
  taxis_t *taxisptr;

  taxisptr = taxis_to_pointer(taxisID);

  taxis_check_ptr(func, taxisptr);

  return (taxisptr);
}


void cdiDecodeTimevalue(int timeunit, double timevalue, int *days, int *secs)
{
  static char func[] = "cdiDecodeTimevalue";
  static int lwarn = TRUE;

  if ( timeunit == TUNIT_MINUTE )
    {
      timevalue *= 60;
      timeunit = TUNIT_SECOND;
    }
  else if ( timeunit == TUNIT_HOUR )
    {
      timevalue /= 24;
      timeunit = TUNIT_DAY;
    }

  if ( timeunit == TUNIT_SECOND )
    {
      *days = (int) (timevalue/86400);
      *secs = (int) (timevalue - *days*86400.);
      if ( *secs < 0 ) { *days -= 1; *secs += 86400; };
      /*
      {
	double cval = *days*86400. + *secs;
	if ( cval != timevalue )
	  printf("TUNIT_SECOND error: %g %g %d %d\n", timevalue, cval, *days, *secs);
      }
      */
    }
  else if ( timeunit == TUNIT_DAY )
    {
      *days = (int) timevalue;
      *secs = (int) ((timevalue - *days)*86400 + 0.5);
      if ( *secs < 0 ) { *days -= 1; *secs += 86400; };
      /*
      {
	double cval = *days + *secs/86400.;
	if ( cval != timevalue )
	  printf("TUNIT_DAY error: %g %g %d %d\n", timevalue, cval, *days, *secs);
      }
      */
    }
  else
    {
      if ( lwarn )
	{
	  Warning(func, "timeunit %s unsupported!", tunitNamePtr(timeunit));
	  lwarn = FALSE;
	}
    }
}

static
void cdiEncodeTimevalue(int days, int secs, int timeunit, double *timevalue)
{
  static char func[] = "cdiEncodeTimevalue";
  static int lwarn = TRUE;

  if ( timeunit == TUNIT_SECOND )
    {
      *timevalue = days*86400. + secs;
    }
  else if ( timeunit == TUNIT_MINUTE ||
	    timeunit == TUNIT_QUARTER )
    {
      *timevalue = days*1440. + secs/60.;
    }
  else if ( timeunit == TUNIT_HOUR   ||
	    timeunit == TUNIT_3HOURS ||
	    timeunit == TUNIT_6HOURS ||
	    timeunit == TUNIT_12HOURS )
    {
      *timevalue = days*24. + secs/3600.;
    }
  else if ( timeunit == TUNIT_DAY )
    {
      *timevalue = days + secs/86400.;
    }
  else
    {
      if ( lwarn )
	{
	  Warning(func, "timeunit %s unsupported!", tunitNamePtr(timeunit));
	  lwarn = FALSE;
	}
    }
}

int days_per_month(int calendar, int year, int month);

void timeval2vtime(double timevalue, taxis_t *taxis, int *vdate, int *vtime)
{
  static char func[] = "timeval2vtime";
  int year, month, day, hour, minute, second;
  int rdate, rtime;
  int timeunit;
  int calendar;
  int julday, secofday, days, secs;
  static int lwarn = TRUE;

  *vdate = 0;
  *vtime = 0;

  timeunit = (*taxis).unit;
  calendar = (*taxis).calendar;

  rdate  = (*taxis).rdate;
  rtime  = (*taxis).rtime;
  cdiDecodeDate(rdate, &year, &month, &day);
  cdiDecodeTime(rtime, &hour, &minute, &second);

  if ( timeunit == TUNIT_MONTH && calendar == CALENDAR_360DAYS )
    {
      timeunit = TUNIT_DAY;
      timevalue *= 30;
    }

  if ( timeunit == TUNIT_MONTH || timeunit == TUNIT_YEAR )
    {
      static int lold = FALSE;

      if ( timeunit == TUNIT_YEAR )
	{
	  timeunit = TUNIT_MONTH;
	  timevalue *= 12;
	}

      if ( lold )
	{
	  int nmon;

	  if ( (NINT(timevalue*10))%10 && lwarn )
	    {
	      Warning(func, "Possible wrong calculation of date/time!\n"
		      "Non integer time offset unsupported for time unit MONTH and YEAR!");
	      lwarn = FALSE;
	    }

	  nmon = (int) (timevalue+0.001);

	  month += nmon;
	  
	  while ( month > 12 ) { month -= 12; year++; }
	  while ( month <  1 ) { month += 12; year--; }
	}
      else
	{
	  int nmon, dpm;
	  double fmon;
	  
	  nmon = (int) timevalue;
	  fmon = timevalue - nmon;
	  
	  month += nmon;
	  
	  while ( month > 12 ) { month -= 12; year++; }
	  while ( month <  1 ) { month += 12; year--; }

	  dpm = days_per_month(calendar, year, month);
	  timeunit = TUNIT_DAY;
	  timevalue = fmon*dpm;
	}
    }

  if ( timeunit != TUNIT_MONTH && timeunit != TUNIT_YEAR )
    {
      encode_caldaysec(calendar, year, month, day, hour, minute, second, &julday, &secofday);

      cdiDecodeTimevalue(timeunit, timevalue, &days, &secs);

      julday_add(days, secs, &julday, &secofday);

      decode_caldaysec(calendar, julday, secofday, &year, &month, &day, &hour, &minute, &second);
    }

  *vdate = cdiEncodeDate(year, month, day);
  *vtime = cdiEncodeTime(hour, minute, second);
}


double vtime2timeval(int vdate, int vtime, taxis_t *taxis)
{
  int ryear, rmonth;
  int year, month, day, hour, minute, second;
  int rdate, rtime;
  double value = 0;
  int timeunit;
  int timeunit0;
  int calendar;
  int julday1, secofday1, julday2, secofday2, days, secs;

  timeunit = (*taxis).unit;
  calendar = (*taxis).calendar;

  rdate = (*taxis).rdate;
  rtime = (*taxis).rtime;
  if ( rdate == -1 )
    {
      rdate  = (*taxis).vdate;
      rtime  = (*taxis).vtime;
    }

  cdiDecodeDate(rdate, &ryear, &rmonth, &day);
  cdiDecodeTime(rtime, &hour, &minute, &second);

  encode_caldaysec(calendar, ryear, rmonth, day, hour, minute, second, &julday1, &secofday1);

  cdiDecodeDate(vdate, &year, &month, &day);
  cdiDecodeTime(vtime, &hour, &minute, &second);

  timeunit0 = timeunit;

  if ( timeunit == TUNIT_MONTH && calendar == CALENDAR_360DAYS )
    {
      timeunit = TUNIT_DAY;
    }

  if ( timeunit == TUNIT_MONTH || timeunit == TUNIT_YEAR )
    {
      int nmonth, dpm;

      dpm = days_per_month(calendar, year, month);

      value = (year-ryear)*12 - rmonth + month;

      nmonth = (int) value;
      month -= nmonth;

      while ( month > 12 ) { month -= 12; year++; }
      while ( month <  1 ) { month += 12; year--; }

      encode_caldaysec(calendar, year, month, day, hour, minute, second, &julday2, &secofday2);

      julday_sub(julday1, secofday1, julday2, secofday2, &days, &secs);

      value += (days+secs/86400.)/dpm;

      if ( timeunit == TUNIT_YEAR ) value = NINT(value/12);
    }
  else
    {
      encode_caldaysec(calendar, year, month, day, hour, minute, second, &julday2, &secofday2);

      julday_sub(julday1, secofday1, julday2, secofday2, &days, &secs);

      cdiEncodeTimevalue(days, secs, timeunit, &value);
    }

  if ( timeunit0 == TUNIT_MONTH && calendar == CALENDAR_360DAYS )
    {
      value /= 30;
    }

  return (value);
}


void conv_timeval(double timevalue, int *rvdate, int *rvtime)
{
  int vdate = 0, vtime = 0;
  int hour, minute, second;
  int daysec;

  vdate = (int) timevalue;
  if ( vdate < 0 )
    daysec = (int) (-(timevalue - vdate)*86400 + 0.01);
  else
    daysec = (int) ( (timevalue - vdate)*86400 + 0.01);
  
  hour   =  daysec / 3600;
  minute = (daysec - hour*3600)/60;
  second =  daysec - hour*3600 - minute*60;
  vtime  = cdiEncodeTime(hour, minute, second);

  *rvdate = vdate;
  *rvtime = vtime;
}


void splitTimevalue(double timevalue, int timeunit, int *date, int *time)
{
  static char func[] = "splitTimevalue";
  int vdate = 0, vtime = 0;
  int hour, minute, second;
  int year, month, day;
  int daysec;
  static int lwarn = TRUE;

  if ( timeunit == TUNIT_SECOND )
    {
      timevalue /= 86400;
      conv_timeval(timevalue, &vdate, &vtime);
    }
  else if ( timeunit == TUNIT_HOUR )
    {
      timevalue /= 24;
      conv_timeval(timevalue, &vdate, &vtime);
    }
  else if ( timeunit == TUNIT_DAY )
    {
      conv_timeval(timevalue, &vdate, &vtime);
    }
  else if ( timeunit == TUNIT_MONTH )
    {
      vdate = (int) timevalue*100;
      vtime = 0;
    }
  else if ( timeunit == TUNIT_YEAR )
    {
      if ( timevalue < -214700 )
	{
	  Warning(func, "Year %g out of range, set to -214700", timevalue);
	  timevalue = -214700;
	}
      else if ( timevalue > 214700 )
	{
	  Warning(func, "Year %g out of range, set to 214700", timevalue);
	  timevalue = 214700;
	}

      vdate = (int) timevalue*10000;
      vtime = 0;
    }
  else
    {
      if ( lwarn )
	{
	  Warning(func, "timeunit %s unsupported!", tunitNamePtr(timeunit));
	  lwarn = FALSE;
	}
    }

  /* verify date and time */

  cdiDecodeDate(vdate, &year, &month, &day);
  cdiDecodeTime(vtime, &hour, &minute, &second);

  if ( month > 17 || day > 31 || hour > 23 || minute > 59 || second > 59 )
    {
      if ( (month  > 17 || day > 31) && (year < -9999 || year > 9999) ) year = 1;
      if ( month  > 17 ) month  = 1;
      if ( day    > 31 ) day    = 1;
      if ( hour   > 23 ) hour   = 0;
      if ( minute > 59 ) minute = 0;
      if ( second > 59 ) second = 0;

      vdate = cdiEncodeDate(year, month, day);
      vtime = cdiEncodeTime(hour, minute, second);

      Warning(func, "Reset wrong date/time to %4.4d-%2.2d-%2.2d %2.2d:%2.2d:%2.2d!",
	      year, month, day, hour, minute, second);
    }

  *date = vdate;
  *time = vtime;
}


void cdiDecodeTimeval(double timevalue, taxis_t *taxis, int *date, int *time)
{
  if ( taxis->type == TAXIS_ABSOLUTE )
    splitTimevalue(timevalue, taxis->unit, date, time);
  else
    timeval2vtime(timevalue, taxis, date, time);
}


double cdiEncodeTimeval(int date, int time, taxis_t *taxis)
{
  double timevalue;

  if ( taxis->type == TAXIS_ABSOLUTE )
    {
      if ( taxis->unit == TUNIT_YEAR )
	{
	  int year, month, day;
	  cdiDecodeDate(date, &year, &month, &day);

	  timevalue = year;
	}
      else if ( taxis->unit == TUNIT_MONTH )
	{
	  int year, month, day;
	  cdiDecodeDate(date, &year, &month, &day);
	  if ( day == 0 )
	    timevalue = date/100;
	  else
	    timevalue = date/100 + 0.5;
	}
      else
	{
	  int hour, minute, second;
	  cdiDecodeTime(time, &hour, &minute, &second);
	  if ( date < 0 )
	    timevalue = -(-date + (hour*3600 + minute*60 + second)/86400.);
	  else
	    timevalue =    date + (hour*3600 + minute*60 + second)/86400.;
	}
    }
  else
    timevalue = vtime2timeval(date, time, taxis);

  return (timevalue);
}


void ptaxisInit(taxis_t *taxisptr)
{
  taxis_init_ptr(taxisptr);
}


void ptaxisCopy(taxis_t *dest, taxis_t *source)
{
  /* memcpy(dest, source, sizeof(taxis_t)); */
  dest->used       = source->used;  
  dest->type       = source->type;
  dest->vdate      = source->vdate;
  dest->vtime      = source->vtime;
  dest->rdate      = source->rdate;
  dest->rtime      = source->rtime;
  dest->calendar   = source->calendar;
  dest->unit       = source->unit;
  dest->numavg     = source->numavg;
  dest->has_bounds = source->has_bounds;
  dest->vdate_lb   = source->vdate_lb;
  dest->vtime_lb   = source->vtime_lb;
  dest->vdate_ub   = source->vdate_ub;
  dest->vtime_ub   = source->vtime_ub;
}
#if defined (HAVE_CONFIG_H)
#endif



int _ExitOnError   = 1;	/* If set to 1, exit on error       */
int _Verbose = 1;	/* If set to 1, errors are reported */
int _Debug   = 0;       /* If set to 1, debugging           */


void SysError(const char *caller, const char *fmt, ...)
{
  va_list args;
	
  va_start(args, fmt);

  printf("\n");
   fprintf(stderr, "Error (%s) : ", caller);
  vfprintf(stderr, fmt, args);
   fprintf(stderr, "\n");

  va_end(args);

  if ( errno )
    perror("System error message ");
	
  exit(EXIT_FAILURE);
}

void Error(const char *caller, const char *fmt, ...)
{
  va_list args;
	
  va_start(args, fmt);

  printf("\n");
   fprintf(stderr, "Error (%s) : ", caller);
  vfprintf(stderr, fmt, args);
   fprintf(stderr, "\n");

  va_end(args);

  if ( _ExitOnError ) exit(EXIT_FAILURE);
}

void Warning(const char *caller, const char *fmt, ...)
{
  va_list args;
	
  va_start(args, fmt);

  if ( _Verbose )
    {
       fprintf(stderr, "Warning (%s) : ", caller);
      vfprintf(stderr, fmt, args);
       fprintf(stderr, "\n");
    }

  va_end(args);
}

void Message(const char *caller, const char *fmt, ...)
{
  va_list args;
	
  va_start(args, fmt);

   fprintf(stdout, "%-18s : ", caller);
  vfprintf(stdout, fmt, args);
   fprintf(stdout, "\n");

  va_end(args);
}



/* convert Julian date into year, months, day */
void decode_julday(int calendar,
		   int julday,	/* Julian day number to convert */
		   int *year,	/* Gregorian year (out)         */
		   int *mon,	/* Gregorian month (1-12) (out) */
		   int *day)	/* Gregorian day (1-31) (out)   */
{
  int a = julday;
  double b, c;
  double d, e, f;

  b = floor((a - 1867216.25)/36524.25);
  c = a + b - floor(b/4) + 1525;

  if ( calendar == CALENDAR_STANDARD )
    if ( a < 2299161 )
      {
	c = a + 1524;
      } 

  d = floor((c - 122.1)/365.25);
  e = floor(365.25*d);
  f = floor((c - e)/30.6001);

  *day  = (int)(c - e - floor(30.6001*f));
  *mon  = (int)(f - 1 - 12*floor(f/14));
  *year = (int)(d - 4715 - floor((7 + *mon)/10));
}


/* convert year, month, day into Julian calendar day */
int encode_julday(int calendar, int year, int month, int day)
{
  int iy;
  int im;
  int ib;
  int julday;

  if ( month <= 2 )
    {
      iy = year  - 1;
      im = month + 12;
    }
  else
    {
      iy = year;
      im = month;
    }


  if ( iy < 0 )
    ib = (int)((iy+1)/400) - (int)((iy+1)/100);
  else
    ib = (int)(iy/400) - (int)(iy/100);

  if ( calendar == CALENDAR_STANDARD )
    {
      if ( year > 1582 || (year == 1582 && (month > 10 || (month == 10 && day >= 15))) )
	{
	  /*
	  ** 15th October 1582 AD or later
	  */
	}
      else
	{
	  /*
	  ** 4th October 1582 AD or earlier
	  */
	  ib = -2;
	}
    }

  julday = (int) (floor(365.25*iy) + (int)(30.6001*(im+1)) + ib + 1720996.5 + day + 0.5);

  return (julday);
}


int date_to_julday(int calendar, int date)
{
  int julday;
  int year, month, day;

  cdiDecodeDate(date, &year, &month, &day);

  julday = encode_julday(calendar, year, month, day);

  return (julday);
}


int julday_to_date(int calendar, int julday)
{
  int date;
  int year, month, day;

  decode_julday(calendar, julday, &year, &month, &day);

  date = cdiEncodeDate(year, month, day);

  return (date);
}


int time_to_sec(int time)
{
  int secofday;
  int hour, minute, second;

  cdiDecodeTime(time, &hour, &minute, &second);

  secofday = hour*3600 + minute*60 + second;

  return (secofday);
}


int sec_to_time(int secofday)
{
  int time;
  int hour, minute, second;

  hour   = secofday/3600;
  minute = secofday/60 - hour*60;
  second = secofday - hour*3600 - minute*60;

  time = cdiEncodeTime(hour, minute, second);

  return (time);
}

static
void adjust_seconds(int *julday, int *secofday)
{
  int secperday = 86400;

  while ( *secofday >= secperday ) 
    { 
      *secofday -= secperday; 
      (*julday)++;
    }

  while ( *secofday <  0 ) 
    { 
      *secofday += secperday;
      (*julday)--;
    }
}


void julday_add_seconds(int seconds, int *julday, int *secofday)
{
  *secofday += seconds;

  adjust_seconds(julday, secofday);
}

/* add days and secs to julday/secofday */
void julday_add(int days, int secs, int *julday, int *secofday)
{
  *julday   += days;
  *secofday += secs;

  adjust_seconds(julday, secofday);
}

/* subtract julday1/secofday1 from julday2/secofday2 and returns the result in seconds */
double julday_sub(int julday1, int secofday1, int julday2, int secofday2, int *days, int *secs)
{
  int seconds;

  *days = julday2 - julday1;
  *secs = secofday2 - secofday1;

  adjust_seconds(days, secs);

  seconds = *days*86400. + *secs;

  return (seconds);
}


void encode_juldaysec(int calendar, int year, int month, int day, int hour, int minute, int *julday, int *secofday)
{
  *julday = encode_julday(calendar, year, month, day);

  *secofday = (hour*60 + minute)*60;
}


void decode_juldaysec(int calendar, int julday, int secofday, int *year, int *month, int *day, int *hour, int *minute)
{
  decode_julday(calendar, julday, year, month, day);

  *hour   = secofday/3600;
  *minute = secofday/60 - *hour*60;
}


#ifdef TEST
int main(void)
{
  int nmin;
  int vdate0, vtime0;
  int vdate, vtime;
  int ijulinc;
  int i, j = 0;
  int year, mon, day, hour, minute, second;
  int julday, secofday;

  /* 1 - Check valid range of years */

  nmin = 11000;
  vdate0 = -80001201;
  vtime0 = 120500;

  printf("start time: %8d %4d\n", vdate0, vtime0);

  for ( i = 0; i < nmin; i++ )
    {
      cdiDecodeDate(vdate0, &year, &mon, &day);
      cdiDecodeTime(vtime0, &hour, &minute, &second);

      julday  = date_to_julday(calendar, vdate0);
      secofday = time_to_sec(vtime0);

      vdate = julday_to_date(calendar, julday);
      vtime = sec_to_time(secofday);

      if ( vdate0 != vdate || vtime0 != vtime )
	printf("%4d %8d %4d %8d %4d %9d %9d\n",
	       ++j, vdate0, vtime0, vdate, vtime, julday, secofday);

      year++;
      vdate0 = cdiEncodeDate(year, mon, day);
      vtime0 = cdiEncodeTime(hour, minute, second);
    }

  printf("stop time: %8d %4d\n", vdate0, vtime0);

  /* 2 - Check time increment of one minute */

  nmin = 120000;
  ijulinc = 60;
  vdate0 = 20001201;
  vtime0 = 0;

  printf("start time: %8d %4d\n", vdate0, vtime0);

  julday = date_to_julday(calendar, vdate0);
  secofday = time_to_sec(vtime0);
  for ( i = 0; i < nmin; i++ )
    {
      cdiDecodeDate(vdate0, &year, &mon, &day);
      cdiDecodeTime(vtime0, &hour, &minute, &second);

      if ( ++minute >= 60 )
	{
	  minute = 0;
	  if ( ++hour >= 24 )
	    {
	      hour = 0;
	      if ( ++day >= 32 )
		{
		  day = 1;
		  if ( ++mon >= 13 )
		    {
		      mon = 1;
		      year++;
		    }
		}
	    }
	}

      vdate0 = cdiEncodeDate(year, mon, day);
      vtime0 = cdiEncodeTime(hour, minute, second);

      julday_add_seconds(ijulinc, &julday, &secofday);

      vdate = julday_to_date(calendar, julday);
      vtime = sec_to_time(secofday);
      if ( vdate0 != vdate || vtime0 != vtime )
	printf("%4d %8d %4d %8d %4d %9d %9d\n",
	       ++j, vdate0, vtime0, vdate, vtime, julday, secofday);
    }

  printf("stop time: %8d %4d\n", vdate0, vtime0);

  return (0);
}
#endif


#ifdef TEST2
int main(void)
{
  int i;
  int julday, secofday;
  int year, month, day, hour, minute;
  int value = 30;
  int factor = 86400;

  year=1979; month=1; day=15; hour=12; minute=30;

  printf("%d/%02d/%02d %02d:%02d\n", year, month, day, hour, minute);

  encode_juldaysec(calendar, year, month, day, hour, minute, &julday, &secofday);

  decode_juldaysec(calendar, julday, secofday, &year, &month, &day, &hour, &minute);
  printf("%d/%02d/%02d %02d:%02d   %d %d\n", year, month, day, hour, minute, julday, secofday);

  for ( i = 0; i < 420; i++ )
    {

      decode_juldaysec(calendar, julday, secofday, &year, &month, &day, &hour, &minute);
      printf("%2d %d/%02d/%02d %02d:%02d\n", i, year, month, day, hour, minute);
      julday_add_seconds(value*factor, &julday, &secofday);
    }

  return (0);
}
#endif



static int month_360[12] = {30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30};
static int month_365[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
static int month_366[12] = {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};


int calendar_dpy(int calendar)
{
  int dpy = 0;

  if      ( calendar == CALENDAR_360DAYS ) dpy = 360;
  else if ( calendar == CALENDAR_365DAYS ) dpy = 365;
  else if ( calendar == CALENDAR_366DAYS ) dpy = 366;

  return (dpy);
}


int days_per_month(int calendar, int year, int month)
{
  int dayspermonth = 0;
  int *dpm = NULL;
  int dpy;

  dpy = calendar_dpy(calendar);

  if      ( dpy == 360 ) dpm = month_360;
  else if ( dpy == 365 ) dpm = month_365;
  else                   dpm = month_366;

  if ( month >= 1 && month <= 12 )
    dayspermonth = dpm[month-1];
  else
    fprintf(stderr, "days_per_month: month %d out of range\n", month);

  if ( dpy == 0 && month == 2 )
    {
      if ( (year%4 == 0 && year%100 != 0) || year%400 == 0 )
	dayspermonth = 29;
      else
	dayspermonth = 28;
    }

  return (dayspermonth);
}


int days_per_year(int calendar, int year)
{
  int daysperyear;
  int dpy;

  dpy = calendar_dpy(calendar);

  if ( dpy == 0 )
    {
      if ( calendar == CALENDAR_STANDARD )
	{
	  if ( year == 1582 )
	    dpy = 355;
	  else if ( (year%4 == 0 && year%100 != 0) || year%400 == 0 )
	    dpy = 366;
	  else
	    dpy = 365;
	}
      else
	{
	  if ( (year%4 == 0 && year%100 != 0) || year%400 == 0 )
	    dpy = 366;
	  else
	    dpy = 365;
	}
    }

  daysperyear = dpy;
  
  return (daysperyear);
}


static void decode_day(int dpy, int days, int *year, int *month, int *day)
{
  int i = 0;
  int *dpm = NULL;

  *year = (days-1) / dpy;
  days -= (*year*dpy);

  if      ( dpy == 360 ) dpm = month_360;
  else if ( dpy == 365 ) dpm = month_365;
  else if ( dpy == 366 ) dpm = month_366;

  if ( dpm )
    for ( i = 0; i < 12; i++ )
      {
	if ( days > dpm[i] ) days -= dpm[i];
	else break;
      }

  *month = i + 1;
  *day   = days;
}


static int encode_day(int dpy, int year, int month, int day)
{
  int i;
  int *dpm = NULL;
  double rval;

  rval = dpy * year + day;

  if      ( dpy == 360 ) dpm = month_360;
  else if ( dpy == 365 ) dpm = month_365;
  else if ( dpy == 366 ) dpm = month_366;
  
  if ( dpm ) for ( i = 0; i < month-1; i++ ) rval += dpm[i];

  return (rval);
}


int date_to_calday(int calendar, int date)
{
  int calday;
  int dpy;
  int year, month, day;

  dpy = calendar_dpy(calendar);

  cdiDecodeDate(date, &year, &month, &day);

  if ( dpy == 360 || dpy == 365 || dpy == 366 )
    calday = encode_day(dpy, year, month, day);
  else
    calday = encode_julday(calendar, year, month, day);

  return (calday);
}


int calday_to_date(int calendar, int calday)
{
  int date;
  int dpy;
  int year, month, day;

  dpy = calendar_dpy(calendar);

  if ( dpy == 360 || dpy == 365 || dpy == 366 )
    decode_day(dpy, calday, &year, &month, &day);
  else
    decode_julday(calendar, calday, &year, &month, &day);

  date = cdiEncodeDate(year, month, day);

  return (date);
}


void encode_caldaysec(int calendar, int year, int month, int day, int hour, int minute, int second,
		      int *julday, int *secofday)
{
  int dpy;

  dpy = calendar_dpy(calendar);

  if ( dpy == 360 || dpy == 365 || dpy == 366 )
    *julday = encode_day(dpy, year, month, day);
  else
    *julday = encode_julday(calendar, year, month, day);

  *secofday = hour*3600 + minute*60 + second;
}


void decode_caldaysec(int calendar, int julday, int secofday, 
		      int *year, int *month, int *day, int *hour, int *minute, int *second)
{
  int dpy;

  dpy = calendar_dpy(calendar);

  if ( dpy == 360 || dpy == 365 || dpy == 366 )
    decode_day(dpy, julday, year, month, day);
  else
    decode_julday(calendar, julday, year, month, day);

  *hour   = secofday/3600;
  *minute = secofday/60 - *hour*60;
  *second = secofday - *hour*3600 - *minute*60;
}


#ifdef TEST
int main(void)
{
  int calendar = CALENDAR_STANDARD;
  int nmin;
  int vdate0, vtime0;
  int vdate, vtime;
  int ijulinc;
  int i, j = 0;
  int year, mon, day, hour, minute, second;
  int calday, secofday;

  /* 1 - Check valid range of years */

  nmin = 11000;
  vdate0 = -80001201;
  vtime0 = 120500;

  printf("start time: %8d %4d\n", vdate0, vtime0);

  for ( i = 0; i < nmin; i++ )
    {
      cdiDecodeDate(vdate0, &year, &mon, &day);
      cdiDecodeTime(vtime0, &hour, &minute, &second);

      calday  = date_to_calday(calendar, vdate0);
      secofday = time_to_sec(vtime0);

      vdate = calday_to_date(calendar, calday);
      vtime = sec_to_time(secofday);

      if ( vdate0 != vdate || vtime0 != vtime )
	printf("%4d %8d %4d %8d %4d %9d %9d\n",
	       ++j, vdate0, vtime0, vdate, vtime, calday, secofday);

      year++;
      vdate0 = cdiEncodeDate(year, mon, day);
      vtime0 = cdiEncodeTime(hour, minute, second);
    }

  printf("stop time: %8d %4d\n", vdate0, vtime0);

  /* 2 - Check time increment of one minute */

  nmin = 120000;
  ijulinc = 60;
  vdate0 = 20001201;
  vtime0 = 0;

  printf("start time: %8d %4d\n", vdate0, vtime0);

  calday = date_to_calday(calendar, vdate0);
  secofday = time_to_sec(vtime0);
  for ( i = 0; i < nmin; i++ )
    {
      cdiDecodeDate(vdate0, &year, &mon, &day);
      cdiDecodeTime(vtime0, &hour, &minute, &second);

      if ( ++minute >= 60 )
	{
	  minute = 0;
	  if ( ++hour >= 24 )
	    {
	      hour = 0;
	      if ( ++day >= 32 )
		{
		  day = 1;
		  if ( ++mon >= 13 )
		    {
		      mon = 1;
		      year++;
		    }
		}
	    }
	}

      vdate0 = cdiEncodeDate(year, mon, day);
      vtime0 = cdiEncodeTime(hour, minute, second);

      julday_add_seconds(ijulinc, &calday, &secofday);

      vdate = calday_to_date(calendar, calday);
      vtime = sec_to_time(secofday);
      if ( vdate0 != vdate || vtime0 != vtime )
	printf("%4d %8d %4d %8d %4d %9d %9d\n",
	       ++j, vdate0, vtime0, vdate, vtime, calday, secofday);
    }

  printf("stop time: %8d %4d\n", vdate0, vtime0);

  return (0);
}
#endif


#ifdef TEST2
int main(void)
{
  int calendar = CALENDAR_STANDARD;
  int i;
  int calday, secofday;
  int year, month, day, hour, minute, second;
  int value = 30;
  int factor = 86400;
  
  calendar = CALENDAR_360DAYS;

  year=1979; month=1; day=15; hour=12; minute=30; second = 0;

  printf("calendar = %d\n", calendar);
  printf("%d/%02d/%02d %02d:%02d:%02d\n", year, month, day, hour, minute, second);

  encode_caldaysec(calendar, year, month, day, hour, minute, second, &calday, &secofday);

  decode_caldaysec(calendar, calday, secofday, &year, &month, &day, &hour, &minute, &second);
  printf("%d/%02d/%02d %02d:%02d:%02d   %d %d\n", year, month, day, hour, minute, second, calday, secofday);

  for ( i = 0; i < 420; i++ )
    {

      decode_caldaysec(calendar, calday, secofday, &year, &month, &day, &hour, &minute, &second);
      printf("%2d %d/%02d/%02d %02d:%02d:%02d\n", i, year, month, day, hour, minute, second);
      julday_add_seconds(value*factor, &calday, &secofday);
    }

  return (0);
}
#endif
#if defined (HAVE_CONFIG_H)
#endif


#undef  UNDEFID
#define UNDEFID -1

int ECHAM4 = UNDEFID;
int ECHAM5 = UNDEFID;
int COSMO  = UNDEFID;

typedef struct
{
  int      self;
  int      used;  
  int      instID;  
  int      modelgribID;
  char    *name;
}
MODEL;



static int  MODEL_Debug = 0;   /* If set to 1, debugging */

static int _model_max = MAX_MODELS;

static void model_initialize(void);

static int _model_init = FALSE;

#if  defined  (HAVE_LIBPTHREAD)

static pthread_once_t _model_init_thread = PTHREAD_ONCE_INIT;
static pthread_mutex_t _model_mutex;

#  define MODEL_LOCK           pthread_mutex_lock(&_model_mutex);
#  define MODEL_UNLOCK         pthread_mutex_unlock(&_model_mutex);
#  define MODEL_INIT                               \
   if ( _model_init == FALSE ) pthread_once(&_model_init_thread, model_initialize);

#else

#  define MODEL_LOCK
#  define MODEL_UNLOCK
#  define MODEL_INIT                               \
   if ( _model_init == FALSE ) model_initialize();

#endif


typedef struct _modelPtrToIdx {
  int idx;
  MODEL *ptr;
  struct _modelPtrToIdx *next;
} modelPtrToIdx;


static modelPtrToIdx *_modelList  = NULL;
static modelPtrToIdx *_modelAvail = NULL;


static void model_list_new(void)
{
  static char func[] = "model_list_new";

  assert(_modelList == NULL);

  _modelList = (modelPtrToIdx *) malloc(_model_max*sizeof(modelPtrToIdx));
}


static void model_list_delete(void)
{
  static char func[] = "model_list_delete";

  if ( _modelList ) free(_modelList);
}


static void model_init_pointer(void)
{
  int  i;
  
  for ( i = 0; i < _model_max; i++ )
    {
      _modelList[i].next = _modelList + i + 1;
      _modelList[i].idx  = i;
      _modelList[i].ptr  = 0;
    }

  _modelList[_model_max-1].next = 0;

  _modelAvail = _modelList;
}


MODEL *model_to_pointer(int idx)
{
  static char func[] = "model_to_pointer";
  MODEL *modelptr = NULL;

  MODEL_INIT

  if ( idx >= 0 && idx < _model_max )
    {
      MODEL_LOCK

      modelptr = _modelList[idx].ptr;

      MODEL_UNLOCK
    }
  else
    Error(func, "model index %d undefined!", idx);

  return (modelptr);
}


/* Create an index from a pointer */
static int model_from_pointer(MODEL *ptr)
{
  static char func[] = "model_from_pointer";
  int      idx = -1;
  modelPtrToIdx *newptr;

  if ( ptr )
    {
      MODEL_LOCK

      if ( _modelAvail )
	{
	  newptr       = _modelAvail;
	  _modelAvail  = _modelAvail->next;
	  newptr->next = 0;
	  idx	       = newptr->idx;
	  newptr->ptr  = ptr;
      
	  if ( MODEL_Debug )
	    Message(func, "Pointer %p has idx %d from model list", ptr, idx);
	}
      else
	Warning(func, "Too many open models (limit is %d)!", _model_max);

      MODEL_UNLOCK
    }
  else
    Error(func, "Internal problem (pointer %p undefined)", ptr);

  return (idx);
}


static void model_init_entry(MODEL *modelptr)
{
  modelptr->self        = model_from_pointer(modelptr);

  modelptr->used        = 1;

  modelptr->instID      = UNDEFID;
  modelptr->modelgribID = UNDEFID;
  modelptr->name        = NULL;
}


static MODEL *model_new_entry(void)
{
  static char func[] = "model_new_entry";
  MODEL *modelptr;

  modelptr = (MODEL *) malloc(sizeof(MODEL));

  if ( modelptr ) model_init_entry(modelptr);

  return (modelptr);
}


static void model_delete_entry(MODEL *modelptr)
{
  static char func[] = "model_delete_entry";
  int idx;

  idx = modelptr->self;

  MODEL_LOCK

  free(modelptr);

  _modelList[idx].next = _modelAvail;
  _modelList[idx].ptr  = 0;
  _modelAvail          = &_modelList[idx];

  MODEL_UNLOCK

  if ( MODEL_Debug )
    Message(func, "Removed idx %d from model list", idx);
}

int modelDef(int instID, int modelgribID, const char *name);

static void model_defaults(void)
{
  int instID;

  instID  = institutInq(  0,   0, "ECMWF", NULL);
  /* (void)    modelDef(instID, 131, "ERA15"); */
  /* (void)    modelDef(instID, 199, "ERA40"); */

  instID  = institutInq(  0,   0, "MPIMET", NULL);
  ECHAM5  = modelDef(instID,  64, "ECHAM5.4");
  (void)    modelDef(instID,  63, "ECHAM5.3");
  (void)    modelDef(instID,  62, "ECHAM5.2");
  (void)    modelDef(instID,  61, "ECHAM5.1");

  instID  = institutInq( 98, 255, "MPIMET", NULL);
  (void)    modelDef(instID,  60, "ECHAM5.0");
  ECHAM4  = modelDef(instID,  50, "ECHAM4");
  (void)    modelDef(instID, 110, "MPIOM1");

  instID  = institutInq(  0,   0, "DWD", NULL);
  (void)    modelDef(instID, 149, "GME");

  instID  = institutInq(  0,   0, "MCH", NULL);
  //(void)  = modelDef(instID, 137, "COSMO");
  COSMO   = modelDef(instID, 255, "COSMO");

  instID  = institutInq(  0,   1, "NCEP", NULL);
  (void)    modelDef(instID,  80, "T62L28MRF");
}


static void model_initialize(void)
{
  char *env;

#if  defined  (HAVE_LIBPTHREAD)
  /* initialize global API mutex lock */
  pthread_mutex_init(&_model_mutex, NULL);
#endif

  env = getenv("MODEL_DEBUG");
  if ( env ) MODEL_Debug = atoi(env);

  model_list_new();
  atexit(model_list_delete);

  MODEL_LOCK

  model_init_pointer();

  MODEL_UNLOCK

  _model_init = TRUE;

  model_defaults();
}


static void model_check_ptr(const char *func, MODEL *modelptr)
{
  if ( modelptr == NULL )
    Error(func, "model undefined!");
}


int modelSize(void)
{
  int modelsize = 0;
  int i;
  
  MODEL_INIT

  MODEL_LOCK

  for ( i = 0; i < _model_max; i++ )
    if ( _modelList[i].ptr ) modelsize++;

  MODEL_UNLOCK

  return (modelsize);
}


int modelInq(int instID, int modelgribID, char *name)
{
  int modelID = UNDEFID;
  size_t len;
  int found;
  int model_size;
  MODEL *modelptr;

  MODEL_INIT

  model_size = modelSize();

  for( modelID = 0; modelID < model_size; modelID++ )
    {
      modelptr = model_to_pointer(modelID);

      if ( modelptr->used )
	{
	  if ( name )
	    {
	      found = 1;
	      if ( instID      != -1 && modelptr->instID      != instID )      found = 0;
	      if ( modelgribID !=  0 && modelptr->modelgribID != modelgribID ) found = 0;

	      if ( found )
		{
		  if ( modelptr->name )
		    {
		      len = strlen(modelptr->name);
		      if ( memcmp(modelptr->name, name, len) == 0 ) break;
		      len = strlen(name);
		      if ( memcmp(modelptr->name, name, len) == 0 ) break;
		    }
		}
	    }
	  else
	    {
	      if ( modelptr->instID      == instID &&
		   modelptr->modelgribID == modelgribID ) break;
	    }
	}
    }

  if ( modelID == model_size ) modelID = UNDEFID;

  return (modelID);
}


int modelDef(int instID, int modelgribID, const char *name)
{
  static char func[] = "modelDef";
  int modelID = UNDEFID;
  MODEL *modelptr;

  MODEL_INIT

  /*
  modelID = modelInq(instID, modelgribID, name);
  */
  if ( modelID == UNDEFID )
    {
      modelptr = model_new_entry();
      if ( ! modelptr ) Error(func, "No memory");

      modelID = modelptr->self;

      modelptr->instID      = instID;
      modelptr->modelgribID = modelgribID;

      if ( name ) modelptr->name = strdupx(name);
    }

  return (modelID);
}


int modelInqInstitut(int modelID)
{
  static char func[] = "modelInqInstitut";
  int instID = UNDEFID;
  MODEL *modelptr;

  MODEL_INIT

  if ( modelID != UNDEFID )
    {
      modelptr = model_to_pointer(modelID);

      model_check_ptr(func, modelptr);
  
      instID = modelptr->instID;
    }

  return (instID);
}


int modelInqGribID(int modelID)
{
  static char func[] = "modelInqGribID";
  int modelgribID = UNDEFID;
  MODEL *modelptr;

  MODEL_INIT

  if ( modelID != UNDEFID )
    {
      modelptr = model_to_pointer(modelID);

      model_check_ptr(func, modelptr);
  
      modelgribID = modelptr->modelgribID;
    }

  return (modelgribID);
}


char *modelInqNamePtr(int modelID)
{
  static char func[] = "modelInqNamePtr";
  char *name = NULL;
  MODEL *modelptr;

  MODEL_INIT

  if ( modelID != UNDEFID )
    {
      modelptr = model_to_pointer(modelID);

      model_check_ptr(func, modelptr);
  
      if ( modelptr->name )
	name = modelptr->name;
    }

  return (name);
}
#if defined (HAVE_CONFIG_H)
#endif


#undef  UNDEFID
#define UNDEFID  -1

int ECMWF  = UNDEFID;
int MPIMET = UNDEFID;
int MCH    = UNDEFID;

typedef struct
{
  int    used;  
  int    center;  
  int    subcenter;
  char  *name;
  char  *longname;
}
Institut;

Institut *instituts;

static int institutsSize = 0;
static int institutsNum  = 0;
static int InstitutsInit = 0;


void institutsDefault(void);
void institutsInit(void);


void institutsInitEntry(int instID)
{
  static char func[] = "institutsInitEntry";

  if ( instID < 0 || instID >= institutsSize )
    Error(func, "instID %d undefined!", instID);

  instituts[instID].used       = 0;
  instituts[instID].center     = UNDEFID;
  instituts[instID].subcenter  = UNDEFID;
  instituts[instID].name       = NULL;
  instituts[instID].longname   = NULL;
}


int institutsNewEntry(void)
{
  static char func[] = "institutsNewEntry";
  int instID = 0;

  /*
    Look for a free slot in instituts.
    (Create the table the first time through).
  */
  if ( !institutsSize )
    {
      int i;

      institutsSize = 32;
      instituts = (Institut *) malloc(institutsSize*sizeof(Institut));
      if( instituts == NULL )
	{
          Message(func, "institutsSize = %d", institutsSize);
	  SysError(func, "Allocation of Institut failed");
	}

      for( i = 0; i < institutsSize; i++ )
	institutsInitEntry(i);
    }
  else
    {
      while( instID < institutsSize )
	{
	  if ( instituts[instID].used == 0 ) break;
	  instID++;
	}
    }
  /*
    If the table overflows, double its size.
  */
  if ( instID == institutsSize )
    {
      int i;

      institutsSize = 2*institutsSize;
      instituts = (Institut *) realloc(instituts, institutsSize*sizeof(Institut));
      if( instituts == NULL )
	{
          Message(func, "institutsSize = %d", institutsSize);
	  SysError(func, "Reallocation of Institut failed");
	}

      for( i = instID; i < institutsSize; i++ )
	institutsInitEntry(i);
    }

  instituts[instID].used = 1;
  institutsNum++;

  return (instID);
}


void institutsInit(void)
{
  InstitutsInit = 1;

  institutsDefault();
}


int institutInq(int center, int subcenter, const char *name, const char *longname)
{
  int instID;
  size_t len;
  int found;

  if ( ! InstitutsInit ) institutsInit();

  for( instID = 0; instID < institutsSize; instID++ )
    {
      if ( instituts[instID].used )
	{
	  if ( name )
	    {
	      found = 1;
	      if ( center    > 0 && instituts[instID].center    != center )    found = 0;
	      if ( subcenter > 0 && instituts[instID].subcenter != subcenter ) found = 0;

	      if ( found )
		{
		  if ( instituts[instID].name )
		    {
		      len = strlen(instituts[instID].name);
		      if ( memcmp(instituts[instID].name, name, len) == 0 ) break;
		    }
		}
	    }
	  else if ( longname )
	    {
	      if ( instituts[instID].longname )
		{
		  len = strlen(instituts[instID].longname);
		  if ( memcmp(instituts[instID].longname, longname, len) == 0 ) break;
		}
	    }
	  else
	    {
	      if ( instituts[instID].center    == center &&
		   instituts[instID].subcenter == subcenter ) break;
	    }
	}
    }

  if ( instID == institutsSize ) instID = UNDEFID;

  return (instID);
}


int institutDef(int center, int subcenter, const char *name, const char *longname)
{
  static char func[] = "institutDef";
  int instID;

  if ( ! InstitutsInit ) institutsInit();
  /*
  instID = institutInq(center, subcenter, name, longname);

  if ( instID == UNDEFID )
  */
    {
      instID = institutsNewEntry();

      instituts[instID].center    = center;
      instituts[instID].subcenter = subcenter;

      if ( name )     instituts[instID].name     = strdupx(name);
      if ( longname ) instituts[instID].longname = strdupx(longname);
    }

  return (instID);
}


void institutionCheckID(char *func, int instID)
{
  if ( instID < 0 || instID >= institutsSize )
    Error(func, "instID %d undefined!", instID);

  if ( ! instituts[instID].used )
    Error(func, "instID %d undefined!", instID);
}


int institutInqCenter(int instID)
{
  static char func[] = "institutInqCenter";
  int center = UNDEFID;

  if ( ! InstitutsInit ) institutsInit();

  if ( instID != UNDEFID )
    {
      institutionCheckID(func, instID);

      center = instituts[instID].center;
    }

  return (center);
}


int institutInqSubcenter(int instID)
{
  static char func[] = "institutInqSubcenter";
  int subcenter = UNDEFID;

  if ( ! InstitutsInit ) institutsInit();

  if ( instID != UNDEFID )
    {
      institutionCheckID(func, instID);

      subcenter = instituts[instID].subcenter;
    }

  return (subcenter);
}


char *institutInqNamePtr(int instID)
{
  static char func[] = "institutInqNamePtr";
  char *name = NULL;

  if ( ! InstitutsInit ) institutsInit();

  if ( instID != UNDEFID )
    {
      institutionCheckID(func, instID);

      if ( instituts[instID].name )
	name = instituts[instID].name;
    }

  return (name);
}


char *institutInqLongnamePtr(int instID)
{
  static char func[] = "institutInqLongnamePtr";
  char *name = NULL;

  if ( ! InstitutsInit ) institutsInit();

  if ( instID != UNDEFID )
    {
      institutionCheckID(func, instID);

      if ( instituts[instID].longname )
	name = instituts[instID].longname;
    }

  return (name);
}


int institutInqNumber(void)
{
  if ( ! InstitutsInit ) institutsInit();

  return (institutsNum);
}


void institutsDefault(void)
{
  ECMWF   = institutDef( 98,   0, "ECMWF",     "European Centre for Medium-Range Weather Forecasts");
  MPIMET  = institutDef( 98, 232, "MPIMET",    "Max-Planck-Institute for Meteorology");
     (void) institutDef( 98, 255, "MPIMET",    "Max-Planck-Institute for Meteorology");
     (void) institutDef( 98, 232, "MPIMET",    "Max-Planck Institute for Meteorology");
     (void) institutDef( 78, 255, "DWD",       "Deutscher Wetterdienst");
  MCH     = institutDef(215, 255, "MCH",       "MeteoSwiss");
     (void) institutDef(  7,   0, "NCEP",      "National Centers for Environmental Prediction");
     (void) institutDef(  7,   1, "NCEP",      "National Centers for Environmental Prediction");
     (void) institutDef( 60,   0, "NCAR",      "National Center for Atmospheric Research");
     (void) institutDef( 74,   0, "METOFFICE", "U.K. Met Office");
     (void) institutDef( 97,   0, "ESA",       "European Space Agency ");
     (void) institutDef( 99,   0, "KNMI",      "Royal Netherlands Meteorological Institute");
     /*     (void) institutDef(  0,   0, "IPSL",      "IPSL (Institut Pierre Simon Laplace, Paris, France)"); */
}
#if defined (HAVE_CONFIG_H)
#endif



#undef  UNDEFID
#define UNDEFID -1

/*int TableDefine = 0; */ /* Define new table also if the entry already exist */
                          /* This is needed for createtable */


#define MAX_TABLE  256
#define MAX_PARS   1024

typedef struct
{
  int    used;  
  PAR   *pars;
  int    npars;
  int    modelID;
  int    number;
  char  *name;
} 
PARTAB;

static PARTAB parTable[MAX_TABLE];
static int  parTableSize = MAX_TABLE;
static int  parTableNum  = 0;
static int  ParTableInit = 0;

static char *tablePath = NULL;

void tableDefModelID(int tableID, int modelID);
void tableDefNum(int tableID, int tablenum);

void tableDefEntry(int tableID, int id, const char *name,
		   const char *longname, const char *units)
{
  static char func[] = "tableDefEntry";
  int item;

  item = parTable[tableID].npars++;
  parTable[tableID].pars[item].id       = id;
  parTable[tableID].pars[item].name     = NULL;
  parTable[tableID].pars[item].longname = NULL;
  parTable[tableID].pars[item].units    = NULL;

  if ( name )
    if ( strlen(name) > 0 )
      parTable[tableID].pars[item].name     = strdupx(name);
  if ( longname )
    if ( strlen(longname) > 0 )
      parTable[tableID].pars[item].longname = strdupx(longname);
  if ( units )
    if ( strlen(units) > 0 )
      parTable[tableID].pars[item].units    = strdupx(units);
}

void tableLink(int tableID, PAR *pars, int npars)
{
  int item;

  for ( item = 0; item < npars; item++ )
    {
      parTable[tableID].pars[item].id       = pars[item].id;
      parTable[tableID].pars[item].name     = pars[item].name;
      parTable[tableID].pars[item].longname = pars[item].longname;
      parTable[tableID].pars[item].units    = pars[item].units;
    }

  parTable[tableID].npars = npars;
}

void parTableInitEntry(int tableID)
{
  parTable[tableID].used    = 0;
  parTable[tableID].pars    = NULL;
  parTable[tableID].npars   = 0;
  parTable[tableID].modelID = UNDEFID;
  parTable[tableID].number  = UNDEFID;
  parTable[tableID].name    = NULL;
}

void tableGetPath(void)
{
  static char func[] = "tableGetPath";
  char *path;

  path = getenv("TABLEPATH");

  if ( path ) tablePath = strdupx(path);
  /*
  printf("tablePath = %s\n", tablePath);
  */
}

void parTableInit(void)
{
  ParTableInit = 1;

  if ( cdiPartabIntern )
    tableDefault();

  tableGetPath();
}

int tableNewEntry()
{
  static char func[] = "tableNewEntry";
  int tableID = 0;
  static int init = 0;

  if ( ! init )
    {
      for ( tableID = 0; tableID < parTableSize; tableID++ )
	parTableInitEntry(tableID);
      init = 1;
    }

  /*
    Look for a free slot in parTable.
  */
  for ( tableID = 0; tableID < parTableSize; tableID++ )
    {
      if ( ! parTable[tableID].used ) break;
    }

  if ( tableID == parTableSize )
    Error(func, "no more entries!");

  parTable[tableID].used = 1;
  parTableNum++;

  return (tableID);
}

int decodeForm1(char *pline, char *name, char *longname, char *units)
{
  /* Format 1 : code name add mult longname [units] */
  double add, mult;
  int level;
  char *pstart, *pend;
  long len;

  level = strtol(pline, &pline, 10);
  while ( isspace((int) *pline) ) pline++;

  pstart = pline;
  while ( ! (isspace((int) *pline) || *pline == 0) ) pline++;
  len = pline - pstart;
  if ( len > 0 )
    {
      memcpy(name, pstart, len);
      name[len] = 0;
    }
  else
    return (0);

  len = strlen(pline);
  if ( len == 0 ) return (0);

  add  = strtod(pline, &pline);
  mult = strtod(pline, &pline);

  while ( isspace((int) *pline) ) pline++;

  len = strlen(pline);
  if ( len > 0)
    {
      pstart = pline;
      pend = strrchr(pline, '[');
      if ( pend )
	pend--;
      else
	pend = pstart + len;
      while ( isspace((int) *pend) ) pend--;
      len = pend - pstart + 1;
      if ( len > 0 )
	{
	  memcpy(longname, pstart, len);
	  longname[len] = 0;
	}
      pstart = strrchr(pline, '[');
      if ( pstart )
	{
	  pstart++;
	  while ( isspace((int) *pstart) ) pstart++;
	  pend = strchr(pstart, ']');
	  if ( ! pend ) return (0);
	  pend--;
	  while ( isspace((int) *pend) ) pend--;
	  len = pend - pstart + 1;
	  if ( len > 0 )
	    {
	      memcpy(units, pstart, len);
	      units[len] = 0;
	    }	  
	}
    }
 
  return (0);
}

int decodeForm2(char *pline, char *name, char *longname, char *units)
{
  /* Format 2 : code | name | longname | units */
  char *pend;
  long len;

  pline = strchr(pline, '|');
  pline++;

  while ( isspace((int) *pline) ) pline++;
  pend = strchr(pline, '|');
  if ( ! pend )
    {
      pend = pline;
      while ( ! isspace((int) *pend) ) pend++;
      len = pend - pline;
      if ( len > 0 )
	{
	  memcpy(name, pline, len);
	  name[len] = 0;
	}
      return (0);
    }
  else
    {
      pend--;
      while ( isspace((int) *pend) ) pend--;
      len = pend - pline + 1;
      if ( len > 0 )
	{
	  memcpy(name, pline, len);
	  name[len] = 0;
	}
    }

  pline = strchr(pline, '|');
  pline++;
  while ( isspace((int) *pline) ) pline++;
  pend = strchr(pline, '|');
  if ( !pend ) pend = strchr(pline, 0);
  pend--;
  while ( isspace((int) *pend) ) pend--;
  len = pend - pline + 1;
  if ( len > 0 )
    {
      memcpy(longname, pline, len);
      longname[len] = 0;
    }

  pline = strchr(pline, '|');
  if ( pline )
    {
      pline++;
      while ( isspace((int) *pline) ) pline++;
      pend = strchr(pline, '|');
      if ( !pend ) pend = strchr(pline, 0);
      pend--;
      while ( isspace((int) *pend) ) pend--;
      len = pend - pline + 1;
      if ( len < 0 ) len = 0;
      memcpy(units, pline, len);
      units[len] = 0;
    }

  return (0);
}

int tableRead(const char *tablefile)
{
  char line[1024], *pline;
  int lnr = 0;
  long len;
  int id;
  char name[256], longname[256], units[256];
  int tableID = UNDEFID;
  int err;
  char *tablename;
  FILE *tablefp;

  tablefp = fopen(tablefile, "r");
  if ( tablefp == NULL ) return (tableID);

  tablename = strrchr(tablefile, '/');
  if ( tablename == 0 ) tablename = (char *) tablefile;
  else                  tablename++;

  tableID = tableDef(-1, 0, tablename);

  while ( fgets(line, 1023, tablefp) )
    {
      len = strlen(line);
      if ( line[len-1] == '\n' ) line[len-1] = '\0';
      lnr++;
      id       = CDI_UNDEFID;
      name[0]     = 0;
      longname[0] = 0;
      units[0]    = 0;
      if ( line[0] == '#' ) continue;
      pline = line;

      len = strlen(pline);
      if ( len < 4 ) continue;
      while ( isspace((int) *pline) ) pline++;
      id = atoi(pline);
      /*
      if ( id > 255 ) id -= 256;
      */
      if ( id == 0 ) continue;

      while ( isdigit((int) *pline) ) pline++; 

      if ( strchr(pline, '|') )
	err = decodeForm2(pline, name, longname, units);
      else
	err = decodeForm1(pline, name, longname, units);

      if ( err ) continue;

      if ( strlen(name) == 0 ) sprintf(name, "var%d", id);

      tableDefEntry(tableID, id, name, longname, units);
    }

  return (tableID);
}

int tableFromEnv(int modelID, int tablenum)
{
  static char func[] = "tableFromEnv";
  int tableID = UNDEFID;
  char tablename[256] = {'\0'};
  int tablenamefound = 0;

  if ( modelInqNamePtr(modelID) )
    {
      strcpy(tablename, modelInqNamePtr(modelID));
      if ( tablenum )
	{
	  int len = strlen(tablename);
	  sprintf(tablename+len, "_%03d", tablenum);
	}
      tablenamefound = 1;
      /* printf("%s: tablename = >%s<\n", func, tablename); */
    }
  else
    {
      int instID = modelInqInstitut(modelID);
      if ( instID != UNDEFID )
	{
	  if ( institutInqNamePtr(instID) )
	    {
	      strcpy(tablename, institutInqNamePtr(instID));
	      if ( tablenum )
		{
		  int len = strlen(tablename);
		  sprintf(tablename+len, "_%03d", tablenum);
		}
	      tablenamefound = 1;
	      /* printf("%s: tablename = >%s<\n", func, tablename); */
	    }
	}
    }

  if ( tablenamefound )
    {
      int lenp = 0, lenf;
      char *tablefile = NULL;
      if ( tablePath )
	lenp = strlen(tablePath);
      lenf = strlen(tablename);
      /* if (tablePath) printf("tablePath = %s\n", tablePath); */
      /* if (tablename) printf("tableName = %s\n", tablename); */
      tablefile = (char *) malloc(lenp+lenf+3);
      if ( tablePath )
	{
	  strcpy(tablefile, tablePath);
	  strcat(tablefile, "/");
	}
      else
	tablefile[0] = '\0';
      strcat(tablefile, tablename);
      /* if (tablefile) printf("tableFile = %s\n", tablefile); */

      tableID = tableRead(tablefile);
      if ( tableID != UNDEFID )
	{
	  tableDefModelID(tableID, modelID);
	  tableDefNum(tableID, tablenum);
	}
      /* printf("tableID = %d %s\n", tableID, tablefile); */

      free(tablefile);
    }

  return (tableID);
}

int tableInq(int modelID, int tablenum, const char *tablename)
{
  static char func[] = "tableInq";
  int tableID = UNDEFID;
  int modelID2 = UNDEFID, i, len;
  char tablefile[256] = {'\0'};

  if ( ! ParTableInit ) parTableInit();

  if ( tablename )
    {
      size_t len;
      strcpy(tablefile, tablename);
      /*
      printf("tableInq: tablefile = >%s<\n", tablefile);
      */
      /* search for internal table */
      for ( tableID = 0; tableID < MAX_TABLE; tableID++ )
	{
	  if ( parTable[tableID].used && parTable[tableID].name )
	    {
	      /* len = strlen(parTable[tableID].name); */
	      len = strlen(tablename);
	      if ( memcmp(parTable[tableID].name, tablename, len) == 0 ) break;
	    }
	}
      if ( tableID == MAX_TABLE ) tableID = UNDEFID;
      if ( CDI_Debug )
	Message(func, "tableID = %d tablename = %s", tableID, tablename);
    }
  else
    {
      for ( tableID = 0; tableID < MAX_TABLE; tableID++ )
	{
	  if ( parTable[tableID].used )
	    {	  
	      if ( parTable[tableID].modelID == modelID &&
		   parTable[tableID].number  == tablenum ) break;
	    }
	}
  
      if ( tableID == MAX_TABLE ) tableID = UNDEFID;

      if ( tableID == UNDEFID )
	{
	  if ( modelID != UNDEFID )
	    {
	      if ( modelInqNamePtr(modelID) )
		{
		  strcpy(tablefile, modelInqNamePtr(modelID));
		  len = strlen(tablefile);
		  for ( i = 0; i < len; i++)
		    if ( tablefile[i] == '.' ) tablefile[i] = '\0';
		  modelID2 = modelInq(-1, 0, tablefile);
		}
	    }
	  if ( modelID2 != UNDEFID )
	    for ( tableID = 0; tableID < MAX_TABLE; tableID++ )
	      {
		if ( parTable[tableID].used )
		  {
		    if ( parTable[tableID].modelID == modelID2 &&
			 parTable[tableID].number  == tablenum ) break;
		  }
	      }
	}

      if ( tableID == MAX_TABLE ) tableID = UNDEFID;

      if ( tableID == UNDEFID && modelID != UNDEFID )
	tableID = tableFromEnv(modelID, tablenum);

      if ( CDI_Debug )
	if ( tablename )
	  Message(func, "tableID = %d tablename = %s", tableID, tablename);
    }

  return (tableID);
}

int tableDef(int modelID, int tablenum, const char *tablename)
{
  static char func[] = "tableDef";
  int tableID = UNDEFID;

  if ( ! ParTableInit ) parTableInit();
  /*
  if ( ! (modelID == UNDEFID && tablenum == 0) )
    tableID = tableInq(modelID, tablenum, tablename);
    */
  if ( tableID == UNDEFID )
    {
      tableID = tableNewEntry();

      parTable[tableID].modelID = modelID;
      parTable[tableID].number  = tablenum;
      if ( tablename ) 
	parTable[tableID].name = strdupx(tablename);

      parTable[tableID].pars = (PAR *) malloc(MAX_PARS * sizeof(PAR));
    }

  return (tableID);
}

void tableDefModelID(int tableID, int modelID)
{
  parTable[tableID].modelID = modelID;
}

void tableDefNum(int tableID, int tablenum)
{
  parTable[tableID].number  = tablenum;
}

int tableInqNum(int tableID)
{
  int number = 0;

  if ( tableID >= 0 && tableID < MAX_TABLE )
    number = parTable[tableID].number;

  return (number);
}

int tableInqModel(int tableID)
{
  int modelID = -1;

  if ( tableID >= 0 && tableID < MAX_TABLE )
    modelID = parTable[tableID].modelID;

  return (modelID);
}

void partabCheckID(int item)
{
  static char func[] = "partabCheckID";

  if ( item < 0 || item >= parTableSize )
    Error(func, "item %d undefined!", item);

  if ( ! parTable[item].name )
    Error(func, "item %d name undefined!", item);
}

char *tableInqNamePtr(int tableID)
{
  static char func[] = "tableInqNamePtr";
  char *tablename = NULL;

  if ( CDI_Debug )
    Message(func, "tableID = %d", tableID);

  if ( ! ParTableInit ) parTableInit();

  if ( tableID >= 0 && tableID < parTableSize )
    if ( parTable[tableID].name )
      tablename = parTable[tableID].name;

  return (tablename);
}

void tableWrite(const char *ptfile, int tableID)
{
  static char func[] = "tableWrite";
  int item, npars;
  int lenname, lenlname, lenunits;
  int maxname = 4, maxlname = 10, maxunits = 2;
  FILE *ptfp;
  int tablenum, modelID, instID = CDI_UNDEFID;
  int center = 0, subcenter = 0;
  char *name, *longname, *units;
  char *instnameptr = NULL, *modelnameptr = NULL;

  if ( CDI_Debug )
    Message(func, "write parameter table %d to %s", tableID, ptfile);

  if ( tableID == UNDEFID )
    {
      Warning(func, "parameter table ID undefined");
      return;
    }

  partabCheckID(tableID);

  ptfp = fopen(ptfile, "w");

  npars = parTable[tableID].npars;

  for ( item = 0; item < npars; item++)
    {
      if ( parTable[tableID].pars[item].name )
	{
	  lenname  = strlen(parTable[tableID].pars[item].name);
	  if ( lenname  > maxname )  maxname  = lenname;
	}

      if ( parTable[tableID].pars[item].longname )
	{
	  lenlname = strlen(parTable[tableID].pars[item].longname);
	  if ( lenlname > maxlname ) maxlname = lenlname;
	}

      if ( parTable[tableID].pars[item].units )
	{
	  lenunits = strlen(parTable[tableID].pars[item].units);
	  if ( lenunits > maxunits ) maxunits = lenunits;
	}
    }

  tablenum = tableInqNum(tableID);
  modelID = parTable[tableID].modelID;
  if ( modelID != CDI_UNDEFID )
    {
      modelnameptr = modelInqNamePtr(modelID);
      instID = modelInqInstitut(modelID);
    }
  if ( instID != CDI_UNDEFID )
    {
      center = institutInqCenter(instID);
      subcenter = institutInqSubcenter(instID);
      instnameptr = institutInqNamePtr(instID);
    }

  fprintf(ptfp, "# Parameter table\n");
  fprintf(ptfp, "#\n");
  if ( tablenum )
    fprintf(ptfp, "# TABLE_ID=%d\n", tablenum);
  fprintf(ptfp, "# TABLE_NAME=%s\n", parTable[tableID].name);
  if ( modelnameptr )
    fprintf(ptfp, "# TABLE_MODEL=%s\n", modelnameptr);
  if ( instnameptr )
    fprintf(ptfp, "# TABLE_INSTITUT=%s\n", instnameptr);
  if ( center )
    fprintf(ptfp, "# TABLE_CENTER=%d\n", center);
  if ( subcenter )
    fprintf(ptfp, "# TABLE_SUBCENTER=%d\n", subcenter);
  fprintf(ptfp, "#\n");
  fprintf(ptfp, "#\n");
  fprintf(ptfp, "# id       = parameter ID\n");
  fprintf(ptfp, "# name     = variable name\n");
  fprintf(ptfp, "# title    = long name (description)\n");
  fprintf(ptfp, "# units    = variable units\n");
  fprintf(ptfp, "#\n");
  fprintf(ptfp, "# The format of each record is:\n");
  fprintf(ptfp, "#\n");
  fprintf(ptfp, "# id | %-*s | %-*s | %-*s\n",
	  maxname,  "name",
	  maxlname, "title",
	  maxunits, "units");
	  
  for ( item = 0; item < npars; item++)
    {
      name = parTable[tableID].pars[item].name;
      longname = parTable[tableID].pars[item].longname;
      units = parTable[tableID].pars[item].units;
      if ( name == NULL ) name = " ";
      if ( longname == NULL ) longname = " ";
      if ( units == NULL ) units = " ";
      fprintf(ptfp, "%4d | %-*s | %-*s | %-*s\n",
	      parTable[tableID].pars[item].id,
	      maxname, name,
	      maxlname, longname,
	      maxunits, units);
    }

  fclose(ptfp);
}


void tableWriteC(const char *filename, int tableID)
{
  static char func[] = "tableWriteC";
  char chelp[] = "";
  int item, npars;
  int lenname, lenlname, lenunits;
  int maxname = 0, maxlname = 0, maxunits = 0;
  char tablename[256];
  int len, i;
  FILE *ptfp;

  if ( CDI_Debug )
    Message(func, "write parameter table %d to %s", tableID, filename);

  if ( tableID == UNDEFID )
    {
      Warning(func, "parameter table ID undefined");
      return;
    }

  partabCheckID(tableID);

  ptfp = fopen(filename, "w");

  npars = parTable[tableID].npars;

  for ( item = 0; item < npars; item++)
    {
      if ( parTable[tableID].pars[item].name )
	{
	  lenname  = strlen(parTable[tableID].pars[item].name);
	  if ( lenname  > maxname )  maxname  = lenname;
	}

      if ( parTable[tableID].pars[item].longname )
	{
	  lenlname = strlen(parTable[tableID].pars[item].longname);
	  if ( lenlname > maxlname ) maxlname = lenlname;
	}

      if ( parTable[tableID].pars[item].units )
	{
	  lenunits = strlen(parTable[tableID].pars[item].units);
	  if ( lenunits > maxunits ) maxunits = lenunits;
	}
    }

  strcpy(tablename, parTable[tableID].name);
  len = strlen(tablename);

  for ( i = 0; i < len; i++ )
    if ( tablename[i] == '.' ) tablename[i] = '_';

  fprintf(ptfp, "static PAR %s[] = {\n", tablename);
	  
  for ( item = 0; item < npars; item++ )
    {
      len = strlen(parTable[tableID].pars[item].name);
      fprintf(ptfp, "  {%4d, \"%s\", %-*s",
	      parTable[tableID].pars[item].id,
	      parTable[tableID].pars[item].name, maxname-len, chelp);

      if ( parTable[tableID].pars[item].longname )
	len = strlen(parTable[tableID].pars[item].longname);
      else
	len = 0;

      if ( len == 0 )
	fprintf(ptfp, " NULL, %-*s", maxlname-3, chelp);
      else
	fprintf(ptfp, "\"%s\", %-*s",
		parTable[tableID].pars[item].longname, maxlname-len, chelp);

      if ( parTable[tableID].pars[item].units )
	len = strlen(parTable[tableID].pars[item].units);
      else
	len = 0;

      if ( len == 0 )
	fprintf(ptfp, " NULL %-*s},\n", maxunits-3, chelp);
      else
	fprintf(ptfp, "\"%s\" %-*s},\n",
		parTable[tableID].pars[item].units,
		maxunits-len, chelp);
    }

  fprintf(ptfp, "};\n\n");

  fclose(ptfp);
}


int tableInqParCode(int tableID, char *varname, int *code)
{
  int item, npars;
  int err = 0;

  npars = parTable[tableID].npars;

  if ( tableID == UNDEFID || varname == NULL )
    {
      err = 1;
    }
  else
    {
      for ( item = 0; item < npars; item++ )
	{
	  if ( parTable[tableID].pars[item].name )
	    if ( strcmp(parTable[tableID].pars[item].name, varname) == 0 )
	      {
		*code = parTable[tableID].pars[item].id;
		break;
	      }
	}
      if ( item == npars ) err = 1;
    }

  return (err);
}


int tableInqParName(int tableID, int code, char *varname)
{
  int item, npars;
  int err = 0;

  npars = parTable[tableID].npars;

  if ( tableID == UNDEFID )
    {
      err = 1;
    }
  else
    {
      for ( item = 0; item < npars; item++ )
	{
	  if ( parTable[tableID].pars[item].id == code )
	    {
	      if ( parTable[tableID].pars[item].name )
		strcpy(varname, parTable[tableID].pars[item].name);
	      break;
	    }
	}
      if ( item == npars ) err = 1;
    }

  return (err);
}


char *tableInqParNamePtr(int tableID, int code)
{
  char *name = NULL;
  int item, npars;

  if ( tableID != UNDEFID )
    {
      npars = parTable[tableID].npars;
      for ( item = 0; item < npars; item++ )
	{
	  if ( parTable[tableID].pars[item].id == code )
	    {
	      name = parTable[tableID].pars[item].name;
	      break;
	    }
	}
    }

  return (name);
}


char *tableInqParLongnamePtr(int tableID, int code)
{
  char *longname = NULL;
  int item, npars;

  if ( tableID != UNDEFID )
    {
      npars = parTable[tableID].npars;
      for ( item = 0; item < npars; item++ )
	{
	  if ( parTable[tableID].pars[item].id == code )
	    {
	      longname = parTable[tableID].pars[item].longname;
	      break;
	    }
	}
    }

  return (longname);
}


char *tableInqParUnitsPtr(int tableID, int code)
{
  char *units = NULL;
  int item, npars;

  if ( tableID != UNDEFID )
    {
      npars = parTable[tableID].npars;
      for ( item = 0; item < npars; item++ )
	{
	  if ( parTable[tableID].pars[item].id == code )
	    {
	      units = parTable[tableID].pars[item].units;
	      break;
	    }
	}
    }

  return (units);
}


int tableInqParLongname(int tableID, int code, char *longname)
{
  int item, npars;
  int err = 0;

  npars = parTable[tableID].npars;

  if ( tableID == UNDEFID )
    {
      err = 1;
    }
  else
    {
      for ( item = 0; item < npars; item++ )
	{
	  if ( parTable[tableID].pars[item].id == code )
	    {
	      if ( parTable[tableID].pars[item].longname )
		strcpy(longname, parTable[tableID].pars[item].longname);
	      break;
	    }
	}
      if ( item == npars ) err = 1;
    }

  return (err);
}


int tableInqParUnits(int tableID, int code, char *units)
{
  int item, npars;
  int err = 0;

  npars = parTable[tableID].npars;

  if ( tableID == UNDEFID )
    {
      err = 1;
    }
  else
    {
      for ( item = 0; item < npars; item++ )
	{
	  if ( parTable[tableID].pars[item].id == code )
	    {
	      if ( parTable[tableID].pars[item].units )
		strcpy(units, parTable[tableID].pars[item].units);
	      break;
	    }
	}
      if ( item == npars ) err = 1;
    }

  return (err);
}


void tableInqPar(int tableID, int code, char *name, char *longname, char *units)
{
  int item, npars;

  npars = parTable[tableID].npars;

  for ( item = 0; item < npars; item++ )
    {
      if ( parTable[tableID].pars[item].id == code )
	{
	  if ( parTable[tableID].pars[item].name )
	    strcpy(name, parTable[tableID].pars[item].name);
	  if ( parTable[tableID].pars[item].longname )
	    strcpy(longname, parTable[tableID].pars[item].longname);
	  if ( parTable[tableID].pars[item].units )
	    strcpy(units, parTable[tableID].pars[item].units);
	  break;
	}
    }
}


int parInqID(int tableID, int code)
{
  int item, npars;

  npars = parTable[tableID].npars;

  for ( item = 0; item < npars; item++ )
    {
      if ( parTable[tableID].pars[item].id == code ) break;
    }

  if ( item == npars ) item = -1;

  return (item);
}

int tableInqNumber(void)
{
  if ( ! ParTableInit ) parTableInit();

  return (parTableNum);
}
#if defined (HAVE_CONFIG_H)
#endif




#undef  IsBigendian
#define IsBigendian()  ( u_byteorder.c[sizeof(long) - 1] )

void cdiPrintDatatypes(void)
{
  /* IsBigendian returns 1 for big endian byte order */
  static union {unsigned long l; unsigned char c[sizeof(long)];} u_byteorder = {1};

  fprintf (stderr, "+-------------+-------+\n"); 
  fprintf (stderr, "| types       | bytes |\n"); 
  fprintf (stderr, "+-------------+-------+\n"); 
  fprintf (stderr, "| void *      |   %3d |\n", (int) sizeof(void *));
  fprintf (stderr, "+-------------+-------+\n"); 
  fprintf (stderr, "| char        |   %3d |\n", (int) sizeof(char));
  fprintf (stderr, "+-------------+-------+\n"); 
  fprintf (stderr, "| short       |   %3d |\n", (int) sizeof(short));
  fprintf (stderr, "| int         |   %3d |\n", (int) sizeof(int));
  fprintf (stderr, "| long        |   %3d |\n", (int) sizeof(long));
  fprintf (stderr, "| long long   |   %3d |\n", (int) sizeof(long long));
  fprintf (stderr, "| size_t      |   %3d |\n", (int) sizeof(size_t));
  fprintf (stderr, "| off_t       |   %3d |\n", (int) sizeof(off_t));
  fprintf (stderr, "+-------------+-------+\n"); 
  fprintf (stderr, "| float       |   %3d |\n", (int) sizeof(float));
  fprintf (stderr, "| double      |   %3d |\n", (int) sizeof(double));
  fprintf (stderr, "| long double |   %3d |\n", (int) sizeof(long double));
  fprintf (stderr, "+-------------+-------+\n\n"); 
#define XSTRING(x)	#x
#define STRING(x)	XSTRING(x)
  fprintf (stderr, "+-------------+-----------+\n"); 
  fprintf (stderr, "| INT32       | %-9s |\n", STRING(INT32));
  fprintf (stderr, "| INT64       | %-9s |\n", STRING(INT64));
  fprintf (stderr, "| FLT32       | %-9s |\n", STRING(FLT32));
  fprintf (stderr, "| FLT64       | %-9s |\n", STRING(FLT64));
  fprintf (stderr, "+-------------+-----------+\n");

  if ( IsBigendian() )
    fprintf (stderr, "\n  byte ordering is BIGENDIAN\n\n");
  else
    fprintf (stderr, "\n  byte ordering is LITTLEENDIAN\n\n");
}



#ifndef  M_SQRT2
#define  M_SQRT2     1.41421356237309504880
#endif


static
void cpledn(int kn, int kodd, double *pfn, double pdx, int kflag, 
            double *pw, double *pdxn, double *pxmod)
{
  double zdlk;
  double zdlldn;
  double zdlx;
  double zdlmod;
  double zdlxn;

  int ik, jn;

  /* 1.0 Newton iteration step */

  zdlx = pdx;
  zdlk = 0.0;
  if (kodd == 0) 
    {
      zdlk = 0.5*pfn[0];
    }
  zdlxn  = 0.0;
  zdlldn = 0.0;

  ik = 1;

  if (kflag == 0) 
    {
      for(jn = 2-kodd; jn <= kn; jn += 2) 
	{
	  /* normalised ordinary Legendre polynomial == \overbar{p_n}^0 */
	  zdlk   = zdlk + pfn[ik]*cos((double)(jn)*zdlx);
	  /* normalised derivative == d/d\theta(\overbar{p_n}^0) */
	  zdlldn = zdlldn - pfn[ik]*(double)(jn)*sin((double)(jn)*zdlx);
	  ik++;
	}
      /* Newton method */
      zdlmod = -(zdlk/zdlldn);
      zdlxn = zdlx + zdlmod;
      *pdxn = zdlxn;
      *pxmod = zdlmod;
    }

  /* 2.0 Compute weights */

  if (kflag == 1) 
    {
      for(jn = 2-kodd; jn <= kn; jn += 2) 
	{
	  /* normalised derivative */
	  zdlldn = zdlldn - pfn[ik]*(double)(jn)*sin((double)(jn)*zdlx);
	  ik++;
	}
      *pw = (double)(2*kn+1)/(zdlldn*zdlldn);
    }

  return;
}

static
void gawl(double *pfn, double *pl, double *pw, int kn, int *kiter)
{
  int iodd;
  double pmod = 0;
  int iflag;
  int itemax;
  int jter;
  double zw = 0;
  double zdlx;
  double zdlxn = 0;

  /* 1.0 Initizialization */

  iflag  =  0;
  itemax = 20;

  iodd   = (kn % 2);

  zdlx   =  *pl;

  /* 2.0 Newton iteration */

  for (jter = 1; jter <= itemax+1; jter++) 
    {
      *kiter = jter;
      cpledn(kn, iodd, pfn, zdlx, iflag, &zw, &zdlxn, &pmod);
      zdlx = zdlxn;
      if (iflag == 1) break;
      if (fabs(pmod) <= DBL_EPSILON*1000.0) iflag = 1;
    }

  *pl = zdlxn;
  *pw = zw;

  return;
}

static
void gauaw(int kn, double *pl, double *pw)
{
  /*
   * 1.0 Initialize Fourier coefficients for ordinary Legendre polynomials
   *
   * Belousov, Swarztrauber, and ECHAM use zfn(0,0) = sqrt(2)
   * IFS normalisation chosen to be 0.5*Integral(Pnm**2) = 1 (zfn(0,0) = 2.0)
   */
  static const char *func = "gauaw";
  double *zfn, *zfnlat;

  double z, zfnn;

  int *iter;

  int ik, ins2, isym, jgl, jglm1, jn, iodd;

  iter   = (int *)    malloc(kn*sizeof(int));
  zfn    = (double *) malloc((kn+1)*(kn+1)*sizeof(double));
  zfnlat = (double *) malloc((kn/2+1+1)*sizeof(double));  

  zfn[0] = M_SQRT2;
  for (jn = 1; jn <= kn; jn++)
    {
      zfnn = zfn[0];
      for (jgl = 1; jgl <= jn; jgl++)
	{
	  zfnn *= sqrt(1.0-0.25/((double)(jgl*jgl))); 
	}

      zfn[jn*(kn+1)+jn] = zfnn;

      iodd = jn % 2;
      for (jgl = 2; jgl <= jn-iodd; jgl += 2) 
	{
	  zfn[jn*(kn+1)+jn-jgl] = zfn[jn*(kn+1)+jn-jgl+2]
	    *((double)((jgl-1)*(2*jn-jgl+2)))/((double)(jgl*(2*jn-jgl+1)));
	}
    }


  /* 2.0 Gaussian latitudes and weights */

  iodd = kn % 2;
  ik = iodd;
  for (jgl = iodd; jgl <= kn; jgl += 2)
    {
      zfnlat[ik] = zfn[kn*(kn+1)+jgl];
      ik++;
    } 

  /*
   * 2.1 Find first approximation of the roots of the
   *     Legendre polynomial of degree kn.
   */

  ins2 = kn/2+(kn % 2);

  for (jgl = 1; jgl <= ins2; jgl++) 
    {
      z = ((double)(4*jgl-1))*M_PI/((double)(4*kn+2)); 
      pl[jgl-1] = z+1.0/(tan(z)*((double)(8*kn*kn)));
    }

  /* 2.2 Computes roots and weights for transformed theta */

  for (jgl = ins2; jgl >= 1 ; jgl--) 
    {
      jglm1 = jgl-1;
      gawl(zfnlat, &(pl[jglm1]), &(pw[jglm1]), kn, &(iter[jglm1]));
    }

  /* convert to physical latitude */

  for (jgl = 0; jgl < ins2; jgl++) 
    {
      pl[jgl] = cos(pl[jgl]);
    }

  for (jgl = 1; jgl <= kn/2; jgl++) 
    {
      jglm1 = jgl-1;
      isym =  kn-jgl;
      pl[isym] =  -pl[jglm1];
      pw[isym] =  pw[jglm1];
    }

  free(zfnlat);
  free(zfn);
  free(iter);

  return;
}

static
void gauaw_old(double *pa, double *pw, int nlat)
{
  /*
   * Compute Gaussian latitudes.  On return pa contains the
   * sine of the latitudes starting closest to the north pole and going
   * toward the south
   *
   */

  const int itemax = 20;

  int isym, iter, ins2, jn, j;
  double za, zw, zan;
  double z, zk, zkm1, zkm2, zx, zxn, zldn, zmod;

  /*
   * Perform the Newton loop
   * Find 0 of Legendre polynomial with Newton loop
   */

  ins2 = nlat/2 + nlat%2;

  for ( j = 0; j < ins2; j++ )
    {
      z = (double) (4*(j+1)-1)*M_PI / (double) (4*nlat+2);
      pa[j] = cos(z + 1.0/(tan(z)*(double)(8*nlat*nlat)));
    }

  for ( j = 0; j < ins2; j++ )
    {

      za = pa[j];

      iter = 0;
      do
	{
	  iter++;
	  zk = 0.0;

	  /* Newton iteration step */

	  zkm2 = 1.0;
	  zkm1 = za;
	  zx = za;
	  for ( jn = 2; jn <= nlat; jn++ )
	    {
	      zk = ((double) (2*jn-1)*zx*zkm1-(double)(jn-1)*zkm2) / (double)(jn);
	      zkm2 = zkm1;
	      zkm1 = zk;
	    }
	  zkm1 = zkm2;
	  zldn = ((double) (nlat)*(zkm1-zx*zk)) / (1.-zx*zx);
	  zmod = -zk/zldn;
	  zxn = zx+zmod;
	  zan = zxn;

	  /* computes weight */

	  zkm2 = 1.0;
	  zkm1 = zxn;
	  zx = zxn;
	  for ( jn = 2; jn <= nlat; jn++ )
	    {
	      zk = ((double) (2*jn-1)*zx*zkm1-(double)(jn-1)*zkm2) / (double) (jn);
	      zkm2 = zkm1;
	      zkm1 = zk;
	    }
	  zkm1 = zkm2;
	  zw = (1.0-zx*zx) / ((double) (nlat*nlat)*zkm1*zkm1);
	  za = zan;
	}
      while ( iter <= itemax && fabs(zmod) >= DBL_EPSILON );

      pa[j] = zan;
      pw[j] = 2.0*zw;
    }

#if defined (SX)
#pragma vdir nodep
#endif
  for (j = 0; j < nlat/2; j++)
    {
      isym = nlat-(j+1);
      pa[isym] = -pa[j];
      pw[isym] =  pw[j];
    }

  return;
}


void gaussaw(double *pa, double *pw, int nlat)
{
  //gauaw_old(pa, pw, nlat);
  gauaw(nlat, pa, pw);
}

/*
#define NGL  48

int main (int rgc, char *argv[])
{
  int ngl = NGL;
  double plo[NGL], pwo[NGL];
  double pl[NGL], pw[NGL];

  int i;

  gauaw(ngl, pl, pw);
  gauaw_old(plo, pwo, ngl);

  for (i = 0; i < ngl; i++)
    {
      fprintf(stderr, "%4d%25.18f%25.18f%25.18f%25.18f\n", i, pl[i], pw[i], pl[i]-plo[i], pw[i]-pwo[i]);
    }

  return 0;
}
*/
#if defined (HAVE_CONFIG_H)
#endif



#undef  UNDEFID
#define UNDEFID -1

static size_t Vctsize = 0;
static double *Vct = NULL;

typedef struct
{
  int      level1;
  int      level2;
  int      recID;
  int      lindex;
}
leveltable_t;

typedef struct
{
  int         param;
  int         prec;
  int         tsteptype;
  int         timave;
  int         timaccu;
  int         gridID;
  int         zaxistype;
  int         ltype;     /* GRIB level type */
  int         lbounds;
  int         zaxisID;
  int         nlevels;
  int         levelTableSize;
  leveltable_t *levelTable;
  int         instID;
  int         modelID;
  int         tableID;
  int         ztype;
  int         zlevel;
  int         lmissval;
  double      missval;
  char       *name;
  char       *longname;
  char       *units;
}
vartable_t;


int vartableInit = 0;
vartable_t *vartable;
static int varTablesize = 0;
int nvars = 0;


static
void paramInitEntry(int varID, int param)
{
  vartable[varID].param          = param;
  vartable[varID].prec           = 0;
  vartable[varID].tsteptype      = TSTEP_INSTANT;
  vartable[varID].timave         = 0;
  vartable[varID].timaccu        = 0;
  vartable[varID].gridID         = UNDEFID;
  vartable[varID].zaxistype      = 0;
  vartable[varID].ltype          = 0;
  vartable[varID].levelTable     = NULL;
  vartable[varID].levelTableSize = 0;
  vartable[varID].nlevels        = 0;
  vartable[varID].instID         = UNDEFID;
  vartable[varID].modelID        = UNDEFID;
  vartable[varID].tableID        = UNDEFID;
  vartable[varID].ztype          = COMPRESS_NONE;
  vartable[varID].zlevel         = 1;
  vartable[varID].lmissval       = 0;
  vartable[varID].missval        = 0;
  vartable[varID].name           = NULL;
  vartable[varID].longname       = NULL;
  vartable[varID].units          = NULL;
}


static
int varGetEntry(int param, int zaxistype, int ltype)
{
  int varID;

  for ( varID = 0; varID < varTablesize; varID++ )
    {
      if ( vartable[varID].param     == param     &&
	   vartable[varID].zaxistype == zaxistype &&
	   vartable[varID].ltype     == ltype )
	return (varID);
    }

  return (UNDEFID);
}


void varFree(void)
{
  static char func[] = "varFree";
  int varID;

  for ( varID = 0; varID < nvars; varID++ )
    {
      if ( vartable[varID].levelTable )
	free(vartable[varID].levelTable);

      if ( vartable[varID].name )     free(vartable[varID].name);
      if ( vartable[varID].longname ) free(vartable[varID].longname);
      if ( vartable[varID].units )    free(vartable[varID].units);
    }

  if ( vartable )
    free(vartable);

  vartable = NULL;
  varTablesize = 0;
  nvars = 0;

  if ( Vct )
    free(Vct);

  Vct = NULL;
  Vctsize = 0;
}

int levelNewEntry(int varID, int level1, int level2)
{
  static char func[] = "levelNewEntry";
  int levelID = 0;
  int levelTableSize;
  leveltable_t *levelTable;

  levelTableSize = vartable[varID].levelTableSize;
  levelTable     = vartable[varID].levelTable;

  /*
    Look for a free slot in levelTable.
    (Create the table the first time through).
  */
  if ( ! levelTableSize )
    {
      int i;

      levelTableSize = 2;
      levelTable = (leveltable_t *) malloc(levelTableSize*sizeof(leveltable_t));
      if( levelTable == NULL )
	{
          Message(func, "levelTableSize = %d", levelTableSize);
	  SysError(func, "Allocation of leveltable failed!");
	}

      for( i = 0; i < levelTableSize; i++ )
	levelTable[i].recID = UNDEFID;
    }
  else
    {
      while( levelID < levelTableSize )
	{
	  if ( levelTable[levelID].recID == UNDEFID ) break;
	  levelID++;
	}
    }
  /*
    If the table overflows, double its size.
  */
  if( levelID == levelTableSize )
    {
      int i;

      levelTableSize = 2*levelTableSize;
      levelTable = (leveltable_t *) realloc(levelTable, levelTableSize*sizeof(leveltable_t));
      if( levelTable == NULL )
	{
          Message(func, "levelTableSize = %d", levelTableSize);
	  SysError(func, "Reallocation of leveltable failed");
	}
      levelID = levelTableSize/2;

      for( i = levelID; i < levelTableSize; i++ )
	levelTable[i].recID = UNDEFID;
    }

  levelTable[levelID].level1 = level1;
  levelTable[levelID].level2 = level2;
  levelTable[levelID].lindex = levelID;

  vartable[varID].nlevels = levelID+1;
  vartable[varID].levelTableSize = levelTableSize;
  vartable[varID].levelTable = levelTable;

  return (levelID);
}

#define  UNDEF_PARAM  -4711

int paramNewEntry (int param)
{
  static char func[] = "paramNewEntry";
  int varID = 0;

  /*
    Look for a free slot in vartable.
    (Create the table the first time through).
  */
  if ( ! varTablesize )
    {
      int i;

      varTablesize = 2;
      vartable = (vartable_t *) malloc(varTablesize*sizeof(vartable_t));
      if( vartable == NULL )
	{
          Message(func, "varTablesize = %d", varTablesize);
	  SysError(func, "Allocation of vartable failed");
	}

      for( i = 0; i < varTablesize; i++ )
	vartable[i].param = UNDEF_PARAM;
    }
  else
    {
      while( varID < varTablesize )
	{
	  if ( vartable[varID].param == UNDEF_PARAM ) break;
	  varID++;
	}
    }
  /*
    If the table overflows, double its size.
  */
  if ( varID == varTablesize )
    {
      int i;

      varTablesize = 2*varTablesize;
      vartable = (vartable_t *) realloc(vartable, varTablesize*sizeof(vartable_t));
      if( vartable == NULL )
	{
          Message(func, "varTablesize = %d", varTablesize);
	  SysError(func, "Reallocation of vartable failed!");
	}
      varID = varTablesize/2;

      for( i = varID; i < varTablesize; i++ )
	vartable[i].param = UNDEF_PARAM;
    }

  paramInitEntry(varID, param);

  return (varID);
}


void varAddRecord(int recID, int param, int gridID, int zaxistype, int lbounds,
		  int level1, int level2, int prec,
		  int *pvarID, int *plevelID, int tsteptype, int numavg, int ltype,
		  const char *name, const char *longname, const char *units)
{
  static char func[] = "varAddRecord";
  int varID = UNDEFID;
  int levelID = -1;

  if ( ! (cdiSplitLtype105 == 1 && zaxistype == ZAXIS_HEIGHT) )
    varID = varGetEntry(param, zaxistype, ltype);

  if ( varID == UNDEFID )
    {
      nvars++;
      varID = paramNewEntry(param);
      if ( prec > vartable[varID].prec ) vartable[varID].prec = prec;
      vartable[varID].gridID    = gridID;
      vartable[varID].zaxistype = zaxistype;
      vartable[varID].ltype     = ltype;
      vartable[varID].lbounds   = lbounds;
      if ( tsteptype > 0 ) vartable[varID].tsteptype = tsteptype;
      if ( numavg ) vartable[varID].timave = 1;

      if ( name )     if ( name[0] )     vartable[varID].name     = strdup(name);
      if ( longname ) if ( longname[0] ) vartable[varID].longname = strdup(longname);
      if ( units )    if ( units[0] )    vartable[varID].units    = strdup(units);
    }
  else
    {
      if ( vartable[varID].gridID != gridID )
	{
	  char paramstr[32];
	  cdiParamToString(param, paramstr, sizeof(paramstr));	  
	  Message(func, "param = %s gridID = %d", paramstr, gridID);
	  Error(func, "horizontal grid must not change for same param!");
	}
      if ( vartable[varID].zaxistype != zaxistype )
	{
	  char paramstr[32];
	  cdiParamToString(param, paramstr, sizeof(paramstr));	  
	  Message(func, "param = %s zaxistype = %d", paramstr, zaxistype);
	  Error(func, "zaxistype must not change for same param!");
	}
    }

  levelID = levelNewEntry(varID, level1, level2);
  vartable[varID].levelTable[levelID].recID = recID;

  if ( CDI_Debug )
    Message(func, "varID = %d  levelID = %d", varID, levelID);

  *pvarID   = varID;
  *plevelID = levelID;
}


int dblcmp(const void *s1, const void *s2)
{
  int cmp = 0;

  if      ( *((double *) s1) < *((double *) s2) ) cmp = -1;
  else if ( *((double *) s1) > *((double *) s2) ) cmp =  1;

  return (cmp);
}


int cmpLevelTable(const void *s1, const void *s2)
{
  int cmp = 0;
  leveltable_t *x = (leveltable_t *) s1;
  leveltable_t *y = (leveltable_t *) s2;
  /*
  printf("%g %g  %d %d\n", x->leve11, y->level1, x, y);
  */
  if      ( x->level1 < y->level1 ) cmp = -1;
  else if ( x->level1 > y->level1 ) cmp =  1;

  return (cmp);
}


typedef struct
{
  int      varid;
  int      param;
  int      ltype;
}
param_t;


static
int cmpparam(const void *s1, const void *s2)
{
  int cmp = 0;
  param_t *x = (param_t *) s1;
  param_t *y = (param_t *) s2;

  if      ( x->param > y->param ) cmp =  1;
  else if ( x->param < y->param ) cmp = -1;

  return (cmp);
}


static
int cmpltype(const void *s1, const void *s2)
{
  int cmp = 0;
  param_t *x = (param_t *) s1;
  param_t *y = (param_t *) s2;

  if      ( x->ltype > y->ltype ) cmp =  1;
  else if ( x->ltype < y->ltype ) cmp = -1;

  return (cmp);
}


void cdiGenVars(int streamID)
{
  static char func[] = "cdiGenVars";
  int varID, gridID, zaxisID, levelID;
  int instID, modelID, tableID;
  int param, nlevels, zaxistype, lindex, ltype;
  int prec;
  int tsteptype;
  int timave, timaccu;
  int lbounds;
  int ztype;
  char name[256], longname[256], units[256];
  double *dlevels = NULL;
  double *dlevels1 = NULL;
  double *dlevels2 = NULL;
  int vlistID;
  int *varids, index, varid;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID =  streamInqVlist(streamID);

  varids = (int *) malloc(nvars*sizeof(int));
  for ( varID = 0; varID < nvars; varID++ ) varids[varID] = varID;

  if ( streamptr->sortname )
    {
      int index;
      param_t **varInfo;
      varInfo    = (param_t **) malloc(nvars*sizeof(param_t *));
      varInfo[0] = (param_t *)  malloc(nvars*sizeof(param_t));

      for ( index = 1; index < nvars; index++ )
	varInfo[index] = varInfo[0] + index;

      for ( varid = 0; varid < nvars; varid++ )
	{
	  varInfo[varid]->varid = varids[varid];
	  varInfo[varid]->param = vartable[varid].param;
	  varInfo[varid]->ltype = vartable[varid].ltype;
	}
      qsort(varInfo[0], nvars, sizeof(param_t), cmpltype);
      qsort(varInfo[0], nvars, sizeof(param_t), cmpparam);
      for ( varid = 0; varid < nvars; varid++ )
	{
	  varids[varid] = varInfo[varid]->varid;
	}
      free(varInfo[0]);
      free(varInfo);
    }

  for ( index = 0; index < nvars; index++ )
    {
      varid     = varids[index];

      gridID    = vartable[varid].gridID;
      param     = vartable[varid].param;
      nlevels   = vartable[varid].nlevels;
      ltype     = vartable[varid].ltype;
      zaxistype = vartable[varid].zaxistype;
      if ( ltype == 0 && zaxistype == ZAXIS_GENERIC && cdiDefaultLeveltype != -1 )
	zaxistype = cdiDefaultLeveltype;
      lbounds   = vartable[varid].lbounds;
      prec      = vartable[varid].prec;
      instID    = vartable[varid].instID;
      modelID   = vartable[varid].modelID;
      tableID   = vartable[varid].tableID;
      tsteptype = vartable[varid].tsteptype;
      timave    = vartable[varid].timave;
      timaccu   = vartable[varid].timaccu;
      ztype     = vartable[varid].ztype;

      zaxisID = UNDEFID;

      if ( ltype == 0 && zaxistype == ZAXIS_GENERIC && nlevels == 1 &&
	   ! (fabs(vartable[varid].levelTable[0].level1)>0) )
	zaxistype = ZAXIS_SURFACE;

      dlevels = (double *) malloc(nlevels*sizeof(double));

      if ( lbounds && zaxistype != ZAXIS_HYBRID && zaxistype != ZAXIS_HYBRID_HALF )
	for ( levelID = 0; levelID < nlevels; levelID++ )
	  dlevels[levelID] = (vartable[varid].levelTable[levelID].level1 +
	                      vartable[varid].levelTable[levelID].level2)/2;
      else
	for ( levelID = 0; levelID < nlevels; levelID++ )
	  dlevels[levelID] = vartable[varid].levelTable[levelID].level1;

      if ( nlevels > 1 )
	{
	  int linc = FALSE, ldec = FALSE;
	  /* check increasing of levels */
	  for ( levelID = 1; levelID < nlevels; levelID++ )
	    if ( dlevels[levelID] < dlevels[levelID-1] ) break;

	  if ( levelID == nlevels ) linc = TRUE;

	  if ( linc == FALSE )
	    {
	      /* check decreasing of levels */
	      for ( levelID = 1; levelID < nlevels; levelID++ )
		if ( dlevels[levelID] > dlevels[levelID-1] ) break;

	      if ( levelID == nlevels ) ldec = TRUE;

	      if ( ldec == FALSE ||
		   zaxistype == ZAXIS_HYBRID ||
		   zaxistype == ZAXIS_DEPTH_BELOW_LAND )
		{
		  /*
		  qsort(dlevels, nlevels, sizeof(double), dblcmp);
		  */
		  qsort(vartable[varid].levelTable, nlevels, 
			sizeof(leveltable_t), cmpLevelTable);

		  if ( lbounds && zaxistype != ZAXIS_HYBRID && zaxistype != ZAXIS_HYBRID_HALF )
		    for ( levelID = 0; levelID < nlevels; levelID++ )
		      dlevels[levelID] = (vartable[varid].levelTable[levelID].level1 +
					  vartable[varid].levelTable[levelID].level2)/2.;
		  else
		    for ( levelID = 0; levelID < nlevels; levelID++ )
		      dlevels[levelID] = vartable[varid].levelTable[levelID].level1;
		}
	    }
	}

      if ( lbounds )
	{
	  dlevels1 = (double *) malloc(nlevels*sizeof(double));
	  for ( levelID = 0; levelID < nlevels; levelID++ )
	    dlevels1[levelID] = vartable[varid].levelTable[levelID].level1;
	  dlevels2 = (double *) malloc(nlevels*sizeof(double));
	  for ( levelID = 0; levelID < nlevels; levelID++ )
	    dlevels2[levelID] = vartable[varid].levelTable[levelID].level2;
	}

      zaxisID = varDefZaxis(vlistID, zaxistype, nlevels, dlevels, lbounds, dlevels1, dlevels2,
			    Vctsize, Vct, NULL, NULL, NULL, 0, 0, ltype);

      if ( lbounds ) free(dlevels1);
      if ( lbounds ) free(dlevels2);
      free(dlevels);

      varID = streamNewVar(streamID, gridID, zaxisID);
      varID = vlistDefVar(vlistID, gridID, zaxisID, TIME_VARIABLE);

      vlistDefVarParam(vlistID, varID, param);
      vlistDefVarDatatype(vlistID, varID, prec);
      vlistDefVarTsteptype(vlistID, varID, tsteptype);
      vlistDefVarTimave(vlistID, varID, timave);
      vlistDefVarTimaccu(vlistID, varID, timaccu);
      vlistDefVarZtype(vlistID, varID, ztype);

      if ( vartable[varid].lmissval ) vlistDefVarMissval(vlistID, varID, vartable[varid].missval);

      if ( vartable[varid].name )     vlistDefVarName(vlistID, varID, vartable[varid].name);
      if ( vartable[varid].longname ) vlistDefVarLongname(vlistID, varID, vartable[varid].longname);
      if ( vartable[varid].units )    vlistDefVarUnits(vlistID, varID, vartable[varid].units);

      if ( cdiDefaultTableID != UNDEFID )
	{
	  int pdis, pcat, pnum;
	  cdiDecodeParam(param, &pnum, &pcat, &pdis);
	  if ( tableInqParNamePtr(cdiDefaultTableID, pnum) )
	    {
	      if ( tableID != UNDEFID )
		{
		  strcpy(name, tableInqParNamePtr(cdiDefaultTableID, pnum));
		  vlistDefVarName(vlistID, varID, name);
		  if ( tableInqParLongnamePtr(cdiDefaultTableID, pnum) )
		    {
		      strcpy(longname, tableInqParLongnamePtr(cdiDefaultTableID, pnum));
		      vlistDefVarLongname(vlistID, varID, longname);
		    }
		  if ( tableInqParUnitsPtr(cdiDefaultTableID, pnum) )
		    {
		      strcpy(units, tableInqParUnitsPtr(cdiDefaultTableID, pnum));
		      vlistDefVarUnits(vlistID, varID, units);
		    }
		}
	      else
		tableID = cdiDefaultTableID;
	    }
	  if ( cdiDefaultModelID != UNDEFID ) modelID = cdiDefaultModelID;
	  if ( cdiDefaultInstID  != UNDEFID )  instID = cdiDefaultInstID;
	}

      if ( instID  != UNDEFID ) vlistDefVarInstitut(vlistID, varID, instID);
      if ( modelID != UNDEFID ) vlistDefVarModel(vlistID, varID, modelID);
      if ( tableID != UNDEFID ) vlistDefVarTable(vlistID, varID, tableID);
    }

  for ( index = 0; index < nvars; index++ )
    {
      varID     = index;
      varid     = varids[index];

      nlevels   = vartable[varid].nlevels;
      /*
      for ( levelID = 0; levelID < nlevels; levelID++ )
	{
	  lindex = vartable[varid].levelTable[levelID].lindex;
	  printf("%d %d %d %d %d\n", varID, levelID, 
		 vartable[varid].levelTable[levelID].lindex,
		 vartable[varid].levelTable[levelID].recID,
		 vartable[varid].levelTable[levelID].level1);
	}
      */
      for ( levelID = 0; levelID < nlevels; levelID++ )
	{
	  streamptr->vars[varID].level[levelID] =
	    vartable[varid].levelTable[levelID].recID;
	  for ( lindex = 0; lindex < nlevels; lindex++ )
	    if ( levelID == vartable[varid].levelTable[lindex].lindex ) break;

	  if ( lindex == nlevels )
	    Error(func, "Internal problem! lindex not found.");

	  streamptr->vars[varID].lindex[levelID] = lindex;
	}
    }

  free(varids);

  varFree();
}


void varDefVCT(size_t vctsize, double *vctptr)
{
  static char func[] = "varDefVCT";

  if ( Vct == NULL && vctptr != NULL && vctsize > 0 )
    {
      Vctsize = vctsize;
      Vct = (double *) malloc(vctsize*sizeof(double));
      memcpy(Vct, vctptr, vctsize*sizeof(double)); 
    }
}


int varDefGrid(int vlistID, grid_t grid, int mode)
{
  /*
    mode: 0 search in vlist and grid table
          1 search in grid table
   */
  static char func[] = "varDefGrid";
  int gridglobdefined = 0;
  int griddefined;
  int ngrids;
  int gridID = UNDEFID;
  int index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  griddefined = 0;
  ngrids = vlistptr->ngrids;

  if ( mode == 0 )
    for ( index = 0; index < ngrids; index++ )
      {
	gridID = vlistptr->gridIDs[index];
	if ( gridID == UNDEFID )
	  Error(func, "undefined gridID %d", gridID);

	if ( gridCompare(gridID, grid) == 0 )
	  {
	    griddefined = 1;
	    break;
	  }
      }

  if ( ! griddefined )
    {
      ngrids = gridSize();
      for ( gridID = 0; gridID < ngrids; gridID++ )
	{
	  if ( gridCompare(gridID, grid) == 0 )
	    {
	      gridglobdefined = 1;
	      break;
	    }
	}

      ngrids = vlistptr->ngrids;
      if ( mode == 1 )
	for ( index = 0; index < ngrids; index++ )
	  if ( vlistptr->gridIDs[index] == gridID )
	    {
	      gridglobdefined = FALSE;
	      break;
	    }
    }

  if ( ! griddefined )
    {
      if ( ! gridglobdefined ) gridID = gridGenerate(grid);
      ngrids = vlistptr->ngrids;
      vlistptr->gridIDs[ngrids] = gridID;
      vlistptr->ngrids++;
    }

  return (gridID);
}


int zaxisCompare(int zaxisID, int zaxistype, int nlevels, int lbounds, double *levels, char *longname, char *units, int ltype)
{
  int differ = 1;
  int levelID;
  int zlbounds = 0;
  int ltype_is_equal = FALSE;

  if ( ltype == zaxisInqLtype(zaxisID) ) ltype_is_equal = TRUE;

  if ( ltype_is_equal && (zaxistype == zaxisInqType(zaxisID) || zaxistype == ZAXIS_GENERIC) )
    {
      if ( zaxisInqLbounds(zaxisID, NULL) > 0 ) zlbounds = 1;
      if ( nlevels == zaxisInqSize(zaxisID) && zlbounds == lbounds )
	{
	  const double *dlevels;
	  char zlongname[256];
	  char zunits[256];
	  
	  dlevels = zaxisInqLevelsPtr(zaxisID);
	  for ( levelID = 0; levelID < nlevels; levelID++ )
	    {
	      if ( fabs(dlevels[levelID] - levels[levelID]) > 0 )
		break;
	    }

	  if ( levelID == nlevels ) differ = 0;

	  if ( ! differ )
	    {
	      zaxisInqLongname(zaxisID, zlongname);
	      zaxisInqUnits(zaxisID, zunits);
	      if ( longname && zlongname[0] )
		{
		  if ( strcmp(longname, zlongname) != 0 ) differ = 1;
		}
	      if ( units && zunits[0] )
		{
		  if ( strcmp(units, zunits) != 0 ) differ = 1;
		}
	    }
	}
    }

  return (differ);
}


int varDefZaxis(int vlistID, int zaxistype, int nlevels, double *levels, int lbounds, 
		double *levels1, double *levels2, int vctsize, double *vct, char *name, 
		char *longname, char *units, int prec, int mode, int ltype)
{
  /*
    mode: 0 search in vlist and zaxis table
          1 search in zaxis table
   */
  static char func[] = "varDefZaxis";
  int zaxisdefined;
  int nzaxis;
  int zaxisID = UNDEFID;
  int index;
  int zaxisglobdefined = 0;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  zaxisdefined = 0;
  nzaxis = vlistptr->nzaxis;

  if ( mode == 0 )
    for ( index = 0; index < nzaxis; index++ )
      {
	zaxisID = vlistptr->zaxisIDs[index];

	if ( zaxisCompare(zaxisID, zaxistype, nlevels, lbounds, levels, longname, units, ltype) == 0 )
	  {
	    zaxisdefined = 1;
	    break;
	  }
      }

  if ( ! zaxisdefined )
    {
      nzaxis = zaxisSize();
      for ( zaxisID = 0; zaxisID < nzaxis; zaxisID++ )
	if ( zaxisCompare(zaxisID, zaxistype, nlevels, lbounds, levels, longname, units, ltype) == 0 )
	  {
	    zaxisglobdefined = 1;
	    break;
	  }

      nzaxis = vlistptr->nzaxis;
      if ( mode == 1 )
	for ( index = 0; index < nzaxis; index++ )
	  if ( vlistptr->zaxisIDs[index] == zaxisID )
	    {
	      zaxisglobdefined = FALSE;
	      break;
	    }
    }

  if ( ! zaxisdefined )
    {
      if ( ! zaxisglobdefined )
	{
	  zaxisID = zaxisCreate(zaxistype, nlevels);
	  zaxisDefLevels(zaxisID, levels);
	  if ( lbounds )
	    {
	      zaxisDefLbounds(zaxisID, levels1);
	      zaxisDefUbounds(zaxisID, levels2);
	    }

	  if ( zaxistype == ZAXIS_HYBRID || zaxistype == ZAXIS_HYBRID_HALF )
	    {
	      /* if ( vctsize > 0 && vctsize >= 2*(nlevels+1)) */
	      /* if ( vctsize > 0 && vctsize >= 2*(nlevels)) */
	      if ( vctsize > 0 )
		zaxisDefVct(zaxisID, vctsize, vct);
	      else
		Warning(func, "VCT missing");
	    }

	  zaxisDefName(zaxisID, name);
	  zaxisDefLongname(zaxisID, longname);
	  zaxisDefUnits(zaxisID, units);
	  zaxisDefPrec(zaxisID, prec);
	  zaxisDefLtype(zaxisID, ltype);
	}

      nzaxis = vlistptr->nzaxis;
      vlistptr->zaxisIDs[nzaxis] = zaxisID;
      vlistptr->nzaxis++;
    }

  return (zaxisID);
}


void varDefMissval(int varID, double missval)
{
  vartable[varID].lmissval = 1;
  vartable[varID].missval = missval;
}


void varDefZtype(int varID, int ztype)
{
  vartable[varID].ztype = ztype;
}


void varDefZlevel(int varID, int zlevel)
{
  vartable[varID].zlevel = zlevel;
}


int varInqInst(int varID)
{
  return (vartable[varID].instID);
}


void varDefInst(int varID, int instID)
{
  vartable[varID].instID = instID;
}


int varInqModel(int varID)
{
  return (vartable[varID].modelID);
}


void varDefModel(int varID, int modelID)
{
  vartable[varID].modelID = modelID;
}


int varInqTable(int varID)
{
  return (vartable[varID].tableID);
}


void varDefTable(int varID, int tableID)
{
  vartable[varID].tableID = tableID;
}
#if defined (HAVE_CONFIG_H)
#endif



static int  VLIST_Debug = 0;   /* If set to 1, debugging */

static int _vlist_min = MIN_VLISTS;
static int _vlist_max = MAX_VLISTS;

static void vlist_initialize(void);

static int _vlist_init = FALSE;
#if  defined  (HAVE_LIBPTHREAD)

static pthread_once_t  _vlist_init_thread = PTHREAD_ONCE_INIT;
static pthread_mutex_t _vlist_mutex;

#  define VLIST_LOCK()         pthread_mutex_lock(&_vlist_mutex)
#  define VLIST_UNLOCK()       pthread_mutex_unlock(&_vlist_mutex)
#  define VLIST_INIT()        \
   if ( _vlist_init == FALSE ) pthread_once(&_vlist_init_thread, vlist_initialize)

#else

#  define VLIST_LOCK()
#  define VLIST_UNLOCK()
#  define VLIST_INIT() 	      \
   if ( _vlist_init == FALSE ) vlist_initialize()

#endif


typedef struct _vlistPtrToIdx {
  int      idx;
  int      next;
  vlist_t *ptr;
} vlistPtrToIdx;


static vlistPtrToIdx *_vlistList  = NULL;
static int            _vlistAvail = -1;

static
void vlist_list_new(void)
{
  static char func[] = "vlist_list_new";

  assert(_vlistList == NULL);

  _vlistList = (vlistPtrToIdx *) malloc(_vlist_min*sizeof(vlistPtrToIdx));
}

static
void vlist_list_delete(void)
{
  static char func[] = "vlist_list_delete";

  if ( _vlistList ) free(_vlistList);
}

static
void vlist_init_pointer(void)
{
  int  i;
  
  for ( i = 0; i < _vlist_min; ++i )
    {
      _vlistList[i].idx  = i;
      _vlistList[i].next = i + 1;
      _vlistList[i].ptr  = NULL;
    }

  _vlistList[_vlist_min-1].next = -1;

  _vlistAvail = 0;
}

static
void vlist_list_extend(void)
{
  static char func[] = "vlist_list_extend";
  int nvlists;
  int i;

  assert(_vlistList != NULL);

  nvlists = _vlist_min + MIN_VLISTS;

  if ( nvlists <= _vlist_max)
    {
      _vlistList = (vlistPtrToIdx *) realloc(_vlistList, nvlists*sizeof(vlistPtrToIdx));
  
      for ( i = _vlist_min; i < nvlists; ++i )
	{
	  _vlistList[i].idx  = i;
	  _vlistList[i].next = i + 1;
	  _vlistList[i].ptr  = NULL;
	}

      _vlistAvail = _vlist_min;
      _vlistList[_vlist_min-1].next = _vlist_min;
      _vlist_min = nvlists;
      _vlistList[_vlist_min-1].next = -1;
    }
  else
    Warning(func, "Too many open vlists (limit is %d)!", _vlist_max);
}


vlist_t *vlist_to_pointer(int idx)
{
  static char func[] = "vlist_to_pointer";
  vlist_t *vlistptr = NULL;

  VLIST_INIT();

  if ( idx >= 0 && idx < _vlist_min )
    {
      VLIST_LOCK();

      vlistptr = _vlistList[idx].ptr;

      VLIST_UNLOCK();
    }
  else
    Error(func, "vlist index %d undefined!", idx);

  return (vlistptr);
}


/* Create an index from a pointer */
static int vlist_from_pointer(vlist_t *ptr)
{
  static char func[] = "vlist_from_pointer";
  int      idx = -1;

  if ( ptr )
    {
      VLIST_LOCK();

      if ( _vlistAvail < 0 ) vlist_list_extend();

      if ( _vlistAvail >= 0 )
	{
	  vlistPtrToIdx *newptr;

	  newptr       = &_vlistList[_vlistAvail];
	  _vlistAvail  = newptr->next;
	  newptr->next = -1;
	  idx	       = newptr->idx;
	  newptr->ptr  = ptr;
      
	  if ( VLIST_Debug )
	    Message(func, "Pointer %p has idx %d from vlist list", ptr, idx);
	}

      VLIST_UNLOCK();
    }
  else
    Error(func, "Internal problem (pointer %p undefined)", ptr);

  return (idx);
}


static void vlist_init_entry(vlist_t *vlistptr)
{
  vlistptr->self           = vlist_from_pointer(vlistptr);

  vlistptr->nlock          = 0;
  vlistptr->nvars          = 0;
  vlistptr->vars           = NULL;
  vlistptr->ngrids         = 0;
  vlistptr->nzaxis         = 0;
  vlistptr->taxisID        = CDI_UNDEFID; 
  vlistptr->instID         = cdiDefaultInstID;
  vlistptr->modelID        = cdiDefaultModelID;
  vlistptr->tableID        = cdiDefaultTableID;
  vlistptr->varsAllocated  = 0;
  vlistptr->ntsteps        = CDI_UNDEFID;
  vlistptr->atts.nalloc    = MAX_ATTRIBUTES;
  vlistptr->atts.nelems    = 0;
}

static
vlist_t *vlist_new_entry(void)
{
  static char func[] = "vlist_new_entry";
  vlist_t *vlistptr;

  vlistptr = (vlist_t *) malloc(sizeof(vlist_t));

  if ( vlistptr ) vlist_init_entry(vlistptr);

  return (vlistptr);
}

static
void vlist_delete_entry(vlist_t *vlistptr)
{
  static char func[] = "vlist_delete_entry";
  int idx;

  idx = vlistptr->self;

  VLIST_LOCK();

  free(vlistptr);

  _vlistList[idx].next = _vlistAvail;
  _vlistList[idx].ptr  = 0;
  _vlistAvail          = idx;

  VLIST_UNLOCK();

  if ( VLIST_Debug )
    Message(func, "Removed idx %d from vlist list", idx);
}

static
void vlist_initialize(void)
{
  char *env;

#if  defined  (HAVE_LIBPTHREAD)
  /* initialize global API mutex lock */
  pthread_mutex_init(&_vlist_mutex, NULL);
#endif

  env = getenv("VLIST_DEBUG");
  if ( env ) VLIST_Debug = atoi(env);

  vlist_list_new();
  atexit(vlist_list_delete);

  VLIST_LOCK();

  vlist_init_pointer();

  VLIST_UNLOCK();

  _vlist_init = TRUE;
}

static
void vlist_copy(vlist_t *vlistptr2, vlist_t *vlistptr1)
{
  int vlistID2;

  vlistID2 = vlistptr2->self;
  memcpy(vlistptr2, vlistptr1, sizeof(vlist_t));
  vlistptr2->atts.nelems = 0;
  vlistptr2->self = vlistID2;
}

static
void vlist_check_ptr(const char *func, vlist_t *vlistptr)
{
  if ( vlistptr == NULL )
    Error(func, "vlist undefined!");
}


/*
@Function  vlistCreate
@Title     Create a variable list

@Prototype int vlistCreate(void)

@Example
Here is an example using @func{vlistCreate} to create a variable list
and add a variable with @func{vlistDefVar}.

@Source
   ...
int vlistID, varID;
   ...
vlistID = vlistCreate();
varID = vlistDefVar(vlistID, gridID, zaxisID, TIME_VARIABLE);
   ...
streamDefVlist(streamID, vlistID);
   ...
vlistDestroy(vlistID);
   ...
@EndSource
@EndFunction
*/
int vlistCreate(void)
{
  static char func[] = "vlistCreate";
  int vlistID = 0;
  vlist_t *vlistptr;

  VLIST_INIT();

  vlistptr = vlist_new_entry();
  if ( ! vlistptr ) Error(func, "No memory");

  vlistID = vlistptr->self;

  if ( vlistID >= 0 ) vlistLock(vlistID);

  return (vlistID);
}


/*
@Function  vlistDestroy
@Title     Destroy a variable list

@Prototype void vlistDestroy(int vlistID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}

@EndFunction
*/
void vlistDestroy(int vlistID)
{
  static char func[] = "vlistDestroy";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  vlistUnlock(vlistID);

  if ( vlistptr->nlock > 0 )
    {
      Warning(func, "vlist %d is locked!", vlistID);
    }
  else
    {
      int nvars = vlistptr->nvars;
      int varID;

      vlistDelAtts(vlistID, CDI_GLOBAL);

      for ( varID = 0; varID < nvars; varID++ )
	{
	  if ( vlistptr->vars[varID].levinfo ) free(vlistptr->vars[varID].levinfo);

	  vlistDelAtts(vlistID, varID);
	}

      if ( vlistptr->vars ) free(vlistptr->vars);

      vlist_delete_entry(vlistptr);
    }
}


int vlistNlock(int vlistID)
{
  static char func[] = "vlistNlock";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  return (vlistptr->nlock);
}


void vlistLock(int vlistID)
{
  static char func[] = "vlistLock";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  vlistptr->nlock++;
  /*  Message(func, "vlistID %d nlock %d", vlistID, vlistptr->nlock); */
}


void vlistUnlock(int vlistID)
{
  static char func[] = "vlistUnlock";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  vlistptr->nlock--;
  /*  Message(func, "vlistID %d nlock %d", vlistID, vlistptr->nlock); */
}


/*
@Function  vlistCopy
@Title     Copy a variable list

@Prototype void vlistCopy(int vlistID2, int vlistID1)
@Parameter
    @Item  vlistID2  Target variable list ID
    @Item  vlistID1  Source variable list ID

@Description
The function @func{vlistCopy} copies all entries from vlistID1 to vlistID2.

@EndFunction
*/
void vlistCopy(int vlistID2, int vlistID1)
{
  static char func[] = "vlistCopy";
  vlist_t *vlistptr1, *vlistptr2;

  vlistptr1 = vlist_to_pointer(vlistID1);
  vlistptr2 = vlist_to_pointer(vlistID2);

  vlist_check_ptr(func, vlistptr1);
  vlist_check_ptr(func, vlistptr2);

  vlist_copy(vlistptr2, vlistptr1);

  vlistCopyVarAtts(vlistID1, CDI_GLOBAL, vlistID2, CDI_GLOBAL);

  if ( vlistptr1->vars )
    {
      int nvars = vlistptr1->nvars;
      int nlevs, varID;

      vlistptr2->vars = (var_t *) malloc(nvars*sizeof(var_t));
      memcpy(vlistptr2->vars, vlistptr1->vars, nvars*sizeof(var_t));

      for ( varID = 0; varID < nvars; varID++ )
	{
	  if ( vlistptr1->vars[varID].name )
	    vlistptr2->vars[varID].name = strdupx(vlistptr1->vars[varID].name);

	  if ( vlistptr1->vars[varID].longname )
	    vlistptr2->vars[varID].longname = strdupx(vlistptr1->vars[varID].longname);

	  if ( vlistptr1->vars[varID].stdname )
	    vlistptr2->vars[varID].stdname = strdupx(vlistptr1->vars[varID].stdname);

	  if ( vlistptr1->vars[varID].units )
	    vlistptr2->vars[varID].units = strdupx(vlistptr1->vars[varID].units);

	  nlevs = vlistptr1->vars[varID].nlevs;
	  vlistptr2->vars[varID].levinfo = (levinfo_t *) malloc(nlevs*sizeof(levinfo_t));
	  memcpy(vlistptr2->vars[varID].levinfo,
		 vlistptr1->vars[varID].levinfo, nlevs*sizeof(levinfo_t));

	  vlistptr2->vars[varID].atts.nelems = 0;
	  vlistCopyVarAtts(vlistID1, varID, vlistID2, varID);
	}
    }

  vlistptr2->nlock = 0;
}


/*
@Function  vlistDuplicate
@Title     Duplicate a variable list

@Prototype int vlistDuplicate(int vlistID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}

@Description
The function @func{vlistDuplicate} duplicates the variable list from vlistID1.

@Result
@func{vlistDuplicate} returns an identifier to the duplicated variable list.

@EndFunction
*/
int vlistDuplicate(int vlistID)
{
  static char func[] = "vlistDuplicate";
  int vlistIDnew;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  vlistIDnew = vlistCreate();

  vlistCopy(vlistIDnew, vlistID);

  return (vlistIDnew);
}


void vlistClearFlag(int vlistID)
{
  int varID, levID;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  for ( varID = 0; varID < vlistptr->nvars; varID++ )
    {
      vlistptr->vars[varID].flag = FALSE;
      for ( levID = 0; levID < vlistptr->vars[varID].nlevs; levID++ )
	{
	  vlistptr->vars[varID].levinfo[levID].flag = FALSE;
	}
    }
}


int vlistInqZaxis(int vlistID, int zaxistype, int nlevels, double *levels, int lbounds, double *levels2,
		  int vctsize, const double *vct)
{
  static char func[] = "vlistInqZaxis";
  int zaxisdefined;
  int nzaxis;
  int zaxisID = CDI_UNDEFID;
  int index;
  int zaxisglobdefined = 0;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  zaxisdefined = 0;
  nzaxis = vlistptr->nzaxis;

  for ( index = 0; index < nzaxis; index++ )
    {
      zaxisID = vlistptr->zaxisIDs[index];

      if ( zaxisCompare(zaxisID, zaxistype, nlevels, lbounds, levels, NULL, NULL, 0) == 0 )
	{
	  zaxisdefined = 1;
	  break;
	}
    }

  if ( ! zaxisdefined )
    {
      nzaxis = zaxisSize();
      for ( zaxisID = 0; zaxisID < nzaxis; zaxisID++ )
	if ( zaxisCompare(zaxisID, zaxistype, nlevels, lbounds, levels, NULL, NULL, 0) == 0 )
	  {
	    zaxisglobdefined = 1;
	    break;
	  }
    }

  if ( ! zaxisdefined )
    {
      if ( ! zaxisglobdefined )
	{
	  zaxisID = zaxisCreate(zaxistype, nlevels);
	  zaxisDefLevels(zaxisID, levels);
	  if ( lbounds )
	    {
	      zaxisDefLbounds(zaxisID, levels);
	      zaxisDefUbounds(zaxisID, levels2);
	    }

	  if ( zaxistype == ZAXIS_HYBRID )
	    {
	      if ( vctsize > 0 )
		zaxisDefVct(zaxisID, vctsize, vct);
	      else
		Warning(func, "VCT missing");
	    }
	}

      nzaxis = vlistptr->nzaxis;
      vlistptr->zaxisIDs[nzaxis] = zaxisID;
      vlistptr->nzaxis++;
    }

  return (zaxisID);
}


/*
@Function  vlistCopyFlag
@Title     Copy some entries of a variable list

@Prototype void vlistCopyFlag(int vlistID2, int vlistID1)
@Parameter
    @Item  vlistID2  Target variable list ID
    @Item  vlistID1  Source variable list ID

@Description
The function @func{vlistCopyFlag} copies all entries with a flag from vlistID1 to vlistID2.

@EndFunction
*/
void vlistCopyFlag(int vlistID2, int vlistID1)
{
  static char func[] = "vlistCopyFlag";
  vlist_t *vlistptr1, *vlistptr2;

  vlistptr1 = vlist_to_pointer(vlistID1);
  vlistptr2 = vlist_to_pointer(vlistID2);

  vlist_check_ptr(func, vlistptr1);
  vlist_check_ptr(func, vlistptr2);

  vlist_copy(vlistptr2, vlistptr1);
  
  vlistCopyVarAtts(vlistID1, CDI_GLOBAL, vlistID2, CDI_GLOBAL);

  if ( vlistptr1->vars )
    {
      int nvars = vlistptr1->nvars;
      int nvars2 = 0, levID2;
      int nlevs, nlevs2, levID, varID, varID2;
      int gridID, zaxisID;
      int index;

      vlistptr2->ngrids = 0;
      vlistptr2->nzaxis = 0;

      for ( varID = 0; varID < nvars; varID++ )
	if ( vlistptr1->vars[varID].flag ) nvars2++;

      vlistptr2->nvars = nvars2;
      if ( nvars2 > 0 )
	vlistptr2->vars  = (var_t *) malloc(nvars2*sizeof(var_t));
      else
	vlistptr2->vars  = NULL;

      varID2 = 0;
      for ( varID = 0; varID < nvars; varID++ )
	if ( vlistptr1->vars[varID].flag )
	  {
	    vlistptr2->vars[varID2].flag = FALSE;
	    zaxisID = vlistptr1->vars[varID].zaxisID;
	    gridID  = vlistptr1->vars[varID].gridID;

	    memcpy(&vlistptr2->vars[varID2], &vlistptr1->vars[varID], sizeof(var_t));

	    vlistptr1->vars[varID].fvarID = varID2;
	    vlistptr2->vars[varID2].fvarID = varID;

	    vlistptr2->vars[varID2].mvarID = varID2;

	    if ( vlistptr1->vars[varID].name )
	      vlistptr2->vars[varID2].name = strdupx(vlistptr1->vars[varID].name);

	    if ( vlistptr1->vars[varID].longname )
	      vlistptr2->vars[varID2].longname = strdupx(vlistptr1->vars[varID].longname);

	    if ( vlistptr1->vars[varID].stdname )
	      vlistptr2->vars[varID2].stdname = strdupx(vlistptr1->vars[varID].stdname);

	    if ( vlistptr1->vars[varID].units )
	      vlistptr2->vars[varID2].units = strdupx(vlistptr1->vars[varID].units);

	    nlevs  = vlistptr1->vars[varID].nlevs;
	    nlevs2 = 0;
	    for ( levID = 0; levID < nlevs; levID++ )
	      if ( vlistptr1->vars[varID].levinfo[levID].flag ) nlevs2++;

	    vlistptr2->vars[varID2].levinfo = (levinfo_t *) malloc(nlevs2*sizeof(levinfo_t));

	    vlistptr2->vars[varID2].atts.nelems = 0;
	    vlistCopyVarAtts(vlistID1, varID, vlistID2, varID2);

	    if ( nlevs != nlevs2 )
	      {
		int zaxisType;
		int zaxisID2;
		int nvct = 0;
		int lbounds;
		double *levels;
		double *levels2;
		const double *vct = NULL;

		zaxisID = vlistptr1->vars[varID].zaxisID;
		levels = (double *) malloc(nlevs2*sizeof(double));
		levID2 = 0;
		for ( levID = 0; levID < nlevs; levID++ )
		  if ( vlistptr1->vars[varID].levinfo[levID].flag )
		    {
		      vlistptr1->vars[varID].levinfo[levID].flevelID = levID2;
		      vlistptr1->vars[varID].levinfo[levID].mlevelID = levID2;
		      levels[levID2++] = zaxisInqLevel(zaxisID, levID);
		    }

		zaxisType = zaxisInqType(zaxisID);

		if ( zaxisType == ZAXIS_HYBRID )
		  {
		    nvct = zaxisInqVctSize(zaxisID);
		    vct  = zaxisInqVctPtr(zaxisID);
		  }
		lbounds = 0;     /* <------------ have to define */
		levels2 = NULL;  /* <------------ have to define */
		zaxisID2 = vlistInqZaxis(vlistID2, zaxisType, nlevs2, levels, lbounds, levels2, nvct, vct);

		free(levels);
		zaxisID = zaxisID2;
		vlistptr2->vars[varID2].zaxisID = zaxisID2;
		vlistptr2->vars[varID2].nlevs   = nlevs2;
	      }

	    for ( levID = 0; levID < nlevs2; levID++ )
	      {
		vlistptr2->vars[varID2].levinfo[levID].flag  = FALSE;
		vlistptr2->vars[varID2].levinfo[levID].index = -1;
	      }

	    levID2 = 0;
	    for ( levID = 0; levID < nlevs; levID++ )
	      if ( vlistptr1->vars[varID].levinfo[levID].flag )
		{
		  vlistptr2->vars[varID2].levinfo[levID2].flevelID = levID;
		  vlistptr2->vars[varID2].levinfo[levID2].mlevelID = levID;
		  levID2++;
		}

	    for ( index = 0; index <vlistptr2->ngrids; index++ )
	      if (vlistptr2->gridIDs[index] == gridID ) break;

	    if ( index ==vlistptr2->ngrids )
	      {
		vlistptr2->gridIDs[vlistptr2->ngrids++] = gridID;
		if (vlistptr2->ngrids >= MAX_GRIDS_PS )
		  Error(func, "Internal Problem! More than %d grids.", MAX_GRIDS_PS);
	      }

	    for ( index = 0; index <vlistptr2->nzaxis; index++ )
	      if (vlistptr2->zaxisIDs[index] == zaxisID ) break;

	    if ( index ==vlistptr2->nzaxis )
	      {
		vlistptr2->zaxisIDs[vlistptr2->nzaxis++] = zaxisID;
		if (vlistptr2->nzaxis >= MAX_ZAXES_PS )
		  Error(func, "Internal Problem! More than %d zaxis.", MAX_ZAXES_PS);
	      }

	    varID2++;
	  }
    }
}


/*
@Function  vlistCat
@Title     Concatenate two variable lists

@Prototype void vlistCat(int vlistID2, int vlistID1)
@Parameter
    @Item  vlistID2  Target variable list ID
    @Item  vlistID1  Source variable list ID

@Description
Concatenate the variable list vlistID1 at the end of vlistID2.

@EndFunction
*/
void vlistCat(int vlistID2, int vlistID1)
{
  static char func[] = "vlistCat";
  int nvars, nvars1, nvars2;
  int varID, varID2, nlevs;
  int index, gridID, zaxisID;
  vlist_t *vlistptr1, *vlistptr2;

  vlistptr1 = vlist_to_pointer(vlistID1);
  vlistptr2 = vlist_to_pointer(vlistID2);

  vlist_check_ptr(func, vlistptr1);
  vlist_check_ptr(func, vlistptr2);

  nvars1 = vlistptr1->nvars;
  nvars2 = vlistptr2->nvars;
  nvars = nvars1 + nvars2;
  vlistptr2->nvars = nvars;

  vlistptr2->vars = (var_t *) realloc(vlistptr2->vars, nvars*sizeof(var_t));
  memcpy(vlistptr2->vars+nvars2, vlistptr1->vars, nvars1*sizeof(var_t));

  for ( varID = 0; varID < nvars1; varID++ )
    {
      varID2 = varID + nvars2;
      vlistptr1->vars[varID].fvarID = varID2;
      vlistptr2->vars[varID2].fvarID = varID;

      vlistptr1->vars[varID].mvarID = varID2;
      vlistptr2->vars[varID2].mvarID = varID;

      if ( vlistptr1->vars[varID].param < 0 )
	{
	  int pnum, pcat, pdis;
	  cdiDecodeParam(vlistptr1->vars[varID].param, &pnum, &pcat, &pdis);
	  pnum=-(varID2+1);
	  vlistptr2->vars[varID2].param = cdiEncodeParam(pnum, pcat, pdis);
	}

      if ( vlistptr1->vars[varID].name )
	vlistptr2->vars[varID2].name = strdupx(vlistptr1->vars[varID].name);

      if ( vlistptr1->vars[varID].longname )
	vlistptr2->vars[varID2].longname = strdupx(vlistptr1->vars[varID].longname);

      if ( vlistptr1->vars[varID].stdname )
	vlistptr2->vars[varID2].stdname = strdupx(vlistptr1->vars[varID].stdname);

      if ( vlistptr1->vars[varID].units )
	vlistptr2->vars[varID2].units = strdupx(vlistptr1->vars[varID].units);

      nlevs = vlistptr1->vars[varID].nlevs;
      vlistptr2->vars[varID2].levinfo = (levinfo_t *) malloc(nlevs*sizeof(levinfo_t));
      memcpy(vlistptr2->vars[varID2].levinfo, vlistptr1->vars[varID].levinfo, nlevs*sizeof(levinfo_t));

      vlistptr2->vars[varID2].atts.nelems = 0;
      vlistCopyVarAtts(vlistID1, varID, vlistID2, varID2);

      gridID = vlistptr1->vars[varID].gridID;
      for ( index = 0; index < vlistptr2->ngrids; index++ )
	if ( gridID == vlistptr2->gridIDs[index] ) break;

      if ( index == vlistptr2->ngrids )
	{
	  vlistptr2->gridIDs[vlistptr2->ngrids++] = gridID;
	  if ( vlistptr2->ngrids >= MAX_GRIDS_PS )
	    Error(func, "Internal Problem! More than %d grids.", MAX_GRIDS_PS);
	}

      zaxisID = vlistptr1->vars[varID].zaxisID;
      for ( index = 0; index < vlistptr2->nzaxis; index++ )
	if ( zaxisID == vlistptr2->zaxisIDs[index] ) break;

      if ( index == vlistptr2->nzaxis )
	{
	  vlistptr2->zaxisIDs[vlistptr2->nzaxis++] = zaxisID;
	  if ( vlistptr2->nzaxis >= MAX_ZAXES_PS )
	    Error(func, "Internal Problem! More than %d zaxis.", MAX_ZAXES_PS);
	}
    }
}


/*
@Function  vlistMerge
@Title     Merge two variable lists

@Prototype void vlistMerge(int vlistID2, int vlistID1)
@Parameter
    @Item  vlistID2  Target variable list ID
    @Item  vlistID1  Source variable list ID

@Description
Merge the variable list vlistID1 to the variable list vlistID2.

@EndFunction
*/
void vlistMerge(int vlistID2, int vlistID1)
{
  static char func[] = "vlistMerge";
  int nvars1, nvars2;
  int varID = 0, varID2, levID, nlevs, nlevs1, nlevs2;
  int index, zaxisID;
  int zaxisID1, zaxisID2;
  int *lvar;
  double *levels;
  vlist_t *vlistptr1, *vlistptr2;

  vlistptr1 = vlist_to_pointer(vlistID1);
  vlistptr2 = vlist_to_pointer(vlistID2);

  vlist_check_ptr(func, vlistptr1);
  vlist_check_ptr(func, vlistptr2);

  nvars1 = vlistptr1->nvars;
  nvars2 = vlistptr2->nvars;

  if ( nvars1 == nvars2 )
    {
      for ( varID = 0; varID < nvars2; varID++ )
	{
	  if ( vlistptr1->vars[varID].name && vlistptr2->vars[varID].name )
	    {
	      if ( strcmp(vlistptr1->vars[varID].name,
			  vlistptr2->vars[varID].name) != 0 ) break;
	    }
	  else
	    {
	      if ( vlistptr1->vars[varID].param != vlistptr2->vars[varID].param )
		break;
	    }
	}
    }

  if ( varID == nvars2 ) /* same variables in vlistID1 and vlistID2 */
    {
      for ( varID = 0; varID < nvars2; varID++ )
	{
	  vlistptr1->vars[varID].fvarID = varID;
	  vlistptr2->vars[varID].fvarID = varID;

	  vlistptr1->vars[varID].mvarID = varID;
	  vlistptr2->vars[varID].mvarID = varID;

	  nlevs1 = vlistptr1->vars[varID].nlevs;
	  nlevs2 = vlistptr2->vars[varID].nlevs;

	  nlevs = nlevs1 + nlevs2;

	  vlistptr2->vars[varID].nlevs = nlevs;
	  /*
	  fprintf(stderr, "var %d %d %d %d %d\n", varID, nlevs1, nlevs2, nlevs, sizeof(levinfo_t));
	  */
	  vlistptr2->vars[varID].levinfo =
	    (levinfo_t *) realloc(vlistptr2->vars[varID].levinfo, nlevs*sizeof(levinfo_t));

	  memcpy(vlistptr2->vars[varID].levinfo+nlevs2,
		 vlistptr1->vars[varID].levinfo, nlevs1*sizeof(levinfo_t));

	  for ( levID = 0; levID < nlevs1; levID++ )
	    {
	      vlistptr1->vars[varID].levinfo[levID].mlevelID = nlevs2 + levID;
	    }
	}

      lvar = (int *) malloc(nvars2*sizeof(int));
      for ( varID = 0; varID < nvars2; varID++ ) lvar[varID] = FALSE;

      for ( varID = 0; varID < nvars2; varID++ )
	{
	  if ( lvar[varID] == TRUE ) continue;

	  zaxisID1 = vlistptr1->vars[varID].zaxisID;
	  zaxisID2 = vlistptr2->vars[varID].zaxisID;
	  /*
	  nlevs1 = vlistptr1->vars[varID].nlevs;
	  nlevs2 = vlistptr2->vars[varID].nlevs;
	  */
	  nlevs1 = zaxisInqSize(zaxisID1);
	  nlevs2 = zaxisInqSize(zaxisID2);
	  /*
	  fprintf(stderr, "zaxis %d %d %d %d\n", zaxisID1, zaxisID2, nlevs1, nlevs2);
	  */
	  nlevs = nlevs1 + nlevs2;

	  zaxisID = zaxisDuplicate(zaxisID2);

	  zaxisResize(zaxisID, nlevs);

	  levels = (double *) malloc(nlevs1*sizeof(double));

	  zaxisInqLevels(zaxisID1, levels);
	  /*
	  for ( levID = 0; levID < nlevs1; levID++ )
	    fprintf(stderr, "%d %d %d %d %d %g\n", varID, levID, nlevs1, nlevs2, vlistptr2->vars[varID].nlevs, levels[levID]);
	  */
	  for ( levID = 0; levID < nlevs1; levID++ )
	    zaxisDefLevel(zaxisID, nlevs2+levID, levels[levID]);

	  free(levels);

	  for ( index = 0; index < vlistptr2->nzaxis; index++ )
	    if ( vlistptr2->zaxisIDs[index] == zaxisID2 )
	      vlistptr2->zaxisIDs[index] = zaxisID;

	  for ( varID2 = 0; varID2 < nvars2; varID2++ )
	    if ( lvar[varID2] == FALSE && vlistptr2->vars[varID2].zaxisID == zaxisID2 )
	      {
		vlistptr2->vars[varID2].zaxisID = zaxisID;
		lvar[varID2] = TRUE;
	      }
	}

      free(lvar);
    }
  else
    {
      vlistCat(vlistID2, vlistID1);
    }
}


/*
@Function  vlistNvars
@Title     Number of variables in a variable list

@Prototype int vlistNvars(int vlistID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}

@Description
The function @func{vlistNvars} returns the number of variables in the variable list vlistID.

@Result
@func{vlistNvars} returns the number of variables in a variable list.

@EndFunction
*/
int vlistNvars(int vlistID)
{
  static char func[] = "vlistNvars";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  return (vlistptr->nvars);
}


int vlistNrecs(int vlistID)
{
  static char func[] = "vlistNrecs";
  int varID, nrecs = 0;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  for ( varID = 0; varID < vlistptr->nvars; varID++ )
    nrecs +=  vlistptr->vars[varID].nlevs;

  return (nrecs);
}


int vlistNumber(int vlistID)
{
  static char func[] = "vlistNumber";
  int varID, number, number2, datatype;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  datatype = vlistptr->vars[0].datatype;
  if (  datatype== DATATYPE_CPX32 || datatype == DATATYPE_CPX64 )
    number = CDI_COMP;
  else
    number = CDI_REAL;

  for ( varID = 1; varID < vlistptr->nvars; varID++ )
    {
      datatype = vlistptr->vars[varID].datatype;
      if ( datatype == DATATYPE_CPX32 || datatype == DATATYPE_CPX64 )
	number2 = CDI_COMP;
      else
	number2 = CDI_REAL;

      if ( number2 != number )
	{
	  number = CDI_BOTH;
	  break;
	}
    }

  return (number);
}


/*
@Function  vlistNgrids
@Title     Number of grids in a variable list

@Prototype int vlistNgrids(int vlistID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}

@Description
The function @func{vlistNgrids} returns the number of grids in the variable list vlistID.

@Result
@func{vlistNgrids} returns the number of grids in a variable list.

@EndFunction
*/
int vlistNgrids(int vlistID)
{
  static char func[] = "vlistNgrids";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  return (vlistptr->ngrids);
}


/*
@Function  vlistNzaxis
@Title     Number of zaxis in a variable list

@Prototype int vlistNzaxis(int vlistID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}

@Description
The function @func{vlistNzaxis} returns the number of zaxis in the variable list vlistID.

@Result
@func{vlistNzaxis} returns the number of zaxis in a variable list.

@EndFunction
*/
int vlistNzaxis(int vlistID)
{
  static char func[] = "vlistNzaxis";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  return (vlistptr->nzaxis);
}


void vlistDefNtsteps(int vlistID, int nts)
{
  static char func[] = "vlistDefNtsteps";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  vlistptr->ntsteps = nts;
}


int vlistNtsteps(int vlistID)
{
  static char func[] = "vlistNtsteps";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  return (vlistptr->ntsteps);
}


void vlistPrint(int vlistID)
{
  static char func[] = "vlistPrint";
  int nvars, flag, index;
  int varID, fvarID, mvarID, flevID, mlevID, levID;
  int param, gridID, zaxisID, timeID, nlevs;
  int dtype;
  char paramstr[32];
  char *name, *longname, *units;
  double level;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  printf("#\n# vlistID %d\n#\n", vlistID);

  if ( vlistID == CDI_UNDEFID ) return;

  nvars = vlistptr->nvars;

  printf("nvars   %d\n", nvars);
  printf("ngrids  %d\n", vlistptr->ngrids);
  printf("nzaxis  %d\n", vlistptr->nzaxis);
  printf("taxisID %d\n", vlistptr->taxisID);
  printf("instID  %d\n", vlistptr->instID);
  printf("modelID %d\n", vlistptr->modelID);
  printf("tableID %d\n", vlistptr->tableID);

  if ( nvars > 0 )
    {
      printf(" varID param    gridID zaxisID timeID nlevel flag  name     longname\n");
      for ( varID = 0; varID < nvars; varID++ )
	{
	  param    = vlistptr->vars[varID].param;
	  gridID   = vlistptr->vars[varID].gridID;
	  zaxisID  = vlistptr->vars[varID].zaxisID;
	  timeID   = vlistptr->vars[varID].timeID;
	  nlevs    = vlistptr->vars[varID].nlevs;
	  name     = vlistptr->vars[varID].name;
	  longname = vlistptr->vars[varID].longname;
	  units    = vlistptr->vars[varID].units;
	  flag     = vlistptr->vars[varID].flag;

	  cdiParamToString(param, paramstr, sizeof(paramstr));
	  printf("%6d %-8s %6d %6d %6d %6d %5d  %-8s %s",
		 varID, paramstr, gridID, zaxisID, timeID, nlevs, flag,
		 name ? name : "", longname ? longname : "");
	  if ( units ) printf("   [%s]", units);
	  printf("\n");
	}

      printf("\n");
      printf(" varID  levID fvarID flevID mvarID mlevID  index  dtype  flag  level\n");
      for ( varID = 0; varID < nvars; varID++ )
	{
	  nlevs    = vlistptr->vars[varID].nlevs;
	  zaxisID  = vlistptr->vars[varID].zaxisID;
	  fvarID   = vlistptr->vars[varID].fvarID;
	  mvarID   = vlistptr->vars[varID].mvarID;
	  dtype    = vlistptr->vars[varID].datatype;
	  for ( levID = 0; levID < nlevs; levID++ )
	    {
	      flevID = vlistptr->vars[varID].levinfo[levID].flevelID;
	      mlevID = vlistptr->vars[varID].levinfo[levID].mlevelID;
	      index  = vlistptr->vars[varID].levinfo[levID].index;
	      flag   = vlistptr->vars[varID].levinfo[levID].flag;
	      level  = zaxisInqLevel(zaxisID, levID);
	      printf("%6d %6d %6d %6d %6d %6d %6d %6d %5d  %.9g\n",
		     varID, levID, fvarID, flevID, mvarID, mlevID, index, dtype, flag, level);
	    }
	}
    }
}


/*
@Function  vlistDefTaxis
@Title     Define the time axis

@Prototype void vlistDefTaxis(int vlistID, int taxisID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  taxisID  Time axis ID, from a previous call to @fref{taxisCreate}

@Description
The function @func{vlistDefTaxis} defines the time axis of a variable list.

@EndFunction
*/
void vlistDefTaxis(int vlistID, int taxisID)
{
  static char func[] = "vlistDefTaxis";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  vlistptr->taxisID = taxisID;
}


/*
@Function  vlistInqTaxis
@Title     Get the time axis

@Prototype int vlistInqTaxis(int vlistID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}

@Description
The function @func{vlistInqTaxis} returns the time axis of a variable list.

@Result
@func{vlistInqTaxis} returns an identifier to the time axis.

@EndFunction
*/
int vlistInqTaxis(int vlistID)
{
  static char func[] = "vlistInqTaxis";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  return (vlistptr->taxisID);
}

void  vlistDefTable(int vlistID, int tableID)
{
  static char func[] = "vlistDefTable";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  vlistptr->tableID = tableID;
}

int vlistInqTable(int vlistID)
{
  static char func[] = "vlistInqTable";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  return (vlistptr->tableID);
}

void vlistDefInstitut(int vlistID, int instID)
{
  static char func[] = "vlistDefInstitut";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  vlistptr->instID = instID;
}

int vlistInqInstitut(int vlistID)
{
  static char func[] = "vlistInqInstitut";
  int varID, instID;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  instID = vlistptr->instID;

  if ( instID == CDI_UNDEFID )
    {
      instID  = vlistInqVarInstitut(vlistID, 0);

      for ( varID = 1; varID < vlistptr->nvars; varID++ )
	if ( instID != vlistInqVarInstitut(vlistID, varID) )
	  {
	    instID = CDI_UNDEFID;
	    break;
      }
      
      vlistDefInstitut(vlistID, instID);
    }

  return (instID);
}

void vlistDefModel(int vlistID, int modelID)
{
  static char func[] = "vlistDefModel";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  vlistptr->modelID = modelID;
}

int vlistInqModel(int vlistID)
{
  static char func[] = "vlistInqModel";
  int varID, modelID;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  modelID = vlistptr->modelID;

  if ( modelID == CDI_UNDEFID )
    {
      modelID = vlistInqVarModel(vlistID, 0);

      for ( varID = 1; varID < vlistptr->nvars; varID++ )
	if ( modelID != vlistInqVarModel(vlistID, varID) )
	  {
	    modelID = CDI_UNDEFID;
	    break;
	  }

      vlistDefModel(vlistID, modelID);
    }

  return (modelID);
}

int vlistGridsizeMax(int vlistID)
{
  static char func[] = "vlistGridsizeMax";
  int gridsize, gridsizemax = 0;
  int gridID, index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  for ( index = 0 ; index < vlistptr->ngrids ; index++ )
    {
      gridID = vlistptr->gridIDs[index];
      gridsize = gridInqSize(gridID);
      if ( gridsize > gridsizemax ) gridsizemax = gridsize;
    }
  
  return (gridsizemax);
}

int vlistGrid(int vlistID, int index)
{
  static char func[] = "vlistGrid";
  int gridID = CDI_UNDEFID;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  if ( index < vlistptr->ngrids && index >= 0 )
    gridID = vlistptr->gridIDs[index];
  
  return (gridID);
}


int vlistGridIndex(int vlistID, int gridID)
{
  static char func[] = "vlistGridIndex";
  int index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  for ( index = 0 ; index < vlistptr->ngrids ; index++ )
    if ( gridID == vlistptr->gridIDs[index] ) break;

  if ( index == vlistptr->ngrids ) index = -1;
  
  return (index);
}


void vlistChangeGridIndex(int vlistID, int index, int gridID)
{
  static char func[] = "vlistChangeGridIndex";
  int gridIDold;
  int varID, nvars;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  gridIDold = vlistptr->gridIDs[index];
  vlistptr->gridIDs[index] = gridID;

  nvars = vlistptr->nvars;
  for ( varID = 0; varID < nvars; varID++ )
    if ( vlistptr->vars[varID].gridID == gridIDold )
      vlistptr->vars[varID].gridID = gridID;
}


void vlistChangeGrid(int vlistID, int gridID1, int gridID2)
{
  static char func[] = "vlistChangeGrid";
  int varID, nvars;
  int index, ngrids;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  ngrids = vlistptr->ngrids;
  for ( index = 0; index < ngrids; index++ )
    {
      if ( vlistptr->gridIDs[index] == gridID1 )
	{
	  vlistptr->gridIDs[index] = gridID2;
	  break;
	}
    }

  nvars = vlistptr->nvars;
  for ( varID = 0; varID < nvars; varID++ )
    if ( vlistptr->vars[varID].gridID == gridID1 )
      vlistptr->vars[varID].gridID = gridID2;
}


int vlistZaxis(int vlistID, int index)
{
  static char func[] = "vlistZaxis";
  int zaxisID = CDI_UNDEFID;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  if ( index < vlistptr->nzaxis && index >= 0 )
    zaxisID = vlistptr->zaxisIDs[index];
  
  return (zaxisID);
}

int vlistZaxisIndex(int vlistID, int zaxisID)
{
  static char func[] = "vlistZaxisIndex";
  int index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  for ( index = 0 ; index < vlistptr->nzaxis ; index++ )
    if ( zaxisID == vlistptr->zaxisIDs[index] ) break;

  if ( index == vlistptr->nzaxis ) index = -1;
  
  return (index);
}

void vlistChangeZaxisIndex(int vlistID, int index, int zaxisID)
{
  static char func[] = "vlistChangeZaxisIndex";
  int zaxisIDold;
  int varID, nvars;
  int nlevs, levID;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  zaxisIDold = vlistptr->zaxisIDs[index];
  vlistptr->zaxisIDs[index] = zaxisID;

  nvars = vlistptr->nvars;
  for ( varID = 0; varID < nvars; varID++ )
    if ( vlistptr->vars[varID].zaxisID == zaxisIDold )
      {
	vlistptr->vars[varID].zaxisID = zaxisID;

	nlevs = zaxisInqSize(zaxisID);
	if ( nlevs != vlistptr->vars[varID].nlevs )
	  {
	    vlistptr->vars[varID].nlevs   = nlevs;
	    vlistptr->vars[varID].levinfo = (levinfo_t *) realloc(vlistptr->vars[varID].levinfo,
								     nlevs*sizeof(levinfo_t));

	    for ( levID = 0; levID < nlevs; levID++ )
	      {
		vlistptr->vars[varID].levinfo[levID].flevelID = levID;
		vlistptr->vars[varID].levinfo[levID].mlevelID = levID;
		vlistptr->vars[varID].levinfo[levID].index    = -1;
		vlistptr->vars[varID].levinfo[levID].flag     = FALSE;
	      }
	  }
      }
}

void vlistChangeZaxis(int vlistID, int zaxisID1, int zaxisID2)
{
  static char func[] = "vlistChangeZaxis";
  int varID, nvars;
  int index, nzaxis;
  int nlevs, levID;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  nzaxis = vlistptr->nzaxis;
  for ( index = 0; index < nzaxis; index++ )
    {
      if ( vlistptr->zaxisIDs[index] == zaxisID1 )
	{
	  vlistptr->zaxisIDs[index] = zaxisID2;
	  break;
	}
    }

  nvars = vlistptr->nvars;
  for ( varID = 0; varID < nvars; varID++ )
    if ( vlistptr->vars[varID].zaxisID == zaxisID1 )
      {
	vlistptr->vars[varID].zaxisID = zaxisID2;

	nlevs = zaxisInqSize(zaxisID2);
	if ( nlevs != vlistptr->vars[varID].nlevs )
	  {
	    vlistptr->vars[varID].nlevs   = nlevs;
	    vlistptr->vars[varID].levinfo = (levinfo_t *) realloc(vlistptr->vars[varID].levinfo,
								     nlevs*sizeof(levinfo_t));

	    for ( levID = 0; levID < nlevs; levID++ )
	      {
		vlistptr->vars[varID].levinfo[levID].flevelID = levID;
		vlistptr->vars[varID].levinfo[levID].mlevelID = levID;
		vlistptr->vars[varID].levinfo[levID].index    = -1;
		vlistptr->vars[varID].levinfo[levID].flag     = FALSE;
	      }
	  }
      }
}


int vlistHasTime(int vlistID)
{
  static char func[] = "vlistHasTime";
  int varID;
  int hastime = FALSE;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlist_check_ptr(func, vlistptr);

  for ( varID = 0; varID <  vlistptr->nvars; varID++ )
    if ( vlistptr->vars[varID].timeID == TIME_VARIABLE )
      {
	hastime = TRUE;
	break;
      }

  return (hastime);
}





static
cdi_atts_t *get_attsp(vlist_t *vlistptr, int varID)
{
  static char func[] = "get_attsp";
  cdi_atts_t *attsp = NULL;

  if ( varID == CDI_GLOBAL )
    {
      attsp = &vlistptr->atts;
    }
  else
    {
      if ( varID >= 0 && varID < vlistptr->nvars )
	attsp = &(vlistptr->vars[varID].atts);
    }

  return (attsp);
}


static
cdi_att_t *find_att(cdi_atts_t *attsp, const char *name)
{
  cdi_att_t *attp;
  size_t attid;
  size_t slen;

  assert(attsp != NULL);

  if ( attsp->nelems == 0 ) return NULL;

  slen = strlen(name);

  for ( attid = 0; attid < attsp->nelems; attid++ )
    {
      attp = &(attsp->value[attid]);
      if ( attp->namesz == slen )
	if ( memcmp(attp->name, name, slen) == 0)
	  {
	    return (attp); /* Normal return */
	  }
    }

  return (NULL);
}


static
cdi_att_t *new_att(cdi_atts_t *attsp, const char *name)
{
  static char func[] = "new_att";
  cdi_att_t *attp;
  size_t slen;

  assert(attsp != NULL);
  assert(name  != NULL);

  if ( attsp->nelems == attsp->nalloc ) return (NULL);

  attp = &(attsp->value[attsp->nelems]);
  attsp->nelems++;

  slen = strlen(name);

  attp->name = (char *) malloc(slen+1);
  memcpy(attp->name, name, slen+1);
  attp->namesz = slen;
  attp->xvalue = NULL;

  return (attp);
}


static
void fill_att(cdi_att_t *attp, int type, size_t nelems, size_t xsz, const void *xvalue)
{
  static char func[] = "fill_att";

  assert(attp != NULL);

  attp->xsz = xsz;
  attp->type = type;
  attp->nelems = nelems;

  if ( xsz > 0 )
    {
      attp->xvalue = (void *) realloc(attp->xvalue, xsz);
      memcpy(attp->xvalue, xvalue, xsz);
    }
}


/*
@Function  vlistInqNatts
@Title     Get number of variable attributes

@Prototype int vlistInqNatts(int vlistID, int varID, int *nattsp)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier, or CDI_GLOBAL for a global attribute
    @Item  nattsp   Pointer to location for returned number of variable attributes

@Description
The function @func{vlistInqNatts} gets the number of variable attributes assigned to this variable.

@EndFunction
*/
int vlistInqNatts(int vlistID, int varID, int *nattsp)
{
  static char func[] = "vlistInqNatts";
  int status = CDI_NOERR;
  vlist_t *vlistptr;
  cdi_atts_t *attsp;

  vlistptr = vlist_to_pointer(vlistID);
  
  attsp = get_attsp(vlistptr, varID);
  assert(attsp != NULL);

  *nattsp = attsp->nelems;

  return (status);
}


/*
@Function  vlistInqAtt
@Title     Get information about an attribute

@Prototype int vlistInqAtt(int vlistID, int varID, int attnum, char *name, int *typep, int *lenp)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier, or CDI_GLOBAL for a global attribute
    @Item  attnum   Attribute number (from 0 to natts-1)
    @Item  name     Pointer to the location for the returned attribute name
    @Item  typep    Pointer to location for returned attribute type
    @Item  lenp     Pointer to location for returned attribute number

@Description
The function @func{vlistInqNatts} gets information about an attribute.

@EndFunction
*/
int vlistInqAtt(int vlistID, int varID, int attnum, char *name, int *typep, int *lenp)
{
  static char func[] = "vlistInqAtt";
  int status = CDI_NOERR;
  vlist_t *vlistptr;
  cdi_att_t *attp = NULL;
  cdi_atts_t *attsp;

  assert(name != NULL);

  vlistptr = vlist_to_pointer(vlistID);

  attsp = get_attsp(vlistptr, varID);
  assert(attsp != NULL);

  if ( attnum >= 0 && attnum < (int)attsp->nelems )
    attp = &(attsp->value[attnum]);

  if ( attp != NULL ) /* name in use */
    {
      memcpy(name, attp->name, attp->namesz+1);
      *typep  = attp->type;
      *lenp   = attp->nelems;
    }
  else
    {
      name[0] =  0;
      *typep  = -1;
      *lenp   =  0;
    }

  return (status);
}


int vlistDelAtts(int vlistID, int varID)
{
  static char func[] = "vlistDelAtts";
  int status = CDI_NOERR;
  vlist_t *vlistptr;
  cdi_att_t *attp = NULL;
  cdi_atts_t *attsp;
  int attid;

  vlistptr = vlist_to_pointer(vlistID);

  attsp = get_attsp(vlistptr, varID);
  assert(attsp != NULL);

  for ( attid = 0; attid < (int)attsp->nelems; attid++ )
    {
      attp = &(attsp->value[attid]);
      if ( attp->name   ) free(attp->name);
      if ( attp->xvalue ) free(attp->xvalue);
    }

  attsp->nelems = 0;

  return (status);
}


int vlistDelAtt(int vlistID, int varID, const char *name)
{
  int status = CDI_NOERR;

  fprintf(stderr, "vlistDelAtt not implemented!\n");

  return (status);
}


static
int vlist_def_att(int type, int vlistID, int varID, const char *name, size_t len, size_t xsz, const void *xp)
{
  static char func[] = "vlist_def_att";
  int status = CDI_NOERR;
  vlist_t *vlistptr;
  cdi_att_t *attp;
  cdi_atts_t *attsp;

  if ( len != 0 && xp == NULL ) /* Null arg */
    {
      return (CDI_EINVAL);
    }

  vlistptr = vlist_to_pointer(vlistID);

  attsp = get_attsp(vlistptr, varID);
  assert(attsp != NULL);

  attp = find_att(attsp, name);
  if ( attp == NULL )
    attp = new_att(attsp, name);

  if ( attp != NULL )
    fill_att(attp, type, len, xsz, xp);
  
  return (status);
}


static
int vlist_inq_att(int type, int vlistID, int varID, const char *name, size_t mxsz, void *xp)
{
  static char func[] = "vlist_inq_att";
  int status = CDI_NOERR;
  vlist_t *vlistptr;
  cdi_att_t *attp;
  cdi_atts_t *attsp;
  size_t xsz;

  if ( mxsz != 0 && xp == NULL ) /* Null arg */
    {
      return (CDI_EINVAL);
    }

  vlistptr = vlist_to_pointer(vlistID);

  attsp = get_attsp(vlistptr, varID);
  assert(attsp != NULL);

  attp = find_att(attsp, name);
  if ( attp != NULL ) /* name in use */
    {
      xsz = attp->xsz;
      if ( mxsz < xsz ) xsz = mxsz;
      if ( xsz > 0 )
	memcpy(xp, attp->xvalue, xsz);
    }
  else
    {
      Warning(func, "Internal problem, attribute %s not found!", name);
    }

  return (status);
}


int vlistCopyVarAtts(int vlistID1, int varID_1, int vlistID2, int varID_2)
{
  static char func[] = "vlistCopyVarAtts";
  int status = CDI_NOERR;
  vlist_t *vlistptr1;
  cdi_att_t *attp = NULL;
  cdi_atts_t *attsp1;
  int attid;

  vlistptr1 = vlist_to_pointer(vlistID1);

  attsp1 = get_attsp(vlistptr1, varID_1);
  assert(attsp1 != NULL);

  for ( attid = 0; attid < (int)attsp1->nelems; attid++ )
    {
      attp = &(attsp1->value[attid]);
      vlist_def_att(attp->type, vlistID2, varID_2, attp->name, attp->nelems, attp->xsz, attp->xvalue);
    }

  return (status);
}


/*
@Function  vlistDefAttInt
@Title     Define an integer attribute

@Prototype int vlistDefAttInt(int vlistID, int varID, const char *name, int len, const int *ip)

@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier, or CDI_GLOBAL for a global attribute
    @Item  name     Attribute name
    @Item  len      Number of values provided for the attribute
    @Item  ip       Pointer to one or more integer values

@Description
The function @func{vlistDefAttInt} defines an integer attribute.

@EndFunction
*/
int vlistDefAttInt(int vlistID, int varID, const char *name, int len, const int *ip)
{
  int status;

  status = vlist_def_att(DATATYPE_INT, vlistID, varID, name, (size_t) len, len*sizeof(int), (const void *) ip);

  return (status);
}


/*
@Function  vlistDefAttFlt
@Title     Define a floating point attribute

@Prototype int vlistDefAttFlt(int vlistID, int varID, const char *name, int len, const double *dp)

@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier, or CDI_GLOBAL for a global attribute
    @Item  name     Attribute name
    @Item  len      Number of values provided for the attribute
    @Item  dp       Pointer to one or more floating point values

@Description
The function @func{vlistDefAttFlt} defines a floating point attribute.

@EndFunction
*/
int vlistDefAttFlt(int vlistID, int varID, const char *name, int len, const double *dp)
{
  int status;

  status = vlist_def_att(DATATYPE_FLT, vlistID, varID, name, (size_t) len, len*sizeof(double), (const void *) dp);

  return (status);
}


/*
@Function  vlistDefAttTxt
@Title     Define a text attribute

@Prototype int vlistDefAttTxt(int vlistID, int varID, const char *name, int len, const char *tp)

@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier, or CDI_GLOBAL for a global attribute
    @Item  name     Attribute name
    @Item  len      Number of values provided for the attribute
    @Item  tp       Pointer to one or more character values

@Description
The function @func{vlistDefAttTxt} defines a text attribute.

@EndFunction
*/
int vlistDefAttTxt(int vlistID, int varID, const char *name, int len, const char *tp)
{
  int status;

  status = vlist_def_att(DATATYPE_TXT, vlistID, varID, name, (size_t) len, len*sizeof(char), (const void *) tp);

  return (status);
}


/*
@Function  vlistInqAttInt
@Title     Get the value(s) of an integer attribute

@Prototype int vlistInqAttInt(int vlistID, int varID, const char *name, int mlen, int *ip)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier, or CDI_GLOBAL for a global attribute
    @Item  name     Attribute name
    @Item  mlen     Number of allocated values provided for the attribute
    @Item  ip       Pointer location for returned integer attribute value(s)

@Description
The function @func{vlistInqAttInt} gets the values(s) of an integer attribute.

@EndFunction
*/
int vlistInqAttInt(int vlistID, int varID, const char *name, int mlen, int *ip)
{
  int status = CDI_NOERR;

  status = vlist_inq_att(DATATYPE_INT, vlistID, varID, name, mlen*sizeof(int), (void *) ip);

  return (CDI_NOERR);
}


/*
@Function  vlistInqAttFlt
@Title     Get the value(s) of a floating point attribute

@Prototype int vlistInqAttFlt(int vlistID, int varID, const char *name, int mlen, int *dp)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier, or CDI_GLOBAL for a global attribute
    @Item  name     Attribute name
    @Item  mlen     Number of allocated values provided for the attribute
    @Item  dp       Pointer location for returned floating point attribute value(s)

@Description
The function @func{vlistInqAttFlt} gets the values(s) of a floating point attribute.

@EndFunction
*/
int vlistInqAttFlt(int vlistID, int varID, const char *name, int mlen, double *dp)
{
  int status = CDI_NOERR;

  status = vlist_inq_att(DATATYPE_FLT, vlistID, varID, name, mlen*sizeof(double), (void *) dp);

  return (status);
}


/*
@Function  vlistInqAttTxt
@Title     Get the value(s) of a text attribute

@Prototype int vlistInqAttTxt(int vlistID, int varID, const char *name, int mlen, int *tp)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier, or CDI_GLOBAL for a global attribute
    @Item  name     Attribute name
    @Item  mlen     Number of allocated values provided for the attribute
    @Item  tp       Pointer location for returned text attribute value(s)

@Description
The function @func{vlistInqAttTxt} gets the values(s) of a text attribute.

@EndFunction
*/
int vlistInqAttTxt(int vlistID, int varID, const char *name, int mlen, char *tp)
{
  int status = CDI_NOERR;

  status = vlist_inq_att(DATATYPE_TXT, vlistID, varID, name, mlen*sizeof(char), (void *) tp);

  return (status);
}
#if defined (HAVE_CONFIG_H)
#endif




static void vlistvarInitEntry(int vlistID, int varID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistptr->vars[varID].fvarID       = varID;
  vlistptr->vars[varID].mvarID       = varID;
  vlistptr->vars[varID].flag         = 0;
  vlistptr->vars[varID].param        = 0;
  vlistptr->vars[varID].timeID       = CDI_UNDEFID;
  vlistptr->vars[varID].datatype     = CDI_UNDEFID;
  vlistptr->vars[varID].tsteptype    = TSTEP_INSTANT;
  vlistptr->vars[varID].timave       = 0;
  vlistptr->vars[varID].timaccu      = 0;
  vlistptr->vars[varID].gridID       = CDI_UNDEFID;
  vlistptr->vars[varID].zaxisID      = CDI_UNDEFID;
  vlistptr->vars[varID].instID       = CDI_UNDEFID;
  vlistptr->vars[varID].modelID      = CDI_UNDEFID;
  vlistptr->vars[varID].tableID      = CDI_UNDEFID;
  vlistptr->vars[varID].missvalused  = FALSE;
  vlistptr->vars[varID].missval      = cdiDefaultMissval;
  vlistptr->vars[varID].addoffset    = 0.0;
  vlistptr->vars[varID].scalefactor  = 1.0;
  vlistptr->vars[varID].name         = NULL;
  vlistptr->vars[varID].longname     = NULL;
  vlistptr->vars[varID].stdname      = NULL;
  vlistptr->vars[varID].units        = NULL;
  vlistptr->vars[varID].nlevs        = 0;
  vlistptr->vars[varID].levinfo      = NULL;
  vlistptr->vars[varID].ztype        = COMPRESS_NONE;
  vlistptr->vars[varID].zlevel       = 1;
  vlistptr->vars[varID].atts.nalloc  = MAX_ATTRIBUTES;
  vlistptr->vars[varID].atts.nelems  = 0;
}

static int vlistvarNewEntry(int vlistID)
{
  static char func[] = "vlistvarNewEntry";
  int varID = 0;
  int vlistvarSize;
  var_t *vlistvar;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistvarSize = vlistptr->varsAllocated;
  vlistvar     = vlistptr->vars;
  /*
    Look for a free slot in vlistvar.
    (Create the table the first time through).
  */
  if ( ! vlistvarSize )
    {
      int i;

      vlistvarSize = 2;
      vlistvar = (var_t *) malloc(vlistvarSize*sizeof(var_t));
      if ( vlistvar == NULL )
	{
          Message(func, "vlistvarSize = %d", vlistvarSize);
	  SysError(func, "Allocation of var_t failed");
	}

      for ( i = 0; i < vlistvarSize; i++ )
	vlistvar[i].isUsed = FALSE;
    }
  else
    {
      while ( varID < vlistvarSize )
	{
	  if ( ! vlistvar[varID].isUsed ) break;
	  varID++;
	}
    }
  /*
    If the table overflows, double its size.
  */
  if ( varID == vlistvarSize )
    {
      int i;

      vlistvarSize = 2*vlistvarSize;
      vlistvar = (var_t *) realloc(vlistvar, vlistvarSize*sizeof(var_t));
      if ( vlistvar == NULL )
	{
          Message(func, "vlistvarSize = %d", vlistvarSize);
	  SysError(func, "Reallocation of var_t failed");
	}
      varID = vlistvarSize/2;

      for ( i = varID; i < vlistvarSize; i++ )
	vlistvar[i].isUsed = FALSE;
    }

  vlistptr->varsAllocated = vlistvarSize;
  vlistptr->vars          = vlistvar;

  vlistvarInitEntry(vlistID, varID);

  vlistptr->vars[varID].isUsed = TRUE;

  return (varID);
}

void vlistCheckVarID(char *func, int vlistID, int varID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  if ( vlistptr == NULL )
    Error(func, "vlist undefined!");

  if ( varID < 0 || varID >= vlistptr->nvars )
    Error(func, "varID %d undefined!", varID);

  if ( ! vlistptr->vars[varID].isUsed )
    Error(func, "varID %d undefined!", varID);
}


/*
@Function  vlistDefVar
@Title     Define a Variable

@Prototype int vlistDefVar(int vlistID, int gridID, int zaxisID, int timeID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  timeID   One of the set of predefined CDI time identifiers.
                    The valid CDI time identifiers are @func{TIME_CONSTANT} and @func{TIME_VARIABLE}.

@Description
The function @func{vlistDefVar} adds a new variable to vlistID.

@Result
@func{vlistDefVar} returns an identifier to the new variable.

@Example
Here is an example using @func{vlistCreate} to create a variable list
and add a variable with @func{vlistDefVar}.

@Source
   ...
int vlistID, varID;
   ...
vlistID = vlistCreate();
varID = vlistDefVar(vlistID, gridID, zaxisID, TIME_VARIABLE);
   ...
streamDefVlist(streamID, vlistID);
   ...
vlistDestroy(vlistID);
   ...
@EndSource
@EndFunction
*/
int vlistDefVar(int vlistID, int gridID, int zaxisID, int timeID)
{
  static char func[] = "vlistDefVar";
  int varID;
  int nlevs;
  int levID;
  int index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  if ( CDI_Debug )
    Message(func, "gridID = %d  zaxisID = %d  timeID = %d", gridID, zaxisID, timeID);

  varID = vlistvarNewEntry(vlistID);

  vlistptr->nvars++;

  vlistptr->vars[varID].gridID  = gridID;
  vlistptr->vars[varID].zaxisID = zaxisID;
  vlistptr->vars[varID].timeID  = timeID;

  if ( timeID != TIME_VARIABLE && timeID != TIME_CONSTANT )
    {
      Message(func, "unexpected timeID %d. Set to TIME_VARIABLE", timeID);
      vlistptr->vars[varID].timeID = TIME_VARIABLE;	  
    }

  nlevs = zaxisInqSize(zaxisID);

  vlistptr->vars[varID].levinfo = (levinfo_t *) malloc(nlevs*sizeof(levinfo_t));

  for ( levID = 0; levID < nlevs; levID++ )
    {
      vlistptr->vars[varID].levinfo[levID].flag     = 0;
      vlistptr->vars[varID].levinfo[levID].index    = -1;
      vlistptr->vars[varID].levinfo[levID].flevelID = levID;
      vlistptr->vars[varID].levinfo[levID].mlevelID = levID;
    }

  vlistptr->vars[varID].nlevs = nlevs;

  for ( index = 0; index < vlistptr->ngrids; index++ )
    if ( gridID == vlistptr->gridIDs[index] ) break;

  if ( index == vlistptr->ngrids )
    {
      if ( vlistptr->ngrids + 1 >= MAX_GRIDS_PS )
	Error(func, "Maximum of %d grids reached", MAX_GRIDS_PS);

      vlistptr->gridIDs[vlistptr->ngrids] = gridID;
      vlistptr->ngrids++;
    }

  for ( index = 0; index < vlistptr->nzaxis; index++ )
    if ( zaxisID == vlistptr->zaxisIDs[index] ) break;

  if ( index == vlistptr->nzaxis )
    {
      if ( vlistptr->nzaxis + 1 >= MAX_ZAXES_PS )
	Error(func, "Maximum of %d zaxis reached", MAX_ZAXES_PS);

      vlistptr->zaxisIDs[vlistptr->nzaxis] = zaxisID;
      vlistptr->nzaxis++;
    }

  vlistptr->vars[varID].param = cdiEncodeParam(-(varID + 1), 255, 255);

  return (varID);
}


/*
@Function  vlistDefVarParam
@Title     Define the parameter number of a Variable

@Prototype void vlistDefVarParam(int vlistID, int varID, int param)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  param    Parameter number

@Description
The function @func{vlistDefVarParam} defines the parameter number of a variable.

@EndFunction
*/
void vlistDefVarParam(int vlistID, int varID, int param)
{
  static char func[] = "vlistDefVarParam";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  vlistptr->vars[varID].param = param;
}


/*
@Function  vlistDefVarCode
@Title     Define the code number of a Variable

@Prototype void vlistDefVarCode(int vlistID, int varID, int code)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  code     Code number

@Description
The function @func{vlistDefVarCode} defines the code number of a variable.

@EndFunction
*/
void vlistDefVarCode(int vlistID, int varID, int code)
{
  static char func[] = "vlistDefVarCode";
  vlist_t *vlistptr;
  int param, pnum, pcat, pdis;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  param = vlistptr->vars[varID].param;

  cdiDecodeParam(param, &pnum, &pcat, &pdis);
  
  vlistptr->vars[varID].param = cdiEncodeParam(code, pcat, pdis);
}


void vlistInqVar(int vlistID, int varID, int *gridID, int *zaxisID, int *timeID)
{
  static char func[] = "vlistInqVar";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  *gridID  = vlistptr->vars[varID].gridID;
  *zaxisID = vlistptr->vars[varID].zaxisID;
  *timeID  = vlistptr->vars[varID].timeID;

  return;
}


/*
@Function  vlistInqVarGrid
@Title     Get the Grid ID of a Variable

@Prototype int vlistInqVarGrid(int vlistID, int varID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier

@Description
The function @func{vlistInqVarGrid} returns the grid ID of a variable.

@Result
@func{vlistInqVarGrid} returns the grid ID of the variable.

@EndFunction
*/
int vlistInqVarGrid(int vlistID, int varID)
{
  static char func[] = "vlistInqVarGrid";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].gridID);
}


/*
@Function  vlistInqVarZaxis
@Title     Get the Zaxis ID of a Variable

@Prototype int vlistInqVarZaxis(int vlistID, int varID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier

@Description
The function @func{vlistInqVarZaxis} returns the zaxis ID of a variable.

@Result
@func{vlistInqVarZaxis} returns the zaxis ID of the variable.

@EndFunction
*/
int vlistInqVarZaxis(int vlistID, int varID)
{
  static char func[] = "vlistInqVarZaxis";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].zaxisID);
}

int vlistInqVarTime(int vlistID, int varID)
{
  static char func[] = "vlistInqVarTime";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].timeID);
}


/*
@Function  vlistInqVarParam
@Title     Get the parameter number of a Variable

@Prototype int vlistInqVarParam(int vlistID, int varID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier

@Description
The function @func{vlistInqVarParam} returns the parameter number of a variable.

@Result
@func{vlistInqVarParam} returns the parameter number of the variable.

@EndFunction
*/
int vlistInqVarParam(int vlistID, int varID)
{
  static char func[] = "vlistInqVarParam";
  vlist_t *vlistptr;
  int param;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  param = vlistptr->vars[varID].param;

  return (param);
}


/*
@Function  vlistInqVarCode
@Title     Get the Code number of a Variable

@Prototype int vlistInqVarCode(int vlistID, int varID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier

@Description
The function @func{vlistInqVarCode} returns the code number of a variable.

@Result
@func{vlistInqVarCode} returns the code number of the variable.

@EndFunction
*/
int vlistInqVarCode(int vlistID, int varID)
{
  static char func[] = "vlistInqVarCode";
  vlist_t *vlistptr;
  int param, code;
  int pdis, pcat, pnum;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  param = vlistptr->vars[varID].param;
  cdiDecodeParam(param, &pnum, &pcat, &pdis);
  code = pnum;

  if ( code < 0 && vlistptr->vars[varID].tableID != -1 && vlistptr->vars[varID].name != NULL )
    {
      tableInqParCode(vlistptr->vars[varID].tableID, vlistptr->vars[varID].name, &code);
    }

  return (code);
}


char *vlistInqVarNamePtr(int vlistID, int varID)
{
  static char func[] = "vlistInqVarNamePtr";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].name);
}

char *vlistInqVarLongnamePtr(int vlistID, int varID)
{
  static char func[] = "vlistInqVarLongnamePtr";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].longname);
}

char *vlistInqVarStdnamePtr(int vlistID, int varID)
{
  static char func[] = "vlistInqVarStdnamePtr";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].stdname);
}

char *vlistInqVarUnitsPtr(int vlistID, int varID)
{
  static char func[] = "vlistInqVarUnitsPtr";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].units);
}


/*
@Function  vlistInqVarName
@Title     Get the name of a Variable

@Prototype void vlistInqVarName(int vlistID, int varID, char *name)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  name     Variable name

@Description
The function @func{vlistInqVarName} returns the name of a variable.

@Result
@func{vlistInqVarName} returns the name of the variable to the parameter name.

@EndFunction
*/
void vlistInqVarName(int vlistID, int varID, char *name)
{
  static char func[] = "vlistInqVarName";
  int tableID;
  int param, code;
  int pdis, pcat, pnum;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  if ( vlistptr->vars[varID].name == NULL )
    {
      param = vlistptr->vars[varID].param;
      cdiDecodeParam(param, &pnum, &pcat, &pdis);
      code = pnum;
      tableID = vlistptr->vars[varID].tableID;
      if ( tableInqParName(tableID, code, name) != 0 )
	sprintf(name, "var%d", code);
    }  
  else
    strcpy(name, vlistptr->vars[varID].name);

  return;
}


/*
@Function  vlistInqVarLongname
@Title     Get the longname of a Variable

@Prototype void vlistInqVarLongname(int vlistID, int varID, char *longname)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  longname Variable description

@Description
The function @func{vlistInqVarLongname} returns the longname of a variable.

@Result
@func{vlistInqVaeLongname} returns the longname of the variable to the parameter longname.

@EndFunction
*/
void vlistInqVarLongname(int vlistID, int varID, char *longname)
{
  static char func[] = "vlistInqVarLongname";
  int tableID;
  int param, code;
  int pdis, pcat, pnum;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  if ( vlistptr->vars[varID].longname == NULL )
    {
      param = vlistptr->vars[varID].param;
      cdiDecodeParam(param, &pnum, &pcat, &pdis);
      code = pnum;
      tableID = vlistptr->vars[varID].tableID;
      if ( tableInqParLongname(tableID, code, longname) != 0 )
	longname[0] = '\0';
    }  
  else
    strcpy(longname, vlistptr->vars[varID].longname);

  return;
}


/*
@Function  vlistInqVarStdname
@Title     Get the standard name of a Variable

@Prototype void vlistInqVarStdname(int vlistID, int varID, char *stdname)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  stdname  Variable standard name

@Description
The function @func{vlistInqVarStdname} returns the standard name of a variable.

@Result
@func{vlistInqVarName} returns the standard name of the variable to the parameter stdname.

@EndFunction
*/
void vlistInqVarStdname(int vlistID, int varID, char *stdname)
{
  static char func[] = "vlistInqVarStdname";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  if ( vlistptr->vars[varID].stdname == NULL )
    {
      stdname[0] = '\0';
    }  
  else
    strcpy(stdname, vlistptr->vars[varID].stdname);

  return;
}


/*
@Function  vlistInqVarUnits
@Title     Get the units of a Variable

@Prototype void vlistInqVarUnits(int vlistID, int varID, char *units)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  units    Variable units

@Description
The function @func{vlistInqVarUnits} returns the units of a variable.

@Result
@func{vlistInqVarUnits} returns the units of the variable to the parameter units.

@EndFunction
*/
void vlistInqVarUnits(int vlistID, int varID, char *units)
{
  static char func[] = "vlistInqVarUnits";
  int tableID;
  int param, code;
  int pdis, pcat, pnum;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  if ( vlistptr->vars[varID].units == NULL )
    {
      param = vlistptr->vars[varID].param;
      cdiDecodeParam(param, &pnum, &pcat, &pdis);
      code = pnum;
      tableID = vlistptr->vars[varID].tableID;
      if ( tableInqParUnits(tableID, code, units) != 0 )
	units[0] = '\0';
    }  
  else
    strcpy(units, vlistptr->vars[varID].units);

  return;
}


int vlistInqVarID(int vlistID, int code)
{
  int varID;
  vlist_t *vlistptr;
  int param, pdis, pcat, pnum;

  vlistptr = vlist_to_pointer(vlistID);

  for ( varID = 0; varID < vlistptr->nvars; varID++ )
    {
      param = vlistptr->vars[varID].param;
      cdiDecodeParam(param, &pnum, &pcat, &pdis);
      if ( pnum == code ) break;
    }

  if ( varID == vlistptr->nvars )
    {
      /*
      Warning(func, "varID not found for param %d\n", param);
      */
      varID = CDI_UNDEFID;
    }

  return (varID);
}


int vlistInqVarSize(int vlistID, int varID)
{
  static char func[] = "vlistInqVarSize";
  int size;
  int zaxisID, gridID;
  int nlevs, gridsize;
  int timeID;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  vlistInqVar(vlistID, varID, &gridID, &zaxisID, &timeID);

  nlevs = zaxisInqSize(zaxisID);

  gridsize = gridInqSize(gridID);

  size = gridsize*nlevs;

  return (size);
}


/*
@Function  vlistInqVarDatatype
@Title     Get the data type of a Variable

@Prototype int vlistInqVarDatatype(int vlistID, int varID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier

@Description
The function @func{vlistInqVarDatatype} returns the data type of a variable.

@Result
@func{vlistInqVarDatatype} returns an identifier to the data type of the variable.
The valid CDI data types are @func{DATATYPE_PACK8}, @func{DATATYPE_PACK16}, @func{DATATYPE_PACK24},
@func{DATATYPE_FLT32} and @func{DATATYPE_FLT64}.

@EndFunction
*/
int vlistInqVarDatatype(int vlistID, int varID)
{
  static char func[] = "vlistInqVarDatatype";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].datatype);
}


int vlistInqVarNumber(int vlistID, int varID)
{
  static char func[] = "vlistInqVarNumber";
  vlist_t *vlistptr;
  int number = CDI_REAL;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  if ( vlistptr->vars[varID].datatype == DATATYPE_CPX32 || vlistptr->vars[varID].datatype == DATATYPE_CPX64 )
    number = CDI_COMP;

  return (number);
}


/*
@Function  vlistDefVarDatatype
@Title     Define the data type of a Variable

@Prototype void vlistDefVarDatatype(int vlistID, int varID, int datatype)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  datatype The data type identifier.
                    The valid CDI data types are @func{DATATYPE_PACK8}, @func{DATATYPE_PACK16},
                    @func{DATATYPE_PACK24}, @func{DATATYPE_FLT32} and @func{DATATYPE_FLT64}.


@Description
The function @func{vlistDefVarDatatype} defines the data type of a variable.

@EndFunction
*/
void vlistDefVarDatatype(int vlistID, int varID, int datatype)
{
  static char func[] = "vlistDefVarDatatype";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  vlistptr->vars[varID].datatype = datatype;
  
  if ( vlistptr->vars[varID].missvalused == FALSE )
    {
      switch (datatype)
	{
	case DATATYPE_INT8:
	  vlistptr->vars[varID].missval =  SCHAR_MIN;
	  break;
	case DATATYPE_UINT8:
	  vlistptr->vars[varID].missval =  UCHAR_MAX;
	  break;
	case DATATYPE_INT16:
	  vlistptr->vars[varID].missval =  SHRT_MIN;
	  break;
	case DATATYPE_UINT16:
	  vlistptr->vars[varID].missval =  USHRT_MAX;
	  break;
	case DATATYPE_INT32:
	  vlistptr->vars[varID].missval =  INT_MIN;
	  break;
	case DATATYPE_UINT32:
	  vlistptr->vars[varID].missval =  UINT_MAX;
	  break;
	}
    }
}


void vlistDefVarInstitut(int vlistID, int varID, int instID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistptr->vars[varID].instID = instID;
}


int vlistInqVarInstitut(int vlistID, int varID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  return (vlistptr->vars[varID].instID);
}


void vlistDefVarModel(int vlistID, int varID, int modelID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistptr->vars[varID].modelID = modelID;
}


int vlistInqVarModel(int vlistID, int varID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  return (vlistptr->vars[varID].modelID);
}


void vlistDefVarTable(int vlistID, int varID, int tableID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistptr->vars[varID].tableID = tableID;

  {
    int param, pnum, pcat, pdis;
    int tablenum;
    tablenum = tableInqNum(tableID);

    param = vlistptr->vars[varID].param;

    cdiDecodeParam(param, &pnum, &pcat, &pdis);
  
    vlistptr->vars[varID].param = cdiEncodeParam(pnum, tablenum, pdis);
  }
}


int vlistInqVarTable(int vlistID, int varID)
{
  int tableID;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  tableID = vlistptr->vars[varID].tableID;

  return (tableID);
}


/*
@Function  vlistDefVarName
@Title     Define the name of a Variable

@Prototype void vlistDefVarName(int vlistID, int varID, const char *name)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  name     Name of the variable

@Description
The function @func{vlistDefVarName} defines the name of a variable.

@EndFunction
*/
void vlistDefVarName(int vlistID, int varID, const char *name)
{
  static char func[] = "vlistDefVarName";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  if ( vlistptr->vars[varID].name )
    {
      free(vlistptr->vars[varID].name);
      vlistptr->vars[varID].name = 0;
    }

  if ( name ) vlistptr->vars[varID].name = strdupx(name);
}


/*
@Function  vlistDefVarLongname
@Title     Define the long name of a Variable

@Prototype void vlistDefVarLongname(int vlistID, int varID, const char *longname)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  longname Long name of the variable

@Description
The function @func{vlistDefVarLongname} defines the long name of a variable.

@EndFunction
*/
void vlistDefVarLongname(int vlistID, int varID, const char *longname)
{
  static char func[] = "vlistDefVarLongname";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  if ( vlistptr->vars[varID].longname )
    {
      free(vlistptr->vars[varID].longname);
      vlistptr->vars[varID].longname = 0;
    }

  if ( longname ) vlistptr->vars[varID].longname = strdupx(longname);
}


/*
@Function  vlistDefVarStdname
@Title     Define the standard name of a Variable

@Prototype void vlistDefVarStdname(int vlistID, int varID, const char *stdname)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  stdname  Standard name of the variable

@Description
The function @func{vlistDefVarStdname} defines the standard name of a variable.

@EndFunction
*/
void vlistDefVarStdname(int vlistID, int varID, const char *stdname)
{
  static char func[] = "vlistDefVarStdname";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  if ( vlistptr->vars[varID].stdname )
    {
      free(vlistptr->vars[varID].stdname);
      vlistptr->vars[varID].stdname = 0;
    }

  if ( stdname ) vlistptr->vars[varID].stdname = strdupx(stdname);
}


/*
@Function  vlistDefVarUnits
@Title     Define the units of a Variable

@Prototype void vlistDefVarUnits(int vlistID, int varID, const char *units)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  units    Units of the variable

@Description
The function @func{vlistDefVarUnits} defines the units of a variable.

@EndFunction
*/
void vlistDefVarUnits(int vlistID, int varID, const char *units)
{
  static char func[] = "vlistDefVarUnits";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  if ( vlistptr->vars[varID].units )
    {
      free(vlistptr->vars[varID].units);
      vlistptr->vars[varID].units = 0;
    }

  if ( units ) vlistptr->vars[varID].units = strdupx(units);
}


/*
@Function  vlistInqVarMissval
@Title     Get the missing value of a Variable

@Prototype double vlistInqVarMissval(int vlistID, int varID)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier

@Description
The function @func{vlistInqVarMissval} returns the missing value of a variable.

@Result
@func{vlistInqVarMissval} returns the missing value of the variable.

@EndFunction
*/
double vlistInqVarMissval(int vlistID, int varID)
{
  static char func[] = "vlistInqVarMissval";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].missval);
}


double vlistInqVarScalefactor(int vlistID, int varID)
{
  static char func[] = "vlistInqVarScalefactor";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].scalefactor);
}

double vlistInqVarAddoffset(int vlistID, int varID)
{
  static char func[] = "vlistInqVarAddoffset";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].addoffset);
}


/*
@Function  vlistDefVarMissval
@Title     Define the missing value of a Variable

@Prototype void vlistDefVarMissval(int vlistID, int varID, double missval)
@Parameter
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}
    @Item  varID    Variable identifier
    @Item  missval  Missing value

@Description
The function @func{vlistDefVarMissval} defines the missing value of a variable.

@EndFunction
*/
void vlistDefVarMissval(int vlistID, int varID, double missval)
{
  static char func[] = "vlistDefVarMissval";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  vlistptr->vars[varID].missval = missval;
  vlistptr->vars[varID].missvalused = TRUE;
}


void vlistDefVarScalefactor(int vlistID, int varID, double scalefactor)
{
  static char func[] = "vlistDefVarScalefactor";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  vlistptr->vars[varID].scalefactor = scalefactor;
}


void vlistDefVarAddoffset(int vlistID, int varID, double addoffset)
{
  static char func[] = "vlistDefVarAddoffset";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  vlistptr->vars[varID].addoffset = addoffset;
}


void vlistDefVarTsteptype(int vlistID, int varID, int tsteptype)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistptr->vars[varID].tsteptype = tsteptype;
}


int vlistInqVarTsteptype(int vlistID, int varID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  return (vlistptr->vars[varID].tsteptype);
}


void vlistDefVarTimave(int vlistID, int varID, int timave)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistptr->vars[varID].timave = timave;
}


int vlistInqVarTimave(int vlistID, int varID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  return (vlistptr->vars[varID].timave);
}


void vlistDefVarTimaccu(int vlistID, int varID, int timaccu)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistptr->vars[varID].timaccu = timaccu;
}


int vlistInqVarTimaccu(int vlistID, int varID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  return (vlistptr->vars[varID].timaccu);
}


void vlistDestroyVarName(int vlistID, int varID)
{
  static char func[] = "vlistDestroyVarName";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  if ( vlistptr->vars[varID].name )
    {
      free(vlistptr->vars[varID].name);
      vlistptr->vars[varID].name = NULL;
    }
}


void vlistDestroyVarLongname(int vlistID, int varID)
{
  static char func[] = "vlistDestroyVarLongname";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  if ( vlistptr->vars[varID].longname )
    {
      free(vlistptr->vars[varID].longname);
      vlistptr->vars[varID].longname = NULL;
    }
}


void vlistDestroyVarStdname(int vlistID, int varID)
{
  static char func[] = "vlistDestroyVarStdname";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  if ( vlistptr->vars[varID].stdname )
    {
      free(vlistptr->vars[varID].stdname);
      vlistptr->vars[varID].stdname = NULL;
    }
}


void vlistDestroyVarUnits(int vlistID, int varID)
{
  static char func[] = "vlistDestroyVarUnits";
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  if ( vlistptr->vars[varID].units )
    {
      free(vlistptr->vars[varID].units);
      vlistptr->vars[varID].units = NULL;
    }
}


void vlistDefVarTime(int vlistID, int varID, int timeID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistptr->vars[varID].timeID = timeID;
}


int vlistInqVarMissvalUsed(int vlistID, int varID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  return (vlistptr->vars[varID].missvalused);
}


void vlistDefFlag(int vlistID, int varID, int levID, int flag)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistptr->vars[varID].flag = flag;
  vlistptr->vars[varID].levinfo[levID].flag = flag;
}


int vlistInqFlag(int vlistID, int varID, int levID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  return (vlistptr->vars[varID].levinfo[levID].flag);
}


int vlistFindVar(int vlistID, int fvarID)
{
  static char func[] = "vlistFindVar";
  int varID;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  for ( varID = 0; varID < vlistptr->nvars; varID++ )
    {
      if ( vlistptr->vars[varID].fvarID == fvarID ) break;
    }

  if ( varID == vlistptr->nvars )
    {
      varID = -1;
      Message(func, "varID not found for fvarID %d in vlistID %d!", fvarID, vlistID);
    }

  return (varID);  
}


int vlistFindLevel(int vlistID, int fvarID, int flevelID)
{
  static char func[] = "vlistFindLevel";
  int varID;
  int levelID = -1;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  varID = vlistFindVar(vlistID, fvarID);

  if ( varID != -1 )
    {
      for ( levelID = 0; levelID < vlistptr->vars[varID].nlevs; levelID++ )
	{
	  if ( vlistptr->vars[varID].levinfo[levelID].flevelID == flevelID ) break;
	}

      if ( levelID == vlistptr->vars[varID].nlevs )
	{
	  levelID = -1;
	  Message(func, "levelID not found for fvarID %d and levelID %d in vlistID %d!",
		  fvarID, flevelID, vlistID);
	}
    }

  return (levelID);  
}


int vlistMergedVar(int vlistID, int varID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  return (vlistptr->vars[varID].mvarID);  
}


int vlistMergedLevel(int vlistID, int varID, int levelID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  return (vlistptr->vars[varID].levinfo[levelID].mlevelID);  
}


void vlistDefIndex(int vlistID, int varID, int levelID, int index)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistptr->vars[varID].levinfo[levelID].index = index;  
}


int vlistInqIndex(int vlistID, int varID, int levelID)
{
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  return (vlistptr->vars[varID].levinfo[levelID].index);  
}


void vlistChangeVarZaxis(int vlistID, int varID, int zaxisID)
{
  static char func[] = "vlistChangeVarZaxis";
  int nlevs1, nlevs2;
  int nvars, index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  nlevs1 = zaxisInqSize(vlistptr->vars[varID].zaxisID);
  nlevs2 = zaxisInqSize(zaxisID);

  if ( nlevs1 != nlevs2 ) Error(func, "Number of levels must not change!");

  nvars = vlistptr->nvars;
  for ( index = 0; index < nvars; index++ )
    if ( index != varID )
      if ( vlistptr->vars[index].zaxisID == vlistptr->vars[varID].zaxisID ) break;

  if ( index == nvars )
    {
      for ( index = 0; index < vlistptr->nzaxis; index++ )
	if ( vlistptr->zaxisIDs[index] == vlistptr->vars[varID].zaxisID )
	  vlistptr->zaxisIDs[index] = zaxisID;
    }
  else
    {
      for ( index = 0; index < vlistptr->nzaxis; index++ )
	if ( vlistptr->zaxisIDs[index] == zaxisID ) break;

      if ( index == vlistptr->nzaxis )
	{
	  if ( vlistptr->nzaxis + 1 >= MAX_ZAXES_PS )
	    Error(func, "Maximum of %d zaxis reached", MAX_ZAXES_PS);

	  vlistptr->zaxisIDs[vlistptr->nzaxis] = zaxisID;
	  vlistptr->nzaxis++;
	}
    }
  
  vlistptr->vars[varID].zaxisID = zaxisID;
}


void vlistChangeVarGrid(int vlistID, int varID, int gridID)
{
  static char func[] = "vlistChangeVarGrid";
  int nvars, index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  nvars = vlistptr->nvars;
  for ( index = 0; index < nvars; index++ )
    if ( index != varID )
      if ( vlistptr->vars[index].gridID == vlistptr->vars[varID].gridID ) break;

  if ( index == nvars )
    {
      for ( index = 0; index < vlistptr->ngrids; index++ )
	if ( vlistptr->gridIDs[index] == vlistptr->vars[varID].gridID )
	  vlistptr->gridIDs[index] = gridID;
    }
  else
    {
      for ( index = 0; index < vlistptr->ngrids; index++ )
	if ( vlistptr->gridIDs[index] == gridID ) break;

      if ( index == vlistptr->ngrids )
	{
	  if ( vlistptr->ngrids + 1 >= MAX_GRIDS_PS )
	    Error(func, "Maximum of %d grids reached", MAX_GRIDS_PS);

	  vlistptr->gridIDs[vlistptr->ngrids] = gridID;
	  vlistptr->ngrids++;
	}
    }
  
  vlistptr->vars[varID].gridID = gridID;
}


void vlistDefVarZtype(int vlistID, int varID, int ztype)
{
  static char func[] = "vlistDefVarZtype";
  int nvars, index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  vlistptr->vars[varID].ztype = ztype;
}


int vlistInqVarZtype(int vlistID, int varID)
{
  static char func[] = "vlistInqVarZtype";
  int nvars, index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].ztype);
}


void vlistDefVarZlevel(int vlistID, int varID, int zlevel)
{
  static char func[] = "vlistDefVarZlevel";
  int nvars, index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  vlistptr->vars[varID].zlevel = zlevel;
}


int vlistInqVarZlevel(int vlistID, int varID)
{
  static char func[] = "vlistInqVarZlevel";
  int nvars, index;
  vlist_t *vlistptr;

  vlistptr = vlist_to_pointer(vlistID);

  vlistCheckVarID(func, vlistID, varID);

  return (vlistptr->vars[varID].zlevel);
}
#if defined (HAVE_CONFIG_H)
#endif



#undef  UNDEFID
#define UNDEFID  CDI_UNDEFID

void basetimeInit(BaseTime *basetime)
{
  static char func[] = "basetimeInit";

  if ( basetime == NULL )
    Error(func, "Internal problem! Basetime not allocated.");

  (*basetime).ncvarid = UNDEFID;
  (*basetime).ncdimid = UNDEFID;
  (*basetime).ncvarboundsid = UNDEFID;
}
#if defined (HAVE_CONFIG_H)
#endif





#define SINGLE_PRECISION  4
#define DOUBLE_PRECISION  8

#define SRV_HEADER_LEN    8


static int initSrvLib      = 0;
static int srvDefaultHprec = 0;
static int srvDefaultDprec = 0;


/*
 * A version string.
 */

#undef  LIBVERSION
#define LIBVERSION      1.2.0
#define XSTRING(x)	#x
#define STRING(x)	XSTRING(x)
static const char srv_libvers[] = STRING(LIBVERSION) " of "__DATE__" "__TIME__;

const char *srvLibraryVersion(void)
{
  return (srv_libvers);
}


int SRV_Debug = 0;    /* If set to 1, debugging */


void srvDebug(int debug)
{
  static char func[] = "srvDebug";

  SRV_Debug = debug;

  if ( SRV_Debug )
    Message(func, "debug level %d", debug);
}


void srvLibInit()
{
  static char func[] = "srvLibInit";
  char *envString;
  char *envName = "SRV_PRECISION";


  envString = getenv(envName);
  if ( envString )
    {
      int pos;
      int nrun;
      if ( strlen(envString) == 2 ) nrun = 1;
      else                          nrun = 2;

      pos = 0;
      while ( nrun-- )
	{
	  switch ( tolower((int) envString[pos]) )
	    {
	    case 'i':
	      {
		switch ( (int) envString[pos+1] )
		  {
		  case '4': srvDefaultHprec = SINGLE_PRECISION; break;
		  case '8': srvDefaultHprec = DOUBLE_PRECISION; break;
		  default:
		    Message(func, "Invalid digit in %s: %s", envName, envString);
		  }
		break;
	      }
	    case 'r':
	      {
		switch ( (int) envString[pos+1] )
		  {
		  case '4': srvDefaultDprec = SINGLE_PRECISION; break;
		  case '8': srvDefaultDprec = DOUBLE_PRECISION; break;
		  default:
		    Message(func, "Invalid digit in %s: %s", envName, envString);
		  }
		break;		
	      }
	    default:
	      Message(func, "Invalid character in %s: %s", envName, envString);
	    }
	  pos += 2;
	}
    }

  initSrvLib = 1;
}


void srvInit(srvrec_t *srvp)
{
  srvp->checked    = 0;
  srvp->byteswap   = 0;
  srvp->hprec      = 0;
  srvp->dprec      = 0;
  srvp->datasize   = 0;
  srvp->buffersize = 0;
  srvp->buffer     = NULL;
}


srvrec_t *srvNew(void)
{
  static char func[] = "srvNew";
  srvrec_t *srvp;

  if ( ! initSrvLib ) srvLibInit();

  srvp = (srvrec_t *) malloc(sizeof(srvrec_t));

  srvInit(srvp);

  return (srvp);
}


void srvDelete(srvrec_t *srvp)
{
  static char func[] = "srvDelete";

  if ( srvp )
    {
      if ( srvp->buffer ) free(srvp->buffer);
      free(srvp);
    }
}


int srvCheckFiletype(int fileID, int *swap)
{
  static char func[] = "srvCheckFiletype";
  size_t blocklen = 0;
  size_t sblocklen = 0;
  size_t data = 0;
  size_t dimx = 0, dimy = 0;
  int fact = 0, found = 0;
  unsigned char buffer[72], *pbuf;

  if ( fileRead(fileID, buffer, 4) != 4 ) return (found);

  blocklen  = (size_t) get_UINT32(buffer);
  sblocklen = (size_t) get_SUINT32(buffer);

  if ( SRV_Debug )
    Message(func, "blocklen = %d sblocklen = %d", blocklen, sblocklen);

  if ( blocklen == 32 )
    {
     *swap = 0;
      fact = blocklen>>3;
      if ( fileRead(fileID, buffer, blocklen+8) != blocklen+8 ) return (found);
      pbuf = buffer+4*fact;      dimx = (size_t) get_UINT32(pbuf);
      pbuf = buffer+5*fact;      dimy = (size_t) get_UINT32(pbuf);
      pbuf = buffer+blocklen+4;  data = (size_t) get_UINT32(pbuf);
    }
  else if ( blocklen == 64 )
    {
     *swap = 0;
      fact = blocklen>>3;
      if ( fileRead(fileID, buffer, blocklen+8) != blocklen+8 ) return (found);
      pbuf = buffer+4*fact;      dimx = (size_t) get_UINT64(pbuf);
      pbuf = buffer+5*fact;      dimy = (size_t) get_UINT64(pbuf);
      pbuf = buffer+blocklen+4;  data = (size_t) get_UINT32(pbuf);
    }
  else if ( sblocklen == 32 )
    {
     *swap = 1;
      fact = sblocklen>>3;
      if ( fileRead(fileID, buffer, sblocklen+8) != sblocklen+8 ) return (found);
      pbuf = buffer+4*fact;       dimx = (size_t) get_SUINT32(pbuf);
      pbuf = buffer+5*fact;       dimy = (size_t) get_SUINT32(pbuf);
      pbuf = buffer+sblocklen+4;  data = (size_t) get_SUINT32(pbuf);
    }
  else if ( sblocklen == 64 )
    {
     *swap = 1;
      fact = sblocklen>>3;
      if ( fileRead(fileID, buffer, sblocklen+8) != sblocklen+8 ) return (found);
      pbuf = buffer+4*fact;       dimx = (size_t) get_SUINT64(pbuf);
      pbuf = buffer+5*fact;       dimy = (size_t) get_SUINT64(pbuf);
      pbuf = buffer+sblocklen+4;  data = (size_t) get_SUINT32(pbuf);
    }

  fileRewind(fileID);

  if      ( data && dimx*dimy*fact == data ) found = 1;
  else if ( data && dimx*dimy*8    == data ) found = 1;

  if ( SRV_Debug )
    {
      Message(func, "swap = %d fact = %d", *swap, fact);
      Message(func, "dimx = %lu dimy = %lu data = %lu", dimx, dimy, data);
    }

  return (found);
}


int srvInqHeader(srvrec_t *srvp, int *header)
{
  static char func[] = "srvInqHeader";
  size_t i;


  for ( i = 0; i < SRV_HEADER_LEN; i++ )
    header[i] = srvp->header[i];
  
  if ( SRV_Debug )
    Message(func, "datasize = %lu", srvp->datasize);

  return (0);
}


int srvDefHeader(srvrec_t *srvp, const int *header)
{
  static char func[] = "srvDefHeader";
  size_t i;


  for ( i = 0; i < SRV_HEADER_LEN; i++ )
    srvp->header[i] = header[i];
  
  srvp->datasize = header[4]*header[5];

  if ( SRV_Debug )
    Message(func, "datasize = %lu", srvp->datasize);

  return (0);
}


int srvInqData(srvrec_t *srvp, int prec, void *data)
{
  static char func[] = "srvInqData";
  size_t datasize;
  size_t i;
  int ierr = 0;
  int dprec;
  void *buffer;
  int byteswap = srvp->byteswap;


  datasize = srvp->datasize;

  buffer = srvp->buffer;

  dprec = srvp->dprec;

  switch ( dprec )
    {
    case SINGLE_PRECISION:
      {
	if ( sizeof(FLT32) == 4 )
	  {
	    if ( byteswap ) swap4byte(buffer, datasize);

	    if ( dprec == prec )
	      memcpy(data, buffer, datasize*sizeof(FLT32));
	    else
	      for (i = 0; i < datasize; i++)
		((double *) data)[i] = (double) ((float *) buffer)[i];
	  }
	else
	  {
	    Error(func, "not implemented for %d byte float", sizeof(FLT32));
	  }	
	break;
      }
    case DOUBLE_PRECISION:
	if ( sizeof(FLT64) == 8 )
	  {
	    if ( byteswap ) swap8byte(buffer, datasize);

	    if ( dprec == prec )
	      memcpy(data, buffer, datasize*sizeof(FLT64));
	    else
	      for (i = 0; i < datasize; i++)
		((float *) data)[i] = (float) ((double *) buffer)[i];
	  }
	else
	  {
	    Error(func, "not implemented for %d byte float", sizeof(FLT64));
	  }	
	break;
    default:
      {
	Error(func, "unexpected data precision %d", dprec);
      }
    }

  return (ierr);
}


int srvInqDataSP(srvrec_t *srvp, float *data)
{
  return (srvInqData(srvp, SINGLE_PRECISION, (void *) data));
}


int srvInqDataDP(srvrec_t *srvp, double *data)
{
  return (srvInqData(srvp, DOUBLE_PRECISION, (void *) data));
}


int srvDefData(srvrec_t *srvp, int prec, const void *data)
{
  static char func[] = "srvDefData";
  size_t datasize;
  size_t blocklen;
  size_t buffersize;
  size_t i;
  int dprec, hprec;
  int *header;
  void *buffer;


  if ( srvDefaultDprec ) dprec = srvDefaultDprec;
  else                   dprec = srvp->dprec;

  if ( ! dprec ) dprec = prec;

  srvp->dprec = dprec;

  if ( srvDefaultHprec ) hprec = srvDefaultHprec;
  else                   hprec = srvp->hprec;

  if ( ! hprec ) hprec = dprec;
  
  srvp->hprec = hprec;

  header = srvp->header;

  datasize = header[4]*header[5];
  blocklen = datasize * dprec;

  srvp->datasize = datasize;

  buffersize = srvp->buffersize;

  if ( buffersize != blocklen )
    {
      buffersize = blocklen;
      buffer = srvp->buffer;
      buffer = realloc(buffer, buffersize);
      srvp->buffer = buffer;
      srvp->buffersize = buffersize;
    }
  else
    buffer = srvp->buffer;

  switch ( dprec )
    {
    case SINGLE_PRECISION:
      {
	if ( dprec == prec )
	  memcpy(buffer, data, datasize*sizeof(FLT32));
	else
	  for (i = 0; i < datasize; i++)
	    ((float *) buffer)[i] = (float) ((double *) data)[i];

	break;
      }
    case DOUBLE_PRECISION:
      {
	if ( dprec == prec )
	  memcpy(buffer, data, datasize*sizeof(FLT64));
	else
	  for (i = 0; i < datasize; i++)
	    ((double *) buffer)[i] = (double) ((float *) data)[i];

	break;
      }
    default:
      {
	Error(func, "unexpected data precision %d", dprec);
      }
    }

  return (0);
}


int srvDefDataSP(srvrec_t *srvp, const float *data)
{
  return (srvDefData(srvp, SINGLE_PRECISION, (void *) data));
}


int srvDefDataDP(srvrec_t *srvp, const double *data)
{
  return (srvDefData(srvp, DOUBLE_PRECISION, (void *) data));
}


int srvRead(int fileID, srvrec_t *srvp)
{
  static char func[] = "srvRead";
  size_t datasize;
  size_t blocklen, blocklen2;
  size_t i;
  char tempheader[64];
  int hprec, dprec;
  void *buffer;
  int buffersize;
  int byteswap;
  int status;

  if ( ! srvp->checked )
    {
      status = srvCheckFiletype(fileID, &srvp->byteswap);
      if ( status == 0 ) Error(func, "Not a SERVICE file!");
      srvp->checked = 1;
    }

  byteswap = srvp->byteswap;

  /* read header record */
  blocklen = binReadF77Block(fileID, byteswap);

  if ( fileEOF(fileID) ) return (-1);

  if ( SRV_Debug )
    Message(func, "blocklen = %lu", blocklen);

  hprec = blocklen / SRV_HEADER_LEN;

  srvp->hprec = hprec;

  switch ( hprec )
    {
    case SINGLE_PRECISION:
      {
	binReadInt32(fileID, byteswap, SRV_HEADER_LEN, (INT32 *) tempheader);

	for ( i = 0; i < SRV_HEADER_LEN; i++ )
          srvp->header[i] = (int) ((INT32 *) tempheader)[i];

	break;
      }
    case DOUBLE_PRECISION:
      {
	binReadInt64(fileID, byteswap, SRV_HEADER_LEN, (INT64 *) tempheader);

	for ( i = 0; i < SRV_HEADER_LEN; i++ )
          srvp->header[i] = (int) ((INT64 *) tempheader)[i];

	break;
      }
    default:
      {
	Error(func, "unexpected header precision %d", hprec);
      }
    }

  blocklen2 = binReadF77Block(fileID, byteswap);

  if ( blocklen2 != blocklen )
    {
      Warning(func, "header blocklen differ!");
      return (-1);
    }

  srvp->datasize = srvp->header[4]*srvp->header[5];

  if ( SRV_Debug )
    Message(func, "datasize = %lu", srvp->datasize);

  blocklen = binReadF77Block(fileID, byteswap);

  buffersize = srvp->buffersize;

  if ( buffersize < (int) blocklen )
    {
      buffersize = blocklen;
      buffer = srvp->buffer;
      buffer = realloc(buffer, buffersize);
      srvp->buffer = buffer;
      srvp->buffersize = buffersize;
    }
  else
    buffer = srvp->buffer;

  datasize = srvp->datasize;

  dprec = blocklen / datasize;

  srvp->dprec = dprec;

  if ( dprec != SINGLE_PRECISION && dprec != DOUBLE_PRECISION )
    {
      Warning(func, "unexpected data precision %d", dprec);
      return (-1);
    }

  fileRead(fileID, buffer, blocklen);

  blocklen2 = binReadF77Block(fileID, byteswap);

  if ( blocklen2 != blocklen )
    {
      Warning(func, "data blocklen differ!");
      return (-1);
    }

  return (0);
}


int srvWrite(int fileID, srvrec_t *srvp)
{
  static char func[] = "srvWrite";
  size_t datasize;
  size_t blocklen;
  size_t i;
  int dprec, hprec;
  char tempheader[64];
  int *header;
  void *buffer;
  int byteswap = srvp->byteswap;


  dprec  = srvp->dprec;
  hprec  = srvp->hprec;
  header = srvp->header;

  /* write header record */
  blocklen = SRV_HEADER_LEN * hprec;

  binWriteF77Block(fileID, byteswap, blocklen);

  switch ( hprec )
    {
    case SINGLE_PRECISION:
      {
	for (i = 0; i < SRV_HEADER_LEN; i++)
          ((INT32 *) tempheader)[i] = (INT32) header[i];

	binWriteInt32(fileID, byteswap, SRV_HEADER_LEN, (INT32 *) tempheader);

	break;
      }
    case DOUBLE_PRECISION:
      {
	for (i = 0; i < SRV_HEADER_LEN; i++)
          ((INT64 *) tempheader)[i] = (INT64) header[i];

	binWriteInt64(fileID, byteswap, SRV_HEADER_LEN, (INT64 *) tempheader);

	break;
      }
    default:
      {
	Error(func, "unexpected header precision %d", hprec);
      }
    }
  
  binWriteF77Block(fileID, byteswap, blocklen);

  datasize = header[4]*header[5];
  blocklen = datasize * dprec;

  binWriteF77Block(fileID, byteswap, blocklen);

  srvp->datasize = datasize;

  buffer = srvp->buffer;

  switch ( dprec )
    {
    case SINGLE_PRECISION:
      {
	binWriteFlt32(fileID, byteswap, datasize, (FLT32 *) buffer);
	break;
      }
    case DOUBLE_PRECISION:
      {
	binWriteFlt64(fileID, byteswap, datasize, (FLT64 *) buffer);
	break;
      }
    default:
      {
	Error(func, "unexpected data precision %d", dprec);
      }
    }

  binWriteF77Block(fileID, byteswap, blocklen);

  return (0);
}
#if defined (HAVE_CONFIG_H)
#endif





#define  SINGLE_PRECISION    4
#define  DOUBLE_PRECISION    8

#define  EXT_HEADER_LEN      4


static int initExtLib       = 0;
static int extDefaultPrec   = 0;
static int extDefaultNumber = EXT_REAL;


/*
 * A version string.
 */

#undef  LIBVERSION
#define LIBVERSION      1.2.0
#define XSTRING(x)	#x
#define STRING(x)	XSTRING(x)
static const char ext_libvers[] = STRING(LIBVERSION) " of "__DATE__" "__TIME__;

const char *extLibraryVersion(void)
{
  return (ext_libvers);
}


int EXT_Debug = 0;    /* If set to 1, debugging */


void extDebug(int debug)
{
  static char func[] = "extDebug";

  EXT_Debug = debug;

  if ( EXT_Debug )
    Message(func, "debug level %d", debug);
}


void extLibInit()
{
  static char func[] = "extLibInit";
  char *envString;
  char *envName = "EXT_PRECISION";


  envString = getenv(envName);
  if ( envString )
    {
      int pos = 0;

      if ( strlen(envString) == 2  )
	{
	  switch ( tolower((int) envString[pos]) )
	    {
	    case 'r':
	      {
		extDefaultNumber = EXT_REAL;
		switch ( (int) envString[pos+1] )
		  {
		  case '4': extDefaultPrec = SINGLE_PRECISION; break;
		  case '8': extDefaultPrec = DOUBLE_PRECISION; break;
		  default:
		    Message(func, "Invalid digit in %s: %s", envName, envString);
		  }
		break;		
	      }
	    case 'c':
	      {
		extDefaultNumber = EXT_COMP;
		switch ( (int) envString[pos+1] )
		  {
		  case '4': extDefaultPrec = SINGLE_PRECISION; break;
		  case '8': extDefaultPrec = DOUBLE_PRECISION; break;
		  default:
		    Message(func, "Invalid digit in %s: %s", envName, envString);
		  }
		break;		
	      }
	    default:
	      Message(func, "Invalid character in %s: %s", envName, envString);
	    }
	}
    }

  initExtLib = 1;
}

static
void extInit(extrec_t *extp)
{
  extp->checked    = 0;
  extp->byteswap   = 0;
  extp->prec       = 0;
  extp->number     = extDefaultNumber;
  extp->datasize   = 0;
  extp->buffersize = 0;
  extp->buffer     = NULL;
}


void *extNew(void)
{
  static char func[] = "extNew";
  extrec_t *extp;

  if ( ! initExtLib ) extLibInit();

  extp = (extrec_t *) malloc(sizeof(extrec_t));

  extInit(extp);

  return ((void*)extp);
}


void extDelete(void *ext)
{
  static char func[] = "extDelete";
  extrec_t *extp = (extrec_t *) ext;

  if ( extp )
    {
      if ( extp->buffer ) free(extp->buffer);
      free(extp);
    }
}


int extCheckFiletype(int fileID, int *swap)
{
  static char func[] = "extCheckFiletype";
  size_t blocklen = 0;
  size_t sblocklen = 0;
  size_t data =  0;
  size_t dimxy = 0;
  int fact = 0, found = 0;
  unsigned char buffer[40], *pbuf;

  if ( fileRead(fileID, buffer, 4) != 4 ) return (found);

  blocklen  = (size_t) get_UINT32(buffer);
  sblocklen = (size_t) get_SUINT32(buffer);

  if ( EXT_Debug )
    Message(func, "blocklen = %d sblocklen = %d", blocklen, sblocklen);

  if ( blocklen == 16 )
    {
     *swap = 0;
      fact = blocklen/4;
      if ( fileRead(fileID, buffer, blocklen+8) != blocklen+8 ) return (found);
      pbuf = buffer+3*fact;      dimxy = (size_t) get_UINT32(pbuf);
      pbuf = buffer+blocklen+4;  data  = (size_t) get_UINT32(pbuf);
    }
  else if ( blocklen == 32 )
    {
     *swap = 0;
      fact = blocklen/4;
      if ( fileRead(fileID, buffer, blocklen+8) != blocklen+8 ) return (found);
      pbuf = buffer+3*fact;      dimxy = (size_t) get_UINT64(pbuf);
      pbuf = buffer+blocklen+4;  data  = (size_t) get_UINT32(pbuf);
    }
  else if ( sblocklen == 16 )
    {
     *swap = 1;
      fact = sblocklen/4;
      if ( fileRead(fileID, buffer, sblocklen+8) != sblocklen+8 ) return (found);
      pbuf = buffer+3*fact;       dimxy = (size_t) get_SUINT32(pbuf);
      pbuf = buffer+sblocklen+4;  data  = (size_t) get_SUINT32(pbuf);
    }
  else if ( sblocklen == 32 )
    {
     *swap = 1;
      fact = sblocklen/4;
      if ( fileRead(fileID, buffer, sblocklen+8) != sblocklen+8 ) return (found);
      pbuf = buffer+3*fact;       dimxy = (size_t) get_SUINT64(pbuf);
      pbuf = buffer+sblocklen+4;  data  = (size_t) get_SUINT32(pbuf);
    }

  fileRewind(fileID);

  if      ( data && dimxy*fact   == data ) found = 1;
  else if ( data && dimxy*fact*2 == data ) found = 1;

  if ( EXT_Debug )
    {
      Message(func, "swap = %d fact = %d", *swap, fact);
      Message(func, "dimxy = %lu data = %lu", dimxy, data);
    }

  return (found);
}


int extInqHeader(void *ext, int *header)
{
  static char func[] = "extInqHeader";
  extrec_t *extp = (extrec_t *) ext;
  size_t i;

  for ( i = 0; i < EXT_HEADER_LEN; i++ )
    header[i] = extp->header[i];
  
  if ( EXT_Debug ) Message(func, "datasize = %lu", extp->datasize);

  return (0);
}


int extDefHeader(void *ext, const int *header)
{
  static char func[] = "extDefHeader";
  extrec_t *extp = (extrec_t *) ext;
  size_t i;

  for ( i = 0; i < EXT_HEADER_LEN; i++ )
    extp->header[i] = header[i];
  
  extp->datasize = header[3];
  if ( extp->number == EXT_COMP ) extp->datasize *= 2;

  if ( EXT_Debug ) Message(func, "datasize = %lu", extp->datasize);

  return (0);
}


int extInqData(void *ext, int prec, void *data)
{
  static char func[] = "extInqData";
  extrec_t *extp = (extrec_t *) ext;
  size_t datasize;
  size_t i;
  int ierr = 0;
  int rprec, number;
  void *buffer;
  int byteswap = extp->byteswap;

  datasize = extp->datasize;
  buffer   = extp->buffer;
  rprec    = extp->prec;
  number   = extp->number;

  switch ( rprec )
    {
    case SINGLE_PRECISION:
      {
	if ( sizeof(FLT32) == 4 )
	  {
	    if ( byteswap ) swap4byte(buffer, datasize);

	    if ( rprec == prec )
	      memcpy(data, buffer, datasize*sizeof(FLT32));
	    else
	      for ( i = 0; i < datasize; ++i )
		((double *) data)[i] = (double) ((float *) buffer)[i];
	  }
	else
	  {
	    Error(func, "not implemented for %d byte float", sizeof(FLT32));
	  }	
	break;
      }
    case DOUBLE_PRECISION:
	if ( sizeof(FLT64) == 8 )
	  {
	    if ( byteswap ) swap8byte(buffer, datasize);

	    if ( rprec == prec )
	      memcpy(data, buffer, datasize*sizeof(FLT64));
	    else
	      for ( i = 0; i < datasize; ++i )
		((float *) data)[i] = (float) ((double *) buffer)[i];
	  }
	else
	  {
	    Error(func, "not implemented for %d byte float", sizeof(FLT64));
	  }	
	break;
    default:
      {
	Error(func, "unexpected data precision %d", rprec);
      }
    }

  return (ierr);
}


int extInqDataSP(void *ext, float *data)
{
  return (extInqData(ext, SINGLE_PRECISION, (void *) data));
}


int extInqDataDP(void *ext, double *data)
{
  return (extInqData(ext, DOUBLE_PRECISION, (void *) data));
}


int extDefData(void *ext, int prec, const void *data)
{
  static char func[] = "extDefData";
  extrec_t *extp = (extrec_t *) ext;
  size_t datasize;
  size_t blocklen;
  size_t buffersize;
  size_t i;
  int rprec;
  int *header;
  void *buffer;

  if ( extDefaultPrec ) rprec = extDefaultPrec;
  else                  rprec = extp->prec;

  if ( ! rprec ) rprec = prec;

  extp->prec = rprec;

  header = extp->header;

  datasize = header[3];
  if ( extp->number == EXT_COMP ) datasize *= 2;
  blocklen = datasize * rprec;

  extp->datasize = datasize;

  buffersize = extp->buffersize;

  if ( buffersize != blocklen )
    {
      buffersize = blocklen;
      buffer = extp->buffer;
      buffer = realloc(buffer, buffersize);
      extp->buffer = buffer;
      extp->buffersize = buffersize;
    }
  else
    buffer = extp->buffer;

  switch ( rprec )
    {
    case SINGLE_PRECISION:
      {
	if ( rprec == prec )
	  memcpy(buffer, data, datasize*sizeof(FLT32));
	else
	  for (i = 0; i < datasize; i++)
	    ((float *) buffer)[i] = (float) ((double *) data)[i];

	break;
      }
    case DOUBLE_PRECISION:
      {
	if ( rprec == prec )
	  memcpy(buffer, data, datasize*sizeof(FLT64));
	else
	  for (i = 0; i < datasize; i++)
	    ((double *) buffer)[i] = (double) ((float *) data)[i];

	break;
      }
    default:
      {
	Error(func, "unexpected data precision %d", rprec);
      }
    }

  return (0);
}


int extDefDataSP(void *ext, const float *data)
{
  return (extDefData(ext, SINGLE_PRECISION, (void *) data));
}


int extDefDataDP(void *ext, const double *data)
{
  return (extDefData(ext, DOUBLE_PRECISION, (void *) data));
}


int extRead(int fileID, void *ext)
{
  static char func[] = "extRead";
  extrec_t *extp = (extrec_t *) ext;
  size_t blocklen, blocklen2;
  size_t i;
  char tempheader[32];
  int hprec, dprec;
  void *buffer;
  int buffersize;
  int byteswap;
  int status;

  if ( ! extp->checked )
    {
      status = extCheckFiletype(fileID, &extp->byteswap);
      if ( status == 0 ) Error(func, "Not a EXTRA file!");
      extp->checked = 1;
    }

  byteswap = extp->byteswap;

  /* read header record */
  blocklen = binReadF77Block(fileID, byteswap);

  if ( fileEOF(fileID) ) return (-1);

  if ( EXT_Debug )
    Message(func, "blocklen = %lu", blocklen);

  hprec = blocklen / EXT_HEADER_LEN;

  extp->prec = hprec;

  switch ( hprec )
    {
    case SINGLE_PRECISION:
      {
	binReadInt32(fileID, byteswap, EXT_HEADER_LEN, (INT32 *) tempheader);

	for ( i = 0; i < EXT_HEADER_LEN; i++ )
          extp->header[i] = (int) ((INT32 *) tempheader)[i];

	break;
      }
    case DOUBLE_PRECISION:
      {
	binReadInt64(fileID, byteswap, EXT_HEADER_LEN, (INT64 *) tempheader);

	for ( i = 0; i < EXT_HEADER_LEN; i++ )
          extp->header[i] = (int) ((INT64 *) tempheader)[i];

	break;
      }
    default:
      {
	Error(func, "unexpected header precision %d", hprec);
      }
    }

  blocklen2 = binReadF77Block(fileID, byteswap);

  if ( blocklen2 != blocklen )
    {
      Warning(func, "header blocklen differ!");
      return (-1);
    }

  extp->datasize = extp->header[3];

  if ( EXT_Debug ) Message(func, "datasize = %lu", extp->datasize);

  blocklen = binReadF77Block(fileID, byteswap);

  buffersize = extp->buffersize;

  if ( buffersize < (int) blocklen )
    {
      buffersize = blocklen;
      buffer = extp->buffer;
      buffer = realloc(buffer, buffersize);
      extp->buffer = buffer;
      extp->buffersize = buffersize;
    }
  else
    buffer = extp->buffer;

  dprec = blocklen / extp->datasize;

  if ( dprec == hprec )
    {
      extp->number = EXT_REAL;
    }
  else if ( dprec == 2*hprec )
    {
      dprec /= 2;
      extp->datasize *= 2;
      extp->number = EXT_COMP;
    }

  if ( dprec != SINGLE_PRECISION && dprec != DOUBLE_PRECISION )
    {
      Warning(func, "unexpected data precision %d", dprec);
      return (-1);
    }

  fileRead(fileID, buffer, blocklen);

  blocklen2 = binReadF77Block(fileID, byteswap);

  if ( blocklen2 != blocklen )
    {
      Warning(func, "data blocklen differ!");
      return (-1);
    }

  return (0);
}


int extWrite(int fileID, void *ext)
{
  static char func[] = "extWrite";
  extrec_t *extp = (extrec_t *) ext;
  size_t datasize;
  size_t blocklen;
  size_t i;
  int rprec, number;
  char tempheader[32];
  int *header;
  void *buffer;
  int byteswap = extp->byteswap;


  rprec  = extp->prec;
  number = extp->number;
  header = extp->header;

  /* write header record */
  blocklen = EXT_HEADER_LEN * rprec;

  binWriteF77Block(fileID, byteswap, blocklen);

  switch ( rprec )
    {
    case SINGLE_PRECISION:
      {
	for (i = 0; i < EXT_HEADER_LEN; i++)
          ((INT32 *) tempheader)[i] = (INT32) header[i];

	binWriteInt32(fileID, byteswap, EXT_HEADER_LEN, (INT32 *) tempheader);

	break;
      }
    case DOUBLE_PRECISION:
      {
	for (i = 0; i < EXT_HEADER_LEN; i++)
          ((INT64 *) tempheader)[i] = (INT64) header[i];

	binWriteInt64(fileID, byteswap, EXT_HEADER_LEN, (INT64 *) tempheader);

	break;
      }
    default:
      {
	Error(func, "unexpected header precision %d", rprec);
      }
    }
  
  binWriteF77Block(fileID, byteswap, blocklen);

  datasize = header[3];
  if ( number == EXT_COMP ) datasize *= 2;
  blocklen = datasize * rprec;

  binWriteF77Block(fileID, byteswap, blocklen);

  extp->datasize = datasize;

  buffer = extp->buffer;

  switch ( rprec )
    {
    case SINGLE_PRECISION:
      {
	binWriteFlt32(fileID, byteswap, datasize, (FLT32 *) buffer);
	break;
      }
    case DOUBLE_PRECISION:
      {
	binWriteFlt64(fileID, byteswap, datasize, (FLT64 *) buffer);
	break;
      }
    default:
      {
	Error(func, "unexpected data precision %d", rprec);
      }
    }

  binWriteF77Block(fileID, byteswap, blocklen);

  return (0);
}
#if defined (HAVE_CONFIG_H)
#endif





#define SINGLE_PRECISION  4
#define DOUBLE_PRECISION  8


static int initIegLib      = 0;
static int iegDefaultDprec = 0;


/*
 * A version string.
 */

#undef  LIBVERSION
#define LIBVERSION      1.2.0
#define XSTRING(x)	#x
#define STRING(x)	XSTRING(x)
static const char ieg_libvers[] = STRING(LIBVERSION) " of "__DATE__" "__TIME__;

const char *iegLibraryVersion(void)
{
  return (ieg_libvers);
}


int IEG_Debug = 0;    /* If set to 1, debugging */



void iegLibInit()
{
  static char func[] = "iegLibInit";
  char *envString;
  char *envName = "IEG_PRECISION";


  envString = getenv(envName);
  if ( envString )
    {
      int pos;
      int nrun;
      if ( strlen(envString) == 2 ) nrun = 1;
      else                          nrun = 2;

      pos = 0;
      while ( nrun-- )
	{
	  switch ( tolower((int) envString[pos]) )
	    {
	    case 'r':
	      {
		switch ( (int) envString[pos+1] )
		  {
		  case '4': iegDefaultDprec = SINGLE_PRECISION; break;
		  case '8': iegDefaultDprec = DOUBLE_PRECISION; break;
		  default:
		    Message(func, "Invalid digit in %s: %s", envName, envString);
		  }
		break;		
	      }
	    default:
	      Message(func, "Invalid character in %s: %s", envName, envString);
	    }
	  pos += 2;
	}
    }

  initIegLib = 1;
}


void iegDebug(int debug)
{
  static char func[] = "iegDebug";

  IEG_Debug = debug;

  if ( IEG_Debug )
    Message(func, "debug level %d", debug);
}


void iegInit(iegrec_t *iegp)
{
  iegp->checked    = 0;
  iegp->byteswap   = 0;
  iegp->dprec      = 0;
  iegp->refval     = 0;
  iegp->datasize   = 0;
  iegp->buffersize = 0;
  iegp->buffer     = NULL;
}


void iegInitMem(iegrec_t *iegp)
{
  memset(iegp->ipdb, 0, sizeof(iegp->ipdb));
  memset(iegp->igdb, 0, sizeof(iegp->igdb));
  memset(iegp->vct,  0, sizeof(iegp->vct));
}


iegrec_t *iegNew(void)
{
  static char func[] = "iegNew";
  iegrec_t *iegp;

  if ( ! initIegLib ) iegLibInit();

  iegp = (iegrec_t *) malloc(sizeof(iegrec_t));

  iegInit(iegp);
  iegInitMem(iegp);

  return (iegp);
}


void iegDelete(iegrec_t *iegp)
{
  static char func[] = "iegDelete";

  if ( iegp )
    {
      if ( iegp->buffer ) free(iegp->buffer);
      free(iegp);
    }
}


int iegCheckFiletype(int fileID, int *swap)
{
  static char func[] = "iegCheckFiletype";
  size_t blocklen = 0;
  size_t sblocklen = 0;
  size_t data = 0;
  size_t dimx = 0, dimy = 0;
  int fact = 0, found = 0;
  unsigned char buffer[1048], *pbuf;

  if ( fileRead(fileID, buffer, 4) != 4 ) return (found);

  blocklen  = get_UINT32(buffer);
  sblocklen = get_SUINT32(buffer);

  if ( IEG_Debug )
    Message(func, "blocklen = %d sblocklen = %d", blocklen, sblocklen);

  if ( blocklen == 636 || blocklen == 640 )
    {
     *swap = 0;
      fact = 4;
      if ( fileRead(fileID, buffer, blocklen+8) != blocklen+8 ) return (found);
      pbuf = buffer+(37+4)*4;    dimx = (size_t) get_UINT32(pbuf);
      pbuf = buffer+(37+5)*4;    dimy = (size_t) get_UINT32(pbuf);
      pbuf = buffer+blocklen+4;  data = (size_t) get_UINT32(pbuf);
    }
  else if ( blocklen == 1040 || blocklen == 1036 )
    {
     *swap = 0;
      fact = 8;
      if ( fileRead(fileID, buffer, blocklen+8) != blocklen+8 ) return (found);
      pbuf = buffer+(37+4)*4;    dimx = (size_t) get_UINT32(pbuf);
      pbuf = buffer+(37+5)*4;    dimy = (size_t) get_UINT32(pbuf);
      pbuf = buffer+blocklen+4;  data = (size_t) get_UINT32(pbuf);
    }
  else if ( sblocklen == 636 || sblocklen == 640 )
    {
     *swap = 1;
      fact = 4;
      if ( fileRead(fileID, buffer, sblocklen+8) != sblocklen+8 ) return (found);
      pbuf = buffer+(37+4)*4;     dimx = (size_t) get_SUINT32(pbuf);
      pbuf = buffer+(37+5)*4;     dimy = (size_t) get_SUINT32(pbuf);
      pbuf = buffer+sblocklen+4;  data = (size_t) get_SUINT32(pbuf);
    }
  else if ( sblocklen == 1040 || sblocklen == 1036 )
    {
     *swap = 1;
      fact = 8;
      if ( fileRead(fileID, buffer, sblocklen+8) != sblocklen+8 ) return (found);
      pbuf = buffer+(37+4)*4;     dimx = (size_t) get_SUINT32(pbuf);
      pbuf = buffer+(37+5)*4;     dimy = (size_t) get_SUINT32(pbuf);
      pbuf = buffer+sblocklen+4;  data = (size_t) get_SUINT32(pbuf);
    }

  fileRewind(fileID);

  if      ( data && dimx*dimy*fact == data ) found = 1;
  else if ( data && dimx*dimy*8    == data ) found = 1;

  if ( IEG_Debug )
    {
      Message(func, "swap = %d fact = %d", *swap, fact);
      Message(func, "dimx = %lu dimy = %lu data = %lu", dimx, dimy, data);
    }

  return (found);
}


void iegCopyMeta(iegrec_t *diegp, iegrec_t *siegp)
{
  /*  diegp->byteswap = siegp->byteswap; */
  diegp->dprec    = siegp->dprec;
  diegp->refval   = siegp->refval;

  memcpy(diegp->ipdb, siegp->ipdb, sizeof(siegp->ipdb));
  memcpy(diegp->igdb, siegp->igdb, sizeof(siegp->igdb));
  memcpy(diegp->vct,  siegp->vct,  sizeof(siegp->vct));
}


int iegInqData(iegrec_t *iegp, int prec, void *data)
{
  static char func[] = "iegInqData";
  size_t datasize;
  size_t i;
  int ierr = 0;
  int dprec;
  void *buffer;
  int byteswap = iegp->byteswap;


  datasize = iegp->datasize;

  buffer = iegp->buffer;

  dprec = iegp->dprec;

  switch ( dprec )
    {
    case SINGLE_PRECISION:
      {
	if ( sizeof(FLT32) == 4 )
	  {
	    if ( byteswap ) swap4byte(buffer, datasize);

	    if ( dprec == prec )
	      memcpy(data, buffer, datasize*sizeof(FLT32));
	    else
	      for (i = 0; i < datasize; i++)
		((double *) data)[i] = (double) ((float *) buffer)[i];
	  }
	else
	  {
	    Error(func, "not implemented for %d byte float", sizeof(FLT32));
	  }	
	break;
      }
    case DOUBLE_PRECISION:
	if ( sizeof(FLT64) == 8 )
	  {
	    if ( byteswap ) swap8byte(buffer, datasize);

	    if ( dprec == prec )
	      memcpy(data, buffer, datasize*sizeof(FLT64));
	    else
	      for (i = 0; i < datasize; i++)
		((float *) data)[i] = (float) ((double *) buffer)[i];
	  }
	else
	  {
	    Error(func, "not implemented for %d byte float", sizeof(FLT64));
	  }	
	break;
    default:
      {
	Error(func, "unexpected data precision %d", dprec);
      }
    }

  return (ierr);
}


int iegInqDataSP(iegrec_t *iegp, float *data)
{
  return (iegInqData(iegp, SINGLE_PRECISION, (void *) data));
}


int iegInqDataDP(iegrec_t *iegp, double *data)
{
  return (iegInqData(iegp, DOUBLE_PRECISION, (void *) data));
}


int iegDefData(iegrec_t *iegp, int prec, const void *data)
{
  static char func[] = "iegDefData";
  size_t datasize;
  size_t blocklen;
  size_t buffersize;
  size_t i;
  int dprec;
  void *buffer;


  if ( iegDefaultDprec ) dprec = iegDefaultDprec;
  else                   dprec = iegp->dprec;

  if ( ! dprec ) dprec = prec;

  iegp->dprec = dprec;

  datasize = IEG_G_NumLon(iegp->igdb)*IEG_G_NumLat(iegp->igdb);
  blocklen = datasize * dprec;

  iegp->datasize = datasize;

  buffersize = iegp->buffersize;

  if ( buffersize != blocklen )
    {
      buffersize = blocklen;
      buffer = iegp->buffer;
      buffer = realloc(buffer, buffersize);
      iegp->buffer = buffer;
      iegp->buffersize = buffersize;
    }
  else
    buffer = iegp->buffer;

  switch ( dprec )
    {
    case SINGLE_PRECISION:
      {
	if ( dprec == prec )
	  memcpy(buffer, data, datasize*sizeof(FLT32));
	else
	  for (i = 0; i < datasize; i++)
	    ((float *) buffer)[i] = (float) ((double *) data)[i];

	break;
      }
    case DOUBLE_PRECISION:
      {
	if ( dprec == prec )
	  memcpy(buffer, data, datasize*sizeof(FLT64));
	else
	  for (i = 0; i < datasize; i++)
	    ((double *) buffer)[i] = (double) ((float *) data)[i];

	break;
      }
    default:
      {
	Error(func, "unexpected data precision %d", dprec);
      }
    }

  return (0);
}


int iegDefDataSP(iegrec_t *iegp, const float *data)
{
  return (iegDefData(iegp, SINGLE_PRECISION, (void *) data));
}


int iegDefDataDP(iegrec_t *iegp, const double *data)
{
  return (iegDefData(iegp, DOUBLE_PRECISION, (void *) data));
}


int iegRead(int fileID, iegrec_t *iegp)
{
  static char func[] = "iegRead";
  size_t datasize;
  size_t blocklen, blocklen2;
  size_t i;
  char tmpbuf[800];
  int dprec = 0;
  void *buffer;
  int buffersize;
  int byteswap;
  int status;

  if ( ! iegp->checked )
    {
      status = iegCheckFiletype(fileID, &iegp->byteswap);
      if ( status == 0 ) Error(func, "Not a IEG file!");
      iegp->checked = 1;
    }

  byteswap = iegp->byteswap;

  /* read header record */
  blocklen = binReadF77Block(fileID, byteswap);

  if ( fileEOF(fileID) ) return (-1);

  if ( IEG_Debug )
    Message(func, "blocklen = %lu", blocklen);

  if ( blocklen == 636 || blocklen == 640 )
    dprec = 4;
  else if ( blocklen == 1040 || blocklen == 1036 )
    dprec = 8;
  else
    {
      Warning(func, "unexpecteted header size %d!", (int) blocklen);
      return (-1);
    }

  iegp->dprec = dprec;

  binReadInt32(fileID, byteswap, 37, (INT32 *) tmpbuf);
  for ( i = 0; i < 37; i++ ) iegp->ipdb[i] = (int) ((INT32 *) tmpbuf)[i];

  binReadInt32(fileID, byteswap, 18, (INT32 *) tmpbuf);
  for ( i = 0; i < 18; i++ ) iegp->igdb[i] = (int) ((INT32 *) tmpbuf)[i];

  if ( blocklen == 636 || blocklen == 1036 )
    {
      fileRead(fileID, tmpbuf, 4);
      if ( byteswap ) swap4byte(tmpbuf, 1);
      iegp->refval = (double) ((float *) tmpbuf)[0];
    }
  else
    {
      fileRead(fileID, tmpbuf, 8);
      if ( byteswap ) swap8byte(tmpbuf, 1);
      iegp->refval = (double) ((double *) tmpbuf)[0];
    }

  binReadInt32(fileID, byteswap, 3, (INT32 *) tmpbuf);
  for ( i = 0; i < 3; i++ ) iegp->igdb[18+i] = (int) ((INT32 *) tmpbuf)[i];

  if ( dprec == SINGLE_PRECISION )
    {
      fileRead(fileID, tmpbuf, 400);
      if ( byteswap ) swap4byte(tmpbuf, 100);
      for ( i = 0; i < 100; i++ )
	iegp->vct[i] = (double) ((float *) tmpbuf)[i];
    }
  else
    {
      fileRead(fileID, tmpbuf, 800);
      if ( byteswap ) swap8byte(tmpbuf, 100);
      for ( i = 0; i < 100; i++ )
	iegp->vct[i] = (double) ((double *) tmpbuf)[i];
    }
  
  /*
  fprintf(stderr, "refval %g\n", iegp->refval);

  for ( i = 0; i < 100; i++ )
    fprintf(stderr, "%3d %g\n", i, iegp->vct[i]);
  
  {
    int i;
    for ( i = 0; i < 37; i++ )
      fprintf(stderr, "pdb: %d %d\n", i, iegp->ipdb[i]);
    for ( i = 0; i < 22; i++ )
      fprintf(stderr, "gdb: %d %d\n", i, iegp->igdb[i]);
  }
  */
  blocklen2 = binReadF77Block(fileID, byteswap);

  if ( blocklen2 != blocklen )
    {
      Warning(func, "header blocklen differ!");
      return (-1);
    }

  iegp->datasize = IEG_G_NumLon(iegp->igdb)*IEG_G_NumLat(iegp->igdb);

  if ( IEG_Debug )
    Message(func, "datasize = %lu", iegp->datasize);

  blocklen = binReadF77Block(fileID, byteswap);

  buffersize = iegp->buffersize;

  if ( buffersize < (int) blocklen )
    {
      buffersize = blocklen;
      buffer = iegp->buffer;
      buffer = realloc(buffer, buffersize);
      iegp->buffer = buffer;
      iegp->buffersize = buffersize;
    }
  else
    buffer = iegp->buffer;

  datasize = iegp->datasize;

  if ( dprec != (int) (blocklen/datasize) )
    {
      Warning(func, "data precision differ! (h = %d; d = %d)",
	      (int) dprec, (int) (blocklen/datasize));
      return (-1);
    }

  fileRead(fileID, buffer, blocklen);

  blocklen2 = binReadF77Block(fileID, byteswap);

  if ( blocklen2 != blocklen )
    {
      Warning(func, "data blocklen differ!");
      return (-1);
    }

  return (0);
}


int iegWrite(int fileID, iegrec_t *iegp)
{
  static char func[] = "iegWrite";
  size_t datasize;
  size_t blocklen;
  size_t i;
  int dprec;
  float refvalf;
  double refval;
  char tmpbuf[800];
  float fvct[100];
  void *buffer;
  int byteswap = iegp->byteswap;


  dprec  = iegp->dprec;

  /* write header record */
  if ( dprec == SINGLE_PRECISION )
    blocklen = 636;
  else
    blocklen = 1040;

  binWriteF77Block(fileID, byteswap, blocklen);

  for ( i = 0; i < 37; i++ ) ((INT32 *) tmpbuf)[i] = (INT32) iegp->ipdb[i];
  binWriteInt32(fileID, byteswap, 37, (INT32 *) tmpbuf);

  for ( i = 0; i < 18; i++ ) ((INT32 *) tmpbuf)[i] = (INT32) iegp->igdb[i];
  binWriteInt32(fileID, byteswap, 18, (INT32 *) tmpbuf);

  refval = iegp->refval;
  refvalf = (float) refval;
  if ( dprec == SINGLE_PRECISION )
    binWriteFlt32(fileID, byteswap, 1, (FLT32 *) &refvalf);
  else
    binWriteFlt64(fileID, byteswap, 1, (FLT64 *) &refval);

  for ( i = 0; i < 3; i++ ) ((INT32 *) tmpbuf)[i] = (INT32) iegp->igdb[18+i];
  binWriteInt32(fileID, byteswap, 3, (INT32 *) tmpbuf);

  if ( dprec == SINGLE_PRECISION )
    {
      for ( i = 0; i < 100; i++ ) fvct[i] = (float) iegp->vct[i];
      binWriteFlt32(fileID, byteswap, 100, fvct);
    }
  else
    {
      binWriteFlt64(fileID, byteswap, 100, iegp->vct);
    }
  
  binWriteF77Block(fileID, byteswap, blocklen);

  datasize = iegp->igdb[4]*iegp->igdb[5];
  blocklen = datasize * dprec;

  binWriteF77Block(fileID, byteswap, blocklen);

  iegp->datasize = datasize;

  buffer = iegp->buffer;

  switch ( dprec )
    {
    case SINGLE_PRECISION:
      {
	binWriteFlt32(fileID, byteswap, datasize, (FLT32 *) buffer);
	break;
      }
    case DOUBLE_PRECISION:
      {
	binWriteFlt64(fileID, byteswap, datasize, (FLT64 *) buffer);
	break;
      }
    default:
      {
	Error(func, "unexpected data precision %d", dprec);
      }
    }

  binWriteF77Block(fileID, byteswap, blocklen);

  return (0);
}
#if defined (HAVE_CONFIG_H)
#endif




#ifndef  RAD2DEG
#define  RAD2DEG  (180./M_PI)   /* conversion for rad to deg */
#endif

#ifndef  DEG2RAD
#define  DEG2RAD  (M_PI/180.)   /* conversion for deg to rad */
#endif


char *Grids[] = {
  /*  0 */  "undefined",
  /*  1 */  "generic",
  /*  2 */  "gaussian",
  /*  3 */  "gaussian reduced",
  /*  4 */  "lonlat",
  /*  5 */  "spectral",
  /*  6 */  "fourier",
  /*  7 */  "gme",
  /*  8 */  "trajectory",
  /*  9 */  "cell",
  /* 10 */  "curvilinear",
  /* 11 */  "lcc",
  /* 12 */  "lcc2",
  /* 13 */  "laea",
  /* 14 */  "sinusoidal",
};


static int  GRID_Debug = 0;   /* If set to 1, debugging */

static int _grid_max = MAX_GRIDS;

static void grid_initialize(void);

static int _grid_init = FALSE;

#if  defined  (HAVE_LIBPTHREAD)

static pthread_once_t _grid_init_thread = PTHREAD_ONCE_INIT;
static pthread_mutex_t _grid_mutex;

#  define GRID_LOCK()         pthread_mutex_lock(&_grid_mutex)
#  define GRID_UNLOCK()       pthread_mutex_unlock(&_grid_mutex)
#  define GRID_INIT()        \
   if ( _grid_init == FALSE ) pthread_once(&_grid_init_thread, grid_initialize)

#else

#  define GRID_LOCK()
#  define GRID_UNLOCK()
#  define GRID_INIT()        \
   if ( _grid_init == FALSE ) grid_initialize()

#endif


typedef struct _gridPtrToIdx {
  int idx;
  grid_t *ptr;
  struct _gridPtrToIdx *next;
} gridPtrToIdx;


static gridPtrToIdx *_gridList  = NULL;
static gridPtrToIdx *_gridAvail = NULL;


static
void grid_list_new(void)
{
  static char func[] = "grid_list_new";

  assert(_gridList == NULL);

  _gridList = (gridPtrToIdx *) malloc(_grid_max*sizeof(gridPtrToIdx));
}

static
void grid_list_delete(void)
{
  static char func[] = "grid_list_delete";

  if ( _gridList ) free(_gridList);
}

static
void grid_init_pointer(void)
{
  int  i;
  
  for ( i = 0; i < _grid_max; i++ )
    {
      _gridList[i].next = _gridList + i + 1;
      _gridList[i].idx  = i;
      _gridList[i].ptr  = 0;
    }

  _gridList[_grid_max-1].next = 0;

  _gridAvail = _gridList;
}

static
grid_t *grid_to_pointer(int idx)
{
  static char func[] = "grid_to_pointer";
  grid_t *gridptr = NULL;

  GRID_INIT();

  if ( idx >= 0 && idx < _grid_max )
    {
      GRID_LOCK();

      gridptr = _gridList[idx].ptr;

      GRID_UNLOCK();
    }
  else
    Error(func, "grid index %d undefined!", idx);

  return (gridptr);
}

/* Create an index from a pointer */
static
int grid_from_pointer(grid_t *ptr)
{
  static char func[] = "grid_from_pointer";
  int      idx = -1;
  gridPtrToIdx *newptr;

  if ( ptr )
    {
      GRID_LOCK();

      if ( _gridAvail )
	{
	  newptr       = _gridAvail;
	  _gridAvail   = _gridAvail->next;
	  newptr->next = 0;
	  idx	       = newptr->idx;
	  newptr->ptr  = ptr;
      
	  if ( GRID_Debug )
	    Message(func, "Pointer %p has idx %d from grid list", ptr, idx);
	}
      else
	Warning(func, "Too many open grids (limit is %d)!", _grid_max);

      GRID_UNLOCK();
    }
  else
    Error(func, "Internal problem (pointer %p undefined)", ptr);

  return (idx);
}

static
void grid_init_entry(grid_t *gridptr)
{
  gridptr->self         = grid_from_pointer(gridptr);

  gridptr->type         = CDI_UNDEFID;
  gridptr->mask         = NULL;
  gridptr->xvals        = NULL;
  gridptr->yvals        = NULL;
  gridptr->area         = NULL;
  gridptr->xbounds      = NULL;
  gridptr->ybounds      = NULL;
  gridptr->rowlon       = NULL;
  gridptr->nrowlon      = 0;
  gridptr->xinc         = 0.0;
  gridptr->yinc         = 0.0;
  gridptr->lcc_originLon = 0.0;
  gridptr->lcc_originLat = 0.0;
  gridptr->lcc_lonParY  = 0.0;
  gridptr->lcc_lat1     = 0.0;
  gridptr->lcc_lat2     = 0.0;
  gridptr->lcc_xinc     = 0.0;
  gridptr->lcc_yinc     = 0.0;
  gridptr->lcc_projflag = 0;
  gridptr->lcc_scanflag = 0;
  gridptr->lcc_defined  = FALSE;
  gridptr->lcc2_lon_0   = 0.0;
  gridptr->lcc2_lat_0   = 0.0;
  gridptr->lcc2_lat_1   = 0.0;
  gridptr->lcc2_lat_2   = 0.0;
  gridptr->lcc2_a       = 0.0;
  gridptr->lcc2_defined = FALSE;
  gridptr->laea_lon_0   = 0.0;
  gridptr->laea_lat_0   = 0.0;
  gridptr->laea_a       = 0.0;
  gridptr->laea_defined = FALSE;
  gridptr->trunc        = 0;
  gridptr->nvertex      = 0;
  gridptr->nd           = 0;
  gridptr->ni           = 0;
  gridptr->ni2          = 0;
  gridptr->ni3          = 0;
  gridptr->prec         = 0;
  gridptr->size         = 0;
  gridptr->xsize        = 0;
  gridptr->ysize        = 0;
  gridptr->isCyclic     = CDI_UNDEFID;
  gridptr->isRotated    = FALSE;
  gridptr->xpole        = 0.0;
  gridptr->ypole        = 0.0;
  gridptr->angle        = 0.0;
  gridptr->locked       = FALSE;
  gridptr->lcomplex     = 0;
  gridptr->xname[0]     = 0;
  gridptr->yname[0]     = 0;
  gridptr->xlongname[0] = 0;
  gridptr->ylongname[0] = 0;
  gridptr->xunits[0]    = 0;
  gridptr->yunits[0]    = 0;
  gridptr->xstdname[0]  = 0;
  gridptr->ystdname[0]  = 0;
}

static
grid_t *grid_new_entry(void)
{
  static char func[] = "grid_new_entry";
  grid_t *gridptr;

  gridptr = (grid_t *) malloc(sizeof(grid_t));

  if ( gridptr ) grid_init_entry(gridptr);

  return (gridptr);
}

static
void grid_delete_entry(grid_t *gridptr)
{
  static char func[] = "grid_delete_entry";
  int idx;

  idx = gridptr->self;

  GRID_LOCK();

  free(gridptr);

  _gridList[idx].next = _gridAvail;
  _gridList[idx].ptr  = 0;
  _gridAvail          = &_gridList[idx];

  GRID_UNLOCK();

  if ( GRID_Debug )
    Message(func, "Removed idx %d from grid list", idx);
}

static
void grid_initialize(void)
{
  char *env;

#if  defined  (HAVE_LIBPTHREAD)
  /* initialize global API mutex lock */
  pthread_mutex_init(&_grid_mutex, NULL);
#endif

  env = getenv("GRID_DEBUG");
  if ( env ) GRID_Debug = atoi(env);

  grid_list_new();
  atexit(grid_list_delete);

  GRID_LOCK();

  grid_init_pointer();

  GRID_UNLOCK();

  _grid_init = TRUE;
}

static
void grid_copy(grid_t *gridptr2, grid_t *gridptr1)
{
  int gridID2;

  gridID2 = gridptr2->self;
  memcpy(gridptr2, gridptr1, sizeof(grid_t));
  gridptr2->self = gridID2;
}

static
void grid_check_ptr(const char *func, grid_t *gridptr)
{
  if ( gridptr == NULL )
    Error(func, "grid undefined!");
}


int gridSize(void)
{
  int gridsize = 0;
  long i;
  
  GRID_INIT();

  GRID_LOCK();

  for ( i = 0; i < _grid_max; i++ )
    if ( _gridList[i].ptr ) gridsize++;

  GRID_UNLOCK();

  return (gridsize);
}


void gridGenXvals(int xsize, double xfirst, double xlast, double xinc, double *xvals)
{
  long i;

  if ( (! (fabs(xinc) > 0)) && xsize > 1 )
    {
      if ( xfirst >= xlast )
	{
	  while ( xfirst >= xlast ) xlast += 360;
	  xinc = (xlast-xfirst)/(xsize);
	}
      else
	{
	  xinc = (xlast-xfirst)/(xsize-1);
	}
    }

  for ( i = 0; i < xsize; i++ )
    xvals[i] = xfirst + i*xinc;
}

static
void calc_gaussgrid(double *yvals, int ysize, double yfirst, double ylast)
{
  static char func[] = "calc_gaussgrid";
  double *yw;
  long yhsize;
  long i;

  yw = (double *) malloc(ysize*sizeof(double));
  gaussaw(yvals, yw, ysize);
  free(yw);
  for ( i = 0; i < ysize; i++ )
    yvals[i] = asin(yvals[i])/M_PI*180.0;

  if ( yfirst < ylast && yfirst > -90.0 && ylast < 90.0 )
    {
      double ytmp;
      yhsize = ysize/2;
      for ( i = 0; i < yhsize; i++ )
	{
	  ytmp = yvals[i];
	  yvals[i] = yvals[ysize-i-1];
	  yvals[ysize-i-1] = ytmp;
	}
    }
}


void gridGenYvals(int gridtype, int ysize, double yfirst, double ylast, double yinc, double *yvals)
{
  static char func[] = "gridGenYvals";
  long i;

  if ( gridtype == GRID_GAUSSIAN || gridtype == GRID_GAUSSIAN_REDUCED )
    {
      if ( ysize > 2 )
	{
	  calc_gaussgrid(yvals, ysize, yfirst, ylast);

	  if ( ! (IS_EQUAL(yfirst, 0) && IS_EQUAL(ylast, 0)) )
	    if ( fabs(yvals[0] - yfirst) > 0.001 || fabs(yvals[ysize-1] - ylast) > 0.001 )
	      {
		double yinc = fabs(ylast-yfirst)/(ysize-1);
		double *ytmp = NULL;
		int nstart, lfound = 0;
		int ny = (int) (180./yinc + 0.5);
		ny -= ny%2;
		/* printf("%g %g %g %g %g %d\n", ylast, yfirst, ylast-yfirst,yinc, 180/yinc, ny); */
		if ( ny < 4096 )
		  {
		    ytmp   = (double *) malloc(ny*sizeof(double));
		    calc_gaussgrid(ytmp, ny, yfirst, ylast);
		    for ( i = 0; i < (ny-ysize); i++ )
		      if ( fabs(ytmp[i] - yfirst) < 0.001 ) break;

		    nstart = i;

		    if ( (nstart+ysize-1) < ny )
		      if ( fabs(ytmp[nstart+ysize-1] - ylast) < 0.001 ) lfound = 1;
		  }

		if ( lfound )
		  {
		    for ( i = 0; i < ysize; i++ ) yvals[i] = ytmp[i+nstart];
		  }
		else
		  {
		    Warning(func, "Cannot calculate gaussian latitudes for lat1 = %g latn = %g", yfirst, ylast);
		    for ( i = 0; i < ysize; i++ ) yvals[i] = 0;
		    yvals[0] = yfirst;
		    yvals[ysize-1] = ylast;
		  }

		if ( ny < 4096 )
		  free(ytmp);
	      }
	}
      else
	{
	  yvals[0] = yfirst;
	  yvals[ysize-1] = ylast;
	}
    }
  /*     else if ( gridtype == GRID_LONLAT || gridtype == GRID_GENERIC ) */
  else
    {
      if ( (! (fabs(yinc) > 0)) && ysize > 1 )
	{
	  if ( IS_EQUAL(yfirst, ylast) && IS_NOT_EQUAL(yfirst, 0) ) ylast *= -1;

	  if ( yfirst > ylast )
	    yinc = (yfirst-ylast)/(ysize-1);
	  else if ( yfirst < ylast )
	    yinc = (ylast-yfirst)/(ysize-1);
	  else
	    {
	      if ( ysize%2 != 0 )
		{
		  yinc = 180.0/(ysize-1);
		  yfirst = -90;
		}
	      else
		{
		  yinc = 180.0/ysize;
		  yfirst = -90 + yinc/2;
		}
	    }
	}

      if ( yfirst > ylast && yinc > 0 ) yinc = -yinc;

      for ( i = 0; i < ysize; i++ )
	yvals[i] = yfirst + i*yinc;
    }
  /*
    else
    Error(func, "unable to calculate values for %s grid!", gridNamePtr(gridtype));
  */
}


/*
@Function  gridCreate
@Title     Create a horizontal Grid

@Prototype int gridCreate(int gridtype, int size)
@Parameter
    @Item  gridtype  The type of the grid, one of the set of predefined CDI grid types.
                     The valid CDI grid types are @func{GRID_GENERIC}, @func{GRID_GAUSSIAN},
                     @func{GRID_LONLAT}, @func{GRID_LCC}, @func{GRID_SPECTRAL},
                     @func{GRID_GME}, @func{GRID_CURVILINEAR} and @func{GRID_CELL}.
    @Item  size      Number of gridpoints.

@Description
The function @func{gridCreate} creates a horizontal Grid.

@Result
@func{gridCreate} returns an identifier to the Grid.

@Example
Here is an example using @func{gridCreate} to create a regular lon/lat Grid:

@Source
   ...
#define  NLON  12
#define  NLAT   6
   ...
double lons[NLON] = {0, 30, 60, 90, 120, 150, 180, 210, 240, 270, 300, 330};
double lats[NLAT] = {-75, -45, -15, 15, 45, 75};
int gridID;
   ...
gridID = gridCreate(GRID_LONLAT, NLON*NLAT);
gridDefXsize(gridID, NLON);
gridDefYsize(gridID, NLAT);
gridDefXvals(gridID, lons);
gridDefYvals(gridID, lats);
   ...
@EndSource
@EndFunction
*/
int gridCreate(int gridtype, int size)
{
  static char func[] = "gridCreate";
  int gridID;
  grid_t *gridptr;

  if ( CDI_Debug )
    Message(func, "gridtype: %d size: %d", gridtype, size);

  GRID_INIT();

  gridptr = grid_new_entry();
  if ( ! gridptr ) Error(func, "No memory");

  gridID = gridptr->self;

  if ( CDI_Debug ) Message(func, "gridID: %d", gridID);

  gridptr->type = gridtype;
  gridptr->size = size;

  /*  if ( gridtype == GRID_GENERIC )     gridptr->xsize = size; */
  if ( gridtype == GRID_CELL )        gridptr->xsize = size;
  if ( gridtype == GRID_CURVILINEAR ) gridptr->nvertex = 4;

  switch (gridtype)
    {
    case GRID_LONLAT:
    case GRID_GAUSSIAN:
    case GRID_GAUSSIAN_REDUCED:
    case GRID_CURVILINEAR:
    case GRID_TRAJECTORY:
      {
	if ( gridtype == GRID_TRAJECTORY )
	  {
	    gridDefXname(gridID, "tlon");
	    gridDefYname(gridID, "tlat");
	  }
	else
	  {
	    gridDefXname(gridID, "lon");
	    gridDefYname(gridID, "lat");
	  }
	gridDefXlongname(gridID, "longitude");
	gridDefYlongname(gridID, "latitude");
	/*
	if ( gridtype == GRID_CURVILINEAR )
	  {
	    strcpy(gridptr->xstdname, "grid_longitude");
	    strcpy(gridptr->ystdname, "grid_latitude");
	    gridDefXunits(gridID, "degrees");
	    gridDefYunits(gridID, "degrees");
	  }
	else
	*/
	  {
	    strcpy(gridptr->xstdname, "longitude");
	    strcpy(gridptr->ystdname, "latitude");
	    gridDefXunits(gridID, "degrees_east");
	    gridDefYunits(gridID, "degrees_north");
	  }

	break;
      }
    case GRID_GME:
    case GRID_CELL:
      {
	gridDefXname(gridID, "lon");
	gridDefYname(gridID, "lat");
	strcpy(gridptr->xstdname, "longitude");
	strcpy(gridptr->ystdname, "latitude");
	gridDefXunits(gridID, "degrees_east");
	gridDefYunits(gridID, "degrees_north");
	break;
      }
    case GRID_GENERIC:
      {
	gridDefXname(gridID, "x");
	gridDefYname(gridID, "y");
	strcpy(gridptr->xstdname, "grid_longitude");
	strcpy(gridptr->ystdname, "grid_latitude");
	gridDefXunits(gridID, "degrees");
	gridDefYunits(gridID, "degrees");
	break;
      }
    case GRID_LCC2:
    case GRID_SINUSOIDAL:
    case GRID_LAEA:
      {
	gridDefXname(gridID, "x");
	gridDefYname(gridID, "y");
	strcpy(gridptr->xstdname, "projection_x_coordinate");
	strcpy(gridptr->ystdname, "projection_y_coordinate");
	gridDefXunits(gridID, "m");
	gridDefYunits(gridID, "m");
	break;
      }
    }

  return (gridID);
}


/*
@Function  gridDestroy
@Title     Destroy a horizontal Grid

@Prototype void gridDestroy(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}

@EndFunction
*/
void gridDestroy(int gridID)
{
  static char *func = "gridDestroy";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);
  
  grid_check_ptr(func, gridptr);

  if ( gridptr->mask    ) free(gridptr->mask);
  if ( gridptr->xvals   ) free(gridptr->xvals);
  if ( gridptr->yvals   ) free(gridptr->yvals);
  if ( gridptr->area    ) free(gridptr->area);
  if ( gridptr->xbounds ) free(gridptr->xbounds);
  if ( gridptr->ybounds ) free(gridptr->ybounds);
  if ( gridptr->rowlon  ) free(gridptr->rowlon);

  grid_delete_entry(gridptr);
}


char *gridNamePtr(int gridtype)
{
  char *name;
  int size = (int) (sizeof(Grids)/sizeof(char *));

  if ( gridtype >= 0 && gridtype < size )
    name = Grids[gridtype];
  else
    name = Grids[GRID_GENERIC];

  return (name);
}


void gridName(int gridtype, char *gridname)
{
  strcpy(gridname, gridNamePtr(gridtype));
}


/*
@Function  gridDefXname
@Title     Define the name of a X-axis

@Prototype void gridDefXname(int gridID, const char *name)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  name     Name of the X-axis

@Description
The function @func{gridDefXname} defines the name of a X-axis.

@EndFunction
*/
void gridDefXname(int gridID, const char *xname)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( xname )
    strcpy(gridptr->xname, xname);
}


/*
@Function  gridDefXlongname
@Title     Define the longname of a X-axis

@Prototype void gridDefXlongname(int gridID, const char *longname)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  longname Longname of the X-axis

@Description
The function @func{gridDefXlongname} defines the longname of a X-axis.

@EndFunction
*/
void gridDefXlongname(int gridID, const char *xlongname)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( xlongname )
    strcpy(gridptr->xlongname, xlongname);
}


/*
@Function  gridDefXunits
@Title     Define the units of a X-axis

@Prototype void gridDefXunits(int gridID, const char *units)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  units    Units of the X-axis

@Description
The function @func{gridDefXunits} defines the units of a X-axis.

@EndFunction
*/
void gridDefXunits(int gridID, const char *xunits)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( xunits )
    strcpy(gridptr->xunits, xunits);
}


/*
@Function  gridDefYname
@Title     Define the name of a Y-axis

@Prototype void gridDefYname(int gridID, const char *name)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  name     Name of the Y-axis

@Description
The function @func{gridDefYname} defines the name of a Y-axis.

@EndFunction
*/
void gridDefYname(int gridID, const char *yname)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( yname )
    strcpy(gridptr->yname, yname);
}


/*
@Function  gridDefYlongname
@Title     Define the longname of a Y-axis

@Prototype void gridDefYlongname(int gridID, const char *longname)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  longname Longname of the Y-axis

@Description
The function @func{gridDefYlongname} defines the longname of a Y-axis.

@EndFunction
*/
void gridDefYlongname(int gridID, const char *ylongname)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( ylongname )
    strcpy(gridptr->ylongname, ylongname);
}


/*
@Function  gridDefYunits
@Title     Define the units of a Y-axis

@Prototype void gridDefYunits(int gridID, const char *units)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  units    Units of the Y-axis

@Description
The function @func{gridDefYunits} defines the units of a Y-axis.

@EndFunction
*/
void gridDefYunits(int gridID, const char *yunits)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( yunits )
    strcpy(gridptr->yunits, yunits);
}


/*
@Function  gridInqXname
@Title     Get the name of a X-axis

@Prototype void gridInqXname(int gridID, const char *name)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  name     Name of the X-axis

@Description
The function @func{gridInqXname} returns the name of a X-axis.

@Result
@func{gridInqXname} returns the name of the X-axis to the parameter name.

@EndFunction
*/
void gridInqXname(int gridID, char *xname)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  strcpy(xname, gridptr->xname);
}


/*
@Function  gridInqXlongname
@Title     Get the longname of a X-axis

@Prototype void gridInqXlongname(int gridID, const char *longname)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  longname Longname of the X-axis

@Description
The function @func{gridInqXlongname} returns the longname of a X-axis.

@Result
@func{gridInqXlongname} returns the longname of the X-axis to the parameter longname.

@EndFunction
*/
void gridInqXlongname(int gridID, char *xlongname)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  strcpy(xlongname, gridptr->xlongname);
}


/*
@Function  gridInqXunits
@Title     Get the units of a X-axis

@Prototype void gridInqXunits(int gridID, const char *units)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  units    Units of the X-axis

@Description
The function @func{gridInqXunits} returns the units of a X-axis.

@Result
@func{gridInqXunits} returns the units of the X-axis to the parameter units.

@EndFunction
*/
void gridInqXunits(int gridID, char *xunits)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  strcpy(xunits, gridptr->xunits);
}


void gridInqXstdname(int gridID, char *xstdname)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  strcpy(xstdname, gridptr->xstdname);
}


/*
@Function  gridInqYname
@Title     Get the name of a Y-axis

@Prototype void gridInqYname(int gridID, const char *name)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  name     Name of the Y-axis

@Description
The function @func{gridInqYname} returns the name of a Y-axis.

@Result
@func{gridInqYname} returns the name of the Y-axis to the parameter name.

@EndFunction
*/
void gridInqYname(int gridID, char *yname)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  strcpy(yname, gridptr->yname);
}


/*
@Function  gridInqYlongname
@Title     Get the longname of a Y-axis

@Prototype void gridInqXlongname(int gridID, const char *longname)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  longname Longname of the Y-axis

@Description
The function @func{gridInqYlongname} returns the longname of a Y-axis.

@Result
@func{gridInqYlongname} returns the longname of the Y-axis to the parameter longname.

@EndFunction
*/
void gridInqYlongname(int gridID, char *ylongname)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  strcpy(ylongname, gridptr->ylongname);
}


/*
@Function  gridInqYunits
@Title     Get the units of a Y-axis

@Prototype void gridInqYunits(int gridID, const char *units)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  units    Units of the Y-axis

@Description
The function @func{gridInqYunits} returns the units of a Y-axis.

@Result
@func{gridInqYunits} returns the units of the Y-axis to the parameter units.

@EndFunction
*/
void gridInqYunits(int gridID, char *yunits)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  strcpy(yunits, gridptr->yunits);
}

void gridInqYstdname(int gridID, char *ystdname)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  strcpy(ystdname, gridptr->ystdname);
}


/*
@Function  gridInqType
@Title     Get the type of a Grid

@Prototype int gridInqType(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}

@Description
The function @func{gridInqType} returns the type of a Grid.

@Result
@func{gridInqType} returns the type of the grid,
one of the set of predefined CDI grid types.
The valid CDI grid types are @func{GRID_GENERIC}, @func{GRID_GAUSSIAN},
@func{GRID_LONLAT}, @func{GRID_LCC}, @func{GRID_SPECTRAL}, @func{GRID_GME},
@func{GRID_CURVILINEAR} and @func{GRID_CELL}.

@EndFunction
*/
int gridInqType(int gridID)
{
  static char func[] = "gridInqType";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  return (gridptr->type);
}


/*
@Function  gridInqSize
@Title     Get the size of a Grid

@Prototype int gridInqSize(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}

@Description
The function @func{gridInqSize} returns the size of a Grid.

@Result
@func{gridInqSize} returns the number of grid points of a Grid.

@EndFunction
*/
int gridInqSize(int gridID)
{
  static char func[] = "gridInqSize";
  int size = 0;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  size = gridptr->size;

  if ( ! size )
    {
      int xsize, ysize;

      xsize = gridptr->xsize;
      ysize = gridptr->ysize;

      if ( ysize )
	size = xsize *ysize;
      else
	size = xsize;

      gridptr->size = size;  
    }

  return (size);
}

static
int nsp2trunc(int nsp)
{
  /*  nsp = (trunc+1)*(trunc+1)              */
  /*      => trunc^2 + 3*trunc - (x-2) = 0   */
  /*                                         */
  /*  with:  y^2 + p*y + q = 0               */
  /*         y = -p/2 +- sqrt((p/2)^2 - q)   */
  /*         p = 3 and q = - (x-2)           */
  int trunc;

  trunc = (int) (sqrt(nsp*4 + 1.) - 3) / 2;

  return (trunc);
}


int gridInqTrunc(int gridID)
{
  static char func[] = "gridInqTrunc";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  if ( gridptr->trunc == 0 )
    {
      if ( gridptr->type == GRID_SPECTRAL )
	gridptr->trunc = nsp2trunc(gridptr->size);
      /*
      else if      ( gridptr->type == GRID_GAUSSIAN )
	gridptr->trunc = nlat2trunc(gridptr->ysize);
      */
    }

  return (gridptr->trunc);
}


void gridDefTrunc(int gridID, int trunc)
{
  static char func[] = "gridDefTrunc";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  gridptr->trunc = trunc;
}


/*
@Function  gridDefXsize
@Title     Define the number of values of a X-axis

@Prototype void gridDefXsize(int gridID, int xsize)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  xsize    Number of values of a X-axis

@Description
The function @func{gridDefXsize} defines the number of values of a X-axis.

@EndFunction
*/
void gridDefXsize(int gridID, int xsize)
{
  static char func[] = "gridDefXsize";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  if ( xsize > gridInqSize(gridID) )
    Error(func, "xsize %d is greater then gridsize %d", xsize, gridInqSize(gridID));

  if ( gridInqType(gridID) == GRID_CELL && xsize != gridInqSize(gridID) )
    Error(func, "xsize %d must be equal gridsize %d for gridtype CELL", xsize, gridInqSize(gridID));

  gridptr->xsize = xsize;

  if ( gridInqType(gridID) != GRID_CELL && 
       gridptr->xsize*gridptr->ysize > gridInqSize(gridID) )
    Error(func, "inconsistent grid declaration! (xsize %d ysize %d gridsize %d)",
	  gridptr->xsize, gridptr->ysize, gridInqSize(gridID));
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void gridDefPrec(int gridID, int prec)
{
  static char func[] = "gridDefPrec";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  gridptr->prec = prec;
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
int gridInqPrec(int gridID)
{
  static char func[] = "gridInqPrec";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  return (gridptr->prec);
}


/*
@Function  gridInqXsize
@Title     Get the number of values of a X-axis

@Prototype void gridInqXsize(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}

@Description
The function @func{gridInqXsize} returns the number of values of a X-axis.

@Result
@func{gridInqXsize} returns the number of values of a X-axis.

@EndFunction
*/
int gridInqXsize(int gridID)
{
  static char func[] = "gridInqXsize";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  return (gridptr->xsize);
}


/*
@Function  gridDefYsize
@Title     Define the number of values of a Y-axis

@Prototype void gridDefYsize(int gridID, int ysize)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  ysize    Number of values of a Y-axis

@Description
The function @func{gridDefYsize} defines the number of values of a Y-axis.

@EndFunction
*/
void gridDefYsize(int gridID, int ysize)
{
  static char func[] = "gridDefYsize";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  if ( ysize > gridInqSize(gridID) )
    Error(func, "ysize %d is greater then gridsize %d", ysize, gridInqSize(gridID));

  if ( gridInqType(gridID) == GRID_CELL && ysize != gridInqSize(gridID) )
    Error(func, "ysize %d must be equal gridsize %d for gridtype CELL", ysize, gridInqSize(gridID));

  gridptr->ysize = ysize;

  if ( gridInqType(gridID) != GRID_CELL && 
       gridptr->xsize*gridptr->ysize > gridInqSize(gridID) )
    Error(func, "inconsistent grid declaration! (xsize %d ysize %d gridsize %d)",
	  gridptr->xsize, gridptr->ysize, gridInqSize(gridID));
}


/*
@Function  gridInqYsize
@Title     Get the number of values of a Y-axis

@Prototype void gridInqYsize(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}

@Description
The function @func{gridInqYsize} returns the number of values of a Y-axis.

@Result
@func{gridInqYsize} returns the number of values of a Y-axis.

@EndFunction
*/
int gridInqYsize(int gridID)
{
  static char func[] = "gridInqYsize";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  return (gridptr->ysize);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void gridDefRowlon(int gridID, int nrowlon, const int *rowlon)
{
  static char func[] = "gridDefRowlon";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);
  
  grid_check_ptr(func, gridptr);

  gridptr->rowlon = (int *) malloc(nrowlon*sizeof(int));
  gridptr->nrowlon = nrowlon;

  memcpy(gridptr->rowlon, rowlon, nrowlon*sizeof(int));
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void gridInqRowlon(int gridID, int *rowlon)
{
  static char func[] = "gridInqRowlon";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  if ( gridptr->rowlon == 0 )  Error(func, "undefined pointer");

  memcpy(rowlon, gridptr->rowlon, gridptr->nrowlon*sizeof(int));
}


int gridInqMask(int gridID, int *mask)
{
  static char func[] = "gridInqMask";
  long size;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  size = gridptr->size;

  if ( CDI_Debug && size == 0 )
    Warning(func, "Size undefined for gridID = %d", gridID);
    
  if ( mask && gridptr->mask )
    memcpy(mask, gridptr->mask, size*sizeof(int));

  if ( gridptr->mask == NULL ) size = 0;

  return (size);
}


void gridDefMask(int gridID, const int *mask)
{
  static char func[] = "gridDefMask";
  int gridtype;
  long size;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  gridtype = gridptr->type;

  size = gridptr->size;

  if ( size == 0 )
    Error(func, "Size undefined for gridID = %d", gridID);
    
  if ( gridptr->mask == NULL )
    gridptr->mask = (int *) malloc(size*sizeof(int));
  else if ( CDI_Debug )
    Warning(func, "mask already defined!");

  memcpy(gridptr->mask, mask, size*sizeof(int));
}


/*
@Function  gridInqXvals
@Title     Get all values of a X-axis

@Prototype int gridInqXvals(int gridID, double *xvals)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  xvals    X-values of the grid

@Description
The function @func{gridInqXvals} returns all values of the X-axis.

@Result
Upon successful completion @func{gridInqXvals} returns the number of values and
the values are stored in @func{xvals}.
Otherwise, 0 is returned and @func{xvals} is empty.

@EndFunction
*/
int gridInqXvals(int gridID, double *xvals)
{
  static char func[] = "gridInqXvals";
  long size;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  if ( gridptr->type == GRID_CURVILINEAR || gridptr->type == GRID_CELL )
    size = gridptr->size;
  else
    size = gridptr->xsize;

  if ( CDI_Debug && size == 0 )
    Warning(func, "Size undefined for gridID = %d", gridID);
    
  if ( xvals && gridptr->xvals )
    memcpy(xvals, gridptr->xvals, size*sizeof(double));

  if ( gridptr->xvals == NULL ) size = 0;

  return (size);
}


/*
@Function  gridDefXvals
@Title     Define the values of a X-axis

@Prototype void gridDefXvals(int gridID, const double *xvals)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  xvals    X-values of the grid

@Description
The function @func{gridDefXvals} defines all values of the X-axis.

@EndFunction
*/
void gridDefXvals(int gridID, const double *xvals)
{
  static char func[] = "gridDefXvals";
  int gridtype;
  long size;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  gridtype = gridptr->type;

  if ( gridtype == GRID_CELL || gridtype == GRID_CURVILINEAR )
    size = gridptr->size;
  else
    size = gridptr->xsize;

  if ( size == 0 )
    Error(func, "Size undefined for gridID = %d", gridID);
    
  if ( gridptr->xvals == NULL )
    gridptr->xvals = (double *) malloc(size*sizeof(double));
  else if ( CDI_Debug )
    Warning(func, "values already defined!");

  memcpy(gridptr->xvals, xvals, size*sizeof(double));
}


/*
@Function  gridInqYvals
@Title     Get all values of a Y-axis

@Prototype int gridInqYvals(int gridID, double *yvals)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  yvals    Y-values of the grid

@Description
The function @func{gridInqYvals} returns all values of the Y-axis.

@Result
Upon successful completion @func{gridInqYvals} returns the number of values and
the values are stored in @func{yvals}.
Otherwise, 0 is returned and @func{yvals} is empty.

@EndFunction
*/
int gridInqYvals(int gridID, double *yvals)
{
  static char func[] = "gridInqYvals";
  long size;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  if ( gridptr->type == GRID_CURVILINEAR || gridptr->type == GRID_CELL )
    size = gridptr->size;
  else
    size = gridptr->ysize;

  if ( CDI_Debug && size == 0 )
    Warning(func, "Size undefined for gridID = %d!", gridID);
    
  if ( yvals && gridptr->yvals )
    memcpy(yvals, gridptr->yvals, size*sizeof(double));

  if ( gridptr->yvals == NULL ) size = 0;

  return (size);
}


/*
@Function  gridDefYvals
@Title     Define the values of a Y-axis

@Prototype void gridDefYvals(int gridID, const double *yvals)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  yvals    Y-values of the grid

@Description
The function @func{gridDefYvals} defines all values of the Y-axis.

@EndFunction
*/
void gridDefYvals(int gridID, const double *yvals)
{
  static char func[] = "gridDefYvals";
  int gridtype;
  long size;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  gridtype = gridptr->type;

  if ( gridtype == GRID_CELL || gridtype == GRID_CURVILINEAR )
    size = gridptr->size;
  else
    size = gridptr->ysize;

  if ( size == 0 )
    Error(func, "Size undefined for gridID = %d!", gridID);
    
  if ( gridptr->yvals == NULL )
    gridptr->yvals = (double *) malloc(size*sizeof(double));
  else if ( CDI_Debug )
    Warning(func, "Values already defined!");
    
  memcpy(gridptr->yvals, yvals, size*sizeof(double));
}


double gridInqXval(int gridID, int index)
{
  double xval = 0;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( gridptr->xvals )
    xval = gridptr->xvals[index];

  return (xval);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
double gridInqYval(int gridID, int index)
{
  double yval = 0;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( gridptr->yvals )
    yval = gridptr->yvals[index];

  return (yval);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
double gridInqXinc(int gridID)
{
  double xinc;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  xinc = gridptr->xinc;

  if ( (! (fabs(xinc) > 0)) && gridptr->xvals )
    {
      int xsize;
      double *xvals;

      xsize = gridptr->xsize;
      xvals = gridptr->xvals;

      if ( xsize > 1 )
	{
	  long i;
	  xinc = fabs(xvals[xsize-1] - xvals[0])/(xsize-1);
	  for ( i = 2; i < xsize; i++ )
	    if ( fabs(fabs(xvals[i-1] - xvals[i]) - xinc) > 0.01*xinc ) break;
		  
	  if ( i < xsize ) xinc = 0;
	}
    }

  return (xinc);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
double gridInqYinc(int gridID)
{
  double yinc;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  yinc = gridptr->yinc;

  if ( (! (fabs(yinc) > 0)) && gridptr->yvals )
    {
      int ysize;
      double *yvals;

      ysize = gridptr->ysize;
      yvals = gridptr->yvals;

      if ( ysize > 1 )
	{
	  long i;
	  yinc = fabs(yvals[1] - yvals[0]);
	  for ( i = 2; i < ysize; i++ )
	    if ( fabs(fabs(yvals[i] - yvals[i-1]) - yinc) > (yinc/1000) ) break;

	  if ( i < ysize ) yinc = 0;
	  else             yinc = yvals[1] - yvals[0];
	}
    }

  return (yinc);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
double gridInqXpole(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->xpole);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void gridDefXpole(int gridID, double xpole)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( memcmp(gridptr->xstdname, "grid", 4) != 0 )
    strcpy(gridptr->xstdname, "grid_longitude");

  gridptr->isRotated = TRUE;
  gridptr->xpole = xpole;
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
double gridInqYpole(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->ypole);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void gridDefYpole(int gridID, double ypole)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( memcmp(gridptr->ystdname, "grid", 4) != 0 )
    strcpy(gridptr->ystdname, "grid_latitude");

  gridptr->isRotated = TRUE;
  gridptr->ypole = ypole;
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
double gridInqAngle(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->angle);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void gridDefAngle(int gridID, double angle)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  gridptr->isRotated = TRUE;
  gridptr->angle = angle;
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
int gridInqGMEnd(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->nd);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void gridDefGMEnd(int gridID, int nd)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  gridptr->nd = nd;
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
int gridInqGMEni(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->ni);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void gridDefGMEni(int gridID, int ni)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  gridptr->ni = ni;
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
int gridInqGMEni2(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->ni2);
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void gridDefGMEni2(int gridID, int ni2)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  gridptr->ni2 = ni2;
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
int gridInqGMEni3(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->ni3);
}

void gridDefGMEni3(int gridID, int ni3)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  gridptr->ni3 = ni3;
}


/*
@Function  
@Title     

@Prototype 
@Parameter
    @Item  Grid identifier

@EndFunction
*/
void gridChangeType(int gridID, int gridtype)
{
  static char func[] = "gridChangeType";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  Message(func, "Changed grid type from %s to %s\n",
	  gridNamePtr(gridptr->type),
	  gridNamePtr(gridtype));
  
  gridptr->type = gridtype;
}


static 
void grid_check_cyclic(grid_t *gridptr)
{
  int xsize, ysize, gridsize;
  long i1, i2, in, j, k1, k2, nc;
  double xinc, x0;
  const double *xvals, *xbounds;

  gridptr->isCyclic = FALSE;

  gridsize = gridptr->size;
  xsize = gridptr->xsize;
  ysize = gridptr->ysize;
  xvals = gridptr->xvals;
  xbounds = gridptr->xbounds;

  if ( gridptr->type == GRID_GAUSSIAN || gridptr->type == GRID_LONLAT )
    {
      if ( xvals && xsize > 1 )
	{
	  xinc = xvals[1] - xvals[0];
	  if ( IS_EQUAL(xinc, 0) )
	    xinc = (xvals[xsize-1] - xvals[0])/(xsize-1);
	  x0 = 2*xvals[xsize-1]-xvals[xsize-2]-360;
	  if ( IS_NOT_EQUAL(xvals[0], xvals[xsize-1]) )
	    if ( fabs(x0 - xvals[0]) < 0.01*xinc ) gridptr->isCyclic = TRUE;
	}
    }
  else if ( gridptr->type == GRID_CURVILINEAR )
    {
      if ( xvals && xsize > 1 )
	{
	  double val1, val2, valn;

	  nc = 0;
	  gridptr->isCyclic = FALSE;
	  for ( j = 0; j < ysize; ++j )
	    {
	      i1 = j*xsize;
	      i2 = j*xsize+1;
	      in = j*xsize+(xsize-1);
	      val1 = xvals[i1];
	      val2 = xvals[i2];
	      valn = xvals[in];

	      xinc = fabs(val2-val1);

	      if ( val1 < 1 && valn > 300 ) val1 += 360;
	      if ( valn < 1 && val1 > 300 ) valn += 360;
	      if ( val1 < -179 && valn > 120 ) val1 += 360;
	      if ( valn < -179 && val1 > 120 ) valn += 360;

	      if ( valn > val1 ) x0 = valn - xinc;
	      else               x0 = valn + xinc;

	      if ( fabs(x0-val1) < 0.5*xinc ) nc++;
	    }

	  if ( nc > 0.5*ysize ) gridptr->isCyclic = TRUE;
	}

      if ( xbounds && xsize > 1 )
	{
	  double val1, val2;

	  gridptr->isCyclic = TRUE;
	  for ( j = 0; j < ysize; ++j )
	    {
	      i1 = j*xsize*4;
	      i2 = j*xsize*4+(xsize-1)*4;
	      nc = 0;
	      for ( k1 = 0; k1 < 4; ++k1 )
		{
		  val1 = xbounds[i1+k1];
		  for ( k2 = 0; k2 < 4; ++k2 )
		    {
		      val2 = xbounds[i2+k2];
		      
		      if ( val1 < 1 && val2 > 300 ) val1 += 360;
		      if ( val2 < 1 && val1 > 300 ) val2 += 360;
		      if ( val1 < -179 && val2 > 120 ) val1 += 360;
		      if ( val2 < -179 && val1 > 120 ) val2 += 360;
		      		      
		      if ( fabs(val1-val2) < 0.001 )
			{
			  nc++;
			  break;
			}
		    }
		}
	      if ( nc < 1 )
		{
		  gridptr->isCyclic = FALSE;
		  break;
		}
	    }
	}
    }
}


int gridIsCircular(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( gridptr->isCyclic == CDI_UNDEFID ) grid_check_cyclic(gridptr);

  return ( gridptr->isCyclic );
}


int gridIsRotated(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return ( gridptr->isRotated );
}


int gridCompare(int gridID, grid_t grid)
{
  static char func[] = "gridCompare";
  int differ = 1;
  int xsize, ysize;

  xsize = grid.xsize;
  ysize = grid.ysize;

  if ( grid.type == gridInqType(gridID) || grid.type == GRID_GENERIC )
    {
      if ( grid.size == gridInqSize(gridID) )
	{
	  differ = 0;
	  if ( grid.type == GRID_LONLAT )
	    {
	      /*
	      printf("gridID      %d\n", gridID);
	      printf("grid.xdef   %d\n", grid.xdef);
	      printf("grid.ydef   %d\n", grid.ydef);
	      printf("grid.xsize  %d\n", grid.xsize);
	      printf("grid.ysize  %d\n", grid.ysize);
	      printf("grid.xfirst %f\n", grid.xfirst);
	      printf("grid.yfirst %f\n", grid.yfirst);
	      printf("grid.xfirst %f\n", gridInqXval(gridID, 0));
	      printf("grid.yfirst %f\n", gridInqYval(gridID, 0));
	      printf("grid.xinc   %f\n", grid.xinc);
	      printf("grid.yinc   %f\n", grid.yinc);
	      printf("grid.xinc   %f\n", gridInqXinc(gridID));
	      printf("grid.yinc   %f\n", gridInqYinc(gridID));
	      */
	      if ( grid.xsize == gridInqXsize(gridID) && grid.ysize == gridInqYsize(gridID) )
		{
		  if ( grid.xdef == 2 && grid.ydef == 2 )
		    {
		      if ( ! (IS_EQUAL(grid.xfirst, 0) && IS_EQUAL(grid.xlast, 0) && IS_EQUAL(grid.xinc, 0)) &&
			   ! (IS_EQUAL(grid.yfirst, 0) && IS_EQUAL(grid.ylast, 0) && IS_EQUAL(grid.yinc, 0)) &&
			   IS_NOT_EQUAL(grid.xfirst, grid.xlast) && IS_NOT_EQUAL(grid.yfirst, grid.ylast) )
			{
			  if ( IS_NOT_EQUAL(grid.xfirst, gridInqXval(gridID, 0)) ||
			       IS_NOT_EQUAL(grid.yfirst, gridInqYval(gridID, 0)))
			    {
			      differ = 1;
			    }
			  if ( !differ && fabs(grid.xinc) > 0 &&
			       fabs(fabs(grid.xinc) - fabs(gridInqXinc(gridID))) > fabs(grid.xinc/1000))
			    {
			      differ = 1;
			    }
			  if ( !differ && fabs(grid.yinc) > 0 &&
			       fabs(fabs(grid.yinc) - fabs(gridInqYinc(gridID))) > fabs(grid.yinc/1000))
			    {
			      differ = 1;
			    }
			}
		    }
		  else
		    {
		      long i;
		      double *xvals, *yvals;

		      xvals = (double *) malloc(xsize*sizeof(double));
		      yvals = (double *) malloc(ysize*sizeof(double));

		      gridInqXvals(gridID, xvals);
		      gridInqYvals(gridID, yvals);

		      for ( i = 0; i < xsize; ++i )
			if ( fabs(grid.xvals[i] - xvals[i]) > 1.e-10 )
			  {
			    differ = 1;
			    break;
			  }

		      for ( i = 0; i < ysize; ++i )
			if ( fabs(grid.yvals[i] - yvals[i]) > 1.e-10 )
			  {
			    differ = 1;
			    break;
			  }
		  
		      free(xvals);
		      free(yvals);
		    }
		}
	      else
		differ = 1;		
	    }
	  else if ( grid.type == GRID_GENERIC )
	    {
	      if ( grid.xsize == gridInqXsize(gridID) && grid.ysize == gridInqYsize(gridID) )
		{
		  if ( grid.xdef == 1 && grid.ydef == 1 )
		    {
		      if ( grid.xvals && grid.yvals &&
			   gridInqXvals(gridID, NULL) && gridInqYvals(gridID, NULL) )
			{
			  long i;
			  double *xvals, *yvals;

			  xvals = (double *) malloc(xsize*sizeof(double));
			  yvals = (double *) malloc(ysize*sizeof(double));

			  gridInqXvals(gridID, xvals);
			  gridInqYvals(gridID, yvals);

			  for ( i = 0; i < xsize; ++i )
			    if ( fabs(grid.xvals[i] - xvals[i]) > 1.e-10 )
			      {
				differ = 1;
				break;
			      }

			  for ( i = 0; i < ysize; ++i )
			    if ( fabs(grid.yvals[i] - yvals[i]) > 1.e-10 )
			      {
				differ = 1;
				break;
			      }
			  
			  free(xvals);
			  free(yvals);
			}
		    }
		}
	      else
		differ = 1;		
	    }
	  else if ( grid.type == GRID_GAUSSIAN )
	    {
	      if ( grid.xsize == gridInqXsize(gridID) && grid.ysize == gridInqYsize(gridID) )
		{
		  if ( grid.xdef == 2 && grid.ydef == 2 )
		    {
		      if ( ! (IS_EQUAL(grid.xfirst, 0) && IS_EQUAL(grid.xlast, 0) && IS_EQUAL(grid.xinc, 0)) &&
			   ! (IS_EQUAL(grid.yfirst, 0) && IS_EQUAL(grid.ylast, 0)) )
			if ( fabs(grid.xfirst - gridInqXval(gridID, 0)) > 0.001 ||
			     fabs(grid.yfirst - gridInqYval(gridID, 0)) > 0.001 ||
			     (fabs(grid.xinc)>0 && fabs(fabs(grid.xinc) - fabs(gridInqXinc(gridID))) > fabs(grid.xinc/1000)) )
			  {
			    differ = 1;
			  }
		    }
		  else
		    {
		      if ( grid.xvals && grid.yvals )
			if ( IS_NOT_EQUAL(grid.xvals[0], gridInqXval(gridID, 0)) ||
			     IS_NOT_EQUAL(grid.yvals[0], gridInqYval(gridID, 0)) ||
			     fabs(fabs(grid.xvals[1]-grid.xvals[0]) - fabs(gridInqXinc(gridID)))
			     > fabs(grid.xinc/1000))
			  {
			    differ = 1;
			  }
		    }
		}
	      else
		differ = 1;		
	    }
	  else if ( grid.type == GRID_CURVILINEAR )
	    {
	      /*
	      printf("gridID      %d\n", gridID);
	      printf("grid.xsize  %d\n", grid.xsize);
	      printf("grid.ysize  %d\n", grid.ysize);
	      printf("grid.xfirst %f\n", grid.xvals[0]);
	      printf("grid.yfirst %f\n", grid.yvals[0]);
	      printf("grid.xfirst %f\n", gridInqXval(gridID, 0));
	      printf("grid.yfirst %f\n", gridInqYval(gridID, 0));
	      printf("grid.xlast  %f\n", grid.xvals[xsize-1]);
	      printf("grid.ylast  %f\n", grid.yvals[ysize-1]);
	      printf("grid.xlast  %f\n", gridInqXval(gridID, xsize-1));
	      printf("grid.ylast  %f\n", gridInqYval(gridID, ysize-1));
	      */
	      if ( grid.xsize == gridInqXsize(gridID) && grid.ysize == gridInqYsize(gridID) )
		if ( grid.xvals && gridInqXvalsPtr(gridID) )
		  {
		    if ( fabs(grid.xvals[0] - gridInqXval(gridID, 0)) > 1.e-9 ||
			 fabs(grid.xvals[xsize-1] - gridInqXval(gridID, xsize-1)) > 1.e-9 )
		      differ = 1;
		  }
		if ( grid.yvals && gridInqYvalsPtr(gridID) )
		  {
		    if ( fabs(grid.yvals[0] - gridInqYval(gridID, 0)) > 1.e-9 ||
			 fabs(grid.yvals[ysize-1] - gridInqYval(gridID, ysize-1)) > 1.e-9 )
		      differ = 1;
		  }
	    }
	}
    }

  return (differ);
}


int gridGenerate(grid_t grid)
{
  static char func[] = "gridGenerate";
  int gridID;
  grid_t *gridptr;

  gridID = gridCreate(grid.type, grid.size);

  gridptr = grid_to_pointer(gridID);

  gridDefPrec(gridID, grid.prec);
	  
  switch (grid.type)
    {
    case GRID_LONLAT:
    case GRID_GAUSSIAN:
    case GRID_CELL:
    case GRID_CURVILINEAR:
    case GRID_GENERIC:
    case GRID_LCC:
    case GRID_LCC2:
    case GRID_SINUSOIDAL:
    case GRID_LAEA:
      {
	if ( grid.xsize > 0 ) gridDefXsize(gridID, grid.xsize);
	if ( grid.ysize > 0 ) gridDefYsize(gridID, grid.ysize);

	if ( grid.nvertex > 0 )
	  gridDefNvertex(gridID, grid.nvertex);

	if ( grid.xdef == 1 )
	  {
	    gridDefXvals(gridID, grid.xvals);
	    if ( grid.xbounds )
	      gridDefXbounds(gridID, grid.xbounds);
	  }
	else if ( grid.xdef == 2 )
	  {
	    double *xvals = (double *) malloc(grid.xsize*sizeof(double));
	    gridGenXvals(grid.xsize, grid.xfirst, grid.xlast, grid.xinc, xvals);
	    gridDefXvals(gridID, xvals);
	    free(xvals);
	    /*
	    gridDefXinc(gridID, grid.xinc);
	    */
	  }

	if ( grid.ydef == 1 )
	  {
	    gridDefYvals(gridID, grid.yvals);
	    if ( grid.ybounds && grid.nvertex )
	      gridDefYbounds(gridID, grid.ybounds);
	  }
	else if ( grid.ydef == 2 )
	  {
	    double *yvals = (double *) malloc(grid.ysize*sizeof(double));
	    gridGenYvals(grid.type, grid.ysize, grid.yfirst, grid.ylast, grid.yinc, yvals);
	    gridDefYvals(gridID, yvals);
	    free(yvals);
	    /*
	    gridDefYinc(gridID, grid.yinc);
	    */
	  }

	if ( grid.isRotated )
	  {
	    gridDefXname(gridID, "rlon");
	    gridDefYname(gridID, "rlat");
	    gridDefXlongname(gridID, "longitude in rotated pole grid");
	    gridDefYlongname(gridID, "latitude in rotated pole grid");
	    strcpy(gridptr->xstdname, "grid_longitude");
	    strcpy(gridptr->ystdname, "grid_latitude");
	    gridDefXunits(gridID, "degrees");
	    gridDefYunits(gridID, "degrees");

	    gridDefXpole(gridID, grid.xpole);
	    gridDefYpole(gridID, grid.ypole);
	    gridDefAngle(gridID, grid.angle);
	  }

	if ( grid.area )
	  {
	    gridDefArea(gridID, grid.area);
	  }

	if ( grid.type == GRID_LAEA )
	  gridDefLaea(gridID, grid.laea_a, grid.laea_lon_0, grid.laea_lat_0);

	if ( grid.type == GRID_LCC2 )
	  gridDefLcc2(gridID, grid.lcc2_a, grid.lcc2_lon_0, grid.lcc2_lat_0, grid.lcc2_lat_1, grid.lcc2_lat_2);

	if ( grid.type == GRID_LCC )
	  gridDefLCC(gridID, grid.lcc_originLon, grid.lcc_originLat, grid.lcc_lonParY,
		     grid.lcc_lat1, grid.lcc_lat2, grid.lcc_xinc, grid.lcc_yinc,
		     grid.lcc_projflag, grid.lcc_scanflag);

	break;
      }
    case GRID_GAUSSIAN_REDUCED:
      {
	gridDefYsize(gridID, grid.ysize);
	gridDefRowlon(gridID, grid.ysize, grid.rowlon);

	if ( grid.ydef == 1 )
	  {
	    gridDefYvals(gridID, grid.yvals);
	    if ( grid.ybounds && grid.nvertex )
	      gridDefYbounds(gridID, grid.ybounds);
	  }
	else if ( grid.ydef == 2 )
	  {
	    double *yvals = (double *) malloc(grid.ysize*sizeof(double));
	    gridGenYvals(grid.type, grid.ysize, grid.yfirst, grid.ylast, grid.yinc, yvals);
	    gridDefYvals(gridID, yvals);
	    free(yvals);
	    /*
	    gridDefYinc(gridID, grid.yinc);
	    */
	  }
	break;
      }
    case GRID_SPECTRAL:
      {
	gridDefTrunc(gridID, grid.trunc);
	if ( grid.lcomplex ) gridDefComplexPacking(gridID, 1);
	break;
      }
    case GRID_GME:
      {
	gridDefGMEnd(gridID, grid.nd);
	gridDefGMEni(gridID, grid.ni);
	gridDefGMEni2(gridID, grid.ni2);
	gridDefGMEni3(gridID, grid.ni3);
	break;
      }
      /*
    case GRID_GENERIC:
      {
	if ( grid.xsize > 0 && grid.ysize > 0 )
	  {
	    gridDefXsize(gridID, grid.xsize);
	    gridDefYsize(gridID, grid.ysize);
	    if ( grid.xvals ) gridDefXvals(gridID, grid.xvals);
	    if ( grid.yvals ) gridDefYvals(gridID, grid.yvals);
	  }
	break;
      }
      */
    case GRID_TRAJECTORY:
      {
	gridDefXsize(gridID, 1);
	gridDefYsize(gridID, 1);
	break;
      }
    default:
      {
	Error(func, "Gridtype %s unsupported!", gridNamePtr(grid.type));
	break;
      }
    }

  if ( grid.xname[0]     ) gridDefXname(gridID, grid.xname);
  if ( grid.xlongname[0] ) gridDefXlongname(gridID, grid.xlongname);
  if ( grid.xunits[0]    ) gridDefXunits(gridID, grid.xunits);
  if ( grid.yname[0]     ) gridDefYname(gridID, grid.yname);
  if ( grid.ylongname[0] ) gridDefYlongname(gridID, grid.ylongname);
  if ( grid.yunits[0]    ) gridDefYunits(gridID, grid.yunits);

  return (gridID);
}


/*
@Function  gridDuplicate
@Title     Duplicate a horizontal Grid

@Prototype int gridDuplicate(int gridID)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate},
                    @fref{gridDuplicate} or @fref{vlistInqVarGrid}.

@Description
The function @func{gridDuplicate} duplicates a horizontal Grid.

@Result
@func{gridDuplicate} returns an identifier to the duplicated Grid.

@EndFunction
*/
int gridDuplicate(int gridID)
{
  static char func[] = "gridDuplicate";
  int gridIDnew;
  int gridtype, gridsize;
  int nrowlon;
  int size;
  grid_t *gridptr, *gridptrnew;

  gridptr = grid_to_pointer(gridID);

  gridtype = gridInqType(gridID);
  gridsize = gridInqSize(gridID);

  gridIDnew = gridCreate(gridtype, gridsize);
  gridptrnew = grid_to_pointer(gridIDnew);

  grid_copy(gridptrnew, gridptr);

  strcpy(gridptrnew->xname, gridptr->xname);
  strcpy(gridptrnew->yname, gridptr->yname);
  strcpy(gridptrnew->xlongname, gridptr->xlongname);
  strcpy(gridptrnew->ylongname, gridptr->ylongname);
  strcpy(gridptrnew->xunits, gridptr->xunits);
  strcpy(gridptrnew->yunits, gridptr->yunits);
  strcpy(gridptrnew->xstdname, gridptr->xstdname);
  strcpy(gridptrnew->ystdname, gridptr->ystdname);

  nrowlon = gridptr->nrowlon;
  if ( nrowlon )
    {
      gridptrnew->rowlon = (int *) malloc(nrowlon*sizeof(int));
      memcpy(gridptrnew->rowlon, gridptr->rowlon, nrowlon*sizeof(int));
    }

  if ( gridptr->xvals != NULL )
    {
      if ( gridtype == GRID_CURVILINEAR || gridtype == GRID_CELL )
	size = gridsize;
      else
	size = gridptr->xsize;

      gridptrnew->xvals = (double *) malloc(size*sizeof(double));
      memcpy(gridptrnew->xvals, gridptr->xvals, size*sizeof(double));
    }

  if ( gridptr->yvals != NULL )
    {
      if ( gridtype == GRID_CURVILINEAR || gridtype == GRID_CELL )
	size = gridsize;
      else
	size = gridptr->ysize;

      gridptrnew->yvals = (double *) malloc(size*sizeof(double));
      memcpy(gridptrnew->yvals, gridptr->yvals, size*sizeof(double));
    }

  if ( gridptr->xbounds != NULL )
    {
      if ( gridtype == GRID_CURVILINEAR || gridtype == GRID_CELL )
	size = gridsize;
      else
	size = gridptr->xsize;

      size *= gridptr->nvertex;

      gridptrnew->xbounds = (double *) malloc(size*sizeof(double));
      memcpy(gridptrnew->xbounds, gridptr->xbounds, size*sizeof(double));
    }

  if ( gridptr->ybounds != NULL )
    {
      if ( gridtype == GRID_CURVILINEAR || gridtype == GRID_CELL )
	size = gridsize;
      else
	size = gridptr->ysize;

      size *= gridptr->nvertex;

      gridptrnew->ybounds = (double *) malloc(size*sizeof(double));
      memcpy(gridptrnew->ybounds, gridptr->ybounds, size*sizeof(double));
    }

  if ( gridptr->area != NULL )
    {
      size = gridsize;

      gridptrnew->area = (double *) malloc(size*sizeof(double));
      memcpy(gridptrnew->area, gridptr->area, size*sizeof(double));
    }

  if ( gridptr->mask != NULL )
    {
      size = gridsize;

      gridptrnew->mask = (int *) malloc(size*sizeof(int));
      memcpy(gridptrnew->mask, gridptr->mask, size*sizeof(int));
    }

  return (gridIDnew);
}


void gridCompress(int gridID)
{
  static char func[] = "gridCompress";
  int gridtype, gridsize;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  gridtype = gridInqType(gridID);
  gridsize = gridInqSize(gridID);

  if ( gridtype == GRID_CELL )
    {
      if ( gridptr->mask != NULL )
	{
	  long i, j, iv, nv;

	  nv = gridptr->nvertex;

	  j = 0;
	  for ( i = 0; i < gridsize; i++ )
	    {
	      if ( gridptr->mask[i] )
		{
		  if ( gridptr->xvals != NULL ) gridptr->xvals[j] = gridptr->xvals[i];
		  if ( gridptr->yvals != NULL ) gridptr->yvals[j] = gridptr->yvals[i];
		  if ( gridptr->area  != NULL ) gridptr->area[j]  = gridptr->area[i];
		  if ( gridptr->xbounds != NULL )
		    for ( iv = 0; iv < nv; iv++ )
		      gridptr->xbounds[j*nv+iv] = gridptr->xbounds[i*nv+iv];
		  if ( gridptr->ybounds != NULL )
		    for ( iv = 0; iv < nv; iv++ )
		      gridptr->ybounds[j*nv+iv] = gridptr->ybounds[i*nv+iv];

		  j++;
		}
	    }

	  /* fprintf(stderr, "grid compress %d %d %d\n", i, j, gridsize); */
	  gridsize = j;
	  gridptr->size  = gridsize;
	  gridptr->xsize = gridsize;
	  gridptr->ysize = gridsize;

	  if ( gridptr->xvals )
	    gridptr->xvals = (double *) realloc(gridptr->xvals, gridsize*sizeof(double));

	  if ( gridptr->yvals )
	    gridptr->yvals = (double *) realloc(gridptr->yvals, gridsize*sizeof(double));

	  if ( gridptr->area )
	    gridptr->area  = (double *) realloc(gridptr->area, gridsize*sizeof(double));

	  if ( gridptr->xbounds )
	    gridptr->xbounds = (double *) realloc(gridptr->xbounds, nv*gridsize*sizeof(double));

	  if ( gridptr->ybounds )
	    gridptr->ybounds = (double *) realloc(gridptr->ybounds, nv*gridsize*sizeof(double));

	  free(gridptr->mask);
	  gridptr->mask = NULL;
	}
    }
  else
    Warning(func, "Unsupported grid type: %s", gridNamePtr(gridtype));
    
}


void gridDefArea(int gridID, const double *area)
{
  static char func[] = "gridDefArea";
  long size;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  grid_check_ptr(func, gridptr);

  size = gridptr->size;

  if ( size == 0 )
    Error(func, "size undefined for gridID = %d", gridID);
    
  if ( gridptr->area == NULL )
    gridptr->area = (double *) malloc(size*sizeof(double));
  else if ( CDI_Debug )
    Warning(func, "values already defined!");

  memcpy(gridptr->area, area, size*sizeof(double));
}


void gridInqArea(int gridID, double *area)
{
  long size;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  size = gridptr->size;

  if ( gridptr->area )
    memcpy(area, gridptr->area, size*sizeof(double));
}


int gridHasArea(int gridID)
{
  int hasArea = FALSE;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( gridptr->area != NULL ) hasArea = TRUE;

  return (hasArea);
}


const double *gridInqAreaPtr(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->area);
}


void gridDefNvertex(int gridID, int nvertex)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  gridptr->nvertex = nvertex;
}


int gridInqNvertex(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->nvertex);
}


/*
@Function  gridDefXbounds
@Title     Define the bounds of a X-axis

@Prototype void gridDefXbounds(int gridID, const double *xbounds)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  xbounds  X-bounds of the grid

@Description
The function @func{gridDefXbounds} defines all bounds of the X-axis.

@EndFunction
*/
void gridDefXbounds(int gridID, const double *xbounds)
{
  static char func[] = "gridDefXbounds";
  long size;
  long nvertex;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  nvertex = gridptr->nvertex;
  if ( nvertex == 0 )
    {
      Warning(func, "nvertex undefined for gridID = %d. Cannot define bounds!", gridID);
      return;
    }

  if ( gridptr->type == GRID_CURVILINEAR || gridptr->type == GRID_CELL )
    size = nvertex*gridptr->size;
  else
    size = nvertex*gridptr->xsize;

  if ( size == 0 )
    Error(func, "size undefined for gridID = %d", gridID);
    
  if ( gridptr->xbounds == NULL )
    gridptr->xbounds = (double *) malloc(size*sizeof(double));
  else if ( CDI_Debug )
    Warning(func, "values already defined!");

  memcpy(gridptr->xbounds, xbounds, size*sizeof(double));
}


/*
@Function  gridInqXbounds
@Title     Get the bounds of a X-axis

@Prototype int gridInqXbounds(int gridID, double *xbounds)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  xbounds  X-bounds of the grid

@Description
The function @func{gridInqXbounds} returns the bounds of the X-axis.

@Result
Upon successful completion @func{gridInqXbounds} returns the number of bounds and
the bounds are stored in @func{xbounds}.
Otherwise, 0 is returned and @func{xbounds} is empty.

@EndFunction
*/
int gridInqXbounds(int gridID, double *xbounds)
{
  static char func[] = "gridInqXbounds";
  long size;
  long nvertex;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  nvertex = gridptr->nvertex;
  if ( CDI_Debug && nvertex == 0 )
    Warning(func, "nvertex undefined for gridID = %d", gridID);

  if ( gridptr->type == GRID_CURVILINEAR || gridptr->type == GRID_CELL )
    size = nvertex*gridptr->size;
  else
    size = nvertex*gridptr->xsize;

  if ( CDI_Debug && size == 0 )
    Warning(func, "size undefined for gridID = %d", gridID);

  if ( xbounds && gridptr->xbounds )
    memcpy(xbounds, gridptr->xbounds, size*sizeof(double));

  if ( gridptr->xbounds == NULL ) size = 0;

  return ((int)size);
}


double *gridInqXboundsPtr(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->xbounds);
}


/*
@Function  gridDefYbounds
@Title     Define the bounds of a Y-axis

@Prototype void gridDefYbounds(int gridID, const double *ybounds)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  ybounds  Y-bounds of the grid

@Description
The function @func{gridDefYbounds} defines all bounds of the Y-axis.

@EndFunction
*/
void gridDefYbounds(int gridID, const double *ybounds)
{
  static char func[] = "gridDefYbounds";
  long size;
  long nvertex;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  nvertex = gridptr->nvertex;
  if ( nvertex == 0 )
    {
      Warning(func, "nvertex undefined for gridID = %d. Cannot define bounds!", gridID);
      return;
    }

  if ( gridptr->type == GRID_CURVILINEAR || gridptr->type == GRID_CELL )
    size = nvertex*gridptr->size;
  else
    size = nvertex*gridptr->ysize;

  if ( size == 0 )
    Error(func, "size undefined for gridID = %d", gridID);
    
  if ( gridptr->ybounds == NULL )
    gridptr->ybounds = (double *) malloc(size*sizeof(double));
  else if ( CDI_Debug )
    Warning(func, "values already defined!");

  memcpy(gridptr->ybounds, ybounds, size*sizeof(double));
}


/*
@Function  gridInqYbounds
@Title     Get the bounds of a Y-axis

@Prototype int gridInqYbounds(int gridID, double *ybounds)
@Parameter
    @Item  gridID   Grid ID, from a previous call to @fref{gridCreate}
    @Item  ybounds  Y-bounds of the grid

@Description
The function @func{gridInqYbounds} returns the bounds of the Y-axis.

@Result
Upon successful completion @func{gridInqYbounds} returns the number of bounds and
the bounds are stored in @func{ybounds}.
Otherwise, 0 is returned and @func{ybounds} is empty.

@EndFunction
*/
int gridInqYbounds(int gridID, double *ybounds)
{
  static char func[] = "gridInqYbounds";
  long size;
  long nvertex;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  nvertex = gridptr->nvertex;
  if ( CDI_Debug && nvertex == 0 )
    Warning(func, "nvertex undefined for gridID = %d", gridID);

  if ( gridptr->type == GRID_CURVILINEAR || gridptr->type == GRID_CELL )
    size = nvertex*gridptr->size;
  else
    size = nvertex*gridptr->ysize;

  if ( CDI_Debug && size == 0 )
    Warning(func, "size undefined for gridID = %d", gridID);

  if ( ybounds && gridptr->ybounds )
    memcpy(ybounds, gridptr->ybounds, size*sizeof(double));

  if ( gridptr->ybounds == NULL ) size = 0;

  return ((int)size);
}


double *gridInqYboundsPtr(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return (gridptr->ybounds);
}


void gridPrint(int gridID, int opt)
{
  static char func[] = "gridPrint";
  FILE *fp = stdout;
  int type;
  int gridsize, xsize, ysize, xdim, ydim;
  int trunc;
  int nbyte0, nbyte;
  int index;
  int nvertex, iv;
  const double *area    = gridInqAreaPtr(gridID);
  const double *xvals   = gridInqXvalsPtr(gridID);
  const double *yvals   = gridInqYvalsPtr(gridID);
  const double *xbounds = gridInqXboundsPtr(gridID);
  const double *ybounds = gridInqYboundsPtr(gridID);
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  type     = gridInqType(gridID);
  trunc    = gridInqTrunc(gridID);
  gridsize = gridInqSize(gridID);
  xsize    = gridInqXsize(gridID);
  ysize    = gridInqYsize(gridID);
  nvertex  = gridInqNvertex(gridID);

  nbyte0 = 0;
  fprintf(fp, "#\n");
  fprintf(fp, "# gridID %d\n", gridID);
  fprintf(fp, "#\n");
  fprintf(fp, "gridtype  = %s\n", gridNamePtr(type));
  fprintf(fp, "gridsize  = %d\n", gridsize);

  if ( type != GRID_GME )
    {
      if ( gridptr->xname[0]     ) fprintf(fp, "xname     = %s\n", gridptr->xname);
      if ( gridptr->xlongname[0] ) fprintf(fp, "xlongname = %s\n", gridptr->xlongname);
      if ( gridptr->xunits[0]    ) fprintf(fp, "xunits    = %s\n", gridptr->xunits);
      if ( gridptr->yname[0]     ) fprintf(fp, "yname     = %s\n", gridptr->yname);
      if ( gridptr->ylongname[0] ) fprintf(fp, "ylongname = %s\n", gridptr->ylongname);
      if ( gridptr->yunits[0]    ) fprintf(fp, "yunits    = %s\n", gridptr->yunits);
      if ( type == GRID_CELL )     fprintf(fp, "nvertex   = %d\n", nvertex);
    }

  switch (type)
    {
    case GRID_LONLAT:
    case GRID_GAUSSIAN:
    case GRID_GENERIC:
    case GRID_LCC2:
    case GRID_SINUSOIDAL:
    case GRID_LAEA:
    case GRID_CURVILINEAR:
    case GRID_CELL:
      {
	if ( type == GRID_CURVILINEAR || type == GRID_CELL )
	  {
	    xdim = gridsize;
	    ydim = gridsize;
	  }
	else
	  {
	    xdim = xsize;
	    ydim = ysize;
	  }

	if ( type != GRID_CELL )
	  {
	    if ( xsize > 0 ) fprintf(fp, "xsize     = %d\n", xsize);
	    if ( ysize > 0 ) fprintf(fp, "ysize     = %d\n", ysize);
	  }

	if ( type == GRID_LAEA )
	  {
	    double a, lon_0, lat_0;
	    gridInqLaea(gridID, &a, &lon_0, &lat_0);
	    fprintf(fp, "a         = %g\n", a);
	    fprintf(fp, "lon_0     = %g\n", lon_0);
	    fprintf(fp, "lat_0     = %g\n", lat_0);
	  }

	if ( type == GRID_LCC2 )
	  {
	    double a, lon_0, lat_0, lat_1, lat_2;
	    gridInqLcc2(gridID, &a, &lon_0, &lat_0, &lat_1, &lat_2);
	    fprintf(fp, "a         = %g\n", a);
	    fprintf(fp, "lon_0     = %g\n", lon_0);
	    fprintf(fp, "lat_0     = %g\n", lat_0);
	    fprintf(fp, "lat_1     = %g\n", lat_1);
	    fprintf(fp, "lat_2     = %g\n", lat_2);
	  }

	if ( gridptr->isRotated )
	  {
	    if ( xsize > 0 ) fprintf(fp, "xnpole    = %g\n", gridptr->xpole);
	    if ( ysize > 0 ) fprintf(fp, "ynpole    = %g\n", gridptr->ypole);
	    if ( gridptr->angle > 0 ) fprintf(fp, "angle     = %g\n", gridptr->angle);
	  }

	if ( xvals )
	  {
	    double xfirst = 0.0, xinc = 0.0;

	    if ( type == GRID_LONLAT     || type == GRID_GAUSSIAN || 
		 type == GRID_GENERIC    || type == GRID_LCC2     || 
                 type == GRID_SINUSOIDAL || type == GRID_LAEA )
	      {
		xfirst = gridInqXval(gridID, 0);
		xinc   = gridInqXinc(gridID);
	      }

	    if ( IS_NOT_EQUAL(xinc, 0) && opt )
	      {
	  	fprintf(fp, "xfirst    = %g\n", xfirst);
		fprintf(fp, "xinc      = %g\n", xinc);
	      }
	    else
	      {
		nbyte0 = fprintf(fp, "xvals     = ");
		nbyte = nbyte0;
		for ( index = 0; index < xdim; index++ )
		  {
		    if ( nbyte > 80 )
		      {
			fprintf(fp, "\n");
			fprintf(fp, "%*s", nbyte0, "");
			nbyte = nbyte0;
		      }
		    nbyte += fprintf(fp, "%.9g ", xvals[index]);
		  }
		fprintf(fp, "\n");
	      }
	  }

	if ( xbounds )
	  {
	    nbyte0 = fprintf(fp, "xbounds   = ");
	    for ( index = 0; index < xdim; index++ )
	      {
		if ( index ) fprintf(fp, "%*s", nbyte0, "");

		for ( iv = 0; iv < nvertex; iv++ )
		  fprintf(fp, "%.9g ", xbounds[index*nvertex+iv]);
		fprintf(fp, "\n");
	      }
	  }

	if ( yvals )
	  {
	    double yfirst = 0.0, yinc = 0.0;

	    if ( type == GRID_LONLAT || type == GRID_GENERIC || type == GRID_LCC2 ||
		 type == GRID_SINUSOIDAL || type == GRID_LAEA )
	      {
		yfirst = gridInqYval(gridID, 0);
		yinc   = gridInqYinc(gridID);
	      }

	    if ( IS_NOT_EQUAL(yinc, 0) && opt )
	      {
	  	fprintf(fp, "yfirst    = %g\n", yfirst);
		fprintf(fp, "yinc      = %g\n", yinc);
	      }
	    else
	      {
		nbyte0 = fprintf(fp, "yvals     = ");
		nbyte = nbyte0;
		for ( index = 0; index < ydim; index++ )
		  {
		    if ( nbyte > 80 )
		      {
			fprintf(fp, "\n");
			fprintf(fp, "%*s", nbyte0, "");
			nbyte = nbyte0;
		      }
		    nbyte += fprintf(fp, "%.9g ", yvals[index]);
		  }
		fprintf(fp, "\n");
	      }
	  }

	if ( ybounds )
	  {
	    nbyte0 = fprintf(fp, "ybounds   = ");
	    for ( index = 0; index < ydim; index++ )
	      {
		if ( index ) fprintf(fp, "%*s", nbyte0, "");

		for ( iv = 0; iv < nvertex; iv++ )
		  fprintf(fp, "%.9g ", ybounds[index*nvertex+iv]);
		fprintf(fp, "\n");
	      }
	  }

	if ( area )
	  {
	    nbyte0 = fprintf(fp, "area      = ");
	    nbyte  = nbyte0;
	    for ( index = 0; index < gridsize; index++ )
	      {
		if ( nbyte > 80 )
		  {
		    fprintf(fp, "\n");
		    fprintf(fp, "%*s", nbyte0, "");
		    nbyte = nbyte0;
		  }
		nbyte += fprintf(fp, "%.9g ", area[index]);
	      }
	    fprintf(fp, "\n");
	  }
	break;
      }
   case GRID_GAUSSIAN_REDUCED:
      {
	int *rowlon;
	fprintf(fp, "ysize = %d\n", ysize);	        
	nbyte0 = fprintf(fp, "rowlon = %d  ", ysize);
	nbyte  = nbyte0;
	rowlon = (int *) malloc(ysize*sizeof(int));
	gridInqRowlon(gridID, rowlon);
	for ( index = 0; index < ysize; index++ )
	  {
	    if ( nbyte > 80 )
	      {
		fprintf(fp, "\n");
		fprintf(fp, "%*s", nbyte0, "");
		nbyte = nbyte0;
	      }
	    nbyte += fprintf(fp, "%d ", rowlon[index]);
	  }
	fprintf(fp, "\n");
	free(rowlon);
	break;
      }
    case GRID_LCC:
      {
	double originLon, originLat, lonParY, lat1, lat2, xincm, yincm;
	int projflag, scanflag;
	gridInqLCC(gridID, &originLon, &originLat, &lonParY, &lat1, &lat2, &xincm, &yincm,
		   &projflag, &scanflag);

	fprintf(fp, "xsize     = %d\n", xsize);
	fprintf(fp, "ysize     = %d\n", ysize);

	fprintf(fp, "originLon = %g\n", originLon);
	fprintf(fp, "originLat = %g\n", originLat);
	fprintf(fp, "lonParY   = %g\n", lonParY);
	fprintf(fp, "lat1      = %g\n", lat1);
	fprintf(fp, "lat2      = %g\n", lat2);
	fprintf(fp, "xinc      = %g\n", xincm);
	fprintf(fp, "yinc      = %g\n", yincm);
	if ( (projflag & 128) == 0 )
	  fprintf(fp, "projection= northpole\n");
	else
	  fprintf(fp, "projection= southpole\n");

	break;
      }
    case GRID_SPECTRAL:
      {
	fprintf(fp, "truncation = %d\n", trunc);
	fprintf(fp, "complexpacking = %d\n", gridInqComplexPacking(gridID));
	break;
      }
    case GRID_GME:
      {
	fprintf(fp, "ni        = %d\n", gridInqGMEni(gridID));
	break;
      }
   default:
      {
	fprintf(stderr, "Unsupported grid type: %s\n", gridNamePtr(type));
      }
    }
}


const double *gridInqXvalsPtr(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return ( gridptr->xvals );
}


const double *gridInqYvalsPtr(int gridID)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  return ( gridptr->yvals );
}


/*
@Function  gridDefLCC
@Title     Define the parameter of a Lambert Conformal Conic grid

@Prototype void gridDefLCC(int gridID, double originLon, double originLat, double lonParY, double lat1, double lat2, double xinc, double yinc, int projflag, int scanflag)
@Parameter
    @Item  gridID    Grid ID, from a previous call to @fref{gridCreate}
    @Item  originLon Longitude of the first grid point
    @Item  originLat Latitude of the first grid point
    @Item  lonParY   The East longitude of the meridian which is parallel to the Y-axis
    @Item  lat1      First latitude from the pole at which the secant cone cuts the sphere
    @Item  lat2      Second latitude at which the secant cone cuts the sphere
    @Item  xinc      X-direction grid lenght in meter
    @Item  yinc      Y-direction grid lenght in meter
    @Item  projflag  Projection centre flag
    @Item  scanflag  Scanning mode flag
 
@Description
The function @func{gridDefLCC} defines the parameter of a Lambert Conformal Conic grid.

@EndFunction
*/
void gridDefLCC(int gridID, double originLon, double originLat, double lonParY,
		double lat1, double lat2, double xinc, double yinc,
		int projflag, int scanflag)
{
  static char func[] = "gridDefLCC";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( gridptr->type != GRID_LCC )
    Warning(func, "Definition of LCC grid for %s grid not allowed!",
	    gridNamePtr(gridptr->type));
  else
    {
      gridptr->lcc_originLon = originLon;
      gridptr->lcc_originLat = originLat;
      gridptr->lcc_lonParY   = lonParY;
      gridptr->lcc_lat1      = lat1;
      gridptr->lcc_lat2      = lat2;
      gridptr->lcc_xinc      = xinc;
      gridptr->lcc_yinc      = yinc;
      gridptr->lcc_projflag  = projflag;
      gridptr->lcc_scanflag  = scanflag;
      gridptr->lcc_defined   = TRUE;
    }
}


/*
@Function  gridInqLCC
@Title     Get the parameter of a Lambert Conformal Conic grid

@Prototype void gridInqLCC(int gridID, double *originLon, double *originLat, double *lonParY, double *lat1, double *lat2, double *xinc, double *yinc, int *projflag, int *scanflag)
@Parameter
    @Item  gridID    Grid ID, from a previous call to @fref{gridCreate}
    @Item  originLon Longitude of the first grid point
    @Item  originLat Latitude of the first grid point
    @Item  lonParY   The East longitude of the meridian which is parallel to the Y-axis
    @Item  lat1      First latitude from the pole at which the secant cone cuts the sphere
    @Item  lat2      Second latitude at which the secant cone cuts the sphere
    @Item  xinc      X-direction grid lenght in meter
    @Item  yinc      Y-direction grid lenght in meter
    @Item  projflag  Projection centre flag
    @Item  scanflag  Scanning mode flag
 
@Description
The function @func{gridInqLCC} returns the parameter of a Lambert Conformal Conic grid.

@EndFunction
*/
void gridInqLCC(int gridID, double *originLon, double *originLat, double *lonParY,
		double *lat1, double *lat2, double *xinc, double *yinc,
		int *projflag, int *scanflag)
{
  static char func[] = "gridInqLCC";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( gridptr->type != GRID_LCC )
    Warning(func, "Inquire of LCC grid definition for %s grid not allowed!",
	    gridNamePtr(gridptr->type));
  else
    {
      if ( gridptr->lcc_defined )
	{
	  *originLon = gridptr->lcc_originLon;
	  *originLat = gridptr->lcc_originLat;
	  *lonParY   = gridptr->lcc_lonParY;
	  *lat1      = gridptr->lcc_lat1;
	  *lat2      = gridptr->lcc_lat2;
	  *xinc      = gridptr->lcc_xinc;
	  *yinc      = gridptr->lcc_yinc;
	  *projflag  = gridptr->lcc_projflag;
	  *scanflag  = gridptr->lcc_scanflag;
	}
      else
	Warning(func, "Lambert Conformal grid undefined (gridID = %d)", gridID);
    }
}

void gridDefLcc2(int gridID, double earth_radius, double lon_0, double lat_0, double lat_1, double lat_2)
{
  static char func[] = "gridDefLcc2";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( gridptr->type != GRID_LCC2 )
    Warning(func, "Definition of LCC2 grid for %s grid not allowed!",
	    gridNamePtr(gridptr->type));
  else
    {
      gridptr->lcc2_a       = earth_radius;
      gridptr->lcc2_lon_0   = lon_0;
      gridptr->lcc2_lat_0   = lat_0;
      gridptr->lcc2_lat_1   = lat_1;
      gridptr->lcc2_lat_2   = lat_2;
      gridptr->lcc2_defined = TRUE;
    }
}


void gridInqLcc2(int gridID, double *earth_radius, double *lon_0, double *lat_0, double *lat_1, double *lat_2)
{
  static char func[] = "gridInqLcc2";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( gridptr->type != GRID_LCC2 )
    Warning(func, "Inquire of LCC2 grid definition for %s grid not allowed!",
	    gridNamePtr(gridptr->type));
  else
    {
      if ( gridptr->lcc2_defined )
	{
	  *earth_radius = gridptr->lcc2_a;
	  *lon_0        = gridptr->lcc2_lon_0;
	  *lat_0        = gridptr->lcc2_lat_0;
	  *lat_1        = gridptr->lcc2_lat_1;
	  *lat_2        = gridptr->lcc2_lat_2;
	}
      else
	Warning(func, "LCC2 grid undefined (gridID = %d)", gridID);
    }
}

void gridDefLaea(int gridID, double earth_radius, double lon_0, double lat_0)
{
  static char func[] = "gridDefLaea";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( gridptr->type != GRID_LAEA )
    Warning(func, "Definition of LAEA grid for %s grid not allowed!",
	    gridNamePtr(gridptr->type));
  else
    {
      gridptr->laea_a       = earth_radius;
      gridptr->laea_lon_0   = lon_0;
      gridptr->laea_lat_0   = lat_0;
      gridptr->laea_defined = TRUE;
    }
}


void gridInqLaea(int gridID, double *earth_radius, double *lon_0, double *lat_0)
{
  static char func[] = "gridInqLaea";
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  if ( gridptr->type != GRID_LAEA )
    Warning(func, "Inquire of LAEA grid definition for %s grid not allowed!",
	    gridNamePtr(gridptr->type));
  else
    {
      if ( gridptr->laea_defined )
	{
	  *earth_radius = gridptr->laea_a;
	  *lon_0        = gridptr->laea_lon_0;
	  *lat_0        = gridptr->laea_lat_0;
	}
      else
	Warning(func, "LAEA grid undefined (gridID = %d)", gridID);
    }
}


void gridDefComplexPacking(int gridID, int lcomplex)
{
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  gridptr->lcomplex = lcomplex;
}


int gridInqComplexPacking(int gridID)
{
  int lcomplex;
  grid_t *gridptr;

  gridptr = grid_to_pointer(gridID);

  lcomplex = gridptr->lcomplex;

  return (lcomplex);
}
#if defined (HAVE_CONFIG_H)
#endif





static struct {
  char *name;
  char *longname;
  char *units;
}
ZaxistypeEntry[] = {
  {"sfc",     "surface",                  ""},
  {"lev",     "generic",                  "level"},
  {"lev",     "hybrid",                   "level"},
  {"lev",     "hybrid_half",              "level"},
  {"lev",     "pressure",                 "Pa"},
  {"height",  "height",                   "m"},
  {"depth",   "depth_below_sea",          "m"},
  {"depth",   "depth_below_land",         "cm"},
  {"lev",     "isentropic",               "K"},
  {"lev",     "trajectory",               ""},
  {"alt",     "altitude",                 "m"},
  {"lev",     "sigma",                    "level"},
  {"lev",     "meansea",                  "level"},
};

static int CDI_MaxZaxistype = sizeof(ZaxistypeEntry) / sizeof(ZaxistypeEntry[0]);


#define  LevelDown  0
#define  LevelUp    1

typedef struct {
  char     name[256];
  char     longname[256];
  char     units[256];
  double  *vals;
  double  *lbounds;
  double  *ubounds;
  double  *weights;
  int      self;
  int      prec;
  int      type;
  int      ltype;    /* GRIB level type */
  int      size;
  int      direction;
  int      vctsize;
  double  *vct;
}
ZAXIS;

static int  ZAXIS_Debug = 0;   /* If set to 1, debugging */

static int _zaxis_max = MAX_ZAXES;

static void zaxis_initialize(void);

static int _zaxis_init = FALSE;

#if  defined  (HAVE_LIBPTHREAD)

static pthread_once_t _zaxis_init_thread = PTHREAD_ONCE_INIT;
static pthread_mutex_t _zaxis_mutex;

#  define ZAXIS_LOCK           pthread_mutex_lock(&_zaxis_mutex);
#  define ZAXIS_UNLOCK         pthread_mutex_unlock(&_zaxis_mutex);
#  define ZAXIS_INIT                               \
   if ( _zaxis_init == FALSE ) pthread_once(&_zaxis_init_thread, zaxis_initialize);

#else

#  define ZAXIS_LOCK
#  define ZAXIS_UNLOCK
#  define ZAXIS_INIT                               \
   if ( _zaxis_init == FALSE ) zaxis_initialize();

#endif


typedef struct _zaxisPtrToIdx {
  int idx;
  ZAXIS *ptr;
  struct _zaxisPtrToIdx *next;
} zaxisPtrToIdx;


static zaxisPtrToIdx *_zaxisList  = NULL;
static zaxisPtrToIdx *_zaxisAvail = NULL;


static void zaxis_list_new(void)
{
  static char func[] = "zaxis_list_new";

  assert(_zaxisList == NULL);

  _zaxisList = (zaxisPtrToIdx *) malloc(_zaxis_max*sizeof(zaxisPtrToIdx));
}


static void zaxis_list_delete(void)
{
  static char func[] = "zaxis_list_delete";

  if ( _zaxisList ) free(_zaxisList);
}


static void zaxis_init_pointer(void)
{
  int  i;
  
  for ( i = 0; i < _zaxis_max; i++ )
    {
      _zaxisList[i].next = _zaxisList + i + 1;
      _zaxisList[i].idx  = i;
      _zaxisList[i].ptr  = 0;
    }

  _zaxisList[_zaxis_max-1].next = 0;

  _zaxisAvail = _zaxisList;
}


ZAXIS *zaxis_to_pointer(int idx)
{
  static char func[] = "zaxis_to_pointer";
  ZAXIS *zaxisptr = NULL;

  ZAXIS_INIT

  if ( idx >= 0 && idx < _zaxis_max )
    {
      ZAXIS_LOCK

      zaxisptr = _zaxisList[idx].ptr;

      ZAXIS_UNLOCK
    }
  else
    Error(func, "zaxis index %d undefined!", idx);

  return (zaxisptr);
}


/* Create an index from a pointer */
static int zaxis_from_pointer(ZAXIS *ptr)
{
  static char func[] = "zaxis_from_pointer";
  int      idx = -1;
  zaxisPtrToIdx *newptr;

  if ( ptr )
    {
      ZAXIS_LOCK

      if ( _zaxisAvail )
	{
	  newptr       = _zaxisAvail;
	  _zaxisAvail  = _zaxisAvail->next;
	  newptr->next = 0;
	  idx	       = newptr->idx;
	  newptr->ptr  = ptr;
      
	  if ( ZAXIS_Debug )
	    Message(func, "Pointer %p has idx %d from zaxis list", ptr, idx);
	}
      else
	Warning(func, "Too many open zaxis (limit is %d)!", _zaxis_max);

      ZAXIS_UNLOCK
    }
  else
    Error(func, "Internal problem (pointer %p undefined)", ptr);

  return (idx);
}


static void zaxis_init_entry(ZAXIS *zaxisptr)
{
  zaxisptr->self        = zaxis_from_pointer(zaxisptr);

  zaxisptr->name[0]     = 0;
  zaxisptr->longname[0] = 0;
  zaxisptr->units[0]    = 0;
  zaxisptr->vals        = NULL;
  zaxisptr->ubounds     = NULL;
  zaxisptr->lbounds     = NULL;
  zaxisptr->weights     = NULL;
  zaxisptr->type        = CDI_UNDEFID;
  zaxisptr->ltype       = 0;
  zaxisptr->direction   = CDI_UNDEFID;
  zaxisptr->prec        = 0;
  zaxisptr->size        = 0;
  zaxisptr->vctsize     = 0;
  zaxisptr->vct         = NULL;
}


static ZAXIS *zaxis_new_entry(void)
{
  static char func[] = "zaxis_new_entry";
  ZAXIS *zaxisptr;

  zaxisptr = (ZAXIS *) malloc(sizeof(ZAXIS));

  if ( zaxisptr ) zaxis_init_entry(zaxisptr);

  return (zaxisptr);
}


static void zaxis_delete_entry(ZAXIS *zaxisptr)
{
  static char func[] = "zaxis_delete_entry";
  int idx;

  idx = zaxisptr->self;

  ZAXIS_LOCK

  free(zaxisptr);

  _zaxisList[idx].next = _zaxisAvail;
  _zaxisList[idx].ptr  = 0;
  _zaxisAvail          = &_zaxisList[idx];

  ZAXIS_UNLOCK

  if ( ZAXIS_Debug )
    Message(func, "Removed idx %d from zaxis list", idx);
}


static void zaxis_initialize(void)
{
  char *env;

#if  defined  (HAVE_LIBPTHREAD)
  /* initialize global API mutex lock */
  pthread_mutex_init(&_zaxis_mutex, NULL);
#endif

  env = getenv("ZAXIS_DEBUG");
  if ( env ) ZAXIS_Debug = atoi(env);

  zaxis_list_new();
  atexit(zaxis_list_delete);

  ZAXIS_LOCK

  zaxis_init_pointer();

  ZAXIS_UNLOCK

  _zaxis_init = TRUE;
}


static void zaxis_copy(ZAXIS *zaxisptr2, ZAXIS *zaxisptr1)
{
  int zaxisID2;

  zaxisID2 = zaxisptr2->self;
  memcpy(zaxisptr2, zaxisptr1, sizeof(ZAXIS));
  zaxisptr2->self = zaxisID2;
}


static void zaxis_check_ptr(const char *func, ZAXIS *zaxisptr)
{
  if ( zaxisptr == NULL )
    Error(func, "zaxis undefined!");
}


int zaxisSize(void)
{
  int zaxissize = 0;
  int i;
  
  ZAXIS_INIT

  ZAXIS_LOCK

  for ( i = 0; i < _zaxis_max; i++ )
    if ( _zaxisList[i].ptr ) zaxissize++;

  ZAXIS_UNLOCK

  return (zaxissize);
}


/*
@Function  zaxisCreate
@Title     Create a vertical Z-axis

@Prototype int zaxisCreate(int zaxistype, int size)
@Parameter
    @Item  zaxistype  The type of the Z-axis, one of the set of predefined CDI Z-axis types.
                      The valid CDI Z-axis types are @func{ZAXIS_GENERIC}, @func{ZAXIS_SURFACE},
                      @func{ZAXIS_HYBRID}, @func{ZAXIS_SIGMA}, @func{ZAXIS_PRESSURE}, @func{ZAXIS_HEIGHT},
                      @func{ZAXIS_DEPTH_BELOW_SEA} and @func{ZAXIS_DEPTH_BELOW_LAND}.
    @Item  size       Number of levels

@Description
The function @func{zaxisCreate} creates a vertical Z-axis.

@Result
@func{zaxisCreate} returns an identifier to the Z-axis.

@Example
Here is an example using @func{zaxisCreate} to create a pressure level Z-axis:

@Source
   ...
#define  NLEV    5
   ...
double levs[NLEV] = {101300, 92500, 85000, 50000, 20000};
int zaxisID;
   ...
zaxisID = zaxisCreate(ZAXIS_PRESSURE, NLEV);
zaxisDefLevels(zaxisID, levs);
   ...
@EndSource
@EndFunction
*/
int zaxisCreate(int zaxistype, int size)
{
  static char func[] = "zaxisCreate";
  int ilev;
  int zaxisID;
  double *vals;
  ZAXIS *zaxisptr;

  if ( CDI_Debug )
    Message(func, "zaxistype: %d size: %d ", zaxistype, size);

  ZAXIS_INIT

  zaxisptr = zaxis_new_entry();
  if ( ! zaxisptr ) Error(func, "No memory");

  zaxisID = zaxisptr->self;

  zaxisptr->type = zaxistype;
  zaxisptr->size = size;

  if ( zaxistype > CDI_MaxZaxistype )
    Error(func, "Internal problem! zaxistype > CDI_MaxZaxistype");

  zaxisDefName(zaxisID, ZaxistypeEntry[zaxistype].name);
  zaxisDefLongname(zaxisID, ZaxistypeEntry[zaxistype].longname);
  zaxisDefUnits(zaxisID, ZaxistypeEntry[zaxistype].units);

  vals = (double *) malloc(size*sizeof(double));

  for ( ilev = 0; ilev < size; ilev++ )
    vals[ilev] = 0.0;

  zaxisptr->vals = vals;

  return (zaxisID);
}


/*
@Function  zaxisDestroy
@Title     Destroy a vertical Z-axis

@Prototype void zaxisDestroy(int zaxisID)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}

@EndFunction
*/
void zaxisDestroy(int zaxisID)
{
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);
}


char *zaxisNamePtr(int zaxistype)
{
  char *name;

  if ( zaxistype >= 0 && zaxistype < CDI_MaxZaxistype )
    name = ZaxistypeEntry[zaxistype].longname;
  else
    name = ZaxistypeEntry[ZAXIS_GENERIC].longname;

  return (name);
}


void zaxisName(int zaxistype, char *zaxisname)
{
  strcpy(zaxisname, zaxisNamePtr(zaxistype));
}


/*
@Function  zaxisDefName
@Title     Define the name of a Z-axis

@Prototype void zaxisDefName(int zaxisID, const char *name)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  name     Name of the Z-axis

@Description
The function @func{zaxisDefName} defines the name of a Z-axis.

@EndFunction
*/
void zaxisDefName(int zaxisID, const char *name)
{
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  if ( name )
    strcpy(zaxisptr->name, name);
}


/*
@Function  zaxisDefLongname
@Title     Define the longname of a Z-axis

@Prototype void zaxisDefLongname(int zaxisID, const char *longname)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  longname Longname of the Z-axis

@Description
The function @func{zaxisDefLongname} defines the longname of a Z-axis.

@EndFunction
*/
void zaxisDefLongname(int zaxisID, const char *longname)
{
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  if ( longname )
    strcpy(zaxisptr->longname, longname);
}


/*
@Function  zaxisDefUnits
@Title     Define the units of a Z-axis

@Prototype void zaxisDefUnits(int zaxisID, const char *units)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  units    Units of the Z-axis

@Description
The function @func{zaxisDefUnits} defines the units of a Z-axis.

@EndFunction
*/
void zaxisDefUnits(int zaxisID, const char *units)
{
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  if ( units )
    strcpy(zaxisptr->units, units);
}


/*
@Function  zaxisInqName
@Title     Get the name of a Z-axis

@Prototype void zaxisInqName(int zaxisID, char *name)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  name     Name of the Z-axis

@Description
The function @func{zaxisInqName} returns the name of a Z-axis.

@Result
@func{zaxisInqName} returns the name of the Z-axis to the parameter name.

@EndFunction
*/
void zaxisInqName(int zaxisID, char *name)
{
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  strcpy(name, zaxisptr->name);
}


/*
@Function  zaxisInqLongname
@Title     Get the longname of a Z-axis

@Prototype void zaxisInqLongname(int zaxisID, char *longname)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  longname Longname of the Z-axis

@Description
The function @func{zaxisInqLongname} returns the longname of a Z-axis.

@Result
@func{zaxisInqLongname} returns the longname of the Z-axis to the parameter longname.

@EndFunction
*/
void zaxisInqLongname(int zaxisID, char *longname)
{
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  strcpy(longname, zaxisptr->longname);
}


/*
@Function  zaxisInqUnits
@Title     Get the units of a Z-axis

@Prototype void zaxisInqUnits(int zaxisID, char *units)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  units    Units of the Z-axis

@Description
The function @func{zaxisInqUnits} returns the units of a Z-axis.

@Result
@func{zaxisInqUnits} returns the units of the Z-axis to the parameter units.

@EndFunction
*/
void zaxisInqUnits(int zaxisID, char *units)
{
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  strcpy(units, zaxisptr->units);
}


void zaxisDefPrec(int zaxisID, int prec)
{
  static char func[] = "zaxisDefPrec";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  zaxisptr->prec = prec;
}


int zaxisInqPrec(int zaxisID)
{
  static char func[] = "zaxisInqPrec";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  return (zaxisptr->prec);
}


void zaxisDefLtype(int zaxisID, int ltype)
{
  static char func[] = "zaxisDefLtype";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  zaxisptr->ltype = ltype;
}


int zaxisInqLtype(int zaxisID)
{
  static char func[] = "zaxisInqLtype";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  return (zaxisptr->ltype);
}


/*
@Function  zaxisDefLevels
@Title     Define the levels of a Z-axis

@Prototype void zaxisDefLevels(int zaxisID, const double *levels)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  levels   All levels of the Z-axis

@Description
The function @func{zaxisDefLevels} defines the levels of a Z-axis.

@EndFunction
*/
void zaxisDefLevels(int zaxisID, const double *levels)
{
  static char func[] = "zaxisDefLevels";
  int ilev;
  int size;
  double *vals;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  size = zaxisptr->size;

  vals = zaxisptr->vals;

  for ( ilev = 0; ilev < size; ilev++ )
    vals[ilev] = levels[ilev];
}


/*
@Function  zaxisDefLevel
@Title     Define one level of a Z-axis

@Prototype void zaxisDefLevel(int zaxisID, int levelID, double level)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  levelID  Level identifier
    @Item  level    Level

@Description
The function @func{zaxisDefLevel} defines one level of a Z-axis.

@EndFunction
*/
void zaxisDefLevel(int zaxisID, int levelID, double level)
{
  static char func[] = "zaxisDefLevel";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  if ( levelID >= 0 && levelID < zaxisptr->size )
    zaxisptr->vals[levelID] = level;
}


/*
@Function  zaxisInqLevel
@Title     Get one level of a Z-axis

@Prototype double zaxisInqLevel(int zaxisID, int levelID)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  levelID  Level index (range: 0 to nlevel-1)

@Description
The function @func{zaxisInqLevel} returns one level of a Z-axis.

@Result
@func{zaxisInqLevel} returns the level of a Z-axis.
@EndFunction
*/
double zaxisInqLevel(int zaxisID, int levelID)
{
  static char func[] = "zaxisInqLevel";
  double level = 0;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  if ( levelID >= 0 && levelID < zaxisptr->size )
    level = zaxisptr->vals[levelID];

  return (level);
}


double zaxisInqLbound(int zaxisID, int index)
{
  static char func[] = "zaxisInqLbound";
  double level = 0;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  if ( zaxisptr->lbounds )
    if ( index >= 0 && index < zaxisptr->size )
      level = zaxisptr->lbounds[index];

  return (level);
}


double zaxisInqUbound(int zaxisID, int index)
{
  static char func[] = "zaxisInqUbound";
  double level = 0;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  if ( zaxisptr->ubounds )
    if ( index >= 0 && index < zaxisptr->size )
      level = zaxisptr->ubounds[index];

  return (level);
}


const double *zaxisInqLevelsPtr(int zaxisID)
{
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  return ( zaxisptr->vals );
}


/*
@Function  zaxisInqLevels
@Title     Get all levels of a Z-axis

@Prototype void zaxisInqLevels(int zaxisID, double *levels)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}
    @Item  levels   Levels of the Z-axis
    
@Description
The function @func{zaxisInqLevels} returns all levels of a Z-axis.

@Result
@func{zaxisInqLevels} saves all levels to the parameter @func{levels}.
@EndFunction
*/
void zaxisInqLevels(int zaxisID, double *levels)
{
  static char func[] = "zaxisInqLevels";
  int size;
  int i;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  size = zaxisptr->size;
  for ( i = 0; i < size; i++ )
    levels[i] =  zaxisptr->vals[i];
}


int zaxisInqLbounds(int zaxisID, double *lbounds)
{
  static char func[] = "zaxisInqLbounds";
  int size = 0;
  int i;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  if ( zaxisptr->lbounds )
    {
      size = zaxisptr->size;

      if ( lbounds )
	for ( i = 0; i < size; i++ )
	  lbounds[i] =  zaxisptr->lbounds[i];
    }

  return (size);
}


int zaxisInqUbounds(int zaxisID, double *ubounds)
{
  static char func[] = "zaxisInqUbounds";
  int size = 0;
  int i;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  if ( zaxisptr->ubounds )
    {
      size = zaxisptr->size;

      if ( ubounds )
	for ( i = 0; i < size; i++ )
	  ubounds[i] =  zaxisptr->ubounds[i];
    }

  return (size);
}


int zaxisInqWeights(int zaxisID, double *weights)
{
  static char func[] = "zaxisInqWeights";
  int size = 0;
  int i;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  if ( zaxisptr->weights )
    {
      size = zaxisptr->size;

      if ( weights )
	for ( i = 0; i < size; i++ )
	  weights[i] =  zaxisptr->weights[i];
    }

  return (size);
}


int zaxisInqLevelID(int zaxisID, double level)
{
  static char func[] = "zaxisInqLevelID";
  int size;
  int levelID = CDI_UNDEFID;
  int i;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  size = zaxisptr->size;
  for ( i = 0; i < size; i++ )
    if ( fabs(level-zaxisptr->vals[i]) < DBL_EPSILON ) break;

  if ( i < size ) levelID = i;

  return (levelID);
}


/*
@Function  zaxisInqType
@Title     Get the type of a Z-axis

@Prototype int zaxisInqType(int zaxisID)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}

@Description
The function @func{zaxisInqType} returns the type of a Z-axis.

@Result
@func{zaxisInqType} returns the type of the Z-axis,
one of the set of predefined CDI Z-axis types.
The valid CDI Z-axis types are @func{ZAXIS_GENERIC}, @func{ZAXIS_SURFACE},
@func{ZAXIS_HYBRID}, @func{ZAXIS_SIGMA}, @func{ZAXIS_PRESSURE}, @func{ZAXIS_HEIGHT},
@func{ZAXIS_DEPTH_BELOW_SEA} and @func{ZAXIS_DEPTH_BELOW_LAND}.

@EndFunction
*/
int zaxisInqType(int zaxisID)
{
  static char func[] = "zaxisInqType";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  return (zaxisptr->type);
}


/*
@Function  zaxisInqSize
@Title     Get the size of a Z-axis

@Prototype int zaxisInqSize(int zaxisID)
@Parameter
    @Item  zaxisID  Z-axis ID, from a previous call to @fref{zaxisCreate}

@Description
The function @func{zaxisInqSize} returns the size of a Z-axis.

@Result
@func{zaxisInqSize} returns the number of levels of a Z-axis.

@EndFunction
*/
int zaxisInqSize(int zaxisID)
{
  static char func[] = "zaxisInqSize";
  int size = 1;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  size = zaxisptr->size;

  return (size);
}


void cdiCheckZaxis(int zaxisID)
{
  static char func[] = "cdiCheckZaxis";
  int size, i, found;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);
  
  zaxis_check_ptr(func, zaxisptr);

  if ( zaxisInqType(zaxisID) == ZAXIS_GENERIC )
    {
      size = zaxisptr->size;
      if ( size > 1 )
	{
	  /* check direction */
	  if ( zaxisptr->direction == CDI_UNDEFID )
	    {
	      found = 0;
	      for ( i = 1; i < size; i++ )
		if ( zaxisptr->vals[i] > zaxisptr->vals[i-1] )
		  found++;
	      if ( found == size-1 )
		{
		  zaxisptr->direction = LevelUp;
		}
	      else
		{
		  found = 0;
		  for ( i = 1; i < size; i++ )
		    if ( zaxisptr->vals[i] < zaxisptr->vals[i-1] )
		      found++;
		  if ( found == size-1 )
		    {
		      zaxisptr->direction = LevelDown;
		    }
		}
	    }
	  /* check consistent */
	  if ( zaxisptr->direction == CDI_UNDEFID )
	    {
	      Warning(func, "direction undefined for zaxisID %d", zaxisID);
	    }
	}
    }
}


void zaxisDefVct(int zaxisID, int size, const double *vct)
{
  static char func[] = "zaxisDefVct";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  if ( zaxisptr->vct == 0 )
    {
      zaxisptr->vctsize = size;
      zaxisptr->vct = (double *) malloc(size*sizeof(double));
      memcpy(zaxisptr->vct, vct, size*sizeof(double));
    }
  else
    if ( zaxisptr->vctsize != size )
      Warning(func, "VCT was already defined");
}


int zaxisInqVctSize(int zaxisID)
{
  static char func[] = "zaxisInqVctSize";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  return (zaxisptr->vctsize);
}


const double *zaxisInqVctPtr(int zaxisID)
{
  static char func[] = "zaxisInqVctPtr";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  return (zaxisptr->vct);
}


void zaxisDefLbounds(int zaxisID, const double *lbounds)
{
  static char func[] = "zaxisDefLbounds";
  size_t size;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  size = zaxisptr->size;
  
  if ( CDI_Debug )
    if ( zaxisptr->lbounds != NULL )
      Warning(func, "Lower bounds already defined for zaxisID = %d", zaxisID);

  if ( zaxisptr->lbounds == NULL )
    zaxisptr->lbounds = (double *) malloc(size*sizeof(double));

  memcpy(zaxisptr->lbounds, lbounds, size*sizeof(double));
}


void zaxisDefUbounds(int zaxisID, const double *ubounds)
{
  static char func[] = "zaxisDefUbounds";
  size_t size;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  size = zaxisptr->size;

  if ( CDI_Debug )
    if ( zaxisptr->ubounds != NULL )
      Warning(func, "Upper bounds already defined for zaxisID = %d", zaxisID);

  if ( zaxisptr->ubounds == NULL )
    zaxisptr->ubounds = (double *) malloc(size*sizeof(double));

  memcpy(zaxisptr->ubounds, ubounds, size*sizeof(double));
}


void zaxisDefWeights(int zaxisID, const double *weights)
{
  static char func[] = "zaxisDefWeights";
  size_t size;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  size = zaxisptr->size;

  if ( CDI_Debug )
    if ( zaxisptr->weights != NULL )
      Warning(func, "Weights already defined for zaxisID = %d", zaxisID);

  if ( zaxisptr->weights == NULL )
    zaxisptr->weights = (double *) malloc(size*sizeof(double));

  memcpy(zaxisptr->weights, weights, size*sizeof(double));
}


void zaxisChangeType(int zaxisID, int zaxistype)
{
  static char func[] = "zaxisChangeType";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  Message(func, "Changed zaxis type from %s to %s\n",
	  zaxisNamePtr(zaxisptr->type),
	  zaxisNamePtr(zaxistype));
  
  zaxisptr->type = zaxistype;
}


void zaxisResize(int zaxisID, int size)
{
  static char func[] = "zaxisResize";
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxis_check_ptr(func, zaxisptr);

  zaxisptr->size = size;

  if ( zaxisptr->vals )
    zaxisptr->vals = (double *) realloc(zaxisptr->vals, size*sizeof(double));
}


int zaxisDuplicate(int zaxisID)
{
  static char func[] = "zaxisDuplicate";
  int zaxisIDnew;
  int zaxistype, zaxissize;
  int size;
  ZAXIS *zaxisptr, *zaxisptrnew;

  zaxisptr = zaxis_to_pointer(zaxisID);

  zaxistype = zaxisInqType(zaxisID);
  zaxissize = zaxisInqSize(zaxisID);

  zaxisIDnew = zaxisCreate(zaxistype, zaxissize);
  zaxisptrnew = zaxis_to_pointer(zaxisIDnew);

  zaxis_copy(zaxisptrnew, zaxisptr);

  strcpy(zaxisptrnew->name, zaxisptr->name);
  strcpy(zaxisptrnew->longname, zaxisptr->longname);
  strcpy(zaxisptrnew->units, zaxisptr->units);

  if ( zaxisptr->vals != NULL )
    {
      size = zaxissize;

      zaxisptrnew->vals = (double *) malloc(size*sizeof(double));
      memcpy(zaxisptrnew->vals, zaxisptr->vals, size*sizeof(double));
    }

  if ( zaxisptr->lbounds )
    {
      size = zaxissize;

      zaxisptrnew->lbounds = (double *) malloc(size*sizeof(double));
      memcpy(zaxisptrnew->lbounds, zaxisptr->lbounds, size*sizeof(double));
    }

  if ( zaxisptr->ubounds )
    {
      size = zaxissize;

      zaxisptrnew->ubounds = (double *) malloc(size*sizeof(double));
      memcpy(zaxisptrnew->ubounds, zaxisptr->ubounds, size*sizeof(double));
    }

  if ( zaxisptr->vct != NULL )
    {
      size = zaxisptr->vctsize;

      if ( size )
	{
	  zaxisptrnew->vctsize = size;
	  zaxisptrnew->vct = (double *) malloc(size*sizeof(double));
	  memcpy(zaxisptrnew->vct, zaxisptr->vct, size*sizeof(double));
	}
    }

  return (zaxisIDnew);
}


void zaxisPrint(int zaxisID)
{
  FILE *fp = stdout;
  int type;
  int nlevels, levelID;
  int nbyte0, nbyte;
  double level;
  ZAXIS *zaxisptr;

  zaxisptr = zaxis_to_pointer(zaxisID);

  type    = zaxisInqType(zaxisID);
  nlevels = zaxisInqSize(zaxisID);

  nbyte0 = 0;
  fprintf(fp, "#\n");
  fprintf(fp, "# zaxisID %d\n", zaxisID);
  fprintf(fp, "#\n");
  fprintf(fp, "zaxistype = %s\n", zaxisNamePtr(type));
  fprintf(fp, "size      = %d\n", nlevels);
  if ( zaxisptr->name[0]     ) fprintf(fp, "name      = %s\n", zaxisptr->name);
  if ( zaxisptr->longname[0] ) fprintf(fp, "longname  = %s\n", zaxisptr->longname);
  if ( zaxisptr->units[0]    ) fprintf(fp, "units     = %s\n", zaxisptr->units);

  nbyte0 = fprintf(fp, "levels    = ");
  nbyte = nbyte0;
  for ( levelID = 0; levelID < nlevels; levelID++ )
    {
      if ( nbyte > 80 )
	{
	  fprintf(stdout, "\n");
	  fprintf(stdout, "%*s", nbyte0, "");
	  nbyte = nbyte0;
	}
      level = zaxisInqLevel(zaxisID, levelID);
      nbyte += fprintf(stdout, "%.9g ", level);
    }
  fprintf(stdout, "\n");

  if ( zaxisptr->lbounds && zaxisptr->ubounds )
    {
      double level1, level2;
      nbyte = nbyte0;
      nbyte0 = fprintf(stdout, "%32s = ", "bounds");
      for ( levelID = 0; levelID < nlevels; levelID++ )
	{
	  if ( nbyte > 80 )
	    {
	      fprintf(stdout, "\n");
	      fprintf(stdout, "%*s", nbyte0, "");
	      nbyte = nbyte0;
	    }
	  level1 = zaxisInqLbound(zaxisID, levelID);
	  level2 = zaxisInqUbound(zaxisID, levelID);
	  nbyte += fprintf(stdout, "%.9g-%.9g ", level1, level2);
	}
      fprintf(stdout, "\n");
    }

  if ( type == ZAXIS_HYBRID || type == ZAXIS_HYBRID_HALF )
    {
      int i;
      int vctsize;
      const double *vct;

      vctsize = zaxisInqVctSize(zaxisID);
      vct     = zaxisInqVctPtr(zaxisID);
      fprintf(stdout, "vctsize   = %d\n", vctsize);
      if ( vctsize )
	{
	  nbyte0 = fprintf(stdout, "vct       = ");
	  nbyte = nbyte0;
	  for ( i = 0; i < vctsize; i++ )
	    {
	      if ( nbyte > 70 || i == vctsize/2 )
		{
		  fprintf(stdout, "\n%*s", nbyte0, "");
		  nbyte = nbyte0;
		}
	      nbyte += fprintf(stdout, "%.9g ", vct[i]);
	    }
	  fprintf(stdout, "\n");
	  /*
	  nbyte0 = fprintf(stdout, "vct_b     = ");
	  nbyte  = nbyte0;
	  for ( i = 0; i < vctsize/2; i++ )
	    {
	      if ( nbyte > 70 )
		{
		  fprintf(stdout, "\n%*s", nbyte0, "");
		  nbyte = nbyte0;
		}
	      nbyte += fprintf(stdout, "%.9g ", vct[vctsize/2+i]);
	    }
	  fprintf(stdout, "\n");
	  */
	}
    }
}
#if defined (HAVE_CONFIG_H)
#endif




extern int CDF_Fatal;
extern int CDF_Verbose;
extern int CDF_Debug;

#if  defined  (HAVE_LIBNETCDF)
/*
#if ! defined (MIN_BUF_SIZE)
#  define  MIN_BUF_SIZE  131072L
#endif

static size_t ChunkSizeMin = MIN_BUF_SIZE;
*/

void cdf_create(const char *path, int cmode, int *ncidp)
{
  static char func[] = "cdf_create";
  int status;
  int oldfill;
  size_t initialsz = 0, chunksizehint = 0;
  /*
#if defined (HAVE_STRUCT_STAT_ST_BLKSIZE)
  struct stat filestat;
  char basename[1024];
  char *pend;

  pend = strrchr(path, '/');
  if ( pend == 0 )
    strcpy(basename, "./");
  else
    {
      memcpy(basename, path, pend-path);
      basename[pend-path] = 0;
    }

  if ( stat(basename, &filestat) != 0 )
    SysError(func, basename);

  chunksizehint = (size_t) filestat.st_blksize * 4;
#endif

  if ( chunksizehint < ChunkSizeMin ) chunksizehint = ChunkSizeMin;
  */
#if defined(__SX__) || defined(ES)
  chunksizehint = 16777216; /* 16 MB */
#endif

  status = nc__create(path, cmode, initialsz, &chunksizehint, ncidp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d  mode = %d  file = %s", *ncidp, cmode, path);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "chunksizehint %d", chunksizehint);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));

  status = nc_set_fill(*ncidp, NC_NOFILL, &oldfill);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}


int cdf_open(const char *path, int omode, int *ncidp)
{
  static char func[] = "cdf_open";
  int status = 0;
  int dapfile = FALSE;
  struct stat filestat;
  size_t chunksizehint = 0;

#if  defined  (HAVE_LIBNC_DAP)
  if ( memcmp(path, "http:", 5) == 0 ) dapfile = TRUE;
#endif

  if ( dapfile )
    {
      status = nc_open(path, omode, ncidp);
    }
  else
    {
      if ( stat(path, &filestat) != 0 ) SysError(func, path);

#if defined (HAVE_STRUCT_STAT_ST_BLKSIZE)
      chunksizehint = (size_t) filestat.st_blksize * 4;
#endif
      /*
      if ( chunksizehint < ChunkSizeMin ) chunksizehint = ChunkSizeMin;
      */
      status = nc__open(path, omode, &chunksizehint, ncidp);

      if ( CDF_Debug )
	Message(func, "chunksizehint %d", chunksizehint);
    }

  if ( CDF_Debug )
    Message(func, "ncid = %d  mode = %d  file = %s", *ncidp, omode, path);

  if ( CDF_Debug && status != NC_NOERR )
    Message(func, "%s", nc_strerror(status));

  return (status);
}


void cdf_close(int ncid)
{
  static char func[] = "cdf_close";
  int status;

  status = nc_close(ncid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}


void cdf_redef(int ncid)
{
  static char func[] = "cdf_redef";
  int status;

  status = nc_redef(ncid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}


void cdf_enddef(int ncid)
{
  static char func[] = "cdf_enddef";
  int status;

  status = nc_enddef(ncid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}


void cdf_sync(int ncid)
{
  static char func[] = "cdf_sync";
  int status;

  status = nc_sync(ncid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}


void cdf_inq(int ncid, int *ndimsp, int *nvarsp, int *ngattsp, int *unlimdimidp)
{
  static char func[] = "cdf_inq";
  int status;

  status = nc_inq(ncid, ndimsp, nvarsp, ngattsp, unlimdimidp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d ndims = %d nvars = %d ngatts = %d unlimid = %d",
	    ncid, *ndimsp, *nvarsp, *ngattsp, *unlimdimidp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}


void cdf_def_dim(int ncid, const char *name, size_t len, int *dimidp)
{
  static char func[] = "cdf_def_dim";
  int status;

  status = nc_def_dim(ncid, name, len, dimidp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d  name = %s  len = %d", ncid, name, len);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_dimid(int ncid, const char *name, int *dimidp)
{
  static char func[] = "cdf_inq_dimid";
  int status;

  status = nc_inq_dimid(ncid, name, dimidp);

  if (CDF_Debug || status != NC_NOERR)
    Message(func, "ncid = %d  name = %s  dimid= %d", ncid, name, *dimidp);

  if (status != NC_NOERR)
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_dim(int ncid, int dimid, char *name, size_t * lengthp)
{
  static char func[] = "cdf_inq_dim";
  int status;

  status = nc_inq_dim(ncid, dimid, name, lengthp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d  dimid = %d  length = %d name = %s",
	    ncid, dimid, *lengthp, name);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_dimname(int ncid, int dimid, char *name)
{
  static char func[] = "cdf_inq_dimname";
  int status;

  status = nc_inq_dimname(ncid, dimid, name);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d  dimid = %d  name = %s", ncid, dimid, name);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_dimlen(int ncid, int dimid, size_t * lengthp)
{
  static char func[] = "cdf_inq_dimlen";
  int status;

  status = nc_inq_dimlen(ncid, dimid, lengthp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d dimid = %d length = %d", ncid, dimid, *lengthp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_def_var(int ncid, const char *name, nc_type xtype, int ndims,
	    const int dimids[], int *varidp)
{
  static char func[] = "cdf_def_var";
  int status;

  status = nc_def_var(ncid, name, xtype, ndims, dimids, varidp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d  name = %s  xtype = %d  ndims = %d  varid = %d",
	    ncid, name, xtype, ndims, *varidp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void cdf_inq_varid(int ncid, const char *name, int *varidp)
{
  static char func[] = "cdf_inq_varid";
  int status;

  status = nc_inq_varid(ncid, name, varidp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d  name = %s  varid = %d ", ncid, name, *varidp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}
void
cdf_inq_nvars(int ncid, int *nvarsp)
{
  static char func[] = "cdf_inq_nvars";
  int status;

  status = nc_inq_nvars(ncid, nvarsp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d  nvars = %d", ncid, *nvarsp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_var(int ncid, int varid, char *name, nc_type *xtypep, int *ndimsp,
	    int dimids[], int *nattsp)
{
  static char func[] = "cdf_inq_var";
  int status;

  status = nc_inq_var(ncid, varid, name, xtypep, ndimsp, dimids, nattsp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d ndims = %d xtype = %d natts = %d name = %s",
	    ncid, varid, *ndimsp, *xtypep, *nattsp, name);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_varname(int ncid, int varid, char *name)
{
  static char func[] = "cdf_inq_varname";
  int status;

  status = nc_inq_varname(ncid, varid, name);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d name = %s", ncid, varid, name);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_vartype(int ncid, int varid, nc_type *xtypep)
{
  static char func[] = "cdf_inq_vartype";
  int status;

  status = nc_inq_vartype(ncid, varid, xtypep);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d xtype = %s", ncid, varid, *xtypep);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_varndims(int ncid, int varid, int *ndimsp)
{
  static char func[] = "cdf_inq_varndims";
  int status;

  status = nc_inq_varndims(ncid, varid, ndimsp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_vardimid(int ncid, int varid, int dimids[])
{
  static char func[] = "cdf_inq_vardimid";
  int status;

  status = nc_inq_vardimid(ncid, varid, dimids);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_varnatts(int ncid, int varid, int *nattsp)
{
  static char func[] = "cdf_inq_varnatts";
  int status;

  status = nc_inq_varnatts(ncid, varid, nattsp);

  if (CDF_Debug || status != NC_NOERR)
    Message(func, "ncid = %d varid = %d nattsp = %d", ncid, varid, *nattsp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_put_var_text(int ncid, int varid, const char *tp)
{
  static char func[] = "cdf_put_var_text";
  int status;

  status = nc_put_var_text(ncid, varid, tp);

  if (CDF_Debug || status != NC_NOERR)
    fprintf (stderr, "cdf_put_var_text : %d %d %s \n", ncid, varid, tp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}


void
cdf_put_var_short(int ncid, int varid, const short *sp)
{
  static char func[] = "cdf_put_var_short";
  int status;

  status = nc_put_var_short(ncid, varid, sp);

  if (CDF_Debug || status != NC_NOERR)
    fprintf (stderr, "cdf_put_var_short : %d %d %hd \n", ncid, varid, *sp);

  if (status != NC_NOERR)
    Error(func, "%s", nc_strerror(status));
}

void
cdf_put_var_int(int ncid, int varid, const int *ip)
{
  static char func[] = "cdf_put_var_int";
  int status;

  status = nc_put_var_int(ncid, varid, ip);

  if (CDF_Debug || status != NC_NOERR)
    fprintf (stderr, "cdf_put_var_int : %d %d %d \n", ncid, varid, *ip);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_put_var_long(int ncid, int varid, const long *lp)
{
  static char func[] = "cdf_put_var_long";
  int status;

  status = nc_put_var_long(ncid, varid, lp);

  if (CDF_Debug || status != NC_NOERR)
    fprintf (stderr, "cdf_put_var_long : %d %d %ld \n", ncid, varid, *lp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_put_var_float(int ncid, int varid, const float *fp)
{
  static char func[] = "cdf_put_var_float";
  int status;

  status = nc_put_var_float(ncid, varid, fp);

  if (CDF_Debug || status != NC_NOERR)
    fprintf (stderr, "cdf_put_var_float : %d %d %f \n", ncid, varid, *fp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void 
cdf_put_vara_double (int ncid, int varid, const size_t start[],
		     const size_t count[], const double *dp)
{
  static char func[] = "cdf_put_vara_double";
  int status;

  status = nc_put_vara_double(ncid, varid, start, count, dp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d val0 = %f", ncid, varid, *dp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void 
cdf_get_vara_int (int ncid, int varid, const size_t start[],
		  const size_t count[], int *dp)
{
  static char func[] = "cdf_get_vara_int";
  int status;

  status = nc_get_vara_int(ncid, varid, start, count, dp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void 
cdf_get_vara_double (int ncid, int varid, const size_t start[],
		     const size_t count[], double *dp)
{
  static char func[] = "cdf_get_vara_double";
  int status;

  status = nc_get_vara_double(ncid, varid, start, count, dp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_put_var_double (int ncid, int varid, const double *dp)
{
  static char func[] = "cdf_put_var_double";
  int status;

  status = nc_put_var_double(ncid, varid, dp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d val0 = %f", ncid, varid, *dp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void 
cdf_get_var1_double(int ncid, int varid, const size_t index[], double *dp)
{
  static char func[] = "cdf_get_var1_double";
  int status;

  status = nc_get_var1_double(ncid, varid, index, dp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_put_var1_double(int ncid, int varid, const size_t index[], const double *dp)
{
  static char func[] = "cdf_put_var1_double";
  int status;

  status = nc_put_var1_double(ncid, varid, index, dp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d val = %f", ncid, varid, *dp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_get_var_text(int ncid, int varid, char *tp)
{
  static char func[] = "cdf_get_var_text";
  int status;

  status = nc_get_var_text(ncid, varid, tp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if (status != NC_NOERR)
    Error(func, "%s", nc_strerror(status));
}

void
cdf_get_var_short(int ncid, int varid, short *sp)
{
  static char func[] = "cdf_get_var_short";
  int status;

  status = nc_get_var_short(ncid, varid, sp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_get_var_int(int ncid, int varid, int *ip)
{
  static char func[] = "cdf_get_var_int";
  int status;

  status = nc_get_var_int(ncid, varid, ip);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_get_var_long(int ncid, int varid, long *lp)
{
  static char func[] = "cdf_get_var_long";
  int status;

  status = nc_get_var_long(ncid, varid, lp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_get_var_float(int ncid, int varid, float *fp)
{
  static char func[] = "cdf_get_var_float";
  int status;

  status = nc_get_var_float(ncid, varid, fp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_get_var_double(int ncid, int varid, double *dp)
{
  static char func[] = "cdf_get_var_double";
  int status;

  status = nc_get_var_double(ncid, varid, dp);

  if (CDF_Debug || status != NC_NOERR)
    Message(func, "ncid = %d varid = %d val[0] = %f", ncid, varid, *dp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_copy_att(int ncid_in, int varid_in, const char *name, int ncid_out,
	     int varid_out)
{
  static char func[] = "cdf_copy_att";
  int status;

  status = nc_copy_att(ncid_in, varid_in, name, ncid_out, varid_out);

  if (CDF_Debug || status != NC_NOERR)
    fprintf (stderr, "cdf_copy_att : %d %d %s %d %d\n", ncid_in, varid_out,
	     name, ncid_out, varid_out);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_put_att_text(int ncid, int varid, const char *name, size_t len,
		 const char *tp)
{
  static char func[] = "cdf_put_att_text";
  int status;

  status = nc_put_att_text(ncid, varid, name, len, tp);

  if (CDF_Debug || status != NC_NOERR)
    Message(func, "ncid = %d varid = %d att = %s text = %s",
	    ncid, varid, name, tp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_put_att_int(int ncid, int varid, const char *name, nc_type xtype,
		size_t len, const int *ip)
{
  static char func[] = "cdf_put_att_int";
  int status;

  status = nc_put_att_int(ncid, varid, name, xtype, len, ip);

  if (CDF_Debug || status != NC_NOERR)
    Message(func, "ncid = %d varid = %d att = %s val = %d",
	    ncid, varid, name, *ip);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_put_att_double(int ncid, int varid, const char *name, nc_type xtype,
		   size_t len, const double *dp)
{
  static char func[] = "cdf_put_att_double";
  int status;

  status = nc_put_att_double(ncid, varid, name, xtype, len, dp);

  if (CDF_Debug || status != NC_NOERR)
    fprintf (stderr, "cdf_put_att_double : %d %d %f \n", ncid, varid, *dp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_get_att_text(int ncid, int varid, char *name, char *tp)
{
  static char func[] = "cdf_get_att_text";
  int status;

  status = nc_get_att_text(ncid, varid, name, tp);

  if (CDF_Debug || status != NC_NOERR)
    Message(func, "ncid = %d varid = %d name = %s", ncid, varid, name);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_get_att_int(int ncid, int varid, char *name, int *ip)
{
  static char func[] = "cdf_get_att_int";
  int status;

  status = nc_get_att_int(ncid, varid, name, ip);

  if (CDF_Debug || status != NC_NOERR)
    Message(func, "ncid = %d varid = %d att = %s val = %d",
	    ncid, varid, name, *ip);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void cdf_get_att_double(int ncid, int varid, char *name, double *dp)
{
  static char func[] = "cdf_get_att_double";
  int status;

  status = nc_get_att_double(ncid, varid, name, dp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d att = %s val = %.9g",
	    ncid, varid, name, *dp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void cdf_inq_att(int ncid, int varid, const char *name, nc_type *xtypep,
	    size_t *lenp)
{
  static char func[] = "cdf_inq_att";
  int status;

  status = nc_inq_att(ncid, varid, name, xtypep, lenp);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_atttype(int ncid, int varid, const char *name, nc_type * xtypep)
{
  static char func[] = "cdf_inq_atttype";
  int status;

  status = nc_inq_atttype(ncid, varid, name, xtypep);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_attlen(int ncid, int varid, const char *name, size_t * lenp)
{
  static char func[] = "cdf_inq_attlen";
  int status;

  status = nc_inq_attlen(ncid, varid, name, lenp);

  if (CDF_Debug || status != NC_NOERR)
    Message(func, "ncid = %d varid = %d name = %s len = %d",
	    ncid, varid, name, *lenp);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_attname(int ncid, int varid, int attnum, char *name)
{
  static char func[] = "cdf_inq_attname";
  int status;

  status = nc_inq_attname(ncid, varid, attnum, name);

  if (CDF_Debug || status != NC_NOERR)
    Message(func, "ncid = %d varid = %d attnum = %d name = %s",
	    ncid, varid, attnum, name);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

void
cdf_inq_attid(int ncid, int varid, const char *name, int *attnump)
{
  static char func[] = "cdf_inq_attid";
  int status;

  status = nc_inq_attid(ncid, varid, name, attnump);

  if ( CDF_Debug || status != NC_NOERR )
    Message(func, "ncid = %d varid = %d", ncid, varid);

  if ( status != NC_NOERR )
    Error(func, "%s", nc_strerror(status));
}

#endif
#if defined (HAVE_CONFIG_H)
#endif


char *cdiStringError(int cdiErrno)
{
  static char UnknownError[] = "Unknown Error";
  static char _EUFTYPE[]     = "Unsupported file type";
  static char _ELIBNAVAIL[]  = "Unsupported file type (library support not compiled in)";
  static char _EUFSTRUCT[]   = "Unsupported file structure";
  static char _EUNC4[]       = "Unsupported netCDF4 structure";
  static char _ELIMIT[]      = "Internal limits exceeded";

  switch (cdiErrno) {
  case CDI_ESYSTEM:
    {
      char *cp = (char *) strerror(errno);
      if ( cp == NULL ) break;
      return cp;
    }
  case CDI_EUFTYPE:    return _EUFTYPE;
  case CDI_ELIBNAVAIL: return _ELIBNAVAIL;
  case CDI_EUFSTRUCT:  return _EUFSTRUCT;
  case CDI_EUNC4:      return _EUNC4;
  case CDI_ELIMIT:     return _ELIMIT;
  }

  return UnknownError;
}

void cdiDecodeParam(int param, int *pnum, int *pcat, int *pdis)
{
  unsigned int *uparam = (unsigned int *) &param;
  unsigned int upnum;

  *pdis = 0xff   & *uparam;
  *pcat = 0xff   & *uparam >> 8;
  upnum = 0xffff & *uparam >> 16;
  if ( upnum > 0x7fff ) upnum = 0x8000 - upnum;
  *pnum = upnum;
}


int cdiEncodeParam(int pnum, int pcat, int pdis)
{
  unsigned int uparam, upnum;

  if ( pcat < 0 || pcat > 255 ) pcat = 255;
  if ( pdis < 0 || pdis > 255 ) pdis = 255;

  upnum = pnum;
  if ( pnum < 0 ) upnum = 0x8000 - pnum;

  uparam = upnum << 16 | pcat << 8 | pdis;

  return ((int)uparam);
}


void cdiDecodeDate(int date, int *year, int *month, int *day)
{
  int idate;

  *year  =  date / 10000;
  idate  = date - *year*10000;
  if ( idate < 0 ) idate = -idate;
  *month = idate / 100;
  *day   = idate - *month*100;
}


int cdiEncodeDate(int year, int month, int day)
{
  int date;
  int iyear;

  iyear = year;
  if ( iyear < 0 ) iyear = -iyear;
  date = iyear*10000 + month*100 + day;
  if ( year < 0 ) date = -date;

  return (date);
}


void cdiDecodeTime(int time, int *hour, int *minute, int *second)
{
  int itime;

  *hour   = time / 10000;
  itime   = time - *hour*10000;
  *minute = itime / 100;
  *second = itime - *minute*100;
}


int cdiEncodeTime(int hour, int minute, int second)
{
  int time;

  time = hour*10000 + minute*100 + second;

  return (time);
}


void cdiParamToString(int param, char *paramstr, int maxlen)
{
  static char func[] = "cdiParamToString";
  int dis, cat, num;
  int len;

  cdiDecodeParam(param, &num, &cat, &dis);

  if ( dis == 255 && (cat == 255 || cat == 0 ) )
    len = sprintf(paramstr, "%d", num);
  else  if ( dis == 255 )
    len = sprintf(paramstr, "%d.%d", num, cat);
  else
    len = sprintf(paramstr, "%d.%d.%d", num, cat, dis);

  if ( len > ( maxlen-1) )
    fprintf(stderr, "Internal problem (%s): size of input string is too small!\n", func);
}
#if defined (HAVE_CONFIG_H)
#endif





int cdiDefaultCalendar = CALENDAR_PROLEPTIC;

int cdiDefaultInstID   = CDI_UNDEFID;
int cdiDefaultModelID  = CDI_UNDEFID;
int cdiDefaultTableID  = CDI_UNDEFID;
int cdiNcMissingValue  = CDI_UNDEFID;
int cdiSplitLtype105   = CDI_UNDEFID;

int cdiIgnoreAttCoordinates = FALSE;
int cdiInventoryMode        = 1;

char *cdiPartabPath   = NULL;
int   cdiPartabIntern = 1;

double cdiDefaultMissval = -9.E33;


char *Filetypes[] = {
  "UNKNOWN",
  "GRIB",
  "GRIB2",
  "netCDF",
  "netCDF2",
  "netCDF4",
  "SERVICE",
  "EXTRA",
  "IEG",
  "HDF5",
};

#undef  UNDEFID
#define UNDEFID  CDI_UNDEFID


int CDI_Debug   = 0;    /* If set to 1, debugging           */


int cdiDefaultLeveltype = -1;
static int cdiDataUnreduced = 0;
static int cdiSortName = 0;
static int cdiHaveMissval = 0;


long cdiGetenvInt(char *envName)
{
  static char func[] = "cdiGetenv";
  char *envString;
  long envValue = -1;
  long fact = 1;

  envString = getenv(envName);

  if ( envString )
    {
      int loop, len;

      len = (int) strlen(envString);
      for ( loop = 0; loop < len; loop++ )
	{
	  if ( ! isdigit((int) envString[loop]) )
	    {
	      switch ( tolower((int) envString[loop]) )
		{
		case 'k':  fact = 1024;        break;
		case 'm':  fact = 1048576;     break;
		case 'g':  fact = 1073741824;  break;
		default:
		  fact = 0;
		  Message(func, "Invalid number string in %s: %s", envName, envString);
		  Warning(func, "%s must comprise only digits [0-9].",envName);
		}
	      break;
	    }
	}

      if ( fact ) envValue = fact*atol(envString);

      if ( CDI_Debug ) Message(func, "set %s to %ld", envName, envValue);
    }

  return (envValue);
}


void cdiInitialize(void)
{
  static char func[] = "cdiInitialize";
  static int Init_CDI = FALSE;
  char *envString;
  long value;

  if ( ! Init_CDI )
    {
      Init_CDI = TRUE;

      value = cdiGetenvInt("CD_REGULARGRID");
      if ( value >= 0 ) cdiDataUnreduced = (int) value;

      value = cdiGetenvInt("CDI_REGULARGRID");
      if ( value >= 0 ) cdiDataUnreduced = (int) value;

      value = cdiGetenvInt("CDI_SORTNAME");
      if ( value >= 0 ) cdiSortName = (int) value;

      value = cdiGetenvInt("CDI_HAVE_MISSVAL");
      if ( value >= 0 ) cdiHaveMissval = (int) value;

      value = cdiGetenvInt("CD_LEVELTYPE");
      if ( value >= 0 ) cdiDefaultLeveltype = (int) value;

      value = cdiGetenvInt("CDI_LEVELTYPE");
      if ( value >= 0 ) cdiDefaultLeveltype = (int) value;

      envString = getenv("CD_MISSVAL");
      if ( envString ) cdiDefaultMissval = atof(envString);

      envString = getenv("CDI_MISSVAL");
      if ( envString ) cdiDefaultMissval = atof(envString);

      envString = getenv("NC_MISSING_VALUE");
      if ( envString ) cdiNcMissingValue = atoi(envString);

      envString = getenv("SPLIT_LTYPE_105");
      if ( envString ) cdiSplitLtype105 = atoi(envString);

      envString = getenv("IGNORE_ATT_COORDINATES");
      if ( envString ) cdiIgnoreAttCoordinates = atoi(envString);

      envString = getenv("GRIB_INVENTORY_MODE");
      if ( envString )
	{
	  if ( strncmp(envString, "time", 4) == 0 )
	    {
	      cdiInventoryMode = 2;
	      if ( CDI_Debug )
		Message(func, "Inventory mode was set to timestep!");
	    }
	}

      envString = getenv("CDI_CALENDAR");
      if ( envString )
	{
	  if      ( strncmp(envString, "standard", 8) == 0 )
	    cdiDefaultCalendar = CALENDAR_STANDARD;
	  else if ( strncmp(envString, "proleptic", 9) == 0 )
	    cdiDefaultCalendar = CALENDAR_PROLEPTIC;
	  else if ( strncmp(envString, "360days", 7) == 0 )
	    cdiDefaultCalendar = CALENDAR_360DAYS;
	  else if ( strncmp(envString, "365days", 7) == 0 )
	    cdiDefaultCalendar = CALENDAR_365DAYS;
	  else if ( strncmp(envString, "366days", 7) == 0 )
	    cdiDefaultCalendar = CALENDAR_366DAYS;
	  else if ( strncmp(envString, "none", 4) == 0 )
	    cdiDefaultCalendar = CALENDAR_NONE;

	  if ( CDI_Debug )
	    Message(func, "Default calendar set to %s!", envString);
	}

      envString = getenv("PARTAB_INTERN");
      if ( envString ) cdiPartabIntern = atoi(envString);

      envString = getenv("PARTAB_PATH");
      if ( envString ) cdiPartabPath = strdup(envString);
    }
}


char *strfiletype(int filetype)
{
  char *name;
  int size = (int) (sizeof(Filetypes)/sizeof(char *));

  if ( filetype > 0 && filetype < size )
    name = Filetypes[filetype];
  else
    name = Filetypes[0];  

  return (name);
}


static int  STREAM_Debug = 0;   /* If set to 1, debugging */

static int _stream_min = MIN_STREAMS;
static int _stream_max = MAX_STREAMS;

static void stream_initialize(void);

static int _stream_init = FALSE;

#if  defined  (HAVE_LIBPTHREAD)

static pthread_once_t  _stream_init_thread = PTHREAD_ONCE_INIT;
static pthread_mutex_t _stream_mutex;

#  define STREAM_LOCK()         pthread_mutex_lock(&_stream_mutex)
#  define STREAM_UNLOCK()       pthread_mutex_unlock(&_stream_mutex)
#  define STREAM_INIT()        \
   if ( _stream_init == FALSE ) pthread_once(&_stream_init_thread, stream_initialize)

#else

#  define STREAM_LOCK()
#  define STREAM_UNLOCK()
#  define STREAM_INIT()        \
   if ( _stream_init == FALSE ) stream_initialize()

#endif


typedef struct _streamPtrToIdx {
  int       idx;
  int       next;
  stream_t *ptr;
} streamPtrToIdx;


static streamPtrToIdx *_streamList  = NULL;
static int             _streamAvail = -1;

static
void stream_list_new(void)
{
  static char func[] = "stream_list_new";

  assert(_streamList == NULL);

  _streamList = (streamPtrToIdx *) malloc(_stream_min*sizeof(streamPtrToIdx));
}

static
void stream_list_delete(void)
{
  static char func[] = "stream_list_delete";

  if ( _streamList ) free(_streamList);
}

static
void stream_init_pointer(void)
{
  int i;
  
  for ( i = 0; i < _stream_min; ++i )
    {
      _streamList[i].idx  = i;
      _streamList[i].next = i + 1;
      _streamList[i].ptr  = NULL;
    }

  _streamList[_stream_min-1].next = -1;

  _streamAvail = 0;
}

static
void stream_list_extend(void)
{
  static char func[] = "stream_list_extend";
  int nstreams;
  int i;

  assert(_streamList != NULL);

  nstreams = _stream_min + MIN_STREAMS;

  if ( nstreams <= _stream_max)
    {
      _streamList = (streamPtrToIdx *) realloc(_streamList, nstreams*sizeof(streamPtrToIdx));
  
      for ( i = _stream_min; i < nstreams; ++i )
	{
	  _streamList[i].idx  = i;
	  _streamList[i].next = i + 1;
	  _streamList[i].ptr  = NULL;
	}

      _streamAvail = _stream_min;
      _streamList[_stream_min-1].next = _stream_min;
      _stream_min = nstreams;
      _streamList[_stream_min-1].next = -1;
    }
  else
    Warning(func, "Too many open streams (limit is %d)!", _stream_max);
}


stream_t *stream_to_pointer(int idx)
{
  static char func[] = "stream_to_pointer";
  stream_t *streamptr = NULL;

  STREAM_INIT();

  if ( idx >= 0 && idx < _stream_min )
    {
      STREAM_LOCK();

      streamptr = _streamList[idx].ptr;

      STREAM_UNLOCK();
    }
  else
    Error(func, "stream index %d undefined!", idx);

  return (streamptr);
}

/* Create an index from a pointer (add the pointer to the stream list) */
static
int stream_from_pointer(stream_t *ptr)
{
  static char func[] = "stream_from_pointer";
  int idx = -1;

  if ( ptr )
    {
      STREAM_LOCK();

      if ( _streamAvail < 0 ) stream_list_extend();

      if ( _streamAvail >= 0 )
	{
	  streamPtrToIdx *newptr;

	  newptr       = &_streamList[_streamAvail];
	  _streamAvail = newptr->next;
	  newptr->next = -1;
	  idx	       = newptr->idx;
	  newptr->ptr  = ptr;
      
	  if ( STREAM_Debug )
	    Message(func, "Pointer %p has idx %d from stream list", ptr, idx);
	}

      STREAM_UNLOCK();
    }
  else
    Error(func, "Internal problem (pointer %p undefined)", ptr);

  return (idx);
}

static
void stream_init_entry(stream_t *streamptr)
{
  int i;

  streamptr->self              = stream_from_pointer(streamptr);

  streamptr->accesstype        = UNDEFID;
  streamptr->accessmode        = 0;
  streamptr->filetype          = UNDEFID;
  streamptr->byteorder         = UNDEFID;
  streamptr->fileID            = 0;
  streamptr->dimgroupID        = UNDEFID;
  streamptr->filemode          = 0;
  streamptr->numvals           = 0;
  streamptr->filename          = NULL;
  streamptr->record            = NULL;
  streamptr->varsAllocated     = 0;
  streamptr->nrecs             = 0;
  streamptr->nvars             = 0;
  streamptr->vars              = NULL;
  streamptr->varinit           = 0;
  streamptr->ncmode            = 0;
  streamptr->curTsID           = UNDEFID;
  streamptr->rtsteps           = 0;
  streamptr->ntsteps           = UNDEFID;
  streamptr->numTimestep       = 0;
  streamptr->tsteps            = NULL;
  streamptr->tstepsTableSize   = 0;
  streamptr->tstepsNextID      = 0;
  streamptr->historyID         = UNDEFID;
  streamptr->vlistID           = UNDEFID;
  streamptr->globalatts        = 0;
  streamptr->localatts         = 0;
  streamptr->vct.ilev          = 0;
  streamptr->vct.mlev          = 0;
  streamptr->vct.ilevID        = UNDEFID;
  streamptr->vct.mlevID        = UNDEFID;
  streamptr->unreduced         = cdiDataUnreduced;
  streamptr->sortname          = cdiSortName;
  streamptr->have_missval      = cdiHaveMissval;
  streamptr->ztype             = COMPRESS_NONE;
  streamptr->zlevel            = 0;

  basetimeInit(&streamptr->basetime);

  for ( i = 0; i < MAX_GRIDS_PS; i++ ) streamptr->xdimID[i]   = UNDEFID;
  for ( i = 0; i < MAX_GRIDS_PS; i++ ) streamptr->ydimID[i]   = UNDEFID;
  for ( i = 0; i < MAX_ZAXES_PS; i++ ) streamptr->zaxisID[i]  = UNDEFID;
  for ( i = 0; i < MAX_GRIDS_PS; i++ ) streamptr->ncxvarID[i] = UNDEFID;
  for ( i = 0; i < MAX_GRIDS_PS; i++ ) streamptr->ncyvarID[i] = UNDEFID;
  for ( i = 0; i < MAX_GRIDS_PS; i++ ) streamptr->ncavarID[i] = UNDEFID;

  streamptr->curfile           = 0;
  streamptr->nfiles            = 0;
  streamptr->fnames            = NULL;

  streamptr->gribHandleNums    = 0;
  streamptr->gribHandle        = NULL;
}


stream_t *stream_new_entry(void)
{
  static char func[] = "stream_new_entry";
  stream_t *streamptr;

  cdiInitialize(); /* ***************** make MT version !!! */

  STREAM_INIT();

  streamptr = (stream_t *) malloc(sizeof(stream_t));

  if ( streamptr ) stream_init_entry(streamptr);

  return (streamptr);
}


void stream_delete_entry(stream_t *streamptr)
{
  static char func[] = "stream_delete_entry";
  int idx;

  idx = streamptr->self;

  STREAM_LOCK();

  free(streamptr);

  _streamList[idx].next = _streamAvail;
  _streamList[idx].ptr  = 0;
  _streamAvail          = idx;

  STREAM_UNLOCK();

  if ( STREAM_Debug )
    Message(func, "Removed idx %d from stream list", idx);
}


static
void stream_initialize(void)
{
  char *env;

#if  defined  (HAVE_LIBPTHREAD)
  /* initialize global API mutex lock */
  pthread_mutex_init(&_stream_mutex, NULL);
#endif

  env = getenv("STREAM_DEBUG");
  if ( env ) STREAM_Debug = atoi(env);

  stream_list_new();
  atexit(stream_list_delete);

  STREAM_LOCK();

  stream_init_pointer();

  STREAM_UNLOCK();

  _stream_init = TRUE;
}


void stream_check_ptr(const char *func, stream_t *streamptr)
{
  if ( streamptr == NULL )
    Error(func, "stream undefined!");
}


int streamSize(void)
{
  int streamsize = 0;
  int i;
  
  STREAM_INIT();

  STREAM_LOCK();

  for ( i = 0; i < _stream_min; i++ )
    if ( _streamList[i].ptr ) streamsize++;

  STREAM_UNLOCK();

  return (streamsize);
}


void cdiDefGlobal(const char *string, int val)
{
  static char func[] = "cdiDefGlobal";

  if ( strcmp(string, "REGULARGRID") == 0 )
    {
      cdiDataUnreduced = val;
    }
  else if ( strcmp(string, "SORTNAME") == 0 )
    {
      cdiSortName = val;
    }
  else if ( strcmp(string, "HAVE_MISSVAL") == 0 )
    {
      cdiHaveMissval = val;
    }
  else
    {
      Warning(func, "Unsupported global key: %s", string);
    }
}


void cdiDefMissval(double missval)
{
  cdiInitialize();

  cdiDefaultMissval = missval;
}


double cdiInqMissval(void)
{
  cdiInitialize();

  return (cdiDefaultMissval);
}


void cdiCheckContents(int streamID)
{
  static char func[] = "cdiCheckContents";
  int index, nzaxis, zaxisID;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);
  nzaxis = vlistNzaxis(vlistID);

  for ( index = 0; index < nzaxis; index++ )
    {
      zaxisID = vlistZaxis(vlistID, index);
      if ( zaxisInqType(zaxisID) == ZAXIS_GENERIC )
	cdiCheckZaxis(zaxisID);
    }
    
}


int streamInqFileID(int streamID)
{
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  return (streamptr->fileID);
}


void streamDefineTaxis(int streamID)
{
  static char func[] = "streamDefineTaxis";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( streamptr->tsteps == NULL )
    {
      int varID, nvars;
      int vlistID;
  
      vlistID = streamInqVlist(streamID);

      nvars = vlistNvars(vlistID);
      for ( varID = 0; varID < nvars; varID++ )
	if ( vlistInqVarTime(vlistID, varID) == TIME_VARIABLE ) break;

      if ( varID == nvars )
	{
	  int taxisID;

	  taxisID = vlistInqTaxis(vlistID);
	  if ( taxisID == CDI_UNDEFID )
	    {
	      taxisID = taxisCreate(TAXIS_ABSOLUTE);
	      vlistDefTaxis(vlistID, taxisID);
	    }
	    
	  (void) streamDefTimestep(streamID, 0);
	}
      else
	Error(func, "time axis undefined");
    }
}


void streamDefDimgroupID(int streamID, int dimgroupID)
{
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  streamptr->dimgroupID = dimgroupID;
}


int streamInqDimgroupID(int streamID)
{
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  return (streamptr->dimgroupID);
}


void cdiDefAccesstype(int streamID, int type)
{
  static char func[] = "cdiDefAccesstype";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( streamptr->accesstype == UNDEFID )
    {
      streamptr->accesstype = type;
    }
  else
    {
      if ( streamptr->accesstype != type )
	{
	  if ( streamptr->accesstype == TYPE_REC )
	    Error(func, "Changing access type from REC to VAR not allowed!");
	  else
	    Error(func, "Changing access type from VAR to REC not allowed!");
	}
    }
}


int cdiInqAccesstype(int streamID)
{
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  return (streamptr->accesstype);
}
#if defined (HAVE_CONFIG_H)
#endif



#define  MAX_FNAMES  3

FILE *popen(const char *command, const char *type);
int pclose(FILE *stream);

void cdiPrintDefaults(void)
{
  fprintf (stderr, "default instID     :  %d\n", cdiDefaultInstID); 
  fprintf (stderr, "default modelID    :  %d\n", cdiDefaultModelID); 
  fprintf (stderr, "default tableID    :  %d\n", cdiDefaultTableID); 
  fprintf (stderr, "default missval    :  %g\n", cdiDefaultMissval); 
}


void cdiDebug(int level)
{
  static char func[] = "cdiDebug";

  if ( level == 1 || level &  2 ) CDI_Debug = 1;

  if ( CDI_Debug ) Message(func, "debug level %d", level);

  if ( level == 1 || level &  4 ) memDebug(1);

  if ( level == 1 || level &  8 ) fileDebug(1);

  if ( level == 1 || level & 16 )
    {
#if  defined  (HAVE_LIBGRIB)
      gribSetDebug(1);
#endif
#if  defined  (HAVE_LIBNETCDF)
      cdfDebug(1);
#endif
#if  defined  (HAVE_LIBSERVICE)
      srvDebug(1);
#endif
#if  defined  (HAVE_LIBEXTRA)
      extDebug(1);
#endif
#if  defined  (HAVE_LIBIEG)
      iegDebug(1);
#endif
    }

  if ( CDI_Debug )
    {
      cdiPrintDefaults();
      cdiPrintDatatypes();
    }
}


#undef  IsBigendian
#define IsBigendian()  ( u_byteorder.c[sizeof(long) - 1] )


static int getByteorder(int byteswap)
{
  static union {unsigned long l; unsigned char c[sizeof(long)];} u_byteorder = {1};
  int byteorder = -1;

  if ( IsBigendian() )
    {
      if ( byteswap ) byteorder = CDI_LITTLEENDIAN;
      else            byteorder = CDI_BIGENDIAN;
    }
  else
    {
      if ( byteswap ) byteorder = CDI_BIGENDIAN;
      else            byteorder = CDI_LITTLEENDIAN;
    }

  return (byteorder);
}


static int getFiletype(const char *filename, int *byteorder)
{
  static char func[] = "getFiletype";
  int filetype = CDI_EUFTYPE;
  int fileID;
  int swap = 0;
  int version;
  long recpos;
  char buffer[8];

  fileID = fileOpen(filename, "r");

  if ( fileID == CDI_UNDEFID )
    {
      if ( memcmp(filename, "http:", 5) == 0 )
	return (FILETYPE_NC);
      else
	return (CDI_ESYSTEM);
    }

  if ( fileRead(fileID, buffer, 8) != 8 ) return (CDI_EUFTYPE);

  fileRewind(fileID);

  if ( memcmp(buffer, "GRIB", 4) == 0 )
    {
      version = buffer[7];
      if ( version <= 1 )
	{
	  filetype = FILETYPE_GRB;
	  if ( CDI_Debug ) Message(func, "found GRIB file = %s, version %d", filename, version);
	}
      else if ( version == 2 )
	{
	  filetype = FILETYPE_GRB2;
	  if ( CDI_Debug ) Message(func, "found GRIB2 file = %s", filename);
	}
    }
  else if ( memcmp(buffer, "CDF\001", 4) == 0 )
    {
      filetype = FILETYPE_NC;
      if ( CDI_Debug ) Message(func, "found CDF1 file = %s", filename);
    }
  else if ( memcmp(buffer, "CDF\002", 4) == 0 )
    {
      filetype = FILETYPE_NC2;
      if ( CDI_Debug ) Message(func, "found CDF2 file = %s", filename);
    }
  else if ( memcmp(buffer+1, "HDF", 3) == 0 )
    {
      filetype = FILETYPE_NC4;
      if ( CDI_Debug ) Message(func, "found HDF file = %s", filename);
    }
#if  defined  (HAVE_LIBSERVICE)
  else if ( srvCheckFiletype(fileID, &swap) )
    {
      filetype = FILETYPE_SRV;
      if ( CDI_Debug ) Message(func, "found SRV file = %s", filename);
    }
#endif
#if  defined  (HAVE_LIBEXTRA)
  else if ( extCheckFiletype(fileID, &swap) )
    {
      filetype = FILETYPE_EXT;
      if ( CDI_Debug ) Message(func, "found EXT file = %s", filename);
    }
#endif
#if  defined  (HAVE_LIBIEG)
  else if ( iegCheckFiletype(fileID, &swap) )
    {
      filetype = FILETYPE_IEG;
      if ( CDI_Debug ) Message(func, "found IEG file = %s", filename);
    }
#endif
  else if ( gribCheckSeek(fileID, &recpos, &version) == 0 )
    {
      if ( version <= 1 )
	{
	  filetype = FILETYPE_GRB;
	  if ( CDI_Debug ) Message(func, "found seek GRIB file = %s", filename);
	}
      else if ( version == 2 )
	{
	  filetype = FILETYPE_GRB2;
	  if ( CDI_Debug ) Message(func, "found seek GRIB2 file = %s", filename);
	}
    }

  fileClose(fileID);

  *byteorder = getByteorder(swap);

  return (filetype);
}


int _readline_(FILE *fp, char *line, int len)
{
  int ichar, ipos = 0;

  while ( (ichar = fgetc(fp)) != EOF )
    {
      if ( ichar == '\n' ) break;
      line[ipos++] = ichar;
      if ( ipos >= len )
        {
          fprintf(stderr, "readline Warning: end of line not found (maxlen = %d)!\n", len);
          break;
        }
    }
  line[ipos] = 0;

  if ( feof(fp) && ipos == 0 ) return (0);

  return (1);
}

#define  MAX_LINE  4096

int get_fnames(const char *argument, char *fnames[], int max_fnames)
{
  static char func[] = "get_fnames";
  int num_fnames = 0;
  int len;
  int nfiles = 0;
  int i, j;
  const char *pch;
  char line[MAX_LINE];

  len = (int) strlen(argument);
  for ( i = 0; i < len; ++i )
    if ( argument[i] == ':' ) break;

  if ( i < len )
    {
      pch = &argument[i+1];
      len -= (i+1);
      if ( len && ( memcmp(argument, "filelist:", i) == 0 || 
		    memcmp(argument, "flist:", i) == 0 ) )
	{
	  for ( i = 0; i < len; ++i ) if ( pch[i] == ',' ) nfiles++;

	  if ( nfiles == 0 )
	    {
	      FILE *fp;
	      fp = fopen(pch, "r");
	      if ( fp == NULL ) Error(func, "Open failed on %s", pch);

	      if ( CDI_Debug )
		Message(func, "Reading file names from %s", pch);

	      rewind(fp);

	      nfiles = 0;
	      while ( _readline_(fp, line, MAX_LINE) )
		{
		  if ( line[0] == '#' || line[0] == '\0' ||
		       line[0] == ' ' ) continue;
		  
		  if ( nfiles >= max_fnames )
		    {
		      Warning(func, "Too many input files (limit: %d)", max_fnames);
		      break;
		    }
		  fnames[nfiles] = strdupx(line);
		  nfiles++;
		}
	      
	      fclose(fp);

	      if ( nfiles == 0 ) Error(func, "No input file found in %s", pch);
	    }
	  else
	    {
	      char xline[65536];
	      	      
	      strcpy(xline, pch);
	      for ( i = 0; i < len; i++ ) if ( xline[i] == ',' ) xline[i] = 0;
	      
	      nfiles++;
	      if ( nfiles >= max_fnames )
		{
		  Warning(func, "Too many input files (limit: %d)", max_fnames);
		  nfiles = max_fnames;
		}

	      i = 0;
	      for ( j = 0; j < nfiles; j++ )
		{
		  fnames[j] = strdupx(&xline[i]);
		  i += strlen(&xline[i]) + 1;
		}
	    }
	}
      else if ( len && memcmp(argument, "ls:", i) == 0 )
	{
	  char command[4096];
	  FILE *pfp;
	  
	  strcpy(command, "ls ");
	  strcat(command, pch);

	  pfp = popen(command, "r");
	  if ( pfp == NULL )
	    SysError(func, "popen %s failed", command);
	  
	  nfiles = 0;
	  while ( _readline_(pfp, line, MAX_LINE) )
	    {
	      if ( nfiles >= max_fnames )
		{
		  Warning(func, "Too many input files (limit: %d)", max_fnames);
		  break;
		}
	      fnames[nfiles++] = strdupx(line);
	    }

	  pclose(pfp);
	  /*
	  for ( j = 0; j < nfiles; j++ )
	    fnames[j] = fnames[j];
	  */
	}
    }

  num_fnames = nfiles;
  
  return (num_fnames);
}


/*
@Function  streamInqFiletype
@Title     Get the filetype

@Prototype int streamInqFiletype(int streamID)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}

@Description
The function @func{streamInqFiletype} returns the filetype of a stream.

@Result
@func{streamInqFiletype} returns the type of the file format,
one of the set of predefined CDI file format types.
The valid CDI file format types are @func{FILETYPE_GRB}, @func{FILETYPE_GRB2}, @func{FILETYPE_NC}, @func{FILETYPE_NC2},
@func{FILETYPE_NC4}, @func{FILETYPE_SRV}, @func{FILETYPE_EXT} and @func{FILETYPE_IEG}.

@EndFunction
*/
int streamInqFiletype(int streamID)
{
  static char func[] = "streamInqFiletype";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  return (streamptr->filetype);
}


int getByteswap(int byteorder)
{
  static union {unsigned long l; unsigned char c[sizeof(long)];} u_byteorder = {1};
  int byteswap = 0;

  if ( IsBigendian() )
    {
      if ( byteorder == CDI_LITTLEENDIAN ) byteswap = TRUE;
    }
  else
    {
      if ( byteorder == CDI_BIGENDIAN ) byteswap = TRUE;
    }

  return (byteswap);
}


/*
@Function  streamDefByteorder
@Title     Define the byte order

@Prototype void streamDefByteorder(int streamID, int byteorder)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}
    @Item  byteorder The byte order of a dataset, one of the CDI constants @func{CDI_BIGENDIAN} and
                     @func{CDI_LITTLEENDIAN}.

@Description
The function @func{streamDefByteorder} defines the byte order of a binary dataset
with the file format type @func{FILETYPE_SRV}, @func{FILETYPE_EXT} or @func{FILETYPE_IEG}.

@EndFunction
*/
void streamDefByteorder(int streamID, int byteorder)
{
  static char func[] = "streamDefByteorder";
  int filetype, fileID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->byteorder = byteorder;
  filetype = streamptr->filetype;
  fileID   = streamptr->fileID;

  switch (filetype)
    {
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
	srvrec_t *srvp = streamptr->record->srvp;
	srvp->byteswap = getByteswap(byteorder);

	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
	extrec_t *extp = streamptr->record->extp;
	extp->byteswap = getByteswap(byteorder);

	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
	iegrec_t *iegp = streamptr->record->iegp;
	iegp->byteswap = getByteswap(byteorder);

	break;
      }
#endif
    }
}


/*
@Function  streamInqByteorder
@Title     Get the byte order

@Prototype int streamInqByteorder(int streamID)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}

@Description
The function @func{streamInqByteorder} returns the byte order of a binary dataset
with the file format type @func{FILETYPE_SRV}, @func{FILETYPE_EXT} or @func{FILETYPE_IEG}.

@Result
@func{streamInqByteorder} returns the type of the byte order.
The valid CDI byte order types are @func{CDI_BIGENDIAN} and @func{CDI_LITTLEENDIAN}

@EndFunction
*/
int streamInqByteorder(int streamID)
{
  static char func[] = "streamInqByteorder";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  return (streamptr->byteorder);
}


char *streamFilesuffix(int filetype)
{
  static char *fileSuffix[] = {"", ".grb", ".g2", ".nc", ".nc2", ".nc4", ".srv", ".ext", ".ieg", ".h5"};
  int size = (int) (sizeof(fileSuffix)/sizeof(char *));

  if ( filetype > 0 && filetype < size )
    return (fileSuffix[filetype]);
  else
    return (fileSuffix[0]);
}


char *streamFilename(int streamID)
{
  static char func[] = "streamFilename";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  return (streamptr->filename);
}


int cdiInqTimeSize(int streamID)
{
  static char func[] = "cdiInqTimeSize";
  int ntsteps;
  int tsID = 0, nrecs;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  ntsteps = streamptr->ntsteps;

  if ( ntsteps == CDI_UNDEFID )
    while ( (nrecs = streamInqTimestep(streamID, tsID++)) )

  ntsteps = streamptr->ntsteps;

  return (ntsteps);
}


int cdiInqContents(int streamID)
{
  static char func[] = "cdiInqContents";
  int filetype;
  int vlistID;
  int taxisID;
  int status = 0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  filetype = streamptr->filetype;

  switch (filetype)
    {
#if  defined  (HAVE_LIBGRIB)
    case FILETYPE_GRB:
    case FILETYPE_GRB2:
      {
        status = grbInqContents(streamID);
	break;
      }
#endif
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
        status = srvInqContents(streamID);
	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
        status = extInqContents(streamID);
	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
        status = iegInqContents(streamID);
	break;
      }
#endif
#if  defined  (HAVE_LIBNETCDF)
    case FILETYPE_NC:
    case FILETYPE_NC2:
    case FILETYPE_NC4:
      {
        status = cdfInqContents(streamID);
	break;
      }
#endif
    default:
      {
	if ( CDI_Debug )
	  Message(func, "%s support not compiled in!", strfiletype(filetype));

	status = CDI_ELIBNAVAIL;
      }
    }

  if ( status == 0 )
    {
      vlistID = streamInqVlist(streamID);
      taxisID = vlistInqTaxis(vlistID);
      if ( taxisID != -1 )
	ptaxisCopy(taxisPtr(taxisID), &streamptr->tsteps[0].taxis);
    }

  return (status);
}


int streamOpen(const char *filename, const char *filemode, int filetype)
{
  static char func[] = "streamOpen";
  int fileID = CDI_UNDEFID;
  int streamID = CDI_ESYSTEM;
  int status;
  Record *record = NULL;
  stream_t *streamptr = NULL;

  if ( CDI_Debug )
    Message(func, "Open %s mode %c file %s", strfiletype(filetype), (int) *filemode, filename);

  if ( ! filename || ! filemode || filetype < 0 ) return (CDI_EINVAL);

  switch (filetype)
    {
#if  defined  (HAVE_LIBGRIB)
    case FILETYPE_GRB:
    case FILETYPE_GRB2:
      {
        fileID = gribOpen(filename, filemode);
	record = (Record *) malloc(sizeof(Record));
	record->buffer = NULL;
	break;
      }
#endif
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
        fileID = fileOpen(filename, filemode);
	record = (Record *) malloc(sizeof(Record));
	record->buffer = NULL;
	record->srvp   = srvNew();
	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
        fileID = fileOpen(filename, filemode);
	record = (Record *) malloc(sizeof(Record));
	record->buffer = NULL;
	record->extp   = extNew();
	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
        fileID = fileOpen(filename, filemode);
	record = (Record *) malloc(sizeof(Record));
	record->buffer = NULL;
	record->iegp   = iegNew();
	break;
      }
#endif
#if  defined  (HAVE_LIBNETCDF)
    case FILETYPE_NC:
      {
	fileID = cdfOpen(filename, filemode);
	break;
      }
    case FILETYPE_NC2:
      {
	fileID = cdfOpen64(filename, filemode);
	break;
      }
    case FILETYPE_NC4:
      {
	fileID = cdf4Open(filename, filemode);
	break;
      }
 #endif
    default:
      {
	if ( CDI_Debug ) Message(func, "%s support not compiled in!", strfiletype(filetype));
	return (CDI_ELIBNAVAIL);
      }
    }

  if ( fileID < 0 )
    {
      streamID = fileID;
    }
  else
    {
      streamptr = stream_new_entry();
      streamID  = streamptr->self;

      if ( streamID < 0 ) return(CDI_ELIMIT);

      streamptr->record   = record;
      streamptr->filetype = filetype;
      streamptr->filemode = tolower(*filemode);
      streamptr->filename = strdupx(filename);
      streamptr->fileID   = fileID;

      if ( streamptr->filemode == 'r' )
	{
	  vlist_t *vlistptr;
	  int vlistID;
	  vlistID = vlistCreate();
	  if ( vlistID < 0 ) return(CDI_ELIMIT);

	  streamptr->vlistID = vlistID;
	  /* cdiReadByteorder(streamID); */
	  status = cdiInqContents(streamID);
	  if ( status < 0 ) return (status);
	  vlistptr = vlist_to_pointer(streamptr->vlistID);
	  vlistptr->ntsteps = streamNtsteps(streamID);
	}
    }
 
  return (streamID);
}


int streamOpenA(const char *filename, const char *filemode, int filetype)
{
  static char func[] = "streamOpenA";
  int fileID = CDI_UNDEFID;
  int streamID = CDI_ESYSTEM;
  int status;
  Record *record = NULL;
  stream_t *streamptr = NULL;

  if ( CDI_Debug )
    Message(func, "Open %s mode %c file %s", strfiletype(filetype), (int) *filemode, filename);

  if ( ! filename || ! filemode || filetype < 0 ) return (CDI_EINVAL);

  switch (filetype)
    {
#if  defined  (HAVE_LIBGRIB)
    case FILETYPE_GRB:
    case FILETYPE_GRB2:
      {
        fileID = gribOpen(filename, "r");
	record = (Record *) malloc(sizeof(Record));
	record->buffer = NULL;
	break;
      }
#endif
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
        fileID = fileOpen(filename, "r");
	record = (Record *) malloc(sizeof(Record));
	record->buffer = NULL;
	record->srvp   = srvNew();
	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
        fileID = fileOpen(filename, "r");
	record = (Record *) malloc(sizeof(Record));
	record->buffer = NULL;
	record->extp   = extNew();
	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
        fileID = fileOpen(filename, "r");
	record = (Record *) malloc(sizeof(Record));
	record->buffer = NULL;
	record->iegp   = iegNew();
	break;
      }
#endif
#if  defined  (HAVE_LIBNETCDF)
    case FILETYPE_NC:
      {
	fileID = cdfOpen(filename, "r");
	break;
      }
    case FILETYPE_NC2:
      {
	fileID = cdfOpen64(filename, "r");
	break;
      }
    case FILETYPE_NC4:
      {
	fileID = cdf4Open(filename, "r");
	break;
      }
#endif
    default:
      {
	if ( CDI_Debug ) Message(func, "%s support not compiled in!", strfiletype(filetype));
	return (CDI_ELIBNAVAIL);
      }
    }

  if ( fileID == CDI_UNDEFID || fileID == CDI_ELIBNAVAIL )
    {
      streamID = fileID;
      return (streamID);
    }
  else
    {
      vlist_t *vlistptr;
      streamptr = stream_new_entry();
      streamID = streamptr->self;

      streamptr->record   = record;
      streamptr->filetype = filetype;
      streamptr->filemode = tolower(*filemode);
      streamptr->filename = strdupx(filename);
      streamptr->fileID   = fileID;

      streamptr->vlistID = vlistCreate();
      /* cdiReadByteorder(streamID); */
      status = cdiInqContents(streamID);
      if ( status < 0 ) return (status);
      vlistptr = vlist_to_pointer(streamptr->vlistID);
      vlistptr->ntsteps = cdiInqTimeSize(streamID);
    }
 
  switch (filetype)
    {
#if  defined  (HAVE_LIBGRIB)
    case FILETYPE_GRB:
    case FILETYPE_GRB2:
      {
	gribClose(fileID);
	break;
      }
#endif
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
	fileClose(fileID);
	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
	fileClose(fileID);
	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
	fileClose(fileID);
	break;
      }
#endif
#if  defined  (HAVE_LIBNETCDF)
    case FILETYPE_NC:
    case FILETYPE_NC2:
    case FILETYPE_NC4:
      {
	cdfClose(fileID);
	break;
      }
#endif
    default:
      {
	if ( CDI_Debug ) Message(func, "%s support not compiled in!", strfiletype(filetype));
	return (CDI_ELIBNAVAIL);
      }
    }

  switch (filetype)
    {
#if  defined  (HAVE_LIBGRIB)
    case FILETYPE_GRB:
    case FILETYPE_GRB2:
      {
        fileID = gribOpen(filename, filemode);
	break;
      }
#endif
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
        fileID = fileOpen(filename, filemode);
	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
        fileID = fileOpen(filename, filemode);
	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
        fileID = fileOpen(filename, filemode);
	break;
      }
#endif
#if  defined  (HAVE_LIBNETCDF)
    case FILETYPE_NC:
      {
	fileID = cdfOpen(filename, filemode);
	streamptr->ncmode = 2;
	break;
      }
    case FILETYPE_NC2:
      {
	fileID = cdfOpen64(filename, filemode);
	streamptr->ncmode = 2;
	break;
      }
    case FILETYPE_NC4:
      {
	fileID = cdf4Open(filename, filemode);
	streamptr->ncmode = 2;
	break;
      }
#endif
    default:
      {
	if ( CDI_Debug ) Message(func, "%s support not compiled in!", strfiletype(filetype));
	return (CDI_ELIBNAVAIL);
      }
    }

  if ( fileID == CDI_UNDEFID )
    streamID = CDI_UNDEFID;
  else
    streamptr->fileID   = fileID;

  return (streamID);
}


/*
@Function  streamOpenRead
@Title     Open a dataset for reading

@Prototype int streamOpenRead(const char *path)
@Parameter
    @Item  path  The name of the dataset to be read

@Description
The function @func{streamOpenRead} opens an existing dataset for reading.

@Result
Upon successful completion @func{streamOpenRead} returns an identifier to the
open stream. Otherwise, a negative number with the error status is returned.

@Errors
@List
   @Item  CDI_ESYSTEM     Operating system error
   @Item  CDI_EINVAL      Invalid argument
   @Item  CDI_EUFILETYPE  Unsupported file type
   @Item  CDI_ELIBNAVAIL  Library support not compiled in
@EndList

@Example
Here is an example using @func{streamOpenRead} to open an existing netCDF
file named @func{foo.nc} for reading:

@Source
   ...
int streamID;
   ...
streamID = streamOpenRead("foo.nc");
if ( streamID < 0 ) handle_error(streamID);
   ...
@EndSource
@EndFunction
*/
int streamOpenRead(const char *filenames)
{
  static char func[] = "streamOpenRead";
  int filetype, byteorder;
  int streamID;
  int num_fnames;
  char *fnames[MAX_FNAMES];
  const char *filename;
  stream_t *streamptr = NULL;

  num_fnames = get_fnames(filenames, fnames, MAX_FNAMES);

  if ( num_fnames == 0 )
    filename = filenames;
  else
    {
      int i; 
      for ( i = 0; i < num_fnames; ++i) printf("fnames: %d %s\n", i, fnames[i]);
      filename = fnames[0];
    }

  filetype = getFiletype(filename, &byteorder);

  if ( filetype < 0 ) return (filetype);

  streamID = streamOpen(filename, "r", filetype);

  if ( streamID >= 0 )
    {
      streamptr = stream_to_pointer(streamID);
      streamptr->byteorder = byteorder;

      if ( num_fnames > 0 )
	{
	  int i;
	  streamptr->nfiles = num_fnames;
	  streamptr->fnames = (char **) malloc(num_fnames*sizeof(char *));
	  for ( i = 0; i < num_fnames; ++i )
	    streamptr->fnames[i] = fnames[i];
	}
    }

  return (streamID);
}


int streamOpenAppend(const char *filename)
{
  int filetype, byteorder;
  int streamID;
  stream_t *streamptr;

  filetype = getFiletype(filename, &byteorder);

  if ( filetype < 0 ) return (filetype);

  streamID = streamOpenA(filename, "a", filetype);

  streamptr = stream_to_pointer(streamID);

  streamptr->byteorder = byteorder;

  return (streamID);
}


/*
@Function  streamOpenWrite
@Title     Create a new dataset

@Prototype int streamOpenWrite(const char *path, int filetype)
@Parameter
    @Item  path      The name of the new dataset
    @Item  filetype  The type of the file format, one of the set of predefined CDI file format types.
                     The valid CDI file format types are @func{FILETYPE_GRB}, @func{FILETYPE_GRB2}, @func{FILETYPE_NC},
                     @func{FILETYPE_NC2}, @func{FILETYPE_NC4}, @func{FILETYPE_SRV},
                     @func{FILETYPE_EXT} and @func{FILETYPE_IEG}.

@Description
The function @func{streamOpenWrite} creates a new datset.
@Result
Upon successful completion @func{streamOpenWrite} returns an identifier to the
open stream. Otherwise, a negative number with the error status is returned.

@Errors
@List
   @Item  CDI_ESYSTEM     Operating system error
   @Item  CDI_EINVAL      Invalid argument
   @Item  CDI_EUFILETYPE  Unsupported file type
   @Item  CDI_ELIBNAVAIL  Library support not compiled in
@EndList

@Example
Here is an example using @func{streamOpenWrite} to create a new netCDF file 
named @func{foo.nc} for writing:

@Source
   ...
int streamID;
   ...
streamID = streamOpenWrite("foo.nc", FILETYPE_NC);
if ( streamID < 0 ) handle_error(streamID);
   ...
@EndSource
@EndFunction
*/
int streamOpenWrite(const char *filename, int filetype)
{
  return (streamOpen(filename, "w", filetype));
}


/*
@Function  streamClose
@Title     Close an open dataset

@Prototype  void streamClose(int streamID)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}

@Description
The function @func{streamClose} closes an open dataset.

@EndFunction
*/
void streamClose(int streamID)
{
  static char func[] = "streamClose";
  int filetype;
  int fileID;
  int index;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  if ( CDI_Debug )
    Message(func, "fileID = %d filename = %s", streamID, streamptr->filename);

  fileID   = streamptr->fileID;
  filetype = streamptr->filetype;
  vlistID  = streamptr->vlistID;

  if ( fileID == CDI_UNDEFID )
    Warning(func, "File %s not open!", streamptr->filename);
  else
    switch (filetype)
      {
#if  defined  (HAVE_LIBGRIB)
      case FILETYPE_GRB:
      case FILETYPE_GRB2:
	{
	  gribClose(fileID);
	  if ( streamptr->gribHandleNums )
	    {
	      int i;
	      for ( i = 0; i < streamptr->gribHandleNums; ++i )
		{
		  gribHandleDelete(streamptr->gribHandle[0]);
		  streamptr->gribHandle[i] = NULL;
		}
	      free(streamptr->gribHandle);
	      streamptr->gribHandle = NULL;
	      streamptr->gribHandleNums = 0;
	    }
	  break;
	}
#endif
#if  defined  (HAVE_LIBSERVICE)
      case FILETYPE_SRV:
	{
	  fileClose(fileID);
	  srvDelete(streamptr->record->srvp);
	  break;
	}
#endif
#if  defined  (HAVE_LIBEXTRA)
      case FILETYPE_EXT:
	{
	  fileClose(fileID);
	  extDelete(streamptr->record->extp);
	  break;
	}
#endif
#if  defined  (HAVE_LIBIEG)
      case FILETYPE_IEG:
	{
	  fileClose(fileID);
	  iegDelete(streamptr->record->iegp);
	  break;
	}
#endif
#if  defined  (HAVE_LIBNETCDF)
      case FILETYPE_NC:
      case FILETYPE_NC2:
      case FILETYPE_NC4:
	{
	  cdfClose(fileID);
	  break;
	}
#endif
      default:
	{
	  Error(func, "%s support not compiled in!", strfiletype(filetype));
	  break;
	}
      }

  if ( streamptr->record )
    {
      if ( streamptr->record->buffer )
	free(streamptr->record->buffer);

      free(streamptr->record);
    }  

  streamptr->filetype = 0;
  if ( streamptr->filename ) free(streamptr->filename);

  for ( index = 0; index < streamptr->nvars; index++ )
    {
      if ( streamptr->vars[index].level )
	free(streamptr->vars[index].level);
      if ( streamptr->vars[index].lindex )
	free(streamptr->vars[index].lindex);
    }
  free(streamptr->vars);

  for ( index = 0; index < streamptr->ntsteps; ++index )
    {
      if ( streamptr->tsteps[index].records )
	free(streamptr->tsteps[index].records);
      if ( streamptr->tsteps[index].recIDs )
	free(streamptr->tsteps[index].recIDs);
    }
    
  if ( streamptr->tsteps ) free(streamptr->tsteps);

  if ( streamptr->nfiles > 0 )
    {
      for ( index = 0; index < streamptr->nfiles; ++index )
	free(streamptr->fnames[index]);

      free(streamptr->fnames);
    }

  if ( vlistID != -1 )
    {
      if ( streamptr->filemode != 'w' )
	if ( vlistInqTaxis(vlistID) != -1 )
	  {
	    taxisDestroy(vlistInqTaxis(vlistID));
	  }

      vlistDestroy(vlistID);
    }

  stream_delete_entry(streamptr);
}


/*
@Function  streamSync
@Title     Synchronize an Open Dataset to Disk

@Prototype  void streamSync(int streamID)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenWrite}

@Description
The function @func{streamSync} offers a way to synchronize the disk copy of a dataset with in-memory buffers.

@EndFunction
*/
void streamSync(int streamID)
{
  static char func[] = "streamSync";
  int filetype;
  int fileID;
  int vlistID;
  int nvars;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID   = streamptr->fileID;
  filetype = streamptr->filetype;
  vlistID  = streamInqVlist(streamID);
  nvars    = vlistNvars(vlistID);

  if ( fileID == CDI_UNDEFID )
    Warning(func, "File %s not open!", streamptr->filename);
  else if ( vlistID == CDI_UNDEFID )
    Warning(func, "Vlist undefined for file %s!", streamptr->filename);
  else if ( nvars == 0 )
    Warning(func, "No variables defined!");
  else
    {
      if ( streamptr->filemode == 'w' || streamptr->filemode == 'a' )
	{
	  switch (filetype)
	    {
#if  defined  (HAVE_LIBNETCDF)
	    case FILETYPE_NC:
	    case FILETYPE_NC2:
	    case FILETYPE_NC4:
	      {
		void cdf_sync(int ncid);
		if ( streamptr->ncmode == 2 ) cdf_sync(fileID);
		break;
	      }
#endif
	    default:
	      {
		fileFlush(fileID);
		break;
	      }
	    }
	}
    }
}


/*
@Function  streamDefTimestep
@Title     Define time step

@Prototype int streamDefTimestep(int streamID, int tsID)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}
    @Item  tsID      Timestep identifier

@Description
The function @func{streamDefTimestep} defines the time step of a stream.

@Result
@func{streamDefTimestep} returns the number of records of the time step.

@EndFunction
*/
int streamDefTimestep(int streamID, int tsID)
{
  static char func[] = "streamDefTimestep";
  int newtsID;
  int taxisID;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d  tsID = %d", streamID, tsID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);
  taxisID = vlistInqTaxis(vlistID);
  if ( taxisID == CDI_UNDEFID )
    {
      Warning(func, "taxisID undefined for fileID = %d! Using absolute time axis.", streamID);
      taxisID = taxisCreate(TAXIS_ABSOLUTE);
      vlistDefTaxis(vlistID, taxisID);
    }

  newtsID = tstepsNewEntry(streamID);

  if ( tsID != newtsID )
    Error(func, "Internal problem: tsID = %d newtsID = %d", tsID, newtsID);

  streamptr->curTsID = tsID;

  ptaxisCopy(&streamptr->tsteps[tsID].taxis, taxisPtr(taxisID));

  streamptr->ntsteps = tsID + 1;

  if ( (streamptr->filetype == FILETYPE_NC  ||
	streamptr->filetype == FILETYPE_NC2 ||
	streamptr->filetype == FILETYPE_NC4)
       && vlistHasTime(vlistID) )
    cdfDefTimestep(streamID, tsID);

  cdiCreateRecords(streamID, tsID);

  return (streamptr->ntsteps);
}


/*
@Function  streamInqTimestep
@Title     Get time step

@Prototype int streamInqTimestep(int streamID, int tsID)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}
    @Item  tsID      Timestep identifier

@Description
The function @func{streamInqTimestep} returns the time step of a stream.

@Result
@func{streamInqTimestep} returns the number of records of the time step.

@EndFunction
*/
int streamInqTimestep(int streamID, int tsID)
{
  static char func[] = "streamInqTimestep";
  int filetype;
  int nrecs = 0;
  int taxisID;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);

  if ( tsID < streamptr->rtsteps )
    {
      streamptr->curTsID = tsID;
      nrecs = streamptr->tsteps[tsID].nrecs;
      streamptr->tsteps[tsID].curRecID = CDI_UNDEFID;
      taxisID = vlistInqTaxis(vlistID);
      if ( taxisID == -1 )
	Error(func, "Timestep undefined for fileID = %d", streamID);
      ptaxisCopy(taxisPtr(taxisID), &streamptr->tsteps[tsID].taxis);

      return (nrecs);
    }

  if ( tsID >= streamptr->ntsteps && streamptr->ntsteps != CDI_UNDEFID )
    {
      return (0);
    }

  filetype = streamptr->filetype;

  if ( CDI_Debug )
    Message(func, "streamID = %d  tsID = %d  filetype = %d", streamID, tsID, filetype);

  switch (filetype)
    {
#if  defined  (HAVE_LIBGRIB)
    case FILETYPE_GRB:
    case FILETYPE_GRB2:
      {
        nrecs = grbInqTimestep(streamID, tsID);
	break;
      }
#endif
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
        nrecs = srvInqTimestep(streamID, tsID);
	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
        nrecs = extInqTimestep(streamID, tsID);
	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
        nrecs = iegInqTimestep(streamID, tsID);
	break;
      }
#endif
#if  defined  (HAVE_LIBNETCDF)
    case FILETYPE_NC:
    case FILETYPE_NC2:
    case FILETYPE_NC4:
      {
        nrecs = cdfInqTimestep(streamID, tsID);
	break;
      }
#endif
    default:
      {
	Error(func, "%s support not compiled in!", strfiletype(filetype));
	break;
      }
    }

  taxisID = vlistInqTaxis(vlistID);
  if ( taxisID == -1 )
    Error(func, "Timestep undefined for fileID = %d", streamID);

  ptaxisCopy(taxisPtr(taxisID), &streamptr->tsteps[tsID].taxis);

  return (nrecs);
}


/*
@Function  streamReadVar
@Title     Read a variable

@Prototype void streamReadVar(int streamID, int varID, double *data, int *nmiss)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}
    @Item  varID     Variable identifier
    @Item  data      Pointer to the location into which the data value is read
    @Item  nmiss     Number of missing values

@Description
The function streamReadVar reads all the values of one time step of a variable
from an open dataset.
@EndFunction
*/
void streamReadVar(int streamID, int varID, double *data, int *nmiss)
{
  static char func[] = "streamReadVar";
  int filetype;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d  varID = %d", streamID, varID);

  stream_check_ptr(func, streamptr);

  filetype = streamptr->filetype;

  *nmiss = 0;

  switch (filetype)
    {
#if  defined  (HAVE_LIBGRIB)
    case FILETYPE_GRB:
    case FILETYPE_GRB2:
      {
        grbReadVarDP(streamID, varID, data, nmiss);
	break;
      }
#endif
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
        srvReadVarDP(streamID, varID, data, nmiss);
	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
        extReadVarDP(streamID, varID, data, nmiss);
	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
        iegReadVarDP(streamID, varID, data, nmiss);
	break;
      }
#endif
#if  defined  (HAVE_LIBNETCDF)
    case FILETYPE_NC:
    case FILETYPE_NC2:
    case FILETYPE_NC4:
      {
        cdfReadVarDP(streamID, varID, data, nmiss);
	break;
      }
#endif
    default:
      {
	Error(func, "%s support not compiled in!", strfiletype(filetype));
	break;
      }
    }
}


/*
@Function  streamWriteVar
@Title     Write a variable

@Prototype void streamWriteVar(int streamID, int varID, const double *data, int nmiss)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}
    @Item  varID     Variable identifier
    @Item  data      Pointer to a block of data values to be written
    @Item  nmiss     Number of missing values

@Description
The function streamWriteVar writes the values of one time step of a variable 
to an open dataset.
@EndFunction
*/
void streamWriteVar(int streamID, int varID, const double *data, int nmiss)
{
  static char func[] = "streamWriteVar";
  int filetype;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d varID = %d", streamID, varID);

  stream_check_ptr(func, streamptr);

  streamDefineTaxis(streamID);

  filetype = streamptr->filetype;

  switch (filetype)
    {
#if  defined  (HAVE_LIBGRIB)
    case FILETYPE_GRB:
    case FILETYPE_GRB2:
      {
        grbWriteVarDP(streamID, varID, data, nmiss);
	break;
      }
#endif
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
        srvWriteVarDP(streamID, varID, data);
	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
        extWriteVarDP(streamID, varID, data);
	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
        iegWriteVarDP(streamID, varID, data);
	break;
      }
#endif
#if  defined  (HAVE_LIBNETCDF)
    case FILETYPE_NC:
    case FILETYPE_NC2:
    case FILETYPE_NC4:
      {
	if ( streamptr->accessmode == 0 ) cdfEndDef(streamID);
        cdfWriteVarDP(streamID, varID, data, nmiss);
	break;
      }
#endif
    default:
      {
	Error(func, "%s support not compiled in!", strfiletype(filetype));
	break;
      }
    }
}


/*
@Function  streamReadVarSlice
@Title     Read a horizontal slice of a variable

@Prototype void streamReadVarSlice(int streamID, int varID, int levelID, double *data, int *nmiss)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}
    @Item  varID     Variable identifier
    @Item  levelID   Level identifier
    @Item  data      Pointer to the location into which the data value is read
    @Item  nmiss     Number of missing values

@Description
The function streamReadVar reads all the values of a horizontal slice of a variable
from an open dataset.
@EndFunction
*/
void streamReadVarSlice(int streamID, int varID, int levelID, double *data, int *nmiss)
{
  static char func[] = "streamReadVarSlice";
  int filetype;
  int ierr = 0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  filetype = streamptr->filetype;

  *nmiss = 0;

  switch (filetype)
    {
#if  defined  (HAVE_LIBGRIB)
    case FILETYPE_GRB:
    case FILETYPE_GRB2:
      {
        grbReadVarSliceDP(streamID, varID, levelID, data, nmiss);
	break;
      }
#endif
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
        srvReadVarSliceDP(streamID, varID, levelID, data, nmiss);
	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
        extReadVarSliceDP(streamID, varID, levelID, data, nmiss);
	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
        iegReadVarSliceDP(streamID, varID, levelID, data, nmiss);
	break;
      }
#endif
#if  defined  (HAVE_LIBNETCDF)
    case FILETYPE_NC:
    case FILETYPE_NC2:
    case FILETYPE_NC4:
      {
        ierr = cdfReadVarSliceDP(streamID, varID, levelID, data, nmiss);
	break;
      }
#endif
    default:
      {
	Error(func, "%s support not compiled in!", strfiletype(filetype));
	break;
      }
    }
}


/*
@Function  streamWriteVarSlice
@Title     Write a horizontal slice of a variable

@Prototype void streamWriteVarSlice(int streamID, int varID, int levelID, const double *data, int nmiss)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}
    @Item  varID     Variable identifier
    @Item  levelID   Level identifier
    @Item  data      Pointer to a block of data values to be written
    @Item  nmiss     Number of missing values

@Description
The function streamWriteVarSlice writes the values of a horizontal slice of a 
variable to an open dataset.
@EndFunction
*/
void streamWriteVarSlice(int streamID, int varID, int levelID, const double *data, int nmiss)
{
  static char func[] = "streamWriteVarSlice";
  int filetype;
  int ierr = 0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d varID = %d", streamID, varID);

  stream_check_ptr(func, streamptr);

  filetype = streamptr->filetype;

  switch (filetype)
    {
#if  defined  (HAVE_LIBGRIB)
    case FILETYPE_GRB:
    case FILETYPE_GRB2:
      {
        grbWriteVarSliceDP(streamID, varID, levelID, data, nmiss);
	break;
      }
#endif
#if  defined  (HAVE_LIBSERVICE)
    case FILETYPE_SRV:
      {
        srvWriteVarSliceDP(streamID, varID, levelID, data);
	break;
      }
#endif
#if  defined  (HAVE_LIBEXTRA)
    case FILETYPE_EXT:
      {
        extWriteVarSliceDP(streamID, varID, levelID, data);
	break;
      }
#endif
#if  defined  (HAVE_LIBIEG)
    case FILETYPE_IEG:
      {
        iegWriteVarSliceDP(streamID, varID, levelID, data);
	break;
      }
#endif
#if  defined  (HAVE_LIBNETCDF)
    case FILETYPE_NC:
    case FILETYPE_NC2:
    case FILETYPE_NC4:
      {
	if ( streamptr->accessmode == 0 ) cdfEndDef(streamID);
        ierr = cdfWriteVarSliceDP(streamID, varID, levelID, data, nmiss);
	break;
      }
#endif
    default:
      {
	Error(func, "%s support not compiled in!", strfiletype(filetype));
	break;
      }
    }
}


void streamWriteContents(int streamID, char *cname)
{
  static char func[] = "streamWriteContents";
  FILE *cnp;
  int tsID, recID, varID, levelID;
  long recsize;
  int nrecs, nvars;
  int code, gridID, zaxisID, timeID, datatype;
  int ngrids, nzaxis;
  int filetype, gridtype;
  int xsize, ysize;
  int date, time;
  int i;
  off_t recpos, position;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);

  cnp = fopen(cname, "w");

  if ( cnp == NULL ) SysError(func, cname);

  fprintf(cnp, "#CDI library version %s\n", cdiLibraryVersion());
  fprintf(cnp, "#\n");

  fprintf(cnp, "filename: %s\n", streamptr->filename);
  filetype = streamptr->filetype;
  fprintf(cnp, "filetype: %s\n", strfiletype(filetype));

  fprintf(cnp, "#\n");
  fprintf(cnp, "#grids:\n");

  ngrids = vlistNgrids(vlistID);
  for ( i = 0; i < ngrids; i++ )
    {
      gridID   = vlistGrid(vlistID, i);
      gridtype = gridInqType(gridID);
      xsize    = gridInqXsize(gridID);
      ysize    = gridInqYsize(gridID);
      fprintf(cnp, "%4d:%4d:%4d:%4d\n", i+1, gridtype, xsize, ysize);
    }
  nzaxis = vlistNzaxis(vlistID);

  fprintf(cnp, "#\n");

  fprintf(cnp, "varID:code:gridID:zaxisID:timeID:datatype\n");

  nvars = vlistNvars(vlistID);
  for ( varID = 0; varID < nvars; varID++ )
    {
      code     = vlistInqVarCode(vlistID, varID);
      gridID   = vlistInqVarGrid(vlistID, varID);
      zaxisID  = vlistInqVarZaxis(vlistID, varID);
      timeID   = vlistInqVarTime(vlistID, varID);
      datatype = vlistInqVarDatatype(vlistID, varID);
      fprintf(cnp, "%4d:%4d:%4d:%4d:%4d:%4d:\n",
	      varID+1, code, gridID, zaxisID, timeID, datatype);
    }

  fprintf(cnp, "#\n");

  fprintf(cnp, "tsID:nrecs:date:time\n");
  
  tsID = 0;
  while (1)
    {
      nrecs = streamptr->tsteps[tsID].nallrecs;
      date  = streamptr->tsteps[tsID].taxis.vdate;
      time  = streamptr->tsteps[tsID].taxis.vtime;
      position = streamptr->tsteps[tsID].position;

      fprintf(cnp, "%4d:%4d:%4d:%4d:%ld\n",
	      tsID, nrecs, date, time, (long) position);

      if ( streamptr->tsteps[tsID].next )
	tsID++;
      else
	break;
    }

  fprintf(cnp, "#\n");

  fprintf(cnp, "tsID:recID:varID:levID:size:pos\n");

  tsID = 0;
  while (1)
    {
      nrecs = streamptr->tsteps[tsID].nallrecs;
      for ( recID = 0; recID < nrecs; recID++ )
	{
	  varID   = streamptr->tsteps[tsID].records[recID].varID;
	  levelID = streamptr->tsteps[tsID].records[recID].levelID;
	  recpos  = streamptr->tsteps[tsID].records[recID].position;
	  recsize = (long)streamptr->tsteps[tsID].records[recID].size;
	  fprintf(cnp, "%4d:%4d:%4d:%4d:%4ld:%ld\n",
		  tsID, recID, varID, levelID, recsize, (long) recpos);
	}

      if ( streamptr->tsteps[tsID].next )
	tsID++;
      else
	break;
    }

  fclose(cnp);
}


void cdiDefTableID(int tableID)
{
  int modelID, instID;

  cdiDefaultTableID = tableID;

  modelID = tableInqModel(tableID);
  cdiDefaultModelID = modelID;

  instID = modelInqInstitut(modelID);
  cdiDefaultInstID = instID;
}


void cdiPrintVersion(void)
{
  fprintf(stderr, "     CDI library version : %s\n", cdiLibraryVersion());
#if  defined  (HAVE_LIBGRIB)
  fprintf(stderr, " CGRIBEX library version : %s\n", cgribexLibraryVersion());
#endif
#if  defined  (HAVE_LIBGRIB_API)
  fprintf(stderr, "GRIB_API library version : %s\n", gribapiLibraryVersion());
#endif
#if  defined  (HAVE_LIBNETCDF)
#  if  defined  (HAVE_LIBNC_DAP)
  fprintf(stderr, "  nc_dap library version : %s\n", cdfLibraryVersion());
#  else
  fprintf(stderr, "  netCDF library version : %s\n", cdfLibraryVersion());
#  endif
#endif
#if  defined  (HAVE_LIBHDF5)
  fprintf(stderr, "    HDF5 library version : %s\n", hdfLibraryVersion());
#endif
#if  defined  (HAVE_LIBSERVICE)
  fprintf(stderr, " SERVICE library version : %s\n", srvLibraryVersion());
#endif
#if  defined  (HAVE_LIBEXTRA)
  fprintf(stderr, "   EXTRA library version : %s\n", extLibraryVersion());
#endif
#if  defined  (HAVE_LIBIEG)
  fprintf(stderr, "     IEG library version : %s\n", iegLibraryVersion());
#endif
  fprintf(stderr, "    FILE library version : %s\n", fileLibraryVersion());
}


int streamNtsteps(int streamID)
{
  static char func[] = "streamNtsteps";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  return (streamptr->ntsteps);
}

off_t   streamNvals(int streamID)
{
  static char func[] = "streamNvals";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  return (streamptr->numvals);
}

/*
@Function  streamDefVlist
@Title     Define the variable list

@Prototype void streamDefVlist(int streamID, int vlistID)
@Parameter
    @Item  streamID Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}
    @Item  vlistID  Variable list ID, from a previous call to @fref{vlistCreate}

@Description
The function @func{streamDefVlist} defines the variable list of a stream.

@EndFunction
*/
void streamDefVlist(int streamID, int vlistID)
{
  static char func[] = "streamDefVlist";
  int nvars, varID;
  int gridID, zaxisID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  if ( streamptr->vlistID == CDI_UNDEFID )
    {
      streamptr->vlistID = vlistDuplicate(vlistID);

      nvars = vlistNvars(vlistID);
      for ( varID = 0; varID < nvars; varID++ )
	{
	  gridID  = vlistInqVarGrid(vlistID, varID);
	  zaxisID = vlistInqVarZaxis(vlistID, varID);
	  streamNewVar(streamID, gridID, zaxisID);
	  if ( streamptr->have_missval )
	    vlistDefVarMissval(streamptr->vlistID, varID, vlistInqVarMissval(vlistID, varID));
	}

      if ( streamptr->filemode == 'w' )
	{
	  if ( streamptr->filetype == FILETYPE_NC  ||
	       streamptr->filetype == FILETYPE_NC2 ||
	       streamptr->filetype == FILETYPE_NC4 )
	    {
	      cdfDefVars(streamID);
	    }
	  else if ( streamptr->filetype == FILETYPE_GRB2 )
	    {
	      gribapiDefHandles(streamID);
	    }
	}
    }
  else
    {
      Warning(func, "vlist already defined for %s!", streamptr->filename);
    }
}


/*
@Function  streamInqVlist
@Title     Get the variable list

@Prototype int streamInqVlist(int streamID)
@Parameter
    @Item  streamID  Stream ID, from a previous call to @fref{streamOpenRead} or @fref{streamOpenWrite}

@Description
The function @func{streamInqVlist} returns the variable list of a stream.

@Result
@func{streamInqVlist} returns an identifier to the variable list.

@EndFunction
*/
int streamInqVlist(int streamID)
{
  static char func[] = "streamInqVlist";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);
  
  stream_check_ptr(func, streamptr);

  return (streamptr->vlistID);
}


void streamDefZtype(int streamID, int ztype)
{
  static char func[] = "streamDefZtype";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->ztype = ztype;
}


void streamDefZlevel(int streamID, int zlevel)
{
  static char func[] = "streamDefZlevel";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->zlevel = zlevel;
}


int streamInqZtype(int streamID)
{
  static char func[] = "streamInqZtype";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  return (streamptr->ztype);
}


int streamInqZlevel(int streamID)
{
  static char func[] = "streamInqZlevel";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  return (streamptr->zlevel);
}
#if defined (HAVE_CONFIG_H)
#endif



void streamDefHistory(int streamID, int length, const char *history)
{
  static char func[] = "streamDefHistory";
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( streamptr->filetype == FILETYPE_NC  ||
       streamptr->filetype == FILETYPE_NC2 ||
       streamptr->filetype == FILETYPE_NC4 )
    {
      char *histstring;
      size_t len;
      if ( history )
	{
	  len = strlen(history);
	  if ( len )
	    {
	      histstring = strdupx(history);
	      cdfDefHistory(streamID, length, histstring);
	      free(histstring);
	    }
	}
    }
}


int streamInqHistorySize(int streamID)
{
  int size = 0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( streamptr->filetype == FILETYPE_NC  ||
       streamptr->filetype == FILETYPE_NC2 ||
       streamptr->filetype == FILETYPE_NC4 )
    {
      size = cdfInqHistorySize(streamID);
    }

  return (size);
}


void streamInqHistoryString(int streamID, char *history)
{
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( streamptr->filetype == FILETYPE_NC  ||
       streamptr->filetype == FILETYPE_NC2 ||
       streamptr->filetype == FILETYPE_NC4 )
    {
      cdfInqHistoryString(streamID, history);
    }
}
#if defined (HAVE_CONFIG_H)
#endif



#if  defined  (HAVE_LIBCGRIBEX)
#endif

extern int cdiInventoryMode;

typedef struct {
  int param;
  int level1;
  int level2;
  int ltype;
} compvar_t; 


static
int cgribexGetGridType(int *isec2)
{
  /*  static char func[] = "cgribexGetGridType"; */
  int gridtype = 0;

  switch (ISEC2_GridType)
    {
    case  GTYPE_LATLON:
    case  GTYPE_LATLON_ROT:
      {
	gridtype = GRID_LONLAT;
	break;
      }
    case  GTYPE_LCC:
      {
	gridtype = GRID_LCC;
	break;
      }
    case  GTYPE_GAUSSIAN:
      {
	if ( ISEC2_Reduced )
	  gridtype = GRID_GAUSSIAN_REDUCED;
	else
	  gridtype = GRID_GAUSSIAN;
	break;
      }
    case  GTYPE_SPECTRAL:
      {
	gridtype = GRID_SPECTRAL;
	break;
      }
    case  GTYPE_GME:
      {
	gridtype = GRID_GME;
	break;
      }
    default:
      {
	gridtype = GRID_GENERIC;
	break;
      }
    }

  return (gridtype);
}

static
int cgribexGetIsRotated(int *isec2)
{
  /*  static char func[] = "cgribexGetIsRotated"; */
  int isRotated = 0;

  if ( ISEC2_GridType == 10 )
    {
      isRotated = 1;
    }

  return (isRotated);
}

static
int cgribexGetZaxisType(int grb_ltype)
{
  int zaxistype = 0;

  switch ( grb_ltype )
    {
    case LTYPE_SURFACE:
      {
	zaxistype = ZAXIS_SURFACE;
	break;
      }
    case LTYPE_MEANSEA:
      {
	zaxistype = ZAXIS_MEANSEA;
	break;
      }
    case LTYPE_99:
    case LTYPE_ISOBARIC:
      {
	zaxistype = ZAXIS_PRESSURE;
	break;
      }
    case LTYPE_HEIGHT:
      {
	zaxistype = ZAXIS_HEIGHT;
	break;
      }
    case LTYPE_ALTITUDE:
      {
	zaxistype = ZAXIS_ALTITUDE;
	break;
      }
    case LTYPE_SIGMA:
      {
	zaxistype = ZAXIS_SIGMA;
	break;
      }
    case LTYPE_HYBRID:
    case LTYPE_HYBRID_LAYER:
      {
	zaxistype = ZAXIS_HYBRID;
	break;
      }
    case LTYPE_LANDDEPTH:
    case LTYPE_LANDDEPTH_LAYER:
      {
	zaxistype = ZAXIS_DEPTH_BELOW_LAND;
	break;
      }
    case LTYPE_ISENTROPIC:
      {
	zaxistype = ZAXIS_ISENTROPIC;
	break;
      }
    case LTYPE_SEADEPTH:
      {
	zaxistype = ZAXIS_DEPTH_BELOW_SEA;
	break;
      }
    default:
      {
	zaxistype = ZAXIS_GENERIC;
	break;
      }
    }

  return (zaxistype);
}

static
int cgribexGetZaxisHasBounds(int grb_ltype)
{
  int lbounds = 0;

  switch (grb_ltype)
    {
    case LTYPE_HYBRID_LAYER:
    case LTYPE_LANDDEPTH_LAYER:
      {
	lbounds = 1;
	break;
      }
    }

  return (lbounds);
}

static
int cgribexGetTimeUnit(int *isec1)
{
  static char func[] = "cgribexGetTimeUnit";
  int timeunit = -1;
  static int lprint = TRUE;

  switch ( ISEC1_TimeUnit )
    {
    case ISEC1_TABLE4_MINUTE:  timeunit = TUNIT_MINUTE;  break;
    case ISEC1_TABLE4_QUARTER: timeunit = TUNIT_QUARTER; break;
    case ISEC1_TABLE4_HOUR:    timeunit = TUNIT_HOUR;    break;
    case ISEC1_TABLE4_3HOURS:  timeunit = TUNIT_3HOURS;  break;
    case ISEC1_TABLE4_6HOURS:  timeunit = TUNIT_6HOURS;  break;
    case ISEC1_TABLE4_12HOURS: timeunit = TUNIT_12HOURS; break;
    case ISEC1_TABLE4_DAY:     timeunit = TUNIT_DAY;     break;
    default:
      if ( lprint )
	{
	  Message(func, "Time unit %d unsupported", ISEC1_TimeUnit);
	  lprint = FALSE;
	}
    }

  return (timeunit);
}

static
int cgribexTimeIsFC(int *isec1)
{
  int isFC = TRUE;

  if ( ISEC1_TimeRange == 10 && ISEC1_TimePeriod1 == 0 && ISEC1_TimePeriod2 == 0 )
    isFC = FALSE;

  return (isFC);
}

static
int cgribexGetTsteptype(int timerange)
{
  static char func[] = "cgribexGetTsteptype";
  int tsteptype = 0;
  static int lprint = TRUE;

  switch ( timerange )
    {
    case  0:  tsteptype = TSTEP_INSTANT;  break;
    case  1:  tsteptype = TSTEP_INSTANT2; break;
    case  2:  tsteptype = TSTEP_RANGE;    break;
    case  3:  tsteptype = TSTEP_AVG;      break;
    case  4:  tsteptype = TSTEP_ACCUM;    break;
    case  5:  tsteptype = TSTEP_DIFF;     break;
    case 10:  tsteptype = TSTEP_INSTANT3; break;
    default:
      if ( lprint )
	{
	  Message(func, "Time range %d unsupported", timerange);
	  lprint = FALSE;
	}
    }

  return (tsteptype);
}


static
void cgribexAddRecord(int streamID, int param, int *isec1, int *isec2, double *fsec2, double *fsec3,
		      int *isec4, long recsize, off_t position, int prec, int ztype, int lmv)
{
  static char func[] = "cgribexAddRecord";
  int gridtype;
  int zaxistype;
  int gridID = CDI_UNDEFID, varID;
  int levelID = 0;
  int tsID, recID;
  int level1, level2;
  int numavg;
  int tsteptype;
  int lbounds = 0;
  record_t *record;
  grid_t grid;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  tsID    = streamptr->curTsID;
  recID   = recordNewEntry(streamID, tsID);
  record  = &streamptr->tsteps[tsID].records[recID];

  tsteptype = cgribexGetTsteptype(ISEC1_TimeRange);
  numavg    = ISEC1_AvgNum;

  level1  = ISEC1_Level1;
  level2  = ISEC1_Level2;

  /* fprintf(stderr, "param %d %d %d %d\n", param, level1, level2, ISEC1_LevelType); */

  (*record).size     = recsize;
  (*record).position = position;
  (*record).param    = param;
  (*record).ilevel   = level1;
  (*record).ilevel2  = level2;
  (*record).ltype    = ISEC1_LevelType;

  gridtype = cgribexGetGridType(isec2);

  if ( streamptr->unreduced && gridtype == GRID_GAUSSIAN_REDUCED )
    {
      gridtype = GRID_GAUSSIAN;
      ISEC2_NumLon = 2*ISEC2_NumLat;
      ISEC4_NumValues = ISEC2_NumLon*ISEC2_NumLat;
    }

  memset(&grid, 0, sizeof(grid_t));
  switch (gridtype)
    {
    case GRID_LONLAT:
    case GRID_GAUSSIAN:
      {
	if ( ISEC4_NumValues != ISEC2_NumLon*ISEC2_NumLat )
	  Error(func, "numberOfPoints (%d) and gridSize (%d) differ!",
		ISEC4_NumValues, ISEC2_NumLon*ISEC2_NumLat);
	grid.size  = ISEC4_NumValues;
	grid.xsize = ISEC2_NumLon;
	grid.ysize = ISEC2_NumLat;
	grid.xinc  = 0;
	grid.yinc  = 0;
	grid.xdef  = 0;
	/* if ( ISEC2_FirstLon != 0 || ISEC2_LastLon != 0 ) */
	  {
	    if ( grid.xsize > 1 )
	      {
		if ( ISEC2_ResFlag && ISEC2_LonIncr > 0 )
		  grid.xinc = ISEC2_LonIncr * 0.001;
		else
		  grid.xinc = (ISEC2_LastLon - ISEC2_FirstLon) * 0.001 / (grid.xsize - 1);

		/* correct xinc if necessary */
		if ( ISEC2_FirstLon == 0 && ISEC2_LastLon > 354000 )
		  {
		    double xinc = 360. / grid.xsize;

		    if ( fabs(grid.xinc-xinc) > 0.0 )
		      {
			grid.xinc = xinc;
			if ( CDI_Debug ) Message(func, "set xinc to %g", grid.xinc);
		      }
		  }
	      }
	    grid.xfirst = ISEC2_FirstLon * 0.001;
	    grid.xlast  = ISEC2_LastLon  * 0.001;
	    grid.xdef   = 2;	    
	  }
	grid.ydef  = 0;
	/* if ( ISEC2_FirstLat != 0 || ISEC2_LastLat != 0 ) */
	  {
	    if ( grid.ysize > 1 )
	      {
		if ( ISEC2_ResFlag && ISEC2_LatIncr > 0 )
		  grid.yinc = ISEC2_LatIncr * 0.001;
		else
		  grid.yinc = (ISEC2_LastLat - ISEC2_FirstLat) * 0.001 / (grid.ysize - 1);
	      }
	    grid.yfirst = ISEC2_FirstLat * 0.001;
	    grid.ylast  = ISEC2_LastLat  * 0.001;
	    grid.ydef   = 2;	    
	  }
	break;
      }
    case GRID_GAUSSIAN_REDUCED:
      {
	grid.size   = ISEC4_NumValues;
        grid.rowlon = ISEC2_RowLonPtr;
	grid.ysize  = ISEC2_NumLat;
	grid.xinc  = 0;
	grid.yinc  = 0;
	grid.xdef  = 0;
	/* if ( ISEC2_FirstLon != 0 || ISEC2_LastLon != 0 ) */
	  {
	    if ( grid.xsize > 1 )
	      {
		if ( ISEC2_ResFlag && ISEC2_LonIncr > 0 )
		  grid.xinc = ISEC2_LonIncr * 0.001;
		else
		  grid.xinc = (ISEC2_LastLon - ISEC2_FirstLon) * 0.001 / (grid.xsize - 1);
	      }
	    grid.xfirst = ISEC2_FirstLon * 0.001;
	    grid.xlast  = ISEC2_LastLon  * 0.001;
	    grid.xdef   = 2;	    
	  }
	grid.ydef  = 0;
	/* if ( ISEC2_FirstLat != 0 || ISEC2_LastLat != 0 ) */
	  {
	    if ( grid.ysize > 1 )
	      {
		if ( ISEC2_ResFlag && ISEC2_LatIncr > 0 )
		  grid.yinc = ISEC2_LatIncr * 0.001;
		else
		  grid.yinc = (ISEC2_LastLat - ISEC2_FirstLat) * 0.001 / (grid.ysize - 1);
	      }
	    grid.yfirst = ISEC2_FirstLat * 0.001;
	    grid.ylast  = ISEC2_LastLat  * 0.001;
	    grid.ydef   = 2;	    
	  }
	break;
      }
    case GRID_LCC:
      {
	if ( ISEC4_NumValues != ISEC2_NumLon*ISEC2_NumLat )
	  Error(func, "numberOfPoints (%d) and gridSize (%d) differ!",
		ISEC4_NumValues, ISEC2_NumLon*ISEC2_NumLat);

	grid.size  = ISEC4_NumValues;
	grid.xsize = ISEC2_NumLon;
	grid.ysize = ISEC2_NumLat;

	grid.lcc_xinc      = ISEC2_Lambert_dx;
	grid.lcc_yinc      = ISEC2_Lambert_dy;
	grid.lcc_originLon = ISEC2_FirstLon * 0.001;
	grid.lcc_originLat = ISEC2_FirstLat * 0.001;
	grid.lcc_lonParY   = ISEC2_Lambert_Lov * 0.001;
	grid.lcc_lat1      = ISEC2_Lambert_LatS1 * 0.001;
	grid.lcc_lat2      = ISEC2_Lambert_LatS2 * 0.001;
	grid.lcc_projflag  = ISEC2_Lambert_ProjFlag;
	grid.lcc_scanflag  = ISEC2_ScanFlag;

	grid.xdef   = 0;	    
	grid.ydef   = 0;

	break;
      }
    case GRID_SPECTRAL:
      {
	grid.size  = ISEC4_NumValues;
	grid.trunc = ISEC2_PentaJ;
	if ( ISEC2_RepMode == 2 )
	  grid.lcomplex = 1;
	else
	  grid.lcomplex = 0;

	break;
      }
    case GRID_GME:
      {
	grid.size  = ISEC4_NumValues;
	grid.nd    = ISEC2_GME_ND;
	grid.ni    = ISEC2_GME_NI;
	grid.ni2   = ISEC2_GME_NI2;
	grid.ni3   = ISEC2_GME_NI3;
	break;
      }
    case GRID_GENERIC:
      {
	grid.size  = ISEC4_NumValues;
	grid.xsize = 0;
	grid.ysize = 0;
	break;
      }
    default:
      {
	Error(func, "Unsupported grid type: %s", gridNamePtr(gridtype));
	break;
      }
    }

  grid.isRotated = FALSE;
  if ( cgribexGetIsRotated(isec2) )
    {
      grid.isRotated = TRUE;
      grid.ypole     = - ISEC2_LatSP * 0.001;
      grid.xpole     =   ISEC2_LonSP * 0.001 - 180;
      grid.angle     = 0;
    }

  grid.xvals = NULL;
  grid.yvals = NULL;
  grid.type  = gridtype;

  gridID = varDefGrid(vlistID, grid, 0);

  zaxistype = cgribexGetZaxisType(ISEC1_LevelType);

  if ( zaxistype == ZAXIS_HYBRID )
    {
      int vctsize = ISEC2_NumVCP;
      double *vctptr = &fsec2[10];

      varDefVCT(vctsize, vctptr);
    }

  lbounds = cgribexGetZaxisHasBounds(ISEC1_LevelType);

  if ( prec > 32 ) prec = DATATYPE_PACK32;
  if ( prec <  0 ) prec = DATATYPE_PACK;

  varAddRecord(recID, param, gridID, zaxistype, lbounds, level1, level2,
	       prec, &varID, &levelID, tsteptype, numavg, ISEC1_LevelType, NULL, NULL, NULL);

  (*record).varID   = varID;
  (*record).levelID = levelID;

  varDefZtype(varID, ztype);

  if ( lmv ) varDefMissval(varID, FSEC3_MissVal);

  if ( varInqInst(varID) == CDI_UNDEFID )
    {
      int center, subcenter, instID;
      center    = ISEC1_CenterID;
      subcenter = ISEC1_SubCenterID;
      instID    = institutInq(center, subcenter, NULL, NULL);
      if ( instID == CDI_UNDEFID )
	instID = institutDef(center, subcenter, NULL, NULL);
      varDefInst(varID, instID);
    }

  if ( varInqModel(varID) == CDI_UNDEFID )
    {
      int modelID;
      modelID = modelInq(varInqInst(varID), ISEC1_ModelID, NULL);
      if ( modelID == CDI_UNDEFID )
	modelID = modelDef(varInqInst(varID), ISEC1_ModelID, NULL);
      varDefModel(varID, modelID);
    }

  if ( varInqTable(varID) == CDI_UNDEFID )
    {
      int tableID;

      tableID = tableInq(varInqModel(varID), ISEC1_CodeTable, NULL);

      if ( tableID == CDI_UNDEFID )
	tableID = tableDef(varInqModel(varID), ISEC1_CodeTable, NULL);
      varDefTable(varID, tableID);
    }

  streamptr->tsteps[tsID].nallrecs++;
  streamptr->nrecs++;

  if ( CDI_Debug )
    Message(func, "varID = %d  param = %d  zaxistype = %d  gridID = %d  levelID = %d",
	    varID, param, zaxistype, gridID, levelID);
}

static
void MCH_get_undef(int *isec1, double *undef_pds, double *undef_eps)
{
  /* 2010-01-13: Oliver Fuhrer */
  if ( ISEC1_CenterID == 215 ) {
    if (isec1[34] != 0 && isec1[34] != 255) {
      if (isec1[34] & 2) {
        if (isec1[34] & 1) {
          *undef_pds = -0.99*pow(10.0,-isec1[35]);
        } else {
          *undef_pds = +0.99*pow(10.0,-isec1[35]);
        }
        *undef_eps = pow(10.0,-isec1[35]-1);
      } else {
        if (isec1[34] & 1) {
          *undef_pds = -0.99*pow(10.0,+isec1[35]);
        } else {
          *undef_pds = +0.99*pow(10.0,+isec1[35]);
        }
        *undef_eps = pow(10.0,isec1[35]-1);
      }
    }
  }
}

static
void cgribexDecodeHeader(int *isec0, int *isec1, int *isec2, double *fsec2,
			 int *isec3, double *fsec3, int *isec4, double *fsec4, 
			 int *gribbuffer, int recsize, int *lmv)
{
  int iret = 0, ipunp = 0, iword = 0;

  gribExDP(isec0, isec1, isec2, fsec2, isec3, fsec3, isec4, fsec4,
	   ipunp, (int *) gribbuffer, recsize, &iword, "J", &iret);

  *lmv = 0;

  if ( ISEC1_CenterID == 215 && (isec1[34] != 0 && isec1[34] != 255) )
    {
      double undef_pds, undef_eps;

      MCH_get_undef(isec1, &undef_pds, &undef_eps);
      FSEC3_MissVal = undef_pds;
      *lmv = 1;
    }
}


void cgribexScanTimestep1(int streamID)
{
  static char func[] = "cgribexScanTimestep1";
  int *isec0, *isec1, *isec2, *isec3, *isec4;
  double fsec2[512], fsec3[2], *fsec4 = NULL;
  int lmv = 0;
  off_t recpos = 0;
  unsigned char *gribbuffer = NULL;
  long buffersize = 0;
  int status;
  int fileID;
  int param = 0;
  int level1 = 0, level2 = 0, vdate = 0, vtime = 0;
  DateTime datetime, datetime0;
  int tsID;
  int varID;
  size_t readsize;
  int nrecords, nrecs, recID;
  int prec;
  long recsize = 0;
  int warn_time = TRUE;
  int warn_numavg = TRUE;
  int taxisID = -1;
  int rdate = 0, rtime = 0, tunit = 0, fcast = 0;
  taxis_t *taxis;
  int vlistID;
  int ztype;
  long unzipsize;
  compvar_t compVar, compVar0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->curTsID = 0;

  isec0 = streamptr->record->sec0;
  isec1 = streamptr->record->sec1;
  isec2 = streamptr->record->sec2;
  isec3 = streamptr->record->sec3;
  isec4 = streamptr->record->sec4;

  tsID  = tstepsNewEntry(streamID);
  taxis = &streamptr->tsteps[tsID].taxis;

  if ( tsID != 0 )
    Error(func, "Internal problem! tstepsNewEntry returns %d", tsID);

  fileID = streamInqFileID(streamID);

  nrecs = 0;
  while ( TRUE )
    {
      recsize = gribGetSize(fileID);
      recpos  = fileGetPos(fileID);

      if ( recsize == 0 )
	{
	  streamptr->ntsteps = 1;
	  break;
	}
      if ( recsize > buffersize )
	{
	  buffersize = recsize;
	  gribbuffer = (unsigned char *) realloc(gribbuffer, buffersize);
	}

      readsize = recsize;
      status = gribRead(fileID, gribbuffer, &readsize);
      if ( status ) break;

      ztype = COMPRESS_NONE;
      if ( gribGetZip(recsize, gribbuffer, &unzipsize) > 0 )
	{
	  ztype = COMPRESS_SZIP;
	  unzipsize += 100; /* need 0 to 1 bytes for rounding of bds */
	  if ( (long) buffersize < unzipsize )
	    {
	      buffersize = unzipsize;
	      gribbuffer = (unsigned char *) realloc(gribbuffer, buffersize);
	    }
	}

      cgribexDecodeHeader(isec0, isec1, isec2, fsec2, isec3, fsec3, isec4, fsec4,
			  (int *) gribbuffer, recsize, &lmv);

      param = cdiEncodeParam(ISEC1_Parameter, ISEC1_CodeTable, 255);
      if ( ISEC1_LevelType == 100 ) ISEC1_Level1 *= 100;
      if ( ISEC1_LevelType ==  99 ) ISEC1_LevelType = 100;
      level1   = ISEC1_Level1;
      level2   = ISEC1_Level2;

      gribDateTime(isec1, &vdate, &vtime);

      if ( ISEC4_NumBits > 0 && ISEC4_NumBits <= 32 )
	prec = ISEC4_NumBits;
      else
        prec = DATATYPE_PACK;

      if ( nrecs == 0 )
	{
	  datetime0.date = vdate;
	  datetime0.time = vtime;
	  rdate = gribRefDate(isec1);
	  rtime = gribRefTime(isec1);
	  tunit = cgribexGetTimeUnit(isec1);
	  fcast = cgribexTimeIsFC(isec1);
	}
      else
	{
	  datetime.date  = vdate;
	  datetime.time  = vtime;
	  compVar.param  = param;
          compVar.level1 = level1;
          compVar.level2 = level2;
          compVar.ltype  = ISEC1_LevelType;
	  for ( recID = 0; recID < nrecs; recID++ )
	    {
	      compVar0.param  = streamptr->tsteps[0].records[recID].param;
	      compVar0.level1 = streamptr->tsteps[0].records[recID].ilevel;
	      compVar0.level2 = streamptr->tsteps[0].records[recID].ilevel2;
	      compVar0.ltype  = streamptr->tsteps[0].records[recID].ltype;

	      if ( memcmp(&compVar0, &compVar, sizeof(compvar_t)) == 0 ) break;
	    }

	  if ( cdiInventoryMode == 1 )
	    {
	      if ( recID < nrecs ) break;
	      if ( warn_time )
		if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) != 0 )
		  {
		    char paramstr[32];
		    cdiParamToString(param, paramstr, sizeof(paramstr));
		    Warning(func, "Inconsistent verification time (param=%s level=%d)", paramstr, level1);
		    warn_time = FALSE;
		  }
	    }
	  else
	    {
	      if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) != 0 ) break;

	      if ( recID < nrecs )
		{
		  char paramstr[32];
		  cdiParamToString(param, paramstr, sizeof(paramstr));
		  Warning(func, "Param=%s level=%d already exist, skipped!", paramstr, level1);
		  continue;
		}
	    }
	}

      if ( ISEC1_AvgNum )
	{
	  if (  taxis->numavg && warn_numavg && (taxis->numavg != ISEC1_AvgNum) )
	    {
	      Message(func, "Change numavg from %d to %d not allowed!",
		      taxis->numavg, ISEC1_AvgNum);
	      warn_numavg = FALSE;
	    }
	  else
	    {
	      taxis->numavg = ISEC1_AvgNum;
	    }
	}

      nrecs++;

      if ( CDI_Debug )
	Message(func, "%4d %8d %4d  %8d %8d %6d", nrecs, (int)recpos, param, level1, vdate, vtime);

      cgribexAddRecord(streamID, param, isec1, isec2, fsec2, fsec3,
		       isec4, recsize, recpos, prec, ztype, lmv);
    }

  streamptr->rtsteps = 1;

  cdiGenVars(streamID);

  if ( fcast )
    {
      taxisID = taxisCreate(TAXIS_RELATIVE);
      taxis->type  = TAXIS_RELATIVE;
      taxis->rdate = rdate;
      taxis->rtime = rtime;
      taxis->unit  = tunit;
    }
  else
    {
      taxisID = taxisCreate(TAXIS_ABSOLUTE);
      taxis->type  = TAXIS_ABSOLUTE;
      taxis->unit  = tunit;
    }

  taxis->vdate = datetime0.date;
  taxis->vtime = datetime0.time;

  vlistID = streamInqVlist(streamID);
  vlistDefTaxis(vlistID, taxisID);

  nrecords = streamptr->tsteps[0].nallrecs;
  if ( nrecords < streamptr->tsteps[0].recordSize )
    {
      streamptr->tsteps[0].recordSize = nrecords;
      streamptr->tsteps[0].records =
      (record_t *) realloc(streamptr->tsteps[0].records, nrecords*sizeof(record_t));
    }

  streamptr->tsteps[0].recIDs = (int *) malloc(nrecords*sizeof(int));
  streamptr->tsteps[0].nrecs = nrecords;
  for ( recID = 0; recID < nrecords; recID++ )
    streamptr->tsteps[0].recIDs[recID] = recID;

  streamptr->record->buffer     = gribbuffer;
  streamptr->record->buffersize = buffersize;

  if ( streamptr->ntsteps == -1 )
    {
      tsID = tstepsNewEntry(streamID);
      if ( tsID != streamptr->rtsteps )
	Error(func, "Internal error. tsID = %d", tsID);

      streamptr->tsteps[tsID-1].next   = TRUE;
      streamptr->tsteps[tsID].position = recpos;
    }

  if ( streamptr->ntsteps == 1 )
    {
      if ( taxis->vdate == 0 && taxis->vtime == 0 )
	{
	  streamptr->ntsteps = 0;
	  for ( varID = 0; varID < streamptr->nvars; varID++ )
	    {
	      vlistDefVarTime(vlistID, varID, TIME_CONSTANT);
	    }
	}
    }
}


int cgribexScanTimestep2(int streamID)
{
  static char func[] = "cgribexScanTimestep2";
  int *isec0, *isec1, *isec2, *isec3, *isec4;
  double fsec2[512], fsec3[2], *fsec4 = NULL;
  int lmv = 0;
  off_t recpos = 0;
  unsigned char *gribbuffer = NULL;
  long buffersize = 0;
  int status;
  int fileID;
  int param = 0;
  int level1 = 0, level2 = 0, vdate = 0, vtime = 0;
  DateTime datetime, datetime0;
  int tsID;
  int varID, gridID;
  size_t readsize;
  int nrecords, nrecs, recID, rindex;
  long recsize = 0;
  int warn_numavg = TRUE;
  int tsteptype;
  int taxisID = -1;
  taxis_t *taxis;
  int vlistID;
  long unzipsize;
  compvar_t compVar, compVar0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->curTsID = 1;

  isec0 = streamptr->record->sec0;
  isec1 = streamptr->record->sec1;
  isec2 = streamptr->record->sec2;
  isec3 = streamptr->record->sec3;
  isec4 = streamptr->record->sec4;

  fileID  = streamInqFileID(streamID);
  vlistID = streamInqVlist(streamID);
  taxisID = vlistInqTaxis(vlistID);

  gribbuffer = (unsigned char *) streamptr->record->buffer;
  buffersize = streamptr->record->buffersize;
                                          
  tsID = streamptr->rtsteps;
  if ( tsID != 1 )
    Error(func, "Internal problem! unexpeceted timestep %d", tsID+1);

  taxis = &streamptr->tsteps[tsID].taxis;

  fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);

  cdiCreateRecords(streamID, tsID);

  nrecords = streamptr->tsteps[tsID].nallrecs;
  streamptr->tsteps[1].recIDs = (int *) malloc(nrecords*sizeof(int));
  streamptr->tsteps[1].nrecs = 0;
  for ( recID = 0; recID < nrecords; recID++ )
    streamptr->tsteps[1].recIDs[recID] = -1;
      
  for ( recID = 0; recID < nrecords; recID++ )
    {
      varID = streamptr->tsteps[0].records[recID].varID;
      streamptr->tsteps[tsID].records[recID].position = 
	streamptr->tsteps[0].records[recID].position;
      streamptr->tsteps[tsID].records[recID].size     = 
	streamptr->tsteps[0].records[recID].size;
    }

  rindex = 0;
  while ( TRUE )
    {
      if ( rindex > nrecords ) break;

      recsize = gribGetSize(fileID);
      recpos  = fileGetPos(fileID);
      if ( recsize == 0 )
	{
	  streamptr->ntsteps = 2;
	  break;
	}
      if ( recsize > buffersize )
	{
	  buffersize = recsize;
	  gribbuffer = (unsigned char *) realloc(gribbuffer, (size_t)buffersize);
	}

      readsize = recsize;
      status = gribRead(fileID, gribbuffer, &readsize);
      if ( status ) break;

      if ( gribGetZip(recsize, gribbuffer, &unzipsize) > 0 )
	{
	  unzipsize += 100; /* need 0 to 1 bytes for rounding of bds */
	  if ( (long) buffersize < unzipsize )
	    {
	      buffersize = unzipsize;
	      gribbuffer = (unsigned char *) realloc(gribbuffer, buffersize);
	    }
	}

      cgribexDecodeHeader(isec0, isec1, isec2, fsec2, isec3, fsec3, isec4, fsec4,
			  (int *) gribbuffer, recsize, &lmv);

      param = cdiEncodeParam(ISEC1_Parameter, ISEC1_CodeTable, 255);
      if ( ISEC1_LevelType == 100 ) ISEC1_Level1 *= 100;
      if ( ISEC1_LevelType ==  99 ) ISEC1_LevelType = 100;
      level1    = ISEC1_Level1;
      level2    = ISEC1_Level2;

      gribDateTime(isec1, &vdate, &vtime);

      if ( rindex == 0 )
	{
	  if ( taxisInqType(taxisID) == TAXIS_RELATIVE )
	    {
	      taxis->type  = TAXIS_RELATIVE;
	      taxis->rdate = gribRefDate(isec1);
	      taxis->rtime = gribRefTime(isec1);
	    }
	  else
	    {
	      taxis->type  = TAXIS_ABSOLUTE;
	    }
	  taxis->unit  = cgribexGetTimeUnit(isec1);
	  taxis->vdate = vdate;
	  taxis->vtime = vtime;

	  datetime0.date = vdate;
	  datetime0.time = vtime;
	}

      tsteptype = cgribexGetTsteptype(ISEC1_TimeRange);

      if ( ISEC1_AvgNum )
	{
	  if (  taxis->numavg && warn_numavg &&
		(taxis->numavg != ISEC1_AvgNum) )
	    {
	  /*
	      Message(func, "change numavg from %d to %d not allowed!",
		      taxis->numavg, ISEC1_AvgNum);
	  */
	      warn_numavg = FALSE;
	    }
	  else
	    {
	      taxis->numavg = ISEC1_AvgNum;
	    }
	}

      datetime.date  = vdate;
      datetime.time  = vtime;
      compVar.param  = param;
      compVar.level1 = level1;
      compVar.level2 = level2;
      compVar.ltype  = ISEC1_LevelType;
      for ( recID = 0; recID < nrecords; recID++ )
	{
	  compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
	  compVar0.level1 = streamptr->tsteps[tsID].records[recID].ilevel;
	  compVar0.level2 = streamptr->tsteps[tsID].records[recID].ilevel2;
	  compVar0.ltype  = streamptr->tsteps[tsID].records[recID].ltype;

	  if ( memcmp(&compVar0, &compVar, sizeof(compvar_t)) == 0 ) break;
	}

      if ( recID == nrecords )
	{
	  char paramstr[32];
	  cdiParamToString(param, paramstr, sizeof(paramstr));
	  Warning(func, "Param=%s level=%d not defined at timestep 1!", paramstr, level1);
	  return (CDI_EUFSTRUCT);
	}

      if ( cdiInventoryMode == 1 )
	{
	  if ( streamptr->tsteps[tsID].records[recID].used )
	    {
	      break;
	    }
	  else
	    {
	      streamptr->tsteps[tsID].records[recID].used = TRUE;
	      streamptr->tsteps[tsID].recIDs[rindex] = recID;
	    }    
	}
      else
	{
	  if ( streamptr->tsteps[tsID].records[recID].used )
	    {
	      char paramstr[32];
	      cdiParamToString(param, paramstr, sizeof(paramstr));

	      if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) != 0 ) break;

	      Warning(func, "Param=%s level=%d already exist, skipped!", paramstr, level1);
	      continue;
	    }
	  else
	    {
	      streamptr->tsteps[tsID].records[recID].used = TRUE;
	      streamptr->tsteps[tsID].recIDs[rindex] = recID;
	    }    
	}

      if ( CDI_Debug )
	Message(func, "%4d %8d %4d %8d %8d %6d", rindex+1, (int)recpos, param, level1, vdate, vtime);

      streamptr->tsteps[tsID].records[recID].size = recsize;

      compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
      compVar0.level1 = streamptr->tsteps[tsID].records[recID].ilevel;
      compVar0.level2 = streamptr->tsteps[tsID].records[recID].ilevel2;
      compVar0.ltype  = streamptr->tsteps[tsID].records[recID].ltype;

      if ( memcmp(&compVar0, &compVar, sizeof(compvar_t)) != 0 )
	{
	  Message(func, "tsID = %d recID = %d param = %3d new %3d  level = %3d new %3d",
		  tsID, recID,
		  streamptr->tsteps[tsID].records[recID].param, param,
		  streamptr->tsteps[tsID].records[recID].ilevel, level1);
	  return (CDI_EUFSTRUCT);
	}

      streamptr->tsteps[1].records[recID].position = recpos;
      varID = streamptr->tsteps[tsID].records[recID].varID;
      gridID = vlistInqVarGrid(vlistID, varID);
      if ( gridInqSize(gridID) == 1 && gridInqType(gridID) == GRID_LONLAT )
	{
	  if ( IS_NOT_EQUAL(gridInqXval(gridID, 0),ISEC2_FirstLon*0.001) ||
	       IS_NOT_EQUAL(gridInqYval(gridID, 0),ISEC2_FirstLat*0.001) )
	    gridChangeType(gridID, GRID_TRAJECTORY);
	}

      if ( tsteptype != vlistInqVarTsteptype(vlistID, varID) )
	vlistDefVarTsteptype(vlistID, varID, tsteptype);

      rindex++;
    }

  nrecs = 0;
  for ( recID = 0; recID < nrecords; recID++ )
    {
      if ( ! streamptr->tsteps[tsID].records[recID].used )
	{
	  varID = streamptr->tsteps[tsID].records[recID].varID;
	  vlistDefVarTime(vlistID, varID, TIME_CONSTANT);
	}
      else
	{
	  nrecs++;
	}
    }
  streamptr->tsteps[tsID].nrecs = nrecs;

  streamptr->rtsteps = 2;

  if ( streamptr->ntsteps == -1 )
    {
      tsID = tstepsNewEntry(streamID);
      if ( tsID != streamptr->rtsteps )
	Error(func, "Internal error. tsID = %d", tsID);

      streamptr->tsteps[tsID-1].next   = TRUE;
      streamptr->tsteps[tsID].position = recpos;
    }

  streamptr->record->buffer     = gribbuffer;
  streamptr->record->buffersize = buffersize;

  return (0);
}


int cgribexScanTimestep(int streamID)
{
  static char func[] = "cgribexScanTimestep";
  int *isec0, *isec1, *isec2, *isec3, *isec4;
  double fsec2[512], fsec3[2], *fsec4 = NULL;
  int lmv = 0;
  long recsize = 0;
  off_t recpos = 0;
  unsigned char *gribbuffer;
  long buffersize = 0;
  int status;
  int fileID;
  int param = 0;
  int level1 = 0, level2 = 0, vdate = 0, vtime = 0;
  DateTime datetime, datetime0;
  int tsID;
  int vrecID, recID;
  int warn_numavg = TRUE;
  size_t readsize;
  int taxisID = -1;
  taxis_t *taxis;
  int vlistID;
  int rindex, nrecs = 0;
  long unzipsize;
  compvar_t compVar, compVar0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);

  if ( CDI_Debug )
    {
      Message(func, "streamID = %d", streamID);
      Message(func, "cts = %d", streamptr->curTsID);
      Message(func, "rts = %d", streamptr->rtsteps);
      Message(func, "nts = %d", streamptr->ntsteps);
    }

  isec0 = streamptr->record->sec0;
  isec1 = streamptr->record->sec1;
  isec2 = streamptr->record->sec2;
  isec3 = streamptr->record->sec3;
  isec4 = streamptr->record->sec4;

  tsID  = streamptr->rtsteps;
  taxis = &streamptr->tsteps[tsID].taxis;

  if ( streamptr->tsteps[tsID].recordSize == 0 )
    {
      gribbuffer = (unsigned char *) streamptr->record->buffer;
      buffersize = streamptr->record->buffersize;

      cdiCreateRecords(streamID, tsID);

      nrecs = streamptr->tsteps[1].nrecs;

      streamptr->tsteps[tsID].nrecs = nrecs;
      streamptr->tsteps[tsID].recIDs = (int *) malloc(nrecs*sizeof(int));
      for ( recID = 0; recID < nrecs; recID++ )
	streamptr->tsteps[tsID].recIDs[recID] = streamptr->tsteps[1].recIDs[recID];

      fileID = streamInqFileID(streamID);

      fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);

      rindex = 0;
      while ( TRUE )
	{
	  if ( rindex > nrecs ) break;

	  recsize = gribGetSize(fileID);
	  recpos  = fileGetPos(fileID);
	  if ( recsize == 0 )
	    {
	      streamptr->ntsteps = streamptr->rtsteps + 1;
	      break;
	    }
	  if ( recsize > buffersize )
	    {
	      buffersize = recsize;
	      gribbuffer = (unsigned char *) realloc(gribbuffer, buffersize);
	    }

	  readsize = recsize;
	  status = gribRead(fileID, gribbuffer, &readsize);
	  if ( status )
	    {
	      Error(func, "Inconsistent timestep %d (GRIB record %d/%d)!\n", tsID+1, rindex+1,
		    streamptr->tsteps[tsID].recordSize);
	      break;
	    }

	  if ( gribGetZip(recsize, gribbuffer, &unzipsize) > 0 )
	    {
	      unzipsize += 100; /* need 0 to 1 bytes for rounding of bds */
	      if ( (long) buffersize < unzipsize )
		{
		  buffersize = unzipsize;
		  gribbuffer = (unsigned char *) realloc(gribbuffer, buffersize);
		}
	    }

	  cgribexDecodeHeader(isec0, isec1, isec2, fsec2, isec3, fsec3, isec4, fsec4,
			      (int *) gribbuffer, recsize, &lmv);

	  param = cdiEncodeParam(ISEC1_Parameter, ISEC1_CodeTable, 255);
	  if ( ISEC1_LevelType == 100 ) ISEC1_Level1 *= 100;
	  if ( ISEC1_LevelType ==  99 ) ISEC1_LevelType = 100;
	  level1   = ISEC1_Level1;
	  level2   = ISEC1_Level2;

	  gribDateTime(isec1, &vdate, &vtime);

	  if ( rindex == nrecs ) break;

	  if ( rindex == 0 )
	    {
	      taxisID = vlistInqTaxis(vlistID);
	      if ( taxisInqType(taxisID) == TAXIS_RELATIVE )
		{
		  taxis->type  = TAXIS_RELATIVE;
		  taxis->rdate = gribRefDate(isec1);
		  taxis->rtime = gribRefTime(isec1);
		}
	      else
		{
		  taxis->type  = TAXIS_ABSOLUTE;
		}
	      taxis->unit  = cgribexGetTimeUnit(isec1);
	      taxis->vdate = vdate;
	      taxis->vtime = vtime;

	      datetime0.date = vdate;
	      datetime0.time = vtime;
	    }

	  if ( ISEC1_AvgNum )
	    {
	      if (  taxis->numavg && warn_numavg &&
		   (taxis->numavg != ISEC1_AvgNum) )
		{
	      /*
		  Message(func, "Change numavg from %d to %d not allowed!",
			  streamptr->tsteps[tsID].taxis.numavg, ISEC1_AvgNum);
	      */
		  warn_numavg = FALSE;
		}
	      else
		{
		  taxis->numavg = ISEC1_AvgNum;
		}
	    }
	  
	  datetime.date  = vdate;
	  datetime.time  = vtime;
	  compVar.param  = param;
          compVar.level1 = level1;
          compVar.level2 = level2;
          compVar.ltype  = ISEC1_LevelType;
	  for ( vrecID = 0; vrecID < nrecs; vrecID++ )
	    {
	      recID   = streamptr->tsteps[1].recIDs[vrecID];
	      compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
	      compVar0.level1 = streamptr->tsteps[tsID].records[recID].ilevel;
	      compVar0.level2 = streamptr->tsteps[tsID].records[recID].ilevel2;
	      compVar0.ltype  = streamptr->tsteps[tsID].records[recID].ltype;

	      if ( memcmp(&compVar0, &compVar, sizeof(compvar_t)) == 0 ) break;
	    }

	  if ( vrecID == nrecs )
	    {
	      char paramstr[32];
	      cdiParamToString(param, paramstr, sizeof(paramstr));
	      Warning(func, "Param=%s level=%d not available at timestep %d!", paramstr, level1, tsID+1);

	      if ( cdiInventoryMode == 1 )
		return (CDI_EUFSTRUCT);
	      else
		continue;
	    }

	  if ( cdiInventoryMode == 1 )
	    {
	      streamptr->tsteps[tsID].records[recID].used = TRUE;
	      streamptr->tsteps[tsID].recIDs[rindex] = recID;
	    }
	  else
	    {
	      if ( streamptr->tsteps[tsID].records[recID].used )
		{
		  char paramstr[32];
		  cdiParamToString(param, paramstr, sizeof(paramstr));

		  if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) != 0 ) break;
		  
		  if ( CDI_Debug )
		    Warning(func, "Param=%s level=%d already exist, skipped!", paramstr, level1);

		  continue;
		}
	      else
		{
		  streamptr->tsteps[tsID].records[recID].used = TRUE;
		  streamptr->tsteps[tsID].recIDs[rindex] = recID;
		}    
	    }

	  if ( CDI_Debug )
	    Message(func, "%4d %8d %4d %8d %8d %6d", rindex+1, (int)recpos, param, level1, vdate, vtime);

	  compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
	  compVar0.level1 = streamptr->tsteps[tsID].records[recID].ilevel;
	  compVar0.level2 = streamptr->tsteps[tsID].records[recID].ilevel2;
	  compVar0.ltype  = streamptr->tsteps[tsID].records[recID].ltype;

	  if ( memcmp(&compVar0, &compVar, sizeof(compvar_t)) != 0 )
	    {
	      Message(func, "tsID = %d recID = %d param = %3d new %3d  level = %3d new %3d",
		      tsID, recID,
		      streamptr->tsteps[tsID].records[recID].param, param,
		      streamptr->tsteps[tsID].records[recID].ilevel, level1);
	      Error(func, "Invalid, unsupported or inconsistent record structure");
	    }
	  
	  streamptr->tsteps[tsID].records[recID].position = recpos;
	  streamptr->tsteps[tsID].records[recID].size = recsize;

	  if ( CDI_Debug )
	    Message(func, "%4d %8d %4d %8d %8d %6d", rindex, (int)recpos, param, level1, vdate, vtime);

	  rindex++;
	}

      for ( vrecID = 0; vrecID < nrecs; vrecID++ )
	{
	  recID   = streamptr->tsteps[tsID].recIDs[vrecID];
	  if ( ! streamptr->tsteps[tsID].records[recID].used ) break;
	}

      if ( vrecID < nrecs )
	{
	  char paramstr[32];
	  cdiParamToString(streamptr->tsteps[tsID].records[recID].param, paramstr, sizeof(paramstr));
	  Warning(func, "Param=%s level=%d not found at timestep %d!",
		  paramstr, streamptr->tsteps[tsID].records[recID].ilevel, tsID+1);
	  return (CDI_EUFSTRUCT);
	}

      streamptr->rtsteps++;

      if ( streamptr->ntsteps != streamptr->rtsteps )
	{
	  tsID = tstepsNewEntry(streamID);
	  if ( tsID != streamptr->rtsteps )
	    Error(func, "Internal error. tsID = %d", tsID);

	  streamptr->tsteps[tsID-1].next   = 1;
	  streamptr->tsteps[tsID].position = recpos;
	}

      fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);
      streamptr->tsteps[tsID].position = recpos;

      streamptr->record->buffer     = gribbuffer;
      streamptr->record->buffersize = buffersize;
    }

  if ( nrecs > 0 && nrecs < streamptr->tsteps[tsID].nrecs )
    {
      Warning(func, "Incomplete timestep. Stop scanning at timestep %d.\n", tsID);
      streamptr->ntsteps = tsID;
    }

  return (streamptr->ntsteps);
}


int cgribexDecode(unsigned char *gribbuffer, int gribsize, double *data, int gridsize,
		  int unreduced, int *nmiss, int *zip, double missval)
{
  static char func[] = "cgribexDecode";
  int status = 0;
#if  defined  (HAVE_LIBCGRIBEX)
  int iret = 0, iword = 0;
  int isec0[2], isec1[4096], isec2[4096], isec3[2], isec4[512];
  int izip;
  long unzipsize;
  double fsec2[512], fsec3[2];
  char hoper[2];

  *zip = 0;

  if ( unreduced ) strcpy(hoper, "R");
  else             strcpy(hoper, "D");

  FSEC3_MissVal = missval;

  if ( (izip = gribGetZip(gribsize, gribbuffer, &unzipsize)) > 0 )
    {
      *zip = izip;
      if ( izip == 128 ) /* szip */
	{
	  unsigned char *itmpbuffer = NULL;
	  size_t itmpbuffersize = 0;

	  if ( unzipsize < (long) gribsize )
	    {
	      fprintf(stderr, "Decompressed size smaller than compressed size (in %d; out %ld)!\n",
		      gribsize, unzipsize);
	      return (status);
	    }

	  if ( itmpbuffersize < (size_t) gribsize )
	    {
	      itmpbuffersize = gribsize;
	      itmpbuffer = (unsigned char *) realloc(itmpbuffer, itmpbuffersize);
	    }

	  memcpy(itmpbuffer, gribbuffer, itmpbuffersize);

	  unzipsize += 100; /* need 0 to 1 bytes for rounding of bds */

	  gribsize = gribUnzip(gribbuffer, unzipsize, itmpbuffer, gribsize);

	  if ( gribsize <= 0 )
	    Error(func, "Decompression problem!\n");
	  
	  free(itmpbuffer);
	}
      else
	{
	  Error(func, "Decompression for %d not implemented!\n", izip);
	}
    }

  gribExDP(isec0, isec1, isec2, fsec2, isec3, fsec3, isec4, data,
	   gridsize, (int *) gribbuffer, gribsize, &iword, hoper, &iret);

  if ( ISEC1_Sec2Or3Flag & 64 )
    *nmiss = ISEC4_NumValues - ISEC4_NumNonMissValues;
  else
    *nmiss = 0;

  if ( ISEC1_CenterID == 215 && (isec1[34] != 0 && isec1[34] != 255) )
    {
      double undef_pds, undef_eps;
      int i;

      MCH_get_undef(isec1, &undef_pds, &undef_eps);

      *nmiss = 0;
      for ( i = 0; i < gridsize; i++ )
        if ( (abs(data[i]-undef_pds) < undef_eps) || IS_EQUAL(data[i],FSEC3_MissVal) ) {
          data[i] = missval;
          (*nmiss)++;
        }
    }
#else
  Error(func, "CGRIBEX support not compiled in!");
#endif

  return (status);
}


#if  defined  (HAVE_LIBCGRIBEX)
static
void cgribexDefInstitut(int *isec1, int vlistID, int varID)
{
  int instID;

  if ( vlistInqInstitut(vlistID) != CDI_UNDEFID )
    instID = vlistInqInstitut(vlistID);
  else
    instID = vlistInqVarInstitut(vlistID, varID);

  if ( instID != CDI_UNDEFID )
    {
      int center, subcenter;
      center    = institutInqCenter(instID);
      subcenter = institutInqSubcenter(instID);
      ISEC1_CenterID    = center;
      ISEC1_SubCenterID = subcenter;
    }
}

static
void cgribexDefModel(int *isec1, int vlistID, int varID)
{
  int modelID;

  if ( vlistInqModel(vlistID) != CDI_UNDEFID )
    modelID = vlistInqModel(vlistID);
  else
    modelID = vlistInqVarModel(vlistID, varID);

  if ( modelID != CDI_UNDEFID )
    ISEC1_ModelID = modelInqGribID(modelID);
}

static
void cgribexDefParam(int *isec1, int param)
{
  static char func[] = "cgribexDefParam";
  int pdis, pcat, pnum;
  static int lwarn = TRUE;

  cdiDecodeParam(param, &pnum, &pcat, &pdis);

  if ( pdis != 255 && lwarn )
    {
      char paramstr[32];
      cdiParamToString(param, paramstr, sizeof(paramstr));
      Warning(func, "Can not convert GRIB2 parameter (%s) to GRIB1!", paramstr);
      lwarn = FALSE;
    }
    
  if ( pnum < 0 ) pnum = -pnum;

  ISEC1_CodeTable = pcat;
  ISEC1_Parameter = pnum;
}

static
int cgribexDefTimerange(int tsteptype, int factor, int calendar,
			int rdate, int rtime, int vdate, int vtime, int *pip1, int *pip2)
{
  int timerange = -1;
  int year, month, day, hour, minute, second;
  int julday1, secofday1, julday2, secofday2, days, secs;
  int ip, ip1 = 0, ip2 = 0;

  cdiDecodeDate(rdate, &year, &month, &day);
  cdiDecodeTime(rtime, &hour, &minute, &second);
  encode_juldaysec(calendar, year, month, day, hour, minute, &julday1, &secofday1);

  cdiDecodeDate(vdate, &year, &month, &day);
  cdiDecodeTime(vtime, &hour, &minute, &second);
  encode_juldaysec(calendar, year, month, day, hour, minute, &julday2, &secofday2);
  
  (void) julday_sub(julday1, secofday1, julday2, secofday2, &days, &secs);

  if ( !(int) fmod(days*86400.0 + secs, factor) )
    {
      ip = (int) ((days*86400.0 + secs)/factor);

      switch ( tsteptype )
	{
	case TSTEP_INSTANT:  timerange =  0; ip1 = ip; ip2 = 0;  break;
	case TSTEP_INSTANT2: timerange =  1; ip1 = 0;  ip2 = 0;  break;
	case TSTEP_RANGE:    timerange =  2; ip1 = 0;  ip2 = ip; break;
	case TSTEP_AVG:      timerange =  3; ip1 = 0;  ip2 = ip; break;
	case TSTEP_ACCUM:    timerange =  4; ip1 = 0;  ip2 = ip; break;
	case TSTEP_DIFF:     timerange =  5; ip1 = 0;  ip2 = ip; break;
	case TSTEP_INSTANT3:
	default:             timerange = 10; ip1 = ip/256; ip2 = ip%256;  break;
	}
    }

  *pip1 = ip1;
  *pip2 = ip2;

  return (timerange);
}

static
int cgribexDefDateTime(int *isec1, int timeunit, int date, int time)
{
  int year, month, day, hour, minute, second;
  int century = 0;
  int factor = 1;

  cdiDecodeDate(date, &year, &month, &day);
  cdiDecodeTime(time, &hour, &minute, &second);

  century =  year / 100;

  ISEC1_Year = year - century*100;
  
  if ( year < 0 )
    {
      century = -century;
      ISEC1_Year = -ISEC1_Year;
    }

  if ( ISEC1_Year == 0 )
    {
      ISEC1_Year = 100;
      century -= 1;
    }

  century += 1;
  if ( year < 0 ) century = -century;

  ISEC1_Month  = month;
  ISEC1_Day    = day;
  ISEC1_Hour   = hour;
  ISEC1_Minute = minute;

  ISEC1_Century = century;

  switch (timeunit)
    {
    case TUNIT_MINUTE:  factor =    60; ISEC1_TimeUnit = ISEC1_TABLE4_MINUTE;  break;
    case TUNIT_QUARTER: factor =   900; ISEC1_TimeUnit = ISEC1_TABLE4_QUARTER; break;
    case TUNIT_HOUR:    factor =  3600; ISEC1_TimeUnit = ISEC1_TABLE4_HOUR;    break;
    case TUNIT_3HOURS:  factor = 10800; ISEC1_TimeUnit = ISEC1_TABLE4_3HOURS;  break;
    case TUNIT_6HOURS:  factor = 21600; ISEC1_TimeUnit = ISEC1_TABLE4_6HOURS;  break;
    case TUNIT_12HOURS: factor = 43200; ISEC1_TimeUnit = ISEC1_TABLE4_12HOURS; break;
    case TUNIT_DAY:     factor = 86400; ISEC1_TimeUnit = ISEC1_TABLE4_DAY;     break;
    default:            factor =  3600; ISEC1_TimeUnit = ISEC1_TABLE4_HOUR;    break;
    }

  return (factor);
}

static
void cgribexDefTime(int *isec1, int vdate, int vtime, int tsteptype, int numavg, int taxisID)
{
  int timetype = -1;
  int timerange = 0;
  int timeunit;

  if ( taxisID != -1 ) timetype = taxisInqType(taxisID);

  timeunit = taxisInqTunit(taxisID);

  if ( timetype == TAXIS_RELATIVE )
    {
      int factor = 1;
      int rdate, rtime;
      int ip1 = 0, ip2 = 0;
      int calendar;
      
      calendar = taxisInqCalendar(taxisID);
      rdate    = taxisInqRdate(taxisID);
      rtime    = taxisInqRtime(taxisID);

      factor = cgribexDefDateTime(isec1, timeunit, rdate, rtime);
      
      timerange = cgribexDefTimerange(tsteptype, factor, calendar,
				      rdate, rtime, vdate, vtime, &ip1, &ip2);

      if ( timerange == -1 || timerange == 3 )
	{
	  timetype = TAXIS_ABSOLUTE;
	}
      /*
      else if ( timerange == 10 )
	{
	  if ( ip1 < 0 || ip1 > 0xFFFF ) timetype = TAXIS_ABSOLUTE;
	  if ( ip2 < 0 || ip2 > 0xFFFF ) timetype = TAXIS_ABSOLUTE;
	}
      */
      else
	{
	  if ( ip1 < 0 || ip1 > 0xFF   ) timetype = TAXIS_ABSOLUTE;
	  if ( ip2 < 0 || ip2 > 0xFF   ) timetype = TAXIS_ABSOLUTE;
	}
      
      ISEC1_TimeRange   = timerange;
      ISEC1_TimePeriod1 = ip1;
      ISEC1_TimePeriod2 = ip2;
    }

  if ( timetype == TAXIS_ABSOLUTE )
    {
      (void) cgribexDefDateTime(isec1, timeunit, vdate, vtime);

      /*
      if ( numavg > 0 )
	ISEC1_TimeRange = 0;
      else
      */
      if ( ISEC1_TimeRange != 3 )
	ISEC1_TimeRange   = 10;

      ISEC1_TimePeriod1 = 0;
      ISEC1_TimePeriod2 = 0;
    }

  ISEC1_AvgNum         = numavg;
  ISEC1_AvgMiss        = 0;
  ISEC1_DecScaleFactor = 0;
}

static
void cgribexDefGrid(int *isec1, int *isec2, int *isec4, int gridID)
{
  static char func[] = "cgribexDefGrid";
  int gridtype;
  static short lwarn = TRUE;

  memset(isec2, 0, 16*sizeof(int));

  ISEC1_Sec2Or3Flag = 128;
  
  gridtype = gridInqType(gridID);

  ISEC1_GridDefinition = 255;

  if ( gridtype == GRID_GENERIC )
    {
      int xsize, ysize;

      xsize = gridInqXsize(gridID);
      ysize = gridInqYsize(gridID);

      if ( (ysize == 32  || ysize == 48 || ysize == 64 ||
	    ysize == 96  || ysize == 160) && 
	   (xsize == 2*ysize || xsize == 1) )
	{
	  gridtype = GRID_GAUSSIAN;
	  gridChangeType(gridID, gridtype);
	}
      else if ( (xsize == 1 && ysize == 1) || (xsize == 0 && ysize == 0) )
	{
	  gridtype = GRID_LONLAT;
	  gridChangeType(gridID, gridtype);
	}
      else if ( gridInqXvals(gridID, NULL) && gridInqYvals(gridID, NULL) )
	{
	  gridtype = GRID_LONLAT;
	  gridChangeType(gridID, gridtype);
	}
    }
  else if ( gridtype == GRID_CURVILINEAR )
    {
      if ( lwarn )
	{
	  lwarn = FALSE;
	  Warning(func, "Curvilinear grids are unsupported in GRIB format! Created wrong GDS!");
	}
      gridtype = GRID_LONLAT;
    }

  ISEC2_Reduced = FALSE;

  ISEC2_ScanFlag = 0;

  switch (gridtype)
    {
    case GRID_LONLAT:
    case GRID_GAUSSIAN:
    case GRID_GAUSSIAN_REDUCED:
    case GRID_TRAJECTORY:
      {
	int nlon = 0, nlat;
	double xfirst = 0, xlast = 0, xinc = 0;
	double yfirst = 0, ylast = 0, yinc = 0;

	if ( gridtype == GRID_GAUSSIAN_REDUCED )
	  {
	    ISEC2_Reduced = TRUE;
	    nlon = 0;
	    gridInqRowlon(gridID, ISEC2_RowLonPtr);
	  }
	else
	  {
	    nlon = gridInqXsize(gridID);
	    if ( nlon == 0 )
	      {
		nlon = 1;
	      }
	    else
	      {
		xfirst = gridInqXval(gridID,      0);
		xlast  = gridInqXval(gridID, nlon-1);
		xinc   = gridInqXinc(gridID);
	      }
	  }

	nlat = gridInqYsize(gridID);
	if ( nlat == 0 )
	  {
	    nlat = 1;
	  }
	else
	  {
	    yfirst = gridInqYval(gridID,      0);
	    ylast  = gridInqYval(gridID, nlat-1);
	    yinc   = gridInqYinc(gridID);
	  }

	if ( gridtype == GRID_GAUSSIAN || gridtype == GRID_GAUSSIAN_REDUCED )
	  ISEC2_GridType = GTYPE_GAUSSIAN;
	else if ( gridtype == GRID_LONLAT && gridIsRotated(gridID) )
	  ISEC2_GridType = GTYPE_LATLON_ROT;
	else
	  ISEC2_GridType = GTYPE_LATLON;

	ISEC2_NumLon   = nlon;
	ISEC2_NumLat   = nlat;
	ISEC2_FirstLat = NINT(yfirst*1000);
	ISEC2_LastLat  = NINT(ylast*1000);
	if ( gridtype == GRID_GAUSSIAN_REDUCED )
	  {
	    ISEC2_FirstLon = 0;
	    ISEC2_LastLon  = NINT(1000*(360.-360./(nlat*2)));
	    ISEC2_LonIncr  = NINT(1000*360./(nlat*2));
	  }
	else
	  {
	    ISEC2_FirstLon = NINT(xfirst*1000);
	    ISEC2_LastLon  = NINT(xlast*1000);
	    ISEC2_LonIncr  = NINT(xinc*1000);
	  }
	if ( fabs(xinc*1000 - ISEC2_LonIncr) > FLT_EPSILON )
	  ISEC2_LonIncr = 0;

	if ( gridtype == GRID_GAUSSIAN || gridtype == GRID_GAUSSIAN_REDUCED )
	  ISEC2_NumPar = nlat/2;
	else
	  {
	    ISEC2_LatIncr = NINT(yinc*1000);
	    if ( fabs(yinc*1000 - ISEC2_LatIncr) > FLT_EPSILON )
	      ISEC2_LatIncr = 0;

	    if ( ISEC2_LatIncr < 0 ) ISEC2_LatIncr = -ISEC2_LatIncr;
	  }

	if ( ISEC2_NumLon > 1 && ISEC2_NumLat == 1 ) 
	  if ( ISEC2_LonIncr != 0 && ISEC2_LatIncr == 0 ) ISEC2_LatIncr = ISEC2_LonIncr;

	if ( ISEC2_NumLon == 1 && ISEC2_NumLat > 1 ) 
	  if ( ISEC2_LonIncr == 0 && ISEC2_LatIncr != 0 ) ISEC2_LonIncr = ISEC2_LatIncr;

	if ( ISEC2_LatIncr == 0 || ISEC2_LonIncr == 0 )
	  ISEC2_ResFlag = 0;
	else
	  ISEC2_ResFlag = 128;

	if ( gridIsRotated(gridID) )
	  {
	    ISEC2_LatSP = - NINT(gridInqYpole(gridID) * 1000);
	    ISEC2_LonSP =   NINT((gridInqXpole(gridID) + 180) * 1000);
	  }

	/* East -> West */
	if ( ISEC2_LastLon < ISEC2_FirstLon ) ISEC2_ScanFlag += 128;

	/* South -> North */
	if ( ISEC2_LastLat > ISEC2_FirstLat ) ISEC2_ScanFlag += 64;

	break;
      }
    case GRID_LCC:
      {
	double originLon, originLat, lonParY, lat1, lat2, xincm, yincm;
	int xsize, ysize;
	int projflag, scanflag;

	xsize = gridInqXsize(gridID);
	ysize = gridInqYsize(gridID);

	gridInqLCC(gridID, &originLon, &originLat, &lonParY, &lat1, &lat2, &xincm, &yincm,
		   &projflag, &scanflag);

	ISEC2_GridType = GTYPE_LCC;
	ISEC2_NumLon   = xsize;
	ISEC2_NumLat   = ysize;
	ISEC2_FirstLon = NINT(originLon * 1000);
	ISEC2_FirstLat = NINT(originLat * 1000);
	ISEC2_Lambert_Lov    = NINT(lonParY * 1000);
	ISEC2_Lambert_LatS1  = NINT(lat1 * 1000);
	ISEC2_Lambert_LatS2  = NINT(lat2 * 1000);
	ISEC2_Lambert_dx     = NINT(xincm);
	ISEC2_Lambert_dy     = NINT(yincm);
	ISEC2_Lambert_LatSP  = 0;
	ISEC2_Lambert_LatSP  = 0;
	ISEC2_Lambert_ProjFlag = projflag;
	ISEC2_ScanFlag = scanflag;

	break;
      }
    case GRID_SPECTRAL:
      {
	ISEC2_GridType = GTYPE_SPECTRAL;
	ISEC2_PentaJ   = gridInqTrunc(gridID);
	ISEC2_PentaK   = ISEC2_PentaJ;
	ISEC2_PentaM   = ISEC2_PentaJ;
	ISEC2_RepType  = 1;
	isec4[2]       = 128;
	if ( gridInqComplexPacking(gridID) && ISEC2_PentaJ >= 21 )
	  {
	    ISEC2_RepMode  = 2;
	    isec4[3]       = 64;
	    isec4[16]      = 0;
	    isec4[17]      = 20;
	    isec4[18]      = 20;
	    isec4[19]      = 20;
	  }
	else
	  {
	    ISEC2_RepMode  = 1;
	    isec4[3]       = 0;
	  }
	break;
      }
    case GRID_GME:
      {
	ISEC2_GridType   = GTYPE_GME;
	ISEC2_GME_ND     = gridInqGMEnd(gridID);
	ISEC2_GME_NI     = gridInqGMEni(gridID);
	ISEC2_GME_NI2    = gridInqGMEni2(gridID);
	ISEC2_GME_NI3    = gridInqGMEni3(gridID);
	ISEC2_GME_AFlag  = 0;
	ISEC2_GME_LatPP  = 90000;
	ISEC2_GME_LonPP  = 0;
	ISEC2_GME_LonMPL = 0;
	ISEC2_GME_BFlag  = 0;
	break;
      }
    default:
      {
	Warning(func, "The GRIB library can not store fields on the used grid!");
	Error(func, "Unsupported grid type: %s", gridNamePtr(gridtype));
      }
    }
}

static
void cgribexDefLevel(int *isec1, int *isec2, double *fsec2, int zaxisID, int levelID)
{
  static char func[] = "cgribexDefLevel";
  double level;
  int ilevel, zaxistype, ltype;
  static int warning = 1;
  static int vct_warning = 1;

  zaxistype = zaxisInqType(zaxisID);
  ltype = zaxisInqLtype(zaxisID);

  if ( zaxistype == ZAXIS_GENERIC && ltype == 0 )
    {
      zaxistype = ZAXIS_PRESSURE;
      zaxisChangeType(zaxisID, zaxistype);
      zaxisDefUnits(zaxisID, "Pa");
    }

  ISEC2_NumVCP = 0;

  switch (zaxistype)
    {
    case ZAXIS_SURFACE:
      {
	ISEC1_LevelType = LTYPE_SURFACE;
	ISEC1_Level1    = (int) zaxisInqLevel(zaxisID, levelID);
	ISEC1_Level2    = 0;
	break;
      }
    case ZAXIS_MEANSEA:
      {
	ISEC1_LevelType = LTYPE_MEANSEA;
	ISEC1_Level1    = (int) zaxisInqLevel(zaxisID, levelID);
	ISEC1_Level2    = 0;
	break;
      }
    case ZAXIS_HYBRID:
    case ZAXIS_HYBRID_HALF:
      {
	int vctsize;

	if ( zaxisInqLbounds(zaxisID, NULL) && zaxisInqUbounds(zaxisID, NULL) )
	  {
	    ISEC1_LevelType = LTYPE_HYBRID_LAYER;
	    ISEC1_Level1    = (int) zaxisInqLbound(zaxisID, levelID);
	    ISEC1_Level2    = (int) zaxisInqUbound(zaxisID, levelID);
	  }
	else
	  {
	    ISEC1_LevelType = LTYPE_HYBRID;
	    ISEC1_Level1    = (int) zaxisInqLevel(zaxisID, levelID);
	    ISEC1_Level2    = 0;
	  }

	vctsize = zaxisInqVctSize(zaxisID);
	if ( vctsize == 0 && warning )
	  {
	    Warning(func, "VCT missing. ( param = %d, zaxisID = %d )",
		    ISEC1_Parameter, zaxisID);
	    warning = 0;
	  }
	if ( vctsize > 255 )
	  {
	    ISEC2_NumVCP = 0;
	    if ( vct_warning )
	      {
		Warning(func, "VCT size of %d is too large (maximum is 255). Set to 0!", vctsize);
		vct_warning = 0;
	      }
	  }
	else
	  {
	    ISEC2_NumVCP = vctsize;
	    memcpy(&fsec2[10], zaxisInqVctPtr(zaxisID), vctsize*sizeof(double));
	  }
	break;
      }
    case ZAXIS_PRESSURE:
      {
	double dum;
	char units[128];

	level = zaxisInqLevel(zaxisID, levelID);
	if ( level < 0 )
	  Warning(func, "Pressure level of %f Pa is below zero!", level);

	zaxisInqUnits(zaxisID, units);
	if ( memcmp(units, "Pa", 2) != 0 ) level *= 100;

	ilevel = (int) level;
	if ( level < 32768 && (level < 100 || modf(level/100, &dum) > 0) )
	  {
	    ISEC1_LevelType = LTYPE_99;
	    ISEC1_Level1    = ilevel;
	    ISEC1_Level2    = 0;
	  }
	else
	  {
	    ISEC1_LevelType = LTYPE_ISOBARIC;
	    ISEC1_Level1    = ilevel/100;
	    ISEC1_Level2    = 0;
	  }
	break;
      }
    case ZAXIS_HEIGHT:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	ilevel = (int) level;
	ISEC1_LevelType = LTYPE_HEIGHT;
	ISEC1_Level1    = ilevel;
	ISEC1_Level2    = 0;

	break;
      }
    case ZAXIS_ALTITUDE:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	ilevel = (int) level;
	ISEC1_LevelType = LTYPE_ALTITUDE;
	ISEC1_Level1    = ilevel;
	ISEC1_Level2    = 0;

	break;
      }
    case ZAXIS_SIGMA:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	ilevel = (int) level;
	ISEC1_LevelType = LTYPE_SIGMA;
	ISEC1_Level1    = ilevel;
	ISEC1_Level2    = 0;

	break;
      }
    case ZAXIS_DEPTH_BELOW_LAND:
      {
	if ( zaxisInqLbounds(zaxisID, NULL) && zaxisInqUbounds(zaxisID, NULL) )
	  {
	    ISEC1_LevelType = LTYPE_LANDDEPTH_LAYER;
	    ISEC1_Level1    = (int) zaxisInqLbound(zaxisID, levelID);
	    ISEC1_Level2    = (int) zaxisInqUbound(zaxisID, levelID);
	  }
	else
	  {
	    level = zaxisInqLevel(zaxisID, levelID);

	    ilevel = (int) level;
	    ISEC1_LevelType = LTYPE_LANDDEPTH;
	    ISEC1_Level1    = ilevel;
	    ISEC1_Level2    = 0;
	  }

	break;
      }
    case ZAXIS_DEPTH_BELOW_SEA:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	ilevel = (int) level;
	ISEC1_LevelType = LTYPE_SEADEPTH;
	ISEC1_Level1    = ilevel;
	ISEC1_Level2    = 0;

	break;
      }
    case ZAXIS_ISENTROPIC:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	ilevel = (int) level;
	ISEC1_LevelType = LTYPE_ISENTROPIC;
	ISEC1_Level1    = ilevel;
	ISEC1_Level2    = 0;

	break;
      }
    case ZAXIS_GENERIC:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	ilevel = (int) level;
	ISEC1_LevelType = ltype;
	ISEC1_Level1    = ilevel;
	ISEC1_Level2    = 0;

	break;
      }
    default:
      {
	Error(func, "Unsupported zaxis type: %s", zaxisNamePtr(zaxistype));
	break;
      }
    }
}

static
void cgribexDefMask(int *isec3)
{
}

static
void cgribexDefaultSec0(int *isec0)
{
  ISEC0_GRIB_Len     = 0;
  ISEC0_GRIB_Version = 0;
}

static
void cgribexDefaultSec1(int *isec1)
{
  ISEC1_CenterID    = 0;
  ISEC1_SubCenterID = 0;
  ISEC1_LocalFLag   = 0;
}

static
void cgribexDefaultSec4(int *isec4)
{
  isec4[2] = 0;
  isec4[3] = 0;
  isec4[4] = 0;
  isec4[5] = 0;
  isec4[6] = 0;
  isec4[7] = 0;
  isec4[8] = 0;
  isec4[9] = 0;
  isec4[10] = 0;
}
#endif


size_t cgribexEncode(int varID, int levelID, int vlistID, int gridID, int zaxisID,
		     int vdate, int vtime, int tsteptype, int numavg, 
		     long datasize, const double *data, int nmiss, unsigned char *gribbuffer, size_t gribbuffersize)
{
  static char func[] = "cgribexEncode";
  size_t nbytes = 0;
#if  defined  (HAVE_LIBCGRIBEX)
  long gribsize;
  int iret = 0, iword = 0;
  int isec0[2], isec1[4096], isec2[4096], isec3[2], isec4[512];
  double fsec2[512], fsec3[2];
  int datatype;
  int param;

  memset(isec1, 0, 32*sizeof(int));
  fsec2[0] = 0; fsec2[1] = 0;

  gribsize = gribbuffersize / sizeof(int);
  param    = vlistInqVarParam(vlistID, varID);

  cgribexDefaultSec0(isec0);
  cgribexDefaultSec1(isec1);
  cgribexDefaultSec4(isec4);

  cgribexDefInstitut(isec1, vlistID, varID);
  cgribexDefModel(isec1, vlistID, varID);

  datatype = vlistInqVarDatatype(vlistID, varID);

  cgribexDefParam(isec1, param);
  cgribexDefTime(isec1, vdate, vtime, tsteptype, numavg, vlistInqTaxis(vlistID));
  cgribexDefGrid(isec1, isec2, isec4, gridID);
  cgribexDefLevel(isec1, isec2, fsec2, zaxisID, levelID);
  cgribexDefMask(isec3);

  ISEC4_NumValues = gridInqSize(gridID);
  ISEC4_NumBits   = grbBitsPerValue(datatype);

  if ( nmiss > 0 )
    {
      FSEC3_MissVal = vlistInqVarMissval(vlistID, varID);
      ISEC1_Sec2Or3Flag |= 64;
    }

  if ( isec4[2] == 128 && isec4[3] == 64 )
    {
      isec4[16] = (int) (1000*calculate_pfactor(data, ISEC2_PentaJ, isec4[17]));
      if ( isec4[16] < -10000 ) isec4[16] = -10000;
      if ( isec4[16] >  10000 ) isec4[16] =  10000;
    }
  //printf("isec4[16] %d\n", isec4[16]);

  gribExDP(isec0, isec1, isec2, fsec2, isec3, fsec3, isec4, (double*) data,
	   datasize, (int *) gribbuffer, gribsize, &iword, "C", &iret);

  if ( iret ) Error(func, "Problem during GRIB encode (errno = %d)!", iret);

  nbytes = iword*sizeof(int);
#else
  Error(func, "CGRIBEX support not compiled in!");
#endif

  return (nbytes);
}
#if defined (HAVE_CONFIG_H)
#endif




#if  defined  (HAVE_LIBGRIB_API)
#  if  defined  (HAVE_LIBCGRIBEX)
#  endif
#endif


extern int cdiInventoryMode;

typedef struct {
  int param;
  int level1;
  int level2;
  int ltype;
} compvar2_t; 


#if  defined  (HAVE_LIBGRIB_API)
static
int gribapiGetGridType(grib_handle *gh, int gribgridtype)
{
  /*  static char func[] = "gribapiGetGridType"; */
  int gridtype = 0;
  long lpar;

  GRIB_CHECK(grib_get_long(gh, "gridDefinitionTemplateNumber", &lpar), 0);
  gribgridtype = (int) lpar;

  switch (gribgridtype)
    {
    case  GRIBAPI_GTYPE_LATLON:
    case  GRIBAPI_GTYPE_LATLON_ROT:
      {
	gridtype = GRID_LONLAT;
	break;
      }
    case  GRIBAPI_GTYPE_LCC:
      {
	gridtype = GRID_LCC;
	break;
      }
    case  GRIBAPI_GTYPE_GAUSSIAN:
      {
	long lpar;
	GRIB_CHECK(grib_get_long(gh, "Ni", &lpar), 0);
	if ( lpar < 0 )
	  gridtype = GRID_GAUSSIAN_REDUCED;
	else
	  gridtype = GRID_GAUSSIAN;
	break;
      }
    case  GRIBAPI_GTYPE_SPECTRAL:
      {
	gridtype = GRID_SPECTRAL;
	break;
      }
    case  GRIBAPI_GTYPE_GME:
      {
	gridtype = GRID_GME;
	break;
      }
    default:
      {
	gridtype = GRID_GENERIC;
	break;
      }
    }

  return (gridtype);
}
#endif

static
int gribapiGetIsRotated(int gribgridtype)
{
  /*  static char func[] = "cgribexGetIsRotated"; */
  int isRotated = 0;

  if ( gribgridtype == GRIBAPI_GTYPE_LATLON_ROT )
    {
      isRotated = 1;
    }

  return (isRotated);
}


#if  defined  (HAVE_LIBGRIB_API)
static
int gribapiGetZaxisType(int grb_ltype)
{
  int zaxistype = 0;

  switch ( grb_ltype )
    {
    case GRIBAPI_LTYPE_SURFACE:
      {
	zaxistype = ZAXIS_SURFACE;
	break;
      }
    case GRIBAPI_LTYPE_MEANSEA:
      {
	zaxistype = ZAXIS_MEANSEA;
	break;
      }
    case GRIBAPI_LTYPE_ISOBARIC:
      {
	zaxistype = ZAXIS_PRESSURE;
	break;
      }
    case GRIBAPI_LTYPE_HEIGHT:
      {
	zaxistype = ZAXIS_HEIGHT;
	break;
      }
    case GRIBAPI_LTYPE_ALTITUDE:
      {
	zaxistype = ZAXIS_ALTITUDE;
	break;
      }
    case GRIBAPI_LTYPE_SIGMA:
      {
	zaxistype = ZAXIS_SIGMA;
	break;
      }
    case GRIBAPI_LTYPE_HYBRID:
      //case GRIBAPI_LTYPE_HYBRID_LAYER:
      {
	zaxistype = ZAXIS_HYBRID;
	break;
      }
    case GRIBAPI_LTYPE_LANDDEPTH:
      //case GRIBAPI_LTYPE_LANDDEPTH_LAYER:
      {
	zaxistype = ZAXIS_DEPTH_BELOW_LAND;
	break;
      }
    case GRIBAPI_LTYPE_ISENTROPIC:
      {
	zaxistype = ZAXIS_ISENTROPIC;
	break;
      }
    case GRIBAPI_LTYPE_SEADEPTH:
      {
	zaxistype = ZAXIS_DEPTH_BELOW_SEA;
	break;
      }
    default:
      {
	zaxistype = ZAXIS_GENERIC;
	break;
      }
    }

  return (zaxistype);
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
int gribapiGetTimeUnits(grib_handle *gh)
{
  static char func[] = "gribapiGetTimeUnits";
  int timeunits = -1;
  long lpar;
  size_t len = 8;
  char stepunits[8];
  static int lprint = TRUE;

  GRIB_CHECK(grib_get_string(gh, "stepUnits", stepunits, &len), 0);

  if      ( memcmp(stepunits, "s",   len-1) == 0 ) timeunits = TUNIT_SECOND;
  else if ( memcmp(stepunits, "m",   len-1) == 0 ) timeunits = TUNIT_MINUTE;
  else if ( memcmp(stepunits, "h",   len-1) == 0 ) timeunits = TUNIT_HOUR;
  else if ( memcmp(stepunits, "3h",  len-1) == 0 ) timeunits = TUNIT_3HOURS;
  else if ( memcmp(stepunits, "6h",  len-1) == 0 ) timeunits = TUNIT_6HOURS;
  else if ( memcmp(stepunits, "12h", len-1) == 0 ) timeunits = TUNIT_12HOURS;
  else if ( memcmp(stepunits, "D",   len-1) == 0 ) timeunits = TUNIT_DAY;
  else if ( memcmp(stepunits, "M",   len-1) == 0 ) timeunits = TUNIT_MONTH;
  else if ( memcmp(stepunits, "Y",   len-1) == 0 ) timeunits = TUNIT_YEAR;
  else if ( lprint )
    {
      Message(func, "Step units >%s< unsupported!", stepunits);
      lprint = FALSE;
    }

  return (timeunits);
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
int gribapiTimeIsFC(grib_handle *gh)
{
  int isFC = TRUE;
  long sigofrtime;

  GRIB_CHECK(grib_get_long(gh, "significanceOfReferenceTime", &sigofrtime), 0);

  if ( sigofrtime == 3 ) isFC = FALSE;

  return (isFC);
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
int gribapiGetTsteptype(grib_handle *gh)
{
  static char func[] = "gribapiGetTsteptype";
  int tsteptype = 0;
  int timerange;
  long lpar;
  static int lprint = TRUE;

  if ( gribapiTimeIsFC(gh) )
    {
      GRIB_CHECK(grib_get_long(gh, "stepType", &lpar), 0);
      timerange = (int) lpar;

      // printf("timerange %d\n", timerange);

      switch ( timerange )
	{
	case  0:  tsteptype = TSTEP_AVG;    break;
	case  1:  tsteptype = TSTEP_ACCUM;  break;
	case  2:  tsteptype = TSTEP_MIN;    break;
	case  3:  tsteptype = TSTEP_MAX;    break;
	case  4:  tsteptype = TSTEP_DIFF;   break;
	default:
	  if ( lprint )
	    {
	      Message(func, "Time range %d unsupported", timerange);
	      lprint = FALSE;
	    }
	}
    }

  return (tsteptype);
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
void gribapiGetValidityDateTime(grib_handle *gh, int *vdate, int *vtime)
{
  long lpar;
  long sigofrtime;

  GRIB_CHECK(grib_get_long(gh, "significanceOfReferenceTime", &sigofrtime), 0);
  if ( sigofrtime == 3 )
    {
      GRIB_CHECK(grib_get_long(gh, "dataDate", &lpar), 0);
      *vdate = (int) lpar;
      GRIB_CHECK(grib_get_long(gh, "dataTime", &lpar), 0);
      *vtime = (int) lpar*100;
    }
  else
    {
      GRIB_CHECK(grib_get_long(gh, "validityDate", &lpar), 0);
      *vdate = (int) lpar;
      GRIB_CHECK(grib_get_long(gh, "validityTime", &lpar), 0);
      *vtime = (int) lpar*100;
    }
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
void gribapiAddRecord(int streamID, int param, grib_handle *gh,
		      long recsize, off_t position, int prec, int ztype)
{
  static char func[] = "gribapiAddRecord";
  int gribgridtype;
  int gridtype;
  int zaxistype;
  int gridID = CDI_UNDEFID, varID;
  int levelID = 0;
  int tsID, recID;
  int level1, level2;
  int numavg;
  int tsteptype;
  int lbounds = 0;
  record_t *record;
  grid_t grid;
  int vlistID;
  stream_t *streamptr;
  int leveltype;
  double dlevel;
  long lpar;
  int status;
  long numberOfPoints;
  size_t datasize;
  char name[256], longname[256], units[256];
  size_t vlen; 

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  tsID    = streamptr->curTsID;
  recID   = recordNewEntry(streamID, tsID);
  record  = &streamptr->tsteps[tsID].records[recID];

  tsteptype = gribapiGetTsteptype(gh);
  // numavg  = ISEC1_AvgNum;
  numavg  = 0;
  /*
  level1  = ISEC1_Level1;
  level2  = ISEC1_Level2;
  */
  status = grib_get_long(gh, "typeOfFirstFixedSurface", &lpar);
  if ( status == 0 )
    {
      leveltype = (int) lpar;
      GRIB_CHECK(grib_get_double(gh, "level", &dlevel), 0);
      if ( leveltype == 100 ) dlevel *= 100;
      if ( dlevel < -2.e9 || dlevel > 2.e9 ) dlevel = 0;
    }
  else 
    {
      leveltype = 0;
      dlevel = 0;
    }

  level1 = (int) dlevel;
  level2 = 0;

  /* fprintf(stderr, "param %d %d %d %d\n", param, level1, level2, ISEC1_LevelType); */

  (*record).size     = recsize;
  (*record).position = position;
  (*record).param    = param;
  (*record).ilevel   = level1;
  (*record).ilevel2  = level2;
  (*record).ltype    = leveltype;

  GRIB_CHECK(grib_get_long(gh, "gridDefinitionTemplateNumber", &lpar), 0);
  gribgridtype = (int) lpar;
  gridtype = gribapiGetGridType(gh, gribgridtype);
  /*
  if ( streamptr->unreduced && gridtype == GRID_GAUSSIAN_REDUCED )
    {
      gridtype = GRID_GAUSSIAN;
      ISEC2_NumLon = 2*ISEC2_NumLat;
      ISEC4_NumValues = ISEC2_NumLon*ISEC2_NumLat;
    }
  */
  memset(&grid, 0, sizeof(grid_t));

  GRIB_CHECK(grib_get_size(gh, "values", &datasize), 0);
  GRIB_CHECK(grib_get_long(gh, "numberOfPoints", &numberOfPoints), 0);

  switch (gridtype)
    {
    case GRID_LONLAT:
    case GRID_GAUSSIAN:
      {
	int nlon, nlat;

	GRIB_CHECK(grib_get_long(gh, "Ni", &lpar), 0);
	nlon = lpar;
	GRIB_CHECK(grib_get_long(gh, "Nj", &lpar), 0);
	nlat = lpar;

	if ( numberOfPoints != nlon*nlat )
	  Error(func, "numberOfPoints (%d) and gridSize (%d) differ!",
		(int)numberOfPoints, nlon*nlat);
	grid.size  = numberOfPoints;
	grid.xsize = nlon;
	grid.ysize = nlat;
	grid.xinc  = 0;
	grid.yinc  = 0;
	GRIB_CHECK(grib_get_double(gh, "longitudeOfFirstGridPointInDegrees", &grid.xfirst), 0);
	GRIB_CHECK(grib_get_double(gh, "longitudeOfLastGridPointInDegrees",  &grid.xlast), 0);
	GRIB_CHECK(grib_get_double(gh, "latitudeOfFirstGridPointInDegrees",  &grid.yfirst), 0);
	GRIB_CHECK(grib_get_double(gh, "latitudeOfLastGridPointInDegrees",   &grid.ylast), 0);
	GRIB_CHECK(grib_get_double(gh, "iDirectionIncrementInDegrees", &grid.xinc), 0);
	if ( gridtype == GRID_LONLAT )
	  GRIB_CHECK(grib_get_double(gh, "jDirectionIncrementInDegrees", &grid.yinc), 0);

	if ( IS_EQUAL(grid.xinc, GRIB_MISSING_DOUBLE) ) grid.xinc = 0;

        if ( IS_NOT_EQUAL(grid.xfirst, 0) || IS_NOT_EQUAL(grid.xlast, 0) )
	  {
	    if ( grid.xsize > 1 )
	      {
		/*
		if ( ISEC2_ResFlag && ISEC2_LonIncr > 0 )
		  grid.xinc = ISEC2_LonIncr;
		else
		  grid.xinc = (ISEC2_LastLon - ISEC2_FirstLon) / (grid.xsize - 1);
		*/
		/* correct xinc if necessary */
		/*
		if ( ISEC2_FirstLon == 0 && ISEC2_LastLon > 354 )
		  {
		    double xinc = 360. / grid.xsize;

		    if ( fabs(grid.xinc-xinc) > 0.0 )
		      {
			grid.xinc = xinc;
			if ( CDI_Debug ) Message(func, "set xinc to %g", grid.xinc);
		      }
		  }
		*/
	      }
	    grid.xdef   = 2;	    
	  }
	grid.ydef  = 0;
        if ( IS_NOT_EQUAL(grid.yfirst, 0) || IS_NOT_EQUAL(grid.ylast, 0) )
	  {
	    if ( grid.ysize > 1 )
	      {
		/*
		if ( ISEC2_ResFlag && ISEC2_LatIncr > 0 )
		  grid.yinc = ISEC2_LatIncr;
		else
		  grid.yinc = (ISEC2_LastLat - ISEC2_FirstLat) / (grid.ysize - 1);
		*/
	      }
	    grid.ydef   = 2;	    
	  }
	break;
      }
      /*
    case GRID_GAUSSIAN_REDUCED:
      {
	grid.size   = ISEC4_NumValues;
        grid.rowlon = ISEC2_RowLonPtr;
	grid.ysize  = ISEC2_NumLat;
	grid.xinc  = 0;
	grid.yinc  = 0;
	grid.xdef  = 0;
	  {
	    if ( grid.xsize > 1 )
	      {
		if ( ISEC2_ResFlag && ISEC2_LonIncr > 0 )
		  grid.xinc = ISEC2_LonIncr * 0.001;
		else
		  grid.xinc = (ISEC2_LastLon - ISEC2_FirstLon) * 0.001 / (grid.xsize - 1);
	      }
	    grid.xfirst = ISEC2_FirstLon * 0.001;
	    grid.xlast  = ISEC2_LastLon  * 0.001;
	    grid.xdef   = 2;	    
	  }
	grid.ydef  = 0;
	  {
	    if ( grid.ysize > 1 )
	      {
		if ( ISEC2_ResFlag && ISEC2_LatIncr > 0 )
		  grid.yinc = ISEC2_LatIncr * 0.001;
		else
		  grid.yinc = (ISEC2_LastLat - ISEC2_FirstLat) * 0.001 / (grid.ysize - 1);
	      }
	    grid.yfirst = ISEC2_FirstLat * 0.001;
	    grid.ylast  = ISEC2_LastLat  * 0.001;
	    grid.ydef   = 2;	    
	  }
	break;
      }
    case GRID_LCC:
      {
	if ( ISEC4_NumValues != ISEC2_NumLon*ISEC2_NumLat )
	  Error(func, "numberOfPoints (%d) and gridSize (%d) differ!",
		ISEC4_NumValues, ISEC2_NumLon*ISEC2_NumLat);

	grid.size  = ISEC4_NumValues;
	grid.xsize = ISEC2_NumLon;
	grid.ysize = ISEC2_NumLat;

	grid.lcc_xinc      = ISEC2_Lambert_dx;
	grid.lcc_yinc      = ISEC2_Lambert_dy;
	grid.lcc_originLon = ISEC2_FirstLon * 0.001;
	grid.lcc_originLat = ISEC2_FirstLat * 0.001;
	grid.lcc_lonParY   = ISEC2_Lambert_Lov * 0.001;
	grid.lcc_lat1      = ISEC2_Lambert_LatS1 * 0.001;
	grid.lcc_lat2      = ISEC2_Lambert_LatS2 * 0.001;
	grid.lcc_projflag  = ISEC2_Lambert_ProjFlag;
	grid.lcc_scanflag  = ISEC2_ScanFlag;

	grid.xdef   = 0;	    
	grid.ydef   = 0;

	break;
      }
      */
    case GRID_SPECTRAL:
      {
	size_t len = 256;
	char typeOfPacking[256];
	GRIB_CHECK(grib_get_string(gh, "typeOfPacking", typeOfPacking, &len), 0);
	// fprintf(stderr, "typeOfPacking %d %s\n", len, typeOfPacking);
	grid.lcomplex = 0;
	if ( strncmp(typeOfPacking, "spectral_complex", len) == 0 ) grid.lcomplex = 1;

	grid.size  = datasize;
	GRIB_CHECK(grib_get_long(gh, "J", &lpar), 0);
	grid.trunc = lpar;
	/*
	GRIB_CHECK(grib_get_long(gh, "complexPacking", &lpar), 0);
	if ( lpar )
	  grid.lcomplex = 1;
	else
	  grid.lcomplex = 0;
	*/
	break;
      }
      /*
    case GRID_GME:
      {
	grid.size  = ISEC4_NumValues;
	grid.nd    = ISEC2_GME_ND;
	grid.ni    = ISEC2_GME_NI;
	grid.ni2   = ISEC2_GME_NI2;
	grid.ni3   = ISEC2_GME_NI3;
	break;
      }
      */
    case GRID_GENERIC:
      {
	int nlon = 0, nlat = 0;

	if ( grib_get_long(gh, "Ni", &lpar) == 0 ) nlon = lpar;
	if ( grib_get_long(gh, "Nj", &lpar) == 0 ) nlat = lpar;

	grid.size  = numberOfPoints;
	if ( nlon && nlat )
	  {
	    grid.xsize = nlon;
	    grid.ysize = nlat;
	  }
	else
	  {
	    grid.xsize = 0;
	    grid.ysize = 0;
	  }

	break;
      }
    default:
      {
	Error(func, "Unsupported grid type: %s", gridNamePtr(gridtype));
	break;
      }
    }

  grid.isRotated = FALSE;
  if ( gribapiGetIsRotated(gribgridtype) )
    {
      grid.isRotated = TRUE;
      GRIB_CHECK(grib_get_double(gh, "latitudeOfSouthernPoleInDegrees",  &grid.ypole), 0);
      GRIB_CHECK(grib_get_double(gh, "longitudeOfSouthernPoleInDegrees", &grid.xpole), 0);
      GRIB_CHECK(grib_get_double(gh, "angleOfRotation", &grid.angle), 0);
      /* change from south to north pole */
      grid.ypole = -grid.ypole;
      grid.xpole =  grid.xpole - 180;
    }

  grid.xvals = NULL;
  grid.yvals = NULL;
  grid.type  = gridtype;

  gridID = varDefGrid(vlistID, grid, 0);

  zaxistype = gribapiGetZaxisType(leveltype);

  if ( zaxistype == ZAXIS_HYBRID )
    {
      int vctsize;
      size_t dummy;
      double *vctptr;

      GRIB_CHECK(grib_get_long(gh, "NV", &lpar), 0);
      vctsize = lpar;
      if ( vctsize > 0 )
	{
	  vctptr = (double *) malloc(vctsize*sizeof(double));
	  dummy = vctsize;
	  GRIB_CHECK(grib_get_double_array(gh, "pv", vctptr, &dummy), 0);
	  varDefVCT(vctsize, vctptr);
	  free(vctptr);
	}
    }

  //lbounds = cgribexGetZaxisHasBounds(ISEC1_LevelType);

  if ( prec > 32 ) prec = DATATYPE_PACK32;
  if ( prec <  0 ) prec = DATATYPE_PACK;

  vlen = 256;
  GRIB_CHECK(grib_get_string(gh, "shortName", name, &vlen), 0);
  if ( vlen == 8 && memcmp(name, "unknown", vlen) == 0 ) name[0] = 0;
  vlen = 256;
  GRIB_CHECK(grib_get_string(gh, "name", longname, &vlen), 0);
  if ( vlen == 8 && memcmp(longname, "unknown", vlen) == 0 ) longname[0] = 0;
  vlen = 256;
  GRIB_CHECK(grib_get_string(gh, "units", units, &vlen), 0);
  if ( vlen == 8 && memcmp(units, "unknown", vlen) == 0 ) units[0] = 0;
  // fprintf(stderr, "param %d name %s %s %s\n", param, name, longname, units); 

  varAddRecord(recID, param, gridID, zaxistype, lbounds, level1, level2,
	       prec, &varID, &levelID, 0, numavg, leveltype,
	       name, longname, units);

  (*record).varID   = varID;
  (*record).levelID = levelID;

  varDefZtype(varID, ztype);

  if ( varInqInst(varID) == CDI_UNDEFID )
    {
      long center, subcenter;
      int instID;
      GRIB_CHECK(grib_get_long(gh, "centre", &center), 0);
      GRIB_CHECK(grib_get_long(gh, "subCentre", &subcenter), 0);
      instID    = institutInq((int)center, (int)subcenter, NULL, NULL);
      if ( instID == CDI_UNDEFID )
	instID = institutDef((int)center, (int)subcenter, NULL, NULL);
      varDefInst(varID, instID);
    }

  if ( varInqModel(varID) == CDI_UNDEFID )
    {
      int modelID;
      long processID;
      status = grib_get_long(gh, "generatingProcessIdentifier", &processID);
      if ( status == 0 )
	{
	  modelID = modelInq(varInqInst(varID), processID, NULL);
	  if ( modelID == CDI_UNDEFID )
	    modelID = modelDef(varInqInst(varID), processID, NULL);
	  varDefModel(varID, modelID);
	}
    }

  if ( varInqTable(varID) == CDI_UNDEFID )
    {
      int pdis, pcat, pnum;

      cdiDecodeParam(param, &pnum, &pcat, &pdis);

      if ( pdis == 255 )
	{
	  int tableID;
	  int tabnum = pcat;

	  tableID = tableInq(varInqModel(varID), tabnum, NULL);

	  if ( tableID == CDI_UNDEFID )
	    tableID = tableDef(varInqModel(varID), tabnum, NULL);
	  varDefTable(varID, tableID);
	}
    }

  streamptr->tsteps[tsID].nallrecs++;
  streamptr->nrecs++;

  if ( CDI_Debug )
    Message(func, "varID = %d  param = %d  zaxistype = %d  gridID = %d  levelID = %d",
	    varID, param, zaxistype, gridID, levelID);
}
#endif

void gribapiScanTimestep1(int streamID)
{
  static char func [] = "gribapiScanTimestep1";
#if  defined  (HAVE_LIBGRIB_API)
  off_t recpos = 0;
  unsigned char *gribbuffer = NULL;
  long buffersize = 0;
  int iret = 0, ipunp = 0, iword = 0;
  int status;
  int fileID;
  int rtabnum = 0;
  int rcode = 0, level1 = 0, level2 = 0;
  int vdate = 0, vtime = 0;
  int param = 0;
  DateTime datetime, datetime0;
  int tsID;
  int varID;
  size_t readsize;
  int nrecords, nrecs, recID;
  int prec;
  long recsize = 0;
  int warn_time = TRUE;
  int warn_numavg = TRUE;
  int taxisID = -1;
  int rdate = 0, rtime = 0, tunit = 0, fcast = 0;
  taxis_t *taxis;
  int vlistID;
  int ztype;
  long unzipsize;
  compvar2_t compVar, compVar0;
  stream_t *streamptr;
  grib_handle *gh = NULL;
  int leveltype;
  int pdis = 0, pcat = 0, pnum = 0;
  long editionNumber;
  long lpar;
  int bitsPerValue;
  double dlevel = 0;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->curTsID = 0;

  tsID  = tstepsNewEntry(streamID);
  taxis = &streamptr->tsteps[tsID].taxis;

  if ( tsID != 0 )
    Error(func, "Internal problem! tstepsNewEntry returns %d", tsID);

  fileID = streamInqFileID(streamID);

  nrecs = 0;
  while ( TRUE )
    {
      recsize = gribGetSize(fileID);
      recpos  = fileGetPos(fileID);

      if ( recsize == 0 )
	{
	  streamptr->ntsteps = 1;
	  break;
	}
      if ( recsize > buffersize )
	{
	  buffersize = recsize;
	  gribbuffer = (unsigned char *) realloc(gribbuffer, buffersize);
	}

      readsize = recsize;
      status = gribRead(fileID, gribbuffer, &readsize);
      if ( status ) break;

      ztype = COMPRESS_NONE;
      if ( gribGetZip(recsize, gribbuffer, &unzipsize) > 0 )
	{
	  ztype = COMPRESS_SZIP;
	  unzipsize += 100;
	  if ( (long) buffersize < unzipsize )
	    {
	      buffersize = unzipsize;
	      gribbuffer = (unsigned char *) realloc(gribbuffer, buffersize);
	    }
	}

      gh = grib_handle_new_from_message(NULL, (void *) gribbuffer, recsize);
      GRIB_CHECK(grib_set_double(gh, "missingValue", GRIB_MISSVAL), 0);

      GRIB_CHECK(grib_get_long(gh, "editionNumber", &editionNumber), 0);

      if ( editionNumber <= 1 )
	{
	  GRIB_CHECK(grib_get_long(gh, "table2Version", &lpar), 0);
	  rtabnum = (int) lpar;
	  GRIB_CHECK(grib_get_long(gh, "indicatorOfParameter", &lpar), 0);
	  rcode = (int) lpar;

	  param = cdiEncodeParam(rcode, rtabnum, 255);

	  status = grib_get_long(gh, "indicatorOfTypeOfLevel", &lpar);
	  if ( status == 0 )
	    {
	      leveltype = (int) lpar;
	      GRIB_CHECK(grib_get_double(gh, "level", &dlevel), 0);
	      if ( leveltype == 100 ) dlevel *= 100;
	      if ( dlevel < -2.e9 || dlevel > 2.e9 ) dlevel = 0;
	    }
	  else 
	    {
	      leveltype = 0;
	      dlevel = 0;
	    }
	}
      else
	{
	  size_t len = 256;
	  char typeOfPacking[256];
	  GRIB_CHECK(grib_get_string(gh, "typeOfPacking", typeOfPacking, &len), 0);
	  // fprintf(stderr, "typeOfPacking %d %s\n", len, typeOfPacking);
	  if ( strncmp(typeOfPacking, "grid_jpeg", len) == 0 ) ztype = COMPRESS_JPEG;
	  
	  GRIB_CHECK(grib_get_long(gh, "discipline", &lpar), 0);
	  pdis = (int) lpar;

	  GRIB_CHECK(grib_get_long(gh, "parameterCategory", &lpar), 0);
	  pcat = (int) lpar;

	  GRIB_CHECK(grib_get_long(gh, "parameterNumber", &lpar), 0);
	  pnum = (int) lpar;

	  param = cdiEncodeParam(pnum, pcat, pdis);

	  status = grib_get_long(gh, "typeOfFirstFixedSurface", &lpar);
	  if ( status == 0 )
	    {
	      leveltype = (int) lpar;
	      GRIB_CHECK(grib_get_double(gh, "level", &dlevel), 0);
	      if ( leveltype == 100 ) dlevel *= 100;
	      if ( dlevel < -2.e9 || dlevel > 2.e9 ) dlevel = 0;
	    }
	  else 
	    {
	      leveltype = 0;
	      dlevel = 0;
	    }
	}

      level1 = (int) dlevel;
      level2 = 0;

      gribapiGetValidityDateTime(gh, &vdate, &vtime);
      /*
      printf("%d %d %d.%d.%d\n", vdate, vtime, pnum, pcat, pdis);
      */

      GRIB_CHECK(grib_get_long(gh,"bitsPerValue", &lpar),0);
      bitsPerValue = (int) lpar;
      if ( bitsPerValue > 0 && bitsPerValue <= 32 )
	prec = bitsPerValue;
      else
        prec = DATATYPE_PACK;

      if ( nrecs == 0 )
	{
	  datetime0.date = vdate;
	  datetime0.time = vtime;
	  GRIB_CHECK(grib_get_long(gh, "dataDate", &lpar), 0);
	  rdate = (int) lpar;
	  GRIB_CHECK(grib_get_long(gh, "dataTime", &lpar), 0);
	  rtime = (int) lpar*100;
	  fcast = gribapiTimeIsFC(gh);
	  if ( fcast ) tunit = gribapiGetTimeUnits(gh);
	}
      else
	{
	  datetime.date  = vdate;
	  datetime.time  = vtime;

	  compVar.param  = param;
          compVar.level1 = level1;
          compVar.level2 = level2;
	  compVar.ltype  = leveltype;

	  for ( recID = 0; recID < nrecs; recID++ )
	    {
	      compVar0.param  = streamptr->tsteps[0].records[recID].param;
	      compVar0.level1 = streamptr->tsteps[0].records[recID].ilevel;
	      compVar0.level2 = streamptr->tsteps[0].records[recID].ilevel2;
	      compVar0.ltype  = streamptr->tsteps[0].records[recID].ltype;

	      if ( memcmp(&compVar0, &compVar, sizeof(compvar2_t)) == 0 ) break;
	    }

	  if ( cdiInventoryMode == 1 )
	    {
	      if ( recID < nrecs ) break;
	      if ( warn_time )
		if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) != 0 )
		  {
		    char paramstr[32];
		    cdiParamToString(param, paramstr, sizeof(paramstr));	    
		    Warning(func, "Inconsistent verification time (param=%s level=%d)", paramstr, level1);
		    warn_time = FALSE;
		  }
	    }
	  else
	    {
	      if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) != 0 ) break;

	      if ( recID < nrecs )
		{
		  char paramstr[32];
		  cdiParamToString(param, paramstr, sizeof(paramstr));
		  Warning(func, "Param=%s level=%d already exist, skipped!", paramstr, level1);
		  continue;
		}
	    }
	}
      /*
      if ( ISEC1_AvgNum )
	{
	  if (  taxis->numavg && warn_numavg && (taxis->numavg != ISEC1_AvgNum) )
	    {
	      Message(func, "Change numavg from %d to %d not allowed!",
		      taxis->numavg, ISEC1_AvgNum);
	      warn_numavg = FALSE;
	    }
	  else
	    {
	      taxis->numavg = ISEC1_AvgNum;
	    }
	}
      */
      nrecs++;

      if ( CDI_Debug )
	Message(func, "%4d %8d %4d  %8d %8d %6d", nrecs, (int)recpos, param, level1, vdate, vtime);

      gribapiAddRecord(streamID, param, gh, recsize, recpos, prec, ztype);

      grib_handle_delete(gh);
      gh = NULL;
    }

  if ( gh ) grib_handle_delete(gh);

  streamptr->rtsteps = 1;

  cdiGenVars(streamID);

  if ( fcast )
    {
      taxisID = taxisCreate(TAXIS_RELATIVE);
      taxis->type  = TAXIS_RELATIVE;
      taxis->rdate = rdate;
      taxis->rtime = rtime;
      taxis->unit  = tunit;
    }
  else
    {
      taxisID = taxisCreate(TAXIS_ABSOLUTE);
      taxis->type  = TAXIS_ABSOLUTE;
    }

  taxis->vdate = datetime0.date;
  taxis->vtime = datetime0.time;

  vlistID = streamInqVlist(streamID);
  vlistDefTaxis(vlistID, taxisID);

  nrecords = streamptr->tsteps[0].nallrecs;
  if ( nrecords < streamptr->tsteps[0].recordSize )
    {
      streamptr->tsteps[0].recordSize = nrecords;
      streamptr->tsteps[0].records =
      (record_t *) realloc(streamptr->tsteps[0].records, nrecords*sizeof(record_t));
    }

  streamptr->tsteps[0].recIDs = (int *) malloc(nrecords*sizeof(int));
  streamptr->tsteps[0].nrecs = nrecords;
  for ( recID = 0; recID < nrecords; recID++ )
    streamptr->tsteps[0].recIDs[recID] = recID;

  streamptr->record->buffer     = gribbuffer;
  streamptr->record->buffersize = buffersize;

  if ( streamptr->ntsteps == -1 )
    {
      tsID = tstepsNewEntry(streamID);
      if ( tsID != streamptr->rtsteps )
	Error(func, "Internal error. tsID = %d", tsID);

      streamptr->tsteps[tsID-1].next   = TRUE;
      streamptr->tsteps[tsID].position = recpos;
    }

  if ( streamptr->ntsteps == 1 )
    {
      if ( taxis->vdate == 0 && taxis->vtime == 0 )
	{
	  streamptr->ntsteps = 0;
	  for ( varID = 0; varID < streamptr->nvars; varID++ )
	    {
	      vlistDefVarTime(vlistID, varID, TIME_CONSTANT);
	    }
	}
    }
#else
  Error(func, "GRIB_API support not compiled in!");
#endif
}


int gribapiScanTimestep2(int streamID)
{
  static char func [] = "gribapiScanTimestep2";
  int status = 0;
#if  defined  (HAVE_LIBGRIB_API)
  off_t recpos = 0;
  unsigned char *gribbuffer = NULL;
  long buffersize = 0;
  int iret = 0, ipunp = 0, iword = 0;
  int fileID;
  int rtabnum = 0;
  int rcode = 0, level1 = 0, level2 = 0, vdate = 0, vtime = 0;
  DateTime datetime, datetime0;
  int tsID;
  int varID, gridID;
  size_t readsize;
  int nrecords, nrecs, recID, rindex;
  long recsize = 0;
  int warn_numavg = TRUE;
  int tsteptype;
  int taxisID = -1;
  taxis_t *taxis;
  int vlistID;
  long unzipsize;
  compvar2_t compVar, compVar0;
  stream_t *streamptr;
  grib_handle *gh = NULL;
  int leveltype;
  int pdis = 0, pcat = 0, pnum = 0;
  int param = 0;
  long editionNumber;
  long lpar;
  double dlevel = 0;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->curTsID = 1;

  fileID  = streamInqFileID(streamID);
  vlistID = streamInqVlist(streamID);
  taxisID = vlistInqTaxis(vlistID);

  gribbuffer = (unsigned char *) streamptr->record->buffer;
  buffersize = streamptr->record->buffersize;
                                          
  tsID = streamptr->rtsteps;
  if ( tsID != 1 )
    Error(func, "Internal problem! unexpeceted timestep %d", tsID+1);

  taxis = &streamptr->tsteps[tsID].taxis;

  fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);

  cdiCreateRecords(streamID, tsID);

  nrecords = streamptr->tsteps[tsID].nallrecs;
  streamptr->tsteps[1].recIDs = (int *) malloc(nrecords*sizeof(int));
  streamptr->tsteps[1].nrecs = 0;
  for ( recID = 0; recID < nrecords; recID++ )
    streamptr->tsteps[1].recIDs[recID] = -1;
      
  for ( recID = 0; recID < nrecords; recID++ )
    {
      varID = streamptr->tsteps[0].records[recID].varID;
      streamptr->tsteps[tsID].records[recID].position = 
	streamptr->tsteps[0].records[recID].position;
      streamptr->tsteps[tsID].records[recID].size     = 
	streamptr->tsteps[0].records[recID].size;
    }

  rindex = 0;
  while ( TRUE )
    {
      if ( rindex > nrecords ) break;

      recsize = gribGetSize(fileID);
      recpos  = fileGetPos(fileID);
      if ( recsize == 0 )
	{
	  streamptr->ntsteps = 2;
	  break;
	}
      if ( recsize > buffersize )
	{
	  buffersize = recsize;
	  gribbuffer = (unsigned char *) realloc(gribbuffer, (size_t)buffersize);
	}

      readsize = recsize;
      status = gribRead(fileID, gribbuffer, &readsize);
      if ( status ) break;

      if ( gribGetZip(recsize, gribbuffer, &unzipsize) > 0 )
	{
	  unzipsize += 100; /* need 0 to 1 bytes for rounding of bds */
	  if ( (long) buffersize < unzipsize )
	    {
	      buffersize = unzipsize;
	      gribbuffer = (unsigned char *) realloc(gribbuffer, buffersize);
	    }
	}

      gh = grib_handle_new_from_message(NULL, (void *) gribbuffer, recsize);
      GRIB_CHECK(grib_set_double(gh, "missingValue", GRIB_MISSVAL), 0);

      GRIB_CHECK(grib_get_long(gh, "editionNumber", &editionNumber), 0);

      if ( editionNumber <= 1 )
	{
	  GRIB_CHECK(grib_get_long(gh, "table2Version", &lpar), 0);
	  rtabnum = (int) lpar;
	  GRIB_CHECK(grib_get_long(gh, "indicatorOfParameter", &lpar), 0);
	  rcode = (int) lpar;

	  param = cdiEncodeParam(rcode, rtabnum, 255);

	  status = grib_get_long(gh, "indicatorOfTypeOfLevel", &lpar);
	  if ( status == 0 )
	    {
	      leveltype = (int) lpar;
	      GRIB_CHECK(grib_get_double(gh, "level", &dlevel), 0);
	      if ( leveltype == 100 ) dlevel *= 100;
	      if ( dlevel < -2.e9 || dlevel > 2.e9 ) dlevel = 0;
	    }
	  else 
	    {
	      leveltype = 0;
	      dlevel = 0;
	    }
	}
      else
	{
	  GRIB_CHECK(grib_get_long(gh, "discipline", &lpar), 0);
	  pdis = (int) lpar;

	  GRIB_CHECK(grib_get_long(gh, "parameterCategory", &lpar), 0);
	  pcat = (int) lpar;

	  GRIB_CHECK(grib_get_long(gh, "parameterNumber", &lpar), 0);
	  pnum = (int) lpar;

	  param = cdiEncodeParam(pnum, pcat, pdis);

	  status = grib_get_long(gh, "typeOfFirstFixedSurface", &lpar);
	  if ( status == 0 )
	    {
	      leveltype = (int) lpar;
	      GRIB_CHECK(grib_get_double(gh, "level", &dlevel), 0);
	      if ( leveltype == 100 ) dlevel *= 100;
	      if ( dlevel < -2.e9 || dlevel > 2.e9 ) dlevel = 0;
	    }
	  else 
	    {
	      leveltype = 0;
	      dlevel = 0;
	    }
	}

      level1 = (int) dlevel;
      level2 = 0;

      gribapiGetValidityDateTime(gh, &vdate, &vtime);

      if ( rindex == 0 )
	{
	  if ( taxisInqType(taxisID) == TAXIS_RELATIVE )
	    {
	      taxis->type  = TAXIS_RELATIVE;
	      GRIB_CHECK(grib_get_long(gh, "dataDate", &lpar), 0);
	      taxis->rdate = (int) lpar;
	      GRIB_CHECK(grib_get_long(gh, "dataTime", &lpar), 0);
	      taxis->rtime = (int) lpar*100;
	      taxis->unit  = gribapiGetTimeUnits(gh);
	    }
	  else
	    {
	      taxis->type  = TAXIS_ABSOLUTE;
	    }
	  taxis->vdate = vdate;
	  taxis->vtime = vtime;

	  datetime0.date = vdate;
	  datetime0.time = vtime;
	}

      tsteptype = gribapiGetTsteptype(gh);
      /*
      if ( ISEC1_AvgNum )
	{
	  if (  taxis->numavg && warn_numavg &&
		(taxis->numavg != ISEC1_AvgNum) )
	    {
	      warn_numavg = FALSE;
	    }
	  else
	    {
	      taxis->numavg = ISEC1_AvgNum;
	    }
	}
      */
      datetime.date  = vdate;
      datetime.time  = vtime;
      compVar.param  = param;
      compVar.level1 = level1;
      compVar.level2 = level2;
      compVar.ltype  = leveltype;
      for ( recID = 0; recID < nrecords; recID++ )
	{
	  compVar0.param = streamptr->tsteps[tsID].records[recID].param;
	  compVar0.level1 = streamptr->tsteps[tsID].records[recID].ilevel;
	  compVar0.level2 = streamptr->tsteps[tsID].records[recID].ilevel2;
	  compVar0.ltype  = streamptr->tsteps[tsID].records[recID].ltype;

	  if ( memcmp(&compVar0, &compVar, sizeof(compvar2_t)) == 0 ) break;
	}

      if ( recID == nrecords )
	{
	  char paramstr[32];
	  cdiParamToString(param, paramstr, sizeof(paramstr));
	  Warning(func, "Param=%s level=%d not defined at timestep 1!", paramstr, level1);
	  return (CDI_EUFSTRUCT);
	}

      if ( cdiInventoryMode == 1 )
	{
	  if ( streamptr->tsteps[tsID].records[recID].used )
	    {
	      break;
	    }
	  else
	    {
	      streamptr->tsteps[tsID].records[recID].used = TRUE;
	      streamptr->tsteps[tsID].recIDs[rindex] = recID;
	    }    
	}
      else
	{
	  if ( streamptr->tsteps[tsID].records[recID].used )
	    {
	      char paramstr[32];
	      cdiParamToString(param, paramstr, sizeof(paramstr));

	      if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) != 0 ) break;

	      Warning(func, "Param=%s level=%d already exist, skipped!", paramstr, level1);
	      continue;
	    }
	  else
	    {
	      streamptr->tsteps[tsID].records[recID].used = TRUE;
	      streamptr->tsteps[tsID].recIDs[rindex] = recID;
	    }    
	}

      if ( CDI_Debug )
	Message(func, "%4d %8d %4d %8d %8d %6d", rindex+1, (int)recpos, param, level1, vdate, vtime);

      streamptr->tsteps[tsID].records[recID].size = recsize;

      compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
      compVar0.level1 = streamptr->tsteps[tsID].records[recID].ilevel;
      compVar0.level2 = streamptr->tsteps[tsID].records[recID].ilevel2;
      compVar0.ltype  = streamptr->tsteps[tsID].records[recID].ltype;

      if ( memcmp(&compVar0, &compVar, sizeof(compvar2_t)) != 0 )
	{
	  Message(func, "tsID = %d recID = %d param = %3d new %3d  level = %3d new %3d",
		  tsID, recID,
		  streamptr->tsteps[tsID].records[recID].param, param,
		  streamptr->tsteps[tsID].records[recID].ilevel, level1);
	  return (CDI_EUFSTRUCT);
	}

      streamptr->tsteps[1].records[recID].position = recpos;
      varID = streamptr->tsteps[tsID].records[recID].varID;
      gridID = vlistInqVarGrid(vlistID, varID);
      /*
      if ( gridInqSize(gridID) == 1 && gridInqType(gridID) == GRID_LONLAT )
	{
	  if ( IS_NOT_EQUAL(gridInqXval(gridID, 0),ISEC2_FirstLon*0.001) ||
	       IS_NOT_EQUAL(gridInqYval(gridID, 0),ISEC2_FirstLat*0.001) )
	    gridChangeType(gridID, GRID_TRAJECTORY);
	}
      */
      if ( tsteptype != vlistInqVarTsteptype(vlistID, varID) )
	vlistDefVarTsteptype(vlistID, varID, tsteptype);

      grib_handle_delete(gh);
      gh = NULL;
      
      rindex++;
    }
  
  if ( gh ) grib_handle_delete(gh);

  nrecs = 0;
  for ( recID = 0; recID < nrecords; recID++ )
    {
      if ( ! streamptr->tsteps[tsID].records[recID].used )
	{
	  varID = streamptr->tsteps[tsID].records[recID].varID;
	  vlistDefVarTime(vlistID, varID, TIME_CONSTANT);
	}
      else
	{
	  nrecs++;
	}
    }
  streamptr->tsteps[tsID].nrecs = nrecs;

  streamptr->rtsteps = 2;

  if ( streamptr->ntsteps == -1 )
    {
      tsID = tstepsNewEntry(streamID);
      if ( tsID != streamptr->rtsteps )
	Error(func, "Internal error. tsID = %d", tsID);

      streamptr->tsteps[tsID-1].next   = TRUE;
      streamptr->tsteps[tsID].position = recpos;
    }

  streamptr->record->buffer     = gribbuffer;
  streamptr->record->buffersize = buffersize;
#else
  Error(func, "GRIB_API support not compiled in!");
#endif

  return (status);
}


int gribapiScanTimestep(int streamID)
{
  static char func [] = "gribapiScanTimestep";
  int status = 0;
#if  defined  (HAVE_LIBGRIB_API)
  long recsize = 0;
  off_t recpos = 0;
  unsigned char *gribbuffer;
  long buffersize = 0;
  int iret = 0, ipunp = 0, iword = 0;
  int fileID;
  int rtabnum = 0;
  int rcode = 0, level1 = 0, level2 = 0, vdate = 0, vtime = 0;
  DateTime datetime, datetime0;
  int tsID;
  int vrecID, recID;
  int warn_numavg = TRUE;
  size_t readsize;
  int taxisID = -1;
  taxis_t *taxis;
  int vlistID;
  int rindex, nrecs = 0;
  long unzipsize;
  compvar2_t compVar, compVar0;
  stream_t *streamptr;
  grib_handle *gh = NULL;
  int leveltype;
  int pdis = 0, pcat = 0, pnum = 0;
  int param = 0;
  long editionNumber;
  long lpar;
  double dlevel = 0;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);

  if ( CDI_Debug )
    {
      Message(func, "streamID = %d", streamID);
      Message(func, "cts = %d", streamptr->curTsID);
      Message(func, "rts = %d", streamptr->rtsteps);
      Message(func, "nts = %d", streamptr->ntsteps);
    }

  tsID  = streamptr->rtsteps;
  taxis = &streamptr->tsteps[tsID].taxis;

  if ( streamptr->tsteps[tsID].recordSize == 0 )
    {
      gribbuffer = (unsigned char *) streamptr->record->buffer;
      buffersize = streamptr->record->buffersize;

      cdiCreateRecords(streamID, tsID);

      nrecs = streamptr->tsteps[1].nrecs;

      streamptr->tsteps[tsID].nrecs = nrecs;
      streamptr->tsteps[tsID].recIDs = (int *) malloc(nrecs*sizeof(int));
      for ( recID = 0; recID < nrecs; recID++ )
	streamptr->tsteps[tsID].recIDs[recID] = streamptr->tsteps[1].recIDs[recID];

      fileID = streamInqFileID(streamID);

      fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);

      rindex = 0;
      while ( TRUE )
	{
	  if ( rindex > nrecs ) break;

	  recsize = gribGetSize(fileID);
	  recpos  = fileGetPos(fileID);
	  if ( recsize == 0 )
	    {
	      streamptr->ntsteps = streamptr->rtsteps + 1;
	      break;
	    }
	  if ( recsize > buffersize )
	    {
	      buffersize = recsize;
	      gribbuffer = (unsigned char *) realloc(gribbuffer, buffersize);
	    }

	  readsize = recsize;
	  status = gribRead(fileID, gribbuffer, &readsize);
	  if ( status )
	    {
	      Error(func, "Inconsistent timestep %d (GRIB record %d/%d)!\n", tsID+1, rindex+1,
		    streamptr->tsteps[tsID].recordSize);
	      break;
	    }

	  if ( gribGetZip(recsize, gribbuffer, &unzipsize) > 0 )
	    {
	      unzipsize += 100; /* need 0 to 1 bytes for rounding of bds */
	      if ( (long) buffersize < unzipsize )
		{
		  buffersize = unzipsize;
		  gribbuffer = (unsigned char *) realloc(gribbuffer, buffersize);
		}
	    }

	  gh = grib_handle_new_from_message(NULL, (void *) gribbuffer, recsize);
	  GRIB_CHECK(grib_set_double(gh, "missingValue", GRIB_MISSVAL), 0);

	  GRIB_CHECK(grib_get_long(gh, "editionNumber", &editionNumber), 0);

	  if ( editionNumber <= 1 )
	    {
	      GRIB_CHECK(grib_get_long(gh, "table2Version", &lpar), 0);
	      rtabnum = (int) lpar;
	      GRIB_CHECK(grib_get_long(gh, "indicatorOfParameter", &lpar), 0);
	      rcode = (int) lpar;

	      param = cdiEncodeParam(rcode, rtabnum, 255);

	      status = grib_get_long(gh, "indicatorOfTypeOfLevel", &lpar);
	      if ( status == 0 )
		{
		  leveltype = (int) lpar;
		  GRIB_CHECK(grib_get_double(gh, "level", &dlevel), 0);
		  if ( leveltype == 100 ) dlevel *= 100;
		  if ( dlevel < -2.e9 || dlevel > 2.e9 ) dlevel = 0;
		}
	      else 
		{
		  leveltype = 0;
		  dlevel = 0;
		}
	    }
	  else
	    {
	      GRIB_CHECK(grib_get_long(gh, "discipline", &lpar), 0);
	      pdis = (int) lpar;

	      GRIB_CHECK(grib_get_long(gh, "parameterCategory", &lpar), 0);
	      pcat = (int) lpar;

	      GRIB_CHECK(grib_get_long(gh, "parameterNumber", &lpar), 0);
	      pnum = (int) lpar;

	      param = cdiEncodeParam(pnum, pcat, pdis);

	      status = grib_get_long(gh, "typeOfFirstFixedSurface", &lpar);
	      if ( status == 0 )
		{
		  leveltype = (int) lpar;
		  GRIB_CHECK(grib_get_double(gh, "level", &dlevel), 0);
		  if ( leveltype == 100 ) dlevel *= 100;
		  if ( dlevel < -2.e9 || dlevel > 2.e9 ) dlevel = 0;
		}
	      else 
		{
		  leveltype = 0;
		  dlevel = 0;
		}
	    }

	  level1 = (int) dlevel;
	  level2 = 0;

	  gribapiGetValidityDateTime(gh, &vdate, &vtime);

	  if ( rindex == nrecs ) break;

	  if ( rindex == 0 )
	    {
	      taxisID = vlistInqTaxis(vlistID);
	      if ( taxisInqType(taxisID) == TAXIS_RELATIVE )
		{
		  taxis->type  = TAXIS_RELATIVE;
		  GRIB_CHECK(grib_get_long(gh, "dataDate", &lpar), 0);
		  taxis->rdate = (int) lpar;
		  GRIB_CHECK(grib_get_long(gh, "dataTime", &lpar), 0);
		  taxis->rtime = (int) lpar*100;
		  taxis->unit  = gribapiGetTimeUnits(gh);
		}
	      else
		{
		  taxis->type  = TAXIS_ABSOLUTE;
		}
	      taxis->vdate = vdate;
	      taxis->vtime = vtime;

	      datetime0.date = vdate;
	      datetime0.time = vtime;
	    }
	  /*
	  if ( ISEC1_AvgNum )
	    {
	      if (  taxis->numavg && warn_numavg &&
		   (taxis->numavg != ISEC1_AvgNum) )
		{
		  warn_numavg = FALSE;
		}
	      else
		{
		  taxis->numavg = ISEC1_AvgNum;
		}
	    }
	  */
	  datetime.date  = vdate;
	  datetime.time  = vtime;
	  compVar.param  = param;
          compVar.level1 = level1;
          compVar.level2 = level2;
          compVar.ltype  = leveltype;
	  for ( vrecID = 0; vrecID < nrecs; vrecID++ )
	    {
	      recID   = streamptr->tsteps[1].recIDs[vrecID];
	      compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
	      compVar0.level1 = streamptr->tsteps[tsID].records[recID].ilevel;
	      compVar0.level2 = streamptr->tsteps[tsID].records[recID].ilevel2;
	      compVar0.ltype  = streamptr->tsteps[tsID].records[recID].ltype;

	      if ( memcmp(&compVar0, &compVar, sizeof(compvar2_t)) == 0 ) break;
	    }

	  if ( vrecID == nrecs )
	    {
	      char paramstr[32];
	      cdiParamToString(param, paramstr, sizeof(paramstr));
	      Warning(func, "Param=%s level=%d not available at timestep %d!", paramstr, level1, tsID+1);

	      if ( cdiInventoryMode == 1 )
		return (CDI_EUFSTRUCT);
	      else
		continue;
	    }

	  if ( cdiInventoryMode == 1 )
	    {
	      streamptr->tsteps[tsID].records[recID].used = TRUE;
	      streamptr->tsteps[tsID].recIDs[rindex] = recID;
	    }
	  else
	    {
	      if ( streamptr->tsteps[tsID].records[recID].used )
		{
		  char paramstr[32];
		  cdiParamToString(param, paramstr, sizeof(paramstr));

		  if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) != 0 ) break;
		  
		  if ( CDI_Debug )
		    Warning(func, "Param=%s level=%d already exist, skipped!", paramstr, level1);

		  continue;
		}
	      else
		{
		  streamptr->tsteps[tsID].records[recID].used = TRUE;
		  streamptr->tsteps[tsID].recIDs[rindex] = recID;
		}    
	    }

	  if ( CDI_Debug )
	    Message(func, "%4d %8d %4d %8d %8d %6d", rindex+1, (int)recpos, param, level1, vdate, vtime);

	  compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
	  compVar0.level1 = streamptr->tsteps[tsID].records[recID].ilevel;
	  compVar0.level2 = streamptr->tsteps[tsID].records[recID].ilevel2;
	  compVar0.ltype  = streamptr->tsteps[tsID].records[recID].ltype;

	  if ( memcmp(&compVar0, &compVar, sizeof(compvar2_t)) != 0 )
	    {
	      Message(func, "tsID = %d recID = %d param = %3d new %3d  level = %3d new %3d",
		      tsID, recID,
		      streamptr->tsteps[tsID].records[recID].param, param,
		      streamptr->tsteps[tsID].records[recID].ilevel, level1);
	      Error(func, "Invalid, unsupported or inconsistent record structure");
	    }
	  
	  streamptr->tsteps[tsID].records[recID].position = recpos;
	  streamptr->tsteps[tsID].records[recID].size = recsize;

	  if ( CDI_Debug )
	    Message(func, "%4d %8d %4d %8d %8d %6d", rindex, (int)recpos, param, level1, vdate, vtime);

	  grib_handle_delete(gh);
	  gh = NULL;

	  rindex++;
	}

      if ( gh ) grib_handle_delete(gh);

      for ( vrecID = 0; vrecID < nrecs; vrecID++ )
	{
	  recID   = streamptr->tsteps[tsID].recIDs[vrecID];
	  if ( ! streamptr->tsteps[tsID].records[recID].used ) break;
	}

      if ( vrecID < nrecs )
	{
	  char paramstr[32];
	  cdiParamToString(streamptr->tsteps[tsID].records[recID].param, paramstr, sizeof(paramstr));
	  Warning(func, "Param %d level %d not found at timestep %d!",
		  paramstr, streamptr->tsteps[tsID].records[recID].ilevel, tsID+1);
	  return (CDI_EUFSTRUCT);
	}

      streamptr->rtsteps++;

      if ( streamptr->ntsteps != streamptr->rtsteps )
	{
	  tsID = tstepsNewEntry(streamID);
	  if ( tsID != streamptr->rtsteps )
	    Error(func, "Internal error. tsID = %d", tsID);

	  streamptr->tsteps[tsID-1].next   = 1;
	  streamptr->tsteps[tsID].position = recpos;
	}

      fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);
      streamptr->tsteps[tsID].position = recpos;

      streamptr->record->buffer     = gribbuffer;
      streamptr->record->buffersize = buffersize;
    }

  if ( nrecs > 0 && nrecs < streamptr->tsteps[tsID].nrecs )
    {
      Warning(func, "Incomplete timestep. Stop scanning at timestep %d.\n", tsID);
      streamptr->ntsteps = tsID;
    }

  status = streamptr->ntsteps;
#else
  Error(func, "GRIB_API support not compiled in!");
#endif

  return (status);
}


int gribapiDecode(unsigned char *gribbuffer, int gribsize, double *data, int gridsize,
		  int unreduced, int *nmiss, int *zip, double missval)
{
  static char func[] = "gribapiDecode";
  int status = 0;
#if  defined  (HAVE_LIBGRIB_API)
  long lpar;
  long editionNumber, numberOfPoints;
  size_t datasize, dummy, recsize;
  grib_handle *gh = NULL;

  if ( unreduced )
    {
      static int lwarn = 1;

      if ( lwarn )
	{
	  lwarn = 0;
	  Warning(func, "Conversion of gaussian reduced grids unsupported!\n");
	}
    }

  recsize = gribsize;
  gh = grib_handle_new_from_message(NULL, (void *) gribbuffer, recsize);
  GRIB_CHECK(grib_set_double(gh, "missingValue", missval), 0);

  GRIB_CHECK(grib_get_long(gh, "editionNumber", &editionNumber), 0);

  /* get the size of the values array*/
  GRIB_CHECK(grib_get_size(gh, "values", &datasize), 0);
  GRIB_CHECK(grib_get_long(gh, "numberOfPoints", &numberOfPoints), 0);

  // printf("values_size = %d  numberOfPoints = %ld\n", datasize, numberOfPoints);

  if ( gridsize != (int) datasize )
    Error(func, "Internal problem: gridsize(%d) != datasize(%d)!\n", gridsize, datasize);
  dummy = datasize;
  GRIB_CHECK(grib_get_double_array(gh, "values", data, &dummy), 0);

  int gridtype;
  GRIB_CHECK(grib_get_long(gh, "gridDefinitionTemplateNumber", &lpar), 0);
  gridtype = (int) lpar;

  *nmiss = 0;
  if ( gridtype < 50 || gridtype > 53 )
    {
      GRIB_CHECK(grib_get_long(gh, "numberOfMissing", &lpar), 0);
      *nmiss = (int) lpar;
      // printf("gridtype %d, nmiss %d\n", gridtype, nmiss);
    }

  grib_handle_delete(gh);

#else
  Error(func, "GRIB_API support not compiled in!");
#endif

  return (status);
}

#if  defined  (HAVE_LIBGRIB_API)
static
void gribapiDefInstitut(grib_handle *gh, int vlistID, int varID)
{
  int instID;

  if ( vlistInqInstitut(vlistID) != CDI_UNDEFID )
    instID = vlistInqInstitut(vlistID);
  else
    instID = vlistInqVarInstitut(vlistID, varID);

  if ( instID != CDI_UNDEFID )
    {
      int center, subcenter;
      center    = institutInqCenter(instID);
      subcenter = institutInqSubcenter(instID);
      GRIB_CHECK(grib_set_long(gh, "centre", center), 0);
      GRIB_CHECK(grib_set_long(gh, "subCentre", subcenter), 0);
    }
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
void gribapiDefModel(grib_handle *gh, int vlistID, int varID)
{
  int modelID;

  if ( vlistInqModel(vlistID) != CDI_UNDEFID )
    modelID = vlistInqModel(vlistID);
  else
    modelID = vlistInqVarModel(vlistID, varID);

  if ( modelID != CDI_UNDEFID )
    GRIB_CHECK(grib_set_long(gh, "generatingProcessIdentifier", modelInqGribID(modelID)), 0);
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
void gribapiDefParam(grib_handle *gh, int param)
{
  int pdis, pcat, pnum;

  cdiDecodeParam(param, &pnum, &pcat, &pdis);

  //ISEC1_CodeTable = codetable;
  if ( pnum < 0 ) pnum = -pnum;
  // GRIB_CHECK(grib_set_long(gh, "indicatorOfParameter", code), 0);
  GRIB_CHECK(grib_set_long(gh, "discipline",        pdis), 0);
  GRIB_CHECK(grib_set_long(gh, "parameterCategory", pcat), 0);
  GRIB_CHECK(grib_set_long(gh, "parameterNumber",   pnum), 0);
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
int gribapiDefTimerange(int tsteptype, int factor, int calendar,
			int rdate, int rtime, int vdate, int vtime, int *pip)
{
  int timerange = -1;
  int year, month, day, hour, minute, second;
  int julday1, secofday1, julday2, secofday2, days, secs;
  int ip = 0;

  cdiDecodeDate(rdate, &year, &month, &day);
  cdiDecodeTime(rtime, &hour, &minute, &second);
  encode_juldaysec(calendar, year, month, day, hour, minute, &julday1, &secofday1);

  cdiDecodeDate(vdate, &year, &month, &day);
  cdiDecodeTime(vtime, &hour, &minute, &second);
  encode_juldaysec(calendar, year, month, day, hour, minute, &julday2, &secofday2);
  
  (void) julday_sub(julday1, secofday1, julday2, secofday2, &days, &secs);

  if ( !(int) fmod(days*86400.0 + secs, factor) )
    {
      ip = (int) ((days*86400.0 + secs)/factor);

      switch ( tsteptype )
	{
	case TSTEP_AVG:    timerange =  0;  break;
	case TSTEP_ACCUM:  timerange =  1;  break;
	case TSTEP_MIN:    timerange =  2;  break;
	case TSTEP_MAX:    timerange =  3;  break;
	case TSTEP_DIFF:   timerange =  4;  break;
	default:           timerange =  0;  break;
	}
    }

  *pip = ip;

  return (timerange);
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
int gribapiDefDateTime(grib_handle *gh, int timeunit, int date, int time)
{
  int factor = 1;
  char stepunits[8];
  size_t len;

  GRIB_CHECK(grib_set_long(gh, "dataDate", date), 0);
  GRIB_CHECK(grib_set_long(gh, "dataTime", time/100), 0);

  switch (timeunit)
    {
    case TUNIT_SECOND:  factor =     1; strcpy(stepunits, "s");   break;
    case TUNIT_MINUTE:  factor =    60; strcpy(stepunits, "m");   break;
    case TUNIT_HOUR:    factor =  3600; strcpy(stepunits, "h");   break;
    case TUNIT_3HOURS:  factor = 10800; strcpy(stepunits, "3h");  break;
    case TUNIT_6HOURS:  factor = 21600; strcpy(stepunits, "6h");  break;
    case TUNIT_12HOURS: factor = 43200; strcpy(stepunits, "12h"); break;
    case TUNIT_DAY:     factor = 86400; strcpy(stepunits, "D");   break;
    default:            factor =  3600; strcpy(stepunits, "h");   break;
    }

  len = strlen(stepunits) + 1;
  GRIB_CHECK(grib_set_string(gh, "stepUnits", stepunits, &len), 0);  

  return (factor);
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
void gribapiDefTime(grib_handle *gh , int vdate, int vtime, int tsteptype, int numavg, int taxisID)
{
  int timetype = -1;
  int timerange = 0;
  int timeunit;

  if ( taxisID != -1 ) timetype = taxisInqType(taxisID);

  timeunit = taxisInqTunit(taxisID);

  if ( timetype == TAXIS_RELATIVE )
    {
      int factor = 1;
      int rdate, rtime;
      int ip = 0;
      int calendar;
      
      calendar = taxisInqCalendar(taxisID);
      rdate    = taxisInqRdate(taxisID);
      rtime    = taxisInqRtime(taxisID);

      factor = gribapiDefDateTime(gh, timeunit, rdate, rtime);
      
      timerange = gribapiDefTimerange(tsteptype, factor, calendar,
				      rdate, rtime, vdate, vtime, &ip);
      // printf("timerange: %d %d\n", timerange, ip);

      if ( ip > 0 )
	{
	  GRIB_CHECK(grib_set_long(gh, "significanceOfReferenceTime", 1), 0);
	  //GRIB_CHECK(grib_set_long(gh, "stepType", timerange), 0);
	  GRIB_CHECK(grib_set_long(gh, "stepRange", ip), 0);
	}
    }

  if ( timetype == TAXIS_ABSOLUTE )
    {
      (void) gribapiDefDateTime(gh, timeunit, vdate, vtime);

      // GRIB_CHECK(grib_set_long(gh, "stepType", timerange), 0);
    }
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
void gribapiDefGrid(grib_handle *gh, int gridID, int ljpeg)
{
  static char func[] = "gribapiDefGrid";
  int gridtype;
  static short lwarn = TRUE;
  size_t len;
  const char *mesg;

  // ISEC1_Sec2Or3Flag = 128;
  
  gridtype = gridInqType(gridID);

  // ISEC1_GridDefinition = 255;

  if ( gridtype == GRID_GENERIC )
    {
      int xsize, ysize;

      xsize = gridInqXsize(gridID);
      ysize = gridInqYsize(gridID);

      if ( (ysize == 32  || ysize == 48 || ysize == 64 ||
	    ysize == 96  || ysize == 160) && 
	   (xsize == 2*ysize || xsize == 1) )
	{
	  gridtype = GRID_GAUSSIAN;
	  gridChangeType(gridID, gridtype);
	}
      else if ( (xsize == 1 && ysize == 1) || (xsize == 0 && ysize == 0) )
	{
	  gridtype = GRID_LONLAT;
	  gridChangeType(gridID, gridtype);
	}
      else if ( gridInqXvals(gridID, NULL) && gridInqYvals(gridID, NULL) )
	{
	  gridtype = GRID_LONLAT;
	  gridChangeType(gridID, gridtype);
	}
    }
  else if ( gridtype == GRID_CURVILINEAR )
    {
      if ( lwarn )
	{
	  lwarn = FALSE;
	  Warning(func, "Curvilinear grids are unsupported in GRIB format! Created wrong GDS!");
	}
      gridtype = GRID_LONLAT;
    }

  // ISEC2_Reduced = FALSE;

  // ISEC2_ScanFlag = 0;

  switch (gridtype)
    {
    case GRID_LONLAT:
    case GRID_GAUSSIAN:
    case GRID_GAUSSIAN_REDUCED:
    case GRID_TRAJECTORY:
      {
	int nlon = 0, nlat;
	double xfirst = 0, xlast = 0, xinc = 0;
	double yfirst = 0, ylast = 0, yinc = 0;
	double latIncr;

	if ( gridtype == GRID_GAUSSIAN_REDUCED )
	  {
	    //  ISEC2_Reduced = TRUE;
	    nlon = 0;
	    // gridInqRowlon(gridID, ISEC2_RowLonPtr);
	  }
	else
	  {
	    nlon = gridInqXsize(gridID);
	    if ( nlon == 0 )
	      {
		nlon = 1;
	      }
	    else
	      {
		xfirst = gridInqXval(gridID,      0);
		xlast  = gridInqXval(gridID, nlon-1);
		xinc   = gridInqXinc(gridID);
	      }
	  }

	nlat = gridInqYsize(gridID);
	if ( nlat == 0 )
	  {
	    nlat = 1;
	  }
	else
	  {
	    yfirst = gridInqYval(gridID,      0);
	    ylast  = gridInqYval(gridID, nlat-1);
	    yinc   = gridInqYinc(gridID);
	  }

	if ( gridtype == GRID_GAUSSIAN || gridtype == GRID_GAUSSIAN_REDUCED )
	  GRIB_CHECK(grib_set_long(gh, "gridDefinitionTemplateNumber", GRIBAPI_GTYPE_GAUSSIAN), 0);
	else if ( gridtype == GRID_LONLAT && gridIsRotated(gridID) )
	  GRIB_CHECK(grib_set_long(gh, "gridDefinitionTemplateNumber", GRIBAPI_GTYPE_LATLON_ROT), 0);
	else
	  GRIB_CHECK(grib_set_long(gh, "gridDefinitionTemplateNumber", GRIBAPI_GTYPE_LATLON), 0);

	GRIB_CHECK(grib_set_long(gh, "Ni", nlon), 0);
	GRIB_CHECK(grib_set_long(gh, "Nj", nlat), 0);
	GRIB_CHECK(grib_set_double(gh, "longitudeOfFirstGridPointInDegrees", xfirst), 0);
	GRIB_CHECK(grib_set_double(gh, "longitudeOfLastGridPointInDegrees",  xlast), 0);
	GRIB_CHECK(grib_set_double(gh, "latitudeOfFirstGridPointInDegrees",  yfirst), 0);
	GRIB_CHECK(grib_set_double(gh, "latitudeOfLastGridPointInDegrees",   ylast), 0);
	GRIB_CHECK(grib_set_double(gh, "iDirectionIncrementInDegrees", xinc), 0);
	/*
	if ( fabs(xinc*1000 - ISEC2_LonIncr) > FLT_EPSILON )
	  ISEC2_LonIncr = 0;
	*/
	if ( gridtype == GRID_GAUSSIAN )
	  GRIB_CHECK(grib_set_long(gh, "numberOfParallelsBetweenAPoleAndTheEquator", nlat/2), 0);
	else
	  {
	    latIncr = yinc;
	    if ( latIncr < 0 ) latIncr = -latIncr;
	    GRIB_CHECK(grib_set_double(gh, "jDirectionIncrementInDegrees", latIncr), 0);
	    /*
	    if ( fabs(yinc*1000 - ISEC2_LatIncr) > FLT_EPSILON )
	      ISEC2_LatIncr = 0;
	    */
	  }
	/*
	if ( ISEC2_NumLon > 1 && ISEC2_NumLat == 1 ) 
	  if ( ISEC2_LonIncr != 0 && ISEC2_LatIncr == 0 ) ISEC2_LatIncr = ISEC2_LonIncr;

	if ( ISEC2_NumLon == 1 && ISEC2_NumLat > 1 ) 
	  if ( ISEC2_LonIncr == 0 && ISEC2_LatIncr != 0 ) ISEC2_LonIncr = ISEC2_LatIncr;

	if ( ISEC2_LatIncr == 0 || ISEC2_LonIncr == 0 )
	  ISEC2_ResFlag = 0;
	else
	  ISEC2_ResFlag = 128;
	*/
	if ( gridIsRotated(gridID) )
	  {
	    double xpole, ypole, angle;
	    xpole = gridInqXpole(gridID);
	    ypole = gridInqYpole(gridID);
	    angle = gridInqAngle(gridID);
	    /* change from noth to south pole */
	    ypole = -ypole;
	    xpole =  xpole + 180;
	    GRIB_CHECK(grib_set_double(gh, "latitudeOfSouthernPoleInDegrees",  ypole), 0);
	    GRIB_CHECK(grib_set_double(gh, "longitudeOfSouthernPoleInDegrees", xpole), 0);
	    GRIB_CHECK(grib_set_double(gh, "angleOfRotation", angle), 0);
	  }

	/* East -> West */
	//if ( ISEC2_LastLon < ISEC2_FirstLon ) ISEC2_ScanFlag += 128;

	/* South -> North */
	//if ( ISEC2_LastLat > ISEC2_FirstLat ) ISEC2_ScanFlag += 64;

	if ( ljpeg )
	  {
	    mesg = "grid_jpeg"; len = strlen(mesg);
	    GRIB_CHECK(grib_set_string(gh, "typeOfPacking", mesg, &len), 0);
	  }
	else
	  {
	    mesg = "grid_simple"; len = strlen(mesg);
	    GRIB_CHECK(grib_set_string(gh, "typeOfPacking", mesg, &len), 0);
	  }

	break;
      }
      /*
    case GRID_LCC:
      {
	double originLon, originLat, lonParY, lat1, lat2, xincm, yincm;
	int xsize, ysize;
	int projflag, scanflag;

	xsize = gridInqXsize(gridID);
	ysize = gridInqYsize(gridID);

	gridInqLCC(gridID, &originLon, &originLat, &lonParY, &lat1, &lat2, &xincm, &yincm,
		   &projflag, &scanflag);

	ISEC2_GridType = GRIBAPI_GTYPE_LCC;
	ISEC2_NumLon   = xsize;
	ISEC2_NumLat   = ysize;
	ISEC2_FirstLon = NINT(originLon * 1000);
	ISEC2_FirstLat = NINT(originLat * 1000);
	ISEC2_Lambert_Lov    = NINT(lonParY * 1000);
	ISEC2_Lambert_LatS1  = NINT(lat1 * 1000);
	ISEC2_Lambert_LatS2  = NINT(lat2 * 1000);
	ISEC2_Lambert_dx     = NINT(xincm);
	ISEC2_Lambert_dy     = NINT(yincm);
	ISEC2_Lambert_LatSP  = 0;
	ISEC2_Lambert_LatSP  = 0;
	ISEC2_Lambert_ProjFlag = projflag;
	ISEC2_ScanFlag = scanflag;

	break;
      }
      */
    case GRID_SPECTRAL:
      {
	int trunc = gridInqTrunc(gridID);

	GRIB_CHECK(grib_set_long(gh, "gridDefinitionTemplateNumber", GRIBAPI_GTYPE_SPECTRAL), 0);
	GRIB_CHECK(grib_set_long(gh, "J", trunc), 0);
	GRIB_CHECK(grib_set_long(gh, "K", trunc), 0);
	GRIB_CHECK(grib_set_long(gh, "M", trunc), 0);

	GRIB_CHECK(grib_set_long(gh, "numberOfDataPoints", gridInqSize(gridID)), 0);
	GRIB_CHECK(grib_set_long(gh, "numberOfValues", gridInqSize(gridID)), 0);

	if ( gridInqComplexPacking(gridID) )
	  {
	    static int lwarncomplex = 1;
	    if ( lwarncomplex )
	      {
		Warning(func, "GRIB2 complex packing not implemented, using simple packing!");
		lwarncomplex = 0;
	      }
	    mesg = "spectral_simple"; len = strlen(mesg);
	    GRIB_CHECK(grib_set_string(gh, "typeOfPacking", mesg, &len), 0);
	    /*
	    mesg = "spectral_complex"; len = strlen(mesg);
	    GRIB_CHECK(grib_set_string(gh, "typeOfPacking", mesg, &len), 0);
	    GRIB_CHECK(grib_set_long(gh, "JS", 20), 0);
	    GRIB_CHECK(grib_set_long(gh, "KS", 20), 0);
	    GRIB_CHECK(grib_set_long(gh, "MS", 20), 0);
	    */
	  }
	else
	  {
	    mesg = "spectral_simple"; len = strlen(mesg);
	    GRIB_CHECK(grib_set_string(gh, "typeOfPacking", mesg, &len), 0);
	  }

	break;
      }
      /*
    case GRID_GME:
      {
	ISEC2_GridType   = GRIBAPI_GTYPE_GME;
	ISEC2_GME_ND     = gridInqGMEnd(gridID);
	ISEC2_GME_NI     = gridInqGMEni(gridID);
	ISEC2_GME_NI2    = gridInqGMEni2(gridID);
	ISEC2_GME_NI3    = gridInqGMEni3(gridID);
	ISEC2_GME_AFlag  = 0;
	ISEC2_GME_LatPP  = 90000;
	ISEC2_GME_LonPP  = 0;
	ISEC2_GME_LonMPL = 0;
	ISEC2_GME_BFlag  = 0;
	break;
      }
      */
    default:
      Error(func, "Unsupported grid type: %s", gridNamePtr(gridtype));
    }
}
#endif

#if  defined  (HAVE_LIBGRIB_API)
static
void gribapiDefLevel(grib_handle *gh, int param, int zaxisID, int levelID)
{
  static char func[] = "gribapiDefLevel";
  double level;
  int zaxistype, ltype;
  static int warning = 1;

  zaxistype = zaxisInqType(zaxisID);
  ltype = zaxisInqLtype(zaxisID);

  if ( zaxistype == ZAXIS_GENERIC && ltype == 0 )
    {
      zaxistype = ZAXIS_PRESSURE;
      zaxisChangeType(zaxisID, zaxistype);
      zaxisDefUnits(zaxisID, "Pa");
    }

  // ISEC2_NumVCP = 0;
  // GRIB_CHECK(grib_set_long(gh, "PVPresent", 0), 0);

  switch (zaxistype)
    {
    case ZAXIS_SURFACE:
      {
	GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_SURFACE), 0);
	//GRIB_CHECK(grib_set_long(gh, "scaleFactorOfFirstFixedSurface", 0), 0);
	//GRIB_CHECK(grib_set_long(gh, "scaledValueOfFirstFixedSurface", 0), 0);
	GRIB_CHECK(grib_set_long(gh, "level", (long) zaxisInqLevel(zaxisID, levelID)), 0);
	/*
	ISEC1_Level1    = (int) zaxisInqLevel(zaxisID, levelID);
	ISEC1_Level2    = 0;
	*/
	break;
      }
    case ZAXIS_MEANSEA:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_MEANSEA), 0);
	GRIB_CHECK(grib_set_double(gh, "level", level), 0);

	break;
      }
    case ZAXIS_HYBRID:
    case ZAXIS_HYBRID_HALF:
      {
	int vctsize;

	GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_HYBRID), 0);
	if ( zaxisInqLbounds(zaxisID, NULL) && zaxisInqUbounds(zaxisID, NULL) )
	  {
	    GRIB_CHECK(grib_set_long(gh, "level", (long) zaxisInqLevel(zaxisID, levelID)), 0);
	    Error(func, "hybrid_half model level code missing!");
	    /*
	    ISEC1_Level1    = (int) zaxisInqLbound(zaxisID, levelID);
	    ISEC1_Level2    = (int) zaxisInqUbound(zaxisID, levelID);
	    */
	  }
	else
	  {
	    GRIB_CHECK(grib_set_long(gh, "level", (long) zaxisInqLevel(zaxisID, levelID)), 0);
	  }

	vctsize = zaxisInqVctSize(zaxisID);
	if ( vctsize == 0 && warning )
	  {
	    char paramstr[32];
	    cdiParamToString(param, paramstr, sizeof(paramstr));
	    Warning(func, "VCT missing ( param = %s, zaxisID = %d )", paramstr, zaxisID);
	    warning = 0;
	  }
	GRIB_CHECK(grib_set_long(gh, "PVPresent", 1), 0);
	GRIB_CHECK(grib_set_double_array(gh, "pv", zaxisInqVctPtr(zaxisID), vctsize), 0);

	break;
      }
    case ZAXIS_PRESSURE:
      {
	char units[128];

	level = zaxisInqLevel(zaxisID, levelID);
	if ( level < 0 )
	  Warning(func, "Pressure level of %f Pa is below zero!", level);

	zaxisInqUnits(zaxisID, units);
	if ( memcmp(units, "Pa", 2) == 0 ) level /= 100;

	GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_ISOBARIC), 0);
	GRIB_CHECK(grib_set_double(gh, "level", level), 0);

	break;
      }
    case ZAXIS_HEIGHT:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_HEIGHT), 0);
	GRIB_CHECK(grib_set_double(gh, "level", level), 0);

	break;
      }
    case ZAXIS_ALTITUDE:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_ALTITUDE), 0);
	GRIB_CHECK(grib_set_double(gh, "level", level), 0);

	break;
      }
    case ZAXIS_SIGMA:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_SIGMA), 0);
	GRIB_CHECK(grib_set_double(gh, "level", level), 0);

	break;
      }
    case ZAXIS_DEPTH_BELOW_LAND:
      {
	if ( zaxisInqLbounds(zaxisID, NULL) && zaxisInqUbounds(zaxisID, NULL) )
	  {
	    GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_LANDDEPTH), 0);
	    GRIB_CHECK(grib_set_double(gh, "level", zaxisInqLbound(zaxisID, levelID)), 0);
	    GRIB_CHECK(grib_set_long(gh, "typeOfSecondFixedSurface", GRIBAPI_LTYPE_LANDDEPTH), 0);
	    GRIB_CHECK(grib_set_double(gh, "level", zaxisInqUbound(zaxisID, levelID)), 0);
	    /*
	    ISEC1_LevelType = GRIBAPI_LTYPE_LANDDEPTH_LAYER;
	    ISEC1_Level1    = (int) zaxisInqLbound(zaxisID, levelID);
	    ISEC1_Level2    = (int) zaxisInqUbound(zaxisID, levelID);
	    */
	  }
	else
	  {
	    level = zaxisInqLevel(zaxisID, levelID);

	    GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_LANDDEPTH), 0);
	    GRIB_CHECK(grib_set_double(gh, "level", level), 0);
	  }

	break;
      }
    case ZAXIS_DEPTH_BELOW_SEA:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_SEADEPTH), 0);
	GRIB_CHECK(grib_set_double(gh, "level", level), 0);

	break;
      }
    case ZAXIS_ISENTROPIC:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", GRIBAPI_LTYPE_ISENTROPIC), 0);
	GRIB_CHECK(grib_set_double(gh, "level", level), 0);

	break;
      }
    case ZAXIS_GENERIC:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	GRIB_CHECK(grib_set_long(gh, "typeOfFirstFixedSurface", ltype), 0);
	GRIB_CHECK(grib_set_double(gh, "level", level), 0);

	break;
      }
    default:
      {
	Error(func, "Unsupported zaxis type: %s", zaxisNamePtr(zaxistype));
	break;
      }
    }
}
#endif


void *gribHandleNew()
{
  static char func[] = "gribHandleNew";
  void *gh = NULL;

#if  defined  (HAVE_LIBGRIB_API)
  gh = (void *) grib_handle_new_from_samples(NULL, "GRIB2");
  if ( gh == NULL ) Error(func, "grib_handle_new_from_samples failed!");
#endif

  return (gh);
}


void gribHandleDelete(void *gh)
{
#if  defined  (HAVE_LIBGRIB_API)
  grib_handle_delete(gh);
#endif
}

/* #define GRIBAPIENCODETEST 1 */

size_t gribapiEncode(int varID, int levelID, int vlistID, int gridID, int zaxisID,
		     int vdate, int vtime, int tsteptype, int numavg, 
		     long datasize, const double *data, int nmiss, unsigned char *gribbuffer, size_t gribbuffersize,
		     int ljpeg, void *gribHandle)
{
  static char func[] = "gribapiEncode";
  size_t nbytes = 0;
#if  defined  (HAVE_LIBGRIB_API)
  size_t recsize = 0;
  void *dummy = NULL;
  long edition = 2;
  int datatype;
  int param;
  long bitsPerValue;
  grib_handle *gh = NULL;
  // extern unsigned char _grib_template_GRIB2[];

  param    = vlistInqVarParam(vlistID, varID);
  datatype = vlistInqVarDatatype(vlistID, varID);

#if defined(GRIBAPIENCODETEST)
  gh = (grib_handle *) gribHandleNew();
#else
  gh = gribHandle;
#endif
  
  GRIB_CHECK(grib_set_long(gh, "editionNumber", edition), 0);

  gribapiDefInstitut(gh, vlistID, varID);
  gribapiDefModel(gh, vlistID, varID);

  gribapiDefParam(gh, param);
  gribapiDefTime(gh, vdate, vtime, tsteptype, numavg, vlistInqTaxis(vlistID));
  gribapiDefGrid(gh, gridID, ljpeg);
  gribapiDefLevel(gh, param, zaxisID, levelID);

  if ( nmiss > 0 )
    {
      GRIB_CHECK(grib_set_long(gh, "bitmapPresent", 1), 0);
      GRIB_CHECK(grib_set_double(gh, "missingValue", vlistInqVarMissval(vlistID, varID)), 0);
    }

  bitsPerValue = grbBitsPerValue(datatype);
  GRIB_CHECK(grib_set_long(gh, "bitsPerValue", bitsPerValue), 0);

  GRIB_CHECK(grib_set_double_array(gh, "values", data, datasize), 0);

  /* get the size of coded message  */
  GRIB_CHECK(grib_get_message(gh, (const void **)&dummy, &recsize), 0);
  //recsize += 512; /* add some space for possible filling */

  if ( recsize > gribbuffersize )
    Error(func, "Internal problem: GRIB buffer too small (size = %ld, needed = %ld", gribbuffersize, recsize);

  /* get a copy of the coded message */
  GRIB_CHECK(grib_get_message_copy(gh, gribbuffer, &recsize), 0);

#if defined(GRIBAPIENCODETEST)
  gribHandleDelete(gh);
#endif

  nbytes = recsize;
#else
  Error(func, "GRIB_API support not compiled in!");
#endif

  return (nbytes);
}
#if defined (HAVE_CONFIG_H)
#endif




int grbBitsPerValue(int datatype)
{
  static char func[] = "grbBitsPerValue";
  int bitsPerValue = 16;

  if ( datatype == DATATYPE_CPX32 || datatype == DATATYPE_CPX64 )
    Error(func, "CDI/GRIB library does not support complex numbers!");

  if ( datatype != CDI_UNDEFID )
    {
      if ( datatype > 0 && datatype <= 32 )
	bitsPerValue = datatype;
      else if ( datatype == DATATYPE_FLT64 )
	bitsPerValue = 24;
      else
	bitsPerValue = 16;
    }

  return (bitsPerValue);
}


/*
int grbInqRecord(int streamID, int *varID, int *levelID)
{
  int status;

  status = cgribexInqRecord(streamID, varID, levelID);

  return (status);
}
*/

int grbDefRecord(int streamID)
{
  static char func[] = "grbDefRecord";
  int fileID;
  int gridID;
  int status = 0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID = streamInqFileID(streamID);
  gridID = streamptr->record->gridID;

  return (status);
}

static
int grbDecode(int filetype, unsigned char *gribbuffer, int gribsize, double *data, int gridsize,
	      int unreduced, int *nmiss, int *zip, double missval)
{
  //static char func[] = "grbDecode";
  int status = 0;

  if ( filetype == FILETYPE_GRB )
    status = cgribexDecode(gribbuffer, gribsize, data, gridsize, unreduced, nmiss, zip, missval);
  else
    status = gribapiDecode(gribbuffer, gribsize, data, gridsize, unreduced, nmiss, zip, missval);
 
  return (status);
}


int grbReadRecord(int streamID, double *data, int *nmiss)
{
  static char func[] = "grbReadRecord";
  int status = 0;
  unsigned char *gribbuffer;
  int fileID;
  int recID, vrecID, tsID, gridID, varID;
  long recsize;
  off_t recpos;
  int gridsize;
  int vlistID;
  int zip;
  int filetype;
  double missval;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  filetype = streamptr->filetype;

  gribbuffer = (unsigned char *) streamptr->record->buffer;

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);
  tsID    = streamptr->curTsID;
  vrecID  = streamptr->tsteps[tsID].curRecID;
  recID   = streamptr->tsteps[tsID].recIDs[vrecID];
  recpos  = streamptr->tsteps[tsID].records[recID].position;
  recsize = streamptr->tsteps[tsID].records[recID].size;
  varID   = streamptr->tsteps[tsID].records[recID].varID;

  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);

  streamptr->numvals += gridsize;

  fileSetPos(fileID, recpos, SEEK_SET);

  fileRead(fileID, gribbuffer, (size_t) recsize);

  missval = vlistInqVarMissval(vlistID, varID);

  grbDecode(filetype, gribbuffer, recsize, data, gridsize, streamptr->unreduced, nmiss, &zip, missval);

  streamptr->tsteps[tsID].records[recID].zip = zip;

  return (status);
}

static
void grbScanTimestep1(int streamID)
{
  int filetype;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);
  filetype  = streamptr->filetype;

  if ( filetype == FILETYPE_GRB )
    {
      cgribexScanTimestep1(streamID);
    }
  else
    {
      gribapiScanTimestep1(streamID);
    }
}

static
int grbScanTimestep2(int streamID)
{
  int status;
  int filetype;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);
  filetype  = streamptr->filetype;

  if ( filetype == FILETYPE_GRB )
    {
      status = cgribexScanTimestep2(streamID);
    }
  else
    {
      status = gribapiScanTimestep2(streamID);
    }

  return (status);
}

static
int grbScanTimestep(int streamID)
{
  int status;
  int filetype;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);
  filetype  = streamptr->filetype;

  if ( filetype == FILETYPE_GRB )
    {
      status = cgribexScanTimestep(streamID);
    }
  else
    {
      status = gribapiScanTimestep(streamID);
    }

  return (status);
}


int grbInqContents(int streamID)
{
  static char func[] = "grbInqContents";
  int fileID;
  int status = 0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID = streamInqFileID(streamID);

  streamptr->curTsID = 0;

  grbScanTimestep1(streamID);
 
  if ( streamptr->ntsteps == -1 ) status = grbScanTimestep2(streamID);

  fileSetPos(fileID, 0, SEEK_SET);

  return (status);
}


int grbInqTimestep(int streamID, int tsID)
{
  static char func[] = "grbInqTimestep";
  int ntsteps, nrecs;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  if ( tsID == 0 && streamptr->rtsteps == 0 )
    Error(func, "Call to cdiInqContents missing!");

  if ( CDI_Debug )
    Message(func, "tsid = %d rtsteps = %d", tsID, streamptr->rtsteps);
  
  ntsteps = CDI_UNDEFID;
  while ( (tsID + 1) > streamptr->rtsteps && ntsteps == CDI_UNDEFID )
    {
      ntsteps = grbScanTimestep(streamID);
      if ( ntsteps == CDI_EUFSTRUCT )
	{
	  streamptr->ntsteps = streamptr->rtsteps;
	  break;
	}
    }

  if ( tsID >= streamptr->ntsteps && streamptr->ntsteps != CDI_UNDEFID )
    {
      nrecs = 0;
    }
  else
    {
      streamptr->curTsID = tsID;
      nrecs = streamptr->tsteps[tsID].nrecs;
    }

  return (nrecs);
}


void grbReadVarDP(int streamID, int varID, double *data, int *nmiss)
{
  static char func[] = "grbReadVarDP";
  int fileID;
  int levelID, nlevs, gridID, gridsize;
  unsigned char *gribbuffer;
  int tsID, recID;
  long recsize;
  off_t recpos, currentfilepos;
  int imiss;
  int vlistID;
  int zip;
  int filetype;
  double missval;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  filetype = streamptr->filetype;

  gribbuffer = (unsigned char *) streamptr->record->buffer;

  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  tsID     = streamptr->curTsID;

  nlevs    = streamptr->vars[varID].nlevs;
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);

  if ( CDI_Debug )
    Message(func, "nlevs = %d gridID = %d gridsize = %d", nlevs, gridID, gridsize);

  currentfilepos = fileGetPos(fileID);

  *nmiss = 0;
  for ( levelID = 0; levelID < nlevs; levelID++ )
    {
      recID   = streamptr->vars[varID].level[levelID];
      recpos  = streamptr->tsteps[tsID].records[recID].position;
      recsize = streamptr->tsteps[tsID].records[recID].size;

      fileSetPos(fileID, recpos, SEEK_SET);

      fileRead(fileID, gribbuffer, recsize);

      missval = vlistInqVarMissval(vlistID, varID);

      grbDecode(filetype, gribbuffer, recsize, &data[levelID*gridsize], gridsize, 
		streamptr->unreduced, &imiss, &zip, missval);

      *nmiss += imiss;

      streamptr->tsteps[tsID].records[recID].zip = zip;
    }

  fileSetPos(fileID, currentfilepos, SEEK_SET);
}


void grbReadVarSliceDP(int streamID, int varID, int levelID, double *data, int *nmiss)
{
  static char func[] = "grbReadVarSliceDP";
  int fileID;
  int gridID, gridsize;
  unsigned char *gribbuffer;
  long recsize;
  off_t recpos, currentfilepos;
  int tsID, recID;
  int vlistID;
  int zip;
  int filetype;
  double missval;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  filetype = streamptr->filetype;

  gribbuffer = (unsigned char *) streamptr->record->buffer;

  vlistID  = streamInqVlist(streamID);
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  tsID     = streamptr->curTsID;

  if ( CDI_Debug )
    Message(func, "gridID = %d gridsize = %d", gridID, gridsize);

  fileID = streamInqFileID(streamID);

  currentfilepos = fileGetPos(fileID);

  recID   = streamptr->vars[varID].level[levelID];
  recpos  = streamptr->tsteps[tsID].records[recID].position;
  recsize = streamptr->tsteps[tsID].records[recID].size;

  if ( recsize == 0 )
    Error(func, "Internal problem! Recordsize is zero for record %d at timestep %d",
	  recID+1, tsID+1);

  fileSetPos(fileID, recpos, SEEK_SET);

  fileRead(fileID, gribbuffer, recsize);

  missval = vlistInqVarMissval(vlistID, varID);

  grbDecode(filetype, gribbuffer, recsize, data, gridsize, streamptr->unreduced, nmiss, &zip, missval);

  fileSetPos(fileID, currentfilepos, SEEK_SET);

  streamptr->tsteps[tsID].records[recID].zip = zip;
}

static
size_t grbEncode(int filetype, int varID, int levelID, int vlistID, int gridID, int zaxisID,
		 int date, int time, int tsteptype, int numavg, 
		 long datasize, const double *data, int nmiss, unsigned char *gribbuffer, size_t gribbuffersize,
		 int ljpeg, void *gribHandle)
{
  size_t nbytes;

  if ( filetype == FILETYPE_GRB )
    {
      nbytes = cgribexEncode(varID, levelID, vlistID, gridID, zaxisID,
			     date, time, tsteptype, numavg, 
			     datasize, data, nmiss, gribbuffer, gribbuffersize);
    }
  else
    {
      nbytes = gribapiEncode(varID, levelID, vlistID, gridID, zaxisID,
			     date, time, tsteptype, numavg, 
			     datasize, data, nmiss, gribbuffer, gribbuffersize, ljpeg, gribHandle);
    }

  return (nbytes);
}

static
size_t grbSzip(int filetype, unsigned char *gribbuffer, size_t gribbuffersize)
{
  static char func[] = "grbSzip";
  size_t nbytes = 0;
  unsigned char *buffer;
  size_t buffersize;
  static int lszip_warn = 1;

  buffersize = gribbuffersize;
  buffer = (unsigned char *) malloc(buffersize);

  memcpy(buffer, gribbuffer, gribbuffersize);
  
  if ( filetype == FILETYPE_GRB )
    {
      nbytes = gribZip(gribbuffer, (long) gribbuffersize, buffer, (long) buffersize);
    }
  else
    {
      if ( lszip_warn ) Warning(func, "Szip compression of GRIB2 records not implemented!");
      lszip_warn = 0;
      nbytes = gribbuffersize;
    }
      
  free(buffer);

  return (nbytes);
}


int grbWriteVarSliceDP(int streamID, int varID, int levelID, const double *data, int nmiss)
{
  static char func[] = "grbWriteVarSliceDP";
  size_t nwrite;
  int fileID;
  int gridID;
  int zaxisID;
  unsigned char *gribbuffer = NULL;
  size_t gribbuffersize = 0;
  long datasize;
  int tsID;
  int vlistID;
  int date, time;
  int tsteptype;
  int numavg = 0;
  size_t nbytes;
  int filetype;
  stream_t *streamptr;
  int ljpeg = 0;
  int ljpeg_warn = 1;
  void *gh = NULL;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  filetype  = streamptr->filetype;

  fileID    = streamInqFileID(streamID);
  vlistID   = streamInqVlist(streamID);
  gridID    = vlistInqVarGrid(vlistID, varID);
  zaxisID   = vlistInqVarZaxis(vlistID, varID);
  tsteptype = vlistInqVarTsteptype(vlistID, varID);

  tsID      = streamptr->curTsID;
  date      = streamptr->tsteps[tsID].taxis.vdate;
  time      = streamptr->tsteps[tsID].taxis.vtime;
  if ( vlistInqVarTimave(vlistID, varID) )
    numavg = streamptr->tsteps[tsID].taxis.numavg;

  if ( CDI_Debug )
    Message(func, "gridID = %d zaxisID = %d", gridID, zaxisID);

  datasize = gridInqSize(gridID);

  gribbuffersize = datasize*4+3000;
  gribbuffer = (unsigned char *) malloc(gribbuffersize);

  if ( filetype == FILETYPE_GRB2 )
    {
      int ngrids = vlistNgrids(vlistID);
      int ghindex = ngrids*vlistGridIndex(vlistID, gridID) + vlistZaxisIndex(vlistID, zaxisID);
      if ( ghindex >= streamptr->gribHandleNums )
	Error(func, "Internal problem, grib handle not found!");
      gh = streamptr->gribHandle[ghindex];
    }

  if ( streamptr->ztype == COMPRESS_JPEG )
    {
      if ( filetype == FILETYPE_GRB2 )
	ljpeg = 1;
      else
	{
	  if ( ljpeg_warn ) Warning(func, "Jpeg compression of GRIB1 records not available!");
	  ljpeg_warn = 0;
	}
    }

  nbytes = grbEncode(filetype, varID, levelID, vlistID, gridID, zaxisID, date, time, tsteptype, numavg, 
		     datasize, data, nmiss, gribbuffer, gribbuffersize, ljpeg, gh);

  if ( streamptr->ztype == COMPRESS_SZIP )
    nbytes = grbSzip(filetype, gribbuffer, nbytes);

  nwrite = fileWrite(fileID, gribbuffer, nbytes);
  if ( nwrite != nbytes ) perror(func);

  if ( gribbuffer ) free(gribbuffer);

  return ((int)nwrite);
}


void grbWriteVarDP(int streamID, int varID, const double *data, int nmiss)
{
  int vlistID, gridID, zaxisID, levelID, nlevs;
  int gridsize;

  vlistID  = streamInqVlist(streamID);
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  zaxisID  = vlistInqVarZaxis(vlistID, varID);
  nlevs    = zaxisInqSize(zaxisID);

  for ( levelID = 0; levelID < nlevs; levelID++ )
    {
      grbWriteVarSliceDP(streamID, varID, levelID, data+levelID*gridsize, nmiss);
    }
}


int grbCopyRecord(int streamID2, int streamID1)
{
  static char func[] = "grbCopyRecord";
  int fileID1, fileID2;
  int tsID, recID, vrecID;
  long recsize;
  size_t gribbuffersize;
  off_t recpos;
  size_t nwrite;
  unsigned char *gribbuffer;
  int filetype;
  size_t nbytes;
  long unzipsize;
  int izip;
  stream_t *streamptr1;
  stream_t *streamptr2;

  streamptr1 = stream_to_pointer(streamID1);
  streamptr2 = stream_to_pointer(streamID2);

  stream_check_ptr(func, streamptr1);
  stream_check_ptr(func, streamptr2);

  filetype = streamptr1->filetype;

  fileID1 = streamInqFileID(streamID1);
  fileID2 = streamInqFileID(streamID2);

  tsID    = streamptr1->curTsID;
  vrecID  = streamptr1->tsteps[tsID].curRecID;
  recID   = streamptr1->tsteps[tsID].recIDs[vrecID];
  recpos  = streamptr1->tsteps[tsID].records[recID].position;
  recsize = streamptr1->tsteps[tsID].records[recID].size;

  fileSetPos(fileID1, recpos, SEEK_SET);

  gribbuffersize = recsize == (recsize>>3)<<3 ? recsize : (1+(recsize>>3))<<3;

  gribbuffer = (unsigned char *) malloc(gribbuffersize);

  fileRead(fileID1, gribbuffer, recsize);

  nbytes = recsize;

  izip = gribGetZip(recsize, gribbuffer, &unzipsize);
  
  if ( izip == 0 )
    if ( streamptr2->ztype == COMPRESS_SZIP )
      nbytes = grbSzip(filetype, gribbuffer, nbytes);

  while ( nbytes & 7 ) gribbuffer[nbytes++] = 0;

  nwrite = fileWrite(fileID2, gribbuffer, nbytes);
  if ( nwrite != nbytes ) perror(func);

  free(gribbuffer);

  return ((int)nwrite);
}


int grbWriteRecord(int streamID, const double *data, int nmiss)
{
  static char func[] = "grbWriteRecord";
  int status = 0;
  int varID, levelID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  varID   = streamptr->record->varID;
  levelID = streamptr->record->levelID;

  status = grbWriteVarSliceDP(streamID, varID, levelID, data, nmiss);

  return (status);
}


void streamInqGinfo(int streamID, int *intnum, float *fltnum)
{
  static char func[] = "streamInqGinfo";
  int recID, vrecID, tsID;
  int filetype;
  void *gribbuffer;
  long recsize;
  long gribbuffersize;
  off_t recpos;
  int zip;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  filetype = streamptr->filetype;

  if ( filetype == FILETYPE_GRB )
    {
      tsID    = streamptr->curTsID;
      vrecID  = streamptr->tsteps[tsID].curRecID;
      recID   = streamptr->tsteps[tsID].recIDs[vrecID];
      recpos  = streamptr->tsteps[tsID].records[recID].position;
      recsize = streamptr->tsteps[tsID].records[recID].size;
      zip     = streamptr->tsteps[tsID].records[recID].zip;

      gribbuffer = streamptr->record->buffer;
      gribbuffersize = streamptr->record->buffersize;

      if ( zip > 0 )
	Error(func, "Compressed GRIB records unsupported!");
      else
	gribGinfo(recpos, gribbuffersize, (unsigned char *) gribbuffer, intnum, fltnum);
    }
}
#if defined (HAVE_CONFIG_H)
#endif





#undef  UNDEFID
#define UNDEFID  CDI_UNDEFID

#define SINGLE_PRECISION  4
#define DOUBLE_PRECISION  8

#if defined (HAVE_LIBSERVICE)


typedef struct {
  int param;
  int level;
} SRVCOMPVAR; 


int srvInqDatatype(int prec)
{
  int datatype;

  if ( prec == DOUBLE_PRECISION ) datatype = DATATYPE_FLT64;
  else                            datatype = DATATYPE_FLT32;

  return (datatype);
}


int srvDefDatatype(int datatype)
{
  static char func[] = "srvDefDatatype";
  int prec;

  if ( datatype == DATATYPE_CPX32 || datatype == DATATYPE_CPX64 )
    Error(func, "CDI/SERVICE library does not support complex numbers!");

  if ( datatype != DATATYPE_FLT32 && datatype != DATATYPE_FLT64 )
    datatype = DATATYPE_FLT32;

  if ( datatype == DATATYPE_FLT64 ) prec = DOUBLE_PRECISION;
  else                              prec = SINGLE_PRECISION;

  return (prec);
}


int srvInqRecord(int streamID, int *varID, int *levelID)
{
  static char func[] = "srvInqRecord";
  int status;
  int fileID;
  int icode, ilevel;
  int zaxisID = -1;
  int header[8];
  int vlistID;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);
  srvp    = streamptr->record->srvp;

  *varID   = -1;
  *levelID = -1;

  status = srvRead(fileID, srvp);
  if ( status != 0 ) return (0);

  srvInqHeader(srvp, header);

  icode  = header[0];
  ilevel = header[1];

  *varID = vlistInqVarID(vlistID, icode);

  if ( *varID == UNDEFID ) Error(func, "Code %d undefined", icode);

  zaxisID = vlistInqVarZaxis(vlistID, *varID);

  *levelID = zaxisInqLevelID(zaxisID, (double) ilevel);
  
  return (1);
}


int srvReadRecord(int streamID, double *data, int *nmiss)
{
  static char func[] = "srvReadRecord";
  int vlistID, fileID;
  int status;
  int recID, vrecID, tsID;
  off_t recpos;
  int header[8];
  int varID, gridID;
  int i, size;
  double missval;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);
  tsID    = streamptr->curTsID;
  vrecID  = streamptr->tsteps[tsID].curRecID;
  recID   = streamptr->tsteps[tsID].recIDs[vrecID];
  recpos  = streamptr->tsteps[tsID].records[recID].position;
  varID   = streamptr->tsteps[tsID].records[recID].varID;
  srvp    = streamptr->record->srvp;

  fileSetPos(fileID, recpos, SEEK_SET);

  status = srvRead(fileID, srvp);
  if ( status != 0 ) return (0);

  srvInqHeader(srvp, header);
  srvInqDataDP(srvp, data);

  missval = vlistInqVarMissval(vlistID, varID);
  gridID  = vlistInqVarGrid(vlistID, varID);
  size    = gridInqSize(gridID);

  streamptr->numvals += size;

  *nmiss = 0;
  for ( i = 0; i < size; i++ )
    if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
      {
	data[i] = missval;
	(*nmiss)++;
      }

  return (1);
}


int srvCopyRecord(int streamID2, int streamID1)
{
  static char func[] = "srvCopyRecord";
  int fileID1, fileID2;
  int tsID, recID, vrecID;
  long recsize;
  off_t recpos;
  int status = 0;
  char *buffer;
  stream_t *streamptr1;
  stream_t *streamptr2;

  streamptr1 = stream_to_pointer(streamID1);
  streamptr2 = stream_to_pointer(streamID2);

  stream_check_ptr(func, streamptr1);
  stream_check_ptr(func, streamptr2);

  fileID1 = streamInqFileID(streamID1);
  fileID2 = streamInqFileID(streamID2);

  tsID    = streamptr1->curTsID;
  vrecID  = streamptr1->tsteps[tsID].curRecID;
  recID   = streamptr1->tsteps[tsID].recIDs[vrecID];
  recpos  = streamptr1->tsteps[tsID].records[recID].position;
  recsize = streamptr1->tsteps[tsID].records[recID].size;

  fileSetPos(fileID1, recpos, SEEK_SET);

  buffer = (char *) malloc(recsize);

  fileRead(fileID1, buffer, recsize);

  fileWrite(fileID2, buffer, recsize);

  free(buffer);

  return (status);
}


int srvDefRecord(int streamID)
{
  static char func[] = "srvDefRecord";
  int fileID;
  int gridID;
  int header[8];
  int status = 0;
  int xsize, ysize;
  int datatype;
  int pdis, pcat, pnum;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID = streamInqFileID(streamID);
  gridID = streamptr->record->gridID;
  srvp   = streamptr->record->srvp;

  cdiDecodeParam(streamptr->record->param, &pnum, &pcat, &pdis);
  header[0] = pnum;
  header[1] = streamptr->record->level;
  header[2] = streamptr->record->date;
  header[3] = streamptr->record->time;

  xsize = gridInqXsize(gridID);
  ysize = gridInqYsize(gridID);
  if ( xsize == 0 || ysize == 0 )
    {
      xsize = gridInqSize(gridID);
      ysize = 1;
    }
  if ( gridInqType(gridID) == GRID_CELL ) ysize = 1;
  if ( gridInqSize(gridID) != xsize*ysize )
    Error(func, "Internal problem with gridsize!");

  header[4] = xsize;
  header[5] = ysize;
  header[6] = 0;
  header[7] = 0;

  datatype = streamptr->record->prec;

  srvp->dprec = srvDefDatatype(datatype);

  srvDefHeader(srvp, header);

  return (status);
}


int srvWriteRecord(int streamID, const double *data)
{
  static char func[] = "srvWriteRecord";
  int fileID;
  int status = 0;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID = streamInqFileID(streamID);
  srvp   = streamptr->record->srvp;

  srvDefDataDP(srvp, data);

  srvWrite(fileID, srvp);

  return (status);
}


void srvAddRecord(int streamID, int param, int level, int xsize, int ysize,
		  long recsize, off_t position, int prec)
{
  static char func[] = "srvAddRecord";
  int leveltype;
  int gridID = UNDEFID;
  int levelID = 0;
  int tsID, recID, varID;
  int datatype;
  record_t *record;
  grid_t grid;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  tsID    = streamptr->curTsID;
  recID   = recordNewEntry(streamID, tsID);
  record  = &streamptr->tsteps[tsID].records[recID];

  (*record).size     = recsize;
  (*record).position = position;
  (*record).param    = param;
  (*record).ilevel   = level;

  memset(&grid, 0, sizeof(grid_t));
  grid.type  = GRID_GENERIC; 
  grid.size  = xsize*ysize;
  grid.xsize = xsize;
  grid.ysize = ysize;
  grid.xvals = NULL;
  grid.yvals = NULL;
  gridID = varDefGrid(vlistID, grid, 0);
  /*
  if ( level == 0 ) leveltype = ZAXIS_SURFACE;
  else              leveltype = ZAXIS_GENERIC;
  */
  leveltype = ZAXIS_GENERIC;

  datatype = srvInqDatatype(prec);

  varAddRecord(recID, param, gridID, leveltype, 0, level, 0,
	       datatype, &varID, &levelID, 0, 0, 0, NULL, NULL, NULL);

  (*record).varID   = varID;
  (*record).levelID = levelID;

  streamptr->tsteps[tsID].nallrecs++;
  streamptr->nrecs++;

  if ( CDI_Debug )
    Message(func, "varID = %d gridID = %d levelID = %d",
	    varID, gridID, levelID);
}


void srvCmpRecord(int streamID, int tsID, int recID, off_t position, int param,
		  int level, int xsize, int ysize)
{
  static char func[] = "srvCmpRecord";
  int varID = 0;
  int levelID = 0;
  record_t *record;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  record  = &streamptr->tsteps[tsID].records[recID];

  if ( param != (*record).param || level != (*record).ilevel )
    Error(func, "inconsistent timestep");

  (*record).position = position;
  /*
  varID   = (*record).varID;
  levelID = (*record).levelID;

  streamptr->vars[varID].level[levelID] = recID;

  streamptr->tsteps[tsID].nallrecs++;
  streamptr->nrecs++;
  */
  if ( CDI_Debug )
    Message(func, "varID = %d levelID = %d", varID, levelID);
}


void srvScanTimestep1(int streamID)
{  
  static char func[] = "srvScanTimestep1";
  int header[8];
  int prec = 0;
  int status;
  int fileID;
  int rxsize = 0, rysize = 0;
  int param = 0;
  int rcode = 0, rlevel = 0, vdate = 0, vtime = 0;
  DateTime datetime, datetime0;
  int tsID;
  int varID;
  long recsize;
  off_t recpos;
  int nrecords, nrecs, recID;
  int taxisID = -1;
  taxis_t *taxis;
  int vlistID;
  SRVCOMPVAR compVar, compVar0;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->curTsID = 0;

  srvp  = streamptr->record->srvp;
  tsID  = tstepsNewEntry(streamID);
  taxis = &streamptr->tsteps[tsID].taxis;

  if ( tsID != 0 )
    Error(func, "Internal problem! tstepsNewEntry returns %d", tsID);

  fileID = streamInqFileID(streamID);

  nrecs = 0;
  while ( TRUE )
    {
      recpos = fileGetPos(fileID);
      status = srvRead(fileID, srvp);
      if ( status != 0 )
	{
	  streamptr->ntsteps = 1;
	  break;
	}
      recsize = fileGetPos(fileID) - recpos;

      srvInqHeader(srvp, header);

      prec   = srvp->dprec;
      rcode  = header[0];
      rlevel = header[1];
      vdate  = header[2];
      vtime  = header[3];
      rxsize = header[4];
      rysize = header[5];

      param = cdiEncodeParam(rcode, 255, 255);

      if ( nrecs == 0 )
	{
	  datetime0.date = vdate;
	  datetime0.time = vtime;
	}
      else
	{
	  datetime.date = vdate;
	  datetime.time = vtime;
	  compVar.param = param;
          compVar.level = rlevel;
	  for ( recID = 0; recID < nrecs; recID++ )
	    {
	      compVar0.param = streamptr->tsteps[0].records[recID].param;
	      compVar0.level = streamptr->tsteps[0].records[recID].ilevel;

	      if ( memcmp(&compVar0, &compVar, sizeof(SRVCOMPVAR)) == 0 ) break;
	    }
	  if ( recID < nrecs ) break;
	  if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) )
	    Warning(func, "Inconsistent verification time for code %d level %d", rcode, rlevel);
	}

      nrecs++;

      if ( CDI_Debug )
	Message(func, "%4d%8d%4d%8d%8d%6d", nrecs, (int)recpos, rcode, rlevel, vdate, vtime);

      srvAddRecord(streamID, param, rlevel, rxsize, rysize, recsize, recpos, prec);
    }

  streamptr->rtsteps = 1;

  cdiGenVars(streamID);

  taxisID = taxisCreate(TAXIS_ABSOLUTE);
  taxis->type  = TAXIS_ABSOLUTE;
  taxis->vdate = datetime0.date;
  taxis->vtime = datetime0.time;

  vlistID = streamInqVlist(streamID);
  vlistDefTaxis(vlistID, taxisID);

  cdiCheckContents(streamID);

  nrecords = streamptr->tsteps[0].nallrecs;
  if ( nrecords < streamptr->tsteps[0].recordSize )
    {
      streamptr->tsteps[0].recordSize = nrecords;
      streamptr->tsteps[0].records =
	(record_t *) realloc(streamptr->tsteps[0].records, nrecords*sizeof(record_t));
    }

  streamptr->tsteps[0].recIDs = (int *) malloc(nrecords*sizeof(int));
  streamptr->tsteps[0].nrecs = nrecords;
  for ( recID = 0; recID < nrecords; recID++ )
    streamptr->tsteps[0].recIDs[recID] = recID;

  if ( streamptr->ntsteps == -1 )
    {
      tsID = tstepsNewEntry(streamID);
      if ( tsID != streamptr->rtsteps )
	Error(func, "Internal error. tsID = %d", tsID);

      streamptr->tsteps[tsID-1].next   = TRUE;
      streamptr->tsteps[tsID].position = recpos;
    }

  if ( streamptr->ntsteps == 1 )
    {
      if ( taxis->vdate == 0 && taxis->vtime == 0 )
	{
	  streamptr->ntsteps = 0;
	  for ( varID = 0; varID < streamptr->nvars; varID++ )
	    {
	      vlistDefVarTime(vlistID, varID, TIME_CONSTANT);
	    }
	}
    }
}


int srvScanTimestep2(int streamID)
{  
  static char func[] = "srvScanTimestep2";
  int header[8];
  int status;
  int fileID;
  int param = 0;
  int rcode = 0, rlevel = 0, vdate = 0, vtime = 0;
  int tsID;
  int varID;
  long recsize;
  off_t recpos = 0;
  int nrecords, nrecs, recID, rindex;
  int nextstep;
  taxis_t *taxis;
  int vlistID;
  SRVCOMPVAR compVar, compVar0;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->curTsID = 1;

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);
  srvp    = streamptr->record->srvp;

  tsID = streamptr->rtsteps;
  if ( tsID != 1 )
    Error(func, "Internal problem! unexpeceted timestep %d", tsID+1);

  taxis = &streamptr->tsteps[tsID].taxis;

  fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);

  cdiCreateRecords(streamID, tsID);

  nrecords = streamptr->tsteps[0].nallrecs;
  streamptr->tsteps[1].recIDs = (int *) malloc(nrecords*sizeof(int));
  streamptr->tsteps[1].nrecs = 0;
  for ( recID = 0; recID < nrecords; recID++ )
    streamptr->tsteps[1].recIDs[recID] = -1;

  for ( recID = 0; recID < nrecords; recID++ )
    {
      varID = streamptr->tsteps[0].records[recID].varID;
      streamptr->tsteps[tsID].records[recID].position = 
	streamptr->tsteps[0].records[recID].position;
      streamptr->tsteps[tsID].records[recID].size     = 
	streamptr->tsteps[0].records[recID].size;
    }

  for ( rindex = 0; rindex <= nrecords; rindex++ )
    {
      recpos = fileGetPos(fileID);
      status = srvRead(fileID, srvp);
      if ( status != 0 )
	{
	  streamptr->ntsteps = 2;
	  break;
	}
      recsize = fileGetPos(fileID) - recpos;

      srvInqHeader(srvp, header);

      rcode  = header[0];
      rlevel = header[1];
      vdate  = header[2];
      vtime  = header[3];

      param = cdiEncodeParam(rcode, 255, 255);

      if ( rindex == 0 )
	{
	  taxis->type  = TAXIS_ABSOLUTE;
	  taxis->vdate = vdate;
	  taxis->vtime = vtime;
	}

      compVar.param = param;
      compVar.level = rlevel;
      nextstep = FALSE;
      for ( recID = 0; recID < nrecords; recID++ )
	{
	  compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
	  compVar0.level = streamptr->tsteps[tsID].records[recID].ilevel;

	  if ( memcmp(&compVar0, &compVar, sizeof(SRVCOMPVAR)) == 0 )
	    {
	      if ( streamptr->tsteps[tsID].records[recID].used )
		{
		  nextstep = TRUE;
		}
	      else
		{
		  streamptr->tsteps[tsID].records[recID].used = TRUE;
		  streamptr->tsteps[tsID].recIDs[rindex] = recID;
		}
	      break;
	    }
	}
      if ( recID == nrecords )
	{
	  Warning(func, "Code %d level %d not found at timestep %d", rcode, rlevel, tsID+1);
	  return (CDI_EUFSTRUCT);
	}

      if ( nextstep ) break;

      if ( CDI_Debug )
	Message(func, "%4d%8d%4d%8d%8d%6d", rindex+1, (int)recpos, rcode, rlevel, vdate, vtime);

      streamptr->tsteps[tsID].records[recID].size = recsize;

      compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
      compVar0.level = streamptr->tsteps[tsID].records[recID].ilevel;

      if ( memcmp(&compVar0, &compVar, sizeof(SRVCOMPVAR)) != 0 )
	{
	  Message(func, "tsID = %d recID = %d param = %3d new %3d  level = %3d new %3d",
		  tsID, recID,
		  streamptr->tsteps[tsID].records[recID].param, param,
		  streamptr->tsteps[tsID].records[recID].ilevel, rlevel);
	  return (CDI_EUFSTRUCT);
	}

      streamptr->tsteps[1].records[recID].position = recpos;
    }

  nrecs = 0;
  for ( recID = 0; recID < nrecords; recID++ )
    {
      if ( ! streamptr->tsteps[tsID].records[recID].used )
	{
	  varID = streamptr->tsteps[tsID].records[recID].varID;
	  vlistDefVarTime(vlistID, varID, TIME_CONSTANT);
	}
      else
	{
	  nrecs++;
	}
    }
  streamptr->tsteps[tsID].nrecs = nrecs;

  streamptr->rtsteps = 2;

  if ( streamptr->ntsteps == -1 )
    {
      tsID = tstepsNewEntry(streamID);
      if ( tsID != streamptr->rtsteps )
	Error(func, "Internal error. tsID = %d", tsID);

      streamptr->tsteps[tsID-1].next   = TRUE;
      streamptr->tsteps[tsID].position = recpos;
    }

  return (0);
}


int srvInqContents(int streamID)
{
  static char func[] = "srvInqContents";
  int fileID;
  int status = 0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID = streamInqFileID(streamID);

  streamptr->curTsID = 0;

  srvScanTimestep1(streamID);
 
  if ( streamptr->ntsteps == -1 ) status = srvScanTimestep2(streamID);

  fileSetPos(fileID, 0, SEEK_SET);

  return (status);
}


int srvScanTimestep(int streamID)
{
  static char func[] = "srvScanTimestep";
  int header[8];
  int status;
  int fileID;
  int tsID;
  int rxsize = 0, rysize = 0;
  int param = 0;
  int rcode = 0, rlevel = 0, vdate = 0, vtime = 0;
  long recsize = 0;
  off_t recpos = 0;
  int recID;
  taxis_t *taxis;
  int rindex, nrecs = 0;
  SRVCOMPVAR compVar, compVar0;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  if ( CDI_Debug )
    {
      Message(func, "streamID = %d", streamID);
      Message(func, "cts = %d", streamptr->curTsID);
      Message(func, "rts = %d", streamptr->rtsteps);
      Message(func, "nts = %d", streamptr->ntsteps);
    }

  if ( streamptr->rtsteps == 0 )
    Error(func, "Internal problem! Missing contents.");

  srvp  = streamptr->record->srvp;
  tsID  = streamptr->rtsteps;
  taxis = &streamptr->tsteps[tsID].taxis;

  if ( streamptr->tsteps[tsID].recordSize == 0 )
    {
      cdiCreateRecords(streamID, tsID);

      nrecs = streamptr->tsteps[1].nrecs;

      streamptr->tsteps[tsID].nrecs = nrecs;
      streamptr->tsteps[tsID].recIDs = (int *) malloc(nrecs*sizeof(int));
      for ( recID = 0; recID < nrecs; recID++ )
	streamptr->tsteps[tsID].recIDs[recID] = streamptr->tsteps[1].recIDs[recID];

      fileID = streamInqFileID(streamID);

      fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);

      for ( rindex = 0; rindex <= nrecs; rindex++ )
	{
	  recpos = fileGetPos(fileID);
	  status = srvRead(fileID, srvp);
	  if ( status != 0 )
	    {
	      streamptr->ntsteps = streamptr->rtsteps + 1;
	      break;
	    }
	  recsize = fileGetPos(fileID) - recpos;

	  srvInqHeader(srvp, header);

	  rcode  = header[0];
	  rlevel = header[1];
	  vdate  = header[2];
	  vtime  = header[3];
	  rxsize = header[4];
	  rysize = header[5];

	  param = cdiEncodeParam(rcode, 255, 255);

	  if ( rindex == nrecs ) break;
	  recID = streamptr->tsteps[tsID].recIDs[rindex];

	  if ( rindex == 0 )
	    {
	      taxis->type  = TAXIS_ABSOLUTE;
	      taxis->vdate = vdate;
	      taxis->vtime = vtime;
	    }
	  /*
	  srvCmpRecord(streamID, tsID, nrecs, recpos, param, rlevel, rxsize, rysize);
	  */
	  compVar.param  = param;
          compVar.level  = rlevel;
	  compVar0.param = streamptr->tsteps[tsID].records[recID].param;
	  compVar0.level = streamptr->tsteps[tsID].records[recID].ilevel;

	  if ( memcmp(&compVar0, &compVar, sizeof(SRVCOMPVAR)) != 0 )
	    {
	      Message(func, "tsID = %d recID = %d param = %3d new %3d  level = %3d new %3d",
		      tsID, recID,
		      streamptr->tsteps[tsID].records[recID].param, param,
		      streamptr->tsteps[tsID].records[recID].ilevel, rlevel);
	      Error(func, "Invalid, unsupported or inconsistent record structure");
	    }

	  streamptr->tsteps[tsID].records[recID].position = recpos;
	  streamptr->tsteps[tsID].records[recID].size = recsize;

	  if ( CDI_Debug )
	    Message(func, "%4d%8d%4d%8d%8d%6d", rindex, (int)recpos, rcode, rlevel, vdate, vtime);
	}

      streamptr->rtsteps++;

      if ( streamptr->ntsteps != streamptr->rtsteps )
	{
	  tsID = tstepsNewEntry(streamID);
	  if ( tsID != streamptr->rtsteps )
	    Error(func, "Internal error. tsID = %d", tsID);

	  streamptr->tsteps[tsID-1].next   = 1;
	  streamptr->tsteps[tsID].position = recpos;
	}

      fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);
      streamptr->tsteps[tsID].position = recpos;
    }

  if ( nrecs > 0 && nrecs < streamptr->tsteps[tsID].nrecs )
    {
      Warning(func, "Incomplete timestep. Stop scanning at timestep %d.\n", tsID);
      streamptr->ntsteps = tsID;
    }

  return (streamptr->ntsteps);
}


int srvInqTimestep(int streamID, int tsID)
{
  static char func[] = "srvInqTimestep";
  int ntsteps, nrecs;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  if ( tsID == 0 && streamptr->rtsteps == 0 )
    Error(func, "Call to cdiInqContents missing!");

  if ( CDI_Debug )
    Message(func, "tsID = %d rtsteps = %d", tsID, streamptr->rtsteps);
  
  ntsteps = UNDEFID;
  while ( ( tsID + 1 ) > streamptr->rtsteps && ntsteps == UNDEFID )
    ntsteps = srvScanTimestep(streamID);

  if ( tsID >= streamptr->ntsteps && streamptr->ntsteps != CDI_UNDEFID )
    {
      nrecs = 0;
    }
  else
    {
      streamptr->curTsID = tsID;
      nrecs = streamptr->tsteps[tsID].nrecs;
    }

  return (nrecs);
}


void srvReadVarDP(int streamID, int varID, double *data, int *nmiss)
{
  static char func[] = "srvReadVarDP";
  int vlistID, fileID;
  int levID, nlevs, gridID, gridsize;
  off_t recpos, currentfilepos;
  int header[8];
  int tsid;
  int recID;
  int i;
  int status;
  double missval;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  srvp     = streamptr->record->srvp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  nlevs    = streamptr->vars[varID].nlevs;
  missval  = vlistInqVarMissval(vlistID, varID);
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  tsid     = streamptr->curTsID;

  if ( CDI_Debug )
    Message(func, "nlevs = %d gridID = %d gridsize = %d", nlevs, gridID, gridsize);

  currentfilepos = fileGetPos(fileID);

  for (levID = 0; levID < nlevs; levID++)
    {
      recID = streamptr->vars[varID].level[levID];
      recpos = streamptr->tsteps[tsid].records[recID].position;
      fileSetPos(fileID, recpos, SEEK_SET);
      status = srvRead(fileID, srvp);
      srvInqHeader(srvp, header);
      srvInqDataDP(srvp, &data[levID*gridsize]);
    }
  fileSetPos(fileID, currentfilepos, SEEK_SET);

  *nmiss = 0;
  for ( i = 0; i < nlevs*gridsize; i++ )
    if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
      {
	data[i] = missval;
	(*nmiss)++;
      }
}


void srvReadVarSliceDP(int streamID, int varID, int levID, double *data, int *nmiss)
{
  static char func[] = "srvReadVarSliceDP";
  int vlistID, fileID;
  int nlevs, gridID, gridsize;
  off_t recpos, currentfilepos;
  int header[8];
  int tsid;
  int recID;
  int i;
  int status;
  double missval;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  srvp     = streamptr->record->srvp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  nlevs    = streamptr->vars[varID].nlevs;
  missval  = vlistInqVarMissval(vlistID, varID);
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  tsid     = streamptr->curTsID;

  if ( CDI_Debug )
    Message(func, "nlevs = %d gridID = %d gridsize = %d",
	     nlevs, gridID, gridsize);

  currentfilepos = fileGetPos(fileID);

  recID = streamptr->vars[varID].level[levID];
  recpos = streamptr->tsteps[tsid].records[recID].position;
  fileSetPos(fileID, recpos, SEEK_SET);
  status = srvRead(fileID, srvp);
  srvInqHeader(srvp, header);
  srvInqDataDP(srvp, data);

  fileSetPos(fileID, currentfilepos, SEEK_SET);

  *nmiss = 0;
  for ( i = 0; i < gridsize; i++ )
    if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
      {
	data[i] = missval;
	(*nmiss)++;
      }
}


void srvWriteVarDP(int streamID, int varID, const double *data)
{
  static char func[] = "srvWriteVarDP";
  int fileID;
  int levID, nlevs, gridID, gridsize;
  int zaxisID;
  double level;
  int header[8];
  int xsize, ysize;
  int datatype;
  int tsID;
  int vlistID;
  int pdis, pcat, pnum;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d  varID = %d", streamID, varID);

  srvp     = streamptr->record->srvp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  tsID     = streamptr->curTsID;
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  zaxisID  = vlistInqVarZaxis(vlistID, varID);
  nlevs    = zaxisInqSize(zaxisID);

  if ( CDI_Debug )
    Message(func, "nlevs = %d gridID = %d gridsize = %d", nlevs, gridID, gridsize);

  cdiDecodeParam(vlistInqVarParam(vlistID, varID), &pnum, &pcat, &pdis);

  header[0] = pnum;
  header[2] = streamptr->tsteps[tsID].taxis.vdate;
  header[3] = streamptr->tsteps[tsID].taxis.vtime;

  xsize = gridInqXsize(gridID);
  ysize = gridInqYsize(gridID);
  if ( xsize == 0 || ysize == 0 )
    {
      xsize = gridInqSize(gridID);
      ysize = 1;
    }
  if ( gridInqType(gridID) == GRID_CELL ) ysize = 1;
  if ( gridInqSize(gridID) != xsize*ysize )
    Error(func, "Internal problem with gridsize!");

  header[4] = xsize;
  header[5] = ysize;
  header[6] = 0;
  header[7] = 0;

  datatype = vlistInqVarDatatype(vlistID, varID);

  srvp->dprec = srvDefDatatype(datatype);

  for ( levID = 0; levID < nlevs; levID++ )
    {
      level = zaxisInqLevel(zaxisID, levID);

      header[1] = (int) level;
      srvDefHeader(srvp, header);
      srvDefDataDP(srvp, &data[levID*gridsize]);
      srvWrite(fileID, srvp);
    }
}


void srvWriteVarSliceDP(int streamID, int varID, int levID, const double *data)
{
  static char func[] = "srvWriteVarSliceDP";
  int fileID;
  int gridID;
  int zaxisID;
  double level;
  int header[8];
  int xsize, ysize;
  int datatype;
  int tsID;
  int vlistID;
  int pdis, pcat, pnum;
  srvrec_t *srvp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  srvp     = streamptr->record->srvp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  tsID     = streamptr->curTsID;
  gridID   = vlistInqVarGrid(vlistID, varID);
  zaxisID  = vlistInqVarZaxis(vlistID, varID);
  level    = zaxisInqLevel(zaxisID, levID);

  if ( CDI_Debug )
    Message(func, "gridID = %d zaxisID = %d", gridID, zaxisID);

  cdiDecodeParam(vlistInqVarParam(vlistID, varID), &pnum, &pcat, &pdis);

  header[0] = pnum;
  header[1] = (int) level;
  header[2] = streamptr->tsteps[tsID].taxis.vdate;
  header[3] = streamptr->tsteps[tsID].taxis.vtime;

  xsize = gridInqXsize(gridID);
  ysize = gridInqYsize(gridID);
  if ( xsize == 0 || ysize == 0 )
    {
      xsize = gridInqSize(gridID);
      ysize = 1;
    }
  if ( gridInqType(gridID) == GRID_CELL ) ysize = 1;
  if ( gridInqSize(gridID) != xsize*ysize )
    Error(func, "Internal problem with gridsize!");

  header[4] = xsize;
  header[5] = ysize;
  header[6] = 0;
  header[7] = 0;

  datatype = vlistInqVarDatatype(vlistID, varID);

  srvp->dprec = srvDefDatatype(datatype);

  srvDefHeader(srvp, header);
  srvDefDataDP(srvp, data);
  srvWrite(fileID, srvp);
}

#endif /* HAVE_LIBSERVICE */
#if defined (HAVE_CONFIG_H)
#endif





#undef  UNDEFID
#define UNDEFID  CDI_UNDEFID

#define SINGLE_PRECISION  4
#define DOUBLE_PRECISION  8

#if defined (HAVE_LIBEXTRA)


typedef struct {
  int param;
  int level;
} extcompvar_t; 

static
int extInqDatatype(int prec, int number)
{
  int datatype;

  if ( number == 2 )
    {
      if ( prec == DOUBLE_PRECISION ) datatype = DATATYPE_CPX64;
      else                            datatype = DATATYPE_CPX32;
    }
  else
    {
      if ( prec == DOUBLE_PRECISION ) datatype = DATATYPE_FLT64;
      else                            datatype = DATATYPE_FLT32;
    }

  return (datatype);
}

static
void extDefDatatype(int datatype, int *prec, int *number)
{

  if ( datatype != DATATYPE_FLT32 && datatype != DATATYPE_FLT64 &&
       datatype != DATATYPE_CPX32 && datatype != DATATYPE_CPX64 )
    datatype = DATATYPE_FLT32;

  if ( datatype == DATATYPE_CPX32 || datatype == DATATYPE_CPX64 )
    *number = 2;
  else
    *number = 1;

  if ( datatype == DATATYPE_FLT64 || datatype == DATATYPE_CPX64 )
    *prec = DOUBLE_PRECISION;
  else 
    *prec = SINGLE_PRECISION;
}

/* not used
int extInqRecord(int streamID, int *varID, int *levelID)
{
  static char func[] = "extInqRecord";
  int status;
  int fileID;
  int icode, ilevel;
  int zaxisID = -1;
  int header[4];
  int vlistID;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);
  extp    = streamptr->record->extp;

  *varID   = -1;
  *levelID = -1;

  status = extRead(fileID, extp);
  if ( status != 0 ) return (0);

  extInqHeader(extp, header);

  icode  = header[1];
  ilevel = header[2];

  *varID = vlistInqVarID(vlistID, icode);

  if ( *varID == UNDEFID ) Error(func, "Code %d undefined", icode);

  zaxisID = vlistInqVarZaxis(vlistID, *varID);

  *levelID = zaxisInqLevelID(zaxisID, (double) ilevel);
  
  return (1);
}
*/

int extReadRecord(int streamID, double *data, int *nmiss)
{
  static char func[] = "extReadRecord";
  int vlistID, fileID;
  int status;
  int recID, vrecID, tsID;
  off_t recpos;
  int header[4];
  int varID, gridID;
  int i, size;
  double missval;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);
  tsID    = streamptr->curTsID;
  vrecID  = streamptr->tsteps[tsID].curRecID;
  recID   = streamptr->tsteps[tsID].recIDs[vrecID];
  recpos  = streamptr->tsteps[tsID].records[recID].position;
  varID   = streamptr->tsteps[tsID].records[recID].varID;
  extp    = streamptr->record->extp;

  fileSetPos(fileID, recpos, SEEK_SET);

  status = extRead(fileID, extp);
  if ( status != 0 ) return (0);

  extInqHeader(extp, header);
  extInqDataDP(extp, data);

  missval = vlistInqVarMissval(vlistID, varID);
  gridID  = vlistInqVarGrid(vlistID, varID);
  size    = gridInqSize(gridID);

  streamptr->numvals += size;

  *nmiss = 0;
  if ( vlistInqVarNumber(vlistID, varID) == CDI_REAL )
    {
      for ( i = 0; i < size; i++ )
	if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
	  {
	    data[i] = missval;
	    (*nmiss)++;
	  }
    }
  else
    {
      for ( i = 0; i < 2*size; i+=2 )
	if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
	  {
	    data[i] = missval;
	    (*nmiss)++;
	  }
    }

  return (1);
}


int extCopyRecord(int streamID2, int streamID1)
{
  static char func[] = "extCopyRecord";
  int fileID1, fileID2;
  int tsID, recID, vrecID;
  long recsize;
  off_t recpos;
  int status = 0;
  char *buffer;
  stream_t *streamptr1;
  stream_t *streamptr2;

  streamptr1 = stream_to_pointer(streamID1);
  streamptr2 = stream_to_pointer(streamID2);

  stream_check_ptr(func, streamptr1);
  stream_check_ptr(func, streamptr2);

  fileID1 = streamInqFileID(streamID1);
  fileID2 = streamInqFileID(streamID2);

  tsID    = streamptr1->curTsID;
  vrecID  = streamptr1->tsteps[tsID].curRecID;
  recID   = streamptr1->tsteps[tsID].recIDs[vrecID];
  recpos  = streamptr1->tsteps[tsID].records[recID].position;
  recsize = streamptr1->tsteps[tsID].records[recID].size;

  fileSetPos(fileID1, recpos, SEEK_SET);

  buffer = (char *) malloc(recsize);

  fileRead(fileID1, buffer, recsize);

  fileWrite(fileID2, buffer, recsize);

  free(buffer);

  return (status);
}


int extDefRecord(int streamID)
{
  static char func[] = "extDefRecord";
  int fileID;
  int gridID;
  int header[4];
  int status = 0;
  int pdis, pcat, pnum;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID   = streamInqFileID(streamID);
  gridID   = streamptr->record->gridID;
  extp     = streamptr->record->extp;

  cdiDecodeParam(streamptr->record->param, &pnum, &pcat, &pdis);
  header[0] = streamptr->record->date;
  header[1] = pnum;
  header[2] = streamptr->record->level;
  header[3] = gridInqSize(gridID);

  extDefDatatype(streamptr->record->prec, &extp->prec, &extp->number);

  extDefHeader(extp, header);

  return (status);
}


int extWriteRecord(int streamID, const double *data)
{
  static char func[] = "extWriteRecord";
  int fileID;
  int status = 0;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID = streamInqFileID(streamID);
  extp   = streamptr->record->extp;

  extDefDataDP(extp, data);

  extWrite(fileID, extp);

  return (status);
}

static
void extAddRecord(int streamID, int param, int level, int xysize,
		  long recsize, off_t position, int prec, int number)
{
  static char func[] = "extAddRecord";
  int leveltype;
  int gridID = UNDEFID;
  int levelID = 0;
  int tsID, recID, varID;
  record_t *record;
  grid_t grid;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  tsID    = streamptr->curTsID;
  recID   = recordNewEntry(streamID, tsID);
  record  = &streamptr->tsteps[tsID].records[recID];

  (*record).size     = recsize;
  (*record).position = position;
  (*record).param     = param;
  (*record).ilevel   = level;

  memset(&grid, 0, sizeof(grid_t));
  grid.type  = GRID_GENERIC;
  grid.size  = xysize;
  grid.xsize = xysize;
  grid.ysize = 0;
  grid.xvals = NULL;
  grid.yvals = NULL;
  gridID = varDefGrid(vlistID, grid, 0);
  /*
  if ( level == 0 ) leveltype = ZAXIS_SURFACE;
  else              leveltype = ZAXIS_GENERIC;
  */
  leveltype = ZAXIS_GENERIC;

  varAddRecord(recID, param, gridID, leveltype, 0, level, 0,
	       extInqDatatype(prec, number), &varID, &levelID, 0, 0, 0, NULL, NULL, NULL);

  (*record).varID   = varID;
  (*record).levelID = levelID;

  streamptr->tsteps[tsID].nallrecs++;
  streamptr->nrecs++;

  if ( CDI_Debug )
    Message(func, "varID = %d gridID = %d levelID = %d",
	    varID, gridID, levelID);
}


void extCmpRecord(int streamID, int tsID, int recID, off_t position, int param,
		  int level, int xysize)
{
  static char func[] = "extCmpRecord";
  int varID = 0;
  int levelID = 0;
  record_t *record;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  record  = &streamptr->tsteps[tsID].records[recID];

  if ( param != (*record).param || level != (*record).ilevel )
    Error(func, "inconsistent timestep");

  (*record).position = position;
  /*
  varID   = (*record).varID;
  levelID = (*record).levelID;

  streamptr->vars[varID].level[levelID] = recID;

  streamptr->tsteps[tsID].nallrecs++;
  streamptr->nrecs++;
  */
  if ( CDI_Debug )
    Message(func, "varID = %d levelID = %d", varID, levelID);
}


void extScanTimestep1(int streamID)
{  
  static char func[] = "extScanTimestep1";
  int header[4];
  int status;
  int fileID;
  int rxysize = 0;
  int param = 0;
  int rcode = 0, rlevel = 0, vdate = 0, vtime = 0;
  DateTime datetime, datetime0;
  int tsID;
  int varID;
  long recsize;
  off_t recpos;
  int nrecords, nrecs, recID;
  int taxisID = -1;
  taxis_t *taxis;
  int vlistID;
  extcompvar_t compVar, compVar0;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->curTsID = 0;

  extp  = streamptr->record->extp;
  tsID  = tstepsNewEntry(streamID);
  taxis = &streamptr->tsteps[tsID].taxis;

  if ( tsID != 0 )
    Error(func, "Internal problem! tstepsNewEntry returns %d", tsID);

  fileID = streamInqFileID(streamID);

  nrecs = 0;
  while ( TRUE )
    {
      recpos = fileGetPos(fileID);
      status = extRead(fileID, extp);
      if ( status != 0 )
	{
	  streamptr->ntsteps = 1;
	  break;
	}
      recsize = fileGetPos(fileID) - recpos;

      extInqHeader(extp, header);

      vdate   = header[0];
      vtime   = 0;
      rcode   = header[1];
      rlevel  = header[2];
      rxysize = header[3];

      param = cdiEncodeParam(rcode, 255, 255);

      if ( nrecs == 0 )
	{
	  datetime0.date = vdate;
	  datetime0.time = vtime;
	}
      else
	{
	  datetime.date = vdate;
	  datetime.time = vtime;
	  compVar.param = param;
          compVar.level = rlevel;
	  for ( recID = 0; recID < nrecs; recID++ )
	    {
	      compVar0.param  = streamptr->tsteps[0].records[recID].param;
	      compVar0.level = streamptr->tsteps[0].records[recID].ilevel;

	      if ( memcmp(&compVar0, &compVar, sizeof(extcompvar_t)) == 0 ) break;
	    }
	  if ( recID < nrecs ) break;
	  if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) )
	    Warning(func, "Inconsistent verification time for code %d level %d", rcode, rlevel);
	}

      nrecs++;

      if ( CDI_Debug )
	Message(func, "%4d%8d%4d%8d%8d%6d", nrecs, (int)recpos, rcode, rlevel, vdate, vtime);

      extAddRecord(streamID, param, rlevel, rxysize, recsize, recpos, extp->prec, extp->number);
    }

  streamptr->rtsteps = 1;

  cdiGenVars(streamID);

  taxisID = taxisCreate(TAXIS_ABSOLUTE);
  taxis->type  = TAXIS_ABSOLUTE;
  taxis->vdate = datetime0.date;
  taxis->vtime = datetime0.time;

  vlistID = streamInqVlist(streamID);
  vlistDefTaxis(vlistID, taxisID);

  cdiCheckContents(streamID);

  nrecords = streamptr->tsteps[0].nallrecs;
  if ( nrecords < streamptr->tsteps[0].recordSize )
    {
      streamptr->tsteps[0].recordSize = nrecords;
      streamptr->tsteps[0].records =
      (record_t *) realloc(streamptr->tsteps[0].records, nrecords*sizeof(record_t));
    }

  streamptr->tsteps[0].recIDs = (int *) malloc(nrecords*sizeof(int));
  streamptr->tsteps[0].nrecs = nrecords;
  for ( recID = 0; recID < nrecords; recID++ )
    streamptr->tsteps[0].recIDs[recID] = recID;

  if ( streamptr->ntsteps == -1 )
    {
      tsID = tstepsNewEntry(streamID);
      if ( tsID != streamptr->rtsteps )
	Error(func, "Internal error. tsID = %d", tsID);

      streamptr->tsteps[tsID-1].next   = TRUE;
      streamptr->tsteps[tsID].position = recpos;
    }

  if ( streamptr->ntsteps == 1 )
    {
      if ( taxis->vdate == 0 && taxis->vtime == 0 )
	{
	  streamptr->ntsteps = 0;
	  for ( varID = 0; varID < streamptr->nvars; varID++ )
	    {
	      vlistDefVarTime(vlistID, varID, TIME_CONSTANT);
	    }
	}
    }
}


int extScanTimestep2(int streamID)
{  
  static char func[] = "extScanTimestep2";
  int header[4];
  int status;
  int fileID;
  int rxysize = 0;
  int param = 0;
  int rcode = 0, rlevel = 0, vdate = 0, vtime = 0;
  int tsID;
  int varID;
  long recsize;
  off_t recpos = 0;
  int nrecords, nrecs, recID, rindex;
  int nextstep;
  taxis_t *taxis;
  int vlistID;
  extcompvar_t compVar, compVar0;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->curTsID = 1;

  fileID  = streamInqFileID(streamID);
  vlistID = streamInqVlist(streamID);
  extp    = streamptr->record->extp;

  tsID = streamptr->rtsteps;
  if ( tsID != 1 )
    Error(func, "Internal problem! unexpeceted timestep %d", tsID+1);

  taxis = &streamptr->tsteps[tsID].taxis;

  fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);

  cdiCreateRecords(streamID, tsID);

  nrecords = streamptr->tsteps[0].nallrecs;
  streamptr->tsteps[1].recIDs = (int *) malloc(nrecords*sizeof(int));
  streamptr->tsteps[1].nrecs = 0;
  for ( recID = 0; recID < nrecords; recID++ )
    streamptr->tsteps[1].recIDs[recID] = -1;

  for ( recID = 0; recID < nrecords; recID++ )
    {
      varID = streamptr->tsteps[0].records[recID].varID;
      streamptr->tsteps[tsID].records[recID].position = 
	streamptr->tsteps[0].records[recID].position;
      streamptr->tsteps[tsID].records[recID].size     = 
	streamptr->tsteps[0].records[recID].size;
    }

  for ( rindex = 0; rindex <= nrecords; rindex++ )
    {
      recpos = fileGetPos(fileID);
      status = extRead(fileID, extp);
      if ( status != 0 )
	{
	  streamptr->ntsteps = 2;
	  break;
	}
      recsize = fileGetPos(fileID) - recpos;

      extInqHeader(extp, header);

      vdate  = header[0];
      vtime  = 0;
      rcode  = header[1];
      rlevel = header[2];
      rxysize = header[3];

      param = cdiEncodeParam(rcode, 255, 255);

      if ( rindex == 0 )
	{
	  taxis->type  = TAXIS_ABSOLUTE;
	  taxis->vdate = vdate;
	  taxis->vtime = vtime;
	}

      compVar.param = param;
      compVar.level = rlevel;
      nextstep = FALSE;
      for ( recID = 0; recID < nrecords; recID++ )
	{
	  compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
	  compVar0.level = streamptr->tsteps[tsID].records[recID].ilevel;

	  if ( memcmp(&compVar0, &compVar, sizeof(extcompvar_t)) == 0 )
	    {
	      if ( streamptr->tsteps[tsID].records[recID].used )
		{
		  nextstep = TRUE;
		}
	      else
		{
		  streamptr->tsteps[tsID].records[recID].used = TRUE;
		  streamptr->tsteps[tsID].recIDs[rindex] = recID;
		}
	      break;
	    }
	}
      if ( recID == nrecords )
	{
	  Warning(func, "Code %d level %d not found at timestep %d", rcode, rlevel, tsID+1);
	  return (CDI_EUFSTRUCT);
	}

      if ( nextstep ) break;

      if ( CDI_Debug )
	Message(func, "%4d%8d%4d%8d%8d%6d", rindex+1, (int)recpos, rcode, rlevel, vdate, vtime);

      streamptr->tsteps[tsID].records[recID].size = recsize;

      compVar0.param  = streamptr->tsteps[tsID].records[recID].param;
      compVar0.level = streamptr->tsteps[tsID].records[recID].ilevel;

      if ( memcmp(&compVar0, &compVar, sizeof(extcompvar_t)) != 0 )
	{
	  Message(func, "tsID = %d recID = %d param = %3d new %3d  level = %3d new %3d",
		  tsID, recID,
		  streamptr->tsteps[tsID].records[recID].param, param,
		  streamptr->tsteps[tsID].records[recID].ilevel, rlevel);
	  return (CDI_EUFSTRUCT);
	}

      streamptr->tsteps[1].records[recID].position = recpos;
    }

  nrecs = 0;
  for ( recID = 0; recID < nrecords; recID++ )
    {
      if ( ! streamptr->tsteps[tsID].records[recID].used )
	{
	  varID = streamptr->tsteps[tsID].records[recID].varID;
	  vlistDefVarTime(vlistID, varID, TIME_CONSTANT);
	}
      else
	{
	  nrecs++;
	}
    }
  streamptr->tsteps[tsID].nrecs = nrecs;

  streamptr->rtsteps = 2;

  if ( streamptr->ntsteps == -1 )
    {
      tsID = tstepsNewEntry(streamID);
      if ( tsID != streamptr->rtsteps )
	Error(func, "Internal error. tsID = %d", tsID);

      streamptr->tsteps[tsID-1].next   = TRUE;
      streamptr->tsteps[tsID].position = recpos;
    }

  return (0);
}


int extInqContents(int streamID)
{
  static char func[] = "extInqContents";
  int fileID;
  int status = 0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID = streamInqFileID(streamID);

  streamptr->curTsID = 0;

  extScanTimestep1(streamID);
 
  if ( streamptr->ntsteps == -1 ) status = extScanTimestep2(streamID);

  fileSetPos(fileID, 0, SEEK_SET);

  return (status);
}


int extScanTimestep(int streamID)
{
  static char func[] = "extScanTimestep";
  int header[4];
  int status;
  int fileID;
  int tsID;
  int rxysize = 0;
  int param = 0;
  int rcode = 0, rlevel = 0, vdate = 0, vtime = 0;
  long recsize = 0;
  off_t recpos = 0;
  int recID;
  taxis_t *taxis;
  int rindex, nrecs = 0;
  extcompvar_t compVar, compVar0;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  if ( CDI_Debug )
    {
      Message(func, "streamID = %d", streamID);
      Message(func, "cts = %d", streamptr->curTsID);
      Message(func, "rts = %d", streamptr->rtsteps);
      Message(func, "nts = %d", streamptr->ntsteps);
    }

  if ( streamptr->rtsteps == 0 )
    Error(func, "Internal problem! Missing contents.");

  extp  = streamptr->record->extp;
  tsID  = streamptr->rtsteps;
  taxis = &streamptr->tsteps[tsID].taxis;

  if ( streamptr->tsteps[tsID].recordSize == 0 )
    {
      cdiCreateRecords(streamID, tsID);

      nrecs = streamptr->tsteps[1].nrecs;

      streamptr->tsteps[tsID].nrecs = nrecs;
      streamptr->tsteps[tsID].recIDs = (int *) malloc(nrecs*sizeof(int));
      for ( recID = 0; recID < nrecs; recID++ )
	streamptr->tsteps[tsID].recIDs[recID] = streamptr->tsteps[1].recIDs[recID];

      fileID = streamInqFileID(streamID);

      fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);

      for ( rindex = 0; rindex <= nrecs; rindex++ )
	{
	  recpos = fileGetPos(fileID);
	  status = extRead(fileID, extp);
	  if ( status != 0 )
	    {
	      streamptr->ntsteps = streamptr->rtsteps + 1;
	      break;
	    }
	  recsize = fileGetPos(fileID) - recpos;

	  extInqHeader(extp, header);

	  vdate  = header[0];
	  vtime  = 0;
	  rcode  = header[1];
	  rlevel = header[2];
	  rxysize = header[3];

	  param = cdiEncodeParam(rcode, 255, 255);

	  if ( rindex == nrecs ) break;
	  recID = streamptr->tsteps[tsID].recIDs[rindex];

	  if ( rindex == 0 )
	    {
	      taxis->type  = TAXIS_ABSOLUTE;
	      taxis->vdate = vdate;
	      taxis->vtime = vtime;
	    }
	  /*
	  extCmpRecord(streamID, tsID, nrecs, recpos, param, rlevel, rxysize);
	  */
	  compVar.param  = param;
          compVar.level  = rlevel;
	  compVar0.param = streamptr->tsteps[tsID].records[recID].param;
	  compVar0.level = streamptr->tsteps[tsID].records[recID].ilevel;

	  if ( memcmp(&compVar0, &compVar, sizeof(extcompvar_t)) != 0 )
	    {
	      Message(func, "tsID = %d recID = %d param = %3d new %3d  level = %3d new %3d",
		      tsID, recID,
		      streamptr->tsteps[tsID].records[recID].param, param,
		      streamptr->tsteps[tsID].records[recID].ilevel, rlevel);
	      Error(func, "Invalid, unsupported or inconsistent record structure");
	    }

	  streamptr->tsteps[tsID].records[recID].position = recpos;
	  streamptr->tsteps[tsID].records[recID].size = recsize;

	  if ( CDI_Debug )
	    Message(func, "%4d%8d%4d%8d%8d%6d", rindex, (int)recpos, rcode, rlevel, vdate, vtime);
	}

      streamptr->rtsteps++;

      if ( streamptr->ntsteps != streamptr->rtsteps )
	{
	  tsID = tstepsNewEntry(streamID);
	  if ( tsID != streamptr->rtsteps )
	    Error(func, "Internal error. tsID = %d", tsID);

	  streamptr->tsteps[tsID-1].next   = 1;
	  streamptr->tsteps[tsID].position = recpos;
	}

      fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);
      streamptr->tsteps[tsID].position = recpos;
    }

  if ( nrecs > 0 && nrecs < streamptr->tsteps[tsID].nrecs )
    {
      Warning(func, "Incomplete timestep. Stop scanning at timestep %d.\n", tsID);
      streamptr->ntsteps = tsID;
    }

  return (streamptr->ntsteps);
}


int extInqTimestep(int streamID, int tsID)
{
  static char func[] = "extInqTimestep";
  int ntsteps, nrecs;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  if ( tsID == 0 && streamptr->rtsteps == 0 )
    Error(func, "Call to cdiInqContents missing!");

  if ( CDI_Debug )
    Message(func, "tsID = %d rtsteps = %d", tsID, streamptr->rtsteps);
  
  ntsteps = UNDEFID;
  while ( ( tsID + 1 ) > streamptr->rtsteps && ntsteps == UNDEFID )
    ntsteps = extScanTimestep(streamID);

  if ( tsID >= streamptr->ntsteps && streamptr->ntsteps != CDI_UNDEFID )
    {
      nrecs = 0;
    }
  else
    {
      streamptr->curTsID = tsID;
      nrecs = streamptr->tsteps[tsID].nrecs;
    }

  return (nrecs);
}


void extReadVarDP(int streamID, int varID, double *data, int *nmiss)
{
  static char func[] = "extReadVarDP";
  int vlistID, fileID;
  int levID, nlevs, gridID, gridsize;
  off_t recpos, currentfilepos;
  int header[4];
  int tsid;
  int recID;
  int i;
  int status;
  double missval;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  extp     = streamptr->record->extp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  nlevs    = streamptr->vars[varID].nlevs;
  missval  = vlistInqVarMissval(vlistID, varID);
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  tsid     = streamptr->curTsID;

  if ( CDI_Debug )
    Message(func, "nlevs = %d gridID = %d gridsize = %d", nlevs, gridID, gridsize);

  currentfilepos = fileGetPos(fileID);

  for (levID = 0; levID < nlevs; levID++)
    {
      recID = streamptr->vars[varID].level[levID];
      recpos = streamptr->tsteps[tsid].records[recID].position;
      fileSetPos(fileID, recpos, SEEK_SET);
      status = extRead(fileID, extp);
      extInqHeader(extp, header);
      extInqDataDP(extp, &data[levID*gridsize]);
    }
  fileSetPos(fileID, currentfilepos, SEEK_SET);

  *nmiss = 0;
  if ( vlistInqVarNumber(vlistID, varID) == CDI_REAL )
    {
      for ( i = 0; i < nlevs*gridsize; i++ )
	if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
	  {
	    data[i] = missval;
	    (*nmiss)++;
	  }
    }
  else
    {
      for ( i = 0; i < 2*nlevs*gridsize; i+=2 )
	if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
	  {
	    data[i] = missval;
	    (*nmiss)++;
	  }
    }
}


void extReadVarSliceDP(int streamID, int varID, int levID, double *data, int *nmiss)
{
  static char func[] = "extReadVarSliceDP";
  int vlistID, fileID;
  int nlevs, gridID, gridsize;
  off_t recpos, currentfilepos;
  int header[4];
  int tsid;
  int recID;
  int i;
  int status;
  double missval;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  extp     = streamptr->record->extp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  nlevs    = streamptr->vars[varID].nlevs;
  missval  = vlistInqVarMissval(vlistID, varID);
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  tsid     = streamptr->curTsID;

  if ( CDI_Debug )
    Message(func, "nlevs = %d gridID = %d gridsize = %d",
	     nlevs, gridID, gridsize);

  currentfilepos = fileGetPos(fileID);

  recID = streamptr->vars[varID].level[levID];
  recpos = streamptr->tsteps[tsid].records[recID].position;
  fileSetPos(fileID, recpos, SEEK_SET);
  status = extRead(fileID, extp);
  extInqHeader(extp, header);
  extInqDataDP(extp, data);
 
  fileSetPos(fileID, currentfilepos, SEEK_SET);

  *nmiss = 0;
  if ( vlistInqVarNumber(vlistID, varID) == CDI_REAL )
    {
      for ( i = 0; i < gridsize; i++ )
	if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
	  {
	    data[i] = missval;
	    (*nmiss)++;
	  }
    }
  else
    {
      for ( i = 0; i < 2*gridsize; i+=2 )
	if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
	  {
	    data[i] = missval;
	    (*nmiss)++;
	  }
    }
}


void extWriteVarDP(int streamID, int varID, const double *data)
{
  static char func[] = "extWriteVarDP";
  int fileID;
  int levID, nlevs, gridID, gridsize;
  int zaxisID;
  double level;
  int header[4];
  int tsID;
  int vlistID;
  int pdis, pcat, pnum;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d  varID = %d", streamID, varID);

  extp     = streamptr->record->extp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  tsID     = streamptr->curTsID;
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  zaxisID  = vlistInqVarZaxis(vlistID, varID);
  nlevs    = zaxisInqSize(zaxisID);

  if ( CDI_Debug )
    Message(func, "nlevs = %d gridID = %d gridsize = %d", nlevs, gridID, gridsize);

  cdiDecodeParam(vlistInqVarParam(vlistID, varID), &pnum, &pcat, &pdis);

  header[0] = streamptr->tsteps[tsID].taxis.vdate;
  header[1] = pnum;
  header[3] = gridInqSize(gridID);

  extDefDatatype(vlistInqVarDatatype(vlistID, varID), &extp->prec, &extp->number);

  for ( levID = 0;  levID < nlevs; levID++ )
    {
      level = zaxisInqLevel(zaxisID, levID);

      header[2] = (int) level;
      extDefHeader(extp, header);
      extDefDataDP(extp, &data[levID*gridsize]);
      extWrite(fileID, extp);
    }
}


void extWriteVarSliceDP(int streamID, int varID, int levID, const double *data)
{
  static char func[] = "extWriteVarSliceDP";
  int fileID;
  int gridID;
  int zaxisID;
  double level;
  int header[4];
  int tsID;
  int vlistID;
  int pdis, pcat, pnum;
  extrec_t *extp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  extp     = streamptr->record->extp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  tsID     = streamptr->curTsID;
  gridID   = vlistInqVarGrid(vlistID, varID);
  zaxisID  = vlistInqVarZaxis(vlistID, varID);
  level    = zaxisInqLevel(zaxisID, levID);

  if ( CDI_Debug )
    Message(func, "gridID = %d zaxisID = %d", gridID, zaxisID);

  cdiDecodeParam(vlistInqVarParam(vlistID, varID), &pnum, &pcat, &pdis);

  header[0] = streamptr->tsteps[tsID].taxis.vdate;
  header[1] = pnum;
  header[2] = (int) level;
  header[3] = gridInqSize(gridID);

  extDefDatatype(vlistInqVarDatatype(vlistID, varID), &extp->prec, &extp->number);

  extDefHeader(extp, header);
  extDefDataDP(extp, data);
  extWrite(fileID, extp);
}

#endif /* HAVE_LIBEXTRA */
#if defined (HAVE_CONFIG_H)
#endif





#undef  UNDEFID
#define UNDEFID  CDI_UNDEFID

#define SINGLE_PRECISION  4
#define DOUBLE_PRECISION  8

#if defined (HAVE_LIBIEG)


typedef struct {
  int param;
  int level;
} IEGCOMPVAR; 


int iegInqDatatype(int prec)
{
  int datatype;

  if ( prec == DOUBLE_PRECISION ) datatype = DATATYPE_FLT64;
  else                            datatype = DATATYPE_FLT32;

  return (datatype);
}


int iegDefDatatype(int datatype)
{
  static char func[] = "iegDefDatatype";
  int prec;

  if ( datatype == DATATYPE_CPX32 || datatype == DATATYPE_CPX64 )
    Error(func, "CDI/IEG library does not support complex numbers!");

  if ( datatype != DATATYPE_FLT32 && datatype != DATATYPE_FLT64 )
    datatype = DATATYPE_FLT32;

  if ( datatype == DATATYPE_FLT64 ) prec = DOUBLE_PRECISION;
  else                              prec = SINGLE_PRECISION;

  return (prec);
}


int iegInqRecord(int streamID, int *varID, int *levelID)
{
  static char func[] = "iegInqRecord";
  int status;
  int fileID;
  int icode, ilevel;
  int zaxisID = -1;
  int vlistID;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);
  iegp    = streamptr->record->iegp;

  *varID   = -1;
  *levelID = -1;

  status = iegRead(fileID, iegp);
  if ( status != 0 ) return (0);

  icode  = IEG_P_Parameter(iegp->ipdb);
  if ( IEG_P_LevelType(iegp->ipdb) == IEG_LTYPE_HYBRID_LAYER )
    ilevel = IEG_P_Level1(iegp->ipdb);
  else
    ilevel = IEG_P_Level2(iegp->ipdb);

  *varID = vlistInqVarID(vlistID, icode);

  if ( *varID == UNDEFID ) Error(func, "Code %d undefined", icode);

  zaxisID = vlistInqVarZaxis(vlistID, *varID);

  *levelID = zaxisInqLevelID(zaxisID, (double) ilevel);
  
  return (1);
}


int iegReadRecord(int streamID, double *data, int *nmiss)
{
  static char func[] = "iegReadRecord";
  int vlistID, fileID;
  int status;
  int recID, vrecID, tsID;
  off_t recpos;
  int varID, gridID;
  int i, size;
  double missval;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);
  tsID    = streamptr->curTsID;
  vrecID  = streamptr->tsteps[tsID].curRecID;
  recID   = streamptr->tsteps[tsID].recIDs[vrecID];
  recpos  = streamptr->tsteps[tsID].records[recID].position;
  varID   = streamptr->tsteps[tsID].records[recID].varID;
  iegp    = streamptr->record->iegp;

  fileSetPos(fileID, recpos, SEEK_SET);

  status = iegRead(fileID, iegp);
  if ( status != 0 ) return (0);

  iegInqDataDP(iegp, data);

  missval = vlistInqVarMissval(vlistID, varID);
  gridID  = vlistInqVarGrid(vlistID, varID);
  size    = gridInqSize(gridID);

  streamptr->numvals += size;

  *nmiss = 0;
  for ( i = 0; i < size; i++ )
    if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
      {
	data[i] = missval;
	(*nmiss)++;
      }

  return (1);
}

static
int iegGetZaxisType(int iegleveltype)
{
  int leveltype = 0;

  switch ( iegleveltype )
    {
    case IEG_LTYPE_SURFACE:
      {
	leveltype = ZAXIS_SURFACE;
	break;
      }
    case IEG_LTYPE_99:
    case IEG_LTYPE_ISOBARIC:
      {
	leveltype = ZAXIS_PRESSURE;
	break;
      }
    case IEG_LTYPE_HEIGHT:
      {
	leveltype = ZAXIS_HEIGHT;
	break;
      }
    case IEG_LTYPE_ALTITUDE:
      {
	leveltype = ZAXIS_ALTITUDE;
	break;
      }
    case IEG_LTYPE_HYBRID:
    case IEG_LTYPE_HYBRID_LAYER:
      {
	leveltype = ZAXIS_HYBRID;
	break;
      }
    case IEG_LTYPE_LANDDEPTH:
    case IEG_LTYPE_LANDDEPTH_LAYER:
      {
	leveltype = ZAXIS_DEPTH_BELOW_LAND;
	break;
      }
    case IEG_LTYPE_SEADEPTH:
      {
	leveltype = ZAXIS_DEPTH_BELOW_SEA;
	break;
      }
    default:
      {
	leveltype = ZAXIS_GENERIC;
	break;
      }
    }

  return (leveltype);
}


void iegDefTime(int *pdb, int date, int time, int timeID)
{
  int year, month, day, hour, minute, second;
  int timetype = -1;

  if ( timeID != -1 ) timetype = taxisInqType(timeID);

  if ( timetype == TAXIS_ABSOLUTE || timetype == TAXIS_RELATIVE )
    {
      cdiDecodeDate(date, &year, &month, &day);
      cdiDecodeTime(time, &hour, &minute, &second);

      IEG_P_Year(pdb)     = year;
      IEG_P_Month(pdb)    = month;
      IEG_P_Day(pdb)      = day;
      IEG_P_Hour(pdb)     = hour;
      IEG_P_Minute(pdb)   = minute;

      pdb[15] = 1;
      pdb[16] = 0;
      pdb[17] = 0;
      pdb[18] = 10;
      pdb[36] = 1;
    }

  pdb[5] = 128;
}

static
void iegDefGrid(int *gdb, int gridID)
{
  static char func[] = "iegDefGrid";
  int gridtype;

  gridtype = gridInqType(gridID);

  if ( gridtype == GRID_GENERIC )
    {
      int xsize, ysize;

      xsize = gridInqXsize(gridID);
      ysize = gridInqYsize(gridID);

      if ( (ysize == 32  || ysize == 48 || ysize == 64 ||
	    ysize == 96  || ysize == 160) && 
	   (xsize == 2*ysize || xsize == 1) )
	{
	  gridtype = GRID_GAUSSIAN;
	  gridChangeType(gridID, gridtype);
	}
      else if ( (xsize == 1 && ysize == 1) || (xsize == 0 && ysize == 0) )
	{
	  gridtype = GRID_LONLAT;
	  gridChangeType(gridID, gridtype);
	}
      else if ( gridInqXvals(gridID, NULL) && gridInqYvals(gridID, NULL) )
	{
	  gridtype = GRID_LONLAT;
	  gridChangeType(gridID, gridtype);
	}
    }
  else if ( gridtype == GRID_CURVILINEAR )
    {
      gridtype = GRID_LONLAT;
    }

  if ( gridtype == GRID_LONLAT || gridtype == GRID_GAUSSIAN )
    {
      int nlon, nlat;
      double xfirst = 0, xlast = 0, xinc = 0;
      double yfirst = 0, ylast = 0, yinc = 0;

      nlon = (int) gridInqXsize(gridID);
      nlat = (int) gridInqYsize(gridID);

      if ( nlon == 0 )
	{
	  nlon = 1;
	}
      else
	{
	  xfirst = gridInqXval(gridID,      0);
	  xlast  = gridInqXval(gridID, nlon-1);
	  xinc   = gridInqXinc(gridID);
	}

      if ( nlat == 0 )
	{
	  nlat = 1;
	}
      else
	{
	  yfirst = gridInqYval(gridID,      0);
	  ylast  = gridInqYval(gridID, nlat-1);
	  yinc   = gridInqYinc(gridID);
	}

      if ( gridtype == GRID_GAUSSIAN )
	IEG_G_GridType(gdb) = 4;
      else if ( gridtype == GRID_LONLAT && gridIsRotated(gridID) )
	IEG_G_GridType(gdb) = 10;
      else
	IEG_G_GridType(gdb) = 0;

      IEG_G_NumLon(gdb)   = nlon;
      IEG_G_NumLat(gdb)   = nlat;
      IEG_G_FirstLat(gdb) = NINT(yfirst*1000);
      IEG_G_LastLat(gdb)  = NINT(ylast*1000);
      IEG_G_FirstLon(gdb) = NINT(xfirst*1000);
      IEG_G_LastLon(gdb)  = NINT(xlast*1000);
      IEG_G_LonIncr(gdb)  = NINT(xinc*1000);
      if ( fabs(xinc*1000 - IEG_G_LonIncr(gdb)) > FLT_EPSILON )
	IEG_G_LonIncr(gdb) = 0;

      if ( gridtype == GRID_GAUSSIAN )
	IEG_G_LatIncr(gdb) = nlat/2;
      else
	{
	  IEG_G_LatIncr(gdb) = NINT(yinc*1000);
	  if ( fabs(yinc*1000 - IEG_G_LatIncr(gdb)) > FLT_EPSILON )
	    IEG_G_LatIncr(gdb) = 0;

	  if ( IEG_G_LatIncr(gdb) < 0 ) IEG_G_LatIncr(gdb) = -IEG_G_LatIncr(gdb);
	}

      if ( IEG_G_NumLon(gdb) > 1 && IEG_G_NumLat(gdb) == 1 ) 
	if ( IEG_G_LonIncr(gdb) != 0 && IEG_G_LatIncr(gdb) == 0 ) IEG_G_LatIncr(gdb) = IEG_G_LonIncr(gdb);

      if ( IEG_G_NumLon(gdb) == 1 && IEG_G_NumLat(gdb) > 1 ) 
	if ( IEG_G_LonIncr(gdb) == 0 && IEG_G_LatIncr(gdb) != 0 ) IEG_G_LonIncr(gdb) = IEG_G_LatIncr(gdb);

      if ( IEG_G_LatIncr(gdb) == 0 || IEG_G_LonIncr(gdb) == 0 )
	IEG_G_ResFlag(gdb) = 0;
      else
	IEG_G_ResFlag(gdb) = 128;

      if ( gridIsRotated(gridID) )
	{
	  IEG_G_LatSP(gdb) = - NINT(gridInqYpole(gridID) * 1000);
	  IEG_G_LonSP(gdb) =   NINT((gridInqXpole(gridID) + 180) * 1000);
	  IEG_G_Size(gdb)  = 42;
	}
      else
	{
	  IEG_G_Size(gdb)  = 32;
	}
    }
  else
    {
      Error(func, "Unsupported grid type: %s", gridNamePtr(gridtype));
    }

  IEG_G_ScanFlag(gdb) = 64;
}

static
void iegDefLevel(int *pdb, int *gdb, double *vct, int zaxisID, int levelID)
{
  static char func[] = "iegDefLevel";
  double level;
  int ilevel, leveltype;
  static int warning = 1;
  static int vct_warning = 1;

  leveltype = zaxisInqType(zaxisID);

  if ( leveltype == ZAXIS_GENERIC )
    {
      leveltype = ZAXIS_PRESSURE;
      zaxisChangeType(zaxisID, leveltype);
      zaxisDefUnits(zaxisID, "Pa");
    }

  /*  IEG_G_NumVCP(gdb) = 0; */

  switch (leveltype)
    {
    case ZAXIS_SURFACE:
      {
	IEG_P_LevelType(pdb) = IEG_LTYPE_SURFACE;
	IEG_P_Level1(pdb)    = 0;
	IEG_P_Level2(pdb)    = (int) zaxisInqLevel(zaxisID, levelID);
	break;
      }
    case ZAXIS_HYBRID:
      {
	int vctsize;

	if ( zaxisInqLbounds(zaxisID, NULL) && zaxisInqUbounds(zaxisID, NULL) )
	  {
	    IEG_P_LevelType(pdb) = IEG_LTYPE_HYBRID_LAYER;
	    IEG_P_Level1(pdb)    = (int) zaxisInqLbound(zaxisID, levelID);
	    IEG_P_Level2(pdb)    = (int) zaxisInqUbound(zaxisID, levelID);
	  }
	else
	  {
	    IEG_P_LevelType(pdb) = IEG_LTYPE_HYBRID;
	    IEG_P_Level1(pdb)    = 0;
	    IEG_P_Level2(pdb)    = (int) zaxisInqLevel(zaxisID, levelID);
	  }

	vctsize = zaxisInqVctSize(zaxisID);
	if ( vctsize == 0 && warning )
	  {
	    Warning(func, "VCT missing. ( code = %d, zaxisID = %d )",
		    IEG_P_Parameter(pdb), zaxisID);
	    warning = 0;
	  }
	if ( vctsize > 100 )
	  {
	    /*	    IEG_G_NumVCP(gdb) = 0; */
	    if ( vct_warning )
	      {
		Warning(func, "VCT size of %d is too large (maximum is 100). Set to 0!", vctsize);
		vct_warning = 0;
	      }
	  }
	else
	  {
	    IEG_G_Size(gdb) += (vctsize*4);
	    memcpy(vct, zaxisInqVctPtr(zaxisID), vctsize/2*sizeof(double));
	    memcpy(vct+50, zaxisInqVctPtr(zaxisID)+vctsize/2, vctsize/2*sizeof(double));
	  }
	break;
      }
    case ZAXIS_PRESSURE:
      {
	double dum;
	char units[128];

	level = zaxisInqLevel(zaxisID, levelID);
	if ( level < 0 )
	  Warning(func, "pressure level of %f Pa is below 0.", level);

	zaxisInqUnits(zaxisID, units);
	if ( memcmp(units, "hPa", 3) == 0 || memcmp(units, "mb",2 ) == 0 )
	  level = level*100;

	ilevel = (int) level;
	if ( level < 32768 && (level < 100 || modf(level/100, &dum) > 0) )
	  {
	    IEG_P_LevelType(pdb) = IEG_LTYPE_99;
	    IEG_P_Level1(pdb)    = 0;
	    IEG_P_Level2(pdb)    = ilevel;
	  }
	else
	  {
	    IEG_P_LevelType(pdb) = IEG_LTYPE_ISOBARIC;
	    IEG_P_Level1(pdb)    = 0;
	    IEG_P_Level2(pdb)    = ilevel/100;
	  }
	break;
      }
    case ZAXIS_HEIGHT:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	ilevel = (int) level;
	IEG_P_LevelType(pdb) = IEG_LTYPE_HEIGHT;
	IEG_P_Level1(pdb)    = 0;
	IEG_P_Level2(pdb)    = ilevel;

	break;
      }
    case ZAXIS_ALTITUDE:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	ilevel = (int) level;
	IEG_P_LevelType(pdb) = IEG_LTYPE_ALTITUDE;
	IEG_P_Level1(pdb)    = 0;
	IEG_P_Level2(pdb)    = ilevel;

	break;
      }
    case ZAXIS_DEPTH_BELOW_LAND:
      {
	if ( zaxisInqLbounds(zaxisID, NULL) && zaxisInqUbounds(zaxisID, NULL) )
	  {
	    IEG_P_LevelType(pdb) = IEG_LTYPE_LANDDEPTH_LAYER;
	    IEG_P_Level1(pdb)    = (int) zaxisInqLbound(zaxisID, levelID);
	    IEG_P_Level2(pdb)    = (int) zaxisInqUbound(zaxisID, levelID);
	  }
	else
	  {
	    level = zaxisInqLevel(zaxisID, levelID);

	    ilevel = (int) level;
	    IEG_P_LevelType(pdb) = IEG_LTYPE_LANDDEPTH;
	    IEG_P_Level1(pdb)    = 0;
	    IEG_P_Level2(pdb)    = ilevel;
	  }

	break;
      }
    case ZAXIS_DEPTH_BELOW_SEA:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	ilevel = (int) level;
	IEG_P_LevelType(pdb) = IEG_LTYPE_SEADEPTH;
	IEG_P_Level1(pdb)    = 0;
	IEG_P_Level2(pdb)    = ilevel;

	break;
      }
    case ZAXIS_ISENTROPIC:
      {
	level = zaxisInqLevel(zaxisID, levelID);

	ilevel = (int) level;
	IEG_P_LevelType(pdb) = 113;
	IEG_P_Level1(pdb)    = 0;
	IEG_P_Level2(pdb)    = ilevel;

	break;
      }
    default:
      {
	Error(func, "Unsupported zaxis type: %s", zaxisNamePtr(leveltype));
	break;
      }
    }
}


int iegCopyRecord(int streamID2, int streamID1)
{
  static char func[] = "iegCopyRecord";
  int fileID1, fileID2;
  int tsID, recID, vrecID;
  long recsize;
  off_t recpos;
  int status = 0;
  char *buffer;
  stream_t *streamptr1;
  stream_t *streamptr2;

  streamptr1 = stream_to_pointer(streamID1);
  streamptr2 = stream_to_pointer(streamID2);

  stream_check_ptr(func, streamptr1);
  stream_check_ptr(func, streamptr2);

  fileID1 = streamInqFileID(streamID1);
  fileID2 = streamInqFileID(streamID2);

  tsID    = streamptr1->curTsID;
  vrecID  = streamptr1->tsteps[tsID].curRecID;
  recID   = streamptr1->tsteps[tsID].recIDs[vrecID];
  recpos  = streamptr1->tsteps[tsID].records[recID].position;
  recsize = streamptr1->tsteps[tsID].records[recID].size;

  fileSetPos(fileID1, recpos, SEEK_SET);

  buffer = (char *) malloc(recsize);

  fileRead(fileID1, buffer, recsize);

  fileWrite(fileID2, buffer, recsize);

  free(buffer);

  return (status);
}


int iegDefRecord(int streamID)
{
  static char func[] = "iegDefRecord";
  int status = 0;
  int fileID, vlistID;
  int gridID;
  int date, time;
  int datatype;
  int i;
  int param, pdis, pcat, pnum;
  int varID, levelID, tsID, zaxisID;
  int byteorder;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID  = streamInqFileID(streamID);
  vlistID = streamInqVlist(streamID);
  iegp    = streamptr->record->iegp;
  byteorder = streamptr->byteorder;

  varID   = streamptr->record->varID;
  levelID = streamptr->record->levelID;
  tsID    = streamptr->curTsID;

  gridID  = vlistInqVarGrid(vlistID, varID);
  zaxisID = vlistInqVarZaxis(vlistID, varID);
  
  iegInitMem(iegp);
  for ( i = 0; i < 37; i++ ) iegp->ipdb[i] = -1;

  iegp->byteswap = getByteswap(byteorder);

  param =  vlistInqVarParam(vlistID, varID);
  cdiDecodeParam(param, &pnum, &pcat, &pdis);
  IEG_P_Parameter(iegp->ipdb) = pnum;
  if ( pdis == 255 ) IEG_P_CodeTable(iegp->ipdb) = pcat;
  date     = streamptr->tsteps[tsID].taxis.vdate;
  time     = streamptr->tsteps[tsID].taxis.vtime;

  iegDefTime(iegp->ipdb, date, time, vlistInqTaxis(vlistID));
  iegDefGrid(iegp->igdb, gridID);
  iegDefLevel(iegp->ipdb, iegp->igdb, iegp->vct, zaxisID, levelID);

  datatype = streamptr->record->prec;

  iegp->dprec = iegDefDatatype(datatype);

  return (status);
}


int iegWriteRecord(int streamID, const double *data)
{
  static char func[] = "iegWriteRecord";
  int fileID;
  int status = 0;
  int i, gridsize, gridID;
  double refval;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID = streamInqFileID(streamID);
  iegp   = streamptr->record->iegp;
  gridID = streamptr->record->gridID;
  
  gridsize = gridInqSize(gridID);

  refval = data[0];
  for ( i = 1; i < gridsize; i++ )
    if ( data[i] < refval ) refval = data[i];

  iegp->refval = refval;

  iegDefDataDP(iegp, data);

  iegWrite(fileID, iegp);

  return (status);
}

static
void iegAddRecord(int streamID, int param, int *pdb, int *gdb, double *vct,
		  long recsize, off_t position, int prec)
{
  static char func[] = "iegAddRecord";
  int leveltype;
  int gridID = UNDEFID;
  int levelID = 0;
  int tsID, recID, varID;
  int datatype;
  int level1, level2;
  int gridtype;
  int lbounds = 0;
  record_t *record;
  grid_t grid;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  tsID    = streamptr->curTsID;
  recID   = recordNewEntry(streamID, tsID);
  record  = &streamptr->tsteps[tsID].records[recID];

  if ( IEG_P_LevelType(pdb) == IEG_LTYPE_HYBRID_LAYER )
    {
      level1 = IEG_P_Level1(pdb);
      level2 = IEG_P_Level2(pdb);
    }
  else
    {
      level1 = IEG_P_Level2(pdb);
      level2 = 0;
      if ( IEG_P_LevelType(pdb) == 100 ) level1 *= 100;
    }

  (*record).size     = recsize;
  (*record).position = position;
  (*record).param    = param;
  (*record).ilevel   = level1;
  (*record).ilevel2  = level2;
  (*record).ltype    = IEG_P_LevelType(pdb);

  if ( IEG_G_GridType(gdb) == 0 || IEG_G_GridType(gdb) == 10 )
    gridtype = GRID_LONLAT;
  else if ( IEG_G_GridType(gdb) == 4 )
    gridtype = GRID_GAUSSIAN;
  else
    gridtype = GRID_GENERIC;

  memset(&grid, 0, sizeof(grid_t));
  grid.type  = gridtype; 
  grid.size  = IEG_G_NumLon(gdb)*IEG_G_NumLat(gdb);
  grid.xsize = IEG_G_NumLon(gdb);
  grid.ysize = IEG_G_NumLat(gdb);
  grid.xinc  = 0;
  grid.yinc  = 0;
  grid.xdef  = 0;
  /* if ( IEG_G_FirstLon != 0 || IEG_G_LastLon != 0 ) */
  {
    if ( grid.xsize > 1 )
      {
	if ( IEG_G_ResFlag(gdb) && IEG_G_LonIncr(gdb) > 0 )
	  grid.xinc = IEG_G_LonIncr(gdb) * 0.001;
	else
	  grid.xinc = (IEG_G_LastLon(gdb) - IEG_G_FirstLon(gdb)) * 0.001 / (grid.xsize - 1);

	/* correct xinc if necessary */
	if ( IEG_G_FirstLon(gdb) == 0 && IEG_G_LastLon(gdb) > 354000 )
	  {
	    double xinc = 360. / grid.xsize;
	    
	    if ( fabs(grid.xinc-xinc) > 0.0 )
	      {
		grid.xinc = xinc;
		if ( CDI_Debug ) Message(func, "set xinc to %g", grid.xinc);
	      }
	  }
      }
    grid.xfirst = IEG_G_FirstLon(gdb) * 0.001;
    grid.xlast  = IEG_G_LastLon(gdb)  * 0.001;
    grid.xdef   = 2;	    
  }
  grid.ydef  = 0;
  /* if ( IEG_G_FirstLat != 0 || IEG_G_LastLat != 0 ) */
  {
    if ( grid.ysize > 1 )
      {
	if ( IEG_G_ResFlag(gdb) && IEG_G_LatIncr(gdb) > 0 )
	  grid.yinc = IEG_G_LatIncr(gdb) * 0.001;
	else
	  grid.yinc = (IEG_G_LastLat(gdb) - IEG_G_FirstLat(gdb)) * 0.001 / (grid.ysize - 1);
      }
    grid.yfirst = IEG_G_FirstLat(gdb) * 0.001;
    grid.ylast  = IEG_G_LastLat(gdb)  * 0.001;
    grid.ydef   = 2;	    
  }
  /*
  grid.xfirst= IEG_G_FirstLon(gdb) * 0.001;
  grid.xlast = IEG_G_LastLon(gdb) * 0.001;
  grid.xinc  = IEG_G_LonIncr(gdb) * 0.001;
  grid.xdef  = 2;	    
  grid.yfirst= IEG_G_FirstLat(gdb) * 0.001;
  grid.ylast = IEG_G_LastLat(gdb) * 0.001;
  grid.yinc  = IEG_G_LatIncr(gdb) * 0.001;
  grid.ydef  = 2;
  */
  grid.xvals = NULL;
  grid.yvals = NULL;

  grid.isRotated = FALSE;
  if ( IEG_G_GridType(gdb) == 10 )
    {
      grid.isRotated = TRUE;
      grid.ypole     = - IEG_G_LatSP(gdb) * 0.001;
      grid.xpole     =   IEG_G_LonSP(gdb) * 0.001 - 180;
      grid.angle     = 0;
    }

  gridID = varDefGrid(vlistID, grid, 0);

  leveltype = iegGetZaxisType(IEG_P_LevelType(pdb));
  
  if ( leveltype == ZAXIS_HYBRID )
    {
      int i;
      double tmpvct[100];
      int vctsize = IEG_G_NumVCP(gdb);

      for ( i = 0; i < vctsize/2; i++ ) tmpvct[i] = vct[i];
      for ( i = 0; i < vctsize/2; i++ ) tmpvct[i+vctsize/2] = vct[i+50];

      varDefVCT(vctsize, tmpvct);
    }

  if ( IEG_P_LevelType(pdb) == IEG_LTYPE_HYBRID_LAYER ) lbounds = 1;

  datatype = iegInqDatatype(prec);

  varAddRecord(recID, param, gridID, leveltype, lbounds, level1, level2,
	       datatype, &varID, &levelID, 0, 0, 0, NULL, NULL, NULL);

  (*record).varID   = varID;
  (*record).levelID = levelID;

  streamptr->tsteps[tsID].nallrecs++;
  streamptr->nrecs++;

  if ( CDI_Debug )
    Message(func, "varID = %d gridID = %d levelID = %d",
	    varID, gridID, levelID);
}

static
void iegCmpRecord(int streamID, int tsID, int recID, off_t position, int param,
		  int level, int xsize, int ysize)
{
  static char func[] = "iegCmpRecord";
  int varID = 0;
  int levelID = 0;
  record_t *record;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  record  = &streamptr->tsteps[tsID].records[recID];

  if ( param != (*record).param || level != (*record).ilevel )
    Error(func, "inconsistent timestep");

  (*record).position = position;
  /*
  varID   = (*record).varID;
  levelID = (*record).levelID;

  streamptr->vars[varID].level[levelID] = recID;

  streamptr->tsteps[tsID].nallrecs++;
  streamptr->nrecs++;
  */
  if ( CDI_Debug )
    Message(func, "varID = %d levelID = %d", varID, levelID);
}

static
void iegDateTime(int *pdb, int *date, int *time)
{
  int ryear, rmonth, rday, rhour, rminute;

  ryear   = IEG_P_Year(pdb);

  rmonth  = IEG_P_Month(pdb);
  rday    = IEG_P_Day(pdb);

  rhour   = IEG_P_Hour(pdb);
  rminute = IEG_P_Minute(pdb);

  if ( rminute == -1 ) rminute = 0;

  *date = cdiEncodeDate(ryear, rmonth, rday);
  *time = cdiEncodeTime(rhour, rminute, 0);
}


void iegScanTimestep1(int streamID)
{  
  static char func[] = "iegScanTimestep1";
  int prec = 0;
  int status;
  int fileID;
  int tabnum;
  int param = 0;
  int rcode = 0, rlevel = 0, vdate = 0, vtime = 0;
  DateTime datetime, datetime0;
  int tsID;
  int varID;
  long recsize;
  off_t recpos;
  int nrecords, nrecs, recID;
  int taxisID = -1;
  taxis_t *taxis;
  int vlistID;
  IEGCOMPVAR compVar, compVar0;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->curTsID = 0;

  iegp  = streamptr->record->iegp;
  tsID  = tstepsNewEntry(streamID);
  taxis = &streamptr->tsteps[tsID].taxis;

  if ( tsID != 0 )
    Error(func, "Internal problem! tstepsNewEntry returns %d", tsID);

  fileID = streamInqFileID(streamID);

  nrecs = 0;
  while ( TRUE )
    {
      recpos = fileGetPos(fileID);
      status = iegRead(fileID, iegp);
      if ( status != 0 )
	{
	  streamptr->ntsteps = 1;
	  break;
	}
      recsize = fileGetPos(fileID) - recpos;

      prec   = iegp->dprec;
      rcode  = IEG_P_Parameter(iegp->ipdb);
      tabnum = IEG_P_CodeTable(iegp->ipdb);
      param  = cdiEncodeParam(rcode, tabnum, 255);

      if ( IEG_P_LevelType(iegp->ipdb) == IEG_LTYPE_HYBRID_LAYER )
	rlevel = IEG_P_Level1(iegp->ipdb);
      else
	rlevel = IEG_P_Level2(iegp->ipdb);

      if ( IEG_P_LevelType(iegp->ipdb) == 100 ) rlevel *= 100;

      iegDateTime(iegp->ipdb, &vdate, &vtime);

      if ( nrecs == 0 )
	{
	  datetime0.date = vdate;
	  datetime0.time = vtime;
	}
      else
	{
	  datetime.date = vdate;
	  datetime.time = vtime;
	  compVar.param = param;
          compVar.level = rlevel;
	  for ( recID = 0; recID < nrecs; recID++ )
	    {
	      compVar0.param = streamptr->tsteps[0].records[recID].param;
	      compVar0.level = streamptr->tsteps[0].records[recID].ilevel;

	      if ( memcmp(&compVar0, &compVar, sizeof(IEGCOMPVAR)) == 0 ) break;
	    }
	  if ( recID < nrecs ) break;
	  if ( memcmp(&datetime, &datetime0, sizeof(DateTime)) )
	    Warning(func, "Inconsistent verification time for param %d level %d", param, rlevel);
	}

      nrecs++;

      if ( CDI_Debug )
	Message(func, "%4d%8d%4d%8d%8d%6d", nrecs, (int)recpos, param, rlevel, vdate, vtime);

      iegAddRecord(streamID, param, iegp->ipdb, iegp->igdb, iegp->vct, recsize, recpos, prec);
    }

  streamptr->rtsteps = 1;

  cdiGenVars(streamID);

  taxisID = taxisCreate(TAXIS_ABSOLUTE);
  taxis->type  = TAXIS_ABSOLUTE;
  taxis->vdate = datetime0.date;
  taxis->vtime = datetime0.time;

  vlistID = streamInqVlist(streamID);
  vlistDefTaxis(vlistID, taxisID);

  cdiCheckContents(streamID);

  nrecords = streamptr->tsteps[0].nallrecs;
  if ( nrecords < streamptr->tsteps[0].recordSize )
    {
      streamptr->tsteps[0].recordSize = nrecords;
      streamptr->tsteps[0].records =
	(record_t *) realloc(streamptr->tsteps[0].records, nrecords*sizeof(record_t));
    }

  streamptr->tsteps[0].recIDs = (int *) malloc(nrecords*sizeof(int));
  streamptr->tsteps[0].nrecs = nrecords;
  for ( recID = 0; recID < nrecords; recID++ )
    streamptr->tsteps[0].recIDs[recID] = recID;

  if ( streamptr->ntsteps == -1 )
    {
      tsID = tstepsNewEntry(streamID);
      if ( tsID != streamptr->rtsteps )
	Error(func, "Internal error. tsID = %d", tsID);

      streamptr->tsteps[tsID-1].next   = TRUE;
      streamptr->tsteps[tsID].position = recpos;
    }

  if ( streamptr->ntsteps == 1 )
    {
      if ( taxis->vdate == 0 && taxis->vtime == 0 )
	{
	  streamptr->ntsteps = 0;
	  for ( varID = 0; varID < streamptr->nvars; varID++ )
	    {
	      vlistDefVarTime(vlistID, varID, TIME_CONSTANT);
	    }
	}
    }
}


int iegScanTimestep2(int streamID)
{  
  static char func[] = "iegScanTimestep2";
  int status;
  int fileID;
  int tabnum;
  int param = 0;
  int rcode = 0, rlevel = 0, vdate = 0, vtime = 0;
  int tsID;
  int varID;
  long recsize;
  off_t recpos = 0;
  int nrecords, nrecs, recID, rindex;
  int nextstep;
  taxis_t *taxis;
  int vlistID;
  IEGCOMPVAR compVar, compVar0;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  streamptr->curTsID = 1;

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);
  iegp    = streamptr->record->iegp;

  tsID = streamptr->rtsteps;
  if ( tsID != 1 )
    Error(func, "Internal problem! unexpeceted timestep %d", tsID+1);

  taxis = &streamptr->tsteps[tsID].taxis;

  fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);

  cdiCreateRecords(streamID, tsID);

  nrecords = streamptr->tsteps[0].nallrecs;
  streamptr->tsteps[1].recIDs = (int *) malloc(nrecords*sizeof(int));
  streamptr->tsteps[1].nrecs = 0;
  for ( recID = 0; recID < nrecords; recID++ )
    streamptr->tsteps[1].recIDs[recID] = -1;

  for ( recID = 0; recID < nrecords; recID++ )
    {
      varID = streamptr->tsteps[0].records[recID].varID;
      streamptr->tsteps[tsID].records[recID].position = 
	streamptr->tsteps[0].records[recID].position;
      streamptr->tsteps[tsID].records[recID].size     = 
	streamptr->tsteps[0].records[recID].size;
    }

  for ( rindex = 0; rindex <= nrecords; rindex++ )
    {
      recpos = fileGetPos(fileID);
      status = iegRead(fileID, iegp);
      if ( status != 0 )
	{
	  streamptr->ntsteps = 2;
	  break;
	}
      recsize = fileGetPos(fileID) - recpos;

      rcode  = IEG_P_Parameter(iegp->ipdb);
      tabnum = IEG_P_CodeTable(iegp->ipdb);
      param  = cdiEncodeParam(rcode, tabnum, 255);

      if ( IEG_P_LevelType(iegp->ipdb) == IEG_LTYPE_HYBRID_LAYER )
	rlevel = IEG_P_Level1(iegp->ipdb);
      else
	rlevel = IEG_P_Level2(iegp->ipdb);

      if ( IEG_P_LevelType(iegp->ipdb) == 100 ) rlevel *= 100;

      iegDateTime(iegp->ipdb, &vdate, &vtime);

      if ( rindex == 0 )
	{
	  taxis->type  = TAXIS_ABSOLUTE;
	  taxis->vdate = vdate;
	  taxis->vtime = vtime;
	}

      compVar.param = param;
      compVar.level = rlevel;
      nextstep = FALSE;
      for ( recID = 0; recID < nrecords; recID++ )
	{
	  compVar0.param = streamptr->tsteps[tsID].records[recID].param;
	  compVar0.level = streamptr->tsteps[tsID].records[recID].ilevel;

	  if ( memcmp(&compVar0, &compVar, sizeof(IEGCOMPVAR)) == 0 )
	    {
	      if ( streamptr->tsteps[tsID].records[recID].used )
		{
		  nextstep = TRUE;
		}
	      else
		{
		  streamptr->tsteps[tsID].records[recID].used = TRUE;
		  streamptr->tsteps[tsID].recIDs[rindex] = recID;
		}
	      break;
	    }
	}
      if ( recID == nrecords )
	{
	  char paramstr[32];
	  cdiParamToString(param, paramstr, sizeof(paramstr));
	  Warning(func, "param %s level %d not defined at timestep 1", paramstr, rlevel);
	  return (CDI_EUFSTRUCT);
	}

      if ( nextstep ) break;

      if ( CDI_Debug )
	Message(func, "%4d%8d%4d%8d%8d%6d", rindex+1, (int)recpos, param, rlevel, vdate, vtime);

      streamptr->tsteps[tsID].records[recID].size = recsize;

      compVar0.param = streamptr->tsteps[tsID].records[recID].param;
      compVar0.level = streamptr->tsteps[tsID].records[recID].ilevel;

      if ( memcmp(&compVar0, &compVar, sizeof(IEGCOMPVAR)) != 0 )
	{
	  Message(func, "tsID = %d recID = %d param = %3d new %3d  level = %3d new %3d",
		  tsID, recID,
		  streamptr->tsteps[tsID].records[recID].param, param,
		  streamptr->tsteps[tsID].records[recID].ilevel, rlevel);
	  return (CDI_EUFSTRUCT);
	}

      streamptr->tsteps[1].records[recID].position = recpos;
    }

  nrecs = 0;
  for ( recID = 0; recID < nrecords; recID++ )
    {
      if ( ! streamptr->tsteps[tsID].records[recID].used )
	{
	  varID = streamptr->tsteps[tsID].records[recID].varID;
	  vlistDefVarTime(vlistID, varID, TIME_CONSTANT);
	}
      else
	{
	  nrecs++;
	}
    }
  streamptr->tsteps[tsID].nrecs = nrecs;

  streamptr->rtsteps = 2;

  if ( streamptr->ntsteps == -1 )
    {
      tsID = tstepsNewEntry(streamID);
      if ( tsID != streamptr->rtsteps )
	Error(func, "Internal error. tsID = %d", tsID);

      streamptr->tsteps[tsID-1].next   = TRUE;
      streamptr->tsteps[tsID].position = recpos;
    }

  return (0);
}


int iegInqContents(int streamID)
{
  static char func[] = "iegInqContents";
  int fileID;
  int status = 0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  fileID = streamInqFileID(streamID);

  streamptr->curTsID = 0;

  iegScanTimestep1(streamID);
 
  if ( streamptr->ntsteps == -1 ) status = iegScanTimestep2(streamID);

  fileSetPos(fileID, 0, SEEK_SET);

  return (status);
}


int iegScanTimestep(int streamID)
{
  static char func[] = "iegScanTimestep";
  int status;
  int fileID;
  int tsID;
  int tabnum;
  int param = 0;
  int rcode = 0, rlevel = 0, vdate = 0, vtime = 0;
  long recsize = 0;
  off_t recpos = 0;
  int recID;
  taxis_t *taxis;
  int rindex, nrecs = 0;
  IEGCOMPVAR compVar, compVar0;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  if ( CDI_Debug )
    {
      Message(func, "streamID = %d", streamID);
      Message(func, "cts = %d", streamptr->curTsID);
      Message(func, "rts = %d", streamptr->rtsteps);
      Message(func, "nts = %d", streamptr->ntsteps);
    }

  if ( streamptr->rtsteps == 0 )
    Error(func, "Internal problem! Missing contents.");

  iegp  = streamptr->record->iegp;
  tsID  = streamptr->rtsteps;
  taxis = &streamptr->tsteps[tsID].taxis;

  if ( streamptr->tsteps[tsID].recordSize == 0 )
    {
      cdiCreateRecords(streamID, tsID);

      nrecs = streamptr->tsteps[1].nrecs;

      streamptr->tsteps[tsID].nrecs = nrecs;
      streamptr->tsteps[tsID].recIDs = (int *) malloc(nrecs*sizeof(int));
      for ( recID = 0; recID < nrecs; recID++ )
	streamptr->tsteps[tsID].recIDs[recID] = streamptr->tsteps[1].recIDs[recID];

      fileID = streamInqFileID(streamID);

      fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);

      for ( rindex = 0; rindex <= nrecs; rindex++ )
	{
	  recpos = fileGetPos(fileID);
	  status = iegRead(fileID, iegp);
	  if ( status != 0 )
	    {
	      streamptr->ntsteps = streamptr->rtsteps + 1;
	      break;
	    }
	  recsize = fileGetPos(fileID) - recpos;

	  rcode  = IEG_P_Parameter(iegp->ipdb);
	  tabnum = IEG_P_CodeTable(iegp->ipdb);
	  param  = cdiEncodeParam(rcode, tabnum, 255);

	  if ( IEG_P_LevelType(iegp->ipdb) == IEG_LTYPE_HYBRID_LAYER )
	    rlevel = IEG_P_Level1(iegp->ipdb);
	  else
	    rlevel = IEG_P_Level2(iegp->ipdb);

	  if ( IEG_P_LevelType(iegp->ipdb) == 100 ) rlevel *= 100;

	  iegDateTime(iegp->ipdb, &vdate, &vtime);

	  if ( rindex == nrecs ) break;
	  recID = streamptr->tsteps[tsID].recIDs[rindex];

	  if ( rindex == 0 )
	    {
	      taxis->type  = TAXIS_ABSOLUTE;
	      taxis->vdate = vdate;
	      taxis->vtime = vtime;
	    }

	  compVar.param = param;
          compVar.level = rlevel;
	  compVar0.param = streamptr->tsteps[tsID].records[recID].param;
	  compVar0.level = streamptr->tsteps[tsID].records[recID].ilevel;

	  if ( memcmp(&compVar0, &compVar, sizeof(IEGCOMPVAR)) != 0 )
	    {
	      Message(func, "tsID = %d recID = %d param = %3d new %3d  level = %3d new %3d",
		      tsID, recID,
		      streamptr->tsteps[tsID].records[recID].param, param,
		      streamptr->tsteps[tsID].records[recID].ilevel, rlevel);
	      Error(func, "Invalid, unsupported or inconsistent record structure");
	    }

	  streamptr->tsteps[tsID].records[recID].position = recpos;
	  streamptr->tsteps[tsID].records[recID].size = recsize;

	  if ( CDI_Debug )
	    Message(func, "%4d%8d%4d%8d%8d%6d", rindex, (int)recpos, param, rlevel, vdate, vtime);
	}

      streamptr->rtsteps++;

      if ( streamptr->ntsteps != streamptr->rtsteps )
	{
	  tsID = tstepsNewEntry(streamID);
	  if ( tsID != streamptr->rtsteps )
	    Error(func, "Internal error. tsID = %d", tsID);

	  streamptr->tsteps[tsID-1].next   = 1;
	  streamptr->tsteps[tsID].position = recpos;
	}

      fileSetPos(fileID, streamptr->tsteps[tsID].position, SEEK_SET);
      streamptr->tsteps[tsID].position = recpos;
    }

  if ( nrecs > 0 && nrecs < streamptr->tsteps[tsID].nrecs )
    {
      Warning(func, "Incomplete timestep. Stop scanning at timestep %d.\n", tsID);
      streamptr->ntsteps = tsID;
    }

  return (streamptr->ntsteps);
}


int iegInqTimestep(int streamID, int tsID)
{
  static char func[] = "iegInqTimestep";
  int ntsteps, nrecs;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  if ( tsID == 0 && streamptr->rtsteps == 0 )
    Error(func, "Call to cdiInqContents missing!");

  if ( CDI_Debug )
    Message(func, "tsID = %d rtsteps = %d", tsID, streamptr->rtsteps);
  
  ntsteps = UNDEFID;
  while ( ( tsID + 1 ) > streamptr->rtsteps && ntsteps == UNDEFID )
    ntsteps = iegScanTimestep(streamID);

  if ( tsID >= streamptr->ntsteps && streamptr->ntsteps != CDI_UNDEFID )
    {
      nrecs = 0;
    }
  else
    {
      streamptr->curTsID = tsID;
      nrecs = streamptr->tsteps[tsID].nrecs;
    }

  return (nrecs);
}


void iegReadVarDP(int streamID, int varID, double *data, int *nmiss)
{
  static char func[] = "iegReadVarDP";
  int vlistID, fileID;
  int levID, nlevs, gridID, gridsize;
  off_t recpos, currentfilepos;
  int tsid;
  int recID;
  int i;
  int status;
  double missval;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  iegp     = streamptr->record->iegp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  nlevs    = streamptr->vars[varID].nlevs;
  missval  = vlistInqVarMissval(vlistID, varID);
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  tsid     = streamptr->curTsID;

  if ( CDI_Debug )
    Message(func, "nlevs = %d gridID = %d gridsize = %d", nlevs, gridID, gridsize);

  currentfilepos = fileGetPos(fileID);

  for (levID = 0; levID < nlevs; levID++)
    {
      recID = streamptr->vars[varID].level[levID];
      recpos = streamptr->tsteps[tsid].records[recID].position;
      fileSetPos(fileID, recpos, SEEK_SET);
      status = iegRead(fileID, iegp);
      iegInqDataDP(iegp, &data[levID*gridsize]);
    }
  fileSetPos(fileID, currentfilepos, SEEK_SET);

  *nmiss = 0;
  for ( i = 0; i < nlevs*gridsize; i++ )
    if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
      {
	data[i] = missval;
	(*nmiss)++;
      }
}


void iegReadVarSliceDP(int streamID, int varID, int levID, double *data, int *nmiss)
{
  static char func[] = "iegReadVarSliceDP";
  int vlistID, fileID;
  int nlevs, gridID, gridsize;
  off_t recpos, currentfilepos;
  int tsid;
  int recID;
  int i;
  int status;
  double missval;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  iegp     = streamptr->record->iegp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  nlevs    = streamptr->vars[varID].nlevs;
  missval  = vlistInqVarMissval(vlistID, varID);
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  tsid     = streamptr->curTsID;

  if ( CDI_Debug )
    Message(func, "nlevs = %d gridID = %d gridsize = %d",
	     nlevs, gridID, gridsize);

  currentfilepos = fileGetPos(fileID);

  recID = streamptr->vars[varID].level[levID];
  recpos = streamptr->tsteps[tsid].records[recID].position;
  fileSetPos(fileID, recpos, SEEK_SET);
  status = iegRead(fileID, iegp);
  iegInqDataDP(iegp, data);

  fileSetPos(fileID, currentfilepos, SEEK_SET);

  *nmiss = 0;
  for ( i = 0; i < gridsize; i++ )
    if ( DBL_IS_EQUAL(data[i], missval) || DBL_IS_EQUAL(data[i], (float)missval) )
      {
	data[i] = missval;
	(*nmiss)++;
      }
}


void iegWriteVarDP(int streamID, int varID, const double *data)
{
  static char func[] = "iegWriteVarDP";
  int fileID;
  int levID, nlevs, gridID, gridsize;
  int zaxisID;
  double level;
  int datatype;
  int tsID;
  int vlistID;
  int i;
  int date, time;
  int param, pdis, pcat, pnum;
  double refval;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d  varID = %d", streamID, varID);

  iegp     = streamptr->record->iegp;

  iegInitMem(iegp);
  for ( i = 0; i < 37; i++ ) iegp->ipdb[i] = -1;

  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  tsID     = streamptr->curTsID;
  gridID   = vlistInqVarGrid(vlistID, varID);
  gridsize = gridInqSize(gridID);
  zaxisID  = vlistInqVarZaxis(vlistID, varID);
  nlevs    = zaxisInqSize(zaxisID);

  if ( CDI_Debug )
    Message(func, "nlevs = %d gridID = %d gridsize = %d", nlevs, gridID, gridsize);

  param    = vlistInqVarParam(vlistID, varID);
  cdiDecodeParam(param, &pnum, &pcat, &pdis);
  IEG_P_Parameter(iegp->ipdb) = pnum;
  if ( pdis == 255 ) IEG_P_CodeTable(iegp->ipdb) = pcat;
  date     = streamptr->tsteps[tsID].taxis.vdate;
  time     = streamptr->tsteps[tsID].taxis.vtime;

  iegDefTime(iegp->ipdb, date, time, vlistInqTaxis(vlistID));
  iegDefGrid(iegp->igdb, gridID);

  datatype = vlistInqVarDatatype(vlistID, varID);

  iegp->dprec = iegDefDatatype(datatype);

  for ( levID = 0;  levID < nlevs; levID++ )
    {
      iegDefLevel(iegp->ipdb, iegp->igdb, iegp->vct, zaxisID, levID);

      refval = data[0];
      for ( i = 1; i < gridsize; i++ )
	if ( data[levID*gridsize+i] < refval ) refval = data[levID*gridsize+i];

      iegp->refval = refval;

      /*  header[1] = (int) level; */
      iegDefDataDP(iegp, &data[levID*gridsize]);
      iegWrite(fileID, iegp);
    }
}


void iegWriteVarSliceDP(int streamID, int varID, int levID, const double *data)
{
  static char func[] = "iegWriteVarSliceDP";
  int fileID;
  int gridID;
  int zaxisID;
  double level;
  int datatype;
  int tsID;
  int vlistID;
  int param, date, time, datasize;
  iegrec_t *iegp;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  iegp     = streamptr->record->iegp;
  vlistID  = streamInqVlist(streamID);
  fileID   = streamInqFileID(streamID);
  tsID     = streamptr->curTsID;
  gridID   = vlistInqVarGrid(vlistID, varID);
  zaxisID  = vlistInqVarZaxis(vlistID, varID);
  level    = zaxisInqLevel(zaxisID, levID);

  if ( CDI_Debug )
    Message(func, "gridID = %d zaxisID = %d", gridID, zaxisID);

  param = vlistInqVarParam(vlistID, varID);
  date = streamptr->tsteps[tsID].taxis.vdate;
  time = streamptr->tsteps[tsID].taxis.vtime;
  datasize = gridInqSize(gridID);

  datatype = vlistInqVarDatatype(vlistID, varID);

  iegp->dprec = iegDefDatatype(datatype);

  iegDefDataDP(iegp, data);
  iegWrite(fileID, iegp);
}

#endif /* HAVE_LIBIEG */
#if defined (HAVE_CONFIG_H)
#endif






#if  defined  (HAVE_LIBNETCDF)
#endif

#undef  UNDEFID
#define UNDEFID  CDI_UNDEFID


void cdfDefGlobalAtts(int streamID);
void cdfDefLocalAtts(int streamID);

#define  MAXNAMELEN  256

#define  X_AXIS  1
#define  Y_AXIS  2
#define  Z_AXIS  3
#define  T_AXIS  4

typedef struct {
  int     ncvarid;
  int     dimtype;
  size_t  len;
  char    name[MAXNAMELEN];
}
NCDIM;

typedef struct {
  int      ignore;
  int      isvar;
  int      islon;
  int      islat;
  int      islev;
  int      warn;
  int      timeID;
  int      code;
  int      tabnum;
  int      bounds;
  int      gridID;
  int      zaxisID;
  int      gridtype;
  int      zaxistype;
  int      xdim;
  int      ydim;
  int      zdim;
  int      xvarid;
  int      yvarid;
  int      zvarid;
  int      tvarid;
  int      ncoordvars;
  int      coordvarids[4];
  int      cellarea;
  int      calendar;
  int      tableID;
  int      truncation;
  int      defmiss;
  int      xtype;
  int      ndims;
  int      gmapid;
  int      positive;
  int      dimids[8];
  int      dimtype[8];
  int      natts;
  int     *atts;
  int      deflate;
  size_t   vlen;
  double  *vdata;
  double   missval;
  double   addoffset;
  double   scalefactor;
  char     name[MAXNAMELEN];
  char     longname[MAXNAMELEN];
  char     stdname[MAXNAMELEN];
  char     units[MAXNAMELEN];
}
NCVAR;

static
void strtolower(char *str)
{
  int i, len;

  if ( str )
    {
      len = (int) strlen(str);
      for ( i = 0; i < len; i++ )
	str[i] = tolower((int) str[i]);
    }
}

static
int get_timeunit(int len, char *ptu)
{
  int timeunit = -1;

  if ( len > 2 )
    {
      if      ( memcmp(ptu, "sec",    3) == 0 )          timeunit = TUNIT_SECOND;
      else if ( memcmp(ptu, "minute", 6) == 0 )          timeunit = TUNIT_MINUTE;
      else if ( memcmp(ptu, "hour",   4) == 0 )          timeunit = TUNIT_HOUR;
      else if ( memcmp(ptu, "day",    3) == 0 )          timeunit = TUNIT_DAY;
      else if ( memcmp(ptu, "month",  5) == 0 )          timeunit = TUNIT_MONTH;
      else if ( memcmp(ptu, "calendar_month", 14) == 0 ) timeunit = TUNIT_MONTH;
      else if ( memcmp(ptu, "year",   4) == 0 )          timeunit = TUNIT_YEAR;
    }
  else if ( len == 1 )
    {
      if ( ptu[0] == 's' ) timeunit = TUNIT_SECOND;
    }

  return (timeunit);
}

static
int isTimeUnits(const char *timeunits)
{
  static char func[] = "isTimeUnits";
  int len, i;
  char *ptu, *tu;
  int timetype = -1;
  int timeunit;
  int status = FALSE;

  len = (int) strlen(timeunits);
  tu = (char *) malloc((len+1)*sizeof(char));
  memcpy(tu, timeunits, (len+1)*sizeof(char));
  ptu = tu;

  for ( i = 0; i < len; i++ ) ptu[i] = tolower((int) ptu[i]);

  timeunit = get_timeunit(len, ptu);
  if ( timeunit != -1 )
    {

      while ( ! isspace(*ptu) && *ptu != 0 ) ptu++;
      if ( *ptu )
	{
	  while ( isspace(*ptu) ) ptu++;
	  
	  if ( memcmp(ptu, "as", 2) == 0 )
	    timetype = TAXIS_ABSOLUTE;
	  else if ( memcmp(ptu, "since", 5) == 0 )
	    timetype = TAXIS_RELATIVE;

	  if ( timetype != -1 ) status = TRUE;
	}
    }

  free(tu);

  return (status);
}

static
int splitBasetime(const char *timeunits, taxis_t *taxis)
{
  static char func[] = "splitBasetime";
  int len, i;
  char *ptu, *tu;
  int year, month, day;
  int hour = 0, minute = 0, second = 0;
  int timetype = TAXIS_ABSOLUTE;
  int rdate = -1, rtime = -1;
  int timeunit;

  len = (int) strlen(timeunits);
  tu = (char *) malloc((len+1)*sizeof(char));
  memcpy(tu, timeunits, (len+1)*sizeof(char));
  ptu = tu;

  for ( i = 0; i < len; i++ ) ptu[i] = tolower((int) ptu[i]);

  timeunit = get_timeunit(len, ptu);
  if ( timeunit == -1 )
    {
      Message(func, "Unsupported TIMEUNIT: %s!", timeunits);
      return (1);
    }

  while ( ! isspace(*ptu) && *ptu != 0 ) ptu++;
  if ( *ptu )
    {
      while ( isspace(*ptu) ) ptu++;

      if ( memcmp(ptu, "as", 2) == 0 )
	timetype = TAXIS_ABSOLUTE;
      else if ( memcmp(ptu, "since", 5) == 0 )
	timetype = TAXIS_RELATIVE;

      while ( ! isspace(*ptu) && *ptu != 0 ) ptu++;
      if ( *ptu )
	{
	  while ( isspace(*ptu) ) ptu++;

	  if ( timetype == TAXIS_ABSOLUTE )
	    {
	      if ( memcmp(ptu, "%y%m%d.%f", 9) != 0 && timeunit == TUNIT_DAY )
		{
		  Message(func, "Unsupported format %s for TIMEUNIT day!", ptu);
		  timeunit = -1;
		}
	      else if ( memcmp(ptu, "%y%m.%f", 7) != 0 && timeunit == TUNIT_MONTH )
		{
		  Message(func, "Unsupported format %s for TIMEUNIT month!", ptu);
		  timeunit = -1;
		}
	    }
	  else if ( timetype == TAXIS_RELATIVE )
	    {
	      year = atoi(ptu);
	      if ( year < 0 ) ptu++;
	      while ( isdigit((int) *ptu) ) ptu++;
	      month = atoi(++ptu);
	      while ( isdigit((int) *ptu) ) ptu++;
	      day = atoi(++ptu);
	      while ( isdigit((int) *ptu) ) ptu++;

	      while ( isspace((int) *ptu) ) ptu++;

	      if ( *ptu )
		{
		  while ( ! isdigit((int) *ptu) ) ptu++;

		  hour = atoi(ptu);
		  while ( isdigit((int) *ptu) ) ptu++;
		  if ( *ptu == ':' )
		    {
		      ptu++;
		      minute = atoi(ptu);
		      while ( isdigit((int) *ptu) ) ptu++;
		      if ( *ptu == ':' )
			{
			  ptu++;
			  second = atoi(ptu);
			  /*
			  if ( second != 0 )
			    Message(func, "Seconds not supported in time units!");
			  */
			}
		    }
		}

	      rdate = cdiEncodeDate(year, month, day);
	      rtime = cdiEncodeTime(hour, minute, second);
	      (*taxis).rdate = rdate;
	      (*taxis).rtime = rtime;

	      if ( CDI_Debug )
		Message(func, "rdate = %d  rtime = %d", rdate, rtime);	      
	    }
	}
    }

  (*taxis).type = timetype;
  (*taxis).unit = timeunit;

  free(tu);

  if ( CDI_Debug )
    Message(func, "timetype = %d  unit = %d", timetype, timeunit);

  return (0);
}


#if  defined  (HAVE_LIBNETCDF)
static
void cdfGetAttInt(int fileID, int ncvarid, char *attname, int attlen, int *attint)
{
  static char func[] = "cdfGetAttInt";
  size_t nc_attlen;
  int *pintatt;

  cdf_inq_attlen(fileID, ncvarid, attname, &nc_attlen);

  if ( (int)nc_attlen > attlen )
    pintatt = (int *) malloc(nc_attlen*sizeof(int));
  else
    pintatt = attint;

  cdf_get_att_int(fileID, ncvarid, attname, pintatt);

  if ( (int)nc_attlen > attlen )
    {
      memcpy(attint, pintatt, attlen*sizeof(int));
      free(pintatt);
    }
}
#endif

#if  defined  (HAVE_LIBNETCDF)
static void cdfGetAttDouble(int fileID, int ncvarid, char *attname, int attlen, double *attdouble)
{
  static char func[] = "cdfGetAttDouble";
  size_t nc_attlen;
  double *pdoubleatt;

  cdf_inq_attlen(fileID, ncvarid, attname, &nc_attlen);

  if ( (int)nc_attlen > attlen )
    pdoubleatt = (double *) malloc(nc_attlen*sizeof(double));
  else
    pdoubleatt = attdouble;

  cdf_get_att_double(fileID, ncvarid, attname, pdoubleatt);

  if ( (int)nc_attlen > attlen )
    {
      memcpy(attdouble, pdoubleatt, attlen*sizeof(double));
      free(pdoubleatt);
    }
}
#endif

#if  defined  (HAVE_LIBNETCDF)
static
void cdfGetAttText(int fileID, int ncvarid, char *attname, int attlen, char *atttext)
{
  size_t nc_attlen;
  char attbuf[65636];

  cdf_inq_attlen(fileID, ncvarid, attname, &nc_attlen);

  if ( nc_attlen < sizeof(attbuf) )
    {
      cdf_get_att_text(fileID, ncvarid, attname, attbuf);

      attbuf[nc_attlen++] = 0;

      if ( (int) nc_attlen > attlen ) nc_attlen = attlen;
      memcpy(atttext, attbuf, nc_attlen);
    }
  else
    {
      atttext[0] = 0;
    }
}
#endif

#if  defined  (HAVE_LIBNETCDF)
static
int cdfInqDatatype(int xtype)
{
  int datatype;

  if      ( xtype == NC_BYTE   )  datatype = DATATYPE_INT8;
  /* else if ( xtype == NC_CHAR   )  datatype = DATATYPE_UINT8; */
  else if ( xtype == NC_SHORT  )  datatype = DATATYPE_INT16;
  else if ( xtype == NC_INT    )  datatype = DATATYPE_INT32;
  else if ( xtype == NC_DOUBLE )  datatype = DATATYPE_FLT64;
  else                            datatype = DATATYPE_FLT32;

  return (datatype);
}
#endif

#if  defined  (HAVE_LIBNETCDF)
static
int cdfDefDatatype(int datatype)
{
  static char func[] = "cdfDefDatatype";
  int xtype;

  if ( datatype == DATATYPE_CPX32 || datatype == DATATYPE_CPX64 )
    Error(func, "CDI/netCDF library does not support complex numbers!");

  if      ( datatype == DATATYPE_INT8   ) xtype = NC_BYTE;
  else if ( datatype == DATATYPE_UINT8  ) xtype = NC_SHORT;
  else if ( datatype == DATATYPE_INT16  ) xtype = NC_SHORT;
  else if ( datatype == DATATYPE_UINT16 ) xtype = NC_INT;
  else if ( datatype == DATATYPE_INT32  ) xtype = NC_INT;
  else if ( datatype == DATATYPE_UINT32 ) xtype = NC_INT;
  else if ( datatype == DATATYPE_FLT64  ) xtype = NC_DOUBLE;
  else                                    xtype = NC_FLOAT;

  return (xtype);
}
#endif


#if  defined  (HAVE_LIBNETCDF)
static
void defineAttributes(int vlistID, int varID, int fileID, int ncvarID)
{
  static char func[] = "defineAttributes";
  int natts, iatt;
  int atttype, attlen;
  size_t len;
  char attname[1024];
  char atttxt[8192];

  vlistInqNatts(vlistID, varID, &natts);

  for ( iatt = 0; iatt < natts; iatt++ )
    {
      vlistInqAtt(vlistID, varID, iatt, attname, &atttype, &attlen);

      if ( atttype == DATATYPE_TXT )
	{
	  vlistInqAttTxt(vlistID, varID, attname, sizeof(atttxt), atttxt);
	  len = attlen;
	  cdf_put_att_text(fileID, ncvarID, attname, len, atttxt);
	}
      else if ( atttype == DATATYPE_INT )
	{
	  int *attint;
	  attint = (int *) malloc(attlen*sizeof(int));
	  vlistInqAttInt(vlistID, varID, attname, attlen, &attint[0]);
	  len = attlen;
	  cdf_put_att_int(fileID, ncvarID, attname, NC_INT, len, attint);
	  free(attint);
	}
      else if ( atttype == DATATYPE_FLT )
	{
	  double *attflt;
	  attflt = (double *) malloc(attlen*sizeof(double));
	  vlistInqAttFlt(vlistID, varID, attname, attlen, attflt);
	  len = attlen;
	  cdf_put_att_double(fileID, ncvarID, attname, NC_DOUBLE, len, attflt);
	  free(attflt);
	}
    }
}
#endif


int cdfCopyRecord(int streamID2, int streamID1)
{
  static char func[] = "cdfCopyRecord";
  double *data;
  int datasize;
  int tsID1, tsID2, recID1, recID2;
  int ivarID, gridID;
  int nmiss;
  int ierr = 0;
  int vlistID1, vlistID2;
  stream_t *streamptr1;
  stream_t *streamptr2;

  streamptr1 = stream_to_pointer(streamID1);
  streamptr2 = stream_to_pointer(streamID2);

  stream_check_ptr(func, streamptr1);
  stream_check_ptr(func, streamptr2);

  vlistID1 = streamptr1->vlistID;
  vlistID2 = streamptr2->vlistID;

  tsID1 = streamptr1->curTsID;
  tsID2 = streamptr2->curTsID;

  recID1 = streamptr1->tsteps[tsID1].curRecID;
  recID2 = streamptr2->tsteps[tsID2].curRecID;

  ivarID = streamptr1->tsteps[tsID1].records[recID1].varID;

  gridID = vlistInqVarGrid(vlistID1, ivarID);

  datasize = gridInqSize(gridID);      
  /* bug fix for constant netCDF fields */
  if ( datasize < 1048576 ) datasize = 1048576;

  data = (double *) malloc(datasize*sizeof(double));

  streamReadRecord(streamID1, data, &nmiss);
  streamWriteRecord(streamID2, data, nmiss);

  free(data);

  return (ierr);
}

/* not used
int cdfInqRecord(int streamID, int *varID, int *levelID)
{
  static char func[] = "cdfInqRecord";
  int tsID, recID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  stream_check_ptr(func, streamptr);

  recID = streamptr->tsteps[0].curRecID++;
  printf("cdfInqRecord recID %d %d\n", recID, streamptr->tsteps[0].curRecID);
  printf("cdfInqRecord tsID %d\n", streamptr->curTsID);

  if ( streamptr->tsteps[0].curRecID >= 
       streamptr->tsteps[0].nrecs )
    {
      streamptr->tsteps[0].curRecID = 0;
    }

  *varID   = streamptr->tsteps[0].records[recID].varID;
  *levelID = streamptr->tsteps[0].records[recID].levelID;

  streamptr->record->varID   = *varID;
  streamptr->record->levelID = *levelID;

  if ( CDI_Debug )
    Message(func, "recID = %d  varID = %d  levelID = %d", recID, *varID, *levelID);
  
  return (recID+1);
}
*/
int cdfDefRecord(int streamID)
{
  static char func[] = "cdfDefRecord";
  int ierr = 0;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d", streamID);

  stream_check_ptr(func, streamptr);

  return (ierr);
}

static
void cdfWriteGridTraj(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  int tsID, fileID;
  int lonID, latID, gridindex;
  size_t index;
  double xlon, xlat;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  gridindex = vlistGridIndex(vlistID, gridID);
  lonID = streamptr->xdimID[gridindex];
  latID = streamptr->ydimID[gridindex];

  xlon = gridInqXval(gridID, 0);
  xlat = gridInqYval(gridID, 0);
  tsID = streamptr->curTsID;
  index = tsID;

  cdf_put_var1_double(fileID, lonID, &index, &xlon);
  cdf_put_var1_double(fileID, latID, &index, &xlat);
#endif
}

static
void cdfReadGridTraj(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  int tsID, fileID;
  int lonID, latID, gridindex;
  size_t index;
  double xlon, xlat;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  gridindex = vlistGridIndex(vlistID, gridID);
  lonID = streamptr->xdimID[gridindex];
  latID = streamptr->ydimID[gridindex];

  tsID = streamptr->curTsID;
  index = tsID;

  cdf_get_var1_double(fileID, lonID, &index, &xlon);
  cdf_get_var1_double(fileID, latID, &index, &xlat);

  gridDefXvals(gridID, &xlon);
  gridDefYvals(gridID, &xlat);
#endif
}


#if  defined  (HAVE_LIBNETCDF)
static
void cdfDefVarDeflate(int ncid, int ncvarid, int deflate_level)
{
  static char func[] = "cdfDefVarDeflate";
#if  defined  (NC_NETCDF4)
  int retval;
  /* Set chunking, shuffle, and deflate. */
  int shuffle = 1;
  int deflate = 1;

  if ( deflate_level < 1 || deflate_level > 9 ) deflate_level = 1;

  if ((retval = nc_def_var_deflate(ncid, ncvarid, shuffle, deflate, deflate_level)))
    {
      Error(func, "nc_def_var_deflate failed, status = %d", retval);
    }
#else
  static int lwarn = TRUE;

  if ( lwarn )
    {
      lwarn = FALSE;
      Warning(func, "Deflate compression failed, netCDF4 not available!");
    }
#endif
}
#endif

#if  defined  (HAVE_LIBNETCDF)

static
void cdfDefVarSzip(int ncid, int ncvarid)
{
  static char func[] = "cdfDefVarSzip";
#if  defined  (NC_NETCDF4) && defined (NC_SZIP_NN_OPTION_MASK)
  int retval;
  /* Set options_mask and bits_per_pixel. */
  int options_mask = NC_SZIP_NN_OPTION_MASK;
  int bits_per_pixel = 16;

  if ((retval = nc_def_var_szip(ncid, ncvarid, options_mask, bits_per_pixel)))
    {
      if ( retval == NC_EINVAL )
	{
	  static int lwarn = TRUE;

	  if ( lwarn )
	    {
	      lwarn = FALSE;
	      Warning(func, "netCDF4/Szip compression not compiled in!");
	    }	  
	}
      else
	Error(func, "nc_def_var_szip failed, status = %d", retval);
    }
#else
  static int lwarn = TRUE;

  if ( lwarn )
    {
      lwarn = FALSE;
      Warning(func, "netCDF4/Szip compression not available!");
    }
#endif
}
#endif

static
void cdfDefVarMissval(int streamID, int varID, int dtype, int lcheck)
{
#if  defined  (HAVE_LIBNETCDF)
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( streamptr->vars[varID].defmiss == FALSE )
    {
      int fileID;
      int ncvarid;
      double missval;
      int vlistID;
      int xtype;

      vlistID = streamInqVlist(streamID);
      fileID  = streamInqFileID(streamID);
      ncvarid = streamptr->vars[varID].ncvarid;
      missval = vlistInqVarMissval(vlistID, varID);
      if ( lcheck && streamptr->ncmode == 2 ) cdf_redef(fileID);

      xtype = cdfDefDatatype(dtype);

      cdf_put_att_double(fileID, ncvarid, "_FillValue", (nc_type) xtype, 1L, &missval);

      if ( cdiNcMissingValue == 1 )
	cdf_put_att_double(fileID, ncvarid, "missing_value", (nc_type) xtype, 1L, &missval);

      if ( lcheck && streamptr->ncmode == 2 ) cdf_enddef(fileID);

      streamptr->vars[varID].defmiss = TRUE;
    }
#endif
}


void cdfWriteRecord(int streamID, const double *data, int nmiss)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfWriteRecord";
  int varID;
  int levelID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  varID   = streamptr->record->varID;
  levelID = streamptr->record->levelID;

  if ( CDI_Debug )
    Message(func, "streamID = %d  varID = %d", streamID, varID);

  cdfWriteVarSliceDP(streamID, varID, levelID, data, nmiss);
#endif
}


int cdfReadRecord(int streamID, double *data, int *nmiss)
{
  static char func[] = "cdfReadRecord";
  int ierr = 0;
  int levelID, varID, tsID, recID, vrecID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug ) Message(func, "streamID = %d", streamID);

  tsID    = streamptr->curTsID;
  vrecID  = streamptr->tsteps[tsID].curRecID;
  recID   = streamptr->tsteps[tsID].recIDs[vrecID];
  varID   = streamptr->tsteps[tsID].records[recID].varID;
  levelID = streamptr->tsteps[tsID].records[recID].levelID;

  cdfReadVarSliceDP(streamID, varID, levelID, data, nmiss);

  return (ierr);
}

static
void cdfDefTimeValue(int streamID, int tsID)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfDefTimeValue";
  int fileID;
  double timevalue;
  int ncvarid;
  size_t index;
  taxis_t *taxis;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  fileID = streamInqFileID(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d, fileID = %d", streamID, fileID);

  taxis = &streamptr->tsteps[tsID].taxis;

  if ( streamptr->ncmode == 1 )
    {
      cdf_enddef(fileID);
      streamptr->ncmode = 2;
    }

  index = tsID;

  timevalue = cdiEncodeTimeval(taxis->vdate, taxis->vtime, &streamptr->tsteps[0].taxis);
  if ( CDI_Debug ) Message(func, "tsID = %d  timevalue = %f", tsID, timevalue);

  ncvarid = streamptr->basetime.ncvarid;
  cdf_put_var1_double(fileID, ncvarid, &index, &timevalue);

  if ( taxis->has_bounds )
    {
      size_t start[2], count[2];

      ncvarid = streamptr->basetime.ncvarboundsid;

      timevalue = cdiEncodeTimeval(taxis->vdate_lb, taxis->vtime_lb, &streamptr->tsteps[0].taxis);
      start[0] = tsID; count[0] = 1; start[1] = 0; count[1] = 1;
      cdf_put_vara_double(fileID, ncvarid, start, count, &timevalue);

      timevalue = cdiEncodeTimeval(taxis->vdate_ub, taxis->vtime_ub, &streamptr->tsteps[0].taxis);
      start[0] = tsID; count[0] = 1; start[1] = 1; count[1] = 1;
      cdf_put_vara_double(fileID, ncvarid, start, count, &timevalue);
    }
  /*
printf("fileID = %d %d %d %f\n", fileID, time_varid, index, timevalue);
  */
#endif
}

static
void cdfDefTime(int streamID)
{
#if  defined  (HAVE_LIBNETCDF)
  int fileID;
  int time_varid;
  int time_bndsid;
  int dims[2];
  int year, month, day, hour, minute, second;
  char unitstr[80];
  char calstr[80];
  size_t len;
  taxis_t *taxis;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( streamptr->basetime.ncvarid != UNDEFID ) return;

  fileID = streamInqFileID(streamID);

  if ( streamptr->ncmode == 0 ) streamptr->ncmode = 1;

  if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

  cdf_def_dim(fileID, "time", NC_UNLIMITED, &streamptr->basetime.ncdimid);

  dims[0] = streamptr->basetime.ncdimid;
  cdf_def_var(fileID, "time", NC_DOUBLE, 1, dims, &time_varid);

  streamptr->basetime.ncvarid = time_varid;

  taxis = &streamptr->tsteps[0].taxis;

  if ( taxis->has_bounds )
    {
      /* fprintf(stderr, "time has bounds\n"); */

      cdf_def_dim(fileID, "tbnds", 2, &dims[1]);
      cdf_def_var(fileID, "time_bnds", NC_DOUBLE, 2, dims, &time_bndsid);

      streamptr->basetime.ncvarboundsid = time_bndsid;

      cdf_put_att_text(fileID, time_varid, "bounds", 9, "time_bnds");
    }

  unitstr[0] = 0;
  if ( streamptr->tsteps[0].taxis.type == TAXIS_ABSOLUTE )
    {
      if ( streamptr->tsteps[0].taxis.unit == TUNIT_YEAR )
	sprintf(unitstr, "year as %s", "%Y.%f");
      else if ( streamptr->tsteps[0].taxis.unit == TUNIT_MONTH )
	sprintf(unitstr, "month as %s", "%Y%m.%f");
      else
	sprintf(unitstr, "day as %s", "%Y%m%d.%f");
    }
  else
    {
      int rdate, rtime;
      int timeunit;

      timeunit = taxis->unit;
      rdate    = taxis->rdate;
      rtime    = taxis->rtime;
      if ( rdate == -1 )
	{
	  rdate  = taxis->vdate;
	  rtime  = taxis->vtime;
	}

      cdiDecodeDate(rdate, &year, &month, &day);
      cdiDecodeTime(rtime, &hour, &minute, &second);

      if ( timeunit == TUNIT_QUARTER ) timeunit = TUNIT_MINUTE;
      sprintf(unitstr, "%s since %d-%02d-%02d %02d:%02d:%02d",
	      tunitNamePtr(timeunit), year, month, day, hour, minute, second);
    }

  len = strlen(unitstr);
  if ( len )
    cdf_put_att_text(fileID, time_varid, "units", len, unitstr);

  if ( taxis->has_bounds )
    if ( len )
      cdf_put_att_text(fileID, time_bndsid, "units", len, unitstr);

  if ( taxis->calendar != -1 )
    {
      calstr[0] = 0;

      if      ( taxis->calendar == CALENDAR_STANDARD )  strcpy(calstr, "standard");
      else if ( taxis->calendar == CALENDAR_PROLEPTIC ) strcpy(calstr, "proleptic_gregorian");
      else if ( taxis->calendar == CALENDAR_NONE )      strcpy(calstr, "none");
      else if ( taxis->calendar == CALENDAR_360DAYS )   strcpy(calstr, "360_day");
      else if ( taxis->calendar == CALENDAR_365DAYS )   strcpy(calstr, "365_day");
      else if ( taxis->calendar == CALENDAR_366DAYS )   strcpy(calstr, "366_day");

      len = strlen(calstr);
      if ( len )
	{
	  cdf_put_att_text(fileID, time_varid, "calendar", len, calstr);

	  if ( taxis->has_bounds )
	    cdf_put_att_text(fileID, time_bndsid, "calendar", len, calstr);
	}
    }

  if ( streamptr->ncmode == 2 ) cdf_enddef(fileID);
#endif
}


void cdfDefTimestep(int streamID, int tsID)
{
  int vlistID;

  vlistID = streamInqVlist(streamID);

  if ( vlistHasTime(vlistID) ) cdfDefTime(streamID);

  cdfDefTimeValue(streamID, tsID);
}

static
void cdfDefComplex(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  char axisname[] = "complex";
  int index;
  int dimID = UNDEFID;
  int gridID0, gridtype0, gridindex;
  int ngrids;
  int fileID;
  int dimlen;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  ngrids = vlistNgrids(vlistID);

  for ( index = 0; index < ngrids; index++ )
    {
      if ( streamptr->xdimID[index] != UNDEFID )
	{
	  gridID0 = vlistGrid(vlistID, index);
	  gridtype0 = gridInqType(gridID0);
	  if ( gridtype0 == GRID_SPECTRAL )
	    {
	      dimID = streamptr->xdimID[index];
	      break;
	    }
	}
    }

  if ( dimID == UNDEFID )
    {
      dimlen = 2;

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_dim(fileID, axisname, dimlen, &dimID);

      cdf_enddef(fileID);
      streamptr->ncmode = 2;
    }

  gridindex = vlistGridIndex(vlistID, gridID);
  streamptr->xdimID[gridindex] = dimID;

#endif
}

static
void cdfDefSpc(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  /*
  char longname[] = "Spherical harmonic coefficient";
  */
  char axisname[5] = "spcX";
  int index, iz = 0;
  int gridID0, gridtype0, gridindex;
  int dimID = UNDEFID;
  int ngrids;
  int fileID;
  int dimlen, dimlen0;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  ngrids = vlistNgrids(vlistID);

  dimlen = gridInqSize(gridID)/2;

  for ( index = 0; index < ngrids; index++ )
    {
      if ( streamptr->ydimID[index] != UNDEFID )
	{
	  gridID0 = vlistGrid(vlistID, index);
	  gridtype0 = gridInqType(gridID0);
	  if ( gridtype0 == GRID_SPECTRAL )
	    {
	      dimlen0 = gridInqSize(gridID0)/2;
	      if ( dimlen == dimlen0 )
		{
		  dimID = streamptr->ydimID[index];
		  break;
		}
	      else
		iz++;	
	    }
	}
    }

  if ( dimID == UNDEFID )
    {
      if ( iz == 0 ) axisname[3] = '\0';
      else           sprintf(&axisname[3], "%1d", iz+1);

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_dim(fileID, axisname, dimlen, &dimID);

      cdf_enddef(fileID);
      streamptr->ncmode = 2;
    }

  gridindex = vlistGridIndex(vlistID, gridID);
  streamptr->ydimID[gridindex] = dimID;

#endif
}

static
void cdfDefTrajLon(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfDefTrajLon";
  char units[256];
  char longname[256];
  char stdname[256];
  char axisname[256];
  int gridtype, gridindex;
  int dimID = UNDEFID;
  int fileID;
  int dimlen;
  size_t len;
  int ncvarid;
  int vlistID;
  int xtype = NC_DOUBLE;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( gridInqPrec(gridID) == DATATYPE_FLT32 ) xtype = NC_FLOAT;

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  gridtype = gridInqType(gridID);
  dimlen = gridInqXsize(gridID);
  if ( dimlen != 1 ) Error(func, "Xsize isn't 1 for %s grid!", gridNamePtr(gridtype));

  gridindex = vlistGridIndex(vlistID, gridID);
  ncvarid = streamptr->xdimID[gridindex];

  gridInqXname(gridID, axisname);
  gridInqXlongname(gridID, longname);
  gridInqXstdname(gridID, stdname);
  gridInqXunits(gridID, units);

  if ( ncvarid == UNDEFID )
    {
      dimID = streamptr->basetime.ncvarid;

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_var(fileID, axisname, (nc_type) xtype, 1, &dimID, &ncvarid);
      if ( (len = strlen(longname)) )
	cdf_put_att_text(fileID, ncvarid, "long_name", len, longname);
      if ( (len = strlen(units)) )
	cdf_put_att_text(fileID, ncvarid, "units", len, units);
      if ( (len = strlen(stdname)) )
	cdf_put_att_text(fileID, ncvarid, "standard_name", len, stdname);

      cdf_enddef(fileID);
      streamptr->ncmode = 2;
    }

  streamptr->xdimID[gridindex] = ncvarid; /* var ID for trajectory !!! */

#endif
}

static
void cdfDefTrajLat(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfDefTrajLat";
  char units[] = "degrees_north";
  char longname[] = "latitude";
  char stdname[] = "latitude";
  char axisname[] = "tlat";
  int gridtype, gridindex;
  int dimID = UNDEFID;
  int fileID;
  int dimlen;
  size_t len;
  int ncvarid;
  int vlistID;
  int xtype = NC_DOUBLE;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( gridInqPrec(gridID) == DATATYPE_FLT32 ) xtype = NC_FLOAT;

  vlistID = streamInqVlist(streamID);
  fileID = streamInqFileID(streamID);

  gridtype = gridInqType(gridID);
  dimlen = gridInqYsize(gridID);
  if ( dimlen != 1 ) Error(func, "Ysize isn't 1 for %s grid!", gridNamePtr(gridtype));

  gridindex = vlistGridIndex(vlistID, gridID);
  ncvarid = streamptr->ydimID[gridindex];

  gridInqYname(gridID, axisname);
  gridInqYlongname(gridID, longname);
  gridInqYstdname(gridID, stdname);
  gridInqYunits(gridID, units);

  if ( ncvarid == UNDEFID )
    {
      dimID = streamptr->basetime.ncvarid;

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_var(fileID, axisname, (nc_type) xtype, 1, &dimID, &ncvarid);
      if ( (len = strlen(longname)) )
	cdf_put_att_text(fileID, ncvarid, "long_name", len, longname);
      if ( (len = strlen(units)) )
	cdf_put_att_text(fileID, ncvarid, "units", len, units);
      if ( (len = strlen(stdname)) )
	cdf_put_att_text(fileID, ncvarid, "standard_name", len, stdname);

      cdf_enddef(fileID);
      streamptr->ncmode = 2;
    }

  streamptr->ydimID[gridindex] = ncvarid; /* var ID for trajectory !!! */

#endif
}

#if  defined  (HAVE_LIBNETCDF)
static
int checkGridName(int type, char *axisname, int fileID, int vlistID, int gridID, int ngrids, int mode)
{
  int iz, index;
  int gridID0;
  int ncdimid;
  char axisname0[256];
  char axisname2[256];
  int checkname;
  int status;

  /* check that the name is not already defined */
  checkname = TRUE;
  iz = 0;

  while ( checkname ) 
    {
      strcpy(axisname2, axisname);
      if ( iz ) sprintf(&axisname2[strlen(axisname2)], "_%d", iz+1);

      //status = nc_inq_varid(fileID, axisname2, &ncvarid);
      if ( type == 'V' ) /* type Var oder Dim */
	status = nc_inq_varid(fileID, axisname2, &ncdimid);
      else
	status = nc_inq_dimid(fileID, axisname2, &ncdimid);

      if ( status != NC_NOERR )
	{
	  if ( iz )
	    {
	      /* check that the name does not exist for other grids */
	      for ( index = 0; index < ngrids; index++ )
		{
		  gridID0 = vlistGrid(vlistID, index);
		  if ( gridID != gridID0 )
		    {
		      if ( mode == 'X' ) /* mode X or Y */
			gridInqXname(gridID0, axisname0);
		      else
			gridInqYname(gridID0, axisname0);

		      if ( strcmp(axisname0, axisname2) == 0 ) break;
		    }
		}
	      if ( index == ngrids ) checkname = FALSE;
	    }
	  else
	    {
	      checkname = FALSE;
	    }
	}

      if ( checkname ) iz++;
      
      if ( iz > 99 ) break;
    }
  
  if ( iz ) sprintf(&axisname[strlen(axisname)], "_%d", iz+1);

  return (iz);
}
#endif

static
void cdfDefXaxis(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfDefXaxis";
  char units[256];
  char longname[256];
  char stdname[256];
  char axisname[256];
  int index;
  /*  int index2; */
  int gridID0, gridtype0, gridindex;
  int dimID = UNDEFID;
  int dimIDs[2];
  int ngrids;
  int fileID;
  int dimlen, dimlen0;
  size_t len;
  int ncvarid = UNDEFID, ncbvarid = UNDEFID;
  int nvertex = 2, nvdimID = -1;
  int vlistID;
  int xtype = NC_DOUBLE;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( gridInqPrec(gridID) == DATATYPE_FLT32 ) xtype = NC_FLOAT;

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  ngrids = vlistNgrids(vlistID);

  dimlen = gridInqXsize(gridID);
  gridindex = vlistGridIndex(vlistID, gridID);

  gridInqXname(gridID, axisname);
  gridInqXlongname(gridID, longname);
  gridInqXstdname(gridID, stdname);
  gridInqXunits(gridID, units);

  if ( axisname[0] == 0 ) Error(func, "axis name undefined!\n");

  for ( index = 0; index < ngrids; index++ )
    {
      if ( streamptr->xdimID[index] != UNDEFID )
	{
	  gridID0 = vlistGrid(vlistID, index);
	  gridtype0 = gridInqType(gridID0);
	  if ( gridtype0 == GRID_GAUSSIAN    ||
	       gridtype0 == GRID_LONLAT      ||
	       gridtype0 == GRID_CURVILINEAR ||
	       gridtype0 == GRID_GENERIC )
	    {
	      dimlen0 = gridInqXsize(gridID0);
	      if ( dimlen == dimlen0 )
		if ( IS_EQUAL(gridInqXval(gridID0, 0), gridInqXval(gridID, 0)) &&
		     IS_EQUAL(gridInqXval(gridID0, dimlen-1), gridInqXval(gridID, dimlen-1)) )
		  {
		    dimID = streamptr->xdimID[index];
		    break;
		  }
	      /*
	      for ( index2 = 0; index2 < index; index2++ )
		if ( streamptr->xdimID[index] == streamptr->xdimID[index2] )
		  break;
	      if ( index2 == index ) iz++;
	      */
	    }
	}
    }

  if ( dimID == UNDEFID )
    {
      int status;
      status = checkGridName('V', axisname, fileID, vlistID, gridID, ngrids, 'X');
      if ( status == 0 )
	status = checkGridName('D', axisname, fileID, vlistID, gridID, ngrids, 'X');

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_dim(fileID, axisname, dimlen, &dimID);

      if ( gridInqXboundsPtr(gridID) || gridInqYboundsPtr(gridID) )
	cdf_def_dim(fileID, "nv", nvertex, &nvdimID);

      if ( gridInqXvalsPtr(gridID) )
	{
	  cdf_def_var(fileID, axisname, (nc_type) xtype, 1, &dimID, &ncvarid);
	  if ( (len = strlen(longname)) )
	    cdf_put_att_text(fileID, ncvarid, "long_name", len, longname);
	  if ( (len = strlen(units)) )
	    cdf_put_att_text(fileID, ncvarid, "units", len, units);
	  if ( (len = strlen(stdname)) )
	    cdf_put_att_text(fileID, ncvarid, "standard_name", len, stdname);

	  if ( gridInqXboundsPtr(gridID) )
	    {
	      strcat(axisname, "_bounds");
	      dimIDs[0] = dimID;
	      dimIDs[1] = nvdimID;
	      cdf_def_var(fileID, axisname, (nc_type) xtype, 2, dimIDs, &ncbvarid);
	      cdf_put_att_text(fileID, ncvarid, "bounds", strlen(axisname), axisname);
	    }

	  /*
	  if ( gridIsRotated(gridID) )
	    {
	      double north_pole = gridInqXpole(gridID);
	      cdf_put_att_double(fileID, ncvarid, "north_pole", NC_DOUBLE, 1L, &north_pole);
	    }
	  */
	}

      cdf_enddef(fileID);
      streamptr->ncmode = 2;

      if ( ncvarid  != UNDEFID ) cdf_put_var_double(fileID, ncvarid, gridInqXvalsPtr(gridID));
      if ( ncbvarid != UNDEFID ) cdf_put_var_double(fileID, ncbvarid, gridInqXboundsPtr(gridID));
    }

  streamptr->xdimID[gridindex] = dimID;

#endif
}

static
void cdfDefYaxis(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfDefYaxis";
  char units[256];
  char longname[256];
  char stdname[256];
  char axisname[256];
  int index;
  /*  int index2; */
  int gridID0, gridtype0, gridindex;
  int dimID = UNDEFID;
  int dimIDs[2];
  int ngrids;
  int fileID;
  int dimlen, dimlen0;
  size_t len;
  int ncvarid = UNDEFID, ncbvarid = UNDEFID;
  int nvdimID = -1;
  int vlistID;
  int xtype = NC_DOUBLE;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( gridInqPrec(gridID) == DATATYPE_FLT32 ) xtype = NC_FLOAT;

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  ngrids = vlistNgrids(vlistID);

  dimlen = gridInqYsize(gridID);
  gridindex = vlistGridIndex(vlistID, gridID);

  gridInqYname(gridID, axisname);
  gridInqYlongname(gridID, longname);
  gridInqYstdname(gridID, stdname);
  gridInqYunits(gridID, units);

  if ( axisname[0] == 0 ) Error(func, "axis name undefined!\n");

  for ( index = 0; index < ngrids; index++ )
    {
      if ( streamptr->ydimID[index] != UNDEFID )
	{
	  gridID0 = vlistGrid(vlistID, index);
	  gridtype0 = gridInqType(gridID0);
	  if ( gridtype0 == GRID_GAUSSIAN    ||
	       gridtype0 == GRID_LONLAT      ||
	       gridtype0 == GRID_CURVILINEAR ||
	       gridtype0 == GRID_GENERIC )
	    {
	      dimlen0 = gridInqYsize(gridID0);
	      if ( dimlen == dimlen0 )
		if ( IS_EQUAL(gridInqYval(gridID0, 0), gridInqYval(gridID, 0)) &&
		     IS_EQUAL(gridInqYval(gridID0, dimlen-1), gridInqYval(gridID, dimlen-1)) )
		  {
		    dimID = streamptr->ydimID[index];
		    break;
		  }
	      /*
	      for ( index2 = 0; index2 < index; index2++ )
		if ( streamptr->ydimID[index] == streamptr->ydimID[index2] )
		  break;
	      if ( index2 == index ) iz++;
	      */
	    }
	}
    }

  if ( dimID == UNDEFID )
    {
      int status;
      status = checkGridName('V', axisname, fileID, vlistID, gridID, ngrids, 'Y');
      if ( status == 0 )
	status = checkGridName('D', axisname, fileID, vlistID, gridID, ngrids, 'Y');

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_dim(fileID, axisname, dimlen, &dimID);

      if ( gridInqXboundsPtr(gridID) || gridInqYboundsPtr(gridID) )
	cdf_inq_dimid(fileID, "nv", &nvdimID);

      if ( gridInqYvalsPtr(gridID) )
	{
	  cdf_def_var(fileID, axisname, (nc_type) xtype, 1, &dimID, &ncvarid);
	  if ( (len = strlen(longname)) )
	    cdf_put_att_text(fileID, ncvarid, "long_name", len, longname);
	  if ( (len = strlen(units)) )
	    cdf_put_att_text(fileID, ncvarid, "units", len, units);
	  if ( (len = strlen(stdname)) )
	    cdf_put_att_text(fileID, ncvarid, "standard_name", len, stdname);

	  if ( gridInqYboundsPtr(gridID) )
	    {
	      strcat(axisname, "_bounds");
	      dimIDs[0] = dimID;
	      dimIDs[1] = nvdimID;
	      cdf_def_var(fileID, axisname, (nc_type) xtype, 2, dimIDs, &ncbvarid);
	      cdf_put_att_text(fileID, ncvarid, "bounds", strlen(axisname), axisname);
	    }
	  /*
	  if ( gridIsRotated(gridID) )
	    {
	      double north_pole = gridInqYpole(gridID);
	      cdf_put_att_double(fileID, ncvarid, "north_pole", NC_DOUBLE, 1L, &north_pole);
	    }
	  */
	}

      cdf_enddef(fileID);
      streamptr->ncmode = 2;

      if ( ncvarid  != UNDEFID ) cdf_put_var_double(fileID, ncvarid, gridInqYvalsPtr(gridID));
      if ( ncbvarid != UNDEFID ) cdf_put_var_double(fileID, ncbvarid, gridInqYboundsPtr(gridID));
    }

  streamptr->ydimID[gridindex] = dimID;

#endif
}

static
void cdfDefLonLat2D(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  char xunits[256];
  char xlongname[256];
  char xstdname[256];
  char yunits[256];
  char ylongname[256];
  char ystdname[256];
  char xaxisname[256];
  char yaxisname[256];
  char xdimname[4] = "x";
  char ydimname[4] = "y";
  int index;
  int gridID0, gridtype0, gridindex;
  int xdimID = UNDEFID;
  int ydimID = UNDEFID;
  int dimIDs[3];
  int ngrids;
  int fileID;
  int xdimlen, ydimlen, dimlen0;
  size_t len;
  int ncxvarid = UNDEFID, ncyvarid = UNDEFID;
  int ncbxvarid = UNDEFID, ncbyvarid = UNDEFID, ncavarid = UNDEFID;
  int nvertex = 4, nvdimID = -1;
  int vlistID;
  int xtype = NC_DOUBLE;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( gridInqPrec(gridID) == DATATYPE_FLT32 ) xtype = NC_FLOAT;

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  ngrids = vlistNgrids(vlistID);

  xdimlen = gridInqXsize(gridID);
  ydimlen = gridInqYsize(gridID);
  gridindex = vlistGridIndex(vlistID, gridID);

  gridInqXname(gridID, xaxisname);
  gridInqXlongname(gridID, xlongname);
  gridInqXstdname(gridID, xstdname);
  gridInqXunits(gridID, xunits);
  gridInqYname(gridID, yaxisname);
  gridInqYlongname(gridID, ylongname);
  gridInqYstdname(gridID, ystdname);
  gridInqYunits(gridID, yunits);

  for ( index = 0; index < ngrids; index++ )
    {
      if ( streamptr->xdimID[index] != UNDEFID )
	{
	  gridID0 = vlistGrid(vlistID, index);
	  gridtype0 = gridInqType(gridID0);
	  if ( gridtype0 == GRID_GAUSSIAN    ||
	       gridtype0 == GRID_LONLAT      ||
	       gridtype0 == GRID_CURVILINEAR ||
	       gridtype0 == GRID_GENERIC )
	    {
	      dimlen0 = gridInqXsize(gridID0);
	      if ( xdimlen == dimlen0 )
		if ( IS_EQUAL(gridInqXval(gridID0, 0), gridInqXval(gridID, 0)) &&
		     IS_EQUAL(gridInqXval(gridID0, xdimlen-1), gridInqXval(gridID, xdimlen-1)) )
		  {
		    xdimID = streamptr->xdimID[index];
		    break;
		  }
	      /*
	      for ( index2 = 0; index2 < index; index2++ )
		if ( streamptr->xdimID[index] == streamptr->xdimID[index2] )
		  break;
	      if ( index2 == index ) iz++;
	      */
	    }
	}
    }

  if ( xdimID == UNDEFID )
    {
      int status;
      status = checkGridName('V', xaxisname, fileID, vlistID, gridID, ngrids, 'X');
      status = checkGridName('V', yaxisname, fileID, vlistID, gridID, ngrids, 'Y');
      status = checkGridName('D', xdimname, fileID, vlistID, gridID, ngrids, 'X');
      status = checkGridName('D', ydimname, fileID, vlistID, gridID, ngrids, 'Y');

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_dim(fileID, xdimname, xdimlen, &xdimID);
      cdf_def_dim(fileID, ydimname, ydimlen, &ydimID);

      if ( gridInqXboundsPtr(gridID) || gridInqYboundsPtr(gridID) )
	{
	  int status;

	  status = nc_inq_dimid(fileID, "nv", &nvdimID);
	  if ( status != NC_NOERR )
	    cdf_def_dim(fileID, "nv", nvertex, &nvdimID);
	}

      dimIDs[0] = ydimID;
      dimIDs[1] = xdimID;

      if ( gridInqXvalsPtr(gridID) )
	{
	  cdf_def_var(fileID, xaxisname, (nc_type) xtype, 2, dimIDs, &ncxvarid);
	  if ( (len = strlen(xlongname)) )
	    cdf_put_att_text(fileID, ncxvarid, "long_name", len, xlongname);
	  if ( (len = strlen(xunits)) )
	    cdf_put_att_text(fileID, ncxvarid, "units", len, xunits);
	  if ( (len = strlen(xstdname)) )
	    cdf_put_att_text(fileID, ncxvarid, "standard_name", len, xstdname);

	  /* attribute for Panoply */
	  cdf_put_att_text(fileID, ncxvarid, "_CoordinateAxisType", 3, "Lon");

	  streamptr->ncxvarID[gridindex] = ncxvarid;

	  if ( gridInqXboundsPtr(gridID) )
	    {
	      strcat(xaxisname, "_bounds");
	      dimIDs[0] = ydimID;
	      dimIDs[1] = xdimID;
	      dimIDs[2] = nvdimID;
	      cdf_def_var(fileID, xaxisname, (nc_type) xtype, 3, dimIDs, &ncbxvarid);
	      cdf_put_att_text(fileID, ncxvarid, "bounds", strlen(xaxisname), xaxisname);
	    }
	}

      if ( gridInqYvalsPtr(gridID) )
	{
	  cdf_def_var(fileID, yaxisname, (nc_type) xtype, 2, dimIDs, &ncyvarid);
	  if ( (len = strlen(ylongname)) )
	    cdf_put_att_text(fileID, ncyvarid, "long_name", len, ylongname);
	  if ( (len = strlen(yunits)) )
	    cdf_put_att_text(fileID, ncyvarid, "units", len, yunits);
	  if ( (len = strlen(ystdname)) )
	    cdf_put_att_text(fileID, ncyvarid, "standard_name", len, ystdname);

	  /* attribute for Panoply */
	  cdf_put_att_text(fileID, ncyvarid, "_CoordinateAxisType", 3, "Lat");

	  streamptr->ncyvarID[gridindex] = ncyvarid;

	  if ( gridInqYboundsPtr(gridID) )
	    {
	      strcat(yaxisname, "_bounds");
	      dimIDs[0] = ydimID;
	      dimIDs[1] = xdimID;
	      dimIDs[2] = nvdimID;
	      cdf_def_var(fileID, yaxisname, (nc_type) xtype, 3, dimIDs, &ncbyvarid);
	      cdf_put_att_text(fileID, ncyvarid, "bounds", strlen(yaxisname), yaxisname);
	    }
	}

      if ( gridInqAreaPtr(gridID) )
	{
	  char yaxisname[] = "cell_area";
	  char units[] = "m2";
	  char longname[] = "area of grid cell";
	  char stdname[] = "area";

	  cdf_def_var(fileID, yaxisname, (nc_type) xtype, 2, dimIDs, &ncavarid);
	  cdf_put_att_text(fileID, ncavarid, "long_name", strlen(longname), longname);
	  cdf_put_att_text(fileID, ncavarid, "standard_name", strlen(stdname), stdname);
	  cdf_put_att_text(fileID, ncavarid, "units", strlen(units), units);

	  streamptr->ncavarID[gridindex] = ncavarid;
	}

      cdf_enddef(fileID);
      streamptr->ncmode = 2;

      if ( ncxvarid  != UNDEFID ) cdf_put_var_double(fileID, ncxvarid,  gridInqXvalsPtr(gridID));
      if ( ncbxvarid != UNDEFID ) cdf_put_var_double(fileID, ncbxvarid, gridInqXboundsPtr(gridID));
      if ( ncyvarid  != UNDEFID ) cdf_put_var_double(fileID, ncyvarid,  gridInqYvalsPtr(gridID));
      if ( ncbyvarid != UNDEFID ) cdf_put_var_double(fileID, ncbyvarid, gridInqYboundsPtr(gridID));
      if ( ncavarid  != UNDEFID ) cdf_put_var_double(fileID, ncavarid,  gridInqAreaPtr(gridID));
    }

  streamptr->xdimID[gridindex] = xdimID;
  streamptr->ydimID[gridindex] = ydimID;

#endif
}

static
void cdfDefRgrid(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfDefRgrid";
  char axisname[7] = "rgridX";
  int index, iz = 0;
  int gridID0, gridtype0, gridindex;
  int dimID = UNDEFID;
  int ngrids;
  int fileID;
  int dimlen, dimlen0;
  int vlistID;
  int lwarn = TRUE;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  ngrids = vlistNgrids(vlistID);

  dimlen = gridInqSize(gridID);

  for ( index = 0; index < ngrids; index++ )
    {
      if ( streamptr->xdimID[index] != UNDEFID )
	{
	  gridID0 = vlistGrid(vlistID, index);
	  gridtype0 = gridInqType(gridID0);
	  if ( gridtype0 == GRID_GAUSSIAN_REDUCED )
	    {
	      dimlen0 = gridInqSize(gridID0);

	      if ( dimlen == dimlen0 )
		{
		  dimID = streamptr->xdimID[index];
		  break;
		}
	      else
		iz++;	
	    }
	}
    }

  if ( dimID == UNDEFID )
    {
      if ( lwarn )
	{
	  Warning(func, "Creating a netCDF file with data on a gaussian reduced grid.");
	  Warning(func, "The further processing of the resulting file is unsupported!");
	  lwarn = FALSE;
	}

      if ( iz == 0 ) axisname[5] = '\0';
      else           sprintf(&axisname[5], "%1d", iz+1);

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_dim(fileID, axisname, dimlen, &dimID);

      cdf_enddef(fileID);
      streamptr->ncmode = 2;
    }

  gridindex = vlistGridIndex(vlistID, gridID);
  streamptr->xdimID[gridindex] = dimID;

#endif
}

static
void cdfDefGdim(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  char axisname[7] = "gsizeX";
  int index, iz = 0;
  int gridID0, gridtype0, gridindex;
  int dimID = UNDEFID;
  int ngrids;
  int fileID;
  int dimlen, dimlen0;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  ngrids = vlistNgrids(vlistID);

  dimlen = gridInqSize(gridID);

  if ( gridInqYsize(gridID) == 0 )
    for ( index = 0; index < ngrids; index++ )
      {
	if ( streamptr->xdimID[index] != UNDEFID )
	  {
	    gridID0 = vlistGrid(vlistID, index);
	    gridtype0 = gridInqType(gridID0);
	    if ( gridtype0 == GRID_GENERIC )
	      {
		dimlen0 = gridInqSize(gridID0);
		if ( dimlen == dimlen0 )
		  {
		    dimID = streamptr->xdimID[index];
		    break;
		  }
		else
		  iz++;	
	      }
	  }
      }

  if ( gridInqXsize(gridID) == 0 )
    for ( index = 0; index < ngrids; index++ )
      {
	if ( streamptr->ydimID[index] != UNDEFID )
	  {
	    gridID0 = vlistGrid(vlistID, index);
	    gridtype0 = gridInqType(gridID0);
	    if ( gridtype0 == GRID_GENERIC )
	      {
		dimlen0 = gridInqSize(gridID0);
		if ( dimlen == dimlen0 )
		  {
		    dimID = streamptr->ydimID[index];
		    break;
		  }
		else
		  iz++;	
	      }
	  }
      }

  if ( dimID == UNDEFID )
    {
      if ( iz == 0 ) axisname[5] = '\0';
      else           sprintf(&axisname[5], "%1d", iz+1);

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_dim(fileID, axisname, dimlen, &dimID);

      cdf_enddef(fileID);
      streamptr->ncmode = 2;
    }

  gridindex = vlistGridIndex(vlistID, gridID);
  streamptr->xdimID[gridindex] = dimID;

#endif
}

static
void cdfDefCell(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  char axisname[] = "cellX";
  char vertname[] = "nvX";
  char xunits[256];
  char xlongname[256];
  char xstdname[256];
  char yunits[256];
  char ylongname[256];
  char ystdname[256];
  char xaxisname[256];
  char yaxisname[256];
  int index, iz = 0;
  int gridID0, gridtype0, gridindex;
  int dimID = UNDEFID;
  int ngrids;
  int fileID;
  int dimlen, dimlen0;
  size_t len;
  int ncxvarid = UNDEFID, ncyvarid = UNDEFID;
  int ncbxvarid = UNDEFID, ncbyvarid = UNDEFID, ncavarid = UNDEFID;
  int nvertex, nvdimID = -1;
  int vlistID;
  int xtype = NC_DOUBLE;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( gridInqPrec(gridID) == DATATYPE_FLT32 ) xtype = NC_FLOAT;

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  ngrids = vlistNgrids(vlistID);

  dimlen = gridInqSize(gridID);
  gridindex = vlistGridIndex(vlistID, gridID);

  gridInqXname(gridID, xaxisname);
  gridInqXlongname(gridID, xlongname);
  gridInqXstdname(gridID, xstdname);
  gridInqXunits(gridID, xunits);
  gridInqYname(gridID, yaxisname);
  gridInqYlongname(gridID, ylongname);
  gridInqYstdname(gridID, ystdname);
  gridInqYunits(gridID, yunits);

  for ( index = 0; index < ngrids; index++ )
    {
      if ( streamptr->xdimID[index] != UNDEFID )
	{
	  gridID0 = vlistGrid(vlistID, index);
	  gridtype0 = gridInqType(gridID0);
	  if ( gridtype0 == GRID_CELL )
	    {
	      dimlen0 = gridInqSize(gridID0);
	      if ( dimlen == dimlen0 )
		{
		  dimID = streamptr->xdimID[index];
		  break;
		}
	      else
		iz++;	
	    }
	}
    }

  if ( dimID == UNDEFID )
    {
      if ( iz == 0 )
	{
	  axisname[4] = '\0';
	  vertname[2] = '\0';
	}
      else
	{
          sprintf(&axisname[4], "%1d", iz+1);
          sprintf(&vertname[2], "%1d", iz+1);
	}

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_dim(fileID, axisname, dimlen, &dimID);

      nvertex = gridInqNvertex(gridID);
      if ( nvertex > 0 ) cdf_def_dim(fileID, vertname, nvertex, &nvdimID);
	
      if ( gridInqXvalsPtr(gridID) )
	{
	  cdf_def_var(fileID, xaxisname, (nc_type) xtype, 1, &dimID, &ncxvarid);
	  if ( (len = strlen(xlongname)) )
	    cdf_put_att_text(fileID, ncxvarid, "long_name", len, xlongname);
	  if ( (len = strlen(xunits)) )
	    cdf_put_att_text(fileID, ncxvarid, "units", len, xunits);
	  if ( (len = strlen(xstdname)) )
	    cdf_put_att_text(fileID, ncxvarid, "standard_name", len, xstdname);

	  streamptr->ncxvarID[gridindex] = ncxvarid;

	  if ( nvdimID != UNDEFID && gridInqXboundsPtr(gridID) )
	    {
	      int dimIDs[2];
	      dimIDs[0] = dimID;
	      dimIDs[1] = nvdimID;
	      strcat(xaxisname, "_vertices");
	      cdf_def_var(fileID, xaxisname, (nc_type) xtype, 2, dimIDs, &ncbxvarid);
	      cdf_put_att_text(fileID, ncxvarid, "bounds", strlen(xaxisname), xaxisname);
	    }
	}

      if ( gridInqYvalsPtr(gridID) )
	{
	  cdf_def_var(fileID, yaxisname, (nc_type) xtype, 1, &dimID, &ncyvarid);
	  if ( (len = strlen(ylongname)) )
	    cdf_put_att_text(fileID, ncyvarid, "long_name", len, ylongname);
	  if ( (len = strlen(yunits)) )
	    cdf_put_att_text(fileID, ncyvarid, "units", len, yunits);
	  if ( (len = strlen(ystdname)) )
	    cdf_put_att_text(fileID, ncyvarid, "standard_name", len, ystdname);

	  streamptr->ncyvarID[gridindex] = ncyvarid;

	  if ( nvdimID != UNDEFID && gridInqYboundsPtr(gridID) )
	    {
	      int dimIDs[2];
	      dimIDs[0] = dimID;
	      dimIDs[1] = nvdimID;
	      strcat(yaxisname, "_vertices");
	      cdf_def_var(fileID, yaxisname, (nc_type) xtype, 2, dimIDs, &ncbyvarid);
	      cdf_put_att_text(fileID, ncyvarid, "bounds", strlen(yaxisname), yaxisname);
	    }
	}

      if ( gridInqAreaPtr(gridID) )
	{
	  char yaxisname[] = "cell_area";
	  char units[] = "m2";
	  char longname[] = "area of grid cell";
	  char stdname[] = "area";

	  cdf_def_var(fileID, yaxisname, (nc_type) xtype, 1, &dimID, &ncavarid);
	  cdf_put_att_text(fileID, ncavarid, "long_name", strlen(longname), longname);
	  cdf_put_att_text(fileID, ncavarid, "standard_name", strlen(stdname), stdname);
	  cdf_put_att_text(fileID, ncavarid, "units", strlen(units), units);

	  streamptr->ncavarID[gridindex] = ncavarid;
	}

      cdf_enddef(fileID);
      streamptr->ncmode = 2;

      if ( ncxvarid  != UNDEFID ) cdf_put_var_double(fileID, ncxvarid,  gridInqXvalsPtr(gridID));
      if ( ncbxvarid != UNDEFID ) cdf_put_var_double(fileID, ncbxvarid, gridInqXboundsPtr(gridID));
      if ( ncyvarid  != UNDEFID ) cdf_put_var_double(fileID, ncyvarid,  gridInqYvalsPtr(gridID));
      if ( ncbyvarid != UNDEFID ) cdf_put_var_double(fileID, ncbyvarid, gridInqYboundsPtr(gridID));
      if ( ncavarid  != UNDEFID ) cdf_put_var_double(fileID, ncavarid,  gridInqAreaPtr(gridID));
    }

  streamptr->xdimID[gridindex] = dimID;

#endif
}

static
void cdfDefVCT(int streamID, int zaxisID)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfDefVCT";
  int type;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  type = zaxisInqType(zaxisID);
  if ( type == ZAXIS_HYBRID || type == ZAXIS_HYBRID_HALF )
    {
      int i;
      int fileID;
      int ilev = zaxisInqVctSize(zaxisID)/2;
      int mlev = ilev - 1;
      size_t start;
      size_t count = 1;      
      int ncdimid, ncdimid2;
      int ncvarid, ncvarid2;
      int hyaiid, hybiid, hyamid, hybmid;
      int *ilevels = NULL;
      const double *vctptr = zaxisInqVctPtr(zaxisID);
      double mval;
      char tmpname[256];

      if ( streamptr->vct.ilev > 0 )
	{
	  if ( streamptr->vct.ilev != ilev )
	    Error(func, "more than one VCT for each file unsupported!");
	  return;
	}

      if ( ilev == 0 )
	{
	  Warning(func, "VCT missing");
	  return;
	}

      fileID = streamInqFileID(streamID);

      if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

      cdf_def_dim(fileID, "mlev", mlev, &ncdimid);
      cdf_def_dim(fileID, "ilev", ilev, &ncdimid2);

      streamptr->vct.mlev   = mlev;
      streamptr->vct.ilev   = ilev;
      streamptr->vct.mlevID = ncdimid;
      streamptr->vct.ilevID = ncdimid2;

      cdf_def_var(fileID, "mlev", NC_INT,    1, &ncdimid,  &ncvarid);
      cdf_def_var(fileID, "ilev", NC_INT,    1, &ncdimid2, &ncvarid2);
      cdf_def_var(fileID, "hyai", NC_DOUBLE, 1, &ncdimid2, &hyaiid);
      cdf_def_var(fileID, "hybi", NC_DOUBLE, 1, &ncdimid2, &hybiid);
      cdf_def_var(fileID, "hyam", NC_DOUBLE, 1, &ncdimid,  &hyamid);
      cdf_def_var(fileID, "hybm", NC_DOUBLE, 1, &ncdimid,  &hybmid);

      strcpy(tmpname, "hybrid level at layer midpoints");
      cdf_put_att_text(fileID, ncvarid, "long_name", strlen(tmpname), tmpname);
      strcpy(tmpname, "hybrid_sigma_pressure");
      cdf_put_att_text(fileID, ncvarid, "standard_name", strlen(tmpname), tmpname);
      strcpy(tmpname, "level");
      cdf_put_att_text(fileID, ncvarid, "units", strlen(tmpname), tmpname);
      strcpy(tmpname, "down");
      cdf_put_att_text(fileID, ncvarid, "positive", strlen(tmpname), tmpname);
      strcpy(tmpname, "hyam hybm (mlev=hyam+hybm*aps)");
      cdf_put_att_text(fileID, ncvarid, "formula", strlen(tmpname), tmpname);
      strcpy(tmpname, "ap: hyam b: hybm ps: aps");
      cdf_put_att_text(fileID, ncvarid, "formula_terms", strlen(tmpname), tmpname);
      strcpy(tmpname, "ilev");
      cdf_put_att_text(fileID, ncvarid, "borders", strlen(tmpname), tmpname);

      strcpy(tmpname, "hybrid level at layer interfaces");
      cdf_put_att_text(fileID, ncvarid2, "long_name", strlen(tmpname), tmpname);
      strcpy(tmpname, "hybrid_sigma_pressure");
      cdf_put_att_text(fileID, ncvarid2, "standard_name", strlen(tmpname), tmpname);
      strcpy(tmpname, "level");
      cdf_put_att_text(fileID, ncvarid2, "units", strlen(tmpname), tmpname);
      strcpy(tmpname, "down");
      cdf_put_att_text(fileID, ncvarid2, "positive", strlen(tmpname), tmpname);
      strcpy(tmpname, "hyai hybi (ilev=hyai+hybi*aps)");
      cdf_put_att_text(fileID, ncvarid2, "formula", strlen(tmpname), tmpname);
      strcpy(tmpname, "ap: hyai b: hybi ps: aps");
      cdf_put_att_text(fileID, ncvarid2, "formula_terms", strlen(tmpname), tmpname);

      strcpy(tmpname, "hybrid A coefficient at layer interfaces");
      cdf_put_att_text(fileID, hyaiid, "long_name", strlen(tmpname), tmpname);
      strcpy(tmpname, "Pa");
      cdf_put_att_text(fileID, hyaiid, "units", strlen(tmpname), tmpname);
      strcpy(tmpname, "hybrid B coefficient at layer interfaces");
      cdf_put_att_text(fileID, hybiid, "long_name", strlen(tmpname), tmpname);
      strcpy(tmpname, "1");
      cdf_put_att_text(fileID, hybiid, "units", strlen(tmpname), tmpname);
      strcpy(tmpname, "hybrid A coefficient at layer midpoints");
      cdf_put_att_text(fileID, hyamid, "long_name", strlen(tmpname), tmpname);
      strcpy(tmpname, "Pa");
      cdf_put_att_text(fileID, hyamid, "units", strlen(tmpname), tmpname);
      strcpy(tmpname, "hybrid B coefficient at layer midpoints");
      cdf_put_att_text(fileID, hybmid, "long_name", strlen(tmpname), tmpname);
      strcpy(tmpname, "1");
      cdf_put_att_text(fileID, hybmid, "units", strlen(tmpname), tmpname);

      cdf_enddef(fileID);
      streamptr->ncmode = 2;

      ilevels = (int *) malloc(ilev*sizeof(int));

      for ( i = 0; i < ilev; i++ ) ilevels[i] = i+1;
      cdf_put_var_int(fileID, ncvarid,  ilevels);
      cdf_put_var_int(fileID, ncvarid2, ilevels);

      free(ilevels);

      cdf_put_var_double(fileID, hyaiid, vctptr);
      cdf_put_var_double(fileID, hybiid, vctptr+ilev);

      for ( i = 0; i < mlev; i++ )
	{
	  start = i;
	  mval = (vctptr[i] + vctptr[i+1]) * 0.5;
	  cdf_put_vara_double(fileID, hyamid, &start, &count, &mval);
	  mval = (vctptr[ilev+i] + vctptr[ilev+i+1]) * 0.5;
	  cdf_put_vara_double(fileID, hybmid, &start, &count, &mval);	  
	}
    }

#endif
}

static
void cdfDefZaxis(int streamID, int zaxisID)
{
#if  defined  (HAVE_LIBNETCDF)
  /*  char zaxisname0[256]; */
  char axisname[256];
  char longname[256];
  char units[256];
  char tmpname[256];
  int index;
  int zaxisID0;
  int dimID = UNDEFID;
  int fileID;
  int dimlen;
  size_t len;
  int ncvarid;
  int type;
  int nzaxis;
  int ilevel = 0;
  int vlistID;
  int zaxisindex;
  int xtype = NC_DOUBLE;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( zaxisInqPrec(zaxisID) == DATATYPE_FLT32 ) xtype = NC_FLOAT;

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  zaxisindex = vlistZaxisIndex(vlistID, zaxisID);

  nzaxis = vlistNzaxis(vlistID);

  dimlen = zaxisInqSize(zaxisID);
  type   = zaxisInqType(zaxisID);

  if ( dimlen == 1 && type == ZAXIS_SURFACE ) return;
  if ( dimlen == 1 && type == ZAXIS_MEANSEA ) return;

  zaxisInqName(zaxisID, axisname);
  /*
  for ( index = 0; index < nzaxis; index++ )
    {
      if ( streamptr->zaxisID[index] != UNDEFID )
	{
	  zaxisID0 = vlistZaxis(vlistID, index);
	  zaxisInqName(zaxisID0, zaxisname0);
	  if ( strcmp(zaxisname0, axisname) == 0 ) ilevel++;
	}
    }
  */
  if ( dimID == UNDEFID )
    {
      char axisname0[256];
      char axisname2[256];
      int checkname = FALSE;
      int status;

      /* check that the name is not already defined */
      checkname = TRUE;
      ilevel = 0;

      while ( checkname ) 
	{
	  strcpy(axisname2, axisname);
	  if ( ilevel ) sprintf(&axisname2[strlen(axisname2)], "_%d", ilevel+1);

	  status = nc_inq_varid(fileID, axisname2, &ncvarid);
	  if ( status != NC_NOERR )
	    {
	      if ( ilevel )
		{
		  /* check that the name does not exist for other grids */
		  for ( index = 0; index < nzaxis; index++ )
		    {
		      zaxisID0 = vlistZaxis(vlistID, index);
		      if ( zaxisID != zaxisID0 )
			{
			  zaxisInqName(zaxisID0, axisname0);
			  if ( strcmp(axisname0, axisname2) == 0 ) break;
			}
		    }
		  if ( index == nzaxis ) checkname = FALSE;
		}
	      else
		{
		  checkname = FALSE;
		}
	    }

	  if ( checkname ) ilevel++;

	  if ( ilevel > 99 ) break;
	}

      if ( ilevel ) sprintf(&axisname[strlen(axisname)], "_%1d", ilevel+1);

      if ( type == ZAXIS_HYBRID || type == ZAXIS_HYBRID_HALF )
	{
	  int ilev = zaxisInqVctSize(zaxisID)/2;
	  int mlev = ilev - 1;

	  if ( type == ZAXIS_HYBRID )
	    {
	      if (  mlev != dimlen )
		{
		  if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

		  cdf_def_dim(fileID, axisname, dimlen, &dimID);
		  cdf_def_var(fileID, axisname, NC_INT, 1, &dimID,  &ncvarid);

		  strcpy(tmpname, "hybrid level at layer midpoints");
		  cdf_put_att_text(fileID, ncvarid, "long_name", strlen(tmpname), tmpname);
		  strcpy(tmpname, "hybrid_sigma_pressure");
		  cdf_put_att_text(fileID, ncvarid, "standard_name", strlen(tmpname), tmpname);
		  strcpy(tmpname, "level");
		  cdf_put_att_text(fileID, ncvarid, "units", strlen(tmpname), tmpname);
		  strcpy(tmpname, "down");
		  cdf_put_att_text(fileID, ncvarid, "positive", strlen(tmpname), tmpname);
		  strcpy(tmpname, "hyam hybm (mlev=hyam+hybm*aps)");
		  cdf_put_att_text(fileID, ncvarid, "formula", strlen(tmpname), tmpname);
		  strcpy(tmpname, "ap: hyam b: hybm ps: aps");
		  cdf_put_att_text(fileID, ncvarid, "formula_terms", strlen(tmpname), tmpname);
		  strcpy(tmpname, "ilev");
		  cdf_put_att_text(fileID, ncvarid, "borders", strlen(tmpname), tmpname);
  
		  cdf_enddef(fileID);
		  streamptr->ncmode = 2;

		  cdf_put_var_double(fileID, ncvarid, zaxisInqLevelsPtr(zaxisID));
		}
	    }

	  if ( type == ZAXIS_HYBRID_HALF )
	    {
	      if ( ilev != dimlen )
		{
		  if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

		  cdf_def_dim(fileID, axisname, dimlen, &dimID);
		  cdf_def_var(fileID, axisname, NC_INT, 1, &dimID,  &ncvarid);

		  strcpy(tmpname, "hybrid level at layer interfaces");
		  cdf_put_att_text(fileID, ncvarid, "long_name", strlen(tmpname), tmpname);
		  strcpy(tmpname, "hybrid_sigma_pressure");
		  cdf_put_att_text(fileID, ncvarid, "standard_name", strlen(tmpname), tmpname);
		  strcpy(tmpname, "level");
		  cdf_put_att_text(fileID, ncvarid, "units", strlen(tmpname), tmpname);
		  strcpy(tmpname, "down");
		  cdf_put_att_text(fileID, ncvarid, "positive", strlen(tmpname), tmpname);
		  strcpy(tmpname, "hyai hybi (ilev=hyai+hybi*aps)");
		  cdf_put_att_text(fileID, ncvarid, "formula", strlen(tmpname), tmpname);
		  strcpy(tmpname, "ap: hyai b: hybi ps: aps");
		  cdf_put_att_text(fileID, ncvarid, "formula_terms", strlen(tmpname), tmpname);
	      
		  cdf_enddef(fileID);
		  streamptr->ncmode = 2;

		  cdf_put_var_double(fileID, ncvarid, zaxisInqLevelsPtr(zaxisID));
		}
	    }

	  cdfDefVCT(streamID, zaxisID);

	  if ( dimID == UNDEFID )
	    {
	      if ( type == ZAXIS_HYBRID )
		streamptr->zaxisID[zaxisindex] = streamptr->vct.mlevID;
	      else
		streamptr->zaxisID[zaxisindex] = streamptr->vct.ilevID;
	    }
	}
      else
	{
	  if ( streamptr->ncmode == 2 ) cdf_redef(fileID);

	  cdf_def_dim(fileID, axisname, dimlen, &dimID);

	  zaxisInqLongname(zaxisID, longname);
	  zaxisInqUnits(zaxisID, units);

	  cdf_def_var(fileID, axisname, (nc_type) xtype, 1, &dimID, &ncvarid);
	  if ( (len = strlen(longname)) )
	    cdf_put_att_text(fileID, ncvarid, "long_name", len, longname);
	  if ( (len = strlen(units)) )
	    cdf_put_att_text(fileID, ncvarid, "units", len, units);

	  cdf_put_att_text(fileID, ncvarid, "axis", 1, "z");
	      
	  cdf_enddef(fileID);
	  streamptr->ncmode = 2;

	  cdf_put_var_double(fileID, ncvarid, zaxisInqLevelsPtr(zaxisID));
	}
    }

  if ( dimID != UNDEFID )
    streamptr->zaxisID[zaxisindex] = dimID;

#endif
}

static
void cdfDefPole(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  int fileID;
  int ncvarid = UNDEFID;
  int ncerr;
  double xpole, ypole, angle;
  char varname[] = "rotated_pole";
  char mapname[] = "rotated_latitude_longitude";

  fileID  = streamInqFileID(streamID);

  ypole = gridInqYpole(gridID);
  xpole = gridInqXpole(gridID);
  angle = gridInqAngle(gridID);

  cdf_redef(fileID);

  ncerr = nc_def_var(fileID, varname, (nc_type) NC_CHAR, 0, NULL, &ncvarid);
  if ( ncerr == NC_NOERR )
    {
      cdf_put_att_text(fileID, ncvarid, "grid_mapping_name", strlen(mapname), mapname);
      cdf_put_att_double(fileID, ncvarid, "grid_north_pole_latitude", NC_DOUBLE, 1L, &ypole);
      cdf_put_att_double(fileID, ncvarid, "grid_north_pole_longitude", NC_DOUBLE, 1L, &xpole);
      if ( angle > 0 )
	cdf_put_att_double(fileID, ncvarid, "north_pole_grid_longitude", NC_DOUBLE, 1L, &angle);
    }

  cdf_enddef(fileID);
#endif
}

static
void cdfDefMapping(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  int fileID;
  int ncvarid = UNDEFID;
  int ncerr;

  if ( gridInqType(gridID) == GRID_SINUSOIDAL )
    {
      char varname[] = "sinusoidal";
      char mapname[] = "sinusoidal";

      fileID  = streamInqFileID(streamID);

      cdf_redef(fileID);

      ncerr = nc_def_var(fileID, varname, (nc_type) NC_CHAR, 0, NULL, &ncvarid);
      if ( ncerr == NC_NOERR )
	{
	  cdf_put_att_text(fileID, ncvarid, "grid_mapping_name", strlen(mapname), mapname);
	  /*
	  cdf_put_att_double(fileID, ncvarid, "grid_north_pole_latitude", NC_DOUBLE, 1L, &ypole);
	  cdf_put_att_double(fileID, ncvarid, "grid_north_pole_longitude", NC_DOUBLE, 1L, &xpole);
	  */
	}

      cdf_enddef(fileID);
    }
  else if ( gridInqType(gridID) == GRID_LAEA )
    {
      char varname[] = "laea";
      char mapname[] = "lambert_azimuthal_equal_area";

      fileID  = streamInqFileID(streamID);

      cdf_redef(fileID);

      ncerr = nc_def_var(fileID, varname, (nc_type) NC_CHAR, 0, NULL, &ncvarid);
      if ( ncerr == NC_NOERR )
	{
	  double a, lon_0, lat_0;

	  gridInqLaea(gridID, &a, &lon_0, &lat_0);

	  cdf_put_att_text(fileID, ncvarid, "grid_mapping_name", strlen(mapname), mapname);
	  cdf_put_att_double(fileID, ncvarid, "earth_radius", NC_DOUBLE, 1L, &a);
	  cdf_put_att_double(fileID, ncvarid, "longitude_of_projection_origin", NC_DOUBLE, 1L, &lon_0);
	  cdf_put_att_double(fileID, ncvarid, "latitude_of_projection_origin", NC_DOUBLE, 1L, &lat_0);
	}

      cdf_enddef(fileID);
    }
  else if ( gridInqType(gridID) == GRID_LCC2 )
    {
      char varname[] = "Lambert_Conformal";
      char mapname[] = "lambert_conformal_conic";

      fileID  = streamInqFileID(streamID);

      cdf_redef(fileID);

      ncerr = nc_def_var(fileID, varname, (nc_type) NC_CHAR, 0, NULL, &ncvarid);
      if ( ncerr == NC_NOERR )
	{
	  double a, lon_0, lat_0, lat_1, lat_2;

	  gridInqLcc2(gridID, &a, &lon_0, &lat_0, &lat_1, &lat_2);

	  cdf_put_att_text(fileID, ncvarid, "grid_mapping_name", strlen(mapname), mapname);
	  if ( a > 0 )
	    cdf_put_att_double(fileID, ncvarid, "earth_radius", NC_DOUBLE, 1L, &a);
	  cdf_put_att_double(fileID, ncvarid, "longitude_of_central_meridian", NC_DOUBLE, 1L, &lon_0);
	  cdf_put_att_double(fileID, ncvarid, "latitude_of_projection_origin", NC_DOUBLE, 1L, &lat_0);
	  if ( IS_EQUAL(lat_1, lat_2) )
	    cdf_put_att_double(fileID, ncvarid, "standard_parallel", NC_DOUBLE, 1L, &lat_1);
	  else
	    {
	      double lat_1_2[2];
	      lat_1_2[0] = lat_1;
	      lat_1_2[1] = lat_2;
	      cdf_put_att_double(fileID, ncvarid, "standard_parallel", NC_DOUBLE, 2L, lat_1_2);
	    }
	}

      cdf_enddef(fileID);
    }
#endif
}

static
void cdfDefGrid(int streamID, int gridID)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfDefGrid";
  int gridtype, size;
  int gridindex;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID = streamInqVlist(streamID);
  gridindex = vlistGridIndex(vlistID, gridID);
  if ( streamptr->xdimID[gridindex] != UNDEFID ) return;

  gridtype = gridInqType(gridID);
  size     = gridInqSize(gridID);

  if ( CDI_Debug )
    Message(func, "gridtype = %d  size = %d", gridtype, size);

  if ( gridtype == GRID_GAUSSIAN ||
       gridtype == GRID_LONLAT   ||
       gridtype == GRID_GENERIC )
    {
      if ( gridtype == GRID_GENERIC && size == 1 && 
	   gridInqXsize(gridID) == 0 && gridInqYsize(gridID) == 0 )
	{
	  /* no grid information */
	}
      else if ( gridtype == GRID_GENERIC && (gridInqXsize(gridID) == 0 || gridInqYsize(gridID) == 0) )
	{
	  cdfDefGdim(streamID, gridID);
	}
      else
	{
	  if ( gridInqXsize(gridID) > 0 ) cdfDefXaxis(streamID, gridID);
	  if ( gridInqYsize(gridID) > 0 ) cdfDefYaxis(streamID, gridID);
	}

      if ( gridIsRotated(gridID) ) cdfDefPole(streamID, gridID);
    }
  else if ( gridtype == GRID_CURVILINEAR )
    {   
      cdfDefLonLat2D(streamID, gridID);
    }
  else if ( gridtype == GRID_GAUSSIAN_REDUCED )
    {
      cdfDefRgrid(streamID, gridID);
    }
  else if ( gridtype == GRID_SPECTRAL )
    {
      cdfDefComplex(streamID, gridID);
      cdfDefSpc(streamID, gridID);
    }
  else if ( gridtype == GRID_TRAJECTORY )
    {
      cdfDefTrajLon(streamID, gridID);
      cdfDefTrajLat(streamID, gridID);
    }
  else if ( gridtype == GRID_CELL )
    {
      cdfDefCell(streamID, gridID);
    }
  else if ( gridtype == GRID_SINUSOIDAL || gridtype == GRID_LAEA || gridtype == GRID_LCC2 )
    {
      cdfDefXaxis(streamID, gridID);
      cdfDefYaxis(streamID, gridID);

      cdfDefMapping(streamID, gridID);
    }
  /*
  else if ( gridtype == GRID_LCC )
    {
      cdfDefLcc(streamID, gridID);
    }
  */
  else
    {
      Error(func, "Unsupported grid type: %s", gridNamePtr(gridtype));
    }
#endif
}

static
int cdfDefVar(int streamID, int varID)
{
  static char func[] = "cdfDefVar";
  int ncvarid = -1;
#if  defined  (HAVE_LIBNETCDF)
  int fileID;
  int xid = UNDEFID, yid = UNDEFID, zid = UNDEFID, tid = UNDEFID;
  size_t xsize = 0, ysize = 0;
  int code, gridID, zaxisID;
  char varname[256];
  char *name = NULL;
  char *longname = NULL;
  char *stdname = NULL;
  char *units = NULL;
  int dims[4];
  int lchunk = FALSE;
  size_t chunks[4] = {0,0,0,0};
  int tableID;
  int ndims = 0;
  int len;
  int timeID;
  int xtype;
  int gridtype, gridsize;
  int gridindex, zaxisindex;
  int tablenum;
  int vlistID;
  int iax = 0;
  char axis[5];
  stream_t *streamptr;
  int retval;

  streamptr = stream_to_pointer(streamID);

  fileID  = streamInqFileID(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d, fileID = %d, varID = %d", streamID, fileID, varID);

  if ( streamptr->vars[varID].ncvarid != UNDEFID )
    return (streamptr->vars[varID].ncvarid);

  vlistID = streamInqVlist(streamID);
  gridID  = vlistInqVarGrid(vlistID, varID);
  zaxisID = vlistInqVarZaxis(vlistID, varID);
  timeID  = vlistInqVarTime(vlistID, varID);
  code    = vlistInqVarCode(vlistID, varID);

  gridsize  = gridInqSize(gridID);
  if ( gridsize > 1 ) lchunk = TRUE;
  gridtype  = gridInqType(gridID);
  gridindex = vlistGridIndex(vlistID, gridID);
  if ( gridtype != GRID_TRAJECTORY )
    {
      xid = streamptr->xdimID[gridindex];
      yid = streamptr->ydimID[gridindex];
      if ( xid != UNDEFID ) cdf_inq_dimlen(fileID, xid, &xsize);
      if ( yid != UNDEFID ) cdf_inq_dimlen(fileID, yid, &ysize);
    }

  zaxisindex = vlistZaxisIndex(vlistID, zaxisID);
  zid = streamptr->zaxisID[zaxisindex];

  tid = streamptr->basetime.ncdimid;

  if ( timeID == TIME_VARIABLE )
    {
      if ( tid == UNDEFID ) Error(func, "Internal problem! Time undefined.");
      chunks[ndims] = 1;
      dims[ndims++] = tid;
      axis[iax++] = 't';
    }

  if ( zid != UNDEFID ) axis[iax++] = 'z';
  if ( zid != UNDEFID ) chunks[ndims] = 1;
  if ( zid != UNDEFID ) dims[ndims++] = zid;

  if ( yid != UNDEFID ) chunks[ndims] = ysize;
  if ( yid != UNDEFID ) dims[ndims++] = yid;

  if ( xid != UNDEFID ) chunks[ndims] = xsize;
  if ( xid != UNDEFID ) dims[ndims++] = xid;

  if ( CDI_Debug ) 
    fprintf(stderr, "chunks %d %d %d %d\n", 
	    (int)chunks[0], (int)chunks[1], (int)chunks[2], (int)chunks[3]);

  tableID  = vlistInqVarTable(vlistID, varID);

  name     = vlistInqVarNamePtr(vlistID, varID);
  longname = vlistInqVarLongnamePtr(vlistID, varID);
  stdname  = vlistInqVarStdnamePtr(vlistID, varID);
  units    = vlistInqVarUnitsPtr(vlistID, varID);

  if ( name     == NULL )     name = tableInqParNamePtr(tableID, code);
  if ( longname == NULL ) longname = tableInqParLongnamePtr(tableID, code);
  if ( units    == NULL )    units = tableInqParUnitsPtr(tableID, code);
  if ( name )
    {
      int checkname;
      int iz;
      int status;

      sprintf(varname, "%s", name);

      checkname = TRUE;
      iz = 0;

      while ( checkname ) 
	{
	  if ( iz ) sprintf(varname, "%s_%d", name, iz+1);

	  status = nc_inq_varid(fileID, varname, &ncvarid);
	  if ( status != NC_NOERR )
	    {
	      checkname = FALSE;
	    }

	  if ( checkname ) iz++;

	  if ( iz > 99 )
	    Error(func, "Double entry of variable name '%s'!", name);
	}

      if ( strcmp(name, varname) != 0 )
	{
	  if ( iz == 1 )
	    Warning(func, "Changed double entry of variable name '%s' to '%s'!", name, varname);
	  else
	    Warning(func, "Changed multiple entry of variable name '%s' to '%s'!", name, varname);
	}

      name = varname;
    }
  else
    {
      int checkname;
      int iz;
      int status;

      if ( code < 0 ) code = -code;

      sprintf(varname, "var%d", code);

      checkname = TRUE;
      iz = 0;

      while ( checkname ) 
	{
	  if ( iz ) sprintf(varname, "var%d_%d", code, iz+1);

	  status = nc_inq_varid(fileID, varname, &ncvarid);
	  if ( status != NC_NOERR )
	    {
	      checkname = FALSE;
	    }

	  if ( checkname ) iz++;

	  if ( iz > 99 ) break;
	}

      name = varname;
      code = 0;
    }

  /* if ( streamptr->ncmode == 2 ) cdf_redef(fileID); */

  xtype = cdfDefDatatype(vlistInqVarDatatype(vlistID, varID));

  cdf_def_var(fileID, name, (nc_type) xtype, ndims, dims, &ncvarid);

#if  defined  (NC_NETCDF4)
  if ( lchunk && streamptr->filetype == FILETYPE_NC4 )
    {
      if ( (retval = nc_def_var_chunking(fileID, ncvarid, 0, chunks)) )
	Error(func, "nc_def_var_chunking failed, status = %d", retval);
    }
#endif

  if ( streamptr->ztype == COMPRESS_ZIP )
    {
      if ( lchunk && streamptr->filetype == FILETYPE_NC4 )
	{
	  cdfDefVarDeflate(fileID, ncvarid, streamptr->zlevel);
	}
      else
	{
	  static int lwarn = TRUE;

	  if ( lwarn )
	    {
	      lwarn = FALSE;
	      Warning(func, "Deflate compression is only available for netCDF4!");
	    }
	}
    }

  if ( streamptr->ztype == COMPRESS_SZIP )
    {
      if ( lchunk && streamptr->filetype == FILETYPE_NC4 )
	{
#if defined (NC_SZIP_NN_OPTION_MASK)
	  cdfDefVarSzip(fileID, ncvarid);
#else
	  static int lwarn = TRUE;

	  if ( lwarn )
	    {
	      lwarn = FALSE;
	      Warning(func, "netCDF4/SZIP compression not available!");
	    }
#endif
	}
      else
	{
	  static int lwarn = TRUE;

	  if ( lwarn )
	    {
	      lwarn = FALSE;
	      Warning(func, "SZIP compression is only available for netCDF4!");
	    }
	}
    }

  if ( longname && *longname )
    cdf_put_att_text(fileID, ncvarid, "long_name", strlen(longname), longname);

  if ( stdname && *stdname )
    cdf_put_att_text(fileID, ncvarid, "standard_name", strlen(stdname), stdname);

  if ( units && *units )
    cdf_put_att_text(fileID, ncvarid, "units", strlen(units), units);

  if ( code > 0 )
    cdf_put_att_int(fileID, ncvarid, "code", NC_INT, 1L, &code);

  if ( tableID != UNDEFID )
    {
      tablenum = tableInqNum(tableID);
      if ( tablenum > 0 )
	cdf_put_att_int(fileID, ncvarid, "table", NC_INT, 1L, &tablenum);
    }

  if ( gridtype != GRID_GENERIC && gridtype != GRID_LONLAT  && 
       gridtype != GRID_CURVILINEAR )
    {
      len = strlen(gridNamePtr(gridtype));
      if ( len > 0 )
	cdf_put_att_text(fileID, ncvarid, "grid_type", len, gridNamePtr(gridtype));
    }

  if ( gridIsRotated(gridID) )
    {
      char mapping[] = "rotated_pole";
      cdf_put_att_text(fileID, ncvarid, "grid_mapping", strlen(mapping), mapping);
    }

  if ( gridtype == GRID_SINUSOIDAL )
    {
      char mapping[] = "sinusoidal";
      cdf_put_att_text(fileID, ncvarid, "grid_mapping", strlen(mapping), mapping);
    }
  else if ( gridtype == GRID_LAEA )
    {
      char mapping[] = "laea";
      cdf_put_att_text(fileID, ncvarid, "grid_mapping", strlen(mapping), mapping);
    }
  else if ( gridtype == GRID_LCC2 )
    {
      char mapping[] = "Lambert_Conformal";
      cdf_put_att_text(fileID, ncvarid, "grid_mapping", strlen(mapping), mapping);
    }
  else if ( gridtype == GRID_TRAJECTORY )
    {
      cdf_put_att_text(fileID, ncvarid, "coordinates", 9, "tlon tlat" );
    }
  else if ( gridtype == GRID_CELL || gridtype == GRID_CURVILINEAR )
    {
      char coordinates[256] = "";
      char cellarea[256] = "area: ";
      int ncxvarID, ncyvarID, ncavarID;
      int gridindex;
      size_t len;

      gridindex = vlistGridIndex(vlistID, gridID);
      ncxvarID = streamptr->ncxvarID[gridindex];
      ncyvarID = streamptr->ncyvarID[gridindex];
      ncavarID = streamptr->ncavarID[gridindex];
      if ( ncxvarID != CDI_UNDEFID )
	cdf_inq_varname(fileID, ncxvarID, coordinates);
      len = strlen(coordinates);
      if ( ncyvarID != CDI_UNDEFID )
	{
	  if ( len ) coordinates[len++] = ' ';
	  cdf_inq_varname(fileID, ncyvarID, coordinates+len);
	}
      len = strlen(coordinates);
      if ( len )
	cdf_put_att_text(fileID, ncvarid, "coordinates", len, coordinates);

      if ( ncavarID != CDI_UNDEFID )
	{
	  len = strlen(cellarea);
	  cdf_inq_varname(fileID, ncavarID, cellarea+len);
	  len = strlen(cellarea);
	  cdf_put_att_text(fileID, ncvarid, "cell_measures", len, cellarea);
	}
    }
  else if ( gridtype == GRID_SPECTRAL )
    {
      int gridTruncation = gridInqTrunc(gridID);

      axis[iax++] = '-';
      axis[iax++] = '-';
      cdf_put_att_text(fileID, ncvarid, "axis", iax, axis);
      cdf_put_att_int(fileID, ncvarid, "truncation", NC_INT, 1L, &gridTruncation);
    }

  /*  if ( xtype == NC_BYTE || xtype == NC_SHORT || xtype == NC_INT ) */
    {
      int laddoffset, lscalefactor;
      double addoffset, scalefactor;
      int astype = NC_DOUBLE;

      addoffset    = vlistInqVarAddoffset(vlistID, varID);
      scalefactor  = vlistInqVarScalefactor(vlistID, varID);
      laddoffset   = IS_NOT_EQUAL(addoffset, 0);
      lscalefactor = IS_NOT_EQUAL(scalefactor, 1);

      if ( laddoffset || lscalefactor )
	{
	  if ( IS_EQUAL(addoffset,   (double) ((float) addoffset)) &&
	       IS_EQUAL(scalefactor, (double) ((float) scalefactor)) )
	    {
	      astype = NC_FLOAT;
	    }

	  if ( xtype == (int) NC_FLOAT ) astype = NC_FLOAT;

	  cdf_put_att_double(fileID, ncvarid, "add_offset",   (nc_type) astype, 1L, &addoffset);
	  cdf_put_att_double(fileID, ncvarid, "scale_factor", (nc_type) astype, 1L, &scalefactor);
	}
    }

  streamptr->vars[varID].ncvarid = ncvarid;

  if ( vlistInqVarMissvalUsed(vlistID, varID) )
    cdfDefVarMissval(streamID, varID, vlistInqVarDatatype(vlistID, varID), 0);

  /* Attributes */
  defineAttributes(vlistID, varID, fileID, ncvarid);

  /* if ( streamptr->ncmode == 2 ) cdf_enddef(fileID); */

#endif
  return (ncvarid);
}


void cdfReadVarDP(int streamID, int varID, double *data, int *nmiss)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfReadVarDP";
  int fileID;
  int gridID;
  int zaxisID;
  int xid = UNDEFID, yid = UNDEFID, zid = UNDEFID;
  int ncvarid;
  int tsID;
  size_t size;
  size_t start[4];
  size_t count[4];
  int ndims = 0;
  int idim;
  int timeID;
  int gridindex, zaxisindex;
  int vlistID;
  int i;
  double missval;
  int laddoffset, lscalefactor;
  double addoffset, scalefactor;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d  varID = %d", streamID, varID);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  tsID = streamptr->curTsID;

  if ( CDI_Debug ) Message(func, "tsID = %d", tsID);

  ncvarid = streamptr->vars[varID].ncvarid;

  gridID  = vlistInqVarGrid(vlistID, varID);
  zaxisID = vlistInqVarZaxis(vlistID, varID);
  timeID  = vlistInqVarTime(vlistID, varID);

  gridindex = vlistGridIndex(vlistID, gridID);
  if ( gridInqType(gridID) == GRID_TRAJECTORY )
    {
      cdfReadGridTraj(streamID, gridID);
    }
  else
    {
      xid = streamptr->xdimID[gridindex];
      yid = streamptr->ydimID[gridindex];
    }

  zaxisindex = vlistZaxisIndex(vlistID, zaxisID);
  zid = streamptr->zaxisID[zaxisindex];

  if ( timeID == TIME_VARIABLE )
    {
      start[ndims] = tsID;
      count[ndims] = 1;
      ndims++;
    }
  if ( zid != UNDEFID )
    {
      start[ndims] = 0;
      count[ndims] = zaxisInqSize(zaxisID);
      ndims++;
    }
  if ( yid != UNDEFID )
    {
      start[ndims] = 0;
      count[ndims] = gridInqYsize(gridID);
      ndims++;
    }
  if ( xid != UNDEFID )
    {
      start[ndims] = 0;
      count[ndims] = gridInqXsize(gridID);
      ndims++;
    }

  if ( CDI_Debug )
    for (idim = 0; idim < ndims; idim++)
      Message(func, "dim = %d  start = %d  count = %d", idim, start[idim], count[idim]);

  cdf_get_vara_double(fileID, ncvarid, start, count, data);

  *nmiss = 0;
  if ( vlistInqVarMissvalUsed(vlistID, varID) == TRUE  )
    {
      size    = gridInqSize(gridID)*zaxisInqSize(zaxisID);
      missval = vlistInqVarMissval(vlistID, varID);

      for ( i = 0; i < (int) size; i++ )
	if ( DBL_IS_EQUAL(data[i], missval) ) *nmiss += 1;
    }

  addoffset    = vlistInqVarAddoffset(vlistID, varID);
  scalefactor  = vlistInqVarScalefactor(vlistID, varID);
  laddoffset   = IS_NOT_EQUAL(addoffset, 0);
  lscalefactor = IS_NOT_EQUAL(scalefactor, 1);

  if ( laddoffset || lscalefactor )
    {
      size    = gridInqSize(gridID)*zaxisInqSize(zaxisID);
      missval = vlistInqVarMissval(vlistID, varID);

      if ( *nmiss > 0 )
	{
	  for ( i = 0; i < (int) size; i++ )
	    {
	      if ( !DBL_IS_EQUAL(data[i], missval) )
		{
		  if ( lscalefactor ) data[i] *= scalefactor;
		  if ( laddoffset )   data[i] += addoffset;
		}
	    }
	}
      else
	{
	  for ( i = 0; i < (int) size; i++ )
	    {
	      if ( lscalefactor ) data[i] *= scalefactor;
	      if ( laddoffset )   data[i] += addoffset;
	    }
	}
    }
#endif
}


void cdfWriteVarDP(int streamID, int varID, const double *data, int nmiss)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfWriteVarDP";
  int fileID;
  int gridID;
  int zaxisID;
  int xid = UNDEFID, yid = UNDEFID, zid = UNDEFID;
  int ncvarid;
  int ntsteps;
  size_t size;
  size_t start[4];
  size_t count[4];
  int ndims = 0;
  int idim;
  int timeID;
  int gridindex, zaxisindex;
  int i;
  int dtype;
  int vlistID;
  double *mdata = NULL;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d  varID = %d", streamID, varID);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  ntsteps = streamptr->ntsteps;
  if ( CDI_Debug )
    Message(func, "ntsteps = %d", ntsteps); 

  if ( vlistHasTime(vlistID) ) cdfDefTime(streamID);

  ncvarid = cdfDefVar(streamID, varID);

  gridID  = vlistInqVarGrid(vlistID, varID);
  zaxisID = vlistInqVarZaxis(vlistID, varID);
  timeID  = vlistInqVarTime(vlistID, varID);

  gridindex = vlistGridIndex(vlistID, gridID);
  if ( gridInqType(gridID) == GRID_TRAJECTORY )
    {
      cdfWriteGridTraj(streamID, gridID);
    }
  else
    {
      xid = streamptr->xdimID[gridindex];
      yid = streamptr->ydimID[gridindex];
    }

  zaxisindex = vlistZaxisIndex(vlistID, zaxisID);
  zid = streamptr->zaxisID[zaxisindex];

  if ( timeID == TIME_VARIABLE )
    {
      start[ndims] = ntsteps - 1;
      count[ndims] = 1;
      ndims++;
    }
  if ( zid != UNDEFID )
    {
      start[ndims] = 0;
      count[ndims] = zaxisInqSize(zaxisID);
      ndims++;
    }
  if ( yid != UNDEFID )
    {
      start[ndims] = 0;
      cdf_inq_dimlen(fileID, yid, &size);
      /*      count[ndims] = gridInqYsize(gridID); */
      count[ndims] = size;
      ndims++;
    }
  if ( xid != UNDEFID )
    {
      start[ndims] = 0;
      cdf_inq_dimlen(fileID, xid, &size);
      /*      count[ndims] = gridInqXsize(gridID); */
      count[ndims] = size;
      ndims++;
    }

  if ( CDI_Debug )
    for (idim = 0; idim < ndims; idim++)
      Message(func, "dim = %d  start = %d  count = %d", idim, start[idim], count[idim]);

  if ( streamptr->ncmode == 1 )
    {
      cdf_enddef(fileID);
      streamptr->ncmode = 2;
    }

  dtype = vlistInqVarDatatype(vlistID, varID);

  if ( nmiss > 0 ) cdfDefVarMissval(streamID, varID, dtype, 1);

  /*  if ( dtype == DATATYPE_INT8 || dtype == DATATYPE_INT16 || dtype == DATATYPE_INT32 ) */
    {
      int nvals;
      int laddoffset, lscalefactor;
      double addoffset, scalefactor;
      double missval;

      addoffset    = vlistInqVarAddoffset(vlistID, varID);
      scalefactor  = vlistInqVarScalefactor(vlistID, varID);
      laddoffset   = IS_NOT_EQUAL(addoffset, 0);
      lscalefactor = IS_NOT_EQUAL(scalefactor, 1);

      missval = vlistInqVarMissval(vlistID, varID);

      nvals = gridInqSize(gridID)*zaxisInqSize(zaxisID);

      if ( laddoffset || lscalefactor )
	{
	  mdata = (double *) malloc(nvals*sizeof(double));
	  memcpy(mdata, data, nvals*sizeof(double));

	  if ( nmiss > 0 )
	    {
	      for ( i = 0; i < nvals; i++ )
		{
		  if ( !DBL_IS_EQUAL(data[i], missval) )
		    {
		      if ( laddoffset )   mdata[i] -= addoffset;
		      if ( lscalefactor ) mdata[i] /= scalefactor;
		    }
		}
	    }
	  else
	    {
	      for ( i = 0; i < nvals; i++ )
		{
		  if ( laddoffset )   mdata[i] -= addoffset;
		  if ( lscalefactor ) mdata[i] /= scalefactor;
		}
	    }
	}

      if ( dtype == DATATYPE_UINT8 || dtype == DATATYPE_INT8 ||
	   dtype == DATATYPE_INT16 || dtype == DATATYPE_INT32 )
	{
	  if ( mdata )
	    {
	      for ( i = 0; i < nvals; i++ ) mdata[i] = NINT(mdata[i]);
	    }
	  else
	    {
	      mdata = (double *) malloc(nvals*sizeof(double));
	      for ( i = 0; i < nvals; i++ ) mdata[i] = NINT(data[i]);
	    }
	}
    }

  if ( mdata )
    cdf_put_vara_double(fileID, ncvarid, start, count, mdata);
  else
    cdf_put_vara_double(fileID, ncvarid, start, count, data);

  if ( mdata ) free(mdata);
#endif
}


int cdfReadVarSliceDP(int streamID, int varID, int levelID, double *data, int *nmiss)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfReadVarSliceDP";
  int fileID;
  int gridID;
  int zaxisID;
  int xid = UNDEFID, yid = UNDEFID, zid = UNDEFID;
  int ncvarid;
  int tsID;
  int gridsize, xsize, ysize;
  size_t size;
  size_t start[4];
  size_t count[4];
  int ndims = 0;
  int idim;
  int timeID;
  int gridindex;
  int zaxisindex;
  int vlistID;
  int i, j;
  int ndimsp;
  int dimids[9];
  int swapyxz = FALSE;
  int swapyz = FALSE;
  int swapxy = FALSE;
  double missval;
  int laddoffset, lscalefactor;
  double addoffset, scalefactor;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);


  if ( CDI_Debug )
    Message(func, "streamID = %d  varID = %d  levelID = %d", streamID, varID, levelID);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  tsID = streamptr->curTsID;
  if ( CDI_Debug )
    Message(func, "tsID = %d", tsID);

  ncvarid = streamptr->vars[varID].ncvarid;

  gridID  = vlistInqVarGrid(vlistID, varID);
  zaxisID = vlistInqVarZaxis(vlistID, varID);
  timeID  = vlistInqVarTime(vlistID, varID);

  gridsize = gridInqSize(gridID);
  xsize = gridInqXsize(gridID);
  ysize = gridInqYsize(gridID);
      
  streamptr->numvals += gridsize;

  gridindex = vlistGridIndex(vlistID, gridID);
  if ( gridInqType(gridID) == GRID_TRAJECTORY )
    {
      cdfReadGridTraj(streamID, gridID);
    }
  else if ( gridInqType(gridID) == GRID_CELL )
    {
      xid = streamptr->xdimID[gridindex];
    }
  else
    {
      xid = streamptr->xdimID[gridindex];
      yid = streamptr->ydimID[gridindex];
    }

  zaxisindex = vlistZaxisIndex(vlistID, zaxisID);
  zid = streamptr->zaxisID[zaxisindex];
  /*
  printf("2 %d %d %d %s\n", streamID, zaxisindex, streamptr->zaxisID[zaxisindex], vlistInqVarNamePtr(vlistID, varID));
  */

  if ( timeID == TIME_VARIABLE )
    {
      start[ndims] = tsID;
      count[ndims] = 1;
      ndims++;
    }

  cdf_inq_varndims(fileID, ncvarid, &ndimsp);
  cdf_inq_vardimid(fileID, ncvarid, dimids);

  if ( zid != UNDEFID && yid != UNDEFID && xid != UNDEFID )
    {
      if ( yid == dimids[ndims] && xid == dimids[ndims+1] && zid == dimids[ndims+2] )
	swapyxz = TRUE;
    }

  if ( swapyxz == FALSE && zid != UNDEFID && yid != UNDEFID )
    {
      if ( zid == dimids[ndims] && yid == dimids[ndims+1] )
	swapyz = FALSE;
      else if ( yid == dimids[ndims] && zid == dimids[ndims+1] )
	swapyz = TRUE;
      else
	{
	  char name[256];
	  vlistInqVarName(vlistID, varID, name);
	  Error(func, "Unsupported array structure for: %s", name);
	}
    }

  if ( swapyxz == FALSE && swapyz == FALSE && yid != UNDEFID && xid != UNDEFID )
    {
      if ( xid == dimids[ndimsp-1] && yid == dimids[ndimsp-2] )
	swapxy = FALSE;
      else if ( yid == dimids[ndimsp-1] && xid == dimids[ndimsp-2] )
	swapxy = TRUE;
      else
	{
	  char name[256];
	  vlistInqVarName(vlistID, varID, name);
	  Error(func, "Unsupported array structure for: %s", name);
	}
    }

  if ( swapyz )
    {
      if ( yid != UNDEFID )
	{
	  start[ndims] = 0;
	  /* count[ndims] = gridInqYsize(gridID); */
	  cdf_inq_dimlen(fileID, yid, &size);
	  count[ndims] = size;
	  ndims++;
	}
      if ( zid != UNDEFID )
	{
	  start[ndims] = levelID;
	  count[ndims] = 1;
	  ndims++;
	}
      if ( xid != UNDEFID )
	{
	  start[ndims] = 0;
	  /* count[ndims] = gridInqXsize(gridID); */
	  cdf_inq_dimlen(fileID, xid, &size);
	  count[ndims] = size;
	  ndims++;
	}
    }
  else if ( swapyxz )
    {
      if ( yid != UNDEFID )
	{
	  start[ndims] = 0;
	  /* count[ndims] = gridInqYsize(gridID); */
	  cdf_inq_dimlen(fileID, yid, &size);
	  count[ndims] = size;
	  ndims++;
	}
      if ( xid != UNDEFID )
	{
	  start[ndims] = 0;
	  /* count[ndims] = gridInqXsize(gridID); */
	  cdf_inq_dimlen(fileID, xid, &size);
	  count[ndims] = size;
	  ndims++;
	}
      if ( zid != UNDEFID )
	{
	  start[ndims] = levelID;
	  count[ndims] = 1;
	  ndims++;
	}
    }
  else
    {
      if ( zid != UNDEFID )
	{
	  start[ndims] = levelID;
	  count[ndims] = 1;
	  ndims++;
	}

      if ( swapxy )
	{
	  if ( xid != UNDEFID )
	    {
	      start[ndims] = 0;
	      /* count[ndims] = gridInqXsize(gridID); */
	      cdf_inq_dimlen(fileID, xid, &size);
	      count[ndims] = size;
	      ndims++;
	    }
	  if ( yid != UNDEFID )
	    {
	      start[ndims] = 0;
	      /* count[ndims] = gridInqYsize(gridID); */
	      cdf_inq_dimlen(fileID, yid, &size);
	      count[ndims] = size;
	      ndims++;
	    }
	}
      else
	{
	  if ( yid != UNDEFID )
	    {
	      start[ndims] = 0;
	      /* count[ndims] = gridInqYsize(gridID); */
	      cdf_inq_dimlen(fileID, yid, &size);
	      count[ndims] = size;
	      ndims++;
	    }
	  if ( xid != UNDEFID )
	    {
	      start[ndims] = 0;
	      /* count[ndims] = gridInqXsize(gridID); */
	      cdf_inq_dimlen(fileID, xid, &size);
	      count[ndims] = size;
	      ndims++;
	    }
	}
    }

  if ( CDI_Debug )
    for (idim = 0; idim < ndims; idim++)
      Message(func, "dim = %d  start = %d  count = %d", idim, start[idim], count[idim]);

  cdf_get_vara_double(fileID, ncvarid, start, count, data);

  if ( swapxy )
    {
      double *tdata;
      tdata = (double *) malloc(gridsize*sizeof(double));
      memcpy(tdata, data, gridsize*sizeof(double));
      for ( j = 0; j < ysize; ++j )
	for ( i = 0; i < xsize; ++i )
	  data[j*xsize+i] = tdata[i*ysize+j];
      free(tdata);
    }

  *nmiss = 0;
  if ( vlistInqVarMissvalUsed(vlistID, varID) == TRUE  )
    {
      missval = vlistInqVarMissval(vlistID, varID);
      // printf("XXX %31.0f %31.0f %31.0f %31.0f\n", missval, (float)data[0]);
      for ( i = 0; i < gridsize; i++ )
	if ( DBL_IS_EQUAL(data[i], missval) ) *nmiss += 1;
    }

  addoffset    = vlistInqVarAddoffset(vlistID, varID);
  scalefactor  = vlistInqVarScalefactor(vlistID, varID);
  laddoffset   = IS_NOT_EQUAL(addoffset, 0);
  lscalefactor = IS_NOT_EQUAL(scalefactor, 1);

  if ( laddoffset || lscalefactor )
    {
      missval = vlistInqVarMissval(vlistID, varID);

      if ( *nmiss > 0 )
	{
	  for ( i = 0; i < gridsize; i++ )
	    {
	      if ( !DBL_IS_EQUAL(data[i], missval) )
		{
		  if ( lscalefactor ) data[i] *= scalefactor;
		  if ( laddoffset )   data[i] += addoffset;
		}
	    }
	}
      else
	{
	  for ( i = 0; i < gridsize; i++ )
	    {
	      if ( lscalefactor ) data[i] *= scalefactor;
	      if ( laddoffset )   data[i] += addoffset;
	    }
	}
    }

#endif
  return (0);
}


int cdfWriteVarSliceDP(int streamID, int varID, int levelID, const double *data, int nmiss)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfWriteVarSliceDP";
  int fileID;
  int gridID;
  int zaxisID;
  int xid = UNDEFID, yid = UNDEFID, zid = UNDEFID;
  int ncvarid;
  int ntsteps;
  size_t size;
  size_t start[4];
  size_t count[4];
  int ndims = 0;
  int idim;
  int timeID;
  int gridindex, zaxisindex;
  int i;
  int dtype;
  int vlistID;
  double *mdata = NULL;
  stream_t *streamptr;
  extern int CDF_Debug;

  streamptr = stream_to_pointer(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d  varID = %d", streamID, varID);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  ntsteps = streamptr->ntsteps;
  if ( CDI_Debug ) Message(func, "ntsteps = %d", ntsteps);

  if ( vlistHasTime(vlistID) ) cdfDefTime(streamID);

  ncvarid = cdfDefVar(streamID, varID);

  gridID  = vlistInqVarGrid(vlistID, varID);
  zaxisID = vlistInqVarZaxis(vlistID, varID);
  timeID  = vlistInqVarTime(vlistID, varID);

  gridindex = vlistGridIndex(vlistID, gridID);
  if ( gridInqType(gridID) == GRID_TRAJECTORY )
    {
      cdfWriteGridTraj(streamID, gridID);
    }
  else
    {
      xid = streamptr->xdimID[gridindex];
      yid = streamptr->ydimID[gridindex];
    }

  zaxisindex = vlistZaxisIndex(vlistID, zaxisID);
  zid = streamptr->zaxisID[zaxisindex];

  if ( timeID == TIME_VARIABLE )
    {
      start[ndims] = ntsteps - 1;
      count[ndims] = 1;
      ndims++;
    }
  if ( zid != UNDEFID )
    {
      start[ndims] = levelID;
      count[ndims] = 1;
      ndims++;
    }
  if ( yid != UNDEFID )
    {
      start[ndims] = 0;
      cdf_inq_dimlen(fileID, yid, &size);
      /*      count[ndims] = gridInqYsize(gridID); */
      count[ndims] = size;
      ndims++;
    }
  if ( xid != UNDEFID )
    {
      start[ndims] = 0;
      cdf_inq_dimlen(fileID, xid, &size);
      /*      count[ndims] = gridInqXsize(gridID); */
      count[ndims] = size;
      ndims++;
    }

  if ( CDI_Debug )
    for (idim = 0; idim < ndims; idim++)
      Message(func, "dim = %d  start = %d  count = %d", idim, start[idim], count[idim]);

  dtype = vlistInqVarDatatype(vlistID, varID);

  if ( nmiss > 0 ) cdfDefVarMissval(streamID, varID, dtype, 1);

  /*  if ( dtype == DATATYPE_INT8 || dtype == DATATYPE_INT16 || dtype == DATATYPE_INT32 ) */
    {
      int nvals;
      int laddoffset, lscalefactor;
      double addoffset, scalefactor;
      double missval;

      addoffset    = vlistInqVarAddoffset(vlistID, varID);
      scalefactor  = vlistInqVarScalefactor(vlistID, varID);
      laddoffset   = IS_NOT_EQUAL(addoffset, 0);
      lscalefactor = IS_NOT_EQUAL(scalefactor, 1);

      missval      = vlistInqVarMissval(vlistID, varID);

      nvals = gridInqSize(gridID);

      if ( laddoffset || lscalefactor )
	{
	  mdata = (double *) malloc(nvals*sizeof(double));
	  memcpy(mdata, data, nvals*sizeof(double));

	  if ( nmiss > 0 )
	    {
	      for ( i = 0; i < nvals; i++ )
		{
		  if ( !DBL_IS_EQUAL(mdata[i], missval) )
		    {
		      if ( laddoffset )   mdata[i] -= addoffset;
		      if ( lscalefactor ) mdata[i] /= scalefactor;
		    }
		}
	    }
	  else
	    {
	      for ( i = 0; i < nvals; i++ )
		{
		  if ( laddoffset )   mdata[i] -= addoffset;
		  if ( lscalefactor ) mdata[i] /= scalefactor;
		}
	    }
	}

      if ( dtype == DATATYPE_UINT8 || dtype == DATATYPE_INT8 ||
	   dtype == DATATYPE_INT16 || dtype == DATATYPE_INT32 )
	{
	  if ( mdata )
	    {
	      for ( i = 0; i < nvals; i++ ) mdata[i] = NINT(mdata[i]);
	    }
	  else
	    {
	      mdata = (double *) malloc(nvals*sizeof(double));
	      for ( i = 0; i < nvals; i++ ) mdata[i] = NINT(data[i]);
	    }
	}

      if ( CDF_Debug )
	{
	  double fmin, fmax;
	  fmin =  1.0e200;
	  fmax = -1.0e200;
	  for ( i = 0; i < nvals; ++i )
	    {
	      if ( !DBL_IS_EQUAL(data[i], missval) )
		{
		  if ( data[i] < fmin ) fmin = data[i];
		  if ( data[i] > fmax ) fmax = data[i];
		}
	    }
	  Message(func, "nvals = %d, nmiss = %d, missval = %g, minval = %g, maxval = %g",
		  nvals, nmiss, missval, fmin, fmax);
	}
    }

  if ( mdata )
    cdf_put_vara_double(fileID, ncvarid, start, count, mdata);
  else
    cdf_put_vara_double(fileID, ncvarid, start, count, data);

  if ( mdata ) free(mdata);
#endif
  return (0);
}

void cdfCreateRecords(int streamID, int tsID)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfCreateRecords";
  int varID, levelID, recID, vrecID, zaxisID;
  int nvars, nlev, nrecs, nvrecs;
  record_t *records = NULL;
  int *recIDs = NULL;
  int vlistID;
  stream_t *streamptr;

  streamptr = stream_to_pointer(streamID);

  vlistID  = streamInqVlist(streamID);

  if ( tsID < 0 || (tsID >= streamptr->ntsteps && tsID > 0) ) return;

  if ( streamptr->tsteps[tsID].nallrecs > 0 ) return;

  if ( tsID == 0 )
    {
      nvars = vlistNvars(vlistID);
      nrecs = vlistNrecs(vlistID);

      streamptr->nrecs += nrecs;

      if ( nrecs > 0 ) records = (record_t *) malloc(nrecs*sizeof(record_t));
      streamptr->tsteps[tsID].records    = records;
      streamptr->tsteps[tsID].nrecs      = nrecs;
      streamptr->tsteps[tsID].nallrecs   = nrecs;
      streamptr->tsteps[tsID].recordSize = nrecs;
      streamptr->tsteps[tsID].curRecID   = UNDEFID;

      nvrecs = nrecs; /* use all records at first timestep */
      if ( nvrecs > 0 ) recIDs = (int *) malloc(nvrecs*sizeof(int));
      streamptr->tsteps[tsID].recIDs     = recIDs;
      for ( recID = 0; recID < nvrecs; recID++ )
	recIDs[recID] = recID;

      recID = 0;
      for ( varID = 0; varID < nvars; varID++ )
	{
	  zaxisID = vlistInqVarZaxis(vlistID, varID);
	  nlev    = zaxisInqSize(zaxisID);
	  for ( levelID = 0; levelID < nlev; levelID++ )
	    {
	      recordInitEntry(&records[recID]);
	      records[recID].varID   = varID;
	      records[recID].levelID = levelID;
	      recID++;
	    }
	}
    }
  else if ( tsID == 1 )
    {
      nvars = vlistNvars(vlistID);
      nrecs = vlistNrecs(vlistID);

      nvrecs = 0;
      for ( varID = 0; varID < nvars; varID++ )
	{
	  if ( vlistInqVarTime(vlistID, varID) == TIME_VARIABLE )
	    {
	      zaxisID = vlistInqVarZaxis(vlistID, varID);
	      nvrecs += zaxisInqSize(zaxisID);
	    }
	}

      streamptr->nrecs += nvrecs;

      records = (record_t *) malloc(nrecs*sizeof(record_t));
      streamptr->tsteps[tsID].records    = records;
      streamptr->tsteps[tsID].nrecs      = nvrecs;
      streamptr->tsteps[tsID].nallrecs   = nrecs;
      streamptr->tsteps[tsID].recordSize = nrecs;
      streamptr->tsteps[tsID].curRecID   = UNDEFID;

      memcpy(streamptr->tsteps[tsID].records,
	     streamptr->tsteps[0].records,
	     nrecs*sizeof(record_t));

      if ( nvrecs )
	{
	  recIDs = (int *) malloc(nvrecs*sizeof(int));
	  streamptr->tsteps[tsID].recIDs     = recIDs;
	  vrecID = 0;
	  for ( recID = 0; recID < nrecs; recID++ )
	    {
	      varID = records[recID].varID;
	      if ( vlistInqVarTime(vlistID, varID) == TIME_VARIABLE )
		{
		  recIDs[vrecID++] = recID;
		}
	    }
	}
    }
  else
    {
      nvars = vlistNvars(vlistID);
      nrecs = vlistNrecs(vlistID);

      nvrecs = streamptr->tsteps[1].nrecs;

      streamptr->nrecs += nvrecs;

      records = (record_t *) malloc(nrecs*sizeof(record_t));
      streamptr->tsteps[tsID].records    = records;
      streamptr->tsteps[tsID].nrecs      = nvrecs;
      streamptr->tsteps[tsID].nallrecs   = nrecs;
      streamptr->tsteps[tsID].recordSize = nrecs;
      streamptr->tsteps[tsID].curRecID   = UNDEFID;

      memcpy(streamptr->tsteps[tsID].records,
	     streamptr->tsteps[0].records,
	     nrecs*sizeof(record_t));

      recIDs = (int *) malloc(nvrecs*sizeof(int));
      streamptr->tsteps[tsID].recIDs     = recIDs;

      memcpy(streamptr->tsteps[tsID].recIDs,
	     streamptr->tsteps[1].recIDs,
	     nvrecs*sizeof(int));
    }
#endif
}

static
int cdfTimeDimID(int fileID, int ndims, int nvars)
{
  int dimid = 0;
#if  defined  (HAVE_LIBNETCDF)
  char dimname[80];
  char timeunits[256];
  char attname[256];
  char name[256];
  nc_type xtype;
  int nvdims, nvatts;
  int dimids[9];
  int varid, iatt;

  for ( dimid = 0; dimid < ndims; dimid++ )
    {
      cdf_inq_dimname(fileID, dimid, dimname);
      if ( memcmp(dimname, "time", 4) == 0 ) break;
    }

  if ( dimid == ndims ) dimid = UNDEFID;

  for ( varid = 0; varid < nvars; varid++ )
    {
      if ( dimid != UNDEFID ) break;

      cdf_inq_var(fileID, varid, name, &xtype, &nvdims, dimids, &nvatts);
      if ( nvdims == 1 )
	{
	  for ( iatt = 0; iatt < nvatts; iatt++ )
	    {
	      cdf_inq_attname(fileID, varid, iatt, attname);
	      if ( memcmp(attname, "units", 5) == 0 )
		{
		  cdfGetAttText(fileID, varid, "units", 256, timeunits);
		  strtolower(timeunits);

		  if ( memcmp(timeunits, "sec",    3) == 0 ||
		       memcmp(timeunits, "minute", 6) == 0 ||
		       memcmp(timeunits, "hour",   4) == 0 ||
		       memcmp(timeunits, "day",    3) == 0 ||
		       memcmp(timeunits, "month",  5) == 0 )
		    {
		      dimid = dimids[0];
		      break;
		    }
		}
	    }
	}
    }

#endif
  return (dimid);
}

static
void init_ncdims(long ndims, NCDIM *ncdims)
{
  long ncdimid;

  for ( ncdimid = 0; ncdimid < ndims; ncdimid++ )
    {
      ncdims[ncdimid].ncvarid      = UNDEFID;
      ncdims[ncdimid].dimtype      = UNDEFID;
      ncdims[ncdimid].len          = 0;
      ncdims[ncdimid].name[0]      = 0;
    }
}

static
void init_ncvars(long nvars, NCVAR *ncvars)
{
  long ncvarid;

  for ( ncvarid = 0; ncvarid < nvars; ncvarid++ )
    {      
      ncvars[ncvarid].ignore          = FALSE;
      ncvars[ncvarid].isvar           = UNDEFID;
      ncvars[ncvarid].islon           = FALSE;
      ncvars[ncvarid].islat           = FALSE;
      ncvars[ncvarid].islev           = FALSE;
      ncvars[ncvarid].warn            = FALSE;
      ncvars[ncvarid].timeID          = TIME_CONSTANT;
      ncvars[ncvarid].code            = UNDEFID;
      ncvars[ncvarid].tabnum          = 0;
      ncvars[ncvarid].calendar        = FALSE;
      ncvars[ncvarid].bounds          = UNDEFID;
      ncvars[ncvarid].gridID          = UNDEFID;
      ncvars[ncvarid].zaxisID         = UNDEFID;
      ncvars[ncvarid].gridtype        = UNDEFID;
      ncvars[ncvarid].zaxistype       = UNDEFID;
      ncvars[ncvarid].xdim            = UNDEFID;
      ncvars[ncvarid].ydim            = UNDEFID;
      ncvars[ncvarid].zdim            = UNDEFID;
      ncvars[ncvarid].xvarid          = UNDEFID;
      ncvars[ncvarid].yvarid          = UNDEFID;
      ncvars[ncvarid].zvarid          = UNDEFID;
      ncvars[ncvarid].tvarid          = UNDEFID;
      ncvars[ncvarid].ncoordvars      = 0;
      ncvars[ncvarid].coordvarids[0]  = UNDEFID;
      ncvars[ncvarid].coordvarids[1]  = UNDEFID;
      ncvars[ncvarid].coordvarids[2]  = UNDEFID;
      ncvars[ncvarid].coordvarids[3]  = UNDEFID;
      ncvars[ncvarid].cellarea        = UNDEFID;
      ncvars[ncvarid].tableID         = UNDEFID;
      ncvars[ncvarid].xtype           = 0;
      ncvars[ncvarid].ndims           = 0;
      ncvars[ncvarid].gmapid          = UNDEFID;
      ncvars[ncvarid].vlen            = 0;
      ncvars[ncvarid].vdata           = NULL;
      ncvars[ncvarid].truncation      = 0;
      ncvars[ncvarid].positive        = 0;
      ncvars[ncvarid].defmiss         = 0;
      ncvars[ncvarid].missval         = 0;
      ncvars[ncvarid].addoffset       = 0;
      ncvars[ncvarid].scalefactor     = 1;
      ncvars[ncvarid].name[0]         = 0;
      ncvars[ncvarid].longname[0]     = 0;
      ncvars[ncvarid].stdname[0]      = 0;
      ncvars[ncvarid].units[0]        = 0;
      ncvars[ncvarid].natts           = 0;
      ncvars[ncvarid].atts            = NULL;
      ncvars[ncvarid].deflate         = 0;
    }
}

static
int isLonAxis(const char *units, const char *stdname)
{
  int lunit = FALSE;

  if ( memcmp(units, "degrees_east", 12) == 0 ||
       memcmp(units, "degree_east", 11)  == 0 ||
       memcmp(units, "degree_E", 8)      == 0 ||
       memcmp(units, "degrees_E", 9)     == 0 ||
       memcmp(units, "degreeE", 7)       == 0 ||
       memcmp(units, "degreesE", 8)      == 0 ||
       memcmp(stdname, "longitude", 9)   == 0 ||
       (memcmp(units, "degree", 6)            == 0 &&
	memcmp(stdname, "grid_longitude", 14) == 0) ||
       (memcmp(units, "radian", 6)            == 0 &&
	memcmp(stdname, "grid_longitude", 14) == 0) )
    {
      lunit = TRUE;
    }

  return (lunit);
}

static
int isLatAxis(const char *units, const char *stdname)
{
  int lunit = FALSE;

  if ( memcmp(units, "degrees_north", 13) == 0 ||
       memcmp(units, "degree_north", 12)  == 0 ||
       memcmp(units, "degree_N", 8)       == 0 ||
       memcmp(units, "degrees_N", 9)      == 0 ||
       memcmp(units, "degreeN", 7)        == 0 ||
       memcmp(units, "degreesN", 8)       == 0 ||
       memcmp(stdname, "latitude", 8)     == 0 ||
       (memcmp(units, "degree", 6)           == 0 &&
	memcmp(stdname, "grid_latitude", 13) == 0) ||
       (memcmp(units, "radian", 6)           == 0 &&
	memcmp(stdname, "grid_latitude", 13) == 0) )
    {
      lunit = TRUE;
    }

  return (lunit);
}

static
int unitsIsPressure(const char *units)
{
  int lunit = FALSE;

  if ( memcmp(units, "millibar", 8) == 0 ||
       memcmp(units, "mb", 2)       == 0 ||
       memcmp(units, "hectopas", 8) == 0 ||
       memcmp(units, "hPa", 3)      == 0 ||
       memcmp(units, "Pa", 2)       == 0 )
    {
      lunit = TRUE;
    }

  return (lunit);
}


static
int isGaussGrid(long ysize, double yinc, double *yvals)
{
  static char func[] = "isGaussGrid";
  int lgauss = FALSE;
  long i;
  double *yv, *yw;

  if ( IS_EQUAL(yinc, 0) && ysize > 2 ) /* check if gaussian */
    {
      yv = (double *) malloc(ysize*sizeof(double));
      yw = (double *) malloc(ysize*sizeof(double));
      gaussaw(yv, yw, ysize);
      free(yw);
      for ( i = 0; i < ysize; i++ )
	yv[i] = asin(yv[i])/M_PI*180.0;

      for ( i = 0; i < ysize; i++ )
	if ( fabs(yv[i] - yvals[i]) >
	     ((yv[0] - yv[1])/500) ) break;
		      
      if ( i == ysize ) lgauss = TRUE;

      /* check S->N */
      if ( lgauss == FALSE )
	{		  
	  for ( i = 0; i < ysize; i++ )
	    if ( fabs(yv[i] - yvals[ysize-i-1]) >
		 ((yv[0] - yv[1])/500) ) break;
      
	  if ( i == ysize ) lgauss = TRUE;
	}

      free(yv);
    }

  return (lgauss);
}


static
void cdfSetVar(NCVAR *ncvars, int ncvarid, int isvar)
{
  static char func[] = "cdfSetVar";

  if ( isvar != TRUE && isvar != FALSE )
    Error(func, "Internal problem! var %s undefined", ncvars[ncvarid].name);

  if ( ncvars[ncvarid].isvar != UNDEFID &&
       ncvars[ncvarid].isvar != isvar   &&
       ncvars[ncvarid].warn  == FALSE )
    {
      if ( ! ncvars[ncvarid].ignore )
	Warning(func, "Inconsistent variable definition for %s!", ncvars[ncvarid].name);
	
      ncvars[ncvarid].warn = TRUE;
      isvar = FALSE;
    }

  ncvars[ncvarid].isvar = isvar;
}

static
void cdfSetDim(NCVAR *ncvars, int ncvarid, int dimid, int dimtype)
{
  static char func[] = "cdfSetDim";

  if ( ncvars[ncvarid].dimtype[dimid] != UNDEFID &&
       ncvars[ncvarid].dimtype[dimid] != dimtype )
    {
      Warning(func, "Inconsistent dimension definition for %s! dimid = %d;  type = %d;  newtype = %d",
	      ncvars[ncvarid].name, dimid, ncvars[ncvarid].dimtype[dimid], dimtype);
    }

  ncvars[ncvarid].dimtype[dimid] = dimtype;
}

static
void printNCvars(NCVAR *ncvars, int nvars)
{
  char axis[6];
  int ncvarid, i;
  int ndim;
  int iaxis[] = {'t', 'z', 'y', 'x'};

  for ( ncvarid = 0; ncvarid < nvars; ncvarid++ )
    {
      ndim = 0;
      if ( ncvars[ncvarid].isvar )
	{
	  axis[ndim++] = 'v';
	  for ( i = 0; i < ncvars[ncvarid].ndims; i++ )
	    {/*
	      if      ( ncvars[ncvarid].tvarid != -1 ) axis[ndim++] = iaxis[0];
	      else if ( ncvars[ncvarid].zvarid != -1 ) axis[ndim++] = iaxis[1];
	      else if ( ncvars[ncvarid].yvarid != -1 ) axis[ndim++] = iaxis[2];
	      else if ( ncvars[ncvarid].xvarid != -1 ) axis[ndim++] = iaxis[3];
	      else
	     */
	      axis[ndim++] = '?';
	    }
	}
      else
	{
	  axis[ndim++] = 'c';
	  if ( ncvars[ncvarid].islev )
	    axis[ndim++] = iaxis[1];
	  else if ( ncvars[ncvarid].islat )
	    axis[ndim++] = iaxis[2];
	  else if ( ncvars[ncvarid].islon )
	    axis[ndim++] = iaxis[3];
	  else
	    axis[ndim++] = '?';
	}

      axis[ndim++] = 0;

      printf("%3d %3d %3d  %-4s %s\n", ncvarid, ncvars[ncvarid].isvar, ndim-2, axis, ncvars[ncvarid].name);
    }
}


typedef struct
{
  int      ncvarid;
  char     name[128];
}
varinfo_t;


static
int cmpvarname(const void *s1, const void *s2)
{
  varinfo_t *x = (varinfo_t *) s1;
  varinfo_t *y = (varinfo_t *) s2;

  return (strcmp(x->name, y->name));
}

#if  defined  (HAVE_LIBNETCDF)
static
void scanVarAttributes(int fileID, int nvars, NCVAR *ncvars, NCDIM *ncdims,
		       int timedimid, int modelID, int format)
{
  static char func[] = "scanAttributes";
  int ncvarid;
  int ncdimid;
  int nvdims, nvatts;
  int *dimidsp;
  nc_type xtype, atttype;
  size_t attlen;
  char name[256];
  char attname[256];
  const int attstringlen = 8192; char attstring[8192];
  int iatt;
  int i;
  int tablenum;

  for ( ncvarid = 0; ncvarid < nvars; ncvarid++ )
    {
      dimidsp = ncvars[ncvarid].dimids;

      cdf_inq_var(fileID, ncvarid, name, &xtype, &nvdims, dimidsp, &nvatts);
      strcpy(ncvars[ncvarid].name, name);      

      for ( ncdimid = 0; ncdimid < nvdims; ncdimid++ )
	ncvars[ncvarid].dimtype[ncdimid] = -1;

      ncvars[ncvarid].xtype = xtype;
      ncvars[ncvarid].ndims = nvdims;

#if  defined  (NC_NETCDF4)
      if ( format == NC_FORMAT_NETCDF4_CLASSIC )
	{
	  int shuffle, deflate, deflate_level;
	  nc_inq_var_deflate(fileID, ncvarid, &shuffle, &deflate, &deflate_level);
	  if ( deflate > 0 )
	    ncvars[ncvarid].deflate = 1;
	}
#endif

      if ( nvdims > 0 )
	if ( timedimid == dimidsp[0] )
	  {
	    ncvars[ncvarid].timeID = TIME_VARIABLE;
	    cdfSetDim(ncvars, ncvarid, 0, T_AXIS);
	  }

      for ( iatt = 0; iatt < nvatts; iatt++ )
	{
	  cdf_inq_attname(fileID, ncvarid, iatt, attname);
	  cdf_inq_atttype(fileID, ncvarid, attname, &atttype);
	  cdf_inq_attlen(fileID, ncvarid, attname, &attlen);
	  
	  if ( strcmp(attname, "long_name") == 0 && atttype == NC_CHAR )
	    {
	      cdfGetAttText(fileID, ncvarid, attname, MAXNAMELEN, ncvars[ncvarid].longname);
      	    }
	  else if ( strcmp(attname, "standard_name") == 0 && atttype == NC_CHAR )
	    {
	      cdfGetAttText(fileID, ncvarid, attname, MAXNAMELEN, ncvars[ncvarid].stdname);
      	    }
	  else if ( strcmp(attname, "units") == 0 && atttype == NC_CHAR )
	    {
	      cdfGetAttText(fileID, ncvarid, attname, MAXNAMELEN, ncvars[ncvarid].units);
      	    }
	  else if ( strcmp(attname, "calendar") == 0 )
	    {
	      ncvars[ncvarid].calendar = TRUE;
      	    }
	  else if ( strcmp(attname, "code") == 0 && atttype != NC_CHAR )
	    {
	      cdfGetAttInt(fileID, ncvarid, attname, 1, &ncvars[ncvarid].code);
	      cdfSetVar(ncvars, ncvarid, TRUE);
	    }
	  else if ( strcmp(attname, "table") == 0 && atttype != NC_CHAR )
	    {
	      cdfGetAttInt(fileID, ncvarid, attname, 1, &tablenum);
	      if ( tablenum > 0 )
		{
		  ncvars[ncvarid].tabnum = tablenum;
		  ncvars[ncvarid].tableID = tableInq(modelID, tablenum, NULL);
		  if ( ncvars[ncvarid].tableID == CDI_UNDEFID )
		    ncvars[ncvarid].tableID = tableDef(modelID, tablenum, NULL);
		}
	      cdfSetVar(ncvars, ncvarid, TRUE);
	    }
	  else if ( strcmp(attname, "trunc_type") == 0 && atttype == NC_CHAR )
	    {
	      cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);
	      if ( memcmp(attstring, "Triangular", attlen) == 0 )
		ncvars[ncvarid].gridtype = GRID_SPECTRAL;
	    }
	  else if ( strcmp(attname, "grid_type") == 0 && atttype == NC_CHAR )
	    {
	      cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);
	      strtolower(attstring);

	      if      ( strcmp(attstring, "gaussian reduced") == 0 )
		ncvars[ncvarid].gridtype = GRID_GAUSSIAN_REDUCED;
	      else if ( strcmp(attstring, "gaussian") == 0 )
		ncvars[ncvarid].gridtype = GRID_GAUSSIAN;
	      else if ( strncmp(attstring, "spectral", 8) == 0 )
		ncvars[ncvarid].gridtype = GRID_SPECTRAL;
	      else if ( strcmp(attstring, "trajectory") == 0 )
		ncvars[ncvarid].gridtype = GRID_TRAJECTORY;
	      else if ( strcmp(attstring, "generic") == 0 )
		ncvars[ncvarid].gridtype = GRID_GENERIC;
	      else if ( strcmp(attstring, "cell") == 0 )
		ncvars[ncvarid].gridtype = GRID_CELL;
	      else if ( strcmp(attstring, "curvilinear") == 0 )
		ncvars[ncvarid].gridtype = GRID_CURVILINEAR;
	      else if ( strcmp(attstring, "sinusoidal") == 0 )
		;
	      else if ( strcmp(attstring, "laea") == 0 )
		;
	      else if ( strcmp(attstring, "lcc2") == 0 )
		;
	      else
		{
		  static int warn = TRUE;
		  if ( warn )
		    {
		      warn = FALSE;
		      Warning(func, "Gridtype %s unsupported!", attstring);
		    }
		}

	      cdfSetVar(ncvars, ncvarid, TRUE);
	    }
	  else if ( strcmp(attname, "trunc_count") == 0 && atttype != NC_CHAR )
	    {
	      cdfGetAttInt(fileID, ncvarid, attname, 1, &ncvars[ncvarid].truncation);
	    }
	  else if ( strcmp(attname, "truncation") == 0 && atttype != NC_CHAR )
	    {
	      cdfGetAttInt(fileID, ncvarid, attname, 1, &ncvars[ncvarid].truncation);
	    }
	  else if ( strcmp(attname, "add_offset") == 0 && atttype != NC_CHAR )
	    {
	      if ( atttype != NC_CHAR )
		{
		  cdfGetAttDouble(fileID, ncvarid, attname, 1, &ncvars[ncvarid].addoffset);
		  /*
		    if ( atttype != NC_BYTE && atttype != NC_SHORT && atttype != NC_INT )
		    if ( ncvars[ncvarid].addoffset != 0 )
		    Warning(func, "attribute add_offset not supported for atttype %d\n", atttype);
		  */
		  cdfSetVar(ncvars, ncvarid, TRUE);
		}
	    }
	  else if ( strcmp(attname, "scale_factor") == 0 && atttype != NC_CHAR )
	    {
	      if ( atttype != NC_CHAR )
		{
		  cdfGetAttDouble(fileID, ncvarid, attname, 1, &ncvars[ncvarid].scalefactor);
		  /*
		    if ( atttype != NC_BYTE && atttype != NC_SHORT && atttype != NC_INT )
		    if ( ncvars[ncvarid].scalefactor != 1 )
		    Warning(func, "attribute scale_factor not supported for atttype %d\n", atttype);
		  */
		  cdfSetVar(ncvars, ncvarid, TRUE);
		}
	    }
	  else if ( strcmp(attname, "bounds") == 0 && atttype == NC_CHAR )
	    {
	      int status, ncboundsid;

	      cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);

	      status = nc_inq_varid(fileID, attstring, &ncboundsid);

	      if ( status == NC_NOERR )
		{
		  ncvars[ncvarid].bounds = ncboundsid;
		  cdfSetVar(ncvars, ncvars[ncvarid].bounds, FALSE);
		  cdfSetVar(ncvars, ncvarid, FALSE);
		}
	      else
		Warning(func, "%s - %s", nc_strerror(status), attstring);
	    }
	  else if ( strcmp(attname, "cell_measures") == 0 && atttype == NC_CHAR )
	    {
	      char *pstring, *cell_measures = NULL, *cell_var = NULL;

	      cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);
	      pstring = attstring;

	      while ( isspace((int) *pstring) ) pstring++;
	      cell_measures = pstring;
	      while ( isalnum((int) *pstring) ) pstring++;
	      *pstring++ = 0;
	      while ( isspace((int) *pstring) ) pstring++;
	      cell_var = pstring;
	      while ( ! isspace((int) *pstring) && *pstring != 0 ) pstring++;
	      *pstring++ = 0;
	      /*
	      printf("cell_measures >%s<\n", cell_measures);
	      printf("cell_var >%s<\n", cell_var);
	      */
	      if ( memcmp(cell_measures, "area", 4) == 0 )
		{
		  int status;
		  int nc_cell_id;

		  status = nc_inq_varid(fileID, cell_var, &nc_cell_id);
		  if ( status == NC_NOERR )
		    {
		      ncvars[ncvarid].cellarea = nc_cell_id;
		      /* ncvars[nc_cell_id].isvar = UNDEFID; */
		      cdfSetVar(ncvars, nc_cell_id, FALSE);
		    }
		  else
		    Warning(func, "%s - %s", nc_strerror(status), cell_var);
		}
	      else
		{
		  Warning(func, "%s has unexpected contents: %s", attname, cell_measures);
		}
	      cdfSetVar(ncvars, ncvarid, TRUE);
	    }
	  /*
	  else if ( strcmp(attname, "coordinates") == 0 )
	    {
	      char *pstring, *xvarname = NULL, *yvarname = NULL;
	      
	      cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);
	      pstring = attstring;

	      while ( isspace((int) *pstring) ) pstring++;
	      xvarname = pstring;
	      while ( isgraph((int) *pstring) ) pstring++;
	      *pstring++ = 0;
	      while ( isspace((int) *pstring) ) pstring++;
	      yvarname = pstring;
	      while ( isgraph((int) *pstring) ) pstring++;
	      *pstring++ = 0;

	      cdf_inq_varid(fileID, xvarname, &ncvars[ncvarid].xvarid);
	      cdf_inq_varid(fileID, yvarname, &ncvars[ncvarid].yvarid);

	      cdfSetVar(ncvars, ncvars[ncvarid].xvarid, FALSE);
	      cdfSetVar(ncvars, ncvars[ncvarid].yvarid, FALSE);
	      cdfSetVar(ncvars, ncvarid, TRUE);
	    }
	  */
	  else if ( strcmp(attname, "associate")  == 0 || 
		    strcmp(attname, "coordinates") == 0 )
	    {
	      int status;
	      char *pstring, *varname = NULL;
	      int lstop = FALSE;
	      int dimvarid;
	      extern int cdiIgnoreAttCoordinates;
	      
	      cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);
	      pstring = attstring;

	      for ( i = 0; i < 4; i++ )
		{
		  while ( isspace((int) *pstring) ) pstring++;
		  if ( *pstring == 0 ) break;
		  varname = pstring;
		  while ( !isspace((int) *pstring) && *pstring != 0 ) pstring++;
		  if ( *pstring == 0 ) lstop = TRUE;
		  *pstring++ = 0;

		  status = nc_inq_varid(fileID, varname, &dimvarid);
		  if ( status == NC_NOERR )
		    {
		      cdfSetVar(ncvars, dimvarid, FALSE);
		      if ( cdiIgnoreAttCoordinates == FALSE )
			{
			  ncvars[ncvarid].coordvarids[i] = dimvarid;
			  ncvars[ncvarid].ncoordvars++;
			}
		    }
		  else
		    Warning(func, "%s - %s", nc_strerror(status), varname);

		  if ( lstop ) break;
		}

	      cdfSetVar(ncvars, ncvarid, TRUE);
	    }
	  else if ( strcmp(attname, "grid_mapping") == 0 && atttype == NC_CHAR )
	    {
	      int status;
	      int nc_gmap_id;
	      
	      cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);

	      status = nc_inq_varid(fileID, attstring, &nc_gmap_id);
	      if ( status == NC_NOERR )
		{
		  ncvars[ncvarid].gmapid = nc_gmap_id;
		  cdfSetVar(ncvars, ncvars[ncvarid].gmapid, FALSE);
		}
	      else
		Warning(func, "%s - %s", nc_strerror(status), attstring);

	      cdfSetVar(ncvars, ncvarid, TRUE);
	    }
	  else if ( strcmp(attname, "positive") == 0 && atttype == NC_CHAR )
	    {	      
	      cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);
	      strtolower(attstring);

	      if    ( memcmp(attstring, "down", 4) == 0 ) ncvars[ncvarid].positive = -1;
	      else if ( memcmp(attstring, "up", 2) == 0 ) ncvars[ncvarid].positive = 1;

	      if ( ncvars[ncvarid].ndims == 1 )
		{
		  cdfSetVar(ncvars, ncvarid, FALSE);
		  cdfSetDim(ncvars, ncvarid, 0, Z_AXIS);
		  ncdims[ncvars[ncvarid].dimids[0]].dimtype = Z_AXIS;
		}
	    }
	  else if ( strcmp(attname, "_FillValue") == 0 || 
		    strcmp(attname, "missing_value") == 0 )
	    {
	      if ( atttype != NC_CHAR )
		{
		  cdfGetAttDouble(fileID, ncvarid, attname, 1, &ncvars[ncvarid].missval);
		  ncvars[ncvarid].defmiss = TRUE;
		  /* cdfSetVar(ncvars, ncvarid, TRUE); */
		}
	    }
	  else if ( strcmp(attname, "cdi") == 0 )
	    {	      
	      if ( atttype == NC_CHAR )
		{
		  cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);
		  strtolower(attstring);

		  if ( memcmp(attstring, "ignore", 6) == 0 )
		    {
		      ncvars[ncvarid].ignore = TRUE;
		      cdfSetVar(ncvars, ncvarid, FALSE);
		    }
		}
	    }
	  else if ( strcmp(attname, "axis") == 0 && atttype == NC_CHAR )
	    {
	      cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);
	      /* don't check attlen anymore because the meaning changed from COARDS to CF */
	      /*
	      if ( (int) attlen != nvdims )
		{
		  if ( (int)(attlen-1) == nvdims && attstring[attlen] == 0 ) attlen--;
		  else
		    {
		      if ( nvdims > 0 )
			Warning(func, "axis attribute length %d does not match nvdim %d for %s",
				(int) attlen, nvdims, name);
		      if ( nvdims > 0 )
			{
			  fprintf(stderr, "attlen %d %d %d\n", (int) strlen(attstring), (int) attlen, nvdims);
			  for ( i = 0; i < (int)attlen; i++ )
			    fprintf(stderr, "       %d %d %c\n", i, (int) attstring[i], attstring[i]);
			}
		    }
		}
	      else
	      */
		{
		  while ( attlen-- )
		    {
		      if ( tolower((int) attstring[attlen]) == 't' )
			{
			  if ( attlen != 0 )
			    Warning(func, "axis attribute 't' not on first position");
			  cdfSetDim(ncvars, ncvarid, attlen, T_AXIS);
			}
		      else if ( tolower((int) attstring[attlen]) == 'z' )
			{
			  ncvars[ncvarid].zdim = dimidsp[attlen];
			  cdfSetDim(ncvars, ncvarid, attlen, Z_AXIS);

			  if ( ncvars[ncvarid].ndims == 1 )
			    {
			      cdfSetVar(ncvars, ncvarid, FALSE);
			      ncdims[ncvars[ncvarid].dimids[0]].dimtype = Z_AXIS;
			    }
			}
		      else if ( tolower((int) attstring[attlen]) == 'y' )
			{
			  ncvars[ncvarid].ydim = dimidsp[attlen];
			  cdfSetDim(ncvars, ncvarid, attlen, Y_AXIS);
			}
		      else if ( tolower((int) attstring[attlen]) == 'x' )
			{
			  ncvars[ncvarid].xdim = dimidsp[attlen];
			  cdfSetDim(ncvars, ncvarid, attlen, X_AXIS);
			}
		    }
		}
	    }
	  else
	    {
	      if ( ncvars[ncvarid].natts == 0 )
		ncvars[ncvarid].atts = (int *) malloc(nvatts*sizeof(int));

	      ncvars[ncvarid].atts[ncvars[ncvarid].natts++] = iatt;
	      /*
	      int attrint;
	      double attrflt;
	      nc_type attrtype;
	      cdf_inq_attlen(fileID, ncvarid, attname, &attlen);
	      cdf_inq_atttype(fileID, ncvarid, attname, &attrtype);
	      if ( attlen == 1 && (attrtype == NC_INT || attrtype == NC_SHORT) )
		{
		  cdfGetAttInt(fileID, ncvarid, attname, 1, &attrint);
		  printf("int: %s.%s = %d\n", ncvars[ncvarid].name, attname, attrint);
		}
	      else if ( attlen == 1 && (attrtype == NC_FLOAT || attrtype == NC_DOUBLE) )
		{
		  cdfGetAttDouble(fileID, ncvarid, attname, 1, &attrflt);
		  printf("flt: %s.%s = %g\n", ncvars[ncvarid].name, attname, attrflt);
		}
	      else if ( attrtype == NC_CHAR )
		{
		  cdfGetAttText(fileID, ncvarid, attname, attstringlen-1, attstring);
		  attstring[attlen] = 0;
		  printf("txt: %s.%s = %s\n", ncvars[ncvarid].name, attname, attstring);
		}
	      else
		printf("att: %s.%s = unknown\n", ncvars[ncvarid].name, attname);
	      */
	    }
	}
    }
}
#endif

static
void setDimType(int nvars, NCVAR *ncvars, NCDIM *ncdims)
{
  static char func[] = "setDimType";
  int ndims;
  int ncvarid, ncdimid;
  int i;

  for ( ncvarid = 0; ncvarid < nvars; ncvarid++ )
    {
      if ( ncvars[ncvarid].isvar == TRUE )
	{
	  int lxdim = 0, lydim = 0, lzdim = 0, ltdim = 0;
	  ndims = ncvars[ncvarid].ndims;
	  for ( i = 0; i < ndims; i++ )
	    {
	      ncdimid = ncvars[ncvarid].dimids[i];
	      if      ( ncdims[ncdimid].dimtype == X_AXIS ) cdfSetDim(ncvars, ncvarid, i, X_AXIS);
	      else if ( ncdims[ncdimid].dimtype == Y_AXIS ) cdfSetDim(ncvars, ncvarid, i, Y_AXIS);
	      else if ( ncdims[ncdimid].dimtype == Z_AXIS ) cdfSetDim(ncvars, ncvarid, i, Z_AXIS);
	      else if ( ncdims[ncdimid].dimtype == T_AXIS ) cdfSetDim(ncvars, ncvarid, i, T_AXIS);
	    }

	  if ( CDI_Debug )
	    {
	      Message(func, "var %d %s", ncvarid, ncvars[ncvarid].name);
	      for ( i = 0; i < ndims; i++ )
		printf("  dim %d type %d  ", i, ncvars[ncvarid].dimtype[i]);
	      printf("\n");
	    }

	  for ( i = 0; i < ndims; i++ )
	    {
	      if      ( ncvars[ncvarid].dimtype[i] == X_AXIS ) lxdim = TRUE;
	      else if ( ncvars[ncvarid].dimtype[i] == Y_AXIS ) lydim = TRUE;
	      else if ( ncvars[ncvarid].dimtype[i] == Z_AXIS ) lzdim = TRUE;
	      else if ( ncvars[ncvarid].dimtype[i] == T_AXIS ) ltdim = TRUE;
	    }

	  for ( i = ndims-1; i >= 0; i-- )
	    {
	      if ( ncvars[ncvarid].dimtype[i] == -1 )
		{
		  /*
		  printf("undef dim: %d %d %d %d %d\n", i, lxdim, lydim, lzdim, ltdim);
		  */
		  if ( lxdim == FALSE )
		    {
		      cdfSetDim(ncvars, ncvarid, i, X_AXIS);
		      lxdim = TRUE;
		    }
		  else if ( lydim == FALSE && ncvars[ncvarid].gridtype != GRID_CELL )
		    {
		      cdfSetDim(ncvars, ncvarid, i, Y_AXIS);
		      lydim = TRUE;
		    }
		  else if ( lzdim == FALSE )
		    {
		      cdfSetDim(ncvars, ncvarid, i, Z_AXIS);
		      lzdim = TRUE;
		    }
		}
	    }	    	  
	}
    }
}


int cdfInqContents(int streamID)
{
#if  defined  (HAVE_LIBNETCDF)
  static char func[] = "cdfInqContents";
  int ndims, nvars, ngatts, unlimdimid;
  int varID, ncvarid, ncvarid2;
  int ncdimid;
  int varID1;
  int fileID;
  int nvatts;
  nc_type xtype;
  size_t size = 0, xsize, ysize;
  size_t ntsteps;
  int timedimid = -1;
  int *varids;
  int nvarids;
  size_t attlen;
  int  ilev;
  char name[256];
  char attname[256];
  const int attstringlen = 8192; char attstring[8192];
  char *pname, *plongname, *punits;
  double datt;
  int iatt, timehasunits = FALSE;
  int time_has_bounds = FALSE;
  size_t len;
  int nc_nvars;
  int nvcth_id = UNDEFID, vcta_id = UNDEFID, vctb_id = UNDEFID;
  grid_t grid;
  int gridindex;
  int zaxisindex;
  size_t vctsize = 0;
  int tableID;
  double *vct = NULL;
  int instID  = UNDEFID;
  int modelID = UNDEFID;
  int code;
  int taxisID;
  int i;
  int nbdims;
  size_t nvertex;
  int zprec;
  int calendar = UNDEFID;
  NCDIM *ncdims;
  NCVAR *ncvars;
  int vlistID;
  stream_t *streamptr;
  int format = 0;
  int ucla_les = FALSE;

  streamptr = stream_to_pointer(streamID);
  
  stream_check_ptr(func, streamptr);

  vlistID = streamInqVlist(streamID);
  fileID  = streamInqFileID(streamID);

  if ( CDI_Debug )
    Message(func, "streamID = %d, fileID = %d", streamID, fileID);

#if  defined  (NC_NETCDF4)
  nc_inq_format(fileID, &format);
#endif

  cdf_inq(fileID, &ndims , &nvars, &ngatts, &unlimdimid);

  /* alloc ncdims */
  if ( ndims > 0 )
    ncdims = (NCDIM *) malloc(ndims*sizeof(NCDIM));
  else
    {
      Warning(func, "ndims = %d", ndims);
      return (CDI_EUFSTRUCT);
    }
  
  /* alloc ncvars */
  if ( nvars > 0 )
    ncvars = (NCVAR *) malloc(nvars*sizeof(NCVAR));
  else
    {
      Warning(func, "nvars = %d", nvars);
      return (CDI_EUFSTRUCT);
    }

  init_ncdims(ndims, ncdims);
  init_ncvars(nvars, ncvars);

  /* read global attributtes*/
  for ( iatt = 0; iatt < ngatts; iatt++ )
    {
      cdf_inq_attname(fileID, NC_GLOBAL, iatt, attname);
      cdf_inq_atttype(fileID, NC_GLOBAL, attname, &xtype);
      cdf_inq_attlen(fileID, NC_GLOBAL, attname, &attlen);

      if ( xtype == NC_CHAR )
	{
	  cdfGetAttText(fileID, NC_GLOBAL, attname, attstringlen-1, attstring);
	  attstring[attlen+1] = 0;

	  if ( attlen > 0 && attstring[0] != 0 )
	    {
	      if ( strcmp(attname, "history") == 0 )
		{
		  streamptr->historyID = iatt;
		}
	      else if ( strcmp(attname, "institution") == 0 )
		{
		  instID = institutInq(0, 0, NULL, attstring);
		  if ( instID == UNDEFID )
		    instID = institutDef(0, 0, NULL, attstring);
		}
	      else if ( strcmp(attname, "source") == 0 )
		{
		  modelID = modelInq(-1, 0, attstring);
		}
	      else if ( strcmp(attname, "Source") == 0 )
		{
		  if ( strncmp(attstring, "UCLA-LES", 8) == 0 )
		    ucla_les = TRUE;
		}
	      /*
	      else if ( strcmp(attname, "Conventions") == 0 )
		{
		}
	      */
	      else if ( strcmp(attname, "CDI") == 0 )
		{
		}
	      else if ( strcmp(attname, "CDO") == 0 )
		{
		}
	      else
		{
		  vlistDefAttTxt(vlistID, CDI_GLOBAL, attname, (int)attlen, attstring);
		}
	    }
	}
      else if ( xtype == NC_INT || xtype == NC_SHORT )
	{
	  int *attint;
	  attint = (int *) malloc(attlen*sizeof(int));
	  cdfGetAttInt(fileID, NC_GLOBAL, attname, attlen, attint);
	  vlistDefAttInt(vlistID, CDI_GLOBAL, attname, (int)attlen, attint);
	  free(attint);
	}
      else if ( xtype == NC_FLOAT || xtype == NC_DOUBLE )
	{
	  double *attflt;
	  attflt = (double *) malloc(attlen*sizeof(double));
	  cdfGetAttDouble(fileID, NC_GLOBAL, attname, attlen, attflt);
	  vlistDefAttFlt(vlistID, CDI_GLOBAL, attname, (int)attlen, attflt);
	  free(attflt);
	}
    }

  /* find time dim */
  if ( unlimdimid >= 0 )
    timedimid = unlimdimid;
  else
    timedimid = cdfTimeDimID(fileID, ndims, nvars);

  streamptr->basetime.ncdimid = timedimid;

  if ( timedimid != UNDEFID )
    cdf_inq_dimlen(fileID, timedimid, &ntsteps);
  else
    ntsteps = 0;

  streamptr->ntsteps = ntsteps;

  if ( CDI_Debug )
    Message(func, "time dimid = %d", streamptr->basetime.ncdimid);

  /* read ncdims */
  for ( ncdimid = 0; ncdimid < ndims; ncdimid++ )
    {
      cdf_inq_dimlen(fileID, ncdimid, &ncdims[ncdimid].len);
      cdf_inq_dimname(fileID, ncdimid, ncdims[ncdimid].name);
      if ( timedimid == ncdimid )
	ncdims[ncdimid].dimtype = T_AXIS;
    }


  /* scan var attributes */
  scanVarAttributes(fileID, nvars, ncvars, ncdims, timedimid, modelID, format);


  if ( CDI_Debug ) printNCvars(ncvars, nvars);

  /* find coordinate vars */
  for ( ncdimid = 0; ncdimid < ndims; ncdimid++ )
    {
      for ( ncvarid = 0; ncvarid < nvars; ncvarid++ )
	{
	  if ( ncvars[ncvarid].ndims == 1 )
	    {
	      if ( timedimid != UNDEFID && timedimid == ncvars[ncvarid].dimids[0] )
		{
		  if ( ncvars[ncvarid].isvar != FALSE ) cdfSetVar(ncvars, ncvarid, TRUE);
		}
	      else
		{
		  if ( ncvars[ncvarid].isvar != TRUE ) cdfSetVar(ncvars, ncvarid, FALSE);
		}
	      // if ( ncvars[ncvarid].isvar != TRUE ) cdfSetVar(ncvars, ncvarid, FALSE);

	      if ( ncdimid == ncvars[ncvarid].dimids[0] && ncdims[ncdimid].ncvarid == UNDEFID )
		if ( strcmp(ncvars[ncvarid].name, ncdims[ncdimid].name) == 0 )
		  {
		    ncdims[ncdimid].ncvarid = ncvarid;
		    ncvars[ncvarid].isvar = FALSE;
		  }
	    }
	}
    }

  /* find time vars */
  if ( timedimid != UNDEFID )
    {
      int ltimevar = FALSE;

      if ( ncdims[timedimid].ncvarid != UNDEFID )
	{
	  streamptr->basetime.ncvarid = ncdims[timedimid].ncvarid;
	  ltimevar = TRUE;
	}

      for ( ncvarid = 0; ncvarid < nvars; ncvarid++ )
	if ( ncvarid != streamptr->basetime.ncvarid &&
	     ncvars[ncvarid].ndims == 1 &&
	     timedimid == ncvars[ncvarid].dimids[0] &&
	     ncvars[ncvarid].xtype != NC_CHAR &&
	     isTimeUnits(ncvars[ncvarid].units) )
	  {
	    ncvars[ncvarid].isvar = FALSE;

	    if ( !ltimevar )
	      {
		streamptr->basetime.ncvarid = ncvarid;
		ltimevar = TRUE;
		if ( CDI_Debug ) 
		  fprintf(stderr, "timevar %s\n", ncvars[ncvarid].name);
	      }
	    else
	      {
		if ( CDI_Debug )
		  fprintf(stderr, "skip timevar %s\n", ncvars[ncvarid].name);
	      }
	  }

      /* time varID */
      ncvarid = streamptr->basetime.ncvarid;

      if ( ncvarid == UNDEFID )
	Warning(func, "time variable not found!");
      else
	{
	  if ( ncvars[ncvarid].units[0] != 0 )
	    timehasunits = TRUE;

	  if ( ncvars[ncvarid].bounds != UNDEFID )
	    {
	      nbdims = ncvars[ncvars[ncvarid].bounds].ndims;
	      if ( nbdims == 2 )
		{
		  cdf_inq_dimlen(fileID, ncvars[ncvars[ncvarid].bounds].dimids[nbdims-1], &len);
		  if ( (int)len == 2 && timedimid == ncvars[ncvars[ncvarid].bounds].dimids[0] )
		    {
		      time_has_bounds = TRUE;
		      streamptr->basetime.ncvarboundsid = ncvars[ncvarid].bounds;
		    }
		}
	    }
	}
    }

  /* check ncvars */
  for ( ncvarid = 0; ncvarid < nvars; ncvarid++ )
    {
      if ( timedimid != UNDEFID )
	if ( ncvars[ncvarid].isvar == -1 &&
	     ncvars[ncvarid].ndims > 1   &&
	     timedimid == ncvars[ncvarid].dimids[0] )
	  cdfSetVar(ncvars, ncvarid, TRUE);

      if ( ncvars[ncvarid].isvar == -1 && ncvars[ncvarid].ndims == 0 )
	cdfSetVar(ncvars, ncvarid, FALSE);

      if ( ncvars[ncvarid].isvar == -1 && ncvars[ncvarid].ndims > 1 )
	cdfSetVar(ncvars, ncvarid, TRUE);
	  
      if ( ncvars[ncvarid].isvar == -1 )
	{
	  ncvars[ncvarid].isvar = 0;
	  Warning(func, "Variable %s has unknown type, skipped!", ncvars[ncvarid].name);
	}

      if ( ncvars[ncvarid].ndims > 4 )
	{
	  ncvars[ncvarid].isvar = 0;
	  Warning(func, "%d dimensional variables unsupported. Skip variable %s",
		ncvars[ncvarid].ndims, ncvars[ncvarid].name);
	}

      if ( ncvars[ncvarid].xtype == NC_CHAR )
	ncvars[ncvarid].isvar = 0;
    }

  /* verify coordinate vars (dimname == varname) */
  for ( ncdimid = 0; ncdimid < ndims; ncdimid++ )
    {	      
      ncvarid = ncdims[ncdimid].ncvarid;
      if ( ncvarid != -1 )
	{
	  if ( ncvars[ncvarid].dimids[0] == timedimid )
	    {
	      ncdims[ncdimid].dimtype = T_AXIS;
	      continue;
	    }

	  if ( ncvars[ncvarid].longname[0] != 0 )
	    {
	      if ( memcmp(ncvars[ncvarid].longname, "Longitude", 9) == 0 ||
		   memcmp(ncvars[ncvarid].longname, "longitude", 9) == 0 )
		{
		  ncvars[ncvarid].islon = TRUE;
		  cdfSetVar(ncvars, ncvarid, FALSE);
		  cdfSetDim(ncvars, ncvarid, 0, X_AXIS);
		  ncdims[ncdimid].dimtype = X_AXIS;
		  continue;
		}
	      else if ( memcmp(ncvars[ncvarid].longname, "Latitude", 8) == 0 || 
			memcmp(ncvars[ncvarid].longname, "latitude", 8) == 0 )
		{
		  ncvars[ncvarid].islat = TRUE;
		  cdfSetVar(ncvars, ncvarid, FALSE);
		  cdfSetDim(ncvars, ncvarid, 0, Y_AXIS);
		  ncdims[ncdimid].dimtype = Y_AXIS;
		  continue;
		}
	    }

	  if ( ncvars[ncvarid].units[0] != 0 )
	    {    
	      if ( isLonAxis(ncvars[ncvarid].units, ncvars[ncvarid].stdname) )
		{
		  ncvars[ncvarid].islon = TRUE;
		  cdfSetVar(ncvars, ncvarid, FALSE);
		  cdfSetDim(ncvars, ncvarid, 0, X_AXIS);
		  ncdims[ncdimid].dimtype = X_AXIS;
		}
	      else if ( isLatAxis(ncvars[ncvarid].units, ncvars[ncvarid].stdname) )
		{
		  ncvars[ncvarid].islat = TRUE;
		  cdfSetVar(ncvars, ncvarid, FALSE);
		  cdfSetDim(ncvars, ncvarid, 0, Y_AXIS);
		  ncdims[ncdimid].dimtype = Y_AXIS;
		}
	      else if ( unitsIsPressure(ncvars[ncvarid].units) )
		{
		  ncvars[ncvarid].zaxistype = ZAXIS_PRESSURE;
		}
	      else if ( strcmp(ncvars[ncvarid].units, "level") == 0 )
		{
		  if      ( strcmp(ncvars[ncvarid].longname, "hybrid level at layer midpoints") == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_HYBRID;
		  else if ( memcmp(ncvars[ncvarid].longname, "hybrid level at midpoints", 25) == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_HYBRID;
		  else if ( strcmp(ncvars[ncvarid].longname, "hybrid level at layer interfaces") == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_HYBRID_HALF;
		  else if ( memcmp(ncvars[ncvarid].longname, "hybrid level at interfaces", 26) == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_HYBRID_HALF;
		  else
		    ncvars[ncvarid].zaxistype = ZAXIS_GENERIC;
		}
	      else if ( strcmp(ncvars[ncvarid].units, "cm")  == 0 )
		{
		  if ( strcmp(ncvars[ncvarid].longname, "depth below land")         == 0 ||
		       strcmp(ncvars[ncvarid].longname, "depth_below_land")         == 0 ||
		       strcmp(ncvars[ncvarid].longname, "levels below the surface") == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_DEPTH_BELOW_LAND;
		}
	      else if ( strcmp(ncvars[ncvarid].units, "m")   == 0 )
		{
		  if ( strcmp(ncvars[ncvarid].longname, "depth_below_sea") == 0 ||
		       strcmp(ncvars[ncvarid].longname, "depth below sea") == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_DEPTH_BELOW_SEA;
		  else if ( strcmp(ncvars[ncvarid].longname, "height") == 0 ||
			    strcmp(ncvars[ncvarid].longname, "height above the surface") == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_HEIGHT;
		}
	    }

	  if ( ncvars[ncvarid].zaxistype != UNDEFID )
	    {
	      cdfSetVar(ncvars, ncvarid, FALSE);
	      cdfSetDim(ncvars, ncvarid, 0, Z_AXIS);
	      ncdims[ncdimid].dimtype = Z_AXIS;
	    }
	}
    }

  /* verify coordinate vars */
  for ( ncvarid = 0; ncvarid < nvars; ncvarid++ )
    {
      if ( ncvars[ncvarid].isvar == 0 )
	{
	  /* not needed anymore for rotated grids */
	  if ( ncvars[ncvarid].longname[0] != 0 )
	    {
	      if ( memcmp(ncvars[ncvarid].longname, "Longitude", 9) == 0 ||
		   memcmp(ncvars[ncvarid].longname, "longitude", 9) == 0 )
		{
		  ncvars[ncvarid].islon = TRUE;
		  continue;
		}
	      else if ( memcmp(ncvars[ncvarid].longname, "Latitude", 8) == 0 || 
			memcmp(ncvars[ncvarid].longname, "latitude", 8) == 0 )
		{
		  ncvars[ncvarid].islat = TRUE;
		  continue;
		}
	    }

	  if ( ncvars[ncvarid].units[0] != 0 )
	    {
	      if ( isLonAxis(ncvars[ncvarid].units, ncvars[ncvarid].stdname) )
		{
		  ncvars[ncvarid].islon = TRUE;
		  continue;
		}
	      else if ( isLatAxis(ncvars[ncvarid].units, ncvars[ncvarid].stdname) )
		{
		  ncvars[ncvarid].islat = TRUE;
		  continue;
		}
	      else if ( unitsIsPressure(ncvars[ncvarid].units) )
		{
		  ncvars[ncvarid].zaxistype = ZAXIS_PRESSURE;
		  continue;
		}
	      else if ( strcmp(ncvars[ncvarid].units, "level") == 0 )
		{
		  if      ( strcmp(ncvars[ncvarid].longname, "hybrid level at layer midpoints") == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_HYBRID;
		  else if ( memcmp(ncvars[ncvarid].longname, "hybrid level at midpoints", 25) == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_HYBRID;
		  else if ( strcmp(ncvars[ncvarid].longname, "hybrid level at layer interfaces") == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_HYBRID_HALF;
		  else if ( memcmp(ncvars[ncvarid].longname, "hybrid level at interfaces", 26) == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_HYBRID_HALF;
		  else
		    ncvars[ncvarid].zaxistype = ZAXIS_GENERIC;
		  continue;
		}
	      else if ( strcmp(ncvars[ncvarid].units, "cm")  == 0 )
		{
		  if ( strcmp(ncvars[ncvarid].longname, "depth below land")         == 0 ||
		       strcmp(ncvars[ncvarid].longname, "depth_below_land")         == 0 ||
		       strcmp(ncvars[ncvarid].longname, "levels below the surface") == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_DEPTH_BELOW_LAND;
		  continue;
		}
	      else if ( strcmp(ncvars[ncvarid].units, "m")   == 0 )
		{
		  if ( strcmp(ncvars[ncvarid].longname, "depth_below_sea") == 0 ||
		       strcmp(ncvars[ncvarid].longname, "depth below sea") == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_DEPTH_BELOW_SEA;
		  else if ( strcmp(ncvars[ncvarid].longname, "height") == 0 ||
			    strcmp(ncvars[ncvarid].longname, "height above the surface") == 0 )
		    ncvars[ncvarid].zaxistype = ZAXIS_HEIGHT;
		  continue;
		}
	    }
	}
    }

  if ( CDI_Debug ) printNCvars(ncvars, nvars);

  if ( ucla_les == TRUE )
    {
      for ( ncdimid = 0; ncdimid < ndims; ncdimid++ )
	{
	  ncvarid = ncdims[ncdimid].ncvarid;
	  if ( ncvarid != -1 )
	    {
	      if ( ncdims[ncdimid].dimtype == UNDEFID && ncvars[ncvarid].units[0] == 'm' )
		{
		  if      ( ncvars[ncvarid].name[0] == 'x' ) ncdims[ncdimid].dimtype = X_AXIS;
		  else if ( ncvars[ncvarid].name[0] == 'y' ) ncdims[ncdimid].dimtype = Y_AXIS;
		  else if ( ncvars[ncvarid].name[0] == 'z' ) ncdims[ncdimid].dimtype = Z_AXIS;
		}
	    }
	}
    }
  /*
  for ( ncdimid = 0; ncdimid < ndims; ncdimid++ )
    {
      ncvarid = ncdims[ncdimid].ncvarid;
      if ( ncvarid != -1 )
	{
	  printf("coord var %d %s %s\n", ncvarid, ncvars[ncvarid].name, ncvars[ncvarid].units);
	  if ( ncdims[ncdimid].dimtype == X_AXIS )
	    printf("coord var %d %s is x dim\n", ncvarid, ncvars[ncvarid].name);
	  if ( ncdims[ncdimid].dimtype == Y_AXIS )
	    printf("coord var %d %s is y dim\n", ncvarid, ncvars[ncvarid].name);
	  if ( ncdims[ncdimid].dimtype == Z_AXIS )
	    printf("coord var %d %s is z dim\n", ncvarid, ncvars[ncvarid].name);
	  if ( ncdims[ncdimid].dimtype == T_AXIS )
	    printf("coord var %d %s is t dim\n", ncvarid, ncvars[ncvarid].name);

	  if ( ncvars[ncvarid].islon )
	    printf("coord var %d %s is lon\n", ncvarid, ncvars[ncvarid].name);
	  if ( ncvars[ncvarid].islat )
	    printf("coord var %d %s is lat\n", ncvarid, ncvars[ncvarid].name);
	  if ( ncvars[ncvarid].islev )
	    printf("coord var %d %s is lev\n", ncvarid, ncvars[ncvarid].name);
	}
    }
  */
  /* set dim type */
  setDimType(nvars, ncvars, ncdims);

  /* Set coordinate varids (att: associate)  */
  for ( ncvarid = 0; ncvarid < nvars; ncvarid++ )
    {
      if ( ncvars[ncvarid].isvar == TRUE && ncvars[ncvarid].ncoordvars )
	{
	  /* ndims = ncvars[ncvarid].ndims; */
	  ndims = ncvars[ncvarid].ncoordvars;
	  for ( i = 0; i < ndims; i++ )
	    {
	      if ( ncvars[ncvars[ncvarid].coordvarids[i]].islon )
		ncvars[ncvarid].xvarid = ncvars[ncvarid].coordvarids[i];
	      else if ( ncvars[ncvars[ncvarid].coordvarids[i]].islat )
		ncvars[ncvarid].yvarid = ncvars[ncvarid].coordvarids[i];
	      else if ( ncvars[ncvars[ncvarid].coordvarids[i]].islev )
		ncvars[ncvarid].zvarid = ncvars[ncvarid].coordvarids[i];
	    }
	}
    }
  
  if ( CDI_Debug ) printNCvars(ncvars, nvars);

  /* define grid */
  for ( ncvarid = 0; ncvarid < nvars; ncvarid++ )
    {
      if ( ncvars[ncvarid].isvar && ncvars[ncvarid].gridID == UNDEFID )
	{
	  int xdimid = -1, ydimid = -1;
	  int xvarid = -1, yvarid = -1;
	  int islon = 0, islat = 0;
	  double xinc = 0, yinc = 0;

	  xsize = 0;
	  ysize = 0;

	  ndims = ncvars[ncvarid].ndims;
	  for ( i = 0; i < ndims; i++ )
	    {
	      if ( ncvars[ncvarid].dimtype[i] == X_AXIS )
		xdimid = ncvars[ncvarid].dimids[i];
	      else if ( ncvars[ncvarid].dimtype[i] == Y_AXIS )
		ydimid = ncvars[ncvarid].dimids[i];
	    }

	  if ( ncvars[ncvarid].xvarid != UNDEFID )
	    xvarid = ncvars[ncvarid].xvarid;
	  else if ( xdimid != UNDEFID )
	    xvarid = ncdims[xdimid].ncvarid;

	  if ( ncvars[ncvarid].yvarid != UNDEFID )
	    yvarid = ncvars[ncvarid].yvarid;
	  else if ( ydimid != UNDEFID )
	    yvarid = ncdims[ydimid].ncvarid;

	  /*
	  if ( xdimid != UNDEFID )
	    xvarid = ncdims[xdimid].ncvarid;
	  if ( xvarid == UNDEFID && ncvars[ncvarid].xvarid != UNDEFID )
	    xvarid = ncvars[ncvarid].xvarid;

	  if ( ydimid != UNDEFID )
	    yvarid = ncdims[ydimid].ncvarid;
	  if ( yvarid == UNDEFID && ncvars[ncvarid].yvarid != UNDEFID )
	    yvarid = ncvars[ncvarid].yvarid;
	  */

	  if ( xdimid != UNDEFID )
	    cdf_inq_dimlen(fileID, xdimid, &xsize);

	  if ( ydimid != UNDEFID )
	    cdf_inq_dimlen(fileID, ydimid, &ysize);

	  if ( ydimid == UNDEFID && yvarid != UNDEFID )
	    {
	      if ( ncvars[yvarid].ndims == 1 )
		{
		  ydimid = ncvars[yvarid].dimids[0];
		  cdf_inq_dimlen(fileID, ydimid, &ysize);
		}   
	    }

	  if ( ncvars[ncvarid].gridtype == UNDEFID || ncvars[ncvarid].gridtype == GRID_GENERIC )
	    if ( ydimid == xdimid ) ncvars[ncvarid].gridtype = GRID_CELL;

	  memset(&grid, 0, sizeof(grid_t));

	  grid.prec  = DATATYPE_FLT64;
	  grid.trunc = ncvars[ncvarid].truncation;
	  
	  if ( ncvars[ncvarid].gridtype == GRID_TRAJECTORY )
	    {
	      if ( ncvars[ncvarid].xvarid == UNDEFID )
		Error(func, "Longitude coordinate undefined for %s!", name);
	      if ( ncvars[ncvarid].yvarid == UNDEFID )
		Error(func, "Latitude coordinate undefined for %s!", name);
	    }
	  else
	    {
	      if ( xvarid != UNDEFID && yvarid != UNDEFID )
		{
		  if ( ncvars[xvarid].ndims != ncvars[yvarid].ndims )
		    {
		      Warning(func, "Inconsistent grid structure for variable %s!",
			      ncvars[ncvarid].name);
		      ncvars[ncvarid].xvarid = UNDEFID;
		      ncvars[ncvarid].yvarid = UNDEFID;
		      xvarid = UNDEFID;
		      yvarid = UNDEFID;
		    }

		  if ( ncvars[xvarid].ndims > 2 || ncvars[yvarid].ndims > 2 )
		    {                           
		      if ( ncvars[xvarid].ndims == 3 && ncvars[xvarid].dimids[0] == timedimid &&
			   ncvars[yvarid].ndims == 3 && ncvars[yvarid].dimids[0] == timedimid )
			{
			}
		      else
			{
			  Warning(func, "Unsupported grid structure for variable %s (grid dims > 2)!",
				  ncvars[ncvarid].name);
			  ncvars[ncvarid].xvarid = UNDEFID;
			  ncvars[ncvarid].yvarid = UNDEFID;
			  xvarid = UNDEFID;
			  yvarid = UNDEFID;
			}
		    }
		}

	      if ( xvarid != UNDEFID )
		{
		  islon = ncvars[xvarid].islon;
		  ndims = ncvars[xvarid].ndims;
		  if ( ndims == 2 || ndims == 3 )
		    {
		      ncvars[ncvarid].gridtype = GRID_CURVILINEAR;
		      size = xsize*ysize;
		      /* Check size of 2 dimensional coordinate variables */
		      {
			int dimid;
			size_t dimsize1, dimsize2;
			dimid = ncvars[xvarid].dimids[ndims-2];
			cdf_inq_dimlen(fileID, dimid, &dimsize1);
			dimid = ncvars[xvarid].dimids[ndims-1];
			cdf_inq_dimlen(fileID, dimid, &dimsize2);
			if ( dimsize1*dimsize2 != size )
			  {
			    Warning(func, "Variable %s has unsupported array structure, skipped!",
				    ncvars[ncvarid].name);
			    ncvars[ncvarid].isvar = -1;
			    continue;
			  }
		      }
		    }
		  else
		    {
		      size = xsize;
		      /* Check size of 1 dimensional coordinate variables */
		      {
			int dimid;
			size_t dimsize;
			dimid = ncvars[xvarid].dimids[0];
			cdf_inq_dimlen(fileID, dimid, &dimsize);
			if ( dimsize != size )
			  {
			    Warning(func, "Variable %s has unsupported array structure, skipped!",
				    ncvars[ncvarid].name);
			    ncvars[ncvarid].isvar = -1;
			    continue;
			  }
		      }
		    }

		  if ( ncvars[xvarid].xtype == NC_FLOAT ) grid.prec = DATATYPE_FLT32;
		  grid.xvals = (double *) malloc(size*sizeof(double));
		  cdf_get_var_double(fileID, xvarid, grid.xvals);
		  strcpy(grid.xname, ncvars[xvarid].name);
		  strcpy(grid.xlongname, ncvars[xvarid].longname);
		  strcpy(grid.xunits, ncvars[xvarid].units);
		  /* don't change the name !!! */
		  /*
		  if ( (len = strlen(grid.xname)) > 2 )
		    if ( grid.xname[len-2] == '_' && isdigit((int) grid.xname[len-1]) )
		      grid.xname[len-2] = 0;
		  */
		  if ( islon && xsize > 1 )
		    {
		      xinc = fabs(grid.xvals[0] - grid.xvals[1]);
		      for ( i = 2; i < (int) xsize; i++ )
			if ( (fabs(grid.xvals[i-1] - grid.xvals[i]) - xinc) > (xinc/1000) ) break;
		  
		      if ( i < (int) xsize ) xinc = 0;
		    }
		}

	      if ( yvarid != UNDEFID )
		{
		  islat = ncvars[yvarid].islat;
		  ndims = ncvars[yvarid].ndims;
		  if ( ndims == 2 || ndims == 3 )
		    {
		      ncvars[ncvarid].gridtype = GRID_CURVILINEAR;
		      size = xsize*ysize;
		      /* Check size of 2 dimensional coordinate variables */
		      {
			int dimid;
			size_t dimsize1, dimsize2;
			dimid = ncvars[yvarid].dimids[ndims-2];
			cdf_inq_dimlen(fileID, dimid, &dimsize1);
			dimid = ncvars[yvarid].dimids[ndims-1];
			cdf_inq_dimlen(fileID, dimid, &dimsize2);
			if ( dimsize1*dimsize2 != size )
			  {
			    Warning(func, "Variable %s has unsupported array structure, skipped!",
				    ncvars[ncvarid].name);
			    ncvars[ncvarid].isvar = -1;
			    continue;
			  }
		      }
		    }
		  else
		    {
		      if ( (int) ysize == 0 ) size = xsize;
		      else                    size = ysize;

		      /* Check size of 1 dimensional coordinate variables */
		      {
			int dimid;
			size_t dimsize;
			dimid = ncvars[yvarid].dimids[0];
			cdf_inq_dimlen(fileID, dimid, &dimsize);
			if ( dimsize != size )
			  {
			    Warning(func, "Variable %s has unsupported array structure, skipped!",
				    ncvars[ncvarid].name);
			    ncvars[ncvarid].isvar = -1;
			    continue;
			  }
		      }
		    }

		  if ( ncvars[yvarid].xtype == NC_FLOAT ) grid.prec = DATATYPE_FLT32;
		  grid.yvals = (double *) malloc(size*sizeof(double));
		  cdf_get_var_double(fileID, yvarid, grid.yvals);
		  strcpy(grid.yname, ncvars[yvarid].name);
		  strcpy(grid.ylongname, ncvars[yvarid].longname);
		  strcpy(grid.yunits, ncvars[yvarid].units);
		  /* don't change the name !!! */
		  /*
		  if ( (len = strlen(grid.yname)) > 2 )
		    if ( grid.yname[len-2] == '_' && isdigit((int) grid.yname[len-1]) )
		      grid.yname[len-2] = 0;
		  */
		  if ( islon && (int) ysize > 1 )
		    {
		      yinc = fabs(grid.yvals[0] - grid.yvals[1]);
		      for ( i = 2; i < (int) ysize; i++ )
			if ( (fabs(grid.yvals[i-1] - grid.yvals[i]) - yinc) > (yinc/1000) ) break;
		  
		      if ( i < (int) ysize ) yinc = 0;
		    }
		}

	      if      ( (int) ysize == 0 ) size = xsize;
	      else if ( (int) xsize == 0 ) size = ysize;
	      else if ( ncvars[ncvarid].gridtype == GRID_CELL ) size = xsize; 
	      else                         size = xsize*ysize;
	    }

	  if ( ncvars[ncvarid].gridtype == UNDEFID ||
	       ncvars[ncvarid].gridtype == GRID_GENERIC )
	    {
	      if ( islat && islon )
		{
		  if ( isGaussGrid(ysize, yinc, grid.yvals) )
		    ncvars[ncvarid].gridtype = GRID_GAUSSIAN;
		  else
		    ncvars[ncvarid].gridtype = GRID_LONLAT;
		}
	      else if ( islat && !islon && xsize == 0 )
		{
		  if ( isGaussGrid(ysize, yinc, grid.yvals) )
		    ncvars[ncvarid].gridtype = GRID_GAUSSIAN;
		  else
		    ncvars[ncvarid].gridtype = GRID_LONLAT;
		}
	      else if ( islon && !islat && ysize == 0 )
		{
		  ncvars[ncvarid].gridtype = GRID_LONLAT;
		}
	      else
		ncvars[ncvarid].gridtype = GRID_GENERIC;
	    }

	  switch (ncvars[ncvarid].gridtype)
	    {
	    case GRID_GENERIC:
	    case GRID_LONLAT:
	    case GRID_GAUSSIAN:
	    case GRID_CELL:
	    case GRID_CURVILINEAR:
	      {
		grid.size  = size;
		grid.xsize = xsize;
		grid.ysize = ysize;
		if ( xvarid != UNDEFID )
		  {
		    grid.xdef  = 1;
		    if ( ncvars[xvarid].bounds != UNDEFID )
		      {
			nbdims = ncvars[ncvars[xvarid].bounds].ndims;
			if ( nbdims == 2 || nbdims == 3 )
			  {
			    cdf_inq_dimlen(fileID, ncvars[ncvars[xvarid].bounds].dimids[nbdims-1], &nvertex);
			    grid.nvertex = (int) nvertex;
			    grid.xbounds = (double *) malloc(nvertex*size*sizeof(double));
			    cdf_get_var_double(fileID, ncvars[xvarid].bounds, grid.xbounds);
			  }
		      }
		  }
		if ( yvarid != UNDEFID )
		  {
		    grid.ydef  = 1;
		    if ( ncvars[yvarid].bounds != UNDEFID )
		      {
			nbdims = ncvars[ncvars[yvarid].bounds].ndims;
			if ( nbdims == 2 || nbdims == 3 )
			  {
			    cdf_inq_dimlen(fileID, ncvars[ncvars[yvarid].bounds].dimids[nbdims-1], &nvertex);
			    /*
			    if ( nvertex != grid.nvertex )
			      Warning(func, "nvertex problem! nvertex x %d, nvertex y %d",
				      grid.nvertex, (int) nvertex);
			    */
			    grid.ybounds = (double *) malloc(nvertex*size*sizeof(double));
			    cdf_get_var_double(fileID, ncvars[yvarid].bounds, grid.ybounds);
			  }
		      }
		  }

		if ( ncvars[ncvarid].cellarea != UNDEFID )
		  {
		    grid.area = (double *) malloc(size*sizeof(double));
		    cdf_get_var_double(fileID, ncvars[ncvarid].cellarea, grid.area);
		  }

		break;
	      }
	    case GRID_SPECTRAL:
	      {
		grid.size = size;
		break;
	      }
	    case GRID_TRAJECTORY:
	      {
		grid.size = 1;
		break;
	      }
	    }

	  grid.type = ncvars[ncvarid].gridtype;

	  if ( grid.size == 0 )
	    {
	      if ( (ncvars[ncvarid].ndims == 1 && ncvars[ncvarid].dimtype[0] == T_AXIS) ||
		   (ncvars[ncvarid].ndims == 2 && ncvars[ncvarid].dimtype[0] == T_AXIS &&
		    ncvars[ncvarid].dimtype[1] == Z_AXIS) )
		{
		  grid.type  = GRID_GENERIC;
		  grid.size  = 1;
		  grid.xsize = 0;
		  grid.ysize = 0;
		}
	      else
		{
		  Warning(func, "Variable %s has unsupported grid, skipped!", ncvars[ncvarid].name);
		  ncvars[ncvarid].isvar = -1;
		  continue;
		}
	    }

	  if ( ncvars[ncvarid].gmapid >= 0 && ncvars[ncvarid].gridtype != GRID_CURVILINEAR )
	    {
	      cdf_inq_varnatts(fileID, ncvars[ncvarid].gmapid, &nvatts);

	      for ( iatt = 0; iatt < nvatts; iatt++ )
		{
		  cdf_inq_attname(fileID, ncvars[ncvarid].gmapid, iatt, attname);
		  cdf_inq_attlen(fileID, ncvars[ncvarid].gmapid, attname, &attlen);

		  if ( strcmp(attname, "grid_mapping_name") == 0 )
		    {
		      cdfGetAttText(fileID, ncvars[ncvarid].gmapid, attname, attstringlen-1, attstring);
		      strtolower(attstring);

		      if ( strcmp(attstring, "rotated_latitude_longitude") == 0 )
			grid.isRotated = TRUE;
		      else if ( strcmp(attstring, "sinusoidal") == 0 )
			grid.type = GRID_SINUSOIDAL;
		      else if ( strcmp(attstring, "lambert_azimuthal_equal_area") == 0 )
			grid.type = GRID_LAEA;
		      else if ( strcmp(attstring, "lambert_conformal_conic") == 0 )
			grid.type = GRID_LCC2;
		    }
		  else if ( strcmp(attname, "earth_radius") == 0 )
		    {
		      cdfGetAttDouble(fileID, ncvars[ncvarid].gmapid, attname, 1, &datt);
		      grid.laea_a = datt;
		      grid.lcc2_a = datt;
		    }
		  else if ( strcmp(attname, "longitude_of_projection_origin") == 0 )
		    {
		      cdfGetAttDouble(fileID, ncvars[ncvarid].gmapid, attname, 1, &grid.laea_lon_0);
		    }
		  else if ( strcmp(attname, "longitude_of_central_meridian") == 0 )
		    {
		      cdfGetAttDouble(fileID, ncvars[ncvarid].gmapid, attname, 1, &grid.lcc2_lon_0);
		    }
		  else if ( strcmp(attname, "latitude_of_projection_origin") == 0 )
		    {
		      cdfGetAttDouble(fileID, ncvars[ncvarid].gmapid, attname, 1, &datt);
		      grid.laea_lat_0 = datt;
		      grid.lcc2_lat_0 = datt;
		    }
		  else if ( strcmp(attname, "standard_parallel") == 0 )
		    {
		      if ( attlen == 1 )
			{
			  cdfGetAttDouble(fileID, ncvars[ncvarid].gmapid, attname, 1, &datt);
			  grid.lcc2_lat_1 = datt;
			  grid.lcc2_lat_2 = datt;
			}
		      else
			{
			  double datt2[2];
			  cdfGetAttDouble(fileID, ncvars[ncvarid].gmapid, attname, 2, datt2);
			  grid.lcc2_lat_1 = datt2[0];
			  grid.lcc2_lat_2 = datt2[1];
			}
		    }
		  else if ( strcmp(attname, "grid_north_pole_latitude") == 0 )
		    {
		      cdfGet