/***************************************************************************
                    mozilla.h  -  Mozilla Class Definition
                             -------------------
    begin                : Sat Oct 05 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This class implements the Mozilla functionality for read and writing  *
 *   bookmarks.                                                            *
 *                                                                         *
 ***************************************************************************/

#ifndef MOZILLA_H
#define MOZILLA_H

#include "bknode.h"
#include "browserbk.h"

#include <QTextStream>

class Mozilla : public BrowserBk
{
public:
	Mozilla()	{ }
	~Mozilla()	{ }

	virtual bool    AreBookmarksValid(const QString &bookmarks);
	virtual bool    BrowseForBookmarks(const BridgeCfg &cfg, QString &bookmarks, QWidget *parent=0);
	virtual bool	DetectBrowser(const BridgeCfg &cfg, QStringList &paths);
	virtual bool	IsBrowserRunning(void);
	virtual void	readBookmarks(const QString &path, BRWSNUM browserOrd) throw(BkException);
	static	void	saveBookmarks(const QString &path, BkFolder &root, BRWSNUM browserOrd)
						throw(BkException);
	static BrowserBk *classFactory(void);

	virtual BkFolder & root(void) { return m_Root; }

private:
	static  void	saveBookmark(const BkBookmark &bkmark, QTextStream &t, int levels, BRWSNUM browserOrd)
						throw(BkException);
	static  void	saveFolder(BkFolder &folder, QTextStream &t, int levels, BRWSNUM browserOrd)
						throw(BkException);

	BkFolder	m_Root;
};

#endif // end of MOZILLA_H
