[-- template default.template --]
[-- define title=Source Code Roadmap--]
[-- define chapter_title=3. How BookmarkBridge Works --]
[-- define prev_link=compiling_bookmarkbridge_from_source.html --]
[-- define prev_title=Compiling BookmarkBridge From Source --]
[-- define next_link=hacking_bookmarkbridge_source.html --]
[-- define next_title=Hacking BookmarkBridge Source --]

<p>
This section gives a brief overview of the source code for BookmarkBridge.  It describes
each source code file and the important files used for compiling.
</p>

<dl>
	<dt>bknode.cpp</dt>
	<dd>
		This file implements the BkNode, BkBookmark, and BkFolder classes.
		These classes implement the bookmark tree, used to represent the
		bookmarks and folder within each browser.
	</dd>
	<dt>bkutil.cpp</dt>
	<dd>
		This file implements the BkUtil class.  This class implements the
		high-level functionality used to read bookmarks and save bookmarks.
		The code in this class is used by the GUI and by the command-line
		operations.  It depends on several other important classes to
		perform its work.
	</dd>
	<dt>bridgecfg.cpp</dt>
	<dd>
		This file implements the BridgeCfg class.  This class reads and writes
		the configuration file, bridgeconf.xml.  It stores the configuration in
		several public variables and completely hides the configuration file
		itself.
	</dd>
	<dt>browserbk.cpp</dt>
	<dd>
		This file implements the BrowserBk class.  This is an abstract base
		class from which classes for each browser derive.  It includes code to
		combine a browser's bookmarks into the combined bookmark tree, and to
		detect and resolve differences between the bookmarks of different
		browsers.  It implements several pure virtual functions that interface
		to browser specific code.  This allows BookmarkBridge to support many
		different browsers with no changes to the core program logic.
	</dd>
	<dt>browserlist.cpp</dt>
	<dd>
		This file is a place-holder for a global array listing each browser
		supported by BookmarkBridge.  To implement support for a new browser,
		simply derive a class from BrowserBk and add an entry to the list in
		this file.
	</dd>
	<dt>dlgabout.cpp</dt>
	<dd>
		This file implements the About dialog box.
	</dd>
	<dt>dlgaddbrowser.cpp</dt>
	<dd>
		This file implements the Add Browser dialog box.  This is a dialog
		presented to the user when they want to add a new browser configuration
		by clicking on the Add button in the Settings window.
	</dd>
	<dt>dlgbrowsers.cpp</dt>
	<dd>
		This file implements the Browsers dialog box.  This is a dialog
		presented to the user when they want to add a configured browser as a
		source or destination.
	</dd>
	<dt>dlghelp.cpp</dt>
	<dd>
		This file implements the help dialog box.
	</dd>
	<dt>dlgmain.cpp</dt>
	<dd>
		This file implements the main dialog window of BookmarkBridge.
	</dd>
	<dt>dlgsettings.cpp</dt>
	<dd>
		This file implements the Setting dialog box.
	</dd>
	<dt>dlgviewbookmarks.cpp</dt>
	<dd>
		This file implements the View Bookmarks dialog box.
	</dd>
	<dt>iexplore.cpp</dt>
	<dd>
		This file implements Internet Explorer functionality.
	</dd>
	<dt>main.cpp</dt>
	<dd>
		This file contains the main() function entry point.  It
		parses command-line options and launches the main dialog box.
	</dd>
	<dt>mozilla.cpp</dt>
	<dd>
		This file implements Mozilla/Netscape functionality.
	</dd>
	<dt>xbelread.cpp</dt>
	<dd>
		This file reads the XBEL file, containing the bookmark tree.
	</dd>
	<dt>xbelwrite.cpp</dt>
	<dd>
		This file writes the XBEL file, containing the bookmark tree.
	</dd>
	<dt>xgetopt.cpp</dt>
	<dd>
		This file, used only with Windows, implements the getopt()
		function.
	</dd>
	<dt>xmlparser.cpp</dt>
	<dd>
		This file interfaces with libxml2 and provides a state machine
		for parsing recursive XML or HTML files.
	</dd>
</dl>
