/***************************************************************************
                          dlgviewbookmarks.h  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGVIEWBOOKMARKS_H
#define DLGVIEWBOOKMARKS_H

#include <QDialog>

#include "ui_dlgviewbookmarks.h"
#include "bridgecfg.h"
#include "bknode.h"

/***************************************************************************
 *                                                                         *
 *   The DlgViewBookmarks class represents the dialog box used to display  *
 *   the bookmarks tree.                                                   *
 *                                                                         *
 ***************************************************************************/

class DlgViewBookmarks : public QDialog, public Ui::DlgViewBookmarks
{
	Q_OBJECT;

public:
	DlgViewBookmarks(const BridgeCfg &cfg,
					 BkFolder *root,
					 QWidget *parent = 0);
	virtual ~DlgViewBookmarks();

public slots:
	void on_listBk_itemSelectionChanged(void);
	void on_checkIgnore_clicked(void);
	void on_buttonCopy_clicked(void);

protected:
	virtual void resizeEvent(QResizeEvent *);

private:
	void SetFolderIgnore(BkFolder &folder, bool checked);
	void fillFolder(BkFolder &parent, QTreeWidgetItem *parentItem);
	void fillList(BkFolder *root);
	void displayText(QLabel *label, const QString &text);

	const BridgeCfg &m_cfg;
};

#endif  // end of DLGVIEWBOOKMARKS_H
