/*
 * wrapper_misc.cxx
 *
 * OpenH323 Wrapper Library
 *
 * Copyright (c) 2002-2005 InAccess Networks
 * Michalis Manousos <manousos@inaccessnetworks.com>
 * Dimitris Economou <decon@inaccessnetworks.com>
 *
 * This file is part of "H.323 support for ASTERISK"
 *
 * "H.323 support for ASTERISK" is free software;
 * you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version. 
 *
 * "H.323 support for ASTERISK" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Id: wrapper_misc.cxx,v 1.1.1.1 2007/06/04 10:55:39 mmanousos Exp $
 *
 */

/************************************************************************/

#define cplusplus
#include "version.h"
#include "wrapper_misc.hxx"

using namespace std;

/************************************************************************/
/* Misc wrapper's internal variables and classes ************************/

int channelsOpen = 0;

/***********************************************************
 * Class WrapMutex
 **********************************************************/

WrapMutex::WrapMutex(char *mutex_name) :
		PMutex()
{
	name = PString(mutex_name);
	WRAPTRACE(2, "Created mutex " << name);
}

BOOL WrapMutex::Wait(const char *file, int line, const char *function, int ms)
{
	PTimeInterval timeout;

	if (ms < 0)
		timeout = PMaxTimeInterval;
	else
		timeout = PTimeInterval(ms);

	WRAPTRACE(2, "Requesting mutex " << name << 
			" [" << file << ", " << line << ", " << function << "]");
	if (PMutex::Wait(timeout) == TRUE) {
		WRAPTRACE(2, "Got mutex " << name << 
				" [" << file << ", " << line << ", " << function << "]");
		return TRUE;
	} else {
		WRAPTRACE(2, "Timeout waiting for mutex " << name << 
				" [" << file << ", " << line << ", " << function << "]");
		return FALSE;
	}
}

void WrapMutex::Signal(const char *file, int line, const char *function)
{
	PMutex::Signal();
	WRAPTRACE(2, "Released mutex " << name << 
			" [" << file << ", " << line << ", " << function << "]");
}

// End of file //////////////////////////////////////////////////////////////
