/* $Id: HFRender.cpp,v 1.2 2002/10/17 22:35:55 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef WIN32
 #include <windows.h>
#endif

#include <GL/gl.h>

#include <Ark/ArkRenderer.h>
#include <Modules/HeightField/HFWorld.h>
#include <Modules/HeightField/HFQuadtree.h>
#include <Modules/HeightField/SkyDome.h>
#include <Modules/HeightField/HFRender.h>


namespace Ark
{

    HeightFieldRender::HeightFieldRender(HeightField* hf) : 
	m_Heightfield( hf ),
	m_Depth (0), 
	m_Size (0),
	m_Points (0)
    {
    }


   void
   HeightFieldRender::SetVertex (int x, int z, Vector3& coord, Vector3& norm) const
   {
       Vector3 north, east, south, west;
       GetExtendedVector(x, z, coord);
       GetExtendedVector(x-1, z, west);
       GetExtendedVector(x, z-1, north);
       GetExtendedVector(x+1, z, east);
       GetExtendedVector(x, z+1, south);

       norm = Vector3(0,0,0)
	   + Vector3::ComputeNormal(coord, west, north)
	   + Vector3::ComputeNormal(coord, north, east)
	   + Vector3::ComputeNormal(coord, east, south)
	   + Vector3::ComputeNormal(coord, south, west);

       norm.Normalize();
   }
    void 
    HeightFieldRender::InitializeVertexBuffer()
    {
	assert( m_Heightfield && m_Size );

	m_Vertices.SetFormat(VertexBuffer::VB_HAS_COORD|VertexBuffer::VB_HAS_NORMAL|VertexBuffer::VB_HAS_COLOR);
	m_Vertices.Resize( m_Points );

	for (unsigned int i=0 ; i<m_Points ; ++i)
	{
	    const int rx = i % m_Size;
	    const int rz = i / m_Size;

	    SetVertex (rx, rz, m_Vertices.Coord(i), m_Vertices.Normal(i));

	    Material* grd = GetExtendedGround(rx, rz);
	    RGBA& rgba = m_Vertices.Color4(i);

	    if (grd)
	    {
		rgba.R = uchar (grd->m_Diffuse.R * 255.f);
		rgba.G = uchar (grd->m_Diffuse.G * 255.f);
		rgba.B = uchar (grd->m_Diffuse.B * 255.f);
		rgba.A = 255;
	    }
	    else
	    {
		rgba.R = rgba.G = rgba.B = rgba.A = 255;
	    }
	}

    }
    
   // This function is really slow, it should only be used during building the vb !
   int
    HeightFieldRender::GetExtendedHeight(int x, int z) const
    {
	const int sz = static_cast<int>( m_Heightfield->m_SizeZ );
	const int sx = static_cast<int>( m_Heightfield->m_SizeX );
	const int cz = (z < sz) ? z : sz-1;
	const int cx = (x < sx) ? x : sx-1;
	return m_Heightfield->Y(cx,cz);
    }

   // This function is really slow, it should only be used during building the vb !
   void
    HeightFieldRender::GetExtendedVector(int x, int z, Vector3& v) const
    {
       v.X = static_cast<scalar>( x ) * m_Heightfield->m_Scale;
       v.Z = static_cast<scalar>( z ) * m_Heightfield->m_Scale;
       v.Y = static_cast<scalar>( GetExtendedHeight(x, z) );
    }

   // This function is really slow, it should only be used during building the vb !
   Material*
    HeightFieldRender::GetExtendedGround(int x, int z) const
    {
	const int sz = static_cast<int>( m_Heightfield->m_SizeZ );
	const int sx = static_cast<int>( m_Heightfield->m_SizeX );
	const int cz = (z < sz) ? z : sz-1;
	const int cx = (x < sx) ? x : sx-1;
	return m_Heightfield->GetGrd(cx,cz);
    }

} // ns Ark
