/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2006 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#ifndef D_OPTION_PARSER_H
#define D_OPTION_PARSER_H

#include "common.h"

#include <string>
#include <vector>
#include <iosfwd>

#include "SharedHandle.h"

namespace aria2 {

class Option;
class OptionHandler;

class OptionParser {
private:
  int idCounter_;

  // optionHandlers_ is sorted by OptionHandler::getName() in
  // ascending order.
  std::vector<SharedHandle<OptionHandler> > optionHandlers_;

  SharedHandle<OptionHandler>
  getOptionHandlerByName(const std::string& optName);

  static SharedHandle<OptionParser> optionParser_;
public:
  OptionParser();

  ~OptionParser();

  // Parses options in argv and writes option name and value to out in
  // NAME=VALUE format. Non-option strings are stored in nonopts.
  // Throws Exception when an unrecognized option is found.
  void parseArg(std::ostream& out, std::vector<std::string>& nonopts,
                int argc, char* argv[]);

  void parse(Option& option, std::istream& ios);

  void parseDefaultValues(Option& option) const;

  void setOptionHandlers
  (const std::vector<SharedHandle<OptionHandler> >& optionHandlers);

  void addOptionHandler(const SharedHandle<OptionHandler>& optionHandler);

  // Hidden options are not returned.
  std::vector<SharedHandle<OptionHandler> >
  findByTag(const std::string& tag) const;

  // Hidden options are not returned.
  std::vector<SharedHandle<OptionHandler> >
  findByNameSubstring(const std::string& substring) const;

  // Hidden options are not returned.
  std::vector<SharedHandle<OptionHandler> > findAll() const;

  // Hidden options are not returned.
  SharedHandle<OptionHandler>
  findByName(const std::string& name) const;

  // Hidden options are not returned.
  SharedHandle<OptionHandler> findByID(int id) const;

  // Hidden options are not returned.
  SharedHandle<OptionHandler> findByShortName(char shortName) const;

  static const SharedHandle<OptionParser>& getInstance();
};

typedef SharedHandle<OptionParser> OptionParserHandle;

} // namespace aria2

#endif // D_OPTION_PARSER_H
