/*
 * Argus Software
 * Copyright (c) 2000-2008 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * $Id: //depot/argus/argus-3.0/clients/include/argus_oids.h#45 $
 * $DateTime: 2006/05/31 02:10:14 $
 * $Change: 862 $
 */

/*
 * argus_oids.h attempts to identify all communication protocol fields
 * that can be used as argus flow key identifiers.  This is important
 * for providing the major strength of aggregation.  If you aggregate
 * records based on an arbitrary set of packet identifiers, then you
 * should be able to unambiguously describe that aggregation key.
 * 
 * The strategy is that their are 2 basic protocol identifiers.  The
 * protocol itself, and then the protocol identifiers.  Ideally we
 * should be able to construct a unique protocol identifier using
 * a 16-bit protocol id and an 8-bit protocol field id.  This is
 * pretty bulky, so we'll try to find some special numbers that 
 * allow us to do the common ones with a small amount of bits, like
 * IPv4 should be able to do it pretty cheaply.
 *
 * The primary Layer 3 protocol numbers are 16-bit values derived from
 * the ethernet protocol field.  This is, of course, really bad, as
 * there just aren't that many protocols in use, so here we'll do a
 * few tricks to get a decent encoding.

enum ArgusProtocols {
   IPv4 = 1,
   IPv6 = 2,
}; 

 *
 * The major Layer 4 protocol numbers are 8-bit values, and we'll
 * use these numbers, called ARGUS_IANA_PROTO.
 *
 * This will be a work in progress, and so it will appear sparse
 * at first, but as new protocols are supported, the tables should
 * fill out.
 *
 * In this first round, we'll provide short identifiers for ethernet,
 * ARP, IPv4, IPv6, TCP, UDP, ICMP, IGMP.
 *
 */

/* IP Header Field Identifiers */

#define ARGUS_IP_SRC                            0x01    
#define ARGUS_IP_DST                            0x02
#define ARGUS_IP_PROTO                          0x04
#define ARGUS_IP_TOS                            0x08
#define ARGUS_IP_TTL                            0x10
#define ARGUS_IP_ID                             0x20


