/*
 * Argus Software
 * Copyright (c) 2000-2008 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
/*
 * $Id: //depot/argus/argus-3.0/clients/include/argus_out.h#39 $
 * $DateTime: 2006/02/23 13:18:34 $
 * $Change: 626 $
 */
 
 
#ifndef Argus_event_h
#define Argus_event_h

#include <stdio.h>
#include <argus_int.h>

#define RA_MAX_TABLE_ARRAY	512
#define RA_MAXTABLES		1
#define RA_MAXTABLES_MASK	0x00001

#define NTAIS_ETARGETS		4

#define NTAIS_DATABASE		0x01
#define NTAIS_SYSLOG		0x02
#define NTAIS_FILE		0x04
#define NTAIS_TERM		0x08


#define NTAIS_NTYPES		9
 
/* type codes */
#define NTAIS_EVENT		0x0001
#define NTAIS_CONDITION		0x0002
#define NTAIS_INTERNAL		0x0004
#define NTAIS_MONITOR		0x0008
#define NTAIS_REPORTED		0x0010
#define NTAIS_DERIVED		0x0020
#define NTAIS_OPERATIONS	0x0040
#define NTAIS_PERFORMANCE	0x0080
#define NTAIS_SECURITY		0x0100
 
#define NTAIS_NSEVERITY		9
 
/* severity codes */
#define NTAIS_EMERG		1       /* system is unusable */
#define NTAIS_ALERT		2       /* action must be taken immediately */
#define NTAIS_CRIT		3       /* critical conditions */
#define NTAIS_ERR		4       /* error conditions */
#define NTAIS_WARNING		5       /* warning conditions */
#define NTAIS_NOTICE		6       /* normal but significant condition */
#define NTAIS_INFO		7       /* informational */
#define NTAIS_DEBUG		8       /* debug-level messages */
 
#define NTAIS_NCAUSE            8
 
/* cause codes */
#define NTAIS_START		0
#define NTAIS_STATUS		1
#define NTAIS_STOP		2
#define NTAIS_TIMEOUT		3
#define NTAIS_SHUTDOWN		4
#define NTAIS_ERROR		5
#define NTAIS_OUTOFSPEC		6
#define NTAIS_INSPEC		7
 
#define NTAIS_NFACILITY		6

/* facilitity codes */
#define NTAIS_NTAIS		1
#define NTAIS_NTAISD		2
#define NTAIS_RADIUM		3
#define NTAIS_ISIS		4
#define NTAIS_RSVP		5
#define NTAIS_USER		6

 
#if defined(ARGUS_EVENT_PROC)
char *RaDataBase = "NTAIS";
unsigned int RaTableFlags = 0;

char *RaExistTableNames[RA_MAX_TABLE_ARRAY];

/*
  The NTAIS Database holds account information and entries for entire
  sets of ra data.  The schema includes an Events table which is
  designed to hold the local list of events that are generated by
  this ntais.  Aspects of this table should be available to the
  composite ntaisd federation for correlation.

  NTAIS.Events schema.

+-----------+---------------+------+-----+---------------------+----------------+
| Field     | Type          | Null | Key | Default             | Extra          |
+-----------+---------------+------+-----+---------------------+----------------+
| id        | int(11)       |      | PRI | NULL                | auto_increment |
| ntaisid   | varchar(255)  |      |     |                     |                |
| uid       | int(11)       |      |     | 0                   |                |
| project   | int(11)       |      |     | 0                   |                |
| start     | timestamp(14) | YES  |     | NULL                |                |
| end       | timestamp(14) | YES  |     | 00000000000000      |                |
| facility  | int(11)       | YES  |     | NULL                |                |
| severity  | int(8)        | YES  |     | NULL                |                |
| access    | timestamp(14) | YES  |     | 00000000000000      |                |
| timestamp | datetime      |      |     | 0000-00-00 00:00:00 |                |
| hostname  | varchar(255)  | YES  |     | NULL                |                |
| sender    | varchar(255)  | YES  |     | NULL                |                |
| instance  | varchar(255)  | YES  |     | NULL                |                |
| version   | int(2)        |      |     | 0                   |                |
| message   | text          | YES  |     | NULL                |                |
| metadata  | text          | YES  |     | NULL                |                |
| status    | int(4)        | YES  |     | NULL                |                |
| record    | blob          | YES  |     | NULL                |                |
+-----------+---------------+------+-----+---------------------+----------------+


  The events schema is primarily designed to support syslog messages, which
  are a form of event that the ntias needs to support.

  The fields are:
     id       - the internal rdbms index number for the specific Entry.
     ntaisid  - the id for the ntais that generated this event (url).
     uid      - user id that generated the event (ntais specific).
     project  - project that generated the event (project id) (0 = ntais).
     start    - Time when this event/condition started.
     end      - Time when this event/condition ended.
     access   - Time when this ntaisd received the event.

     version  - Event version number.
     type     - NTAIS event classification.
           Numerical  Class
             Code
              1       NTAIS Internal Component Event
              2       Monitored Network Entity Event
              3       Reported Network Entity State Transition
              4       Derived Network Entity State Transition

     cause    - reason event was generated.
           Numerical  Class
             Code
              1       Start    - initial report
              2       Status   - continuation record
              3       Stop     - condition close/termination indication
              4       Timeout  - timeout condition reached
              5       Shutdown - ntais component shutdown
              6       Error    - ntais error condition
              7       OutSpec  - value exceeded specification
              8       InSpe    - value within specificiation

     facility - event source classification.  this uses syslog.h for
                0-23 definitions in order to make importing syslog
                messages from routers/switches/end-systems straight
                forward.  NTAIS facility codes will be generated to
                provide greater utility.

     severity - event classification.  This number can be modified by the
                receiving ntaisd.  The complete original message is
                contained in the 'message' field, and so can be recovered.
           Numerical  Severity
             Code
              1       Emergency: system is unusable
              2       Alert: action must be taken immediately
              3       Critical: critical conditions
              4       Error: error conditions
              5       Warning: warning conditions
              6       Notice: normal but significant condition
              7       Informational: informational messages
              8       Debug: debug-level messages

    timestamp - The time reported by the generator of the event (syslog).
     hostname - Generally, this is the FQDN of the host/probe/system
                that generated the event.
       sender - This identifies the device or application that
                generated the event.
     instance - This identifies a specific instance of the sender.
                NULL value indicates an unidentified instance.

     message  - Complete event message received.
    metadata  - Complete event message received.
      status  - An internal ntais status indicator (processed/tracked/imported/learned/deleted/orphaned).
*/

char *ArgusEventTableCreationString[RA_MAXTABLES * 2] = {
   "CREATE TABLE %s (id int not null auto_increment, ntaisid varchar(255) not null, uid int(11) not null, project int(11) not null, start datetime, end datetime, type int(8), cause int(8), facility int(11), severity int(8), access timestamp(14), timestamp datetime not null, hostname varchar(255), sender varchar(255), instance varchar(255), version int(2) not null, message text, metadata text, status int (4), record blob, primary key (id)) TYPE=MyISAM",

   "CREATE TABLE %s (id int not null auto_increment, %s , ntaisid varchar(255) not null, uid int(11) not null, project int(11) not null, start datetime, end datetime, type int(8), cause int(8), facility int(11), severity int(8), access timestamp(14), timestamp datetime not null, hostname varchar(255), sender varchar(255), instance varchar(255), version int(2) not null, message text, metadata text, status int (4), record blob, primary key (id)) TYPE=MyISAM",
};


struct ArgusTokenStruct NtaisEventTargets[NTAIS_ETARGETS] = {
   { NTAIS_DATABASE,   "sql" } ,
   { NTAIS_SYSLOG,     "syslog" } ,
   { NTAIS_FILE,       "file" } ,
   { NTAIS_TERM,       "term" } ,
};

struct ArgusTokenStruct RaSQLEventTypes[NTAIS_NTYPES] = {
   { NTAIS_EVENT,       "event" } ,
   { NTAIS_CONDITION,   "condition" } ,
   { NTAIS_INTERNAL,    "internal" } ,
   { NTAIS_MONITOR,     "monitor" } ,
   { NTAIS_REPORTED,    "reported" } ,
   { NTAIS_DERIVED,     "derived" } ,
   { NTAIS_OPERATIONS,  "ops" } ,
   { NTAIS_PERFORMANCE, "perf" } ,
   { NTAIS_SECURITY,    "sec" } ,
};

struct ArgusTokenStruct RaSQLEventCause[NTAIS_NCAUSE] = {
   { NTAIS_START,     "start" } ,
   { NTAIS_STATUS,    "status" } ,
   { NTAIS_STOP,      "stop" } ,
   { NTAIS_TIMEOUT,   "timeout" } ,
   { NTAIS_SHUTDOWN,  "shutdown" } ,
   { NTAIS_ERROR,     "error" } ,
   { NTAIS_OUTOFSPEC, "outofspec" } ,
   { NTAIS_INSPEC,    "inspec" } ,
};

struct ArgusTokenStruct RaSQLEventFacilities[NTAIS_NFACILITY] = {
   { NTAIS_NTAIS,     "ntais" } ,
   { NTAIS_NTAISD,    "ntaisd" } ,
   { NTAIS_RADIUM,    "radium" } ,
   { NTAIS_RSVP,      "rsvp" } ,
   { NTAIS_ISIS,      "isis" } ,
   { NTAIS_USER,      "user" } ,
};

struct ArgusTokenStruct RaSQLEventSeverities[NTAIS_NSEVERITY] = {
   { 0,              "no" } ,
   { NTAIS_EMERG,    "emerg" } ,
   { NTAIS_ALERT,    "alert" } ,
   { NTAIS_CRIT,     "crit" } ,
   { NTAIS_ERR,      "err" } ,
   { NTAIS_WARNING,  "warn" } ,
   { NTAIS_NOTICE,   "notice" } ,
   { NTAIS_INFO,     "info" } ,
   { NTAIS_DEBUG,    "debug" } ,
};

#else

extern struct ArgusTokenStruct NtaisEventTargets[NTAIS_ETARGETS];
extern struct ArgusTokenStruct RaSQLEventTypes[NTAIS_NTYPES];
extern struct ArgusTokenStruct RaSQLEventCause[NTAIS_NCAUSE];
extern struct ArgusTokenStruct RaSQLEventFacilities[NTAIS_NFACILITY];
extern struct ArgusTokenStruct RaSQLEventSeverities[NTAIS_NSEVERITY];

#endif

struct ArgusEventStruct {
   struct ArgusQueueHeader qhdr;
   int status, target;
   int type, cause, facility, severity;
   char *accounts, *message, *metadata;
};

struct ArgusEventStruct *ArgusNewEvent(struct ArgusParserStruct *, int, int, int, int, int, char *, char *, char *);
void ArgusDeleteEvent(struct ArgusEventStruct *);
int ArgusProcessEvent (struct ArgusParserStruct *, struct ArgusEventStruct *, struct ArgusRecordStruct *);

#endif
