#!/usr/bin/perl
#	@(#) remove.pl -- Remove script for apt-cacher
#	$ Revision: $
#	$ Source: $
#	$ Date: $
#

use strict;
use warnings;

my $path = $ENV{PATH_INFO};
#############################################################################
### configuration ###########################################################
# Include the library for the config file parser
require('/usr/share/apt-cacher/apt-cacher-lib.pl');

# Read in the config file and set the necessary variables
my $configfile = '/etc/apt-cacher/apt-cacher.conf';

my $configref;
eval {
        $configref = read_config($configfile);
};
my %config = %$configref;

# not sure what to do if we can't read the config file...
die "Could not read config file: $@" if $@;

# Now set some things from the config file
# $logfile used to be set in the config file: now we derive it from $log_dir
$config{logfile} = "$config{log_dir}/access.log";

# $errorfile used to be set in the config file: now we derive it from $log_dir
$config{errorfile} = "$config{log_dir}/error.log";

my $private_dir = "$config{cache_dir}/private";

################################################

# Now set some things from the config file
$config{reportfile} = "$config{log_dir}/report.html";


# Delete the cache directory and everything in it, in the purge step
#system("rm", "-rf", $config{cache_dir});

# Delete the two log files (leaving the directory behind for now)
unlink($config{logfile});
unlink($config{errorfile});
unlink($config{reportfile});

exit(0);
