#!/usr/bin/perl

use strict;
use warnings;

use lib '/usr/src/apt-cacher/src';

require('apt-cacher-lib.pl');

my $cfg = read_config('/dev/null'); # Get defaults with no config file


print <<"EOF"
#################################################################################
# This is the config file for apt-cacher. On most Debian systems you can safely #
# leave the defaults alone.                                                     #
#                                                                               #
# Commented defaults or examples are given. They can be changed here, or        #
# overridden using a fragment placed in ./conf.d/                               #
#################################################################################

### GENERAL ###

# The location of the local cache/working directory. This can become quite
# large, so make sure it is somewhere with plenty of space.
#
#cache_dir = $cfg->{cache_dir}

# The directory to use for apt-cacher access and error logs.
# The access log records every request in the format:
#
#  date-time|PID|client ip address|HIT/HEAD/MISS/EXPIRED/NOTMOD|object size|object name
#
# The error log is slightly more free-form, and is also used for debug messages
# if debug mode is turned on.
#
#log_dir = $cfg->{log_dir}

# The email address of the administrator is displayed in the info page and
# traffic reports.
#
#admin_email = $cfg->{admin_email}

# Daemon port setting, only useful in stand-alone mode. You need to run the
# daemon as root to use privileged ports (<1024).
#
# For standalone daemon auto startup settings please edit the file
# /etc/default/apt-cacher.
#
#daemon_port = $cfg->{daemon_port}

# optional settings, user and group to run the daemon as. Make sure they have
# sufficient permissions on the cache and log directories. Comment the settings
# to run apt-cacher as the native user.
#
#group = www-data
#user = www-data

# optional setting, binds the listening daemon to specified IP(s). Use IP ranges
# for more advanced configuration, see below.
#
#daemon_addr = localhost

# Apt-cacher can be used in offline mode which just uses files already cached,
# but doesn't make any new outgoing connections by setting this to 1.
#
#offline_mode = 1

# To enable data checksumming, install libberkeleydb-perl and set this option to
# 1. Then wait until the Packages/Sources files have been refreshed once (and so
# the database has been built up). You can also nuke them in the cache to
# trigger the update.
#
#checksum = 1

# CGI mode is deprecated.
#
# Send a 410 (Gone) HTTP message with the specified text when accessed via
# CGI. Useful to tell users to adapt their sources.list files when the
# apt-cacher server is being relocated (via apt-get's error messages while
# running "update")
#
#cgi_advise_to_use = Please use http://cacheserver:3142/ as apt-cacher access URL
#cgi_advise_to_use = Server relocated. To change sources.list, run \
# perl -pe "s,/apt-cacher\??,:3142," -i /etc/apt/sources.list
#
# To further facilitate migration from CGI to daemon mode this setting will
# automatically redirect incomming CGI requests to the specified daemon URL.
#
#cgi_redirect = http://localhost:3142/

### UPSTREAM PROXY ###

# Apt-cacher can pass all its requests to an external http proxy like Squid,
# which could be very useful if you are using an ISP that blocks port 80 and
# requires all web traffic to go through its proxy. The format is
# 'hostname:port', eg: 'proxy.example.com:8080'.
#
#http_proxy=proxy.example.com:8080

# External http proxy sometimes need authentication to get full access. The
# format is 'username:password'.
#
#http_proxy_auth=proxyuser:proxypass

# Use of the configured external proxy can be turned on or off with this flag.
# Value should be either 0 (off) or 1 (on).
#
#use_proxy = $cfg->{use_proxy}

# Use of external proxy authentication can be turned on or off with this flag.
# Value should be either 0 (off) or 1 (on).
#
#use_proxy_auth = $cfg->{use_proxy_auth}

# This sets the interface to use for the upstream connection.
# Specify an interface name, an IP address or a host name.
# If unset, the default route is used.
#
#interface = eth0

# Rate limiting sets the maximum bandwidth in bytes per second to use for
# fetching packages. Syntax is fully defined in 'man wget'.  Use 'k' or 'm' to
# use kilobytes or megabytes / second: eg, 'limit=25k'.  Use 0 or a negative
# value for no rate limiting.
#
#limit = $cfg->{limit}

### ACCESS and SECURITY ###

# Server mapping - this allows to hide real server names behind virtual paths
# that appear in the access URL. The syntax is simple, the part of the beginning
# to replace, followed by a list of mirror urls, all space separated. Multiple
# profile are separated by semicolons Note that you need to specify all target
# servers in the allowed_locations options if you make use of it. Also note that
# the paths should not overlap each other.
#
# The virtual paths are also used to separate the caching of multiple
# distributions within a single apt-cacher instance if distinct_namespaces is
# also set.
#
#path_map = debian ftp.uni-kl.de/pub/linux/debian ftp2.de.debian.org/debian ; \
# ubuntu archive.ubuntu.com/ubuntu ; \
# security security.debian.org/debian-security ftp2.de.debian.org/debian-security

# If your apt-cacher machine is directly exposed to the Internet and you are
# worried about unauthorised machines fetching packages through it, you can
# specify a list of IPv4 addresses which are allowed to use it and another list
# of IPv4 addresses which aren't.
#
# Localhost (127.0.0.1) is always allowed. Other addresses must be matched by
# allowed_hosts and not by denied_hosts to be permitted to use the cache.
# Setting allowed_hosts to "*" means "allow all" (which was the default before
# 1.7.0).
#
# Otherwise the format is a comma-separated list containing addresses,
# optionally with masks (like 10.0.0.0/22), or ranges of addresses (two
# addresses separated by a hyphen, no masks, like '192.168.0.3-192.168.0.56').
#
#allowed_hosts = *
#denied_hosts = $cfg->{denied_hosts}

# And similarly for IPv6 with allowed_hosts_6 and denied_hosts_6.  Note that
# IPv4-mapped IPv6 addresses (::ffff:w.x.y.z) are truncated to w.x.y.z and are
# handled as IPv4.
#
#allowed_hosts_6 = *
#denied_hosts_6 = $cfg->{denied_hosts_6}

# Only allow HTTPS/SSL proxy CONNECT to hosts or IPs which match an item in this
# list.
#
#allowed_ssl_locations =

# Only allow HTTPS/SSL proxy CONNECT to ports which match an item in this list.
# Adding further items to this can pose a significant security risk.  DO NOT do
# it unless you understand the full implications.
#
#allowed_ssl_ports = $cfg->{allowed_ssl_ports}

# Optional setting to limit access to Debian mirrors based on server names in
# the URLs. This is matched before any path_map settings are honoured.
#
#allowed_locations = ftp.uni-kl.de,ftp.nerim.net,debian.tu-bs.de

### HOUSEKEEPING ###

# Apt-cacher can generate usage reports every 24 hours if you set this directive
# to 1. You can view the reports in a web browser by pointing to your cache
# machine with 'report' on the end, like this:
#
#      http://yourcache.example.com:3142/report
#
# Generating reports is very fast even with many thousands of logfile lines, so
# you can safely turn this on without creating much additional system load.
#
#generate_reports = $cfg->{generate_reports}

# Apt-cacher can clean up its cache directory every 24 hours if you set this
# directive to 1. Cleaning the cache can take some time to run (generally in the
# order of a few minutes) and removes all package files that are not mentioned
# in any existing 'Packages' lists. This has the effect of deleting packages
# that have been superseded by an updated 'Packages' list.
#
#clean_cache = $cfg->{clean_cache}

### INTERNALS ###

# Debug mode makes apt-cacher spew a lot of extra debug junk to the error log
# (whose location is defined with the 'log_dir' directive).  Leave this off
# unless you need it, or your error log will get very big. Acceptable values are
# 0 or and integer up to 7. See man apt-cacher (1) for further details.
#
#debug = $cfg->{debug}

# You shouldn't need to change anything below here. If you do, ensure you
# understand the full implications of doing so.

# Permitted package files - this is a perl regular expression which matches all
# package-type files (files that are uniquely identified by their filename).
#
#package_files_regexp = $cfg->{package_files_regexp}

# Permitted Index files - this is the perl regular expression which matches all
# index-type files (files that are uniquely identified by their full path and
# need to be checked for freshness).
#
#index_files_regexp = $cfg->{index_files_regexp}

# Permitted installer files -- this is the perl regular expression which matches
# all installer-type files (files that are uniquely identified by their full
# path but don’t need to be checked for freshness). These are typically files
# used by Debian Installer, Debian Live and apt.
#
#installer_files_regexp = $cfg->{installer_files_regexp}

# Perl regular expression which matches Index files from which to read checksums
# if checksum is enabled.
#
#checksum_files_regexp = $cfg->{checksum_files_regexp}

# Perl regular expression which matches URLs to be permitted for Debian bugs
# SOAP requests as made by apt-listbugs(1).
#
#soap_url_regexp = $cfg->{soap_url_regexp}
EOF
